/* tracker-builder.c generated by valac 0.56.1, the Vala compiler
 * generated from tracker-builder.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/**
 * SECTION: tracker-sparql-builder
 * @short_description: Creating insertion/update SPARQL queries.
 * @title: TrackerSparqlBuilder
 * @stability: Stable
 * @include: tracker-sparql.h
 *
 * <note>
 * This object is deprecated since 2.0, use #TrackerResource to build
 * SPARQL updates.
 * </note>
 *
 * <para>
 * #TrackerSparqlBuilder is an object what will gather a set of
 * subject/predicate/object triples, together with an optional WHERE clause,
 * in order to create a query that may be issued to tracker-store.
 * </para>
 *
 * <para>
 * When using #TrackerSparqlBuilder, note that you may append several predicates
 * for the same subject, and several objects for the same predicate.
 * </para>
 */
/**
 * TrackerSparqlBuilder:
 *
 * The <structname>TrackerSparqlBuilder</structname> object represents an
 * insertion/update SPARQL query.
 */
/**
 * tracker_sparql_builder_get_result:
 * @self: a #TrackerSparqlBuilder
 *
 * Retrieves a string representation of the constructed SPARQL query.
 *
 * Returns: the created SPARQL query. The string is contained in the
 * #TrackerSparqlBuilder object, and should not be freed by the caller.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_builder_get_length:
 * @self: a #TrackerSparqlBuilder
 *
 * Returns the number of objects added to @self.
 *
 * Returns: the number of objects contained.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_builder_get_state:
 * @self: a #TrackerSparqlBuilder
 *
 * Returns the current state of @self
 *
 * Returns: a #TrackerSparqlBuilderState defining the current state of @self
 *
 * Since: 0.10
 */

#define _XOPEN_SOURCE

#include "libtracker-sparql/tracker-generated-no-checks.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>
#include <math.h>

enum  {
	TRACKER_SPARQL_BUILDER_0_PROPERTY,
	TRACKER_SPARQL_BUILDER_RESULT_PROPERTY,
	TRACKER_SPARQL_BUILDER_LENGTH_PROPERTY,
	TRACKER_SPARQL_BUILDER_STATE_PROPERTY,
	TRACKER_SPARQL_BUILDER_NUM_PROPERTIES
};
static GParamSpec* tracker_sparql_builder_properties[TRACKER_SPARQL_BUILDER_NUM_PROPERTIES];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TrackerSparqlBuilderPrivate {
	gint _length;
	TrackerSparqlBuilderState* states;
	gint states_length1;
	gint _states_size_;
	GString* str;
};

static gint TrackerSparqlBuilder_private_offset;
static gpointer tracker_sparql_builder_parent_class = NULL;

static void _vala_array_add1 (TrackerSparqlBuilderState* * array,
                       gint* length,
                       gint* size,
                       TrackerSparqlBuilderState value);
static void _vala_array_add2 (TrackerSparqlBuilderState* * array,
                       gint* length,
                       gint* size,
                       TrackerSparqlBuilderState value);
static void _vala_array_add3 (TrackerSparqlBuilderState* * array,
                       gint* length,
                       gint* size,
                       TrackerSparqlBuilderState value);
static void _vala_array_add4 (TrackerSparqlBuilderState* * array,
                       gint* length,
                       gint* size,
                       TrackerSparqlBuilderState value);
static void _vala_array_add5 (TrackerSparqlBuilderState* * array,
                       gint* length,
                       gint* size,
                       TrackerSparqlBuilderState value);
static void _vala_array_add6 (TrackerSparqlBuilderState* * array,
                       gint* length,
                       gint* size,
                       TrackerSparqlBuilderState value);
static void _vala_array_add7 (TrackerSparqlBuilderState* * array,
                       gint* length,
                       gint* size,
                       TrackerSparqlBuilderState value);
static void _vala_array_add8 (TrackerSparqlBuilderState* * array,
                       gint* length,
                       gint* size,
                       TrackerSparqlBuilderState value);
static void _vala_array_add9 (TrackerSparqlBuilderState* * array,
                       gint* length,
                       gint* size,
                       TrackerSparqlBuilderState value);
static void _vala_array_add10 (TrackerSparqlBuilderState* * array,
                        gint* length,
                        gint* size,
                        TrackerSparqlBuilderState value);
static void _vala_array_add11 (TrackerSparqlBuilderState* * array,
                        gint* length,
                        gint* size,
                        TrackerSparqlBuilderState value);
static void _vala_array_add12 (TrackerSparqlBuilderState* * array,
                        gint* length,
                        gint* size,
                        TrackerSparqlBuilderState value);
static void tracker_sparql_builder_set_length (TrackerSparqlBuilder* self,
                                        gint value);
static void _vala_array_add13 (TrackerSparqlBuilderState* * array,
                        gint* length,
                        gint* size,
                        TrackerSparqlBuilderState value);
static void _vala_array_add14 (TrackerSparqlBuilderState* * array,
                        gint* length,
                        gint* size,
                        TrackerSparqlBuilderState value);
static void _vala_array_add15 (TrackerSparqlBuilderState* * array,
                        gint* length,
                        gint* size,
                        TrackerSparqlBuilderState value);
static void tracker_sparql_builder_finalize (GObject * obj);
static GType tracker_sparql_builder_get_type_once (void);
static void _vala_tracker_sparql_builder_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_tracker_sparql_builder_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
tracker_sparql_builder_get_instance_private (TrackerSparqlBuilder* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerSparqlBuilder_private_offset);
}

/**
 * TrackerSparqlBuilderState:
 * @TRACKER_SPARQL_BUILDER_STATE_UPDATE: Builder is generating an UPDATE
 * @TRACKER_SPARQL_BUILDER_STATE_INSERT: Builder is generating an INSERT
 * @TRACKER_SPARQL_BUILDER_STATE_DELETE: Builder is generating a DELETE
 * @TRACKER_SPARQL_BUILDER_STATE_SUBJECT: Builder is generating the subject of the query
 * @TRACKER_SPARQL_BUILDER_STATE_PREDICATE: Builder is generating the predicate of the query
 * @TRACKER_SPARQL_BUILDER_STATE_OBJECT: Builder is generating the object of the query
 * @TRACKER_SPARQL_BUILDER_STATE_BLANK: Builder is generating a blank node subject
 * @TRACKER_SPARQL_BUILDER_STATE_WHERE: Builder is generating the WHERE clause contents
 * @TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT: Builder is generating an embedded INSERT
 * @TRACKER_SPARQL_BUILDER_STATE_GRAPH: Builder is generating the GRAPH clause contents
 *
 * Enumeration with the possible states of the SPARQL Builder
 */
static GType
tracker_sparql_builder_state_get_type_once (void)
{
	static const GEnumValue values[] = {{TRACKER_SPARQL_BUILDER_STATE_UPDATE, "TRACKER_SPARQL_BUILDER_STATE_UPDATE", "update"}, {TRACKER_SPARQL_BUILDER_STATE_INSERT, "TRACKER_SPARQL_BUILDER_STATE_INSERT", "insert"}, {TRACKER_SPARQL_BUILDER_STATE_DELETE, "TRACKER_SPARQL_BUILDER_STATE_DELETE", "delete"}, {TRACKER_SPARQL_BUILDER_STATE_SUBJECT, "TRACKER_SPARQL_BUILDER_STATE_SUBJECT", "subject"}, {TRACKER_SPARQL_BUILDER_STATE_PREDICATE, "TRACKER_SPARQL_BUILDER_STATE_PREDICATE", "predicate"}, {TRACKER_SPARQL_BUILDER_STATE_OBJECT, "TRACKER_SPARQL_BUILDER_STATE_OBJECT", "object"}, {TRACKER_SPARQL_BUILDER_STATE_BLANK, "TRACKER_SPARQL_BUILDER_STATE_BLANK", "blank"}, {TRACKER_SPARQL_BUILDER_STATE_WHERE, "TRACKER_SPARQL_BUILDER_STATE_WHERE", "where"}, {TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT, "TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT", "embedded-insert"}, {TRACKER_SPARQL_BUILDER_STATE_GRAPH, "TRACKER_SPARQL_BUILDER_STATE_GRAPH", "graph"}, {0, NULL, NULL}};
	GType tracker_sparql_builder_state_type_id;
	tracker_sparql_builder_state_type_id = g_enum_register_static ("TrackerSparqlBuilderState", values);
	return tracker_sparql_builder_state_type_id;
}

GType
tracker_sparql_builder_state_get_type (void)
{
	static volatile gsize tracker_sparql_builder_state_type_id__once = 0;
	if (g_once_init_enter (&tracker_sparql_builder_state_type_id__once)) {
		GType tracker_sparql_builder_state_type_id;
		tracker_sparql_builder_state_type_id = tracker_sparql_builder_state_get_type_once ();
		g_once_init_leave (&tracker_sparql_builder_state_type_id__once, tracker_sparql_builder_state_type_id);
	}
	return tracker_sparql_builder_state_type_id__once;
}

/**
 * tracker_sparql_builder_new_update:
 *
 * Creates an empty #TrackerSparqlBuilder for an update query.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
static void
_vala_array_add1 (TrackerSparqlBuilderState* * array,
                  gint* length,
                  gint* size,
                  TrackerSparqlBuilderState value)
{
#line 178 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 178 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 178 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 257 "tracker-builder.c"
	}
#line 178 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 261 "tracker-builder.c"
}

TrackerSparqlBuilder*
tracker_sparql_builder_construct_update (GType object_type)
{
	TrackerSparqlBuilder * self = NULL;
#line 177 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
#line 178 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add1 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_UPDATE);
#line 177 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	return self;
#line 274 "tracker-builder.c"
}

TrackerSparqlBuilder*
tracker_sparql_builder_new_update (void)
{
#line 177 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	return tracker_sparql_builder_construct_update (TRACKER_SPARQL_TYPE_BUILDER);
#line 282 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_new_embedded_insert:
 *
 * Creates a #TrackerSparqlBuilder ready to be embedded in another query. In embedded
 * inserts, the subject is implied (responsibility of the embedder), so only calls to
 * append predicates and objects for the given subject are allowed.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
static void
_vala_array_add2 (TrackerSparqlBuilderState* * array,
                  gint* length,
                  gint* size,
                  TrackerSparqlBuilderState value)
{
#line 193 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 193 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 193 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 308 "tracker-builder.c"
	}
#line 193 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 312 "tracker-builder.c"
}

static void
_vala_array_add3 (TrackerSparqlBuilderState* * array,
                  gint* length,
                  gint* size,
                  TrackerSparqlBuilderState value)
{
#line 194 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 194 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 194 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 327 "tracker-builder.c"
	}
#line 194 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 331 "tracker-builder.c"
}

static void
_vala_array_add4 (TrackerSparqlBuilderState* * array,
                  gint* length,
                  gint* size,
                  TrackerSparqlBuilderState value)
{
#line 195 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 195 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 195 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 346 "tracker-builder.c"
	}
#line 195 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 350 "tracker-builder.c"
}

TrackerSparqlBuilder*
tracker_sparql_builder_construct_embedded_insert (GType object_type)
{
	TrackerSparqlBuilder * self = NULL;
#line 192 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
#line 193 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add2 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT);
#line 194 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add3 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
#line 195 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add4 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_SUBJECT);
#line 192 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	return self;
#line 367 "tracker-builder.c"
}

TrackerSparqlBuilder*
tracker_sparql_builder_new_embedded_insert (void)
{
#line 192 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	return tracker_sparql_builder_construct_embedded_insert (TRACKER_SPARQL_TYPE_BUILDER);
#line 375 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_insert_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens an insertion statement.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void
_vala_array_add5 (TrackerSparqlBuilderState* * array,
                  gint* length,
                  gint* size,
                  TrackerSparqlBuilderState value)
{
#line 212 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 212 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 212 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 400 "tracker-builder.c"
	}
#line 212 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 404 "tracker-builder.c"
}

void
tracker_sparql_builder_insert_open (TrackerSparqlBuilder* self,
                                    const gchar* graph)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
#line 209 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 209 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 209 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 209 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE, "state == State.UPDATE");
#line 212 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add5 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
#line 213 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (graph != NULL) {
#line 425 "tracker-builder.c"
		GString* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 214 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp2_ = self->priv->str;
#line 214 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3_ = g_strdup_printf ("INSERT INTO <%s> {\n", graph);
#line 214 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = _tmp3_;
#line 214 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp2_, _tmp4_);
#line 214 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_g_free0 (_tmp4_);
#line 439 "tracker-builder.c"
	} else {
		GString* _tmp5_;
#line 216 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp5_ = self->priv->str;
#line 216 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp5_, "INSERT {\n");
#line 446 "tracker-builder.c"
	}
}

/**
 * tracker_sparql_builder_insert_silent_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens a silent insertion statement.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void
_vala_array_add6 (TrackerSparqlBuilderState* * array,
                  gint* length,
                  gint* size,
                  TrackerSparqlBuilderState value)
{
#line 233 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 233 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 233 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 472 "tracker-builder.c"
	}
#line 233 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 476 "tracker-builder.c"
}

void
tracker_sparql_builder_insert_silent_open (TrackerSparqlBuilder* self,
                                           const gchar* graph)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
#line 230 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 230 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 230 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 230 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE, "state == State.UPDATE");
#line 233 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add6 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_INSERT);
#line 234 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (graph != NULL) {
#line 497 "tracker-builder.c"
		GString* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 235 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp2_ = self->priv->str;
#line 235 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3_ = g_strdup_printf ("INSERT SILENT INTO <%s> {\n", graph);
#line 235 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = _tmp3_;
#line 235 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp2_, _tmp4_);
#line 235 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_g_free0 (_tmp4_);
#line 511 "tracker-builder.c"
	} else {
		GString* _tmp5_;
#line 237 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp5_ = self->priv->str;
#line 237 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp5_, "INSERT SILENT {\n");
#line 518 "tracker-builder.c"
	}
}

/**
 * tracker_sparql_builder_insert_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes an insertion statement opened with tracker_sparql_builder_insert_open().
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_insert_close (TrackerSparqlBuilder* self)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	gint _tmp7_;
	TrackerSparqlBuilderState _tmp8_;
	TrackerSparqlBuilderState _tmp9_;
#line 250 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 250 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 250 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 250 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 250 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 250 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.INSERT || state == State.OBJECT");
#line 253 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 253 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 253 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 561 "tracker-builder.c"
		GString* _tmp6_;
#line 254 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 254 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 255 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 569 "tracker-builder.c"
	}
#line 257 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = self->priv->states_length1;
#line 257 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp7_ - 1;
#line 259 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = tracker_sparql_builder_get_state (self);
#line 259 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = _tmp8_;
#line 259 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp9_ != TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT) {
#line 581 "tracker-builder.c"
		GString* _tmp10_;
#line 260 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp10_ = self->priv->str;
#line 260 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp10_, "}\n");
#line 587 "tracker-builder.c"
	}
}

/**
 * tracker_sparql_builder_delete_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name, or %NULL.
 *
 * Opens a DELETE clause. Data triples may be appended in order to prepare
 * a query to delete them.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void
_vala_array_add7 (TrackerSparqlBuilderState* * array,
                  gint* length,
                  gint* size,
                  TrackerSparqlBuilderState value)
{
#line 279 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 279 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 279 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 614 "tracker-builder.c"
	}
#line 279 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 618 "tracker-builder.c"
}

void
tracker_sparql_builder_delete_open (TrackerSparqlBuilder* self,
                                    const gchar* graph)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
#line 276 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 276 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 276 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 276 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE, "state == State.UPDATE");
#line 279 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add7 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_DELETE);
#line 280 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (graph != NULL) {
#line 639 "tracker-builder.c"
		GString* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 281 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp2_ = self->priv->str;
#line 281 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3_ = g_strdup_printf ("DELETE FROM <%s> {\n", graph);
#line 281 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = _tmp3_;
#line 281 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp2_, _tmp4_);
#line 281 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_g_free0 (_tmp4_);
#line 653 "tracker-builder.c"
	} else {
		GString* _tmp5_;
#line 283 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp5_ = self->priv->str;
#line 283 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp5_, "DELETE {\n");
#line 660 "tracker-builder.c"
	}
}

/**
 * tracker_sparql_builder_delete_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a DELETE clause opened through tracker_sparql_builder_delete_open().
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_delete_close (TrackerSparqlBuilder* self)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	gint _tmp7_;
	GString* _tmp8_;
#line 296 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 296 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 296 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 296 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 296 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 296 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_DELETE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.DELETE || state == State.OBJECT");
#line 299 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 299 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 299 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 702 "tracker-builder.c"
		GString* _tmp6_;
#line 300 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 300 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 301 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 710 "tracker-builder.c"
	}
#line 303 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = self->priv->states_length1;
#line 303 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp7_ - 1;
#line 305 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 305 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp8_, "}\n");
#line 720 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_graph_open:
 * @self: a #TrackerSparqlBuilder
 * @graph: graph name.
 *
 * Opens a GRAPH clause within INSERT, DELETE, or WHERE.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void
_vala_array_add8 (TrackerSparqlBuilderState* * array,
                  gint* length,
                  gint* size,
                  TrackerSparqlBuilderState value)
{
#line 322 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 322 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 322 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 745 "tracker-builder.c"
	}
#line 322 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 749 "tracker-builder.c"
}

void
tracker_sparql_builder_graph_open (TrackerSparqlBuilder* self,
                                   const gchar* graph)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	TrackerSparqlBuilderState _tmp6_;
	TrackerSparqlBuilderState _tmp7_;
	TrackerSparqlBuilderState _tmp8_;
	TrackerSparqlBuilderState _tmp9_;
	GString* _tmp10_;
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (graph != NULL);
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tracker_sparql_builder_get_state (self);
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_;
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = tracker_sparql_builder_get_state (self);
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = _tmp8_;
#line 319 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (((((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_DELETE)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp7_ == TRACKER_SPARQL_BUILDER_STATE_WHERE)) || (_tmp9_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH), "state == State.INSERT || state == State.DELETE || state == State.OBJECT || state == State.WHERE || state == State.GRAPH");
#line 322 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add8 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_GRAPH);
#line 323 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = self->priv->str;
#line 323 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append_printf (_tmp10_, "GRAPH <%s> {\n", graph);
#line 799 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_graph_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a GRAPH clause opened through tracker_sparql_builder_graph_open().
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_graph_close (TrackerSparqlBuilder* self)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	gint _tmp7_;
	GString* _tmp8_;
#line 336 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 336 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 336 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 336 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 336 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 336 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.GRAPH || state == State.OBJECT");
#line 339 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 339 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 339 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 840 "tracker-builder.c"
		GString* _tmp6_;
#line 340 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 340 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 341 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 848 "tracker-builder.c"
	}
#line 343 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = self->priv->states_length1;
#line 343 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp7_ - 1;
#line 345 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 345 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp8_, "}\n");
#line 858 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_where_open:
 * @self: a #TrackerSparqlBuilder
 *
 * Opens a WHERE clause. Data triples may be appended then to narrow the scope
 * to which the update query applies.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void
_vala_array_add9 (TrackerSparqlBuilderState* * array,
                  gint* length,
                  gint* size,
                  TrackerSparqlBuilderState value)
{
#line 362 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 362 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 362 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 883 "tracker-builder.c"
	}
#line 362 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 887 "tracker-builder.c"
}

void
tracker_sparql_builder_where_open (TrackerSparqlBuilder* self)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	GString* _tmp2_;
#line 359 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 359 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 359 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 359 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_UPDATE, "state == State.UPDATE");
#line 362 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add9 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_WHERE);
#line 363 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->str;
#line 363 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp2_, "WHERE {\n");
#line 910 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_where_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes a WHERE clause opened through tracker_sparql_builder_where_open().
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_where_close (TrackerSparqlBuilder* self)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	gint _tmp7_;
	GString* _tmp8_;
#line 376 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 376 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 376 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 376 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 376 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 376 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_WHERE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.WHERE || state == State.OBJECT");
#line 379 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 379 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 379 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 951 "tracker-builder.c"
		GString* _tmp6_;
#line 380 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 380 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " .\n");
#line 381 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 959 "tracker-builder.c"
	}
#line 383 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = self->priv->states_length1;
#line 383 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = _tmp7_ - 1;
#line 384 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 384 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp8_, "}\n");
#line 969 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_subject_variable:
 * @self: a #TrackerSparqlBuilder
 * @var_name: variable name, without leading '?'
 *
 * Appends a subject as a SPARQL variable, such as "?urn".
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_subject_variable (TrackerSparqlBuilder* self,
                                         const gchar* var_name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 398 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 398 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (var_name != NULL);
#line 399 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = g_strdup_printf ("?%s", var_name);
#line 399 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 399 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_subject (self, _tmp1_);
#line 399 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp1_);
#line 1000 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_object_variable:
 * @self: a #TrackerSparqlBuilder
 * @var_name: variable name, without leading '?'
 *
 * Appends an object as a SparQL variable, such as "?urn".
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_object_variable (TrackerSparqlBuilder* self,
                                        const gchar* var_name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 413 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 413 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (var_name != NULL);
#line 414 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = g_strdup_printf ("?%s", var_name);
#line 414 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 414 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp1_);
#line 414 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp1_);
#line 1031 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_subject_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends a subject as an IRI, such as "&lt;urn:file:1234-5678&gt;". IRIs
 * univocally identify a resource in tracker-store.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_subject_iri (TrackerSparqlBuilder* self,
                                    const gchar* iri)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 429 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 429 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 430 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = g_strdup_printf ("<%s>", iri);
#line 430 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 430 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_subject (self, _tmp1_);
#line 430 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp1_);
#line 1063 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_subject:
 * @self: a #TrackerSparqlBuilder
 * @s: subject string
 *
 * Appends a subject.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void
_vala_array_add10 (TrackerSparqlBuilderState* * array,
                   gint* length,
                   gint* size,
                   TrackerSparqlBuilderState value)
{
#line 452 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 452 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 452 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1088 "tracker-builder.c"
	}
#line 452 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1092 "tracker-builder.c"
}

void
tracker_sparql_builder_subject (TrackerSparqlBuilder* self,
                                const gchar* s)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	TrackerSparqlBuilderState _tmp6_;
	TrackerSparqlBuilderState _tmp7_;
	TrackerSparqlBuilderState _tmp8_;
	TrackerSparqlBuilderState _tmp9_;
	TrackerSparqlBuilderState _tmp10_;
	TrackerSparqlBuilderState _tmp11_;
	TrackerSparqlBuilderState _tmp12_;
	TrackerSparqlBuilderState _tmp13_;
	GString* _tmp15_;
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (s != NULL);
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tracker_sparql_builder_get_state (self);
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_;
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = tracker_sparql_builder_get_state (self);
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = _tmp8_;
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = tracker_sparql_builder_get_state (self);
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = _tmp10_;
#line 444 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((((((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_INSERT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT)) || (_tmp7_ == TRACKER_SPARQL_BUILDER_STATE_DELETE)) || (_tmp9_ == TRACKER_SPARQL_BUILDER_STATE_WHERE)) || (_tmp11_ == TRACKER_SPARQL_BUILDER_STATE_GRAPH), "state == State.INSERT || state == State.OBJECT || state == State.EMBEDDED_INSERT || state == State.DELETE || state == State.WHERE || state == State.GRAPH");
#line 447 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp12_ = tracker_sparql_builder_get_state (self);
#line 447 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp13_ = _tmp12_;
#line 447 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp13_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1150 "tracker-builder.c"
		GString* _tmp14_;
#line 448 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp14_ = self->priv->str;
#line 448 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp14_, " .\n");
#line 449 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 1158 "tracker-builder.c"
	}
#line 451 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp15_ = self->priv->str;
#line 451 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp15_, s);
#line 452 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add10 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_SUBJECT);
#line 1166 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_predicate_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends a predicate as an IRI.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_predicate_iri (TrackerSparqlBuilder* self,
                                      const gchar* iri)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 466 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 466 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 467 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = g_strdup_printf ("<%s>", iri);
#line 467 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 467 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_predicate (self, _tmp1_);
#line 467 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp1_);
#line 1197 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_predicate:
 * @self: a #TrackerSparqlBuilder
 * @s: predicate string
 *
 * Appends a predicate for the previously appended subject.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void
_vala_array_add11 (TrackerSparqlBuilderState* * array,
                   gint* length,
                   gint* size,
                   TrackerSparqlBuilderState value)
{
#line 490 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 490 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 490 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1222 "tracker-builder.c"
	}
#line 490 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1226 "tracker-builder.c"
}

void
tracker_sparql_builder_predicate (TrackerSparqlBuilder* self,
                                  const gchar* s)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	TrackerSparqlBuilderState _tmp6_;
	TrackerSparqlBuilderState _tmp7_;
	GString* _tmp9_;
	GString* _tmp10_;
#line 481 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 481 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (s != NULL);
#line 481 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 481 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 481 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 481 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 481 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 481 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 481 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail (((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_SUBJECT) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT)) || (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_BLANK), "state == State.SUBJECT || state == State.OBJECT || state == State.BLANK");
#line 484 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tracker_sparql_builder_get_state (self);
#line 484 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_;
#line 484 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp7_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1267 "tracker-builder.c"
		GString* _tmp8_;
#line 485 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp8_ = self->priv->str;
#line 485 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp8_, " ;\n\t");
#line 486 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 2;
#line 1275 "tracker-builder.c"
	}
#line 488 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 488 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, " ");
#line 489 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = self->priv->str;
#line 489 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp10_, s);
#line 490 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add11 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_PREDICATE);
#line 1287 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_object_iri:
 * @self: a #TrackerSparqlBuilder
 * @iri: IRI name, without leading and trailing greater/less than symbols.
 *
 * Appends an object as an IRI.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_object_iri (TrackerSparqlBuilder* self,
                                   const gchar* iri)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 504 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 504 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (iri != NULL);
#line 505 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = g_strdup_printf ("<%s>", iri);
#line 505 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 505 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp1_);
#line 505 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp1_);
#line 1318 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_object:
 * @self: a #TrackerSparqlBuilder
 * @s: object string
 *
 * Appends a free-form object for the previously appended subject and predicate.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void
_vala_array_add12 (TrackerSparqlBuilderState* * array,
                   gint* length,
                   gint* size,
                   TrackerSparqlBuilderState value)
{
#line 528 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 528 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 528 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1343 "tracker-builder.c"
	}
#line 528 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1347 "tracker-builder.c"
}

void
tracker_sparql_builder_object (TrackerSparqlBuilder* self,
                               const gchar* s)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	GString* _tmp8_;
	GString* _tmp9_;
	gint _tmp10_;
#line 519 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 519 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (s != NULL);
#line 519 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 519 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 519 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 519 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 519 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.PREDICATE || state == State.OBJECT");
#line 522 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 522 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 522 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1383 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 523 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 523 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " ,");
#line 524 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 524 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = _tmp7_ - 1;
#line 1394 "tracker-builder.c"
	}
#line 526 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 526 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp8_, " ");
#line 527 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = self->priv->str;
#line 527 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp9_, s);
#line 528 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add12 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
#line 530 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = self->priv->_length;
#line 530 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp10_ + 1);
#line 1410 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_object_string:
 * @self: a #TrackerSparqlBuilder
 * @literal: string object
 *
 * Appends an object formatted as an string. @literal will be escaped and surrounded
 * by double quotes.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void
_vala_array_add13 (TrackerSparqlBuilderState* * array,
                   gint* length,
                   gint* size,
                   TrackerSparqlBuilderState value)
{
#line 554 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 554 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 554 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1436 "tracker-builder.c"
	}
#line 554 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1440 "tracker-builder.c"
}

void
tracker_sparql_builder_object_string (TrackerSparqlBuilder* self,
                                      const gchar* literal)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	GString* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gint _tmp11_;
#line 545 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 545 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (literal != NULL);
#line 545 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 545 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 545 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 545 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 545 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.PREDICATE || state == State.OBJECT");
#line 548 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 548 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 548 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1477 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 549 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 549 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " ,");
#line 550 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 550 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = _tmp7_ - 1;
#line 1488 "tracker-builder.c"
	}
#line 553 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 553 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp9_ = tracker_sparql_escape_string (literal);
#line 553 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp10_ = _tmp9_;
#line 553 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append_printf (_tmp8_, " \"%s\"", _tmp10_);
#line 553 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp10_);
#line 554 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add13 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
#line 556 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp11_ = self->priv->_length;
#line 556 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp11_ + 1);
#line 1506 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_object_unvalidated:
 * @self: a #TrackerSparqlBuilder
 * @value: possibly UTF-8 invalid string.
 *
 * Appends a string not validated as UTF-8 as an object.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 1539 "tracker-builder.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 1548 "tracker-builder.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1567 "tracker-builder.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1571 "tracker-builder.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1577 "tracker-builder.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1587 "tracker-builder.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1595 "tracker-builder.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1599 "tracker-builder.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 1605 "tracker-builder.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 1615 "tracker-builder.c"
}

void
tracker_sparql_builder_object_unvalidated (TrackerSparqlBuilder* self,
                                           const gchar* value)
{
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
#line 570 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 570 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (value != NULL);
#line 573 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_utf8_validate (value, (gssize) -1, &_tmp0_);
#line 573 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	end = _tmp0_;
#line 573 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (!_tmp1_) {
#line 1635 "tracker-builder.c"
		gchar* _tmp2_;
#line 574 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp2_ = end;
#line 574 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		if (value != _tmp2_) {
#line 1641 "tracker-builder.c"
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
#line 575 "../tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp3_ = end;
#line 575 "../tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp4_ = string_substring (value, (glong) 0, (glong) (_tmp3_ - ((gchar*) value)));
#line 575 "../tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp5_ = _tmp4_;
#line 575 "../tracker/src/libtracker-sparql/tracker-builder.vala"
			tracker_sparql_builder_object_string (self, _tmp5_);
#line 575 "../tracker/src/libtracker-sparql/tracker-builder.vala"
			_g_free0 (_tmp5_);
#line 1655 "tracker-builder.c"
		} else {
#line 577 "../tracker/src/libtracker-sparql/tracker-builder.vala"
			tracker_sparql_builder_object_string (self, "(invalid data)");
#line 1659 "tracker-builder.c"
		}
#line 580 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		return;
#line 1663 "tracker-builder.c"
	}
#line 583 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object_string (self, value);
#line 1667 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_object_boolean:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gboolean
 *
 * Appends a #gboolean value as an object.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_object_boolean (TrackerSparqlBuilder* self,
                                       gboolean literal)
{
	const gchar* _tmp0_ = NULL;
#line 597 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 598 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (literal) {
#line 598 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = "true";
#line 1691 "tracker-builder.c"
	} else {
#line 598 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = "false";
#line 1695 "tracker-builder.c"
	}
#line 598 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp0_);
#line 1699 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_object_int64:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gint64
 *
 * Appends a #gint64 value as an object.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_object_int64 (TrackerSparqlBuilder* self,
                                     gint64 literal)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 612 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 613 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, literal);
#line 613 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 613 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp1_);
#line 613 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp1_);
#line 1728 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_object_date:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #time_t
 *
 * Appends a #time_t value as an object. @literal will be converted
 * to a string in the date format used by tracker-store.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void
g_time_gm (time_t time,
           struct tm* result)
{
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 3214 "glib-2.0.vapi"
	gmtime_r (&time, &_tmp0_);
#line 3214 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 3215 "glib-2.0.vapi"
	*result = _result_;
#line 3215 "glib-2.0.vapi"
	return;
#line 1756 "tracker-builder.c"
}

void
tracker_sparql_builder_object_date (TrackerSparqlBuilder* self,
                                    time_t* literal)
{
	struct tm tm = {0};
	struct tm _tmp0_ = {0};
	struct tm _tmp1_;
	struct tm _tmp2_;
	struct tm _tmp3_;
	struct tm _tmp4_;
	struct tm _tmp5_;
	struct tm _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
#line 628 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 629 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_time_gm (*literal, &_tmp0_);
#line 629 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tm = _tmp0_;
#line 631 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = tm;
#line 631 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tm;
#line 631 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = tm;
#line 631 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tm;
#line 631 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = tm;
#line 631 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = tm;
#line 631 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = g_strdup_printf ("%04d-%02d-%02dT%02d:%02d:%02dZ", _tmp1_.tm_year + 1900, _tmp2_.tm_mon + 1, _tmp3_.tm_mday, _tmp4_.tm_hour, _tmp5_.tm_min, _tmp6_.tm_sec);
#line 631 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = _tmp7_;
#line 631 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object_string (self, _tmp8_);
#line 631 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp8_);
#line 1799 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_object_double:
 * @self: a #TrackerSparqlBuilder
 * @literal: object as a #gdouble
 *
 * Appends a #gdouble value as an object.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
#line 989 "glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 989 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 989 "glib-2.0.vapi"
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 989 "glib-2.0.vapi"
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
#line 989 "glib-2.0.vapi"
	_tmp3_ = g_strdup (_tmp2_);
#line 989 "glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 989 "glib-2.0.vapi"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 989 "glib-2.0.vapi"
	result = _tmp4_;
#line 989 "glib-2.0.vapi"
	return result;
#line 1840 "tracker-builder.c"
}

void
tracker_sparql_builder_object_double (TrackerSparqlBuilder* self,
                                      gdouble literal)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 645 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 646 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = double_to_string (literal);
#line 646 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 646 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_object (self, _tmp1_);
#line 646 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp1_);
#line 1859 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_object_blank_open:
 * @self: a #TrackerSparqlBuilder
 *
 * Opens an anonymous blank node. In insertions this can be used to create
 * anonymous nodes for not previously known data without the need of a
 * separate insertion.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void
_vala_array_add14 (TrackerSparqlBuilderState* * array,
                   gint* length,
                   gint* size,
                   TrackerSparqlBuilderState value)
{
#line 669 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 669 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 669 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1885 "tracker-builder.c"
	}
#line 669 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1889 "tracker-builder.c"
}

void
tracker_sparql_builder_object_blank_open (TrackerSparqlBuilder* self)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState _tmp2_;
	TrackerSparqlBuilderState _tmp3_;
	TrackerSparqlBuilderState _tmp4_;
	TrackerSparqlBuilderState _tmp5_;
	GString* _tmp8_;
#line 661 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 661 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 661 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 661 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = tracker_sparql_builder_get_state (self);
#line 661 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = _tmp2_;
#line 661 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_PREDICATE) || (_tmp3_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT), "state == State.PREDICATE || state == State.OBJECT");
#line 664 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = tracker_sparql_builder_get_state (self);
#line 664 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = _tmp4_;
#line 664 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp5_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 1920 "tracker-builder.c"
		GString* _tmp6_;
		gint _tmp7_;
#line 665 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp6_ = self->priv->str;
#line 665 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp6_, " ,");
#line 666 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp7_ = self->priv->states_length1;
#line 666 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = _tmp7_ - 1;
#line 1931 "tracker-builder.c"
	}
#line 668 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp8_ = self->priv->str;
#line 668 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp8_, " [");
#line 669 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add14 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_BLANK);
#line 1939 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_object_blank_close:
 * @self: a #TrackerSparqlBuilder
 *
 * Closes an anomymous blank node opened with tracker_sparql_builder_object_blank_open()
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
static void
_vala_array_add15 (TrackerSparqlBuilderState* * array,
                   gint* length,
                   gint* size,
                   TrackerSparqlBuilderState value)
{
#line 687 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if ((*length) == (*size)) {
#line 687 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 687 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		*array = g_renew (TrackerSparqlBuilderState, *array, *size);
#line 1963 "tracker-builder.c"
	}
#line 687 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	(*array)[(*length)++] = value;
#line 1967 "tracker-builder.c"
}

void
tracker_sparql_builder_object_blank_close (TrackerSparqlBuilder* self)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	TrackerSparqlBuilderState* _tmp2_;
	gint _tmp2__length1;
	TrackerSparqlBuilderState* _tmp3_;
	gint _tmp3__length1;
	TrackerSparqlBuilderState _tmp4_;
	GString* _tmp5_;
	gint _tmp6_;
#line 682 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 682 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 682 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 682 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = self->priv->states;
#line 682 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2__length1 = self->priv->states_length1;
#line 682 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = self->priv->states;
#line 682 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3__length1 = self->priv->states_length1;
#line 682 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = _tmp2_[_tmp3__length1 - 3];
#line 682 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_return_if_fail ((_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) && (_tmp4_ == TRACKER_SPARQL_BUILDER_STATE_BLANK), "state == State.OBJECT && states[states.length - 3] == State.BLANK");
#line 685 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp5_ = self->priv->str;
#line 685 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp5_, "]");
#line 686 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states_length1 = self->priv->states_length1 - 3;
#line 687 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_vala_array_add15 (&self->priv->states, &self->priv->states_length1, &self->priv->_states_size_, TRACKER_SPARQL_BUILDER_STATE_OBJECT);
#line 689 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = self->priv->_length;
#line 689 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp6_ + 1);
#line 2012 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_prepend:
 * @self: a #TrackerSparqlBuilder
 * @raw: raw content to prepend.
 *
 * Prepends raw, unvalidated content to @self.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_prepend (TrackerSparqlBuilder* self,
                                const gchar* raw)
{
	GString* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
#line 703 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 703 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (raw != NULL);
#line 705 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->str;
#line 705 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = g_strdup_printf ("%s\n", raw);
#line 705 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp1_;
#line 705 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_prepend (_tmp0_, _tmp2_);
#line 705 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_free0 (_tmp2_);
#line 707 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = self->priv->_length;
#line 707 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp3_ + 1);
#line 2051 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_append:
 * @self: a #TrackerSparqlBuilder
 * @raw: raw content to append.
 *
 * Appends raw, unvalidated content to @self.
 *
 * Since: 0.10
 * Deprecated: 2.0
 */
void
tracker_sparql_builder_append (TrackerSparqlBuilder* self,
                               const gchar* raw)
{
	TrackerSparqlBuilderState _tmp0_;
	TrackerSparqlBuilderState _tmp1_;
	GString* _tmp3_;
	gint _tmp4_;
#line 721 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 721 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (raw != NULL);
#line 723 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = tracker_sparql_builder_get_state (self);
#line 723 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = _tmp0_;
#line 723 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp1_ == TRACKER_SPARQL_BUILDER_STATE_OBJECT) {
#line 2082 "tracker-builder.c"
		GString* _tmp2_;
#line 724 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp2_ = self->priv->str;
#line 724 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_string_append (_tmp2_, " .\n");
#line 725 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->states_length1 = self->priv->states_length1 - 3;
#line 2090 "tracker-builder.c"
	}
#line 728 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp3_ = self->priv->str;
#line 728 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_string_append (_tmp3_, raw);
#line 730 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp4_ = self->priv->_length;
#line 730 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_set_length (self, _tmp4_ + 1);
#line 2100 "tracker-builder.c"
}

TrackerSparqlBuilder*
tracker_sparql_builder_construct (GType object_type)
{
	TrackerSparqlBuilder * self = NULL;
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	self = (TrackerSparqlBuilder*) g_object_new (object_type, NULL);
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	return self;
#line 2111 "tracker-builder.c"
}

TrackerSparqlBuilder*
tracker_sparql_builder_new (void)
{
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	return tracker_sparql_builder_construct (TRACKER_SPARQL_TYPE_BUILDER);
#line 2119 "tracker-builder.c"
}

const gchar*
tracker_sparql_builder_get_result (TrackerSparqlBuilder* self)
{
	const gchar* result;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlBuilderState* _tmp1_;
	gint _tmp1__length1;
	GString* _tmp6_;
	const gchar* _tmp7_;
#line 112 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = self->priv->states;
#line 113 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1__length1 = self->priv->states_length1;
#line 113 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (_tmp1__length1 == 1) {
#line 113 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = TRUE;
#line 2141 "tracker-builder.c"
	} else {
		gboolean _tmp2_ = FALSE;
		TrackerSparqlBuilderState* _tmp3_;
		gint _tmp3__length1;
		TrackerSparqlBuilderState _tmp4_;
#line 114 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3_ = self->priv->states;
#line 114 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp3__length1 = self->priv->states_length1;
#line 114 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp4_ = _tmp3_[0];
#line 114 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		if (_tmp4_ == TRACKER_SPARQL_BUILDER_STATE_EMBEDDED_INSERT) {
#line 2155 "tracker-builder.c"
			TrackerSparqlBuilderState* _tmp5_;
			gint _tmp5__length1;
#line 115 "../tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp5_ = self->priv->states;
#line 115 "../tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp5__length1 = self->priv->states_length1;
#line 115 "../tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp2_ = _tmp5__length1 == 3;
#line 2164 "tracker-builder.c"
		} else {
#line 114 "../tracker/src/libtracker-sparql/tracker-builder.vala"
			_tmp2_ = FALSE;
#line 2168 "tracker-builder.c"
		}
#line 114 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		_tmp0_ = _tmp2_;
#line 2172 "tracker-builder.c"
	}
#line 113 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_warn_if_fail (_tmp0_);
#line 116 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp6_ = self->priv->str;
#line 116 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp7_ = _tmp6_->str;
#line 116 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	result = _tmp7_;
#line 116 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	return result;
#line 2184 "tracker-builder.c"
}

gint
tracker_sparql_builder_get_length (TrackerSparqlBuilder* self)
{
	gint result;
#line 139 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 139 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	result = self->priv->_length;
#line 139 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	return result;
#line 2197 "tracker-builder.c"
}

static void
tracker_sparql_builder_set_length (TrackerSparqlBuilder* self,
                                   gint value)
{
	gint old_value;
#line 140 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_if_fail (self != NULL);
#line 140 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	old_value = tracker_sparql_builder_get_length (self);
#line 140 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	if (old_value != value) {
#line 140 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		self->priv->_length = value;
#line 140 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_object_notify_by_pspec ((GObject *) self, tracker_sparql_builder_properties[TRACKER_SPARQL_BUILDER_LENGTH_PROPERTY]);
#line 2215 "tracker-builder.c"
	}
}

TrackerSparqlBuilderState
tracker_sparql_builder_get_state (TrackerSparqlBuilder* self)
{
	TrackerSparqlBuilderState result;
	TrackerSparqlBuilderState* _tmp0_;
	gint _tmp0__length1;
	TrackerSparqlBuilderState* _tmp1_;
	gint _tmp1__length1;
	TrackerSparqlBuilderState _tmp2_;
#line 162 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 162 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = self->priv->states;
#line 162 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0__length1 = self->priv->states_length1;
#line 162 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1_ = self->priv->states;
#line 162 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp1__length1 = self->priv->states_length1;
#line 162 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp2_ = _tmp0_[_tmp1__length1 - 1];
#line 162 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	result = _tmp2_;
#line 162 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	return result;
#line 2244 "tracker-builder.c"
}

static void
tracker_sparql_builder_class_init (TrackerSparqlBuilderClass * klass,
                                   gpointer klass_data)
{
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	tracker_sparql_builder_parent_class = g_type_class_peek_parent (klass);
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_type_class_adjust_private_offset (klass, &TrackerSparqlBuilder_private_offset);
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_builder_get_property;
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_builder_set_property;
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_builder_finalize;
#line 2261 "tracker-builder.c"
	/**
	 * TrackerSparqlBuilder:result:
	 *
	 * String containing the constructed SPARQL in the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_RESULT_PROPERTY, tracker_sparql_builder_properties[TRACKER_SPARQL_BUILDER_RESULT_PROPERTY] = g_param_spec_string ("result", "result", "result", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 2271 "tracker-builder.c"
	/**
	 * TrackerSparqlBuilder:length:
	 *
	 * Number of objects added to the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_LENGTH_PROPERTY, tracker_sparql_builder_properties[TRACKER_SPARQL_BUILDER_LENGTH_PROPERTY] = g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 2281 "tracker-builder.c"
	/**
	 * TrackerSparqlBuilder:state:
	 *
	 * Current state of the #TrackerSparqlBuilder.
	 *
	 * Since: 0.10
	 */
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_BUILDER_STATE_PROPERTY, tracker_sparql_builder_properties[TRACKER_SPARQL_BUILDER_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", TRACKER_SPARQL_BUILDER_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 2291 "tracker-builder.c"
}

static void
tracker_sparql_builder_instance_init (TrackerSparqlBuilder * self,
                                      gpointer klass)
{
	GString* _tmp0_;
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv = tracker_sparql_builder_get_instance_private (self);
#line 166 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_tmp0_ = g_string_new ("");
#line 166 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->str = _tmp0_;
#line 2305 "tracker-builder.c"
}

static void
tracker_sparql_builder_finalize (GObject * obj)
{
	TrackerSparqlBuilder * self;
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder);
#line 165 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	self->priv->states = (g_free (self->priv->states), NULL);
#line 166 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	_g_string_free0 (self->priv->str);
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	G_OBJECT_CLASS (tracker_sparql_builder_parent_class)->finalize (obj);
#line 2320 "tracker-builder.c"
}

/**
 * tracker_sparql_builder_new:
 *
 * Creates a stateless #TrackerSparqlBuilder.
 *
 * Returns: a newly created #TrackerSparqlBuilder. Free with g_object_unref() when done
 *
 * Since: 0.10
 */
static GType
tracker_sparql_builder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlBuilder), 0, (GInstanceInitFunc) tracker_sparql_builder_instance_init, NULL };
	GType tracker_sparql_builder_type_id;
	tracker_sparql_builder_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlBuilder", &g_define_type_info, 0);
	TrackerSparqlBuilder_private_offset = g_type_add_instance_private (tracker_sparql_builder_type_id, sizeof (TrackerSparqlBuilderPrivate));
	return tracker_sparql_builder_type_id;
}

GType
tracker_sparql_builder_get_type (void)
{
	static volatile gsize tracker_sparql_builder_type_id__once = 0;
	if (g_once_init_enter (&tracker_sparql_builder_type_id__once)) {
		GType tracker_sparql_builder_type_id;
		tracker_sparql_builder_type_id = tracker_sparql_builder_get_type_once ();
		g_once_init_leave (&tracker_sparql_builder_type_id__once, tracker_sparql_builder_type_id);
	}
	return tracker_sparql_builder_type_id__once;
}

static void
_vala_tracker_sparql_builder_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	TrackerSparqlBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder);
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	switch (property_id) {
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_RESULT_PROPERTY:
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_value_set_string (value, tracker_sparql_builder_get_result (self));
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_LENGTH_PROPERTY:
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_value_set_int (value, tracker_sparql_builder_get_length (self));
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_STATE_PROPERTY:
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		g_value_set_enum (value, tracker_sparql_builder_get_state (self));
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2382 "tracker-builder.c"
		default:
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2388 "tracker-builder.c"
	}
}

static void
_vala_tracker_sparql_builder_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	TrackerSparqlBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_BUILDER, TrackerSparqlBuilder);
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
	switch (property_id) {
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		case TRACKER_SPARQL_BUILDER_LENGTH_PROPERTY:
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		tracker_sparql_builder_set_length (self, g_value_get_int (value));
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2408 "tracker-builder.c"
		default:
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 62 "../tracker/src/libtracker-sparql/tracker-builder.vala"
		break;
#line 2414 "tracker-builder.c"
	}
}

