#
# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################
"""
The arg spec for the iosxr_ospfv2 module
"""
from __future__ import absolute_import, division, print_function

__metaclass__ = type


class Ospfv2Args(object):  # pylint: disable=R0903
    """The arg spec for the iosxr_ospfv2 module"""

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "config": {
            "options": {
                "processes": {
                    "elements": "dict",
                    "options": {
                        "address_family_unicast": {"type": "bool"},
                        "adjacency_stagger": {
                            "options": {
                                "disable": {"type": "bool"},
                                "max_adjacency": {"type": "int"},
                                "min_adjacency": {"type": "int"},
                            },
                            "required_together": [
                                ["min_adjacency", "max_adjacency"]
                            ],
                            "type": "dict",
                        },
                        "apply_weight": {
                            "mutually_exclusive": [
                                ["bandwidth", "default_weight"]
                            ],
                            "options": {
                                "bandwidth": {"type": "int"},
                                "default_weight": {"type": "int"},
                            },
                            "type": "dict",
                        },
                        "areas": {
                            "elements": "dict",
                            "options": {
                                "area_id": {"required": True, "type": "str"},
                                "authentication": {
                                    "mutually_exclusive": [
                                        [
                                            "keychain",
                                            "message_digest",
                                            "no_auth",
                                        ]
                                    ],
                                    "options": {
                                        "keychain": {
                                            "type": "str",
                                            "no_log": False,
                                        },
                                        "message_digest": {
                                            "options": {
                                                "keychain": {
                                                    "type": "str",
                                                    "no_log": False,
                                                }
                                            },
                                            "type": "dict",
                                        },
                                        "no_auth": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "authentication_key": {
                                    "mutually_exclusive": [
                                        ["clear", "encrypted"]
                                    ],
                                    "options": {
                                        "clear": {"type": "str"},
                                        "encrypted": {"type": "str"},
                                        "password": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                    },
                                    "type": "dict",
                                    "no_log": True,
                                },
                                "bfd": {
                                    "options": {
                                        "fast_detect": {
                                            "options": {
                                                "set": {"type": "bool"},
                                                "strict_mode": {
                                                    "type": "bool"
                                                },
                                            },
                                            "type": "dict",
                                        },
                                        "minimum_interval": {"type": "int"},
                                        "multiplier": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                                "cost": {"type": "int"},
                                "dead_interval": {"type": "int"},
                                "default_cost": {"type": "int"},
                                "hello_interval": {"type": "int"},
                                "mpls": {
                                    "options": {
                                        "ldp": {
                                            "options": {
                                                "auto_config": {
                                                    "type": "bool"
                                                },
                                                "sync": {"type": "bool"},
                                                "sync_igp_shortcuts": {
                                                    "type": "bool"
                                                },
                                            },
                                            "type": "dict",
                                        },
                                        "traffic_eng": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "mtu_ignore": {
                                    "choices": ["enable", "disable"],
                                    "type": "str",
                                },
                                "nssa": {
                                    "options": {
                                        "default_information_originate": {
                                            "options": {
                                                "metric": {"type": "int"},
                                                "metric_type": {"type": "int"},
                                            },
                                            "type": "dict",
                                        },
                                        "no_redistribution": {"type": "bool"},
                                        "no_summary": {"type": "bool"},
                                        "set": {"type": "bool"},
                                        "translate": {
                                            "options": {
                                                "type7": {
                                                    "options": {
                                                        "always": {
                                                            "type": "bool"
                                                        }
                                                    },
                                                    "type": "dict",
                                                }
                                            },
                                            "type": "dict",
                                        },
                                    },
                                    "type": "dict",
                                },
                                "ranges": {
                                    "elements": "dict",
                                    "mutually_exclusive": [
                                        ["advertise", "not_advertise"]
                                    ],
                                    "options": {
                                        "address": {
                                            "required": True,
                                            "type": "str",
                                        },
                                        "advertise": {"type": "bool"},
                                        "not_advertise": {"type": "bool"},
                                    },
                                    "type": "list",
                                },
                                "route_policy": {
                                    "elements": "dict",
                                    "options": {
                                        "direction": {
                                            "choices": ["in", "out"],
                                            "type": "str",
                                        },
                                        "parameters": {
                                            "elements": "str",
                                            "type": "list",
                                        },
                                    },
                                    "type": "list",
                                },
                                "stub": {
                                    "options": {
                                        "no_summary": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "transmit_delay": {"type": "int"},
                                "virtual_link": {
                                    "elements": "dict",
                                    "options": {
                                        "authentication": {
                                            "mutually_exclusive": [
                                                [
                                                    "keychain",
                                                    "message_digest",
                                                    "no_auth",
                                                ]
                                            ],
                                            "options": {
                                                "keychain": {
                                                    "type": "str",
                                                    "no_log": False,
                                                },
                                                "message_digest": {
                                                    "options": {
                                                        "keychain": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        }
                                                    },
                                                    "type": "dict",
                                                },
                                                "no_auth": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                        "authentication_key": {
                                            "mutually_exclusive": [
                                                ["clear", "encrypted"]
                                            ],
                                            "options": {
                                                "clear": {"type": "str"},
                                                "encrypted": {"type": "str"},
                                                "password": {
                                                    "type": "str",
                                                    "no_log": True,
                                                },
                                            },
                                            "type": "dict",
                                            "no_log": True,
                                        },
                                        "dead_interval": {"type": "int"},
                                        "hello_interval": {"type": "int"},
                                        "id": {
                                            "required": True,
                                            "type": "str",
                                        },
                                        "message_digest_key": {
                                            "options": {
                                                "id": {
                                                    "required": True,
                                                    "type": "int",
                                                },
                                                "md5": {
                                                    "mutually_exclusive": [
                                                        ["clear", "encrypted"]
                                                    ],
                                                    "options": {
                                                        "clear": {
                                                            "type": "bool"
                                                        },
                                                        "encrypted": {
                                                            "type": "bool"
                                                        },
                                                        "password": {
                                                            "type": "str",
                                                            "no_log": True,
                                                        },
                                                    },
                                                    "type": "dict",
                                                    "no_log": False,
                                                },
                                            },
                                            "type": "dict",
                                            "no_log": False,
                                        },
                                        "retransmit_interval": {"type": "int"},
                                        "transmit_delay": {"type": "int"},
                                    },
                                    "type": "list",
                                },
                            },
                            "type": "list",
                        },
                        "authentication": {
                            "mutually_exclusive": [
                                ["keychain", "message_digest", "no_auth"]
                            ],
                            "options": {
                                "keychain": {"type": "str", "no_log": False},
                                "message_digest": {
                                    "options": {
                                        "keychain": {
                                            "type": "str",
                                            "no_log": False,
                                        },
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "no_auth": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "authentication_key": {
                            "mutually_exclusive": [["clear", "encrypted"]],
                            "options": {
                                "clear": {"type": "bool"},
                                "encrypted": {"type": "bool"},
                                "password": {"type": "str", "no_log": True},
                            },
                            "type": "dict",
                            "no_log": True,
                        },
                        "auto_cost": {
                            "mutually_exclusive": [
                                ["reference_bandwidth", "disable"]
                            ],
                            "options": {
                                "disable": {"type": "bool"},
                                "reference_bandwidth": {"type": "int"},
                            },
                            "type": "dict",
                        },
                        "bfd": {
                            "options": {
                                "fast_detect": {
                                    "options": {
                                        "set": {"type": "bool"},
                                        "strict_mode": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "minimum_interval": {"type": "int"},
                                "multiplier": {"type": "int"},
                            },
                            "type": "dict",
                        },
                        "capability": {
                            "options": {
                                "opaque": {
                                    "mutually_exclusive": [["set", "disable"]],
                                    "options": {
                                        "disable": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "type7": {"type": "str"},
                            },
                            "type": "dict",
                        },
                        "cost": {"type": "int"},
                        "database_filter": {
                            "choices": ["enable", "disable"],
                            "type": "str",
                        },
                        "dead_interval": {"type": "int"},
                        "default_information_originate": {
                            "options": {
                                "always": {"type": "bool"},
                                "metric": {"type": "int"},
                                "metric_type": {"type": "int"},
                                "route_policy": {"type": "str"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "default_metric": {"type": "int"},
                        "demand_circuit": {
                            "choices": ["enable", "disable"],
                            "type": "str",
                        },
                        "distance": {
                            "options": {
                                "admin_distance": {
                                    "elements": "dict",
                                    "options": {
                                        "access_list": {"type": "str"},
                                        "source": {"type": "str"},
                                        "value": {"type": "int"},
                                        "wildcard": {"type": "str"},
                                    },
                                    "required_together": [
                                        ["value", "source", "wildcard"]
                                    ],
                                    "type": "list",
                                },
                                "ospf_distance": {
                                    "options": {
                                        "external": {"type": "int"},
                                        "inter_area": {"type": "int"},
                                        "intra_area": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "distribute_bgp_ls": {
                            "options": {
                                "instance_id": {"type": "int"},
                                "throttle": {"type": "int"},
                            },
                            "type": "dict",
                        },
                        "distribute_link_state": {
                            "options": {
                                "instance_id": {"type": "int"},
                                "throttle": {"type": "int"},
                            },
                            "type": "dict",
                        },
                        "distribute_list": {
                            "elements": "dict",
                            "mutually_exclusive": [
                                ["access_list", "route_policy"]
                            ],
                            "options": {
                                "access_list": {"type": "str"},
                                "direction": {
                                    "choices": ["in", "out"],
                                    "type": "str",
                                },
                                "outgoing_params": {
                                    "options": {
                                        "id": {"type": "str"},
                                        "route_type": {
                                            "choices": [
                                                "bgp",
                                                "connected",
                                                "dagr",
                                                "ospf",
                                                "static",
                                            ],
                                            "type": "str",
                                        },
                                    },
                                    "type": "dict",
                                },
                                "route_policy": {"type": "str"},
                            },
                            "type": "list",
                        },
                        "external_out": {
                            "choices": ["enable", "disable"],
                            "type": "str",
                        },
                        "flood_reduction": {
                            "choices": ["enable", "disable"],
                            "type": "str",
                        },
                        "hello_interval": {"type": "int"},
                        "ignore_lsa_mospf": {"type": "bool"},
                        "link_down_fast_detect": {"type": "bool"},
                        "log_adjacency_changes": {
                            "options": {
                                "detail": {"type": "bool"},
                                "disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "loopback_stub_network": {
                            "choices": ["enable", "disable"],
                            "type": "str",
                        },
                        "max_lsa": {
                            "options": {
                                "ignore_count": {"type": "int"},
                                "ignore_time": {"type": "int"},
                                "reset_time": {"type": "int"},
                                "threshold": {"type": "int"},
                                "warning_only": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "max_metric": {
                            "options": {
                                "router_lsa": {
                                    "options": {
                                        "external_lsa": {
                                            "options": {
                                                "max_metric_value": {
                                                    "type": "int"
                                                },
                                                "set": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                        "include_stub": {"type": "bool"},
                                        "on_startup": {
                                            "options": {
                                                "set": {"type": "bool"},
                                                "wait_for_bgp_asn": {
                                                    "type": "int"
                                                },
                                                "wait_period": {"type": "int"},
                                            },
                                            "type": "dict",
                                        },
                                        "set": {"type": "bool"},
                                        "summary_lsa": {
                                            "options": {
                                                "max_metric_value": {
                                                    "type": "int"
                                                },
                                                "set": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                    },
                                    "type": "dict",
                                }
                            },
                            "type": "dict",
                        },
                        "message_digest_key": {
                            "options": {
                                "id": {"required": True, "type": "int"},
                                "md5": {
                                    "mutually_exclusive": [
                                        ["clear", "encrypted"]
                                    ],
                                    "options": {
                                        "clear": {"type": "bool"},
                                        "encrypted": {"type": "bool"},
                                        "password": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                    },
                                    "required": True,
                                    "type": "dict",
                                    "no_log": False,
                                },
                            },
                            "type": "dict",
                            "no_log": False,
                        },
                        "microloop_avoidance": {
                            "mutually_exclusive": [
                                [
                                    "protected",
                                    "rib_update_delay",
                                    "segment_routing",
                                ]
                            ],
                            "options": {
                                "protected": {"type": "bool"},
                                "rib_update_delay": {"type": "int"},
                                "segment_routing": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "monitor_convergence": {
                            "options": {
                                "prefix_list": {"type": "str"},
                                "track_external_routes": {"type": "bool"},
                                "track_ip_frr": {"type": "bool"},
                                "track_summary_routes": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "mpls": {
                            "options": {
                                "ldp": {
                                    "options": {
                                        "auto_config": {"type": "bool"},
                                        "sync": {"type": "bool"},
                                        "sync_igp_shortcuts": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "traffic_eng": {
                                    "options": {
                                        "autoroute_exclude": {
                                            "options": {
                                                "parameters": {
                                                    "elements": "str",
                                                    "type": "list",
                                                },
                                                "route_policy": {
                                                    "type": "str"
                                                },
                                            },
                                            "type": "dict",
                                        },
                                        "igp_intact": {"type": "bool"},
                                        "ldp_sync_update": {"type": "bool"},
                                        "multicast_intact": {"type": "bool"},
                                        "router_id": {"type": "str"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "mtu_ignore": {
                            "choices": ["enable", "disable"],
                            "type": "str",
                        },
                        "network": {
                            "options": {
                                "broadcast": {"type": "bool"},
                                "non_broadcast": {"type": "bool"},
                                "point_to_multipoint": {"type": "bool"},
                                "point_to_point": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "nsf": {
                            "options": {
                                "cisco": {
                                    "options": {
                                        "enforce_global": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "flush_delay_time": {"type": "int"},
                                "ietf": {
                                    "options": {
                                        "helper_disable": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "interval": {"type": "int"},
                                "lifetime": {"type": "int"},
                            },
                            "type": "dict",
                        },
                        "nsr": {"type": "bool"},
                        "packet_size": {"type": "int"},
                        "passive": {
                            "choices": ["enable", "disable"],
                            "type": "str",
                        },
                        "prefix_suppression": {
                            "options": {
                                "secondary_address": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "priority": {"type": "int"},
                        "process_id": {"required": True, "type": "str"},
                        "protocol_shutdown": {
                            "options": {
                                "host_mode": {"type": "bool"},
                                "limit": {
                                    "options": {
                                        "high": {"type": "int"},
                                        "low": {"type": "int"},
                                        "medium": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                                "on_reload": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "redistribute": {
                            "options": {
                                "id": {"type": "str"},
                                "level": {
                                    "choices": [1, 2, 12],
                                    "type": "int",
                                },
                                "lsa_type_summary": {"type": "bool"},
                                "match": {"type": "str"},
                                "metric": {"type": "int"},
                                "metric_type": {
                                    "choices": [1, 2],
                                    "type": "int",
                                },
                                "nssa_only": {"type": "bool"},
                                "preserve_med": {"type": "bool"},
                                "route_policy": {
                                    "options": {
                                        "name": {"type": "str"},
                                        "parameters": {
                                            "elements": "str",
                                            "type": "list",
                                        },
                                    },
                                    "type": "dict",
                                },
                                "route_type": {
                                    "choices": [
                                        "application",
                                        "bgp",
                                        "connected",
                                        "dagr",
                                        "eigrp",
                                        "isis",
                                        "mobile",
                                        "ospf",
                                        "rip",
                                        "static",
                                        "subscriber",
                                    ],
                                    "type": "str",
                                },
                                "tag": {"type": "int"},
                            },
                            "type": "dict",
                        },
                        "retransmit_interval": {"type": "int"},
                        "router_id": {"type": "str"},
                        "security_ttl": {
                            "options": {
                                "hops": {"type": "int"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "summary_in": {
                            "choices": ["enable", "disable"],
                            "type": "str",
                        },
                        "summary_prefix": {
                            "elements": "dict",
                            "options": {
                                "not_advertise": {"type": "bool"},
                                "prefix": {"required": True, "type": "str"},
                                "tag": {"type": "int"},
                            },
                            "type": "list",
                        },
                        "timers": {
                            "options": {
                                "graceful_shutdown": {
                                    "options": {
                                        "initial_delay": {"type": "int"},
                                        "retain_routes": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                                "lsa": {
                                    "options": {
                                        "group_pacing": {"type": "int"},
                                        "min_arrival": {"type": "int"},
                                        "refresh": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                                "pacing_flood": {"type": "int"},
                                "throttle": {
                                    "options": {
                                        "fast_reroute": {"type": "int"},
                                        "lsa_all": {
                                            "options": {
                                                "initial_delay": {
                                                    "type": "int"
                                                },
                                                "max_delay": {"type": "int"},
                                                "min_delay": {"type": "int"},
                                            },
                                            "type": "dict",
                                        },
                                        "spf": {
                                            "options": {
                                                "change_delay": {
                                                    "type": "int"
                                                },
                                                "max_wait": {"type": "int"},
                                                "second_delay": {
                                                    "type": "int"
                                                },
                                            },
                                            "type": "dict",
                                        },
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "transmit_delay": {"type": "int"},
                        "weight": {"type": "int"},
                    },
                    "type": "list",
                }
            },
            "type": "dict",
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "rendered",
                "parsed",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
