/* BluetoothIndicator.c generated by valac 0.56.2, the Vala compiler
 * generated from BluetoothIndicator.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 * Copyright (C) 2015 Alberts Muktupāvels
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BluetoothIndicator is largely inspired by gnome-flashback.
 */

#include "statusapplet.h"
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include <bluetooth-client.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include "plugin.h"
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <bluetooth-enums.h>
#include <gio/gdesktopappinfo.h>

typedef GDBusProxy RfkillProxy;
typedef GDBusProxyClass RfkillProxyClass;
enum  {
	BLUETOOTH_INDICATOR_0_PROPERTY,
	BLUETOOTH_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* bluetooth_indicator_properties[BLUETOOTH_INDICATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BluetoothIndicatorSetupDbusData BluetoothIndicatorSetupDbusData;
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BluetoothIndicatorPrivate {
	BluetoothClient* client;
	GtkTreeModel* model;
	Rfkill* killer;
	GDBusProxy* db;
	GtkCheckButton* radio_airplane;
	gulong radio_id;
	GtkButton* send_to;
};

struct _BluetoothIndicatorSetupDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothIndicator* self;
	Rfkill* _tmp0_;
	Rfkill* _tmp1_;
	Rfkill* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_;
};

static GType rfkill_type_id = 0;
static gint BluetoothIndicator_private_offset;
static gpointer bluetooth_indicator_parent_class = NULL;
static GType bluetooth_indicator_type_id = 0;

static void rfkill_proxy_g_signal (GDBusProxy* proxy,
                            const gchar* sender_name,
                            const gchar* signal_name,
                            GVariant* parameters);
static gboolean rfkill_dbus_proxy_get_BluetoothAirplaneMode (Rfkill* self);
static void rfkill_dbus_proxy_set_BluetoothAirplaneMode (Rfkill* self,
                                                  gboolean value);
static void rfkill_proxy_rfkill_interface_init (RfkillIface* iface);
static void rfkill_dbus_interface_method_call (GDBusConnection* connection,
                                        const gchar* sender,
                                        const gchar* object_path,
                                        const gchar* interface_name,
                                        const gchar* method_name,
                                        GVariant* parameters,
                                        GDBusMethodInvocation* invocation,
                                        gpointer user_data);
static GVariant* rfkill_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data);
static GVariant* _dbus_rfkill_get_BluetoothAirplaneMode (Rfkill* self);
static gboolean rfkill_dbus_interface_set_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GVariant* value,
                                             GError** error,
                                             gpointer user_data);
static void _dbus_rfkill_set_BluetoothAirplaneMode (Rfkill* self,
                                             GVariant* _value);
static void _rfkill_unregister_object (gpointer user_data);
static gboolean bluetooth_indicator_on_button_release_event (BluetoothIndicator* self,
                                                      GdkEventButton* e);
static gboolean _bluetooth_indicator_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                       GdkEventButton* event,
                                                                                       gpointer self);
static void bluetooth_indicator_on_settings_activate (BluetoothIndicator* self);
static void _bluetooth_indicator_on_settings_activate_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void bluetooth_indicator_on_send_file (BluetoothIndicator* self);
static void _bluetooth_indicator_on_send_file_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void bluetooth_indicator_on_set_airplane (BluetoothIndicator* self);
static void _bluetooth_indicator_on_set_airplane_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void __lambda4_ (BluetoothIndicator* self);
static void bluetooth_indicator_resync (BluetoothIndicator* self);
static void ___lambda4__gtk_tree_model_row_changed (GtkTreeModel* _sender,
                                             GtkTreePath* path,
                                             GtkTreeIter* iter,
                                             gpointer self);
static void __lambda5_ (BluetoothIndicator* self);
static void ___lambda5__gtk_tree_model_row_deleted (GtkTreeModel* _sender,
                                             GtkTreePath* path,
                                             gpointer self);
static void __lambda6_ (BluetoothIndicator* self);
static void ___lambda6__gtk_tree_model_row_inserted (GtkTreeModel* _sender,
                                              GtkTreePath* path,
                                              GtkTreeIter* iter,
                                              gpointer self);
static void bluetooth_indicator_setup_dbus (BluetoothIndicator* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void bluetooth_indicator_setup_dbus_finish (BluetoothIndicator* self,
                                            GAsyncResult* _res_);
static void __lambda7_ (BluetoothIndicator* self);
static void bluetooth_indicator_sync_rfkill (BluetoothIndicator* self);
static void ___lambda7__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void bluetooth_indicator_setup_dbus_data_free (gpointer _data);
static gboolean bluetooth_indicator_setup_dbus_co (BluetoothIndicatorSetupDbusData* _data_);
static void bluetooth_indicator_setup_dbus_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static gboolean bluetooth_indicator_get_default_adapter (BluetoothIndicator* self,
                                                  GtkTreeIter** adapter);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static gint bluetooth_indicator_get_n_devices (BluetoothIndicator* self);
static void bluetooth_indicator_on_airplane_change (BluetoothIndicator* self);
static void _bluetooth_indicator_on_airplane_change_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                GVariant* changed_properties,
                                                                                gchar** invalidated_properties,
                                                                                gpointer self);
static void bluetooth_indicator_finalize (GObject * obj);

static const GDBusMethodInfo * const _rfkill_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _rfkill_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _rfkill_dbus_property_info_BluetoothAirplaneMode = {-1, "BluetoothAirplaneMode", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _rfkill_dbus_property_info[] = {&_rfkill_dbus_property_info_BluetoothAirplaneMode, NULL};
static const GDBusInterfaceInfo _rfkill_dbus_interface_info = {-1, "org.gnome.SettingsDaemon.Rfkill", (GDBusMethodInfo **) (&_rfkill_dbus_method_info), (GDBusSignalInfo **) (&_rfkill_dbus_signal_info), (GDBusPropertyInfo **) (&_rfkill_dbus_property_info), NULL};
static const GDBusInterfaceVTable _rfkill_dbus_interface_vtable = {rfkill_dbus_interface_method_call, rfkill_dbus_interface_get_property, rfkill_dbus_interface_set_property};

gboolean
rfkill_get_BluetoothAirplaneMode (Rfkill* self)
{
	RfkillIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = RFKILL_GET_INTERFACE (self);
	if (_iface_->get_BluetoothAirplaneMode) {
		return _iface_->get_BluetoothAirplaneMode (self);
	}
	return FALSE;
}

void
rfkill_set_BluetoothAirplaneMode (Rfkill* self,
                                  gboolean value)
{
	RfkillIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RFKILL_GET_INTERFACE (self);
	if (_iface_->set_BluetoothAirplaneMode) {
		_iface_->set_BluetoothAirplaneMode (self, value);
	}
}

static void
rfkill_default_init (RfkillIface * iface,
                     gpointer iface_data)
{
}

GType
rfkill_get_type (void)
{
	return rfkill_type_id;
}

GType
rfkill_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (RfkillIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rfkill_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	rfkill_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "Rfkill", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (rfkill_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (rfkill_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) rfkill_proxy_get_type);
	g_type_set_qdata (rfkill_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SettingsDaemon.Rfkill");
	g_type_set_qdata (rfkill_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_rfkill_dbus_interface_info));
	g_type_set_qdata (rfkill_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) rfkill_register_object);
	return rfkill_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (RfkillProxy, rfkill_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_RFKILL, rfkill_proxy_rfkill_interface_init) )
static void
rfkill_proxy_class_init (RfkillProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = rfkill_proxy_g_signal;
}

static void
rfkill_proxy_g_signal (GDBusProxy* proxy,
                       const gchar* sender_name,
                       const gchar* signal_name,
                       GVariant* parameters)
{
}

static void
rfkill_proxy_class_finalize (RfkillProxyClass* klass)
{
}

void
rfkill_proxy_register_dynamic_type (GTypeModule* module)
{
	rfkill_proxy_register_type (module);
}

static void
rfkill_proxy_init (RfkillProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_rfkill_dbus_interface_info));
}

static gboolean
rfkill_dbus_proxy_get_BluetoothAirplaneMode (Rfkill* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "BluetoothAirplaneMode");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Rfkill"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("BluetoothAirplaneMode"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp0_ = FALSE;
			return _tmp0_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
rfkill_dbus_proxy_set_BluetoothAirplaneMode (Rfkill* self,
                                             gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Rfkill"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("BluetoothAirplaneMode"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
rfkill_proxy_rfkill_interface_init (RfkillIface* iface)
{
	iface->get_BluetoothAirplaneMode = rfkill_dbus_proxy_get_BluetoothAirplaneMode;
	iface->set_BluetoothAirplaneMode = rfkill_dbus_proxy_set_BluetoothAirplaneMode;
}

static void
rfkill_dbus_interface_method_call (GDBusConnection* connection,
                                   const gchar* sender,
                                   const gchar* object_path,
                                   const gchar* interface_name,
                                   const gchar* method_name,
                                   GVariant* parameters,
                                   GDBusMethodInvocation* invocation,
                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_rfkill_get_BluetoothAirplaneMode (Rfkill* self)
{
	gboolean result;
	GVariant* _reply;
	result = rfkill_get_BluetoothAirplaneMode (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
rfkill_dbus_interface_get_property (GDBusConnection* connection,
                                    const gchar* sender,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* property_name,
                                    GError** error,
                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "BluetoothAirplaneMode") == 0) {
		return _dbus_rfkill_get_BluetoothAirplaneMode (object);
	}
	return NULL;
}

static void
_dbus_rfkill_set_BluetoothAirplaneMode (Rfkill* self,
                                        GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	rfkill_set_BluetoothAirplaneMode (self, value);
}

static gboolean
rfkill_dbus_interface_set_property (GDBusConnection* connection,
                                    const gchar* sender,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* property_name,
                                    GVariant* value,
                                    GError** error,
                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "BluetoothAirplaneMode") == 0) {
		_dbus_rfkill_set_BluetoothAirplaneMode (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
rfkill_register_object (gpointer object,
                        GDBusConnection* connection,
                        const gchar* path,
                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_rfkill_dbus_interface_info), &_rfkill_dbus_interface_vtable, data, _rfkill_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_rfkill_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
bluetooth_indicator_get_instance_private (BluetoothIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothIndicator_private_offset);
}

static gboolean
_bluetooth_indicator_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self)
{
	gboolean result;
	result = bluetooth_indicator_on_button_release_event ((BluetoothIndicator*) self, event);
	return result;
}

static void
_bluetooth_indicator_on_settings_activate_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	bluetooth_indicator_on_settings_activate ((BluetoothIndicator*) self);
}

static void
_bluetooth_indicator_on_send_file_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	bluetooth_indicator_on_send_file ((BluetoothIndicator*) self);
}

static void
_bluetooth_indicator_on_set_airplane_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	bluetooth_indicator_on_set_airplane ((BluetoothIndicator*) self);
}

static void
__lambda4_ (BluetoothIndicator* self)
{
	bluetooth_indicator_resync (self);
}

static void
___lambda4__gtk_tree_model_row_changed (GtkTreeModel* _sender,
                                        GtkTreePath* path,
                                        GtkTreeIter* iter,
                                        gpointer self)
{
	__lambda4_ ((BluetoothIndicator*) self);
}

static void
__lambda5_ (BluetoothIndicator* self)
{
	bluetooth_indicator_resync (self);
}

static void
___lambda5__gtk_tree_model_row_deleted (GtkTreeModel* _sender,
                                        GtkTreePath* path,
                                        gpointer self)
{
	__lambda5_ ((BluetoothIndicator*) self);
}

static void
__lambda6_ (BluetoothIndicator* self)
{
	bluetooth_indicator_resync (self);
}

static void
___lambda6__gtk_tree_model_row_inserted (GtkTreeModel* _sender,
                                         GtkTreePath* path,
                                         GtkTreeIter* iter,
                                         gpointer self)
{
	__lambda6_ ((BluetoothIndicator*) self);
}

static void
__lambda7_ (BluetoothIndicator* self)
{
	Rfkill* _tmp0_;
	_tmp0_ = self->priv->killer;
	if (_tmp0_ == NULL) {
		return;
	}
	bluetooth_indicator_sync_rfkill (self);
}

static void
___lambda7__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda7_ ((BluetoothIndicator*) self);
	g_object_unref (self);
}

BluetoothIndicator*
bluetooth_indicator_construct (GType object_type)
{
	BluetoothIndicator * self = NULL;
	GtkImage* _tmp0_;
	GtkEventBox* _tmp1_;
	GtkEventBox* _tmp2_;
	GtkEventBox* _tmp3_;
	GtkImage* _tmp4_;
	GtkEventBox* _tmp5_;
	GtkEventBox* _tmp6_;
	GtkEventBox* _tmp7_;
	BudgiePopover* _tmp8_;
	GtkBox* box = NULL;
	GtkBox* _tmp9_;
	BudgiePopover* _tmp10_;
	GtkButton* button = NULL;
	GtkButton* _tmp11_;
	GtkWidget* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	GtkWidget* _tmp16_;
	GtkButton* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkSeparator* sep = NULL;
	GtkSeparator* _tmp21_;
	GtkCheckButton* _tmp22_;
	GtkCheckButton* _tmp23_;
	GtkWidget* _tmp24_;
	GValue _tmp25_ = {0};
	GtkCheckButton* _tmp26_;
	gulong _tmp27_;
	GtkCheckButton* _tmp28_;
	BluetoothClient* _tmp29_;
	BluetoothClient* _tmp30_;
	GtkTreeModel* _tmp31_;
	GtkTreeModel* _tmp32_;
	GtkTreeModel* _tmp33_;
	GtkTreeModel* _tmp34_;
	self = (BluetoothIndicator*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("bluetooth-active-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->image);
	self->image = _tmp0_;
	_tmp1_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->ebox);
	self->ebox = _tmp1_;
	_tmp2_ = self->ebox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = self->ebox;
	_tmp4_ = self->image;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->ebox;
	gtk_widget_add_events ((GtkWidget*) _tmp5_, (gint) GDK_BUTTON_RELEASE_MASK);
	_tmp6_ = self->ebox;
	g_signal_connect_object ((GtkWidget*) _tmp6_, "button-release-event", (GCallback) _bluetooth_indicator_on_button_release_event_gtk_widget_button_release_event, self, 0);
	_tmp7_ = self->ebox;
	_tmp8_ = (BudgiePopover*) budgie_popover_new ((GtkWidget*) _tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->popover);
	self->popover = _tmp8_;
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 1);
	g_object_ref_sink (_tmp9_);
	box = _tmp9_;
	gtk_container_set_border_width ((GtkContainer*) box, (guint) 6);
	_tmp10_ = self->popover;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) box);
	_tmp11_ = (GtkButton*) gtk_button_new_with_label (_ ("Bluetooth Settings"));
	g_object_ref_sink (_tmp11_);
	button = _tmp11_;
	_tmp12_ = gtk_bin_get_child ((GtkBin*) button);
	gtk_widget_set_halign (_tmp12_, GTK_ALIGN_START);
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) button);
	gtk_style_context_add_class (_tmp13_, GTK_STYLE_CLASS_FLAT);
	g_signal_connect_object (button, "clicked", (GCallback) _bluetooth_indicator_on_settings_activate_gtk_button_clicked, self, 0);
	gtk_box_pack_start (box, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	_tmp14_ = (GtkButton*) gtk_button_new_with_label (_ ("Send Files"));
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->send_to);
	self->priv->send_to = _tmp14_;
	_tmp15_ = self->priv->send_to;
	_tmp16_ = gtk_bin_get_child ((GtkBin*) _tmp15_);
	gtk_widget_set_halign (_tmp16_, GTK_ALIGN_START);
	_tmp17_ = self->priv->send_to;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, GTK_STYLE_CLASS_FLAT);
	_tmp19_ = self->priv->send_to;
	g_signal_connect_object (_tmp19_, "clicked", (GCallback) _bluetooth_indicator_on_send_file_gtk_button_clicked, self, 0);
	_tmp20_ = self->priv->send_to;
	gtk_box_pack_start (box, (GtkWidget*) _tmp20_, FALSE, FALSE, (guint) 0);
	_tmp21_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp21_);
	sep = _tmp21_;
	gtk_box_pack_start (box, (GtkWidget*) sep, FALSE, FALSE, (guint) 1);
	_tmp22_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Bluetooth Airplane Mode"));
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->radio_airplane);
	self->priv->radio_airplane = _tmp22_;
	_tmp23_ = self->priv->radio_airplane;
	_tmp24_ = gtk_bin_get_child ((GtkBin*) _tmp23_);
	g_value_init (&_tmp25_, G_TYPE_INT);
	g_value_set_int (&_tmp25_, 4);
	g_object_set_property ((GObject*) _tmp24_, "margin", &_tmp25_);
	G_IS_VALUE (&_tmp25_) ? (g_value_unset (&_tmp25_), NULL) : NULL;
	_tmp26_ = self->priv->radio_airplane;
	_tmp27_ = g_signal_connect_object ((GObject*) _tmp26_, "notify::active", (GCallback) _bluetooth_indicator_on_set_airplane_g_object_notify, self, G_CONNECT_AFTER);
	self->priv->radio_id = _tmp27_;
	_tmp28_ = self->priv->radio_airplane;
	gtk_box_pack_start (box, (GtkWidget*) _tmp28_, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) box);
	_tmp29_ = bluetooth_client_new ();
	_g_object_unref0 (self->priv->client);
	self->priv->client = _tmp29_;
	_tmp30_ = self->priv->client;
	_tmp31_ = bluetooth_client_get_model (_tmp30_);
	_g_object_unref0 (self->priv->model);
	self->priv->model = _tmp31_;
	_tmp32_ = self->priv->model;
	g_signal_connect_object (_tmp32_, "row-changed", (GCallback) ___lambda4__gtk_tree_model_row_changed, self, 0);
	_tmp33_ = self->priv->model;
	g_signal_connect_object (_tmp33_, "row-deleted", (GCallback) ___lambda5__gtk_tree_model_row_deleted, self, 0);
	_tmp34_ = self->priv->model;
	g_signal_connect_object (_tmp34_, "row-inserted", (GCallback) ___lambda6__gtk_tree_model_row_inserted, self, 0);
	bluetooth_indicator_resync (self);
	bluetooth_indicator_setup_dbus (self, ___lambda7__gasync_ready_callback, g_object_ref (self));
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (sep);
	_g_object_unref0 (button);
	_g_object_unref0 (box);
	return self;
}

BluetoothIndicator*
bluetooth_indicator_new (void)
{
	return bluetooth_indicator_construct (TYPE_BLUETOOTH_INDICATOR);
}

static gboolean
bluetooth_indicator_on_button_release_event (BluetoothIndicator* self,
                                             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button == ((guint) GDK_BUTTON_MIDDLE)) {
		Rfkill* _tmp0_;
		_tmp0_ = self->priv->killer;
		if (_tmp0_ != NULL) {
			Rfkill* _tmp1_;
			Rfkill* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_tmp1_ = self->priv->killer;
			_tmp2_ = self->priv->killer;
			_tmp3_ = rfkill_get_BluetoothAirplaneMode (_tmp2_);
			_tmp4_ = _tmp3_;
			rfkill_set_BluetoothAirplaneMode (_tmp1_, !_tmp4_);
		}
	} else {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	result = GDK_EVENT_STOP;
	return result;
}

static void
bluetooth_indicator_setup_dbus_data_free (gpointer _data)
{
	BluetoothIndicatorSetupDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothIndicatorSetupDbusData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bluetooth_indicator_setup_dbus (BluetoothIndicator* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	BluetoothIndicatorSetupDbusData* _data_;
	BluetoothIndicator* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothIndicatorSetupDbusData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_indicator_setup_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_indicator_setup_dbus_co (_data_);
}

static void
bluetooth_indicator_setup_dbus_finish (BluetoothIndicator* self,
                                       GAsyncResult* _res_)
{
	BluetoothIndicatorSetupDbusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
bluetooth_indicator_setup_dbus_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	BluetoothIndicatorSetupDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_indicator_setup_dbus_co (_data_);
}

static gboolean
bluetooth_indicator_setup_dbus_co (BluetoothIndicatorSetupDbusData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (TYPE_RFKILL_PROXY, 0, NULL, bluetooth_indicator_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.gnome.SettingsDaemon.Rfkill", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SettingsDaemon/Rfkill", "g-interface-name", "org.gnome.SettingsDaemon.Rfkill", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (Rfkill*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (Rfkill*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->killer);
		_data_->self->priv->killer = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_g_object_unref0 (_data_->self->priv->killer);
		_data_->self->priv->killer = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("BluetoothIndicator.vala:113: Unable to contact RfKill manager: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static gboolean
bluetooth_indicator_get_default_adapter (BluetoothIndicator* self,
                                         GtkTreeIter** adapter)
{
	GtkTreeIter* _vala_adapter = NULL;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	__vala_GtkTreeIter_free0 (_vala_adapter);
	_vala_adapter = NULL;
	_tmp0_ = self->priv->model;
	_tmp2_ = gtk_tree_model_get_iter_first (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		if (adapter) {
			*adapter = _vala_adapter;
		} else {
			__vala_GtkTreeIter_free0 (_vala_adapter);
		}
		return result;
	}
	while (TRUE) {
		gboolean is_default = FALSE;
		GtkTreeModel* _tmp3_;
		GtkTreeIter _tmp4_;
		gboolean _tmp5_ = FALSE;
		GtkTreeModel* _tmp8_;
		gboolean _tmp9_;
		_tmp3_ = self->priv->model;
		_tmp4_ = iter;
		gtk_tree_model_get (_tmp3_, &_tmp4_, BLUETOOTH_COLUMN_DEFAULT, &_tmp5_, -1, -1);
		is_default = _tmp5_;
		if (is_default) {
			GtkTreeIter _tmp6_;
			GtkTreeIter* _tmp7_;
			_tmp6_ = iter;
			_tmp7_ = __vala_GtkTreeIter_copy0 (&_tmp6_);
			__vala_GtkTreeIter_free0 (_vala_adapter);
			_vala_adapter = _tmp7_;
			result = TRUE;
			if (adapter) {
				*adapter = _vala_adapter;
			} else {
				__vala_GtkTreeIter_free0 (_vala_adapter);
			}
			return result;
		}
		_tmp8_ = self->priv->model;
		_tmp9_ = gtk_tree_model_iter_next (_tmp8_, &iter);
		if (!_tmp9_) {
			break;
		}
	}
	result = FALSE;
	if (adapter) {
		*adapter = _vala_adapter;
	} else {
		__vala_GtkTreeIter_free0 (_vala_adapter);
	}
	return result;
}

static gint
bluetooth_indicator_get_n_devices (BluetoothIndicator* self)
{
	GtkTreeIter iter = {0};
	GtkTreeIter* adapter = NULL;
	gint n_devices = 0;
	GtkTreeIter* _tmp0_ = NULL;
	gboolean _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	n_devices = 0;
	_tmp1_ = bluetooth_indicator_get_default_adapter (self, &_tmp0_);
	__vala_GtkTreeIter_free0 (adapter);
	adapter = _tmp0_;
	if (!_tmp1_) {
		result = -1;
		__vala_GtkTreeIter_free0 (adapter);
		return result;
	}
	_tmp2_ = self->priv->model;
	_tmp3_ = adapter;
	_tmp5_ = gtk_tree_model_iter_children (_tmp2_, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	if (!_tmp5_) {
		result = 0;
		__vala_GtkTreeIter_free0 (adapter);
		return result;
	}
	while (TRUE) {
		gboolean con = FALSE;
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		gboolean _tmp8_ = FALSE;
		GtkTreeModel* _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = self->priv->model;
		_tmp7_ = iter;
		gtk_tree_model_get (_tmp6_, &_tmp7_, BLUETOOTH_COLUMN_CONNECTED, &_tmp8_, -1, -1);
		con = _tmp8_;
		if (con) {
			gint _tmp9_;
			_tmp9_ = n_devices;
			n_devices = _tmp9_ + 1;
		}
		_tmp10_ = self->priv->model;
		_tmp11_ = gtk_tree_model_iter_next (_tmp10_, &iter);
		if (!_tmp11_) {
			break;
		}
	}
	result = n_devices;
	__vala_GtkTreeIter_free0 (adapter);
	return result;
}

static void
bluetooth_indicator_resync (BluetoothIndicator* self)
{
	gint n_devices = 0;
	gchar* lbl = NULL;
	Rfkill* _tmp0_;
	GtkImage* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	n_devices = bluetooth_indicator_get_n_devices (self);
	lbl = NULL;
	_tmp0_ = self->priv->killer;
	if (_tmp0_ != NULL) {
		Rfkill* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->killer;
		_tmp2_ = rfkill_get_BluetoothAirplaneMode (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			GtkImage* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = self->image;
			gtk_image_set_from_icon_name (_tmp4_, "bluetooth-disabled-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
			_tmp5_ = g_strdup (_ ("Bluetooth is disabled"));
			_g_free0 (lbl);
			lbl = _tmp5_;
			n_devices = 0;
		} else {
			GtkImage* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = self->image;
			gtk_image_set_from_icon_name (_tmp6_, "bluetooth-active-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
			_tmp7_ = g_strdup (_ ("Bluetooth is active"));
			_g_free0 (lbl);
			lbl = _tmp7_;
		}
	}
	if (n_devices > 0) {
		gchar* _tmp8_;
		GtkButton* _tmp9_;
		_tmp8_ = g_strdup_printf (ngettext ("Connected to %d device", "Connected to %d devices", (gulong) n_devices), n_devices);
		_g_free0 (lbl);
		lbl = _tmp8_;
		_tmp9_ = self->priv->send_to;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, TRUE);
	} else {
		if (n_devices < 0) {
			gtk_widget_hide ((GtkWidget*) self);
			_g_free0 (lbl);
			return;
		} else {
			GtkButton* _tmp10_;
			_tmp10_ = self->priv->send_to;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
		}
	}
	gtk_widget_show ((GtkWidget*) self);
	_tmp11_ = self->image;
	_tmp12_ = lbl;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, _tmp12_);
	_g_free0 (lbl);
}

static void
bluetooth_indicator_on_settings_activate (BluetoothIndicator* self)
{
	BudgiePopover* _tmp0_;
	GDesktopAppInfo* app_info = NULL;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = g_desktop_app_info_new ("budgie-bluetooth-panel.desktop");
	app_info = _tmp1_;
	_tmp2_ = app_info;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (app_info);
		return;
	}
	{
		GDesktopAppInfo* _tmp3_;
		_tmp3_ = app_info;
		g_app_info_launch ((GAppInfo*) _tmp3_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_message ("BluetoothIndicator.vala:206: Unable to launch budgie-bluetooth-panel.d" \
"esktop: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (app_info);
}

static void
bluetooth_indicator_on_send_file (BluetoothIndicator* self)
{
	BudgiePopover* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	{
		GAppInfo* app_info = NULL;
		GAppInfo* _tmp1_;
		GAppInfo* _tmp2_;
		_tmp1_ = g_app_info_create_from_commandline ("bluetooth-sendto", "Bluetooth Transfer", G_APP_INFO_CREATE_NONE, &_inner_error0_);
		app_info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = app_info;
		if (_tmp2_ == NULL) {
			_g_object_unref0 (app_info);
			return;
		}
		{
			GAppInfo* _tmp3_;
			_tmp3_ = app_info;
			g_app_info_launch (_tmp3_, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_message ("BluetoothIndicator.vala:222: Unable to launch bluetooth-sendto: %s", _tmp5_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (app_info);
			goto __catch0_g_error;
		}
		_g_object_unref0 (app_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_message ("BluetoothIndicator.vala:225: Unable to create bluetooth-sendto AppInfo" \
": %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
bluetooth_indicator_on_set_airplane (BluetoothIndicator* self)
{
	gboolean s = FALSE;
	GtkCheckButton* _tmp0_;
	BudgiePopover* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->radio_airplane;
	s = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	{
		Rfkill* _tmp1_;
		_tmp1_ = self->priv->killer;
		rfkill_set_BluetoothAirplaneMode (_tmp1_, s);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_message ("BluetoothIndicator.vala:236: Error setting airplane mode: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = self->popover;
	gtk_widget_hide ((GtkWidget*) _tmp4_);
}

static void
bluetooth_indicator_on_airplane_change (BluetoothIndicator* self)
{
	GtkCheckButton* _tmp0_;
	GtkCheckButton* _tmp1_;
	Rfkill* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkCheckButton* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->radio_airplane;
	g_signal_handler_block (_tmp0_, self->priv->radio_id);
	_tmp1_ = self->priv->radio_airplane;
	_tmp2_ = self->priv->killer;
	_tmp3_ = rfkill_get_BluetoothAirplaneMode (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp1_, _tmp4_);
	_tmp5_ = self->priv->radio_airplane;
	g_signal_handler_unblock (_tmp5_, self->priv->radio_id);
	bluetooth_indicator_resync (self);
}

static void
_bluetooth_indicator_on_airplane_change_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                           GVariant* changed_properties,
                                                                           gchar** invalidated_properties,
                                                                           gpointer self)
{
	bluetooth_indicator_on_airplane_change ((BluetoothIndicator*) self);
}

static void
bluetooth_indicator_sync_rfkill (BluetoothIndicator* self)
{
	Rfkill* _tmp0_;
	GDBusProxy* _tmp1_;
	GDBusProxy* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->killer;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_dbus_proxy_get_type ()) ? ((GDBusProxy*) _tmp0_) : NULL);
	_g_object_unref0 (self->priv->db);
	self->priv->db = _tmp1_;
	_tmp2_ = self->priv->db;
	g_signal_connect_object (_tmp2_, "g-properties-changed", (GCallback) _bluetooth_indicator_on_airplane_change_g_dbus_proxy_g_properties_changed, self, 0);
	bluetooth_indicator_resync (self);
	bluetooth_indicator_on_airplane_change (self);
}

static void
bluetooth_indicator_class_init (BluetoothIndicatorClass * klass,
                                gpointer klass_data)
{
	bluetooth_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothIndicator_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bluetooth_indicator_finalize;
}

static void
bluetooth_indicator_instance_init (BluetoothIndicator * self,
                                   gpointer klass)
{
	self->priv = bluetooth_indicator_get_instance_private (self);
	self->image = NULL;
	self->ebox = NULL;
	self->priv->client = NULL;
	self->priv->model = NULL;
	self->popover = NULL;
	self->priv->killer = NULL;
	self->priv->db = NULL;
}

static void
bluetooth_indicator_finalize (GObject * obj)
{
	BluetoothIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLUETOOTH_INDICATOR, BluetoothIndicator);
	_g_object_unref0 (self->image);
	_g_object_unref0 (self->ebox);
	_g_object_unref0 (self->priv->client);
	_g_object_unref0 (self->priv->model);
	_g_object_unref0 (self->popover);
	_g_object_unref0 (self->priv->killer);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->radio_airplane);
	_g_object_unref0 (self->priv->send_to);
	G_OBJECT_CLASS (bluetooth_indicator_parent_class)->finalize (obj);
}

GType
bluetooth_indicator_get_type (void)
{
	return bluetooth_indicator_type_id;
}

GType
bluetooth_indicator_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothIndicator), 0, (GInstanceInitFunc) bluetooth_indicator_instance_init, NULL };
	bluetooth_indicator_type_id = g_type_module_register_type (module, gtk_bin_get_type (), "BluetoothIndicator", &g_define_type_info, 0);
	BluetoothIndicator_private_offset = sizeof (BluetoothIndicatorPrivate);
	return bluetooth_indicator_type_id;
}

