/* MprisGui.c generated by valac 0.56.2, the Vala compiler
 * generated from MprisGui.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include "raven.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <pango/pango.h>

#define BACKGROUND_SIZE 250

enum  {
	CLIENT_IMAGE_0_PROPERTY,
	CLIENT_IMAGE_NUM_PROPERTIES
};
static GParamSpec* client_image_properties[CLIENT_IMAGE_NUM_PROPERTIES];
enum  {
	CLIENT_WIDGET_0_PROPERTY,
	CLIENT_WIDGET_NUM_PROPERTIES
};
static GParamSpec* client_widget_properties[CLIENT_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _ClientWidgetDownloadArtData ClientWidgetDownloadArtData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _ClientWidgetPrivate {
	BudgieRavenExpander* player_revealer;
	GtkImage* background;
	GtkEventBox* background_wrap;
	MprisClient* client;
	GtkLabel* title_label;
	GtkLabel* artist_label;
	GtkLabel* album_label;
	GtkButton* prev_btn;
	GtkButton* play_btn;
	GtkButton* next_btn;
	gchar* filename;
	GCancellable* cancel;
	gint our_width;
	BudgieHeaderWidget* header;
};

struct _Block1Data {
	int _ref_count_;
	ClientWidget* self;
	MprisClient* client;
};

struct _ClientWidgetDownloadArtData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ClientWidget* self;
	gchar* uri;
	gchar* proper_uri;
	gchar* _tmp0_;
	GFile* art_file;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFileInputStream* ins;
	GFile* _tmp3_;
	GCancellable* _tmp4_;
	GFileInputStream* _tmp5_;
	GdkPixbuf* pbuf;
	GFileInputStream* _tmp6_;
	GCancellable* _tmp7_;
	GdkPixbuf* _tmp8_;
	GtkImage* _tmp9_;
	GdkPixbuf* _tmp10_;
	GtkStyleContext* _tmp11_;
	GError* _inner_error0_;
};

static gpointer client_image_parent_class = NULL;
static gint ClientWidget_private_offset;
static gpointer client_widget_parent_class = NULL;

static GType client_image_get_type_once (void);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda10_ (Block1Data* _data1_);
static void ___lambda11_ (Block1Data* _data1_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda11__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda10__budgie_header_widget_closed (BudgieHeaderWidget* _sender,
                                               gpointer self);
static gboolean client_widget_on_raise_player (ClientWidget* self);
static gboolean _client_widget_on_raise_player_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self);
static void __lambda13_ (Block1Data* _data1_);
static void ___lambda14_ (Block1Data* _data1_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda14__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda13__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda15_ (Block1Data* _data1_);
static void __lambda16_ (Block1Data* _data1_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda16__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ___lambda15__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda17_ (Block1Data* _data1_);
static void ___lambda18_ (Block1Data* _data1_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda18__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda17__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void client_widget_update_play_status (ClientWidget* self);
static void client_widget_update_controls (ClientWidget* self);
static void __lambda19_ (ClientWidget* self,
                  const gchar* i,
                  GHashTable* p,
                  gchar** inv,
                  gint inv_length1);
static void ___lambda20_ (ClientWidget* self,
                   const gchar* k,
                   GVariant* v);
static void ____lambda20__gh_func (gconstpointer key,
                            gconstpointer value,
                            gpointer self);
static void ___lambda19__dbus_prop_iface_properties_changed (DbusPropIface* _sender,
                                                      const gchar* iface,
                                                      GHashTable* changed,
                                                      gchar** invalid,
                                                      gint invalid_length1,
                                                      gpointer self);
static void client_widget_update_art (ClientWidget* self,
                               const gchar* uri,
                               gboolean force_reload);
static void __lambda12_ (ClientWidget* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda12__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void client_widget_download_art (ClientWidget* self,
                                 const gchar* uri,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void client_widget_download_art_finish (ClientWidget* self,
                                        GAsyncResult* _res_);
static void client_widget_update_art_fallback (ClientWidget* self);
static void client_widget_download_art_data_free (gpointer _data);
static gboolean client_widget_download_art_co (ClientWidgetDownloadArtData* _data_);
static void client_widget_download_art_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static gchar* client_widget_get_meta_string (ClientWidget* self,
                                      const gchar* key,
                                      const gchar* fallback);
static void client_widget_finalize (GObject * obj);
static GType client_widget_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

ClientImage*
client_image_construct_from_pixbuf (GType object_type,
                                    GdkPixbuf* pbuf)
{
	ClientImage * self = NULL;
	g_return_val_if_fail (pbuf != NULL, NULL);
	self = (ClientImage*) g_object_new (object_type, "pixbuf", pbuf, NULL);
	return self;
}

ClientImage*
client_image_new_from_pixbuf (GdkPixbuf* pbuf)
{
	return client_image_construct_from_pixbuf (TYPE_CLIENT_IMAGE, pbuf);
}

ClientImage*
client_image_construct_from_icon_name (GType object_type,
                                       const gchar* icon_name,
                                       GtkIconSize size)
{
	ClientImage * self = NULL;
	g_return_val_if_fail (icon_name != NULL, NULL);
	self = (ClientImage*) g_object_new (object_type, "icon-name", icon_name, "icon-size", size, NULL);
	return self;
}

ClientImage*
client_image_new_from_icon_name (const gchar* icon_name,
                                 GtkIconSize size)
{
	return client_image_construct_from_icon_name (TYPE_CLIENT_IMAGE, icon_name, size);
}

ClientImage*
client_image_construct (GType object_type)
{
	ClientImage * self = NULL;
	self = (ClientImage*) g_object_new (object_type, NULL);
	return self;
}

ClientImage*
client_image_new (void)
{
	return client_image_construct (TYPE_CLIENT_IMAGE);
}

static void
client_image_class_init (ClientImageClass * klass,
                         gpointer klass_data)
{
	client_image_parent_class = g_type_class_peek_parent (klass);
}

static void
client_image_instance_init (ClientImage * self,
                            gpointer klass)
{
}

/**
 * A fancier Gtk.Image, which forces a fade-effect across the bottom of the image
 * making it easier to use/see the overlayed playback controls within the ClientWidget
 */
static GType
client_image_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClientImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) client_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClientImage), 0, (GInstanceInitFunc) client_image_instance_init, NULL };
	GType client_image_type_id;
	client_image_type_id = g_type_register_static (gtk_image_get_type (), "ClientImage", &g_define_type_info, 0);
	return client_image_type_id;
}

GType
client_image_get_type (void)
{
	static volatile gsize client_image_type_id__once = 0;
	if (g_once_init_enter (&client_image_type_id__once)) {
		GType client_image_type_id;
		client_image_type_id = client_image_get_type_once ();
		g_once_init_leave (&client_image_type_id__once, client_image_type_id);
	}
	return client_image_type_id__once;
}

static inline gpointer
client_widget_get_instance_private (ClientWidget* self)
{
	return G_STRUCT_MEMBER_P (self, ClientWidget_private_offset);
}

/**
 * Create a new ClientWidget
 *
 * @param client The underlying MprisClient instance to use
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ClientWidget* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->client);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda11_ (Block1Data* _data1_,
              GObject* obj,
              GAsyncResult* res)
{
	ClientWidget* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		{
			PlayerIface* _tmp0_;
			PlayerIface* _tmp1_;
			_tmp0_ = mpris_client_get_player (_data1_->client);
			_tmp1_ = _tmp0_;
			mpris_iface_quit_finish ((MprisIface*) _tmp1_, res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			GError* e = NULL;
			PlayerIface* _tmp2_;
			PlayerIface* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = mpris_client_get_player (_data1_->client);
			_tmp3_ = _tmp2_;
			_tmp4_ = mpris_iface_get_identity ((MprisIface*) _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_warning ("MprisGui.vala:75: Error closing %s: %s", _tmp6_, _tmp8_);
			_g_free0 (_tmp6_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		PlayerIface* _tmp9_;
		PlayerIface* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = mpris_client_get_player (_data1_->client);
		_tmp10_ = _tmp9_;
		_tmp11_ = mpris_iface_get_identity ((MprisIface*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("MprisGui.vala:78: Error closing %s: %s", _tmp13_, _tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda11__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda11_ (self, source_object, res);
	block1_data_unref (self);
}

static void
__lambda10_ (Block1Data* _data1_)
{
	ClientWidget* self;
	PlayerIface* _tmp0_;
	PlayerIface* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data1_->self;
	_tmp0_ = mpris_client_get_player (_data1_->client);
	_tmp1_ = _tmp0_;
	_tmp2_ = mpris_iface_get_can_quit ((MprisIface*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		PlayerIface* _tmp4_;
		PlayerIface* _tmp5_;
		_tmp4_ = mpris_client_get_player (_data1_->client);
		_tmp5_ = _tmp4_;
		mpris_iface_quit ((MprisIface*) _tmp5_, ____lambda11__gasync_ready_callback, block1_data_ref (_data1_));
	}
}

static void
___lambda10__budgie_header_widget_closed (BudgieHeaderWidget* _sender,
                                          gpointer self)
{
	__lambda10_ (self);
}

static gboolean
_client_widget_on_raise_player_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                GdkEventButton* event,
                                                                gpointer self)
{
	gboolean result;
	result = client_widget_on_raise_player ((ClientWidget*) self);
	return result;
}

static void
___lambda14_ (Block1Data* _data1_,
              GObject* obj,
              GAsyncResult* res)
{
	ClientWidget* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		{
			PlayerIface* _tmp0_;
			PlayerIface* _tmp1_;
			_tmp0_ = mpris_client_get_player (_data1_->client);
			_tmp1_ = _tmp0_;
			player_iface_previous_finish (_tmp1_, res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			GError* e = NULL;
			PlayerIface* _tmp2_;
			PlayerIface* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = mpris_client_get_player (_data1_->client);
			_tmp3_ = _tmp2_;
			_tmp4_ = mpris_iface_get_identity ((MprisIface*) _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_warning ("MprisGui.vala:139: Error going to the previous track %s: %s", _tmp6_, _tmp8_);
			_g_free0 (_tmp6_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		PlayerIface* _tmp9_;
		PlayerIface* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = mpris_client_get_player (_data1_->client);
		_tmp10_ = _tmp9_;
		_tmp11_ = mpris_iface_get_identity ((MprisIface*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("MprisGui.vala:142: Error going to the previous track %s: %s", _tmp13_, _tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda14__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda14_ (self, source_object, res);
	block1_data_unref (self);
}

static void
__lambda13_ (Block1Data* _data1_)
{
	ClientWidget* self;
	PlayerIface* _tmp0_;
	PlayerIface* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data1_->self;
	_tmp0_ = mpris_client_get_player (_data1_->client);
	_tmp1_ = _tmp0_;
	_tmp2_ = player_iface_get_can_go_previous (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		PlayerIface* _tmp4_;
		PlayerIface* _tmp5_;
		_tmp4_ = mpris_client_get_player (_data1_->client);
		_tmp5_ = _tmp4_;
		player_iface_previous (_tmp5_, ____lambda14__gasync_ready_callback, block1_data_ref (_data1_));
	}
}

static void
___lambda13__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda13_ (self);
}

static void
__lambda16_ (Block1Data* _data1_,
             GObject* obj,
             GAsyncResult* res)
{
	ClientWidget* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		{
			PlayerIface* _tmp0_;
			PlayerIface* _tmp1_;
			_tmp0_ = mpris_client_get_player (_data1_->client);
			_tmp1_ = _tmp0_;
			player_iface_play_pause_finish (_tmp1_, res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			GError* e = NULL;
			PlayerIface* _tmp2_;
			PlayerIface* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = mpris_client_get_player (_data1_->client);
			_tmp3_ = _tmp2_;
			_tmp4_ = mpris_iface_get_identity ((MprisIface*) _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_warning ("MprisGui.vala:159: Error toggling play state %s: %s", _tmp6_, _tmp8_);
			_g_free0 (_tmp6_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		PlayerIface* _tmp9_;
		PlayerIface* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = mpris_client_get_player (_data1_->client);
		_tmp10_ = _tmp9_;
		_tmp11_ = mpris_iface_get_identity ((MprisIface*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("MprisGui.vala:162: Error toggling the play state %s: %s", _tmp13_, _tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda16__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda16_ (self, source_object, res);
	block1_data_unref (self);
}

static void
__lambda15_ (Block1Data* _data1_)
{
	ClientWidget* self;
	PlayerIface* _tmp0_;
	PlayerIface* _tmp1_;
	self = _data1_->self;
	_tmp0_ = mpris_client_get_player (_data1_->client);
	_tmp1_ = _tmp0_;
	player_iface_play_pause (_tmp1_, ___lambda16__gasync_ready_callback, block1_data_ref (_data1_));
}

static void
___lambda15__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda15_ (self);
}

static void
___lambda18_ (Block1Data* _data1_,
              GObject* obj,
              GAsyncResult* res)
{
	ClientWidget* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		{
			PlayerIface* _tmp0_;
			PlayerIface* _tmp1_;
			_tmp0_ = mpris_client_get_player (_data1_->client);
			_tmp1_ = _tmp0_;
			player_iface_next_finish (_tmp1_, res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			GError* e = NULL;
			PlayerIface* _tmp2_;
			PlayerIface* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = mpris_client_get_player (_data1_->client);
			_tmp3_ = _tmp2_;
			_tmp4_ = mpris_iface_get_identity ((MprisIface*) _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_warning ("MprisGui.vala:180: Error going to the next track %s: %s", _tmp6_, _tmp8_);
			_g_free0 (_tmp6_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		PlayerIface* _tmp9_;
		PlayerIface* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = mpris_client_get_player (_data1_->client);
		_tmp10_ = _tmp9_;
		_tmp11_ = mpris_iface_get_identity ((MprisIface*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("MprisGui.vala:183: Error going to the next track %s: %s", _tmp13_, _tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda18__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda18_ (self, source_object, res);
	block1_data_unref (self);
}

static void
__lambda17_ (Block1Data* _data1_)
{
	ClientWidget* self;
	PlayerIface* _tmp0_;
	PlayerIface* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data1_->self;
	_tmp0_ = mpris_client_get_player (_data1_->client);
	_tmp1_ = _tmp0_;
	_tmp2_ = player_iface_get_can_go_next (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		PlayerIface* _tmp4_;
		PlayerIface* _tmp5_;
		_tmp4_ = mpris_client_get_player (_data1_->client);
		_tmp5_ = _tmp4_;
		player_iface_next (_tmp5_, ____lambda18__gasync_ready_callback, block1_data_ref (_data1_));
	}
}

static void
___lambda17__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda17_ (self);
}

static void
___lambda20_ (ClientWidget* self,
              const gchar* k,
              GVariant* v)
{
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	if (g_strcmp0 (k, "Metadata") == 0) {
		client_widget_update_from_meta (self);
	} else {
		if (g_strcmp0 (k, "PlaybackStatus") == 0) {
			client_widget_update_play_status (self);
		} else {
			gboolean _tmp0_ = FALSE;
			if (g_strcmp0 (k, "CanGoNext") == 0) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = g_strcmp0 (k, "CanGoPrevious") == 0;
			}
			if (_tmp0_) {
				client_widget_update_controls (self);
			}
		}
	}
}

static void
____lambda20__gh_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	___lambda20_ ((ClientWidget*) self, (const gchar*) key, (GVariant*) value);
}

static void
__lambda19_ (ClientWidget* self,
             const gchar* i,
             GHashTable* p,
             gchar** inv,
             gint inv_length1)
{
	g_return_if_fail (i != NULL);
	g_return_if_fail (p != NULL);
	if (g_strcmp0 (i, "org.mpris.MediaPlayer2.Player") == 0) {
		g_hash_table_foreach (p, ____lambda20__gh_func, self);
	}
}

static void
___lambda19__dbus_prop_iface_properties_changed (DbusPropIface* _sender,
                                                 const gchar* iface,
                                                 GHashTable* changed,
                                                 gchar** invalid,
                                                 gint invalid_length1,
                                                 gpointer self)
{
	__lambda19_ ((ClientWidget*) self, iface, changed, invalid, invalid_length1);
}

ClientWidget*
client_widget_construct (GType object_type,
                         MprisClient* client,
                         gint width)
{
	ClientWidget * self = NULL;
	Block1Data* _data1_;
	MprisClient* _tmp0_;
	GtkWidget* row = NULL;
	GCancellable* _tmp1_;
	MprisClient* _tmp2_;
	PlayerIface* _tmp3_;
	PlayerIface* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	BudgieHeaderWidget* _tmp8_;
	BudgieHeaderWidget* _tmp9_;
	BudgieHeaderWidget* _tmp10_;
	BudgieRavenExpander* _tmp11_;
	BudgieRavenExpander* _tmp12_;
	GtkBox* player_box = NULL;
	GtkBox* _tmp13_;
	BudgieHeaderWidget* _tmp14_;
	PlayerIface* _tmp15_;
	PlayerIface* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	ClientImage* _tmp19_;
	GtkImage* _tmp20_;
	GtkEventBox* _tmp21_;
	GtkEventBox* _tmp22_;
	GtkImage* _tmp23_;
	GtkEventBox* _tmp24_;
	GtkOverlay* layout = NULL;
	GtkOverlay* _tmp25_;
	GtkBox* _tmp26_;
	GtkOverlay* _tmp27_;
	GtkOverlay* _tmp28_;
	GtkEventBox* _tmp29_;
	GtkBox* top_box = NULL;
	GtkBox* _tmp30_;
	GtkBox* _tmp31_;
	GtkBox* _tmp32_;
	GtkStyleContext* _tmp33_;
	GtkBox* box = NULL;
	GtkBox* _tmp34_;
	GtkBox* _tmp35_;
	GtkBox* _tmp36_;
	GtkBox* _tmp37_;
	GtkBox* _tmp38_;
	GtkBox* controls = NULL;
	GtkBox* _tmp39_;
	GtkBox* _tmp40_;
	GtkStyleContext* _tmp41_;
	GtkWidget* _tmp42_;
	GtkWidget* _tmp43_;
	gconstpointer _tmp44_;
	GtkLabel* _tmp45_;
	GtkBox* _tmp46_;
	GtkWidget* _tmp47_;
	GtkWidget* _tmp48_;
	GtkWidget* _tmp49_;
	gconstpointer _tmp50_;
	GtkLabel* _tmp51_;
	GtkBox* _tmp52_;
	GtkWidget* _tmp53_;
	GtkWidget* _tmp54_;
	GtkWidget* _tmp55_;
	gconstpointer _tmp56_;
	GtkLabel* _tmp57_;
	GtkBox* _tmp58_;
	GtkWidget* _tmp59_;
	GtkBox* _tmp60_;
	GtkBox* _tmp61_;
	GtkButton* btn = NULL;
	GtkButton* _tmp62_;
	GtkButton* _tmp63_;
	GtkButton* _tmp64_;
	GtkButton* _tmp65_;
	GtkButton* _tmp66_;
	GtkButton* _tmp67_;
	GtkButton* _tmp68_;
	GtkStyleContext* _tmp69_;
	GtkBox* _tmp70_;
	GtkButton* _tmp71_;
	GtkButton* _tmp72_;
	GtkButton* _tmp73_;
	GtkButton* _tmp74_;
	GtkButton* _tmp75_;
	GtkButton* _tmp76_;
	GtkButton* _tmp77_;
	GtkStyleContext* _tmp78_;
	GtkBox* _tmp79_;
	GtkButton* _tmp80_;
	GtkButton* _tmp81_;
	GtkButton* _tmp82_;
	GtkButton* _tmp83_;
	GtkButton* _tmp84_;
	GtkButton* _tmp85_;
	GtkButton* _tmp86_;
	GtkButton* _tmp87_;
	GtkStyleContext* _tmp88_;
	GtkBox* _tmp89_;
	GtkButton* _tmp90_;
	GtkBox* _tmp91_;
	GtkBox* _tmp92_;
	GtkOverlay* _tmp93_;
	GtkBox* _tmp94_;
	DbusPropIface* _tmp95_;
	DbusPropIface* _tmp96_;
	GtkBox* _tmp97_;
	GtkStyleContext* _tmp98_;
	gboolean _tmp99_ = FALSE;
	PlayerIface* _tmp100_;
	PlayerIface* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gboolean _tmp105_;
	GtkStyleContext* _tmp131_;
	BudgieRavenExpander* _tmp132_;
	GtkBox* _tmp133_;
	BudgieRavenExpander* _tmp134_;
	g_return_val_if_fail (client != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (client);
	_g_object_unref0 (_data1_->client);
	_data1_->client = _tmp0_;
	self = (ClientWidget*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 0, NULL);
	_data1_->self = g_object_ref (self);
	row = NULL;
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancel);
	self->priv->cancel = _tmp1_;
	self->priv->our_width = width;
	_tmp2_ = _g_object_ref0 (_data1_->client);
	_g_object_unref0 (self->priv->client);
	self->priv->client = _tmp2_;
	_tmp3_ = mpris_client_get_player (_data1_->client);
	_tmp4_ = _tmp3_;
	_tmp5_ = mpris_iface_get_identity ((MprisIface*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = budgie_header_widget_new (_tmp7_, "media-playback-pause-symbolic", FALSE, NULL, NULL);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp9_ = self->priv->header;
	g_signal_connect_data (_tmp9_, "closed", (GCallback) ___lambda10__budgie_header_widget_closed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp10_ = self->priv->header;
	_tmp11_ = budgie_raven_expander_new (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->player_revealer);
	self->priv->player_revealer = _tmp11_;
	_tmp12_ = self->priv->player_revealer;
	budgie_raven_expander_set_expanded (_tmp12_, TRUE);
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp13_);
	player_box = _tmp13_;
	_tmp14_ = self->priv->header;
	_tmp15_ = mpris_client_get_player (_data1_->client);
	_tmp16_ = _tmp15_;
	_tmp17_ = mpris_iface_get_can_quit ((MprisIface*) _tmp16_);
	_tmp18_ = _tmp17_;
	budgie_header_widget_set_can_close (_tmp14_, _tmp18_);
	_tmp19_ = client_image_new_from_icon_name ("emblem-music-symbolic", GTK_ICON_SIZE_INVALID);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = (GtkImage*) _tmp19_;
	_tmp20_ = self->priv->background;
	gtk_image_set_pixel_size (_tmp20_, self->priv->our_width);
	_tmp21_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->background_wrap);
	self->priv->background_wrap = _tmp21_;
	_tmp22_ = self->priv->background_wrap;
	_tmp23_ = self->priv->background;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->background_wrap;
	g_signal_connect_object ((GtkWidget*) _tmp24_, "button-release-event", (GCallback) _client_widget_on_raise_player_gtk_widget_button_release_event, self, 0);
	_tmp25_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp25_);
	layout = _tmp25_;
	_tmp26_ = player_box;
	_tmp27_ = layout;
	gtk_box_pack_start (_tmp26_, (GtkWidget*) _tmp27_, TRUE, TRUE, (guint) 0);
	_tmp28_ = layout;
	_tmp29_ = self->priv->background_wrap;
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp30_);
	top_box = _tmp30_;
	_tmp31_ = top_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp31_, GTK_ALIGN_END);
	_tmp32_ = top_box;
	_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) _tmp32_);
	gtk_style_context_add_class (_tmp33_, "raven-mpris");
	_tmp34_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_ref_sink (_tmp34_);
	box = _tmp34_;
	_tmp35_ = box;
	g_object_set ((GtkWidget*) _tmp35_, "margin", 6, NULL);
	_tmp36_ = box;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp36_, 12);
	_tmp37_ = top_box;
	_tmp38_ = box;
	gtk_box_pack_start (_tmp37_, (GtkWidget*) _tmp38_, TRUE, TRUE, (guint) 0);
	_tmp39_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp39_);
	controls = _tmp39_;
	_tmp40_ = controls;
	_tmp41_ = gtk_widget_get_style_context ((GtkWidget*) _tmp40_);
	gtk_style_context_add_class (_tmp41_, "raven-mpris-controls");
	_tmp42_ = create_row ("Unknown Artist", "user-info-symbolic", NULL);
	_g_object_unref0 (row);
	row = _tmp42_;
	_tmp43_ = row;
	_tmp44_ = g_object_get_data ((GObject*) _tmp43_, "label_item");
	_tmp45_ = _g_object_ref0 ((GtkLabel*) _tmp44_);
	_g_object_unref0 (self->priv->artist_label);
	self->priv->artist_label = _tmp45_;
	_tmp46_ = box;
	_tmp47_ = row;
	gtk_box_pack_start (_tmp46_, _tmp47_, FALSE, FALSE, (guint) 0);
	_tmp48_ = create_row ("Unknown Title", "emblem-music-symbolic", NULL);
	_g_object_unref0 (row);
	row = _tmp48_;
	_tmp49_ = row;
	_tmp50_ = g_object_get_data ((GObject*) _tmp49_, "label_item");
	_tmp51_ = _g_object_ref0 ((GtkLabel*) _tmp50_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp51_;
	_tmp52_ = box;
	_tmp53_ = row;
	gtk_box_pack_start (_tmp52_, _tmp53_, FALSE, FALSE, (guint) 0);
	_tmp54_ = create_row ("Unknown Album", "media-optical-symbolic", NULL);
	_g_object_unref0 (row);
	row = _tmp54_;
	_tmp55_ = row;
	_tmp56_ = g_object_get_data ((GObject*) _tmp55_, "label_item");
	_tmp57_ = _g_object_ref0 ((GtkLabel*) _tmp56_);
	_g_object_unref0 (self->priv->album_label);
	self->priv->album_label = _tmp57_;
	_tmp58_ = box;
	_tmp59_ = row;
	gtk_box_pack_start (_tmp58_, _tmp59_, FALSE, FALSE, (guint) 0);
	_tmp60_ = box;
	_tmp61_ = controls;
	gtk_box_pack_start (_tmp60_, (GtkWidget*) _tmp61_, FALSE, FALSE, (guint) 0);
	_tmp62_ = (GtkButton*) gtk_button_new_from_icon_name ("media-skip-backward-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp62_);
	btn = _tmp62_;
	_tmp63_ = btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp63_, FALSE);
	_tmp64_ = btn;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp64_, FALSE);
	_tmp65_ = btn;
	_tmp66_ = _g_object_ref0 (_tmp65_);
	_g_object_unref0 (self->priv->prev_btn);
	self->priv->prev_btn = _tmp66_;
	_tmp67_ = btn;
	g_signal_connect_data (_tmp67_, "clicked", (GCallback) ___lambda13__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp68_ = btn;
	_tmp69_ = gtk_widget_get_style_context ((GtkWidget*) _tmp68_);
	gtk_style_context_add_class (_tmp69_, "flat");
	_tmp70_ = controls;
	_tmp71_ = btn;
	gtk_box_pack_start (_tmp70_, (GtkWidget*) _tmp71_, FALSE, FALSE, (guint) 0);
	_tmp72_ = (GtkButton*) gtk_button_new_from_icon_name ("media-playback-start-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp72_);
	_g_object_unref0 (btn);
	btn = _tmp72_;
	_tmp73_ = btn;
	_tmp74_ = _g_object_ref0 (_tmp73_);
	_g_object_unref0 (self->priv->play_btn);
	self->priv->play_btn = _tmp74_;
	_tmp75_ = btn;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp75_, FALSE);
	_tmp76_ = btn;
	g_signal_connect_data (_tmp76_, "clicked", (GCallback) ___lambda15__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp77_ = btn;
	_tmp78_ = gtk_widget_get_style_context ((GtkWidget*) _tmp77_);
	gtk_style_context_add_class (_tmp78_, "flat");
	_tmp79_ = controls;
	_tmp80_ = btn;
	gtk_box_pack_start (_tmp79_, (GtkWidget*) _tmp80_, FALSE, FALSE, (guint) 0);
	_tmp81_ = (GtkButton*) gtk_button_new_from_icon_name ("media-skip-forward-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp81_);
	_g_object_unref0 (btn);
	btn = _tmp81_;
	_tmp82_ = btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp82_, FALSE);
	_tmp83_ = btn;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp83_, FALSE);
	_tmp84_ = btn;
	_tmp85_ = _g_object_ref0 (_tmp84_);
	_g_object_unref0 (self->priv->next_btn);
	self->priv->next_btn = _tmp85_;
	_tmp86_ = btn;
	g_signal_connect_data (_tmp86_, "clicked", (GCallback) ___lambda17__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp87_ = btn;
	_tmp88_ = gtk_widget_get_style_context ((GtkWidget*) _tmp87_);
	gtk_style_context_add_class (_tmp88_, "flat");
	_tmp89_ = controls;
	_tmp90_ = btn;
	gtk_box_pack_start (_tmp89_, (GtkWidget*) _tmp90_, FALSE, FALSE, (guint) 0);
	_tmp91_ = controls;
	gtk_widget_set_halign ((GtkWidget*) _tmp91_, GTK_ALIGN_CENTER);
	_tmp92_ = controls;
	gtk_widget_set_valign ((GtkWidget*) _tmp92_, GTK_ALIGN_END);
	_tmp93_ = layout;
	_tmp94_ = top_box;
	gtk_overlay_add_overlay (_tmp93_, (GtkWidget*) _tmp94_);
	client_widget_update_from_meta (self);
	client_widget_update_play_status (self);
	client_widget_update_controls (self);
	_tmp95_ = mpris_client_get_prop (_data1_->client);
	_tmp96_ = _tmp95_;
	g_signal_connect_object (_tmp96_, "properties-changed", (GCallback) ___lambda19__dbus_prop_iface_properties_changed, self, 0);
	_tmp97_ = player_box;
	_tmp98_ = gtk_widget_get_style_context ((GtkWidget*) _tmp97_);
	gtk_style_context_add_class (_tmp98_, "raven-background");
	_tmp100_ = mpris_client_get_player (_data1_->client);
	_tmp101_ = _tmp100_;
	_tmp102_ = mpris_iface_get_desktop_entry ((MprisIface*) _tmp101_);
	_tmp103_ = _tmp102_;
	_tmp104_ = _tmp103_;
	_tmp105_ = _tmp104_ != NULL;
	_g_free0 (_tmp104_);
	if (_tmp105_) {
		PlayerIface* _tmp106_;
		PlayerIface* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		gchar* _tmp110_;
		_tmp106_ = mpris_client_get_player (_data1_->client);
		_tmp107_ = _tmp106_;
		_tmp108_ = mpris_iface_get_desktop_entry ((MprisIface*) _tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = _tmp109_;
		_tmp99_ = g_strcmp0 (_tmp110_, "") != 0;
		_g_free0 (_tmp110_);
	} else {
		_tmp99_ = FALSE;
	}
	if (_tmp99_) {
		GtkStyleContext* _tmp111_;
		PlayerIface* _tmp112_;
		PlayerIface* _tmp113_;
		gchar* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		_tmp111_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp112_ = mpris_client_get_player (_data1_->client);
		_tmp113_ = _tmp112_;
		_tmp114_ = mpris_iface_get_desktop_entry ((MprisIface*) _tmp113_);
		_tmp115_ = _tmp114_;
		_tmp116_ = _tmp115_;
		gtk_style_context_add_class (_tmp111_, _tmp116_);
		_g_free0 (_tmp116_);
	} else {
		PlayerIface* _tmp117_;
		PlayerIface* _tmp118_;
		gchar* _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
		gboolean _tmp122_;
		_tmp117_ = mpris_client_get_player (_data1_->client);
		_tmp118_ = _tmp117_;
		_tmp119_ = mpris_iface_get_identity ((MprisIface*) _tmp118_);
		_tmp120_ = _tmp119_;
		_tmp121_ = _tmp120_;
		_tmp122_ = _tmp121_ != NULL;
		_g_free0 (_tmp121_);
		if (_tmp122_) {
			GtkStyleContext* _tmp123_;
			PlayerIface* _tmp124_;
			PlayerIface* _tmp125_;
			gchar* _tmp126_;
			gchar* _tmp127_;
			gchar* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			_tmp123_ = gtk_widget_get_style_context ((GtkWidget*) self);
			_tmp124_ = mpris_client_get_player (_data1_->client);
			_tmp125_ = _tmp124_;
			_tmp126_ = mpris_iface_get_identity ((MprisIface*) _tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = _tmp127_;
			_tmp129_ = g_utf8_strdown (_tmp128_, (gssize) -1);
			_tmp130_ = _tmp129_;
			gtk_style_context_add_class (_tmp123_, _tmp130_);
			_g_free0 (_tmp130_);
			_g_free0 (_tmp128_);
		}
	}
	_tmp131_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp131_, "mpris-widget");
	_tmp132_ = self->priv->player_revealer;
	_tmp133_ = player_box;
	gtk_container_add ((GtkContainer*) _tmp132_, (GtkWidget*) _tmp133_);
	_tmp134_ = self->priv->player_revealer;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp134_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (btn);
	_g_object_unref0 (controls);
	_g_object_unref0 (box);
	_g_object_unref0 (top_box);
	_g_object_unref0 (layout);
	_g_object_unref0 (player_box);
	_g_object_unref0 (row);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}

ClientWidget*
client_widget_new (MprisClient* client,
                   gint width)
{
	return client_widget_construct (TYPE_CLIENT_WIDGET, client, width);
}

void
client_widget_update_width (ClientWidget* self,
                            gint new_width)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->our_width = new_width;
	_tmp0_ = self->priv->filename;
	client_widget_update_art (self, _tmp0_, TRUE);
}

/**
 * You raise me up ...
 */
static void
__lambda12_ (ClientWidget* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		{
			MprisClient* _tmp0_;
			PlayerIface* _tmp1_;
			PlayerIface* _tmp2_;
			_tmp0_ = self->priv->client;
			_tmp1_ = mpris_client_get_player (_tmp0_);
			_tmp2_ = _tmp1_;
			mpris_iface_raise_finish ((MprisIface*) _tmp2_, res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			GError* e = NULL;
			MprisClient* _tmp3_;
			PlayerIface* _tmp4_;
			PlayerIface* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = self->priv->client;
			_tmp4_ = mpris_client_get_player (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = mpris_iface_get_identity ((MprisIface*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("MprisGui.vala:252: Error raising the client for %s: %s", _tmp8_, _tmp10_);
			_g_free0 (_tmp8_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		MprisClient* _tmp11_;
		PlayerIface* _tmp12_;
		PlayerIface* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = self->priv->client;
		_tmp12_ = mpris_client_get_player (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = mpris_iface_get_identity ((MprisIface*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("MprisGui.vala:255: Error raising the client for %s: %s", _tmp16_, _tmp18_);
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda12__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda12_ ((ClientWidget*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
client_widget_on_raise_player (ClientWidget* self)
{
	gboolean _tmp0_ = FALSE;
	MprisClient* _tmp1_;
	MprisClient* _tmp7_;
	PlayerIface* _tmp8_;
	PlayerIface* _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->client;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		MprisClient* _tmp2_;
		PlayerIface* _tmp3_;
		PlayerIface* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp2_ = self->priv->client;
		_tmp3_ = mpris_client_get_player (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = mpris_iface_get_can_raise ((MprisIface*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	}
	if (_tmp0_) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp7_ = self->priv->client;
	_tmp8_ = mpris_client_get_player (_tmp7_);
	_tmp9_ = _tmp8_;
	mpris_iface_raise ((MprisIface*) _tmp9_, ___lambda12__gasync_ready_callback, g_object_ref (self));
	result = GDK_EVENT_STOP;
	return result;
}

/**
 * Update play status based on player requirements
 */
static void
client_widget_update_play_status (ClientWidget* self)
{
	MprisClient* _tmp0_;
	PlayerIface* _tmp1_;
	PlayerIface* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->client;
	_tmp1_ = mpris_client_get_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = player_iface_get_playback_status (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	g_free (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("Playing")))) {
		switch (0) {
			default:
			{
				BudgieHeaderWidget* _tmp8_;
				BudgieHeaderWidget* _tmp9_;
				MprisClient* _tmp10_;
				PlayerIface* _tmp11_;
				PlayerIface* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				GtkButton* _tmp18_;
				GtkWidget* _tmp19_;
				_tmp8_ = self->priv->header;
				budgie_header_widget_set_icon_name (_tmp8_, "media-playback-start-symbolic");
				_tmp9_ = self->priv->header;
				_tmp10_ = self->priv->client;
				_tmp11_ = mpris_client_get_player (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = mpris_iface_get_identity ((MprisIface*) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strdup_printf ("%s - Playing", _tmp15_);
				_tmp17_ = _tmp16_;
				budgie_header_widget_set_text (_tmp9_, _tmp17_);
				_g_free0 (_tmp17_);
				_g_free0 (_tmp15_);
				_tmp18_ = self->priv->play_btn;
				_tmp19_ = gtk_button_get_image (_tmp18_);
				gtk_image_set_from_icon_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_image_get_type (), GtkImage), "media-playback-pause-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("Paused")))) {
		switch (0) {
			default:
			{
				BudgieHeaderWidget* _tmp20_;
				BudgieHeaderWidget* _tmp21_;
				MprisClient* _tmp22_;
				PlayerIface* _tmp23_;
				PlayerIface* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				GtkButton* _tmp30_;
				GtkWidget* _tmp31_;
				_tmp20_ = self->priv->header;
				budgie_header_widget_set_icon_name (_tmp20_, "media-playback-pause-symbolic");
				_tmp21_ = self->priv->header;
				_tmp22_ = self->priv->client;
				_tmp23_ = mpris_client_get_player (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = mpris_iface_get_identity ((MprisIface*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strdup_printf ("%s - Paused", _tmp27_);
				_tmp29_ = _tmp28_;
				budgie_header_widget_set_text (_tmp21_, _tmp29_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp27_);
				_tmp30_ = self->priv->play_btn;
				_tmp31_ = gtk_button_get_image (_tmp30_);
				gtk_image_set_from_icon_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_image_get_type (), GtkImage), "media-playback-start-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				BudgieHeaderWidget* _tmp32_;
				MprisClient* _tmp33_;
				PlayerIface* _tmp34_;
				PlayerIface* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				BudgieHeaderWidget* _tmp39_;
				GtkButton* _tmp40_;
				GtkWidget* _tmp41_;
				_tmp32_ = self->priv->header;
				_tmp33_ = self->priv->client;
				_tmp34_ = mpris_client_get_player (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = mpris_iface_get_identity ((MprisIface*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = _tmp37_;
				budgie_header_widget_set_text (_tmp32_, _tmp38_);
				_g_free0 (_tmp38_);
				_tmp39_ = self->priv->header;
				budgie_header_widget_set_icon_name (_tmp39_, "media-playback-stop-symbolic");
				_tmp40_ = self->priv->play_btn;
				_tmp41_ = gtk_button_get_image (_tmp40_);
				gtk_image_set_from_icon_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_image_get_type (), GtkImage), "media-playback-start-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
				break;
			}
		}
	}
}

/**
 * Update prev/next sensitivity based on player requirements
 */
static void
client_widget_update_controls (ClientWidget* self)
{
	GtkButton* _tmp0_;
	MprisClient* _tmp1_;
	PlayerIface* _tmp2_;
	PlayerIface* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GtkButton* _tmp6_;
	MprisClient* _tmp7_;
	PlayerIface* _tmp8_;
	PlayerIface* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prev_btn;
	_tmp1_ = self->priv->client;
	_tmp2_ = mpris_client_get_player (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = player_iface_get_can_go_previous (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp5_);
	_tmp6_ = self->priv->next_btn;
	_tmp7_ = self->priv->client;
	_tmp8_ = mpris_client_get_player (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = player_iface_get_can_go_next (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, _tmp11_);
}

/**
 * Utility, handle updating the album art
 */
static void
client_widget_update_art (ClientWidget* self,
                          const gchar* uri,
                          gboolean force_reload)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp1_ = self->priv->filename;
	if (g_strcmp0 (uri, _tmp1_) == 0) {
		_tmp0_ = !force_reload;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (g_str_has_prefix (uri, "http")) {
		GCancellable* _tmp2_;
		GCancellable* _tmp4_;
		_tmp2_ = self->priv->cancel;
		if (!g_cancellable_is_cancelled (_tmp2_)) {
			GCancellable* _tmp3_;
			_tmp3_ = self->priv->cancel;
			g_cancellable_cancel (_tmp3_);
		}
		_tmp4_ = self->priv->cancel;
		g_cancellable_reset (_tmp4_);
		client_widget_download_art (self, uri, NULL, NULL);
	} else {
		if (g_str_has_prefix (uri, "file://")) {
			gchar* fname = NULL;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp6_ = _tmp5_ = g_strsplit (uri, "file://", 0);
			_tmp7_ = _tmp6_;
			_tmp7__length1 = _vala_array_length (_tmp5_);
			_tmp8_ = _tmp7_[1];
			_tmp9_ = g_strdup (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
			fname = _tmp10_;
			{
				GdkPixbuf* pbuf = NULL;
				const gchar* _tmp11_;
				GdkPixbuf* _tmp12_;
				GtkImage* _tmp13_;
				GdkPixbuf* _tmp14_;
				GtkStyleContext* _tmp15_;
				_tmp11_ = fname;
				_tmp12_ = gdk_pixbuf_new_from_file_at_size (_tmp11_, self->priv->our_width, self->priv->our_width, &_inner_error0_);
				pbuf = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp13_ = self->priv->background;
				_tmp14_ = pbuf;
				gtk_image_set_from_pixbuf (_tmp13_, _tmp14_);
				_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) self);
				gtk_style_context_remove_class (_tmp15_, "no-album-art");
				_g_object_unref0 (pbuf);
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
				client_widget_update_art_fallback (self);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (fname);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_free0 (fname);
		} else {
			client_widget_update_art_fallback (self);
		}
	}
	_tmp16_ = g_strdup (uri);
	_g_free0 (self->priv->filename);
	self->priv->filename = _tmp16_;
}

static void
client_widget_update_art_fallback (ClientWidget* self)
{
	GtkStyleContext* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "no-album-art");
	_tmp1_ = self->priv->background;
	gtk_image_set_from_icon_name (_tmp1_, "emblem-music-symbolic", (GtkIconSize) GTK_ICON_SIZE_INVALID);
	_tmp2_ = self->priv->background;
	gtk_image_set_pixel_size (_tmp2_, self->priv->our_width);
}

static void
client_widget_download_art_data_free (gpointer _data)
{
	ClientWidgetDownloadArtData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (ClientWidgetDownloadArtData, _data_);
}

static void
client_widget_download_art (ClientWidget* self,
                            const gchar* uri,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	ClientWidgetDownloadArtData* _data_;
	ClientWidget* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (ClientWidgetDownloadArtData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, client_widget_download_art_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	client_widget_download_art_co (_data_);
}

static void
client_widget_download_art_finish (ClientWidget* self,
                                   GAsyncResult* _res_)
{
	ClientWidgetDownloadArtData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
 * Fetch the cover art asynchronously and set it as the background image
 */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
client_widget_download_art_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	ClientWidgetDownloadArtData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	client_widget_download_art_co (_data_);
}

static gboolean
client_widget_download_art_co (ClientWidgetDownloadArtData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = string_replace (_data_->uri, "https://open.spotify.com/image/", "https://i.scdn.co/image/");
	_data_->proper_uri = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->proper_uri;
		_data_->_tmp2_ = g_file_new_for_uri (_data_->_tmp1_);
		_data_->art_file = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->art_file;
		_data_->_tmp4_ = _data_->self->priv->cancel;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp3_, G_PRIORITY_DEFAULT, _data_->_tmp4_, client_widget_download_art_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = g_file_read_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		_data_->ins = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->art_file);
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->ins;
		_data_->_tmp7_ = _data_->self->priv->cancel;
		_data_->_state_ = 2;
		gdk_pixbuf_new_from_stream_at_scale_async ((GInputStream*) _data_->_tmp6_, _data_->self->priv->our_width, _data_->self->priv->our_width, TRUE, _data_->_tmp7_, client_widget_download_art_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->pbuf = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->ins);
			_g_object_unref0 (_data_->art_file);
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->self->priv->background;
		_data_->_tmp10_ = _data_->pbuf;
		gtk_image_set_from_pixbuf (_data_->_tmp9_, _data_->_tmp10_);
		_data_->_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _data_->self);
		gtk_style_context_remove_class (_data_->_tmp11_, "no-album-art");
		_g_object_unref0 (_data_->pbuf);
		_g_object_unref0 (_data_->ins);
		_g_object_unref0 (_data_->art_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		client_widget_update_art_fallback (_data_->self);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->proper_uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->proper_uri);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static gchar*
client_widget_get_meta_string (ClientWidget* self,
                               const gchar* key,
                               const gchar* fallback)
{
	MprisClient* _tmp0_;
	PlayerIface* _tmp1_;
	PlayerIface* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	gboolean _tmp6_;
	gchar* _tmp33_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (fallback != NULL, NULL);
	_tmp0_ = self->priv->client;
	_tmp1_ = mpris_client_get_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = player_iface_get_metadata (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_hash_table_contains (_tmp5_, key);
	_g_hash_table_unref0 (_tmp5_);
	if (_tmp6_) {
		GVariant* label = NULL;
		MprisClient* _tmp7_;
		PlayerIface* _tmp8_;
		PlayerIface* _tmp9_;
		GHashTable* _tmp10_;
		GHashTable* _tmp11_;
		GHashTable* _tmp12_;
		gconstpointer _tmp13_;
		GVariant* _tmp14_;
		GVariant* _tmp15_;
		gchar* lab = NULL;
		const GVariantType* type = NULL;
		GVariant* _tmp16_;
		const GVariantType* _tmp17_;
		const GVariantType* _tmp18_;
		const GVariantType* _tmp19_;
		gboolean _tmp30_ = FALSE;
		const gchar* _tmp31_;
		_tmp7_ = self->priv->client;
		_tmp8_ = mpris_client_get_player (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = player_iface_get_metadata (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = g_hash_table_lookup (_tmp12_, key);
		_tmp14_ = _g_variant_ref0 ((GVariant*) _tmp13_);
		_tmp15_ = _tmp14_;
		_g_hash_table_unref0 (_tmp12_);
		label = _tmp15_;
		lab = NULL;
		_tmp16_ = label;
		_tmp17_ = g_variant_get_type (_tmp16_);
		type = _tmp17_;
		_tmp18_ = type;
		_tmp19_ = G_VARIANT_TYPE_STRING;
		if (g_variant_type_is_subtype_of (_tmp18_, _tmp19_)) {
			GVariant* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp20_ = label;
			_tmp21_ = g_variant_get_string (_tmp20_, NULL);
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (lab);
			lab = _tmp22_;
		} else {
			const GVariantType* _tmp23_;
			const GVariantType* _tmp24_;
			_tmp23_ = type;
			_tmp24_ = G_VARIANT_TYPE_STRING_ARRAY;
			if (g_variant_type_is_subtype_of (_tmp23_, _tmp24_)) {
				gchar** vals = NULL;
				GVariant* _tmp25_;
				size_t _tmp26_ = 0;
				gchar** _tmp27_;
				gint vals_length1;
				gint _vals_size_;
				gchar** _tmp28_;
				gint _tmp28__length1;
				gchar* _tmp29_;
				_tmp25_ = label;
				_tmp27_ = g_variant_dup_strv (_tmp25_, &_tmp26_);
				vals = _tmp27_;
				vals_length1 = _tmp26_;
				_vals_size_ = vals_length1;
				_tmp28_ = vals;
				_tmp28__length1 = vals_length1;
				_tmp29_ = _vala_g_strjoinv (", ", _tmp28_, (gint) _tmp28__length1);
				_g_free0 (lab);
				lab = _tmp29_;
				vals = (_vala_array_free (vals, vals_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_tmp31_ = lab;
		if (_tmp31_ != NULL) {
			const gchar* _tmp32_;
			_tmp32_ = lab;
			_tmp30_ = g_strcmp0 (_tmp32_, "") != 0;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			result = lab;
			_g_variant_unref0 (label);
			return result;
		}
		_g_free0 (lab);
		_g_variant_unref0 (label);
	}
	_tmp33_ = g_strdup (fallback);
	result = _tmp33_;
	return result;
}

/**
 * Update display info such as artist, the background image, etc.
 */
void
client_widget_update_from_meta (ClientWidget* self)
{
	MprisClient* _tmp0_;
	PlayerIface* _tmp1_;
	PlayerIface* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	gboolean _tmp6_;
	MprisClient* _tmp7_;
	PlayerIface* _tmp8_;
	PlayerIface* _tmp9_;
	GHashTable* _tmp10_;
	GHashTable* _tmp11_;
	GHashTable* _tmp12_;
	gboolean _tmp13_;
	GtkLabel* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GtkLabel* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkLabel* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->client;
	_tmp1_ = mpris_client_get_player (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = player_iface_get_metadata (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ == NULL;
	_g_hash_table_unref0 (_tmp5_);
	if (_tmp6_) {
		return;
	}
	_tmp7_ = self->priv->client;
	_tmp8_ = mpris_client_get_player (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = player_iface_get_metadata (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = g_hash_table_contains (_tmp12_, "mpris:artUrl");
	_g_hash_table_unref0 (_tmp12_);
	if (_tmp13_) {
		gchar* url = NULL;
		MprisClient* _tmp14_;
		PlayerIface* _tmp15_;
		PlayerIface* _tmp16_;
		GHashTable* _tmp17_;
		GHashTable* _tmp18_;
		GHashTable* _tmp19_;
		gconstpointer _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp14_ = self->priv->client;
		_tmp15_ = mpris_client_get_player (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = player_iface_get_metadata (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp20_ = g_hash_table_lookup (_tmp19_, "mpris:artUrl");
		_tmp21_ = g_variant_get_string ((GVariant*) _tmp20_, NULL);
		_tmp22_ = g_strdup (_tmp21_);
		_tmp23_ = _tmp22_;
		_g_hash_table_unref0 (_tmp19_);
		url = _tmp23_;
		_tmp24_ = url;
		client_widget_update_art (self, _tmp24_, FALSE);
		_g_free0 (url);
	} else {
		client_widget_update_art_fallback (self);
	}
	_tmp25_ = self->priv->title_label;
	_tmp26_ = client_widget_get_meta_string (self, "xesam:title", "Unknown Title");
	_tmp27_ = _tmp26_;
	gtk_label_set_text (_tmp25_, _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = self->priv->album_label;
	_tmp29_ = client_widget_get_meta_string (self, "xesam:album", "Unknown Album");
	_tmp30_ = _tmp29_;
	gtk_label_set_text (_tmp28_, _tmp30_);
	_g_free0 (_tmp30_);
	_tmp31_ = self->priv->artist_label;
	_tmp32_ = client_widget_get_meta_string (self, "xesam:artist", "Unknown Artist");
	_tmp33_ = _tmp32_;
	gtk_label_set_text (_tmp31_, _tmp33_);
	_g_free0 (_tmp33_);
}

static void
client_widget_class_init (ClientWidgetClass * klass,
                          gpointer klass_data)
{
	client_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClientWidget_private_offset);
	G_OBJECT_CLASS (klass)->finalize = client_widget_finalize;
}

static void
client_widget_instance_init (ClientWidget * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	self->priv = client_widget_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->filename = _tmp0_;
	self->priv->our_width = BACKGROUND_SIZE;
	self->priv->header = NULL;
}

static void
client_widget_finalize (GObject * obj)
{
	ClientWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CLIENT_WIDGET, ClientWidget);
	_g_object_unref0 (self->priv->player_revealer);
	_g_object_unref0 (self->priv->background);
	_g_object_unref0 (self->priv->background_wrap);
	_g_object_unref0 (self->priv->client);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->artist_label);
	_g_object_unref0 (self->priv->album_label);
	_g_object_unref0 (self->priv->prev_btn);
	_g_object_unref0 (self->priv->play_btn);
	_g_object_unref0 (self->priv->next_btn);
	_g_free0 (self->priv->filename);
	_g_object_unref0 (self->priv->cancel);
	_g_object_unref0 (self->priv->header);
	G_OBJECT_CLASS (client_widget_parent_class)->finalize (obj);
}

/**
 * A ClientWidget is simply used to control and display information in a two-way
 * fashion with an underlying MPRIS provider (MediaPlayer2)
 * It is "designed" to be self contained and added to a large UI, enabling multiple
 * MPRIS clients to be controlled with multiple widgets
 */
static GType
client_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClientWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) client_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClientWidget), 0, (GInstanceInitFunc) client_widget_instance_init, NULL };
	GType client_widget_type_id;
	client_widget_type_id = g_type_register_static (gtk_box_get_type (), "ClientWidget", &g_define_type_info, 0);
	ClientWidget_private_offset = g_type_add_instance_private (client_widget_type_id, sizeof (ClientWidgetPrivate));
	return client_widget_type_id;
}

GType
client_widget_get_type (void)
{
	static volatile gsize client_widget_type_id__once = 0;
	if (g_once_init_enter (&client_widget_type_id__once)) {
		GType client_widget_type_id;
		client_widget_type_id = client_widget_get_type_once ();
		g_once_init_leave (&client_widget_type_id__once, client_widget_type_id);
	}
	return client_widget_type_id__once;
}

/**
 * Boring utility function, create an image/label row
 *
 * @param name Label to appear on row
 * @param icon Icon name to use, or NULL if using gicon
 * @param gicon A gicon to use, if not using icon
 *
 * @return A Gtk.Box with the boilerplate cruft out of the way
 */
GtkWidget*
create_row (const gchar* name,
            const gchar* icon,
            GIcon* gicon)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkImage* img = NULL;
	gboolean _tmp1_ = FALSE;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkBox* _tmp6_;
	GtkImage* _tmp7_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkLabel* _tmp11_;
	GtkBox* _tmp12_;
	GtkImage* _tmp13_;
	GtkImage* _tmp14_;
	GtkWidget* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	if (icon == NULL) {
		_tmp1_ = gicon != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkImage* _tmp2_;
		_tmp2_ = (GtkImage*) gtk_image_new_from_gicon (gicon, (GtkIconSize) GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (img);
		img = _tmp2_;
	} else {
		GtkImage* _tmp3_;
		_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name (icon, (GtkIconSize) GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (img);
		img = _tmp3_;
	}
	_tmp4_ = img;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 8);
	_tmp5_ = img;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp5_, 8);
	_tmp6_ = box;
	_tmp7_ = img;
	gtk_box_pack_start (_tmp6_, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
	_tmp8_ = (GtkLabel*) gtk_label_new (name);
	g_object_ref_sink (_tmp8_);
	label = _tmp8_;
	gtk_label_set_line_wrap (label, TRUE);
	gtk_label_set_line_wrap_mode (label, PANGO_WRAP_WORD);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	_tmp9_ = box;
	gtk_box_pack_start (_tmp9_, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	_tmp10_ = box;
	_tmp11_ = _g_object_ref0 (label);
	g_object_set_data_full ((GObject*) _tmp10_, "label_item", _tmp11_, g_object_unref);
	_tmp12_ = box;
	_tmp13_ = img;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	g_object_set_data_full ((GObject*) _tmp12_, "image_item", _tmp14_, g_object_unref);
	result = (GtkWidget*) box;
	_g_object_unref0 (label);
	_g_object_unref0 (img);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

