Object.defineProperty(exports, "__esModule", { value: true });
var hub_1 = require("@sentry/hub");
exports.TRACEPARENT_REGEXP = new RegExp('^[ \\t]*' + // whitespace
    '([0-9a-f]{32})?' + // trace_id
    '-?([0-9a-f]{16})?' + // span_id
    '-?([01])?' + // sampled
    '[ \\t]*$');
/**
 * Determines if tracing is currently enabled.
 *
 * Tracing is enabled when at least one of `tracesSampleRate` and `tracesSampler` is defined in the SDK config.
 */
function hasTracingEnabled(maybeOptions) {
    var client = hub_1.getCurrentHub().getClient();
    var options = maybeOptions || (client && client.getOptions());
    return !!options && ('tracesSampleRate' in options || 'tracesSampler' in options);
}
exports.hasTracingEnabled = hasTracingEnabled;
/**
 * Extract transaction context data from a `sentry-trace` header.
 *
 * @param traceparent Traceparent string
 *
 * @returns Object containing data from the header, or undefined if traceparent string is malformed
 */
function extractTraceparentData(traceparent) {
    var matches = traceparent.match(exports.TRACEPARENT_REGEXP);
    if (matches) {
        var parentSampled = void 0;
        if (matches[3] === '1') {
            parentSampled = true;
        }
        else if (matches[3] === '0') {
            parentSampled = false;
        }
        return {
            traceId: matches[1],
            parentSampled: parentSampled,
            parentSpanId: matches[2],
        };
    }
    return undefined;
}
exports.extractTraceparentData = extractTraceparentData;
/** Grabs active transaction off scope, if any */
function getActiveTransaction(maybeHub) {
    var hub = maybeHub || hub_1.getCurrentHub();
    var scope = hub.getScope();
    return scope && scope.getTransaction();
}
exports.getActiveTransaction = getActiveTransaction;
/**
 * Converts from milliseconds to seconds
 * @param time time in ms
 */
function msToSec(time) {
    return time / 1000;
}
exports.msToSec = msToSec;
/**
 * Converts from seconds to milliseconds
 * @param time time in seconds
 */
function secToMs(time) {
    return time * 1000;
}
exports.secToMs = secToMs;
// so it can be used in manual instrumentation without necessitating a hard dependency on @sentry/utils
var utils_1 = require("@sentry/utils");
exports.stripUrlQueryAndFragment = utils_1.stripUrlQueryAndFragment;
//# sourceMappingURL=utils.js.map