/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.Tile;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;

public class Fire
extends Canvas {
    private static final Random RND = new Random();
    private static final Image IMAGE = new Image(Tile.class.getResourceAsStream("fire.png"));
    private static final double HALF_WIDTH = IMAGE.getWidth() * 0.5;
    private static final double HALF_HEIGHT = IMAGE.getHeight() * 0.5;
    private static final int NO_OF_PARTICLES = 150;
    private double width;
    private double height;
    private boolean running = false;
    private GraphicsContext ctx = this.getGraphicsContext2D();
    private AnimationTimer timer;
    private static final int NO_OF_FIELDS = 9;
    private static final int ARRAY_LENGTH = 1350;
    private static final int X = 0;
    private static final int Y = 1;
    private static final int VX = 2;
    private static final int VY = 3;
    private static final int OPACITY = 4;
    private static final int SIZE = 5;
    private static final int LIFE = 6;
    private static final int REMAINING_LIFE = 7;
    private static final int ACTIVE = 8;
    private boolean particlesVisible = true;
    private boolean initialized = false;
    private double[] particles;

    public Fire() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.timer = new AnimationTimer(){

            public void handle(long NOW) {
                Fire.this.draw();
            }
        };
        this.setMouseTransparent(true);
        this.registerListeners();
    }

    public void init() {
        this.particles = new double[1350];
        int pos = 0;
        for (int i = 0; i < 141; ++i) {
            this.initParticle(pos);
            pos += 9;
        }
    }

    private void registerListeners() {
        this.widthProperty().addListener((o, ov, nv) -> {
            this.width = nv.doubleValue();
        });
        this.heightProperty().addListener((o, ov, nv) -> {
            this.height = nv.doubleValue();
        });
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        if (!this.initialized) {
            this.init();
        }
        this.timer.start();
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void initParticle(int POS) {
        this.particles[POS + 0] = RND.nextDouble() * this.width;
        this.particles[POS + 1] = this.height + HALF_HEIGHT;
        this.particles[POS + 2] = RND.nextDouble() * 2.0 - 1.0;
        this.particles[POS + 3] = -(RND.nextDouble() * 3.0);
        this.particles[POS + 4] = 1.0;
        this.particles[POS + 5] = RND.nextDouble() * 1.0 + 0.5;
        this.particles[POS + 6] = RND.nextDouble() * 20.0 + 40.0;
        this.particles[POS + 7] = this.particles[POS + 6];
        this.particles[POS + 8] = 1.0;
    }

    private void update(int POS) {
        if (this.particles[POS + 8] > 0.0) {
            this.particles[POS + 4] = this.particles[POS + 7] / this.particles[POS + 6] * 0.5;
            int n = POS + 0;
            this.particles[n] = this.particles[n] + this.particles[POS + 2];
            int n2 = POS + 1;
            this.particles[n2] = this.particles[n2] + this.particles[POS + 3];
            int n3 = POS + 7;
            this.particles[n3] = this.particles[n3] - 1.0;
            if (this.particles[POS + 7] < 0.0 || this.particles[POS + 5] < 0.0 || this.particles[POS + 4] < 0.01) {
                if (this.running) {
                    this.initParticle(POS);
                } else if (this.particles[POS + 4] < 0.0) {
                    this.particles[POS + 8] = 0.0;
                }
            }
        }
    }

    private void draw() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.particlesVisible = false;
        for (int pos = 0; pos < 150; pos += 9) {
            this.update(pos);
            if (this.particles[pos + 4] > 0.01) {
                this.particlesVisible = true;
            }
            this.ctx.save();
            this.ctx.translate(this.particles[pos + 0], this.particles[pos + 1]);
            this.ctx.scale(this.particles[pos + 5], this.particles[pos + 5]);
            this.ctx.translate(-HALF_WIDTH, -HALF_HEIGHT);
            this.ctx.setGlobalAlpha(this.particles[pos + 4]);
            this.ctx.drawImage(IMAGE, 0.0, 0.0);
            this.ctx.restore();
        }
        if (!this.particlesVisible) {
            this.timer.stop();
        }
    }
}

