/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mediathek.config.Konstanten;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.file.GetFile;
import mediathek.tool.NetUtils;
import mediathek.tool.http.MVHttpClient;
import mediathek.tool.models.TModel;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ListePsetVorlagen
extends ArrayList<String[]> {
    private static final String BS_WIN_32 = "Windows-32Bit";
    private static final String BS_WIN_64 = "Windows-64Bit";
    private static final String BS_LINUX = "Linux";
    private static final String BS_MAC = "Mac";
    public static final String[] BS = new String[]{"", "Windows-32Bit", "Windows-64Bit", "Linux", "Mac"};
    public static final String PGR = "Vorlage";
    public static final String PGR_NAME = "Name";
    public static final int PGR_NAME_NR = 0;
    public static final String PGR_BESCHREIBUNG = "Beschreibung";
    public static final int PGR_BESCHREIBUNG_NR = 1;
    public static final String PGR_VERSION = "Version";
    public static final int PGR_VERSION_NR = 2;
    public static final String PGR_BS = "Bs";
    public static final int PGR_BS_NR = 3;
    public static final String PGR_URL = "URL";
    public static final int PGR_URL_NR = 4;
    public static final String PGR_INFO = "Info";
    public static final int PGR_INFO_NR = 5;
    public static final int PGR_MAX_ELEM = 6;
    public static final String[] PGR_COLUMN_NAMES = new String[]{"Name", "Beschreibung", "Version", "Bs", "URL", "Info"};
    private static final Logger logger = LogManager.getLogger(ListePsetVorlagen.class);

    public TModel getTModel(String bs) {
        if (this.size() > 0) {
            Object[][] object;
            if (!bs.isEmpty()) {
                List tmp = this.stream().filter(aThi -> aThi[3].contains(bs)).collect(Collectors.toList());
                object = new String[tmp.size()][6];
                for (int i = 0; i < tmp.size(); ++i) {
                    object[i] = (String[])tmp.get(i);
                }
            } else {
                object = new String[this.size()][6];
                for (int i = 0; i < this.size(); ++i) {
                    object[i] = (String[])this.get(i);
                }
            }
            return new TModel(object, PGR_COLUMN_NAMES);
        }
        return new TModel(new Object[0][], PGR_COLUMN_NAMES);
    }

    @NotNull
    private static String getOperatingSystemString() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return BS_MAC;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return "Windows";
        }
        if (SystemUtils.IS_OS_LINUX) {
            return BS_LINUX;
        }
        return "";
    }

    public static ListePset getStandarset(JFrame parent, boolean replaceMuster) {
        ListePset listePset = null;
        String[] vorlage = null;
        ListePsetVorlagen listePsetVorlagen = new ListePsetVorlagen();
        if (listePsetVorlagen.loadListOfSets()) {
            for (String[] ar : listePsetVorlagen) {
                if (!ar[0].equalsIgnoreCase("Standardset " + ListePsetVorlagen.getOperatingSystemString())) continue;
                vorlage = ar;
                break;
            }
            if (vorlage != null && !vorlage[4].isEmpty() && (listePset = ListePsetVorlagen.importPsetFile((String)vorlage[4], true)) != null) {
                listePset.version = vorlage[2];
            }
        }
        if (listePset == null) {
            listePset = ListePsetVorlagen.importPset(GetFile.getLocalPsetTemplate(), true);
        }
        if (replaceMuster && listePset != null) {
            ListePset.progMusterErsetzen(parent, listePset);
        }
        return listePset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadListOfSets() {
        try {
            this.clear();
            XMLStreamReader parser = null;
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            HttpUrl url = Konstanten.URL_MEDIATHEKVIEW_RESOURCES.resolve("programmgruppen13/programmgruppen.xml");
            assert (url != null);
            Request request = new Request.Builder().url(url).get().build();
            try (Response response = MVHttpClient.getInstance().getReducedTimeOutClient().newCall(request).execute();
                 ResponseBody body = response.body();){
                if (response.isSuccessful() && body != null) {
                    try (InputStream is = body.byteStream();
                         InputStreamReader inReader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                        parser = inFactory.createXMLStreamReader(inReader);
                        while (parser.hasNext()) {
                            int event = parser.next();
                            if (event != 1 || !parser.getLocalName().equals(PGR)) continue;
                            String[] p = new String[6];
                            ListePsetVorlagen.get(parser, PGR, PGR_COLUMN_NAMES, p);
                            if (p[4].isEmpty()) continue;
                            this.add(p);
                        }
                        return true;
                    }
                    finally {
                        if (parser != null) {
                            parser.close();
                        }
                    }
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (ConnectException | UnknownHostException ignored) {
            return false;
        }
        catch (Exception ex) {
            logger.error("loadListOfSets()", (Throwable)ex);
            return false;
        }
    }

    public static ListePset importPsetFile(String dateiUrl, boolean log) {
        try {
            ListePset result;
            block37: {
                result = null;
                if (NetUtils.isUrl(dateiUrl)) {
                    Request request = new Request.Builder().url(dateiUrl).get().build();
                    try (Response response = MVHttpClient.getInstance().getReducedTimeOutClient().newCall(request).execute();
                         ResponseBody body = response.body();){
                        if (!response.isSuccessful() || body == null) break block37;
                        try (InputStream is = body.byteStream();
                             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
                            result = ListePsetVorlagen.importPset(isr, log);
                            break block37;
                        }
                    }
                }
                try (FileInputStream fis = new FileInputStream(dateiUrl);
                     InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
                    result = ListePsetVorlagen.importPset(isr, log);
                }
            }
            return result;
        }
        catch (Exception ex) {
            if (log) {
                logger.error("importPsetFile(..)", (Throwable)ex);
            }
            return null;
        }
    }

    public static ListePset importPsetText(String text, boolean log) {
        ListePset result = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(text.getBytes());
             InputStreamReader ir = new InputStreamReader(bais);){
            result = ListePsetVorlagen.importPset(ir, log);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ListePset importPset(InputStreamReader in, boolean log) {
        DatenPset datenPset = null;
        ListePset liste = new ListePset();
        XMLStreamReader parser = null;
        try {
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            parser = inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                switch (parser.getLocalName()) {
                    case "Programmset": {
                        datenPset = new DatenPset();
                        if (!ListePsetVorlagen.get(parser, "Programmset", DatenPset.XML_NAMES, datenPset.arr)) {
                            datenPset = null;
                            break;
                        }
                        if (datenPset.isEmpty()) break;
                        liste.add(datenPset);
                        break;
                    }
                    case "Programm": {
                        if (datenPset == null) break;
                        DatenProg datenProg = new DatenProg();
                        if (!ListePsetVorlagen.get(parser, "Programm", DatenProg.XML_NAMES, datenProg.arr)) break;
                        datenPset.addProg(datenProg);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (log) {
                logger.error("importPset", (Throwable)ex);
            }
            ListePset listePset = null;
            return listePset;
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (liste.isEmpty()) {
            return null;
        }
        return liste;
    }

    private static boolean get(XMLStreamReader parser, String xmlElem, String[] xmlNames, String[] strRet) {
        boolean ret = true;
        int maxElem = strRet.length;
        for (int i = 0; i < maxElem; ++i) {
            strRet[i] = "";
        }
        try {
            int event;
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (int i = 0; i < maxElem; ++i) {
                    if (!parser.getLocalName().equals(xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            ret = false;
            logger.error("get", (Throwable)ex);
        }
        return ret;
    }
}

