"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JwtAuthentication = void 0;

var _authentication_type = require("../authentication_type");

var _routes = require("./routes");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class JwtAuthentication extends _authentication_type.AuthenticationType {
  constructor(config, sessionStorageFactory, router, esClient, coreSetup, logger) {
    var _this$config$jwt;

    super(config, sessionStorageFactory, router, esClient, coreSetup, logger);

    _defineProperty(this, "type", 'jwt');

    _defineProperty(this, "authHeaderName", void 0);

    this.authHeaderName = ((_this$config$jwt = this.config.jwt) === null || _this$config$jwt === void 0 ? void 0 : _this$config$jwt.header.toLowerCase()) || 'authorization';
    this.init();
  }

  async init() {
    const routes = new _routes.JwtAuthRoutes(this.router, this.sessionStorageFactory);
    routes.setupRoutes();
  }

  getTokenFromUrlParam(request) {
    var _this$config$jwt2;

    const urlParamName = (_this$config$jwt2 = this.config.jwt) === null || _this$config$jwt2 === void 0 ? void 0 : _this$config$jwt2.url_param;

    if (urlParamName) {
      const token = request.url.searchParams.get('urlParamName');
      return token || undefined;
    }

    return undefined;
  }

  getBearerToken(request) {
    const token = this.getTokenFromUrlParam(request);

    if (token) {
      return `Bearer ${token}`;
    } // no token in url parameter, try to get token from header


    return request.headers[this.authHeaderName] || undefined;
  }

  requestIncludesAuthInfo(request) {
    var _this$config$jwt3;

    if (request.headers[this.authHeaderName]) {
      return true;
    }

    const urlParamName = (_this$config$jwt3 = this.config.jwt) === null || _this$config$jwt3 === void 0 ? void 0 : _this$config$jwt3.url_param;

    if (urlParamName && request.url.searchParams.get('urlParamName')) {
      return true;
    }

    return false;
  }

  getAdditionalAuthHeader(request) {
    const header = {};
    const token = this.getTokenFromUrlParam(request);

    if (token) {
      header[this.authHeaderName] = `Bearer ${token}`;
    }

    return header;
  }

  getCookie(request, authInfo) {
    return {
      username: authInfo.user_name,
      credentials: {
        authHeaderValue: this.getBearerToken(request)
      },
      authType: this.type,
      expiryTime: Date.now() + this.config.session.ttl
    };
  }

  async isValidCookie(cookie) {
    var _cookie$credentials;

    return cookie.authType === this.type && cookie.username && cookie.expiryTime && ((_cookie$credentials = cookie.credentials) === null || _cookie$credentials === void 0 ? void 0 : _cookie$credentials.authHeaderValue);
  }

  handleUnauthedRequest(request, response, toolkit) {
    return response.unauthorized();
  }

  buildAuthHeaderFromCookie(cookie) {
    var _cookie$credentials2;

    const header = {};
    const authHeaderValue = (_cookie$credentials2 = cookie.credentials) === null || _cookie$credentials2 === void 0 ? void 0 : _cookie$credentials2.authHeaderValue;

    if (authHeaderValue) {
      header[this.authHeaderName] = authHeaderValue;
    }

    return header;
  }

}

exports.JwtAuthentication = JwtAuthentication;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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