/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle.stagent;

import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.tools.profiler.CPUSampler;
import com.oracle.truffle.tools.profiler.HeapMonitor;
import com.oracle.truffle.tools.profiler.HeapSummary;
import com.oracle.truffle.tools.profiler.StackTraceEntry;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.polyglot.Engine;
import org.graalvm.visualvm.sampler.truffle.stagent.TruffleJMX;
import org.graalvm.visualvm.sampler.truffle.stagent.TruffleMBean;
import sun.misc.Unsafe;

public class Truffle
implements TruffleMBean {
    private static final String POLYGLOTENGINEIMPL_CLASS_NAME = "com.oracle.truffle.polyglot.PolyglotEngineImpl";
    private ThreadMXBean threadBean;
    private Method Engine_findActiveEngines;
    private Map engines;
    private Unsafe unsafe;
    private boolean trackFlags;
    private static final int COMPILED = 1;
    private static final int INLINED = 2;

    public Truffle(Unsafe u) {
        this.unsafe = u;
        this.threadBean = ManagementFactory.getThreadMXBean();
        this.Engine_findActiveEngines = this.getFindActiveEngines();
        if (this.Engine_findActiveEngines == null) {
            this.engines = this.getEngines();
            if (this.engines == null) {
                throw new IllegalStateException();
            }
        }
        try {
            for (CPUSampler stacks : this.getAllStackTracesInstances()) {
                if (!TruffleJMX.DEBUG) continue;
                System.out.println("Stacks " + stacks + " " + Integer.toHexString(System.identityHashCode(stacks)));
                System.out.println(this.threadDump(stacks));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Map<String, Object>[] dumpAllThreads() {
        try {
            Collection<CPUSampler> allThreads = this.getAllStackTracesInstances();
            ArrayList threads = new ArrayList(allThreads.size());
            for (CPUSampler stacks : allThreads) {
                Map all = stacks.takeSample();
                if (all == null) continue;
                for (Map.Entry entry : all.entrySet()) {
                    Thread t = (Thread)entry.getKey();
                    long tid = t.getId();
                    long threadCpuTime = this.threadBean.getThreadCpuTime(tid);
                    TruffleStackTrace stack = this.getStackTraceElements((List)entry.getValue());
                    String name = t.getName();
                    HashMap<String, Object> threadInfo = new HashMap<String, Object>();
                    threadInfo.put("stack", stack.stack);
                    if (this.trackFlags) {
                        threadInfo.put("flags", stack.flags);
                    }
                    threadInfo.put("name", name);
                    threadInfo.put("tid", tid);
                    threadInfo.put("threadCpuTime", threadCpuTime);
                    threads.add(threadInfo);
                }
            }
            return threads.toArray(new Map[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return new Map[0];
        }
    }

    private String threadDump(CPUSampler stacks) {
        Map all = stacks.takeSample();
        if (all == null) {
            return "Thread dump EMPTY";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Thread dump:\n");
        for (Map.Entry entry : all.entrySet()) {
            sb.append(((Thread)entry.getKey()).getName()).append('\n');
            if (entry.getValue() == null) {
                sb.append("  no information\n");
                continue;
            }
            for (StackTraceEntry stackTraceEntry : (List)entry.getValue()) {
                StackTraceElement stackTraceElement = stackTraceEntry.toStackTraceElement();
                sb.append("  ");
                sb.append(stackTraceElement.getClassName()).append('.').append(stackTraceElement.getMethodName());
                String fileName = stackTraceElement.getFileName();
                int lastSep = fileName.lastIndexOf(47);
                if (lastSep != -1) {
                    fileName = fileName.substring(lastSep + 1);
                }
                sb.append(" (").append(fileName).append(":").append(stackTraceElement.getLineNumber()).append(')');
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private Method getFindActiveEngines() {
        block4: {
            try {
                Method m = Engine.class.getDeclaredMethod("findActiveEngines", new Class[0]);
                m.setAccessible(true);
                return m;
            }
            catch (SecurityException ex) {
                Logger.getLogger(Truffle.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(Truffle.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                if (!TruffleJMX.DEBUG) break block4;
                Logger.getLogger(Truffle.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    private Map getEngines() {
        try {
            Class<?> POLY_CLASS = Class.forName(POLYGLOTENGINEIMPL_CLASS_NAME);
            Field f = POLY_CLASS.getDeclaredField("ENGINES");
            Object base = this.unsafe.staticFieldBase(f);
            return (Map)this.unsafe.getObject(base, this.unsafe.staticFieldOffset(f));
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Truffle.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(Truffle.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(Truffle.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private Collection<Engine> getAllEngineInstances() {
        try {
            if (this.Engine_findActiveEngines == null) {
                ArrayList<Engine> en = new ArrayList<Engine>();
                for (Object o : this.engines.keySet()) {
                    Field cf = TruffleJMX.getDeclaredField(o, "creatorApi", "api");
                    Engine e = (Engine)this.unsafe.getObject(o, this.unsafe.objectFieldOffset(cf));
                    en.add(e);
                }
                return en;
            }
            return (Collection)this.Engine_findActiveEngines.invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(Truffle.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Truffle.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(Truffle.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(Truffle.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(Truffle.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Collections.EMPTY_LIST;
    }

    private Collection<CPUSampler> getAllStackTracesInstances() {
        ArrayList<CPUSampler> allInstances = new ArrayList<CPUSampler>();
        Collection<Engine> all = this.getAllEngineInstances();
        for (Engine engine : all) {
            CPUSampler sampler;
            if (engine == null || (sampler = CPUSampler.find((Engine)engine)) == null) continue;
            allInstances.add(sampler);
        }
        return allInstances;
    }

    private TruffleStackTrace getStackTraceElements(List<StackTraceEntry> entries) {
        StackTraceElement[] stack = new StackTraceElement[entries.size()];
        byte[] flags = new byte[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            StackTraceEntry entry = entries.get(i);
            stack[i] = entry.toStackTraceElement();
            int n = i;
            flags[n] = (byte)(flags[n] | (entry.isCompiled() ? (byte)1 : 0));
            int n2 = i;
            flags[n2] = (byte)(flags[n2] | (entry.isInlined() ? 2 : 0));
            if (!TruffleJMX.DEBUG || flags[i] == 0) continue;
            System.out.println(stack[i] + " " + Integer.toHexString(flags[i]) + " " + entry.isInlined());
        }
        return new TruffleStackTrace(stack, flags);
    }

    @Override
    public boolean isStackTracesEnabled() {
        return !this.getAllStackTracesInstances().isEmpty();
    }

    private Collection<HeapMonitor> getAllHeapHistogramInstances() {
        ArrayList<HeapMonitor> allInstances = new ArrayList<HeapMonitor>();
        Collection<Engine> all = this.getAllEngineInstances();
        for (Engine engine : all) {
            HeapMonitor heapHisto;
            if (engine == null || (heapHisto = HeapMonitor.find((Engine)engine)) == null) continue;
            if (!heapHisto.isCollecting()) {
                heapHisto.setCollecting(true);
            }
            allInstances.add(heapHisto);
        }
        return allInstances;
    }

    @Override
    public Map<String, Object>[] heapHistogram() {
        Collection<HeapMonitor> all = this.getAllHeapHistogramInstances();
        for (HeapMonitor histo : all) {
            if (!histo.hasData()) continue;
            Map info = histo.takeMetaObjectSummary();
            try {
                return this.toMap(info);
            }
            catch (Throwable ex) {
                Logger.getLogger(Truffle.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return new Map[0];
    }

    @Override
    public boolean isHeapHistogramEnabled() {
        return !this.getAllHeapHistogramInstances().isEmpty();
    }

    Map<String, Object>[] toMap(Map<LanguageInfo, Map<String, HeapSummary>> summaries) throws NoSuchFieldException {
        ArrayList heapHisto = new ArrayList(summaries.size());
        for (Map.Entry<LanguageInfo, Map<String, HeapSummary>> objectsByLanguage : summaries.entrySet()) {
            String langId = this.getLanguageId(objectsByLanguage.getKey());
            for (Map.Entry<String, HeapSummary> objectsByMetaObject : objectsByLanguage.getValue().entrySet()) {
                HeapSummary mi = objectsByMetaObject.getValue();
                HashMap<String, Object> metaObjMap = new HashMap<String, Object>();
                metaObjMap.put("language", langId);
                metaObjMap.put("name", objectsByMetaObject.getKey());
                metaObjMap.put("allocatedInstancesCount", mi.getTotalInstances());
                metaObjMap.put("bytes", mi.getTotalBytes());
                metaObjMap.put("liveInstancesCount", mi.getAliveInstances());
                metaObjMap.put("liveBytes", mi.getAliveBytes());
                heapHisto.add(metaObjMap);
            }
        }
        return heapHisto.toArray(new Map[0]);
    }

    private String getLanguageId(Object lang) throws NoSuchFieldException, SecurityException {
        if (this.Engine_findActiveEngines != null) {
            return ((LanguageInfo)lang).getId();
        }
        Field f = lang.getClass().getDeclaredField("id");
        String lId = (String)this.unsafe.getObject(lang, this.unsafe.objectFieldOffset(f));
        return lId;
    }

    @Override
    public void setTrackFlags(boolean trackFlags) {
        this.trackFlags = trackFlags;
    }

    @Override
    public void setMode(String modeStr) {
        if ("ROOTS".equals(modeStr)) {
            this.setMode(CPUSampler.Mode.ROOTS);
        } else if ("EXCLUDE_INLINED_ROOTS".equals(modeStr)) {
            this.setMode(CPUSampler.Mode.STATEMENTS);
        } else if ("EXCLUDE_INLINED_ROOTS".equals(modeStr)) {
            this.setMode(CPUSampler.Mode.STATEMENTS);
        }
    }

    @Override
    public boolean isModeAvailable() {
        try {
            Class.forName("com.oracle.truffle.tools.profiler.CPUSampler$Mode");
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return true;
    }

    private void setMode(CPUSampler.Mode m) {
        Collection<Engine> all = this.getAllEngineInstances();
        for (Engine engine : all) {
            CPUSampler sampler;
            if (engine == null || (sampler = CPUSampler.find((Engine)engine)) == null) continue;
            sampler.setMode(m);
        }
    }

    private static class TruffleStackTrace {
        private StackTraceElement[] stack;
        private byte[] flags;

        private TruffleStackTrace(StackTraceElement[] stack, byte[] flags) {
            this.stack = stack;
            this.flags = flags;
        }
    }
}

