/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.exceptions.Unrescuable;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CheckForLJEInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.PopBlockFrameInstr;
import org.jruby.ir.instructions.PushBlockFrameInstr;
import org.jruby.ir.instructions.PushMethodFrameInstr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.RestoreBindingVisibilityInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SaveBindingVisibilityInstr;
import org.jruby.ir.instructions.ToggleBacktraceInstr;
import org.jruby.ir.instructions.boxing.AluInstr;
import org.jruby.ir.instructions.boxing.BoxBooleanInstr;
import org.jruby.ir.instructions.boxing.BoxFixnumInstr;
import org.jruby.ir.instructions.boxing.BoxFloatInstr;
import org.jruby.ir.instructions.boxing.BoxInstr;
import org.jruby.ir.instructions.boxing.UnboxInstr;
import org.jruby.ir.instructions.specialized.OneFixnumArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneFloatArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockNoResultCallInstr;
import org.jruby.ir.instructions.specialized.TwoOperandArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.ZeroOperandArgNoBlockCallInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.interpreter.Profiler;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UnboxedBoolean;
import org.jruby.ir.operands.UnboxedFixnum;
import org.jruby.ir.operands.UnboxedFloat;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpreterEngine {
    public IRubyObject interpret(ThreadContext context, Block block, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, Block blockArg) {
        return this.interpret(context, block, self2, interpreterContext, implClass, name2, IRubyObject.NULL_ARRAY, blockArg);
    }

    public IRubyObject interpret(ThreadContext context, Block block, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject arg1, Block blockArg) {
        return this.interpret(context, block, self2, interpreterContext, implClass, name2, new IRubyObject[]{arg1}, blockArg);
    }

    public IRubyObject interpret(ThreadContext context, Block block, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject arg1, IRubyObject arg2, Block blockArg) {
        return this.interpret(context, block, self2, interpreterContext, implClass, name2, new IRubyObject[]{arg1, arg2}, blockArg);
    }

    public IRubyObject interpret(ThreadContext context, Block block, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block blockArg) {
        return this.interpret(context, block, self2, interpreterContext, implClass, name2, new IRubyObject[]{arg1, arg2, arg3}, blockArg);
    }

    public IRubyObject interpret(ThreadContext context, Block block, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, Block blockArg) {
        return this.interpret(context, block, self2, interpreterContext, implClass, name2, new IRubyObject[]{arg1, arg2, arg3, arg4}, blockArg);
    }

    public IRubyObject interpret(ThreadContext context, Block block, IRubyObject self2, InterpreterContext interpreterContext, RubyModule implClass, String name2, IRubyObject[] args2, Block blockArg) {
        Instr[] instrs = interpreterContext.getInstructions();
        Object[] temp = interpreterContext.allocateTemporaryVariables();
        double[] floats = interpreterContext.allocateTemporaryFloatVariables();
        long[] fixnums = interpreterContext.allocateTemporaryFixnumVariables();
        boolean[] booleans = interpreterContext.allocateTemporaryBooleanVariables();
        int n = instrs.length;
        int ipc = 0;
        Throwable exception2 = null;
        boolean acceptsKeywordArgument = interpreterContext.receivesKeywordArguments();
        if (acceptsKeywordArgument) {
            args2 = IRRuntimeHelpers.frobnicateKwargsArgument(context, args2, interpreterContext.getRequiredArgsCount());
        }
        StaticScope currScope = interpreterContext.getStaticScope();
        DynamicScope currDynScope = context.getCurrentScope();
        boolean debug = IRRuntimeHelpers.isDebug();
        boolean profile = IRRuntimeHelpers.inProfileMode();
        Integer scopeVersion = profile ? Profiler.initProfiling(interpreterContext.getScope()) : 0;
        while (ipc < n) {
            Instr instr = instrs[ipc];
            Operation operation = instr.getOperation();
            if (debug) {
                Interpreter.LOG.info("I: {" + ipc + "} " + instr, new Object[0]);
                ++Interpreter.interpInstrsCount;
            } else if (profile) {
                Profiler.instrTick(operation);
                ++Interpreter.interpInstrsCount;
            }
            ++ipc;
            try {
                block1 : switch (operation.opClass) {
                    case INT_OP: {
                        InterpreterEngine.interpretIntOp((AluInstr)instr, operation, fixnums, booleans);
                        break;
                    }
                    case FLOAT_OP: {
                        InterpreterEngine.interpretFloatOp((AluInstr)instr, operation, floats, booleans);
                        break;
                    }
                    case ARG_OP: {
                        InterpreterEngine.receiveArg(context, instr, operation, args2, acceptsKeywordArgument, currDynScope, temp, exception2, blockArg);
                        break;
                    }
                    case CALL_OP: {
                        if (profile) {
                            Profiler.updateCallSite(instr, interpreterContext.getScope(), scopeVersion);
                        }
                        InterpreterEngine.processCall(context, instr, operation, currDynScope, currScope, temp, self2);
                        break;
                    }
                    case RET_OP: {
                        return InterpreterEngine.processReturnOp(context, block, instr, operation, currDynScope, temp, self2, currScope);
                    }
                    case BRANCH_OP: {
                        switch (operation) {
                            case JUMP: {
                                ipc = ((JumpInstr)instr).getJumpTarget().getTargetPC();
                                break block1;
                            }
                        }
                        ipc = instr.interpretAndGetNewIPC(context, currDynScope, currScope, self2, temp, ipc);
                        break;
                    }
                    case BOOK_KEEPING_OP: {
                        switch (operation) {
                            case PUSH_METHOD_BINDING: {
                                currDynScope = interpreterContext.newDynamicScope(context);
                                context.pushScope(currDynScope);
                                break block1;
                            }
                            case PUSH_BLOCK_BINDING: {
                                currDynScope = IRRuntimeHelpers.pushBlockDynamicScopeIfNeeded(context, block, interpreterContext.pushNewDynScope(), interpreterContext.reuseParentDynScope());
                                break block1;
                            }
                            case UPDATE_BLOCK_STATE: {
                                self2 = IRRuntimeHelpers.updateBlockState(block, self2);
                                break block1;
                            }
                            case PREPARE_NO_BLOCK_ARGS: {
                                args2 = IRRuntimeHelpers.prepareNoBlockArgs(context, block, args2);
                                break block1;
                            }
                            case PREPARE_SINGLE_BLOCK_ARG: {
                                args2 = IRRuntimeHelpers.prepareSingleBlockArgs(context, block, args2);
                                break block1;
                            }
                            case PREPARE_FIXED_BLOCK_ARGS: {
                                args2 = IRRuntimeHelpers.prepareFixedBlockArgs(context, block, args2);
                                break block1;
                            }
                            case PREPARE_BLOCK_ARGS: {
                                args2 = IRRuntimeHelpers.prepareBlockArgs(context, block, args2, acceptsKeywordArgument);
                                break block1;
                            }
                        }
                        InterpreterEngine.processBookKeepingOp(context, block, instr, operation, name2, args2, self2, blockArg, implClass, currDynScope, temp, currScope);
                        break;
                    }
                    case OTHER_OP: {
                        InterpreterEngine.processOtherOp(context, block, instr, operation, currDynScope, currScope, temp, self2, floats, fixnums, booleans);
                    }
                }
            }
            catch (Throwable t) {
                if (debug) {
                    InterpreterEngine.extractToMethodToAvoidC2Crash(instr, t);
                }
                ipc = ((FullInterpreterContext)interpreterContext).determineRPC(ipc);
                if (debug) {
                    Interpreter.LOG.info("in : " + interpreterContext.getScope() + ", caught Java throwable: " + t + "; excepting instr: " + instr, new Object[0]);
                    Interpreter.LOG.info("ipc for rescuer: " + ipc, new Object[0]);
                }
                if (ipc == -1) {
                    Helpers.throwException(t);
                    continue;
                }
                exception2 = t;
            }
        }
        throw context.runtime.newRuntimeError("BUG: interpreter fell through to end unexpectedly");
    }

    protected static void interpretIntOp(AluInstr instr, Operation op, long[] fixnums, boolean[] booleans) {
        TemporaryLocalVariable dst = (TemporaryLocalVariable)instr.getResult();
        long i1 = InterpreterEngine.getFixnumArg(fixnums, instr.getArg1());
        long i2 = InterpreterEngine.getFixnumArg(fixnums, instr.getArg2());
        switch (op) {
            case IADD: {
                InterpreterEngine.setFixnumVar(fixnums, dst, i1 + i2);
                break;
            }
            case ISUB: {
                InterpreterEngine.setFixnumVar(fixnums, dst, i1 - i2);
                break;
            }
            case IMUL: {
                InterpreterEngine.setFixnumVar(fixnums, dst, i1 * i2);
                break;
            }
            case IDIV: {
                InterpreterEngine.setFixnumVar(fixnums, dst, i1 / i2);
                break;
            }
            case IOR: {
                InterpreterEngine.setFixnumVar(fixnums, dst, i1 | i2);
                break;
            }
            case IAND: {
                InterpreterEngine.setFixnumVar(fixnums, dst, i1 & i2);
                break;
            }
            case IXOR: {
                InterpreterEngine.setFixnumVar(fixnums, dst, i1 ^ i2);
                break;
            }
            case ISHL: {
                InterpreterEngine.setFixnumVar(fixnums, dst, i1 << (int)i2);
                break;
            }
            case ISHR: {
                InterpreterEngine.setFixnumVar(fixnums, dst, i1 >> (int)i2);
                break;
            }
            case ILT: {
                InterpreterEngine.setBooleanVar(booleans, dst, i1 < i2);
                break;
            }
            case IGT: {
                InterpreterEngine.setBooleanVar(booleans, dst, i1 > i2);
                break;
            }
            case IEQ: {
                InterpreterEngine.setBooleanVar(booleans, dst, i1 == i2);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled int op: " + (Object)((Object)op) + " for instr " + instr);
            }
        }
    }

    protected static void interpretFloatOp(AluInstr instr, Operation op, double[] floats, boolean[] booleans) {
        TemporaryLocalVariable dst = (TemporaryLocalVariable)instr.getResult();
        double a1 = InterpreterEngine.getFloatArg(floats, instr.getArg1());
        double a2 = InterpreterEngine.getFloatArg(floats, instr.getArg2());
        switch (op) {
            case FADD: {
                InterpreterEngine.setFloatVar(floats, dst, a1 + a2);
                break;
            }
            case FSUB: {
                InterpreterEngine.setFloatVar(floats, dst, a1 - a2);
                break;
            }
            case FMUL: {
                InterpreterEngine.setFloatVar(floats, dst, a1 * a2);
                break;
            }
            case FDIV: {
                InterpreterEngine.setFloatVar(floats, dst, a1 / a2);
                break;
            }
            case FLT: {
                InterpreterEngine.setBooleanVar(booleans, dst, a1 < a2);
                break;
            }
            case FGT: {
                InterpreterEngine.setBooleanVar(booleans, dst, a1 > a2);
                break;
            }
            case FEQ: {
                InterpreterEngine.setBooleanVar(booleans, dst, a1 == a2);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled float op: " + (Object)((Object)op) + " for instr " + instr);
            }
        }
    }

    protected static void receiveArg(ThreadContext context, Instr i2, Operation operation, IRubyObject[] args2, boolean acceptsKeywordArgument, DynamicScope currDynScope, Object[] temp, Object exception2, Block blockArg) {
        ResultInstr instr = (ResultInstr)((Object)i2);
        switch (operation) {
            case RECV_PRE_REQD_ARG: {
                int argIndex = ((ReceivePreReqdArgInstr)instr).getArgIndex();
                IRubyObject result2 = IRRuntimeHelpers.getPreArgSafe(context, args2, argIndex);
                InterpreterEngine.setResult(temp, currDynScope, instr.getResult(), (Object)result2);
                return;
            }
            case RECV_POST_REQD_ARG: {
                IRubyObject result3 = ((ReceivePostReqdArgInstr)instr).receivePostReqdArg(context, args2, acceptsKeywordArgument);
                InterpreterEngine.setResult(temp, currDynScope, instr.getResult(), (Object)result3);
                return;
            }
            case RECV_RUBY_EXC: {
                InterpreterEngine.setResult(temp, currDynScope, instr.getResult(), IRRuntimeHelpers.unwrapRubyException(exception2));
                return;
            }
            case RECV_JRUBY_EXC: {
                InterpreterEngine.setResult(temp, currDynScope, instr.getResult(), exception2);
                return;
            }
            case LOAD_IMPLICIT_CLOSURE: {
                InterpreterEngine.setResult(temp, currDynScope, instr.getResult(), (Object)blockArg);
                return;
            }
        }
        IRubyObject result4 = ((ReceiveArgBase)instr).receiveArg(context, args2, acceptsKeywordArgument);
        InterpreterEngine.setResult(temp, currDynScope, instr.getResult(), (Object)result4);
    }

    protected static void processCall(ThreadContext context, Instr instr, Operation operation, DynamicScope currDynScope, StaticScope currScope, Object[] temp, IRubyObject self2) {
        switch (operation) {
            case CALL_1F: {
                OneFixnumArgNoBlockCallInstr call2 = (OneFixnumArgNoBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)InterpreterEngine.retrieveOp(call2.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject result2 = call2.getCallSite().call(context, self2, r, call2.getFixnumArg());
                InterpreterEngine.setResult(temp, currDynScope, call2.getResult(), (Object)result2);
                break;
            }
            case CALL_1D: {
                OneFloatArgNoBlockCallInstr call3 = (OneFloatArgNoBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)InterpreterEngine.retrieveOp(call3.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject result3 = call3.getCallSite().call(context, self2, r, call3.getFloatArg());
                InterpreterEngine.setResult(temp, currDynScope, call3.getResult(), (Object)result3);
                break;
            }
            case CALL_1O: {
                OneOperandArgNoBlockCallInstr call4 = (OneOperandArgNoBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)InterpreterEngine.retrieveOp(call4.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject o = (IRubyObject)call4.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                IRubyObject result4 = call4.getCallSite().call(context, self2, r, o);
                InterpreterEngine.setResult(temp, currDynScope, call4.getResult(), (Object)result4);
                break;
            }
            case CALL_2O: {
                TwoOperandArgNoBlockCallInstr call5 = (TwoOperandArgNoBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)InterpreterEngine.retrieveOp(call5.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject o1 = (IRubyObject)call5.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                IRubyObject o2 = (IRubyObject)call5.getArg2().retrieve(context, self2, currScope, currDynScope, temp);
                IRubyObject result5 = call5.getCallSite().call(context, self2, r, o1, o2);
                InterpreterEngine.setResult(temp, currDynScope, call5.getResult(), (Object)result5);
                break;
            }
            case CALL_1OB: {
                OneOperandArgBlockCallInstr call6 = (OneOperandArgBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)InterpreterEngine.retrieveOp(call6.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject o = (IRubyObject)call6.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                Block preparedBlock = call6.prepareBlock(context, self2, currScope, currDynScope, temp);
                CallSite callSite = call6.getCallSite();
                IRubyObject result6 = call6.hasLiteralClosure() ? callSite.callIter(context, self2, r, o, preparedBlock) : callSite.call(context, self2, r, o, preparedBlock);
                InterpreterEngine.setResult(temp, currDynScope, call6.getResult(), (Object)result6);
                break;
            }
            case CALL_0O: {
                ZeroOperandArgNoBlockCallInstr call7 = (ZeroOperandArgNoBlockCallInstr)instr;
                IRubyObject r = (IRubyObject)InterpreterEngine.retrieveOp(call7.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject result7 = call7.getCallSite().call(context, self2, r);
                InterpreterEngine.setResult(temp, currDynScope, call7.getResult(), (Object)result7);
                break;
            }
            case NORESULT_CALL_1O: {
                OneOperandArgNoBlockNoResultCallInstr call8 = (OneOperandArgNoBlockNoResultCallInstr)instr;
                IRubyObject r = (IRubyObject)InterpreterEngine.retrieveOp(call8.getReceiver(), context, self2, currDynScope, currScope, temp);
                IRubyObject o = (IRubyObject)call8.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
                call8.getCallSite().call(context, self2, r, o);
                break;
            }
            case NORESULT_CALL: {
                instr.interpret(context, currScope, currDynScope, self2, temp);
                break;
            }
            default: {
                Object result8 = instr.interpret(context, currScope, currDynScope, self2, temp);
                InterpreterEngine.setResult(temp, currDynScope, instr, result8);
            }
        }
    }

    protected static void processBookKeepingOp(ThreadContext context, Block block, Instr instr, Operation operation, String name2, IRubyObject[] args2, IRubyObject self2, Block blockArg, RubyModule implClass, DynamicScope currDynScope, Object[] temp, StaticScope currScope) {
        switch (operation) {
            case LABEL: {
                break;
            }
            case SAVE_BINDING_VIZ: {
                InterpreterEngine.setResult(temp, currDynScope, ((SaveBindingVisibilityInstr)instr).getResult(), (Object)block.getBinding().getFrame().getVisibility());
                break;
            }
            case RESTORE_BINDING_VIZ: {
                block.getBinding().getFrame().setVisibility((Visibility)((Object)InterpreterEngine.retrieveOp(((RestoreBindingVisibilityInstr)instr).getVisibility(), context, self2, currDynScope, currScope, temp)));
                break;
            }
            case PUSH_BLOCK_FRAME: {
                InterpreterEngine.setResult(temp, currDynScope, ((PushBlockFrameInstr)instr).getResult(), (Object)context.preYieldNoScope(block.getBinding()));
                break;
            }
            case POP_BLOCK_FRAME: {
                context.postYieldNoScope((Frame)InterpreterEngine.retrieveOp(((PopBlockFrameInstr)instr).getFrame(), context, self2, currDynScope, currScope, temp));
                break;
            }
            case PUSH_METHOD_FRAME: {
                context.preMethodFrameOnly(implClass, name2, self2, ((PushMethodFrameInstr)instr).getVisibility(), blockArg);
                break;
            }
            case PUSH_BACKREF_FRAME: {
                context.preBackrefMethod();
                break;
            }
            case POP_METHOD_FRAME: {
                context.popFrame();
                break;
            }
            case POP_BACKREF_FRAME: {
                context.postBackrefMethod();
                break;
            }
            case POP_BINDING: {
                context.popScope();
                break;
            }
            case THREAD_POLL: {
                if (IRRuntimeHelpers.inProfileMode()) {
                    Profiler.clockTick();
                }
                context.callThreadPoll();
                break;
            }
            case CHECK_ARITY: {
                ((CheckArityInstr)instr).checkArity(context, currScope, args2, block);
                break;
            }
            case LINE_NUM: {
                LineNumberInstr line = (LineNumberInstr)instr;
                context.setLine(line.lineNumber);
                if (!line.coverage) break;
                IRRuntimeHelpers.updateCoverage(context, currScope.getFile(), line.lineNumber);
                if (!line.oneshot) break;
                line.coverage = false;
                break;
            }
            case TOGGLE_BACKTRACE: {
                context.setExceptionRequiresBacktrace(((ToggleBacktraceInstr)instr).requiresBacktrace());
                break;
            }
            case TRACE: {
                instr.interpret(context, currScope, currDynScope, self2, temp);
            }
        }
    }

    protected static IRubyObject processReturnOp(ThreadContext context, Block block, Instr instr, Operation operation, DynamicScope currDynScope, Object[] temp, IRubyObject self2, StaticScope currScope) {
        switch (operation) {
            case RETURN: {
                return (IRubyObject)InterpreterEngine.retrieveOp(((ReturnBase)instr).getReturnValue(), context, self2, currDynScope, currScope, temp);
            }
            case BREAK: {
                BreakInstr bi = (BreakInstr)instr;
                IRubyObject rv = (IRubyObject)bi.getReturnValue().retrieve(context, self2, currScope, currDynScope, temp);
                return IRRuntimeHelpers.initiateBreak(context, currDynScope, rv, block);
            }
            case NONLOCAL_RETURN: {
                NonlocalReturnInstr ri = (NonlocalReturnInstr)instr;
                IRubyObject rv = (IRubyObject)InterpreterEngine.retrieveOp(ri.getReturnValue(), context, self2, currDynScope, currScope, temp);
                return IRRuntimeHelpers.initiateNonLocalReturn(currDynScope, block, rv);
            }
            case RETURN_OR_RETHROW_SAVED_EXC: {
                IRubyObject retVal = (IRubyObject)InterpreterEngine.retrieveOp(((ReturnBase)instr).getReturnValue(), context, self2, currDynScope, currScope, temp);
                return IRRuntimeHelpers.returnOrRethrowSavedException(context, retVal);
            }
        }
        return null;
    }

    protected static void processOtherOp(ThreadContext context, Block block, Instr instr, Operation operation, DynamicScope currDynScope, StaticScope currScope, Object[] temp, IRubyObject self2, double[] floats, long[] fixnums, boolean[] booleans) {
        switch (operation) {
            case RECV_SELF: {
                break;
            }
            case COPY: {
                CopyInstr c = (CopyInstr)instr;
                Operand src = c.getSource();
                Variable res = c.getResult();
                if (res instanceof TemporaryFloatVariable) {
                    InterpreterEngine.setFloatVar(floats, (TemporaryFloatVariable)res, InterpreterEngine.getFloatArg(floats, src));
                    break;
                }
                if (res instanceof TemporaryFixnumVariable) {
                    InterpreterEngine.setFixnumVar(fixnums, (TemporaryFixnumVariable)res, InterpreterEngine.getFixnumArg(fixnums, src));
                    break;
                }
                InterpreterEngine.setResult(temp, currDynScope, res, InterpreterEngine.retrieveOp(src, context, self2, currDynScope, currScope, temp));
                break;
            }
            case RUNTIME_HELPER: {
                RuntimeHelperCall rhc = (RuntimeHelperCall)instr;
                InterpreterEngine.setResult(temp, currDynScope, rhc.getResult(), (Object)rhc.callHelper(context, currScope, currDynScope, self2, temp, block));
                break;
            }
            case CHECK_FOR_LJE: {
                ((CheckForLJEInstr)instr).check(context, currDynScope, block);
                break;
            }
            case BOX_FLOAT: {
                RubyFloat f = context.runtime.newFloat(InterpreterEngine.getFloatArg(floats, ((BoxFloatInstr)instr).getValue()));
                InterpreterEngine.setResult(temp, currDynScope, ((BoxInstr)instr).getResult(), (Object)f);
                break;
            }
            case BOX_FIXNUM: {
                RubyFixnum f = context.runtime.newFixnum(InterpreterEngine.getFixnumArg(fixnums, ((BoxFixnumInstr)instr).getValue()));
                InterpreterEngine.setResult(temp, currDynScope, ((BoxInstr)instr).getResult(), (Object)f);
                break;
            }
            case BOX_BOOLEAN: {
                RubyBoolean f = RubyBoolean.newBoolean(context, InterpreterEngine.getBooleanArg(booleans, ((BoxBooleanInstr)instr).getValue()));
                InterpreterEngine.setResult(temp, currDynScope, ((BoxInstr)instr).getResult(), (Object)f);
                break;
            }
            case UNBOX_FLOAT: {
                UnboxInstr ui = (UnboxInstr)instr;
                Object val = InterpreterEngine.retrieveOp(ui.getValue(), context, self2, currDynScope, currScope, temp);
                if (val instanceof RubyFloat) {
                    floats[((TemporaryLocalVariable)ui.getResult()).offset] = ((RubyFloat)val).getValue();
                    break;
                }
                floats[((TemporaryLocalVariable)ui.getResult()).offset] = ((RubyFixnum)val).getDoubleValue();
                break;
            }
            case UNBOX_FIXNUM: {
                UnboxInstr ui = (UnboxInstr)instr;
                Object val = InterpreterEngine.retrieveOp(ui.getValue(), context, self2, currDynScope, currScope, temp);
                if (val instanceof RubyFloat) {
                    fixnums[((TemporaryLocalVariable)ui.getResult()).offset] = ((RubyFloat)val).getLongValue();
                    break;
                }
                fixnums[((TemporaryLocalVariable)ui.getResult()).offset] = ((RubyFixnum)val).getLongValue();
                break;
            }
            case LOAD_FRAME_CLOSURE: {
                InterpreterEngine.setResult(temp, currDynScope, instr, (Object)context.getFrameBlock());
                break;
            }
            case LOAD_BLOCK_IMPLICIT_CLOSURE: {
                InterpreterEngine.setResult(temp, currDynScope, instr, (Object)Helpers.getImplicitBlockFromBlockBinding(block));
                return;
            }
            default: {
                Object result2 = instr.interpret(context, currScope, currDynScope, self2, temp);
                InterpreterEngine.setResult(temp, currDynScope, instr, result2);
            }
        }
    }

    protected static void extractToMethodToAvoidC2Crash(Instr instr, Throwable t) {
        if (!(t instanceof Unrescuable) && !instr.canRaiseException()) {
            System.err.println("BUG: Got exception " + t + " but instr " + instr + " is not supposed to be raising exceptions!");
        }
    }

    protected static void setResult(Object[] temp, DynamicScope currDynScope, Variable resultVar, Object result2) {
        if (resultVar instanceof TemporaryVariable) {
            temp[((TemporaryLocalVariable)resultVar).offset] = result2;
        } else {
            LocalVariable lv = (LocalVariable)resultVar;
            currDynScope.setValueVoid((IRubyObject)result2, lv.getLocation(), lv.getScopeDepth());
        }
    }

    protected static void setResult(Object[] temp, DynamicScope currDynScope, Instr instr, Object result2) {
        if (instr instanceof ResultInstr) {
            InterpreterEngine.setResult(temp, currDynScope, ((ResultInstr)((Object)instr)).getResult(), result2);
        }
    }

    protected static Object retrieveOp(Operand r, ThreadContext context, IRubyObject self2, DynamicScope currDynScope, StaticScope currScope, Object[] temp) {
        if (r instanceof Self) {
            return self2;
        }
        if (r instanceof TemporaryLocalVariable) {
            Object res = temp[((TemporaryLocalVariable)r).offset];
            return res == null ? context.nil : res;
        }
        if (r instanceof LocalVariable) {
            LocalVariable lv = (LocalVariable)r;
            IRubyObject res = currDynScope.getValue(lv.getLocation(), lv.getScopeDepth());
            return res == null ? context.nil : res;
        }
        return r.retrieve(context, self2, currScope, currDynScope, temp);
    }

    private static double getFloatArg(double[] floats, Operand arg2) {
        if (arg2 instanceof Float) {
            return ((Float)arg2).value;
        }
        if (arg2 instanceof UnboxedFloat) {
            return ((UnboxedFloat)arg2).value;
        }
        if (arg2 instanceof Fixnum) {
            return ((Fixnum)arg2).value;
        }
        if (arg2 instanceof UnboxedFixnum) {
            return ((UnboxedFixnum)arg2).value;
        }
        if (arg2 instanceof Bignum) {
            return ((Bignum)arg2).value.doubleValue();
        }
        if (arg2 instanceof TemporaryLocalVariable) {
            return floats[((TemporaryLocalVariable)arg2).offset];
        }
        throw new RuntimeException("invalid float operand: " + arg2);
    }

    private static long getFixnumArg(long[] fixnums, Operand arg2) {
        if (arg2 instanceof Float) {
            return (long)((Float)arg2).value;
        }
        if (arg2 instanceof UnboxedFixnum) {
            return ((UnboxedFixnum)arg2).value;
        }
        if (arg2 instanceof Fixnum) {
            return ((Fixnum)arg2).value;
        }
        if (arg2 instanceof Bignum) {
            return ((Bignum)arg2).value.longValue();
        }
        if (arg2 instanceof TemporaryLocalVariable) {
            return fixnums[((TemporaryLocalVariable)arg2).offset];
        }
        throw new RuntimeException("invalid fixnum operand: " + arg2);
    }

    private static boolean getBooleanArg(boolean[] booleans, Operand arg2) {
        if (arg2 instanceof UnboxedBoolean) {
            return ((UnboxedBoolean)arg2).isTrue();
        }
        if (arg2 instanceof TemporaryLocalVariable) {
            return booleans[((TemporaryLocalVariable)arg2).offset];
        }
        throw new RuntimeException("invalid fixnum operand: " + arg2);
    }

    private static void setFloatVar(double[] floats, TemporaryLocalVariable var, double val) {
        floats[var.offset] = val;
    }

    private static void setFixnumVar(long[] fixnums, TemporaryLocalVariable var, long val) {
        fixnums[var.offset] = val;
    }

    private static void setBooleanVar(boolean[] booleans, TemporaryLocalVariable var, boolean val) {
        booleans[var.offset] = val;
    }
}

