"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statsCommands = exports.regexForSuggestion = exports.regexForIndex = exports.pipeCommands = exports.numberTypes = exports.firstCommand = exports.STRING_FIELD_AFTER_PARSE = exports.RARE_TOP_FIELD_LOOP = exports.PLUS_MINUS_FIELD_IN_FIELDS_LOOP = exports.PLUS_MINUS_FIELD_AFTER_SORT = exports.PLUS_MINUS_FIELD_AFTER_FIELDS = exports.PIPE_MATH_AFTER_EXPRESSIONS = exports.PIPE_COMMA_AFTER_INDEX = exports.PIPE_AFTER_WHERE = exports.PIPE_AFTER_STATS_GROUP_BY = exports.PIPE_AFTER_SPAN = exports.PIPE_AFTER_PARSE = exports.PIPE_AFTER_MATCH = exports.PIPE_AFTER_KEEP_EMPTY = exports.PIPE_AFTER_HEAD = exports.PIPE_AFTER_GROUP_BY = exports.PIPE_AFTER_CONSECUTIVE = exports.NUM_FIELD_AFTER_AGGREGATION = exports.MORE_INDEX_AFTER_COMMA = exports.MATH_AFTER_FIELD = exports.MATCH_FIELD_AFTER_WHERE = exports.INDEX_AFTER_EQUAL = exports.FIELD_SPAN_AFTER_GROUP_BY = exports.FIELD_IN_FIELD_LOOP = exports.FIELD_IN_FIELDS_LOOP = exports.FIELD_AFTER_SPAN = exports.FIELD_AFTER_PLUS_MINUS_SORT = exports.FIELD_AFTER_PLUS_MINUS = exports.FIELD_AFTER_EVAL_EQUAL = exports.FIELD_AFTER_COMMAND = exports.FIELD_AFTER_COMMA = exports.FIELD_AFTER_BY = exports.EQUAL_AFTER_WHERE_FIELD = exports.EQUAL_AFTER_SOURCE = exports.EQUAL_AFTER_EVAL_FIELD = exports.EMPTY_REGEX = exports.DATA_AFTER_WHERE_EQUAL = exports.DATA_AFTER_COMMA = exports.COMMA_PIPE_BY_AFTER_FIELD = exports.COMMA_PIPE_BY_AFTER_AGGREGATION = exports.COMMA_PIPE_AFTER_SORT_FIELD = exports.COMMA_PIPE_AFTER_RENAME_FIELD = exports.COMMA_PIPE_AFTER_FIELDS = exports.COMMA_PIPE_AFTER_FIELD = exports.COMMA_AFTER_FIELD = exports.CLOSE_AFTER_SPAN = exports.CLOSE_AFTER_FIELD = exports.CLOSE_AFTER_DATA = exports.AS_AFTER_FIELD = exports.AGGREGATION_FOR_STATS = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/* eslint-disable prettier/prettier */
const firstCommand = [{
  label: 'source'
}];
exports.firstCommand = firstCommand;
const pipeCommands = [{
  label: 'dedup'
}, {
  label: 'eval'
}, {
  label: 'fields'
}, {
  label: 'head'
}, {
  label: 'parse'
}, {
  label: 'rare'
}, {
  label: 'rename'
}, {
  label: 'sort'
}, {
  label: 'stats'
}, {
  label: 'top'
}, {
  label: 'where'
}];
exports.pipeCommands = pipeCommands;
const statsCommands = [{
  label: 'count()'
}, {
  label: 'sum('
}, {
  label: 'avg('
}, {
  label: 'max('
}, {
  label: 'min('
}, {
  label: 'var_samp('
}, {
  label: 'var_pop('
}, {
  label: 'stddev_samp('
}, {
  label: 'stddev_pop('
}];
exports.statsCommands = statsCommands;
const numberTypes = ['long', 'integer', 'short', 'byte', 'double', 'float', 'half_float', 'scaled_float', 'unsigned_long'];
exports.numberTypes = numberTypes;
const JUST_SEARCH_REGEX = /\s*(search\s+source|source|index)\s*=\s*[^\\\/\?\"\<\>\|\s\,\#]*(\s*,\s*[^\\\/\?\"\<\>\|\s\,\#]+)*/;
const SEARCH_WHERE_REGEX = /\s*(search\s+source|source|index)\s*=\s*[^\\\/\?\"\<\>\|\s\,\#]*(\s*,\s*[^\\\/\?\"\<\>\|\s\,\#]+)*\s*\|\s*where\s+\S+\s*=\s*\S+/;
const SEARCH_MATCH_REGEX = /\s*(search\s+source|source|index)\s*=\s*[^\\\/\?\"\<\>\|\s\,\#]*(\s*,\s*[^\\\/\?\"\<\>\|\s\,\#]+)*\s*\|\s*where\s+match\(\S+,\s*\S+\)/;
const EMPTY_REGEX = /^\s*\S*$/;
exports.EMPTY_REGEX = EMPTY_REGEX;
const FIELD_AFTER_COMMAND = /^\s*(dedup|eval|rare|top|rename|where\s+match\()\s+\S*$/; // Regex for where command

exports.FIELD_AFTER_COMMAND = FIELD_AFTER_COMMAND;
const MATCH_FIELD_AFTER_WHERE = /^\s*where\s+\S*$/;
exports.MATCH_FIELD_AFTER_WHERE = MATCH_FIELD_AFTER_WHERE;
const EQUAL_AFTER_WHERE_FIELD = /^\s*where\s+(\S+)\s+$/;
exports.EQUAL_AFTER_WHERE_FIELD = EQUAL_AFTER_WHERE_FIELD;
const DATA_AFTER_WHERE_EQUAL = /^\s*where\s+\S+\s*=\s*(("(\w|\s|')*)|(\d*\.?\d*)|\w*)$/;
exports.DATA_AFTER_WHERE_EQUAL = DATA_AFTER_WHERE_EQUAL;
const PIPE_AFTER_WHERE = /^\s*where\s+\S+\s*=\s*(("(\w|\s|')+")|(\d+\.?\d*)|\w+)\s+$/;
exports.PIPE_AFTER_WHERE = PIPE_AFTER_WHERE;
const COMMA_AFTER_FIELD = /^\s*where\s+match\(\s*([^\s,]+)\s*$/;
exports.COMMA_AFTER_FIELD = COMMA_AFTER_FIELD;
const DATA_AFTER_COMMA = /^\s*where\s+match\(\s*\S+\s*,\s*(("(\w|\s|')*)|(\d*\.?\d*)|\w*)$/;
exports.DATA_AFTER_COMMA = DATA_AFTER_COMMA;
const CLOSE_AFTER_DATA = /^\s*where\s+match\(\s*\S+\s*,\s*(("(\w|\s|')+")|(\d+\.?\d*)|\w+)\s+$/;
exports.CLOSE_AFTER_DATA = CLOSE_AFTER_DATA;
const PIPE_AFTER_MATCH = /^\s*where\s+match\(\s*\S+\s*,\s*(("(\w|\s|')+")|(\d+\.?\d*)|\w+)\s*\)\s*$/; // Regex for dedup command

exports.PIPE_AFTER_MATCH = PIPE_AFTER_MATCH;
const FIELD_IN_FIELD_LOOP = /^\s*dedup\s*\d*\s+\S+\s*(,\s*\S+\s*)*,\s*([^\s,]*)$/;
exports.FIELD_IN_FIELD_LOOP = FIELD_IN_FIELD_LOOP;
const COMMA_PIPE_AFTER_FIELD = /^\s*dedup\s*\d*\s+\S+\s*(,\s*\S+\s*)*\s+$/;
exports.COMMA_PIPE_AFTER_FIELD = COMMA_PIPE_AFTER_FIELD;
const PIPE_AFTER_KEEP_EMPTY = /^\s*dedup\s*\d*\s+\S+\s*(,\s*\S+\s*)*\s*keepempty=true\s+$/;
exports.PIPE_AFTER_KEEP_EMPTY = PIPE_AFTER_KEEP_EMPTY;
const PIPE_AFTER_CONSECUTIVE = /^\s*dedup\s*\d*\s+\S+\s*(,\s*\S+\s*)*\s*consecutive=true\s+$/; // Regex for eval command

exports.PIPE_AFTER_CONSECUTIVE = PIPE_AFTER_CONSECUTIVE;
const EQUAL_AFTER_EVAL_FIELD = /^\s*eval\s+(\S+)\s+$/;
exports.EQUAL_AFTER_EVAL_FIELD = EQUAL_AFTER_EVAL_FIELD;
const FIELD_AFTER_EVAL_EQUAL = /^\s*eval\s+\S+\s*=\s*\S*$/;
exports.FIELD_AFTER_EVAL_EQUAL = FIELD_AFTER_EVAL_EQUAL;
const MATH_AFTER_FIELD = /^\s*eval\s+\S+\s*=\s*\S+\s+$/;
exports.MATH_AFTER_FIELD = MATH_AFTER_FIELD;
const PIPE_MATH_AFTER_EXPRESSIONS = /^\s*eval\s+(\S+\s*=\s*\S+(\s*(\+|\-|\*|\/)\s*\S+)+)+\s+$/; // Regex for fields command

exports.PIPE_MATH_AFTER_EXPRESSIONS = PIPE_MATH_AFTER_EXPRESSIONS;
const PLUS_MINUS_FIELD_AFTER_FIELDS = /^\s*fields\s+\S*$/;
exports.PLUS_MINUS_FIELD_AFTER_FIELDS = PLUS_MINUS_FIELD_AFTER_FIELDS;
const FIELD_AFTER_PLUS_MINUS = /^\s*fields\s+(\+|\-)\s*\S*$/;
exports.FIELD_AFTER_PLUS_MINUS = FIELD_AFTER_PLUS_MINUS;
const COMMA_PIPE_AFTER_FIELDS = /^\s*fields\s+((\+|\-)\s+)?\S+\s*(,\s*\S+\s*)*\s+$/;
exports.COMMA_PIPE_AFTER_FIELDS = COMMA_PIPE_AFTER_FIELDS;
const FIELD_IN_FIELDS_LOOP = /^\s*fields\s+((\+|\-)\s+)?\S+\s*(,\s*\S+\s*)*,\s*\S*$/; // Regex for rare/top command

exports.FIELD_IN_FIELDS_LOOP = FIELD_IN_FIELDS_LOOP;
const COMMA_PIPE_BY_AFTER_FIELD = /^\s*(rare|top(\s+\d+)?)\s+\S+\s*(,\s*\S+\s*)*\s+\S*$/;
exports.COMMA_PIPE_BY_AFTER_FIELD = COMMA_PIPE_BY_AFTER_FIELD;
const RARE_TOP_FIELD_LOOP = /^\s*(rare|top(\s+\d+)?)\s+\S+\s*(,\s*\S+\s*)*,\s*\S*$/;
exports.RARE_TOP_FIELD_LOOP = RARE_TOP_FIELD_LOOP;
const FIELD_AFTER_BY = /^\s*(rare|top(\s+\d+)?)\s+\S+\s*(,\s*\S+\s*)*\s+by\s+\S*$/;
exports.FIELD_AFTER_BY = FIELD_AFTER_BY;
const PIPE_AFTER_GROUP_BY = /^\s*(rare|top(\s+\d+)?)\s+\S+\s*(,\s*\S+\s*)*\s+by\s+\S+\s+$/; // Regex for rename command

exports.PIPE_AFTER_GROUP_BY = PIPE_AFTER_GROUP_BY;
const AS_AFTER_FIELD = /^\s*rename\s+((,\s*)?\S+\s+as\s+\S+\s*)*\s*(,\s*)?\S+\s+\S*$/;
exports.AS_AFTER_FIELD = AS_AFTER_FIELD;
const COMMA_PIPE_AFTER_RENAME_FIELD = /^\s*rename\s+((,\s*)?\S+\s+as\s+\S+\s*)+$/;
exports.COMMA_PIPE_AFTER_RENAME_FIELD = COMMA_PIPE_AFTER_RENAME_FIELD;
const FIELD_AFTER_COMMA = /^\s*rename\s+((,\s*)?\S+\s+as\s+\S+\s*)+\s*,\s+\S*$/; // Regex for head command

exports.FIELD_AFTER_COMMA = FIELD_AFTER_COMMA;
const PIPE_AFTER_HEAD = /^\s*head\s+\d+\s+/; // Regex for sort command

exports.PIPE_AFTER_HEAD = PIPE_AFTER_HEAD;
const PLUS_MINUS_FIELD_AFTER_SORT = /^\s*sort(\s+\d+)?\s+\S*$/;
exports.PLUS_MINUS_FIELD_AFTER_SORT = PLUS_MINUS_FIELD_AFTER_SORT;
const FIELD_AFTER_PLUS_MINUS_SORT = /^\s*sort(\s+\d+)?((,\s*)?\s+(\+|\-)?\s*\S+\s*)*\s+(\+|\-)\s*\S*$/;
exports.FIELD_AFTER_PLUS_MINUS_SORT = FIELD_AFTER_PLUS_MINUS_SORT;
const COMMA_PIPE_AFTER_SORT_FIELD = /^\s*sort(\s+\d+)?((,\s*)?\s+(\+|\-)?\s*\S+\s*)*\s+\S+\s+$/;
exports.COMMA_PIPE_AFTER_SORT_FIELD = COMMA_PIPE_AFTER_SORT_FIELD;
const PLUS_MINUS_FIELD_IN_FIELDS_LOOP = /^\s*sort(\s+\d+)?((,\s*)?\s+(\+|\-)?\s*\S+\s*)*,\s+\S*$/; // Regex for stats command

exports.PLUS_MINUS_FIELD_IN_FIELDS_LOOP = PLUS_MINUS_FIELD_IN_FIELDS_LOOP;
const FIELD_SPAN_AFTER_GROUP_BY = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+\S*$/;
exports.FIELD_SPAN_AFTER_GROUP_BY = FIELD_SPAN_AFTER_GROUP_BY;
const NUM_FIELD_AFTER_AGGREGATION = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))*(,\s*)?(sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S*$/;
exports.NUM_FIELD_AFTER_AGGREGATION = NUM_FIELD_AFTER_AGGREGATION;
const FIELD_AFTER_SPAN = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+span\(\s*([^\s,]*)\s*$/;
exports.FIELD_AFTER_SPAN = FIELD_AFTER_SPAN;
const CLOSE_AFTER_SPAN = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+span\(\s*[^\s,]+\s*,\s*(("(\w|\s|')+")|(\d+\.?\d*)|\w+)\s+$/;
exports.CLOSE_AFTER_SPAN = CLOSE_AFTER_SPAN;
const PIPE_AFTER_SPAN = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+span\(\s*[^\s,]+\s*,\s*(("(\w|\s|')*")|(\d*\.?\d*)|\w*)\s*\)\s*$/;
exports.PIPE_AFTER_SPAN = PIPE_AFTER_SPAN;
const CLOSE_AFTER_FIELD = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))*(,\s*)?(sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s+$/;
exports.CLOSE_AFTER_FIELD = CLOSE_AFTER_FIELD;
const COMMA_PIPE_BY_AFTER_AGGREGATION = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+\S*$/;
exports.COMMA_PIPE_BY_AFTER_AGGREGATION = COMMA_PIPE_BY_AFTER_AGGREGATION;
const PIPE_AFTER_STATS_GROUP_BY = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+\S+\s+$/;
exports.PIPE_AFTER_STATS_GROUP_BY = PIPE_AFTER_STATS_GROUP_BY;
const AGGREGATION_FOR_STATS = /^\s*stats\s+(((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+,\s*)?\S*$/; // Regex for parse command

exports.AGGREGATION_FOR_STATS = AGGREGATION_FOR_STATS;
const STRING_FIELD_AFTER_PARSE = /^\s*parse\s+\S*$/;
exports.STRING_FIELD_AFTER_PARSE = STRING_FIELD_AFTER_PARSE;
const PIPE_AFTER_PARSE = /^\s*parse\s+\S+\s+$/; // Regex for source command

exports.PIPE_AFTER_PARSE = PIPE_AFTER_PARSE;
const EQUAL_AFTER_SOURCE = /^\s*source\s+$/;
exports.EQUAL_AFTER_SOURCE = EQUAL_AFTER_SOURCE;
const INDEX_AFTER_EQUAL = /^\s*source\s+=\s+[^\\\/\?\"\<\>\|\s\,\#]*$/;
exports.INDEX_AFTER_EQUAL = INDEX_AFTER_EQUAL;
const PIPE_COMMA_AFTER_INDEX = /^\s*source\s+=\s+[^\\\/\?\"\<\>\|\s\,\#]+(,[^\\\/\?\"\<\>\|\s\,\#]+)*\s+$/;
exports.PIPE_COMMA_AFTER_INDEX = PIPE_COMMA_AFTER_INDEX;
const MORE_INDEX_AFTER_COMMA = /^\s*source\s+=\s+[^\\\/\?\"\<\>\|\s\,\#]+(,[^\\\/\?\"\<\>\|\s\,\#]+)*,\s*[^\\\/\?\"\<\>\|\s\,\#]*\s*$/;
exports.MORE_INDEX_AFTER_COMMA = MORE_INDEX_AFTER_COMMA;
const regexForSuggestion = [EMPTY_REGEX, FIELD_AFTER_COMMAND, MATCH_FIELD_AFTER_WHERE, EQUAL_AFTER_WHERE_FIELD, DATA_AFTER_WHERE_EQUAL, PIPE_AFTER_WHERE, COMMA_AFTER_FIELD, DATA_AFTER_COMMA, CLOSE_AFTER_DATA, PIPE_AFTER_MATCH, FIELD_IN_FIELD_LOOP, COMMA_PIPE_AFTER_FIELD, PIPE_AFTER_KEEP_EMPTY, PIPE_AFTER_CONSECUTIVE, EQUAL_AFTER_EVAL_FIELD, FIELD_AFTER_EVAL_EQUAL, MATH_AFTER_FIELD, PIPE_MATH_AFTER_EXPRESSIONS, PLUS_MINUS_FIELD_AFTER_FIELDS, FIELD_AFTER_PLUS_MINUS, COMMA_PIPE_AFTER_FIELDS, FIELD_IN_FIELDS_LOOP, COMMA_PIPE_BY_AFTER_FIELD, RARE_TOP_FIELD_LOOP, FIELD_AFTER_BY, PIPE_AFTER_GROUP_BY, COMMA_PIPE_AFTER_RENAME_FIELD, FIELD_AFTER_COMMA, AS_AFTER_FIELD, PIPE_AFTER_HEAD, PLUS_MINUS_FIELD_AFTER_SORT, FIELD_AFTER_PLUS_MINUS_SORT, PLUS_MINUS_FIELD_IN_FIELDS_LOOP, COMMA_PIPE_AFTER_SORT_FIELD, FIELD_SPAN_AFTER_GROUP_BY, NUM_FIELD_AFTER_AGGREGATION, FIELD_AFTER_SPAN, CLOSE_AFTER_SPAN, PIPE_AFTER_SPAN, CLOSE_AFTER_FIELD, COMMA_PIPE_BY_AFTER_AGGREGATION, PIPE_AFTER_STATS_GROUP_BY, AGGREGATION_FOR_STATS, STRING_FIELD_AFTER_PARSE, PIPE_AFTER_PARSE, EQUAL_AFTER_SOURCE, INDEX_AFTER_EQUAL, PIPE_COMMA_AFTER_INDEX, MORE_INDEX_AFTER_COMMA];
exports.regexForSuggestion = regexForSuggestion;
const regexForIndex = [JUST_SEARCH_REGEX, SEARCH_WHERE_REGEX, SEARCH_MATCH_REGEX];
exports.regexForIndex = regexForIndex;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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