# ----------------------------------------------------------------------------
#
#  Copyright (C) 2018-2022 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


import globdef as G
from PyQt5 import QtGui, QtCore, QtWidgets


# Base class for the two matrix windows.
#
class Matrixwin (QtWidgets.QWidget):
    
    def __init__(self, parent, nrow, ncol): 
        super (Matrixwin, self).__init__(parent)
        self.nrow = nrow
        self.ncol = ncol
        self.xs = ncol * (G.ELM_XS + 1) + 1
        self.ys = nrow * (G.ELM_YS + 1) + 1
        self.resize (self.xs, self.ys)


    def paintEvent(self, E):
        qp = QtGui.QPainter(self)
        qp.setRenderHint (QtGui.QPainter.Antialiasing)
        qp.setBrush (QtCore.Qt.NoBrush)
        qp.setPen (QtGui.QPen (QtGui.QColor (G.MK_N), 0.2))
        qp.translate (0.5, 0.5)
        x = 0
        for i in range (self.ncol + 1):
            qp.drawLine (x, 0, x, self.ys)
            x += G.ELM_XS + 1
        y = 0
        for i in range (self.nrow + 1):
            qp.drawLine (0, y, self.xs, y)
            y += G.ELM_YS + 1
    
