// WARNING: Portions of this file are autogenerated from codes.def and /build/kjs/src/kjs-5.96.0/src/kjs/bytecode/opcodes.cpp.in.
// (which is what the licensing terms apply to)
// Any changes you make here may be lost!
#line 1 "/build/kjs/src/kjs-5.96.0/src/kjs/bytecode/opcodes.cpp.in"
/*
 *  Opcode data structure and selection routines for KJS/Frostbyte
 *  This file is part of the KDE libraries
 *  Copyright (C) 2008 Maksim Orlovich (maksim@kde.org)
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "opcodes.h"
#include "CompileState.h"
#include <cstdio>

#if PLATFORM(SOLARIS_OS)
using std::printf;
#endif

// Enable this to dump instruction selection instructions.
// #define TRACE_INSTR_SELECT

namespace KJS {

const int Cost_NoConversion = -100000; // small enough so that adding actual costs doesn't
                                       // make it positive
const int Cost_Checked      = -2;

const char* const OpTypeVals[] = {
    "OpType_bool", 
    "OpType_int32", 
    "OpType_value", 
    "OpType_number", 
    "OpType_ident", 
    "OpType_addr", 
    "OpType_reg", 
    "OpType_string", 
    "OpType_node", 
    "OpType_cstr", 
    "OpType_void"
};

const bool opTypeIsAlign8[] = {
    false, // bool
    false, // int32
    true, // value
    true, // number
    true, // ident
    false, // addr
    false, // reg
    true, // string
    true, // node
    true, // cstr
    false  // void
};

const char* const ConvOpVals[] = {
    "Conv_NoConversion", 
    "Conv_NoOp", 
    "Conv_I_R_Int32_Value", 
    "Conv_I_R_Number_Value", 
    "Conv_IBool_Int32", 
    "Conv_RBool_Int32", 
    "Conv_IBool_Value", 
    "Conv_RBool_Value", 
    "Conv_IBool_Number", 
    "Conv_RBool_Number", 
    "Conv_IValue_Bool", 
    "Conv_RValue_Bool", 
    "Conv_IValue_Int32", 
    "Conv_RValue_Int32", 
    "Conv_IValue_Number", 
    "Conv_RValue_Number", 
    "Conv_IInt32_Bool", 
    "Conv_RInt32_Bool", 
    "Conv_IInt32_Value", 
    "Conv_RInt32_Value", 
    "Conv_IInt32_Number", 
    "Conv_RInt32_Number", 
    "Conv_INumber_Bool", 
    "Conv_RNumber_Bool", 
    "Conv_INumber_Value", 
    "Conv_RNumber_Value", 
    "Conv_INumber_Int32", 
    "Conv_RNumber_Int32"
};

struct ConvInfo {
    ConvOp routine;
    int    costCode;
};

ConvInfo conversions[] = {
    {Conv_NoOp, 0}, // bool => bool
    {Conv_RBool_Int32, 0}, // bool => int32
    {Conv_RBool_Value, 10}, // bool => value
    {Conv_RBool_Number, 10}, // bool => number
    {Conv_NoConversion, Cost_NoConversion}, // bool => ident
    {Conv_NoConversion, Cost_NoConversion}, // bool => addr
    {Conv_NoConversion, Cost_NoConversion}, // bool => reg
    {Conv_NoConversion, Cost_NoConversion}, // bool => string
    {Conv_NoConversion, Cost_NoConversion}, // bool => node
    {Conv_NoConversion, Cost_NoConversion}, // bool => cstr
    {Conv_NoConversion, Cost_NoConversion}, // bool => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_RInt32_Bool, 10}, // int32 => bool
    {Conv_NoOp, 0}, // int32 => int32
    {Conv_RInt32_Value, 25}, // int32 => value
    {Conv_RInt32_Number, 10}, // int32 => number
    {Conv_NoConversion, Cost_NoConversion}, // int32 => ident
    {Conv_NoConversion, Cost_NoConversion}, // int32 => addr
    {Conv_NoConversion, Cost_NoConversion}, // int32 => reg
    {Conv_NoConversion, Cost_NoConversion}, // int32 => string
    {Conv_NoConversion, Cost_NoConversion}, // int32 => node
    {Conv_NoConversion, Cost_NoConversion}, // int32 => cstr
    {Conv_NoConversion, Cost_NoConversion}, // int32 => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_RValue_Bool, 15}, // value => bool
    {Conv_RValue_Int32, 50}, // value => int32
    {Conv_NoOp, 0}, // value => value
    {Conv_RValue_Number, 49}, // value => number
    {Conv_NoConversion, Cost_NoConversion}, // value => ident
    {Conv_NoConversion, Cost_NoConversion}, // value => addr
    {Conv_NoConversion, Cost_NoConversion}, // value => reg
    {Conv_NoConversion, Cost_NoConversion}, // value => string
    {Conv_NoConversion, Cost_NoConversion}, // value => node
    {Conv_NoConversion, Cost_NoConversion}, // value => cstr
    {Conv_NoConversion, Cost_NoConversion}, // value => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_RNumber_Bool, 25}, // number => bool
    {Conv_RNumber_Int32, 20}, // number => int32
    {Conv_RNumber_Value, 35}, // number => value
    {Conv_NoOp, 0}, // number => number
    {Conv_NoConversion, Cost_NoConversion}, // number => ident
    {Conv_NoConversion, Cost_NoConversion}, // number => addr
    {Conv_NoConversion, Cost_NoConversion}, // number => reg
    {Conv_NoConversion, Cost_NoConversion}, // number => string
    {Conv_NoConversion, Cost_NoConversion}, // number => node
    {Conv_NoConversion, Cost_NoConversion}, // number => cstr
    {Conv_NoConversion, Cost_NoConversion}, // number => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // ident => bool
    {Conv_NoConversion, Cost_NoConversion}, // ident => int32
    {Conv_NoConversion, Cost_NoConversion}, // ident => value
    {Conv_NoConversion, Cost_NoConversion}, // ident => number
    {Conv_NoOp, 0}, // ident => ident
    {Conv_NoConversion, Cost_NoConversion}, // ident => addr
    {Conv_NoConversion, Cost_NoConversion}, // ident => reg
    {Conv_NoConversion, Cost_NoConversion}, // ident => string
    {Conv_NoConversion, Cost_NoConversion}, // ident => node
    {Conv_NoConversion, Cost_NoConversion}, // ident => cstr
    {Conv_NoConversion, Cost_NoConversion}, // ident => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // addr => bool
    {Conv_NoConversion, Cost_NoConversion}, // addr => int32
    {Conv_NoConversion, Cost_NoConversion}, // addr => value
    {Conv_NoConversion, Cost_NoConversion}, // addr => number
    {Conv_NoConversion, Cost_NoConversion}, // addr => ident
    {Conv_NoOp, 0}, // addr => addr
    {Conv_NoConversion, Cost_NoConversion}, // addr => reg
    {Conv_NoConversion, Cost_NoConversion}, // addr => string
    {Conv_NoConversion, Cost_NoConversion}, // addr => node
    {Conv_NoConversion, Cost_NoConversion}, // addr => cstr
    {Conv_NoConversion, Cost_NoConversion}, // addr => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // reg => bool
    {Conv_NoConversion, Cost_NoConversion}, // reg => int32
    {Conv_NoConversion, Cost_NoConversion}, // reg => value
    {Conv_NoConversion, Cost_NoConversion}, // reg => number
    {Conv_NoConversion, Cost_NoConversion}, // reg => ident
    {Conv_NoConversion, Cost_NoConversion}, // reg => addr
    {Conv_NoOp, 0}, // reg => reg
    {Conv_NoConversion, Cost_NoConversion}, // reg => string
    {Conv_NoConversion, Cost_NoConversion}, // reg => node
    {Conv_NoConversion, Cost_NoConversion}, // reg => cstr
    {Conv_NoConversion, Cost_NoConversion}, // reg => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // string => bool
    {Conv_NoConversion, Cost_NoConversion}, // string => int32
    {Conv_NoConversion, Cost_NoConversion}, // string => value
    {Conv_NoConversion, Cost_NoConversion}, // string => number
    {Conv_NoConversion, Cost_NoConversion}, // string => ident
    {Conv_NoConversion, Cost_NoConversion}, // string => addr
    {Conv_NoConversion, Cost_NoConversion}, // string => reg
    {Conv_NoOp, 0}, // string => string
    {Conv_NoConversion, Cost_NoConversion}, // string => node
    {Conv_NoConversion, Cost_NoConversion}, // string => cstr
    {Conv_NoConversion, Cost_NoConversion}, // string => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // node => bool
    {Conv_NoConversion, Cost_NoConversion}, // node => int32
    {Conv_NoConversion, Cost_NoConversion}, // node => value
    {Conv_NoConversion, Cost_NoConversion}, // node => number
    {Conv_NoConversion, Cost_NoConversion}, // node => ident
    {Conv_NoConversion, Cost_NoConversion}, // node => addr
    {Conv_NoConversion, Cost_NoConversion}, // node => reg
    {Conv_NoConversion, Cost_NoConversion}, // node => string
    {Conv_NoOp, 0}, // node => node
    {Conv_NoConversion, Cost_NoConversion}, // node => cstr
    {Conv_NoConversion, Cost_NoConversion}, // node => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // cstr => bool
    {Conv_NoConversion, Cost_NoConversion}, // cstr => int32
    {Conv_NoConversion, Cost_NoConversion}, // cstr => value
    {Conv_NoConversion, Cost_NoConversion}, // cstr => number
    {Conv_NoConversion, Cost_NoConversion}, // cstr => ident
    {Conv_NoConversion, Cost_NoConversion}, // cstr => addr
    {Conv_NoConversion, Cost_NoConversion}, // cstr => reg
    {Conv_NoConversion, Cost_NoConversion}, // cstr => string
    {Conv_NoConversion, Cost_NoConversion}, // cstr => node
    {Conv_NoOp, 0}, // cstr => cstr
    {Conv_NoConversion, Cost_NoConversion}, // cstr => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // void => bool
    {Conv_NoConversion, Cost_NoConversion}, // void => int32
    {Conv_NoConversion, Cost_NoConversion}, // void => value
    {Conv_NoConversion, Cost_NoConversion}, // void => number
    {Conv_NoConversion, Cost_NoConversion}, // void => ident
    {Conv_NoConversion, Cost_NoConversion}, // void => addr
    {Conv_NoConversion, Cost_NoConversion}, // void => reg
    {Conv_NoConversion, Cost_NoConversion}, // void => string
    {Conv_NoConversion, Cost_NoConversion}, // void => node
    {Conv_NoConversion, Cost_NoConversion}, // void => cstr
    {Conv_NoOp, 0}, // void => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoOp, 0}, // bool => bool
    {Conv_IBool_Int32, 0}, // bool => int32
    {Conv_IBool_Value, 0}, // bool => value
    {Conv_IBool_Number, 0}, // bool => number
    {Conv_NoConversion, Cost_NoConversion}, // bool => ident
    {Conv_NoConversion, Cost_NoConversion}, // bool => addr
    {Conv_NoConversion, Cost_NoConversion}, // bool => reg
    {Conv_NoConversion, Cost_NoConversion}, // bool => string
    {Conv_NoConversion, Cost_NoConversion}, // bool => node
    {Conv_NoConversion, Cost_NoConversion}, // bool => cstr
    {Conv_NoConversion, Cost_NoConversion}, // bool => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_IInt32_Bool, 0}, // int32 => bool
    {Conv_NoOp, 0}, // int32 => int32
    {Conv_IInt32_Value, Cost_Checked}, // int32 => value
    {Conv_IInt32_Number, 0}, // int32 => number
    {Conv_NoConversion, Cost_NoConversion}, // int32 => ident
    {Conv_NoConversion, Cost_NoConversion}, // int32 => addr
    {Conv_NoConversion, Cost_NoConversion}, // int32 => reg
    {Conv_NoConversion, Cost_NoConversion}, // int32 => string
    {Conv_NoConversion, Cost_NoConversion}, // int32 => node
    {Conv_NoConversion, Cost_NoConversion}, // int32 => cstr
    {Conv_NoConversion, Cost_NoConversion}, // int32 => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_IValue_Bool, 0}, // value => bool
    {Conv_IValue_Int32, 0}, // value => int32
    {Conv_NoOp, 0}, // value => value
    {Conv_IValue_Number, 0}, // value => number
    {Conv_NoConversion, Cost_NoConversion}, // value => ident
    {Conv_NoConversion, Cost_NoConversion}, // value => addr
    {Conv_NoConversion, Cost_NoConversion}, // value => reg
    {Conv_NoConversion, Cost_NoConversion}, // value => string
    {Conv_NoConversion, Cost_NoConversion}, // value => node
    {Conv_NoConversion, Cost_NoConversion}, // value => cstr
    {Conv_NoConversion, Cost_NoConversion}, // value => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_INumber_Bool, 0}, // number => bool
    {Conv_INumber_Int32, 0}, // number => int32
    {Conv_INumber_Value, Cost_Checked}, // number => value
    {Conv_NoOp, 0}, // number => number
    {Conv_NoConversion, Cost_NoConversion}, // number => ident
    {Conv_NoConversion, Cost_NoConversion}, // number => addr
    {Conv_NoConversion, Cost_NoConversion}, // number => reg
    {Conv_NoConversion, Cost_NoConversion}, // number => string
    {Conv_NoConversion, Cost_NoConversion}, // number => node
    {Conv_NoConversion, Cost_NoConversion}, // number => cstr
    {Conv_NoConversion, Cost_NoConversion}, // number => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // ident => bool
    {Conv_NoConversion, Cost_NoConversion}, // ident => int32
    {Conv_NoConversion, Cost_NoConversion}, // ident => value
    {Conv_NoConversion, Cost_NoConversion}, // ident => number
    {Conv_NoOp, 0}, // ident => ident
    {Conv_NoConversion, Cost_NoConversion}, // ident => addr
    {Conv_NoConversion, Cost_NoConversion}, // ident => reg
    {Conv_NoConversion, Cost_NoConversion}, // ident => string
    {Conv_NoConversion, Cost_NoConversion}, // ident => node
    {Conv_NoConversion, Cost_NoConversion}, // ident => cstr
    {Conv_NoConversion, Cost_NoConversion}, // ident => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // addr => bool
    {Conv_NoConversion, Cost_NoConversion}, // addr => int32
    {Conv_NoConversion, Cost_NoConversion}, // addr => value
    {Conv_NoConversion, Cost_NoConversion}, // addr => number
    {Conv_NoConversion, Cost_NoConversion}, // addr => ident
    {Conv_NoOp, 0}, // addr => addr
    {Conv_NoConversion, Cost_NoConversion}, // addr => reg
    {Conv_NoConversion, Cost_NoConversion}, // addr => string
    {Conv_NoConversion, Cost_NoConversion}, // addr => node
    {Conv_NoConversion, Cost_NoConversion}, // addr => cstr
    {Conv_NoConversion, Cost_NoConversion}, // addr => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // reg => bool
    {Conv_NoConversion, Cost_NoConversion}, // reg => int32
    {Conv_NoConversion, Cost_NoConversion}, // reg => value
    {Conv_NoConversion, Cost_NoConversion}, // reg => number
    {Conv_NoConversion, Cost_NoConversion}, // reg => ident
    {Conv_NoConversion, Cost_NoConversion}, // reg => addr
    {Conv_NoOp, 0}, // reg => reg
    {Conv_NoConversion, Cost_NoConversion}, // reg => string
    {Conv_NoConversion, Cost_NoConversion}, // reg => node
    {Conv_NoConversion, Cost_NoConversion}, // reg => cstr
    {Conv_NoConversion, Cost_NoConversion}, // reg => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // string => bool
    {Conv_NoConversion, Cost_NoConversion}, // string => int32
    {Conv_NoConversion, Cost_NoConversion}, // string => value
    {Conv_NoConversion, Cost_NoConversion}, // string => number
    {Conv_NoConversion, Cost_NoConversion}, // string => ident
    {Conv_NoConversion, Cost_NoConversion}, // string => addr
    {Conv_NoConversion, Cost_NoConversion}, // string => reg
    {Conv_NoOp, 0}, // string => string
    {Conv_NoConversion, Cost_NoConversion}, // string => node
    {Conv_NoConversion, Cost_NoConversion}, // string => cstr
    {Conv_NoConversion, Cost_NoConversion}, // string => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // node => bool
    {Conv_NoConversion, Cost_NoConversion}, // node => int32
    {Conv_NoConversion, Cost_NoConversion}, // node => value
    {Conv_NoConversion, Cost_NoConversion}, // node => number
    {Conv_NoConversion, Cost_NoConversion}, // node => ident
    {Conv_NoConversion, Cost_NoConversion}, // node => addr
    {Conv_NoConversion, Cost_NoConversion}, // node => reg
    {Conv_NoConversion, Cost_NoConversion}, // node => string
    {Conv_NoOp, 0}, // node => node
    {Conv_NoConversion, Cost_NoConversion}, // node => cstr
    {Conv_NoConversion, Cost_NoConversion}, // node => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // cstr => bool
    {Conv_NoConversion, Cost_NoConversion}, // cstr => int32
    {Conv_NoConversion, Cost_NoConversion}, // cstr => value
    {Conv_NoConversion, Cost_NoConversion}, // cstr => number
    {Conv_NoConversion, Cost_NoConversion}, // cstr => ident
    {Conv_NoConversion, Cost_NoConversion}, // cstr => addr
    {Conv_NoConversion, Cost_NoConversion}, // cstr => reg
    {Conv_NoConversion, Cost_NoConversion}, // cstr => string
    {Conv_NoConversion, Cost_NoConversion}, // cstr => node
    {Conv_NoOp, 0}, // cstr => cstr
    {Conv_NoConversion, Cost_NoConversion}, // cstr => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, // void => bool
    {Conv_NoConversion, Cost_NoConversion}, // void => int32
    {Conv_NoConversion, Cost_NoConversion}, // void => value
    {Conv_NoConversion, Cost_NoConversion}, // void => number
    {Conv_NoConversion, Cost_NoConversion}, // void => ident
    {Conv_NoConversion, Cost_NoConversion}, // void => addr
    {Conv_NoConversion, Cost_NoConversion}, // void => reg
    {Conv_NoConversion, Cost_NoConversion}, // void => string
    {Conv_NoConversion, Cost_NoConversion}, // void => node
    {Conv_NoConversion, Cost_NoConversion}, // void => cstr
    {Conv_NoOp, 0}, // void => void
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}, 
    {Conv_NoConversion, Cost_NoConversion}
};

static inline const ConvInfo* getConversionInfo(bool immediate, OpType from, OpType to)
{
    return &conversions[((int)immediate << 8) | ((int)from << 4) | (int)to];
}

static bool emitImmediateConversion(ConvOp convType, OpValue* original, OpValue& out)
{
    out.immediate = true;
    switch(convType) {
    case Conv_NoOp:
        out = *original;
        break;
    case Conv_IBool_Int32:
        out.type = OpType_int32;
        out.value.narrow.int32Val = convertIBool_Int32(nullptr, original->value.narrow.boolVal);
        break;
    case Conv_IBool_Value:
        out.type = OpType_value;
        out.value.wide.valueVal = convertIBool_Value(nullptr, original->value.narrow.boolVal);
        break;
    case Conv_IBool_Number:
        out.type = OpType_number;
        out.value.wide.numberVal = convertIBool_Number(nullptr, original->value.narrow.boolVal);
        break;
    case Conv_IValue_Bool:
        out.type = OpType_bool;
        out.value.narrow.boolVal = convertIValue_Bool(nullptr, original->value.wide.valueVal);
        break;
    case Conv_IValue_Int32:
        out.type = OpType_int32;
        out.value.narrow.int32Val = convertIValue_Int32(nullptr, original->value.wide.valueVal);
        break;
    case Conv_IValue_Number:
        out.type = OpType_number;
        out.value.wide.numberVal = convertIValue_Number(nullptr, original->value.wide.valueVal);
        break;
    case Conv_IInt32_Bool:
        out.type = OpType_bool;
        out.value.narrow.boolVal = convertIInt32_Bool(nullptr, original->value.narrow.int32Val);
        break;
    case Conv_IInt32_Value:
        out.type = OpType_value;
        out.value.wide.valueVal = convertIInt32_Value(nullptr, original->value.narrow.int32Val);
        break;
    case Conv_IInt32_Number:
        out.type = OpType_number;
        out.value.wide.numberVal = convertIInt32_Number(nullptr, original->value.narrow.int32Val);
        break;
    case Conv_INumber_Bool:
        out.type = OpType_bool;
        out.value.narrow.boolVal = convertINumber_Bool(nullptr, original->value.wide.numberVal);
        break;
    case Conv_INumber_Value:
        out.type = OpType_value;
        out.value.wide.valueVal = convertINumber_Value(nullptr, original->value.wide.numberVal);
        break;
    case Conv_INumber_Int32:
        out.type = OpType_int32;
        out.value.narrow.int32Val = convertINumber_Int32(nullptr, original->value.wide.numberVal);
        break;
    default:
        return false;
    }
    return true;
}

static bool emitSimpleRegisterConversion(CompileState* comp, ConvOp convType, OpValue* original, OpValue& out)
{
    switch(convType) {
    case Conv_NoOp:
        out = *original;
        break;
    case Conv_RBool_Int32:
        CodeGen::emitOp(comp, Op_RBool_Int32, &out, original);
        break;
    case Conv_RBool_Value:
        CodeGen::emitOp(comp, Op_RBool_Value, &out, original);
        break;
    case Conv_RBool_Number:
        CodeGen::emitOp(comp, Op_RBool_Number, &out, original);
        break;
    case Conv_RValue_Bool:
        CodeGen::emitOp(comp, Op_RValue_Bool, &out, original);
        break;
    case Conv_RValue_Int32:
        CodeGen::emitOp(comp, Op_RValue_Int32, &out, original);
        break;
    case Conv_RValue_Number:
        CodeGen::emitOp(comp, Op_RValue_Number, &out, original);
        break;
    case Conv_RInt32_Bool:
        CodeGen::emitOp(comp, Op_RInt32_Bool, &out, original);
        break;
    case Conv_RInt32_Value:
        CodeGen::emitOp(comp, Op_RInt32_Value, &out, original);
        break;
    case Conv_RInt32_Number:
        CodeGen::emitOp(comp, Op_RInt32_Number, &out, original);
        break;
    case Conv_RNumber_Bool:
        CodeGen::emitOp(comp, Op_RNumber_Bool, &out, original);
        break;
    case Conv_RNumber_Value:
        CodeGen::emitOp(comp, Op_RNumber_Value, &out, original);
        break;
    case Conv_RNumber_Int32:
        CodeGen::emitOp(comp, Op_RNumber_Int32, &out, original);
        break;
    default:
        return false;
    }
    return true;
}

const char* const OpNameVals[] = {
    "Op_RBool_Int32", 
    "Op_RBool_Value", 
    "Op_RBool_Number", 
    "Op_RValue_Bool", 
    "Op_RValue_Int32", 
    "Op_RValue_Number", 
    "Op_RInt32_Bool", 
    "Op_RInt32_Value", 
    "Op_RInt32_Number", 
    "Op_RNumber_Bool", 
    "Op_RNumber_Value", 
    "Op_RNumber_Int32", 
    "Op_RInt32_Value_NonImm", 
    "Op_RNum_Value_NonImm", 
    "Op_PrintInfo", 
    "Op_AtStatement", 
    "Op_Exit", 
    "Op_Jump", 
    "Op_IfJump", 
    "Op_IfNotJump", 
    "Op_BeginForIn", 
    "Op_NextForInEntry", 
    "Op_PushScope", 
    "Op_UnwindStacks", 
    "Op_PopScope", 
    "Op_PopExceptionHandler", 
    "Op_PushExceptionHandler", 
    "Op_EnterCatch", 
    "Op_ExitCatch", 
    "Op_DeferCompletion", 
    "Op_ReactivateCompletion", 
    "Op_ReactivateCompletionDebug", 
    "Op_Throw", 
    "Op_ContBreakInTryFinally", 
    "Op_ReturnInTryFinally", 
    "Op_PropagateException", 
    "Op_Return", 
    "Op_RaiseError", 
    "Op_Preamble", 
    "Op_EnterDebugContext", 
    "Op_ExitDebugContext", 
    "Op_FunctionLookupAndGet", 
    "Op_NonLocalFunctionLookupAndGet", 
    "Op_ScopeLookupAndGetChecked", 
    "Op_ScopeLookupAndGet", 
    "Op_NonLocalScopeLookupAndGetChecked", 
    "Op_NonLocalScopeLookupAndGet", 
    "Op_ScopeLookup", 
    "Op_NonLocalScopeLookup", 
    "Op_VarGet", 
    "Op_NonLocalVarGet", 
    "Op_RegPutValue", 
    "Op_RegPutNumber", 
    "Op_RegPutBool", 
    "Op_RegPutInt32", 
    "Op_ToObject", 
    "Op_SymPutKnownObject", 
    "Op_SymGet", 
    "Op_SymGetKnownObject", 
    "Op_SymGetAndBind", 
    "Op_BracketGet", 
    "Op_BracketGetAndBind", 
    "Op_BracketPutKnownObject", 
    "Op_GlobalObjectGet", 
    "Op_SymDeleteKnownObject", 
    "Op_SymDelete", 
    "Op_BracketDelete", 
    "Op_OwnedString", 
    "Op_NewEmptyArray", 
    "Op_NewObject", 
    "Op_NewRegExp", 
    "Op_DefineGetter", 
    "Op_DefineSetter", 
    "Op_Add1", 
    "Op_Sub1", 
    "Op_Neg", 
    "Op_Mult", 
    "Op_Div", 
    "Op_Mod", 
    "Op_Exp", 
    "Op_Sub", 
    "Op_Add", 
    "Op_LShift", 
    "Op_RShift", 
    "Op_URShift", 
    "Op_Less", 
    "Op_GreaterEq", 
    "Op_Greater", 
    "Op_LessEq", 
    "Op_EqEq", 
    "Op_NotEq", 
    "Op_StrEq", 
    "Op_StrNEq", 
    "Op_BitNot", 
    "Op_BitAnd", 
    "Op_BitXOr", 
    "Op_BitOr", 
    "Op_LogicalNot", 
    "Op_TypeOf", 
    "Op_In", 
    "Op_InstanceOf", 
    "Op_ClearArgs", 
    "Op_AddArg", 
    "Op_Add2Arg", 
    "Op_Add3Arg", 
    "Op_FunctionCall", 
    "Op_CtorCall", 
    "Op_EvalFuncExpr"
};

static const OpType opRetTypes[] = {
     OpType_int32, //RBool_Int32
     OpType_value, //RBool_Value
     OpType_number, //RBool_Number
     OpType_bool, //RValue_Bool
     OpType_int32, //RValue_Int32
     OpType_number, //RValue_Number
     OpType_bool, //RInt32_Bool
     OpType_value, //RInt32_Value
     OpType_number, //RInt32_Number
     OpType_bool, //RNumber_Bool
     OpType_value, //RNumber_Value
     OpType_int32, //RNumber_Int32
     OpType_value, //RInt32_Value_NonImm
     OpType_value, //RNum_Value_NonImm
     OpType_void, //PrintInfo
     OpType_void, //AtStatement
     OpType_void, //Exit
     OpType_void, //Jump
     OpType_void, //IfJump
     OpType_void, //IfNotJump
     OpType_value, //BeginForIn
     OpType_value, //NextForInEntry
     OpType_void, //PushScope
     OpType_void, //UnwindStacks
     OpType_void, //PopScope
     OpType_void, //PopExceptionHandler
     OpType_void, //PushExceptionHandler
     OpType_void, //EnterCatch
     OpType_void, //ExitCatch
     OpType_void, //DeferCompletion
     OpType_void, //ReactivateCompletion
     OpType_void, //ReactivateCompletionDebug
     OpType_void, //Throw
     OpType_void, //ContBreakInTryFinally
     OpType_void, //ReturnInTryFinally
     OpType_void, //PropagateException
     OpType_void, //Return
     OpType_void, //RaiseError
     OpType_void, //Preamble
     OpType_void, //EnterDebugContext
     OpType_void, //ExitDebugContext
     OpType_value, //FunctionLookupAndGet
     OpType_value, //NonLocalFunctionLookupAndGet
     OpType_value, //ScopeLookupAndGetChecked
     OpType_value, //ScopeLookupAndGet
     OpType_value, //NonLocalScopeLookupAndGetChecked
     OpType_value, //NonLocalScopeLookupAndGet
     OpType_value, //ScopeLookup
     OpType_value, //NonLocalScopeLookup
     OpType_value, //VarGet
     OpType_value, //NonLocalVarGet
     OpType_void, //RegPutValue
     OpType_void, //RegPutNumber
     OpType_void, //RegPutBool
     OpType_void, //RegPutInt32
     OpType_value, //ToObject
     OpType_void, //SymPutKnownObject
     OpType_value, //SymGet
     OpType_value, //SymGetKnownObject
     OpType_value, //SymGetAndBind
     OpType_value, //BracketGet
     OpType_value, //BracketGetAndBind
     OpType_void, //BracketPutKnownObject
     OpType_value, //GlobalObjectGet
     OpType_bool, //SymDeleteKnownObject
     OpType_bool, //SymDelete
     OpType_bool, //BracketDelete
     OpType_value, //OwnedString
     OpType_value, //NewEmptyArray
     OpType_value, //NewObject
     OpType_value, //NewRegExp
     OpType_void, //DefineGetter
     OpType_void, //DefineSetter
     OpType_number, //Add1
     OpType_number, //Sub1
     OpType_number, //Neg
     OpType_number, //Mult
     OpType_number, //Div
     OpType_number, //Mod
     OpType_number, //Exp
     OpType_number, //Sub
     OpType_number, //Add
     OpType_int32, //LShift
     OpType_int32, //RShift
     OpType_number, //URShift
     OpType_bool, //Less
     OpType_bool, //GreaterEq
     OpType_bool, //Greater
     OpType_bool, //LessEq
     OpType_bool, //EqEq
     OpType_bool, //NotEq
     OpType_bool, //StrEq
     OpType_bool, //StrNEq
     OpType_int32, //BitNot
     OpType_int32, //BitAnd
     OpType_int32, //BitXOr
     OpType_int32, //BitOr
     OpType_bool, //LogicalNot
     OpType_value, //TypeOf
     OpType_bool, //In
     OpType_bool, //InstanceOf
     OpType_void, //ClearArgs
     OpType_void, //AddArg
     OpType_void, //Add2Arg
     OpType_void, //Add3Arg
     OpType_value, //FunctionCall
     OpType_value, //CtorCall
     OpType_value //EvalFuncExpr
};

const char* const OpByteCodeVals[] = {
    "OpByteCode_RBool_Int32_Ireg_Ibool", 
    "OpByteCode_RBool_Int32_Ireg_Rbool", 
    "OpByteCode_RBool_Value_Ireg_Ibool", 
    "OpByteCode_RBool_Value_Ireg_Rbool", 
    "OpByteCode_RBool_Number_Ireg_Ibool", 
    "OpByteCode_RBool_Number_Ireg_Rbool", 
    "OpByteCode_RValue_Bool_Ireg_Ivalue_Pad", 
    "OpByteCode_RValue_Bool_Ireg_Ivalue", 
    "OpByteCode_RValue_Bool_Ireg_Rvalue", 
    "OpByteCode_RValue_Int32_Ireg_Ivalue_Pad", 
    "OpByteCode_RValue_Int32_Ireg_Ivalue", 
    "OpByteCode_RValue_Int32_Ireg_Rvalue", 
    "OpByteCode_RValue_Number_Ireg_Ivalue_Pad", 
    "OpByteCode_RValue_Number_Ireg_Ivalue", 
    "OpByteCode_RValue_Number_Ireg_Rvalue", 
    "OpByteCode_RInt32_Bool_Ireg_Iint32", 
    "OpByteCode_RInt32_Bool_Ireg_Rint32", 
    "OpByteCode_RInt32_Value_Ireg_Iint32", 
    "OpByteCode_RInt32_Value_Ireg_Rint32", 
    "OpByteCode_RInt32_Number_Ireg_Iint32", 
    "OpByteCode_RInt32_Number_Ireg_Rint32", 
    "OpByteCode_RNumber_Bool_Ireg_Inumber_Pad", 
    "OpByteCode_RNumber_Bool_Ireg_Inumber", 
    "OpByteCode_RNumber_Bool_Ireg_Rnumber", 
    "OpByteCode_RNumber_Value_Ireg_Inumber_Pad", 
    "OpByteCode_RNumber_Value_Ireg_Inumber", 
    "OpByteCode_RNumber_Value_Ireg_Rnumber", 
    "OpByteCode_RNumber_Int32_Ireg_Inumber_Pad", 
    "OpByteCode_RNumber_Int32_Ireg_Inumber", 
    "OpByteCode_RNumber_Int32_Ireg_Rnumber", 
    "OpByteCode_RInt32_Value_NonImm_Ireg_Iint32", 
    "OpByteCode_RInt32_Value_NonImm_Ireg_Rint32", 
    "OpByteCode_RNum_Value_NonImm_Ireg_Inumber_Pad", 
    "OpByteCode_RNum_Value_NonImm_Ireg_Inumber", 
    "OpByteCode_RNum_Value_NonImm_Ireg_Rnumber", 
    "OpByteCode_PrintInfo_Ivalue_Pad", 
    "OpByteCode_PrintInfo_Ivalue", 
    "OpByteCode_PrintInfo_Rvalue", 
    "OpByteCode_AtStatement_Inode_Pad", 
    "OpByteCode_AtStatement_Inode", 
    "OpByteCode_Exit", 
    "OpByteCode_Jump_Iaddr", 
    "OpByteCode_IfJump_Ibool_Iaddr", 
    "OpByteCode_IfJump_Rbool_Iaddr", 
    "OpByteCode_IfJump_Rvalue_Iaddr", 
    "OpByteCode_IfNotJump_Ibool_Iaddr", 
    "OpByteCode_IfNotJump_Rbool_Iaddr", 
    "OpByteCode_IfNotJump_Rvalue_Iaddr", 
    "OpByteCode_BeginForIn_Ireg_Ivalue_Ireg_Pad", 
    "OpByteCode_BeginForIn_Ireg_Ivalue_Ireg", 
    "OpByteCode_BeginForIn_Ireg_Rvalue_Ireg", 
    "OpByteCode_NextForInEntry_Ireg_Rvalue_Rvalue_Iaddr", 
    "OpByteCode_PushScope_Ivalue_Pad", 
    "OpByteCode_PushScope_Ivalue", 
    "OpByteCode_PushScope_Rvalue", 
    "OpByteCode_UnwindStacks_Iint32", 
    "OpByteCode_UnwindStacks_Rint32", 
    "OpByteCode_PopScope", 
    "OpByteCode_PopExceptionHandler", 
    "OpByteCode_PushExceptionHandler_Iaddr", 
    "OpByteCode_EnterCatch_Iident_Pad", 
    "OpByteCode_EnterCatch_Iident", 
    "OpByteCode_ExitCatch", 
    "OpByteCode_DeferCompletion", 
    "OpByteCode_ReactivateCompletion_Ibool", 
    "OpByteCode_ReactivateCompletion_Rbool", 
    "OpByteCode_ReactivateCompletionDebug_Ibool_Inode_Pad", 
    "OpByteCode_ReactivateCompletionDebug_Ibool_Inode", 
    "OpByteCode_ReactivateCompletionDebug_Rbool_Inode_Pad", 
    "OpByteCode_ReactivateCompletionDebug_Rbool_Inode", 
    "OpByteCode_Throw_Ivalue_Pad", 
    "OpByteCode_Throw_Ivalue", 
    "OpByteCode_Throw_Rvalue", 
    "OpByteCode_ContBreakInTryFinally_Iaddr", 
    "OpByteCode_ReturnInTryFinally_Ivalue_Pad", 
    "OpByteCode_ReturnInTryFinally_Ivalue", 
    "OpByteCode_ReturnInTryFinally_Rvalue", 
    "OpByteCode_PropagateException", 
    "OpByteCode_Return_Ivalue_Pad", 
    "OpByteCode_Return_Ivalue", 
    "OpByteCode_Return_Rvalue", 
    "OpByteCode_RaiseError_Inode_Iint32_Icstr_Pad", 
    "OpByteCode_RaiseError_Inode_Iint32_Icstr", 
    "OpByteCode_RaiseError_Inode_Rint32_Icstr_Pad", 
    "OpByteCode_RaiseError_Inode_Rint32_Icstr", 
    "OpByteCode_Preamble_Ireg_Ireg_Ireg", 
    "OpByteCode_EnterDebugContext_Inode_Pad", 
    "OpByteCode_EnterDebugContext_Inode", 
    "OpByteCode_ExitDebugContext_Inode_Pad", 
    "OpByteCode_ExitDebugContext_Inode", 
    "OpByteCode_FunctionLookupAndGet_Ireg_Ireg_Iident_Pad", 
    "OpByteCode_FunctionLookupAndGet_Ireg_Ireg_Iident", 
    "OpByteCode_NonLocalFunctionLookupAndGet_Ireg_Ireg_Iident_Pad", 
    "OpByteCode_NonLocalFunctionLookupAndGet_Ireg_Ireg_Iident", 
    "OpByteCode_ScopeLookupAndGetChecked_Ireg_Ireg_Iident_Pad", 
    "OpByteCode_ScopeLookupAndGetChecked_Ireg_Ireg_Iident", 
    "OpByteCode_ScopeLookupAndGet_Ireg_Ireg_Iident_Pad", 
    "OpByteCode_ScopeLookupAndGet_Ireg_Ireg_Iident", 
    "OpByteCode_NonLocalScopeLookupAndGetChecked_Ireg_Ireg_Iident_Pad", 
    "OpByteCode_NonLocalScopeLookupAndGetChecked_Ireg_Ireg_Iident", 
    "OpByteCode_NonLocalScopeLookupAndGet_Ireg_Ireg_Iident_Pad", 
    "OpByteCode_NonLocalScopeLookupAndGet_Ireg_Ireg_Iident", 
    "OpByteCode_ScopeLookup_Ireg_Iident_Inode_Pad", 
    "OpByteCode_ScopeLookup_Ireg_Iident_Inode", 
    "OpByteCode_NonLocalScopeLookup_Ireg_Iident_Inode_Pad", 
    "OpByteCode_NonLocalScopeLookup_Ireg_Iident_Inode", 
    "OpByteCode_VarGet_Ireg_Iident_Pad", 
    "OpByteCode_VarGet_Ireg_Iident", 
    "OpByteCode_NonLocalVarGet_Ireg_Iident_Pad", 
    "OpByteCode_NonLocalVarGet_Ireg_Iident", 
    "OpByteCode_RegPutValue_Ireg_Ivalue_Pad", 
    "OpByteCode_RegPutValue_Ireg_Ivalue", 
    "OpByteCode_RegPutValue_Ireg_Rvalue", 
    "OpByteCode_RegPutValue_Ireg_Rnumber", 
    "OpByteCode_RegPutNumber_Ireg_Inumber_Pad", 
    "OpByteCode_RegPutNumber_Ireg_Inumber", 
    "OpByteCode_RegPutNumber_Ireg_Rnumber", 
    "OpByteCode_RegPutBool_Ireg_Ibool", 
    "OpByteCode_RegPutBool_Ireg_Rbool", 
    "OpByteCode_RegPutInt32_Ireg_Iint32", 
    "OpByteCode_RegPutInt32_Ireg_Rint32", 
    "OpByteCode_ToObject_Ireg_Ivalue_Pad", 
    "OpByteCode_ToObject_Ireg_Ivalue", 
    "OpByteCode_ToObject_Ireg_Rvalue", 
    "OpByteCode_SymPutKnownObject_Rvalue_Iident_Ivalue_Pad", 
    "OpByteCode_SymPutKnownObject_Rvalue_Iident_Ivalue", 
    "OpByteCode_SymPutKnownObject_Rvalue_Iident_Rvalue_Pad", 
    "OpByteCode_SymPutKnownObject_Rvalue_Iident_Rvalue", 
    "OpByteCode_SymPutKnownObject_Rvalue_Iident_Rnumber_Pad", 
    "OpByteCode_SymPutKnownObject_Rvalue_Iident_Rnumber", 
    "OpByteCode_SymGet_Ireg_Ivalue_Iident_Pad", 
    "OpByteCode_SymGet_Ireg_Ivalue_Iident", 
    "OpByteCode_SymGet_Ireg_Rvalue_Iident_Pad", 
    "OpByteCode_SymGet_Ireg_Rvalue_Iident", 
    "OpByteCode_SymGetKnownObject_Ireg_Ivalue_Iident_Pad", 
    "OpByteCode_SymGetKnownObject_Ireg_Ivalue_Iident", 
    "OpByteCode_SymGetKnownObject_Ireg_Rvalue_Iident_Pad", 
    "OpByteCode_SymGetKnownObject_Ireg_Rvalue_Iident", 
    "OpByteCode_SymGetAndBind_Ireg_Ireg_Rvalue_Iident_Pad", 
    "OpByteCode_SymGetAndBind_Ireg_Ireg_Rvalue_Iident", 
    "OpByteCode_BracketGet_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_BracketGet_Ireg_Rvalue_Ivalue", 
    "OpByteCode_BracketGet_Ireg_Rvalue_Rvalue", 
    "OpByteCode_BracketGet_Ireg_Rvalue_Iint32", 
    "OpByteCode_BracketGet_Ireg_Rvalue_Rint32", 
    "OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Ivalue", 
    "OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Rvalue", 
    "OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Iint32", 
    "OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Rint32", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Ivalue_Ivalue_Pad", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Ivalue_Ivalue", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Ivalue_Rvalue_Pad", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Ivalue_Rvalue", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Rvalue_Ivalue_Pad", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Rvalue_Ivalue", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Rvalue_Rvalue", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Iint32_Ivalue_Pad", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Iint32_Ivalue", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Iint32_Rvalue", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Rint32_Ivalue_Pad", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Rint32_Ivalue", 
    "OpByteCode_BracketPutKnownObject_Rvalue_Rint32_Rvalue", 
    "OpByteCode_GlobalObjectGet_Ireg_Iident_Pad", 
    "OpByteCode_GlobalObjectGet_Ireg_Iident", 
    "OpByteCode_SymDeleteKnownObject_Ireg_Ivalue_Iident_Pad", 
    "OpByteCode_SymDeleteKnownObject_Ireg_Ivalue_Iident", 
    "OpByteCode_SymDeleteKnownObject_Ireg_Rvalue_Iident_Pad", 
    "OpByteCode_SymDeleteKnownObject_Ireg_Rvalue_Iident", 
    "OpByteCode_SymDelete_Ireg_Ivalue_Iident_Pad", 
    "OpByteCode_SymDelete_Ireg_Ivalue_Iident", 
    "OpByteCode_SymDelete_Ireg_Rvalue_Iident_Pad", 
    "OpByteCode_SymDelete_Ireg_Rvalue_Iident", 
    "OpByteCode_BracketDelete_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_BracketDelete_Ireg_Rvalue_Ivalue", 
    "OpByteCode_BracketDelete_Ireg_Rvalue_Rvalue", 
    "OpByteCode_BracketDelete_Ireg_Ivalue_Iint32_Pad", 
    "OpByteCode_BracketDelete_Ireg_Ivalue_Iint32", 
    "OpByteCode_BracketDelete_Ireg_Ivalue_Rint32_Pad", 
    "OpByteCode_BracketDelete_Ireg_Ivalue_Rint32", 
    "OpByteCode_BracketDelete_Ireg_Rvalue_Iint32", 
    "OpByteCode_BracketDelete_Ireg_Rvalue_Rint32", 
    "OpByteCode_OwnedString_Ireg_Istring_Pad", 
    "OpByteCode_OwnedString_Ireg_Istring", 
    "OpByteCode_NewEmptyArray_Ireg", 
    "OpByteCode_NewObject_Ireg", 
    "OpByteCode_NewRegExp_Ireg_Istring_Istring_Pad", 
    "OpByteCode_NewRegExp_Ireg_Istring_Istring", 
    "OpByteCode_DefineGetter_Rvalue_Iident_Ivalue_Pad", 
    "OpByteCode_DefineGetter_Rvalue_Iident_Ivalue", 
    "OpByteCode_DefineGetter_Rvalue_Iident_Rvalue_Pad", 
    "OpByteCode_DefineGetter_Rvalue_Iident_Rvalue", 
    "OpByteCode_DefineSetter_Rvalue_Iident_Ivalue_Pad", 
    "OpByteCode_DefineSetter_Rvalue_Iident_Ivalue", 
    "OpByteCode_DefineSetter_Rvalue_Iident_Rvalue_Pad", 
    "OpByteCode_DefineSetter_Rvalue_Iident_Rvalue", 
    "OpByteCode_Add1_Ireg_Inumber_Pad", 
    "OpByteCode_Add1_Ireg_Inumber", 
    "OpByteCode_Add1_Ireg_Rnumber", 
    "OpByteCode_Add1_Ireg_Rvalue", 
    "OpByteCode_Sub1_Ireg_Inumber_Pad", 
    "OpByteCode_Sub1_Ireg_Inumber", 
    "OpByteCode_Sub1_Ireg_Rnumber", 
    "OpByteCode_Neg_Ireg_Inumber_Pad", 
    "OpByteCode_Neg_Ireg_Inumber", 
    "OpByteCode_Neg_Ireg_Rnumber", 
    "OpByteCode_Neg_Ireg_Rvalue", 
    "OpByteCode_Mult_Ireg_Inumber_Inumber_Pad", 
    "OpByteCode_Mult_Ireg_Inumber_Inumber", 
    "OpByteCode_Mult_Ireg_Inumber_Rnumber_Pad", 
    "OpByteCode_Mult_Ireg_Inumber_Rnumber", 
    "OpByteCode_Mult_Ireg_Rnumber_Inumber_Pad", 
    "OpByteCode_Mult_Ireg_Rnumber_Inumber", 
    "OpByteCode_Mult_Ireg_Rnumber_Rnumber", 
    "OpByteCode_Mult_Ireg_Rvalue_Rvalue", 
    "OpByteCode_Mult_Ireg_Rvalue_Rnumber", 
    "OpByteCode_Mult_Ireg_Rnumber_Rvalue", 
    "OpByteCode_Div_Ireg_Inumber_Inumber_Pad", 
    "OpByteCode_Div_Ireg_Inumber_Inumber", 
    "OpByteCode_Div_Ireg_Inumber_Rnumber_Pad", 
    "OpByteCode_Div_Ireg_Inumber_Rnumber", 
    "OpByteCode_Div_Ireg_Rnumber_Inumber_Pad", 
    "OpByteCode_Div_Ireg_Rnumber_Inumber", 
    "OpByteCode_Div_Ireg_Rnumber_Rnumber", 
    "OpByteCode_Mod_Ireg_Inumber_Inumber_Pad", 
    "OpByteCode_Mod_Ireg_Inumber_Inumber", 
    "OpByteCode_Mod_Ireg_Inumber_Rnumber_Pad", 
    "OpByteCode_Mod_Ireg_Inumber_Rnumber", 
    "OpByteCode_Mod_Ireg_Rnumber_Inumber_Pad", 
    "OpByteCode_Mod_Ireg_Rnumber_Inumber", 
    "OpByteCode_Mod_Ireg_Rnumber_Rnumber", 
    "OpByteCode_Exp_Ireg_Inumber_Inumber_Pad", 
    "OpByteCode_Exp_Ireg_Inumber_Inumber", 
    "OpByteCode_Exp_Ireg_Inumber_Rnumber_Pad", 
    "OpByteCode_Exp_Ireg_Inumber_Rnumber", 
    "OpByteCode_Exp_Ireg_Rnumber_Inumber_Pad", 
    "OpByteCode_Exp_Ireg_Rnumber_Inumber", 
    "OpByteCode_Exp_Ireg_Rnumber_Rnumber", 
    "OpByteCode_Sub_Ireg_Inumber_Inumber_Pad", 
    "OpByteCode_Sub_Ireg_Inumber_Inumber", 
    "OpByteCode_Sub_Ireg_Inumber_Rnumber_Pad", 
    "OpByteCode_Sub_Ireg_Inumber_Rnumber", 
    "OpByteCode_Sub_Ireg_Rnumber_Inumber_Pad", 
    "OpByteCode_Sub_Ireg_Rnumber_Inumber", 
    "OpByteCode_Sub_Ireg_Rnumber_Rnumber", 
    "OpByteCode_Add_Ireg_Ivalue_Ivalue_Pad", 
    "OpByteCode_Add_Ireg_Ivalue_Ivalue", 
    "OpByteCode_Add_Ireg_Ivalue_Rvalue_Pad", 
    "OpByteCode_Add_Ireg_Ivalue_Rvalue", 
    "OpByteCode_Add_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_Add_Ireg_Rvalue_Ivalue", 
    "OpByteCode_Add_Ireg_Rvalue_Rvalue", 
    "OpByteCode_Add_Ireg_Inumber_Inumber_Pad", 
    "OpByteCode_Add_Ireg_Inumber_Inumber", 
    "OpByteCode_Add_Ireg_Inumber_Rnumber_Pad", 
    "OpByteCode_Add_Ireg_Inumber_Rnumber", 
    "OpByteCode_Add_Ireg_Rnumber_Inumber_Pad", 
    "OpByteCode_Add_Ireg_Rnumber_Inumber", 
    "OpByteCode_Add_Ireg_Rnumber_Rnumber", 
    "OpByteCode_LShift_Ireg_Iint32_Iint32", 
    "OpByteCode_LShift_Ireg_Iint32_Rint32", 
    "OpByteCode_LShift_Ireg_Rint32_Iint32", 
    "OpByteCode_LShift_Ireg_Rint32_Rint32", 
    "OpByteCode_RShift_Ireg_Iint32_Iint32", 
    "OpByteCode_RShift_Ireg_Iint32_Rint32", 
    "OpByteCode_RShift_Ireg_Rint32_Iint32", 
    "OpByteCode_RShift_Ireg_Rint32_Rint32", 
    "OpByteCode_URShift_Ireg_Iint32_Iint32", 
    "OpByteCode_URShift_Ireg_Iint32_Rint32", 
    "OpByteCode_URShift_Ireg_Rint32_Iint32", 
    "OpByteCode_URShift_Ireg_Rint32_Rint32", 
    "OpByteCode_Less_Ireg_Ivalue_Ivalue_Pad", 
    "OpByteCode_Less_Ireg_Ivalue_Ivalue", 
    "OpByteCode_Less_Ireg_Ivalue_Rvalue_Pad", 
    "OpByteCode_Less_Ireg_Ivalue_Rvalue", 
    "OpByteCode_Less_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_Less_Ireg_Rvalue_Ivalue", 
    "OpByteCode_Less_Ireg_Rvalue_Rvalue", 
    "OpByteCode_Less_Ireg_Ivalue_Inumber_Pad", 
    "OpByteCode_Less_Ireg_Ivalue_Inumber", 
    "OpByteCode_Less_Ireg_Ivalue_Rnumber_Pad", 
    "OpByteCode_Less_Ireg_Ivalue_Rnumber", 
    "OpByteCode_Less_Ireg_Rvalue_Inumber_Pad", 
    "OpByteCode_Less_Ireg_Rvalue_Inumber", 
    "OpByteCode_Less_Ireg_Rvalue_Rnumber", 
    "OpByteCode_Less_Ireg_Ivalue_Iint32_Pad", 
    "OpByteCode_Less_Ireg_Ivalue_Iint32", 
    "OpByteCode_Less_Ireg_Ivalue_Rint32_Pad", 
    "OpByteCode_Less_Ireg_Ivalue_Rint32", 
    "OpByteCode_Less_Ireg_Rvalue_Iint32", 
    "OpByteCode_Less_Ireg_Rvalue_Rint32", 
    "OpByteCode_GreaterEq_Ireg_Ivalue_Ivalue_Pad", 
    "OpByteCode_GreaterEq_Ireg_Ivalue_Ivalue", 
    "OpByteCode_GreaterEq_Ireg_Ivalue_Rvalue_Pad", 
    "OpByteCode_GreaterEq_Ireg_Ivalue_Rvalue", 
    "OpByteCode_GreaterEq_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_GreaterEq_Ireg_Rvalue_Ivalue", 
    "OpByteCode_GreaterEq_Ireg_Rvalue_Rvalue", 
    "OpByteCode_Greater_Ireg_Ivalue_Ivalue_Pad", 
    "OpByteCode_Greater_Ireg_Ivalue_Ivalue", 
    "OpByteCode_Greater_Ireg_Ivalue_Rvalue_Pad", 
    "OpByteCode_Greater_Ireg_Ivalue_Rvalue", 
    "OpByteCode_Greater_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_Greater_Ireg_Rvalue_Ivalue", 
    "OpByteCode_Greater_Ireg_Rvalue_Rvalue", 
    "OpByteCode_LessEq_Ireg_Ivalue_Ivalue_Pad", 
    "OpByteCode_LessEq_Ireg_Ivalue_Ivalue", 
    "OpByteCode_LessEq_Ireg_Ivalue_Rvalue_Pad", 
    "OpByteCode_LessEq_Ireg_Ivalue_Rvalue", 
    "OpByteCode_LessEq_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_LessEq_Ireg_Rvalue_Ivalue", 
    "OpByteCode_LessEq_Ireg_Rvalue_Rvalue", 
    "OpByteCode_EqEq_Ireg_Ivalue_Ivalue_Pad", 
    "OpByteCode_EqEq_Ireg_Ivalue_Ivalue", 
    "OpByteCode_EqEq_Ireg_Ivalue_Rvalue_Pad", 
    "OpByteCode_EqEq_Ireg_Ivalue_Rvalue", 
    "OpByteCode_EqEq_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_EqEq_Ireg_Rvalue_Ivalue", 
    "OpByteCode_EqEq_Ireg_Rvalue_Rvalue", 
    "OpByteCode_EqEq_Ireg_Ivalue_Iint32_Pad", 
    "OpByteCode_EqEq_Ireg_Ivalue_Iint32", 
    "OpByteCode_EqEq_Ireg_Ivalue_Rint32_Pad", 
    "OpByteCode_EqEq_Ireg_Ivalue_Rint32", 
    "OpByteCode_EqEq_Ireg_Rvalue_Iint32", 
    "OpByteCode_EqEq_Ireg_Rvalue_Rint32", 
    "OpByteCode_NotEq_Ireg_Ivalue_Ivalue_Pad", 
    "OpByteCode_NotEq_Ireg_Ivalue_Ivalue", 
    "OpByteCode_NotEq_Ireg_Ivalue_Rvalue_Pad", 
    "OpByteCode_NotEq_Ireg_Ivalue_Rvalue", 
    "OpByteCode_NotEq_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_NotEq_Ireg_Rvalue_Ivalue", 
    "OpByteCode_NotEq_Ireg_Rvalue_Rvalue", 
    "OpByteCode_NotEq_Ireg_Ivalue_Iint32_Pad", 
    "OpByteCode_NotEq_Ireg_Ivalue_Iint32", 
    "OpByteCode_NotEq_Ireg_Ivalue_Rint32_Pad", 
    "OpByteCode_NotEq_Ireg_Ivalue_Rint32", 
    "OpByteCode_NotEq_Ireg_Rvalue_Iint32", 
    "OpByteCode_NotEq_Ireg_Rvalue_Rint32", 
    "OpByteCode_StrEq_Ireg_Ivalue_Ivalue_Pad", 
    "OpByteCode_StrEq_Ireg_Ivalue_Ivalue", 
    "OpByteCode_StrEq_Ireg_Ivalue_Rvalue_Pad", 
    "OpByteCode_StrEq_Ireg_Ivalue_Rvalue", 
    "OpByteCode_StrEq_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_StrEq_Ireg_Rvalue_Ivalue", 
    "OpByteCode_StrEq_Ireg_Rvalue_Rvalue", 
    "OpByteCode_StrNEq_Ireg_Ivalue_Ivalue_Pad", 
    "OpByteCode_StrNEq_Ireg_Ivalue_Ivalue", 
    "OpByteCode_StrNEq_Ireg_Ivalue_Rvalue_Pad", 
    "OpByteCode_StrNEq_Ireg_Ivalue_Rvalue", 
    "OpByteCode_StrNEq_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_StrNEq_Ireg_Rvalue_Ivalue", 
    "OpByteCode_StrNEq_Ireg_Rvalue_Rvalue", 
    "OpByteCode_BitNot_Ireg_Iint32", 
    "OpByteCode_BitNot_Ireg_Rint32", 
    "OpByteCode_BitAnd_Ireg_Iint32_Iint32", 
    "OpByteCode_BitAnd_Ireg_Iint32_Rint32", 
    "OpByteCode_BitAnd_Ireg_Rint32_Iint32", 
    "OpByteCode_BitAnd_Ireg_Rint32_Rint32", 
    "OpByteCode_BitAnd_Ireg_Rvalue_Rvalue", 
    "OpByteCode_BitAnd_Ireg_Rvalue_Rint32", 
    "OpByteCode_BitAnd_Ireg_Rint32_Rvalue", 
    "OpByteCode_BitXOr_Ireg_Iint32_Iint32", 
    "OpByteCode_BitXOr_Ireg_Iint32_Rint32", 
    "OpByteCode_BitXOr_Ireg_Rint32_Iint32", 
    "OpByteCode_BitXOr_Ireg_Rint32_Rint32", 
    "OpByteCode_BitOr_Ireg_Iint32_Iint32", 
    "OpByteCode_BitOr_Ireg_Iint32_Rint32", 
    "OpByteCode_BitOr_Ireg_Rint32_Iint32", 
    "OpByteCode_BitOr_Ireg_Rint32_Rint32", 
    "OpByteCode_LogicalNot_Ireg_Ibool", 
    "OpByteCode_LogicalNot_Ireg_Rbool", 
    "OpByteCode_TypeOf_Ireg_Ivalue_Pad", 
    "OpByteCode_TypeOf_Ireg_Ivalue", 
    "OpByteCode_TypeOf_Ireg_Rvalue", 
    "OpByteCode_In_Ireg_Ivalue_Ivalue_Pad", 
    "OpByteCode_In_Ireg_Ivalue_Ivalue", 
    "OpByteCode_In_Ireg_Ivalue_Rvalue_Pad", 
    "OpByteCode_In_Ireg_Ivalue_Rvalue", 
    "OpByteCode_In_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_In_Ireg_Rvalue_Ivalue", 
    "OpByteCode_In_Ireg_Rvalue_Rvalue", 
    "OpByteCode_InstanceOf_Ireg_Ivalue_Ivalue_Pad", 
    "OpByteCode_InstanceOf_Ireg_Ivalue_Ivalue", 
    "OpByteCode_InstanceOf_Ireg_Ivalue_Rvalue_Pad", 
    "OpByteCode_InstanceOf_Ireg_Ivalue_Rvalue", 
    "OpByteCode_InstanceOf_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_InstanceOf_Ireg_Rvalue_Ivalue", 
    "OpByteCode_InstanceOf_Ireg_Rvalue_Rvalue", 
    "OpByteCode_ClearArgs", 
    "OpByteCode_AddArg_Ivalue_Pad", 
    "OpByteCode_AddArg_Ivalue", 
    "OpByteCode_AddArg_Rvalue", 
    "OpByteCode_Add2Arg_Ivalue_Ivalue_Pad", 
    "OpByteCode_Add2Arg_Ivalue_Ivalue", 
    "OpByteCode_Add2Arg_Ivalue_Rvalue_Pad", 
    "OpByteCode_Add2Arg_Ivalue_Rvalue", 
    "OpByteCode_Add2Arg_Rvalue_Ivalue_Pad", 
    "OpByteCode_Add2Arg_Rvalue_Ivalue", 
    "OpByteCode_Add2Arg_Rvalue_Rvalue", 
    "OpByteCode_Add3Arg_Ivalue_Ivalue_Ivalue_Pad", 
    "OpByteCode_Add3Arg_Ivalue_Ivalue_Ivalue", 
    "OpByteCode_Add3Arg_Ivalue_Ivalue_Rvalue_Pad", 
    "OpByteCode_Add3Arg_Ivalue_Ivalue_Rvalue", 
    "OpByteCode_Add3Arg_Ivalue_Rvalue_Ivalue_Pad", 
    "OpByteCode_Add3Arg_Ivalue_Rvalue_Ivalue", 
    "OpByteCode_Add3Arg_Ivalue_Rvalue_Rvalue_Pad", 
    "OpByteCode_Add3Arg_Ivalue_Rvalue_Rvalue", 
    "OpByteCode_Add3Arg_Rvalue_Ivalue_Ivalue_Pad", 
    "OpByteCode_Add3Arg_Rvalue_Ivalue_Ivalue", 
    "OpByteCode_Add3Arg_Rvalue_Ivalue_Rvalue_Pad", 
    "OpByteCode_Add3Arg_Rvalue_Ivalue_Rvalue", 
    "OpByteCode_Add3Arg_Rvalue_Rvalue_Ivalue_Pad", 
    "OpByteCode_Add3Arg_Rvalue_Rvalue_Ivalue", 
    "OpByteCode_Add3Arg_Rvalue_Rvalue_Rvalue", 
    "OpByteCode_FunctionCall_Ireg_Ivalue_Ivalue_Pad", 
    "OpByteCode_FunctionCall_Ireg_Ivalue_Ivalue", 
    "OpByteCode_FunctionCall_Ireg_Ivalue_Rvalue_Pad", 
    "OpByteCode_FunctionCall_Ireg_Ivalue_Rvalue", 
    "OpByteCode_FunctionCall_Ireg_Rvalue_Ivalue_Pad", 
    "OpByteCode_FunctionCall_Ireg_Rvalue_Ivalue", 
    "OpByteCode_FunctionCall_Ireg_Rvalue_Rvalue", 
    "OpByteCode_CtorCall_Ireg_Ivalue_Pad", 
    "OpByteCode_CtorCall_Ireg_Ivalue", 
    "OpByteCode_CtorCall_Ireg_Rvalue", 
    "OpByteCode_EvalFuncExpr_Ireg_Iident_Inode_Pad", 
    "OpByteCode_EvalFuncExpr_Ireg_Iident_Inode"
};

const Op opsForOpCodes[] = {
    {Op_RBool_Int32, OpByteCode_RBool_Int32_Ireg_Ibool, 0, 2, {OpType_reg, OpType_bool}, {true, true}, {false, true}, OpType_int32, 12, {4, 8}, false, false, false},
    {Op_RBool_Int32, OpByteCode_RBool_Int32_Ireg_Rbool, 0, 2, {OpType_reg, OpType_bool}, {true, false}, {false, true}, OpType_int32, 12, {4, 8}, false, false, false},
    {Op_RBool_Value, OpByteCode_RBool_Value_Ireg_Ibool, 0, 2, {OpType_reg, OpType_bool}, {true, true}, {false, true}, OpType_value, 12, {4, 8}, false, false, false},
    {Op_RBool_Value, OpByteCode_RBool_Value_Ireg_Rbool, 0, 2, {OpType_reg, OpType_bool}, {true, false}, {false, true}, OpType_value, 12, {4, 8}, false, false, false},
    {Op_RBool_Number, OpByteCode_RBool_Number_Ireg_Ibool, 0, 2, {OpType_reg, OpType_bool}, {true, true}, {false, true}, OpType_number, 12, {4, 8}, false, false, false},
    {Op_RBool_Number, OpByteCode_RBool_Number_Ireg_Rbool, 0, 2, {OpType_reg, OpType_bool}, {true, false}, {false, true}, OpType_number, 12, {4, 8}, false, false, false},
    {Op_RValue_Bool, OpByteCode_RValue_Bool_Ireg_Ivalue_Pad, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, true}, OpType_bool, 20, {16, 8}, true, true, false},
    {Op_RValue_Bool, OpByteCode_RValue_Bool_Ireg_Ivalue, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, true}, OpType_bool, 16, {12, 4}, false, true, false},
    {Op_RValue_Bool, OpByteCode_RValue_Bool_Ireg_Rvalue, 0, 2, {OpType_reg, OpType_value}, {true, false}, {false, true}, OpType_bool, 12, {4, 8}, false, false, false},
    {Op_RValue_Int32, OpByteCode_RValue_Int32_Ireg_Ivalue_Pad, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, true}, OpType_int32, 20, {16, 8}, true, true, false},
    {Op_RValue_Int32, OpByteCode_RValue_Int32_Ireg_Ivalue, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, true}, OpType_int32, 16, {12, 4}, false, true, false},
    {Op_RValue_Int32, OpByteCode_RValue_Int32_Ireg_Rvalue, 0, 2, {OpType_reg, OpType_value}, {true, false}, {false, true}, OpType_int32, 12, {4, 8}, false, false, false},
    {Op_RValue_Number, OpByteCode_RValue_Number_Ireg_Ivalue_Pad, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, true}, OpType_number, 20, {16, 8}, true, true, false},
    {Op_RValue_Number, OpByteCode_RValue_Number_Ireg_Ivalue, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, true}, OpType_number, 16, {12, 4}, false, true, false},
    {Op_RValue_Number, OpByteCode_RValue_Number_Ireg_Rvalue, 0, 2, {OpType_reg, OpType_value}, {true, false}, {false, true}, OpType_number, 12, {4, 8}, false, false, false},
    {Op_RInt32_Bool, OpByteCode_RInt32_Bool_Ireg_Iint32, 0, 2, {OpType_reg, OpType_int32}, {true, true}, {false, true}, OpType_bool, 12, {4, 8}, false, false, false},
    {Op_RInt32_Bool, OpByteCode_RInt32_Bool_Ireg_Rint32, 0, 2, {OpType_reg, OpType_int32}, {true, false}, {false, true}, OpType_bool, 12, {4, 8}, false, false, false},
    {Op_RInt32_Value, OpByteCode_RInt32_Value_Ireg_Iint32, 0, 2, {OpType_reg, OpType_int32}, {true, true}, {false, true}, OpType_value, 12, {4, 8}, false, false, false},
    {Op_RInt32_Value, OpByteCode_RInt32_Value_Ireg_Rint32, 0, 2, {OpType_reg, OpType_int32}, {true, false}, {false, true}, OpType_value, 12, {4, 8}, false, false, false},
    {Op_RInt32_Number, OpByteCode_RInt32_Number_Ireg_Iint32, 0, 2, {OpType_reg, OpType_int32}, {true, true}, {false, true}, OpType_number, 12, {4, 8}, false, false, false},
    {Op_RInt32_Number, OpByteCode_RInt32_Number_Ireg_Rint32, 0, 2, {OpType_reg, OpType_int32}, {true, false}, {false, true}, OpType_number, 12, {4, 8}, false, false, false},
    {Op_RNumber_Bool, OpByteCode_RNumber_Bool_Ireg_Inumber_Pad, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, true}, OpType_bool, 20, {16, 8}, true, true, false},
    {Op_RNumber_Bool, OpByteCode_RNumber_Bool_Ireg_Inumber, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, true}, OpType_bool, 16, {12, 4}, false, true, false},
    {Op_RNumber_Bool, OpByteCode_RNumber_Bool_Ireg_Rnumber, 0, 2, {OpType_reg, OpType_number}, {true, false}, {false, true}, OpType_bool, 12, {4, 8}, false, false, false},
    {Op_RNumber_Value, OpByteCode_RNumber_Value_Ireg_Inumber_Pad, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, true}, OpType_value, 20, {16, 8}, true, true, false},
    {Op_RNumber_Value, OpByteCode_RNumber_Value_Ireg_Inumber, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, true}, OpType_value, 16, {12, 4}, false, true, false},
    {Op_RNumber_Value, OpByteCode_RNumber_Value_Ireg_Rnumber, 0, 2, {OpType_reg, OpType_number}, {true, false}, {false, true}, OpType_value, 12, {4, 8}, false, false, false},
    {Op_RNumber_Int32, OpByteCode_RNumber_Int32_Ireg_Inumber_Pad, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, true}, OpType_int32, 20, {16, 8}, true, true, false},
    {Op_RNumber_Int32, OpByteCode_RNumber_Int32_Ireg_Inumber, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, true}, OpType_int32, 16, {12, 4}, false, true, false},
    {Op_RNumber_Int32, OpByteCode_RNumber_Int32_Ireg_Rnumber, 0, 2, {OpType_reg, OpType_number}, {true, false}, {false, true}, OpType_int32, 12, {4, 8}, false, false, false},
    {Op_RInt32_Value_NonImm, OpByteCode_RInt32_Value_NonImm_Ireg_Iint32, 0, 2, {OpType_reg, OpType_int32}, {true, true}, {false, false}, OpType_value, 12, {4, 8}, false, false, false},
    {Op_RInt32_Value_NonImm, OpByteCode_RInt32_Value_NonImm_Ireg_Rint32, 0, 2, {OpType_reg, OpType_int32}, {true, false}, {false, false}, OpType_value, 12, {4, 8}, false, false, false},
    {Op_RNum_Value_NonImm, OpByteCode_RNum_Value_NonImm_Ireg_Inumber_Pad, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, false}, OpType_value, 20, {16, 8}, true, true, false},
    {Op_RNum_Value_NonImm, OpByteCode_RNum_Value_NonImm_Ireg_Inumber, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, false}, OpType_value, 16, {12, 4}, false, true, false},
    {Op_RNum_Value_NonImm, OpByteCode_RNum_Value_NonImm_Ireg_Rnumber, 0, 2, {OpType_reg, OpType_number}, {true, false}, {false, false}, OpType_value, 12, {4, 8}, false, false, false},
    {Op_PrintInfo, OpByteCode_PrintInfo_Ivalue_Pad, 0, 1, {OpType_value}, {true}, {false}, OpType_void, 16, {8}, true, true, false},
    {Op_PrintInfo, OpByteCode_PrintInfo_Ivalue, 0, 1, {OpType_value}, {true}, {false}, OpType_void, 12, {4}, false, true, false},
    {Op_PrintInfo, OpByteCode_PrintInfo_Rvalue, 0, 1, {OpType_value}, {false}, {false}, OpType_void, 8, {4}, false, false, false},
    {Op_AtStatement, OpByteCode_AtStatement_Inode_Pad, 0, 1, {OpType_node}, {true}, {false}, OpType_void, 16, {8}, true, true, false},
    {Op_AtStatement, OpByteCode_AtStatement_Inode, 0, 1, {OpType_node}, {true}, {false}, OpType_void, 12, {4}, false, true, false},
    {Op_Exit, OpByteCode_Exit, 0, 0, {}, {}, {}, OpType_void, 4, {}, false, false, true},
    {Op_Jump, OpByteCode_Jump_Iaddr, 0, 1, {OpType_addr}, {true}, {false}, OpType_void, 8, {4}, false, false, true},
    {Op_IfJump, OpByteCode_IfJump_Ibool_Iaddr, 0, 2, {OpType_bool, OpType_addr}, {true, true}, {false, false}, OpType_void, 12, {4, 8}, false, false, true},
    {Op_IfJump, OpByteCode_IfJump_Rbool_Iaddr, 0, 2, {OpType_bool, OpType_addr}, {false, true}, {false, false}, OpType_void, 12, {4, 8}, false, false, true},
    {Op_IfJump, OpByteCode_IfJump_Rvalue_Iaddr, 5, 2, {OpType_value, OpType_addr}, {false, true}, {false, false}, OpType_void, 12, {4, 8}, false, false, true},
    {Op_IfNotJump, OpByteCode_IfNotJump_Ibool_Iaddr, 0, 2, {OpType_bool, OpType_addr}, {true, true}, {false, false}, OpType_void, 12, {4, 8}, false, false, true},
    {Op_IfNotJump, OpByteCode_IfNotJump_Rbool_Iaddr, 0, 2, {OpType_bool, OpType_addr}, {false, true}, {false, false}, OpType_void, 12, {4, 8}, false, false, true},
    {Op_IfNotJump, OpByteCode_IfNotJump_Rvalue_Iaddr, 5, 2, {OpType_value, OpType_addr}, {false, true}, {false, false}, OpType_void, 12, {4, 8}, false, false, true},
    {Op_BeginForIn, OpByteCode_BeginForIn_Ireg_Ivalue_Ireg_Pad, 0, 3, {OpType_reg, OpType_value, OpType_reg}, {true, true, true}, {false, false, false}, OpType_value, 24, {16, 8, 20}, true, true, true},
    {Op_BeginForIn, OpByteCode_BeginForIn_Ireg_Ivalue_Ireg, 0, 3, {OpType_reg, OpType_value, OpType_reg}, {true, true, true}, {false, false, false}, OpType_value, 20, {12, 4, 16}, false, true, true},
    {Op_BeginForIn, OpByteCode_BeginForIn_Ireg_Rvalue_Ireg, 0, 3, {OpType_reg, OpType_value, OpType_reg}, {true, false, true}, {false, false, false}, OpType_value, 16, {4, 8, 12}, false, false, true},
    {Op_NextForInEntry, OpByteCode_NextForInEntry_Ireg_Rvalue_Rvalue_Iaddr, 0, 4, {OpType_reg, OpType_value, OpType_value, OpType_addr}, {true, false, false, true}, {false, false, false, false}, OpType_value, 20, {4, 8, 12, 16}, false, false, false},
    {Op_PushScope, OpByteCode_PushScope_Ivalue_Pad, 0, 1, {OpType_value}, {true}, {false}, OpType_void, 16, {8}, true, true, false},
    {Op_PushScope, OpByteCode_PushScope_Ivalue, 0, 1, {OpType_value}, {true}, {false}, OpType_void, 12, {4}, false, true, false},
    {Op_PushScope, OpByteCode_PushScope_Rvalue, 0, 1, {OpType_value}, {false}, {false}, OpType_void, 8, {4}, false, false, false},
    {Op_UnwindStacks, OpByteCode_UnwindStacks_Iint32, 0, 1, {OpType_int32}, {true}, {false}, OpType_void, 8, {4}, false, false, false},
    {Op_UnwindStacks, OpByteCode_UnwindStacks_Rint32, 0, 1, {OpType_int32}, {false}, {false}, OpType_void, 8, {4}, false, false, false},
    {Op_PopScope, OpByteCode_PopScope, 0, 0, {}, {}, {}, OpType_void, 4, {}, false, false, false},
    {Op_PopExceptionHandler, OpByteCode_PopExceptionHandler, 0, 0, {}, {}, {}, OpType_void, 4, {}, false, false, false},
    {Op_PushExceptionHandler, OpByteCode_PushExceptionHandler_Iaddr, 0, 1, {OpType_addr}, {true}, {false}, OpType_void, 8, {4}, false, false, false},
    {Op_EnterCatch, OpByteCode_EnterCatch_Iident_Pad, 0, 1, {OpType_ident}, {true}, {false}, OpType_void, 16, {8}, true, true, false},
    {Op_EnterCatch, OpByteCode_EnterCatch_Iident, 0, 1, {OpType_ident}, {true}, {false}, OpType_void, 12, {4}, false, true, false},
    {Op_ExitCatch, OpByteCode_ExitCatch, 0, 0, {}, {}, {}, OpType_void, 4, {}, false, false, false},
    {Op_DeferCompletion, OpByteCode_DeferCompletion, 0, 0, {}, {}, {}, OpType_void, 4, {}, false, false, false},
    {Op_ReactivateCompletion, OpByteCode_ReactivateCompletion_Ibool, 0, 1, {OpType_bool}, {true}, {false}, OpType_void, 8, {4}, false, false, false},
    {Op_ReactivateCompletion, OpByteCode_ReactivateCompletion_Rbool, 0, 1, {OpType_bool}, {false}, {false}, OpType_void, 8, {4}, false, false, false},
    {Op_ReactivateCompletionDebug, OpByteCode_ReactivateCompletionDebug_Ibool_Inode_Pad, 0, 2, {OpType_bool, OpType_node}, {true, true}, {false, false}, OpType_void, 20, {16, 8}, true, true, false},
    {Op_ReactivateCompletionDebug, OpByteCode_ReactivateCompletionDebug_Ibool_Inode, 0, 2, {OpType_bool, OpType_node}, {true, true}, {false, false}, OpType_void, 16, {12, 4}, false, true, false},
    {Op_ReactivateCompletionDebug, OpByteCode_ReactivateCompletionDebug_Rbool_Inode_Pad, 0, 2, {OpType_bool, OpType_node}, {false, true}, {false, false}, OpType_void, 20, {16, 8}, true, true, false},
    {Op_ReactivateCompletionDebug, OpByteCode_ReactivateCompletionDebug_Rbool_Inode, 0, 2, {OpType_bool, OpType_node}, {false, true}, {false, false}, OpType_void, 16, {12, 4}, false, true, false},
    {Op_Throw, OpByteCode_Throw_Ivalue_Pad, 0, 1, {OpType_value}, {true}, {false}, OpType_void, 16, {8}, true, true, false},
    {Op_Throw, OpByteCode_Throw_Ivalue, 0, 1, {OpType_value}, {true}, {false}, OpType_void, 12, {4}, false, true, false},
    {Op_Throw, OpByteCode_Throw_Rvalue, 0, 1, {OpType_value}, {false}, {false}, OpType_void, 8, {4}, false, false, false},
    {Op_ContBreakInTryFinally, OpByteCode_ContBreakInTryFinally_Iaddr, 0, 1, {OpType_addr}, {true}, {false}, OpType_void, 8, {4}, false, false, false},
    {Op_ReturnInTryFinally, OpByteCode_ReturnInTryFinally_Ivalue_Pad, 0, 1, {OpType_value}, {true}, {false}, OpType_void, 16, {8}, true, true, false},
    {Op_ReturnInTryFinally, OpByteCode_ReturnInTryFinally_Ivalue, 0, 1, {OpType_value}, {true}, {false}, OpType_void, 12, {4}, false, true, false},
    {Op_ReturnInTryFinally, OpByteCode_ReturnInTryFinally_Rvalue, 0, 1, {OpType_value}, {false}, {false}, OpType_void, 8, {4}, false, false, false},
    {Op_PropagateException, OpByteCode_PropagateException, 0, 0, {}, {}, {}, OpType_void, 4, {}, false, false, false},
    {Op_Return, OpByteCode_Return_Ivalue_Pad, 0, 1, {OpType_value}, {true}, {false}, OpType_void, 16, {8}, true, true, true},
    {Op_Return, OpByteCode_Return_Ivalue, 0, 1, {OpType_value}, {true}, {false}, OpType_void, 12, {4}, false, true, true},
    {Op_Return, OpByteCode_Return_Rvalue, 0, 1, {OpType_value}, {false}, {false}, OpType_void, 8, {4}, false, false, true},
    {Op_RaiseError, OpByteCode_RaiseError_Inode_Iint32_Icstr_Pad, 0, 3, {OpType_node, OpType_int32, OpType_cstr}, {true, true, true}, {false, false, false}, OpType_void, 28, {8, 24, 16}, true, true, false},
    {Op_RaiseError, OpByteCode_RaiseError_Inode_Iint32_Icstr, 0, 3, {OpType_node, OpType_int32, OpType_cstr}, {true, true, true}, {false, false, false}, OpType_void, 24, {4, 20, 12}, false, true, false},
    {Op_RaiseError, OpByteCode_RaiseError_Inode_Rint32_Icstr_Pad, 0, 3, {OpType_node, OpType_int32, OpType_cstr}, {true, false, true}, {false, false, false}, OpType_void, 28, {8, 24, 16}, true, true, false},
    {Op_RaiseError, OpByteCode_RaiseError_Inode_Rint32_Icstr, 0, 3, {OpType_node, OpType_int32, OpType_cstr}, {true, false, true}, {false, false, false}, OpType_void, 24, {4, 20, 12}, false, true, false},
    {Op_Preamble, OpByteCode_Preamble_Ireg_Ireg_Ireg, 0, 3, {OpType_reg, OpType_reg, OpType_reg}, {true, true, true}, {false, false, false}, OpType_void, 16, {4, 8, 12}, false, false, false},
    {Op_EnterDebugContext, OpByteCode_EnterDebugContext_Inode_Pad, 0, 1, {OpType_node}, {true}, {false}, OpType_void, 16, {8}, true, true, false},
    {Op_EnterDebugContext, OpByteCode_EnterDebugContext_Inode, 0, 1, {OpType_node}, {true}, {false}, OpType_void, 12, {4}, false, true, false},
    {Op_ExitDebugContext, OpByteCode_ExitDebugContext_Inode_Pad, 0, 1, {OpType_node}, {true}, {false}, OpType_void, 16, {8}, true, true, false},
    {Op_ExitDebugContext, OpByteCode_ExitDebugContext_Inode, 0, 1, {OpType_node}, {true}, {false}, OpType_void, 12, {4}, false, true, false},
    {Op_FunctionLookupAndGet, OpByteCode_FunctionLookupAndGet_Ireg_Ireg_Iident_Pad, 0, 3, {OpType_reg, OpType_reg, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 24, {16, 20, 8}, true, true, false},
    {Op_FunctionLookupAndGet, OpByteCode_FunctionLookupAndGet_Ireg_Ireg_Iident, 0, 3, {OpType_reg, OpType_reg, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 20, {12, 16, 4}, false, true, false},
    {Op_NonLocalFunctionLookupAndGet, OpByteCode_NonLocalFunctionLookupAndGet_Ireg_Ireg_Iident_Pad, 0, 3, {OpType_reg, OpType_reg, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 24, {16, 20, 8}, true, true, false},
    {Op_NonLocalFunctionLookupAndGet, OpByteCode_NonLocalFunctionLookupAndGet_Ireg_Ireg_Iident, 0, 3, {OpType_reg, OpType_reg, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 20, {12, 16, 4}, false, true, false},
    {Op_ScopeLookupAndGetChecked, OpByteCode_ScopeLookupAndGetChecked_Ireg_Ireg_Iident_Pad, 0, 3, {OpType_reg, OpType_reg, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 24, {16, 20, 8}, true, true, false},
    {Op_ScopeLookupAndGetChecked, OpByteCode_ScopeLookupAndGetChecked_Ireg_Ireg_Iident, 0, 3, {OpType_reg, OpType_reg, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 20, {12, 16, 4}, false, true, false},
    {Op_ScopeLookupAndGet, OpByteCode_ScopeLookupAndGet_Ireg_Ireg_Iident_Pad, 0, 3, {OpType_reg, OpType_reg, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 24, {16, 20, 8}, true, true, false},
    {Op_ScopeLookupAndGet, OpByteCode_ScopeLookupAndGet_Ireg_Ireg_Iident, 0, 3, {OpType_reg, OpType_reg, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 20, {12, 16, 4}, false, true, false},
    {Op_NonLocalScopeLookupAndGetChecked, OpByteCode_NonLocalScopeLookupAndGetChecked_Ireg_Ireg_Iident_Pad, 0, 3, {OpType_reg, OpType_reg, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 24, {16, 20, 8}, true, true, false},
    {Op_NonLocalScopeLookupAndGetChecked, OpByteCode_NonLocalScopeLookupAndGetChecked_Ireg_Ireg_Iident, 0, 3, {OpType_reg, OpType_reg, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 20, {12, 16, 4}, false, true, false},
    {Op_NonLocalScopeLookupAndGet, OpByteCode_NonLocalScopeLookupAndGet_Ireg_Ireg_Iident_Pad, 0, 3, {OpType_reg, OpType_reg, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 24, {16, 20, 8}, true, true, false},
    {Op_NonLocalScopeLookupAndGet, OpByteCode_NonLocalScopeLookupAndGet_Ireg_Ireg_Iident, 0, 3, {OpType_reg, OpType_reg, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 20, {12, 16, 4}, false, true, false},
    {Op_ScopeLookup, OpByteCode_ScopeLookup_Ireg_Iident_Inode_Pad, 0, 3, {OpType_reg, OpType_ident, OpType_node}, {true, true, true}, {false, false, false}, OpType_value, 28, {24, 8, 16}, true, true, false},
    {Op_ScopeLookup, OpByteCode_ScopeLookup_Ireg_Iident_Inode, 0, 3, {OpType_reg, OpType_ident, OpType_node}, {true, true, true}, {false, false, false}, OpType_value, 24, {20, 4, 12}, false, true, false},
    {Op_NonLocalScopeLookup, OpByteCode_NonLocalScopeLookup_Ireg_Iident_Inode_Pad, 0, 3, {OpType_reg, OpType_ident, OpType_node}, {true, true, true}, {false, false, false}, OpType_value, 28, {24, 8, 16}, true, true, false},
    {Op_NonLocalScopeLookup, OpByteCode_NonLocalScopeLookup_Ireg_Iident_Inode, 0, 3, {OpType_reg, OpType_ident, OpType_node}, {true, true, true}, {false, false, false}, OpType_value, 24, {20, 4, 12}, false, true, false},
    {Op_VarGet, OpByteCode_VarGet_Ireg_Iident_Pad, 0, 2, {OpType_reg, OpType_ident}, {true, true}, {false, false}, OpType_value, 20, {16, 8}, true, true, false},
    {Op_VarGet, OpByteCode_VarGet_Ireg_Iident, 0, 2, {OpType_reg, OpType_ident}, {true, true}, {false, false}, OpType_value, 16, {12, 4}, false, true, false},
    {Op_NonLocalVarGet, OpByteCode_NonLocalVarGet_Ireg_Iident_Pad, 0, 2, {OpType_reg, OpType_ident}, {true, true}, {false, false}, OpType_value, 20, {16, 8}, true, true, false},
    {Op_NonLocalVarGet, OpByteCode_NonLocalVarGet_Ireg_Iident, 0, 2, {OpType_reg, OpType_ident}, {true, true}, {false, false}, OpType_value, 16, {12, 4}, false, true, false},
    {Op_RegPutValue, OpByteCode_RegPutValue_Ireg_Ivalue_Pad, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, false}, OpType_void, 20, {16, 8}, true, true, false},
    {Op_RegPutValue, OpByteCode_RegPutValue_Ireg_Ivalue, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, false}, OpType_void, 16, {12, 4}, false, true, false},
    {Op_RegPutValue, OpByteCode_RegPutValue_Ireg_Rvalue, 0, 2, {OpType_reg, OpType_value}, {true, false}, {false, false}, OpType_void, 12, {4, 8}, false, false, false},
    {Op_RegPutValue, OpByteCode_RegPutValue_Ireg_Rnumber, 15, 2, {OpType_reg, OpType_number}, {true, false}, {false, false}, OpType_void, 12, {4, 8}, false, false, false},
    {Op_RegPutNumber, OpByteCode_RegPutNumber_Ireg_Inumber_Pad, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, false}, OpType_void, 20, {16, 8}, true, true, false},
    {Op_RegPutNumber, OpByteCode_RegPutNumber_Ireg_Inumber, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, false}, OpType_void, 16, {12, 4}, false, true, false},
    {Op_RegPutNumber, OpByteCode_RegPutNumber_Ireg_Rnumber, 0, 2, {OpType_reg, OpType_number}, {true, false}, {false, false}, OpType_void, 12, {4, 8}, false, false, false},
    {Op_RegPutBool, OpByteCode_RegPutBool_Ireg_Ibool, 0, 2, {OpType_reg, OpType_bool}, {true, true}, {false, false}, OpType_void, 12, {4, 8}, false, false, false},
    {Op_RegPutBool, OpByteCode_RegPutBool_Ireg_Rbool, 0, 2, {OpType_reg, OpType_bool}, {true, false}, {false, false}, OpType_void, 12, {4, 8}, false, false, false},
    {Op_RegPutInt32, OpByteCode_RegPutInt32_Ireg_Iint32, 0, 2, {OpType_reg, OpType_int32}, {true, true}, {false, false}, OpType_void, 12, {4, 8}, false, false, false},
    {Op_RegPutInt32, OpByteCode_RegPutInt32_Ireg_Rint32, 0, 2, {OpType_reg, OpType_int32}, {true, false}, {false, false}, OpType_void, 12, {4, 8}, false, false, false},
    {Op_ToObject, OpByteCode_ToObject_Ireg_Ivalue_Pad, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, false}, OpType_value, 20, {16, 8}, true, true, false},
    {Op_ToObject, OpByteCode_ToObject_Ireg_Ivalue, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, false}, OpType_value, 16, {12, 4}, false, true, false},
    {Op_ToObject, OpByteCode_ToObject_Ireg_Rvalue, 0, 2, {OpType_reg, OpType_value}, {true, false}, {false, false}, OpType_value, 12, {4, 8}, false, false, false},
    {Op_SymPutKnownObject, OpByteCode_SymPutKnownObject_Rvalue_Iident_Ivalue_Pad, 0, 3, {OpType_value, OpType_ident, OpType_value}, {false, true, true}, {false, false, false}, OpType_void, 28, {24, 8, 16}, true, true, false},
    {Op_SymPutKnownObject, OpByteCode_SymPutKnownObject_Rvalue_Iident_Ivalue, 0, 3, {OpType_value, OpType_ident, OpType_value}, {false, true, true}, {false, false, false}, OpType_void, 24, {20, 4, 12}, false, true, false},
    {Op_SymPutKnownObject, OpByteCode_SymPutKnownObject_Rvalue_Iident_Rvalue_Pad, 0, 3, {OpType_value, OpType_ident, OpType_value}, {false, true, false}, {false, false, false}, OpType_void, 24, {16, 8, 20}, true, true, false},
    {Op_SymPutKnownObject, OpByteCode_SymPutKnownObject_Rvalue_Iident_Rvalue, 0, 3, {OpType_value, OpType_ident, OpType_value}, {false, true, false}, {false, false, false}, OpType_void, 20, {12, 4, 16}, false, true, false},
    {Op_SymPutKnownObject, OpByteCode_SymPutKnownObject_Rvalue_Iident_Rnumber_Pad, 15, 3, {OpType_value, OpType_ident, OpType_number}, {false, true, false}, {false, false, false}, OpType_void, 24, {16, 8, 20}, true, true, false},
    {Op_SymPutKnownObject, OpByteCode_SymPutKnownObject_Rvalue_Iident_Rnumber, 15, 3, {OpType_value, OpType_ident, OpType_number}, {false, true, false}, {false, false, false}, OpType_void, 20, {12, 4, 16}, false, true, false},
    {Op_SymGet, OpByteCode_SymGet_Ireg_Ivalue_Iident_Pad, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 28, {24, 8, 16}, true, true, false},
    {Op_SymGet, OpByteCode_SymGet_Ireg_Ivalue_Iident, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 24, {20, 4, 12}, false, true, false},
    {Op_SymGet, OpByteCode_SymGet_Ireg_Rvalue_Iident_Pad, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, false, true}, {false, false, false}, OpType_value, 24, {16, 20, 8}, true, true, false},
    {Op_SymGet, OpByteCode_SymGet_Ireg_Rvalue_Iident, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, false, true}, {false, false, false}, OpType_value, 20, {12, 16, 4}, false, true, false},
    {Op_SymGetKnownObject, OpByteCode_SymGetKnownObject_Ireg_Ivalue_Iident_Pad, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 28, {24, 8, 16}, true, true, false},
    {Op_SymGetKnownObject, OpByteCode_SymGetKnownObject_Ireg_Ivalue_Iident, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, true, true}, {false, false, false}, OpType_value, 24, {20, 4, 12}, false, true, false},
    {Op_SymGetKnownObject, OpByteCode_SymGetKnownObject_Ireg_Rvalue_Iident_Pad, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, false, true}, {false, false, false}, OpType_value, 24, {16, 20, 8}, true, true, false},
    {Op_SymGetKnownObject, OpByteCode_SymGetKnownObject_Ireg_Rvalue_Iident, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, false, true}, {false, false, false}, OpType_value, 20, {12, 16, 4}, false, true, false},
    {Op_SymGetAndBind, OpByteCode_SymGetAndBind_Ireg_Ireg_Rvalue_Iident_Pad, 0, 4, {OpType_reg, OpType_reg, OpType_value, OpType_ident}, {true, true, false, true}, {false, false, false, false}, OpType_value, 28, {16, 20, 24, 8}, true, true, false},
    {Op_SymGetAndBind, OpByteCode_SymGetAndBind_Ireg_Ireg_Rvalue_Iident, 0, 4, {OpType_reg, OpType_reg, OpType_value, OpType_ident}, {true, true, false, true}, {false, false, false, false}, OpType_value, 24, {12, 16, 20, 4}, false, true, false},
    {Op_BracketGet, OpByteCode_BracketGet_Ireg_Rvalue_Ivalue_Pad, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_value, 24, {16, 20, 8}, true, true, false},
    {Op_BracketGet, OpByteCode_BracketGet_Ireg_Rvalue_Ivalue, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_value, 20, {12, 16, 4}, false, true, false},
    {Op_BracketGet, OpByteCode_BracketGet_Ireg_Rvalue_Rvalue, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_value, 16, {4, 8, 12}, false, false, false},
    {Op_BracketGet, OpByteCode_BracketGet_Ireg_Rvalue_Iint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, false, true}, {false, false, true}, OpType_value, 16, {4, 8, 12}, false, false, false},
    {Op_BracketGet, OpByteCode_BracketGet_Ireg_Rvalue_Rint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, false, false}, {false, false, true}, OpType_value, 16, {4, 8, 12}, false, false, false},
    {Op_BracketGetAndBind, OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Ivalue_Pad, 50, 4, {OpType_reg, OpType_reg, OpType_value, OpType_value}, {true, true, false, true}, {false, false, false, false}, OpType_value, 28, {16, 20, 24, 8}, true, true, false},
    {Op_BracketGetAndBind, OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Ivalue, 50, 4, {OpType_reg, OpType_reg, OpType_value, OpType_value}, {true, true, false, true}, {false, false, false, false}, OpType_value, 24, {12, 16, 20, 4}, false, true, false},
    {Op_BracketGetAndBind, OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Rvalue, 50, 4, {OpType_reg, OpType_reg, OpType_value, OpType_value}, {true, true, false, false}, {false, false, false, false}, OpType_value, 20, {4, 8, 12, 16}, false, false, false},
    {Op_BracketGetAndBind, OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Iint32, 0, 4, {OpType_reg, OpType_reg, OpType_value, OpType_int32}, {true, true, false, true}, {false, false, false, true}, OpType_value, 20, {4, 8, 12, 16}, false, false, false},
    {Op_BracketGetAndBind, OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Rint32, 0, 4, {OpType_reg, OpType_reg, OpType_value, OpType_int32}, {true, true, false, false}, {false, false, false, true}, OpType_value, 20, {4, 8, 12, 16}, false, false, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Ivalue_Ivalue_Pad, 50, 3, {OpType_value, OpType_value, OpType_value}, {false, true, true}, {false, false, false}, OpType_void, 28, {24, 8, 16}, true, true, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Ivalue_Ivalue, 50, 3, {OpType_value, OpType_value, OpType_value}, {false, true, true}, {false, false, false}, OpType_void, 24, {20, 4, 12}, false, true, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Ivalue_Rvalue_Pad, 50, 3, {OpType_value, OpType_value, OpType_value}, {false, true, false}, {false, false, false}, OpType_void, 24, {16, 8, 20}, true, true, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Ivalue_Rvalue, 50, 3, {OpType_value, OpType_value, OpType_value}, {false, true, false}, {false, false, false}, OpType_void, 20, {12, 4, 16}, false, true, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Rvalue_Ivalue_Pad, 50, 3, {OpType_value, OpType_value, OpType_value}, {false, false, true}, {false, false, false}, OpType_void, 24, {16, 20, 8}, true, true, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Rvalue_Ivalue, 50, 3, {OpType_value, OpType_value, OpType_value}, {false, false, true}, {false, false, false}, OpType_void, 20, {12, 16, 4}, false, true, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Rvalue_Rvalue, 50, 3, {OpType_value, OpType_value, OpType_value}, {false, false, false}, {false, false, false}, OpType_void, 16, {4, 8, 12}, false, false, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Iint32_Ivalue_Pad, 0, 3, {OpType_value, OpType_int32, OpType_value}, {false, true, true}, {false, true, false}, OpType_void, 24, {16, 20, 8}, true, true, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Iint32_Ivalue, 0, 3, {OpType_value, OpType_int32, OpType_value}, {false, true, true}, {false, true, false}, OpType_void, 20, {12, 16, 4}, false, true, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Iint32_Rvalue, 0, 3, {OpType_value, OpType_int32, OpType_value}, {false, true, false}, {false, true, false}, OpType_void, 16, {4, 8, 12}, false, false, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Rint32_Ivalue_Pad, 0, 3, {OpType_value, OpType_int32, OpType_value}, {false, false, true}, {false, true, false}, OpType_void, 24, {16, 20, 8}, true, true, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Rint32_Ivalue, 0, 3, {OpType_value, OpType_int32, OpType_value}, {false, false, true}, {false, true, false}, OpType_void, 20, {12, 16, 4}, false, true, false},
    {Op_BracketPutKnownObject, OpByteCode_BracketPutKnownObject_Rvalue_Rint32_Rvalue, 0, 3, {OpType_value, OpType_int32, OpType_value}, {false, false, false}, {false, true, false}, OpType_void, 16, {4, 8, 12}, false, false, false},
    {Op_GlobalObjectGet, OpByteCode_GlobalObjectGet_Ireg_Iident_Pad, 0, 2, {OpType_reg, OpType_ident}, {true, true}, {false, false}, OpType_value, 20, {16, 8}, true, true, false},
    {Op_GlobalObjectGet, OpByteCode_GlobalObjectGet_Ireg_Iident, 0, 2, {OpType_reg, OpType_ident}, {true, true}, {false, false}, OpType_value, 16, {12, 4}, false, true, false},
    {Op_SymDeleteKnownObject, OpByteCode_SymDeleteKnownObject_Ireg_Ivalue_Iident_Pad, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, true, true}, {false, false, false}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_SymDeleteKnownObject, OpByteCode_SymDeleteKnownObject_Ireg_Ivalue_Iident, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, true, true}, {false, false, false}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_SymDeleteKnownObject, OpByteCode_SymDeleteKnownObject_Ireg_Rvalue_Iident_Pad, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_SymDeleteKnownObject, OpByteCode_SymDeleteKnownObject_Ireg_Rvalue_Iident, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_SymDelete, OpByteCode_SymDelete_Ireg_Ivalue_Iident_Pad, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, true, true}, {false, false, false}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_SymDelete, OpByteCode_SymDelete_Ireg_Ivalue_Iident, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, true, true}, {false, false, false}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_SymDelete, OpByteCode_SymDelete_Ireg_Rvalue_Iident_Pad, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_SymDelete, OpByteCode_SymDelete_Ireg_Rvalue_Iident, 0, 3, {OpType_reg, OpType_value, OpType_ident}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_BracketDelete, OpByteCode_BracketDelete_Ireg_Rvalue_Ivalue_Pad, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_BracketDelete, OpByteCode_BracketDelete_Ireg_Rvalue_Ivalue, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_BracketDelete, OpByteCode_BracketDelete_Ireg_Rvalue_Rvalue, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_BracketDelete, OpByteCode_BracketDelete_Ireg_Ivalue_Iint32_Pad, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, true}, {false, false, true}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_BracketDelete, OpByteCode_BracketDelete_Ireg_Ivalue_Iint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, true}, {false, false, true}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_BracketDelete, OpByteCode_BracketDelete_Ireg_Ivalue_Rint32_Pad, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, false}, {false, false, true}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_BracketDelete, OpByteCode_BracketDelete_Ireg_Ivalue_Rint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, false}, {false, false, true}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_BracketDelete, OpByteCode_BracketDelete_Ireg_Rvalue_Iint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, false, true}, {false, false, true}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_BracketDelete, OpByteCode_BracketDelete_Ireg_Rvalue_Rint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, false, false}, {false, false, true}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_OwnedString, OpByteCode_OwnedString_Ireg_Istring_Pad, 0, 2, {OpType_reg, OpType_string}, {true, true}, {false, false}, OpType_value, 20, {16, 8}, true, true, false},
    {Op_OwnedString, OpByteCode_OwnedString_Ireg_Istring, 0, 2, {OpType_reg, OpType_string}, {true, true}, {false, false}, OpType_value, 16, {12, 4}, false, true, false},
    {Op_NewEmptyArray, OpByteCode_NewEmptyArray_Ireg, 0, 1, {OpType_reg}, {true}, {false}, OpType_value, 8, {4}, false, false, false},
    {Op_NewObject, OpByteCode_NewObject_Ireg, 0, 1, {OpType_reg}, {true}, {false}, OpType_value, 8, {4}, false, false, false},
    {Op_NewRegExp, OpByteCode_NewRegExp_Ireg_Istring_Istring_Pad, 0, 3, {OpType_reg, OpType_string, OpType_string}, {true, true, true}, {false, false, false}, OpType_value, 28, {24, 8, 16}, true, true, false},
    {Op_NewRegExp, OpByteCode_NewRegExp_Ireg_Istring_Istring, 0, 3, {OpType_reg, OpType_string, OpType_string}, {true, true, true}, {false, false, false}, OpType_value, 24, {20, 4, 12}, false, true, false},
    {Op_DefineGetter, OpByteCode_DefineGetter_Rvalue_Iident_Ivalue_Pad, 0, 3, {OpType_value, OpType_ident, OpType_value}, {false, true, true}, {false, false, false}, OpType_void, 28, {24, 8, 16}, true, true, false},
    {Op_DefineGetter, OpByteCode_DefineGetter_Rvalue_Iident_Ivalue, 0, 3, {OpType_value, OpType_ident, OpType_value}, {false, true, true}, {false, false, false}, OpType_void, 24, {20, 4, 12}, false, true, false},
    {Op_DefineGetter, OpByteCode_DefineGetter_Rvalue_Iident_Rvalue_Pad, 0, 3, {OpType_value, OpType_ident, OpType_value}, {false, true, false}, {false, false, false}, OpType_void, 24, {16, 8, 20}, true, true, false},
    {Op_DefineGetter, OpByteCode_DefineGetter_Rvalue_Iident_Rvalue, 0, 3, {OpType_value, OpType_ident, OpType_value}, {false, true, false}, {false, false, false}, OpType_void, 20, {12, 4, 16}, false, true, false},
    {Op_DefineSetter, OpByteCode_DefineSetter_Rvalue_Iident_Ivalue_Pad, 0, 3, {OpType_value, OpType_ident, OpType_value}, {false, true, true}, {false, false, false}, OpType_void, 28, {24, 8, 16}, true, true, false},
    {Op_DefineSetter, OpByteCode_DefineSetter_Rvalue_Iident_Ivalue, 0, 3, {OpType_value, OpType_ident, OpType_value}, {false, true, true}, {false, false, false}, OpType_void, 24, {20, 4, 12}, false, true, false},
    {Op_DefineSetter, OpByteCode_DefineSetter_Rvalue_Iident_Rvalue_Pad, 0, 3, {OpType_value, OpType_ident, OpType_value}, {false, true, false}, {false, false, false}, OpType_void, 24, {16, 8, 20}, true, true, false},
    {Op_DefineSetter, OpByteCode_DefineSetter_Rvalue_Iident_Rvalue, 0, 3, {OpType_value, OpType_ident, OpType_value}, {false, true, false}, {false, false, false}, OpType_void, 20, {12, 4, 16}, false, true, false},
    {Op_Add1, OpByteCode_Add1_Ireg_Inumber_Pad, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, false}, OpType_number, 20, {16, 8}, true, true, false},
    {Op_Add1, OpByteCode_Add1_Ireg_Inumber, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, false}, OpType_number, 16, {12, 4}, false, true, false},
    {Op_Add1, OpByteCode_Add1_Ireg_Rnumber, 0, 2, {OpType_reg, OpType_number}, {true, false}, {false, false}, OpType_number, 12, {4, 8}, false, false, false},
    {Op_Add1, OpByteCode_Add1_Ireg_Rvalue, 37, 2, {OpType_reg, OpType_value}, {true, false}, {false, false}, OpType_number, 12, {4, 8}, false, false, false},
    {Op_Sub1, OpByteCode_Sub1_Ireg_Inumber_Pad, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, false}, OpType_number, 20, {16, 8}, true, true, false},
    {Op_Sub1, OpByteCode_Sub1_Ireg_Inumber, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, false}, OpType_number, 16, {12, 4}, false, true, false},
    {Op_Sub1, OpByteCode_Sub1_Ireg_Rnumber, 0, 2, {OpType_reg, OpType_number}, {true, false}, {false, false}, OpType_number, 12, {4, 8}, false, false, false},
    {Op_Neg, OpByteCode_Neg_Ireg_Inumber_Pad, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, false}, OpType_number, 20, {16, 8}, true, true, false},
    {Op_Neg, OpByteCode_Neg_Ireg_Inumber, 0, 2, {OpType_reg, OpType_number}, {true, true}, {false, false}, OpType_number, 16, {12, 4}, false, true, false},
    {Op_Neg, OpByteCode_Neg_Ireg_Rnumber, 0, 2, {OpType_reg, OpType_number}, {true, false}, {false, false}, OpType_number, 12, {4, 8}, false, false, false},
    {Op_Neg, OpByteCode_Neg_Ireg_Rvalue, 37, 2, {OpType_reg, OpType_value}, {true, false}, {false, false}, OpType_number, 12, {4, 8}, false, false, false},
    {Op_Mult, OpByteCode_Mult_Ireg_Inumber_Inumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, true}, {false, false, false}, OpType_number, 28, {24, 8, 16}, true, true, false},
    {Op_Mult, OpByteCode_Mult_Ireg_Inumber_Inumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, true}, {false, false, false}, OpType_number, 24, {20, 4, 12}, false, true, false},
    {Op_Mult, OpByteCode_Mult_Ireg_Inumber_Rnumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, false}, {false, false, false}, OpType_number, 24, {16, 8, 20}, true, true, false},
    {Op_Mult, OpByteCode_Mult_Ireg_Inumber_Rnumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, false}, {false, false, false}, OpType_number, 20, {12, 4, 16}, false, true, false},
    {Op_Mult, OpByteCode_Mult_Ireg_Rnumber_Inumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, true}, {false, false, false}, OpType_number, 24, {16, 20, 8}, true, true, false},
    {Op_Mult, OpByteCode_Mult_Ireg_Rnumber_Inumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, true}, {false, false, false}, OpType_number, 20, {12, 16, 4}, false, true, false},
    {Op_Mult, OpByteCode_Mult_Ireg_Rnumber_Rnumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, false}, {false, false, false}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_Mult, OpByteCode_Mult_Ireg_Rvalue_Rvalue, 74, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_Mult, OpByteCode_Mult_Ireg_Rvalue_Rnumber, 37, 3, {OpType_reg, OpType_value, OpType_number}, {true, false, false}, {false, false, false}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_Mult, OpByteCode_Mult_Ireg_Rnumber_Rvalue, 37, 3, {OpType_reg, OpType_number, OpType_value}, {true, false, false}, {false, false, false}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_Div, OpByteCode_Div_Ireg_Inumber_Inumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, true}, {false, false, false}, OpType_number, 28, {24, 8, 16}, true, true, false},
    {Op_Div, OpByteCode_Div_Ireg_Inumber_Inumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, true}, {false, false, false}, OpType_number, 24, {20, 4, 12}, false, true, false},
    {Op_Div, OpByteCode_Div_Ireg_Inumber_Rnumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, false}, {false, false, false}, OpType_number, 24, {16, 8, 20}, true, true, false},
    {Op_Div, OpByteCode_Div_Ireg_Inumber_Rnumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, false}, {false, false, false}, OpType_number, 20, {12, 4, 16}, false, true, false},
    {Op_Div, OpByteCode_Div_Ireg_Rnumber_Inumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, true}, {false, false, false}, OpType_number, 24, {16, 20, 8}, true, true, false},
    {Op_Div, OpByteCode_Div_Ireg_Rnumber_Inumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, true}, {false, false, false}, OpType_number, 20, {12, 16, 4}, false, true, false},
    {Op_Div, OpByteCode_Div_Ireg_Rnumber_Rnumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, false}, {false, false, false}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_Mod, OpByteCode_Mod_Ireg_Inumber_Inumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, true}, {false, false, false}, OpType_number, 28, {24, 8, 16}, true, true, false},
    {Op_Mod, OpByteCode_Mod_Ireg_Inumber_Inumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, true}, {false, false, false}, OpType_number, 24, {20, 4, 12}, false, true, false},
    {Op_Mod, OpByteCode_Mod_Ireg_Inumber_Rnumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, false}, {false, false, false}, OpType_number, 24, {16, 8, 20}, true, true, false},
    {Op_Mod, OpByteCode_Mod_Ireg_Inumber_Rnumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, false}, {false, false, false}, OpType_number, 20, {12, 4, 16}, false, true, false},
    {Op_Mod, OpByteCode_Mod_Ireg_Rnumber_Inumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, true}, {false, false, false}, OpType_number, 24, {16, 20, 8}, true, true, false},
    {Op_Mod, OpByteCode_Mod_Ireg_Rnumber_Inumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, true}, {false, false, false}, OpType_number, 20, {12, 16, 4}, false, true, false},
    {Op_Mod, OpByteCode_Mod_Ireg_Rnumber_Rnumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, false}, {false, false, false}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_Exp, OpByteCode_Exp_Ireg_Inumber_Inumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, true}, {false, false, false}, OpType_number, 28, {24, 8, 16}, true, true, false},
    {Op_Exp, OpByteCode_Exp_Ireg_Inumber_Inumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, true}, {false, false, false}, OpType_number, 24, {20, 4, 12}, false, true, false},
    {Op_Exp, OpByteCode_Exp_Ireg_Inumber_Rnumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, false}, {false, false, false}, OpType_number, 24, {16, 8, 20}, true, true, false},
    {Op_Exp, OpByteCode_Exp_Ireg_Inumber_Rnumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, false}, {false, false, false}, OpType_number, 20, {12, 4, 16}, false, true, false},
    {Op_Exp, OpByteCode_Exp_Ireg_Rnumber_Inumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, true}, {false, false, false}, OpType_number, 24, {16, 20, 8}, true, true, false},
    {Op_Exp, OpByteCode_Exp_Ireg_Rnumber_Inumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, true}, {false, false, false}, OpType_number, 20, {12, 16, 4}, false, true, false},
    {Op_Exp, OpByteCode_Exp_Ireg_Rnumber_Rnumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, false}, {false, false, false}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_Sub, OpByteCode_Sub_Ireg_Inumber_Inumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, true}, {false, false, false}, OpType_number, 28, {24, 8, 16}, true, true, false},
    {Op_Sub, OpByteCode_Sub_Ireg_Inumber_Inumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, true}, {false, false, false}, OpType_number, 24, {20, 4, 12}, false, true, false},
    {Op_Sub, OpByteCode_Sub_Ireg_Inumber_Rnumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, false}, {false, false, false}, OpType_number, 24, {16, 8, 20}, true, true, false},
    {Op_Sub, OpByteCode_Sub_Ireg_Inumber_Rnumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, false}, {false, false, false}, OpType_number, 20, {12, 4, 16}, false, true, false},
    {Op_Sub, OpByteCode_Sub_Ireg_Rnumber_Inumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, true}, {false, false, false}, OpType_number, 24, {16, 20, 8}, true, true, false},
    {Op_Sub, OpByteCode_Sub_Ireg_Rnumber_Inumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, true}, {false, false, false}, OpType_number, 20, {12, 16, 4}, false, true, false},
    {Op_Sub, OpByteCode_Sub_Ireg_Rnumber_Rnumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, false}, {false, false, false}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_Add, OpByteCode_Add_Ireg_Ivalue_Ivalue_Pad, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_value, 28, {24, 8, 16}, true, true, false},
    {Op_Add, OpByteCode_Add_Ireg_Ivalue_Ivalue, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_value, 24, {20, 4, 12}, false, true, false},
    {Op_Add, OpByteCode_Add_Ireg_Ivalue_Rvalue_Pad, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_value, 24, {16, 8, 20}, true, true, false},
    {Op_Add, OpByteCode_Add_Ireg_Ivalue_Rvalue, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_value, 20, {12, 4, 16}, false, true, false},
    {Op_Add, OpByteCode_Add_Ireg_Rvalue_Ivalue_Pad, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_value, 24, {16, 20, 8}, true, true, false},
    {Op_Add, OpByteCode_Add_Ireg_Rvalue_Ivalue, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_value, 20, {12, 16, 4}, false, true, false},
    {Op_Add, OpByteCode_Add_Ireg_Rvalue_Rvalue, 50, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_value, 16, {4, 8, 12}, false, false, false},
    {Op_Add, OpByteCode_Add_Ireg_Inumber_Inumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, true}, {false, true, true}, OpType_number, 28, {24, 8, 16}, true, true, false},
    {Op_Add, OpByteCode_Add_Ireg_Inumber_Inumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, true}, {false, true, true}, OpType_number, 24, {20, 4, 12}, false, true, false},
    {Op_Add, OpByteCode_Add_Ireg_Inumber_Rnumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, false}, {false, true, true}, OpType_number, 24, {16, 8, 20}, true, true, false},
    {Op_Add, OpByteCode_Add_Ireg_Inumber_Rnumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, true, false}, {false, true, true}, OpType_number, 20, {12, 4, 16}, false, true, false},
    {Op_Add, OpByteCode_Add_Ireg_Rnumber_Inumber_Pad, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, true}, {false, true, true}, OpType_number, 24, {16, 20, 8}, true, true, false},
    {Op_Add, OpByteCode_Add_Ireg_Rnumber_Inumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, true}, {false, true, true}, OpType_number, 20, {12, 16, 4}, false, true, false},
    {Op_Add, OpByteCode_Add_Ireg_Rnumber_Rnumber, 0, 3, {OpType_reg, OpType_number, OpType_number}, {true, false, false}, {false, true, true}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_LShift, OpByteCode_LShift_Ireg_Iint32_Iint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, true, true}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_LShift, OpByteCode_LShift_Ireg_Iint32_Rint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, true, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_LShift, OpByteCode_LShift_Ireg_Rint32_Iint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, false, true}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_LShift, OpByteCode_LShift_Ireg_Rint32_Rint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, false, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_RShift, OpByteCode_RShift_Ireg_Iint32_Iint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, true, true}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_RShift, OpByteCode_RShift_Ireg_Iint32_Rint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, true, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_RShift, OpByteCode_RShift_Ireg_Rint32_Iint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, false, true}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_RShift, OpByteCode_RShift_Ireg_Rint32_Rint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, false, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_URShift, OpByteCode_URShift_Ireg_Iint32_Iint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, true, true}, {false, false, false}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_URShift, OpByteCode_URShift_Ireg_Iint32_Rint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, true, false}, {false, false, false}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_URShift, OpByteCode_URShift_Ireg_Rint32_Iint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, false, true}, {false, false, false}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_URShift, OpByteCode_URShift_Ireg_Rint32_Rint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, false, false}, {false, false, false}, OpType_number, 16, {4, 8, 12}, false, false, false},
    {Op_Less, OpByteCode_Less_Ireg_Ivalue_Ivalue_Pad, 40, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Ivalue_Ivalue, 40, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Ivalue_Rvalue_Pad, 40, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Ivalue_Rvalue, 40, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Rvalue_Ivalue_Pad, 40, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Rvalue_Ivalue, 40, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Rvalue_Rvalue, 40, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_Less, OpByteCode_Less_Ireg_Ivalue_Inumber_Pad, 0, 3, {OpType_reg, OpType_value, OpType_number}, {true, true, true}, {false, false, true}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Ivalue_Inumber, 0, 3, {OpType_reg, OpType_value, OpType_number}, {true, true, true}, {false, false, true}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Ivalue_Rnumber_Pad, 0, 3, {OpType_reg, OpType_value, OpType_number}, {true, true, false}, {false, false, true}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Ivalue_Rnumber, 0, 3, {OpType_reg, OpType_value, OpType_number}, {true, true, false}, {false, false, true}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Rvalue_Inumber_Pad, 0, 3, {OpType_reg, OpType_value, OpType_number}, {true, false, true}, {false, false, true}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Rvalue_Inumber, 0, 3, {OpType_reg, OpType_value, OpType_number}, {true, false, true}, {false, false, true}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Rvalue_Rnumber, 0, 3, {OpType_reg, OpType_value, OpType_number}, {true, false, false}, {false, false, true}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_Less, OpByteCode_Less_Ireg_Ivalue_Iint32_Pad, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, true}, {false, false, true}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Ivalue_Iint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, true}, {false, false, true}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Ivalue_Rint32_Pad, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, false}, {false, false, true}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Ivalue_Rint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, false}, {false, false, true}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_Less, OpByteCode_Less_Ireg_Rvalue_Iint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, false, true}, {false, false, true}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_Less, OpByteCode_Less_Ireg_Rvalue_Rint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, false, false}, {false, false, true}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_GreaterEq, OpByteCode_GreaterEq_Ireg_Ivalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_GreaterEq, OpByteCode_GreaterEq_Ireg_Ivalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_GreaterEq, OpByteCode_GreaterEq_Ireg_Ivalue_Rvalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_GreaterEq, OpByteCode_GreaterEq_Ireg_Ivalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_GreaterEq, OpByteCode_GreaterEq_Ireg_Rvalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_GreaterEq, OpByteCode_GreaterEq_Ireg_Rvalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_GreaterEq, OpByteCode_GreaterEq_Ireg_Rvalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_Greater, OpByteCode_Greater_Ireg_Ivalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_Greater, OpByteCode_Greater_Ireg_Ivalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_Greater, OpByteCode_Greater_Ireg_Ivalue_Rvalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_Greater, OpByteCode_Greater_Ireg_Ivalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_Greater, OpByteCode_Greater_Ireg_Rvalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_Greater, OpByteCode_Greater_Ireg_Rvalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_Greater, OpByteCode_Greater_Ireg_Rvalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_LessEq, OpByteCode_LessEq_Ireg_Ivalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_LessEq, OpByteCode_LessEq_Ireg_Ivalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_LessEq, OpByteCode_LessEq_Ireg_Ivalue_Rvalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_LessEq, OpByteCode_LessEq_Ireg_Ivalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_LessEq, OpByteCode_LessEq_Ireg_Rvalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_LessEq, OpByteCode_LessEq_Ireg_Rvalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_LessEq, OpByteCode_LessEq_Ireg_Rvalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Ivalue_Ivalue_Pad, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Ivalue_Ivalue, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Ivalue_Rvalue_Pad, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Ivalue_Rvalue, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Rvalue_Ivalue_Pad, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Rvalue_Ivalue, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Rvalue_Rvalue, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Ivalue_Iint32_Pad, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, true}, {false, false, true}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Ivalue_Iint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, true}, {false, false, true}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Ivalue_Rint32_Pad, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, false}, {false, false, true}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Ivalue_Rint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, false}, {false, false, true}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Rvalue_Iint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, false, true}, {false, false, true}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_EqEq, OpByteCode_EqEq_Ireg_Rvalue_Rint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, false, false}, {false, false, true}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Ivalue_Ivalue_Pad, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Ivalue_Ivalue, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Ivalue_Rvalue_Pad, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Ivalue_Rvalue, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Rvalue_Ivalue_Pad, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Rvalue_Ivalue, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Rvalue_Rvalue, 30, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Ivalue_Iint32_Pad, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, true}, {false, false, true}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Ivalue_Iint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, true}, {false, false, true}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Ivalue_Rint32_Pad, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, false}, {false, false, true}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Ivalue_Rint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, true, false}, {false, false, true}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Rvalue_Iint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, false, true}, {false, false, true}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_NotEq, OpByteCode_NotEq_Ireg_Rvalue_Rint32, 0, 3, {OpType_reg, OpType_value, OpType_int32}, {true, false, false}, {false, false, true}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_StrEq, OpByteCode_StrEq_Ireg_Ivalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_StrEq, OpByteCode_StrEq_Ireg_Ivalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_StrEq, OpByteCode_StrEq_Ireg_Ivalue_Rvalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_StrEq, OpByteCode_StrEq_Ireg_Ivalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_StrEq, OpByteCode_StrEq_Ireg_Rvalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_StrEq, OpByteCode_StrEq_Ireg_Rvalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_StrEq, OpByteCode_StrEq_Ireg_Rvalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_StrNEq, OpByteCode_StrNEq_Ireg_Ivalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_StrNEq, OpByteCode_StrNEq_Ireg_Ivalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_StrNEq, OpByteCode_StrNEq_Ireg_Ivalue_Rvalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_StrNEq, OpByteCode_StrNEq_Ireg_Ivalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_StrNEq, OpByteCode_StrNEq_Ireg_Rvalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_StrNEq, OpByteCode_StrNEq_Ireg_Rvalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_StrNEq, OpByteCode_StrNEq_Ireg_Rvalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_BitNot, OpByteCode_BitNot_Ireg_Iint32, 0, 2, {OpType_reg, OpType_int32}, {true, true}, {false, false}, OpType_int32, 12, {4, 8}, false, false, false},
    {Op_BitNot, OpByteCode_BitNot_Ireg_Rint32, 0, 2, {OpType_reg, OpType_int32}, {true, false}, {false, false}, OpType_int32, 12, {4, 8}, false, false, false},
    {Op_BitAnd, OpByteCode_BitAnd_Ireg_Iint32_Iint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, true, true}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitAnd, OpByteCode_BitAnd_Ireg_Iint32_Rint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, true, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitAnd, OpByteCode_BitAnd_Ireg_Rint32_Iint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, false, true}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitAnd, OpByteCode_BitAnd_Ireg_Rint32_Rint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, false, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitAnd, OpByteCode_BitAnd_Ireg_Rvalue_Rvalue, 80, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitAnd, OpByteCode_BitAnd_Ireg_Rvalue_Rint32, 40, 3, {OpType_reg, OpType_value, OpType_int32}, {true, false, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitAnd, OpByteCode_BitAnd_Ireg_Rint32_Rvalue, 40, 3, {OpType_reg, OpType_int32, OpType_value}, {true, false, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitXOr, OpByteCode_BitXOr_Ireg_Iint32_Iint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, true, true}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitXOr, OpByteCode_BitXOr_Ireg_Iint32_Rint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, true, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitXOr, OpByteCode_BitXOr_Ireg_Rint32_Iint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, false, true}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitXOr, OpByteCode_BitXOr_Ireg_Rint32_Rint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, false, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitOr, OpByteCode_BitOr_Ireg_Iint32_Iint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, true, true}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitOr, OpByteCode_BitOr_Ireg_Iint32_Rint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, true, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitOr, OpByteCode_BitOr_Ireg_Rint32_Iint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, false, true}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_BitOr, OpByteCode_BitOr_Ireg_Rint32_Rint32, 0, 3, {OpType_reg, OpType_int32, OpType_int32}, {true, false, false}, {false, false, false}, OpType_int32, 16, {4, 8, 12}, false, false, false},
    {Op_LogicalNot, OpByteCode_LogicalNot_Ireg_Ibool, 0, 2, {OpType_reg, OpType_bool}, {true, true}, {false, false}, OpType_bool, 12, {4, 8}, false, false, false},
    {Op_LogicalNot, OpByteCode_LogicalNot_Ireg_Rbool, 0, 2, {OpType_reg, OpType_bool}, {true, false}, {false, false}, OpType_bool, 12, {4, 8}, false, false, false},
    {Op_TypeOf, OpByteCode_TypeOf_Ireg_Ivalue_Pad, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, false}, OpType_value, 20, {16, 8}, true, true, false},
    {Op_TypeOf, OpByteCode_TypeOf_Ireg_Ivalue, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, false}, OpType_value, 16, {12, 4}, false, true, false},
    {Op_TypeOf, OpByteCode_TypeOf_Ireg_Rvalue, 0, 2, {OpType_reg, OpType_value}, {true, false}, {false, false}, OpType_value, 12, {4, 8}, false, false, false},
    {Op_In, OpByteCode_In_Ireg_Ivalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_In, OpByteCode_In_Ireg_Ivalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_In, OpByteCode_In_Ireg_Ivalue_Rvalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_In, OpByteCode_In_Ireg_Ivalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_In, OpByteCode_In_Ireg_Rvalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_In, OpByteCode_In_Ireg_Rvalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_In, OpByteCode_In_Ireg_Rvalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_InstanceOf, OpByteCode_InstanceOf_Ireg_Ivalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 28, {24, 8, 16}, true, true, false},
    {Op_InstanceOf, OpByteCode_InstanceOf_Ireg_Ivalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_bool, 24, {20, 4, 12}, false, true, false},
    {Op_InstanceOf, OpByteCode_InstanceOf_Ireg_Ivalue_Rvalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 24, {16, 8, 20}, true, true, false},
    {Op_InstanceOf, OpByteCode_InstanceOf_Ireg_Ivalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_bool, 20, {12, 4, 16}, false, true, false},
    {Op_InstanceOf, OpByteCode_InstanceOf_Ireg_Rvalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 24, {16, 20, 8}, true, true, false},
    {Op_InstanceOf, OpByteCode_InstanceOf_Ireg_Rvalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_bool, 20, {12, 16, 4}, false, true, false},
    {Op_InstanceOf, OpByteCode_InstanceOf_Ireg_Rvalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_bool, 16, {4, 8, 12}, false, false, false},
    {Op_ClearArgs, OpByteCode_ClearArgs, 0, 0, {}, {}, {}, OpType_void, 4, {}, false, false, false},
    {Op_AddArg, OpByteCode_AddArg_Ivalue_Pad, 0, 1, {OpType_value}, {true}, {false}, OpType_void, 16, {8}, true, true, false},
    {Op_AddArg, OpByteCode_AddArg_Ivalue, 0, 1, {OpType_value}, {true}, {false}, OpType_void, 12, {4}, false, true, false},
    {Op_AddArg, OpByteCode_AddArg_Rvalue, 0, 1, {OpType_value}, {false}, {false}, OpType_void, 8, {4}, false, false, false},
    {Op_Add2Arg, OpByteCode_Add2Arg_Ivalue_Ivalue_Pad, 0, 2, {OpType_value, OpType_value}, {true, true}, {false, false}, OpType_void, 24, {8, 16}, true, true, false},
    {Op_Add2Arg, OpByteCode_Add2Arg_Ivalue_Ivalue, 0, 2, {OpType_value, OpType_value}, {true, true}, {false, false}, OpType_void, 20, {4, 12}, false, true, false},
    {Op_Add2Arg, OpByteCode_Add2Arg_Ivalue_Rvalue_Pad, 0, 2, {OpType_value, OpType_value}, {true, false}, {false, false}, OpType_void, 20, {8, 16}, true, true, false},
    {Op_Add2Arg, OpByteCode_Add2Arg_Ivalue_Rvalue, 0, 2, {OpType_value, OpType_value}, {true, false}, {false, false}, OpType_void, 16, {4, 12}, false, true, false},
    {Op_Add2Arg, OpByteCode_Add2Arg_Rvalue_Ivalue_Pad, 0, 2, {OpType_value, OpType_value}, {false, true}, {false, false}, OpType_void, 20, {16, 8}, true, true, false},
    {Op_Add2Arg, OpByteCode_Add2Arg_Rvalue_Ivalue, 0, 2, {OpType_value, OpType_value}, {false, true}, {false, false}, OpType_void, 16, {12, 4}, false, true, false},
    {Op_Add2Arg, OpByteCode_Add2Arg_Rvalue_Rvalue, 0, 2, {OpType_value, OpType_value}, {false, false}, {false, false}, OpType_void, 12, {4, 8}, false, false, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Ivalue_Ivalue_Ivalue_Pad, 0, 3, {OpType_value, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_void, 32, {8, 16, 24}, true, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Ivalue_Ivalue_Ivalue, 0, 3, {OpType_value, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_void, 28, {4, 12, 20}, false, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Ivalue_Ivalue_Rvalue_Pad, 0, 3, {OpType_value, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_void, 28, {8, 16, 24}, true, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Ivalue_Ivalue_Rvalue, 0, 3, {OpType_value, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_void, 24, {4, 12, 20}, false, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Ivalue_Rvalue_Ivalue_Pad, 0, 3, {OpType_value, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_void, 28, {8, 24, 16}, true, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Ivalue_Rvalue_Ivalue, 0, 3, {OpType_value, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_void, 24, {4, 20, 12}, false, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Ivalue_Rvalue_Rvalue_Pad, 0, 3, {OpType_value, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_void, 24, {8, 16, 20}, true, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Ivalue_Rvalue_Rvalue, 0, 3, {OpType_value, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_void, 20, {4, 12, 16}, false, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Rvalue_Ivalue_Ivalue_Pad, 0, 3, {OpType_value, OpType_value, OpType_value}, {false, true, true}, {false, false, false}, OpType_void, 28, {24, 8, 16}, true, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Rvalue_Ivalue_Ivalue, 0, 3, {OpType_value, OpType_value, OpType_value}, {false, true, true}, {false, false, false}, OpType_void, 24, {20, 4, 12}, false, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Rvalue_Ivalue_Rvalue_Pad, 0, 3, {OpType_value, OpType_value, OpType_value}, {false, true, false}, {false, false, false}, OpType_void, 24, {16, 8, 20}, true, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Rvalue_Ivalue_Rvalue, 0, 3, {OpType_value, OpType_value, OpType_value}, {false, true, false}, {false, false, false}, OpType_void, 20, {12, 4, 16}, false, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Rvalue_Rvalue_Ivalue_Pad, 0, 3, {OpType_value, OpType_value, OpType_value}, {false, false, true}, {false, false, false}, OpType_void, 24, {16, 20, 8}, true, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Rvalue_Rvalue_Ivalue, 0, 3, {OpType_value, OpType_value, OpType_value}, {false, false, true}, {false, false, false}, OpType_void, 20, {12, 16, 4}, false, true, false},
    {Op_Add3Arg, OpByteCode_Add3Arg_Rvalue_Rvalue_Rvalue, 0, 3, {OpType_value, OpType_value, OpType_value}, {false, false, false}, {false, false, false}, OpType_void, 16, {4, 8, 12}, false, false, false},
    {Op_FunctionCall, OpByteCode_FunctionCall_Ireg_Ivalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_value, 28, {24, 8, 16}, true, true, false},
    {Op_FunctionCall, OpByteCode_FunctionCall_Ireg_Ivalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, true}, {false, false, false}, OpType_value, 24, {20, 4, 12}, false, true, false},
    {Op_FunctionCall, OpByteCode_FunctionCall_Ireg_Ivalue_Rvalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_value, 24, {16, 8, 20}, true, true, false},
    {Op_FunctionCall, OpByteCode_FunctionCall_Ireg_Ivalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, true, false}, {false, false, false}, OpType_value, 20, {12, 4, 16}, false, true, false},
    {Op_FunctionCall, OpByteCode_FunctionCall_Ireg_Rvalue_Ivalue_Pad, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_value, 24, {16, 20, 8}, true, true, false},
    {Op_FunctionCall, OpByteCode_FunctionCall_Ireg_Rvalue_Ivalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, true}, {false, false, false}, OpType_value, 20, {12, 16, 4}, false, true, false},
    {Op_FunctionCall, OpByteCode_FunctionCall_Ireg_Rvalue_Rvalue, 0, 3, {OpType_reg, OpType_value, OpType_value}, {true, false, false}, {false, false, false}, OpType_value, 16, {4, 8, 12}, false, false, false},
    {Op_CtorCall, OpByteCode_CtorCall_Ireg_Ivalue_Pad, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, false}, OpType_value, 20, {16, 8}, true, true, false},
    {Op_CtorCall, OpByteCode_CtorCall_Ireg_Ivalue, 0, 2, {OpType_reg, OpType_value}, {true, true}, {false, false}, OpType_value, 16, {12, 4}, false, true, false},
    {Op_CtorCall, OpByteCode_CtorCall_Ireg_Rvalue, 0, 2, {OpType_reg, OpType_value}, {true, false}, {false, false}, OpType_value, 12, {4, 8}, false, false, false},
    {Op_EvalFuncExpr, OpByteCode_EvalFuncExpr_Ireg_Iident_Inode_Pad, 0, 3, {OpType_reg, OpType_ident, OpType_node}, {true, true, true}, {false, false, false}, OpType_value, 28, {24, 8, 16}, true, true, false},
    {Op_EvalFuncExpr, OpByteCode_EvalFuncExpr_Ireg_Iident_Inode, 0, 3, {OpType_reg, OpType_ident, OpType_node}, {true, true, true}, {false, false, false}, OpType_value, 24, {20, 4, 12}, false, true, false}
};

static const Op* const opRBool_Int32Variants[] = {&opsForOpCodes[OpByteCode_RBool_Int32_Ireg_Ibool], &opsForOpCodes[OpByteCode_RBool_Int32_Ireg_Rbool], nullptr};
static const Op* const opRBool_ValueVariants[] = {&opsForOpCodes[OpByteCode_RBool_Value_Ireg_Ibool], &opsForOpCodes[OpByteCode_RBool_Value_Ireg_Rbool], nullptr};
static const Op* const opRBool_NumberVariants[] = {&opsForOpCodes[OpByteCode_RBool_Number_Ireg_Ibool], &opsForOpCodes[OpByteCode_RBool_Number_Ireg_Rbool], nullptr};
static const Op* const opRValue_BoolVariants[] = {&opsForOpCodes[OpByteCode_RValue_Bool_Ireg_Ivalue_Pad], &opsForOpCodes[OpByteCode_RValue_Bool_Ireg_Ivalue], &opsForOpCodes[OpByteCode_RValue_Bool_Ireg_Rvalue], nullptr};
static const Op* const opRValue_Int32Variants[] = {&opsForOpCodes[OpByteCode_RValue_Int32_Ireg_Ivalue_Pad], &opsForOpCodes[OpByteCode_RValue_Int32_Ireg_Ivalue], &opsForOpCodes[OpByteCode_RValue_Int32_Ireg_Rvalue], nullptr};
static const Op* const opRValue_NumberVariants[] = {&opsForOpCodes[OpByteCode_RValue_Number_Ireg_Ivalue_Pad], &opsForOpCodes[OpByteCode_RValue_Number_Ireg_Ivalue], &opsForOpCodes[OpByteCode_RValue_Number_Ireg_Rvalue], nullptr};
static const Op* const opRInt32_BoolVariants[] = {&opsForOpCodes[OpByteCode_RInt32_Bool_Ireg_Iint32], &opsForOpCodes[OpByteCode_RInt32_Bool_Ireg_Rint32], nullptr};
static const Op* const opRInt32_ValueVariants[] = {&opsForOpCodes[OpByteCode_RInt32_Value_Ireg_Iint32], &opsForOpCodes[OpByteCode_RInt32_Value_Ireg_Rint32], nullptr};
static const Op* const opRInt32_NumberVariants[] = {&opsForOpCodes[OpByteCode_RInt32_Number_Ireg_Iint32], &opsForOpCodes[OpByteCode_RInt32_Number_Ireg_Rint32], nullptr};
static const Op* const opRNumber_BoolVariants[] = {&opsForOpCodes[OpByteCode_RNumber_Bool_Ireg_Inumber_Pad], &opsForOpCodes[OpByteCode_RNumber_Bool_Ireg_Inumber], &opsForOpCodes[OpByteCode_RNumber_Bool_Ireg_Rnumber], nullptr};
static const Op* const opRNumber_ValueVariants[] = {&opsForOpCodes[OpByteCode_RNumber_Value_Ireg_Inumber_Pad], &opsForOpCodes[OpByteCode_RNumber_Value_Ireg_Inumber], &opsForOpCodes[OpByteCode_RNumber_Value_Ireg_Rnumber], nullptr};
static const Op* const opRNumber_Int32Variants[] = {&opsForOpCodes[OpByteCode_RNumber_Int32_Ireg_Inumber_Pad], &opsForOpCodes[OpByteCode_RNumber_Int32_Ireg_Inumber], &opsForOpCodes[OpByteCode_RNumber_Int32_Ireg_Rnumber], nullptr};
static const Op* const opRInt32_Value_NonImmVariants[] = {&opsForOpCodes[OpByteCode_RInt32_Value_NonImm_Ireg_Iint32], &opsForOpCodes[OpByteCode_RInt32_Value_NonImm_Ireg_Rint32], nullptr};
static const Op* const opRNum_Value_NonImmVariants[] = {&opsForOpCodes[OpByteCode_RNum_Value_NonImm_Ireg_Inumber_Pad], &opsForOpCodes[OpByteCode_RNum_Value_NonImm_Ireg_Inumber], &opsForOpCodes[OpByteCode_RNum_Value_NonImm_Ireg_Rnumber], nullptr};
static const Op* const opPrintInfoVariants[] = {&opsForOpCodes[OpByteCode_PrintInfo_Ivalue_Pad], &opsForOpCodes[OpByteCode_PrintInfo_Ivalue], &opsForOpCodes[OpByteCode_PrintInfo_Rvalue], nullptr};
static const Op* const opAtStatementVariants[] = {&opsForOpCodes[OpByteCode_AtStatement_Inode_Pad], &opsForOpCodes[OpByteCode_AtStatement_Inode], nullptr};
static const Op* const opExitVariants[] = {&opsForOpCodes[OpByteCode_Exit], nullptr};
static const Op* const opJumpVariants[] = {&opsForOpCodes[OpByteCode_Jump_Iaddr], nullptr};
static const Op* const opIfJumpVariants[] = {&opsForOpCodes[OpByteCode_IfJump_Ibool_Iaddr], &opsForOpCodes[OpByteCode_IfJump_Rbool_Iaddr], &opsForOpCodes[OpByteCode_IfJump_Rvalue_Iaddr], nullptr};
static const Op* const opIfNotJumpVariants[] = {&opsForOpCodes[OpByteCode_IfNotJump_Ibool_Iaddr], &opsForOpCodes[OpByteCode_IfNotJump_Rbool_Iaddr], &opsForOpCodes[OpByteCode_IfNotJump_Rvalue_Iaddr], nullptr};
static const Op* const opBeginForInVariants[] = {&opsForOpCodes[OpByteCode_BeginForIn_Ireg_Ivalue_Ireg_Pad], &opsForOpCodes[OpByteCode_BeginForIn_Ireg_Ivalue_Ireg], &opsForOpCodes[OpByteCode_BeginForIn_Ireg_Rvalue_Ireg], nullptr};
static const Op* const opNextForInEntryVariants[] = {&opsForOpCodes[OpByteCode_NextForInEntry_Ireg_Rvalue_Rvalue_Iaddr], nullptr};
static const Op* const opPushScopeVariants[] = {&opsForOpCodes[OpByteCode_PushScope_Ivalue_Pad], &opsForOpCodes[OpByteCode_PushScope_Ivalue], &opsForOpCodes[OpByteCode_PushScope_Rvalue], nullptr};
static const Op* const opUnwindStacksVariants[] = {&opsForOpCodes[OpByteCode_UnwindStacks_Iint32], &opsForOpCodes[OpByteCode_UnwindStacks_Rint32], nullptr};
static const Op* const opPopScopeVariants[] = {&opsForOpCodes[OpByteCode_PopScope], nullptr};
static const Op* const opPopExceptionHandlerVariants[] = {&opsForOpCodes[OpByteCode_PopExceptionHandler], nullptr};
static const Op* const opPushExceptionHandlerVariants[] = {&opsForOpCodes[OpByteCode_PushExceptionHandler_Iaddr], nullptr};
static const Op* const opEnterCatchVariants[] = {&opsForOpCodes[OpByteCode_EnterCatch_Iident_Pad], &opsForOpCodes[OpByteCode_EnterCatch_Iident], nullptr};
static const Op* const opExitCatchVariants[] = {&opsForOpCodes[OpByteCode_ExitCatch], nullptr};
static const Op* const opDeferCompletionVariants[] = {&opsForOpCodes[OpByteCode_DeferCompletion], nullptr};
static const Op* const opReactivateCompletionVariants[] = {&opsForOpCodes[OpByteCode_ReactivateCompletion_Ibool], &opsForOpCodes[OpByteCode_ReactivateCompletion_Rbool], nullptr};
static const Op* const opReactivateCompletionDebugVariants[] = {&opsForOpCodes[OpByteCode_ReactivateCompletionDebug_Ibool_Inode_Pad], &opsForOpCodes[OpByteCode_ReactivateCompletionDebug_Ibool_Inode], &opsForOpCodes[OpByteCode_ReactivateCompletionDebug_Rbool_Inode_Pad], &opsForOpCodes[OpByteCode_ReactivateCompletionDebug_Rbool_Inode], nullptr};
static const Op* const opThrowVariants[] = {&opsForOpCodes[OpByteCode_Throw_Ivalue_Pad], &opsForOpCodes[OpByteCode_Throw_Ivalue], &opsForOpCodes[OpByteCode_Throw_Rvalue], nullptr};
static const Op* const opContBreakInTryFinallyVariants[] = {&opsForOpCodes[OpByteCode_ContBreakInTryFinally_Iaddr], nullptr};
static const Op* const opReturnInTryFinallyVariants[] = {&opsForOpCodes[OpByteCode_ReturnInTryFinally_Ivalue_Pad], &opsForOpCodes[OpByteCode_ReturnInTryFinally_Ivalue], &opsForOpCodes[OpByteCode_ReturnInTryFinally_Rvalue], nullptr};
static const Op* const opPropagateExceptionVariants[] = {&opsForOpCodes[OpByteCode_PropagateException], nullptr};
static const Op* const opReturnVariants[] = {&opsForOpCodes[OpByteCode_Return_Ivalue_Pad], &opsForOpCodes[OpByteCode_Return_Ivalue], &opsForOpCodes[OpByteCode_Return_Rvalue], nullptr};
static const Op* const opRaiseErrorVariants[] = {&opsForOpCodes[OpByteCode_RaiseError_Inode_Iint32_Icstr_Pad], &opsForOpCodes[OpByteCode_RaiseError_Inode_Iint32_Icstr], &opsForOpCodes[OpByteCode_RaiseError_Inode_Rint32_Icstr_Pad], &opsForOpCodes[OpByteCode_RaiseError_Inode_Rint32_Icstr], nullptr};
static const Op* const opPreambleVariants[] = {&opsForOpCodes[OpByteCode_Preamble_Ireg_Ireg_Ireg], nullptr};
static const Op* const opEnterDebugContextVariants[] = {&opsForOpCodes[OpByteCode_EnterDebugContext_Inode_Pad], &opsForOpCodes[OpByteCode_EnterDebugContext_Inode], nullptr};
static const Op* const opExitDebugContextVariants[] = {&opsForOpCodes[OpByteCode_ExitDebugContext_Inode_Pad], &opsForOpCodes[OpByteCode_ExitDebugContext_Inode], nullptr};
static const Op* const opFunctionLookupAndGetVariants[] = {&opsForOpCodes[OpByteCode_FunctionLookupAndGet_Ireg_Ireg_Iident_Pad], &opsForOpCodes[OpByteCode_FunctionLookupAndGet_Ireg_Ireg_Iident], nullptr};
static const Op* const opNonLocalFunctionLookupAndGetVariants[] = {&opsForOpCodes[OpByteCode_NonLocalFunctionLookupAndGet_Ireg_Ireg_Iident_Pad], &opsForOpCodes[OpByteCode_NonLocalFunctionLookupAndGet_Ireg_Ireg_Iident], nullptr};
static const Op* const opScopeLookupAndGetCheckedVariants[] = {&opsForOpCodes[OpByteCode_ScopeLookupAndGetChecked_Ireg_Ireg_Iident_Pad], &opsForOpCodes[OpByteCode_ScopeLookupAndGetChecked_Ireg_Ireg_Iident], nullptr};
static const Op* const opScopeLookupAndGetVariants[] = {&opsForOpCodes[OpByteCode_ScopeLookupAndGet_Ireg_Ireg_Iident_Pad], &opsForOpCodes[OpByteCode_ScopeLookupAndGet_Ireg_Ireg_Iident], nullptr};
static const Op* const opNonLocalScopeLookupAndGetCheckedVariants[] = {&opsForOpCodes[OpByteCode_NonLocalScopeLookupAndGetChecked_Ireg_Ireg_Iident_Pad], &opsForOpCodes[OpByteCode_NonLocalScopeLookupAndGetChecked_Ireg_Ireg_Iident], nullptr};
static const Op* const opNonLocalScopeLookupAndGetVariants[] = {&opsForOpCodes[OpByteCode_NonLocalScopeLookupAndGet_Ireg_Ireg_Iident_Pad], &opsForOpCodes[OpByteCode_NonLocalScopeLookupAndGet_Ireg_Ireg_Iident], nullptr};
static const Op* const opScopeLookupVariants[] = {&opsForOpCodes[OpByteCode_ScopeLookup_Ireg_Iident_Inode_Pad], &opsForOpCodes[OpByteCode_ScopeLookup_Ireg_Iident_Inode], nullptr};
static const Op* const opNonLocalScopeLookupVariants[] = {&opsForOpCodes[OpByteCode_NonLocalScopeLookup_Ireg_Iident_Inode_Pad], &opsForOpCodes[OpByteCode_NonLocalScopeLookup_Ireg_Iident_Inode], nullptr};
static const Op* const opVarGetVariants[] = {&opsForOpCodes[OpByteCode_VarGet_Ireg_Iident_Pad], &opsForOpCodes[OpByteCode_VarGet_Ireg_Iident], nullptr};
static const Op* const opNonLocalVarGetVariants[] = {&opsForOpCodes[OpByteCode_NonLocalVarGet_Ireg_Iident_Pad], &opsForOpCodes[OpByteCode_NonLocalVarGet_Ireg_Iident], nullptr};
static const Op* const opRegPutValueVariants[] = {&opsForOpCodes[OpByteCode_RegPutValue_Ireg_Ivalue_Pad], &opsForOpCodes[OpByteCode_RegPutValue_Ireg_Ivalue], &opsForOpCodes[OpByteCode_RegPutValue_Ireg_Rvalue], &opsForOpCodes[OpByteCode_RegPutValue_Ireg_Rnumber], nullptr};
static const Op* const opRegPutNumberVariants[] = {&opsForOpCodes[OpByteCode_RegPutNumber_Ireg_Inumber_Pad], &opsForOpCodes[OpByteCode_RegPutNumber_Ireg_Inumber], &opsForOpCodes[OpByteCode_RegPutNumber_Ireg_Rnumber], nullptr};
static const Op* const opRegPutBoolVariants[] = {&opsForOpCodes[OpByteCode_RegPutBool_Ireg_Ibool], &opsForOpCodes[OpByteCode_RegPutBool_Ireg_Rbool], nullptr};
static const Op* const opRegPutInt32Variants[] = {&opsForOpCodes[OpByteCode_RegPutInt32_Ireg_Iint32], &opsForOpCodes[OpByteCode_RegPutInt32_Ireg_Rint32], nullptr};
static const Op* const opToObjectVariants[] = {&opsForOpCodes[OpByteCode_ToObject_Ireg_Ivalue_Pad], &opsForOpCodes[OpByteCode_ToObject_Ireg_Ivalue], &opsForOpCodes[OpByteCode_ToObject_Ireg_Rvalue], nullptr};
static const Op* const opSymPutKnownObjectVariants[] = {&opsForOpCodes[OpByteCode_SymPutKnownObject_Rvalue_Iident_Ivalue_Pad], &opsForOpCodes[OpByteCode_SymPutKnownObject_Rvalue_Iident_Ivalue], &opsForOpCodes[OpByteCode_SymPutKnownObject_Rvalue_Iident_Rvalue_Pad], &opsForOpCodes[OpByteCode_SymPutKnownObject_Rvalue_Iident_Rvalue], &opsForOpCodes[OpByteCode_SymPutKnownObject_Rvalue_Iident_Rnumber_Pad], &opsForOpCodes[OpByteCode_SymPutKnownObject_Rvalue_Iident_Rnumber], nullptr};
static const Op* const opSymGetVariants[] = {&opsForOpCodes[OpByteCode_SymGet_Ireg_Ivalue_Iident_Pad], &opsForOpCodes[OpByteCode_SymGet_Ireg_Ivalue_Iident], &opsForOpCodes[OpByteCode_SymGet_Ireg_Rvalue_Iident_Pad], &opsForOpCodes[OpByteCode_SymGet_Ireg_Rvalue_Iident], nullptr};
static const Op* const opSymGetKnownObjectVariants[] = {&opsForOpCodes[OpByteCode_SymGetKnownObject_Ireg_Ivalue_Iident_Pad], &opsForOpCodes[OpByteCode_SymGetKnownObject_Ireg_Ivalue_Iident], &opsForOpCodes[OpByteCode_SymGetKnownObject_Ireg_Rvalue_Iident_Pad], &opsForOpCodes[OpByteCode_SymGetKnownObject_Ireg_Rvalue_Iident], nullptr};
static const Op* const opSymGetAndBindVariants[] = {&opsForOpCodes[OpByteCode_SymGetAndBind_Ireg_Ireg_Rvalue_Iident_Pad], &opsForOpCodes[OpByteCode_SymGetAndBind_Ireg_Ireg_Rvalue_Iident], nullptr};
static const Op* const opBracketGetVariants[] = {&opsForOpCodes[OpByteCode_BracketGet_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_BracketGet_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_BracketGet_Ireg_Rvalue_Rvalue], &opsForOpCodes[OpByteCode_BracketGet_Ireg_Rvalue_Iint32], &opsForOpCodes[OpByteCode_BracketGet_Ireg_Rvalue_Rint32], nullptr};
static const Op* const opBracketGetAndBindVariants[] = {&opsForOpCodes[OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Rvalue], &opsForOpCodes[OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Iint32], &opsForOpCodes[OpByteCode_BracketGetAndBind_Ireg_Ireg_Rvalue_Rint32], nullptr};
static const Op* const opBracketPutKnownObjectVariants[] = {&opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Rvalue_Rvalue], &opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Iint32_Ivalue_Pad], &opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Iint32_Ivalue], &opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Iint32_Rvalue], &opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Rint32_Ivalue_Pad], &opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Rint32_Ivalue], &opsForOpCodes[OpByteCode_BracketPutKnownObject_Rvalue_Rint32_Rvalue], nullptr};
static const Op* const opGlobalObjectGetVariants[] = {&opsForOpCodes[OpByteCode_GlobalObjectGet_Ireg_Iident_Pad], &opsForOpCodes[OpByteCode_GlobalObjectGet_Ireg_Iident], nullptr};
static const Op* const opSymDeleteKnownObjectVariants[] = {&opsForOpCodes[OpByteCode_SymDeleteKnownObject_Ireg_Ivalue_Iident_Pad], &opsForOpCodes[OpByteCode_SymDeleteKnownObject_Ireg_Ivalue_Iident], &opsForOpCodes[OpByteCode_SymDeleteKnownObject_Ireg_Rvalue_Iident_Pad], &opsForOpCodes[OpByteCode_SymDeleteKnownObject_Ireg_Rvalue_Iident], nullptr};
static const Op* const opSymDeleteVariants[] = {&opsForOpCodes[OpByteCode_SymDelete_Ireg_Ivalue_Iident_Pad], &opsForOpCodes[OpByteCode_SymDelete_Ireg_Ivalue_Iident], &opsForOpCodes[OpByteCode_SymDelete_Ireg_Rvalue_Iident_Pad], &opsForOpCodes[OpByteCode_SymDelete_Ireg_Rvalue_Iident], nullptr};
static const Op* const opBracketDeleteVariants[] = {&opsForOpCodes[OpByteCode_BracketDelete_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_BracketDelete_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_BracketDelete_Ireg_Rvalue_Rvalue], &opsForOpCodes[OpByteCode_BracketDelete_Ireg_Ivalue_Iint32_Pad], &opsForOpCodes[OpByteCode_BracketDelete_Ireg_Ivalue_Iint32], &opsForOpCodes[OpByteCode_BracketDelete_Ireg_Ivalue_Rint32_Pad], &opsForOpCodes[OpByteCode_BracketDelete_Ireg_Ivalue_Rint32], &opsForOpCodes[OpByteCode_BracketDelete_Ireg_Rvalue_Iint32], &opsForOpCodes[OpByteCode_BracketDelete_Ireg_Rvalue_Rint32], nullptr};
static const Op* const opOwnedStringVariants[] = {&opsForOpCodes[OpByteCode_OwnedString_Ireg_Istring_Pad], &opsForOpCodes[OpByteCode_OwnedString_Ireg_Istring], nullptr};
static const Op* const opNewEmptyArrayVariants[] = {&opsForOpCodes[OpByteCode_NewEmptyArray_Ireg], nullptr};
static const Op* const opNewObjectVariants[] = {&opsForOpCodes[OpByteCode_NewObject_Ireg], nullptr};
static const Op* const opNewRegExpVariants[] = {&opsForOpCodes[OpByteCode_NewRegExp_Ireg_Istring_Istring_Pad], &opsForOpCodes[OpByteCode_NewRegExp_Ireg_Istring_Istring], nullptr};
static const Op* const opDefineGetterVariants[] = {&opsForOpCodes[OpByteCode_DefineGetter_Rvalue_Iident_Ivalue_Pad], &opsForOpCodes[OpByteCode_DefineGetter_Rvalue_Iident_Ivalue], &opsForOpCodes[OpByteCode_DefineGetter_Rvalue_Iident_Rvalue_Pad], &opsForOpCodes[OpByteCode_DefineGetter_Rvalue_Iident_Rvalue], nullptr};
static const Op* const opDefineSetterVariants[] = {&opsForOpCodes[OpByteCode_DefineSetter_Rvalue_Iident_Ivalue_Pad], &opsForOpCodes[OpByteCode_DefineSetter_Rvalue_Iident_Ivalue], &opsForOpCodes[OpByteCode_DefineSetter_Rvalue_Iident_Rvalue_Pad], &opsForOpCodes[OpByteCode_DefineSetter_Rvalue_Iident_Rvalue], nullptr};
static const Op* const opAdd1Variants[] = {&opsForOpCodes[OpByteCode_Add1_Ireg_Inumber_Pad], &opsForOpCodes[OpByteCode_Add1_Ireg_Inumber], &opsForOpCodes[OpByteCode_Add1_Ireg_Rnumber], &opsForOpCodes[OpByteCode_Add1_Ireg_Rvalue], nullptr};
static const Op* const opSub1Variants[] = {&opsForOpCodes[OpByteCode_Sub1_Ireg_Inumber_Pad], &opsForOpCodes[OpByteCode_Sub1_Ireg_Inumber], &opsForOpCodes[OpByteCode_Sub1_Ireg_Rnumber], nullptr};
static const Op* const opNegVariants[] = {&opsForOpCodes[OpByteCode_Neg_Ireg_Inumber_Pad], &opsForOpCodes[OpByteCode_Neg_Ireg_Inumber], &opsForOpCodes[OpByteCode_Neg_Ireg_Rnumber], &opsForOpCodes[OpByteCode_Neg_Ireg_Rvalue], nullptr};
static const Op* const opMultVariants[] = {&opsForOpCodes[OpByteCode_Mult_Ireg_Inumber_Inumber_Pad], &opsForOpCodes[OpByteCode_Mult_Ireg_Inumber_Inumber], &opsForOpCodes[OpByteCode_Mult_Ireg_Inumber_Rnumber_Pad], &opsForOpCodes[OpByteCode_Mult_Ireg_Inumber_Rnumber], &opsForOpCodes[OpByteCode_Mult_Ireg_Rnumber_Inumber_Pad], &opsForOpCodes[OpByteCode_Mult_Ireg_Rnumber_Inumber], &opsForOpCodes[OpByteCode_Mult_Ireg_Rnumber_Rnumber], &opsForOpCodes[OpByteCode_Mult_Ireg_Rvalue_Rvalue], &opsForOpCodes[OpByteCode_Mult_Ireg_Rvalue_Rnumber], &opsForOpCodes[OpByteCode_Mult_Ireg_Rnumber_Rvalue], nullptr};
static const Op* const opDivVariants[] = {&opsForOpCodes[OpByteCode_Div_Ireg_Inumber_Inumber_Pad], &opsForOpCodes[OpByteCode_Div_Ireg_Inumber_Inumber], &opsForOpCodes[OpByteCode_Div_Ireg_Inumber_Rnumber_Pad], &opsForOpCodes[OpByteCode_Div_Ireg_Inumber_Rnumber], &opsForOpCodes[OpByteCode_Div_Ireg_Rnumber_Inumber_Pad], &opsForOpCodes[OpByteCode_Div_Ireg_Rnumber_Inumber], &opsForOpCodes[OpByteCode_Div_Ireg_Rnumber_Rnumber], nullptr};
static const Op* const opModVariants[] = {&opsForOpCodes[OpByteCode_Mod_Ireg_Inumber_Inumber_Pad], &opsForOpCodes[OpByteCode_Mod_Ireg_Inumber_Inumber], &opsForOpCodes[OpByteCode_Mod_Ireg_Inumber_Rnumber_Pad], &opsForOpCodes[OpByteCode_Mod_Ireg_Inumber_Rnumber], &opsForOpCodes[OpByteCode_Mod_Ireg_Rnumber_Inumber_Pad], &opsForOpCodes[OpByteCode_Mod_Ireg_Rnumber_Inumber], &opsForOpCodes[OpByteCode_Mod_Ireg_Rnumber_Rnumber], nullptr};
static const Op* const opExpVariants[] = {&opsForOpCodes[OpByteCode_Exp_Ireg_Inumber_Inumber_Pad], &opsForOpCodes[OpByteCode_Exp_Ireg_Inumber_Inumber], &opsForOpCodes[OpByteCode_Exp_Ireg_Inumber_Rnumber_Pad], &opsForOpCodes[OpByteCode_Exp_Ireg_Inumber_Rnumber], &opsForOpCodes[OpByteCode_Exp_Ireg_Rnumber_Inumber_Pad], &opsForOpCodes[OpByteCode_Exp_Ireg_Rnumber_Inumber], &opsForOpCodes[OpByteCode_Exp_Ireg_Rnumber_Rnumber], nullptr};
static const Op* const opSubVariants[] = {&opsForOpCodes[OpByteCode_Sub_Ireg_Inumber_Inumber_Pad], &opsForOpCodes[OpByteCode_Sub_Ireg_Inumber_Inumber], &opsForOpCodes[OpByteCode_Sub_Ireg_Inumber_Rnumber_Pad], &opsForOpCodes[OpByteCode_Sub_Ireg_Inumber_Rnumber], &opsForOpCodes[OpByteCode_Sub_Ireg_Rnumber_Inumber_Pad], &opsForOpCodes[OpByteCode_Sub_Ireg_Rnumber_Inumber], &opsForOpCodes[OpByteCode_Sub_Ireg_Rnumber_Rnumber], nullptr};
static const Op* const opAddVariants[] = {&opsForOpCodes[OpByteCode_Add_Ireg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_Add_Ireg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_Add_Ireg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_Add_Ireg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_Add_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_Add_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_Add_Ireg_Rvalue_Rvalue], &opsForOpCodes[OpByteCode_Add_Ireg_Inumber_Inumber_Pad], &opsForOpCodes[OpByteCode_Add_Ireg_Inumber_Inumber], &opsForOpCodes[OpByteCode_Add_Ireg_Inumber_Rnumber_Pad], &opsForOpCodes[OpByteCode_Add_Ireg_Inumber_Rnumber], &opsForOpCodes[OpByteCode_Add_Ireg_Rnumber_Inumber_Pad], &opsForOpCodes[OpByteCode_Add_Ireg_Rnumber_Inumber], &opsForOpCodes[OpByteCode_Add_Ireg_Rnumber_Rnumber], nullptr};
static const Op* const opLShiftVariants[] = {&opsForOpCodes[OpByteCode_LShift_Ireg_Iint32_Iint32], &opsForOpCodes[OpByteCode_LShift_Ireg_Iint32_Rint32], &opsForOpCodes[OpByteCode_LShift_Ireg_Rint32_Iint32], &opsForOpCodes[OpByteCode_LShift_Ireg_Rint32_Rint32], nullptr};
static const Op* const opRShiftVariants[] = {&opsForOpCodes[OpByteCode_RShift_Ireg_Iint32_Iint32], &opsForOpCodes[OpByteCode_RShift_Ireg_Iint32_Rint32], &opsForOpCodes[OpByteCode_RShift_Ireg_Rint32_Iint32], &opsForOpCodes[OpByteCode_RShift_Ireg_Rint32_Rint32], nullptr};
static const Op* const opURShiftVariants[] = {&opsForOpCodes[OpByteCode_URShift_Ireg_Iint32_Iint32], &opsForOpCodes[OpByteCode_URShift_Ireg_Iint32_Rint32], &opsForOpCodes[OpByteCode_URShift_Ireg_Rint32_Iint32], &opsForOpCodes[OpByteCode_URShift_Ireg_Rint32_Rint32], nullptr};
static const Op* const opLessVariants[] = {&opsForOpCodes[OpByteCode_Less_Ireg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_Less_Ireg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_Less_Ireg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_Less_Ireg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_Less_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_Less_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_Less_Ireg_Rvalue_Rvalue], &opsForOpCodes[OpByteCode_Less_Ireg_Ivalue_Inumber_Pad], &opsForOpCodes[OpByteCode_Less_Ireg_Ivalue_Inumber], &opsForOpCodes[OpByteCode_Less_Ireg_Ivalue_Rnumber_Pad], &opsForOpCodes[OpByteCode_Less_Ireg_Ivalue_Rnumber], &opsForOpCodes[OpByteCode_Less_Ireg_Rvalue_Inumber_Pad], &opsForOpCodes[OpByteCode_Less_Ireg_Rvalue_Inumber], &opsForOpCodes[OpByteCode_Less_Ireg_Rvalue_Rnumber], &opsForOpCodes[OpByteCode_Less_Ireg_Ivalue_Iint32_Pad], &opsForOpCodes[OpByteCode_Less_Ireg_Ivalue_Iint32], &opsForOpCodes[OpByteCode_Less_Ireg_Ivalue_Rint32_Pad], &opsForOpCodes[OpByteCode_Less_Ireg_Ivalue_Rint32], &opsForOpCodes[OpByteCode_Less_Ireg_Rvalue_Iint32], &opsForOpCodes[OpByteCode_Less_Ireg_Rvalue_Rint32], nullptr};
static const Op* const opGreaterEqVariants[] = {&opsForOpCodes[OpByteCode_GreaterEq_Ireg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_GreaterEq_Ireg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_GreaterEq_Ireg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_GreaterEq_Ireg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_GreaterEq_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_GreaterEq_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_GreaterEq_Ireg_Rvalue_Rvalue], nullptr};
static const Op* const opGreaterVariants[] = {&opsForOpCodes[OpByteCode_Greater_Ireg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_Greater_Ireg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_Greater_Ireg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_Greater_Ireg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_Greater_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_Greater_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_Greater_Ireg_Rvalue_Rvalue], nullptr};
static const Op* const opLessEqVariants[] = {&opsForOpCodes[OpByteCode_LessEq_Ireg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_LessEq_Ireg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_LessEq_Ireg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_LessEq_Ireg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_LessEq_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_LessEq_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_LessEq_Ireg_Rvalue_Rvalue], nullptr};
static const Op* const opEqEqVariants[] = {&opsForOpCodes[OpByteCode_EqEq_Ireg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_EqEq_Ireg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_EqEq_Ireg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_EqEq_Ireg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_EqEq_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_EqEq_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_EqEq_Ireg_Rvalue_Rvalue], &opsForOpCodes[OpByteCode_EqEq_Ireg_Ivalue_Iint32_Pad], &opsForOpCodes[OpByteCode_EqEq_Ireg_Ivalue_Iint32], &opsForOpCodes[OpByteCode_EqEq_Ireg_Ivalue_Rint32_Pad], &opsForOpCodes[OpByteCode_EqEq_Ireg_Ivalue_Rint32], &opsForOpCodes[OpByteCode_EqEq_Ireg_Rvalue_Iint32], &opsForOpCodes[OpByteCode_EqEq_Ireg_Rvalue_Rint32], nullptr};
static const Op* const opNotEqVariants[] = {&opsForOpCodes[OpByteCode_NotEq_Ireg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_NotEq_Ireg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_NotEq_Ireg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_NotEq_Ireg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_NotEq_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_NotEq_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_NotEq_Ireg_Rvalue_Rvalue], &opsForOpCodes[OpByteCode_NotEq_Ireg_Ivalue_Iint32_Pad], &opsForOpCodes[OpByteCode_NotEq_Ireg_Ivalue_Iint32], &opsForOpCodes[OpByteCode_NotEq_Ireg_Ivalue_Rint32_Pad], &opsForOpCodes[OpByteCode_NotEq_Ireg_Ivalue_Rint32], &opsForOpCodes[OpByteCode_NotEq_Ireg_Rvalue_Iint32], &opsForOpCodes[OpByteCode_NotEq_Ireg_Rvalue_Rint32], nullptr};
static const Op* const opStrEqVariants[] = {&opsForOpCodes[OpByteCode_StrEq_Ireg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_StrEq_Ireg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_StrEq_Ireg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_StrEq_Ireg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_StrEq_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_StrEq_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_StrEq_Ireg_Rvalue_Rvalue], nullptr};
static const Op* const opStrNEqVariants[] = {&opsForOpCodes[OpByteCode_StrNEq_Ireg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_StrNEq_Ireg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_StrNEq_Ireg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_StrNEq_Ireg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_StrNEq_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_StrNEq_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_StrNEq_Ireg_Rvalue_Rvalue], nullptr};
static const Op* const opBitNotVariants[] = {&opsForOpCodes[OpByteCode_BitNot_Ireg_Iint32], &opsForOpCodes[OpByteCode_BitNot_Ireg_Rint32], nullptr};
static const Op* const opBitAndVariants[] = {&opsForOpCodes[OpByteCode_BitAnd_Ireg_Iint32_Iint32], &opsForOpCodes[OpByteCode_BitAnd_Ireg_Iint32_Rint32], &opsForOpCodes[OpByteCode_BitAnd_Ireg_Rint32_Iint32], &opsForOpCodes[OpByteCode_BitAnd_Ireg_Rint32_Rint32], &opsForOpCodes[OpByteCode_BitAnd_Ireg_Rvalue_Rvalue], &opsForOpCodes[OpByteCode_BitAnd_Ireg_Rvalue_Rint32], &opsForOpCodes[OpByteCode_BitAnd_Ireg_Rint32_Rvalue], nullptr};
static const Op* const opBitXOrVariants[] = {&opsForOpCodes[OpByteCode_BitXOr_Ireg_Iint32_Iint32], &opsForOpCodes[OpByteCode_BitXOr_Ireg_Iint32_Rint32], &opsForOpCodes[OpByteCode_BitXOr_Ireg_Rint32_Iint32], &opsForOpCodes[OpByteCode_BitXOr_Ireg_Rint32_Rint32], nullptr};
static const Op* const opBitOrVariants[] = {&opsForOpCodes[OpByteCode_BitOr_Ireg_Iint32_Iint32], &opsForOpCodes[OpByteCode_BitOr_Ireg_Iint32_Rint32], &opsForOpCodes[OpByteCode_BitOr_Ireg_Rint32_Iint32], &opsForOpCodes[OpByteCode_BitOr_Ireg_Rint32_Rint32], nullptr};
static const Op* const opLogicalNotVariants[] = {&opsForOpCodes[OpByteCode_LogicalNot_Ireg_Ibool], &opsForOpCodes[OpByteCode_LogicalNot_Ireg_Rbool], nullptr};
static const Op* const opTypeOfVariants[] = {&opsForOpCodes[OpByteCode_TypeOf_Ireg_Ivalue_Pad], &opsForOpCodes[OpByteCode_TypeOf_Ireg_Ivalue], &opsForOpCodes[OpByteCode_TypeOf_Ireg_Rvalue], nullptr};
static const Op* const opInVariants[] = {&opsForOpCodes[OpByteCode_In_Ireg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_In_Ireg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_In_Ireg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_In_Ireg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_In_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_In_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_In_Ireg_Rvalue_Rvalue], nullptr};
static const Op* const opInstanceOfVariants[] = {&opsForOpCodes[OpByteCode_InstanceOf_Ireg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_InstanceOf_Ireg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_InstanceOf_Ireg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_InstanceOf_Ireg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_InstanceOf_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_InstanceOf_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_InstanceOf_Ireg_Rvalue_Rvalue], nullptr};
static const Op* const opClearArgsVariants[] = {&opsForOpCodes[OpByteCode_ClearArgs], nullptr};
static const Op* const opAddArgVariants[] = {&opsForOpCodes[OpByteCode_AddArg_Ivalue_Pad], &opsForOpCodes[OpByteCode_AddArg_Ivalue], &opsForOpCodes[OpByteCode_AddArg_Rvalue], nullptr};
static const Op* const opAdd2ArgVariants[] = {&opsForOpCodes[OpByteCode_Add2Arg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_Add2Arg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_Add2Arg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_Add2Arg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_Add2Arg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_Add2Arg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_Add2Arg_Rvalue_Rvalue], nullptr};
static const Op* const opAdd3ArgVariants[] = {&opsForOpCodes[OpByteCode_Add3Arg_Ivalue_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_Add3Arg_Ivalue_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_Add3Arg_Ivalue_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_Add3Arg_Ivalue_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_Add3Arg_Ivalue_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_Add3Arg_Ivalue_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_Add3Arg_Ivalue_Rvalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_Add3Arg_Ivalue_Rvalue_Rvalue], &opsForOpCodes[OpByteCode_Add3Arg_Rvalue_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_Add3Arg_Rvalue_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_Add3Arg_Rvalue_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_Add3Arg_Rvalue_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_Add3Arg_Rvalue_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_Add3Arg_Rvalue_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_Add3Arg_Rvalue_Rvalue_Rvalue], nullptr};
static const Op* const opFunctionCallVariants[] = {&opsForOpCodes[OpByteCode_FunctionCall_Ireg_Ivalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_FunctionCall_Ireg_Ivalue_Ivalue], &opsForOpCodes[OpByteCode_FunctionCall_Ireg_Ivalue_Rvalue_Pad], &opsForOpCodes[OpByteCode_FunctionCall_Ireg_Ivalue_Rvalue], &opsForOpCodes[OpByteCode_FunctionCall_Ireg_Rvalue_Ivalue_Pad], &opsForOpCodes[OpByteCode_FunctionCall_Ireg_Rvalue_Ivalue], &opsForOpCodes[OpByteCode_FunctionCall_Ireg_Rvalue_Rvalue], nullptr};
static const Op* const opCtorCallVariants[] = {&opsForOpCodes[OpByteCode_CtorCall_Ireg_Ivalue_Pad], &opsForOpCodes[OpByteCode_CtorCall_Ireg_Ivalue], &opsForOpCodes[OpByteCode_CtorCall_Ireg_Rvalue], nullptr};
static const Op* const opEvalFuncExprVariants[] = {&opsForOpCodes[OpByteCode_EvalFuncExpr_Ireg_Iident_Inode_Pad], &opsForOpCodes[OpByteCode_EvalFuncExpr_Ireg_Iident_Inode], nullptr};

const Op* const* const opSpecializations[] = {
    opRBool_Int32Variants,
    opRBool_ValueVariants,
    opRBool_NumberVariants,
    opRValue_BoolVariants,
    opRValue_Int32Variants,
    opRValue_NumberVariants,
    opRInt32_BoolVariants,
    opRInt32_ValueVariants,
    opRInt32_NumberVariants,
    opRNumber_BoolVariants,
    opRNumber_ValueVariants,
    opRNumber_Int32Variants,
    opRInt32_Value_NonImmVariants,
    opRNum_Value_NonImmVariants,
    opPrintInfoVariants,
    opAtStatementVariants,
    opExitVariants,
    opJumpVariants,
    opIfJumpVariants,
    opIfNotJumpVariants,
    opBeginForInVariants,
    opNextForInEntryVariants,
    opPushScopeVariants,
    opUnwindStacksVariants,
    opPopScopeVariants,
    opPopExceptionHandlerVariants,
    opPushExceptionHandlerVariants,
    opEnterCatchVariants,
    opExitCatchVariants,
    opDeferCompletionVariants,
    opReactivateCompletionVariants,
    opReactivateCompletionDebugVariants,
    opThrowVariants,
    opContBreakInTryFinallyVariants,
    opReturnInTryFinallyVariants,
    opPropagateExceptionVariants,
    opReturnVariants,
    opRaiseErrorVariants,
    opPreambleVariants,
    opEnterDebugContextVariants,
    opExitDebugContextVariants,
    opFunctionLookupAndGetVariants,
    opNonLocalFunctionLookupAndGetVariants,
    opScopeLookupAndGetCheckedVariants,
    opScopeLookupAndGetVariants,
    opNonLocalScopeLookupAndGetCheckedVariants,
    opNonLocalScopeLookupAndGetVariants,
    opScopeLookupVariants,
    opNonLocalScopeLookupVariants,
    opVarGetVariants,
    opNonLocalVarGetVariants,
    opRegPutValueVariants,
    opRegPutNumberVariants,
    opRegPutBoolVariants,
    opRegPutInt32Variants,
    opToObjectVariants,
    opSymPutKnownObjectVariants,
    opSymGetVariants,
    opSymGetKnownObjectVariants,
    opSymGetAndBindVariants,
    opBracketGetVariants,
    opBracketGetAndBindVariants,
    opBracketPutKnownObjectVariants,
    opGlobalObjectGetVariants,
    opSymDeleteKnownObjectVariants,
    opSymDeleteVariants,
    opBracketDeleteVariants,
    opOwnedStringVariants,
    opNewEmptyArrayVariants,
    opNewObjectVariants,
    opNewRegExpVariants,
    opDefineGetterVariants,
    opDefineSetterVariants,
    opAdd1Variants,
    opSub1Variants,
    opNegVariants,
    opMultVariants,
    opDivVariants,
    opModVariants,
    opExpVariants,
    opSubVariants,
    opAddVariants,
    opLShiftVariants,
    opRShiftVariants,
    opURShiftVariants,
    opLessVariants,
    opGreaterEqVariants,
    opGreaterVariants,
    opLessEqVariants,
    opEqEqVariants,
    opNotEqVariants,
    opStrEqVariants,
    opStrNEqVariants,
    opBitNotVariants,
    opBitAndVariants,
    opBitXOrVariants,
    opBitOrVariants,
    opLogicalNotVariants,
    opTypeOfVariants,
    opInVariants,
    opInstanceOfVariants,
    opClearArgsVariants,
    opAddArgVariants,
    opAdd2ArgVariants,
    opAdd3ArgVariants,
    opFunctionCallVariants,
    opCtorCallVariants,
    opEvalFuncExprVariants
};

#line 40 "/build/kjs/src/kjs-5.96.0/src/kjs/bytecode/opcodes.cpp.in"

// Note: costOut will be negative if no conversion is possible
ConvOp computeCast(const OpValue* in, OpType outType, bool outImmediate, int& costOut, bool exact)
{
    bool   inImmediate = (in->immediate != 0);
    OpType inType      = in->type;

    // Obviously, we can't make a register result into an an immediate value
    if (outImmediate && !inImmediate) {
        costOut = Cost_NoConversion;
        return Conv_NoConversion;
    }

    if (exact) {
        if (inType == outType) {
            costOut = 0;
            // We want to prefer these even if they require a spill,
            // (since the implementation is more immediate),
            // but we do want a slight cost to the spill so we don't do it for no good reason
            if (!outImmediate && inImmediate)
                costOut = 1;
            return Conv_NoOp;
        }

        // as a special case, int32 -> number conversion is always safe; otherwise
        // exact matching can't happen
        if (inType != OpType_int32 || outType != OpType_number) {
            costOut = Cost_NoConversion;
            return Conv_NoConversion;
        }
    }

    // In general, if we're converting immediate to register, we first try to
    // convert the immediate value to the right type. That will either produce
    // a fresh immediate value that be spilled directly, or may even emit the
    // conversion for us. If it produces the value --- and hence the basic conversion ---
    // all we have to do is spill it.

    // Look up in the table..
    const ConvInfo* inf = getConversionInfo(inImmediate, inType, outType);

    if (inf->costCode == Cost_Checked) {
        ASSERT(inImmediate);
        ASSERT(outType == OpType_value);
        ASSERT(inType  == OpType_int32 || inType == OpType_number);

        // Where a conversion is checked, we may not be able to get an
        // immediate<->immediate match, so we may have to generate
        // a special immediate<->register conversion.

        bool inlineOK = inType == OpType_int32 ? JSImmediate::from(in->value.narrow.int32Val) :
                                                 JSImmediate::from(in->value.wide.numberVal);

        if (outImmediate) {
            // immediate -> immediate..
            if (inlineOK)
                costOut = 0;
            else
                costOut = Cost_NoConversion;
            return inf->routine;
        } else {
            // immediate -> register.

            // If we know inline op OK, we follow the normal path below which adds in a spill cost.
            // Otherwise we emit the op directly.
            if (!inlineOK) {
                // cost about the same as register int32-> number conversion
                costOut = getConversionInfo(false, OpType_int32, OpType_value)->costCode;
                return inType == OpType_int32 ? Conv_I_R_Int32_Value :
                                                Conv_I_R_Number_Value;
            }
        }
    }

    costOut = inf->costCode;
    // Add some cost for a spill...
    if (inImmediate && !outImmediate)
        costOut += 25;

    return inf->routine;
}

void emitConversion(CompileState* comp, bool outImm,
                    ConvOp convType, OpValue* original, OpValue& out)
{
    if (emitImmediateConversion(convType, original, out)) {
        // Emit a spill if needed, after the value gets converted..
        if (!outImm && original->immediate) {  // Need both checks since NoOp might get here..
            OpValue spillVal, spillRef;

            comp->requestTemporary(out.type, &spillVal, &spillRef);
            CodeGen::emitRegStore(comp, &spillRef, &out);
            out = spillVal;
        }

        return;
    }

    if (emitSimpleRegisterConversion(comp, convType, original, out))
        return;

    switch (convType) {
    case Conv_I_R_Int32_Value:
        CodeGen::emitOp(comp, Op_RInt32_Value_NonImm, &out, original);
        break;

    case Conv_I_R_Number_Value:
        CodeGen::emitOp(comp, Op_RNum_Value_NonImm, &out, original);
        break;

    default:
        fprintf(stderr, "Unable to emit conversion:%s, in:%c, out:%c\n", ConvOpVals[convType],
               original->immediate ? 'I' : 'R', outImm ? 'I' : 'R');
        CRASH();
    };
}

static inline void setArg(unsigned char* argBase, const OpValue& val)
{
    if (val.immediate) {
        if (opTypeIsAlign8[val.type]) {
            *reinterpret_cast<WideArg*>(argBase) = val.value.wide;
        } else {
            *reinterpret_cast<NarrowArg*>(argBase) = val.value.narrow;
        }
    } else {
        // For arguments, we actually output the byte offset.
        reinterpret_cast<NarrowArg*>(argBase)->regVal = val.ownedReg->reg() * sizeof(LocalStorageEntry);
    }
}

static void emitArg(unsigned char* basePtr, const Op* opDescr, int pos, const OpValue& val)
{
    ASSERT(opDescr->immediateParams[pos] == val.immediate);
    ASSERT(opDescr->paramTypes[pos] == val.type);

    unsigned char* argBase = basePtr + opDescr->paramOffsets[pos];
    setArg(argBase, val);
}

void CodeGen::emitConvertTo(CompileState* comp, OpValue* in,
                            OpType outType, OpValue* out)
{
    int cost;
    ConvOp op = computeCast(in, outType, in->immediate, cost, false);
    ASSERT(cost >= 0);
    emitConversion(comp, in->immediate, op, in, *out);
}

void CodeGen::emitRegStore(CompileState* comp, OpValue* regNum, OpValue* val)
{
    ASSERT(regNum->immediate && regNum->type == OpType_reg);

    switch (val->type) {
    case OpType_bool:
        emitOp(comp, Op_RegPutBool, nullptr, regNum, val);
        break;
    case OpType_int32:
        emitOp(comp, Op_RegPutInt32, nullptr, regNum, val);
        break;
    case OpType_value:
        emitOp(comp, Op_RegPutValue, nullptr, regNum, val);
        break;
    case OpType_number:
        emitOp(comp, Op_RegPutNumber, nullptr, regNum, val);
        break;
    default:
        fprintf(stderr, "Don't know how to store type to register:%s\n", OpTypeVals[val->type]);
        CRASH();
    }
}

static void printType(const char* prefix, int pos, OpValue* v) {
    fprintf(stderr, "%s%d:%s/imm:%d\n", prefix, pos, OpTypeVals[v->type], v->immediate);
}

Addr CodeGen::emitOp(CompileState* comp, OpName baseInstr,
                     OpValue* retOut, OpValue* a0, OpValue* a1, OpValue* a2, OpValue* a3)
{
    CodeBlock& block = comp->codeBlock();
    const Op* const* cands = opSpecializations[baseInstr];

    const Op* cheapest = nullptr;
    int    cheapestCost = 0;
    ConvOp cheapestConvOps[4] = {Conv_NoConversion, Conv_NoConversion, Conv_NoConversion};

    // Here, we assume that all methods either return or not.
    OpType retType = opRetTypes[baseInstr];
    OpValue retVal, retReg;
    if (retType != OpType_void) {
        // Add in a register argument.. For now just a dummy #;
        // will fill in w/appropriate type later
        ASSERT(!a3);
        retReg.immediate = true;
        retReg.type      = OpType_reg;
        a3 = a2;
        a2 = a1;
        a1 = a0;
        a0 = &retReg;
    } else {
        ASSERT(!retOut);
    }

    OpValue* args[4] = {a0, a1, a2, a3};
    
    int numArgs = 0;
    while (numArgs < 4 && args[numArgs])
        ++numArgs;

#ifdef TRACE_INSTR_SELECT
    fprintf(stderr, "\n\nTrying to select variant for:%s\n", OpNameVals[baseInstr]);
    for (int i = 0; i < numArgs; ++i)
        printType("\targ", i, args[i]);
#endif
        
    // First, scan through, and determine the cheapest non-align variant.
    // We can't select whether to align or not, since we may have to emit
    // cast ops, which could change where we are.
    for (int c = 0; cands[c]; ++c) {
        const Op* cand = cands[c];
        ASSERT(cand->baseInstr == baseInstr);
        ASSERT(cand->numParams == numArgs);

        if (cand->padAlign)
            continue;

        int    costs[4];
        ConvOp convOps[4];

        int totalCost = cand->cost;
        for (int i = 0; i < numArgs; ++i) {
            convOps[i] = computeCast(args[i], cand->paramTypes[i],
                                     cand->immediateParams[i], costs[i], cand->exactParams[i]);

            totalCost += costs[i];
        }

#ifdef TRACE_INSTR_SELECT
        fprintf(stderr, "Candidate:%s, totalCost:%d, variant cost:%d\n", OpByteCodeVals[cand->opCode], totalCost, cand->cost);
        for (int i = 0; i < numArgs; ++i) {
            fprintf(stderr, "\tconv:%s, costs:%d\n", ConvOpVals[convOps[i]], costs[i]);
        }
#endif

        if (totalCost < 0) // Cost_NoConversion in the sum...
            continue;

        if (totalCost < cheapestCost || !cheapest) {
            cheapest        = cand;
            cheapestCost    = totalCost;
            cheapestConvOps[0] = convOps[0];
            cheapestConvOps[1] = convOps[1];
            cheapestConvOps[2] = convOps[2];
            cheapestConvOps[3] = convOps[3];
        }
    }

    if (!cheapest) {
        fprintf(stderr, "Unable to find an acceptable conversion for:%s\n", OpNameVals[baseInstr]);
        for (int i = 0; i < numArgs; ++i)
            printType("\ta", i, args[i]);
        CRASH(); // Should never happen!
    }

    if (cheapest->endsBB)
        comp->localFlushAll(block);

    // Now that we have a candidate, actually grab a register of the proper return type.
    retType = cheapest->retType;
    if (retType != OpType_void) {
        comp->requestTemporary(retType, &retVal, &retReg);

        // Set return value, if needed
        if (retOut)
            *retOut = retVal;
    }

    OpValue c[4]; // converted version

    for (int i = 0; i < numArgs; ++i)
        emitConversion(comp, cheapest->immediateParams[i], cheapestConvOps[i], args[i], c[i]);

    // Now figure out if we need to do align.. We need it if the PC is 8-aligned, since
    // the instr will mess that up, and the instruction need it..
    if (cheapest->hasPadVariant && ((block.size() % 8) == 0)) {
        // The padded variant of the instruction always precedes the unpadded one..
        cheapest = &opsForOpCodes[cheapest->opCode - 1];
    }

    // Phewww. Now we can actually write out stuff.
    size_t pos = block.size();
    block.resize(pos + cheapest->length);
    unsigned char* basePtr = block.data() + pos;

    // Write out the opcode..
    *reinterpret_cast<OpByteCode*>(basePtr) = cheapest->opCode;

    // ... and the args, as needed.
    for (int i = 0; i < numArgs; ++i) {
        emitArg(basePtr, cheapest, i, c[i]);
    }

    return basePtr - block.data();
}

Addr CodeGen::nextPC(CompileState* comp)
{
    CodeBlock& block = comp->codeBlock();
    comp->localFlushAll(block);
    return block.size();
}

void CodeGen::patchOpArgument(CodeBlock& block, Addr baseAddr, int pos, OpValue& newVal)
{
    OpByteCode* base = reinterpret_cast<OpByteCode*>(block.data() + baseAddr);
    const Op& variant = opsForOpCodes[*base];

    // We only permit patching immediate arguments for now..
    ASSERT(variant.immediateParams[pos] && newVal.immediate);
    ASSERT(variant.paramTypes[pos] == newVal.type);
    ASSERT(pos < variant.numParams);

    unsigned char* argBase = reinterpret_cast<unsigned char*>(base) + variant.paramOffsets[pos];
    setArg(argBase, newVal);
}

void CodeGen::patchJumpToNext(CompileState* comp, Addr op, int argNum)
{
    OpValue destAddr = OpValue::immAddr(nextPC(comp));
    patchOpArgument(comp->codeBlock(), op, argNum, destAddr);
}

static void dumpParam(CodeBlock& block, size_t offset, OpType type, bool wasImm)
{
    switch (type) {
    case OpType_bool:
        if (reinterpret_cast<NarrowArg*>(block.data() + offset)->boolVal)
            std::fprintf(stderr, "true");
        else
            std::fprintf(stderr, "false");
        break;
    case OpType_int32:
        std::fprintf(stderr, "%d", reinterpret_cast<NarrowArg*>(block.data() + offset)->int32Val);
        break;
    case OpType_value:
        // Immediate value -- should go through JSImmediate stuff..
        std::fprintf(stderr, "<ival:%s>", JSValue::toString(reinterpret_cast<WideArg*>(block.data() + offset)->valueVal, nullptr).ascii());
        break;
    case OpType_ident:
        std::fprintf(stderr, "%s", reinterpret_cast<WideArg*>(block.data() + offset)->identVal->ustring().ascii());
        break;
    case OpType_string:
        std::fprintf(stderr, "\"%s\"", reinterpret_cast<WideArg*>(block.data() + offset)->stringVal->ascii());
        break;
    case OpType_number:
        std::fprintf(stderr, "%f", reinterpret_cast<WideArg*>(block.data() + offset)->numberVal);
        break;
    case OpType_addr:
        std::fprintf(stderr, "A%08x", reinterpret_cast<NarrowArg*>(block.data() + offset)->addrVal);
        break;
    case OpType_reg:
        std::fprintf(stderr, "r%lu", reinterpret_cast<NarrowArg*>(block.data() + offset)->regVal / (wasImm ?
                    1lu : sizeof(LocalStorageEntry)));
        break;
    case OpType_node:
        std::fprintf(stderr,"N%p", (void*)(reinterpret_cast<WideArg*>(block.data() + offset)->nodeVal));
        break;
    case OpType_cstr:
        std::fprintf(stderr, "c\"%s\"", reinterpret_cast<WideArg*>(block.data() + offset)->cstrVal);
        break;
    default:
        std::fprintf(stderr, "???:%s", OpTypeVals[type]);
    };
    std::fprintf(stderr, " ");
}

void CodeGen::disassembleBlock(CodeBlock& block)
{
    size_t pc = 0;
    while (pc < block.size()) {
        OpByteCode opCode = *reinterpret_cast<OpByteCode*>(block.data() + pc);
        const Op& opDescr = opsForOpCodes[opCode];

        std::fprintf(stderr, "%08lx %s ", pc, OpNameVals[opDescr.baseInstr]);
        for (int p = 0; p < opDescr.numParams; ++p) {
            dumpParam(block, pc + opDescr.paramOffsets[p],
                      opDescr.immediateParams[p] ? opDescr.paramTypes[p] : OpType_reg, opDescr.immediateParams[p]);
        }

        std::fprintf(stderr, "\t\t// %s\n", OpByteCodeVals[opCode]);
        pc += opDescr.length;
    }
}

} //namespace KJS
// kate: indent-width 4; replace-tabs on; tab-width 4; space-indent on; hl c++;

