/* contacts-editor-property.c generated by valac 0.56.0, the Vala compiler
 * generated from contacts-editor-property.vala, do not modify */

/*
 * Copyright (C) 2019 Purism SPC
 * Author: Julian Sparber <julian.sparber@puri.sm>
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <folks/folks.h>
#include <adwaita.h>
#include "contacts.h"
#include <gee.h>
#include <gio/gio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_BIRTHDAY_EDITOR (contacts_birthday_editor_get_type ())
#define CONTACTS_BIRTHDAY_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditor))
#define CONTACTS_BIRTHDAY_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditorClass))
#define CONTACTS_IS_BIRTHDAY_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_BIRTHDAY_EDITOR))
#define CONTACTS_IS_BIRTHDAY_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_BIRTHDAY_EDITOR))
#define CONTACTS_BIRTHDAY_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditorClass))

typedef struct _ContactsBirthdayEditor ContactsBirthdayEditor;
typedef struct _ContactsBirthdayEditorClass ContactsBirthdayEditorClass;
typedef struct _ContactsBirthdayEditorPrivate ContactsBirthdayEditorPrivate;
enum  {
	CONTACTS_BIRTHDAY_EDITOR_0_PROPERTY,
	CONTACTS_BIRTHDAY_EDITOR_IS_SET_PROPERTY,
	CONTACTS_BIRTHDAY_EDITOR_NUM_PROPERTIES
};
static GParamSpec* contacts_birthday_editor_properties[CONTACTS_BIRTHDAY_EDITOR_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	CONTACTS_BIRTHDAY_EDITOR_CHANGED_SIGNAL,
	CONTACTS_BIRTHDAY_EDITOR_NUM_SIGNALS
};
static guint contacts_birthday_editor_signals[CONTACTS_BIRTHDAY_EDITOR_NUM_SIGNALS] = {0};

#define CONTACTS_TYPE_ADDRESS_EDITOR (contacts_address_editor_get_type ())
#define CONTACTS_ADDRESS_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_ADDRESS_EDITOR, ContactsAddressEditor))
#define CONTACTS_ADDRESS_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_ADDRESS_EDITOR, ContactsAddressEditorClass))
#define CONTACTS_IS_ADDRESS_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_ADDRESS_EDITOR))
#define CONTACTS_IS_ADDRESS_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_ADDRESS_EDITOR))
#define CONTACTS_ADDRESS_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_ADDRESS_EDITOR, ContactsAddressEditorClass))

typedef struct _ContactsAddressEditor ContactsAddressEditor;
typedef struct _ContactsAddressEditorClass ContactsAddressEditorClass;
typedef struct _ContactsAddressEditorPrivate ContactsAddressEditorPrivate;
enum  {
	CONTACTS_ADDRESS_EDITOR_0_PROPERTY,
	CONTACTS_ADDRESS_EDITOR_NUM_PROPERTIES
};
static GParamSpec* contacts_address_editor_properties[CONTACTS_ADDRESS_EDITOR_NUM_PROPERTIES];
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;
enum  {
	CONTACTS_ADDRESS_EDITOR_CHANGED_SIGNAL,
	CONTACTS_ADDRESS_EDITOR_NUM_SIGNALS
};
static guint contacts_address_editor_signals[CONTACTS_ADDRESS_EDITOR_NUM_SIGNALS] = {0};

#define CONTACTS_TYPE_ROLE_EDITOR (contacts_role_editor_get_type ())
#define CONTACTS_ROLE_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_ROLE_EDITOR, ContactsRoleEditor))
#define CONTACTS_ROLE_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_ROLE_EDITOR, ContactsRoleEditorClass))
#define CONTACTS_IS_ROLE_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_ROLE_EDITOR))
#define CONTACTS_IS_ROLE_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_ROLE_EDITOR))
#define CONTACTS_ROLE_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_ROLE_EDITOR, ContactsRoleEditorClass))

typedef struct _ContactsRoleEditor ContactsRoleEditor;
typedef struct _ContactsRoleEditorClass ContactsRoleEditorClass;
typedef struct _ContactsRoleEditorPrivate ContactsRoleEditorPrivate;
enum  {
	CONTACTS_ROLE_EDITOR_0_PROPERTY,
	CONTACTS_ROLE_EDITOR_NUM_PROPERTIES
};
static GParamSpec* contacts_role_editor_properties[CONTACTS_ROLE_EDITOR_NUM_PROPERTIES];
enum  {
	CONTACTS_ROLE_EDITOR_CHANGED_SIGNAL,
	CONTACTS_ROLE_EDITOR_NUM_SIGNALS
};
static guint contacts_role_editor_signals[CONTACTS_ROLE_EDITOR_NUM_SIGNALS] = {0};

#define CONTACTS_TYPE_EDITOR_PROPERTY_ROW (contacts_editor_property_row_get_type ())
#define CONTACTS_EDITOR_PROPERTY_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_EDITOR_PROPERTY_ROW, ContactsEditorPropertyRow))
#define CONTACTS_EDITOR_PROPERTY_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_EDITOR_PROPERTY_ROW, ContactsEditorPropertyRowClass))
#define CONTACTS_IS_EDITOR_PROPERTY_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_EDITOR_PROPERTY_ROW))
#define CONTACTS_IS_EDITOR_PROPERTY_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_EDITOR_PROPERTY_ROW))
#define CONTACTS_EDITOR_PROPERTY_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_EDITOR_PROPERTY_ROW, ContactsEditorPropertyRowClass))

typedef struct _ContactsEditorPropertyRow ContactsEditorPropertyRow;
typedef struct _ContactsEditorPropertyRowClass ContactsEditorPropertyRowClass;
typedef struct _ContactsEditorPropertyRowPrivate ContactsEditorPropertyRowPrivate;
enum  {
	CONTACTS_EDITOR_PROPERTY_ROW_0_PROPERTY,
	CONTACTS_EDITOR_PROPERTY_ROW_IS_EMPTY_PROPERTY,
	CONTACTS_EDITOR_PROPERTY_ROW_IS_REMOVED_PROPERTY,
	CONTACTS_EDITOR_PROPERTY_ROW_REMOVABLE_PROPERTY,
	CONTACTS_EDITOR_PROPERTY_ROW_PTYPE_PROPERTY,
	CONTACTS_EDITOR_PROPERTY_ROW_NUM_PROPERTIES
};
static GParamSpec* contacts_editor_property_row_properties[CONTACTS_EDITOR_PROPERTY_ROW_NUM_PROPERTIES];
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;

#define CONTACTS_TYPE_TYPECOMBO_ROW (contacts_typecombo_row_get_type ())
#define CONTACTS_TYPECOMBO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_TYPECOMBO_ROW, ContactsTypeComboRow))
#define CONTACTS_TYPECOMBO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_TYPECOMBO_ROW, ContactsTypeComboRowClass))
#define CONTACTS_IS_TYPECOMBO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_TYPECOMBO_ROW))
#define CONTACTS_IS_TYPECOMBO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_TYPECOMBO_ROW))
#define CONTACTS_TYPECOMBO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_TYPECOMBO_ROW, ContactsTypeComboRowClass))

typedef struct _ContactsTypeComboRow ContactsTypeComboRow;
typedef struct _ContactsTypeComboRowClass ContactsTypeComboRowClass;
typedef struct _Block27Data Block27Data;

#define CONTACTS_TYPE_EDITOR_PROPERTY (contacts_editor_property_get_type ())
#define CONTACTS_EDITOR_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_EDITOR_PROPERTY, ContactsEditorProperty))
#define CONTACTS_EDITOR_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_EDITOR_PROPERTY, ContactsEditorPropertyClass))
#define CONTACTS_IS_EDITOR_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_EDITOR_PROPERTY))
#define CONTACTS_IS_EDITOR_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_EDITOR_PROPERTY))
#define CONTACTS_EDITOR_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_EDITOR_PROPERTY, ContactsEditorPropertyClass))

typedef struct _ContactsEditorProperty ContactsEditorProperty;
typedef struct _ContactsEditorPropertyClass ContactsEditorPropertyClass;
typedef struct _ContactsEditorPropertyPrivate ContactsEditorPropertyPrivate;
enum  {
	CONTACTS_EDITOR_PROPERTY_0_PROPERTY,
	CONTACTS_EDITOR_PROPERTY_WRITEABLE_PROPERTY,
	CONTACTS_EDITOR_PROPERTY_NUM_PROPERTIES
};
static GParamSpec* contacts_editor_property_properties[CONTACTS_EDITOR_PROPERTY_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block28Data Block28Data;
typedef struct _Block29Data Block29Data;
typedef struct _Block30Data Block30Data;
typedef struct _Block31Data Block31Data;
typedef struct _Block32Data Block32Data;
typedef struct _Block33Data Block33Data;
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
typedef struct _Block34Data Block34Data;
typedef struct _Block35Data Block35Data;
typedef struct _Block36Data Block36Data;

struct _ContactsBirthdayEditor {
	GtkDialog parent_instance;
	ContactsBirthdayEditorPrivate * priv;
};

struct _ContactsBirthdayEditorClass {
	GtkDialogClass parent_class;
};

struct _ContactsBirthdayEditorPrivate {
	GtkSpinButton* day_spin;
	GtkComboBoxText* month_combo;
	GtkSpinButton* year_spin;
	gboolean _is_set;
};

struct _ContactsAddressEditor {
	GtkBox parent_instance;
	ContactsAddressEditorPrivate * priv;
};

struct _ContactsAddressEditorClass {
	GtkBoxClass parent_class;
};

struct _ContactsAddressEditorPrivate {
	GtkEntry* entries[7];
};

struct _Block23Data {
	int _ref_count_;
	ContactsAddressEditor* self;
	FolksPostalAddressFieldDetails* details;
};

struct _Block24Data {
	int _ref_count_;
	Block23Data * _data23_;
	gchar* prop_name;
};

struct _ContactsRoleEditor {
	GtkBox parent_instance;
	ContactsRoleEditorPrivate * priv;
};

struct _ContactsRoleEditorClass {
	GtkBoxClass parent_class;
};

struct _ContactsRoleEditorPrivate {
	GtkEntry* role_entry;
	GtkEntry* organisation_entry;
};

struct _ContactsEditorPropertyRow {
	AdwBin parent_instance;
	ContactsEditorPropertyRowPrivate * priv;
};

struct _ContactsEditorPropertyRowClass {
	AdwBinClass parent_class;
};

struct _ContactsEditorPropertyRowPrivate {
	GtkRevealer* revealer;
	GtkListBox* listbox;
	gboolean _is_empty;
	gboolean _is_removed;
	gboolean _removable;
	gchar* _ptype;
};

struct _Block25Data {
	int _ref_count_;
	ContactsEditorPropertyRow* self;
	GtkListBoxRow* row;
	GtkWidget* widget;
};

struct _Block26Data {
	int _ref_count_;
	ContactsEditorPropertyRow* self;
	GtkEntry* entry;
};

struct _Block27Data {
	int _ref_count_;
	ContactsEditorPropertyRow* self;
	ContactsTypeComboRow* row;
	GeeSet* details_set;
	FolksAbstractFieldDetails* details;
};

struct _ContactsEditorProperty {
	GObject parent_instance;
	ContactsEditorPropertyPrivate * priv;
};

struct _ContactsEditorPropertyClass {
	GObjectClass parent_class;
};

struct _ContactsEditorPropertyPrivate {
	GPtrArray* rows;
	gboolean _writeable;
};

struct _Block28Data {
	int _ref_count_;
	ContactsEditorProperty* self;
	GtkEntry* entry;
	GeeSet* details_set;
	FolksEmailFieldDetails* details;
};

struct _Block29Data {
	int _ref_count_;
	ContactsEditorProperty* self;
	GtkEntry* entry;
	GeeSet* details_set;
	FolksPhoneFieldDetails* details;
};

struct _Block30Data {
	int _ref_count_;
	ContactsEditorProperty* self;
	GtkEntry* entry;
	GeeSet* details_set;
	FolksUrlFieldDetails* details;
};

struct _Block31Data {
	int _ref_count_;
	ContactsEditorProperty* self;
	GtkEntry* entry;
	FolksNameDetails* details;
};

struct _Block32Data {
	int _ref_count_;
	ContactsEditorProperty* self;
	ContactsEditorPropertyRow* box;
	GtkTextView* textview;
	GeeSet* details_set;
	FolksNoteFieldDetails* details;
};

struct _Block33Data {
	int _ref_count_;
	ContactsEditorProperty* self;
	GDateTime* date;
	GtkButton* button;
	ContactsEditorPropertyRow* box;
	FolksBirthdayDetails* details;
};

struct _Block34Data {
	int _ref_count_;
	Block33Data * _data33_;
	ContactsBirthdayEditor* dialog;
};

struct _Block35Data {
	int _ref_count_;
	ContactsEditorProperty* self;
	ContactsEditorPropertyRow* box;
	ContactsAddressEditor* value_address;
	GeeSet* details_set;
};

struct _Block36Data {
	int _ref_count_;
	ContactsEditorProperty* self;
	ContactsEditorPropertyRow* box;
	ContactsRoleEditor* role_editor;
	GeeSet* details_set;
};

static gint ContactsBirthdayEditor_private_offset;
static gpointer contacts_birthday_editor_parent_class = NULL;
static gint ContactsAddressEditor_private_offset;
static gpointer contacts_address_editor_parent_class = NULL;
static gchar** contacts_address_editor_postal_element_names;
static gint contacts_address_editor_postal_element_names_length1;
static gchar** contacts_address_editor_postal_element_names = NULL;
static gint contacts_address_editor_postal_element_names_length1 = 0;
static gint _contacts_address_editor_postal_element_names_size_ = 0;
static gint ContactsRoleEditor_private_offset;
static gpointer contacts_role_editor_parent_class = NULL;
static gint ContactsEditorPropertyRow_private_offset;
static gpointer contacts_editor_property_row_parent_class = NULL;
static gint ContactsEditorProperty_private_offset;
static gpointer contacts_editor_property_parent_class = NULL;
static GListModelInterface * contacts_editor_property_g_list_model_parent_iface = NULL;

VALA_EXTERN GType contacts_birthday_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsBirthdayEditor, g_object_unref)
VALA_EXTERN ContactsBirthdayEditor* contacts_birthday_editor_new (GtkWindow* window,
                                                      GDateTime* birthday);
VALA_EXTERN ContactsBirthdayEditor* contacts_birthday_editor_construct (GType object_type,
                                                            GtkWindow* window,
                                                            GDateTime* birthday);
static void contacts_birthday_editor_update_date (ContactsBirthdayEditor* self);
static void __lambda32_ (ContactsBirthdayEditor* self);
static void ___lambda32__gtk_combo_box_changed (GtkComboBox* _sender,
                                         gpointer self);
static void __lambda33_ (ContactsBirthdayEditor* self);
static void ___lambda33__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                 gpointer self);
VALA_EXTERN GDateTime* contacts_birthday_editor_get_birthday (ContactsBirthdayEditor* self);
static gboolean _vala_int_array_contains (gint * stack,
                                   gssize stack_length,
                                   const gint needle);
VALA_EXTERN gboolean contacts_birthday_editor_get_is_set (ContactsBirthdayEditor* self);
VALA_EXTERN void contacts_birthday_editor_set_is_set (ContactsBirthdayEditor* self,
                                          gboolean value);
static GObject * contacts_birthday_editor_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _contacts_birthday_editor___lambda34_ (ContactsBirthdayEditor* self,
                                            gint id);
static void __contacts_birthday_editor___lambda34__gtk_dialog_response (GtkDialog* _sender,
                                                                 gint response_id,
                                                                 gpointer self);
static void contacts_birthday_editor_finalize (GObject * obj);
static GType contacts_birthday_editor_get_type_once (void);
static void _vala_contacts_birthday_editor_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_contacts_birthday_editor_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
VALA_EXTERN GType contacts_address_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAddressEditor, g_object_unref)
VALA_EXTERN ContactsAddressEditor* contacts_address_editor_new (FolksPostalAddressFieldDetails* details);
VALA_EXTERN ContactsAddressEditor* contacts_address_editor_construct (GType object_type,
                                                          FolksPostalAddressFieldDetails* details);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void _____lambda38_ (Block24Data* _data24_,
                     GtkEditable* editable);
static void ______lambda38__gtk_editable_changed (GtkEditable* _sender,
                                           gpointer self);
VALA_EXTERN gboolean contacts_address_editor_is_empty (ContactsAddressEditor* self);
static GObject * contacts_address_editor_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void contacts_address_editor_finalize (GObject * obj);
static GType contacts_address_editor_get_type_once (void);
VALA_EXTERN GType contacts_role_editor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsRoleEditor, g_object_unref)
VALA_EXTERN ContactsRoleEditor* contacts_role_editor_new (FolksRoleFieldDetails* details);
VALA_EXTERN ContactsRoleEditor* contacts_role_editor_construct (GType object_type,
                                                    FolksRoleFieldDetails* details);
VALA_EXTERN gboolean contacts_role_editor_is_empty (ContactsRoleEditor* self);
static GObject * contacts_role_editor_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _contacts_role_editor___lambda40_ (ContactsRoleEditor* self,
                                        GtkEditable* _);
static void __contacts_role_editor___lambda40__gtk_editable_changed (GtkEditable* _sender,
                                                              gpointer self);
static void _contacts_role_editor___lambda41_ (ContactsRoleEditor* self,
                                        GtkEditable* _);
static void __contacts_role_editor___lambda41__gtk_editable_changed (GtkEditable* _sender,
                                                              gpointer self);
static void contacts_role_editor_finalize (GObject * obj);
static GType contacts_role_editor_get_type_once (void);
VALA_EXTERN GType contacts_editor_property_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsEditorPropertyRow, g_object_unref)
VALA_EXTERN ContactsEditorPropertyRow* contacts_editor_property_row_new (const gchar* type);
VALA_EXTERN ContactsEditorPropertyRow* contacts_editor_property_row_construct (GType object_type,
                                                                   const gchar* type);
VALA_EXTERN void contacts_editor_property_row_show_with_animation (ContactsEditorPropertyRow* self,
                                                       gboolean animate);
VALA_EXTERN void contacts_editor_property_row_remove (ContactsEditorPropertyRow* self);
VALA_EXTERN const gchar* contacts_editor_property_row_get_ptype (ContactsEditorPropertyRow* self);
static gboolean __lambda21_ (ContactsEditorPropertyRow* self);
static gboolean ___lambda21__gsource_func (gpointer self);
static void __lambda22_ (ContactsEditorPropertyRow* self);
static void ___lambda22__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN void contacts_editor_property_row_set_main_widget (ContactsEditorPropertyRow* self,
                                                   GtkWidget* widget,
                                                   gboolean add_icon);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void __lambda23_ (Block25Data* _data25_,
                  GtkListBoxRow* activated_row);
static void ___lambda23__gtk_list_box_row_activated (GtkListBox* _sender,
                                              GtkListBoxRow* row,
                                              gpointer self);
VALA_EXTERN gboolean contacts_editor_property_row_get_removable (ContactsEditorPropertyRow* self);
static void ___lambda24_ (ContactsEditorPropertyRow* self,
                   GtkButton* b);
static void ____lambda24__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
VALA_EXTERN GtkEntry* contacts_editor_property_row_set_main_entry (ContactsEditorPropertyRow* self,
                                                       const gchar* text,
                                                       const gchar* placeholder);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
VALA_EXTERN void contacts_editor_property_row_set_is_empty (ContactsEditorPropertyRow* self,
                                                gboolean value);
static void __lambda25_ (Block26Data* _data26_);
static void ___lambda25__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
VALA_EXTERN void contacts_editor_property_row_add_type_combo (ContactsEditorPropertyRow* self,
                                                  GeeSet* details_set,
                                                  ContactsTypeSet* combo_type,
                                                  FolksAbstractFieldDetails* details);
VALA_EXTERN GType contacts_typecombo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsTypeComboRow, g_object_unref)
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
VALA_EXTERN ContactsTypeComboRow* contacts_typecombo_row_new (ContactsTypeSet* type_set);
VALA_EXTERN ContactsTypeComboRow* contacts_typecombo_row_construct (GType object_type,
                                                        ContactsTypeSet* type_set);
VALA_EXTERN void contacts_typecombo_row_set_selected_from_field_details (ContactsTypeComboRow* self,
                                                             FolksAbstractFieldDetails* details);
static void __lambda26_ (Block27Data* _data27_,
                  GObject* obj,
                  GParamSpec* pspec);
VALA_EXTERN ContactsTypeDescriptor* contacts_typecombo_row_get_selected_descriptor (ContactsTypeComboRow* self);
static void ___lambda26__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN gboolean contacts_editor_property_row_get_is_empty (ContactsEditorPropertyRow* self);
VALA_EXTERN gboolean contacts_editor_property_row_get_is_removed (ContactsEditorPropertyRow* self);
VALA_EXTERN void contacts_editor_property_row_set_is_removed (ContactsEditorPropertyRow* self,
                                                  gboolean value);
VALA_EXTERN void contacts_editor_property_row_set_removable (ContactsEditorPropertyRow* self,
                                                 gboolean value);
static void contacts_editor_property_row_set_ptype (ContactsEditorPropertyRow* self,
                                             const gchar* value);
static GObject * contacts_editor_property_row_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void contacts_editor_property_row_finalize (GObject * obj);
static GType contacts_editor_property_row_get_type_once (void);
static void _vala_contacts_editor_property_row_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_contacts_editor_property_row_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
VALA_EXTERN GType contacts_editor_property_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsEditorProperty, g_object_unref)
VALA_EXTERN ContactsEditorProperty* contacts_editor_property_new (FolksPersona* persona,
                                                      const gchar* property_name,
                                                      gboolean only_new);
VALA_EXTERN ContactsEditorProperty* contacts_editor_property_construct (GType object_type,
                                                            FolksPersona* persona,
                                                            const gchar* property_name,
                                                            gboolean only_new);
static void contacts_editor_property_set_writeable (ContactsEditorProperty* self,
                                             gboolean value);
static void contacts_editor_property_create_for_property (ContactsEditorProperty* self,
                                                   FolksPersona* p,
                                                   const gchar* prop_name,
                                                   gboolean only_new);
static GObject* contacts_editor_property_real_get_item (GListModel* base,
                                                 guint i);
static guint contacts_editor_property_real_get_n_items (GListModel* base);
static GType contacts_editor_property_real_get_item_type (GListModel* base);
static ContactsEditorPropertyRow* contacts_editor_property_create_for_email (ContactsEditorProperty* self,
                                                                      GeeSet* details_set,
                                                                      FolksEmailFieldDetails* details);
VALA_EXTERN gboolean contacts_editor_property_get_writeable (ContactsEditorProperty* self);
static ContactsEditorPropertyRow* contacts_editor_property_create_for_phone (ContactsEditorProperty* self,
                                                                      GeeSet* details_set,
                                                                      FolksPhoneFieldDetails* details);
static ContactsEditorPropertyRow* contacts_editor_property_create_for_url (ContactsEditorProperty* self,
                                                                    GeeSet* details_set,
                                                                    FolksUrlFieldDetails* details);
static ContactsEditorPropertyRow* contacts_editor_property_create_for_nick (ContactsEditorProperty* self,
                                                                     FolksNameDetails* details);
static ContactsEditorPropertyRow* contacts_editor_property_create_for_birthday (ContactsEditorProperty* self,
                                                                         FolksBirthdayDetails* details);
static ContactsEditorPropertyRow* contacts_editor_property_create_for_note (ContactsEditorProperty* self,
                                                                     GeeSet* details_set,
                                                                     FolksNoteFieldDetails* details);
static ContactsEditorPropertyRow* contacts_editor_property_create_for_address (ContactsEditorProperty* self,
                                                                        GeeSet* details_set,
                                                                        FolksPostalAddressFieldDetails* details);
static ContactsEditorPropertyRow* contacts_editor_property_create_for_role (ContactsEditorProperty* self,
                                                                     GeeSet* details_set,
                                                                     FolksRoleFieldDetails* details);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static void __lambda27_ (Block28Data* _data28_);
static void ___lambda27__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void __lambda28_ (Block29Data* _data29_);
static void ___lambda28__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static void __lambda29_ (Block30Data* _data30_);
static void ___lambda29__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void __lambda30_ (Block31Data* _data31_);
static void ___lambda30__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static void __lambda37_ (Block32Data* _data32_);
static void ___lambda37__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                           gpointer self);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void __lambda31_ (Block33Data* _data33_);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
static void ___lambda35_ (Block34Data* _data34_);
static void ____lambda35__contacts_birthday_editor_changed (ContactsBirthdayEditor* _sender,
                                                     gpointer self);
static void ___lambda31__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda36_ (Block33Data* _data33_);
static void ___lambda36__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
static void __lambda39_ (Block35Data* _data35_);
static void ___lambda39__contacts_address_editor_changed (ContactsAddressEditor* _sender,
                                                   gpointer self);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
static void __lambda42_ (Block36Data* _data36_);
static void ___lambda42__contacts_role_editor_changed (ContactsRoleEditor* _sender,
                                                gpointer self);
static GObject * contacts_editor_property_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void contacts_editor_property_finalize (GObject * obj);
static GType contacts_editor_property_get_type_once (void);
static void _vala_contacts_editor_property_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_contacts_editor_property_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* CONTACTS_ADDRESS_EDITOR_postal_element_props[7] = {"street", "extension", "locality", "region", "postal_code", "po_box", "country"};

static inline gpointer
contacts_birthday_editor_get_instance_private (ContactsBirthdayEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsBirthdayEditor_private_offset);
}

static void
__lambda32_ (ContactsBirthdayEditor* self)
{
	contacts_birthday_editor_update_date (self);
}

static void
___lambda32__gtk_combo_box_changed (GtkComboBox* _sender,
                                    gpointer self)
{
	__lambda32_ ((ContactsBirthdayEditor*) self);
}

static void
__lambda33_ (ContactsBirthdayEditor* self)
{
	contacts_birthday_editor_update_date (self);
}

static void
___lambda33__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                            gpointer self)
{
	__lambda33_ ((ContactsBirthdayEditor*) self);
}

ContactsBirthdayEditor*
contacts_birthday_editor_construct (GType object_type,
                                    GtkWindow* window,
                                    GDateTime* birthday)
{
	ContactsBirthdayEditor * self = NULL;
	GDateTime* bday_local = NULL;
	GDateTime* _tmp0_;
	GtkSpinButton* _tmp1_;
	GtkComboBoxText* _tmp2_;
	GtkSpinButton* _tmp3_;
	GtkComboBoxText* _tmp4_;
	GtkSpinButton* _tmp5_;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (birthday != NULL, NULL);
	self = (ContactsBirthdayEditor*) g_object_new (object_type, "transient-for", window, "use-header-bar", 1, "modal", TRUE, NULL);
	_tmp0_ = g_date_time_to_local (birthday);
	bday_local = _tmp0_;
	_tmp1_ = self->priv->day_spin;
	gtk_spin_button_set_value (_tmp1_, (gdouble) g_date_time_get_day_of_month (bday_local));
	_tmp2_ = self->priv->month_combo;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp2_, g_date_time_get_month (bday_local) - 1);
	_tmp3_ = self->priv->year_spin;
	gtk_spin_button_set_value (_tmp3_, (gdouble) g_date_time_get_year (bday_local));
	contacts_birthday_editor_update_date (self);
	_tmp4_ = self->priv->month_combo;
	g_signal_connect_object ((GtkComboBox*) _tmp4_, "changed", (GCallback) ___lambda32__gtk_combo_box_changed, self, 0);
	_tmp5_ = self->priv->year_spin;
	g_signal_connect_object (_tmp5_, "value-changed", (GCallback) ___lambda33__gtk_spin_button_value_changed, self, 0);
	_g_date_time_unref0 (bday_local);
	return self;
}

ContactsBirthdayEditor*
contacts_birthday_editor_new (GtkWindow* window,
                              GDateTime* birthday)
{
	return contacts_birthday_editor_construct (CONTACTS_TYPE_BIRTHDAY_EDITOR, window, birthday);
}

/**
   * Returns the selected birthday (in UTC timezone)
   */
GDateTime*
contacts_birthday_editor_get_birthday (ContactsBirthdayEditor* self)
{
	GtkSpinButton* _tmp0_;
	GtkComboBoxText* _tmp1_;
	GtkSpinButton* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->year_spin;
	_tmp1_ = self->priv->month_combo;
	_tmp2_ = self->priv->day_spin;
	_tmp3_ = g_date_time_new_local (gtk_spin_button_get_value_as_int (_tmp0_), gtk_combo_box_get_active ((GtkComboBox*) _tmp1_) + 1, gtk_spin_button_get_value_as_int (_tmp2_), 0, 0, (gdouble) 0);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_date_time_to_utc (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_date_time_unref0 (_tmp4_);
	result = _tmp6_;
	return result;
}

static gboolean
_vala_int_array_contains (gint * stack,
                          gssize stack_length,
                          const gint needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
contacts_birthday_editor_update_date (ContactsBirthdayEditor* self)
{
	static const gint month_of_31[4] = {3, 5, 8, 10};
	GtkComboBoxText* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->month_combo;
	if (_vala_int_array_contains (month_of_31, G_N_ELEMENTS (month_of_31), gtk_combo_box_get_active ((GtkComboBox*) _tmp0_))) {
		GtkSpinButton* _tmp1_;
		_tmp1_ = self->priv->day_spin;
		gtk_spin_button_set_range (_tmp1_, (gdouble) 1, (gdouble) 30);
	} else {
		GtkComboBoxText* _tmp2_;
		_tmp2_ = self->priv->month_combo;
		if (gtk_combo_box_get_active ((GtkComboBox*) _tmp2_) == 1) {
			gboolean _tmp3_ = FALSE;
			GtkSpinButton* _tmp4_;
			_tmp4_ = self->priv->year_spin;
			if ((gtk_spin_button_get_value_as_int (_tmp4_) % 400) == 0) {
				_tmp3_ = TRUE;
			} else {
				gboolean _tmp5_ = FALSE;
				GtkSpinButton* _tmp6_;
				_tmp6_ = self->priv->year_spin;
				if ((gtk_spin_button_get_value_as_int (_tmp6_) % 4) == 0) {
					GtkSpinButton* _tmp7_;
					_tmp7_ = self->priv->year_spin;
					_tmp5_ = (gtk_spin_button_get_value_as_int (_tmp7_) % 100) != 0;
				} else {
					_tmp5_ = FALSE;
				}
				_tmp3_ = _tmp5_;
			}
			if (_tmp3_) {
				GtkSpinButton* _tmp8_;
				_tmp8_ = self->priv->day_spin;
				gtk_spin_button_set_range (_tmp8_, (gdouble) 1, (gdouble) 29);
			} else {
				GtkSpinButton* _tmp9_;
				_tmp9_ = self->priv->day_spin;
				gtk_spin_button_set_range (_tmp9_, (gdouble) 1, (gdouble) 28);
			}
		} else {
			GtkSpinButton* _tmp10_;
			_tmp10_ = self->priv->day_spin;
			gtk_spin_button_set_range (_tmp10_, (gdouble) 1, (gdouble) 31);
		}
	}
}

gboolean
contacts_birthday_editor_get_is_set (ContactsBirthdayEditor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_set;
	return result;
}

void
contacts_birthday_editor_set_is_set (ContactsBirthdayEditor* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_birthday_editor_get_is_set (self);
	if (old_value != value) {
		self->priv->_is_set = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_birthday_editor_properties[CONTACTS_BIRTHDAY_EDITOR_IS_SET_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_contacts_birthday_editor___lambda34_ (ContactsBirthdayEditor* self,
                                       gint id)
{
	switch (id) {
		case GTK_RESPONSE_OK:
		{
			contacts_birthday_editor_set_is_set (self, TRUE);
			g_signal_emit (self, contacts_birthday_editor_signals[CONTACTS_BIRTHDAY_EDITOR_CHANGED_SIGNAL], 0);
			break;
		}
		case GTK_RESPONSE_CANCEL:
		{
			break;
		}
		default:
		break;
	}
	gtk_window_destroy ((GtkWindow*) self);
}

static void
__contacts_birthday_editor___lambda34__gtk_dialog_response (GtkDialog* _sender,
                                                            gint response_id,
                                                            gpointer self)
{
	_contacts_birthday_editor___lambda34_ ((ContactsBirthdayEditor*) self, response_id);
}

static GObject *
contacts_birthday_editor_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsBirthdayEditor * self;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkBox* _tmp4_;
	GtkGrid* _tmp5_;
	GtkSpinButton* d_spin = NULL;
	GtkSpinButton* _tmp6_;
	GtkSpinButton* _tmp7_;
	GtkSpinButton* _tmp8_;
	GtkSpinButton* _tmp9_;
	GtkComboBoxText* m_combo = NULL;
	GtkComboBoxText* _tmp10_;
	GDateTime* january = NULL;
	GDateTime* _tmp11_;
	GtkComboBoxText* _tmp20_;
	GtkComboBoxText* _tmp21_;
	GtkSpinButton* y_spin = NULL;
	GtkSpinButton* _tmp22_;
	GtkSpinButton* _tmp23_;
	GtkSpinButton* _tmp24_;
	GtkSpinButton* _tmp25_;
	GtkLabel* day = NULL;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkGrid* _tmp28_;
	GtkLabel* _tmp29_;
	GtkGrid* _tmp30_;
	GtkSpinButton* _tmp31_;
	GtkLabel* month = NULL;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkGrid* _tmp34_;
	GtkLabel* _tmp35_;
	GtkGrid* _tmp36_;
	GtkComboBoxText* _tmp37_;
	GtkLabel* year = NULL;
	GtkLabel* _tmp38_;
	GtkLabel* _tmp39_;
	GtkGrid* _tmp40_;
	GtkLabel* _tmp41_;
	GtkGrid* _tmp42_;
	GtkSpinButton* _tmp43_;
	GtkWidget* ok_button = NULL;
	GtkWidget* _tmp44_;
	GtkWidget* _tmp45_;
	GtkWidget* _tmp46_;
	parent_class = G_OBJECT_CLASS (contacts_birthday_editor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditor);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	_tmp1_ = grid;
	gtk_grid_set_column_spacing (_tmp1_, 12);
	_tmp2_ = grid;
	gtk_grid_set_row_spacing (_tmp2_, 12);
	_tmp3_ = grid;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, "contacts-editor-birthday");
	_tmp4_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp5_ = grid;
	gtk_box_append (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkSpinButton*) gtk_spin_button_new_with_range (1.0, 31.0, 1.0);
	g_object_ref_sink (_tmp6_);
	d_spin = _tmp6_;
	_tmp7_ = d_spin;
	gtk_spin_button_set_digits (_tmp7_, (guint) 0);
	_tmp8_ = d_spin;
	gtk_spin_button_set_numeric (_tmp8_, TRUE);
	_tmp9_ = d_spin;
	self->priv->day_spin = _tmp9_;
	_tmp10_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp10_);
	m_combo = _tmp10_;
	_tmp11_ = g_date_time_new_local (1, 1, 1, 1, 1, (gdouble) 1);
	january = _tmp11_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				GDateTime* month = NULL;
				GDateTime* _tmp14_;
				GDateTime* _tmp15_;
				GtkComboBoxText* _tmp16_;
				GDateTime* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(i < 12)) {
					break;
				}
				_tmp14_ = january;
				_tmp15_ = g_date_time_add_months (_tmp14_, i);
				month = _tmp15_;
				_tmp16_ = m_combo;
				_tmp17_ = month;
				_tmp18_ = g_date_time_format (_tmp17_, "%B");
				_tmp19_ = _tmp18_;
				gtk_combo_box_text_append_text (_tmp16_, _tmp19_);
				_g_free0 (_tmp19_);
				_g_date_time_unref0 (month);
			}
		}
	}
	_tmp20_ = m_combo;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp20_, TRUE);
	_tmp21_ = m_combo;
	self->priv->month_combo = _tmp21_;
	_tmp22_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1800, (gdouble) 3000, (gdouble) 1);
	g_object_ref_sink (_tmp22_);
	y_spin = _tmp22_;
	_tmp23_ = y_spin;
	gtk_spin_button_set_digits (_tmp23_, (guint) 0);
	_tmp24_ = y_spin;
	gtk_spin_button_set_numeric (_tmp24_, TRUE);
	_tmp25_ = y_spin;
	self->priv->year_spin = _tmp25_;
	_tmp26_ = (GtkLabel*) gtk_label_new (_ ("Day"));
	g_object_ref_sink (_tmp26_);
	day = _tmp26_;
	_tmp27_ = day;
	gtk_widget_set_halign ((GtkWidget*) _tmp27_, GTK_ALIGN_END);
	_tmp28_ = grid;
	_tmp29_ = day;
	gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 0, 0, 1, 1);
	_tmp30_ = grid;
	_tmp31_ = self->priv->day_spin;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 1, 0, 1, 1);
	_tmp32_ = (GtkLabel*) gtk_label_new (_ ("Month"));
	g_object_ref_sink (_tmp32_);
	month = _tmp32_;
	_tmp33_ = month;
	gtk_widget_set_halign ((GtkWidget*) _tmp33_, GTK_ALIGN_END);
	_tmp34_ = grid;
	_tmp35_ = month;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 0, 1, 1, 1);
	_tmp36_ = grid;
	_tmp37_ = self->priv->month_combo;
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 1, 1, 1, 1);
	_tmp38_ = (GtkLabel*) gtk_label_new (_ ("Year"));
	g_object_ref_sink (_tmp38_);
	year = _tmp38_;
	_tmp39_ = year;
	gtk_widget_set_halign ((GtkWidget*) _tmp39_, GTK_ALIGN_END);
	_tmp40_ = grid;
	_tmp41_ = year;
	gtk_grid_attach (_tmp40_, (GtkWidget*) _tmp41_, 0, 2, 1, 1);
	_tmp42_ = grid;
	_tmp43_ = self->priv->year_spin;
	gtk_grid_attach (_tmp42_, (GtkWidget*) _tmp43_, 1, 2, 1, 1);
	gtk_window_set_title ((GtkWindow*) self, _ ("Change Birthday"));
	gtk_dialog_add_buttons ((GtkDialog*) self, _ ("Set"), GTK_RESPONSE_OK, _ ("Cancel"), GTK_RESPONSE_CANCEL, NULL, NULL);
	_tmp44_ = gtk_dialog_get_widget_for_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
	_tmp45_ = _g_object_ref0 (_tmp44_);
	ok_button = _tmp45_;
	_tmp46_ = ok_button;
	gtk_widget_add_css_class (_tmp46_, "suggested-action");
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __contacts_birthday_editor___lambda34__gtk_dialog_response, self, 0);
	_g_object_unref0 (ok_button);
	_g_object_unref0 (year);
	_g_object_unref0 (month);
	_g_object_unref0 (day);
	_g_object_unref0 (y_spin);
	_g_date_time_unref0 (january);
	_g_object_unref0 (m_combo);
	_g_object_unref0 (d_spin);
	_g_object_unref0 (grid);
	return obj;
}

static void
contacts_birthday_editor_class_init (ContactsBirthdayEditorClass * klass,
                                     gpointer klass_data)
{
	contacts_birthday_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsBirthdayEditor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_birthday_editor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_birthday_editor_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_birthday_editor_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_birthday_editor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_BIRTHDAY_EDITOR_IS_SET_PROPERTY, contacts_birthday_editor_properties[CONTACTS_BIRTHDAY_EDITOR_IS_SET_PROPERTY] = g_param_spec_boolean ("is-set", "is-set", "is-set", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	contacts_birthday_editor_signals[CONTACTS_BIRTHDAY_EDITOR_CHANGED_SIGNAL] = g_signal_new ("changed", CONTACTS_TYPE_BIRTHDAY_EDITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
contacts_birthday_editor_instance_init (ContactsBirthdayEditor * self,
                                        gpointer klass)
{
	self->priv = contacts_birthday_editor_get_instance_private (self);
	self->priv->_is_set = FALSE;
}

static void
contacts_birthday_editor_finalize (GObject * obj)
{
	ContactsBirthdayEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditor);
	G_OBJECT_CLASS (contacts_birthday_editor_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_birthday_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsBirthdayEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_birthday_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsBirthdayEditor), 0, (GInstanceInitFunc) contacts_birthday_editor_instance_init, NULL };
	GType contacts_birthday_editor_type_id;
	contacts_birthday_editor_type_id = g_type_register_static (gtk_dialog_get_type (), "ContactsBirthdayEditor", &g_define_type_info, 0);
	ContactsBirthdayEditor_private_offset = g_type_add_instance_private (contacts_birthday_editor_type_id, sizeof (ContactsBirthdayEditorPrivate));
	return contacts_birthday_editor_type_id;
}

GType
contacts_birthday_editor_get_type (void)
{
	static volatile gsize contacts_birthday_editor_type_id__once = 0;
	if (g_once_init_enter (&contacts_birthday_editor_type_id__once)) {
		GType contacts_birthday_editor_type_id;
		contacts_birthday_editor_type_id = contacts_birthday_editor_get_type_once ();
		g_once_init_leave (&contacts_birthday_editor_type_id__once, contacts_birthday_editor_type_id);
	}
	return contacts_birthday_editor_type_id__once;
}

static void
_vala_contacts_birthday_editor_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ContactsBirthdayEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditor);
	switch (property_id) {
		case CONTACTS_BIRTHDAY_EDITOR_IS_SET_PROPERTY:
		g_value_set_boolean (value, contacts_birthday_editor_get_is_set (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_birthday_editor_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	ContactsBirthdayEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_BIRTHDAY_EDITOR, ContactsBirthdayEditor);
	switch (property_id) {
		case CONTACTS_BIRTHDAY_EDITOR_IS_SET_PROPERTY:
		contacts_birthday_editor_set_is_set (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_address_editor_get_instance_private (ContactsAddressEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsAddressEditor_private_offset);
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		ContactsAddressEditor* self;
		self = _data23_->self;
		_g_object_unref0 (_data23_->details);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		ContactsAddressEditor* self;
		self = _data24_->_data23_->self;
		_g_free0 (_data24_->prop_name);
		block23_data_unref (_data24_->_data23_);
		_data24_->_data23_ = NULL;
		g_slice_free (Block24Data, _data24_);
	}
}

static void
_____lambda38_ (Block24Data* _data24_,
                GtkEditable* editable)
{
	Block23Data* _data23_;
	ContactsAddressEditor* self;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	_data23_ = _data24_->_data23_;
	self = _data23_->self;
	g_return_if_fail (editable != NULL);
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _data23_->details);
	_tmp1_ = _tmp0_;
	_tmp2_ = _data24_->prop_name;
	_tmp3_ = gtk_editable_get_text (editable);
	_tmp4_ = _tmp3_;
	g_object_set ((GObject*) ((FolksPostalAddress*) _tmp1_), _tmp2_, _tmp4_, NULL);
	g_signal_emit (self, contacts_address_editor_signals[CONTACTS_ADDRESS_EDITOR_CHANGED_SIGNAL], 0);
}

static void
______lambda38__gtk_editable_changed (GtkEditable* _sender,
                                      gpointer self)
{
	_____lambda38_ (self, _sender);
}

ContactsAddressEditor*
contacts_address_editor_construct (GType object_type,
                                   FolksPostalAddressFieldDetails* details)
{
	ContactsAddressEditor * self = NULL;
	Block23Data* _data23_;
	FolksPostalAddressFieldDetails* _tmp0_;
	g_return_val_if_fail (details != NULL, NULL);
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (details);
	_g_object_unref0 (_data23_->details);
	_data23_->details = _tmp0_;
	self = (ContactsAddressEditor*) g_object_new (object_type, NULL);
	_data23_->self = g_object_ref (self);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				Block24Data* _data24_;
				gchar* postal_part = NULL;
				gconstpointer _tmp3_;
				gconstpointer _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_ = NULL;
				GtkEntry* _tmp7_;
				GtkEntry* _tmp8_;
				GtkEntry* _tmp9_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				GtkEntry* _tmp12_;
				const gchar* _tmp13_;
				GtkEntry* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				GtkEntry* _tmp19_;
				_data24_ = g_slice_new0 (Block24Data);
				_data24_->_ref_count_ = 1;
				_data24_->_data23_ = block23_data_ref (_data23_);
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 7)) {
					block24_data_unref (_data24_);
					_data24_ = NULL;
					break;
				}
				_tmp3_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _data23_->details);
				_tmp4_ = _tmp3_;
				_tmp5_ = CONTACTS_ADDRESS_EDITOR_postal_element_props[i];
				g_object_get ((GObject*) ((FolksPostalAddress*) _tmp4_), _tmp5_, &_tmp6_, NULL);
				_g_free0 (postal_part);
				postal_part = _tmp6_;
				_tmp7_ = (GtkEntry*) gtk_entry_new ();
				g_object_ref_sink (_tmp7_);
				_g_object_unref0 (self->priv->entries[i]);
				self->priv->entries[i] = _tmp7_;
				_tmp8_ = self->priv->entries[i];
				gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
				_tmp9_ = self->priv->entries[i];
				_tmp10_ = contacts_address_editor_postal_element_names;
				_tmp10__length1 = contacts_address_editor_postal_element_names_length1;
				_tmp11_ = _tmp10_[i];
				gtk_entry_set_placeholder_text (_tmp9_, _tmp11_);
				_tmp12_ = self->priv->entries[i];
				gtk_widget_add_css_class ((GtkWidget*) _tmp12_, "flat");
				_tmp13_ = postal_part;
				if (_tmp13_ != NULL) {
					GtkEntry* _tmp14_;
					const gchar* _tmp15_;
					_tmp14_ = self->priv->entries[i];
					_tmp15_ = postal_part;
					gtk_editable_set_text ((GtkEditable*) _tmp14_, _tmp15_);
				}
				_tmp16_ = self->priv->entries[i];
				gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp16_);
				_tmp17_ = CONTACTS_ADDRESS_EDITOR_postal_element_props[i];
				_tmp18_ = g_strdup (_tmp17_);
				_data24_->prop_name = _tmp18_;
				_tmp19_ = self->priv->entries[i];
				g_signal_connect_data ((GtkEditable*) _tmp19_, "changed", (GCallback) ______lambda38__gtk_editable_changed, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
				_g_free0 (postal_part);
				block24_data_unref (_data24_);
				_data24_ = NULL;
			}
		}
	}
	block23_data_unref (_data23_);
	_data23_ = NULL;
	return self;
}

ContactsAddressEditor*
contacts_address_editor_new (FolksPostalAddressFieldDetails* details)
{
	return contacts_address_editor_construct (CONTACTS_TYPE_ADDRESS_EDITOR, details);
}

gboolean
contacts_address_editor_is_empty (ContactsAddressEditor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GtkEntry** entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = self->priv->entries;
		entry_collection_length1 = 7;
		for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
			GtkEntry* _tmp0_;
			GtkEntry* entry = NULL;
			_tmp0_ = _g_object_ref0 (entry_collection[entry_it]);
			entry = _tmp0_;
			{
				GtkEntry* _tmp1_;
				const gchar* _tmp2_;
				_tmp1_ = entry;
				_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
				if (g_strcmp0 (_tmp2_, "") != 0) {
					result = FALSE;
					_g_object_unref0 (entry);
					return result;
				}
				_g_object_unref0 (entry);
			}
		}
	}
	result = TRUE;
	return result;
}

static GObject *
contacts_address_editor_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsAddressEditor * self;
	parent_class = G_OBJECT_CLASS (contacts_address_editor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_ADDRESS_EDITOR, ContactsAddressEditor);
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-editor-address");
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	return obj;
}

static void
contacts_address_editor_class_init (ContactsAddressEditorClass * klass,
                                    gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	contacts_address_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsAddressEditor_private_offset);
	G_OBJECT_CLASS (klass)->constructor = contacts_address_editor_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_address_editor_finalize;
	contacts_address_editor_signals[CONTACTS_ADDRESS_EDITOR_CHANGED_SIGNAL] = g_signal_new ("changed", CONTACTS_TYPE_ADDRESS_EDITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_strdup (_ ("Street"));
	_tmp1_ = g_strdup (_ ("Extension"));
	_tmp2_ = g_strdup (_ ("City"));
	_tmp3_ = g_strdup (_ ("State/Province"));
	_tmp4_ = g_strdup (_ ("Zip/Postal Code"));
	_tmp5_ = g_strdup (_ ("PO box"));
	_tmp6_ = g_strdup (_ ("Country"));
	_tmp7_ = g_new0 (gchar*, 7 + 1);
	_tmp7_[0] = _tmp0_;
	_tmp7_[1] = _tmp1_;
	_tmp7_[2] = _tmp2_;
	_tmp7_[3] = _tmp3_;
	_tmp7_[4] = _tmp4_;
	_tmp7_[5] = _tmp5_;
	_tmp7_[6] = _tmp6_;
	contacts_address_editor_postal_element_names = _tmp7_;
	contacts_address_editor_postal_element_names_length1 = 7;
}

static void
contacts_address_editor_instance_init (ContactsAddressEditor * self,
                                       gpointer klass)
{
	self->priv = contacts_address_editor_get_instance_private (self);
}

static void
contacts_address_editor_finalize (GObject * obj)
{
	ContactsAddressEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_ADDRESS_EDITOR, ContactsAddressEditor);
	_vala_array_destroy (self->priv->entries, 7, (GDestroyNotify) g_object_unref);
	G_OBJECT_CLASS (contacts_address_editor_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_address_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsAddressEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_address_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAddressEditor), 0, (GInstanceInitFunc) contacts_address_editor_instance_init, NULL };
	GType contacts_address_editor_type_id;
	contacts_address_editor_type_id = g_type_register_static (gtk_box_get_type (), "ContactsAddressEditor", &g_define_type_info, 0);
	ContactsAddressEditor_private_offset = g_type_add_instance_private (contacts_address_editor_type_id, sizeof (ContactsAddressEditorPrivate));
	return contacts_address_editor_type_id;
}

GType
contacts_address_editor_get_type (void)
{
	static volatile gsize contacts_address_editor_type_id__once = 0;
	if (g_once_init_enter (&contacts_address_editor_type_id__once)) {
		GType contacts_address_editor_type_id;
		contacts_address_editor_type_id = contacts_address_editor_get_type_once ();
		g_once_init_leave (&contacts_address_editor_type_id__once, contacts_address_editor_type_id);
	}
	return contacts_address_editor_type_id__once;
}

static inline gpointer
contacts_role_editor_get_instance_private (ContactsRoleEditor* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsRoleEditor_private_offset);
}

ContactsRoleEditor*
contacts_role_editor_construct (GType object_type,
                                FolksRoleFieldDetails* details)
{
	ContactsRoleEditor * self = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	GtkEntry* _tmp2_;
	gconstpointer _tmp3_;
	gconstpointer _tmp4_;
	GtkEntry* _tmp5_;
	g_return_val_if_fail (details != NULL, NULL);
	self = (ContactsRoleEditor*) g_object_new (object_type, NULL);
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) details);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->role_entry;
	g_object_bind_property_with_closures ((GObject*) ((FolksRole*) _tmp1_), "title", (GObject*) _tmp2_, "text", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp3_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) details);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->organisation_entry;
	g_object_bind_property_with_closures ((GObject*) ((FolksRole*) _tmp4_), "organisation-name", (GObject*) _tmp5_, "text", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return self;
}

ContactsRoleEditor*
contacts_role_editor_new (FolksRoleFieldDetails* details)
{
	return contacts_role_editor_construct (CONTACTS_TYPE_ROLE_EDITOR, details);
}

gboolean
contacts_role_editor_is_empty (ContactsRoleEditor* self)
{
	gboolean _tmp0_ = FALSE;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->role_entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	if (g_strcmp0 (_tmp2_, "") != 0) {
		GtkEntry* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->organisation_entry;
		_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
		_tmp0_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
_contacts_role_editor___lambda40_ (ContactsRoleEditor* self,
                                   GtkEditable* _)
{
	g_return_if_fail (_ != NULL);
	g_signal_emit (self, contacts_role_editor_signals[CONTACTS_ROLE_EDITOR_CHANGED_SIGNAL], 0);
}

static void
__contacts_role_editor___lambda40__gtk_editable_changed (GtkEditable* _sender,
                                                         gpointer self)
{
	_contacts_role_editor___lambda40_ ((ContactsRoleEditor*) self, _sender);
}

static void
_contacts_role_editor___lambda41_ (ContactsRoleEditor* self,
                                   GtkEditable* _)
{
	g_return_if_fail (_ != NULL);
	g_signal_emit (self, contacts_role_editor_signals[CONTACTS_ROLE_EDITOR_CHANGED_SIGNAL], 0);
}

static void
__contacts_role_editor___lambda41__gtk_editable_changed (GtkEditable* _sender,
                                                         gpointer self)
{
	_contacts_role_editor___lambda41_ ((ContactsRoleEditor*) self, _sender);
}

static GObject *
contacts_role_editor_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsRoleEditor * self;
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkEntry* _tmp11_;
	parent_class = G_OBJECT_CLASS (contacts_role_editor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_ROLE_EDITOR, ContactsRoleEditor);
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-editor-role");
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp0_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->role_entry);
	self->priv->role_entry = _tmp0_;
	_tmp1_ = self->priv->role_entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->role_entry;
	gtk_entry_set_placeholder_text (_tmp2_, _ ("Role"));
	_tmp3_ = self->priv->role_entry;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, "flat");
	_tmp4_ = self->priv->role_entry;
	g_signal_connect_object ((GtkEditable*) _tmp4_, "changed", (GCallback) __contacts_role_editor___lambda40__gtk_editable_changed, self, 0);
	_tmp5_ = self->priv->role_entry;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->organisation_entry);
	self->priv->organisation_entry = _tmp6_;
	_tmp7_ = self->priv->organisation_entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = self->priv->organisation_entry;
	gtk_entry_set_placeholder_text (_tmp8_, _ ("Organisation"));
	_tmp9_ = self->priv->organisation_entry;
	gtk_widget_add_css_class ((GtkWidget*) _tmp9_, "flat");
	_tmp10_ = self->priv->organisation_entry;
	g_signal_connect_object ((GtkEditable*) _tmp10_, "changed", (GCallback) __contacts_role_editor___lambda41__gtk_editable_changed, self, 0);
	_tmp11_ = self->priv->organisation_entry;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp11_);
	return obj;
}

static void
contacts_role_editor_class_init (ContactsRoleEditorClass * klass,
                                 gpointer klass_data)
{
	contacts_role_editor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsRoleEditor_private_offset);
	G_OBJECT_CLASS (klass)->constructor = contacts_role_editor_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_role_editor_finalize;
	contacts_role_editor_signals[CONTACTS_ROLE_EDITOR_CHANGED_SIGNAL] = g_signal_new ("changed", CONTACTS_TYPE_ROLE_EDITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
contacts_role_editor_instance_init (ContactsRoleEditor * self,
                                    gpointer klass)
{
	self->priv = contacts_role_editor_get_instance_private (self);
}

static void
contacts_role_editor_finalize (GObject * obj)
{
	ContactsRoleEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_ROLE_EDITOR, ContactsRoleEditor);
	_g_object_unref0 (self->priv->role_entry);
	_g_object_unref0 (self->priv->organisation_entry);
	G_OBJECT_CLASS (contacts_role_editor_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_role_editor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsRoleEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_role_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsRoleEditor), 0, (GInstanceInitFunc) contacts_role_editor_instance_init, NULL };
	GType contacts_role_editor_type_id;
	contacts_role_editor_type_id = g_type_register_static (gtk_box_get_type (), "ContactsRoleEditor", &g_define_type_info, 0);
	ContactsRoleEditor_private_offset = g_type_add_instance_private (contacts_role_editor_type_id, sizeof (ContactsRoleEditorPrivate));
	return contacts_role_editor_type_id;
}

GType
contacts_role_editor_get_type (void)
{
	static volatile gsize contacts_role_editor_type_id__once = 0;
	if (g_once_init_enter (&contacts_role_editor_type_id__once)) {
		GType contacts_role_editor_type_id;
		contacts_role_editor_type_id = contacts_role_editor_get_type_once ();
		g_once_init_leave (&contacts_role_editor_type_id__once, contacts_role_editor_type_id);
	}
	return contacts_role_editor_type_id__once;
}

static inline gpointer
contacts_editor_property_row_get_instance_private (ContactsEditorPropertyRow* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsEditorPropertyRow_private_offset);
}

ContactsEditorPropertyRow*
contacts_editor_property_row_construct (GType object_type,
                                        const gchar* type)
{
	ContactsEditorPropertyRow * self = NULL;
	g_return_val_if_fail (type != NULL, NULL);
	self = (ContactsEditorPropertyRow*) g_object_new (object_type, "ptype", type, NULL);
	return self;
}

ContactsEditorPropertyRow*
contacts_editor_property_row_new (const gchar* type)
{
	return contacts_editor_property_row_construct (CONTACTS_TYPE_EDITOR_PROPERTY_ROW, type);
}

void
contacts_editor_property_row_show_with_animation (ContactsEditorPropertyRow* self,
                                                  gboolean animate)
{
	g_return_if_fail (self != NULL);
	if (!animate) {
		guint duration = 0U;
		GtkRevealer* _tmp0_;
		GtkRevealer* _tmp1_;
		GtkRevealer* _tmp2_;
		_tmp0_ = self->priv->revealer;
		duration = gtk_revealer_get_transition_duration (_tmp0_);
		_tmp1_ = self->priv->revealer;
		gtk_revealer_set_reveal_child (_tmp1_, TRUE);
		_tmp2_ = self->priv->revealer;
		gtk_revealer_set_transition_duration (_tmp2_, duration);
	} else {
		GtkRevealer* _tmp3_;
		_tmp3_ = self->priv->revealer;
		gtk_revealer_set_reveal_child (_tmp3_, TRUE);
	}
}

static gboolean
__lambda21_ (ContactsEditorPropertyRow* self)
{
	gboolean result;
	result = FALSE;
	return result;
}

static gboolean
___lambda21__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda21_ ((ContactsEditorPropertyRow*) self);
	return result;
}

static void
__lambda22_ (ContactsEditorPropertyRow* self)
{
	g_signal_emit_by_name ((GtkWidget*) self, "destroy");
}

static void
___lambda22__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda22_ ((ContactsEditorPropertyRow*) self);
}

void
contacts_editor_property_row_remove (ContactsEditorPropertyRow* self)
{
	const gchar* _tmp0_;
	GtkRevealer* _tmp1_;
	GtkRevealer* _tmp2_;
	GtkRevealer* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_ptype;
	g_debug ("contacts-editor-property.vala:281: Property %s is removed", _tmp0_);
	_tmp1_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp1_, FALSE);
	_tmp2_ = self->priv->revealer;
	g_timeout_add_full (G_PRIORITY_DEFAULT, gtk_revealer_get_transition_duration (_tmp2_) / 2, ___lambda21__gsource_func, g_object_ref (self), g_object_unref);
	_tmp3_ = self->priv->revealer;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::child-revealed", (GCallback) ___lambda22__g_object_notify, self, 0);
}

/**
   * Setter for the main widget, which can be used to actually edit the property
   */
static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		ContactsEditorPropertyRow* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->row);
		_g_object_unref0 (_data25_->widget);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static void
__lambda23_ (Block25Data* _data25_,
             GtkListBoxRow* activated_row)
{
	ContactsEditorPropertyRow* self;
	GtkListBoxRow* _tmp0_;
	self = _data25_->self;
	g_return_if_fail (activated_row != NULL);
	_tmp0_ = _data25_->row;
	if (_tmp0_ == activated_row) {
		gtk_widget_mnemonic_activate (_data25_->widget, FALSE);
	}
}

static void
___lambda23__gtk_list_box_row_activated (GtkListBox* _sender,
                                         GtkListBoxRow* row,
                                         gpointer self)
{
	__lambda23_ (self, row);
}

static void
___lambda24_ (ContactsEditorPropertyRow* self,
              GtkButton* b)
{
	g_return_if_fail (b != NULL);
	contacts_editor_property_row_remove (self);
}

static void
____lambda24__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda24_ ((ContactsEditorPropertyRow*) self, _sender);
}

void
contacts_editor_property_row_set_main_widget (ContactsEditorPropertyRow* self,
                                              GtkWidget* widget,
                                              gboolean add_icon)
{
	Block25Data* _data25_;
	GtkWidget* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkBox* box = NULL;
	GtkBox* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp18_;
	GtkListBox* _tmp19_;
	gboolean _tmp20_;
	GtkListBox* _tmp27_;
	GtkListBoxRow* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data25_->widget);
	_data25_->widget = _tmp0_;
	_tmp1_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	g_object_ref_sink (_tmp1_);
	_data25_->row = _tmp1_;
	_tmp2_ = _data25_->row;
	gtk_widget_set_focusable ((GtkWidget*) _tmp2_, FALSE);
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp3_);
	box = _tmp3_;
	gtk_widget_set_hexpand (_data25_->widget, TRUE);
	_tmp4_ = _data25_->row;
	_tmp5_ = box;
	gtk_list_box_row_set_child (_tmp4_, (GtkWidget*) _tmp5_);
	if (add_icon) {
		const gchar* icon_name = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = self->priv->_ptype;
		_tmp7_ = contacts_utils_get_icon_name_for_property (_tmp6_);
		icon_name = _tmp7_;
		_tmp8_ = icon_name;
		if (_tmp8_ != NULL) {
			GtkImage* icon = NULL;
			const gchar* _tmp9_;
			GtkImage* _tmp10_;
			GtkImage* _tmp11_;
			GtkImage* _tmp12_;
			GtkImage* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			GtkBox* _tmp16_;
			GtkImage* _tmp17_;
			_tmp9_ = icon_name;
			_tmp10_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp9_);
			g_object_ref_sink (_tmp10_);
			icon = _tmp10_;
			_tmp11_ = icon;
			gtk_widget_set_valign ((GtkWidget*) _tmp11_, GTK_ALIGN_START);
			_tmp12_ = icon;
			gtk_widget_add_css_class ((GtkWidget*) _tmp12_, "contacts-property-icon");
			_tmp13_ = icon;
			_tmp14_ = self->priv->_ptype;
			_tmp15_ = contacts_utils_get_display_name_for_property (_tmp14_);
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp13_, _tmp15_);
			_tmp16_ = box;
			_tmp17_ = icon;
			gtk_box_prepend (_tmp16_, (GtkWidget*) _tmp17_);
			_g_object_unref0 (icon);
		}
	}
	gtk_widget_add_css_class (_data25_->widget, "contacts-editor-main-widget");
	_tmp18_ = box;
	gtk_box_append (_tmp18_, _data25_->widget);
	_tmp19_ = self->priv->listbox;
	g_signal_connect_data (_tmp19_, "row-activated", (GCallback) ___lambda23__gtk_list_box_row_activated, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_tmp20_ = self->priv->_removable;
	if (_tmp20_) {
		GtkButton* delete_button = NULL;
		GtkButton* _tmp21_;
		GtkButton* _tmp22_;
		GtkButton* _tmp23_;
		GtkButton* _tmp24_;
		GtkBox* _tmp25_;
		GtkButton* _tmp26_;
		_tmp21_ = (GtkButton*) gtk_button_new_from_icon_name ("user-trash-symbolic");
		g_object_ref_sink (_tmp21_);
		delete_button = _tmp21_;
		_tmp22_ = delete_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp22_, _ ("Delete field"));
		_tmp23_ = delete_button;
		g_object_bind_property_with_closures ((GObject*) self, "is-empty", (GObject*) _tmp23_, "sensitive", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp24_ = delete_button;
		g_signal_connect_object (_tmp24_, "clicked", (GCallback) ____lambda24__gtk_button_clicked, self, 0);
		_tmp25_ = box;
		_tmp26_ = delete_button;
		gtk_box_append (_tmp25_, (GtkWidget*) _tmp26_);
		_g_object_unref0 (delete_button);
	}
	_tmp27_ = self->priv->listbox;
	_tmp28_ = _data25_->row;
	gtk_list_box_append (_tmp27_, (GtkWidget*) _tmp28_);
	_g_object_unref0 (box);
	block25_data_unref (_data25_);
	_data25_ = NULL;
}

/**
   * Wrapper around set_main_widget() with some extra styling for GtkEntries,
   * as well as making sure the "is-empty" property is updated.
   */
static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		ContactsEditorPropertyRow* self;
		self = _data26_->self;
		_g_object_unref0 (_data26_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static void
__lambda25_ (Block26Data* _data26_)
{
	ContactsEditorPropertyRow* self;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = _data26_->self;
	_tmp0_ = _data26_->entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	contacts_editor_property_row_set_is_empty (self, g_strcmp0 (_tmp2_, "") == 0);
}

static void
___lambda25__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda25_ (self);
}

GtkEntry*
contacts_editor_property_row_set_main_entry (ContactsEditorPropertyRow* self,
                                             const gchar* text,
                                             const gchar* placeholder)
{
	Block26Data* _data26_;
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	const gchar* icon_name = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GtkEntry* _tmp12_;
	GtkEntry* _tmp13_;
	GtkEntry* _tmp14_;
	GtkEntry* _tmp15_;
	GtkEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	_tmp0_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp0_);
	_data26_->entry = _tmp0_;
	_tmp1_ = _data26_->entry;
	gtk_editable_set_text ((GtkEditable*) _tmp1_, text);
	_tmp2_ = _data26_->entry;
	gtk_entry_set_placeholder_text (_tmp2_, placeholder);
	_tmp3_ = _data26_->entry;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, "flat");
	_tmp4_ = self->priv->_ptype;
	_tmp5_ = contacts_utils_get_icon_name_for_property (_tmp4_);
	icon_name = _tmp5_;
	_tmp6_ = icon_name;
	if (_tmp6_ != NULL) {
		GtkEntry* _tmp7_;
		const gchar* _tmp8_;
		GtkEntry* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp7_ = _data26_->entry;
		_tmp8_ = icon_name;
		g_object_set (_tmp7_, "primary-icon-name", _tmp8_, NULL);
		_tmp9_ = _data26_->entry;
		_tmp10_ = self->priv->_ptype;
		_tmp11_ = contacts_utils_get_display_name_for_property (_tmp10_);
		g_object_set (_tmp9_, "primary-icon-tooltip-text", _tmp11_, NULL);
	}
	_tmp12_ = _data26_->entry;
	contacts_editor_property_row_set_main_widget (self, (GtkWidget*) _tmp12_, FALSE);
	contacts_editor_property_row_set_is_empty (self, g_strcmp0 (text, "") == 0);
	_tmp13_ = _data26_->entry;
	g_signal_connect_data ((GtkEditable*) _tmp13_, "changed", (GCallback) ___lambda25__gtk_editable_changed, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
	_tmp14_ = _data26_->entry;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	result = _tmp15_;
	block26_data_unref (_data26_);
	_data26_ = NULL;
	return result;
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		ContactsEditorPropertyRow* self;
		self = _data27_->self;
		_g_object_unref0 (_data27_->row);
		_g_object_unref0 (_data27_->details_set);
		_g_object_unref0 (_data27_->details);
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}

static void
__lambda26_ (Block27Data* _data27_,
             GObject* obj,
             GParamSpec* pspec)
{
	ContactsEditorPropertyRow* self;
	ContactsTypeDescriptor* descr = NULL;
	ContactsTypeDescriptor* _tmp0_;
	ContactsTypeDescriptor* _tmp1_;
	self = _data27_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = contacts_typecombo_row_get_selected_descriptor (_data27_->row);
	_tmp1_ = _tmp0_;
	descr = _tmp1_;
	contacts_typedescriptor_save_to_field_details (descr, _data27_->details);
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_data27_->details_set, CONTACTS_TYPE_FAKE_HASH_SET, ContactsFakeHashSet), "changed");
	g_debug ("contacts-editor-property.vala:382: Property phone changed");
}

static void
___lambda26__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda26_ (self, _sender, pspec);
}

void
contacts_editor_property_row_add_type_combo (ContactsEditorPropertyRow* self,
                                             GeeSet* details_set,
                                             ContactsTypeSet* combo_type,
                                             FolksAbstractFieldDetails* details)
{
	Block27Data* _data27_;
	GeeSet* _tmp0_;
	FolksAbstractFieldDetails* _tmp1_;
	ContactsTypeComboRow* _tmp2_;
	GtkListBox* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details_set != NULL);
	g_return_if_fail (combo_type != NULL);
	g_return_if_fail (details != NULL);
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (details_set);
	_g_object_unref0 (_data27_->details_set);
	_data27_->details_set = _tmp0_;
	_tmp1_ = _g_object_ref0 (details);
	_g_object_unref0 (_data27_->details);
	_data27_->details = _tmp1_;
	_tmp2_ = contacts_typecombo_row_new (combo_type);
	g_object_ref_sink (_tmp2_);
	_data27_->row = _tmp2_;
	adw_preferences_row_set_title ((AdwPreferencesRow*) _data27_->row, _ ("Label"));
	contacts_typecombo_row_set_selected_from_field_details (_data27_->row, _data27_->details);
	_tmp3_ = self->priv->listbox;
	gtk_list_box_append (_tmp3_, (GtkWidget*) _data27_->row);
	g_signal_connect_data ((GObject*) _data27_->row, "notify::selected-item", (GCallback) ___lambda26__g_object_notify, block27_data_ref (_data27_), (GClosureNotify) block27_data_unref, 0);
	block27_data_unref (_data27_);
	_data27_ = NULL;
}

gboolean
contacts_editor_property_row_get_is_empty (ContactsEditorPropertyRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_empty;
	return result;
}

void
contacts_editor_property_row_set_is_empty (ContactsEditorPropertyRow* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_editor_property_row_get_is_empty (self);
	if (old_value != value) {
		self->priv->_is_empty = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_editor_property_row_properties[CONTACTS_EDITOR_PROPERTY_ROW_IS_EMPTY_PROPERTY]);
	}
}

gboolean
contacts_editor_property_row_get_is_removed (ContactsEditorPropertyRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_removed;
	return result;
}

void
contacts_editor_property_row_set_is_removed (ContactsEditorPropertyRow* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_editor_property_row_get_is_removed (self);
	if (old_value != value) {
		self->priv->_is_removed = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_editor_property_row_properties[CONTACTS_EDITOR_PROPERTY_ROW_IS_REMOVED_PROPERTY]);
	}
}

gboolean
contacts_editor_property_row_get_removable (ContactsEditorPropertyRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_removable;
	return result;
}

void
contacts_editor_property_row_set_removable (ContactsEditorPropertyRow* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_editor_property_row_get_removable (self);
	if (old_value != value) {
		self->priv->_removable = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_editor_property_row_properties[CONTACTS_EDITOR_PROPERTY_ROW_REMOVABLE_PROPERTY]);
	}
}

const gchar*
contacts_editor_property_row_get_ptype (ContactsEditorPropertyRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ptype;
	result = _tmp0_;
	return result;
}

static void
contacts_editor_property_row_set_ptype (ContactsEditorPropertyRow* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_editor_property_row_get_ptype (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_ptype);
		self->priv->_ptype = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_editor_property_row_properties[CONTACTS_EDITOR_PROPERTY_ROW_PTYPE_PROPERTY]);
	}
}

static GObject *
contacts_editor_property_row_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsEditorPropertyRow * self;
	GtkRevealer* _revealer = NULL;
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	GtkRevealer* _tmp2_;
	GtkRevealer* _tmp3_;
	GtkListBox* list_box = NULL;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkRevealer* _tmp10_;
	GtkListBox* _tmp11_;
	parent_class = G_OBJECT_CLASS (contacts_editor_property_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_EDITOR_PROPERTY_ROW, ContactsEditorPropertyRow);
	_tmp0_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp0_);
	_revealer = _tmp0_;
	_tmp1_ = _revealer;
	g_object_bind_property_with_closures ((GObject*) _tmp1_, "reveal-child", (GObject*) self, "is-removed", G_BINDING_BIDIRECTIONAL | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp2_ = _revealer;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = _revealer;
	self->priv->revealer = _tmp3_;
	_tmp4_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp4_);
	list_box = _tmp4_;
	_tmp5_ = list_box;
	self->priv->listbox = _tmp5_;
	_tmp6_ = self->priv->listbox;
	gtk_list_box_set_selection_mode (_tmp6_, GTK_SELECTION_NONE);
	_tmp7_ = self->priv->listbox;
	gtk_list_box_set_activate_on_single_click (_tmp7_, TRUE);
	_tmp8_ = self->priv->listbox;
	gtk_widget_add_css_class ((GtkWidget*) _tmp8_, "boxed-list");
	_tmp9_ = self->priv->listbox;
	gtk_widget_add_css_class ((GtkWidget*) _tmp9_, "contacts-editor-property");
	_tmp10_ = self->priv->revealer;
	_tmp11_ = self->priv->listbox;
	gtk_revealer_set_child (_tmp10_, (GtkWidget*) _tmp11_);
	_g_object_unref0 (list_box);
	_g_object_unref0 (_revealer);
	return obj;
}

static void
contacts_editor_property_row_class_init (ContactsEditorPropertyRowClass * klass,
                                         gpointer klass_data)
{
	contacts_editor_property_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsEditorPropertyRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_editor_property_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_editor_property_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_editor_property_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_editor_property_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_EDITOR_PROPERTY_ROW_IS_EMPTY_PROPERTY, contacts_editor_property_row_properties[CONTACTS_EDITOR_PROPERTY_ROW_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_EDITOR_PROPERTY_ROW_IS_REMOVED_PROPERTY, contacts_editor_property_row_properties[CONTACTS_EDITOR_PROPERTY_ROW_IS_REMOVED_PROPERTY] = g_param_spec_boolean ("is-removed", "is-removed", "is-removed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_EDITOR_PROPERTY_ROW_REMOVABLE_PROPERTY, contacts_editor_property_row_properties[CONTACTS_EDITOR_PROPERTY_ROW_REMOVABLE_PROPERTY] = g_param_spec_boolean ("removable", "removable", "removable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Internal type name of the property */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_EDITOR_PROPERTY_ROW_PTYPE_PROPERTY, contacts_editor_property_row_properties[CONTACTS_EDITOR_PROPERTY_ROW_PTYPE_PROPERTY] = g_param_spec_string ("ptype", "ptype", "ptype", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
contacts_editor_property_row_instance_init (ContactsEditorPropertyRow * self,
                                            gpointer klass)
{
	self->priv = contacts_editor_property_row_get_instance_private (self);
	self->priv->_is_empty = TRUE;
	self->priv->_is_removed = FALSE;
	self->priv->_removable = FALSE;
}

static void
contacts_editor_property_row_finalize (GObject * obj)
{
	ContactsEditorPropertyRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_EDITOR_PROPERTY_ROW, ContactsEditorPropertyRow);
	_g_free0 (self->priv->_ptype);
	G_OBJECT_CLASS (contacts_editor_property_row_parent_class)->finalize (obj);
}

/**
 * Basic widget to show a single property of a contact (for example an email
 * address, a birthday, ...). It can show itself using a GtkRevealer animation.
 *
 * To edit the value of the property, you should supply a widget and set it as
 * the main widget.
 */
 G_GNUC_NO_INLINE static GType
contacts_editor_property_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsEditorPropertyRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_editor_property_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsEditorPropertyRow), 0, (GInstanceInitFunc) contacts_editor_property_row_instance_init, NULL };
	GType contacts_editor_property_row_type_id;
	contacts_editor_property_row_type_id = g_type_register_static (adw_bin_get_type (), "ContactsEditorPropertyRow", &g_define_type_info, 0);
	ContactsEditorPropertyRow_private_offset = g_type_add_instance_private (contacts_editor_property_row_type_id, sizeof (ContactsEditorPropertyRowPrivate));
	return contacts_editor_property_row_type_id;
}

GType
contacts_editor_property_row_get_type (void)
{
	static volatile gsize contacts_editor_property_row_type_id__once = 0;
	if (g_once_init_enter (&contacts_editor_property_row_type_id__once)) {
		GType contacts_editor_property_row_type_id;
		contacts_editor_property_row_type_id = contacts_editor_property_row_get_type_once ();
		g_once_init_leave (&contacts_editor_property_row_type_id__once, contacts_editor_property_row_type_id);
	}
	return contacts_editor_property_row_type_id__once;
}

static void
_vala_contacts_editor_property_row_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	ContactsEditorPropertyRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_EDITOR_PROPERTY_ROW, ContactsEditorPropertyRow);
	switch (property_id) {
		case CONTACTS_EDITOR_PROPERTY_ROW_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, contacts_editor_property_row_get_is_empty (self));
		break;
		case CONTACTS_EDITOR_PROPERTY_ROW_IS_REMOVED_PROPERTY:
		g_value_set_boolean (value, contacts_editor_property_row_get_is_removed (self));
		break;
		case CONTACTS_EDITOR_PROPERTY_ROW_REMOVABLE_PROPERTY:
		g_value_set_boolean (value, contacts_editor_property_row_get_removable (self));
		break;
		case CONTACTS_EDITOR_PROPERTY_ROW_PTYPE_PROPERTY:
		g_value_set_string (value, contacts_editor_property_row_get_ptype (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_editor_property_row_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	ContactsEditorPropertyRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_EDITOR_PROPERTY_ROW, ContactsEditorPropertyRow);
	switch (property_id) {
		case CONTACTS_EDITOR_PROPERTY_ROW_IS_EMPTY_PROPERTY:
		contacts_editor_property_row_set_is_empty (self, g_value_get_boolean (value));
		break;
		case CONTACTS_EDITOR_PROPERTY_ROW_IS_REMOVED_PROPERTY:
		contacts_editor_property_row_set_is_removed (self, g_value_get_boolean (value));
		break;
		case CONTACTS_EDITOR_PROPERTY_ROW_REMOVABLE_PROPERTY:
		contacts_editor_property_row_set_removable (self, g_value_get_boolean (value));
		break;
		case CONTACTS_EDITOR_PROPERTY_ROW_PTYPE_PROPERTY:
		contacts_editor_property_row_set_ptype (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_editor_property_get_instance_private (ContactsEditorProperty* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsEditorProperty_private_offset);
}

ContactsEditorProperty*
contacts_editor_property_construct (GType object_type,
                                    FolksPersona* persona,
                                    const gchar* property_name,
                                    gboolean only_new)
{
	ContactsEditorProperty * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (persona != NULL, NULL);
	g_return_val_if_fail (property_name != NULL, NULL);
	self = (ContactsEditorProperty*) g_object_new (object_type, NULL);
	_tmp0_ = folks_persona_get_writeable_properties (persona, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp2_;
		s_collection_length1 = _tmp2__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				const gchar* _tmp3_;
				_tmp3_ = s;
				if (g_strcmp0 (_tmp3_, property_name) == 0) {
					contacts_editor_property_set_writeable (self, TRUE);
					break;
				}
			}
		}
	}
	contacts_editor_property_create_for_property (self, persona, property_name, only_new);
	return self;
}

ContactsEditorProperty*
contacts_editor_property_new (FolksPersona* persona,
                              const gchar* property_name,
                              gboolean only_new)
{
	return contacts_editor_property_construct (CONTACTS_TYPE_EDITOR_PROPERTY, persona, property_name, only_new);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static GObject*
contacts_editor_property_real_get_item (GListModel* base,
                                        guint i)
{
	ContactsEditorProperty * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	gconstpointer _tmp4_;
	GObject* _tmp5_;
	GObject* result;
	self = (ContactsEditorProperty*) base;
	_tmp0_ = self->priv->rows;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (i > ((guint) _tmp2_)) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->rows;
	_tmp4_ = g_ptr_array_index (_tmp3_, i);
	_tmp5_ = _g_object_ref0 ((GObject*) ((ContactsEditorPropertyRow*) _tmp4_));
	result = _tmp5_;
	return result;
}

static guint
contacts_editor_property_real_get_n_items (GListModel* base)
{
	ContactsEditorProperty * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
	self = (ContactsEditorProperty*) base;
	_tmp0_ = self->priv->rows;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

static GType
contacts_editor_property_real_get_item_type (GListModel* base)
{
	ContactsEditorProperty * self;
	GType result;
	self = (ContactsEditorProperty*) base;
	result = CONTACTS_TYPE_EDITOR_PROPERTY_ROW;
	return result;
}

static void
contacts_editor_property_create_for_property (ContactsEditorProperty* self,
                                              FolksPersona* p,
                                              const gchar* prop_name,
                                              gboolean only_new)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("email-addresses")))) {
		switch (0) {
			default:
			{
				FolksEmailDetails* details = NULL;
				FolksEmailDetails* _tmp3_;
				details = G_TYPE_CHECK_INSTANCE_TYPE (p, FOLKS_TYPE_EMAIL_DETAILS) ? ((FolksEmailDetails*) p) : NULL;
				_tmp3_ = details;
				if (_tmp3_ != NULL) {
					GeeList* emails = NULL;
					FolksEmailDetails* _tmp4_;
					GeeSet* _tmp5_;
					GeeSet* _tmp6_;
					GeeList* _tmp7_;
					gboolean _tmp22_;
					_tmp4_ = details;
					_tmp5_ = folks_email_details_get_email_addresses (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp7_ = contacts_utils_sort_fields (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeCollection*) _tmp6_);
					emails = _tmp7_;
					if (!only_new) {
						{
							GeeList* _email_list = NULL;
							GeeList* _tmp8_;
							gint _email_size = 0;
							GeeList* _tmp9_;
							gint _tmp10_;
							gint _tmp11_;
							gint _email_index = 0;
							_tmp8_ = emails;
							_email_list = _tmp8_;
							_tmp9_ = _email_list;
							_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
							_tmp11_ = _tmp10_;
							_email_size = _tmp11_;
							_email_index = -1;
							while (TRUE) {
								gint _tmp12_;
								gint _tmp13_;
								FolksEmailFieldDetails* email = NULL;
								GeeList* _tmp14_;
								gpointer _tmp15_;
								GPtrArray* _tmp16_;
								FolksEmailDetails* _tmp17_;
								GeeSet* _tmp18_;
								GeeSet* _tmp19_;
								FolksEmailFieldDetails* _tmp20_;
								ContactsEditorPropertyRow* _tmp21_;
								_email_index = _email_index + 1;
								_tmp12_ = _email_index;
								_tmp13_ = _email_size;
								if (!(_tmp12_ < _tmp13_)) {
									break;
								}
								_tmp14_ = _email_list;
								_tmp15_ = gee_list_get (_tmp14_, _email_index);
								email = (FolksEmailFieldDetails*) _tmp15_;
								_tmp16_ = self->priv->rows;
								_tmp17_ = details;
								_tmp18_ = folks_email_details_get_email_addresses (_tmp17_);
								_tmp19_ = _tmp18_;
								_tmp20_ = email;
								_tmp21_ = contacts_editor_property_create_for_email (self, _tmp19_, _tmp20_);
								g_ptr_array_add (_tmp16_, _tmp21_);
								_g_object_unref0 (email);
							}
						}
					}
					_tmp22_ = self->priv->_writeable;
					if (_tmp22_) {
						GPtrArray* _tmp23_;
						FolksEmailDetails* _tmp24_;
						GeeSet* _tmp25_;
						GeeSet* _tmp26_;
						ContactsEditorPropertyRow* _tmp27_;
						_tmp23_ = self->priv->rows;
						_tmp24_ = details;
						_tmp25_ = folks_email_details_get_email_addresses (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = contacts_editor_property_create_for_email (self, _tmp26_, NULL);
						g_ptr_array_add (_tmp23_, _tmp27_);
					}
					_g_object_unref0 (emails);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("phone-numbers")))) {
		switch (0) {
			default:
			{
				FolksPhoneDetails* details = NULL;
				FolksPhoneDetails* _tmp28_;
				details = G_TYPE_CHECK_INSTANCE_TYPE (p, FOLKS_TYPE_PHONE_DETAILS) ? ((FolksPhoneDetails*) p) : NULL;
				_tmp28_ = details;
				if (_tmp28_ != NULL) {
					GeeList* phones = NULL;
					FolksPhoneDetails* _tmp29_;
					GeeSet* _tmp30_;
					GeeSet* _tmp31_;
					GeeList* _tmp32_;
					gboolean _tmp47_;
					_tmp29_ = details;
					_tmp30_ = folks_phone_details_get_phone_numbers (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = contacts_utils_sort_fields (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeCollection*) _tmp31_);
					phones = _tmp32_;
					if (!only_new) {
						{
							GeeList* _phone_list = NULL;
							GeeList* _tmp33_;
							gint _phone_size = 0;
							GeeList* _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							gint _phone_index = 0;
							_tmp33_ = phones;
							_phone_list = _tmp33_;
							_tmp34_ = _phone_list;
							_tmp35_ = gee_collection_get_size ((GeeCollection*) _tmp34_);
							_tmp36_ = _tmp35_;
							_phone_size = _tmp36_;
							_phone_index = -1;
							while (TRUE) {
								gint _tmp37_;
								gint _tmp38_;
								FolksPhoneFieldDetails* phone = NULL;
								GeeList* _tmp39_;
								gpointer _tmp40_;
								GPtrArray* _tmp41_;
								FolksPhoneDetails* _tmp42_;
								GeeSet* _tmp43_;
								GeeSet* _tmp44_;
								FolksPhoneFieldDetails* _tmp45_;
								ContactsEditorPropertyRow* _tmp46_;
								_phone_index = _phone_index + 1;
								_tmp37_ = _phone_index;
								_tmp38_ = _phone_size;
								if (!(_tmp37_ < _tmp38_)) {
									break;
								}
								_tmp39_ = _phone_list;
								_tmp40_ = gee_list_get (_tmp39_, _phone_index);
								phone = (FolksPhoneFieldDetails*) _tmp40_;
								_tmp41_ = self->priv->rows;
								_tmp42_ = details;
								_tmp43_ = folks_phone_details_get_phone_numbers (_tmp42_);
								_tmp44_ = _tmp43_;
								_tmp45_ = phone;
								_tmp46_ = contacts_editor_property_create_for_phone (self, _tmp44_, _tmp45_);
								g_ptr_array_add (_tmp41_, _tmp46_);
								_g_object_unref0 (phone);
							}
						}
					}
					_tmp47_ = self->priv->_writeable;
					if (_tmp47_) {
						GPtrArray* _tmp48_;
						FolksPhoneDetails* _tmp49_;
						GeeSet* _tmp50_;
						GeeSet* _tmp51_;
						ContactsEditorPropertyRow* _tmp52_;
						_tmp48_ = self->priv->rows;
						_tmp49_ = details;
						_tmp50_ = folks_phone_details_get_phone_numbers (_tmp49_);
						_tmp51_ = _tmp50_;
						_tmp52_ = contacts_editor_property_create_for_phone (self, _tmp51_, NULL);
						g_ptr_array_add (_tmp48_, _tmp52_);
					}
					_g_object_unref0 (phones);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("urls")))) {
		switch (0) {
			default:
			{
				FolksUrlDetails* details = NULL;
				FolksUrlDetails* _tmp53_;
				details = G_TYPE_CHECK_INSTANCE_TYPE (p, FOLKS_TYPE_URL_DETAILS) ? ((FolksUrlDetails*) p) : NULL;
				_tmp53_ = details;
				if (_tmp53_ != NULL) {
					GeeList* urls = NULL;
					FolksUrlDetails* _tmp54_;
					GeeSet* _tmp55_;
					GeeSet* _tmp56_;
					GeeList* _tmp57_;
					GPtrArray* _tmp72_;
					FolksUrlDetails* _tmp73_;
					GeeSet* _tmp74_;
					GeeSet* _tmp75_;
					ContactsEditorPropertyRow* _tmp76_;
					_tmp54_ = details;
					_tmp55_ = folks_url_details_get_urls (_tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = contacts_utils_sort_fields (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeCollection*) _tmp56_);
					urls = _tmp57_;
					if (!only_new) {
						{
							GeeList* _url_list = NULL;
							GeeList* _tmp58_;
							gint _url_size = 0;
							GeeList* _tmp59_;
							gint _tmp60_;
							gint _tmp61_;
							gint _url_index = 0;
							_tmp58_ = urls;
							_url_list = _tmp58_;
							_tmp59_ = _url_list;
							_tmp60_ = gee_collection_get_size ((GeeCollection*) _tmp59_);
							_tmp61_ = _tmp60_;
							_url_size = _tmp61_;
							_url_index = -1;
							while (TRUE) {
								gint _tmp62_;
								gint _tmp63_;
								FolksUrlFieldDetails* url = NULL;
								GeeList* _tmp64_;
								gpointer _tmp65_;
								GPtrArray* _tmp66_;
								FolksUrlDetails* _tmp67_;
								GeeSet* _tmp68_;
								GeeSet* _tmp69_;
								FolksUrlFieldDetails* _tmp70_;
								ContactsEditorPropertyRow* _tmp71_;
								_url_index = _url_index + 1;
								_tmp62_ = _url_index;
								_tmp63_ = _url_size;
								if (!(_tmp62_ < _tmp63_)) {
									break;
								}
								_tmp64_ = _url_list;
								_tmp65_ = gee_list_get (_tmp64_, _url_index);
								url = (FolksUrlFieldDetails*) _tmp65_;
								_tmp66_ = self->priv->rows;
								_tmp67_ = details;
								_tmp68_ = folks_url_details_get_urls (_tmp67_);
								_tmp69_ = _tmp68_;
								_tmp70_ = url;
								_tmp71_ = contacts_editor_property_create_for_url (self, _tmp69_, _tmp70_);
								g_ptr_array_add (_tmp66_, _tmp71_);
								_g_object_unref0 (url);
							}
						}
					}
					_tmp72_ = self->priv->rows;
					_tmp73_ = details;
					_tmp74_ = folks_url_details_get_urls (_tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = contacts_editor_property_create_for_url (self, _tmp75_, NULL);
					g_ptr_array_add (_tmp72_, _tmp76_);
					_g_object_unref0 (urls);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("nickname")))) {
		switch (0) {
			default:
			{
				FolksNameDetails* name_details = NULL;
				gboolean _tmp77_ = FALSE;
				gboolean _tmp78_ = FALSE;
				FolksNameDetails* _tmp79_;
				name_details = G_TYPE_CHECK_INSTANCE_TYPE (p, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) p) : NULL;
				_tmp79_ = name_details;
				if (_tmp79_ != NULL) {
					FolksNameDetails* _tmp80_;
					const gchar* _tmp81_;
					const gchar* _tmp82_;
					_tmp80_ = name_details;
					_tmp81_ = folks_name_details_get_nickname (_tmp80_);
					_tmp82_ = _tmp81_;
					_tmp78_ = _tmp82_ != NULL;
				} else {
					_tmp78_ = FALSE;
				}
				if (_tmp78_) {
					_tmp77_ = !only_new;
				} else {
					_tmp77_ = FALSE;
				}
				if (_tmp77_) {
					GPtrArray* _tmp83_;
					FolksNameDetails* _tmp84_;
					ContactsEditorPropertyRow* _tmp85_;
					_tmp83_ = self->priv->rows;
					_tmp84_ = name_details;
					_tmp85_ = contacts_editor_property_create_for_nick (self, _tmp84_);
					g_ptr_array_add (_tmp83_, _tmp85_);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("birthday")))) {
		switch (0) {
			default:
			{
				FolksBirthdayDetails* birthday_details = NULL;
				gboolean _tmp86_ = FALSE;
				FolksBirthdayDetails* _tmp87_;
				birthday_details = G_TYPE_CHECK_INSTANCE_TYPE (p, FOLKS_TYPE_BIRTHDAY_DETAILS) ? ((FolksBirthdayDetails*) p) : NULL;
				_tmp87_ = birthday_details;
				if (_tmp87_ != NULL) {
					_tmp86_ = !only_new;
				} else {
					_tmp86_ = FALSE;
				}
				if (_tmp86_) {
					GPtrArray* _tmp88_;
					FolksBirthdayDetails* _tmp89_;
					ContactsEditorPropertyRow* _tmp90_;
					_tmp88_ = self->priv->rows;
					_tmp89_ = birthday_details;
					_tmp90_ = contacts_editor_property_create_for_birthday (self, _tmp89_);
					g_ptr_array_add (_tmp88_, _tmp90_);
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("notes")))) {
		switch (0) {
			default:
			{
				FolksNoteDetails* note_details = NULL;
				FolksNoteDetails* _tmp91_;
				note_details = G_TYPE_CHECK_INSTANCE_TYPE (p, FOLKS_TYPE_NOTE_DETAILS) ? ((FolksNoteDetails*) p) : NULL;
				_tmp91_ = note_details;
				if (_tmp91_ != NULL) {
					gboolean _tmp105_;
					if (!only_new) {
						{
							GeeIterator* _note_it = NULL;
							FolksNoteDetails* _tmp92_;
							GeeSet* _tmp93_;
							GeeSet* _tmp94_;
							GeeIterator* _tmp95_;
							_tmp92_ = note_details;
							_tmp93_ = folks_note_details_get_notes (_tmp92_);
							_tmp94_ = _tmp93_;
							_tmp95_ = gee_iterable_iterator ((GeeIterable*) _tmp94_);
							_note_it = _tmp95_;
							while (TRUE) {
								GeeIterator* _tmp96_;
								FolksNoteFieldDetails* note = NULL;
								GeeIterator* _tmp97_;
								gpointer _tmp98_;
								GPtrArray* _tmp99_;
								FolksNoteDetails* _tmp100_;
								GeeSet* _tmp101_;
								GeeSet* _tmp102_;
								FolksNoteFieldDetails* _tmp103_;
								ContactsEditorPropertyRow* _tmp104_;
								_tmp96_ = _note_it;
								if (!gee_iterator_next (_tmp96_)) {
									break;
								}
								_tmp97_ = _note_it;
								_tmp98_ = gee_iterator_get (_tmp97_);
								note = (FolksNoteFieldDetails*) _tmp98_;
								_tmp99_ = self->priv->rows;
								_tmp100_ = note_details;
								_tmp101_ = folks_note_details_get_notes (_tmp100_);
								_tmp102_ = _tmp101_;
								_tmp103_ = note;
								_tmp104_ = contacts_editor_property_create_for_note (self, _tmp102_, _tmp103_);
								g_ptr_array_add (_tmp99_, _tmp104_);
								_g_object_unref0 (note);
							}
							_g_object_unref0 (_note_it);
						}
					}
					_tmp105_ = self->priv->_writeable;
					if (_tmp105_) {
						GPtrArray* _tmp106_;
						FolksNoteDetails* _tmp107_;
						GeeSet* _tmp108_;
						GeeSet* _tmp109_;
						ContactsEditorPropertyRow* _tmp110_;
						_tmp106_ = self->priv->rows;
						_tmp107_ = note_details;
						_tmp108_ = folks_note_details_get_notes (_tmp107_);
						_tmp109_ = _tmp108_;
						_tmp110_ = contacts_editor_property_create_for_note (self, _tmp109_, NULL);
						g_ptr_array_add (_tmp106_, _tmp110_);
					}
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("postal-addresses")))) {
		switch (0) {
			default:
			{
				FolksPostalAddressDetails* address_details = NULL;
				FolksPostalAddressDetails* _tmp111_;
				address_details = G_TYPE_CHECK_INSTANCE_TYPE (p, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS) ? ((FolksPostalAddressDetails*) p) : NULL;
				_tmp111_ = address_details;
				if (_tmp111_ != NULL) {
					gboolean _tmp125_;
					if (!only_new) {
						{
							GeeIterator* _addr_it = NULL;
							FolksPostalAddressDetails* _tmp112_;
							GeeSet* _tmp113_;
							GeeSet* _tmp114_;
							GeeIterator* _tmp115_;
							_tmp112_ = address_details;
							_tmp113_ = folks_postal_address_details_get_postal_addresses (_tmp112_);
							_tmp114_ = _tmp113_;
							_tmp115_ = gee_iterable_iterator ((GeeIterable*) _tmp114_);
							_addr_it = _tmp115_;
							while (TRUE) {
								GeeIterator* _tmp116_;
								FolksPostalAddressFieldDetails* addr = NULL;
								GeeIterator* _tmp117_;
								gpointer _tmp118_;
								GPtrArray* _tmp119_;
								FolksPostalAddressDetails* _tmp120_;
								GeeSet* _tmp121_;
								GeeSet* _tmp122_;
								FolksPostalAddressFieldDetails* _tmp123_;
								ContactsEditorPropertyRow* _tmp124_;
								_tmp116_ = _addr_it;
								if (!gee_iterator_next (_tmp116_)) {
									break;
								}
								_tmp117_ = _addr_it;
								_tmp118_ = gee_iterator_get (_tmp117_);
								addr = (FolksPostalAddressFieldDetails*) _tmp118_;
								_tmp119_ = self->priv->rows;
								_tmp120_ = address_details;
								_tmp121_ = folks_postal_address_details_get_postal_addresses (_tmp120_);
								_tmp122_ = _tmp121_;
								_tmp123_ = addr;
								_tmp124_ = contacts_editor_property_create_for_address (self, _tmp122_, _tmp123_);
								g_ptr_array_add (_tmp119_, _tmp124_);
								_g_object_unref0 (addr);
							}
							_g_object_unref0 (_addr_it);
						}
					}
					_tmp125_ = self->priv->_writeable;
					if (_tmp125_) {
						GPtrArray* _tmp126_;
						FolksPostalAddressDetails* _tmp127_;
						GeeSet* _tmp128_;
						GeeSet* _tmp129_;
						ContactsEditorPropertyRow* _tmp130_;
						_tmp126_ = self->priv->rows;
						_tmp127_ = address_details;
						_tmp128_ = folks_postal_address_details_get_postal_addresses (_tmp127_);
						_tmp129_ = _tmp128_;
						_tmp130_ = contacts_editor_property_create_for_address (self, _tmp129_, NULL);
						g_ptr_array_add (_tmp126_, _tmp130_);
					}
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("roles")))) {
		switch (0) {
			default:
			{
				FolksRoleDetails* role_details = NULL;
				FolksRoleDetails* _tmp131_;
				role_details = G_TYPE_CHECK_INSTANCE_TYPE (p, FOLKS_TYPE_ROLE_DETAILS) ? ((FolksRoleDetails*) p) : NULL;
				_tmp131_ = role_details;
				if (_tmp131_ != NULL) {
					gboolean _tmp145_;
					if (!only_new) {
						{
							GeeIterator* _role_it = NULL;
							FolksRoleDetails* _tmp132_;
							GeeSet* _tmp133_;
							GeeSet* _tmp134_;
							GeeIterator* _tmp135_;
							_tmp132_ = role_details;
							_tmp133_ = folks_role_details_get_roles (_tmp132_);
							_tmp134_ = _tmp133_;
							_tmp135_ = gee_iterable_iterator ((GeeIterable*) _tmp134_);
							_role_it = _tmp135_;
							while (TRUE) {
								GeeIterator* _tmp136_;
								FolksRoleFieldDetails* role = NULL;
								GeeIterator* _tmp137_;
								gpointer _tmp138_;
								GPtrArray* _tmp139_;
								FolksRoleDetails* _tmp140_;
								GeeSet* _tmp141_;
								GeeSet* _tmp142_;
								FolksRoleFieldDetails* _tmp143_;
								ContactsEditorPropertyRow* _tmp144_;
								_tmp136_ = _role_it;
								if (!gee_iterator_next (_tmp136_)) {
									break;
								}
								_tmp137_ = _role_it;
								_tmp138_ = gee_iterator_get (_tmp137_);
								role = (FolksRoleFieldDetails*) _tmp138_;
								_tmp139_ = self->priv->rows;
								_tmp140_ = role_details;
								_tmp141_ = folks_role_details_get_roles (_tmp140_);
								_tmp142_ = _tmp141_;
								_tmp143_ = role;
								_tmp144_ = contacts_editor_property_create_for_role (self, _tmp142_, _tmp143_);
								g_ptr_array_add (_tmp139_, _tmp144_);
								_g_object_unref0 (role);
							}
							_g_object_unref0 (_role_it);
						}
					}
					_tmp145_ = self->priv->_writeable;
					if (_tmp145_) {
						GPtrArray* _tmp146_;
						FolksRoleDetails* _tmp147_;
						GeeSet* _tmp148_;
						GeeSet* _tmp149_;
						ContactsEditorPropertyRow* _tmp150_;
						_tmp146_ = self->priv->rows;
						_tmp147_ = role_details;
						_tmp148_ = folks_role_details_get_roles (_tmp147_);
						_tmp149_ = _tmp148_;
						_tmp150_ = contacts_editor_property_create_for_role (self, _tmp149_, NULL);
						g_ptr_array_add (_tmp146_, _tmp150_);
					}
				}
				break;
			}
		}
	}
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		ContactsEditorProperty* self;
		self = _data28_->self;
		_g_object_unref0 (_data28_->entry);
		_g_object_unref0 (_data28_->details_set);
		_g_object_unref0 (_data28_->details);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}

static void
__lambda27_ (Block28Data* _data28_)
{
	ContactsEditorProperty* self;
	const gchar* _tmp0_;
	self = _data28_->self;
	_tmp0_ = gtk_editable_get_text ((GtkEditable*) _data28_->entry);
	folks_abstract_field_details_set_value ((FolksAbstractFieldDetails*) _data28_->details, _tmp0_);
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_data28_->details_set, CONTACTS_TYPE_FAKE_HASH_SET, ContactsFakeHashSet), "changed");
	g_debug ("contacts-editor-property.vala:535: Property email changed");
}

static void
___lambda27__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda27_ (self);
}

static ContactsEditorPropertyRow*
contacts_editor_property_create_for_email (ContactsEditorProperty* self,
                                           GeeSet* details_set,
                                           FolksEmailFieldDetails* details)
{
	Block28Data* _data28_;
	GeeSet* _tmp0_;
	FolksEmailFieldDetails* _tmp1_;
	ContactsEditorPropertyRow* box = NULL;
	ContactsEditorPropertyRow* _tmp9_;
	gboolean _tmp10_;
	gconstpointer _tmp11_;
	gconstpointer _tmp12_;
	GtkEntry* _tmp13_;
	ContactsTypeSet* _tmp14_;
	ContactsTypeSet* _tmp15_;
	ContactsEditorPropertyRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (details_set != NULL, NULL);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (details_set);
	_g_object_unref0 (_data28_->details_set);
	_data28_->details_set = _tmp0_;
	_tmp1_ = _g_object_ref0 (details);
	_g_object_unref0 (_data28_->details);
	_data28_->details = _tmp1_;
	if (_data28_->details == NULL) {
		GeeHashMultiMap* parameters = NULL;
		GeeHashMultiMap* _tmp2_;
		GeeHashMultiMap* _tmp3_;
		FolksEmailFieldDetails* new_details = NULL;
		GeeHashMultiMap* _tmp4_;
		FolksEmailFieldDetails* _tmp5_;
		FolksEmailFieldDetails* _tmp6_;
		FolksEmailFieldDetails* _tmp7_;
		FolksEmailFieldDetails* _tmp8_;
		_tmp2_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		parameters = _tmp2_;
		_tmp3_ = parameters;
		gee_multi_map_set ((GeeMultiMap*) _tmp3_, "type", "PERSONAL");
		_tmp4_ = parameters;
		_tmp5_ = folks_email_field_details_new ("", (GeeMultiMap*) _tmp4_);
		new_details = _tmp5_;
		_tmp6_ = new_details;
		gee_collection_add ((GeeCollection*) _data28_->details_set, (FolksAbstractFieldDetails*) _tmp6_);
		_tmp7_ = new_details;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (_data28_->details);
		_data28_->details = _tmp8_;
		_g_object_unref0 (new_details);
		_g_object_unref0 (parameters);
	}
	_tmp9_ = contacts_editor_property_row_new ("email-addresses");
	g_object_ref_sink (_tmp9_);
	box = _tmp9_;
	_tmp10_ = self->priv->_writeable;
	gtk_widget_set_sensitive ((GtkWidget*) box, _tmp10_);
	_tmp11_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _data28_->details);
	_tmp12_ = _tmp11_;
	_tmp13_ = contacts_editor_property_row_set_main_entry (box, (const gchar*) _tmp12_, _ ("Add email"));
	_data28_->entry = _tmp13_;
	gtk_entry_set_input_purpose (_data28_->entry, GTK_INPUT_PURPOSE_EMAIL);
	g_signal_connect_data ((GtkEditable*) _data28_->entry, "changed", (GCallback) ___lambda27__gtk_editable_changed, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
	_tmp14_ = contacts_typeset_get_email ();
	_tmp15_ = _tmp14_;
	contacts_editor_property_row_add_type_combo (box, _data28_->details_set, _tmp15_, (FolksAbstractFieldDetails*) _data28_->details);
	result = box;
	block28_data_unref (_data28_);
	_data28_ = NULL;
	return result;
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		ContactsEditorProperty* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->entry);
		_g_object_unref0 (_data29_->details_set);
		_g_object_unref0 (_data29_->details);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static void
__lambda28_ (Block29Data* _data29_)
{
	ContactsEditorProperty* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = _data29_->self;
	_tmp0_ = gtk_editable_get_text ((GtkEditable*) _data29_->entry);
	_tmp1_ = _tmp0_;
	folks_abstract_field_details_set_value ((FolksAbstractFieldDetails*) _data29_->details, _tmp1_);
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_data29_->details_set, CONTACTS_TYPE_FAKE_HASH_SET, ContactsFakeHashSet), "changed");
	g_debug ("contacts-editor-property.vala:562: Property type changed");
}

static void
___lambda28__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda28_ (self);
}

static ContactsEditorPropertyRow*
contacts_editor_property_create_for_phone (ContactsEditorProperty* self,
                                           GeeSet* details_set,
                                           FolksPhoneFieldDetails* details)
{
	Block29Data* _data29_;
	GeeSet* _tmp0_;
	FolksPhoneFieldDetails* _tmp1_;
	ContactsEditorPropertyRow* box = NULL;
	ContactsEditorPropertyRow* _tmp9_;
	gboolean _tmp10_;
	gconstpointer _tmp11_;
	gconstpointer _tmp12_;
	GtkEntry* _tmp13_;
	ContactsTypeSet* _tmp14_;
	ContactsTypeSet* _tmp15_;
	ContactsEditorPropertyRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (details_set != NULL, NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (details_set);
	_g_object_unref0 (_data29_->details_set);
	_data29_->details_set = _tmp0_;
	_tmp1_ = _g_object_ref0 (details);
	_g_object_unref0 (_data29_->details);
	_data29_->details = _tmp1_;
	if (_data29_->details == NULL) {
		GeeHashMultiMap* parameters = NULL;
		GeeHashMultiMap* _tmp2_;
		GeeHashMultiMap* _tmp3_;
		FolksPhoneFieldDetails* new_details = NULL;
		GeeHashMultiMap* _tmp4_;
		FolksPhoneFieldDetails* _tmp5_;
		FolksPhoneFieldDetails* _tmp6_;
		FolksPhoneFieldDetails* _tmp7_;
		FolksPhoneFieldDetails* _tmp8_;
		_tmp2_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		parameters = _tmp2_;
		_tmp3_ = parameters;
		gee_multi_map_set ((GeeMultiMap*) _tmp3_, "type", "CELL");
		_tmp4_ = parameters;
		_tmp5_ = folks_phone_field_details_new ("", (GeeMultiMap*) _tmp4_);
		new_details = _tmp5_;
		_tmp6_ = new_details;
		gee_collection_add ((GeeCollection*) _data29_->details_set, (FolksAbstractFieldDetails*) _tmp6_);
		_tmp7_ = new_details;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (_data29_->details);
		_data29_->details = _tmp8_;
		_g_object_unref0 (new_details);
		_g_object_unref0 (parameters);
	}
	_tmp9_ = contacts_editor_property_row_new ("phone-numbers");
	g_object_ref_sink (_tmp9_);
	box = _tmp9_;
	_tmp10_ = self->priv->_writeable;
	gtk_widget_set_sensitive ((GtkWidget*) box, _tmp10_);
	_tmp11_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _data29_->details);
	_tmp12_ = _tmp11_;
	_tmp13_ = contacts_editor_property_row_set_main_entry (box, (const gchar*) _tmp12_, _ ("Add phone number"));
	_data29_->entry = _tmp13_;
	gtk_entry_set_input_purpose (_data29_->entry, GTK_INPUT_PURPOSE_PHONE);
	g_signal_connect_data ((GtkEditable*) _data29_->entry, "changed", (GCallback) ___lambda28__gtk_editable_changed, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	_tmp14_ = contacts_typeset_get_phone ();
	_tmp15_ = _tmp14_;
	contacts_editor_property_row_add_type_combo (box, _data29_->details_set, _tmp15_, (FolksAbstractFieldDetails*) _data29_->details);
	result = box;
	block29_data_unref (_data29_);
	_data29_ = NULL;
	return result;
}

static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		ContactsEditorProperty* self;
		self = _data30_->self;
		_g_object_unref0 (_data30_->entry);
		_g_object_unref0 (_data30_->details_set);
		_g_object_unref0 (_data30_->details);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}

static void
__lambda29_ (Block30Data* _data30_)
{
	ContactsEditorProperty* self;
	const gchar* _tmp0_;
	self = _data30_->self;
	_tmp0_ = gtk_editable_get_text ((GtkEditable*) _data30_->entry);
	folks_abstract_field_details_set_value ((FolksAbstractFieldDetails*) _data30_->details, _tmp0_);
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_data30_->details_set, CONTACTS_TYPE_FAKE_HASH_SET, ContactsFakeHashSet), "changed");
	g_debug ("contacts-editor-property.vala:590: Property type changed");
}

static void
___lambda29__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda29_ (self);
}

static ContactsEditorPropertyRow*
contacts_editor_property_create_for_url (ContactsEditorProperty* self,
                                         GeeSet* details_set,
                                         FolksUrlFieldDetails* details)
{
	Block30Data* _data30_;
	GeeSet* _tmp0_;
	FolksUrlFieldDetails* _tmp1_;
	ContactsEditorPropertyRow* box = NULL;
	ContactsEditorPropertyRow* _tmp9_;
	gboolean _tmp10_;
	gconstpointer _tmp11_;
	gconstpointer _tmp12_;
	GtkEntry* _tmp13_;
	ContactsEditorPropertyRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (details_set != NULL, NULL);
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_data30_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (details_set);
	_g_object_unref0 (_data30_->details_set);
	_data30_->details_set = _tmp0_;
	_tmp1_ = _g_object_ref0 (details);
	_g_object_unref0 (_data30_->details);
	_data30_->details = _tmp1_;
	if (_data30_->details == NULL) {
		GeeHashMultiMap* parameters = NULL;
		GeeHashMultiMap* _tmp2_;
		GeeHashMultiMap* _tmp3_;
		FolksUrlFieldDetails* new_details = NULL;
		GeeHashMultiMap* _tmp4_;
		FolksUrlFieldDetails* _tmp5_;
		FolksUrlFieldDetails* _tmp6_;
		FolksUrlFieldDetails* _tmp7_;
		FolksUrlFieldDetails* _tmp8_;
		_tmp2_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		parameters = _tmp2_;
		_tmp3_ = parameters;
		gee_multi_map_set ((GeeMultiMap*) _tmp3_, "type", "PERSONAL");
		_tmp4_ = parameters;
		_tmp5_ = folks_url_field_details_new ("", (GeeMultiMap*) _tmp4_);
		new_details = _tmp5_;
		_tmp6_ = new_details;
		gee_collection_add ((GeeCollection*) _data30_->details_set, (FolksAbstractFieldDetails*) _tmp6_);
		_tmp7_ = new_details;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (_data30_->details);
		_data30_->details = _tmp8_;
		_g_object_unref0 (new_details);
		_g_object_unref0 (parameters);
	}
	_tmp9_ = contacts_editor_property_row_new ("urls");
	g_object_ref_sink (_tmp9_);
	box = _tmp9_;
	_tmp10_ = self->priv->_writeable;
	gtk_widget_set_sensitive ((GtkWidget*) box, _tmp10_);
	_tmp11_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _data30_->details);
	_tmp12_ = _tmp11_;
	_tmp13_ = contacts_editor_property_row_set_main_entry (box, (const gchar*) _tmp12_, _ ("https://example.com"));
	_data30_->entry = _tmp13_;
	gtk_entry_set_input_purpose (_data30_->entry, GTK_INPUT_PURPOSE_URL);
	g_signal_connect_data ((GtkEditable*) _data30_->entry, "changed", (GCallback) ___lambda29__gtk_editable_changed, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
	result = box;
	block30_data_unref (_data30_);
	_data30_ = NULL;
	return result;
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		ContactsEditorProperty* self;
		self = _data31_->self;
		_g_object_unref0 (_data31_->entry);
		_g_object_unref0 (_data31_->details);
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}

static void
__lambda30_ (Block31Data* _data31_)
{
	ContactsEditorProperty* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = _data31_->self;
	_tmp0_ = gtk_editable_get_text ((GtkEditable*) _data31_->entry);
	_tmp1_ = _tmp0_;
	folks_name_details_set_nickname (_data31_->details, _tmp1_);
	g_debug ("contacts-editor-property.vala:604: Nickname changed");
}

static void
___lambda30__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda30_ (self);
}

static ContactsEditorPropertyRow*
contacts_editor_property_create_for_nick (ContactsEditorProperty* self,
                                          FolksNameDetails* details)
{
	Block31Data* _data31_;
	FolksNameDetails* _tmp0_;
	ContactsEditorPropertyRow* box = NULL;
	ContactsEditorPropertyRow* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkEntry* _tmp5_;
	ContactsEditorPropertyRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (details != NULL, NULL);
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (details);
	_g_object_unref0 (_data31_->details);
	_data31_->details = _tmp0_;
	_tmp1_ = contacts_editor_property_row_new ("nickname");
	g_object_ref_sink (_tmp1_);
	box = _tmp1_;
	_tmp2_ = self->priv->_writeable;
	gtk_widget_set_sensitive ((GtkWidget*) box, _tmp2_);
	_tmp3_ = folks_name_details_get_nickname (_data31_->details);
	_tmp4_ = _tmp3_;
	_tmp5_ = contacts_editor_property_row_set_main_entry (box, _tmp4_, _ ("Nickname"));
	_data31_->entry = _tmp5_;
	gtk_entry_set_input_purpose (_data31_->entry, GTK_INPUT_PURPOSE_NAME);
	g_signal_connect_data ((GtkEditable*) _data31_->entry, "changed", (GCallback) ___lambda30__gtk_editable_changed, block31_data_ref (_data31_), (GClosureNotify) block31_data_unref, 0);
	result = box;
	block31_data_unref (_data31_);
	_data31_ = NULL;
	return result;
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		ContactsEditorProperty* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->textview);
		_g_object_unref0 (_data32_->box);
		_g_object_unref0 (_data32_->details_set);
		_g_object_unref0 (_data32_->details);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static void
__lambda37_ (Block32Data* _data32_)
{
	ContactsEditorProperty* self;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextBuffer* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	GtkTextBuffer* _tmp4_;
	GtkTextIter _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gconstpointer _tmp9_;
	gconstpointer _tmp10_;
	self = _data32_->self;
	_tmp0_ = gtk_text_view_get_buffer (_data32_->textview);
	gtk_text_buffer_get_start_iter (_tmp0_, &_tmp1_);
	start = _tmp1_;
	_tmp2_ = gtk_text_view_get_buffer (_data32_->textview);
	gtk_text_buffer_get_end_iter (_tmp2_, &_tmp3_);
	end = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer (_data32_->textview);
	_tmp5_ = start;
	_tmp6_ = end;
	_tmp7_ = gtk_text_buffer_get_text (_tmp4_, &_tmp5_, &_tmp6_, TRUE);
	_tmp8_ = _tmp7_;
	folks_abstract_field_details_set_value ((FolksAbstractFieldDetails*) _data32_->details, _tmp8_);
	_g_free0 (_tmp8_);
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_data32_->details_set, CONTACTS_TYPE_FAKE_HASH_SET, ContactsFakeHashSet), "changed");
	g_debug ("contacts-editor-property.vala:640: Property changed");
	_tmp9_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _data32_->details);
	_tmp10_ = _tmp9_;
	contacts_editor_property_row_set_is_empty (_data32_->box, g_strcmp0 ((const gchar*) _tmp10_, "") == 0);
}

static void
___lambda37__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                      gpointer self)
{
	__lambda37_ (self);
}

static ContactsEditorPropertyRow*
contacts_editor_property_create_for_note (ContactsEditorProperty* self,
                                          GeeSet* details_set,
                                          FolksNoteFieldDetails* details)
{
	Block32Data* _data32_;
	GeeSet* _tmp0_;
	FolksNoteFieldDetails* _tmp1_;
	ContactsEditorPropertyRow* _tmp9_;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp10_;
	GtkTextView* _tmp11_;
	GtkTextBuffer* _tmp12_;
	gconstpointer _tmp13_;
	gconstpointer _tmp14_;
	GtkTextBuffer* _tmp15_;
	gboolean _tmp16_;
	ContactsEditorPropertyRow* _tmp17_;
	ContactsEditorPropertyRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (details_set != NULL, NULL);
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (details_set);
	_g_object_unref0 (_data32_->details_set);
	_data32_->details_set = _tmp0_;
	_tmp1_ = _g_object_ref0 (details);
	_g_object_unref0 (_data32_->details);
	_data32_->details = _tmp1_;
	if (_data32_->details == NULL) {
		GeeHashMultiMap* parameters = NULL;
		GeeHashMultiMap* _tmp2_;
		GeeHashMultiMap* _tmp3_;
		FolksNoteFieldDetails* new_details = NULL;
		GeeHashMultiMap* _tmp4_;
		FolksNoteFieldDetails* _tmp5_;
		FolksNoteFieldDetails* _tmp6_;
		FolksNoteFieldDetails* _tmp7_;
		FolksNoteFieldDetails* _tmp8_;
		_tmp2_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		parameters = _tmp2_;
		_tmp3_ = parameters;
		gee_multi_map_set ((GeeMultiMap*) _tmp3_, "type", "PERSONAL");
		_tmp4_ = parameters;
		_tmp5_ = folks_note_field_details_new ("", (GeeMultiMap*) _tmp4_, NULL);
		new_details = _tmp5_;
		_tmp6_ = new_details;
		gee_collection_add ((GeeCollection*) _data32_->details_set, _tmp6_);
		_tmp7_ = new_details;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (_data32_->details);
		_data32_->details = _tmp8_;
		_g_object_unref0 (new_details);
		_g_object_unref0 (parameters);
	}
	_tmp9_ = contacts_editor_property_row_new ("notes");
	g_object_ref_sink (_tmp9_);
	_data32_->box = _tmp9_;
	_tmp10_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp10_);
	sw = _tmp10_;
	gtk_widget_set_focusable ((GtkWidget*) sw, FALSE);
	gtk_scrolled_window_set_has_frame (sw, FALSE);
	gtk_widget_set_size_request ((GtkWidget*) sw, -1, 100);
	contacts_editor_property_row_set_main_widget (_data32_->box, (GtkWidget*) sw, TRUE);
	_tmp11_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp11_);
	_data32_->textview = _tmp11_;
	_tmp12_ = gtk_text_view_get_buffer (_data32_->textview);
	_tmp13_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _data32_->details);
	_tmp14_ = _tmp13_;
	gtk_text_buffer_set_text (_tmp12_, (const gchar*) _tmp14_, -1);
	gtk_widget_set_hexpand ((GtkWidget*) _data32_->textview, TRUE);
	gtk_scrolled_window_set_child (sw, (GtkWidget*) _data32_->textview);
	_tmp15_ = gtk_text_view_get_buffer (_data32_->textview);
	g_signal_connect_data (_tmp15_, "changed", (GCallback) ___lambda37__gtk_text_buffer_changed, block32_data_ref (_data32_), (GClosureNotify) block32_data_unref, 0);
	_tmp16_ = self->priv->_writeable;
	gtk_widget_set_sensitive ((GtkWidget*) _data32_->box, _tmp16_);
	_tmp17_ = _g_object_ref0 (_data32_->box);
	result = _tmp17_;
	_g_object_unref0 (sw);
	block32_data_unref (_data32_);
	_data32_ = NULL;
	return result;
}

static Block33Data*
block33_data_ref (Block33Data* _data33_)
{
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}

static void
block33_data_unref (void * _userdata_)
{
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		ContactsEditorProperty* self;
		self = _data33_->self;
		_g_object_unref0 (_data33_->box);
		_g_object_unref0 (_data33_->button);
		_g_date_time_unref0 (_data33_->date);
		_g_object_unref0 (_data33_->details);
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static Block34Data*
block34_data_ref (Block34Data* _data34_)
{
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}

static void
block34_data_unref (void * _userdata_)
{
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		ContactsEditorProperty* self;
		self = _data34_->_data33_->self;
		_g_object_unref0 (_data34_->dialog);
		block33_data_unref (_data34_->_data33_);
		_data34_->_data33_ = NULL;
		g_slice_free (Block34Data, _data34_);
	}
}

static void
___lambda35_ (Block34Data* _data34_)
{
	Block33Data* _data33_;
	ContactsEditorProperty* self;
	ContactsBirthdayEditor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_data33_ = _data34_->_data33_;
	self = _data33_->self;
	_tmp0_ = _data34_->dialog;
	_tmp1_ = contacts_birthday_editor_get_is_set (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ContactsBirthdayEditor* _tmp3_;
		GDateTime* _tmp4_;
		GDateTime* _tmp5_;
		GtkButton* _tmp6_;
		GDateTime* _tmp7_;
		GDateTime* _tmp8_;
		GDateTime* _tmp9_;
		GDateTime* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp3_ = _data34_->dialog;
		_tmp4_ = contacts_birthday_editor_get_birthday (_tmp3_);
		_tmp5_ = _tmp4_;
		folks_birthday_details_set_birthday (_data33_->details, _tmp5_);
		_g_date_time_unref0 (_tmp5_);
		_tmp6_ = _data33_->button;
		_tmp7_ = folks_birthday_details_get_birthday (_data33_->details);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_date_time_to_local (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_date_time_format (_tmp10_, "%x");
		_tmp12_ = _tmp11_;
		gtk_button_set_label (_tmp6_, _tmp12_);
		_g_free0 (_tmp12_);
		_g_date_time_unref0 (_tmp10_);
		contacts_editor_property_row_set_is_empty (_data33_->box, FALSE);
	}
}

static void
____lambda35__contacts_birthday_editor_changed (ContactsBirthdayEditor* _sender,
                                                gpointer self)
{
	___lambda35_ (self);
}

static void
__lambda31_ (Block33Data* _data33_)
{
	ContactsEditorProperty* self;
	GtkWindow* parent_window = NULL;
	GtkButton* _tmp0_;
	GtkRoot* _tmp1_;
	GtkWindow* _tmp2_;
	self = _data33_->self;
	_tmp0_ = _data33_->button;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) _tmp0_);
	parent_window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL;
	_tmp2_ = parent_window;
	if (_tmp2_ != NULL) {
		Block34Data* _data34_;
		GtkWindow* _tmp3_;
		GDateTime* _tmp4_;
		ContactsBirthdayEditor* _tmp5_;
		ContactsBirthdayEditor* _tmp6_;
		ContactsBirthdayEditor* _tmp7_;
		_data34_ = g_slice_new0 (Block34Data);
		_data34_->_ref_count_ = 1;
		_data34_->_data33_ = block33_data_ref (_data33_);
		_tmp3_ = parent_window;
		_tmp4_ = _data33_->date;
		_tmp5_ = contacts_birthday_editor_new (_tmp3_, _tmp4_);
		g_object_ref_sink (_tmp5_);
		_data34_->dialog = _tmp5_;
		_tmp6_ = _data34_->dialog;
		g_signal_connect_data (_tmp6_, "changed", (GCallback) ____lambda35__contacts_birthday_editor_changed, block34_data_ref (_data34_), (GClosureNotify) block34_data_unref, 0);
		_tmp7_ = _data34_->dialog;
		gtk_widget_show ((GtkWidget*) _tmp7_);
		block34_data_unref (_data34_);
		_data34_ = NULL;
	}
}

static void
___lambda31__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda31_ (self);
}

static void
__lambda36_ (Block33Data* _data33_)
{
	ContactsEditorProperty* self;
	GtkButton* _tmp0_;
	self = _data33_->self;
	g_debug ("contacts-editor-property.vala:686: Birthday removed");
	folks_birthday_details_set_birthday (_data33_->details, NULL);
	contacts_editor_property_row_set_is_empty (_data33_->box, TRUE);
	_tmp0_ = _data33_->button;
	gtk_button_set_label (_tmp0_, _ ("Set Birthday"));
}

static void
___lambda36__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda36_ (self);
}

static ContactsEditorPropertyRow*
contacts_editor_property_create_for_birthday (ContactsEditorProperty* self,
                                              FolksBirthdayDetails* details)
{
	Block33Data* _data33_;
	FolksBirthdayDetails* _tmp0_;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	ContactsEditorPropertyRow* _tmp19_;
	GtkButton* _tmp20_;
	GtkButton* _tmp21_;
	GDateTime* _tmp22_;
	GDateTime* _tmp23_;
	GtkButton* delete_button = NULL;
	GtkButton* _tmp24_;
	gboolean _tmp25_;
	ContactsEditorPropertyRow* _tmp26_;
	ContactsEditorPropertyRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data33_ = g_slice_new0 (Block33Data);
	_data33_->_ref_count_ = 1;
	_data33_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (details);
	_g_object_unref0 (_data33_->details);
	_data33_->details = _tmp0_;
	_tmp2_ = folks_birthday_details_get_birthday (_data33_->details);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	_tmp1_ = _tmp4_;
	if (_tmp1_ == NULL) {
		GTimeZone* _tmp5_;
		GTimeZone* _tmp6_;
		GDateTime* _tmp7_;
		_tmp5_ = g_time_zone_new_local ();
		_tmp6_ = _tmp5_;
		_tmp7_ = g_date_time_new_now (_tmp6_);
		_g_date_time_unref0 (_tmp1_);
		_tmp1_ = _tmp7_;
		_g_time_zone_unref0 (_tmp6_);
	}
	_tmp8_ = _tmp1_;
	_tmp1_ = NULL;
	_data33_->date = _tmp8_;
	_tmp9_ = folks_birthday_details_get_birthday (_data33_->details);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == NULL) {
		GtkButton* _tmp11_;
		_tmp11_ = (GtkButton*) gtk_button_new_with_label (_ ("Set Birthday"));
		g_object_ref_sink (_tmp11_);
		_g_object_unref0 (_data33_->button);
		_data33_->button = _tmp11_;
	} else {
		GDateTime* _tmp12_;
		GDateTime* _tmp13_;
		GDateTime* _tmp14_;
		GDateTime* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GtkButton* _tmp18_;
		_tmp12_ = folks_birthday_details_get_birthday (_data33_->details);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_date_time_to_local (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_date_time_format (_tmp15_, "%x");
		_tmp17_ = _tmp16_;
		_tmp18_ = (GtkButton*) gtk_button_new_with_label (_tmp17_);
		g_object_ref_sink (_tmp18_);
		_g_object_unref0 (_data33_->button);
		_data33_->button = _tmp18_;
		_g_free0 (_tmp17_);
		_g_date_time_unref0 (_tmp15_);
	}
	_tmp19_ = contacts_editor_property_row_new ("birthday");
	g_object_ref_sink (_tmp19_);
	_data33_->box = _tmp19_;
	_tmp20_ = _data33_->button;
	contacts_editor_property_row_set_main_widget (_data33_->box, (GtkWidget*) _tmp20_, TRUE);
	_tmp21_ = _data33_->button;
	g_signal_connect_data (_tmp21_, "clicked", (GCallback) ___lambda31__gtk_button_clicked, block33_data_ref (_data33_), (GClosureNotify) block33_data_unref, 0);
	_tmp22_ = folks_birthday_details_get_birthday (_data33_->details);
	_tmp23_ = _tmp22_;
	contacts_editor_property_row_set_is_empty (_data33_->box, _tmp23_ == NULL);
	_tmp24_ = (GtkButton*) gtk_button_new_from_icon_name ("user-trash-symbolic");
	g_object_ref_sink (_tmp24_);
	delete_button = _tmp24_;
	gtk_widget_set_tooltip_text ((GtkWidget*) delete_button, _ ("Delete field"));
	gtk_widget_set_valign ((GtkWidget*) delete_button, GTK_ALIGN_START);
	g_object_bind_property_with_closures ((GObject*) _data33_->box, "is-empty", (GObject*) delete_button, "sensitive", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data (delete_button, "clicked", (GCallback) ___lambda36__gtk_button_clicked, block33_data_ref (_data33_), (GClosureNotify) block33_data_unref, 0);
	_tmp25_ = self->priv->_writeable;
	gtk_widget_set_sensitive ((GtkWidget*) _data33_->box, _tmp25_);
	_tmp26_ = _g_object_ref0 (_data33_->box);
	result = _tmp26_;
	_g_object_unref0 (delete_button);
	_g_date_time_unref0 (_tmp1_);
	block33_data_unref (_data33_);
	_data33_ = NULL;
	return result;
}

static Block35Data*
block35_data_ref (Block35Data* _data35_)
{
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}

static void
block35_data_unref (void * _userdata_)
{
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		ContactsEditorProperty* self;
		self = _data35_->self;
		_g_object_unref0 (_data35_->value_address);
		_g_object_unref0 (_data35_->box);
		_g_object_unref0 (_data35_->details_set);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}

static void
__lambda39_ (Block35Data* _data35_)
{
	ContactsEditorProperty* self;
	self = _data35_->self;
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_data35_->details_set, CONTACTS_TYPE_FAKE_HASH_SET, ContactsFakeHashSet), "changed");
	g_debug ("contacts-editor-property.vala:717: Address changed");
	contacts_editor_property_row_set_is_empty (_data35_->box, contacts_address_editor_is_empty (_data35_->value_address));
}

static void
___lambda39__contacts_address_editor_changed (ContactsAddressEditor* _sender,
                                              gpointer self)
{
	__lambda39_ (self);
}

static ContactsEditorPropertyRow*
contacts_editor_property_create_for_address (ContactsEditorProperty* self,
                                             GeeSet* details_set,
                                             FolksPostalAddressFieldDetails* details)
{
	Block35Data* _data35_;
	GeeSet* _tmp0_;
	ContactsEditorPropertyRow* _tmp9_;
	ContactsAddressEditor* _tmp10_;
	ContactsTypeSet* _tmp11_;
	ContactsTypeSet* _tmp12_;
	gboolean _tmp13_;
	ContactsEditorPropertyRow* _tmp14_;
	ContactsEditorPropertyRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (details_set != NULL, NULL);
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_data35_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (details_set);
	_g_object_unref0 (_data35_->details_set);
	_data35_->details_set = _tmp0_;
	if (details == NULL) {
		GeeHashMultiMap* parameters = NULL;
		GeeHashMultiMap* _tmp1_;
		GeeHashMultiMap* _tmp2_;
		FolksPostalAddress* address = NULL;
		FolksPostalAddress* _tmp3_;
		FolksPostalAddressFieldDetails* new_details = NULL;
		FolksPostalAddress* _tmp4_;
		GeeHashMultiMap* _tmp5_;
		FolksPostalAddressFieldDetails* _tmp6_;
		FolksPostalAddressFieldDetails* _tmp7_;
		FolksPostalAddressFieldDetails* _tmp8_;
		_tmp1_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		parameters = _tmp1_;
		_tmp2_ = parameters;
		gee_multi_map_set ((GeeMultiMap*) _tmp2_, "type", "HOME");
		_tmp3_ = folks_postal_address_new (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		address = _tmp3_;
		_tmp4_ = address;
		_tmp5_ = parameters;
		_tmp6_ = folks_postal_address_field_details_new (_tmp4_, (GeeMultiMap*) _tmp5_);
		new_details = _tmp6_;
		_tmp7_ = new_details;
		gee_collection_add ((GeeCollection*) _data35_->details_set, _tmp7_);
		_tmp8_ = new_details;
		details = _tmp8_;
		_g_object_unref0 (new_details);
		_g_object_unref0 (address);
		_g_object_unref0 (parameters);
	}
	_tmp9_ = contacts_editor_property_row_new ("postal-addresses");
	g_object_ref_sink (_tmp9_);
	_data35_->box = _tmp9_;
	_tmp10_ = contacts_address_editor_new (details);
	g_object_ref_sink (_tmp10_);
	_data35_->value_address = _tmp10_;
	contacts_editor_property_row_set_main_widget (_data35_->box, (GtkWidget*) _data35_->value_address, TRUE);
	contacts_editor_property_row_set_is_empty (_data35_->box, contacts_address_editor_is_empty (_data35_->value_address));
	_tmp11_ = contacts_typeset_get_general ();
	_tmp12_ = _tmp11_;
	contacts_editor_property_row_add_type_combo (_data35_->box, _data35_->details_set, _tmp12_, (FolksAbstractFieldDetails*) details);
	g_signal_connect_data (_data35_->value_address, "changed", (GCallback) ___lambda39__contacts_address_editor_changed, block35_data_ref (_data35_), (GClosureNotify) block35_data_unref, 0);
	_tmp13_ = self->priv->_writeable;
	gtk_widget_set_sensitive ((GtkWidget*) _data35_->box, _tmp13_);
	_tmp14_ = _g_object_ref0 (_data35_->box);
	result = _tmp14_;
	block35_data_unref (_data35_);
	_data35_ = NULL;
	return result;
}

static Block36Data*
block36_data_ref (Block36Data* _data36_)
{
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}

static void
block36_data_unref (void * _userdata_)
{
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		ContactsEditorProperty* self;
		self = _data36_->self;
		_g_object_unref0 (_data36_->role_editor);
		_g_object_unref0 (_data36_->box);
		_g_object_unref0 (_data36_->details_set);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}

static void
__lambda42_ (Block36Data* _data36_)
{
	ContactsEditorProperty* self;
	self = _data36_->self;
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_data36_->details_set, CONTACTS_TYPE_FAKE_HASH_SET, ContactsFakeHashSet), "changed");
	g_debug ("contacts-editor-property.vala:741: Role changed");
	contacts_editor_property_row_set_is_empty (_data36_->box, contacts_role_editor_is_empty (_data36_->role_editor));
}

static void
___lambda42__contacts_role_editor_changed (ContactsRoleEditor* _sender,
                                           gpointer self)
{
	__lambda42_ (self);
}

static ContactsEditorPropertyRow*
contacts_editor_property_create_for_role (ContactsEditorProperty* self,
                                          GeeSet* details_set,
                                          FolksRoleFieldDetails* details)
{
	Block36Data* _data36_;
	GeeSet* _tmp0_;
	ContactsEditorPropertyRow* _tmp7_;
	ContactsRoleEditor* _tmp8_;
	gboolean _tmp9_;
	ContactsEditorPropertyRow* _tmp10_;
	ContactsEditorPropertyRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (details_set != NULL, NULL);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (details_set);
	_g_object_unref0 (_data36_->details_set);
	_data36_->details_set = _tmp0_;
	if (details == NULL) {
		FolksRoleFieldDetails* new_details = NULL;
		FolksRole* _tmp1_;
		FolksRole* _tmp2_;
		FolksRoleFieldDetails* _tmp3_;
		FolksRoleFieldDetails* _tmp4_;
		FolksRoleFieldDetails* _tmp5_;
		FolksRoleFieldDetails* _tmp6_;
		_tmp1_ = folks_role_new (NULL, NULL, NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = folks_role_field_details_new (_tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		new_details = _tmp4_;
		_tmp5_ = new_details;
		gee_collection_add ((GeeCollection*) _data36_->details_set, _tmp5_);
		_tmp6_ = new_details;
		details = _tmp6_;
		_g_object_unref0 (new_details);
	}
	_tmp7_ = contacts_editor_property_row_new ("roles");
	g_object_ref_sink (_tmp7_);
	_data36_->box = _tmp7_;
	_tmp8_ = contacts_role_editor_new (details);
	g_object_ref_sink (_tmp8_);
	_data36_->role_editor = _tmp8_;
	contacts_editor_property_row_set_main_widget (_data36_->box, (GtkWidget*) _data36_->role_editor, TRUE);
	contacts_editor_property_row_set_is_empty (_data36_->box, contacts_role_editor_is_empty (_data36_->role_editor));
	g_signal_connect_data (_data36_->role_editor, "changed", (GCallback) ___lambda42__contacts_role_editor_changed, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_tmp9_ = self->priv->_writeable;
	gtk_widget_set_sensitive ((GtkWidget*) _data36_->box, _tmp9_);
	_tmp10_ = _g_object_ref0 (_data36_->box);
	result = _tmp10_;
	block36_data_unref (_data36_);
	_data36_ = NULL;
	return result;
}

gboolean
contacts_editor_property_get_writeable (ContactsEditorProperty* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_writeable;
	return result;
}

static void
contacts_editor_property_set_writeable (ContactsEditorProperty* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_editor_property_get_writeable (self);
	if (old_value != value) {
		self->priv->_writeable = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_editor_property_properties[CONTACTS_EDITOR_PROPERTY_WRITEABLE_PROPERTY]);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GObject *
contacts_editor_property_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsEditorProperty * self;
	GPtrArray* _tmp0_;
	parent_class = G_OBJECT_CLASS (contacts_editor_property_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_EDITOR_PROPERTY, ContactsEditorProperty);
	_tmp0_ = g_ptr_array_new_full ((guint) 1, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->rows);
	self->priv->rows = _tmp0_;
	return obj;
}

static void
contacts_editor_property_class_init (ContactsEditorPropertyClass * klass,
                                     gpointer klass_data)
{
	contacts_editor_property_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsEditorProperty_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_editor_property_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_editor_property_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_editor_property_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_editor_property_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_EDITOR_PROPERTY_WRITEABLE_PROPERTY, contacts_editor_property_properties[CONTACTS_EDITOR_PROPERTY_WRITEABLE_PROPERTY] = g_param_spec_boolean ("writeable", "writeable", "writeable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_editor_property_g_list_model_interface_init (GListModelInterface * iface,
                                                      gpointer iface_data)
{
	contacts_editor_property_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item = (GObject* (*) (GListModel*, guint)) contacts_editor_property_real_get_item;
	iface->get_n_items = (guint (*) (GListModel*)) contacts_editor_property_real_get_n_items;
	iface->get_item_type = (GType (*) (GListModel*)) contacts_editor_property_real_get_item_type;
}

static void
contacts_editor_property_instance_init (ContactsEditorProperty * self,
                                        gpointer klass)
{
	self->priv = contacts_editor_property_get_instance_private (self);
	self->priv->_writeable = FALSE;
}

static void
contacts_editor_property_finalize (GObject * obj)
{
	ContactsEditorProperty * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_EDITOR_PROPERTY, ContactsEditorProperty);
	_g_ptr_array_unref0 (self->priv->rows);
	G_OBJECT_CLASS (contacts_editor_property_parent_class)->finalize (obj);
}

/**
 * A widget representing a property of a persona in the editor {@link Contact}.
 *
 * We can have more then one field in a single property
 * (for example: emails, phone nrs, ...), so it implements a
 * {@link GLib.ListModel}.
 */
 G_GNUC_NO_INLINE static GType
contacts_editor_property_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsEditorPropertyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_editor_property_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsEditorProperty), 0, (GInstanceInitFunc) contacts_editor_property_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) contacts_editor_property_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType contacts_editor_property_type_id;
	contacts_editor_property_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsEditorProperty", &g_define_type_info, 0);
	g_type_add_interface_static (contacts_editor_property_type_id, g_list_model_get_type (), &g_list_model_info);
	ContactsEditorProperty_private_offset = g_type_add_instance_private (contacts_editor_property_type_id, sizeof (ContactsEditorPropertyPrivate));
	return contacts_editor_property_type_id;
}

GType
contacts_editor_property_get_type (void)
{
	static volatile gsize contacts_editor_property_type_id__once = 0;
	if (g_once_init_enter (&contacts_editor_property_type_id__once)) {
		GType contacts_editor_property_type_id;
		contacts_editor_property_type_id = contacts_editor_property_get_type_once ();
		g_once_init_leave (&contacts_editor_property_type_id__once, contacts_editor_property_type_id);
	}
	return contacts_editor_property_type_id__once;
}

static void
_vala_contacts_editor_property_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ContactsEditorProperty * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_EDITOR_PROPERTY, ContactsEditorProperty);
	switch (property_id) {
		case CONTACTS_EDITOR_PROPERTY_WRITEABLE_PROPERTY:
		g_value_set_boolean (value, contacts_editor_property_get_writeable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_editor_property_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	ContactsEditorProperty * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_EDITOR_PROPERTY, ContactsEditorProperty);
	switch (property_id) {
		case CONTACTS_EDITOR_PROPERTY_WRITEABLE_PROPERTY:
		contacts_editor_property_set_writeable (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

