/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-duration.h"
#include "libical-glib-private.h"

G_DEFINE_TYPE (ICalDuration, i_cal_duration, I_CAL_TYPE_OBJECT)

static void i_cal_duration_class_init (G_GNUC_UNUSED ICalDurationClass *klass)
{
}

static void i_cal_duration_init (G_GNUC_UNUSED ICalDuration *self)
{
}

/**
 * i_cal_duration_new_full: (skip)
 * @native: The native libical object.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalDuration *
i_cal_duration_new_full (struct icaldurationtype native)
{
    ICalDuration *object;
    struct icaldurationtype *clone;
    
    
    clone = g_new (struct icaldurationtype, 1);
    *clone = native;
    object = i_cal_object_construct (I_CAL_TYPE_DURATION,
                            (gpointer) clone,
                            (GDestroyNotify) g_free,
                            FALSE,
                            NULL);

    return object;
}


/**
 * i_cal_duration_is_neg:
 * @duration: The #ICalDuration to be queried
 *
 * Gets the is_neg of #ICalDuration.
 *
 * Returns: The is_neg.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_duration_is_neg (ICalDuration *duration)
{
	g_return_val_if_fail (duration != NULL, 0);
	return (((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration))->is_neg) ? TRUE : FALSE;
}

/**
 * i_cal_duration_set_is_neg:
 * @duration: The #ICalDuration to be set
 * @is_neg: The is_neg
 *
 * Sets the is_neg of #ICalDuration.
 *
 * Since: 1.0
 *
 **/
void
i_cal_duration_set_is_neg (ICalDuration *duration, 
                           gboolean is_neg)
{
	g_return_if_fail (duration != NULL && I_CAL_IS_DURATION (duration));
	((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration))->is_neg = is_neg ? 1 : 0;
}

/**
 * i_cal_duration_get_days:
 * @duration: The #ICalDuration to be queried
 *
 * Gets the days of #ICalDuration.
 *
 * Returns: The days.
 *
 * Since: 1.0
 *
 **/
guint
i_cal_duration_get_days (ICalDuration *duration)
{
	g_return_val_if_fail (duration != NULL, 0);
	return ((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration))->days;
}

/**
 * i_cal_duration_set_days:
 * @duration: The #ICalDuration to be set
 * @days: The days
 *
 * Sets the days of #ICalDuration.
 *
 * Since: 1.0
 *
 **/
void
i_cal_duration_set_days (ICalDuration *duration, 
                         guint days)
{
	g_return_if_fail (duration != NULL && I_CAL_IS_DURATION (duration));
	((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration))->days = days;
}

/**
 * i_cal_duration_get_weeks:
 * @duration: The #ICalDuration to be queried
 *
 * Gets the weeks of #ICalDuration.
 *
 * Returns: The weeks.
 *
 * Since: 1.0
 *
 **/
guint
i_cal_duration_get_weeks (ICalDuration *duration)
{
	g_return_val_if_fail (duration != NULL, 0);
	return ((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration))->weeks;
}

/**
 * i_cal_duration_set_weeks:
 * @duration: The #ICalDuration to be set
 * @weeks: The weeks
 *
 * Sets the weeks of #ICalDuration.
 *
 * Since: 1.0
 *
 **/
void
i_cal_duration_set_weeks (ICalDuration *duration, 
                          guint weeks)
{
	g_return_if_fail (duration != NULL && I_CAL_IS_DURATION (duration));
	((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration))->weeks = weeks;
}

/**
 * i_cal_duration_get_hours:
 * @duration: The #ICalDuration to be queried
 *
 * Gets the hours of #ICalDuration.
 *
 * Returns: The hours.
 *
 * Since: 1.0
 *
 **/
guint
i_cal_duration_get_hours (ICalDuration *duration)
{
	g_return_val_if_fail (duration != NULL, 0);
	return ((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration))->hours;
}

/**
 * i_cal_duration_set_hours:
 * @duration: The #ICalDuration to be set
 * @hours: The hours
 *
 * Sets the hours of #ICalDuration.
 *
 * Since: 1.0
 *
 **/
void
i_cal_duration_set_hours (ICalDuration *duration, 
                          guint hours)
{
	g_return_if_fail (duration != NULL && I_CAL_IS_DURATION (duration));
	((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration))->hours = hours;
}

/**
 * i_cal_duration_get_minutes:
 * @duration: The #ICalDuration to be queried
 *
 * Gets the minutes of #ICalDuration.
 *
 * Returns: The minutes.
 *
 * Since: 1.0
 *
 **/
guint
i_cal_duration_get_minutes (ICalDuration *duration)
{
	g_return_val_if_fail (duration != NULL, 0);
	return ((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration))->minutes;
}

/**
 * i_cal_duration_set_minutes:
 * @duration: The #ICalDuration to be set
 * @minutes: The minutes
 *
 * Sets the minutes of #ICalDuration.
 *
 * Since: 1.0
 *
 **/
void
i_cal_duration_set_minutes (ICalDuration *duration, 
                            guint minutes)
{
	g_return_if_fail (duration != NULL && I_CAL_IS_DURATION (duration));
	((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration))->minutes = minutes;
}

/**
 * i_cal_duration_get_seconds:
 * @duration: The #ICalDuration to be queried
 *
 * Gets the seconds of #ICalDuration.
 *
 * Returns: The seconds.
 *
 * Since: 1.0
 *
 **/
guint
i_cal_duration_get_seconds (ICalDuration *duration)
{
	g_return_val_if_fail (duration != NULL, 0);
	return ((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration))->seconds;
}

/**
 * i_cal_duration_set_seconds:
 * @duration: The #ICalDuration to be set
 * @seconds: The seconds
 *
 * Sets the seconds of #ICalDuration.
 *
 * Since: 1.0
 *
 **/
void
i_cal_duration_set_seconds (ICalDuration *duration, 
                            guint seconds)
{
	g_return_if_fail (duration != NULL && I_CAL_IS_DURATION (duration));
	((struct icaldurationtype *)i_cal_object_get_native ((ICalObject *)duration))->seconds = seconds;
}

/**
 * i_cal_duration_new_from_int:
 * @t: The duration in second
 *
 * Creates a #ICalDuration from the duration in second.
 *
 * Returns: (transfer full): The newly created #ICalDuration
 *
 * Since: 1.0
 *
 **/
ICalDuration *
i_cal_duration_new_from_int (gint t)
{
	return i_cal_duration_new_full (icaldurationtype_from_int (t));
}

/**
 * i_cal_duration_new_from_string:
 * @str: The string representation of the duration
 *
 * Creates a #ICalDuration from the duration in string.
 *
 * Returns: (transfer full): The newly created #ICalDuration
 *
 * Since: 1.0
 *
 **/
ICalDuration *
i_cal_duration_new_from_string (const gchar *str)
{
	g_return_val_if_fail (str != NULL, NULL);

	return i_cal_duration_new_full (icaldurationtype_from_string (str));
}

/**
 * i_cal_duration_as_int:
 * @duration: The #ICalDuration to be converted
 *
 * Converts the #ICalDuration to the representation in second.
 *
 * Returns: The duration in second
 *
 * Since: 1.0
 *
 **/
gint
i_cal_duration_as_int (ICalDuration *duration)
{
	g_return_val_if_fail (I_CAL_IS_DURATION (duration), 0);

	return icaldurationtype_as_int (* (struct icaldurationtype *)i_cal_object_get_native (I_CAL_OBJECT (duration)));
}

/**
 * i_cal_duration_as_ical_string:
 * @duration: The #ICalDuration to be converted
 *
 * Converts the #ICalDuration to the representation in string.
 *
 * Returns: (transfer full): The duration in string
 *
 * Since: 1.0
 *
 **/
gchar *
i_cal_duration_as_ical_string (ICalDuration *duration)
{
	g_return_val_if_fail (I_CAL_IS_DURATION (duration), NULL);

	return icaldurationtype_as_ical_string_r (* (struct icaldurationtype *)i_cal_object_get_native (I_CAL_OBJECT (duration)));
}

/**
 * i_cal_duration_new_null_duration:
 *
 * Creates a #ICalDuration with all the fields to be zero.
 *
 * Returns: (transfer full): The newly created #ICalDuration
 *
 * Since: 1.0
 *
 **/
ICalDuration *
i_cal_duration_new_null_duration (void)
{
	return i_cal_duration_new_full (icaldurationtype_null_duration ());
}

/**
 * i_cal_duration_new_bad_duration:
 *
 * Creates a bad #ICalDuration.
 *
 * Returns: (transfer full): The newly created #ICalDuration
 *
 * Since: 1.0
 *
 **/
ICalDuration *
i_cal_duration_new_bad_duration (void)
{
	return i_cal_duration_new_full (icaldurationtype_bad_duration ());
}

/**
 * i_cal_duration_is_null_duration:
 * @duration: The #ICalDuration to be checked
 *
 * Checks whether the #ICalDuration is the null_duration.
 *
 * Returns: 1 if @duration is the null_duration, 0 if not.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_duration_is_null_duration (ICalDuration *duration)
{
	g_return_val_if_fail (I_CAL_IS_DURATION (duration), FALSE);

	return icaldurationtype_is_null_duration (* (struct icaldurationtype *)i_cal_object_get_native (I_CAL_OBJECT (duration)));
}

/**
 * i_cal_duration_is_bad_duration:
 * @duration: The #ICalDuration to be checked
 *
 * Checks whether the #ICalDuration is the bad_duration.
 *
 * Returns: 1 if @duration is the bad_duration, 0 if not.
 *
 * Since: 1.0
 *
 **/
gboolean
i_cal_duration_is_bad_duration (ICalDuration *duration)
{
	g_return_val_if_fail (I_CAL_IS_DURATION (duration), FALSE);

	return icaldurationtype_is_bad_duration (* (struct icaldurationtype *)i_cal_object_get_native (I_CAL_OBJECT (duration)));
}
