/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "DrawingAreaProxy.h"

#include "ArgumentCoders.h"
#include "CallbackID.h"
#include "Decoder.h"
#include "DrawingAreaProxyMessages.h"
#include "HandleMessage.h"
#include "LayerTreeContext.h"
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
#include "UpdateInfo.h"
#endif
#include <wtf/Vector.h>

namespace WebKit {

void DrawingAreaProxy::didReceiveMessage(IPC::Connection& connection, IPC::Decoder& decoder)
{
    if (decoder.messageName() == Messages::DrawingAreaProxy::EnterAcceleratedCompositingMode::name())
        return IPC::handleMessage<Messages::DrawingAreaProxy::EnterAcceleratedCompositingMode>(connection, decoder, this, &DrawingAreaProxy::enterAcceleratedCompositingMode);
    if (decoder.messageName() == Messages::DrawingAreaProxy::UpdateAcceleratedCompositingMode::name())
        return IPC::handleMessage<Messages::DrawingAreaProxy::UpdateAcceleratedCompositingMode>(connection, decoder, this, &DrawingAreaProxy::updateAcceleratedCompositingMode);
    if (decoder.messageName() == Messages::DrawingAreaProxy::DidFirstLayerFlush::name())
        return IPC::handleMessage<Messages::DrawingAreaProxy::DidFirstLayerFlush>(connection, decoder, this, &DrawingAreaProxy::didFirstLayerFlush);
    if (decoder.messageName() == Messages::DrawingAreaProxy::DispatchPresentationCallbacksAfterFlushingLayers::name())
        return IPC::handleMessage<Messages::DrawingAreaProxy::DispatchPresentationCallbacksAfterFlushingLayers>(connection, decoder, this, &DrawingAreaProxy::dispatchPresentationCallbacksAfterFlushingLayers);
#if PLATFORM(COCOA)
    if (decoder.messageName() == Messages::DrawingAreaProxy::DidUpdateGeometry::name())
        return IPC::handleMessage<Messages::DrawingAreaProxy::DidUpdateGeometry>(connection, decoder, this, &DrawingAreaProxy::didUpdateGeometry);
#endif
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
    if (decoder.messageName() == Messages::DrawingAreaProxy::Update::name())
        return IPC::handleMessage<Messages::DrawingAreaProxy::Update>(connection, decoder, this, &DrawingAreaProxy::update);
#endif
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
    if (decoder.messageName() == Messages::DrawingAreaProxy::DidUpdateBackingStoreState::name())
        return IPC::handleMessage<Messages::DrawingAreaProxy::DidUpdateBackingStoreState>(connection, decoder, this, &DrawingAreaProxy::didUpdateBackingStoreState);
#endif
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
    if (decoder.messageName() == Messages::DrawingAreaProxy::ExitAcceleratedCompositingMode::name())
        return IPC::handleMessage<Messages::DrawingAreaProxy::ExitAcceleratedCompositingMode>(connection, decoder, this, &DrawingAreaProxy::exitAcceleratedCompositingMode);
#endif
    UNUSED_PARAM(connection);
    UNUSED_PARAM(decoder);
#if ENABLE(IPC_TESTING_API)
    if (connection.ignoreInvalidMessageForTesting())
        return;
#endif // ENABLE(IPC_TESTING_API)
    ASSERT_NOT_REACHED_WITH_MESSAGE("Unhandled message %s to %" PRIu64, IPC::description(decoder.messageName()), decoder.destinationID());
}

} // namespace WebKit
