/*
 * Copyright (C) 2021 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebIDBServer.h"

#include "ArgumentCoders.h"
#include "Decoder.h"
#include "HandleMessage.h"
#include "WebCoreArgumentCoders.h"
#include "WebIDBServerMessages.h"
#include <WebCore/ClientOrigin.h>
#include <WebCore/IDBCursorInfo.h>
#include <WebCore/IDBGetAllRecordsData.h>
#include <WebCore/IDBGetRecordData.h>
#include <WebCore/IDBIndexInfo.h>
#include <WebCore/IDBIterateCursorData.h>
#include <WebCore/IDBKeyData.h>
#include <WebCore/IDBKeyRangeData.h>
#include <WebCore/IDBObjectStoreInfo.h>
#include <WebCore/IDBRequestData.h>
#include <WebCore/IDBResourceIdentifier.h>
#include <WebCore/IDBTransactionInfo.h>
#include <WebCore/IDBValue.h>
#include <WebCore/IndexedDB.h>
#include <wtf/text/WTFString.h>

namespace WebKit {

void WebIDBServer::didReceiveMessage(IPC::Connection& connection, IPC::Decoder& decoder)
{
    Ref protectedThis { *this };
    if (decoder.messageName() == Messages::WebIDBServer::DeleteDatabase::name())
        return IPC::handleMessage<Messages::WebIDBServer::DeleteDatabase>(connection, decoder, this, &WebIDBServer::deleteDatabase);
    if (decoder.messageName() == Messages::WebIDBServer::OpenDatabase::name())
        return IPC::handleMessage<Messages::WebIDBServer::OpenDatabase>(connection, decoder, this, &WebIDBServer::openDatabase);
    if (decoder.messageName() == Messages::WebIDBServer::AbortTransaction::name())
        return IPC::handleMessage<Messages::WebIDBServer::AbortTransaction>(connection, decoder, this, &WebIDBServer::abortTransaction);
    if (decoder.messageName() == Messages::WebIDBServer::CommitTransaction::name())
        return IPC::handleMessage<Messages::WebIDBServer::CommitTransaction>(connection, decoder, this, &WebIDBServer::commitTransaction);
    if (decoder.messageName() == Messages::WebIDBServer::DidFinishHandlingVersionChangeTransaction::name())
        return IPC::handleMessage<Messages::WebIDBServer::DidFinishHandlingVersionChangeTransaction>(connection, decoder, this, &WebIDBServer::didFinishHandlingVersionChangeTransaction);
    if (decoder.messageName() == Messages::WebIDBServer::CreateObjectStore::name())
        return IPC::handleMessage<Messages::WebIDBServer::CreateObjectStore>(connection, decoder, this, &WebIDBServer::createObjectStore);
    if (decoder.messageName() == Messages::WebIDBServer::DeleteObjectStore::name())
        return IPC::handleMessage<Messages::WebIDBServer::DeleteObjectStore>(connection, decoder, this, &WebIDBServer::deleteObjectStore);
    if (decoder.messageName() == Messages::WebIDBServer::RenameObjectStore::name())
        return IPC::handleMessage<Messages::WebIDBServer::RenameObjectStore>(connection, decoder, this, &WebIDBServer::renameObjectStore);
    if (decoder.messageName() == Messages::WebIDBServer::ClearObjectStore::name())
        return IPC::handleMessage<Messages::WebIDBServer::ClearObjectStore>(connection, decoder, this, &WebIDBServer::clearObjectStore);
    if (decoder.messageName() == Messages::WebIDBServer::CreateIndex::name())
        return IPC::handleMessage<Messages::WebIDBServer::CreateIndex>(connection, decoder, this, &WebIDBServer::createIndex);
    if (decoder.messageName() == Messages::WebIDBServer::DeleteIndex::name())
        return IPC::handleMessage<Messages::WebIDBServer::DeleteIndex>(connection, decoder, this, &WebIDBServer::deleteIndex);
    if (decoder.messageName() == Messages::WebIDBServer::RenameIndex::name())
        return IPC::handleMessage<Messages::WebIDBServer::RenameIndex>(connection, decoder, this, &WebIDBServer::renameIndex);
    if (decoder.messageName() == Messages::WebIDBServer::PutOrAdd::name())
        return IPC::handleMessageWantsConnection<Messages::WebIDBServer::PutOrAdd>(connection, decoder, this, &WebIDBServer::putOrAdd);
    if (decoder.messageName() == Messages::WebIDBServer::GetRecord::name())
        return IPC::handleMessage<Messages::WebIDBServer::GetRecord>(connection, decoder, this, &WebIDBServer::getRecord);
    if (decoder.messageName() == Messages::WebIDBServer::GetAllRecords::name())
        return IPC::handleMessage<Messages::WebIDBServer::GetAllRecords>(connection, decoder, this, &WebIDBServer::getAllRecords);
    if (decoder.messageName() == Messages::WebIDBServer::GetCount::name())
        return IPC::handleMessage<Messages::WebIDBServer::GetCount>(connection, decoder, this, &WebIDBServer::getCount);
    if (decoder.messageName() == Messages::WebIDBServer::DeleteRecord::name())
        return IPC::handleMessage<Messages::WebIDBServer::DeleteRecord>(connection, decoder, this, &WebIDBServer::deleteRecord);
    if (decoder.messageName() == Messages::WebIDBServer::OpenCursor::name())
        return IPC::handleMessage<Messages::WebIDBServer::OpenCursor>(connection, decoder, this, &WebIDBServer::openCursor);
    if (decoder.messageName() == Messages::WebIDBServer::IterateCursor::name())
        return IPC::handleMessage<Messages::WebIDBServer::IterateCursor>(connection, decoder, this, &WebIDBServer::iterateCursor);
    if (decoder.messageName() == Messages::WebIDBServer::EstablishTransaction::name())
        return IPC::handleMessage<Messages::WebIDBServer::EstablishTransaction>(connection, decoder, this, &WebIDBServer::establishTransaction);
    if (decoder.messageName() == Messages::WebIDBServer::DatabaseConnectionPendingClose::name())
        return IPC::handleMessage<Messages::WebIDBServer::DatabaseConnectionPendingClose>(connection, decoder, this, &WebIDBServer::databaseConnectionPendingClose);
    if (decoder.messageName() == Messages::WebIDBServer::DatabaseConnectionClosed::name())
        return IPC::handleMessage<Messages::WebIDBServer::DatabaseConnectionClosed>(connection, decoder, this, &WebIDBServer::databaseConnectionClosed);
    if (decoder.messageName() == Messages::WebIDBServer::AbortOpenAndUpgradeNeeded::name())
        return IPC::handleMessage<Messages::WebIDBServer::AbortOpenAndUpgradeNeeded>(connection, decoder, this, &WebIDBServer::abortOpenAndUpgradeNeeded);
    if (decoder.messageName() == Messages::WebIDBServer::DidFireVersionChangeEvent::name())
        return IPC::handleMessage<Messages::WebIDBServer::DidFireVersionChangeEvent>(connection, decoder, this, &WebIDBServer::didFireVersionChangeEvent);
    if (decoder.messageName() == Messages::WebIDBServer::OpenDBRequestCancelled::name())
        return IPC::handleMessage<Messages::WebIDBServer::OpenDBRequestCancelled>(connection, decoder, this, &WebIDBServer::openDBRequestCancelled);
    if (decoder.messageName() == Messages::WebIDBServer::GetAllDatabaseNamesAndVersions::name())
        return IPC::handleMessageWantsConnection<Messages::WebIDBServer::GetAllDatabaseNamesAndVersions>(connection, decoder, this, &WebIDBServer::getAllDatabaseNamesAndVersions);
    UNUSED_PARAM(connection);
    UNUSED_PARAM(decoder);
#if ENABLE(IPC_TESTING_API)
    if (connection.ignoreInvalidMessageForTesting())
        return;
#endif // ENABLE(IPC_TESTING_API)
    ASSERT_NOT_REACHED_WITH_MESSAGE("Unhandled message %s to %" PRIu64, IPC::description(decoder.messageName()), decoder.destinationID());
}

} // namespace WebKit
