/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "./src/xdp-impl-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Access
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplAccess
 * @title: XdpImplAccess
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Access D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Access ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_access_method_info_access_dialog_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_access_method_info_access_dialog_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_access_method_info_access_dialog_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_access_method_info_access_dialog_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_access_method_info_access_dialog_IN_ARG_subtitle =
{
  {
    -1,
    (gchar *) "subtitle",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_access_method_info_access_dialog_IN_ARG_body =
{
  {
    -1,
    (gchar *) "body",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_access_method_info_access_dialog_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_access_method_info_access_dialog_IN_ARG_pointers[] =
{
  &_xdp_impl_access_method_info_access_dialog_IN_ARG_handle.parent_struct,
  &_xdp_impl_access_method_info_access_dialog_IN_ARG_app_id.parent_struct,
  &_xdp_impl_access_method_info_access_dialog_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_access_method_info_access_dialog_IN_ARG_title.parent_struct,
  &_xdp_impl_access_method_info_access_dialog_IN_ARG_subtitle.parent_struct,
  &_xdp_impl_access_method_info_access_dialog_IN_ARG_body.parent_struct,
  &_xdp_impl_access_method_info_access_dialog_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_access_method_info_access_dialog_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_access_method_info_access_dialog_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_access_method_info_access_dialog_OUT_ARG_pointers[] =
{
  &_xdp_impl_access_method_info_access_dialog_OUT_ARG_response.parent_struct,
  &_xdp_impl_access_method_info_access_dialog_OUT_ARG_results.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_access_method_info_access_dialog =
{
  {
    -1,
    (gchar *) "AccessDialog",
    (GDBusArgInfo **) &_xdp_impl_access_method_info_access_dialog_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_access_method_info_access_dialog_OUT_ARG_pointers,
    NULL
  },
  "handle-access-dialog",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_access_method_info_pointers[] =
{
  &_xdp_impl_access_method_info_access_dialog.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_access_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Access",
    (GDBusMethodInfo **) &_xdp_impl_access_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "access",
};


/**
 * xdp_impl_access_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_access_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_access_interface_info.parent_struct;
}

/**
 * xdp_impl_access_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplAccess interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_access_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpImplAccess:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link>.
 */

/**
 * XdpImplAccessIface:
 * @parent_iface: The parent interface.
 * @handle_access_dialog: Handler for the #XdpImplAccess::handle-access-dialog signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link>.
 */

typedef XdpImplAccessIface XdpImplAccessInterface;
G_DEFINE_INTERFACE (XdpImplAccess, xdp_impl_access, G_TYPE_OBJECT)

static void
xdp_impl_access_default_init (XdpImplAccessIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplAccess::handle-access-dialog:
   * @object: A #XdpImplAccess.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_subtitle: Argument passed by remote caller.
   * @arg_body: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Access.AccessDialog">AccessDialog()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_access_complete_access_dialog() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-access-dialog",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplAccessIface, handle_access_dialog),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    8,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_impl_access_call_access_dialog:
 * @proxy: A #XdpImplAccessProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_subtitle: Argument to pass with the method invocation.
 * @arg_body: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Access.AccessDialog">AccessDialog()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_access_call_access_dialog_finish() to get the result of the operation.
 *
 * See xdp_impl_access_call_access_dialog_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_access_call_access_dialog (
    XdpImplAccess *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    const gchar *arg_subtitle,
    const gchar *arg_body,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AccessDialog",
    g_variant_new ("(osssss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_subtitle,
                   arg_body,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_access_call_access_dialog_finish:
 * @proxy: A #XdpImplAccessProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_access_call_access_dialog().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_access_call_access_dialog().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_access_call_access_dialog_finish (
    XdpImplAccess *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_access_call_access_dialog_sync:
 * @proxy: A #XdpImplAccessProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_subtitle: Argument to pass with the method invocation.
 * @arg_body: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Access.AccessDialog">AccessDialog()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_access_call_access_dialog() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_access_call_access_dialog_sync (
    XdpImplAccess *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    const gchar *arg_subtitle,
    const gchar *arg_body,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AccessDialog",
    g_variant_new ("(osssss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_subtitle,
                   arg_body,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_access_complete_access_dialog:
 * @object: A #XdpImplAccess.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Access.AccessDialog">AccessDialog()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_access_complete_access_dialog (
    XdpImplAccess *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplAccessProxy:
 *
 * The #XdpImplAccessProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplAccessProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplAccessProxy.
 */

struct _XdpImplAccessProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_access_proxy_iface_init (XdpImplAccessIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplAccessProxy, xdp_impl_access_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplAccessProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_ACCESS, xdp_impl_access_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplAccessProxy, xdp_impl_access_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_ACCESS, xdp_impl_access_proxy_iface_init))

#endif
static void
xdp_impl_access_proxy_finalize (GObject *object)
{
  XdpImplAccessProxy *proxy = XDP_IMPL_ACCESS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_access_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_access_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_access_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_access_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_access_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_ACCESS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_ACCESS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_access_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplAccessProxy *proxy = XDP_IMPL_ACCESS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_access_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_access_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_access_proxy_init (XdpImplAccessProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_access_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_ACCESS_PROXY, XdpImplAccessProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_access_interface_info ());
}

static void
xdp_impl_access_proxy_class_init (XdpImplAccessProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_access_proxy_finalize;
  gobject_class->get_property = xdp_impl_access_proxy_get_property;
  gobject_class->set_property = xdp_impl_access_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_access_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_access_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplAccessProxyPrivate));
#endif
}

static void
xdp_impl_access_proxy_iface_init (XdpImplAccessIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_access_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_access_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_access_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_access_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_ACCESS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Access", NULL);
}

/**
 * xdp_impl_access_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_access_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_access_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplAccessProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplAccess *
xdp_impl_access_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_ACCESS (ret);
  else
    return NULL;
}

/**
 * xdp_impl_access_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_access_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplAccessProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplAccess *
xdp_impl_access_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_ACCESS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Access", NULL);
  if (ret != NULL)
    return XDP_IMPL_ACCESS (ret);
  else
    return NULL;
}


/**
 * xdp_impl_access_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_access_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_access_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_access_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_access_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_ACCESS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Access", NULL);
}

/**
 * xdp_impl_access_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_access_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_access_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplAccessProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplAccess *
xdp_impl_access_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_ACCESS (ret);
  else
    return NULL;
}

/**
 * xdp_impl_access_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_access_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_access_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplAccessProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplAccess *
xdp_impl_access_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_ACCESS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Access", NULL);
  if (ret != NULL)
    return XDP_IMPL_ACCESS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplAccessSkeleton:
 *
 * The #XdpImplAccessSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplAccessSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplAccessSkeleton.
 */

struct _XdpImplAccessSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_access_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplAccessSkeleton *skeleton = XDP_IMPL_ACCESS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_ACCESS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_ACCESS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_access_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplAccessSkeleton *skeleton = XDP_IMPL_ACCESS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_access_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_access_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplAccessSkeleton *skeleton = XDP_IMPL_ACCESS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_access_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_access_skeleton_vtable =
{
  _xdp_impl_access_skeleton_handle_method_call,
  _xdp_impl_access_skeleton_handle_get_property,
  _xdp_impl_access_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_access_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_access_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_access_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_access_skeleton_vtable;
}

static GVariant *
xdp_impl_access_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplAccessSkeleton *skeleton = XDP_IMPL_ACCESS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_access_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_access_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_access_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_access_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Access", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_access_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_impl_access_skeleton_iface_init (XdpImplAccessIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplAccessSkeleton, xdp_impl_access_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplAccessSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_ACCESS, xdp_impl_access_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplAccessSkeleton, xdp_impl_access_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_ACCESS, xdp_impl_access_skeleton_iface_init))

#endif
static void
xdp_impl_access_skeleton_finalize (GObject *object)
{
  XdpImplAccessSkeleton *skeleton = XDP_IMPL_ACCESS_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_access_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_access_skeleton_init (XdpImplAccessSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_access_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_ACCESS_SKELETON, XdpImplAccessSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_access_skeleton_class_init (XdpImplAccessSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_access_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_access_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_access_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_access_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_access_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplAccessSkeletonPrivate));
#endif
}

static void
xdp_impl_access_skeleton_iface_init (XdpImplAccessIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_access_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link>.
 *
 * Returns: (transfer full) (type XdpImplAccessSkeleton): The skeleton object.
 */
XdpImplAccess *
xdp_impl_access_skeleton_new (void)
{
  return XDP_IMPL_ACCESS (g_object_new (XDP_IMPL_TYPE_ACCESS_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Account
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplAccount
 * @title: XdpImplAccount
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Account D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Account ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_account_method_info_get_user_information_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_account_method_info_get_user_information_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_account_method_info_get_user_information_IN_ARG_window =
{
  {
    -1,
    (gchar *) "window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_account_method_info_get_user_information_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_account_method_info_get_user_information_IN_ARG_pointers[] =
{
  &_xdp_impl_account_method_info_get_user_information_IN_ARG_handle.parent_struct,
  &_xdp_impl_account_method_info_get_user_information_IN_ARG_app_id.parent_struct,
  &_xdp_impl_account_method_info_get_user_information_IN_ARG_window.parent_struct,
  &_xdp_impl_account_method_info_get_user_information_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_account_method_info_get_user_information_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_account_method_info_get_user_information_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_account_method_info_get_user_information_OUT_ARG_pointers[] =
{
  &_xdp_impl_account_method_info_get_user_information_OUT_ARG_response.parent_struct,
  &_xdp_impl_account_method_info_get_user_information_OUT_ARG_results.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_account_method_info_get_user_information =
{
  {
    -1,
    (gchar *) "GetUserInformation",
    (GDBusArgInfo **) &_xdp_impl_account_method_info_get_user_information_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_account_method_info_get_user_information_OUT_ARG_pointers,
    NULL
  },
  "handle-get-user-information",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_account_method_info_pointers[] =
{
  &_xdp_impl_account_method_info_get_user_information.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_account_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Account",
    (GDBusMethodInfo **) &_xdp_impl_account_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "account",
};


/**
 * xdp_impl_account_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_account_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_account_interface_info.parent_struct;
}

/**
 * xdp_impl_account_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplAccount interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_account_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpImplAccount:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link>.
 */

/**
 * XdpImplAccountIface:
 * @parent_iface: The parent interface.
 * @handle_get_user_information: Handler for the #XdpImplAccount::handle-get-user-information signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link>.
 */

typedef XdpImplAccountIface XdpImplAccountInterface;
G_DEFINE_INTERFACE (XdpImplAccount, xdp_impl_account, G_TYPE_OBJECT)

static void
xdp_impl_account_default_init (XdpImplAccountIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplAccount::handle-get-user-information:
   * @object: A #XdpImplAccount.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Account.GetUserInformation">GetUserInformation()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_account_complete_get_user_information() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-user-information",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplAccountIface, handle_get_user_information),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_impl_account_call_get_user_information:
 * @proxy: A #XdpImplAccountProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Account.GetUserInformation">GetUserInformation()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_account_call_get_user_information_finish() to get the result of the operation.
 *
 * See xdp_impl_account_call_get_user_information_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_account_call_get_user_information (
    XdpImplAccount *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUserInformation",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_account_call_get_user_information_finish:
 * @proxy: A #XdpImplAccountProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_account_call_get_user_information().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_account_call_get_user_information().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_account_call_get_user_information_finish (
    XdpImplAccount *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_account_call_get_user_information_sync:
 * @proxy: A #XdpImplAccountProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Account.GetUserInformation">GetUserInformation()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_account_call_get_user_information() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_account_call_get_user_information_sync (
    XdpImplAccount *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUserInformation",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_account_complete_get_user_information:
 * @object: A #XdpImplAccount.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Account.GetUserInformation">GetUserInformation()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_account_complete_get_user_information (
    XdpImplAccount *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplAccountProxy:
 *
 * The #XdpImplAccountProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplAccountProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplAccountProxy.
 */

struct _XdpImplAccountProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_account_proxy_iface_init (XdpImplAccountIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplAccountProxy, xdp_impl_account_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplAccountProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_ACCOUNT, xdp_impl_account_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplAccountProxy, xdp_impl_account_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_ACCOUNT, xdp_impl_account_proxy_iface_init))

#endif
static void
xdp_impl_account_proxy_finalize (GObject *object)
{
  XdpImplAccountProxy *proxy = XDP_IMPL_ACCOUNT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_account_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_account_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_account_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_account_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_account_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_ACCOUNT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_ACCOUNT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_account_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplAccountProxy *proxy = XDP_IMPL_ACCOUNT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_account_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_account_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_account_proxy_init (XdpImplAccountProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_account_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_ACCOUNT_PROXY, XdpImplAccountProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_account_interface_info ());
}

static void
xdp_impl_account_proxy_class_init (XdpImplAccountProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_account_proxy_finalize;
  gobject_class->get_property = xdp_impl_account_proxy_get_property;
  gobject_class->set_property = xdp_impl_account_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_account_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_account_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplAccountProxyPrivate));
#endif
}

static void
xdp_impl_account_proxy_iface_init (XdpImplAccountIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_account_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_account_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_account_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_account_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_ACCOUNT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Account", NULL);
}

/**
 * xdp_impl_account_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_account_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_account_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplAccountProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplAccount *
xdp_impl_account_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_ACCOUNT (ret);
  else
    return NULL;
}

/**
 * xdp_impl_account_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_account_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplAccountProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplAccount *
xdp_impl_account_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_ACCOUNT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Account", NULL);
  if (ret != NULL)
    return XDP_IMPL_ACCOUNT (ret);
  else
    return NULL;
}


/**
 * xdp_impl_account_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_account_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_account_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_account_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_account_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_ACCOUNT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Account", NULL);
}

/**
 * xdp_impl_account_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_account_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_account_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplAccountProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplAccount *
xdp_impl_account_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_ACCOUNT (ret);
  else
    return NULL;
}

/**
 * xdp_impl_account_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_account_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_account_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplAccountProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplAccount *
xdp_impl_account_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_ACCOUNT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Account", NULL);
  if (ret != NULL)
    return XDP_IMPL_ACCOUNT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplAccountSkeleton:
 *
 * The #XdpImplAccountSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplAccountSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplAccountSkeleton.
 */

struct _XdpImplAccountSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_account_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplAccountSkeleton *skeleton = XDP_IMPL_ACCOUNT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_ACCOUNT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_ACCOUNT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_account_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplAccountSkeleton *skeleton = XDP_IMPL_ACCOUNT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_account_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_account_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplAccountSkeleton *skeleton = XDP_IMPL_ACCOUNT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_account_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_account_skeleton_vtable =
{
  _xdp_impl_account_skeleton_handle_method_call,
  _xdp_impl_account_skeleton_handle_get_property,
  _xdp_impl_account_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_account_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_account_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_account_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_account_skeleton_vtable;
}

static GVariant *
xdp_impl_account_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplAccountSkeleton *skeleton = XDP_IMPL_ACCOUNT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_account_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_account_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_account_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_account_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Account", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_account_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_impl_account_skeleton_iface_init (XdpImplAccountIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplAccountSkeleton, xdp_impl_account_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplAccountSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_ACCOUNT, xdp_impl_account_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplAccountSkeleton, xdp_impl_account_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_ACCOUNT, xdp_impl_account_skeleton_iface_init))

#endif
static void
xdp_impl_account_skeleton_finalize (GObject *object)
{
  XdpImplAccountSkeleton *skeleton = XDP_IMPL_ACCOUNT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_account_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_account_skeleton_init (XdpImplAccountSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_account_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_ACCOUNT_SKELETON, XdpImplAccountSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_account_skeleton_class_init (XdpImplAccountSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_account_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_account_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_account_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_account_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_account_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplAccountSkeletonPrivate));
#endif
}

static void
xdp_impl_account_skeleton_iface_init (XdpImplAccountIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_account_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link>.
 *
 * Returns: (transfer full) (type XdpImplAccountSkeleton): The skeleton object.
 */
XdpImplAccount *
xdp_impl_account_skeleton_new (void)
{
  return XDP_IMPL_ACCOUNT (g_object_new (XDP_IMPL_TYPE_ACCOUNT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.AppChooser
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplAppChooser
 * @title: XdpImplAppChooser
 * @short_description: Generated C code for the org.freedesktop.impl.portal.AppChooser D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.AppChooser ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_app_chooser_method_info_choose_application_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_app_chooser_method_info_choose_application_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_app_chooser_method_info_choose_application_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_app_chooser_method_info_choose_application_IN_ARG_choices =
{
  {
    -1,
    (gchar *) "choices",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_app_chooser_method_info_choose_application_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_app_chooser_method_info_choose_application_IN_ARG_pointers[] =
{
  &_xdp_impl_app_chooser_method_info_choose_application_IN_ARG_handle.parent_struct,
  &_xdp_impl_app_chooser_method_info_choose_application_IN_ARG_app_id.parent_struct,
  &_xdp_impl_app_chooser_method_info_choose_application_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_app_chooser_method_info_choose_application_IN_ARG_choices.parent_struct,
  &_xdp_impl_app_chooser_method_info_choose_application_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_app_chooser_method_info_choose_application_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_app_chooser_method_info_choose_application_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_app_chooser_method_info_choose_application_OUT_ARG_pointers[] =
{
  &_xdp_impl_app_chooser_method_info_choose_application_OUT_ARG_response.parent_struct,
  &_xdp_impl_app_chooser_method_info_choose_application_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_app_chooser_method_choose_application_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_app_chooser_method_choose_application_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_app_chooser_method_choose_application_annotation_info_pointers[] =
{
  &_xdp_impl_app_chooser_method_choose_application_annotation_info_0,
  &_xdp_impl_app_chooser_method_choose_application_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_app_chooser_method_info_choose_application =
{
  {
    -1,
    (gchar *) "ChooseApplication",
    (GDBusArgInfo **) &_xdp_impl_app_chooser_method_info_choose_application_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_app_chooser_method_info_choose_application_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_app_chooser_method_choose_application_annotation_info_pointers
  },
  "handle-choose-application",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_app_chooser_method_info_update_choices_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_app_chooser_method_info_update_choices_IN_ARG_choices =
{
  {
    -1,
    (gchar *) "choices",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_app_chooser_method_info_update_choices_IN_ARG_pointers[] =
{
  &_xdp_impl_app_chooser_method_info_update_choices_IN_ARG_handle.parent_struct,
  &_xdp_impl_app_chooser_method_info_update_choices_IN_ARG_choices.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_app_chooser_method_info_update_choices =
{
  {
    -1,
    (gchar *) "UpdateChoices",
    (GDBusArgInfo **) &_xdp_impl_app_chooser_method_info_update_choices_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-update-choices",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_app_chooser_method_info_pointers[] =
{
  &_xdp_impl_app_chooser_method_info_choose_application.parent_struct,
  &_xdp_impl_app_chooser_method_info_update_choices.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_app_chooser_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.AppChooser",
    (GDBusMethodInfo **) &_xdp_impl_app_chooser_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "app-chooser",
};


/**
 * xdp_impl_app_chooser_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_app_chooser_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_app_chooser_interface_info.parent_struct;
}

/**
 * xdp_impl_app_chooser_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplAppChooser interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_app_chooser_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpImplAppChooser:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link>.
 */

/**
 * XdpImplAppChooserIface:
 * @parent_iface: The parent interface.
 * @handle_choose_application: Handler for the #XdpImplAppChooser::handle-choose-application signal.
 * @handle_update_choices: Handler for the #XdpImplAppChooser::handle-update-choices signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link>.
 */

typedef XdpImplAppChooserIface XdpImplAppChooserInterface;
G_DEFINE_INTERFACE (XdpImplAppChooser, xdp_impl_app_chooser, G_TYPE_OBJECT)

static void
xdp_impl_app_chooser_default_init (XdpImplAppChooserIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplAppChooser::handle-choose-application:
   * @object: A #XdpImplAppChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_choices: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.ChooseApplication">ChooseApplication()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_app_chooser_complete_choose_application() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-choose-application",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplAppChooserIface, handle_choose_application),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_VARIANT);

  /**
   * XdpImplAppChooser::handle-update-choices:
   * @object: A #XdpImplAppChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_choices: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.UpdateChoices">UpdateChoices()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_app_chooser_complete_update_choices() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update-choices",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplAppChooserIface, handle_update_choices),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV);

}

/**
 * xdp_impl_app_chooser_call_choose_application:
 * @proxy: A #XdpImplAppChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_choices: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.ChooseApplication">ChooseApplication()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_app_chooser_call_choose_application_finish() to get the result of the operation.
 *
 * See xdp_impl_app_chooser_call_choose_application_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_app_chooser_call_choose_application (
    XdpImplAppChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *const *arg_choices,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ChooseApplication",
    g_variant_new ("(oss^as@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_choices,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_app_chooser_call_choose_application_finish:
 * @proxy: A #XdpImplAppChooserProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_app_chooser_call_choose_application().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_app_chooser_call_choose_application().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_app_chooser_call_choose_application_finish (
    XdpImplAppChooser *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_app_chooser_call_choose_application_sync:
 * @proxy: A #XdpImplAppChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_choices: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.ChooseApplication">ChooseApplication()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_app_chooser_call_choose_application() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_app_chooser_call_choose_application_sync (
    XdpImplAppChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *const *arg_choices,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ChooseApplication",
    g_variant_new ("(oss^as@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_choices,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_app_chooser_call_update_choices:
 * @proxy: A #XdpImplAppChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_choices: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.UpdateChoices">UpdateChoices()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_app_chooser_call_update_choices_finish() to get the result of the operation.
 *
 * See xdp_impl_app_chooser_call_update_choices_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_app_chooser_call_update_choices (
    XdpImplAppChooser *proxy,
    const gchar *arg_handle,
    const gchar *const *arg_choices,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UpdateChoices",
    g_variant_new ("(o^as)",
                   arg_handle,
                   arg_choices),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_app_chooser_call_update_choices_finish:
 * @proxy: A #XdpImplAppChooserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_app_chooser_call_update_choices().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_app_chooser_call_update_choices().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_app_chooser_call_update_choices_finish (
    XdpImplAppChooser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_app_chooser_call_update_choices_sync:
 * @proxy: A #XdpImplAppChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_choices: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.UpdateChoices">UpdateChoices()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_app_chooser_call_update_choices() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_app_chooser_call_update_choices_sync (
    XdpImplAppChooser *proxy,
    const gchar *arg_handle,
    const gchar *const *arg_choices,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UpdateChoices",
    g_variant_new ("(o^as)",
                   arg_handle,
                   arg_choices),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_app_chooser_complete_choose_application:
 * @object: A #XdpImplAppChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.ChooseApplication">ChooseApplication()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_app_chooser_complete_choose_application (
    XdpImplAppChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_app_chooser_complete_update_choices:
 * @object: A #XdpImplAppChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.UpdateChoices">UpdateChoices()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_app_chooser_complete_update_choices (
    XdpImplAppChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplAppChooserProxy:
 *
 * The #XdpImplAppChooserProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplAppChooserProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplAppChooserProxy.
 */

struct _XdpImplAppChooserProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_app_chooser_proxy_iface_init (XdpImplAppChooserIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplAppChooserProxy, xdp_impl_app_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplAppChooserProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_APP_CHOOSER, xdp_impl_app_chooser_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplAppChooserProxy, xdp_impl_app_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_APP_CHOOSER, xdp_impl_app_chooser_proxy_iface_init))

#endif
static void
xdp_impl_app_chooser_proxy_finalize (GObject *object)
{
  XdpImplAppChooserProxy *proxy = XDP_IMPL_APP_CHOOSER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_app_chooser_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_app_chooser_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_app_chooser_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_app_chooser_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_app_chooser_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_APP_CHOOSER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_APP_CHOOSER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_app_chooser_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplAppChooserProxy *proxy = XDP_IMPL_APP_CHOOSER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_app_chooser_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_app_chooser_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_app_chooser_proxy_init (XdpImplAppChooserProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_app_chooser_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_APP_CHOOSER_PROXY, XdpImplAppChooserProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_app_chooser_interface_info ());
}

static void
xdp_impl_app_chooser_proxy_class_init (XdpImplAppChooserProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_app_chooser_proxy_finalize;
  gobject_class->get_property = xdp_impl_app_chooser_proxy_get_property;
  gobject_class->set_property = xdp_impl_app_chooser_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_app_chooser_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_app_chooser_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplAppChooserProxyPrivate));
#endif
}

static void
xdp_impl_app_chooser_proxy_iface_init (XdpImplAppChooserIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_app_chooser_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_app_chooser_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_app_chooser_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_app_chooser_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_APP_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.AppChooser", NULL);
}

/**
 * xdp_impl_app_chooser_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_app_chooser_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_app_chooser_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplAppChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplAppChooser *
xdp_impl_app_chooser_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_APP_CHOOSER (ret);
  else
    return NULL;
}

/**
 * xdp_impl_app_chooser_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_app_chooser_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplAppChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplAppChooser *
xdp_impl_app_chooser_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_APP_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.AppChooser", NULL);
  if (ret != NULL)
    return XDP_IMPL_APP_CHOOSER (ret);
  else
    return NULL;
}


/**
 * xdp_impl_app_chooser_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_app_chooser_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_app_chooser_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_app_chooser_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_app_chooser_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_APP_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.AppChooser", NULL);
}

/**
 * xdp_impl_app_chooser_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_app_chooser_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_app_chooser_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplAppChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplAppChooser *
xdp_impl_app_chooser_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_APP_CHOOSER (ret);
  else
    return NULL;
}

/**
 * xdp_impl_app_chooser_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_app_chooser_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_app_chooser_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplAppChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplAppChooser *
xdp_impl_app_chooser_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_APP_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.AppChooser", NULL);
  if (ret != NULL)
    return XDP_IMPL_APP_CHOOSER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplAppChooserSkeleton:
 *
 * The #XdpImplAppChooserSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplAppChooserSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplAppChooserSkeleton.
 */

struct _XdpImplAppChooserSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_app_chooser_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplAppChooserSkeleton *skeleton = XDP_IMPL_APP_CHOOSER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_APP_CHOOSER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_APP_CHOOSER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_app_chooser_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplAppChooserSkeleton *skeleton = XDP_IMPL_APP_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_app_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_app_chooser_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplAppChooserSkeleton *skeleton = XDP_IMPL_APP_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_app_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_app_chooser_skeleton_vtable =
{
  _xdp_impl_app_chooser_skeleton_handle_method_call,
  _xdp_impl_app_chooser_skeleton_handle_get_property,
  _xdp_impl_app_chooser_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_app_chooser_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_app_chooser_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_app_chooser_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_app_chooser_skeleton_vtable;
}

static GVariant *
xdp_impl_app_chooser_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplAppChooserSkeleton *skeleton = XDP_IMPL_APP_CHOOSER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_app_chooser_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_app_chooser_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_app_chooser_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_app_chooser_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.AppChooser", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_app_chooser_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_impl_app_chooser_skeleton_iface_init (XdpImplAppChooserIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplAppChooserSkeleton, xdp_impl_app_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplAppChooserSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_APP_CHOOSER, xdp_impl_app_chooser_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplAppChooserSkeleton, xdp_impl_app_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_APP_CHOOSER, xdp_impl_app_chooser_skeleton_iface_init))

#endif
static void
xdp_impl_app_chooser_skeleton_finalize (GObject *object)
{
  XdpImplAppChooserSkeleton *skeleton = XDP_IMPL_APP_CHOOSER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_app_chooser_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_app_chooser_skeleton_init (XdpImplAppChooserSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_app_chooser_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_APP_CHOOSER_SKELETON, XdpImplAppChooserSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_app_chooser_skeleton_class_init (XdpImplAppChooserSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_app_chooser_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_app_chooser_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_app_chooser_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_app_chooser_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_app_chooser_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplAppChooserSkeletonPrivate));
#endif
}

static void
xdp_impl_app_chooser_skeleton_iface_init (XdpImplAppChooserIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_app_chooser_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link>.
 *
 * Returns: (transfer full) (type XdpImplAppChooserSkeleton): The skeleton object.
 */
XdpImplAppChooser *
xdp_impl_app_chooser_skeleton_new (void)
{
  return XDP_IMPL_APP_CHOOSER (g_object_new (XDP_IMPL_TYPE_APP_CHOOSER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Background
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplBackground
 * @title: XdpImplBackground
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Background D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Background ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_get_app_state_OUT_ARG_apps =
{
  {
    -1,
    (gchar *) "apps",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_background_method_info_get_app_state_OUT_ARG_pointers[] =
{
  &_xdp_impl_background_method_info_get_app_state_OUT_ARG_apps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_background_method_info_get_app_state =
{
  {
    -1,
    (gchar *) "GetAppState",
    NULL,
    (GDBusArgInfo **) &_xdp_impl_background_method_info_get_app_state_OUT_ARG_pointers,
    NULL
  },
  "handle-get-app-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_notify_background_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_notify_background_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_notify_background_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_background_method_info_notify_background_IN_ARG_pointers[] =
{
  &_xdp_impl_background_method_info_notify_background_IN_ARG_handle.parent_struct,
  &_xdp_impl_background_method_info_notify_background_IN_ARG_app_id.parent_struct,
  &_xdp_impl_background_method_info_notify_background_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_notify_background_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_notify_background_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_background_method_info_notify_background_OUT_ARG_pointers[] =
{
  &_xdp_impl_background_method_info_notify_background_OUT_ARG_response.parent_struct,
  &_xdp_impl_background_method_info_notify_background_OUT_ARG_results.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_background_method_info_notify_background =
{
  {
    -1,
    (gchar *) "NotifyBackground",
    (GDBusArgInfo **) &_xdp_impl_background_method_info_notify_background_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_background_method_info_notify_background_OUT_ARG_pointers,
    NULL
  },
  "handle-notify-background",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_enable_autostart_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_enable_autostart_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_enable_autostart_IN_ARG_commandline =
{
  {
    -1,
    (gchar *) "commandline",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_enable_autostart_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_background_method_info_enable_autostart_IN_ARG_pointers[] =
{
  &_xdp_impl_background_method_info_enable_autostart_IN_ARG_app_id.parent_struct,
  &_xdp_impl_background_method_info_enable_autostart_IN_ARG_enable.parent_struct,
  &_xdp_impl_background_method_info_enable_autostart_IN_ARG_commandline.parent_struct,
  &_xdp_impl_background_method_info_enable_autostart_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_background_method_info_enable_autostart_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_background_method_info_enable_autostart_OUT_ARG_pointers[] =
{
  &_xdp_impl_background_method_info_enable_autostart_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_background_method_info_enable_autostart =
{
  {
    -1,
    (gchar *) "EnableAutostart",
    (GDBusArgInfo **) &_xdp_impl_background_method_info_enable_autostart_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_background_method_info_enable_autostart_OUT_ARG_pointers,
    NULL
  },
  "handle-enable-autostart",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_background_method_info_pointers[] =
{
  &_xdp_impl_background_method_info_get_app_state.parent_struct,
  &_xdp_impl_background_method_info_notify_background.parent_struct,
  &_xdp_impl_background_method_info_enable_autostart.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_impl_background_signal_info_running_applications_changed =
{
  {
    -1,
    (gchar *) "RunningApplicationsChanged",
    NULL,
    NULL
  },
  "running-applications-changed"
};

static const GDBusSignalInfo * const _xdp_impl_background_signal_info_pointers[] =
{
  &_xdp_impl_background_signal_info_running_applications_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_background_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Background",
    (GDBusMethodInfo **) &_xdp_impl_background_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_impl_background_signal_info_pointers,
    NULL,
    NULL
  },
  "background",
};


/**
 * xdp_impl_background_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_background_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_background_interface_info.parent_struct;
}

/**
 * xdp_impl_background_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplBackground interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_background_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpImplBackground:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>.
 */

/**
 * XdpImplBackgroundIface:
 * @parent_iface: The parent interface.
 * @handle_enable_autostart: Handler for the #XdpImplBackground::handle-enable-autostart signal.
 * @handle_get_app_state: Handler for the #XdpImplBackground::handle-get-app-state signal.
 * @handle_notify_background: Handler for the #XdpImplBackground::handle-notify-background signal.
 * @running_applications_changed: Handler for the #XdpImplBackground::running-applications-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>.
 */

typedef XdpImplBackgroundIface XdpImplBackgroundInterface;
G_DEFINE_INTERFACE (XdpImplBackground, xdp_impl_background, G_TYPE_OBJECT)

static void
xdp_impl_background_default_init (XdpImplBackgroundIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplBackground::handle-get-app-state:
   * @object: A #XdpImplBackground.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.GetAppState">GetAppState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_background_complete_get_app_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-app-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplBackgroundIface, handle_get_app_state),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XdpImplBackground::handle-notify-background:
   * @object: A #XdpImplBackground.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.NotifyBackground">NotifyBackground()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_background_complete_notify_background() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-background",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplBackgroundIface, handle_notify_background),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpImplBackground::handle-enable-autostart:
   * @object: A #XdpImplBackground.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_enable: Argument passed by remote caller.
   * @arg_commandline: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.EnableAutostart">EnableAutostart()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_background_complete_enable_autostart() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable-autostart",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplBackgroundIface, handle_enable_autostart),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRV, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpImplBackground::running-applications-changed:
   * @object: A #XdpImplBackground.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Background.RunningApplicationsChanged">"RunningApplicationsChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("running-applications-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplBackgroundIface, running_applications_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

}

/**
 * xdp_impl_background_emit_running_applications_changed:
 * @object: A #XdpImplBackground.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Background.RunningApplicationsChanged">"RunningApplicationsChanged"</link> D-Bus signal.
 */
void
xdp_impl_background_emit_running_applications_changed (
    XdpImplBackground *object)
{
  g_signal_emit_by_name (object, "running-applications-changed");
}

/**
 * xdp_impl_background_call_get_app_state:
 * @proxy: A #XdpImplBackgroundProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.GetAppState">GetAppState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_background_call_get_app_state_finish() to get the result of the operation.
 *
 * See xdp_impl_background_call_get_app_state_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_background_call_get_app_state (
    XdpImplBackground *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAppState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_background_call_get_app_state_finish:
 * @proxy: A #XdpImplBackgroundProxy.
 * @out_apps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_background_call_get_app_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_background_call_get_app_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_background_call_get_app_state_finish (
    XdpImplBackground *proxy,
    GVariant **out_apps,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_apps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_background_call_get_app_state_sync:
 * @proxy: A #XdpImplBackgroundProxy.
 * @out_apps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.GetAppState">GetAppState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_background_call_get_app_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_background_call_get_app_state_sync (
    XdpImplBackground *proxy,
    GVariant **out_apps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAppState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_apps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_background_call_notify_background:
 * @proxy: A #XdpImplBackgroundProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.NotifyBackground">NotifyBackground()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_background_call_notify_background_finish() to get the result of the operation.
 *
 * See xdp_impl_background_call_notify_background_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_background_call_notify_background (
    XdpImplBackground *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyBackground",
    g_variant_new ("(oss)",
                   arg_handle,
                   arg_app_id,
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_background_call_notify_background_finish:
 * @proxy: A #XdpImplBackgroundProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_background_call_notify_background().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_background_call_notify_background().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_background_call_notify_background_finish (
    XdpImplBackground *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_background_call_notify_background_sync:
 * @proxy: A #XdpImplBackgroundProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.NotifyBackground">NotifyBackground()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_background_call_notify_background() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_background_call_notify_background_sync (
    XdpImplBackground *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_name,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyBackground",
    g_variant_new ("(oss)",
                   arg_handle,
                   arg_app_id,
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_background_call_enable_autostart:
 * @proxy: A #XdpImplBackgroundProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @arg_commandline: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.EnableAutostart">EnableAutostart()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_background_call_enable_autostart_finish() to get the result of the operation.
 *
 * See xdp_impl_background_call_enable_autostart_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_background_call_enable_autostart (
    XdpImplBackground *proxy,
    const gchar *arg_app_id,
    gboolean arg_enable,
    const gchar *const *arg_commandline,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnableAutostart",
    g_variant_new ("(sb^asu)",
                   arg_app_id,
                   arg_enable,
                   arg_commandline,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_background_call_enable_autostart_finish:
 * @proxy: A #XdpImplBackgroundProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_background_call_enable_autostart().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_background_call_enable_autostart().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_background_call_enable_autostart_finish (
    XdpImplBackground *proxy,
    gboolean *out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_background_call_enable_autostart_sync:
 * @proxy: A #XdpImplBackgroundProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @arg_commandline: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.EnableAutostart">EnableAutostart()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_background_call_enable_autostart() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_background_call_enable_autostart_sync (
    XdpImplBackground *proxy,
    const gchar *arg_app_id,
    gboolean arg_enable,
    const gchar *const *arg_commandline,
    guint arg_flags,
    gboolean *out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnableAutostart",
    g_variant_new ("(sb^asu)",
                   arg_app_id,
                   arg_enable,
                   arg_commandline,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_background_complete_get_app_state:
 * @object: A #XdpImplBackground.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @apps: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.GetAppState">GetAppState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_background_complete_get_app_state (
    XdpImplBackground *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *apps)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   apps));
}

/**
 * xdp_impl_background_complete_notify_background:
 * @object: A #XdpImplBackground.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.NotifyBackground">NotifyBackground()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_background_complete_notify_background (
    XdpImplBackground *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_background_complete_enable_autostart:
 * @object: A #XdpImplBackground.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.EnableAutostart">EnableAutostart()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_background_complete_enable_autostart (
    XdpImplBackground *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   result));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplBackgroundProxy:
 *
 * The #XdpImplBackgroundProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplBackgroundProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplBackgroundProxy.
 */

struct _XdpImplBackgroundProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_background_proxy_iface_init (XdpImplBackgroundIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplBackgroundProxy, xdp_impl_background_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplBackgroundProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_BACKGROUND, xdp_impl_background_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplBackgroundProxy, xdp_impl_background_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_BACKGROUND, xdp_impl_background_proxy_iface_init))

#endif
static void
xdp_impl_background_proxy_finalize (GObject *object)
{
  XdpImplBackgroundProxy *proxy = XDP_IMPL_BACKGROUND_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_background_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_background_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_background_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_background_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_background_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_BACKGROUND);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_BACKGROUND);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_background_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplBackgroundProxy *proxy = XDP_IMPL_BACKGROUND_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_background_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_background_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_background_proxy_init (XdpImplBackgroundProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_background_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_BACKGROUND_PROXY, XdpImplBackgroundProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_background_interface_info ());
}

static void
xdp_impl_background_proxy_class_init (XdpImplBackgroundProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_background_proxy_finalize;
  gobject_class->get_property = xdp_impl_background_proxy_get_property;
  gobject_class->set_property = xdp_impl_background_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_background_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_background_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplBackgroundProxyPrivate));
#endif
}

static void
xdp_impl_background_proxy_iface_init (XdpImplBackgroundIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_background_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_background_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_background_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_background_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_BACKGROUND_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Background", NULL);
}

/**
 * xdp_impl_background_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_background_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_background_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplBackground *
xdp_impl_background_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_BACKGROUND (ret);
  else
    return NULL;
}

/**
 * xdp_impl_background_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_background_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplBackground *
xdp_impl_background_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_BACKGROUND_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Background", NULL);
  if (ret != NULL)
    return XDP_IMPL_BACKGROUND (ret);
  else
    return NULL;
}


/**
 * xdp_impl_background_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_background_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_background_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_background_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_background_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_BACKGROUND_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Background", NULL);
}

/**
 * xdp_impl_background_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_background_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_background_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplBackground *
xdp_impl_background_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_BACKGROUND (ret);
  else
    return NULL;
}

/**
 * xdp_impl_background_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_background_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_background_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplBackground *
xdp_impl_background_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_BACKGROUND_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Background", NULL);
  if (ret != NULL)
    return XDP_IMPL_BACKGROUND (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplBackgroundSkeleton:
 *
 * The #XdpImplBackgroundSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplBackgroundSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplBackgroundSkeleton.
 */

struct _XdpImplBackgroundSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_background_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplBackgroundSkeleton *skeleton = XDP_IMPL_BACKGROUND_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_BACKGROUND);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_BACKGROUND);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_background_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplBackgroundSkeleton *skeleton = XDP_IMPL_BACKGROUND_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_background_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_background_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplBackgroundSkeleton *skeleton = XDP_IMPL_BACKGROUND_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_background_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_background_skeleton_vtable =
{
  _xdp_impl_background_skeleton_handle_method_call,
  _xdp_impl_background_skeleton_handle_get_property,
  _xdp_impl_background_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_background_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_background_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_background_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_background_skeleton_vtable;
}

static GVariant *
xdp_impl_background_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplBackgroundSkeleton *skeleton = XDP_IMPL_BACKGROUND_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_background_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_background_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_background_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_background_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Background", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_background_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_xdp_impl_background_on_signal_running_applications_changed (
    XdpImplBackground *object)
{
  XdpImplBackgroundSkeleton *skeleton = XDP_IMPL_BACKGROUND_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Background", "RunningApplicationsChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_impl_background_skeleton_iface_init (XdpImplBackgroundIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplBackgroundSkeleton, xdp_impl_background_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplBackgroundSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_BACKGROUND, xdp_impl_background_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplBackgroundSkeleton, xdp_impl_background_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_BACKGROUND, xdp_impl_background_skeleton_iface_init))

#endif
static void
xdp_impl_background_skeleton_finalize (GObject *object)
{
  XdpImplBackgroundSkeleton *skeleton = XDP_IMPL_BACKGROUND_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_background_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_background_skeleton_init (XdpImplBackgroundSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_background_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_BACKGROUND_SKELETON, XdpImplBackgroundSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_background_skeleton_class_init (XdpImplBackgroundSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_background_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_background_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_background_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_background_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_background_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplBackgroundSkeletonPrivate));
#endif
}

static void
xdp_impl_background_skeleton_iface_init (XdpImplBackgroundIface *iface)
{
  iface->running_applications_changed = _xdp_impl_background_on_signal_running_applications_changed;
}

/**
 * xdp_impl_background_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>.
 *
 * Returns: (transfer full) (type XdpImplBackgroundSkeleton): The skeleton object.
 */
XdpImplBackground *
xdp_impl_background_skeleton_new (void)
{
  return XDP_IMPL_BACKGROUND (g_object_new (XDP_IMPL_TYPE_BACKGROUND_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.DynamicLauncher
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplDynamicLauncher
 * @title: XdpImplDynamicLauncher
 * @short_description: Generated C code for the org.freedesktop.impl.portal.DynamicLauncher D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.DynamicLauncher ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_icon_v =
{
  {
    -1,
    (gchar *) "icon_v",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_pointers[] =
{
  &_xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_handle.parent_struct,
  &_xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_app_id.parent_struct,
  &_xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_name.parent_struct,
  &_xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_icon_v.parent_struct,
  &_xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_dynamic_launcher_method_info_prepare_install_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_dynamic_launcher_method_info_prepare_install_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_dynamic_launcher_method_info_prepare_install_OUT_ARG_pointers[] =
{
  &_xdp_impl_dynamic_launcher_method_info_prepare_install_OUT_ARG_response.parent_struct,
  &_xdp_impl_dynamic_launcher_method_info_prepare_install_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_dynamic_launcher_method_prepare_install_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_dynamic_launcher_method_prepare_install_annotation_info_pointers[] =
{
  &_xdp_impl_dynamic_launcher_method_prepare_install_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_dynamic_launcher_method_info_prepare_install =
{
  {
    -1,
    (gchar *) "PrepareInstall",
    (GDBusArgInfo **) &_xdp_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_dynamic_launcher_method_info_prepare_install_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_dynamic_launcher_method_prepare_install_annotation_info_pointers
  },
  "handle-prepare-install",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_dynamic_launcher_method_info_request_install_token_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_dynamic_launcher_method_info_request_install_token_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_dynamic_launcher_method_info_request_install_token_IN_ARG_pointers[] =
{
  &_xdp_impl_dynamic_launcher_method_info_request_install_token_IN_ARG_app_id.parent_struct,
  &_xdp_impl_dynamic_launcher_method_info_request_install_token_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_dynamic_launcher_method_info_request_install_token_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_dynamic_launcher_method_info_request_install_token_OUT_ARG_pointers[] =
{
  &_xdp_impl_dynamic_launcher_method_info_request_install_token_OUT_ARG_response.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_dynamic_launcher_method_info_request_install_token =
{
  {
    -1,
    (gchar *) "RequestInstallToken",
    (GDBusArgInfo **) &_xdp_impl_dynamic_launcher_method_info_request_install_token_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_dynamic_launcher_method_info_request_install_token_OUT_ARG_pointers,
    NULL
  },
  "handle-request-install-token",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_dynamic_launcher_method_info_pointers[] =
{
  &_xdp_impl_dynamic_launcher_method_info_prepare_install.parent_struct,
  &_xdp_impl_dynamic_launcher_method_info_request_install_token.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_dynamic_launcher_property_info_supported_launcher_types =
{
  {
    -1,
    (gchar *) "SupportedLauncherTypes",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-launcher-types",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_dynamic_launcher_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_impl_dynamic_launcher_property_info_pointers[] =
{
  &_xdp_impl_dynamic_launcher_property_info_supported_launcher_types.parent_struct,
  &_xdp_impl_dynamic_launcher_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_dynamic_launcher_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.DynamicLauncher",
    (GDBusMethodInfo **) &_xdp_impl_dynamic_launcher_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_impl_dynamic_launcher_property_info_pointers,
    NULL
  },
  "dynamic-launcher",
};


/**
 * xdp_impl_dynamic_launcher_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_dynamic_launcher_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_dynamic_launcher_interface_info.parent_struct;
}

/**
 * xdp_impl_dynamic_launcher_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplDynamicLauncher interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_dynamic_launcher_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "supported-launcher-types");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpImplDynamicLauncher:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link>.
 */

/**
 * XdpImplDynamicLauncherIface:
 * @parent_iface: The parent interface.
 * @handle_prepare_install: Handler for the #XdpImplDynamicLauncher::handle-prepare-install signal.
 * @handle_request_install_token: Handler for the #XdpImplDynamicLauncher::handle-request-install-token signal.
 * @get_supported_launcher_types: Getter for the #XdpImplDynamicLauncher:supported-launcher-types property.
 * @get_version: Getter for the #XdpImplDynamicLauncher:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link>.
 */

typedef XdpImplDynamicLauncherIface XdpImplDynamicLauncherInterface;
G_DEFINE_INTERFACE (XdpImplDynamicLauncher, xdp_impl_dynamic_launcher, G_TYPE_OBJECT)

static void
xdp_impl_dynamic_launcher_default_init (XdpImplDynamicLauncherIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplDynamicLauncher::handle-prepare-install:
   * @object: A #XdpImplDynamicLauncher.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   * @arg_icon_v: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.PrepareInstall">PrepareInstall()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_dynamic_launcher_complete_prepare_install() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-prepare-install",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplDynamicLauncherIface, handle_prepare_install),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdpImplDynamicLauncher::handle-request-install-token:
   * @object: A #XdpImplDynamicLauncher.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.RequestInstallToken">RequestInstallToken()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_dynamic_launcher_complete_request_install_token() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-install-token",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplDynamicLauncherIface, handle_request_install_token),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpImplDynamicLauncher:supported-launcher-types:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-DynamicLauncher.SupportedLauncherTypes">"SupportedLauncherTypes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("supported-launcher-types", "SupportedLauncherTypes", "SupportedLauncherTypes", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplDynamicLauncher:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-DynamicLauncher.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_impl_dynamic_launcher_get_supported_launcher_types: (skip)
 * @object: A #XdpImplDynamicLauncher.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-DynamicLauncher.SupportedLauncherTypes">"SupportedLauncherTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_impl_dynamic_launcher_get_supported_launcher_types (XdpImplDynamicLauncher *object)
{
  return XDP_IMPL_DYNAMIC_LAUNCHER_GET_IFACE (object)->get_supported_launcher_types (object);
}

/**
 * xdp_impl_dynamic_launcher_set_supported_launcher_types: (skip)
 * @object: A #XdpImplDynamicLauncher.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-DynamicLauncher.SupportedLauncherTypes">"SupportedLauncherTypes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_impl_dynamic_launcher_set_supported_launcher_types (XdpImplDynamicLauncher *object, guint value)
{
  g_object_set (G_OBJECT (object), "supported-launcher-types", value, NULL);
}

/**
 * xdp_impl_dynamic_launcher_get_version: (skip)
 * @object: A #XdpImplDynamicLauncher.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-DynamicLauncher.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_impl_dynamic_launcher_get_version (XdpImplDynamicLauncher *object)
{
  return XDP_IMPL_DYNAMIC_LAUNCHER_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_impl_dynamic_launcher_set_version: (skip)
 * @object: A #XdpImplDynamicLauncher.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-DynamicLauncher.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_impl_dynamic_launcher_set_version (XdpImplDynamicLauncher *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_impl_dynamic_launcher_call_prepare_install:
 * @proxy: A #XdpImplDynamicLauncherProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_icon_v: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.PrepareInstall">PrepareInstall()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_dynamic_launcher_call_prepare_install_finish() to get the result of the operation.
 *
 * See xdp_impl_dynamic_launcher_call_prepare_install_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_dynamic_launcher_call_prepare_install (
    XdpImplDynamicLauncher *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_name,
    GVariant *arg_icon_v,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PrepareInstall",
    g_variant_new ("(osss@v@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_name,
                   arg_icon_v,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_dynamic_launcher_call_prepare_install_finish:
 * @proxy: A #XdpImplDynamicLauncherProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_dynamic_launcher_call_prepare_install().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_dynamic_launcher_call_prepare_install().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_dynamic_launcher_call_prepare_install_finish (
    XdpImplDynamicLauncher *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_dynamic_launcher_call_prepare_install_sync:
 * @proxy: A #XdpImplDynamicLauncherProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_icon_v: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.PrepareInstall">PrepareInstall()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_dynamic_launcher_call_prepare_install() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_dynamic_launcher_call_prepare_install_sync (
    XdpImplDynamicLauncher *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_name,
    GVariant *arg_icon_v,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PrepareInstall",
    g_variant_new ("(osss@v@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_name,
                   arg_icon_v,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_dynamic_launcher_call_request_install_token:
 * @proxy: A #XdpImplDynamicLauncherProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.RequestInstallToken">RequestInstallToken()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_dynamic_launcher_call_request_install_token_finish() to get the result of the operation.
 *
 * See xdp_impl_dynamic_launcher_call_request_install_token_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_dynamic_launcher_call_request_install_token (
    XdpImplDynamicLauncher *proxy,
    const gchar *arg_app_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestInstallToken",
    g_variant_new ("(s@a{sv})",
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_dynamic_launcher_call_request_install_token_finish:
 * @proxy: A #XdpImplDynamicLauncherProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_dynamic_launcher_call_request_install_token().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_dynamic_launcher_call_request_install_token().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_dynamic_launcher_call_request_install_token_finish (
    XdpImplDynamicLauncher *proxy,
    guint *out_response,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_dynamic_launcher_call_request_install_token_sync:
 * @proxy: A #XdpImplDynamicLauncherProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.RequestInstallToken">RequestInstallToken()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_dynamic_launcher_call_request_install_token() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_dynamic_launcher_call_request_install_token_sync (
    XdpImplDynamicLauncher *proxy,
    const gchar *arg_app_id,
    GVariant *arg_options,
    guint *out_response,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestInstallToken",
    g_variant_new ("(s@a{sv})",
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_dynamic_launcher_complete_prepare_install:
 * @object: A #XdpImplDynamicLauncher.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.PrepareInstall">PrepareInstall()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_dynamic_launcher_complete_prepare_install (
    XdpImplDynamicLauncher *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_dynamic_launcher_complete_request_install_token:
 * @object: A #XdpImplDynamicLauncher.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.RequestInstallToken">RequestInstallToken()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_dynamic_launcher_complete_request_install_token (
    XdpImplDynamicLauncher *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   response));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplDynamicLauncherProxy:
 *
 * The #XdpImplDynamicLauncherProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplDynamicLauncherProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplDynamicLauncherProxy.
 */

struct _XdpImplDynamicLauncherProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_dynamic_launcher_proxy_iface_init (XdpImplDynamicLauncherIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplDynamicLauncherProxy, xdp_impl_dynamic_launcher_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplDynamicLauncherProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_DYNAMIC_LAUNCHER, xdp_impl_dynamic_launcher_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplDynamicLauncherProxy, xdp_impl_dynamic_launcher_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_DYNAMIC_LAUNCHER, xdp_impl_dynamic_launcher_proxy_iface_init))

#endif
static void
xdp_impl_dynamic_launcher_proxy_finalize (GObject *object)
{
  XdpImplDynamicLauncherProxy *proxy = XDP_IMPL_DYNAMIC_LAUNCHER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_dynamic_launcher_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_dynamic_launcher_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_dynamic_launcher_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_impl_dynamic_launcher_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.DynamicLauncher: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_impl_dynamic_launcher_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_dynamic_launcher_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.DynamicLauncher", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_impl_dynamic_launcher_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_impl_dynamic_launcher_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_dynamic_launcher_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_DYNAMIC_LAUNCHER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_DYNAMIC_LAUNCHER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_dynamic_launcher_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplDynamicLauncherProxy *proxy = XDP_IMPL_DYNAMIC_LAUNCHER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_dynamic_launcher_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_dynamic_launcher_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_impl_dynamic_launcher_proxy_get_supported_launcher_types (XdpImplDynamicLauncher *object)
{
  XdpImplDynamicLauncherProxy *proxy = XDP_IMPL_DYNAMIC_LAUNCHER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedLauncherTypes");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
xdp_impl_dynamic_launcher_proxy_get_version (XdpImplDynamicLauncher *object)
{
  XdpImplDynamicLauncherProxy *proxy = XDP_IMPL_DYNAMIC_LAUNCHER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_impl_dynamic_launcher_proxy_init (XdpImplDynamicLauncherProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_dynamic_launcher_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_DYNAMIC_LAUNCHER_PROXY, XdpImplDynamicLauncherProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_dynamic_launcher_interface_info ());
}

static void
xdp_impl_dynamic_launcher_proxy_class_init (XdpImplDynamicLauncherProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_dynamic_launcher_proxy_finalize;
  gobject_class->get_property = xdp_impl_dynamic_launcher_proxy_get_property;
  gobject_class->set_property = xdp_impl_dynamic_launcher_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_dynamic_launcher_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_dynamic_launcher_proxy_g_properties_changed;

  xdp_impl_dynamic_launcher_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplDynamicLauncherProxyPrivate));
#endif
}

static void
xdp_impl_dynamic_launcher_proxy_iface_init (XdpImplDynamicLauncherIface *iface)
{
  iface->get_supported_launcher_types = xdp_impl_dynamic_launcher_proxy_get_supported_launcher_types;
  iface->get_version = xdp_impl_dynamic_launcher_proxy_get_version;
}

/**
 * xdp_impl_dynamic_launcher_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_dynamic_launcher_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_dynamic_launcher_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_dynamic_launcher_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_DYNAMIC_LAUNCHER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.DynamicLauncher", NULL);
}

/**
 * xdp_impl_dynamic_launcher_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_dynamic_launcher_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_dynamic_launcher_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplDynamicLauncherProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplDynamicLauncher *
xdp_impl_dynamic_launcher_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_DYNAMIC_LAUNCHER (ret);
  else
    return NULL;
}

/**
 * xdp_impl_dynamic_launcher_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_dynamic_launcher_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplDynamicLauncherProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplDynamicLauncher *
xdp_impl_dynamic_launcher_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_DYNAMIC_LAUNCHER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.DynamicLauncher", NULL);
  if (ret != NULL)
    return XDP_IMPL_DYNAMIC_LAUNCHER (ret);
  else
    return NULL;
}


/**
 * xdp_impl_dynamic_launcher_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_dynamic_launcher_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_dynamic_launcher_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_dynamic_launcher_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_dynamic_launcher_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_DYNAMIC_LAUNCHER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.DynamicLauncher", NULL);
}

/**
 * xdp_impl_dynamic_launcher_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_dynamic_launcher_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_dynamic_launcher_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplDynamicLauncherProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplDynamicLauncher *
xdp_impl_dynamic_launcher_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_DYNAMIC_LAUNCHER (ret);
  else
    return NULL;
}

/**
 * xdp_impl_dynamic_launcher_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_dynamic_launcher_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_dynamic_launcher_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplDynamicLauncherProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplDynamicLauncher *
xdp_impl_dynamic_launcher_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_DYNAMIC_LAUNCHER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.DynamicLauncher", NULL);
  if (ret != NULL)
    return XDP_IMPL_DYNAMIC_LAUNCHER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplDynamicLauncherSkeleton:
 *
 * The #XdpImplDynamicLauncherSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplDynamicLauncherSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplDynamicLauncherSkeleton.
 */

struct _XdpImplDynamicLauncherSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_dynamic_launcher_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplDynamicLauncherSkeleton *skeleton = XDP_IMPL_DYNAMIC_LAUNCHER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_DYNAMIC_LAUNCHER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_DYNAMIC_LAUNCHER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_dynamic_launcher_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplDynamicLauncherSkeleton *skeleton = XDP_IMPL_DYNAMIC_LAUNCHER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_dynamic_launcher_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_dynamic_launcher_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplDynamicLauncherSkeleton *skeleton = XDP_IMPL_DYNAMIC_LAUNCHER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_dynamic_launcher_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_dynamic_launcher_skeleton_vtable =
{
  _xdp_impl_dynamic_launcher_skeleton_handle_method_call,
  _xdp_impl_dynamic_launcher_skeleton_handle_get_property,
  _xdp_impl_dynamic_launcher_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_dynamic_launcher_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_dynamic_launcher_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_dynamic_launcher_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_dynamic_launcher_skeleton_vtable;
}

static GVariant *
xdp_impl_dynamic_launcher_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplDynamicLauncherSkeleton *skeleton = XDP_IMPL_DYNAMIC_LAUNCHER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_dynamic_launcher_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_dynamic_launcher_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_dynamic_launcher_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_dynamic_launcher_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.DynamicLauncher", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_impl_dynamic_launcher_emit_changed (gpointer user_data);

static void
xdp_impl_dynamic_launcher_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplDynamicLauncherSkeleton *skeleton = XDP_IMPL_DYNAMIC_LAUNCHER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_impl_dynamic_launcher_emit_changed (skeleton);
}

static void xdp_impl_dynamic_launcher_skeleton_iface_init (XdpImplDynamicLauncherIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplDynamicLauncherSkeleton, xdp_impl_dynamic_launcher_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplDynamicLauncherSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_DYNAMIC_LAUNCHER, xdp_impl_dynamic_launcher_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplDynamicLauncherSkeleton, xdp_impl_dynamic_launcher_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_DYNAMIC_LAUNCHER, xdp_impl_dynamic_launcher_skeleton_iface_init))

#endif
static void
xdp_impl_dynamic_launcher_skeleton_finalize (GObject *object)
{
  XdpImplDynamicLauncherSkeleton *skeleton = XDP_IMPL_DYNAMIC_LAUNCHER_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_dynamic_launcher_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_dynamic_launcher_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpImplDynamicLauncherSkeleton *skeleton = XDP_IMPL_DYNAMIC_LAUNCHER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_impl_dynamic_launcher_emit_changed (gpointer user_data)
{
  XdpImplDynamicLauncherSkeleton *skeleton = XDP_IMPL_DYNAMIC_LAUNCHER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.DynamicLauncher",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_impl_dynamic_launcher_schedule_emit_changed (XdpImplDynamicLauncherSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_impl_dynamic_launcher_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpImplDynamicLauncherSkeleton *skeleton = XDP_IMPL_DYNAMIC_LAUNCHER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_impl_dynamic_launcher_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_impl_dynamic_launcher_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_impl_dynamic_launcher_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpImplDynamicLauncherSkeleton *skeleton = XDP_IMPL_DYNAMIC_LAUNCHER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_dynamic_launcher_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_impl_dynamic_launcher_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_impl_dynamic_launcher_skeleton_init (XdpImplDynamicLauncherSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_dynamic_launcher_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_DYNAMIC_LAUNCHER_SKELETON, XdpImplDynamicLauncherSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
}

static guint 
xdp_impl_dynamic_launcher_skeleton_get_supported_launcher_types (XdpImplDynamicLauncher *object)
{
  XdpImplDynamicLauncherSkeleton *skeleton = XDP_IMPL_DYNAMIC_LAUNCHER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
xdp_impl_dynamic_launcher_skeleton_get_version (XdpImplDynamicLauncher *object)
{
  XdpImplDynamicLauncherSkeleton *skeleton = XDP_IMPL_DYNAMIC_LAUNCHER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_impl_dynamic_launcher_skeleton_class_init (XdpImplDynamicLauncherSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_dynamic_launcher_skeleton_finalize;
  gobject_class->get_property = xdp_impl_dynamic_launcher_skeleton_get_property;
  gobject_class->set_property = xdp_impl_dynamic_launcher_skeleton_set_property;
  gobject_class->notify       = xdp_impl_dynamic_launcher_skeleton_notify;


  xdp_impl_dynamic_launcher_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_dynamic_launcher_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_dynamic_launcher_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_dynamic_launcher_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_dynamic_launcher_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplDynamicLauncherSkeletonPrivate));
#endif
}

static void
xdp_impl_dynamic_launcher_skeleton_iface_init (XdpImplDynamicLauncherIface *iface)
{
  iface->get_supported_launcher_types = xdp_impl_dynamic_launcher_skeleton_get_supported_launcher_types;
  iface->get_version = xdp_impl_dynamic_launcher_skeleton_get_version;
}

/**
 * xdp_impl_dynamic_launcher_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link>.
 *
 * Returns: (transfer full) (type XdpImplDynamicLauncherSkeleton): The skeleton object.
 */
XdpImplDynamicLauncher *
xdp_impl_dynamic_launcher_skeleton_new (void)
{
  return XDP_IMPL_DYNAMIC_LAUNCHER (g_object_new (XDP_IMPL_TYPE_DYNAMIC_LAUNCHER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Email
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplEmail
 * @title: XdpImplEmail
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Email D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Email ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_email_method_info_compose_email_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_email_method_info_compose_email_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_email_method_info_compose_email_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_email_method_info_compose_email_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_email_method_info_compose_email_IN_ARG_pointers[] =
{
  &_xdp_impl_email_method_info_compose_email_IN_ARG_handle.parent_struct,
  &_xdp_impl_email_method_info_compose_email_IN_ARG_app_id.parent_struct,
  &_xdp_impl_email_method_info_compose_email_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_email_method_info_compose_email_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_email_method_info_compose_email_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_email_method_info_compose_email_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_email_method_info_compose_email_OUT_ARG_pointers[] =
{
  &_xdp_impl_email_method_info_compose_email_OUT_ARG_response.parent_struct,
  &_xdp_impl_email_method_info_compose_email_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_email_method_compose_email_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_email_method_compose_email_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_email_method_compose_email_annotation_info_pointers[] =
{
  &_xdp_impl_email_method_compose_email_annotation_info_0,
  &_xdp_impl_email_method_compose_email_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_email_method_info_compose_email =
{
  {
    -1,
    (gchar *) "ComposeEmail",
    (GDBusArgInfo **) &_xdp_impl_email_method_info_compose_email_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_email_method_info_compose_email_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_email_method_compose_email_annotation_info_pointers
  },
  "handle-compose-email",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_email_method_info_pointers[] =
{
  &_xdp_impl_email_method_info_compose_email.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_email_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Email",
    (GDBusMethodInfo **) &_xdp_impl_email_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "email",
};


/**
 * xdp_impl_email_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_email_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_email_interface_info.parent_struct;
}

/**
 * xdp_impl_email_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplEmail interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_email_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpImplEmail:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link>.
 */

/**
 * XdpImplEmailIface:
 * @parent_iface: The parent interface.
 * @handle_compose_email: Handler for the #XdpImplEmail::handle-compose-email signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link>.
 */

typedef XdpImplEmailIface XdpImplEmailInterface;
G_DEFINE_INTERFACE (XdpImplEmail, xdp_impl_email, G_TYPE_OBJECT)

static void
xdp_impl_email_default_init (XdpImplEmailIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplEmail::handle-compose-email:
   * @object: A #XdpImplEmail.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Email.ComposeEmail">ComposeEmail()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_email_complete_compose_email() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-compose-email",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplEmailIface, handle_compose_email),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_impl_email_call_compose_email:
 * @proxy: A #XdpImplEmailProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Email.ComposeEmail">ComposeEmail()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_email_call_compose_email_finish() to get the result of the operation.
 *
 * See xdp_impl_email_call_compose_email_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_email_call_compose_email (
    XdpImplEmail *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ComposeEmail",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_email_call_compose_email_finish:
 * @proxy: A #XdpImplEmailProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_email_call_compose_email().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_email_call_compose_email().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_email_call_compose_email_finish (
    XdpImplEmail *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_email_call_compose_email_sync:
 * @proxy: A #XdpImplEmailProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Email.ComposeEmail">ComposeEmail()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_email_call_compose_email() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_email_call_compose_email_sync (
    XdpImplEmail *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ComposeEmail",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_email_complete_compose_email:
 * @object: A #XdpImplEmail.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Email.ComposeEmail">ComposeEmail()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_email_complete_compose_email (
    XdpImplEmail *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplEmailProxy:
 *
 * The #XdpImplEmailProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplEmailProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplEmailProxy.
 */

struct _XdpImplEmailProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_email_proxy_iface_init (XdpImplEmailIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplEmailProxy, xdp_impl_email_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplEmailProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_EMAIL, xdp_impl_email_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplEmailProxy, xdp_impl_email_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_EMAIL, xdp_impl_email_proxy_iface_init))

#endif
static void
xdp_impl_email_proxy_finalize (GObject *object)
{
  XdpImplEmailProxy *proxy = XDP_IMPL_EMAIL_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_email_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_email_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_email_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_email_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_email_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_EMAIL);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_EMAIL);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_email_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplEmailProxy *proxy = XDP_IMPL_EMAIL_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_email_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_email_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_email_proxy_init (XdpImplEmailProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_email_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_EMAIL_PROXY, XdpImplEmailProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_email_interface_info ());
}

static void
xdp_impl_email_proxy_class_init (XdpImplEmailProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_email_proxy_finalize;
  gobject_class->get_property = xdp_impl_email_proxy_get_property;
  gobject_class->set_property = xdp_impl_email_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_email_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_email_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplEmailProxyPrivate));
#endif
}

static void
xdp_impl_email_proxy_iface_init (XdpImplEmailIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_email_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_email_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_email_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_email_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_EMAIL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Email", NULL);
}

/**
 * xdp_impl_email_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_email_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_email_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplEmailProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplEmail *
xdp_impl_email_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_EMAIL (ret);
  else
    return NULL;
}

/**
 * xdp_impl_email_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_email_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplEmailProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplEmail *
xdp_impl_email_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_EMAIL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Email", NULL);
  if (ret != NULL)
    return XDP_IMPL_EMAIL (ret);
  else
    return NULL;
}


/**
 * xdp_impl_email_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_email_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_email_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_email_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_email_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_EMAIL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Email", NULL);
}

/**
 * xdp_impl_email_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_email_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_email_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplEmailProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplEmail *
xdp_impl_email_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_EMAIL (ret);
  else
    return NULL;
}

/**
 * xdp_impl_email_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_email_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_email_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplEmailProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplEmail *
xdp_impl_email_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_EMAIL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Email", NULL);
  if (ret != NULL)
    return XDP_IMPL_EMAIL (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplEmailSkeleton:
 *
 * The #XdpImplEmailSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplEmailSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplEmailSkeleton.
 */

struct _XdpImplEmailSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_email_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplEmailSkeleton *skeleton = XDP_IMPL_EMAIL_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_EMAIL);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_EMAIL);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_email_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplEmailSkeleton *skeleton = XDP_IMPL_EMAIL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_email_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_email_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplEmailSkeleton *skeleton = XDP_IMPL_EMAIL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_email_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_email_skeleton_vtable =
{
  _xdp_impl_email_skeleton_handle_method_call,
  _xdp_impl_email_skeleton_handle_get_property,
  _xdp_impl_email_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_email_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_email_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_email_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_email_skeleton_vtable;
}

static GVariant *
xdp_impl_email_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplEmailSkeleton *skeleton = XDP_IMPL_EMAIL_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_email_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_email_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_email_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_email_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Email", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_email_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_impl_email_skeleton_iface_init (XdpImplEmailIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplEmailSkeleton, xdp_impl_email_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplEmailSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_EMAIL, xdp_impl_email_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplEmailSkeleton, xdp_impl_email_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_EMAIL, xdp_impl_email_skeleton_iface_init))

#endif
static void
xdp_impl_email_skeleton_finalize (GObject *object)
{
  XdpImplEmailSkeleton *skeleton = XDP_IMPL_EMAIL_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_email_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_email_skeleton_init (XdpImplEmailSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_email_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_EMAIL_SKELETON, XdpImplEmailSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_email_skeleton_class_init (XdpImplEmailSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_email_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_email_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_email_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_email_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_email_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplEmailSkeletonPrivate));
#endif
}

static void
xdp_impl_email_skeleton_iface_init (XdpImplEmailIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_email_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link>.
 *
 * Returns: (transfer full) (type XdpImplEmailSkeleton): The skeleton object.
 */
XdpImplEmail *
xdp_impl_email_skeleton_new (void)
{
  return XDP_IMPL_EMAIL (g_object_new (XDP_IMPL_TYPE_EMAIL_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.FileChooser
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplFileChooser
 * @title: XdpImplFileChooser
 * @short_description: Generated C code for the org.freedesktop.impl.portal.FileChooser D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.FileChooser ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_open_file_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_open_file_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_open_file_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_open_file_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_open_file_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_file_chooser_method_info_open_file_IN_ARG_pointers[] =
{
  &_xdp_impl_file_chooser_method_info_open_file_IN_ARG_handle.parent_struct,
  &_xdp_impl_file_chooser_method_info_open_file_IN_ARG_app_id.parent_struct,
  &_xdp_impl_file_chooser_method_info_open_file_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_file_chooser_method_info_open_file_IN_ARG_title.parent_struct,
  &_xdp_impl_file_chooser_method_info_open_file_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_open_file_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_open_file_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_file_chooser_method_info_open_file_OUT_ARG_pointers[] =
{
  &_xdp_impl_file_chooser_method_info_open_file_OUT_ARG_response.parent_struct,
  &_xdp_impl_file_chooser_method_info_open_file_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_file_chooser_method_open_file_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_file_chooser_method_open_file_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_file_chooser_method_open_file_annotation_info_pointers[] =
{
  &_xdp_impl_file_chooser_method_open_file_annotation_info_0,
  &_xdp_impl_file_chooser_method_open_file_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_file_chooser_method_info_open_file =
{
  {
    -1,
    (gchar *) "OpenFile",
    (GDBusArgInfo **) &_xdp_impl_file_chooser_method_info_open_file_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_file_chooser_method_info_open_file_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_file_chooser_method_open_file_annotation_info_pointers
  },
  "handle-open-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_file_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_file_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_file_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_file_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_file_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_file_chooser_method_info_save_file_IN_ARG_pointers[] =
{
  &_xdp_impl_file_chooser_method_info_save_file_IN_ARG_handle.parent_struct,
  &_xdp_impl_file_chooser_method_info_save_file_IN_ARG_app_id.parent_struct,
  &_xdp_impl_file_chooser_method_info_save_file_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_file_chooser_method_info_save_file_IN_ARG_title.parent_struct,
  &_xdp_impl_file_chooser_method_info_save_file_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_file_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_file_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_file_chooser_method_info_save_file_OUT_ARG_pointers[] =
{
  &_xdp_impl_file_chooser_method_info_save_file_OUT_ARG_response.parent_struct,
  &_xdp_impl_file_chooser_method_info_save_file_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_file_chooser_method_save_file_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_file_chooser_method_save_file_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_file_chooser_method_save_file_annotation_info_pointers[] =
{
  &_xdp_impl_file_chooser_method_save_file_annotation_info_0,
  &_xdp_impl_file_chooser_method_save_file_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_file_chooser_method_info_save_file =
{
  {
    -1,
    (gchar *) "SaveFile",
    (GDBusArgInfo **) &_xdp_impl_file_chooser_method_info_save_file_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_file_chooser_method_info_save_file_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_file_chooser_method_save_file_annotation_info_pointers
  },
  "handle-save-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_files_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_files_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_files_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_files_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_files_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_file_chooser_method_info_save_files_IN_ARG_pointers[] =
{
  &_xdp_impl_file_chooser_method_info_save_files_IN_ARG_handle.parent_struct,
  &_xdp_impl_file_chooser_method_info_save_files_IN_ARG_app_id.parent_struct,
  &_xdp_impl_file_chooser_method_info_save_files_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_file_chooser_method_info_save_files_IN_ARG_title.parent_struct,
  &_xdp_impl_file_chooser_method_info_save_files_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_files_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_file_chooser_method_info_save_files_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_file_chooser_method_info_save_files_OUT_ARG_pointers[] =
{
  &_xdp_impl_file_chooser_method_info_save_files_OUT_ARG_response.parent_struct,
  &_xdp_impl_file_chooser_method_info_save_files_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_file_chooser_method_save_files_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_file_chooser_method_save_files_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_file_chooser_method_save_files_annotation_info_pointers[] =
{
  &_xdp_impl_file_chooser_method_save_files_annotation_info_0,
  &_xdp_impl_file_chooser_method_save_files_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_file_chooser_method_info_save_files =
{
  {
    -1,
    (gchar *) "SaveFiles",
    (GDBusArgInfo **) &_xdp_impl_file_chooser_method_info_save_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_file_chooser_method_info_save_files_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_file_chooser_method_save_files_annotation_info_pointers
  },
  "handle-save-files",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_file_chooser_method_info_pointers[] =
{
  &_xdp_impl_file_chooser_method_info_open_file.parent_struct,
  &_xdp_impl_file_chooser_method_info_save_file.parent_struct,
  &_xdp_impl_file_chooser_method_info_save_files.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_file_chooser_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.FileChooser",
    (GDBusMethodInfo **) &_xdp_impl_file_chooser_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "file-chooser",
};


/**
 * xdp_impl_file_chooser_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_file_chooser_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_file_chooser_interface_info.parent_struct;
}

/**
 * xdp_impl_file_chooser_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplFileChooser interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_file_chooser_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpImplFileChooser:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>.
 */

/**
 * XdpImplFileChooserIface:
 * @parent_iface: The parent interface.
 * @handle_open_file: Handler for the #XdpImplFileChooser::handle-open-file signal.
 * @handle_save_file: Handler for the #XdpImplFileChooser::handle-save-file signal.
 * @handle_save_files: Handler for the #XdpImplFileChooser::handle-save-files signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>.
 */

typedef XdpImplFileChooserIface XdpImplFileChooserInterface;
G_DEFINE_INTERFACE (XdpImplFileChooser, xdp_impl_file_chooser, G_TYPE_OBJECT)

static void
xdp_impl_file_chooser_default_init (XdpImplFileChooserIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplFileChooser::handle-open-file:
   * @object: A #XdpImplFileChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_file_chooser_complete_open_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplFileChooserIface, handle_open_file),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpImplFileChooser::handle-save-file:
   * @object: A #XdpImplFileChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_file_chooser_complete_save_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-save-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplFileChooserIface, handle_save_file),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpImplFileChooser::handle-save-files:
   * @object: A #XdpImplFileChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_file_chooser_complete_save_files() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-save-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplFileChooserIface, handle_save_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_impl_file_chooser_call_open_file:
 * @proxy: A #XdpImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_file_chooser_call_open_file_finish() to get the result of the operation.
 *
 * See xdp_impl_file_chooser_call_open_file_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_file_chooser_call_open_file (
    XdpImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenFile",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_file_chooser_call_open_file_finish:
 * @proxy: A #XdpImplFileChooserProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_file_chooser_call_open_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_file_chooser_call_open_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_file_chooser_call_open_file_finish (
    XdpImplFileChooser *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_file_chooser_call_open_file_sync:
 * @proxy: A #XdpImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_file_chooser_call_open_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_file_chooser_call_open_file_sync (
    XdpImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenFile",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_file_chooser_call_save_file:
 * @proxy: A #XdpImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_file_chooser_call_save_file_finish() to get the result of the operation.
 *
 * See xdp_impl_file_chooser_call_save_file_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_file_chooser_call_save_file (
    XdpImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SaveFile",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_file_chooser_call_save_file_finish:
 * @proxy: A #XdpImplFileChooserProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_file_chooser_call_save_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_file_chooser_call_save_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_file_chooser_call_save_file_finish (
    XdpImplFileChooser *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_file_chooser_call_save_file_sync:
 * @proxy: A #XdpImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_file_chooser_call_save_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_file_chooser_call_save_file_sync (
    XdpImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SaveFile",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_file_chooser_call_save_files:
 * @proxy: A #XdpImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_file_chooser_call_save_files_finish() to get the result of the operation.
 *
 * See xdp_impl_file_chooser_call_save_files_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_file_chooser_call_save_files (
    XdpImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SaveFiles",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_file_chooser_call_save_files_finish:
 * @proxy: A #XdpImplFileChooserProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_file_chooser_call_save_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_file_chooser_call_save_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_file_chooser_call_save_files_finish (
    XdpImplFileChooser *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_file_chooser_call_save_files_sync:
 * @proxy: A #XdpImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_file_chooser_call_save_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_file_chooser_call_save_files_sync (
    XdpImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SaveFiles",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_file_chooser_complete_open_file:
 * @object: A #XdpImplFileChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_file_chooser_complete_open_file (
    XdpImplFileChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_file_chooser_complete_save_file:
 * @object: A #XdpImplFileChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_file_chooser_complete_save_file (
    XdpImplFileChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_file_chooser_complete_save_files:
 * @object: A #XdpImplFileChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_file_chooser_complete_save_files (
    XdpImplFileChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplFileChooserProxy:
 *
 * The #XdpImplFileChooserProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplFileChooserProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplFileChooserProxy.
 */

struct _XdpImplFileChooserProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_file_chooser_proxy_iface_init (XdpImplFileChooserIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplFileChooserProxy, xdp_impl_file_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplFileChooserProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_FILE_CHOOSER, xdp_impl_file_chooser_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplFileChooserProxy, xdp_impl_file_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_FILE_CHOOSER, xdp_impl_file_chooser_proxy_iface_init))

#endif
static void
xdp_impl_file_chooser_proxy_finalize (GObject *object)
{
  XdpImplFileChooserProxy *proxy = XDP_IMPL_FILE_CHOOSER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_file_chooser_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_file_chooser_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_file_chooser_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_file_chooser_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_file_chooser_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_FILE_CHOOSER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_FILE_CHOOSER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_file_chooser_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplFileChooserProxy *proxy = XDP_IMPL_FILE_CHOOSER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_file_chooser_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_file_chooser_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_file_chooser_proxy_init (XdpImplFileChooserProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_file_chooser_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_FILE_CHOOSER_PROXY, XdpImplFileChooserProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_file_chooser_interface_info ());
}

static void
xdp_impl_file_chooser_proxy_class_init (XdpImplFileChooserProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_file_chooser_proxy_finalize;
  gobject_class->get_property = xdp_impl_file_chooser_proxy_get_property;
  gobject_class->set_property = xdp_impl_file_chooser_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_file_chooser_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_file_chooser_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplFileChooserProxyPrivate));
#endif
}

static void
xdp_impl_file_chooser_proxy_iface_init (XdpImplFileChooserIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_file_chooser_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_file_chooser_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_file_chooser_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_file_chooser_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_FILE_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.FileChooser", NULL);
}

/**
 * xdp_impl_file_chooser_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_file_chooser_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_file_chooser_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplFileChooser *
xdp_impl_file_chooser_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_FILE_CHOOSER (ret);
  else
    return NULL;
}

/**
 * xdp_impl_file_chooser_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_file_chooser_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplFileChooser *
xdp_impl_file_chooser_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_FILE_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.FileChooser", NULL);
  if (ret != NULL)
    return XDP_IMPL_FILE_CHOOSER (ret);
  else
    return NULL;
}


/**
 * xdp_impl_file_chooser_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_file_chooser_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_file_chooser_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_file_chooser_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_file_chooser_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_FILE_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.FileChooser", NULL);
}

/**
 * xdp_impl_file_chooser_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_file_chooser_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_file_chooser_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplFileChooser *
xdp_impl_file_chooser_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_FILE_CHOOSER (ret);
  else
    return NULL;
}

/**
 * xdp_impl_file_chooser_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_file_chooser_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_file_chooser_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplFileChooser *
xdp_impl_file_chooser_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_FILE_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.FileChooser", NULL);
  if (ret != NULL)
    return XDP_IMPL_FILE_CHOOSER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplFileChooserSkeleton:
 *
 * The #XdpImplFileChooserSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplFileChooserSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplFileChooserSkeleton.
 */

struct _XdpImplFileChooserSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_file_chooser_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplFileChooserSkeleton *skeleton = XDP_IMPL_FILE_CHOOSER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_FILE_CHOOSER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_FILE_CHOOSER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_file_chooser_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplFileChooserSkeleton *skeleton = XDP_IMPL_FILE_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_file_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_file_chooser_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplFileChooserSkeleton *skeleton = XDP_IMPL_FILE_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_file_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_file_chooser_skeleton_vtable =
{
  _xdp_impl_file_chooser_skeleton_handle_method_call,
  _xdp_impl_file_chooser_skeleton_handle_get_property,
  _xdp_impl_file_chooser_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_file_chooser_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_file_chooser_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_file_chooser_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_file_chooser_skeleton_vtable;
}

static GVariant *
xdp_impl_file_chooser_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplFileChooserSkeleton *skeleton = XDP_IMPL_FILE_CHOOSER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_file_chooser_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_file_chooser_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_file_chooser_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_file_chooser_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.FileChooser", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_file_chooser_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_impl_file_chooser_skeleton_iface_init (XdpImplFileChooserIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplFileChooserSkeleton, xdp_impl_file_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplFileChooserSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_FILE_CHOOSER, xdp_impl_file_chooser_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplFileChooserSkeleton, xdp_impl_file_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_FILE_CHOOSER, xdp_impl_file_chooser_skeleton_iface_init))

#endif
static void
xdp_impl_file_chooser_skeleton_finalize (GObject *object)
{
  XdpImplFileChooserSkeleton *skeleton = XDP_IMPL_FILE_CHOOSER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_file_chooser_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_file_chooser_skeleton_init (XdpImplFileChooserSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_file_chooser_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_FILE_CHOOSER_SKELETON, XdpImplFileChooserSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_file_chooser_skeleton_class_init (XdpImplFileChooserSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_file_chooser_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_file_chooser_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_file_chooser_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_file_chooser_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_file_chooser_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplFileChooserSkeletonPrivate));
#endif
}

static void
xdp_impl_file_chooser_skeleton_iface_init (XdpImplFileChooserIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_file_chooser_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>.
 *
 * Returns: (transfer full) (type XdpImplFileChooserSkeleton): The skeleton object.
 */
XdpImplFileChooser *
xdp_impl_file_chooser_skeleton_new (void)
{
  return XDP_IMPL_FILE_CHOOSER (g_object_new (XDP_IMPL_TYPE_FILE_CHOOSER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Inhibit
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplInhibit
 * @title: XdpImplInhibit
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Inhibit D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Inhibit ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_inhibit_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_inhibit_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_inhibit_IN_ARG_window =
{
  {
    -1,
    (gchar *) "window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_inhibit_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_inhibit_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_inhibit_method_info_inhibit_IN_ARG_pointers[] =
{
  &_xdp_impl_inhibit_method_info_inhibit_IN_ARG_handle.parent_struct,
  &_xdp_impl_inhibit_method_info_inhibit_IN_ARG_app_id.parent_struct,
  &_xdp_impl_inhibit_method_info_inhibit_IN_ARG_window.parent_struct,
  &_xdp_impl_inhibit_method_info_inhibit_IN_ARG_flags.parent_struct,
  &_xdp_impl_inhibit_method_info_inhibit_IN_ARG_options.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_inhibit_method_inhibit_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_inhibit_method_inhibit_annotation_info_pointers[] =
{
  &_xdp_impl_inhibit_method_inhibit_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_inhibit_method_info_inhibit =
{
  {
    -1,
    (gchar *) "Inhibit",
    (GDBusArgInfo **) &_xdp_impl_inhibit_method_info_inhibit_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_xdp_impl_inhibit_method_inhibit_annotation_info_pointers
  },
  "handle-inhibit",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_create_monitor_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_create_monitor_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_create_monitor_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_create_monitor_IN_ARG_window =
{
  {
    -1,
    (gchar *) "window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_inhibit_method_info_create_monitor_IN_ARG_pointers[] =
{
  &_xdp_impl_inhibit_method_info_create_monitor_IN_ARG_handle.parent_struct,
  &_xdp_impl_inhibit_method_info_create_monitor_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_inhibit_method_info_create_monitor_IN_ARG_app_id.parent_struct,
  &_xdp_impl_inhibit_method_info_create_monitor_IN_ARG_window.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_create_monitor_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_inhibit_method_info_create_monitor_OUT_ARG_pointers[] =
{
  &_xdp_impl_inhibit_method_info_create_monitor_OUT_ARG_response.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_inhibit_method_info_create_monitor =
{
  {
    -1,
    (gchar *) "CreateMonitor",
    (GDBusArgInfo **) &_xdp_impl_inhibit_method_info_create_monitor_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_inhibit_method_info_create_monitor_OUT_ARG_pointers,
    NULL
  },
  "handle-create-monitor",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_method_info_query_end_response_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_inhibit_method_info_query_end_response_IN_ARG_pointers[] =
{
  &_xdp_impl_inhibit_method_info_query_end_response_IN_ARG_session_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_inhibit_method_info_query_end_response =
{
  {
    -1,
    (gchar *) "QueryEndResponse",
    (GDBusArgInfo **) &_xdp_impl_inhibit_method_info_query_end_response_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-query-end-response",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_inhibit_method_info_pointers[] =
{
  &_xdp_impl_inhibit_method_info_inhibit.parent_struct,
  &_xdp_impl_inhibit_method_info_create_monitor.parent_struct,
  &_xdp_impl_inhibit_method_info_query_end_response.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_signal_info_state_changed_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_inhibit_signal_info_state_changed_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_inhibit_signal_info_state_changed_ARG_pointers[] =
{
  &_xdp_impl_inhibit_signal_info_state_changed_ARG_session_handle.parent_struct,
  &_xdp_impl_inhibit_signal_info_state_changed_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_impl_inhibit_signal_info_state_changed =
{
  {
    -1,
    (gchar *) "StateChanged",
    (GDBusArgInfo **) &_xdp_impl_inhibit_signal_info_state_changed_ARG_pointers,
    NULL
  },
  "state-changed"
};

static const GDBusSignalInfo * const _xdp_impl_inhibit_signal_info_pointers[] =
{
  &_xdp_impl_inhibit_signal_info_state_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_inhibit_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Inhibit",
    (GDBusMethodInfo **) &_xdp_impl_inhibit_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_impl_inhibit_signal_info_pointers,
    NULL,
    NULL
  },
  "inhibit",
};


/**
 * xdp_impl_inhibit_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_inhibit_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_inhibit_interface_info.parent_struct;
}

/**
 * xdp_impl_inhibit_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplInhibit interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_inhibit_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpImplInhibit:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>.
 */

/**
 * XdpImplInhibitIface:
 * @parent_iface: The parent interface.
 * @handle_create_monitor: Handler for the #XdpImplInhibit::handle-create-monitor signal.
 * @handle_inhibit: Handler for the #XdpImplInhibit::handle-inhibit signal.
 * @handle_query_end_response: Handler for the #XdpImplInhibit::handle-query-end-response signal.
 * @state_changed: Handler for the #XdpImplInhibit::state-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>.
 */

typedef XdpImplInhibitIface XdpImplInhibitInterface;
G_DEFINE_INTERFACE (XdpImplInhibit, xdp_impl_inhibit, G_TYPE_OBJECT)

static void
xdp_impl_inhibit_default_init (XdpImplInhibitIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplInhibit::handle-inhibit:
   * @object: A #XdpImplInhibit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_window: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_inhibit_complete_inhibit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-inhibit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplInhibitIface, handle_inhibit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_VARIANT);

  /**
   * XdpImplInhibit::handle-create-monitor:
   * @object: A #XdpImplInhibit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_window: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_inhibit_complete_create_monitor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-monitor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplInhibitIface, handle_create_monitor),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpImplInhibit::handle-query-end-response:
   * @object: A #XdpImplInhibit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_inhibit_complete_query_end_response() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-query-end-response",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplInhibitIface, handle_query_end_response),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpImplInhibit::state-changed:
   * @object: A #XdpImplInhibit.
   * @arg_session_handle: Argument.
   * @arg_state: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Inhibit.StateChanged">"StateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("state-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplInhibitIface, state_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_impl_inhibit_emit_state_changed:
 * @object: A #XdpImplInhibit.
 * @arg_session_handle: Argument to pass with the signal.
 * @arg_state: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Inhibit.StateChanged">"StateChanged"</link> D-Bus signal.
 */
void
xdp_impl_inhibit_emit_state_changed (
    XdpImplInhibit *object,
    const gchar *arg_session_handle,
    GVariant *arg_state)
{
  g_signal_emit_by_name (object, "state-changed", arg_session_handle, arg_state);
}

/**
 * xdp_impl_inhibit_call_inhibit:
 * @proxy: A #XdpImplInhibitProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_inhibit_call_inhibit_finish() to get the result of the operation.
 *
 * See xdp_impl_inhibit_call_inhibit_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_inhibit_call_inhibit (
    XdpImplInhibit *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    guint arg_flags,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(ossu@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_window,
                   arg_flags,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_inhibit_call_inhibit_finish:
 * @proxy: A #XdpImplInhibitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_inhibit_call_inhibit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_inhibit_call_inhibit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_inhibit_call_inhibit_finish (
    XdpImplInhibit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_inhibit_call_inhibit_sync:
 * @proxy: A #XdpImplInhibitProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_inhibit_call_inhibit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_inhibit_call_inhibit_sync (
    XdpImplInhibit *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    guint arg_flags,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(ossu@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_window,
                   arg_flags,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_inhibit_call_create_monitor:
 * @proxy: A #XdpImplInhibitProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_inhibit_call_create_monitor_finish() to get the result of the operation.
 *
 * See xdp_impl_inhibit_call_create_monitor_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_inhibit_call_create_monitor (
    XdpImplInhibit *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateMonitor",
    g_variant_new ("(ooss)",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_window),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_inhibit_call_create_monitor_finish:
 * @proxy: A #XdpImplInhibitProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_inhibit_call_create_monitor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_inhibit_call_create_monitor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_inhibit_call_create_monitor_finish (
    XdpImplInhibit *proxy,
    guint *out_response,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_inhibit_call_create_monitor_sync:
 * @proxy: A #XdpImplInhibitProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_inhibit_call_create_monitor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_inhibit_call_create_monitor_sync (
    XdpImplInhibit *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    guint *out_response,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateMonitor",
    g_variant_new ("(ooss)",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_window),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_inhibit_call_query_end_response:
 * @proxy: A #XdpImplInhibitProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_inhibit_call_query_end_response_finish() to get the result of the operation.
 *
 * See xdp_impl_inhibit_call_query_end_response_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_inhibit_call_query_end_response (
    XdpImplInhibit *proxy,
    const gchar *arg_session_handle,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "QueryEndResponse",
    g_variant_new ("(o)",
                   arg_session_handle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_inhibit_call_query_end_response_finish:
 * @proxy: A #XdpImplInhibitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_inhibit_call_query_end_response().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_inhibit_call_query_end_response().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_inhibit_call_query_end_response_finish (
    XdpImplInhibit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_inhibit_call_query_end_response_sync:
 * @proxy: A #XdpImplInhibitProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_inhibit_call_query_end_response() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_inhibit_call_query_end_response_sync (
    XdpImplInhibit *proxy,
    const gchar *arg_session_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "QueryEndResponse",
    g_variant_new ("(o)",
                   arg_session_handle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_inhibit_complete_inhibit:
 * @object: A #XdpImplInhibit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_inhibit_complete_inhibit (
    XdpImplInhibit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_inhibit_complete_create_monitor:
 * @object: A #XdpImplInhibit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_inhibit_complete_create_monitor (
    XdpImplInhibit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   response));
}

/**
 * xdp_impl_inhibit_complete_query_end_response:
 * @object: A #XdpImplInhibit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_inhibit_complete_query_end_response (
    XdpImplInhibit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplInhibitProxy:
 *
 * The #XdpImplInhibitProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplInhibitProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplInhibitProxy.
 */

struct _XdpImplInhibitProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_inhibit_proxy_iface_init (XdpImplInhibitIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplInhibitProxy, xdp_impl_inhibit_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplInhibitProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_INHIBIT, xdp_impl_inhibit_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplInhibitProxy, xdp_impl_inhibit_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_INHIBIT, xdp_impl_inhibit_proxy_iface_init))

#endif
static void
xdp_impl_inhibit_proxy_finalize (GObject *object)
{
  XdpImplInhibitProxy *proxy = XDP_IMPL_INHIBIT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_inhibit_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_inhibit_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_inhibit_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_inhibit_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_inhibit_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_INHIBIT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_INHIBIT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_inhibit_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplInhibitProxy *proxy = XDP_IMPL_INHIBIT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_inhibit_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_inhibit_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_inhibit_proxy_init (XdpImplInhibitProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_inhibit_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_INHIBIT_PROXY, XdpImplInhibitProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_inhibit_interface_info ());
}

static void
xdp_impl_inhibit_proxy_class_init (XdpImplInhibitProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_inhibit_proxy_finalize;
  gobject_class->get_property = xdp_impl_inhibit_proxy_get_property;
  gobject_class->set_property = xdp_impl_inhibit_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_inhibit_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_inhibit_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplInhibitProxyPrivate));
#endif
}

static void
xdp_impl_inhibit_proxy_iface_init (XdpImplInhibitIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_inhibit_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_inhibit_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_inhibit_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_inhibit_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_INHIBIT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Inhibit", NULL);
}

/**
 * xdp_impl_inhibit_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_inhibit_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_inhibit_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplInhibit *
xdp_impl_inhibit_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_INHIBIT (ret);
  else
    return NULL;
}

/**
 * xdp_impl_inhibit_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_inhibit_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplInhibit *
xdp_impl_inhibit_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_INHIBIT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Inhibit", NULL);
  if (ret != NULL)
    return XDP_IMPL_INHIBIT (ret);
  else
    return NULL;
}


/**
 * xdp_impl_inhibit_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_inhibit_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_inhibit_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_inhibit_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_inhibit_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_INHIBIT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Inhibit", NULL);
}

/**
 * xdp_impl_inhibit_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_inhibit_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_inhibit_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplInhibit *
xdp_impl_inhibit_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_INHIBIT (ret);
  else
    return NULL;
}

/**
 * xdp_impl_inhibit_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_inhibit_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_inhibit_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplInhibit *
xdp_impl_inhibit_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_INHIBIT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Inhibit", NULL);
  if (ret != NULL)
    return XDP_IMPL_INHIBIT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplInhibitSkeleton:
 *
 * The #XdpImplInhibitSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplInhibitSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplInhibitSkeleton.
 */

struct _XdpImplInhibitSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_inhibit_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplInhibitSkeleton *skeleton = XDP_IMPL_INHIBIT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_INHIBIT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_INHIBIT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_inhibit_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplInhibitSkeleton *skeleton = XDP_IMPL_INHIBIT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_inhibit_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_inhibit_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplInhibitSkeleton *skeleton = XDP_IMPL_INHIBIT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_inhibit_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_inhibit_skeleton_vtable =
{
  _xdp_impl_inhibit_skeleton_handle_method_call,
  _xdp_impl_inhibit_skeleton_handle_get_property,
  _xdp_impl_inhibit_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_inhibit_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_inhibit_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_inhibit_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_inhibit_skeleton_vtable;
}

static GVariant *
xdp_impl_inhibit_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplInhibitSkeleton *skeleton = XDP_IMPL_INHIBIT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_inhibit_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_inhibit_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_inhibit_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_inhibit_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Inhibit", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_inhibit_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_xdp_impl_inhibit_on_signal_state_changed (
    XdpImplInhibit *object,
    const gchar *arg_session_handle,
    GVariant *arg_state)
{
  XdpImplInhibitSkeleton *skeleton = XDP_IMPL_INHIBIT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o@a{sv})",
                   arg_session_handle,
                   arg_state));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Inhibit", "StateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_impl_inhibit_skeleton_iface_init (XdpImplInhibitIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplInhibitSkeleton, xdp_impl_inhibit_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplInhibitSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_INHIBIT, xdp_impl_inhibit_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplInhibitSkeleton, xdp_impl_inhibit_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_INHIBIT, xdp_impl_inhibit_skeleton_iface_init))

#endif
static void
xdp_impl_inhibit_skeleton_finalize (GObject *object)
{
  XdpImplInhibitSkeleton *skeleton = XDP_IMPL_INHIBIT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_inhibit_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_inhibit_skeleton_init (XdpImplInhibitSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_inhibit_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_INHIBIT_SKELETON, XdpImplInhibitSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_inhibit_skeleton_class_init (XdpImplInhibitSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_inhibit_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_inhibit_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_inhibit_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_inhibit_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_inhibit_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplInhibitSkeletonPrivate));
#endif
}

static void
xdp_impl_inhibit_skeleton_iface_init (XdpImplInhibitIface *iface)
{
  iface->state_changed = _xdp_impl_inhibit_on_signal_state_changed;
}

/**
 * xdp_impl_inhibit_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>.
 *
 * Returns: (transfer full) (type XdpImplInhibitSkeleton): The skeleton object.
 */
XdpImplInhibit *
xdp_impl_inhibit_skeleton_new (void)
{
  return XDP_IMPL_INHIBIT (g_object_new (XDP_IMPL_TYPE_INHIBIT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Lockdown
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplLockdown
 * @title: XdpImplLockdown
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Lockdown D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Lockdown ---- */

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_printing =
{
  {
    -1,
    (gchar *) "disable-printing",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-printing",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_save_to_disk =
{
  {
    -1,
    (gchar *) "disable-save-to-disk",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-save-to-disk",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_application_handlers =
{
  {
    -1,
    (gchar *) "disable-application-handlers",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-application-handlers",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_location =
{
  {
    -1,
    (gchar *) "disable-location",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-location",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_camera =
{
  {
    -1,
    (gchar *) "disable-camera",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-camera",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_microphone =
{
  {
    -1,
    (gchar *) "disable-microphone",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-microphone",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_lockdown_property_info_disable_sound_output =
{
  {
    -1,
    (gchar *) "disable-sound-output",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-sound-output",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_impl_lockdown_property_info_pointers[] =
{
  &_xdp_impl_lockdown_property_info_disable_printing.parent_struct,
  &_xdp_impl_lockdown_property_info_disable_save_to_disk.parent_struct,
  &_xdp_impl_lockdown_property_info_disable_application_handlers.parent_struct,
  &_xdp_impl_lockdown_property_info_disable_location.parent_struct,
  &_xdp_impl_lockdown_property_info_disable_camera.parent_struct,
  &_xdp_impl_lockdown_property_info_disable_microphone.parent_struct,
  &_xdp_impl_lockdown_property_info_disable_sound_output.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_lockdown_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Lockdown",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_xdp_impl_lockdown_property_info_pointers,
    NULL
  },
  "lockdown",
};


/**
 * xdp_impl_lockdown_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_lockdown_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_lockdown_interface_info.parent_struct;
}

/**
 * xdp_impl_lockdown_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplLockdown interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_lockdown_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "disable-printing");
  g_object_class_override_property (klass, property_id_begin++, "disable-save-to-disk");
  g_object_class_override_property (klass, property_id_begin++, "disable-application-handlers");
  g_object_class_override_property (klass, property_id_begin++, "disable-location");
  g_object_class_override_property (klass, property_id_begin++, "disable-camera");
  g_object_class_override_property (klass, property_id_begin++, "disable-microphone");
  g_object_class_override_property (klass, property_id_begin++, "disable-sound-output");
  return property_id_begin - 1;
}



/**
 * XdpImplLockdown:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>.
 */

/**
 * XdpImplLockdownIface:
 * @parent_iface: The parent interface.
 * @get_disable_application_handlers: Getter for the #XdpImplLockdown:disable-application-handlers property.
 * @get_disable_camera: Getter for the #XdpImplLockdown:disable-camera property.
 * @get_disable_location: Getter for the #XdpImplLockdown:disable-location property.
 * @get_disable_microphone: Getter for the #XdpImplLockdown:disable-microphone property.
 * @get_disable_printing: Getter for the #XdpImplLockdown:disable-printing property.
 * @get_disable_save_to_disk: Getter for the #XdpImplLockdown:disable-save-to-disk property.
 * @get_disable_sound_output: Getter for the #XdpImplLockdown:disable-sound-output property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>.
 */

typedef XdpImplLockdownIface XdpImplLockdownInterface;
G_DEFINE_INTERFACE (XdpImplLockdown, xdp_impl_lockdown, G_TYPE_OBJECT)

static void
xdp_impl_lockdown_default_init (XdpImplLockdownIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * XdpImplLockdown:disable-printing:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-printing">"disable-printing"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-printing", "disable-printing", "disable-printing", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplLockdown:disable-save-to-disk:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-save-to-disk">"disable-save-to-disk"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-save-to-disk", "disable-save-to-disk", "disable-save-to-disk", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplLockdown:disable-application-handlers:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-application-handlers">"disable-application-handlers"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-application-handlers", "disable-application-handlers", "disable-application-handlers", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplLockdown:disable-location:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-location">"disable-location"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-location", "disable-location", "disable-location", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplLockdown:disable-camera:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-camera">"disable-camera"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-camera", "disable-camera", "disable-camera", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplLockdown:disable-microphone:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-microphone">"disable-microphone"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-microphone", "disable-microphone", "disable-microphone", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplLockdown:disable-sound-output:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-sound-output">"disable-sound-output"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-sound-output", "disable-sound-output", "disable-sound-output", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_impl_lockdown_get_disable_printing: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-printing">"disable-printing"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_printing (XdpImplLockdown *object)
{
  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_printing (object);
}

/**
 * xdp_impl_lockdown_set_disable_printing: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-printing">"disable-printing"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_printing (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-printing", value, NULL);
}

/**
 * xdp_impl_lockdown_get_disable_save_to_disk: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-save-to-disk">"disable-save-to-disk"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_save_to_disk (XdpImplLockdown *object)
{
  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_save_to_disk (object);
}

/**
 * xdp_impl_lockdown_set_disable_save_to_disk: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-save-to-disk">"disable-save-to-disk"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_save_to_disk (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-save-to-disk", value, NULL);
}

/**
 * xdp_impl_lockdown_get_disable_application_handlers: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-application-handlers">"disable-application-handlers"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_application_handlers (XdpImplLockdown *object)
{
  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_application_handlers (object);
}

/**
 * xdp_impl_lockdown_set_disable_application_handlers: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-application-handlers">"disable-application-handlers"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_application_handlers (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-application-handlers", value, NULL);
}

/**
 * xdp_impl_lockdown_get_disable_location: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-location">"disable-location"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_location (XdpImplLockdown *object)
{
  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_location (object);
}

/**
 * xdp_impl_lockdown_set_disable_location: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-location">"disable-location"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_location (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-location", value, NULL);
}

/**
 * xdp_impl_lockdown_get_disable_camera: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-camera">"disable-camera"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_camera (XdpImplLockdown *object)
{
  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_camera (object);
}

/**
 * xdp_impl_lockdown_set_disable_camera: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-camera">"disable-camera"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_camera (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-camera", value, NULL);
}

/**
 * xdp_impl_lockdown_get_disable_microphone: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-microphone">"disable-microphone"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_microphone (XdpImplLockdown *object)
{
  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_microphone (object);
}

/**
 * xdp_impl_lockdown_set_disable_microphone: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-microphone">"disable-microphone"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_microphone (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-microphone", value, NULL);
}

/**
 * xdp_impl_lockdown_get_disable_sound_output: (skip)
 * @object: A #XdpImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-sound-output">"disable-sound-output"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_impl_lockdown_get_disable_sound_output (XdpImplLockdown *object)
{
  return XDP_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_sound_output (object);
}

/**
 * xdp_impl_lockdown_set_disable_sound_output: (skip)
 * @object: A #XdpImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-sound-output">"disable-sound-output"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_impl_lockdown_set_disable_sound_output (XdpImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-sound-output", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplLockdownProxy:
 *
 * The #XdpImplLockdownProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplLockdownProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplLockdownProxy.
 */

struct _XdpImplLockdownProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_lockdown_proxy_iface_init (XdpImplLockdownIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplLockdownProxy, xdp_impl_lockdown_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplLockdownProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_LOCKDOWN, xdp_impl_lockdown_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplLockdownProxy, xdp_impl_lockdown_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_LOCKDOWN, xdp_impl_lockdown_proxy_iface_init))

#endif
static void
xdp_impl_lockdown_proxy_finalize (GObject *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_lockdown_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_lockdown_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_lockdown_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_impl_lockdown_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.Lockdown: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_impl_lockdown_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_lockdown_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.Lockdown", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_impl_lockdown_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_impl_lockdown_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_lockdown_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_LOCKDOWN);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_LOCKDOWN);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_lockdown_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_lockdown_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_lockdown_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_printing (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-printing");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_save_to_disk (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-save-to-disk");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_application_handlers (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-application-handlers");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_location (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-location");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_camera (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-camera");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_microphone (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-microphone");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_impl_lockdown_proxy_get_disable_sound_output (XdpImplLockdown *object)
{
  XdpImplLockdownProxy *proxy = XDP_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-sound-output");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_impl_lockdown_proxy_init (XdpImplLockdownProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_lockdown_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_LOCKDOWN_PROXY, XdpImplLockdownProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_lockdown_interface_info ());
}

static void
xdp_impl_lockdown_proxy_class_init (XdpImplLockdownProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_lockdown_proxy_finalize;
  gobject_class->get_property = xdp_impl_lockdown_proxy_get_property;
  gobject_class->set_property = xdp_impl_lockdown_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_lockdown_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_lockdown_proxy_g_properties_changed;

  xdp_impl_lockdown_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplLockdownProxyPrivate));
#endif
}

static void
xdp_impl_lockdown_proxy_iface_init (XdpImplLockdownIface *iface)
{
  iface->get_disable_printing = xdp_impl_lockdown_proxy_get_disable_printing;
  iface->get_disable_save_to_disk = xdp_impl_lockdown_proxy_get_disable_save_to_disk;
  iface->get_disable_application_handlers = xdp_impl_lockdown_proxy_get_disable_application_handlers;
  iface->get_disable_location = xdp_impl_lockdown_proxy_get_disable_location;
  iface->get_disable_camera = xdp_impl_lockdown_proxy_get_disable_camera;
  iface->get_disable_microphone = xdp_impl_lockdown_proxy_get_disable_microphone;
  iface->get_disable_sound_output = xdp_impl_lockdown_proxy_get_disable_sound_output;
}

/**
 * xdp_impl_lockdown_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_lockdown_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_lockdown_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_lockdown_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_LOCKDOWN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Lockdown", NULL);
}

/**
 * xdp_impl_lockdown_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_lockdown_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_lockdown_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplLockdownProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplLockdown *
xdp_impl_lockdown_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_LOCKDOWN (ret);
  else
    return NULL;
}

/**
 * xdp_impl_lockdown_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_lockdown_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplLockdownProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplLockdown *
xdp_impl_lockdown_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_LOCKDOWN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Lockdown", NULL);
  if (ret != NULL)
    return XDP_IMPL_LOCKDOWN (ret);
  else
    return NULL;
}


/**
 * xdp_impl_lockdown_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_lockdown_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_lockdown_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_lockdown_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_lockdown_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_LOCKDOWN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Lockdown", NULL);
}

/**
 * xdp_impl_lockdown_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_lockdown_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_lockdown_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplLockdownProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplLockdown *
xdp_impl_lockdown_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_LOCKDOWN (ret);
  else
    return NULL;
}

/**
 * xdp_impl_lockdown_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_lockdown_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_lockdown_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplLockdownProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplLockdown *
xdp_impl_lockdown_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_LOCKDOWN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Lockdown", NULL);
  if (ret != NULL)
    return XDP_IMPL_LOCKDOWN (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplLockdownSkeleton:
 *
 * The #XdpImplLockdownSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplLockdownSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplLockdownSkeleton.
 */

struct _XdpImplLockdownSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_lockdown_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_LOCKDOWN);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_LOCKDOWN);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_lockdown_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_lockdown_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_lockdown_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_lockdown_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_lockdown_skeleton_vtable =
{
  _xdp_impl_lockdown_skeleton_handle_method_call,
  _xdp_impl_lockdown_skeleton_handle_get_property,
  _xdp_impl_lockdown_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_lockdown_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_lockdown_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_lockdown_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_lockdown_skeleton_vtable;
}

static GVariant *
xdp_impl_lockdown_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_lockdown_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_lockdown_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_lockdown_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_lockdown_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Lockdown", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_impl_lockdown_emit_changed (gpointer user_data);

static void
xdp_impl_lockdown_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_impl_lockdown_emit_changed (skeleton);
}

static void xdp_impl_lockdown_skeleton_iface_init (XdpImplLockdownIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplLockdownSkeleton, xdp_impl_lockdown_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplLockdownSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_LOCKDOWN, xdp_impl_lockdown_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplLockdownSkeleton, xdp_impl_lockdown_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_LOCKDOWN, xdp_impl_lockdown_skeleton_iface_init))

#endif
static void
xdp_impl_lockdown_skeleton_finalize (GObject *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  guint n;
  for (n = 0; n < 7; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_lockdown_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_lockdown_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_impl_lockdown_emit_changed (gpointer user_data)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.Lockdown",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_impl_lockdown_schedule_emit_changed (XdpImplLockdownSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_impl_lockdown_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_impl_lockdown_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_impl_lockdown_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_impl_lockdown_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_lockdown_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_impl_lockdown_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_impl_lockdown_skeleton_init (XdpImplLockdownSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_lockdown_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_LOCKDOWN_SKELETON, XdpImplLockdownSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 7);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_BOOLEAN);
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_printing (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_save_to_disk (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_application_handlers (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_location (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_camera (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_microphone (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_impl_lockdown_skeleton_get_disable_sound_output (XdpImplLockdown *object)
{
  XdpImplLockdownSkeleton *skeleton = XDP_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_impl_lockdown_skeleton_class_init (XdpImplLockdownSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_lockdown_skeleton_finalize;
  gobject_class->get_property = xdp_impl_lockdown_skeleton_get_property;
  gobject_class->set_property = xdp_impl_lockdown_skeleton_set_property;
  gobject_class->notify       = xdp_impl_lockdown_skeleton_notify;


  xdp_impl_lockdown_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_lockdown_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_lockdown_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_lockdown_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_lockdown_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplLockdownSkeletonPrivate));
#endif
}

static void
xdp_impl_lockdown_skeleton_iface_init (XdpImplLockdownIface *iface)
{
  iface->get_disable_printing = xdp_impl_lockdown_skeleton_get_disable_printing;
  iface->get_disable_save_to_disk = xdp_impl_lockdown_skeleton_get_disable_save_to_disk;
  iface->get_disable_application_handlers = xdp_impl_lockdown_skeleton_get_disable_application_handlers;
  iface->get_disable_location = xdp_impl_lockdown_skeleton_get_disable_location;
  iface->get_disable_camera = xdp_impl_lockdown_skeleton_get_disable_camera;
  iface->get_disable_microphone = xdp_impl_lockdown_skeleton_get_disable_microphone;
  iface->get_disable_sound_output = xdp_impl_lockdown_skeleton_get_disable_sound_output;
}

/**
 * xdp_impl_lockdown_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>.
 *
 * Returns: (transfer full) (type XdpImplLockdownSkeleton): The skeleton object.
 */
XdpImplLockdown *
xdp_impl_lockdown_skeleton_new (void)
{
  return XDP_IMPL_LOCKDOWN (g_object_new (XDP_IMPL_TYPE_LOCKDOWN_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Notification
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplNotification
 * @title: XdpImplNotification
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Notification D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Notification ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_notification_method_info_add_notification_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_notification_method_info_add_notification_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_notification_method_info_add_notification_IN_ARG_notification =
{
  {
    -1,
    (gchar *) "notification",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_notification_method_info_add_notification_IN_ARG_pointers[] =
{
  &_xdp_impl_notification_method_info_add_notification_IN_ARG_app_id.parent_struct,
  &_xdp_impl_notification_method_info_add_notification_IN_ARG_id.parent_struct,
  &_xdp_impl_notification_method_info_add_notification_IN_ARG_notification.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_notification_method_add_notification_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In2",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_notification_method_add_notification_annotation_info_pointers[] =
{
  &_xdp_impl_notification_method_add_notification_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_notification_method_info_add_notification =
{
  {
    -1,
    (gchar *) "AddNotification",
    (GDBusArgInfo **) &_xdp_impl_notification_method_info_add_notification_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_xdp_impl_notification_method_add_notification_annotation_info_pointers
  },
  "handle-add-notification",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_notification_method_info_remove_notification_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_notification_method_info_remove_notification_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_notification_method_info_remove_notification_IN_ARG_pointers[] =
{
  &_xdp_impl_notification_method_info_remove_notification_IN_ARG_app_id.parent_struct,
  &_xdp_impl_notification_method_info_remove_notification_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_notification_method_info_remove_notification =
{
  {
    -1,
    (gchar *) "RemoveNotification",
    (GDBusArgInfo **) &_xdp_impl_notification_method_info_remove_notification_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-remove-notification",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_notification_method_info_pointers[] =
{
  &_xdp_impl_notification_method_info_add_notification.parent_struct,
  &_xdp_impl_notification_method_info_remove_notification.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_notification_signal_info_action_invoked_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_notification_signal_info_action_invoked_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_notification_signal_info_action_invoked_ARG_action =
{
  {
    -1,
    (gchar *) "action",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_notification_signal_info_action_invoked_ARG_parameter =
{
  {
    -1,
    (gchar *) "parameter",
    (gchar *) "av",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_notification_signal_info_action_invoked_ARG_pointers[] =
{
  &_xdp_impl_notification_signal_info_action_invoked_ARG_app_id.parent_struct,
  &_xdp_impl_notification_signal_info_action_invoked_ARG_id.parent_struct,
  &_xdp_impl_notification_signal_info_action_invoked_ARG_action.parent_struct,
  &_xdp_impl_notification_signal_info_action_invoked_ARG_parameter.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_impl_notification_signal_info_action_invoked =
{
  {
    -1,
    (gchar *) "ActionInvoked",
    (GDBusArgInfo **) &_xdp_impl_notification_signal_info_action_invoked_ARG_pointers,
    NULL
  },
  "action-invoked"
};

static const GDBusSignalInfo * const _xdp_impl_notification_signal_info_pointers[] =
{
  &_xdp_impl_notification_signal_info_action_invoked.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_notification_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Notification",
    (GDBusMethodInfo **) &_xdp_impl_notification_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_impl_notification_signal_info_pointers,
    NULL,
    NULL
  },
  "notification",
};


/**
 * xdp_impl_notification_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_notification_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_notification_interface_info.parent_struct;
}

/**
 * xdp_impl_notification_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplNotification interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_notification_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpImplNotification:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>.
 */

/**
 * XdpImplNotificationIface:
 * @parent_iface: The parent interface.
 * @handle_add_notification: Handler for the #XdpImplNotification::handle-add-notification signal.
 * @handle_remove_notification: Handler for the #XdpImplNotification::handle-remove-notification signal.
 * @action_invoked: Handler for the #XdpImplNotification::action-invoked signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>.
 */

typedef XdpImplNotificationIface XdpImplNotificationInterface;
G_DEFINE_INTERFACE (XdpImplNotification, xdp_impl_notification, G_TYPE_OBJECT)

static void
xdp_impl_notification_default_init (XdpImplNotificationIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplNotification::handle-add-notification:
   * @object: A #XdpImplNotification.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_notification: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.AddNotification">AddNotification()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_notification_complete_add_notification() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-notification",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplNotificationIface, handle_add_notification),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpImplNotification::handle-remove-notification:
   * @object: A #XdpImplNotification.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_notification_complete_remove_notification() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-remove-notification",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplNotificationIface, handle_remove_notification),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpImplNotification::action-invoked:
   * @object: A #XdpImplNotification.
   * @arg_app_id: Argument.
   * @arg_id: Argument.
   * @arg_action: Argument.
   * @arg_parameter: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Notification.ActionInvoked">"ActionInvoked"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("action-invoked",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplNotificationIface, action_invoked),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_impl_notification_emit_action_invoked:
 * @object: A #XdpImplNotification.
 * @arg_app_id: Argument to pass with the signal.
 * @arg_id: Argument to pass with the signal.
 * @arg_action: Argument to pass with the signal.
 * @arg_parameter: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Notification.ActionInvoked">"ActionInvoked"</link> D-Bus signal.
 */
void
xdp_impl_notification_emit_action_invoked (
    XdpImplNotification *object,
    const gchar *arg_app_id,
    const gchar *arg_id,
    const gchar *arg_action,
    GVariant *arg_parameter)
{
  g_signal_emit_by_name (object, "action-invoked", arg_app_id, arg_id, arg_action, arg_parameter);
}

/**
 * xdp_impl_notification_call_add_notification:
 * @proxy: A #XdpImplNotificationProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_notification: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.AddNotification">AddNotification()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_notification_call_add_notification_finish() to get the result of the operation.
 *
 * See xdp_impl_notification_call_add_notification_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_notification_call_add_notification (
    XdpImplNotification *proxy,
    const gchar *arg_app_id,
    const gchar *arg_id,
    GVariant *arg_notification,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddNotification",
    g_variant_new ("(ss@a{sv})",
                   arg_app_id,
                   arg_id,
                   arg_notification),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_notification_call_add_notification_finish:
 * @proxy: A #XdpImplNotificationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_notification_call_add_notification().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_notification_call_add_notification().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_notification_call_add_notification_finish (
    XdpImplNotification *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_notification_call_add_notification_sync:
 * @proxy: A #XdpImplNotificationProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_notification: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.AddNotification">AddNotification()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_notification_call_add_notification() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_notification_call_add_notification_sync (
    XdpImplNotification *proxy,
    const gchar *arg_app_id,
    const gchar *arg_id,
    GVariant *arg_notification,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddNotification",
    g_variant_new ("(ss@a{sv})",
                   arg_app_id,
                   arg_id,
                   arg_notification),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_notification_call_remove_notification:
 * @proxy: A #XdpImplNotificationProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_notification_call_remove_notification_finish() to get the result of the operation.
 *
 * See xdp_impl_notification_call_remove_notification_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_notification_call_remove_notification (
    XdpImplNotification *proxy,
    const gchar *arg_app_id,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RemoveNotification",
    g_variant_new ("(ss)",
                   arg_app_id,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_notification_call_remove_notification_finish:
 * @proxy: A #XdpImplNotificationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_notification_call_remove_notification().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_notification_call_remove_notification().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_notification_call_remove_notification_finish (
    XdpImplNotification *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_notification_call_remove_notification_sync:
 * @proxy: A #XdpImplNotificationProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_notification_call_remove_notification() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_notification_call_remove_notification_sync (
    XdpImplNotification *proxy,
    const gchar *arg_app_id,
    const gchar *arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RemoveNotification",
    g_variant_new ("(ss)",
                   arg_app_id,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_notification_complete_add_notification:
 * @object: A #XdpImplNotification.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.AddNotification">AddNotification()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_notification_complete_add_notification (
    XdpImplNotification *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_notification_complete_remove_notification:
 * @object: A #XdpImplNotification.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_notification_complete_remove_notification (
    XdpImplNotification *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplNotificationProxy:
 *
 * The #XdpImplNotificationProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplNotificationProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplNotificationProxy.
 */

struct _XdpImplNotificationProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_notification_proxy_iface_init (XdpImplNotificationIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplNotificationProxy, xdp_impl_notification_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplNotificationProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_NOTIFICATION, xdp_impl_notification_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplNotificationProxy, xdp_impl_notification_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_NOTIFICATION, xdp_impl_notification_proxy_iface_init))

#endif
static void
xdp_impl_notification_proxy_finalize (GObject *object)
{
  XdpImplNotificationProxy *proxy = XDP_IMPL_NOTIFICATION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_notification_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_notification_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_notification_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_notification_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_notification_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_NOTIFICATION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_NOTIFICATION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_notification_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplNotificationProxy *proxy = XDP_IMPL_NOTIFICATION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_notification_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_notification_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_notification_proxy_init (XdpImplNotificationProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_notification_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_NOTIFICATION_PROXY, XdpImplNotificationProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_notification_interface_info ());
}

static void
xdp_impl_notification_proxy_class_init (XdpImplNotificationProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_notification_proxy_finalize;
  gobject_class->get_property = xdp_impl_notification_proxy_get_property;
  gobject_class->set_property = xdp_impl_notification_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_notification_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_notification_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplNotificationProxyPrivate));
#endif
}

static void
xdp_impl_notification_proxy_iface_init (XdpImplNotificationIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_notification_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_notification_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_notification_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_notification_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_NOTIFICATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Notification", NULL);
}

/**
 * xdp_impl_notification_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_notification_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_notification_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplNotification *
xdp_impl_notification_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_NOTIFICATION (ret);
  else
    return NULL;
}

/**
 * xdp_impl_notification_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_notification_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplNotification *
xdp_impl_notification_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_NOTIFICATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Notification", NULL);
  if (ret != NULL)
    return XDP_IMPL_NOTIFICATION (ret);
  else
    return NULL;
}


/**
 * xdp_impl_notification_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_notification_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_notification_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_notification_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_notification_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_NOTIFICATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Notification", NULL);
}

/**
 * xdp_impl_notification_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_notification_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_notification_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplNotification *
xdp_impl_notification_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_NOTIFICATION (ret);
  else
    return NULL;
}

/**
 * xdp_impl_notification_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_notification_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_notification_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplNotification *
xdp_impl_notification_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_NOTIFICATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Notification", NULL);
  if (ret != NULL)
    return XDP_IMPL_NOTIFICATION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplNotificationSkeleton:
 *
 * The #XdpImplNotificationSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplNotificationSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplNotificationSkeleton.
 */

struct _XdpImplNotificationSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_notification_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplNotificationSkeleton *skeleton = XDP_IMPL_NOTIFICATION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_NOTIFICATION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_NOTIFICATION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_notification_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplNotificationSkeleton *skeleton = XDP_IMPL_NOTIFICATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_notification_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_notification_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplNotificationSkeleton *skeleton = XDP_IMPL_NOTIFICATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_notification_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_notification_skeleton_vtable =
{
  _xdp_impl_notification_skeleton_handle_method_call,
  _xdp_impl_notification_skeleton_handle_get_property,
  _xdp_impl_notification_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_notification_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_notification_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_notification_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_notification_skeleton_vtable;
}

static GVariant *
xdp_impl_notification_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplNotificationSkeleton *skeleton = XDP_IMPL_NOTIFICATION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_notification_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_notification_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_notification_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_notification_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Notification", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_notification_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_xdp_impl_notification_on_signal_action_invoked (
    XdpImplNotification *object,
    const gchar *arg_app_id,
    const gchar *arg_id,
    const gchar *arg_action,
    GVariant *arg_parameter)
{
  XdpImplNotificationSkeleton *skeleton = XDP_IMPL_NOTIFICATION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(sss@av)",
                   arg_app_id,
                   arg_id,
                   arg_action,
                   arg_parameter));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Notification", "ActionInvoked",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_impl_notification_skeleton_iface_init (XdpImplNotificationIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplNotificationSkeleton, xdp_impl_notification_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplNotificationSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_NOTIFICATION, xdp_impl_notification_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplNotificationSkeleton, xdp_impl_notification_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_NOTIFICATION, xdp_impl_notification_skeleton_iface_init))

#endif
static void
xdp_impl_notification_skeleton_finalize (GObject *object)
{
  XdpImplNotificationSkeleton *skeleton = XDP_IMPL_NOTIFICATION_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_notification_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_notification_skeleton_init (XdpImplNotificationSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_notification_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_NOTIFICATION_SKELETON, XdpImplNotificationSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_notification_skeleton_class_init (XdpImplNotificationSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_notification_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_notification_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_notification_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_notification_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_notification_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplNotificationSkeletonPrivate));
#endif
}

static void
xdp_impl_notification_skeleton_iface_init (XdpImplNotificationIface *iface)
{
  iface->action_invoked = _xdp_impl_notification_on_signal_action_invoked;
}

/**
 * xdp_impl_notification_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>.
 *
 * Returns: (transfer full) (type XdpImplNotificationSkeleton): The skeleton object.
 */
XdpImplNotification *
xdp_impl_notification_skeleton_new (void)
{
  return XDP_IMPL_NOTIFICATION (g_object_new (XDP_IMPL_TYPE_NOTIFICATION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.PermissionStore
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplPermissionStore
 * @title: XdpImplPermissionStore
 * @short_description: Generated C code for the org.freedesktop.impl.portal.PermissionStore D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.PermissionStore ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_lookup_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_lookup_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_permission_store_method_info_lookup_IN_ARG_pointers[] =
{
  &_xdp_impl_permission_store_method_info_lookup_IN_ARG_table.parent_struct,
  &_xdp_impl_permission_store_method_info_lookup_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_lookup_OUT_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "a{sas}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_lookup_OUT_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_permission_store_method_info_lookup_OUT_ARG_pointers[] =
{
  &_xdp_impl_permission_store_method_info_lookup_OUT_ARG_permissions.parent_struct,
  &_xdp_impl_permission_store_method_info_lookup_OUT_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_permission_store_method_info_lookup =
{
  {
    -1,
    (gchar *) "Lookup",
    (GDBusArgInfo **) &_xdp_impl_permission_store_method_info_lookup_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_permission_store_method_info_lookup_OUT_ARG_pointers,
    NULL
  },
  "handle-lookup",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_IN_ARG_create =
{
  {
    -1,
    (gchar *) "create",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_IN_ARG_app_permissions =
{
  {
    -1,
    (gchar *) "app_permissions",
    (gchar *) "a{sas}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_permission_store_method_info_set_IN_ARG_pointers[] =
{
  &_xdp_impl_permission_store_method_info_set_IN_ARG_table.parent_struct,
  &_xdp_impl_permission_store_method_info_set_IN_ARG_create.parent_struct,
  &_xdp_impl_permission_store_method_info_set_IN_ARG_id.parent_struct,
  &_xdp_impl_permission_store_method_info_set_IN_ARG_app_permissions.parent_struct,
  &_xdp_impl_permission_store_method_info_set_IN_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_permission_store_method_info_set =
{
  {
    -1,
    (gchar *) "Set",
    (GDBusArgInfo **) &_xdp_impl_permission_store_method_info_set_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_delete_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_delete_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_permission_store_method_info_delete_IN_ARG_pointers[] =
{
  &_xdp_impl_permission_store_method_info_delete_IN_ARG_table.parent_struct,
  &_xdp_impl_permission_store_method_info_delete_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_permission_store_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    (GDBusArgInfo **) &_xdp_impl_permission_store_method_info_delete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_value_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_value_IN_ARG_create =
{
  {
    -1,
    (gchar *) "create",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_value_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_value_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_permission_store_method_info_set_value_IN_ARG_pointers[] =
{
  &_xdp_impl_permission_store_method_info_set_value_IN_ARG_table.parent_struct,
  &_xdp_impl_permission_store_method_info_set_value_IN_ARG_create.parent_struct,
  &_xdp_impl_permission_store_method_info_set_value_IN_ARG_id.parent_struct,
  &_xdp_impl_permission_store_method_info_set_value_IN_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_permission_store_method_info_set_value =
{
  {
    -1,
    (gchar *) "SetValue",
    (GDBusArgInfo **) &_xdp_impl_permission_store_method_info_set_value_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-value",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_permission_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_permission_IN_ARG_create =
{
  {
    -1,
    (gchar *) "create",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_permission_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_permission_IN_ARG_app =
{
  {
    -1,
    (gchar *) "app",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_set_permission_IN_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_permission_store_method_info_set_permission_IN_ARG_pointers[] =
{
  &_xdp_impl_permission_store_method_info_set_permission_IN_ARG_table.parent_struct,
  &_xdp_impl_permission_store_method_info_set_permission_IN_ARG_create.parent_struct,
  &_xdp_impl_permission_store_method_info_set_permission_IN_ARG_id.parent_struct,
  &_xdp_impl_permission_store_method_info_set_permission_IN_ARG_app.parent_struct,
  &_xdp_impl_permission_store_method_info_set_permission_IN_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_permission_store_method_info_set_permission =
{
  {
    -1,
    (gchar *) "SetPermission",
    (GDBusArgInfo **) &_xdp_impl_permission_store_method_info_set_permission_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-permission",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_delete_permission_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_delete_permission_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_delete_permission_IN_ARG_app =
{
  {
    -1,
    (gchar *) "app",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_permission_store_method_info_delete_permission_IN_ARG_pointers[] =
{
  &_xdp_impl_permission_store_method_info_delete_permission_IN_ARG_table.parent_struct,
  &_xdp_impl_permission_store_method_info_delete_permission_IN_ARG_id.parent_struct,
  &_xdp_impl_permission_store_method_info_delete_permission_IN_ARG_app.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_permission_store_method_info_delete_permission =
{
  {
    -1,
    (gchar *) "DeletePermission",
    (GDBusArgInfo **) &_xdp_impl_permission_store_method_info_delete_permission_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete-permission",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_get_permission_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_get_permission_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_get_permission_IN_ARG_app =
{
  {
    -1,
    (gchar *) "app",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_permission_store_method_info_get_permission_IN_ARG_pointers[] =
{
  &_xdp_impl_permission_store_method_info_get_permission_IN_ARG_table.parent_struct,
  &_xdp_impl_permission_store_method_info_get_permission_IN_ARG_id.parent_struct,
  &_xdp_impl_permission_store_method_info_get_permission_IN_ARG_app.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_get_permission_OUT_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_permission_store_method_info_get_permission_OUT_ARG_pointers[] =
{
  &_xdp_impl_permission_store_method_info_get_permission_OUT_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_permission_store_method_info_get_permission =
{
  {
    -1,
    (gchar *) "GetPermission",
    (GDBusArgInfo **) &_xdp_impl_permission_store_method_info_get_permission_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_permission_store_method_info_get_permission_OUT_ARG_pointers,
    NULL
  },
  "handle-get-permission",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_list_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_permission_store_method_info_list_IN_ARG_pointers[] =
{
  &_xdp_impl_permission_store_method_info_list_IN_ARG_table.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_method_info_list_OUT_ARG_ids =
{
  {
    -1,
    (gchar *) "ids",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_permission_store_method_info_list_OUT_ARG_pointers[] =
{
  &_xdp_impl_permission_store_method_info_list_OUT_ARG_ids.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_permission_store_method_info_list =
{
  {
    -1,
    (gchar *) "List",
    (GDBusArgInfo **) &_xdp_impl_permission_store_method_info_list_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_permission_store_method_info_list_OUT_ARG_pointers,
    NULL
  },
  "handle-list",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_permission_store_method_info_pointers[] =
{
  &_xdp_impl_permission_store_method_info_lookup.parent_struct,
  &_xdp_impl_permission_store_method_info_set.parent_struct,
  &_xdp_impl_permission_store_method_info_delete.parent_struct,
  &_xdp_impl_permission_store_method_info_set_value.parent_struct,
  &_xdp_impl_permission_store_method_info_set_permission.parent_struct,
  &_xdp_impl_permission_store_method_info_delete_permission.parent_struct,
  &_xdp_impl_permission_store_method_info_get_permission.parent_struct,
  &_xdp_impl_permission_store_method_info_list.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_signal_info_changed_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_signal_info_changed_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_signal_info_changed_ARG_deleted =
{
  {
    -1,
    (gchar *) "deleted",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_signal_info_changed_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_permission_store_signal_info_changed_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "a{sas}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_permission_store_signal_info_changed_ARG_pointers[] =
{
  &_xdp_impl_permission_store_signal_info_changed_ARG_table.parent_struct,
  &_xdp_impl_permission_store_signal_info_changed_ARG_id.parent_struct,
  &_xdp_impl_permission_store_signal_info_changed_ARG_deleted.parent_struct,
  &_xdp_impl_permission_store_signal_info_changed_ARG_data.parent_struct,
  &_xdp_impl_permission_store_signal_info_changed_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_impl_permission_store_signal_info_changed =
{
  {
    -1,
    (gchar *) "Changed",
    (GDBusArgInfo **) &_xdp_impl_permission_store_signal_info_changed_ARG_pointers,
    NULL
  },
  "changed"
};

static const GDBusSignalInfo * const _xdp_impl_permission_store_signal_info_pointers[] =
{
  &_xdp_impl_permission_store_signal_info_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_permission_store_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_impl_permission_store_property_info_pointers[] =
{
  &_xdp_impl_permission_store_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_permission_store_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.PermissionStore",
    (GDBusMethodInfo **) &_xdp_impl_permission_store_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_impl_permission_store_signal_info_pointers,
    (GDBusPropertyInfo **) &_xdp_impl_permission_store_property_info_pointers,
    NULL
  },
  "permission-store",
};


/**
 * xdp_impl_permission_store_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_permission_store_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_permission_store_interface_info.parent_struct;
}

/**
 * xdp_impl_permission_store_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplPermissionStore interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_permission_store_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpImplPermissionStore:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>.
 */

/**
 * XdpImplPermissionStoreIface:
 * @parent_iface: The parent interface.
 * @handle_delete: Handler for the #XdpImplPermissionStore::handle-delete signal.
 * @handle_delete_permission: Handler for the #XdpImplPermissionStore::handle-delete-permission signal.
 * @handle_get_permission: Handler for the #XdpImplPermissionStore::handle-get-permission signal.
 * @handle_list: Handler for the #XdpImplPermissionStore::handle-list signal.
 * @handle_lookup: Handler for the #XdpImplPermissionStore::handle-lookup signal.
 * @handle_set: Handler for the #XdpImplPermissionStore::handle-set signal.
 * @handle_set_permission: Handler for the #XdpImplPermissionStore::handle-set-permission signal.
 * @handle_set_value: Handler for the #XdpImplPermissionStore::handle-set-value signal.
 * @get_version: Getter for the #XdpImplPermissionStore:version property.
 * @changed: Handler for the #XdpImplPermissionStore::changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>.
 */

typedef XdpImplPermissionStoreIface XdpImplPermissionStoreInterface;
G_DEFINE_INTERFACE (XdpImplPermissionStore, xdp_impl_permission_store, G_TYPE_OBJECT)

static void
xdp_impl_permission_store_default_init (XdpImplPermissionStoreIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplPermissionStore::handle-lookup:
   * @object: A #XdpImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Lookup">Lookup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_permission_store_complete_lookup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lookup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplPermissionStoreIface, handle_lookup),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpImplPermissionStore::handle-set:
   * @object: A #XdpImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_create: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_app_permissions: Argument passed by remote caller.
   * @arg_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Set">Set()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_permission_store_complete_set() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplPermissionStoreIface, handle_set),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdpImplPermissionStore::handle-delete:
   * @object: A #XdpImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_permission_store_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplPermissionStoreIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpImplPermissionStore::handle-set-value:
   * @object: A #XdpImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_create: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetValue">SetValue()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_permission_store_complete_set_value() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-value",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplPermissionStoreIface, handle_set_value),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpImplPermissionStore::handle-set-permission:
   * @object: A #XdpImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_create: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_app: Argument passed by remote caller.
   * @arg_permissions: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetPermission">SetPermission()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_permission_store_complete_set_permission() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-permission",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplPermissionStoreIface, handle_set_permission),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV);

  /**
   * XdpImplPermissionStore::handle-delete-permission:
   * @object: A #XdpImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_app: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.DeletePermission">DeletePermission()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_permission_store_complete_delete_permission() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete-permission",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplPermissionStoreIface, handle_delete_permission),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpImplPermissionStore::handle-get-permission:
   * @object: A #XdpImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_app: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.GetPermission">GetPermission()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_permission_store_complete_get_permission() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-permission",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplPermissionStoreIface, handle_get_permission),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpImplPermissionStore::handle-list:
   * @object: A #XdpImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.List">List()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_permission_store_complete_list() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplPermissionStoreIface, handle_list),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpImplPermissionStore::changed:
   * @object: A #XdpImplPermissionStore.
   * @arg_table: Argument.
   * @arg_id: Argument.
   * @arg_deleted: Argument.
   * @arg_data: Argument.
   * @arg_permissions: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-PermissionStore.Changed">"Changed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplPermissionStoreIface, changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpImplPermissionStore:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-PermissionStore.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_impl_permission_store_get_version: (skip)
 * @object: A #XdpImplPermissionStore.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-PermissionStore.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_impl_permission_store_get_version (XdpImplPermissionStore *object)
{
  return XDP_IMPL_PERMISSION_STORE_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_impl_permission_store_set_version: (skip)
 * @object: A #XdpImplPermissionStore.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-PermissionStore.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_impl_permission_store_set_version (XdpImplPermissionStore *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_impl_permission_store_emit_changed:
 * @object: A #XdpImplPermissionStore.
 * @arg_table: Argument to pass with the signal.
 * @arg_id: Argument to pass with the signal.
 * @arg_deleted: Argument to pass with the signal.
 * @arg_data: Argument to pass with the signal.
 * @arg_permissions: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-PermissionStore.Changed">"Changed"</link> D-Bus signal.
 */
void
xdp_impl_permission_store_emit_changed (
    XdpImplPermissionStore *object,
    const gchar *arg_table,
    const gchar *arg_id,
    gboolean arg_deleted,
    GVariant *arg_data,
    GVariant *arg_permissions)
{
  g_signal_emit_by_name (object, "changed", arg_table, arg_id, arg_deleted, arg_data, arg_permissions);
}

/**
 * xdp_impl_permission_store_call_lookup:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Lookup">Lookup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_permission_store_call_lookup_finish() to get the result of the operation.
 *
 * See xdp_impl_permission_store_call_lookup_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_permission_store_call_lookup (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lookup",
    g_variant_new ("(ss)",
                   arg_table,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_permission_store_call_lookup_finish:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @out_permissions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_permission_store_call_lookup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_permission_store_call_lookup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_lookup_finish (
    XdpImplPermissionStore *proxy,
    GVariant **out_permissions,
    GVariant **out_data,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sas}@v)",
                 out_permissions,
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_lookup_sync:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @out_permissions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Lookup">Lookup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_permission_store_call_lookup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_lookup_sync (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    GVariant **out_permissions,
    GVariant **out_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lookup",
    g_variant_new ("(ss)",
                   arg_table,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sas}@v)",
                 out_permissions,
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_set:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app_permissions: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Set">Set()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_permission_store_call_set_finish() to get the result of the operation.
 *
 * See xdp_impl_permission_store_call_set_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_permission_store_call_set (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    GVariant *arg_app_permissions,
    GVariant *arg_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Set",
    g_variant_new ("(sbs@a{sas}@v)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_app_permissions,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_permission_store_call_set_finish:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_permission_store_call_set().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_permission_store_call_set().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_set_finish (
    XdpImplPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_set_sync:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app_permissions: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Set">Set()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_permission_store_call_set() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_set_sync (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    GVariant *arg_app_permissions,
    GVariant *arg_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Set",
    g_variant_new ("(sbs@a{sas}@v)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_app_permissions,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_delete:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_permission_store_call_delete_finish() to get the result of the operation.
 *
 * See xdp_impl_permission_store_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_permission_store_call_delete (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(ss)",
                   arg_table,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_permission_store_call_delete_finish:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_permission_store_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_permission_store_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_delete_finish (
    XdpImplPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_delete_sync:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_permission_store_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_delete_sync (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(ss)",
                   arg_table,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_set_value:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetValue">SetValue()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_permission_store_call_set_value_finish() to get the result of the operation.
 *
 * See xdp_impl_permission_store_call_set_value_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_permission_store_call_set_value (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    GVariant *arg_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetValue",
    g_variant_new ("(sbs@v)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_permission_store_call_set_value_finish:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_permission_store_call_set_value().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_permission_store_call_set_value().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_set_value_finish (
    XdpImplPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_set_value_sync:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetValue">SetValue()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_permission_store_call_set_value() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_set_value_sync (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    GVariant *arg_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetValue",
    g_variant_new ("(sbs@v)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_set_permission:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetPermission">SetPermission()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_permission_store_call_set_permission_finish() to get the result of the operation.
 *
 * See xdp_impl_permission_store_call_set_permission_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_permission_store_call_set_permission (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    const gchar *arg_app,
    const gchar *const *arg_permissions,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPermission",
    g_variant_new ("(sbss^as)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_app,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_permission_store_call_set_permission_finish:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_permission_store_call_set_permission().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_permission_store_call_set_permission().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_set_permission_finish (
    XdpImplPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_set_permission_sync:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetPermission">SetPermission()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_permission_store_call_set_permission() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_set_permission_sync (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    const gchar *arg_app,
    const gchar *const *arg_permissions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPermission",
    g_variant_new ("(sbss^as)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_app,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_delete_permission:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.DeletePermission">DeletePermission()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_permission_store_call_delete_permission_finish() to get the result of the operation.
 *
 * See xdp_impl_permission_store_call_delete_permission_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_permission_store_call_delete_permission (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    const gchar *arg_app,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeletePermission",
    g_variant_new ("(sss)",
                   arg_table,
                   arg_id,
                   arg_app),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_permission_store_call_delete_permission_finish:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_permission_store_call_delete_permission().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_permission_store_call_delete_permission().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_delete_permission_finish (
    XdpImplPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_delete_permission_sync:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.DeletePermission">DeletePermission()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_permission_store_call_delete_permission() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_delete_permission_sync (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    const gchar *arg_app,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeletePermission",
    g_variant_new ("(sss)",
                   arg_table,
                   arg_id,
                   arg_app),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_get_permission:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.GetPermission">GetPermission()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_permission_store_call_get_permission_finish() to get the result of the operation.
 *
 * See xdp_impl_permission_store_call_get_permission_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_permission_store_call_get_permission (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    const gchar *arg_app,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetPermission",
    g_variant_new ("(sss)",
                   arg_table,
                   arg_id,
                   arg_app),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_permission_store_call_get_permission_finish:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @out_permissions: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_permission_store_call_get_permission().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_permission_store_call_get_permission().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_get_permission_finish (
    XdpImplPermissionStore *proxy,
    gchar ***out_permissions,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_permissions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_get_permission_sync:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @out_permissions: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.GetPermission">GetPermission()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_permission_store_call_get_permission() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_get_permission_sync (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    const gchar *arg_app,
    gchar ***out_permissions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetPermission",
    g_variant_new ("(sss)",
                   arg_table,
                   arg_id,
                   arg_app),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_permissions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_list:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.List">List()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_permission_store_call_list_finish() to get the result of the operation.
 *
 * See xdp_impl_permission_store_call_list_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_permission_store_call_list (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("(s)",
                   arg_table),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_permission_store_call_list_finish:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @out_ids: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_permission_store_call_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_permission_store_call_list().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_list_finish (
    XdpImplPermissionStore *proxy,
    gchar ***out_ids,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_ids);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_call_list_sync:
 * @proxy: A #XdpImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @out_ids: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.List">List()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_permission_store_call_list() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_permission_store_call_list_sync (
    XdpImplPermissionStore *proxy,
    const gchar *arg_table,
    gchar ***out_ids,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("(s)",
                   arg_table),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_ids);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_permission_store_complete_lookup:
 * @object: A #XdpImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @permissions: Parameter to return.
 * @data: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Lookup">Lookup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_permission_store_complete_lookup (
    XdpImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *permissions,
    GVariant *data)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sas}@v)",
                   permissions,
                   data));
}

/**
 * xdp_impl_permission_store_complete_set:
 * @object: A #XdpImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Set">Set()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_permission_store_complete_set (
    XdpImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_permission_store_complete_delete:
 * @object: A #XdpImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_permission_store_complete_delete (
    XdpImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_permission_store_complete_set_value:
 * @object: A #XdpImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetValue">SetValue()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_permission_store_complete_set_value (
    XdpImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_permission_store_complete_set_permission:
 * @object: A #XdpImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetPermission">SetPermission()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_permission_store_complete_set_permission (
    XdpImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_permission_store_complete_delete_permission:
 * @object: A #XdpImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.DeletePermission">DeletePermission()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_permission_store_complete_delete_permission (
    XdpImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_permission_store_complete_get_permission:
 * @object: A #XdpImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @permissions: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.GetPermission">GetPermission()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_permission_store_complete_get_permission (
    XdpImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *permissions)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   permissions));
}

/**
 * xdp_impl_permission_store_complete_list:
 * @object: A #XdpImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @ids: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.List">List()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_permission_store_complete_list (
    XdpImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *ids)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   ids));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplPermissionStoreProxy:
 *
 * The #XdpImplPermissionStoreProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplPermissionStoreProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplPermissionStoreProxy.
 */

struct _XdpImplPermissionStoreProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_permission_store_proxy_iface_init (XdpImplPermissionStoreIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplPermissionStoreProxy, xdp_impl_permission_store_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplPermissionStoreProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_PERMISSION_STORE, xdp_impl_permission_store_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplPermissionStoreProxy, xdp_impl_permission_store_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_PERMISSION_STORE, xdp_impl_permission_store_proxy_iface_init))

#endif
static void
xdp_impl_permission_store_proxy_finalize (GObject *object)
{
  XdpImplPermissionStoreProxy *proxy = XDP_IMPL_PERMISSION_STORE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_permission_store_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_permission_store_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_permission_store_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_impl_permission_store_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.PermissionStore: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_impl_permission_store_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_permission_store_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.PermissionStore", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_impl_permission_store_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_impl_permission_store_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_permission_store_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_PERMISSION_STORE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_PERMISSION_STORE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_permission_store_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplPermissionStoreProxy *proxy = XDP_IMPL_PERMISSION_STORE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_permission_store_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_permission_store_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_impl_permission_store_proxy_get_version (XdpImplPermissionStore *object)
{
  XdpImplPermissionStoreProxy *proxy = XDP_IMPL_PERMISSION_STORE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_impl_permission_store_proxy_init (XdpImplPermissionStoreProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_permission_store_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_PERMISSION_STORE_PROXY, XdpImplPermissionStoreProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_permission_store_interface_info ());
}

static void
xdp_impl_permission_store_proxy_class_init (XdpImplPermissionStoreProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_permission_store_proxy_finalize;
  gobject_class->get_property = xdp_impl_permission_store_proxy_get_property;
  gobject_class->set_property = xdp_impl_permission_store_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_permission_store_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_permission_store_proxy_g_properties_changed;

  xdp_impl_permission_store_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplPermissionStoreProxyPrivate));
#endif
}

static void
xdp_impl_permission_store_proxy_iface_init (XdpImplPermissionStoreIface *iface)
{
  iface->get_version = xdp_impl_permission_store_proxy_get_version;
}

/**
 * xdp_impl_permission_store_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_permission_store_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_permission_store_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_permission_store_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_PERMISSION_STORE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
}

/**
 * xdp_impl_permission_store_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_permission_store_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_permission_store_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplPermissionStoreProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplPermissionStore *
xdp_impl_permission_store_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_PERMISSION_STORE (ret);
  else
    return NULL;
}

/**
 * xdp_impl_permission_store_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_permission_store_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplPermissionStoreProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplPermissionStore *
xdp_impl_permission_store_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_PERMISSION_STORE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
  if (ret != NULL)
    return XDP_IMPL_PERMISSION_STORE (ret);
  else
    return NULL;
}


/**
 * xdp_impl_permission_store_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_permission_store_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_permission_store_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_permission_store_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_permission_store_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_PERMISSION_STORE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
}

/**
 * xdp_impl_permission_store_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_permission_store_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_permission_store_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplPermissionStoreProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplPermissionStore *
xdp_impl_permission_store_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_PERMISSION_STORE (ret);
  else
    return NULL;
}

/**
 * xdp_impl_permission_store_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_permission_store_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_permission_store_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplPermissionStoreProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplPermissionStore *
xdp_impl_permission_store_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_PERMISSION_STORE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
  if (ret != NULL)
    return XDP_IMPL_PERMISSION_STORE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplPermissionStoreSkeleton:
 *
 * The #XdpImplPermissionStoreSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplPermissionStoreSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplPermissionStoreSkeleton.
 */

struct _XdpImplPermissionStoreSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_permission_store_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplPermissionStoreSkeleton *skeleton = XDP_IMPL_PERMISSION_STORE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_PERMISSION_STORE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_PERMISSION_STORE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_permission_store_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplPermissionStoreSkeleton *skeleton = XDP_IMPL_PERMISSION_STORE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_permission_store_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_permission_store_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplPermissionStoreSkeleton *skeleton = XDP_IMPL_PERMISSION_STORE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_permission_store_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_permission_store_skeleton_vtable =
{
  _xdp_impl_permission_store_skeleton_handle_method_call,
  _xdp_impl_permission_store_skeleton_handle_get_property,
  _xdp_impl_permission_store_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_permission_store_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_permission_store_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_permission_store_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_permission_store_skeleton_vtable;
}

static GVariant *
xdp_impl_permission_store_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplPermissionStoreSkeleton *skeleton = XDP_IMPL_PERMISSION_STORE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_permission_store_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_permission_store_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_permission_store_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_permission_store_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.PermissionStore", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_impl_permission_store_emit_changed (gpointer user_data);

static void
xdp_impl_permission_store_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplPermissionStoreSkeleton *skeleton = XDP_IMPL_PERMISSION_STORE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_impl_permission_store_emit_changed (skeleton);
}

static void
_xdp_impl_permission_store_on_signal_changed (
    XdpImplPermissionStore *object,
    const gchar *arg_table,
    const gchar *arg_id,
    gboolean arg_deleted,
    GVariant *arg_data,
    GVariant *arg_permissions)
{
  XdpImplPermissionStoreSkeleton *skeleton = XDP_IMPL_PERMISSION_STORE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ssb@v@a{sas})",
                   arg_table,
                   arg_id,
                   arg_deleted,
                   arg_data,
                   arg_permissions));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.PermissionStore", "Changed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_impl_permission_store_skeleton_iface_init (XdpImplPermissionStoreIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplPermissionStoreSkeleton, xdp_impl_permission_store_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplPermissionStoreSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_PERMISSION_STORE, xdp_impl_permission_store_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplPermissionStoreSkeleton, xdp_impl_permission_store_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_PERMISSION_STORE, xdp_impl_permission_store_skeleton_iface_init))

#endif
static void
xdp_impl_permission_store_skeleton_finalize (GObject *object)
{
  XdpImplPermissionStoreSkeleton *skeleton = XDP_IMPL_PERMISSION_STORE_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_permission_store_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_permission_store_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpImplPermissionStoreSkeleton *skeleton = XDP_IMPL_PERMISSION_STORE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_impl_permission_store_emit_changed (gpointer user_data)
{
  XdpImplPermissionStoreSkeleton *skeleton = XDP_IMPL_PERMISSION_STORE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.PermissionStore",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_impl_permission_store_schedule_emit_changed (XdpImplPermissionStoreSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_impl_permission_store_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpImplPermissionStoreSkeleton *skeleton = XDP_IMPL_PERMISSION_STORE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_impl_permission_store_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_impl_permission_store_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_impl_permission_store_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpImplPermissionStoreSkeleton *skeleton = XDP_IMPL_PERMISSION_STORE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_permission_store_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_impl_permission_store_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_impl_permission_store_skeleton_init (XdpImplPermissionStoreSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_permission_store_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_PERMISSION_STORE_SKELETON, XdpImplPermissionStoreSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_impl_permission_store_skeleton_get_version (XdpImplPermissionStore *object)
{
  XdpImplPermissionStoreSkeleton *skeleton = XDP_IMPL_PERMISSION_STORE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_impl_permission_store_skeleton_class_init (XdpImplPermissionStoreSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_permission_store_skeleton_finalize;
  gobject_class->get_property = xdp_impl_permission_store_skeleton_get_property;
  gobject_class->set_property = xdp_impl_permission_store_skeleton_set_property;
  gobject_class->notify       = xdp_impl_permission_store_skeleton_notify;


  xdp_impl_permission_store_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_permission_store_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_permission_store_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_permission_store_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_permission_store_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplPermissionStoreSkeletonPrivate));
#endif
}

static void
xdp_impl_permission_store_skeleton_iface_init (XdpImplPermissionStoreIface *iface)
{
  iface->changed = _xdp_impl_permission_store_on_signal_changed;
  iface->get_version = xdp_impl_permission_store_skeleton_get_version;
}

/**
 * xdp_impl_permission_store_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>.
 *
 * Returns: (transfer full) (type XdpImplPermissionStoreSkeleton): The skeleton object.
 */
XdpImplPermissionStore *
xdp_impl_permission_store_skeleton_new (void)
{
  return XDP_IMPL_PERMISSION_STORE (g_object_new (XDP_IMPL_TYPE_PERMISSION_STORE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Print
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplPrint
 * @title: XdpImplPrint
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Print D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Print ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_print_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_print_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_print_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_print_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_print_IN_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_print_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_print_method_info_print_IN_ARG_pointers[] =
{
  &_xdp_impl_print_method_info_print_IN_ARG_handle.parent_struct,
  &_xdp_impl_print_method_info_print_IN_ARG_app_id.parent_struct,
  &_xdp_impl_print_method_info_print_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_print_method_info_print_IN_ARG_title.parent_struct,
  &_xdp_impl_print_method_info_print_IN_ARG_fd.parent_struct,
  &_xdp_impl_print_method_info_print_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_print_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_print_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_print_method_info_print_OUT_ARG_pointers[] =
{
  &_xdp_impl_print_method_info_print_OUT_ARG_response.parent_struct,
  &_xdp_impl_print_method_info_print_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_print_method_print_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In5",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_print_method_print_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_print_method_print_annotation_info_pointers[] =
{
  &_xdp_impl_print_method_print_annotation_info_0,
  &_xdp_impl_print_method_print_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_print_method_info_print =
{
  {
    -1,
    (gchar *) "Print",
    (GDBusArgInfo **) &_xdp_impl_print_method_info_print_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_print_method_info_print_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_print_method_print_annotation_info_pointers
  },
  "handle-print",
  TRUE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_prepare_print_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_prepare_print_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_prepare_print_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_prepare_print_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_prepare_print_IN_ARG_settings =
{
  {
    -1,
    (gchar *) "settings",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_prepare_print_IN_ARG_page_setup =
{
  {
    -1,
    (gchar *) "page_setup",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_prepare_print_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_print_method_info_prepare_print_IN_ARG_pointers[] =
{
  &_xdp_impl_print_method_info_prepare_print_IN_ARG_handle.parent_struct,
  &_xdp_impl_print_method_info_prepare_print_IN_ARG_app_id.parent_struct,
  &_xdp_impl_print_method_info_prepare_print_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_print_method_info_prepare_print_IN_ARG_title.parent_struct,
  &_xdp_impl_print_method_info_prepare_print_IN_ARG_settings.parent_struct,
  &_xdp_impl_print_method_info_prepare_print_IN_ARG_page_setup.parent_struct,
  &_xdp_impl_print_method_info_prepare_print_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_prepare_print_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_print_method_info_prepare_print_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_print_method_info_prepare_print_OUT_ARG_pointers[] =
{
  &_xdp_impl_print_method_info_prepare_print_OUT_ARG_response.parent_struct,
  &_xdp_impl_print_method_info_prepare_print_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_print_method_prepare_print_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_print_method_prepare_print_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In5",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_print_method_prepare_print_annotation_info_2 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In6",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_print_method_prepare_print_annotation_info_3 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_print_method_prepare_print_annotation_info_pointers[] =
{
  &_xdp_impl_print_method_prepare_print_annotation_info_0,
  &_xdp_impl_print_method_prepare_print_annotation_info_1,
  &_xdp_impl_print_method_prepare_print_annotation_info_2,
  &_xdp_impl_print_method_prepare_print_annotation_info_3,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_print_method_info_prepare_print =
{
  {
    -1,
    (gchar *) "PreparePrint",
    (GDBusArgInfo **) &_xdp_impl_print_method_info_prepare_print_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_print_method_info_prepare_print_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_print_method_prepare_print_annotation_info_pointers
  },
  "handle-prepare-print",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_print_method_info_pointers[] =
{
  &_xdp_impl_print_method_info_print.parent_struct,
  &_xdp_impl_print_method_info_prepare_print.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_print_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Print",
    (GDBusMethodInfo **) &_xdp_impl_print_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "print",
};


/**
 * xdp_impl_print_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_print_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_print_interface_info.parent_struct;
}

/**
 * xdp_impl_print_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplPrint interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_print_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpImplPrint:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link>.
 */

/**
 * XdpImplPrintIface:
 * @parent_iface: The parent interface.
 * @handle_prepare_print: Handler for the #XdpImplPrint::handle-prepare-print signal.
 * @handle_print: Handler for the #XdpImplPrint::handle-print signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link>.
 */

typedef XdpImplPrintIface XdpImplPrintInterface;
G_DEFINE_INTERFACE (XdpImplPrint, xdp_impl_print, G_TYPE_OBJECT)

static void
xdp_impl_print_default_init (XdpImplPrintIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplPrint::handle-print:
   * @object: A #XdpImplPrint.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_fd: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.Print">Print()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_print_complete_print() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-print",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplPrintIface, handle_print),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    8,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdpImplPrint::handle-prepare-print:
   * @object: A #XdpImplPrint.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_settings: Argument passed by remote caller.
   * @arg_page_setup: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.PreparePrint">PreparePrint()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_print_complete_prepare_print() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-prepare-print",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplPrintIface, handle_prepare_print),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    8,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT, G_TYPE_VARIANT);

}

/**
 * xdp_impl_print_call_print:
 * @proxy: A #XdpImplPrintProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_fd: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.Print">Print()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_print_call_print_finish() to get the result of the operation.
 *
 * See xdp_impl_print_call_print_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_print_call_print (
    XdpImplPrint *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_fd,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "Print",
    g_variant_new ("(osss@h@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_fd,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_print_call_print_finish:
 * @proxy: A #XdpImplPrintProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_print_call_print().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_print_call_print().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_print_call_print_finish (
    XdpImplPrint *proxy,
    guint *out_response,
    GVariant **out_results,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_print_call_print_sync:
 * @proxy: A #XdpImplPrintProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_fd: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.Print">Print()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_print_call_print() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_print_call_print_sync (
    XdpImplPrint *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_fd,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    guint *out_response,
    GVariant **out_results,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "Print",
    g_variant_new ("(osss@h@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_fd,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_print_call_prepare_print:
 * @proxy: A #XdpImplPrintProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_settings: Argument to pass with the method invocation.
 * @arg_page_setup: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.PreparePrint">PreparePrint()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_print_call_prepare_print_finish() to get the result of the operation.
 *
 * See xdp_impl_print_call_prepare_print_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_print_call_prepare_print (
    XdpImplPrint *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_settings,
    GVariant *arg_page_setup,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PreparePrint",
    g_variant_new ("(osss@a{sv}@a{sv}@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_settings,
                   arg_page_setup,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_print_call_prepare_print_finish:
 * @proxy: A #XdpImplPrintProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_print_call_prepare_print().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_print_call_prepare_print().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_print_call_prepare_print_finish (
    XdpImplPrint *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_print_call_prepare_print_sync:
 * @proxy: A #XdpImplPrintProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_settings: Argument to pass with the method invocation.
 * @arg_page_setup: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.PreparePrint">PreparePrint()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_print_call_prepare_print() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_print_call_prepare_print_sync (
    XdpImplPrint *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_settings,
    GVariant *arg_page_setup,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PreparePrint",
    g_variant_new ("(osss@a{sv}@a{sv}@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_settings,
                   arg_page_setup,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_print_complete_print:
 * @object: A #XdpImplPrint.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.Print">Print()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_print_complete_print (
    XdpImplPrint *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results),
    fd_list);
}

/**
 * xdp_impl_print_complete_prepare_print:
 * @object: A #XdpImplPrint.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.PreparePrint">PreparePrint()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_print_complete_prepare_print (
    XdpImplPrint *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplPrintProxy:
 *
 * The #XdpImplPrintProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplPrintProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplPrintProxy.
 */

struct _XdpImplPrintProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_print_proxy_iface_init (XdpImplPrintIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplPrintProxy, xdp_impl_print_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplPrintProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_PRINT, xdp_impl_print_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplPrintProxy, xdp_impl_print_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_PRINT, xdp_impl_print_proxy_iface_init))

#endif
static void
xdp_impl_print_proxy_finalize (GObject *object)
{
  XdpImplPrintProxy *proxy = XDP_IMPL_PRINT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_print_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_print_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_print_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_print_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_print_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_PRINT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_PRINT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_print_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplPrintProxy *proxy = XDP_IMPL_PRINT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_print_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_print_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_print_proxy_init (XdpImplPrintProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_print_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_PRINT_PROXY, XdpImplPrintProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_print_interface_info ());
}

static void
xdp_impl_print_proxy_class_init (XdpImplPrintProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_print_proxy_finalize;
  gobject_class->get_property = xdp_impl_print_proxy_get_property;
  gobject_class->set_property = xdp_impl_print_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_print_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_print_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplPrintProxyPrivate));
#endif
}

static void
xdp_impl_print_proxy_iface_init (XdpImplPrintIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_print_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_print_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_print_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_print_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_PRINT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Print", NULL);
}

/**
 * xdp_impl_print_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_print_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_print_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplPrintProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplPrint *
xdp_impl_print_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_PRINT (ret);
  else
    return NULL;
}

/**
 * xdp_impl_print_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_print_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplPrintProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplPrint *
xdp_impl_print_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_PRINT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Print", NULL);
  if (ret != NULL)
    return XDP_IMPL_PRINT (ret);
  else
    return NULL;
}


/**
 * xdp_impl_print_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_print_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_print_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_print_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_print_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_PRINT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Print", NULL);
}

/**
 * xdp_impl_print_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_print_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_print_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplPrintProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplPrint *
xdp_impl_print_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_PRINT (ret);
  else
    return NULL;
}

/**
 * xdp_impl_print_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_print_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_print_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplPrintProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplPrint *
xdp_impl_print_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_PRINT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Print", NULL);
  if (ret != NULL)
    return XDP_IMPL_PRINT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplPrintSkeleton:
 *
 * The #XdpImplPrintSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplPrintSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplPrintSkeleton.
 */

struct _XdpImplPrintSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_print_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplPrintSkeleton *skeleton = XDP_IMPL_PRINT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_PRINT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_PRINT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_print_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplPrintSkeleton *skeleton = XDP_IMPL_PRINT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_print_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_print_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplPrintSkeleton *skeleton = XDP_IMPL_PRINT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_print_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_print_skeleton_vtable =
{
  _xdp_impl_print_skeleton_handle_method_call,
  _xdp_impl_print_skeleton_handle_get_property,
  _xdp_impl_print_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_print_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_print_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_print_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_print_skeleton_vtable;
}

static GVariant *
xdp_impl_print_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplPrintSkeleton *skeleton = XDP_IMPL_PRINT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_print_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_print_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_print_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_print_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Print", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_print_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_impl_print_skeleton_iface_init (XdpImplPrintIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplPrintSkeleton, xdp_impl_print_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplPrintSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_PRINT, xdp_impl_print_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplPrintSkeleton, xdp_impl_print_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_PRINT, xdp_impl_print_skeleton_iface_init))

#endif
static void
xdp_impl_print_skeleton_finalize (GObject *object)
{
  XdpImplPrintSkeleton *skeleton = XDP_IMPL_PRINT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_print_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_print_skeleton_init (XdpImplPrintSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_print_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_PRINT_SKELETON, XdpImplPrintSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_print_skeleton_class_init (XdpImplPrintSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_print_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_print_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_print_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_print_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_print_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplPrintSkeletonPrivate));
#endif
}

static void
xdp_impl_print_skeleton_iface_init (XdpImplPrintIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_print_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link>.
 *
 * Returns: (transfer full) (type XdpImplPrintSkeleton): The skeleton object.
 */
XdpImplPrint *
xdp_impl_print_skeleton_new (void)
{
  return XDP_IMPL_PRINT (g_object_new (XDP_IMPL_TYPE_PRINT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.RemoteDesktop
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplRemoteDesktop
 * @title: XdpImplRemoteDesktop
 * @short_description: Generated C code for the org.freedesktop.impl.portal.RemoteDesktop D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.RemoteDesktop ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_create_session_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_create_session_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_create_session_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_create_session_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_create_session_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_create_session_IN_ARG_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_create_session_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_create_session_IN_ARG_app_id.parent_struct,
  &_xdp_impl_remote_desktop_method_info_create_session_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_create_session_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_create_session_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_create_session_OUT_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_create_session_OUT_ARG_response.parent_struct,
  &_xdp_impl_remote_desktop_method_info_create_session_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_remote_desktop_method_create_session_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_remote_desktop_method_create_session_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_remote_desktop_method_create_session_annotation_info_pointers[] =
{
  &_xdp_impl_remote_desktop_method_create_session_annotation_info_0,
  &_xdp_impl_remote_desktop_method_create_session_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_create_session =
{
  {
    -1,
    (gchar *) "CreateSession",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_create_session_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_create_session_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_remote_desktop_method_create_session_annotation_info_pointers
  },
  "handle-create-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_select_devices_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_select_devices_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_select_devices_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_select_devices_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_select_devices_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_select_devices_IN_ARG_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_select_devices_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_select_devices_IN_ARG_app_id.parent_struct,
  &_xdp_impl_remote_desktop_method_info_select_devices_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_select_devices_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_select_devices_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_select_devices_OUT_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_select_devices_OUT_ARG_response.parent_struct,
  &_xdp_impl_remote_desktop_method_info_select_devices_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_remote_desktop_method_select_devices_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_remote_desktop_method_select_devices_annotation_info_pointers[] =
{
  &_xdp_impl_remote_desktop_method_select_devices_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_select_devices =
{
  {
    -1,
    (gchar *) "SelectDevices",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_select_devices_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_select_devices_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_remote_desktop_method_select_devices_annotation_info_pointers
  },
  "handle-select-devices",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_start_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_start_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_start_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_start_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_start_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_start_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_start_IN_ARG_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_start_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_start_IN_ARG_app_id.parent_struct,
  &_xdp_impl_remote_desktop_method_info_start_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_remote_desktop_method_info_start_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_start_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_start_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_start_OUT_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_start_OUT_ARG_response.parent_struct,
  &_xdp_impl_remote_desktop_method_info_start_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_remote_desktop_method_start_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_remote_desktop_method_start_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_remote_desktop_method_start_annotation_info_pointers[] =
{
  &_xdp_impl_remote_desktop_method_start_annotation_info_0,
  &_xdp_impl_remote_desktop_method_start_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_start_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_start_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_remote_desktop_method_start_annotation_info_pointers
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_dx =
{
  {
    -1,
    (gchar *) "dx",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_dy =
{
  {
    -1,
    (gchar *) "dy",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_options.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_dx.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_dy.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_notify_pointer_motion =
{
  {
    -1,
    (gchar *) "NotifyPointerMotion",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-motion",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_options.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_stream.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_x.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute =
{
  {
    -1,
    (gchar *) "NotifyPointerMotionAbsolute",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-motion-absolute",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_button =
{
  {
    -1,
    (gchar *) "button",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_options.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_button.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_notify_pointer_button =
{
  {
    -1,
    (gchar *) "NotifyPointerButton",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-button",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_dx =
{
  {
    -1,
    (gchar *) "dx",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_dy =
{
  {
    -1,
    (gchar *) "dy",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_options.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_dx.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_dy.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_notify_pointer_axis =
{
  {
    -1,
    (gchar *) "NotifyPointerAxis",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-axis",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_axis =
{
  {
    -1,
    (gchar *) "axis",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_steps =
{
  {
    -1,
    (gchar *) "steps",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_options.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_axis.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_steps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_notify_pointer_axis_discrete =
{
  {
    -1,
    (gchar *) "NotifyPointerAxisDiscrete",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-axis-discrete",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_keycode =
{
  {
    -1,
    (gchar *) "keycode",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_options.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_keycode.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_notify_keyboard_keycode =
{
  {
    -1,
    (gchar *) "NotifyKeyboardKeycode",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-keyboard-keycode",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_keysym =
{
  {
    -1,
    (gchar *) "keysym",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_options.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_keysym.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_notify_keyboard_keysym =
{
  {
    -1,
    (gchar *) "NotifyKeyboardKeysym",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-keyboard-keysym",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_options.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_stream.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_slot.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_x.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_notify_touch_down =
{
  {
    -1,
    (gchar *) "NotifyTouchDown",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-down",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_options.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_stream.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_slot.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_x.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_notify_touch_motion =
{
  {
    -1,
    (gchar *) "NotifyTouchMotion",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-motion",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_options.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_slot.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_remote_desktop_method_info_notify_touch_up =
{
  {
    -1,
    (gchar *) "NotifyTouchUp",
    (GDBusArgInfo **) &_xdp_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-up",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_remote_desktop_method_info_pointers[] =
{
  &_xdp_impl_remote_desktop_method_info_create_session.parent_struct,
  &_xdp_impl_remote_desktop_method_info_select_devices.parent_struct,
  &_xdp_impl_remote_desktop_method_info_start.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_motion.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_motion_absolute.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_button.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_axis.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_pointer_axis_discrete.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_keyboard_keycode.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_keyboard_keysym.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_down.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_motion.parent_struct,
  &_xdp_impl_remote_desktop_method_info_notify_touch_up.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_remote_desktop_property_info_available_device_types =
{
  {
    -1,
    (gchar *) "AvailableDeviceTypes",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "available-device-types",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_remote_desktop_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_impl_remote_desktop_property_info_pointers[] =
{
  &_xdp_impl_remote_desktop_property_info_available_device_types.parent_struct,
  &_xdp_impl_remote_desktop_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_remote_desktop_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.RemoteDesktop",
    (GDBusMethodInfo **) &_xdp_impl_remote_desktop_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_impl_remote_desktop_property_info_pointers,
    NULL
  },
  "remote-desktop",
};


/**
 * xdp_impl_remote_desktop_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_remote_desktop_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_remote_desktop_interface_info.parent_struct;
}

/**
 * xdp_impl_remote_desktop_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplRemoteDesktop interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_remote_desktop_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "available-device-types");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpImplRemoteDesktop:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link>.
 */

/**
 * XdpImplRemoteDesktopIface:
 * @parent_iface: The parent interface.
 * @handle_create_session: Handler for the #XdpImplRemoteDesktop::handle-create-session signal.
 * @handle_notify_keyboard_keycode: Handler for the #XdpImplRemoteDesktop::handle-notify-keyboard-keycode signal.
 * @handle_notify_keyboard_keysym: Handler for the #XdpImplRemoteDesktop::handle-notify-keyboard-keysym signal.
 * @handle_notify_pointer_axis: Handler for the #XdpImplRemoteDesktop::handle-notify-pointer-axis signal.
 * @handle_notify_pointer_axis_discrete: Handler for the #XdpImplRemoteDesktop::handle-notify-pointer-axis-discrete signal.
 * @handle_notify_pointer_button: Handler for the #XdpImplRemoteDesktop::handle-notify-pointer-button signal.
 * @handle_notify_pointer_motion: Handler for the #XdpImplRemoteDesktop::handle-notify-pointer-motion signal.
 * @handle_notify_pointer_motion_absolute: Handler for the #XdpImplRemoteDesktop::handle-notify-pointer-motion-absolute signal.
 * @handle_notify_touch_down: Handler for the #XdpImplRemoteDesktop::handle-notify-touch-down signal.
 * @handle_notify_touch_motion: Handler for the #XdpImplRemoteDesktop::handle-notify-touch-motion signal.
 * @handle_notify_touch_up: Handler for the #XdpImplRemoteDesktop::handle-notify-touch-up signal.
 * @handle_select_devices: Handler for the #XdpImplRemoteDesktop::handle-select-devices signal.
 * @handle_start: Handler for the #XdpImplRemoteDesktop::handle-start signal.
 * @get_available_device_types: Getter for the #XdpImplRemoteDesktop:available-device-types property.
 * @get_version: Getter for the #XdpImplRemoteDesktop:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link>.
 */

typedef XdpImplRemoteDesktopIface XdpImplRemoteDesktopInterface;
G_DEFINE_INTERFACE (XdpImplRemoteDesktop, xdp_impl_remote_desktop, G_TYPE_OBJECT)

static void
xdp_impl_remote_desktop_default_init (XdpImplRemoteDesktopIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplRemoteDesktop::handle-create-session:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_create_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_create_session),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpImplRemoteDesktop::handle-select-devices:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.SelectDevices">SelectDevices()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_select_devices() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-devices",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_select_devices),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpImplRemoteDesktop::handle-start:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpImplRemoteDesktop::handle-notify-pointer-motion:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_dx: Argument passed by remote caller.
   * @arg_dy: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotion">NotifyPointerMotion()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_notify_pointer_motion() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-motion",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_notify_pointer_motion),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * XdpImplRemoteDesktop::handle-notify-pointer-motion-absolute:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_stream: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_notify_pointer_motion_absolute() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-motion-absolute",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_notify_pointer_motion_absolute),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * XdpImplRemoteDesktop::handle-notify-pointer-button:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_button: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_notify_pointer_button() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-button",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_notify_pointer_button),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_INT, G_TYPE_UINT);

  /**
   * XdpImplRemoteDesktop::handle-notify-pointer-axis:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_dx: Argument passed by remote caller.
   * @arg_dy: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_notify_pointer_axis() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-axis",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_notify_pointer_axis),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * XdpImplRemoteDesktop::handle-notify-pointer-axis-discrete:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_axis: Argument passed by remote caller.
   * @arg_steps: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_notify_pointer_axis_discrete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-axis-discrete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_notify_pointer_axis_discrete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_INT);

  /**
   * XdpImplRemoteDesktop::handle-notify-keyboard-keycode:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_keycode: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_notify_keyboard_keycode() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-keyboard-keycode",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_notify_keyboard_keycode),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_INT, G_TYPE_UINT);

  /**
   * XdpImplRemoteDesktop::handle-notify-keyboard-keysym:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_keysym: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_notify_keyboard_keysym() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-keyboard-keysym",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_notify_keyboard_keysym),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_INT, G_TYPE_UINT);

  /**
   * XdpImplRemoteDesktop::handle-notify-touch-down:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_stream: Argument passed by remote caller.
   * @arg_slot: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_notify_touch_down() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-down",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_notify_touch_down),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * XdpImplRemoteDesktop::handle-notify-touch-motion:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_stream: Argument passed by remote caller.
   * @arg_slot: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_notify_touch_motion() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-motion",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_notify_touch_motion),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * XdpImplRemoteDesktop::handle-notify-touch-up:
   * @object: A #XdpImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_slot: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_remote_desktop_complete_notify_touch_up() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-up",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRemoteDesktopIface, handle_notify_touch_up),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpImplRemoteDesktop:available-device-types:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-RemoteDesktop.AvailableDeviceTypes">"AvailableDeviceTypes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("available-device-types", "AvailableDeviceTypes", "AvailableDeviceTypes", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplRemoteDesktop:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-RemoteDesktop.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_impl_remote_desktop_get_available_device_types: (skip)
 * @object: A #XdpImplRemoteDesktop.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-RemoteDesktop.AvailableDeviceTypes">"AvailableDeviceTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_impl_remote_desktop_get_available_device_types (XdpImplRemoteDesktop *object)
{
  return XDP_IMPL_REMOTE_DESKTOP_GET_IFACE (object)->get_available_device_types (object);
}

/**
 * xdp_impl_remote_desktop_set_available_device_types: (skip)
 * @object: A #XdpImplRemoteDesktop.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-RemoteDesktop.AvailableDeviceTypes">"AvailableDeviceTypes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_impl_remote_desktop_set_available_device_types (XdpImplRemoteDesktop *object, guint value)
{
  g_object_set (G_OBJECT (object), "available-device-types", value, NULL);
}

/**
 * xdp_impl_remote_desktop_get_version: (skip)
 * @object: A #XdpImplRemoteDesktop.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-RemoteDesktop.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_impl_remote_desktop_get_version (XdpImplRemoteDesktop *object)
{
  return XDP_IMPL_REMOTE_DESKTOP_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_impl_remote_desktop_set_version: (skip)
 * @object: A #XdpImplRemoteDesktop.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-RemoteDesktop.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_impl_remote_desktop_set_version (XdpImplRemoteDesktop *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_impl_remote_desktop_call_create_session:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_create_session_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_create_session_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_create_session (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_create_session_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_create_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_create_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_create_session_finish (
    XdpImplRemoteDesktop *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_create_session_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_create_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_create_session_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_select_devices:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.SelectDevices">SelectDevices()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_select_devices_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_select_devices_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_select_devices (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectDevices",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_select_devices_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_select_devices().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_select_devices().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_select_devices_finish (
    XdpImplRemoteDesktop *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_select_devices_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.SelectDevices">SelectDevices()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_select_devices() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_select_devices_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectDevices",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_start:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_start_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_start_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_start (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(ooss@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_start_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_start_finish (
    XdpImplRemoteDesktop *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_start_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_start_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(ooss@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_motion:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotion">NotifyPointerMotion()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_notify_pointer_motion_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_notify_pointer_motion_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_notify_pointer_motion (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerMotion",
    g_variant_new ("(o@a{sv}dd)",
                   arg_session_handle,
                   arg_options,
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_motion_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_notify_pointer_motion().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_notify_pointer_motion().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_pointer_motion_finish (
    XdpImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_motion_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotion">NotifyPointerMotion()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_notify_pointer_motion() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_pointer_motion_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerMotion",
    g_variant_new ("(o@a{sv}dd)",
                   arg_session_handle,
                   arg_options,
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_motion_absolute:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_notify_pointer_motion_absolute_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_notify_pointer_motion_absolute_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_notify_pointer_motion_absolute (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_stream,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionAbsolute",
    g_variant_new ("(o@a{sv}udd)",
                   arg_session_handle,
                   arg_options,
                   arg_stream,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_motion_absolute_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_notify_pointer_motion_absolute().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_notify_pointer_motion_absolute().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_pointer_motion_absolute_finish (
    XdpImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_motion_absolute_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_notify_pointer_motion_absolute() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_pointer_motion_absolute_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_stream,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionAbsolute",
    g_variant_new ("(o@a{sv}udd)",
                   arg_session_handle,
                   arg_options,
                   arg_stream,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_button:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_notify_pointer_button_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_notify_pointer_button_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_notify_pointer_button (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gint arg_button,
    guint arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerButton",
    g_variant_new ("(o@a{sv}iu)",
                   arg_session_handle,
                   arg_options,
                   arg_button,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_button_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_notify_pointer_button().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_notify_pointer_button().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_pointer_button_finish (
    XdpImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_button_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_notify_pointer_button() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_pointer_button_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gint arg_button,
    guint arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerButton",
    g_variant_new ("(o@a{sv}iu)",
                   arg_session_handle,
                   arg_options,
                   arg_button,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_axis:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_notify_pointer_axis_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_notify_pointer_axis_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_notify_pointer_axis (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerAxis",
    g_variant_new ("(o@a{sv}dd)",
                   arg_session_handle,
                   arg_options,
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_axis_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_notify_pointer_axis().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_notify_pointer_axis().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_pointer_axis_finish (
    XdpImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_axis_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_notify_pointer_axis() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_pointer_axis_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerAxis",
    g_variant_new ("(o@a{sv}dd)",
                   arg_session_handle,
                   arg_options,
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_axis_discrete:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_axis: Argument to pass with the method invocation.
 * @arg_steps: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_notify_pointer_axis_discrete_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_notify_pointer_axis_discrete_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_notify_pointer_axis_discrete (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_axis,
    gint arg_steps,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerAxisDiscrete",
    g_variant_new ("(o@a{sv}ui)",
                   arg_session_handle,
                   arg_options,
                   arg_axis,
                   arg_steps),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_axis_discrete_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_notify_pointer_axis_discrete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_notify_pointer_axis_discrete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_pointer_axis_discrete_finish (
    XdpImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_pointer_axis_discrete_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_axis: Argument to pass with the method invocation.
 * @arg_steps: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_notify_pointer_axis_discrete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_pointer_axis_discrete_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_axis,
    gint arg_steps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerAxisDiscrete",
    g_variant_new ("(o@a{sv}ui)",
                   arg_session_handle,
                   arg_options,
                   arg_axis,
                   arg_steps),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_keyboard_keycode:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_notify_keyboard_keycode_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_notify_keyboard_keycode_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_notify_keyboard_keycode (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gint arg_keycode,
    guint arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeycode",
    g_variant_new ("(o@a{sv}iu)",
                   arg_session_handle,
                   arg_options,
                   arg_keycode,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_notify_keyboard_keycode_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_notify_keyboard_keycode().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_notify_keyboard_keycode().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_keyboard_keycode_finish (
    XdpImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_keyboard_keycode_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_notify_keyboard_keycode() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_keyboard_keycode_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gint arg_keycode,
    guint arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeycode",
    g_variant_new ("(o@a{sv}iu)",
                   arg_session_handle,
                   arg_options,
                   arg_keycode,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_keyboard_keysym:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_keysym: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_notify_keyboard_keysym_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_notify_keyboard_keysym_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_notify_keyboard_keysym (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gint arg_keysym,
    guint arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeysym",
    g_variant_new ("(o@a{sv}iu)",
                   arg_session_handle,
                   arg_options,
                   arg_keysym,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_notify_keyboard_keysym_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_notify_keyboard_keysym().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_notify_keyboard_keysym().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_keyboard_keysym_finish (
    XdpImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_keyboard_keysym_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_keysym: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_notify_keyboard_keysym() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_keyboard_keysym_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gint arg_keysym,
    guint arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeysym",
    g_variant_new ("(o@a{sv}iu)",
                   arg_session_handle,
                   arg_options,
                   arg_keysym,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_touch_down:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_notify_touch_down_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_notify_touch_down_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_notify_touch_down (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchDown",
    g_variant_new ("(o@a{sv}uudd)",
                   arg_session_handle,
                   arg_options,
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_notify_touch_down_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_notify_touch_down().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_notify_touch_down().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_touch_down_finish (
    XdpImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_touch_down_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_notify_touch_down() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_touch_down_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchDown",
    g_variant_new ("(o@a{sv}uudd)",
                   arg_session_handle,
                   arg_options,
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_touch_motion:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_notify_touch_motion_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_notify_touch_motion_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_notify_touch_motion (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchMotion",
    g_variant_new ("(o@a{sv}uudd)",
                   arg_session_handle,
                   arg_options,
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_notify_touch_motion_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_notify_touch_motion().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_notify_touch_motion().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_touch_motion_finish (
    XdpImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_touch_motion_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_notify_touch_motion() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_touch_motion_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchMotion",
    g_variant_new ("(o@a{sv}uudd)",
                   arg_session_handle,
                   arg_options,
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_touch_up:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_call_notify_touch_up_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_call_notify_touch_up_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_remote_desktop_call_notify_touch_up (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_slot,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchUp",
    g_variant_new ("(o@a{sv}u)",
                   arg_session_handle,
                   arg_options,
                   arg_slot),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_remote_desktop_call_notify_touch_up_finish:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_call_notify_touch_up().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_remote_desktop_call_notify_touch_up().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_touch_up_finish (
    XdpImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_call_notify_touch_up_sync:
 * @proxy: A #XdpImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_call_notify_touch_up() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_remote_desktop_call_notify_touch_up_sync (
    XdpImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_slot,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchUp",
    g_variant_new ("(o@a{sv}u)",
                   arg_session_handle,
                   arg_options,
                   arg_slot),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_remote_desktop_complete_create_session:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_create_session (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_remote_desktop_complete_select_devices:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.SelectDevices">SelectDevices()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_select_devices (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_remote_desktop_complete_start:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_start (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_remote_desktop_complete_notify_pointer_motion:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotion">NotifyPointerMotion()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_notify_pointer_motion (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_remote_desktop_complete_notify_pointer_motion_absolute:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_notify_pointer_motion_absolute (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_remote_desktop_complete_notify_pointer_button:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_notify_pointer_button (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_remote_desktop_complete_notify_pointer_axis:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_notify_pointer_axis (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_remote_desktop_complete_notify_pointer_axis_discrete:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_notify_pointer_axis_discrete (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_remote_desktop_complete_notify_keyboard_keycode:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_notify_keyboard_keycode (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_remote_desktop_complete_notify_keyboard_keysym:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_notify_keyboard_keysym (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_remote_desktop_complete_notify_touch_down:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_notify_touch_down (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_remote_desktop_complete_notify_touch_motion:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_notify_touch_motion (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_impl_remote_desktop_complete_notify_touch_up:
 * @object: A #XdpImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_remote_desktop_complete_notify_touch_up (
    XdpImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplRemoteDesktopProxy:
 *
 * The #XdpImplRemoteDesktopProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplRemoteDesktopProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplRemoteDesktopProxy.
 */

struct _XdpImplRemoteDesktopProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_remote_desktop_proxy_iface_init (XdpImplRemoteDesktopIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplRemoteDesktopProxy, xdp_impl_remote_desktop_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplRemoteDesktopProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_REMOTE_DESKTOP, xdp_impl_remote_desktop_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplRemoteDesktopProxy, xdp_impl_remote_desktop_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_REMOTE_DESKTOP, xdp_impl_remote_desktop_proxy_iface_init))

#endif
static void
xdp_impl_remote_desktop_proxy_finalize (GObject *object)
{
  XdpImplRemoteDesktopProxy *proxy = XDP_IMPL_REMOTE_DESKTOP_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_remote_desktop_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_remote_desktop_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_remote_desktop_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_impl_remote_desktop_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.RemoteDesktop: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_impl_remote_desktop_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_remote_desktop_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.RemoteDesktop", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_impl_remote_desktop_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_impl_remote_desktop_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_remote_desktop_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_REMOTE_DESKTOP);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_REMOTE_DESKTOP);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_remote_desktop_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplRemoteDesktopProxy *proxy = XDP_IMPL_REMOTE_DESKTOP_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_remote_desktop_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_remote_desktop_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_impl_remote_desktop_proxy_get_available_device_types (XdpImplRemoteDesktop *object)
{
  XdpImplRemoteDesktopProxy *proxy = XDP_IMPL_REMOTE_DESKTOP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AvailableDeviceTypes");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
xdp_impl_remote_desktop_proxy_get_version (XdpImplRemoteDesktop *object)
{
  XdpImplRemoteDesktopProxy *proxy = XDP_IMPL_REMOTE_DESKTOP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_impl_remote_desktop_proxy_init (XdpImplRemoteDesktopProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_remote_desktop_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_REMOTE_DESKTOP_PROXY, XdpImplRemoteDesktopProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_remote_desktop_interface_info ());
}

static void
xdp_impl_remote_desktop_proxy_class_init (XdpImplRemoteDesktopProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_remote_desktop_proxy_finalize;
  gobject_class->get_property = xdp_impl_remote_desktop_proxy_get_property;
  gobject_class->set_property = xdp_impl_remote_desktop_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_remote_desktop_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_remote_desktop_proxy_g_properties_changed;

  xdp_impl_remote_desktop_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplRemoteDesktopProxyPrivate));
#endif
}

static void
xdp_impl_remote_desktop_proxy_iface_init (XdpImplRemoteDesktopIface *iface)
{
  iface->get_available_device_types = xdp_impl_remote_desktop_proxy_get_available_device_types;
  iface->get_version = xdp_impl_remote_desktop_proxy_get_version;
}

/**
 * xdp_impl_remote_desktop_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_remote_desktop_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_REMOTE_DESKTOP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.RemoteDesktop", NULL);
}

/**
 * xdp_impl_remote_desktop_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_remote_desktop_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplRemoteDesktop *
xdp_impl_remote_desktop_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_REMOTE_DESKTOP (ret);
  else
    return NULL;
}

/**
 * xdp_impl_remote_desktop_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplRemoteDesktop *
xdp_impl_remote_desktop_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_REMOTE_DESKTOP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.RemoteDesktop", NULL);
  if (ret != NULL)
    return XDP_IMPL_REMOTE_DESKTOP (ret);
  else
    return NULL;
}


/**
 * xdp_impl_remote_desktop_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_remote_desktop_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_remote_desktop_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_remote_desktop_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_remote_desktop_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_REMOTE_DESKTOP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.RemoteDesktop", NULL);
}

/**
 * xdp_impl_remote_desktop_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_remote_desktop_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_remote_desktop_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplRemoteDesktop *
xdp_impl_remote_desktop_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_REMOTE_DESKTOP (ret);
  else
    return NULL;
}

/**
 * xdp_impl_remote_desktop_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_remote_desktop_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_remote_desktop_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplRemoteDesktop *
xdp_impl_remote_desktop_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_REMOTE_DESKTOP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.RemoteDesktop", NULL);
  if (ret != NULL)
    return XDP_IMPL_REMOTE_DESKTOP (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplRemoteDesktopSkeleton:
 *
 * The #XdpImplRemoteDesktopSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplRemoteDesktopSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplRemoteDesktopSkeleton.
 */

struct _XdpImplRemoteDesktopSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_remote_desktop_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplRemoteDesktopSkeleton *skeleton = XDP_IMPL_REMOTE_DESKTOP_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_REMOTE_DESKTOP);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_REMOTE_DESKTOP);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_remote_desktop_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplRemoteDesktopSkeleton *skeleton = XDP_IMPL_REMOTE_DESKTOP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_remote_desktop_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_remote_desktop_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplRemoteDesktopSkeleton *skeleton = XDP_IMPL_REMOTE_DESKTOP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_remote_desktop_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_remote_desktop_skeleton_vtable =
{
  _xdp_impl_remote_desktop_skeleton_handle_method_call,
  _xdp_impl_remote_desktop_skeleton_handle_get_property,
  _xdp_impl_remote_desktop_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_remote_desktop_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_remote_desktop_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_remote_desktop_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_remote_desktop_skeleton_vtable;
}

static GVariant *
xdp_impl_remote_desktop_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplRemoteDesktopSkeleton *skeleton = XDP_IMPL_REMOTE_DESKTOP_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_remote_desktop_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_remote_desktop_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_remote_desktop_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_remote_desktop_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.RemoteDesktop", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_impl_remote_desktop_emit_changed (gpointer user_data);

static void
xdp_impl_remote_desktop_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplRemoteDesktopSkeleton *skeleton = XDP_IMPL_REMOTE_DESKTOP_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_impl_remote_desktop_emit_changed (skeleton);
}

static void xdp_impl_remote_desktop_skeleton_iface_init (XdpImplRemoteDesktopIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplRemoteDesktopSkeleton, xdp_impl_remote_desktop_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplRemoteDesktopSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_REMOTE_DESKTOP, xdp_impl_remote_desktop_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplRemoteDesktopSkeleton, xdp_impl_remote_desktop_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_REMOTE_DESKTOP, xdp_impl_remote_desktop_skeleton_iface_init))

#endif
static void
xdp_impl_remote_desktop_skeleton_finalize (GObject *object)
{
  XdpImplRemoteDesktopSkeleton *skeleton = XDP_IMPL_REMOTE_DESKTOP_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_remote_desktop_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_remote_desktop_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpImplRemoteDesktopSkeleton *skeleton = XDP_IMPL_REMOTE_DESKTOP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_impl_remote_desktop_emit_changed (gpointer user_data)
{
  XdpImplRemoteDesktopSkeleton *skeleton = XDP_IMPL_REMOTE_DESKTOP_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.RemoteDesktop",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_impl_remote_desktop_schedule_emit_changed (XdpImplRemoteDesktopSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_impl_remote_desktop_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpImplRemoteDesktopSkeleton *skeleton = XDP_IMPL_REMOTE_DESKTOP_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_impl_remote_desktop_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_impl_remote_desktop_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_impl_remote_desktop_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpImplRemoteDesktopSkeleton *skeleton = XDP_IMPL_REMOTE_DESKTOP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_remote_desktop_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_impl_remote_desktop_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_impl_remote_desktop_skeleton_init (XdpImplRemoteDesktopSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_remote_desktop_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_REMOTE_DESKTOP_SKELETON, XdpImplRemoteDesktopSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
}

static guint 
xdp_impl_remote_desktop_skeleton_get_available_device_types (XdpImplRemoteDesktop *object)
{
  XdpImplRemoteDesktopSkeleton *skeleton = XDP_IMPL_REMOTE_DESKTOP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
xdp_impl_remote_desktop_skeleton_get_version (XdpImplRemoteDesktop *object)
{
  XdpImplRemoteDesktopSkeleton *skeleton = XDP_IMPL_REMOTE_DESKTOP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_impl_remote_desktop_skeleton_class_init (XdpImplRemoteDesktopSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_remote_desktop_skeleton_finalize;
  gobject_class->get_property = xdp_impl_remote_desktop_skeleton_get_property;
  gobject_class->set_property = xdp_impl_remote_desktop_skeleton_set_property;
  gobject_class->notify       = xdp_impl_remote_desktop_skeleton_notify;


  xdp_impl_remote_desktop_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_remote_desktop_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_remote_desktop_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_remote_desktop_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_remote_desktop_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplRemoteDesktopSkeletonPrivate));
#endif
}

static void
xdp_impl_remote_desktop_skeleton_iface_init (XdpImplRemoteDesktopIface *iface)
{
  iface->get_available_device_types = xdp_impl_remote_desktop_skeleton_get_available_device_types;
  iface->get_version = xdp_impl_remote_desktop_skeleton_get_version;
}

/**
 * xdp_impl_remote_desktop_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link>.
 *
 * Returns: (transfer full) (type XdpImplRemoteDesktopSkeleton): The skeleton object.
 */
XdpImplRemoteDesktop *
xdp_impl_remote_desktop_skeleton_new (void)
{
  return XDP_IMPL_REMOTE_DESKTOP (g_object_new (XDP_IMPL_TYPE_REMOTE_DESKTOP_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Request
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplRequest
 * @title: XdpImplRequest
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Request D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Request ---- */

static const _ExtendedGDBusMethodInfo _xdp_impl_request_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_request_method_info_pointers[] =
{
  &_xdp_impl_request_method_info_close.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_request_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Request",
    (GDBusMethodInfo **) &_xdp_impl_request_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "request",
};


/**
 * xdp_impl_request_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_request_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_request_interface_info.parent_struct;
}

/**
 * xdp_impl_request_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplRequest interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_request_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpImplRequest:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>.
 */

/**
 * XdpImplRequestIface:
 * @parent_iface: The parent interface.
 * @handle_close: Handler for the #XdpImplRequest::handle-close signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>.
 */

typedef XdpImplRequestIface XdpImplRequestInterface;
G_DEFINE_INTERFACE (XdpImplRequest, xdp_impl_request, G_TYPE_OBJECT)

static void
xdp_impl_request_default_init (XdpImplRequestIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplRequest::handle-close:
   * @object: A #XdpImplRequest.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_request_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplRequestIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * xdp_impl_request_call_close:
 * @proxy: A #XdpImplRequestProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_request_call_close_finish() to get the result of the operation.
 *
 * See xdp_impl_request_call_close_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_request_call_close (
    XdpImplRequest *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_request_call_close_finish:
 * @proxy: A #XdpImplRequestProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_request_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_request_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_request_call_close_finish (
    XdpImplRequest *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_request_call_close_sync:
 * @proxy: A #XdpImplRequestProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_request_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_request_call_close_sync (
    XdpImplRequest *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_request_complete_close:
 * @object: A #XdpImplRequest.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_request_complete_close (
    XdpImplRequest *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplRequestProxy:
 *
 * The #XdpImplRequestProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplRequestProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplRequestProxy.
 */

struct _XdpImplRequestProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_request_proxy_iface_init (XdpImplRequestIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplRequestProxy, xdp_impl_request_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplRequestProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_REQUEST, xdp_impl_request_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplRequestProxy, xdp_impl_request_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_REQUEST, xdp_impl_request_proxy_iface_init))

#endif
static void
xdp_impl_request_proxy_finalize (GObject *object)
{
  XdpImplRequestProxy *proxy = XDP_IMPL_REQUEST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_request_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_request_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_request_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_request_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_request_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_REQUEST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_REQUEST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_request_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplRequestProxy *proxy = XDP_IMPL_REQUEST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_request_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_request_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_request_proxy_init (XdpImplRequestProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_request_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_REQUEST_PROXY, XdpImplRequestProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_request_interface_info ());
}

static void
xdp_impl_request_proxy_class_init (XdpImplRequestProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_request_proxy_finalize;
  gobject_class->get_property = xdp_impl_request_proxy_get_property;
  gobject_class->set_property = xdp_impl_request_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_request_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_request_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplRequestProxyPrivate));
#endif
}

static void
xdp_impl_request_proxy_iface_init (XdpImplRequestIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_request_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_request_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_request_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_request_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_REQUEST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
}

/**
 * xdp_impl_request_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_request_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_request_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplRequest *
xdp_impl_request_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_REQUEST (ret);
  else
    return NULL;
}

/**
 * xdp_impl_request_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_request_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplRequest *
xdp_impl_request_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_REQUEST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
  if (ret != NULL)
    return XDP_IMPL_REQUEST (ret);
  else
    return NULL;
}


/**
 * xdp_impl_request_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_request_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_request_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_request_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_request_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_REQUEST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
}

/**
 * xdp_impl_request_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_request_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_request_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplRequest *
xdp_impl_request_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_REQUEST (ret);
  else
    return NULL;
}

/**
 * xdp_impl_request_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_request_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_request_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplRequest *
xdp_impl_request_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_REQUEST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
  if (ret != NULL)
    return XDP_IMPL_REQUEST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplRequestSkeleton:
 *
 * The #XdpImplRequestSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplRequestSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplRequestSkeleton.
 */

struct _XdpImplRequestSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_request_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplRequestSkeleton *skeleton = XDP_IMPL_REQUEST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_REQUEST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_REQUEST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_request_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplRequestSkeleton *skeleton = XDP_IMPL_REQUEST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_request_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_request_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplRequestSkeleton *skeleton = XDP_IMPL_REQUEST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_request_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_request_skeleton_vtable =
{
  _xdp_impl_request_skeleton_handle_method_call,
  _xdp_impl_request_skeleton_handle_get_property,
  _xdp_impl_request_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_request_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_request_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_request_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_request_skeleton_vtable;
}

static GVariant *
xdp_impl_request_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplRequestSkeleton *skeleton = XDP_IMPL_REQUEST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_request_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_request_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_request_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_request_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Request", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_request_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_impl_request_skeleton_iface_init (XdpImplRequestIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplRequestSkeleton, xdp_impl_request_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplRequestSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_REQUEST, xdp_impl_request_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplRequestSkeleton, xdp_impl_request_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_REQUEST, xdp_impl_request_skeleton_iface_init))

#endif
static void
xdp_impl_request_skeleton_finalize (GObject *object)
{
  XdpImplRequestSkeleton *skeleton = XDP_IMPL_REQUEST_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_request_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_request_skeleton_init (XdpImplRequestSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_request_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_REQUEST_SKELETON, XdpImplRequestSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_request_skeleton_class_init (XdpImplRequestSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_request_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_request_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_request_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_request_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_request_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplRequestSkeletonPrivate));
#endif
}

static void
xdp_impl_request_skeleton_iface_init (XdpImplRequestIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_request_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>.
 *
 * Returns: (transfer full) (type XdpImplRequestSkeleton): The skeleton object.
 */
XdpImplRequest *
xdp_impl_request_skeleton_new (void)
{
  return XDP_IMPL_REQUEST (g_object_new (XDP_IMPL_TYPE_REQUEST_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.ScreenCast
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplScreenCast
 * @title: XdpImplScreenCast
 * @short_description: Generated C code for the org.freedesktop.impl.portal.ScreenCast D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.ScreenCast ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_create_session_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_create_session_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_create_session_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_create_session_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screen_cast_method_info_create_session_IN_ARG_pointers[] =
{
  &_xdp_impl_screen_cast_method_info_create_session_IN_ARG_handle.parent_struct,
  &_xdp_impl_screen_cast_method_info_create_session_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_screen_cast_method_info_create_session_IN_ARG_app_id.parent_struct,
  &_xdp_impl_screen_cast_method_info_create_session_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_create_session_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_create_session_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screen_cast_method_info_create_session_OUT_ARG_pointers[] =
{
  &_xdp_impl_screen_cast_method_info_create_session_OUT_ARG_response.parent_struct,
  &_xdp_impl_screen_cast_method_info_create_session_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screen_cast_method_create_session_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screen_cast_method_create_session_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_screen_cast_method_create_session_annotation_info_pointers[] =
{
  &_xdp_impl_screen_cast_method_create_session_annotation_info_0,
  &_xdp_impl_screen_cast_method_create_session_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_screen_cast_method_info_create_session =
{
  {
    -1,
    (gchar *) "CreateSession",
    (GDBusArgInfo **) &_xdp_impl_screen_cast_method_info_create_session_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_screen_cast_method_info_create_session_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_screen_cast_method_create_session_annotation_info_pointers
  },
  "handle-create-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_select_sources_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_select_sources_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_select_sources_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_select_sources_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screen_cast_method_info_select_sources_IN_ARG_pointers[] =
{
  &_xdp_impl_screen_cast_method_info_select_sources_IN_ARG_handle.parent_struct,
  &_xdp_impl_screen_cast_method_info_select_sources_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_screen_cast_method_info_select_sources_IN_ARG_app_id.parent_struct,
  &_xdp_impl_screen_cast_method_info_select_sources_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_select_sources_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_select_sources_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screen_cast_method_info_select_sources_OUT_ARG_pointers[] =
{
  &_xdp_impl_screen_cast_method_info_select_sources_OUT_ARG_response.parent_struct,
  &_xdp_impl_screen_cast_method_info_select_sources_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screen_cast_method_select_sources_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screen_cast_method_select_sources_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_screen_cast_method_select_sources_annotation_info_pointers[] =
{
  &_xdp_impl_screen_cast_method_select_sources_annotation_info_0,
  &_xdp_impl_screen_cast_method_select_sources_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_screen_cast_method_info_select_sources =
{
  {
    -1,
    (gchar *) "SelectSources",
    (GDBusArgInfo **) &_xdp_impl_screen_cast_method_info_select_sources_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_screen_cast_method_info_select_sources_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_screen_cast_method_select_sources_annotation_info_pointers
  },
  "handle-select-sources",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_start_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_start_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_start_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_start_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_start_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screen_cast_method_info_start_IN_ARG_pointers[] =
{
  &_xdp_impl_screen_cast_method_info_start_IN_ARG_handle.parent_struct,
  &_xdp_impl_screen_cast_method_info_start_IN_ARG_session_handle.parent_struct,
  &_xdp_impl_screen_cast_method_info_start_IN_ARG_app_id.parent_struct,
  &_xdp_impl_screen_cast_method_info_start_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_screen_cast_method_info_start_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_start_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screen_cast_method_info_start_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screen_cast_method_info_start_OUT_ARG_pointers[] =
{
  &_xdp_impl_screen_cast_method_info_start_OUT_ARG_response.parent_struct,
  &_xdp_impl_screen_cast_method_info_start_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screen_cast_method_start_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screen_cast_method_start_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_screen_cast_method_start_annotation_info_pointers[] =
{
  &_xdp_impl_screen_cast_method_start_annotation_info_0,
  &_xdp_impl_screen_cast_method_start_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_screen_cast_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    (GDBusArgInfo **) &_xdp_impl_screen_cast_method_info_start_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_screen_cast_method_info_start_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_screen_cast_method_start_annotation_info_pointers
  },
  "handle-start",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_screen_cast_method_info_pointers[] =
{
  &_xdp_impl_screen_cast_method_info_create_session.parent_struct,
  &_xdp_impl_screen_cast_method_info_select_sources.parent_struct,
  &_xdp_impl_screen_cast_method_info_start.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_screen_cast_property_info_available_source_types =
{
  {
    -1,
    (gchar *) "AvailableSourceTypes",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "available-source-types",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_screen_cast_property_info_available_cursor_modes =
{
  {
    -1,
    (gchar *) "AvailableCursorModes",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "available-cursor-modes",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_screen_cast_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_impl_screen_cast_property_info_pointers[] =
{
  &_xdp_impl_screen_cast_property_info_available_source_types.parent_struct,
  &_xdp_impl_screen_cast_property_info_available_cursor_modes.parent_struct,
  &_xdp_impl_screen_cast_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_screen_cast_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.ScreenCast",
    (GDBusMethodInfo **) &_xdp_impl_screen_cast_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_impl_screen_cast_property_info_pointers,
    NULL
  },
  "screen-cast",
};


/**
 * xdp_impl_screen_cast_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_screen_cast_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_screen_cast_interface_info.parent_struct;
}

/**
 * xdp_impl_screen_cast_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplScreenCast interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_screen_cast_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "available-source-types");
  g_object_class_override_property (klass, property_id_begin++, "available-cursor-modes");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpImplScreenCast:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link>.
 */

/**
 * XdpImplScreenCastIface:
 * @parent_iface: The parent interface.
 * @handle_create_session: Handler for the #XdpImplScreenCast::handle-create-session signal.
 * @handle_select_sources: Handler for the #XdpImplScreenCast::handle-select-sources signal.
 * @handle_start: Handler for the #XdpImplScreenCast::handle-start signal.
 * @get_available_cursor_modes: Getter for the #XdpImplScreenCast:available-cursor-modes property.
 * @get_available_source_types: Getter for the #XdpImplScreenCast:available-source-types property.
 * @get_version: Getter for the #XdpImplScreenCast:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link>.
 */

typedef XdpImplScreenCastIface XdpImplScreenCastInterface;
G_DEFINE_INTERFACE (XdpImplScreenCast, xdp_impl_screen_cast, G_TYPE_OBJECT)

static void
xdp_impl_screen_cast_default_init (XdpImplScreenCastIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplScreenCast::handle-create-session:
   * @object: A #XdpImplScreenCast.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.CreateSession">CreateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_screen_cast_complete_create_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplScreenCastIface, handle_create_session),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpImplScreenCast::handle-select-sources:
   * @object: A #XdpImplScreenCast.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.SelectSources">SelectSources()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_screen_cast_complete_select_sources() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-sources",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplScreenCastIface, handle_select_sources),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpImplScreenCast::handle-start:
   * @object: A #XdpImplScreenCast.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_screen_cast_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplScreenCastIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpImplScreenCast:available-source-types:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.AvailableSourceTypes">"AvailableSourceTypes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("available-source-types", "AvailableSourceTypes", "AvailableSourceTypes", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplScreenCast:available-cursor-modes:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.AvailableCursorModes">"AvailableCursorModes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("available-cursor-modes", "AvailableCursorModes", "AvailableCursorModes", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpImplScreenCast:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_impl_screen_cast_get_available_source_types: (skip)
 * @object: A #XdpImplScreenCast.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.AvailableSourceTypes">"AvailableSourceTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_impl_screen_cast_get_available_source_types (XdpImplScreenCast *object)
{
  return XDP_IMPL_SCREEN_CAST_GET_IFACE (object)->get_available_source_types (object);
}

/**
 * xdp_impl_screen_cast_set_available_source_types: (skip)
 * @object: A #XdpImplScreenCast.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.AvailableSourceTypes">"AvailableSourceTypes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_impl_screen_cast_set_available_source_types (XdpImplScreenCast *object, guint value)
{
  g_object_set (G_OBJECT (object), "available-source-types", value, NULL);
}

/**
 * xdp_impl_screen_cast_get_available_cursor_modes: (skip)
 * @object: A #XdpImplScreenCast.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.AvailableCursorModes">"AvailableCursorModes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_impl_screen_cast_get_available_cursor_modes (XdpImplScreenCast *object)
{
  return XDP_IMPL_SCREEN_CAST_GET_IFACE (object)->get_available_cursor_modes (object);
}

/**
 * xdp_impl_screen_cast_set_available_cursor_modes: (skip)
 * @object: A #XdpImplScreenCast.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.AvailableCursorModes">"AvailableCursorModes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_impl_screen_cast_set_available_cursor_modes (XdpImplScreenCast *object, guint value)
{
  g_object_set (G_OBJECT (object), "available-cursor-modes", value, NULL);
}

/**
 * xdp_impl_screen_cast_get_version: (skip)
 * @object: A #XdpImplScreenCast.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_impl_screen_cast_get_version (XdpImplScreenCast *object)
{
  return XDP_IMPL_SCREEN_CAST_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_impl_screen_cast_set_version: (skip)
 * @object: A #XdpImplScreenCast.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_impl_screen_cast_set_version (XdpImplScreenCast *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_impl_screen_cast_call_create_session:
 * @proxy: A #XdpImplScreenCastProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.CreateSession">CreateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screen_cast_call_create_session_finish() to get the result of the operation.
 *
 * See xdp_impl_screen_cast_call_create_session_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_screen_cast_call_create_session (
    XdpImplScreenCast *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_screen_cast_call_create_session_finish:
 * @proxy: A #XdpImplScreenCastProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screen_cast_call_create_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_screen_cast_call_create_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screen_cast_call_create_session_finish (
    XdpImplScreenCast *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screen_cast_call_create_session_sync:
 * @proxy: A #XdpImplScreenCastProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.CreateSession">CreateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screen_cast_call_create_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screen_cast_call_create_session_sync (
    XdpImplScreenCast *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screen_cast_call_select_sources:
 * @proxy: A #XdpImplScreenCastProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.SelectSources">SelectSources()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screen_cast_call_select_sources_finish() to get the result of the operation.
 *
 * See xdp_impl_screen_cast_call_select_sources_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_screen_cast_call_select_sources (
    XdpImplScreenCast *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectSources",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_screen_cast_call_select_sources_finish:
 * @proxy: A #XdpImplScreenCastProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screen_cast_call_select_sources().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_screen_cast_call_select_sources().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screen_cast_call_select_sources_finish (
    XdpImplScreenCast *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screen_cast_call_select_sources_sync:
 * @proxy: A #XdpImplScreenCastProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.SelectSources">SelectSources()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screen_cast_call_select_sources() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screen_cast_call_select_sources_sync (
    XdpImplScreenCast *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectSources",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screen_cast_call_start:
 * @proxy: A #XdpImplScreenCastProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screen_cast_call_start_finish() to get the result of the operation.
 *
 * See xdp_impl_screen_cast_call_start_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_screen_cast_call_start (
    XdpImplScreenCast *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(ooss@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_screen_cast_call_start_finish:
 * @proxy: A #XdpImplScreenCastProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screen_cast_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_screen_cast_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screen_cast_call_start_finish (
    XdpImplScreenCast *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screen_cast_call_start_sync:
 * @proxy: A #XdpImplScreenCastProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screen_cast_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screen_cast_call_start_sync (
    XdpImplScreenCast *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(ooss@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screen_cast_complete_create_session:
 * @object: A #XdpImplScreenCast.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.CreateSession">CreateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_screen_cast_complete_create_session (
    XdpImplScreenCast *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_screen_cast_complete_select_sources:
 * @object: A #XdpImplScreenCast.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.SelectSources">SelectSources()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_screen_cast_complete_select_sources (
    XdpImplScreenCast *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_screen_cast_complete_start:
 * @object: A #XdpImplScreenCast.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_screen_cast_complete_start (
    XdpImplScreenCast *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplScreenCastProxy:
 *
 * The #XdpImplScreenCastProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplScreenCastProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplScreenCastProxy.
 */

struct _XdpImplScreenCastProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_screen_cast_proxy_iface_init (XdpImplScreenCastIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplScreenCastProxy, xdp_impl_screen_cast_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplScreenCastProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SCREEN_CAST, xdp_impl_screen_cast_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplScreenCastProxy, xdp_impl_screen_cast_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SCREEN_CAST, xdp_impl_screen_cast_proxy_iface_init))

#endif
static void
xdp_impl_screen_cast_proxy_finalize (GObject *object)
{
  XdpImplScreenCastProxy *proxy = XDP_IMPL_SCREEN_CAST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_screen_cast_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_screen_cast_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_screen_cast_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_impl_screen_cast_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.ScreenCast: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_impl_screen_cast_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_screen_cast_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.ScreenCast", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_impl_screen_cast_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_impl_screen_cast_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_screen_cast_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_SCREEN_CAST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_SCREEN_CAST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_screen_cast_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplScreenCastProxy *proxy = XDP_IMPL_SCREEN_CAST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_screen_cast_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_screen_cast_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_impl_screen_cast_proxy_get_available_source_types (XdpImplScreenCast *object)
{
  XdpImplScreenCastProxy *proxy = XDP_IMPL_SCREEN_CAST_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AvailableSourceTypes");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
xdp_impl_screen_cast_proxy_get_available_cursor_modes (XdpImplScreenCast *object)
{
  XdpImplScreenCastProxy *proxy = XDP_IMPL_SCREEN_CAST_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AvailableCursorModes");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
xdp_impl_screen_cast_proxy_get_version (XdpImplScreenCast *object)
{
  XdpImplScreenCastProxy *proxy = XDP_IMPL_SCREEN_CAST_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_impl_screen_cast_proxy_init (XdpImplScreenCastProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_screen_cast_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_SCREEN_CAST_PROXY, XdpImplScreenCastProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_screen_cast_interface_info ());
}

static void
xdp_impl_screen_cast_proxy_class_init (XdpImplScreenCastProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_screen_cast_proxy_finalize;
  gobject_class->get_property = xdp_impl_screen_cast_proxy_get_property;
  gobject_class->set_property = xdp_impl_screen_cast_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_screen_cast_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_screen_cast_proxy_g_properties_changed;

  xdp_impl_screen_cast_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplScreenCastProxyPrivate));
#endif
}

static void
xdp_impl_screen_cast_proxy_iface_init (XdpImplScreenCastIface *iface)
{
  iface->get_available_source_types = xdp_impl_screen_cast_proxy_get_available_source_types;
  iface->get_available_cursor_modes = xdp_impl_screen_cast_proxy_get_available_cursor_modes;
  iface->get_version = xdp_impl_screen_cast_proxy_get_version;
}

/**
 * xdp_impl_screen_cast_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screen_cast_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_screen_cast_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_screen_cast_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_SCREEN_CAST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.ScreenCast", NULL);
}

/**
 * xdp_impl_screen_cast_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screen_cast_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_screen_cast_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplScreenCast *
xdp_impl_screen_cast_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_SCREEN_CAST (ret);
  else
    return NULL;
}

/**
 * xdp_impl_screen_cast_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screen_cast_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplScreenCast *
xdp_impl_screen_cast_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_SCREEN_CAST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.ScreenCast", NULL);
  if (ret != NULL)
    return XDP_IMPL_SCREEN_CAST (ret);
  else
    return NULL;
}


/**
 * xdp_impl_screen_cast_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_screen_cast_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screen_cast_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_screen_cast_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_screen_cast_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_SCREEN_CAST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.ScreenCast", NULL);
}

/**
 * xdp_impl_screen_cast_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screen_cast_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_screen_cast_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplScreenCast *
xdp_impl_screen_cast_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_SCREEN_CAST (ret);
  else
    return NULL;
}

/**
 * xdp_impl_screen_cast_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_screen_cast_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screen_cast_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplScreenCast *
xdp_impl_screen_cast_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_SCREEN_CAST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.ScreenCast", NULL);
  if (ret != NULL)
    return XDP_IMPL_SCREEN_CAST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplScreenCastSkeleton:
 *
 * The #XdpImplScreenCastSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplScreenCastSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplScreenCastSkeleton.
 */

struct _XdpImplScreenCastSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_screen_cast_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_SCREEN_CAST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_SCREEN_CAST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_screen_cast_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_screen_cast_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_screen_cast_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_screen_cast_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_screen_cast_skeleton_vtable =
{
  _xdp_impl_screen_cast_skeleton_handle_method_call,
  _xdp_impl_screen_cast_skeleton_handle_get_property,
  _xdp_impl_screen_cast_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_screen_cast_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_screen_cast_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_screen_cast_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_screen_cast_skeleton_vtable;
}

static GVariant *
xdp_impl_screen_cast_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_screen_cast_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_screen_cast_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_screen_cast_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_screen_cast_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.ScreenCast", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_impl_screen_cast_emit_changed (gpointer user_data);

static void
xdp_impl_screen_cast_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_impl_screen_cast_emit_changed (skeleton);
}

static void xdp_impl_screen_cast_skeleton_iface_init (XdpImplScreenCastIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplScreenCastSkeleton, xdp_impl_screen_cast_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplScreenCastSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SCREEN_CAST, xdp_impl_screen_cast_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplScreenCastSkeleton, xdp_impl_screen_cast_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SCREEN_CAST, xdp_impl_screen_cast_skeleton_iface_init))

#endif
static void
xdp_impl_screen_cast_skeleton_finalize (GObject *object)
{
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_screen_cast_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_screen_cast_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_impl_screen_cast_emit_changed (gpointer user_data)
{
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.ScreenCast",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_impl_screen_cast_schedule_emit_changed (XdpImplScreenCastSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_impl_screen_cast_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_impl_screen_cast_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_impl_screen_cast_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_impl_screen_cast_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_screen_cast_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_impl_screen_cast_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_impl_screen_cast_skeleton_init (XdpImplScreenCastSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_screen_cast_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_SCREEN_CAST_SKELETON, XdpImplScreenCastSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_UINT);
}

static guint 
xdp_impl_screen_cast_skeleton_get_available_source_types (XdpImplScreenCast *object)
{
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
xdp_impl_screen_cast_skeleton_get_available_cursor_modes (XdpImplScreenCast *object)
{
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
xdp_impl_screen_cast_skeleton_get_version (XdpImplScreenCast *object)
{
  XdpImplScreenCastSkeleton *skeleton = XDP_IMPL_SCREEN_CAST_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_impl_screen_cast_skeleton_class_init (XdpImplScreenCastSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_screen_cast_skeleton_finalize;
  gobject_class->get_property = xdp_impl_screen_cast_skeleton_get_property;
  gobject_class->set_property = xdp_impl_screen_cast_skeleton_set_property;
  gobject_class->notify       = xdp_impl_screen_cast_skeleton_notify;


  xdp_impl_screen_cast_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_screen_cast_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_screen_cast_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_screen_cast_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_screen_cast_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplScreenCastSkeletonPrivate));
#endif
}

static void
xdp_impl_screen_cast_skeleton_iface_init (XdpImplScreenCastIface *iface)
{
  iface->get_available_source_types = xdp_impl_screen_cast_skeleton_get_available_source_types;
  iface->get_available_cursor_modes = xdp_impl_screen_cast_skeleton_get_available_cursor_modes;
  iface->get_version = xdp_impl_screen_cast_skeleton_get_version;
}

/**
 * xdp_impl_screen_cast_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link>.
 *
 * Returns: (transfer full) (type XdpImplScreenCastSkeleton): The skeleton object.
 */
XdpImplScreenCast *
xdp_impl_screen_cast_skeleton_new (void)
{
  return XDP_IMPL_SCREEN_CAST (g_object_new (XDP_IMPL_TYPE_SCREEN_CAST_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Screenshot
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplScreenshot
 * @title: XdpImplScreenshot
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Screenshot D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Screenshot ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_screenshot_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_screenshot_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_screenshot_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_screenshot_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screenshot_method_info_screenshot_IN_ARG_pointers[] =
{
  &_xdp_impl_screenshot_method_info_screenshot_IN_ARG_handle.parent_struct,
  &_xdp_impl_screenshot_method_info_screenshot_IN_ARG_app_id.parent_struct,
  &_xdp_impl_screenshot_method_info_screenshot_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_screenshot_method_info_screenshot_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_screenshot_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_screenshot_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screenshot_method_info_screenshot_OUT_ARG_pointers[] =
{
  &_xdp_impl_screenshot_method_info_screenshot_OUT_ARG_response.parent_struct,
  &_xdp_impl_screenshot_method_info_screenshot_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screenshot_method_screenshot_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screenshot_method_screenshot_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_screenshot_method_screenshot_annotation_info_pointers[] =
{
  &_xdp_impl_screenshot_method_screenshot_annotation_info_0,
  &_xdp_impl_screenshot_method_screenshot_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_screenshot_method_info_screenshot =
{
  {
    -1,
    (gchar *) "Screenshot",
    (GDBusArgInfo **) &_xdp_impl_screenshot_method_info_screenshot_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_screenshot_method_info_screenshot_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_screenshot_method_screenshot_annotation_info_pointers
  },
  "handle-screenshot",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_pick_color_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_pick_color_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_pick_color_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_pick_color_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screenshot_method_info_pick_color_IN_ARG_pointers[] =
{
  &_xdp_impl_screenshot_method_info_pick_color_IN_ARG_handle.parent_struct,
  &_xdp_impl_screenshot_method_info_pick_color_IN_ARG_app_id.parent_struct,
  &_xdp_impl_screenshot_method_info_pick_color_IN_ARG_parent_window.parent_struct,
  &_xdp_impl_screenshot_method_info_pick_color_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_pick_color_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_screenshot_method_info_pick_color_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_screenshot_method_info_pick_color_OUT_ARG_pointers[] =
{
  &_xdp_impl_screenshot_method_info_pick_color_OUT_ARG_response.parent_struct,
  &_xdp_impl_screenshot_method_info_pick_color_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screenshot_method_pick_color_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_screenshot_method_pick_color_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_screenshot_method_pick_color_annotation_info_pointers[] =
{
  &_xdp_impl_screenshot_method_pick_color_annotation_info_0,
  &_xdp_impl_screenshot_method_pick_color_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_screenshot_method_info_pick_color =
{
  {
    -1,
    (gchar *) "PickColor",
    (GDBusArgInfo **) &_xdp_impl_screenshot_method_info_pick_color_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_screenshot_method_info_pick_color_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_screenshot_method_pick_color_annotation_info_pointers
  },
  "handle-pick-color",
  FALSE
};

static const GDBusMethodInfo * const _xdp_impl_screenshot_method_info_pointers[] =
{
  &_xdp_impl_screenshot_method_info_screenshot.parent_struct,
  &_xdp_impl_screenshot_method_info_pick_color.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_screenshot_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Screenshot",
    (GDBusMethodInfo **) &_xdp_impl_screenshot_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "screenshot",
};


/**
 * xdp_impl_screenshot_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_screenshot_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_screenshot_interface_info.parent_struct;
}

/**
 * xdp_impl_screenshot_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplScreenshot interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_screenshot_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpImplScreenshot:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>.
 */

/**
 * XdpImplScreenshotIface:
 * @parent_iface: The parent interface.
 * @handle_pick_color: Handler for the #XdpImplScreenshot::handle-pick-color signal.
 * @handle_screenshot: Handler for the #XdpImplScreenshot::handle-screenshot signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>.
 */

typedef XdpImplScreenshotIface XdpImplScreenshotInterface;
G_DEFINE_INTERFACE (XdpImplScreenshot, xdp_impl_screenshot, G_TYPE_OBJECT)

static void
xdp_impl_screenshot_default_init (XdpImplScreenshotIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplScreenshot::handle-screenshot:
   * @object: A #XdpImplScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.Screenshot">Screenshot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_screenshot_complete_screenshot() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-screenshot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplScreenshotIface, handle_screenshot),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpImplScreenshot::handle-pick-color:
   * @object: A #XdpImplScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.PickColor">PickColor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_screenshot_complete_pick_color() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pick-color",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplScreenshotIface, handle_pick_color),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_impl_screenshot_call_screenshot:
 * @proxy: A #XdpImplScreenshotProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.Screenshot">Screenshot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screenshot_call_screenshot_finish() to get the result of the operation.
 *
 * See xdp_impl_screenshot_call_screenshot_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_screenshot_call_screenshot (
    XdpImplScreenshot *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Screenshot",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_screenshot_call_screenshot_finish:
 * @proxy: A #XdpImplScreenshotProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screenshot_call_screenshot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_screenshot_call_screenshot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screenshot_call_screenshot_finish (
    XdpImplScreenshot *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screenshot_call_screenshot_sync:
 * @proxy: A #XdpImplScreenshotProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.Screenshot">Screenshot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screenshot_call_screenshot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screenshot_call_screenshot_sync (
    XdpImplScreenshot *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Screenshot",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screenshot_call_pick_color:
 * @proxy: A #XdpImplScreenshotProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.PickColor">PickColor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screenshot_call_pick_color_finish() to get the result of the operation.
 *
 * See xdp_impl_screenshot_call_pick_color_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_screenshot_call_pick_color (
    XdpImplScreenshot *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PickColor",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_screenshot_call_pick_color_finish:
 * @proxy: A #XdpImplScreenshotProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screenshot_call_pick_color().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_screenshot_call_pick_color().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screenshot_call_pick_color_finish (
    XdpImplScreenshot *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screenshot_call_pick_color_sync:
 * @proxy: A #XdpImplScreenshotProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.PickColor">PickColor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screenshot_call_pick_color() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_screenshot_call_pick_color_sync (
    XdpImplScreenshot *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PickColor",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_screenshot_complete_screenshot:
 * @object: A #XdpImplScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.Screenshot">Screenshot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_screenshot_complete_screenshot (
    XdpImplScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_impl_screenshot_complete_pick_color:
 * @object: A #XdpImplScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.PickColor">PickColor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_screenshot_complete_pick_color (
    XdpImplScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplScreenshotProxy:
 *
 * The #XdpImplScreenshotProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplScreenshotProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplScreenshotProxy.
 */

struct _XdpImplScreenshotProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_screenshot_proxy_iface_init (XdpImplScreenshotIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplScreenshotProxy, xdp_impl_screenshot_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplScreenshotProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SCREENSHOT, xdp_impl_screenshot_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplScreenshotProxy, xdp_impl_screenshot_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SCREENSHOT, xdp_impl_screenshot_proxy_iface_init))

#endif
static void
xdp_impl_screenshot_proxy_finalize (GObject *object)
{
  XdpImplScreenshotProxy *proxy = XDP_IMPL_SCREENSHOT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_screenshot_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_screenshot_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_screenshot_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_impl_screenshot_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_screenshot_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_SCREENSHOT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_SCREENSHOT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_screenshot_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplScreenshotProxy *proxy = XDP_IMPL_SCREENSHOT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_screenshot_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_screenshot_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_impl_screenshot_proxy_init (XdpImplScreenshotProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_screenshot_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_SCREENSHOT_PROXY, XdpImplScreenshotProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_screenshot_interface_info ());
}

static void
xdp_impl_screenshot_proxy_class_init (XdpImplScreenshotProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_screenshot_proxy_finalize;
  gobject_class->get_property = xdp_impl_screenshot_proxy_get_property;
  gobject_class->set_property = xdp_impl_screenshot_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_screenshot_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_screenshot_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplScreenshotProxyPrivate));
#endif
}

static void
xdp_impl_screenshot_proxy_iface_init (XdpImplScreenshotIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_screenshot_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screenshot_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_screenshot_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_screenshot_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_SCREENSHOT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Screenshot", NULL);
}

/**
 * xdp_impl_screenshot_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screenshot_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_screenshot_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplScreenshot *
xdp_impl_screenshot_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_SCREENSHOT (ret);
  else
    return NULL;
}

/**
 * xdp_impl_screenshot_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screenshot_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplScreenshot *
xdp_impl_screenshot_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_SCREENSHOT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Screenshot", NULL);
  if (ret != NULL)
    return XDP_IMPL_SCREENSHOT (ret);
  else
    return NULL;
}


/**
 * xdp_impl_screenshot_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_screenshot_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_screenshot_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_screenshot_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_screenshot_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_SCREENSHOT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Screenshot", NULL);
}

/**
 * xdp_impl_screenshot_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_screenshot_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_screenshot_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplScreenshot *
xdp_impl_screenshot_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_SCREENSHOT (ret);
  else
    return NULL;
}

/**
 * xdp_impl_screenshot_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_screenshot_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_screenshot_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplScreenshot *
xdp_impl_screenshot_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_SCREENSHOT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Screenshot", NULL);
  if (ret != NULL)
    return XDP_IMPL_SCREENSHOT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplScreenshotSkeleton:
 *
 * The #XdpImplScreenshotSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplScreenshotSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplScreenshotSkeleton.
 */

struct _XdpImplScreenshotSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_screenshot_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_SCREENSHOT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_SCREENSHOT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_screenshot_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_screenshot_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_screenshot_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_screenshot_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_screenshot_skeleton_vtable =
{
  _xdp_impl_screenshot_skeleton_handle_method_call,
  _xdp_impl_screenshot_skeleton_handle_get_property,
  _xdp_impl_screenshot_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_screenshot_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_screenshot_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_screenshot_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_screenshot_skeleton_vtable;
}

static GVariant *
xdp_impl_screenshot_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_screenshot_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_screenshot_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_screenshot_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_screenshot_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Screenshot", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_impl_screenshot_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_impl_screenshot_skeleton_iface_init (XdpImplScreenshotIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplScreenshotSkeleton, xdp_impl_screenshot_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplScreenshotSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SCREENSHOT, xdp_impl_screenshot_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplScreenshotSkeleton, xdp_impl_screenshot_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SCREENSHOT, xdp_impl_screenshot_skeleton_iface_init))

#endif
static void
xdp_impl_screenshot_skeleton_finalize (GObject *object)
{
  XdpImplScreenshotSkeleton *skeleton = XDP_IMPL_SCREENSHOT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_screenshot_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_screenshot_skeleton_init (XdpImplScreenshotSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_impl_screenshot_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_IMPL_TYPE_SCREENSHOT_SKELETON, XdpImplScreenshotSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_impl_screenshot_skeleton_class_init (XdpImplScreenshotSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_impl_screenshot_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_impl_screenshot_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_impl_screenshot_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_impl_screenshot_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_impl_screenshot_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplScreenshotSkeletonPrivate));
#endif
}

static void
xdp_impl_screenshot_skeleton_iface_init (XdpImplScreenshotIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_impl_screenshot_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>.
 *
 * Returns: (transfer full) (type XdpImplScreenshotSkeleton): The skeleton object.
 */
XdpImplScreenshot *
xdp_impl_screenshot_skeleton_new (void)
{
  return XDP_IMPL_SCREENSHOT (g_object_new (XDP_IMPL_TYPE_SCREENSHOT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Secret
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpImplSecret
 * @title: XdpImplSecret
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Secret D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Secret.top_of_page">org.freedesktop.impl.portal.Secret</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Secret ---- */

static const _ExtendedGDBusArgInfo _xdp_impl_secret_method_info_retrieve_secret_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_secret_method_info_retrieve_secret_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_secret_method_info_retrieve_secret_IN_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_secret_method_info_retrieve_secret_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_secret_method_info_retrieve_secret_IN_ARG_pointers[] =
{
  &_xdp_impl_secret_method_info_retrieve_secret_IN_ARG_handle.parent_struct,
  &_xdp_impl_secret_method_info_retrieve_secret_IN_ARG_app_id.parent_struct,
  &_xdp_impl_secret_method_info_retrieve_secret_IN_ARG_fd.parent_struct,
  &_xdp_impl_secret_method_info_retrieve_secret_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_impl_secret_method_info_retrieve_secret_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_impl_secret_method_info_retrieve_secret_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_impl_secret_method_info_retrieve_secret_OUT_ARG_pointers[] =
{
  &_xdp_impl_secret_method_info_retrieve_secret_OUT_ARG_response.parent_struct,
  &_xdp_impl_secret_method_info_retrieve_secret_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_secret_method_retrieve_secret_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_impl_secret_method_retrieve_secret_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_impl_secret_method_retrieve_secret_annotation_info_pointers[] =
{
  &_xdp_impl_secret_method_retrieve_secret_annotation_info_0,
  &_xdp_impl_secret_method_retrieve_secret_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_impl_secret_method_info_retrieve_secret =
{
  {
    -1,
    (gchar *) "RetrieveSecret",
    (GDBusArgInfo **) &_xdp_impl_secret_method_info_retrieve_secret_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_impl_secret_method_info_retrieve_secret_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_impl_secret_method_retrieve_secret_annotation_info_pointers
  },
  "handle-retrieve-secret",
  TRUE
};

static const GDBusMethodInfo * const _xdp_impl_secret_method_info_pointers[] =
{
  &_xdp_impl_secret_method_info_retrieve_secret.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_impl_secret_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_impl_secret_property_info_pointers[] =
{
  &_xdp_impl_secret_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_impl_secret_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Secret",
    (GDBusMethodInfo **) &_xdp_impl_secret_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_impl_secret_property_info_pointers,
    NULL
  },
  "secret",
};


/**
 * xdp_impl_secret_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Secret.top_of_page">org.freedesktop.impl.portal.Secret</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_impl_secret_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_impl_secret_interface_info.parent_struct;
}

/**
 * xdp_impl_secret_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpImplSecret interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_impl_secret_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpImplSecret:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Secret.top_of_page">org.freedesktop.impl.portal.Secret</link>.
 */

/**
 * XdpImplSecretIface:
 * @parent_iface: The parent interface.
 * @handle_retrieve_secret: Handler for the #XdpImplSecret::handle-retrieve-secret signal.
 * @get_version: Getter for the #XdpImplSecret:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Secret.top_of_page">org.freedesktop.impl.portal.Secret</link>.
 */

typedef XdpImplSecretIface XdpImplSecretInterface;
G_DEFINE_INTERFACE (XdpImplSecret, xdp_impl_secret, G_TYPE_OBJECT)

static void
xdp_impl_secret_default_init (XdpImplSecretIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpImplSecret::handle-retrieve-secret:
   * @object: A #XdpImplSecret.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_fd: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Secret.RetrieveSecret">RetrieveSecret()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_impl_secret_complete_retrieve_secret() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-retrieve-secret",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpImplSecretIface, handle_retrieve_secret),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpImplSecret:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Secret.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_impl_secret_get_version: (skip)
 * @object: A #XdpImplSecret.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Secret.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_impl_secret_get_version (XdpImplSecret *object)
{
  return XDP_IMPL_SECRET_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_impl_secret_set_version: (skip)
 * @object: A #XdpImplSecret.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Secret.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_impl_secret_set_version (XdpImplSecret *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_impl_secret_call_retrieve_secret:
 * @proxy: A #XdpImplSecretProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_fd: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Secret.RetrieveSecret">RetrieveSecret()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_secret_call_retrieve_secret_finish() to get the result of the operation.
 *
 * See xdp_impl_secret_call_retrieve_secret_sync() for the synchronous, blocking version of this method.
 */
void
xdp_impl_secret_call_retrieve_secret (
    XdpImplSecret *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    GVariant *arg_fd,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "RetrieveSecret",
    g_variant_new ("(os@h@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_fd,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_impl_secret_call_retrieve_secret_finish:
 * @proxy: A #XdpImplSecretProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_secret_call_retrieve_secret().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_impl_secret_call_retrieve_secret().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_secret_call_retrieve_secret_finish (
    XdpImplSecret *proxy,
    guint *out_response,
    GVariant **out_results,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_secret_call_retrieve_secret_sync:
 * @proxy: A #XdpImplSecretProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_fd: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Secret.RetrieveSecret">RetrieveSecret()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_secret_call_retrieve_secret() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_impl_secret_call_retrieve_secret_sync (
    XdpImplSecret *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    GVariant *arg_fd,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    guint *out_response,
    GVariant **out_results,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "RetrieveSecret",
    g_variant_new ("(os@h@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_fd,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_impl_secret_complete_retrieve_secret:
 * @object: A #XdpImplSecret.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Secret.RetrieveSecret">RetrieveSecret()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_impl_secret_complete_retrieve_secret (
    XdpImplSecret *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * XdpImplSecretProxy:
 *
 * The #XdpImplSecretProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplSecretProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplSecretProxy.
 */

struct _XdpImplSecretProxyPrivate
{
  GData *qdata;
};

static void xdp_impl_secret_proxy_iface_init (XdpImplSecretIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplSecretProxy, xdp_impl_secret_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpImplSecretProxy)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SECRET, xdp_impl_secret_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplSecretProxy, xdp_impl_secret_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SECRET, xdp_impl_secret_proxy_iface_init))

#endif
static void
xdp_impl_secret_proxy_finalize (GObject *object)
{
  XdpImplSecretProxy *proxy = XDP_IMPL_SECRET_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_impl_secret_proxy_parent_class)->finalize (object);
}

static void
xdp_impl_secret_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_secret_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_impl_secret_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.Secret: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_impl_secret_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_impl_secret_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.Secret", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_impl_secret_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_impl_secret_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_impl_secret_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_IMPL_TYPE_SECRET);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_SECRET);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_impl_secret_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpImplSecretProxy *proxy = XDP_IMPL_SECRET_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_secret_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_secret_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_impl_secret_proxy_get_version (XdpImplSecret *object)
{
  XdpImplSecretProxy *proxy = XDP_IMPL_SECRET_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_impl_secret_proxy_init (XdpImplSecretProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_impl_secret_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_IMPL_TYPE_SECRET_PROXY, XdpImplSecretProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_impl_secret_interface_info ());
}

static void
xdp_impl_secret_proxy_class_init (XdpImplSecretProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_impl_secret_proxy_finalize;
  gobject_class->get_property = xdp_impl_secret_proxy_get_property;
  gobject_class->set_property = xdp_impl_secret_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_impl_secret_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_impl_secret_proxy_g_properties_changed;

  xdp_impl_secret_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpImplSecretProxyPrivate));
#endif
}

static void
xdp_impl_secret_proxy_iface_init (XdpImplSecretIface *iface)
{
  iface->get_version = xdp_impl_secret_proxy_get_version;
}

/**
 * xdp_impl_secret_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Secret.top_of_page">org.freedesktop.impl.portal.Secret</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_secret_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_impl_secret_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_secret_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_SECRET_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Secret", NULL);
}

/**
 * xdp_impl_secret_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_secret_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_secret_proxy_new().
 *
 * Returns: (transfer full) (type XdpImplSecretProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplSecret *
xdp_impl_secret_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_SECRET (ret);
  else
    return NULL;
}

/**
 * xdp_impl_secret_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Secret.top_of_page">org.freedesktop.impl.portal.Secret</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_secret_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplSecretProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplSecret *
xdp_impl_secret_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_SECRET_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Secret", NULL);
  if (ret != NULL)
    return XDP_IMPL_SECRET (ret);
  else
    return NULL;
}


/**
 * xdp_impl_secret_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_impl_secret_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_impl_secret_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_impl_secret_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_impl_secret_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_IMPL_TYPE_SECRET_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Secret", NULL);
}

/**
 * xdp_impl_secret_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_impl_secret_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_impl_secret_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpImplSecretProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplSecret *
xdp_impl_secret_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_IMPL_SECRET (ret);
  else
    return NULL;
}

/**
 * xdp_impl_secret_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_impl_secret_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_impl_secret_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpImplSecretProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpImplSecret *
xdp_impl_secret_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_IMPL_TYPE_SECRET_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Secret", NULL);
  if (ret != NULL)
    return XDP_IMPL_SECRET (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpImplSecretSkeleton:
 *
 * The #XdpImplSecretSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpImplSecretSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpImplSecretSkeleton.
 */

struct _XdpImplSecretSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_impl_secret_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpImplSecretSkeleton *skeleton = XDP_IMPL_SECRET_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_IMPL_TYPE_SECRET);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_IMPL_TYPE_SECRET);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_impl_secret_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpImplSecretSkeleton *skeleton = XDP_IMPL_SECRET_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_secret_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_impl_secret_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpImplSecretSkeleton *skeleton = XDP_IMPL_SECRET_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_impl_secret_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_impl_secret_skeleton_vtable =
{
  _xdp_impl_secret_skeleton_handle_method_call,
  _xdp_impl_secret_skeleton_handle_get_property,
  _xdp_impl_secret_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_impl_secret_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_impl_secret_interface_info ();
}

static GDBusInterfaceVTable *
xdp_impl_secret_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_impl_secret_skeleton_vtable;
}

static GVariant *
xdp_impl_secret_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplSecretSkeleton *skeleton = XDP_IMPL_SECRET_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_impl_secret_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_impl_secret_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_impl_secret_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_impl_secret_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Secret", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_impl_secret_emit_changed (gpointer user_data);

static void
xdp_impl_secret_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpImplSecretSkeleton *skeleton = XDP_IMPL_SECRET_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_impl_secret_emit_changed (skeleton);
}

static void xdp_impl_secret_skeleton_iface_init (XdpImplSecretIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpImplSecretSkeleton, xdp_impl_secret_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpImplSecretSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SECRET, xdp_impl_secret_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpImplSecretSkeleton, xdp_impl_secret_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_IMPL_TYPE_SECRET, xdp_impl_secret_skeleton_iface_init))

#endif
static void
xdp_impl_secret_skeleton_finalize (GObject *object)
{
  XdpImplSecretSkeleton *skeleton = XDP_IMPL_SECRET_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_impl_secret_skeleton_parent_class)->finalize (object);
}

static void
xdp_impl_secret_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpImplSecretSkeleton *skeleton = XDP_IMPL_SECRET_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_impl_secret_emit_changed (gpointer user_data)
{
  XdpImplSecretSkeleton *skeleton = XDP_IMPL_SECRET_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.Secret",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_impl_secret_schedule_emit_changed (XdpImplSecretSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_impl_secret_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpImplSecretSkeleton *skeleton = XDP_IMPL_SECRET_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_sour