/* setting-object.c generated by valac 0.56.2, the Vala compiler
 * generated from setting-object.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <dconf.h>
#include <gio/gio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SETTING_OBJECT (setting_object_get_type ())
#define SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTING_OBJECT, SettingObject))
#define SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTING_OBJECT, SettingObjectClass))
#define IS_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTING_OBJECT))
#define IS_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTING_OBJECT))
#define SETTING_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTING_OBJECT, SettingObjectClass))

typedef struct _SettingObject SettingObject;
typedef struct _SettingObjectClass SettingObjectClass;
typedef struct _SettingObjectPrivate SettingObjectPrivate;
enum  {
	SETTING_OBJECT_0_PROPERTY,
	SETTING_OBJECT_NAME_PROPERTY,
	SETTING_OBJECT_FULL_NAME_PROPERTY,
	SETTING_OBJECT_NUM_PROPERTIES
};
static GParamSpec* setting_object_properties[SETTING_OBJECT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DIRECTORY (directory_get_type ())
#define DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY, Directory))
#define DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY, DirectoryClass))
#define IS_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY))
#define IS_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY))
#define DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY, DirectoryClass))

typedef struct _Directory Directory;
typedef struct _DirectoryClass DirectoryClass;
typedef struct _DirectoryPrivate DirectoryPrivate;
enum  {
	DIRECTORY_0_PROPERTY,
	DIRECTORY_NUM_PROPERTIES
};
static GParamSpec* directory_properties[DIRECTORY_NUM_PROPERTIES];

#define TYPE_KEY (key_get_type ())
#define KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY, Key))
#define KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY, KeyClass))
#define IS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY))
#define IS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY))
#define KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY, KeyClass))

typedef struct _Key Key;
typedef struct _KeyClass KeyClass;
typedef struct _KeyPrivate KeyPrivate;
enum  {
	KEY_0_PROPERTY,
	KEY_TYPE_STRING_PROPERTY,
	KEY_KEY_HASH_PROPERTY,
	KEY_ALL_FIXED_PROPERTIES_PROPERTY,
	KEY_NUM_PROPERTIES
};
static GParamSpec* key_properties[KEY_NUM_PROPERTIES];
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_REGISTRY_VARIANT_DICT (registry_variant_dict_get_type ())
#define REGISTRY_VARIANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDict))
#define REGISTRY_VARIANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDictClass))
#define IS_REGISTRY_VARIANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VARIANT_DICT))
#define IS_REGISTRY_VARIANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VARIANT_DICT))
#define REGISTRY_VARIANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDictClass))

typedef struct _RegistryVariantDict RegistryVariantDict;
typedef struct _RegistryVariantDictClass RegistryVariantDictClass;
typedef enum  {
	PROPERTY_QUERY_HASH = 1 << 0,
	PROPERTY_QUERY_HAS_SCHEMA = 1 << 1,
	PROPERTY_QUERY_KEY_NAME = 1 << 2,
	PROPERTY_QUERY_TYPE_CODE = 1 << 3,
	PROPERTY_QUERY_KEY_VALUE = 1 << 4,
	PROPERTY_QUERY_FIXED_SCHEMA = 1 << 5,
	PROPERTY_QUERY_SCHEMA_ID = 1 << 6,
	PROPERTY_QUERY_SUMMARY = 1 << 7,
	PROPERTY_QUERY_DESCRIPTION = 1 << 8,
	PROPERTY_QUERY_DEFAULT_VALUE = 1 << 9,
	PROPERTY_QUERY_RANGE_TYPE = 1 << 10,
	PROPERTY_QUERY_RANGE_CONTENT = 1 << 11,
	PROPERTY_QUERY_MAXIMUM = 1 << 12,
	PROPERTY_QUERY_MINIMUM = 1 << 13,
	PROPERTY_QUERY_KEY_CONFLICT = 1 << 14,
	PROPERTY_QUERY_IS_DEFAULT = 1 << 15
} PropertyQuery;

#define TYPE_PROPERTY_QUERY (property_query_get_type ())
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DCONF_KEY (dconf_key_get_type ())
#define DCONF_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_KEY, DConfKey))
#define DCONF_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_KEY, DConfKeyClass))
#define IS_DCONF_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_KEY))
#define IS_DCONF_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_KEY))
#define DCONF_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_KEY, DConfKeyClass))

typedef struct _DConfKey DConfKey;
typedef struct _DConfKeyClass DConfKeyClass;

#define TYPE_GSETTINGS_KEY (gsettings_key_get_type ())
#define GSETTINGS_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GSETTINGS_KEY, GSettingsKey))
#define GSETTINGS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GSETTINGS_KEY, GSettingsKeyClass))
#define IS_GSETTINGS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GSETTINGS_KEY))
#define IS_GSETTINGS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GSETTINGS_KEY))
#define GSETTINGS_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GSETTINGS_KEY, GSettingsKeyClass))

typedef struct _GSettingsKey GSettingsKey;
typedef struct _GSettingsKeyClass GSettingsKeyClass;
enum  {
	KEY_VALUE_CHANGED_SIGNAL,
	KEY_NUM_SIGNALS
};
static guint key_signals[KEY_NUM_SIGNALS] = {0};
typedef struct _DConfKeyPrivate DConfKeyPrivate;
enum  {
	DCONF_KEY_0_PROPERTY,
	DCONF_KEY_NUM_PROPERTIES
};
static GParamSpec* dconf_key_properties[DCONF_KEY_NUM_PROPERTIES];
typedef struct _GSettingsKeyPrivate GSettingsKeyPrivate;
typedef enum  {
	KEY_CONFLICT_NONE,
	KEY_CONFLICT_SOFT,
	KEY_CONFLICT_HARD
} KeyConflict;

#define TYPE_KEY_CONFLICT (key_conflict_get_type ())
typedef enum  {
	RANGE_TYPE_TYPE,
	RANGE_TYPE_ENUM,
	RANGE_TYPE_FLAGS,
	RANGE_TYPE_RANGE,
	RANGE_TYPE_OTHER
} RangeType;

#define TYPE_RANGE_TYPE (range_type_get_type ())
enum  {
	GSETTINGS_KEY_0_PROPERTY,
	GSETTINGS_KEY_SCHEMA_PATH_PROPERTY,
	GSETTINGS_KEY_SUMMARY_PROPERTY,
	GSETTINGS_KEY_DESCRIPTION_PROPERTY,
	GSETTINGS_KEY_SCHEMA_ID_PROPERTY,
	GSETTINGS_KEY_DEFAULT_VALUE_PROPERTY,
	GSETTINGS_KEY_RANGE_TYPE_PROPERTY,
	GSETTINGS_KEY_RANGE_CONTENT_PROPERTY,
	GSETTINGS_KEY_SETTINGS_PROPERTY,
	GSETTINGS_KEY_DESCRIPTOR_PROPERTY,
	GSETTINGS_KEY_NUM_PROPERTIES
};
static GParamSpec* gsettings_key_properties[GSETTINGS_KEY_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SettingObject {
	GObject parent_instance;
	SettingObjectPrivate * priv;
};

struct _SettingObjectClass {
	GObjectClass parent_class;
};

struct _SettingObjectPrivate {
	gchar* _name;
	gchar* _full_name;
};

struct _Directory {
	SettingObject parent_instance;
	DirectoryPrivate * priv;
};

struct _DirectoryClass {
	SettingObjectClass parent_class;
};

struct _Key {
	SettingObject parent_instance;
	KeyPrivate * priv;
	gulong key_value_changed_handler;
};

struct _KeyClass {
	SettingObjectClass parent_class;
};

struct _KeyPrivate {
	gchar* _type_string;
	guint _key_hash;
	GVariant* _all_fixed_properties;
};

struct _DConfKey {
	Key parent_instance;
	DConfKeyPrivate * priv;
};

struct _DConfKeyClass {
	KeyClass parent_class;
};

struct _DConfKeyPrivate {
	gulong client_changed_handler;
};

struct _GSettingsKey {
	Key parent_instance;
	GSettingsKeyPrivate * priv;
	KeyConflict key_conflict;
};

struct _GSettingsKeyClass {
	KeyClass parent_class;
};

struct _GSettingsKeyPrivate {
	gchar* _schema_path;
	gchar* _summary;
	gchar* _description;
	gchar* _schema_id;
	GVariant* _default_value;
	RangeType _range_type;
	GVariant* _range_content;
	GSettings* _settings;
	gulong settings_changed_handler;
};

static gint SettingObject_private_offset;
static gpointer setting_object_parent_class = NULL;
static gpointer directory_parent_class = NULL;
static gint Key_private_offset;
static gpointer key_parent_class = NULL;
static gint DConfKey_private_offset;
static gpointer dconf_key_parent_class = NULL;
static gint GSettingsKey_private_offset;
static gpointer gsettings_key_parent_class = NULL;

VALA_EXTERN GType setting_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingObject, g_object_unref)
VALA_EXTERN SettingObject* setting_object_construct (GType object_type);
VALA_EXTERN const gchar* setting_object_get_name (SettingObject* self);
static void setting_object_set_name (SettingObject* self,
                              const gchar* value);
VALA_EXTERN const gchar* setting_object_get_full_name (SettingObject* self);
static void setting_object_set_full_name (SettingObject* self,
                                   const gchar* value);
static void setting_object_finalize (GObject * obj);
static GType setting_object_get_type_once (void);
static void _vala_setting_object_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_setting_object_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
VALA_EXTERN GType directory_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Directory, g_object_unref)
VALA_EXTERN Directory* directory_new (const gchar* _full_name,
                          const gchar* _name);
VALA_EXTERN Directory* directory_construct (GType object_type,
                                const gchar* _full_name,
                                const gchar* _name);
static GType directory_get_type_once (void);
VALA_EXTERN GType key_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Key, g_object_unref)
VALA_EXTERN void key_generate_key_fixed_properties (Key* key);
VALA_EXTERN guint key_get_key_hash (Key* self);
VALA_EXTERN GVariant* key_get_all_fixed_properties (Key* self);
VALA_EXTERN GType registry_variant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistryVariantDict, g_object_unref)
VALA_EXTERN RegistryVariantDict* registry_variant_dict_new (void);
VALA_EXTERN RegistryVariantDict* registry_variant_dict_construct (GType object_type);
VALA_EXTERN GType property_query_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void key_get_key_fixed_properties (Key* key,
                                   PropertyQuery query,
                                   RegistryVariantDict** variantdict);
VALA_EXTERN GVariant* registry_variant_dict_end (RegistryVariantDict* self);
static void key_set_all_fixed_properties (Key* self,
                                   GVariant* value);
static void key_set_key_hash (Key* self,
                       guint value);
VALA_EXTERN GType dconf_key_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DConfKey, g_object_unref)
VALA_EXTERN void _dconf_key_get_key_fixed_properties (DConfKey* dkey,
                                          PropertyQuery query,
                                          RegistryVariantDict** variantdict);
VALA_EXTERN GType gsettings_key_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GSettingsKey, g_object_unref)
VALA_EXTERN void _gsettings_key_get_key_fixed_properties (GSettingsKey* gkey,
                                              PropertyQuery query,
                                              RegistryVariantDict** variantdict);
VALA_EXTERN void key_get_min_and_max_string (gchar** min,
                                 gchar** max,
                                 const gchar* type_string);
VALA_EXTERN gchar* key_cool_text_value_from_variant (GVariant* variant);
VALA_EXTERN gchar* key_cool_boolean_text_value (gboolean* nullable_boolean,
                                    gboolean capitalized);
static gboolean _bool_equal (const gboolean * s1,
                      const gboolean * s2);
VALA_EXTERN gboolean key_show_min_and_max (const gchar* type_code);
VALA_EXTERN guint64 key_get_variant_as_uint64 (GVariant* variant);
VALA_EXTERN gint64 key_get_variant_as_int64 (GVariant* variant);
VALA_EXTERN Key* key_construct (GType object_type);
VALA_EXTERN const gchar* key_get_type_string (Key* self);
VALA_EXTERN void key_set_type_string (Key* self,
                          const gchar* value);
static void key_finalize (GObject * obj);
static GType key_get_type_once (void);
static void _vala_key_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec);
static void _vala_key_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec);
VALA_EXTERN DConfKey* dconf_key_new (const gchar* full_name,
                         const gchar* name,
                         const gchar* type_string);
VALA_EXTERN DConfKey* dconf_key_construct (GType object_type,
                               const gchar* full_name,
                               const gchar* name,
                               const gchar* type_string);
VALA_EXTERN void dconf_key_connect_client (DConfKey* self,
                               DConfClient* client);
static void __lambda33_ (DConfKey* self,
                  DConfClient* client,
                  const gchar* prefix,
                  gchar** changes,
                  const gchar* tag);
static void ___lambda33__dconf_client_changed (DConfClient* _sender,
                                        const gchar* prefix,
                                        gchar** changes,
                                        const gchar* tag,
                                        gpointer self);
VALA_EXTERN void dconf_key_disconnect_client (DConfKey* self,
                                  DConfClient* client);
VALA_EXTERN void registry_variant_dict_insert_value (RegistryVariantDict* self,
                                         guint16 key,
                                         GVariant* variant);
static void dconf_key_finalize (GObject * obj);
static GType dconf_key_get_type_once (void);
VALA_EXTERN GType key_conflict_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType range_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GSettingsKey* gsettings_key_new (const gchar* parent_full_name,
                                 const gchar* name,
                                 GSettings* settings,
                                 const gchar* schema_id,
                                 const gchar* schema_path,
                                 const gchar* summary,
                                 const gchar* description,
                                 const gchar* type_string,
                                 GVariant* default_value,
                                 RangeType range_type,
                                 GVariant* range_content);
VALA_EXTERN GSettingsKey* gsettings_key_construct (GType object_type,
                                       const gchar* parent_full_name,
                                       const gchar* name,
                                       GSettings* settings,
                                       const gchar* schema_id,
                                       const gchar* schema_path,
                                       const gchar* summary,
                                       const gchar* description,
                                       const gchar* type_string,
                                       GVariant* default_value,
                                       RangeType range_type,
                                       GVariant* range_content);
VALA_EXTERN void gsettings_key_connect_settings (GSettingsKey* self);
VALA_EXTERN GSettings* gsettings_key_get_settings (GSettingsKey* self);
static void __lambda34_ (GSettingsKey* self);
static void ___lambda34__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
VALA_EXTERN void gsettings_key_disconnect_settings (GSettingsKey* self);
static const gchar* gsettings_key_get_schema_path (GSettingsKey* self);
static const gchar* gsettings_key_get_summary (GSettingsKey* self);
static const gchar* gsettings_key_get_description (GSettingsKey* self);
VALA_EXTERN const gchar* gsettings_key_get_schema_id (GSettingsKey* self);
VALA_EXTERN GVariant* gsettings_key_get_default_value (GSettingsKey* self);
VALA_EXTERN RangeType gsettings_key_get_range_type (GSettingsKey* self);
VALA_EXTERN GVariant* gsettings_key_get_range_content (GSettingsKey* self);
static void gsettings_key_set_schema_path (GSettingsKey* self,
                                    const gchar* value);
static void gsettings_key_set_summary (GSettingsKey* self,
                                const gchar* value);
static void gsettings_key_set_description (GSettingsKey* self,
                                    const gchar* value);
static void gsettings_key_set_schema_id (GSettingsKey* self,
                                  const gchar* value);
static void gsettings_key_set_default_value (GSettingsKey* self,
                                      GVariant* value);
static void gsettings_key_set_range_type (GSettingsKey* self,
                                   RangeType value);
static void gsettings_key_set_range_content (GSettingsKey* self,
                                      GVariant* value);
static void gsettings_key_set_settings (GSettingsKey* self,
                                 GSettings* value);
VALA_EXTERN gchar* gsettings_key_get_descriptor (GSettingsKey* self);
static void gsettings_key_finalize (GObject * obj);
static GType gsettings_key_get_type_once (void);
static void _vala_gsettings_key_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_gsettings_key_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
VALA_EXTERN gchar* get_defined_by (gboolean has_schema,
                       gboolean fixed_schema);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
setting_object_get_instance_private (SettingObject* self)
{
	return G_STRUCT_MEMBER_P (self, SettingObject_private_offset);
}

SettingObject*
setting_object_construct (GType object_type)
{
	SettingObject * self = NULL;
	self = (SettingObject*) g_object_new (object_type, NULL);
	return self;
}

const gchar*
setting_object_get_name (SettingObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
setting_object_set_name (SettingObject* self,
                         const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

const gchar*
setting_object_get_full_name (SettingObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}

static void
setting_object_set_full_name (SettingObject* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_full_name);
	self->priv->_full_name = _tmp0_;
}

static void
setting_object_class_init (SettingObjectClass * klass,
                           gpointer klass_data)
{
	setting_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SettingObject_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_setting_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_setting_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = setting_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTING_OBJECT_NAME_PROPERTY, setting_object_properties[SETTING_OBJECT_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTING_OBJECT_FULL_NAME_PROPERTY, setting_object_properties[SETTING_OBJECT_FULL_NAME_PROPERTY] = g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
}

static void
setting_object_instance_init (SettingObject * self,
                              gpointer klass)
{
	self->priv = setting_object_get_instance_private (self);
}

static void
setting_object_finalize (GObject * obj)
{
	SettingObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTING_OBJECT, SettingObject);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_full_name);
	G_OBJECT_CLASS (setting_object_parent_class)->finalize (obj);
}

static GType
setting_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SettingObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) setting_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingObject), 0, (GInstanceInitFunc) setting_object_instance_init, NULL };
	GType setting_object_type_id;
	setting_object_type_id = g_type_register_static (G_TYPE_OBJECT, "SettingObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SettingObject_private_offset = g_type_add_instance_private (setting_object_type_id, sizeof (SettingObjectPrivate));
	return setting_object_type_id;
}

GType
setting_object_get_type (void)
{
	static volatile gsize setting_object_type_id__once = 0;
	if (g_once_init_enter (&setting_object_type_id__once)) {
		GType setting_object_type_id;
		setting_object_type_id = setting_object_get_type_once ();
		g_once_init_leave (&setting_object_type_id__once, setting_object_type_id);
	}
	return setting_object_type_id__once;
}

static void
_vala_setting_object_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	SettingObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SETTING_OBJECT, SettingObject);
	switch (property_id) {
		case SETTING_OBJECT_NAME_PROPERTY:
		g_value_set_string (value, setting_object_get_name (self));
		break;
		case SETTING_OBJECT_FULL_NAME_PROPERTY:
		g_value_set_string (value, setting_object_get_full_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_setting_object_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	SettingObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SETTING_OBJECT, SettingObject);
	switch (property_id) {
		case SETTING_OBJECT_NAME_PROPERTY:
		setting_object_set_name (self, g_value_get_string (value));
		break;
		case SETTING_OBJECT_FULL_NAME_PROPERTY:
		setting_object_set_full_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

Directory*
directory_construct (GType object_type,
                     const gchar* _full_name,
                     const gchar* _name)
{
	Directory * self = NULL;
	g_return_val_if_fail (_full_name != NULL, NULL);
	g_return_val_if_fail (_name != NULL, NULL);
	self = (Directory*) g_object_new (object_type, "full-name", _full_name, "name", _name, NULL);
	return self;
}

Directory*
directory_new (const gchar* _full_name,
               const gchar* _name)
{
	return directory_construct (TYPE_DIRECTORY, _full_name, _name);
}

static void
directory_class_init (DirectoryClass * klass,
                      gpointer klass_data)
{
	directory_parent_class = g_type_class_peek_parent (klass);
}

static void
directory_instance_init (Directory * self,
                         gpointer klass)
{
}

static GType
directory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DirectoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Directory), 0, (GInstanceInitFunc) directory_instance_init, NULL };
	GType directory_type_id;
	directory_type_id = g_type_register_static (TYPE_SETTING_OBJECT, "Directory", &g_define_type_info, 0);
	return directory_type_id;
}

GType
directory_get_type (void)
{
	static volatile gsize directory_type_id__once = 0;
	if (g_once_init_enter (&directory_type_id__once)) {
		GType directory_type_id;
		directory_type_id = directory_get_type_once ();
		g_once_init_leave (&directory_type_id__once, directory_type_id);
	}
	return directory_type_id__once;
}

static inline gpointer
key_get_instance_private (Key* self)
{
	return G_STRUCT_MEMBER_P (self, Key_private_offset);
}

void
key_generate_key_fixed_properties (Key* key)
{
	guint _tmp0_;
	GVariant* _tmp1_;
	RegistryVariantDict* variantdict = NULL;
	RegistryVariantDict* _tmp2_;
	RegistryVariantDict* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GBytes* _tmp7_;
	GBytes* _tmp8_;
	g_return_if_fail (key != NULL);
	_tmp0_ = key->priv->_key_hash;
	_vala_return_if_fail (_tmp0_ == ((guint) 0), "key.key_hash == 0");
	_tmp1_ = key->priv->_all_fixed_properties;
	_vala_return_if_fail (_tmp1_ == NULL, "key.all_fixed_properties == null");
	_tmp2_ = registry_variant_dict_new ();
	variantdict = _tmp2_;
	key_get_key_fixed_properties (key, 0, &variantdict);
	_tmp3_ = variantdict;
	_tmp4_ = registry_variant_dict_end (_tmp3_);
	_tmp5_ = _tmp4_;
	key_set_all_fixed_properties (key, _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_tmp6_ = key->priv->_all_fixed_properties;
	_tmp7_ = g_variant_get_data_as_bytes ((GVariant*) _tmp6_);
	_tmp8_ = _tmp7_;
	key_set_key_hash (key, g_bytes_hash (_tmp8_));
	_g_bytes_unref0 (_tmp8_);
	_g_object_unref0 (variantdict);
}

void
key_get_key_fixed_properties (Key* key,
                              PropertyQuery query,
                              RegistryVariantDict** variantdict)
{
	g_return_if_fail (key != NULL);
	g_return_if_fail (*variantdict != NULL);
	if (IS_DCONF_KEY (key)) {
		_dconf_key_get_key_fixed_properties (G_TYPE_CHECK_INSTANCE_CAST (key, TYPE_DCONF_KEY, DConfKey), query, variantdict);
	} else {
		if (IS_GSETTINGS_KEY (key)) {
			_gsettings_key_get_key_fixed_properties (G_TYPE_CHECK_INSTANCE_CAST (key, TYPE_GSETTINGS_KEY, GSettingsKey), query, variantdict);
		} else {
			g_assert_not_reached ();
		}
	}
}

void
key_get_min_and_max_string (gchar** min,
                            gchar** max,
                            const gchar* type_string)
{
	gchar* _vala_min = NULL;
	gchar* _vala_max = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	g_return_if_fail (type_string != NULL);
	_tmp0_ = type_string;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("y")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = g_strdup_printf ("%hhu", (guchar) 0U);
				_g_free0 (_vala_min);
				_vala_min = _tmp3_;
				_tmp4_ = g_strdup_printf ("%hhu", (guchar) G_MAXUINT8);
				_g_free0 (_vala_max);
				_vala_max = _tmp4_;
				if (min) {
					*min = _vala_min;
				} else {
					_g_free0 (_vala_min);
				}
				if (max) {
					*max = _vala_max;
				} else {
					_g_free0 (_vala_max);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("n")))) {
		switch (0) {
			default:
			{
				gchar* nullable_min = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* nullable_max = NULL;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp17_;
				gchar* _tmp18_ = NULL;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp22_;
				_tmp5_ = g_strdup_printf ("%'hi", G_MININT16);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_locale_to_utf8 (_tmp6_, (gssize) -1, NULL, NULL, NULL);
				_tmp8_ = _tmp7_;
				_g_free0 (_tmp6_);
				nullable_min = _tmp8_;
				_tmp9_ = g_strdup_printf ("%'hi", G_MAXINT16);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_locale_to_utf8 (_tmp10_, (gssize) -1, NULL, NULL, NULL);
				_tmp12_ = _tmp11_;
				_g_free0 (_tmp10_);
				nullable_max = _tmp12_;
				_tmp14_ = nullable_min;
				_tmp15_ = g_strdup (_tmp14_);
				_tmp13_ = _tmp15_;
				if (_tmp13_ == NULL) {
					gchar* _tmp16_;
					_tmp16_ = g_strdup_printf ("%hi", (gshort) G_MININT16);
					_g_free0 (_tmp13_);
					_tmp13_ = _tmp16_;
				}
				_tmp17_ = g_strdup ((const gchar*) _tmp13_);
				_g_free0 (_vala_min);
				_vala_min = _tmp17_;
				_tmp19_ = nullable_max;
				_tmp20_ = g_strdup (_tmp19_);
				_tmp18_ = _tmp20_;
				if (_tmp18_ == NULL) {
					gchar* _tmp21_;
					_tmp21_ = g_strdup_printf ("%hi", (gshort) G_MAXINT16);
					_g_free0 (_tmp18_);
					_tmp18_ = _tmp21_;
				}
				_tmp22_ = g_strdup ((const gchar*) _tmp18_);
				_g_free0 (_vala_max);
				_vala_max = _tmp22_;
				_g_free0 (_tmp18_);
				_g_free0 (_tmp13_);
				_g_free0 (nullable_max);
				_g_free0 (nullable_min);
				if (min) {
					*min = _vala_min;
				} else {
					_g_free0 (_vala_min);
				}
				if (max) {
					*max = _vala_max;
				} else {
					_g_free0 (_vala_max);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("q")))) {
		switch (0) {
			default:
			{
				gchar* nullable_min = NULL;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* nullable_max = NULL;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_ = NULL;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp35_;
				gchar* _tmp36_ = NULL;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp40_;
				_tmp23_ = g_strdup_printf ("%'hu", 0U);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_locale_to_utf8 (_tmp24_, (gssize) -1, NULL, NULL, NULL);
				_tmp26_ = _tmp25_;
				_g_free0 (_tmp24_);
				nullable_min = _tmp26_;
				_tmp27_ = g_strdup_printf ("%'hu", G_MAXUINT16);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_locale_to_utf8 (_tmp28_, (gssize) -1, NULL, NULL, NULL);
				_tmp30_ = _tmp29_;
				_g_free0 (_tmp28_);
				nullable_max = _tmp30_;
				_tmp32_ = nullable_min;
				_tmp33_ = g_strdup (_tmp32_);
				_tmp31_ = _tmp33_;
				if (_tmp31_ == NULL) {
					gchar* _tmp34_;
					_tmp34_ = g_strdup_printf ("%hu", (gushort) 0U);
					_g_free0 (_tmp31_);
					_tmp31_ = _tmp34_;
				}
				_tmp35_ = g_strdup ((const gchar*) _tmp31_);
				_g_free0 (_vala_min);
				_vala_min = _tmp35_;
				_tmp37_ = nullable_max;
				_tmp38_ = g_strdup (_tmp37_);
				_tmp36_ = _tmp38_;
				if (_tmp36_ == NULL) {
					gchar* _tmp39_;
					_tmp39_ = g_strdup_printf ("%hu", (gushort) G_MAXUINT16);
					_g_free0 (_tmp36_);
					_tmp36_ = _tmp39_;
				}
				_tmp40_ = g_strdup ((const gchar*) _tmp36_);
				_g_free0 (_vala_max);
				_vala_max = _tmp40_;
				_g_free0 (_tmp36_);
				_g_free0 (_tmp31_);
				_g_free0 (nullable_max);
				_g_free0 (nullable_min);
				if (min) {
					*min = _vala_min;
				} else {
					_g_free0 (_vala_min);
				}
				if (max) {
					*max = _vala_max;
				} else {
					_g_free0 (_vala_max);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("i")))) {
		switch (0) {
			default:
			{
				gchar* nullable_min = NULL;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* nullable_max = NULL;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_ = NULL;
				const gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp53_;
				gchar* _tmp54_ = NULL;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp58_;
				_tmp41_ = g_strdup_printf ("%'i", G_MININT32);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_locale_to_utf8 (_tmp42_, (gssize) -1, NULL, NULL, NULL);
				_tmp44_ = _tmp43_;
				_g_free0 (_tmp42_);
				nullable_min = _tmp44_;
				_tmp45_ = g_strdup_printf ("%'i", G_MAXINT32);
				_tmp46_ = _tmp45_;
				_tmp47_ = g_locale_to_utf8 (_tmp46_, (gssize) -1, NULL, NULL, NULL);
				_tmp48_ = _tmp47_;
				_g_free0 (_tmp46_);
				nullable_max = _tmp48_;
				_tmp50_ = nullable_min;
				_tmp51_ = g_strdup (_tmp50_);
				_tmp49_ = _tmp51_;
				if (_tmp49_ == NULL) {
					gchar* _tmp52_;
					_tmp52_ = g_strdup_printf ("%i", (gint) G_MININT32);
					_g_free0 (_tmp49_);
					_tmp49_ = _tmp52_;
				}
				_tmp53_ = g_strdup ((const gchar*) _tmp49_);
				_g_free0 (_vala_min);
				_vala_min = _tmp53_;
				_tmp55_ = nullable_max;
				_tmp56_ = g_strdup (_tmp55_);
				_tmp54_ = _tmp56_;
				if (_tmp54_ == NULL) {
					gchar* _tmp57_;
					_tmp57_ = g_strdup_printf ("%i", (gint) G_MAXINT32);
					_g_free0 (_tmp54_);
					_tmp54_ = _tmp57_;
				}
				_tmp58_ = g_strdup ((const gchar*) _tmp54_);
				_g_free0 (_vala_max);
				_vala_max = _tmp58_;
				_g_free0 (_tmp54_);
				_g_free0 (_tmp49_);
				_g_free0 (nullable_max);
				_g_free0 (nullable_min);
				if (min) {
					*min = _vala_min;
				} else {
					_g_free0 (_vala_min);
				}
				if (max) {
					*max = _vala_max;
				} else {
					_g_free0 (_vala_max);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("u")))) {
		switch (0) {
			default:
			{
				gchar* nullable_min = NULL;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* nullable_max = NULL;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_ = NULL;
				const gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp71_;
				gchar* _tmp72_ = NULL;
				const gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp76_;
				_tmp59_ = g_strdup_printf ("%'u", 0U);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_locale_to_utf8 (_tmp60_, (gssize) -1, NULL, NULL, NULL);
				_tmp62_ = _tmp61_;
				_g_free0 (_tmp60_);
				nullable_min = _tmp62_;
				_tmp63_ = g_strdup_printf ("%'u", G_MAXUINT32);
				_tmp64_ = _tmp63_;
				_tmp65_ = g_locale_to_utf8 (_tmp64_, (gssize) -1, NULL, NULL, NULL);
				_tmp66_ = _tmp65_;
				_g_free0 (_tmp64_);
				nullable_max = _tmp66_;
				_tmp68_ = nullable_min;
				_tmp69_ = g_strdup (_tmp68_);
				_tmp67_ = _tmp69_;
				if (_tmp67_ == NULL) {
					gchar* _tmp70_;
					_tmp70_ = g_strdup_printf ("%u", (guint) 0U);
					_g_free0 (_tmp67_);
					_tmp67_ = _tmp70_;
				}
				_tmp71_ = g_strdup ((const gchar*) _tmp67_);
				_g_free0 (_vala_min);
				_vala_min = _tmp71_;
				_tmp73_ = nullable_max;
				_tmp74_ = g_strdup (_tmp73_);
				_tmp72_ = _tmp74_;
				if (_tmp72_ == NULL) {
					gchar* _tmp75_;
					_tmp75_ = g_strdup_printf ("%u", (guint) G_MAXUINT32);
					_g_free0 (_tmp72_);
					_tmp72_ = _tmp75_;
				}
				_tmp76_ = g_strdup ((const gchar*) _tmp72_);
				_g_free0 (_vala_max);
				_vala_max = _tmp76_;
				_g_free0 (_tmp72_);
				_g_free0 (_tmp67_);
				_g_free0 (nullable_max);
				_g_free0 (nullable_min);
				if (min) {
					*min = _vala_min;
				} else {
					_g_free0 (_vala_min);
				}
				if (max) {
					*max = _vala_max;
				} else {
					_g_free0 (_vala_max);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("x")))) {
		switch (0) {
			default:
			{
				gchar* nullable_min = NULL;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				gchar* nullable_max = NULL;
				gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_ = NULL;
				const gchar* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp89_;
				gchar* _tmp90_ = NULL;
				const gchar* _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp94_;
				_tmp77_ = g_strdup_printf ("%'lli", G_MININT64);
				_tmp78_ = _tmp77_;
				_tmp79_ = g_locale_to_utf8 (_tmp78_, (gssize) -1, NULL, NULL, NULL);
				_tmp80_ = _tmp79_;
				_g_free0 (_tmp78_);
				nullable_min = _tmp80_;
				_tmp81_ = g_strdup_printf ("%'lli", G_MAXINT64);
				_tmp82_ = _tmp81_;
				_tmp83_ = g_locale_to_utf8 (_tmp82_, (gssize) -1, NULL, NULL, NULL);
				_tmp84_ = _tmp83_;
				_g_free0 (_tmp82_);
				nullable_max = _tmp84_;
				_tmp86_ = nullable_min;
				_tmp87_ = g_strdup (_tmp86_);
				_tmp85_ = _tmp87_;
				if (_tmp85_ == NULL) {
					gchar* _tmp88_;
					_tmp88_ = g_strdup_printf ("%lli", G_MININT64);
					_g_free0 (_tmp85_);
					_tmp85_ = _tmp88_;
				}
				_tmp89_ = g_strdup ((const gchar*) _tmp85_);
				_g_free0 (_vala_min);
				_vala_min = _tmp89_;
				_tmp91_ = nullable_max;
				_tmp92_ = g_strdup (_tmp91_);
				_tmp90_ = _tmp92_;
				if (_tmp90_ == NULL) {
					gchar* _tmp93_;
					_tmp93_ = g_strdup_printf ("%lli", G_MAXINT64);
					_g_free0 (_tmp90_);
					_tmp90_ = _tmp93_;
				}
				_tmp94_ = g_strdup ((const gchar*) _tmp90_);
				_g_free0 (_vala_max);
				_vala_max = _tmp94_;
				_g_free0 (_tmp90_);
				_g_free0 (_tmp85_);
				_g_free0 (nullable_max);
				_g_free0 (nullable_min);
				if (min) {
					*min = _vala_min;
				} else {
					_g_free0 (_vala_min);
				}
				if (max) {
					*max = _vala_max;
				} else {
					_g_free0 (_vala_max);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("t")))) {
		switch (0) {
			default:
			{
				gchar* nullable_min = NULL;
				gchar* _tmp95_;
				gchar* _tmp96_;
				gchar* _tmp97_;
				gchar* _tmp98_;
				gchar* nullable_max = NULL;
				gchar* _tmp99_;
				gchar* _tmp100_;
				gchar* _tmp101_;
				gchar* _tmp102_;
				gchar* _tmp103_ = NULL;
				const gchar* _tmp104_;
				gchar* _tmp105_;
				gchar* _tmp107_;
				gchar* _tmp108_ = NULL;
				const gchar* _tmp109_;
				gchar* _tmp110_;
				gchar* _tmp112_;
				_tmp95_ = g_strdup_printf ("%'llu", 0ULL);
				_tmp96_ = _tmp95_;
				_tmp97_ = g_locale_to_utf8 (_tmp96_, (gssize) -1, NULL, NULL, NULL);
				_tmp98_ = _tmp97_;
				_g_free0 (_tmp96_);
				nullable_min = _tmp98_;
				_tmp99_ = g_strdup_printf ("%'llu", G_MAXUINT64);
				_tmp100_ = _tmp99_;
				_tmp101_ = g_locale_to_utf8 (_tmp100_, (gssize) -1, NULL, NULL, NULL);
				_tmp102_ = _tmp101_;
				_g_free0 (_tmp100_);
				nullable_max = _tmp102_;
				_tmp104_ = nullable_min;
				_tmp105_ = g_strdup (_tmp104_);
				_tmp103_ = _tmp105_;
				if (_tmp103_ == NULL) {
					gchar* _tmp106_;
					_tmp106_ = g_strdup_printf ("%llu", 0ULL);
					_g_free0 (_tmp103_);
					_tmp103_ = _tmp106_;
				}
				_tmp107_ = g_strdup ((const gchar*) _tmp103_);
				_g_free0 (_vala_min);
				_vala_min = _tmp107_;
				_tmp109_ = nullable_max;
				_tmp110_ = g_strdup (_tmp109_);
				_tmp108_ = _tmp110_;
				if (_tmp108_ == NULL) {
					gchar* _tmp111_;
					_tmp111_ = g_strdup_printf ("%llu", G_MAXUINT64);
					_g_free0 (_tmp108_);
					_tmp108_ = _tmp111_;
				}
				_tmp112_ = g_strdup ((const gchar*) _tmp108_);
				_g_free0 (_vala_max);
				_vala_max = _tmp112_;
				_g_free0 (_tmp108_);
				_g_free0 (_tmp103_);
				_g_free0 (nullable_max);
				_g_free0 (nullable_min);
				if (min) {
					*min = _vala_min;
				} else {
					_g_free0 (_vala_min);
				}
				if (max) {
					*max = _vala_max;
				} else {
					_g_free0 (_vala_max);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("d")))) {
		switch (0) {
			default:
			{
				gchar* nullable_min = NULL;
				gchar* _tmp113_;
				gchar* _tmp114_;
				gchar* _tmp115_;
				gchar* _tmp116_;
				gchar* nullable_max = NULL;
				gchar* _tmp117_;
				gchar* _tmp118_;
				gchar* _tmp119_;
				gchar* _tmp120_;
				gchar* _tmp121_ = NULL;
				const gchar* _tmp122_;
				gchar* _tmp123_;
				gchar* _tmp125_;
				gchar* _tmp126_ = NULL;
				const gchar* _tmp127_;
				gchar* _tmp128_;
				gchar* _tmp130_;
				_tmp113_ = g_strdup_printf ("%'g", -DBL_MAX);
				_tmp114_ = _tmp113_;
				_tmp115_ = g_locale_to_utf8 (_tmp114_, (gssize) -1, NULL, NULL, NULL);
				_tmp116_ = _tmp115_;
				_g_free0 (_tmp114_);
				nullable_min = _tmp116_;
				_tmp117_ = g_strdup_printf ("%'g", DBL_MAX);
				_tmp118_ = _tmp117_;
				_tmp119_ = g_locale_to_utf8 (_tmp118_, (gssize) -1, NULL, NULL, NULL);
				_tmp120_ = _tmp119_;
				_g_free0 (_tmp118_);
				nullable_max = _tmp120_;
				_tmp122_ = nullable_min;
				_tmp123_ = g_strdup (_tmp122_);
				_tmp121_ = _tmp123_;
				if (_tmp121_ == NULL) {
					gchar* _tmp124_;
					_tmp124_ = g_strdup_printf ("%g", -DBL_MAX);
					_g_free0 (_tmp121_);
					_tmp121_ = _tmp124_;
				}
				_tmp125_ = g_strdup ((const gchar*) _tmp121_);
				_g_free0 (_vala_min);
				_vala_min = _tmp125_;
				_tmp127_ = nullable_max;
				_tmp128_ = g_strdup (_tmp127_);
				_tmp126_ = _tmp128_;
				if (_tmp126_ == NULL) {
					gchar* _tmp129_;
					_tmp129_ = g_strdup_printf ("%g", DBL_MAX);
					_g_free0 (_tmp126_);
					_tmp126_ = _tmp129_;
				}
				_tmp130_ = g_strdup ((const gchar*) _tmp126_);
				_g_free0 (_vala_max);
				_vala_max = _tmp130_;
				_g_free0 (_tmp126_);
				_g_free0 (_tmp121_);
				_g_free0 (nullable_max);
				_g_free0 (nullable_min);
				if (min) {
					*min = _vala_min;
				} else {
					_g_free0 (_vala_min);
				}
				if (max) {
					*max = _vala_max;
				} else {
					_g_free0 (_vala_max);
				}
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("h")))) {
		switch (0) {
			default:
			{
				gchar* nullable_min = NULL;
				gchar* _tmp131_;
				gchar* _tmp132_;
				gchar* _tmp133_;
				gchar* _tmp134_;
				gchar* nullable_max = NULL;
				gchar* _tmp135_;
				gchar* _tmp136_;
				gchar* _tmp137_;
				gchar* _tmp138_;
				gchar* _tmp139_ = NULL;
				const gchar* _tmp140_;
				gchar* _tmp141_;
				gchar* _tmp143_;
				gchar* _tmp144_ = NULL;
				const gchar* _tmp145_;
				gchar* _tmp146_;
				gchar* _tmp148_;
				_tmp131_ = g_strdup_printf ("%'i", G_MININT32);
				_tmp132_ = _tmp131_;
				_tmp133_ = g_locale_to_utf8 (_tmp132_, (gssize) -1, NULL, NULL, NULL);
				_tmp134_ = _tmp133_;
				_g_free0 (_tmp132_);
				nullable_min = _tmp134_;
				_tmp135_ = g_strdup_printf ("%'i", G_MAXINT32);
				_tmp136_ = _tmp135_;
				_tmp137_ = g_locale_to_utf8 (_tmp136_, (gssize) -1, NULL, NULL, NULL);
				_tmp138_ = _tmp137_;
				_g_free0 (_tmp136_);
				nullable_max = _tmp138_;
				_tmp140_ = nullable_min;
				_tmp141_ = g_strdup (_tmp140_);
				_tmp139_ = _tmp141_;
				if (_tmp139_ == NULL) {
					gchar* _tmp142_;
					_tmp142_ = g_strdup_printf ("%i", (gint) G_MININT32);
					_g_free0 (_tmp139_);
					_tmp139_ = _tmp142_;
				}
				_tmp143_ = g_strdup ((const gchar*) _tmp139_);
				_g_free0 (_vala_min);
				_vala_min = _tmp143_;
				_tmp145_ = nullable_max;
				_tmp146_ = g_strdup (_tmp145_);
				_tmp144_ = _tmp146_;
				if (_tmp144_ == NULL) {
					gchar* _tmp147_;
					_tmp147_ = g_strdup_printf ("%i", (gint) G_MAXINT32);
					_g_free0 (_tmp144_);
					_tmp144_ = _tmp147_;
				}
				_tmp148_ = g_strdup ((const gchar*) _tmp144_);
				_g_free0 (_vala_max);
				_vala_max = _tmp148_;
				_g_free0 (_tmp144_);
				_g_free0 (_tmp139_);
				_g_free0 (nullable_max);
				_g_free0 (nullable_min);
				if (min) {
					*min = _vala_min;
				} else {
					_g_free0 (_vala_min);
				}
				if (max) {
					*max = _vala_max;
				} else {
					_g_free0 (_vala_max);
				}
				return;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

gchar*
key_cool_text_value_from_variant (GVariant* variant)
{
	gchar* type = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	static GQuark _tmp4_label3 = 0;
	static GQuark _tmp4_label4 = 0;
	static GQuark _tmp4_label5 = 0;
	static GQuark _tmp4_label6 = 0;
	static GQuark _tmp4_label7 = 0;
	static GQuark _tmp4_label8 = 0;
	static GQuark _tmp4_label9 = 0;
	const gchar* _tmp84_;
	gchar* _tmp92_;
	gchar* result;
	g_return_val_if_fail (variant != NULL, NULL);
	_tmp0_ = g_variant_get_type_string (variant);
	_tmp1_ = g_strdup (_tmp0_);
	type = _tmp1_;
	_tmp2_ = type;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("b")))) {
		switch (0) {
			default:
			{
				gboolean _tmp6_;
				gchar* _tmp7_;
				_tmp6_ = g_variant_get_boolean (variant);
				_tmp7_ = key_cool_boolean_text_value (&_tmp6_, FALSE);
				result = _tmp7_;
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("y")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp8_ = g_variant_print (variant, FALSE);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup_printf ("%hhu (%s)", (guchar) g_variant_get_byte (variant), _tmp9_);
				_tmp11_ = _tmp10_;
				_g_free0 (_tmp9_);
				result = _tmp11_;
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("n")))) {
		switch (0) {
			default:
			{
				gchar* nullable_text = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_ = NULL;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp20_;
				_tmp12_ = g_strdup_printf ("%'hi", g_variant_get_int16 (variant));
				_tmp13_ = _tmp12_;
				_tmp14_ = g_locale_to_utf8 (_tmp13_, (gssize) -1, NULL, NULL, NULL);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp13_);
				nullable_text = _tmp15_;
				_tmp17_ = nullable_text;
				_tmp18_ = g_strdup (_tmp17_);
				_tmp16_ = _tmp18_;
				if (_tmp16_ == NULL) {
					gchar* _tmp19_;
					_tmp19_ = g_strdup_printf ("%hi", (gshort) g_variant_get_int16 (variant));
					_g_free0 (_tmp16_);
					_tmp16_ = _tmp19_;
				}
				_tmp20_ = g_strdup ((const gchar*) _tmp16_);
				result = _tmp20_;
				_g_free0 (_tmp16_);
				_g_free0 (nullable_text);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("q")))) {
		switch (0) {
			default:
			{
				gchar* nullable_text = NULL;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_ = NULL;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp29_;
				_tmp21_ = g_strdup_printf ("%'hu", g_variant_get_uint16 (variant));
				_tmp22_ = _tmp21_;
				_tmp23_ = g_locale_to_utf8 (_tmp22_, (gssize) -1, NULL, NULL, NULL);
				_tmp24_ = _tmp23_;
				_g_free0 (_tmp22_);
				nullable_text = _tmp24_;
				_tmp26_ = nullable_text;
				_tmp27_ = g_strdup (_tmp26_);
				_tmp25_ = _tmp27_;
				if (_tmp25_ == NULL) {
					gchar* _tmp28_;
					_tmp28_ = g_strdup_printf ("%hu", (gushort) g_variant_get_uint16 (variant));
					_g_free0 (_tmp25_);
					_tmp25_ = _tmp28_;
				}
				_tmp29_ = g_strdup ((const gchar*) _tmp25_);
				result = _tmp29_;
				_g_free0 (_tmp25_);
				_g_free0 (nullable_text);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("i")))) {
		switch (0) {
			default:
			{
				gchar* nullable_text = NULL;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_ = NULL;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp38_;
				_tmp30_ = g_strdup_printf ("%'i", g_variant_get_int32 (variant));
				_tmp31_ = _tmp30_;
				_tmp32_ = g_locale_to_utf8 (_tmp31_, (gssize) -1, NULL, NULL, NULL);
				_tmp33_ = _tmp32_;
				_g_free0 (_tmp31_);
				nullable_text = _tmp33_;
				_tmp35_ = nullable_text;
				_tmp36_ = g_strdup (_tmp35_);
				_tmp34_ = _tmp36_;
				if (_tmp34_ == NULL) {
					gchar* _tmp37_;
					_tmp37_ = g_strdup_printf ("%i", (gint) g_variant_get_int32 (variant));
					_g_free0 (_tmp34_);
					_tmp34_ = _tmp37_;
				}
				_tmp38_ = g_strdup ((const gchar*) _tmp34_);
				result = _tmp38_;
				_g_free0 (_tmp34_);
				_g_free0 (nullable_text);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label5) ? _tmp4_label5 : (_tmp4_label5 = g_quark_from_static_string ("u")))) {
		switch (0) {
			default:
			{
				gchar* nullable_text = NULL;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_ = NULL;
				const gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp47_;
				_tmp39_ = g_strdup_printf ("%'u", g_variant_get_uint32 (variant));
				_tmp40_ = _tmp39_;
				_tmp41_ = g_locale_to_utf8 (_tmp40_, (gssize) -1, NULL, NULL, NULL);
				_tmp42_ = _tmp41_;
				_g_free0 (_tmp40_);
				nullable_text = _tmp42_;
				_tmp44_ = nullable_text;
				_tmp45_ = g_strdup (_tmp44_);
				_tmp43_ = _tmp45_;
				if (_tmp43_ == NULL) {
					gchar* _tmp46_;
					_tmp46_ = g_strdup_printf ("%u", (guint) g_variant_get_uint32 (variant));
					_g_free0 (_tmp43_);
					_tmp43_ = _tmp46_;
				}
				_tmp47_ = g_strdup ((const gchar*) _tmp43_);
				result = _tmp47_;
				_g_free0 (_tmp43_);
				_g_free0 (nullable_text);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label6) ? _tmp4_label6 : (_tmp4_label6 = g_quark_from_static_string ("x")))) {
		switch (0) {
			default:
			{
				gchar* nullable_text = NULL;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_ = NULL;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp56_;
				_tmp48_ = g_strdup_printf ("%'lli", g_variant_get_int64 (variant));
				_tmp49_ = _tmp48_;
				_tmp50_ = g_locale_to_utf8 (_tmp49_, (gssize) -1, NULL, NULL, NULL);
				_tmp51_ = _tmp50_;
				_g_free0 (_tmp49_);
				nullable_text = _tmp51_;
				_tmp53_ = nullable_text;
				_tmp54_ = g_strdup (_tmp53_);
				_tmp52_ = _tmp54_;
				if (_tmp52_ == NULL) {
					gchar* _tmp55_;
					_tmp55_ = g_strdup_printf ("%lli", g_variant_get_int64 (variant));
					_g_free0 (_tmp52_);
					_tmp52_ = _tmp55_;
				}
				_tmp56_ = g_strdup ((const gchar*) _tmp52_);
				result = _tmp56_;
				_g_free0 (_tmp52_);
				_g_free0 (nullable_text);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label7) ? _tmp4_label7 : (_tmp4_label7 = g_quark_from_static_string ("t")))) {
		switch (0) {
			default:
			{
				gchar* nullable_text = NULL;
				gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_ = NULL;
				const gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp65_;
				_tmp57_ = g_strdup_printf ("%'llu", g_variant_get_uint64 (variant));
				_tmp58_ = _tmp57_;
				_tmp59_ = g_locale_to_utf8 (_tmp58_, (gssize) -1, NULL, NULL, NULL);
				_tmp60_ = _tmp59_;
				_g_free0 (_tmp58_);
				nullable_text = _tmp60_;
				_tmp62_ = nullable_text;
				_tmp63_ = g_strdup (_tmp62_);
				_tmp61_ = _tmp63_;
				if (_tmp61_ == NULL) {
					gchar* _tmp64_;
					_tmp64_ = g_strdup_printf ("%llu", g_variant_get_uint64 (variant));
					_g_free0 (_tmp61_);
					_tmp61_ = _tmp64_;
				}
				_tmp65_ = g_strdup ((const gchar*) _tmp61_);
				result = _tmp65_;
				_g_free0 (_tmp61_);
				_g_free0 (nullable_text);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label8) ? _tmp4_label8 : (_tmp4_label8 = g_quark_from_static_string ("d")))) {
		switch (0) {
			default:
			{
				gchar* nullable_text = NULL;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_ = NULL;
				const gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp74_;
				_tmp66_ = g_strdup_printf ("%'.12g", g_variant_get_double (variant));
				_tmp67_ = _tmp66_;
				_tmp68_ = g_locale_to_utf8 (_tmp67_, (gssize) -1, NULL, NULL, NULL);
				_tmp69_ = _tmp68_;
				_g_free0 (_tmp67_);
				nullable_text = _tmp69_;
				_tmp71_ = nullable_text;
				_tmp72_ = g_strdup (_tmp71_);
				_tmp70_ = _tmp72_;
				if (_tmp70_ == NULL) {
					gchar* _tmp73_;
					_tmp73_ = g_strdup_printf ("%g", g_variant_get_double (variant));
					_g_free0 (_tmp70_);
					_tmp70_ = _tmp73_;
				}
				_tmp74_ = g_strdup ((const gchar*) _tmp70_);
				result = _tmp74_;
				_g_free0 (_tmp70_);
				_g_free0 (nullable_text);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label9) ? _tmp4_label9 : (_tmp4_label9 = g_quark_from_static_string ("h")))) {
		switch (0) {
			default:
			{
				gchar* nullable_text = NULL;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_ = NULL;
				const gchar* _tmp80_;
				gchar* _tmp81_;
				gchar* _tmp83_;
				_tmp75_ = g_strdup_printf ("%'i", g_variant_get_handle (variant));
				_tmp76_ = _tmp75_;
				_tmp77_ = g_locale_to_utf8 (_tmp76_, (gssize) -1, NULL, NULL, NULL);
				_tmp78_ = _tmp77_;
				_g_free0 (_tmp76_);
				nullable_text = _tmp78_;
				_tmp80_ = nullable_text;
				_tmp81_ = g_strdup (_tmp80_);
				_tmp79_ = _tmp81_;
				if (_tmp79_ == NULL) {
					gchar* _tmp82_;
					_tmp82_ = g_strdup_printf ("%i", (gint) g_variant_get_int32 (variant));
					_g_free0 (_tmp79_);
					_tmp79_ = _tmp82_;
				}
				_tmp83_ = g_strdup ((const gchar*) _tmp79_);
				result = _tmp83_;
				_g_free0 (_tmp79_);
				_g_free0 (nullable_text);
				_g_free0 (type);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp84_ = type;
	if (g_str_has_prefix (_tmp84_, "m")) {
		GVariant* maybe_variant = NULL;
		GVariant* _tmp85_;
		GVariant* _tmp86_;
		const gchar* _tmp88_;
		_tmp85_ = g_variant_get_maybe (variant);
		maybe_variant = _tmp85_;
		_tmp86_ = maybe_variant;
		if (_tmp86_ == NULL) {
			gchar* _tmp87_;
			_tmp87_ = key_cool_boolean_text_value (NULL, FALSE);
			result = _tmp87_;
			_g_variant_unref0 (maybe_variant);
			_g_free0 (type);
			return result;
		}
		_tmp88_ = type;
		if (g_strcmp0 (_tmp88_, "mb") == 0) {
			GVariant* _tmp89_;
			gboolean _tmp90_;
			gchar* _tmp91_;
			_tmp89_ = maybe_variant;
			_tmp90_ = g_variant_get_boolean ((GVariant*) _tmp89_);
			_tmp91_ = key_cool_boolean_text_value (&_tmp90_, FALSE);
			result = _tmp91_;
			_g_variant_unref0 (maybe_variant);
			_g_free0 (type);
			return result;
		}
		_g_variant_unref0 (maybe_variant);
	}
	_tmp92_ = g_variant_print (variant, FALSE);
	result = _tmp92_;
	_g_free0 (type);
	return result;
}

static gboolean
_bool_equal (const gboolean * s1,
             const gboolean * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

gchar*
key_cool_boolean_text_value (gboolean* nullable_boolean,
                             gboolean capitalized)
{
	gchar* result;
	if (capitalized) {
		gboolean _tmp0_;
		gboolean _tmp2_;
		gchar* _tmp4_;
		_tmp0_ = TRUE;
		if (_bool_equal (nullable_boolean, &_tmp0_) == TRUE) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("True"));
			result = _tmp1_;
			return result;
		}
		_tmp2_ = FALSE;
		if (_bool_equal (nullable_boolean, &_tmp2_) == TRUE) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("False"));
			result = _tmp3_;
			return result;
		}
		_tmp4_ = g_strdup (_ ("Nothing"));
		result = _tmp4_;
		return result;
	} else {
		gboolean _tmp5_;
		gboolean _tmp7_;
		gchar* nothing = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp5_ = TRUE;
		if (_bool_equal (nullable_boolean, &_tmp5_) == TRUE) {
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("true"));
			result = _tmp6_;
			return result;
		}
		_tmp7_ = FALSE;
		if (_bool_equal (nullable_boolean, &_tmp7_) == TRUE) {
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("false"));
			result = _tmp8_;
			return result;
		}
		_tmp9_ = g_strdup_printf (_ ("nothing (%s)"), "nothing");
		nothing = _tmp9_;
		_tmp10_ = nothing;
		if (g_strcmp0 (_tmp10_, "nothing (nothing)") != 0) {
			result = nothing;
			return result;
		}
		_tmp11_ = g_strdup (_ ("nothing"));
		result = _tmp11_;
		_g_free0 (nothing);
		return result;
	}
}

gboolean
key_show_min_and_max (const gchar* type_code)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean result;
	g_return_val_if_fail (type_code != NULL, FALSE);
	if (g_strcmp0 (type_code, "d") == 0) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = g_strcmp0 (type_code, "y") == 0;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = g_strcmp0 (type_code, "i") == 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = g_strcmp0 (type_code, "u") == 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_strcmp0 (type_code, "n") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (type_code, "q") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (type_code, "x") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (type_code, "t") == 0;
	}
	result = _tmp0_;
	return result;
}

guint64
key_get_variant_as_uint64 (GVariant* variant)
{
	guint64 result;
	g_return_val_if_fail (variant != NULL, 0ULL);
	switch (g_variant_classify (variant)) {
		case G_VARIANT_CLASS_BYTE:
		{
			result = (guint64) ((gint64) g_variant_get_byte (variant));
			return result;
		}
		case G_VARIANT_CLASS_UINT16:
		{
			result = (guint64) ((gint64) g_variant_get_uint16 (variant));
			return result;
		}
		case G_VARIANT_CLASS_UINT32:
		{
			result = (guint64) ((gint64) g_variant_get_uint32 (variant));
			return result;
		}
		case G_VARIANT_CLASS_UINT64:
		{
			result = g_variant_get_uint64 (variant);
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gint64
key_get_variant_as_int64 (GVariant* variant)
{
	gint64 result;
	g_return_val_if_fail (variant != NULL, 0LL);
	switch (g_variant_classify (variant)) {
		case G_VARIANT_CLASS_INT16:
		{
			result = (gint64) g_variant_get_int16 (variant);
			return result;
		}
		case G_VARIANT_CLASS_INT32:
		{
			result = (gint64) g_variant_get_int32 (variant);
			return result;
		}
		case G_VARIANT_CLASS_INT64:
		{
			result = g_variant_get_int64 (variant);
			return result;
		}
		case G_VARIANT_CLASS_HANDLE:
		{
			result = (gint64) g_variant_get_handle (variant);
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

Key*
key_construct (GType object_type)
{
	Key * self = NULL;
	self = (Key*) setting_object_construct (object_type);
	return self;
}

const gchar*
key_get_type_string (Key* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_type_string;
	result = _tmp0_;
	return result;
}

void
key_set_type_string (Key* self,
                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_type_string);
	self->priv->_type_string = _tmp0_;
}

guint
key_get_key_hash (Key* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_key_hash;
	return result;
}

static void
key_set_key_hash (Key* self,
                  guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_key_hash = value;
}

GVariant*
key_get_all_fixed_properties (Key* self)
{
	GVariant* result;
	GVariant* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_all_fixed_properties;
	result = _tmp0_;
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
key_set_all_fixed_properties (Key* self,
                              GVariant* value)
{
	GVariant* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_variant_ref0 (value);
	_g_variant_unref0 (self->priv->_all_fixed_properties);
	self->priv->_all_fixed_properties = _tmp0_;
}

static void
key_class_init (KeyClass * klass,
                gpointer klass_data)
{
	key_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Key_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_key_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_key_set_property;
	G_OBJECT_CLASS (klass)->finalize = key_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEY_TYPE_STRING_PROPERTY, key_properties[KEY_TYPE_STRING_PROPERTY] = g_param_spec_string ("type-string", "type-string", "type-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEY_KEY_HASH_PROPERTY, key_properties[KEY_KEY_HASH_PROPERTY] = g_param_spec_uint ("key-hash", "key-hash", "key-hash", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEY_ALL_FIXED_PROPERTIES_PROPERTY, key_properties[KEY_ALL_FIXED_PROPERTIES_PROPERTY] = g_param_spec_variant ("all-fixed-properties", "all-fixed-properties", "all-fixed-properties", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	key_signals[KEY_VALUE_CHANGED_SIGNAL] = g_signal_new ("value-changed", TYPE_KEY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
key_instance_init (Key * self,
                   gpointer klass)
{
	gchar* _tmp0_;
	self->priv = key_get_instance_private (self);
	_tmp0_ = g_strdup ("*");
	self->priv->_type_string = _tmp0_;
	self->priv->_key_hash = (guint) 0;
	self->priv->_all_fixed_properties = NULL;
	self->key_value_changed_handler = (gulong) 0;
}

static void
key_finalize (GObject * obj)
{
	Key * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEY, Key);
	_g_free0 (self->priv->_type_string);
	_g_variant_unref0 (self->priv->_all_fixed_properties);
	G_OBJECT_CLASS (key_parent_class)->finalize (obj);
}

static GType
key_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) key_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Key), 0, (GInstanceInitFunc) key_instance_init, NULL };
	GType key_type_id;
	key_type_id = g_type_register_static (TYPE_SETTING_OBJECT, "Key", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	Key_private_offset = g_type_add_instance_private (key_type_id, sizeof (KeyPrivate));
	return key_type_id;
}

GType
key_get_type (void)
{
	static volatile gsize key_type_id__once = 0;
	if (g_once_init_enter (&key_type_id__once)) {
		GType key_type_id;
		key_type_id = key_get_type_once ();
		g_once_init_leave (&key_type_id__once, key_type_id);
	}
	return key_type_id__once;
}

static void
_vala_key_get_property (GObject * object,
                        guint property_id,
                        GValue * value,
                        GParamSpec * pspec)
{
	Key * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_KEY, Key);
	switch (property_id) {
		case KEY_TYPE_STRING_PROPERTY:
		g_value_set_string (value, key_get_type_string (self));
		break;
		case KEY_KEY_HASH_PROPERTY:
		g_value_set_uint (value, key_get_key_hash (self));
		break;
		case KEY_ALL_FIXED_PROPERTIES_PROPERTY:
		g_value_set_variant (value, key_get_all_fixed_properties (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_key_set_property (GObject * object,
                        guint property_id,
                        const GValue * value,
                        GParamSpec * pspec)
{
	Key * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_KEY, Key);
	switch (property_id) {
		case KEY_TYPE_STRING_PROPERTY:
		key_set_type_string (self, g_value_get_string (value));
		break;
		case KEY_KEY_HASH_PROPERTY:
		key_set_key_hash (self, g_value_get_uint (value));
		break;
		case KEY_ALL_FIXED_PROPERTIES_PROPERTY:
		key_set_all_fixed_properties (self, g_value_get_variant (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
dconf_key_get_instance_private (DConfKey* self)
{
	return G_STRUCT_MEMBER_P (self, DConfKey_private_offset);
}

DConfKey*
dconf_key_construct (GType object_type,
                     const gchar* full_name,
                     const gchar* name,
                     const gchar* type_string)
{
	DConfKey * self = NULL;
	g_return_val_if_fail (full_name != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	self = (DConfKey*) g_object_new (object_type, "full-name", full_name, "name", name, "type-string", type_string, NULL);
	return self;
}

DConfKey*
dconf_key_new (const gchar* full_name,
               const gchar* name,
               const gchar* type_string)
{
	return dconf_key_construct (TYPE_DCONF_KEY, full_name, name, type_string);
}

static void
__lambda33_ (DConfKey* self,
             DConfClient* client,
             const gchar* prefix,
             gchar** changes,
             const gchar* tag)
{
	g_return_if_fail (client != NULL);
	g_return_if_fail (prefix != NULL);
	{
		gchar** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = changes;
		item_collection_length1 = _vala_array_length (changes);
		for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
			gchar* _tmp0_;
			gchar* item = NULL;
			_tmp0_ = g_strdup (item_collection[item_it]);
			item = _tmp0_;
			{
				const gchar* _tmp1_;
				gchar* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				gboolean _tmp6_;
				_tmp1_ = item;
				_tmp2_ = g_strconcat (prefix, _tmp1_, NULL);
				_tmp3_ = _tmp2_;
				_tmp4_ = setting_object_get_full_name ((SettingObject*) self);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strcmp0 (_tmp3_, _tmp5_) == 0;
				_g_free0 (_tmp3_);
				if (_tmp6_) {
					g_signal_emit ((Key*) self, key_signals[KEY_VALUE_CHANGED_SIGNAL], 0);
					_g_free0 (item);
					return;
				}
				_g_free0 (item);
			}
		}
	}
}

static void
___lambda33__dconf_client_changed (DConfClient* _sender,
                                   const gchar* prefix,
                                   gchar** changes,
                                   const gchar* tag,
                                   gpointer self)
{
	__lambda33_ ((DConfKey*) self, _sender, prefix, changes, tag);
}

void
dconf_key_connect_client (DConfKey* self,
                          DConfClient* client)
{
	gulong _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	if (self->priv->client_changed_handler != ((gulong) 0)) {
		return;
	}
	_tmp0_ = g_signal_connect_object (client, "changed", (GCallback) ___lambda33__dconf_client_changed, self, 0);
	self->priv->client_changed_handler = _tmp0_;
}

void
dconf_key_disconnect_client (DConfKey* self,
                             DConfClient* client)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	if (self->priv->client_changed_handler == ((gulong) 0)) {
		return;
	}
	g_signal_handler_disconnect ((GObject*) client, self->priv->client_changed_handler);
	self->priv->client_changed_handler = (gulong) 0;
}

void
_dconf_key_get_key_fixed_properties (DConfKey* dkey,
                                     PropertyQuery query,
                                     RegistryVariantDict** variantdict)
{
	gboolean all_properties_queried = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	g_return_if_fail (dkey != NULL);
	g_return_if_fail (*variantdict != NULL);
	all_properties_queried = query == 0;
	if (all_properties_queried) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (query & PROPERTY_QUERY_HAS_SCHEMA) == PROPERTY_QUERY_HAS_SCHEMA;
	}
	if (_tmp0_) {
		GVariant* _tmp1_;
		GVariant* _tmp2_;
		_tmp1_ = g_variant_new_boolean (FALSE);
		g_variant_ref_sink (_tmp1_);
		_tmp2_ = _tmp1_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_HAS_SCHEMA, _tmp2_);
		_g_variant_unref0 (_tmp2_);
	}
	if (all_properties_queried) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = (query & PROPERTY_QUERY_KEY_NAME) == PROPERTY_QUERY_KEY_NAME;
	}
	if (_tmp3_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		_tmp4_ = setting_object_get_name ((SettingObject*) dkey);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_variant_new_string (_tmp5_);
		g_variant_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_KEY_NAME, _tmp7_);
		_g_variant_unref0 (_tmp7_);
	}
	if (all_properties_queried) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = (query & PROPERTY_QUERY_TYPE_CODE) == PROPERTY_QUERY_TYPE_CODE;
	}
	if (_tmp8_) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GVariant* _tmp11_;
		GVariant* _tmp12_;
		_tmp9_ = key_get_type_string ((Key*) dkey);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_variant_new_string (_tmp10_);
		g_variant_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_TYPE_CODE, _tmp12_);
		_g_variant_unref0 (_tmp12_);
	}
	_tmp14_ = key_get_type_string ((Key*) dkey);
	_tmp15_ = _tmp14_;
	if (key_show_min_and_max (_tmp15_)) {
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		if (all_properties_queried) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = (query & PROPERTY_QUERY_MINIMUM) == PROPERTY_QUERY_MINIMUM;
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			_tmp16_ = (query & PROPERTY_QUERY_MAXIMUM) == PROPERTY_QUERY_MAXIMUM;
		}
		_tmp13_ = _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gchar* min = NULL;
		gchar* max = NULL;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_;
		GVariant* _tmp23_;
		GVariant* _tmp24_;
		const gchar* _tmp25_;
		GVariant* _tmp26_;
		GVariant* _tmp27_;
		_tmp18_ = key_get_type_string ((Key*) dkey);
		_tmp19_ = _tmp18_;
		key_get_min_and_max_string (&_tmp20_, &_tmp21_, _tmp19_);
		_g_free0 (min);
		min = _tmp20_;
		_g_free0 (max);
		max = _tmp21_;
		_tmp22_ = min;
		_tmp23_ = g_variant_new_string (_tmp22_);
		g_variant_ref_sink (_tmp23_);
		_tmp24_ = _tmp23_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_MINIMUM, _tmp24_);
		_g_variant_unref0 (_tmp24_);
		_tmp25_ = max;
		_tmp26_ = g_variant_new_string (_tmp25_);
		g_variant_ref_sink (_tmp26_);
		_tmp27_ = _tmp26_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_MAXIMUM, _tmp27_);
		_g_variant_unref0 (_tmp27_);
		_g_free0 (max);
		_g_free0 (min);
	}
}

static void
dconf_key_class_init (DConfKeyClass * klass,
                      gpointer klass_data)
{
	dconf_key_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DConfKey_private_offset);
	G_OBJECT_CLASS (klass)->finalize = dconf_key_finalize;
}

static void
dconf_key_instance_init (DConfKey * self,
                         gpointer klass)
{
	self->priv = dconf_key_get_instance_private (self);
	self->priv->client_changed_handler = (gulong) 0;
}

static void
dconf_key_finalize (GObject * obj)
{
	DConfKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DCONF_KEY, DConfKey);
	G_OBJECT_CLASS (dconf_key_parent_class)->finalize (obj);
}

static GType
dconf_key_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DConfKeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dconf_key_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DConfKey), 0, (GInstanceInitFunc) dconf_key_instance_init, NULL };
	GType dconf_key_type_id;
	dconf_key_type_id = g_type_register_static (TYPE_KEY, "DConfKey", &g_define_type_info, 0);
	DConfKey_private_offset = g_type_add_instance_private (dconf_key_type_id, sizeof (DConfKeyPrivate));
	return dconf_key_type_id;
}

GType
dconf_key_get_type (void)
{
	static volatile gsize dconf_key_type_id__once = 0;
	if (g_once_init_enter (&dconf_key_type_id__once)) {
		GType dconf_key_type_id;
		dconf_key_type_id = dconf_key_get_type_once ();
		g_once_init_leave (&dconf_key_type_id__once, dconf_key_type_id);
	}
	return dconf_key_type_id__once;
}

static inline gpointer
gsettings_key_get_instance_private (GSettingsKey* self)
{
	return G_STRUCT_MEMBER_P (self, GSettingsKey_private_offset);
}

GSettingsKey*
gsettings_key_construct (GType object_type,
                         const gchar* parent_full_name,
                         const gchar* name,
                         GSettings* settings,
                         const gchar* schema_id,
                         const gchar* schema_path,
                         const gchar* summary,
                         const gchar* description,
                         const gchar* type_string,
                         GVariant* default_value,
                         RangeType range_type,
                         GVariant* range_content)
{
	GSettingsKey * self = NULL;
	gchar* summary_nullable = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* description_nullable = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (parent_full_name != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (schema_id != NULL, NULL);
	g_return_val_if_fail (summary != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	g_return_val_if_fail (default_value != NULL, NULL);
	g_return_val_if_fail (range_content != NULL, NULL);
	_tmp0_ = g_locale_to_utf8 (summary, (gssize) -1, NULL, NULL, NULL);
	summary_nullable = _tmp0_;
	_tmp2_ = summary_nullable;
	_tmp1_ = _tmp2_;
	if (_tmp1_ == NULL) {
		_tmp1_ = summary;
	}
	summary = (const gchar*) _tmp1_;
	_tmp3_ = g_locale_to_utf8 (description, (gssize) -1, NULL, NULL, NULL);
	description_nullable = _tmp3_;
	_tmp5_ = description_nullable;
	_tmp4_ = _tmp5_;
	if (_tmp4_ == NULL) {
		_tmp4_ = description;
	}
	description = (const gchar*) _tmp4_;
	_tmp6_ = g_strconcat (parent_full_name, name, NULL);
	_tmp7_ = _tmp6_;
	self = (GSettingsKey*) g_object_new (object_type, "schema-id", schema_id, "full-name", _tmp7_, "name", name, "settings", settings, "schema-path", schema_path, "summary", summary, "description", description, "type-string", type_string, "default-value", default_value, "range-type", range_type, "range-content", range_content, NULL);
	_g_free0 (_tmp7_);
	_g_free0 (description_nullable);
	_g_free0 (summary_nullable);
	return self;
}

GSettingsKey*
gsettings_key_new (const gchar* parent_full_name,
                   const gchar* name,
                   GSettings* settings,
                   const gchar* schema_id,
                   const gchar* schema_path,
                   const gchar* summary,
                   const gchar* description,
                   const gchar* type_string,
                   GVariant* default_value,
                   RangeType range_type,
                   GVariant* range_content)
{
	return gsettings_key_construct (TYPE_GSETTINGS_KEY, parent_full_name, name, settings, schema_id, schema_path, summary, description, type_string, default_value, range_type, range_content);
}

static void
__lambda34_ (GSettingsKey* self)
{
	g_signal_emit ((Key*) self, key_signals[KEY_VALUE_CHANGED_SIGNAL], 0);
}

static void
___lambda34__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda34_ ((GSettingsKey*) self);
}

void
gsettings_key_connect_settings (GSettingsKey* self)
{
	GSettings* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gulong _tmp4_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->settings_changed_handler == ((gulong) 0), "settings_changed_handler == 0");
	_tmp0_ = self->priv->_settings;
	_tmp1_ = setting_object_get_name ((SettingObject*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("changed::", _tmp2_, NULL);
	_tmp4_ = g_signal_connect_object (_tmp0_, _tmp3_, (GCallback) ___lambda34__g_settings_changed, self, 0);
	self->priv->settings_changed_handler = _tmp4_;
	_g_free0 (_tmp3_);
}

void
gsettings_key_disconnect_settings (GSettingsKey* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->settings_changed_handler != ((gulong) 0), "settings_changed_handler != 0");
	_tmp0_ = self->priv->_settings;
	g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->settings_changed_handler);
	self->priv->settings_changed_handler = (gulong) 0;
}

void
_gsettings_key_get_key_fixed_properties (GSettingsKey* gkey,
                                         PropertyQuery query,
                                         RegistryVariantDict** variantdict)
{
	gboolean all_properties_queried = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp43_ = FALSE;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	g_return_if_fail (gkey != NULL);
	g_return_if_fail (*variantdict != NULL);
	all_properties_queried = query == 0;
	if (all_properties_queried) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (query & PROPERTY_QUERY_HAS_SCHEMA) == PROPERTY_QUERY_HAS_SCHEMA;
	}
	if (_tmp0_) {
		GVariant* _tmp1_;
		GVariant* _tmp2_;
		_tmp1_ = g_variant_new_boolean (TRUE);
		g_variant_ref_sink (_tmp1_);
		_tmp2_ = _tmp1_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_HAS_SCHEMA, _tmp2_);
		_g_variant_unref0 (_tmp2_);
	}
	if (all_properties_queried) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = (query & PROPERTY_QUERY_KEY_NAME) == PROPERTY_QUERY_KEY_NAME;
	}
	if (_tmp3_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		_tmp4_ = setting_object_get_name ((SettingObject*) gkey);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_variant_new_string (_tmp5_);
		g_variant_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_KEY_NAME, _tmp7_);
		_g_variant_unref0 (_tmp7_);
	}
	if (all_properties_queried) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = (query & PROPERTY_QUERY_TYPE_CODE) == PROPERTY_QUERY_TYPE_CODE;
	}
	if (_tmp8_) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GVariant* _tmp11_;
		GVariant* _tmp12_;
		_tmp9_ = key_get_type_string ((Key*) gkey);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_variant_new_string (_tmp10_);
		g_variant_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_TYPE_CODE, _tmp12_);
		_g_variant_unref0 (_tmp12_);
	}
	if (all_properties_queried) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = (query & PROPERTY_QUERY_FIXED_SCHEMA) == PROPERTY_QUERY_FIXED_SCHEMA;
	}
	if (_tmp13_) {
		const gchar* _tmp14_;
		GVariant* _tmp15_;
		GVariant* _tmp16_;
		_tmp14_ = gkey->priv->_schema_path;
		_tmp15_ = g_variant_new_boolean (_tmp14_ != NULL);
		g_variant_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_FIXED_SCHEMA, _tmp16_);
		_g_variant_unref0 (_tmp16_);
	}
	if (all_properties_queried) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = (query & PROPERTY_QUERY_SUMMARY) == PROPERTY_QUERY_SUMMARY;
	}
	if (_tmp17_) {
		const gchar* _tmp18_;
		GVariant* _tmp19_;
		GVariant* _tmp20_;
		_tmp18_ = gkey->priv->_summary;
		_tmp19_ = g_variant_new_string (_tmp18_);
		g_variant_ref_sink (_tmp19_);
		_tmp20_ = _tmp19_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_SUMMARY, _tmp20_);
		_g_variant_unref0 (_tmp20_);
	}
	if (all_properties_queried) {
		_tmp21_ = TRUE;
	} else {
		_tmp21_ = (query & PROPERTY_QUERY_DESCRIPTION) == PROPERTY_QUERY_DESCRIPTION;
	}
	if (_tmp21_) {
		const gchar* _tmp22_;
		GVariant* _tmp23_;
		GVariant* _tmp24_;
		_tmp22_ = gkey->priv->_description;
		_tmp23_ = g_variant_new_string (_tmp22_);
		g_variant_ref_sink (_tmp23_);
		_tmp24_ = _tmp23_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_DESCRIPTION, _tmp24_);
		_g_variant_unref0 (_tmp24_);
	}
	if (all_properties_queried) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = (query & PROPERTY_QUERY_SCHEMA_ID) == PROPERTY_QUERY_SCHEMA_ID;
	}
	if (_tmp25_) {
		const gchar* _tmp26_;
		GVariant* _tmp27_;
		GVariant* _tmp28_;
		_tmp26_ = gkey->priv->_schema_id;
		_tmp27_ = g_variant_new_string (_tmp26_);
		g_variant_ref_sink (_tmp27_);
		_tmp28_ = _tmp27_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_SCHEMA_ID, _tmp28_);
		_g_variant_unref0 (_tmp28_);
	}
	if (all_properties_queried) {
		_tmp29_ = TRUE;
	} else {
		_tmp29_ = (query & PROPERTY_QUERY_DEFAULT_VALUE) == PROPERTY_QUERY_DEFAULT_VALUE;
	}
	if (_tmp29_) {
		GVariant* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GVariant* _tmp33_;
		GVariant* _tmp34_;
		_tmp30_ = gkey->priv->_default_value;
		_tmp31_ = key_cool_text_value_from_variant (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_variant_new_string (_tmp32_);
		g_variant_ref_sink (_tmp33_);
		_tmp34_ = _tmp33_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_DEFAULT_VALUE, _tmp34_);
		_g_variant_unref0 (_tmp34_);
		_g_free0 (_tmp32_);
	}
	if (all_properties_queried) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = (query & PROPERTY_QUERY_RANGE_TYPE) == PROPERTY_QUERY_RANGE_TYPE;
	}
	if (_tmp35_) {
		RangeType _tmp36_;
		GVariant* _tmp37_;
		GVariant* _tmp38_;
		_tmp36_ = gkey->priv->_range_type;
		_tmp37_ = g_variant_new_byte ((guint8) _tmp36_);
		g_variant_ref_sink (_tmp37_);
		_tmp38_ = _tmp37_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_RANGE_TYPE, _tmp38_);
		_g_variant_unref0 (_tmp38_);
	}
	if (all_properties_queried) {
		_tmp39_ = TRUE;
	} else {
		_tmp39_ = (query & PROPERTY_QUERY_RANGE_CONTENT) == PROPERTY_QUERY_RANGE_CONTENT;
	}
	if (_tmp39_) {
		GVariant* _tmp40_;
		GVariant* _tmp41_;
		GVariant* _tmp42_;
		_tmp40_ = gkey->priv->_range_content;
		_tmp41_ = g_variant_new_variant (_tmp40_);
		g_variant_ref_sink (_tmp41_);
		_tmp42_ = _tmp41_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_RANGE_CONTENT, _tmp42_);
		_g_variant_unref0 (_tmp42_);
	}
	_tmp44_ = key_get_type_string ((Key*) gkey);
	_tmp45_ = _tmp44_;
	if (key_show_min_and_max (_tmp45_)) {
		gboolean _tmp46_ = FALSE;
		gboolean _tmp47_ = FALSE;
		if (all_properties_queried) {
			_tmp47_ = TRUE;
		} else {
			_tmp47_ = (query & PROPERTY_QUERY_MINIMUM) == PROPERTY_QUERY_MINIMUM;
		}
		if (_tmp47_) {
			_tmp46_ = TRUE;
		} else {
			_tmp46_ = (query & PROPERTY_QUERY_MAXIMUM) == PROPERTY_QUERY_MAXIMUM;
		}
		_tmp43_ = _tmp46_;
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		gchar* min = NULL;
		gchar* max = NULL;
		RangeType _tmp48_;
		const gchar* _tmp61_;
		GVariant* _tmp62_;
		GVariant* _tmp63_;
		const gchar* _tmp64_;
		GVariant* _tmp65_;
		GVariant* _tmp66_;
		_tmp48_ = gkey->priv->_range_type;
		if (_tmp48_ == RANGE_TYPE_RANGE) {
			GVariant* _tmp49_;
			GVariant* _tmp50_;
			GVariant* _tmp51_;
			gchar* _tmp52_;
			GVariant* _tmp53_;
			GVariant* _tmp54_;
			GVariant* _tmp55_;
			gchar* _tmp56_;
			_tmp49_ = gkey->priv->_range_content;
			_tmp50_ = g_variant_get_child_value (_tmp49_, (gsize) 0);
			_tmp51_ = _tmp50_;
			_tmp52_ = key_cool_text_value_from_variant (_tmp51_);
			_g_free0 (min);
			min = _tmp52_;
			_g_variant_unref0 (_tmp51_);
			_tmp53_ = gkey->priv->_range_content;
			_tmp54_ = g_variant_get_child_value (_tmp53_, (gsize) 1);
			_tmp55_ = _tmp54_;
			_tmp56_ = key_cool_text_value_from_variant (_tmp55_);
			_g_free0 (max);
			max = _tmp56_;
			_g_variant_unref0 (_tmp55_);
		} else {
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			gchar* _tmp59_ = NULL;
			gchar* _tmp60_ = NULL;
			_tmp57_ = key_get_type_string ((Key*) gkey);
			_tmp58_ = _tmp57_;
			key_get_min_and_max_string (&_tmp59_, &_tmp60_, _tmp58_);
			_g_free0 (min);
			min = _tmp59_;
			_g_free0 (max);
			max = _tmp60_;
		}
		_tmp61_ = min;
		_tmp62_ = g_variant_new_string (_tmp61_);
		g_variant_ref_sink (_tmp62_);
		_tmp63_ = _tmp62_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_MINIMUM, _tmp63_);
		_g_variant_unref0 (_tmp63_);
		_tmp64_ = max;
		_tmp65_ = g_variant_new_string (_tmp64_);
		g_variant_ref_sink (_tmp65_);
		_tmp66_ = _tmp65_;
		registry_variant_dict_insert_value (*variantdict, (guint16) PROPERTY_QUERY_MAXIMUM, _tmp66_);
		_g_variant_unref0 (_tmp66_);
		_g_free0 (max);
		_g_free0 (min);
	}
}

static const gchar*
gsettings_key_get_schema_path (GSettingsKey* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_schema_path;
	result = _tmp0_;
	return result;
}

static void
gsettings_key_set_schema_path (GSettingsKey* self,
                               const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_schema_path);
	self->priv->_schema_path = _tmp0_;
}

static const gchar*
gsettings_key_get_summary (GSettingsKey* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_summary;
	result = _tmp0_;
	return result;
}

static void
gsettings_key_set_summary (GSettingsKey* self,
                           const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_summary);
	self->priv->_summary = _tmp0_;
}

static const gchar*
gsettings_key_get_description (GSettingsKey* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
gsettings_key_set_description (GSettingsKey* self,
                               const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp0_;
}

const gchar*
gsettings_key_get_schema_id (GSettingsKey* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_schema_id;
	result = _tmp0_;
	return result;
}

static void
gsettings_key_set_schema_id (GSettingsKey* self,
                             const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_schema_id);
	self->priv->_schema_id = _tmp0_;
}

GVariant*
gsettings_key_get_default_value (GSettingsKey* self)
{
	GVariant* result;
	GVariant* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_value;
	result = _tmp0_;
	return result;
}

static void
gsettings_key_set_default_value (GSettingsKey* self,
                                 GVariant* value)
{
	GVariant* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_variant_ref0 (value);
	_g_variant_unref0 (self->priv->_default_value);
	self->priv->_default_value = _tmp0_;
}

RangeType
gsettings_key_get_range_type (GSettingsKey* self)
{
	RangeType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_range_type;
	return result;
}

static void
gsettings_key_set_range_type (GSettingsKey* self,
                              RangeType value)
{
	g_return_if_fail (self != NULL);
	self->priv->_range_type = value;
}

GVariant*
gsettings_key_get_range_content (GSettingsKey* self)
{
	GVariant* result;
	GVariant* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_range_content;
	result = _tmp0_;
	return result;
}

static void
gsettings_key_set_range_content (GSettingsKey* self,
                                 GVariant* value)
{
	GVariant* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_variant_ref0 (value);
	_g_variant_unref0 (self->priv->_range_content);
	self->priv->_range_content = _tmp0_;
}

GSettings*
gsettings_key_get_settings (GSettingsKey* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gsettings_key_set_settings (GSettingsKey* self,
                            GSettings* value)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
gsettings_key_get_descriptor (GSettingsKey* self)
{
	gchar* result;
	gchar* parent_path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp18_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = setting_object_get_full_name ((SettingObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ < 2) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("/");
		_g_free0 (parent_path);
		parent_path = _tmp4_;
	} else {
		gchar* tmp_string = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp5_ = setting_object_get_full_name ((SettingObject*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = setting_object_get_full_name ((SettingObject*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_slice (_tmp6_, (glong) 0, (glong) string_last_index_of_char (_tmp8_, (gunichar) '/', 0));
		tmp_string = _tmp9_;
		_tmp10_ = setting_object_get_full_name ((SettingObject*) self);
		_tmp11_ = _tmp10_;
		if (g_str_has_suffix (_tmp11_, "/")) {
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = setting_object_get_full_name ((SettingObject*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = tmp_string;
			_tmp15_ = string_slice (_tmp13_, (glong) 0, (glong) (string_last_index_of_char (_tmp14_, (gunichar) '/', 0) + 1));
			_g_free0 (parent_path);
			parent_path = _tmp15_;
		} else {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = tmp_string;
			_tmp17_ = g_strconcat (_tmp16_, "/", NULL);
			_g_free0 (parent_path);
			parent_path = _tmp17_;
		}
		_g_free0 (tmp_string);
	}
	_tmp18_ = self->priv->_schema_path;
	if (_tmp18_ == NULL) {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp19_ = self->priv->_schema_id;
		_tmp20_ = string_to_string (_tmp19_);
		_tmp21_ = parent_path;
		_tmp22_ = string_to_string (_tmp21_);
		_tmp23_ = setting_object_get_name ((SettingObject*) self);
		_tmp24_ = _tmp23_;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat (_tmp20_, ":", _tmp22_, " ", _tmp25_, NULL);
		result = _tmp26_;
		_g_free0 (parent_path);
		return result;
	}
	_tmp27_ = self->priv->_schema_id;
	_tmp28_ = string_to_string (_tmp27_);
	_tmp29_ = setting_object_get_name ((SettingObject*) self);
	_tmp30_ = _tmp29_;
	_tmp31_ = string_to_string (_tmp30_);
	_tmp32_ = g_strconcat (_tmp28_, " ", _tmp31_, NULL);
	result = _tmp32_;
	_g_free0 (parent_path);
	return result;
}

static void
gsettings_key_class_init (GSettingsKeyClass * klass,
                          gpointer klass_data)
{
	gsettings_key_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GSettingsKey_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gsettings_key_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gsettings_key_set_property;
	G_OBJECT_CLASS (klass)->finalize = gsettings_key_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSETTINGS_KEY_SCHEMA_PATH_PROPERTY, gsettings_key_properties[GSETTINGS_KEY_SCHEMA_PATH_PROPERTY] = g_param_spec_string ("schema-path", "schema-path", "schema-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSETTINGS_KEY_SUMMARY_PROPERTY, gsettings_key_properties[GSETTINGS_KEY_SUMMARY_PROPERTY] = g_param_spec_string ("summary", "summary", "summary", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSETTINGS_KEY_DESCRIPTION_PROPERTY, gsettings_key_properties[GSETTINGS_KEY_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSETTINGS_KEY_SCHEMA_ID_PROPERTY, gsettings_key_properties[GSETTINGS_KEY_SCHEMA_ID_PROPERTY] = g_param_spec_string ("schema-id", "schema-id", "schema-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSETTINGS_KEY_DEFAULT_VALUE_PROPERTY, gsettings_key_properties[GSETTINGS_KEY_DEFAULT_VALUE_PROPERTY] = g_param_spec_variant ("default-value", "default-value", "default-value", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSETTINGS_KEY_RANGE_TYPE_PROPERTY, gsettings_key_properties[GSETTINGS_KEY_RANGE_TYPE_PROPERTY] = g_param_spec_enum ("range-type", "range-type", "range-type", TYPE_RANGE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSETTINGS_KEY_RANGE_CONTENT_PROPERTY, gsettings_key_properties[GSETTINGS_KEY_RANGE_CONTENT_PROPERTY] = g_param_spec_variant ("range-content", "range-content", "range-content", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSETTINGS_KEY_SETTINGS_PROPERTY, gsettings_key_properties[GSETTINGS_KEY_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSETTINGS_KEY_DESCRIPTOR_PROPERTY, gsettings_key_properties[GSETTINGS_KEY_DESCRIPTOR_PROPERTY] = g_param_spec_string ("descriptor", "descriptor", "descriptor", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
gsettings_key_instance_init (GSettingsKey * self,
                             gpointer klass)
{
	self->priv = gsettings_key_get_instance_private (self);
	self->key_conflict = KEY_CONFLICT_NONE;
	self->priv->settings_changed_handler = (gulong) 0;
}

static void
gsettings_key_finalize (GObject * obj)
{
	GSettingsKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GSETTINGS_KEY, GSettingsKey);
	_g_free0 (self->priv->_schema_path);
	_g_free0 (self->priv->_summary);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_schema_id);
	_g_variant_unref0 (self->priv->_default_value);
	_g_variant_unref0 (self->priv->_range_content);
	_g_object_unref0 (self->priv->_settings);
	G_OBJECT_CLASS (gsettings_key_parent_class)->finalize (obj);
}

static GType
gsettings_key_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GSettingsKeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gsettings_key_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GSettingsKey), 0, (GInstanceInitFunc) gsettings_key_instance_init, NULL };
	GType gsettings_key_type_id;
	gsettings_key_type_id = g_type_register_static (TYPE_KEY, "GSettingsKey", &g_define_type_info, 0);
	GSettingsKey_private_offset = g_type_add_instance_private (gsettings_key_type_id, sizeof (GSettingsKeyPrivate));
	return gsettings_key_type_id;
}

GType
gsettings_key_get_type (void)
{
	static volatile gsize gsettings_key_type_id__once = 0;
	if (g_once_init_enter (&gsettings_key_type_id__once)) {
		GType gsettings_key_type_id;
		gsettings_key_type_id = gsettings_key_get_type_once ();
		g_once_init_leave (&gsettings_key_type_id__once, gsettings_key_type_id);
	}
	return gsettings_key_type_id__once;
}

static void
_vala_gsettings_key_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	GSettingsKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GSETTINGS_KEY, GSettingsKey);
	switch (property_id) {
		case GSETTINGS_KEY_SCHEMA_PATH_PROPERTY:
		g_value_set_string (value, gsettings_key_get_schema_path (self));
		break;
		case GSETTINGS_KEY_SUMMARY_PROPERTY:
		g_value_set_string (value, gsettings_key_get_summary (self));
		break;
		case GSETTINGS_KEY_DESCRIPTION_PROPERTY:
		g_value_set_string (value, gsettings_key_get_description (self));
		break;
		case GSETTINGS_KEY_SCHEMA_ID_PROPERTY:
		g_value_set_string (value, gsettings_key_get_schema_id (self));
		break;
		case GSETTINGS_KEY_DEFAULT_VALUE_PROPERTY:
		g_value_set_variant (value, gsettings_key_get_default_value (self));
		break;
		case GSETTINGS_KEY_RANGE_TYPE_PROPERTY:
		g_value_set_enum (value, gsettings_key_get_range_type (self));
		break;
		case GSETTINGS_KEY_RANGE_CONTENT_PROPERTY:
		g_value_set_variant (value, gsettings_key_get_range_content (self));
		break;
		case GSETTINGS_KEY_SETTINGS_PROPERTY:
		g_value_set_object (value, gsettings_key_get_settings (self));
		break;
		case GSETTINGS_KEY_DESCRIPTOR_PROPERTY:
		g_value_take_string (value, gsettings_key_get_descriptor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gsettings_key_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	GSettingsKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GSETTINGS_KEY, GSettingsKey);
	switch (property_id) {
		case GSETTINGS_KEY_SCHEMA_PATH_PROPERTY:
		gsettings_key_set_schema_path (self, g_value_get_string (value));
		break;
		case GSETTINGS_KEY_SUMMARY_PROPERTY:
		gsettings_key_set_summary (self, g_value_get_string (value));
		break;
		case GSETTINGS_KEY_DESCRIPTION_PROPERTY:
		gsettings_key_set_description (self, g_value_get_string (value));
		break;
		case GSETTINGS_KEY_SCHEMA_ID_PROPERTY:
		gsettings_key_set_schema_id (self, g_value_get_string (value));
		break;
		case GSETTINGS_KEY_DEFAULT_VALUE_PROPERTY:
		gsettings_key_set_default_value (self, g_value_get_variant (value));
		break;
		case GSETTINGS_KEY_RANGE_TYPE_PROPERTY:
		gsettings_key_set_range_type (self, g_value_get_enum (value));
		break;
		case GSETTINGS_KEY_RANGE_CONTENT_PROPERTY:
		gsettings_key_set_range_content (self, g_value_get_variant (value));
		break;
		case GSETTINGS_KEY_SETTINGS_PROPERTY:
		gsettings_key_set_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gchar*
get_defined_by (gboolean has_schema,
                gboolean fixed_schema)
{
	gchar* _tmp2_;
	gchar* result;
	if (fixed_schema) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (_ ("Schema with path"));
		result = _tmp0_;
		return result;
	}
	if (has_schema) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (_ ("Relocatable schema"));
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_strdup (_ ("DConf backend"));
	result = _tmp2_;
	return result;
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

