/*
 * Copyright (C) 2017, 2018 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import chai from 'chai';
import { uri, createServer, lastPosition, filePath, readContents, positionAfter } from './test-utils.js';
const assert = chai.assert;
let server;
before(() => __awaiter(void 0, void 0, void 0, function* () {
    server = yield createServer({
        rootUri: uri(),
        publishDiagnostics: () => { }
    });
}));
beforeEach(() => {
    server.closeAll();
});
after(() => {
    server.closeAll();
    server.shutdown();
});
describe('documentHighlight', () => {
    it('simple test', () => __awaiter(void 0, void 0, void 0, function* () {
        const doc = {
            uri: uri('module2.ts'),
            languageId: 'typescript',
            version: 1,
            text: readContents(filePath('module2.ts'))
        };
        server.didOpenTextDocument({
            textDocument: doc
        });
        const result = yield server.documentHighlight({
            textDocument: doc,
            position: lastPosition(doc, 'doStuff')
        });
        assert.equal(2, result.length, JSON.stringify(result, undefined, 2));
    }));
});
describe('completions', () => {
    it('receives completion that auto-imports from another module', () => __awaiter(void 0, void 0, void 0, function* () {
        const doc = {
            uri: uri('completion.ts'),
            languageId: 'typescript',
            version: 1,
            text: readContents(filePath('completion.ts'))
        };
        server.didOpenTextDocument({ textDocument: doc });
        const proposals = yield server.completion({
            textDocument: doc,
            position: positionAfter(doc, 'doStuff')
        });
        assert.isNotNull(proposals);
        const completion = proposals.items.find(item => item.label === 'doStuff');
        assert.isDefined(completion);
        const resolvedCompletion = yield server.completionResolve(completion);
        assert.isDefined(resolvedCompletion.additionalTextEdits);
        assert.isUndefined(resolvedCompletion.command);
        server.didCloseTextDocument({ textDocument: doc });
    }));
});
//# sourceMappingURL=file-lsp-server.spec.js.map