/*
 * Copyright (C) 2017, 2018 TypeFox and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as lsp from 'vscode-languageserver';
import { TypeScriptRenameRequest } from './ts-protocol.js';
export class LspClientImpl {
    constructor(connection) {
        this.connection = connection;
    }
    setClientCapabilites(capabilites) {
        this.clientCapabilities = capabilites;
    }
    createProgressReporter() {
        let workDoneProgress;
        return {
            begin: (message = '') => {
                var _a, _b;
                if ((_b = (_a = this.clientCapabilities) === null || _a === void 0 ? void 0 : _a.window) === null || _b === void 0 ? void 0 : _b.workDoneProgress) {
                    workDoneProgress = this.connection.window.createWorkDoneProgress();
                    workDoneProgress
                        .then((progress) => {
                        progress.begin(message);
                    })
                        .catch(() => { });
                }
            },
            report: (message) => {
                if (workDoneProgress) {
                    workDoneProgress
                        .then((progress) => {
                        progress.report(message);
                    })
                        .catch(() => { });
                }
            },
            end: () => {
                if (workDoneProgress) {
                    workDoneProgress
                        .then((progress) => {
                        progress.done();
                    })
                        .catch(() => { });
                    workDoneProgress = undefined;
                }
            }
        };
    }
    publishDiagnostics(args) {
        this.connection.sendNotification(lsp.PublishDiagnosticsNotification.type, args);
    }
    showMessage(args) {
        this.connection.sendNotification(lsp.ShowMessageNotification.type, args);
    }
    logMessage(args) {
        this.connection.sendNotification(lsp.LogMessageNotification.type, args);
    }
    telemetry(args) {
        this.connection.sendNotification(lsp.TelemetryEventNotification.type, args);
    }
    applyWorkspaceEdit(args) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.connection.sendRequest(lsp.ApplyWorkspaceEditRequest.type, args);
        });
    }
    rename(args) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.connection.sendRequest(TypeScriptRenameRequest.type, args);
        });
    }
}
//# sourceMappingURL=lsp-client.js.map