MACRO(checkOpencoreAmrnb)
	IF (NOT OPENCORE_AMRNB_CHECKED)
		OPTION(OPENCORE_AMRNB "" ON)

		MESSAGE(STATUS "Checking for opencore-amrnb")
		MESSAGE(STATUS "***************************")

		IF (OPENCORE_AMRNB)
			FIND_HEADER_AND_LIB(OPENCORE_AMRNB opencore-amrnb/interf_dec.h opencore-amrnb Decoder_Interface_init)
			PRINT_LIBRARY_INFO("opencore-amrnb" OPENCORE_AMRNB_FOUND "${OPENCORE_AMRNB_INCLUDE_DIR}" "${OPENCORE_AMRNB_LIBRARY_DIR}")
		ELSE (OPENCORE_AMRNB)
			MESSAGE("${MSG_DISABLE_OPTION}")
		ENDIF (OPENCORE_AMRNB)

		MESSAGE("")

		SET(OPENCORE_AMRNB_CHECKED 1)
	ENDIF (NOT OPENCORE_AMRNB_CHECKED)

	APPEND_SUMMARY_LIST("Audio Decoder" "opencore-amrnb" "${OPENCORE_AMRNB_FOUND}")
ENDMACRO(checkOpencoreAmrnb)

MACRO(checkOpencoreAmrwb)
	IF (NOT OPENCORE_AMRWB_CHECKED)
		OPTION(OPENCORE_AMRWB "" ON)

		MESSAGE(STATUS "Checking for opencore-amrwb")
		MESSAGE(STATUS "***************************")

		IF (OPENCORE_AMRWB)
			FIND_HEADER_AND_LIB(OPENCORE_AMRWB opencore-amrwb/dec_if.h opencore-amrwb D_IF_init)
			PRINT_LIBRARY_INFO("opencore-amrwb" OPENCORE_AMRWB_FOUND "${OPENCORE_AMRWB_INCLUDE_DIR}" "${OPENCORE_AMRWB_LIBRARY_DIR}")
		ELSE (OPENCORE_AMRWB)
			MESSAGE("${MSG_DISABLE_OPTION}")
		ENDIF (OPENCORE_AMRWB)

		SET(ENV{ADM_HAVE_OPENCORE_AMRWB} ${OPENCORE_AMRWB_FOUND})		
		MESSAGE("")
		
		SET(OPENCORE_AMRWB_CHECKED 1)
	ENDIF (NOT OPENCORE_AMRWB_CHECKED)

	APPEND_SUMMARY_LIST("Audio Decoder" "opencore-amrwb" "${OPENCORE_AMRWB_FOUND}")
ENDMACRO(checkOpencoreAmrwb)