# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function

__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# cli_rm_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the module docstring and re-run
# cli_rm_builder.
#
#############################################

"""
The arg spec for the iosxr_ntp_global module
"""


class Ntp_globalArgs(object):  # pylint: disable=R0903
    """The arg spec for the iosxr_ntp_global module"""

    argument_spec = {
        "config": {
            "type": "dict",
            "options": {
                "access_group": {
                    "type": "dict",
                    "options": {
                        "ipv4": {
                            "type": "dict",
                            "options": {
                                "peer": {"type": "str"},
                                "query_only": {"type": "str"},
                                "serve": {"type": "str"},
                                "serve_only": {"type": "str"},
                            },
                        },
                        "ipv6": {
                            "type": "dict",
                            "options": {
                                "peer": {"type": "str"},
                                "query_only": {"type": "str"},
                                "serve": {"type": "str"},
                                "serve_only": {"type": "str"},
                            },
                        },
                        "vrfs": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "name": {"type": "str"},
                                "ipv4": {
                                    "type": "dict",
                                    "options": {
                                        "peer": {"type": "str"},
                                        "query_only": {"type": "str"},
                                        "serve": {"type": "str"},
                                        "serve_only": {"type": "str"},
                                    },
                                },
                                "ipv6": {
                                    "type": "dict",
                                    "options": {
                                        "peer": {"type": "str"},
                                        "query_only": {"type": "str"},
                                        "serve": {"type": "str"},
                                        "serve_only": {"type": "str"},
                                    },
                                },
                            },
                        },
                    },
                },
                "authenticate": {"type": "bool"},
                "authentication_keys": {
                    "type": "list",
                    "elements": "dict",
                    "no_log": False,
                    "options": {
                        "id": {"type": "int"},
                        "key": {"type": "str", "no_log": True},
                        "encryption": {"type": "bool"},
                    },
                },
                "broadcastdelay": {"type": "int"},
                "drift": {
                    "type": "dict",
                    "options": {
                        "aging_time": {"type": "int"},
                        "file": {"type": "str"},
                    },
                },
                "interfaces": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "name": {"type": "str"},
                        "vrf": {"type": "str"},
                        "broadcast_client": {"type": "bool"},
                        "broadcast_destination": {"type": "str"},
                        "broadcast_key": {"type": "int", "no_log": False},
                        "broadcast_version": {"type": "int"},
                        "multicast_key": {"type": "int", "no_log": False},
                        "multicast_ttl": {"type": "int"},
                        "multicast_client": {"type": "str"},
                        "multicast_destination": {"type": "str"},
                        "multicast_version": {"type": "int"},
                    },
                },
                "ipv4": {
                    "type": "dict",
                    "options": {
                        "dscp": {"type": "str"},
                        "precedence": {
                            "type": "str",
                            "choices": [
                                "critical",
                                "flash",
                                "flash-override",
                                "immediate",
                                "internet",
                                "network",
                                "priority",
                                "routine",
                            ],
                        },
                    },
                },
                "ipv6": {
                    "type": "dict",
                    "options": {
                        "dscp": {"type": "str"},
                        "precedence": {
                            "type": "str",
                            "choices": [
                                "critical",
                                "flash",
                                "flash-override",
                                "immediate",
                                "internet",
                                "network",
                                "priority",
                                "routine",
                            ],
                        },
                    },
                },
                "log_internal_sync": {"type": "bool"},
                "master": {
                    "type": "dict",
                    "options": {"stratum": {"type": "int"}},
                },
                "max_associations": {"type": "int"},
                "passive": {"type": "bool"},
                "trusted_keys": {
                    "type": "list",
                    "elements": "dict",
                    "no_log": False,
                    "options": {"key_id": {"type": "int"}},
                },
                "update_calendar": {"type": "bool"},
                "source_interface": {"type": "str"},
                "source_vrfs": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "name": {"type": "str"},
                        "vrf": {"type": "str"},
                    },
                },
                "servers": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "vrf": {"type": "str"},
                        "server": {"type": "str", "required": True},
                        "burst": {"type": "bool"},
                        "iburst": {"type": "bool"},
                        "key_id": {"type": "int"},
                        "source": {"type": "str"},
                        "maxpoll": {"type": "int"},
                        "minpoll": {"type": "int"},
                        "prefer": {"type": "bool"},
                        "version": {"type": "int"},
                    },
                },
                "peers": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "vrf": {"type": "str"},
                        "peer": {"type": "str", "required": True},
                        "burst": {"type": "bool"},
                        "iburst": {"type": "bool"},
                        "key_id": {"type": "int"},
                        "source": {"type": "str"},
                        "maxpoll": {"type": "int"},
                        "minpoll": {"type": "int"},
                        "prefer": {"type": "bool"},
                        "version": {"type": "int"},
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "type": "str",
            "choices": [
                "deleted",
                "merged",
                "overridden",
                "replaced",
                "gathered",
                "rendered",
                "parsed",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
