# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function

__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The arg spec for the iosxr_ospfv3 module
"""


class Ospfv3Args(object):  # pylint: disable=R0903
    """The arg spec for the iosxr_ospfv3 module"""

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "running_config": {"type": "str"},
        "config": {
            "type": "dict",
            "options": {
                "processes": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "process_id": {"type": "str", "required": True},
                        "address_family_unicast": {"type": "bool"},
                        "authentication": {
                            "type": "dict",
                            "options": {
                                "disable": {"type": "bool", "default": False},
                                "ipsec": {
                                    "type": "dict",
                                    "options": {
                                        "spi": {"type": "int"},
                                        "algorithim_type": {
                                            "type": "str",
                                            "choices": ["md5", "sha1"],
                                        },
                                        "key": {
                                            "type": "str",
                                            "no_log": False,
                                        },
                                        "clear_key": {
                                            "type": "str",
                                            "no_log": False,
                                        },
                                        "password_key": {
                                            "type": "str",
                                            "no_log": False,
                                        },
                                    },
                                },
                            },
                        },
                        "auto_cost": {
                            "type": "dict",
                            "options": {
                                "reference_bandwidth": {"type": "int"},
                                "disable": {"type": "bool"},
                            },
                        },
                        "bfd": {
                            "type": "dict",
                            "options": {
                                "fast_detect": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "strict_mode": {"type": "bool"},
                                    },
                                },
                                "minimum_interval": {"type": "int"},
                                "multiplier": {"type": "int"},
                            },
                        },
                        "areas": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "area_id": {"type": "str", "required": True},
                                "authentication": {
                                    "type": "dict",
                                    "options": {
                                        "disable": {
                                            "type": "bool",
                                            "default": False,
                                        },
                                        "ipsec": {
                                            "type": "dict",
                                            "options": {
                                                "spi": {"type": "int"},
                                                "algorithim_type": {
                                                    "type": "str",
                                                    "choices": ["md5", "sha1"],
                                                },
                                                "key": {
                                                    "type": "str",
                                                    "no_log": False,
                                                },
                                                "clear_key": {
                                                    "type": "str",
                                                    "no_log": False,
                                                },
                                                "password_key": {
                                                    "type": "str",
                                                    "no_log": False,
                                                },
                                            },
                                        },
                                    },
                                },
                                "bfd": {
                                    "type": "dict",
                                    "options": {
                                        "fast_detect": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "strict_mode": {
                                                    "type": "bool"
                                                },
                                            },
                                        },
                                        "minimum_interval": {"type": "int"},
                                        "multiplier": {"type": "int"},
                                    },
                                },
                                "cost": {"type": "int"},
                                "database_filter": {
                                    "type": "dict",
                                    "options": {
                                        "all_outgoing_lsa": {"type": "bool"}
                                    },
                                },
                                "dead_interval": {"type": "int"},
                                "default_cost": {"type": "int"},
                                "demand_circuit": {"type": "bool"},
                                "distrinbute_rib_prefix_list_name": {
                                    "type": "str"
                                },
                                "fast_reroute": {
                                    "type": "dict",
                                    "options": {
                                        "disabled": {"type": "bool"},
                                        "per_link": {
                                            "type": "dict",
                                            "options": {
                                                "information_type": {
                                                    "type": "str",
                                                    "choices": [
                                                        "exclude",
                                                        "lfa_candidate",
                                                    ],
                                                },
                                                "use_candidate_only": {
                                                    "type": "bool"
                                                },
                                                "interface": {
                                                    "type": "dict",
                                                    "options": {
                                                        "bvi": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "bundle_ether": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "pos_int": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "fast_ethernet": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "fiftygige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "fortygige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "fourhundredgige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "gigabitethernet": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "hundredgige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "mgmteth": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "multilink": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "pw_ether": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "pw_iw": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "srp": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "serial": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "tengige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "twentyfivegige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "twohundredgige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "nve": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "tunnel_ip": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "tunnel_ipsec": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "tunnel_mte": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "tunnel_mpls": {
                                                            "type": "int"
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                        "per_prefix": {
                                            "type": "dict",
                                            "options": {
                                                "information_type": {
                                                    "type": "str",
                                                    "choices": [
                                                        "exclude",
                                                        "lfa_candidate",
                                                    ],
                                                },
                                                "use_candidate_only": {
                                                    "type": "bool"
                                                },
                                                "interface": {
                                                    "type": "dict",
                                                    "options": {
                                                        "bvi": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "bundle_ether": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "pos_int": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "fast_ethernet": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "fiftygige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "fortygige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "fourhundredgige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "gigabitethernet": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "hundredgige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "mgmteth": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "multilink": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "pw_ether": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "pw_iw": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "srp": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "serial": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "tengige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "twentyfivegige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "twohundredgige": {
                                                            "type": "list",
                                                            "elements": "str",
                                                        },
                                                        "nve": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "tunnel_ip": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "tunnel_ipsec": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "tunnel_mte": {
                                                            "type": "list",
                                                            "elements": "int",
                                                        },
                                                        "tunnel_mpls": {
                                                            "type": "int"
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                    },
                                },
                                "flood_reduction": {"type": "bool"},
                                "hello_interval": {"type": "int"},
                                "instance_id": {"type": "int"},
                                "mtu_ignore": {"type": "bool"},
                                "mpls_ldp_sync": {"type": "bool"},
                                "network": {
                                    "type": "str",
                                    "choices": [
                                        "broadcast",
                                        "non-broadcast",
                                        "point-to-multipoint",
                                        "point-to-point",
                                    ],
                                },
                                "nssa": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "default_information_originate": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "metric": {"type": "int"},
                                                "metric_type": {"type": "int"},
                                            },
                                        },
                                        "no_redistribution": {"type": "bool"},
                                        "no_summary": {"type": "bool"},
                                        "translate": {
                                            "type": "dict",
                                            "options": {
                                                "type7": {
                                                    "type": "dict",
                                                    "options": {
                                                        "always": {
                                                            "type": "bool",
                                                            "required": True,
                                                        }
                                                    },
                                                }
                                            },
                                        },
                                    },
                                },
                                "packet_size": {"type": "int"},
                                "passive": {"type": "bool"},
                                "prefix_suppression": {"type": "bool"},
                                "priority": {"type": "int"},
                                "ranges": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "address": {
                                            "type": "str",
                                            "required": True,
                                        },
                                        "cost": {"type": "int"},
                                        "advertise": {"type": "bool"},
                                        "not_advertise": {"type": "bool"},
                                    },
                                },
                                "retransmit_interval": {"type": "int"},
                                "stub": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "no_summary": {"type": "bool"},
                                    },
                                },
                                "transmit_delay": {"type": "int"},
                                "virtual_link": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "id": {
                                            "type": "str",
                                            "required": True,
                                        },
                                        "authentication": {
                                            "type": "dict",
                                            "options": {
                                                "disable": {
                                                    "type": "bool",
                                                    "default": False,
                                                },
                                                "ipsec": {
                                                    "type": "dict",
                                                    "options": {
                                                        "spi": {"type": "int"},
                                                        "algorithim_type": {
                                                            "type": "str",
                                                            "choices": [
                                                                "md5",
                                                                "sha1",
                                                            ],
                                                        },
                                                        "key": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        },
                                                        "clear_key": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        },
                                                        "password_key": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                        "dead_interval": {"type": "int"},
                                        "hello_interval": {"type": "int"},
                                        "retransmit_interval": {"type": "int"},
                                        "transmit_delay": {"type": "int"},
                                        "encryption": {
                                            "type": "dict",
                                            "options": {
                                                "disable": {
                                                    "type": "bool",
                                                    "default": False,
                                                },
                                                "ipsec": {
                                                    "type": "dict",
                                                    "options": {
                                                        "spi": {"type": "int"},
                                                        "esp": {
                                                            "type": "dict",
                                                            "options": {
                                                                "triple_des": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "key": {
                                                                            "type": "str",
                                                                            "no_log": False,
                                                                        },
                                                                        "clear_key": {
                                                                            "type": "str",
                                                                            "no_log": False,
                                                                        },
                                                                        "password_key": {
                                                                            "type": "str",
                                                                            "no_log": False,
                                                                        },
                                                                    },
                                                                },
                                                                "aes": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "algorithim_type": {
                                                                            "type": "str",
                                                                            "choices": [
                                                                                "192",
                                                                                "256",
                                                                            ],
                                                                        },
                                                                        "key": {
                                                                            "type": "str",
                                                                            "no_log": False,
                                                                        },
                                                                        "clear_key": {
                                                                            "type": "str",
                                                                            "no_log": False,
                                                                        },
                                                                        "password_key": {
                                                                            "type": "str",
                                                                            "no_log": False,
                                                                        },
                                                                    },
                                                                },
                                                                "des": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "key": {
                                                                            "type": "str",
                                                                            "no_log": False,
                                                                        },
                                                                        "clear_key": {
                                                                            "type": "str",
                                                                            "no_log": False,
                                                                        },
                                                                        "password_key": {
                                                                            "type": "str",
                                                                            "no_log": False,
                                                                        },
                                                                    },
                                                                },
                                                                "null_encryption": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "authentication": {
                                                                            "type": "dict",
                                                                            "options": {
                                                                                "algorithim_type": {
                                                                                    "type": "str",
                                                                                    "choices": [
                                                                                        "md5",
                                                                                        "sha1",
                                                                                    ],
                                                                                },
                                                                                "key": {
                                                                                    "type": "str",
                                                                                    "no_log": False,
                                                                                },
                                                                                "clear_key": {
                                                                                    "type": "str",
                                                                                    "no_log": False,
                                                                                },
                                                                                "password_key": {
                                                                                    "type": "str",
                                                                                    "no_log": False,
                                                                                },
                                                                            },
                                                                        }
                                                                    },
                                                                },
                                                            },
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                    },
                                },
                                "encryption": {
                                    "type": "dict",
                                    "options": {
                                        "disable": {
                                            "type": "bool",
                                            "default": False,
                                        },
                                        "ipsec": {
                                            "type": "dict",
                                            "options": {
                                                "spi": {"type": "int"},
                                                "esp": {
                                                    "type": "dict",
                                                    "options": {
                                                        "triple_des": {
                                                            "type": "dict",
                                                            "options": {
                                                                "key": {
                                                                    "type": "str",
                                                                    "no_log": False,
                                                                },
                                                                "clear_key": {
                                                                    "type": "str",
                                                                    "no_log": False,
                                                                },
                                                                "password_key": {
                                                                    "type": "str",
                                                                    "no_log": False,
                                                                },
                                                            },
                                                        },
                                                        "aes": {
                                                            "type": "dict",
                                                            "options": {
                                                                "algorithim_type": {
                                                                    "type": "str",
                                                                    "choices": [
                                                                        "192",
                                                                        "256",
                                                                    ],
                                                                },
                                                                "key": {
                                                                    "type": "str",
                                                                    "no_log": False,
                                                                },
                                                                "clear_key": {
                                                                    "type": "str",
                                                                    "no_log": False,
                                                                },
                                                                "password_key": {
                                                                    "type": "str",
                                                                    "no_log": False,
                                                                },
                                                            },
                                                        },
                                                        "des": {
                                                            "type": "dict",
                                                            "options": {
                                                                "key": {
                                                                    "type": "str",
                                                                    "no_log": False,
                                                                },
                                                                "clear_key": {
                                                                    "type": "str",
                                                                    "no_log": False,
                                                                },
                                                                "password_key": {
                                                                    "type": "str",
                                                                    "no_log": False,
                                                                },
                                                            },
                                                        },
                                                        "null_encryption": {
                                                            "type": "dict",
                                                            "options": {
                                                                "authentication": {
                                                                    "type": "dict",
                                                                    "options": {
                                                                        "algorithim_type": {
                                                                            "type": "str",
                                                                            "choices": [
                                                                                "md5",
                                                                                "sha1",
                                                                            ],
                                                                        },
                                                                        "key": {
                                                                            "type": "str",
                                                                            "no_log": False,
                                                                        },
                                                                        "clear_key": {
                                                                            "type": "str",
                                                                            "no_log": False,
                                                                        },
                                                                        "password_key": {
                                                                            "type": "str",
                                                                            "no_log": False,
                                                                        },
                                                                    },
                                                                }
                                                            },
                                                        },
                                                    },
                                                },
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "capability": {
                            "type": "dict",
                            "options": {
                                "type7": {
                                    "type": "dict",
                                    "options": {
                                        "prefer": {"type": "bool"},
                                        "translate": {"type": "bool"},
                                    },
                                }
                            },
                        },
                        "cost": {"type": "int"},
                        "database_filter": {
                            "type": "dict",
                            "options": {"all_outgoing_lsa": {"type": "bool"}},
                        },
                        "dead_interval": {"type": "int"},
                        "default_information_originate": {
                            "type": "dict",
                            "options": {
                                "always": {"type": "bool"},
                                "metric": {"type": "int"},
                                "metric_type": {"type": "int"},
                                "route_policy": {"type": "str"},
                                "tag": {"type": "int"},
                                "set": {"type": "bool"},
                            },
                        },
                        "default_metric": {"type": "int"},
                        "demand_circuit": {"type": "bool"},
                        "distance": {
                            "type": "dict",
                            "options": {
                                "admin_distance": {"type": "int"},
                                "ospfv3_distance": {
                                    "type": "dict",
                                    "options": {
                                        "external": {"type": "int"},
                                        "inter_area": {"type": "int"},
                                        "intra_area": {"type": "int"},
                                    },
                                },
                            },
                        },
                        "distribute_list": {
                            "type": "dict",
                            "options": {
                                "prefix_list": {
                                    "type": "list",
                                    "elements": "str",
                                    "options": {
                                        "name": {"type": "str"},
                                        "in": {"type": "bool"},
                                        "out": {"type": "bool"},
                                    },
                                }
                            },
                        },
                        "encryption": {
                            "type": "dict",
                            "options": {
                                "disable": {"type": "bool", "default": False},
                                "ipsec": {
                                    "type": "dict",
                                    "options": {
                                        "spi": {"type": "int"},
                                        "esp": {
                                            "type": "dict",
                                            "options": {
                                                "triple_des": {
                                                    "type": "dict",
                                                    "options": {
                                                        "key": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        },
                                                        "clear_key": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        },
                                                        "password_key": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        },
                                                    },
                                                },
                                                "aes": {
                                                    "type": "dict",
                                                    "options": {
                                                        "algorithim_type": {
                                                            "type": "str",
                                                            "choices": [
                                                                "192",
                                                                "256",
                                                            ],
                                                        },
                                                        "key": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        },
                                                        "clear_key": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        },
                                                        "password_key": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        },
                                                    },
                                                },
                                                "des": {
                                                    "type": "dict",
                                                    "options": {
                                                        "key": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        },
                                                        "clear_key": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        },
                                                        "password_key": {
                                                            "type": "str",
                                                            "no_log": False,
                                                        },
                                                    },
                                                },
                                                "null_encryption": {
                                                    "type": "dict",
                                                    "options": {
                                                        "authentication": {
                                                            "type": "dict",
                                                            "options": {
                                                                "algorithim_type": {
                                                                    "type": "str",
                                                                    "choices": [
                                                                        "md5",
                                                                        "sha1",
                                                                    ],
                                                                },
                                                                "key": {
                                                                    "type": "str",
                                                                    "no_log": False,
                                                                },
                                                                "clear_key": {
                                                                    "type": "str",
                                                                    "no_log": False,
                                                                },
                                                                "password_key": {
                                                                    "type": "str",
                                                                    "no_log": False,
                                                                },
                                                            },
                                                        }
                                                    },
                                                },
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "fast_reroute": {
                            "type": "dict",
                            "options": {
                                "disabled": {"type": "bool"},
                                "per_link": {
                                    "type": "dict",
                                    "options": {
                                        "information_type": {
                                            "type": "str",
                                            "choices": [
                                                "exclude",
                                                "lfa_candidate",
                                            ],
                                        },
                                        "use_candidate_only": {"type": "bool"},
                                        "interface": {
                                            "type": "dict",
                                            "options": {
                                                "bvi": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "bundle_ether": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "pos_int": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "fast_ethernet": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "fiftygige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "fortygige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "fourhundredgige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "gigabitethernet": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "hundredgige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "mgmteth": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "multilink": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "pw_ether": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "pw_iw": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "srp": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "serial": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "tengige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "twentyfivegige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "twohundredgige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "nve": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "tunnel_ip": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "tunnel_ipsec": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "tunnel_mte": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "tunnel_mpls": {"type": "int"},
                                            },
                                        },
                                    },
                                },
                                "per_prefix": {
                                    "type": "dict",
                                    "options": {
                                        "information_type": {
                                            "type": "str",
                                            "choices": [
                                                "exclude",
                                                "lfa_candidate",
                                            ],
                                        },
                                        "use_candidate_only": {"type": "bool"},
                                        "interface": {
                                            "type": "dict",
                                            "options": {
                                                "bvi": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "bundle_ether": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "post_int": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "fast_ethernet": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "fiftygige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "fortygige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "fourhundredgige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "gigabitethernet": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "hundredgige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "mgmteth": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "multilink": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "pw_ether": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "pw_iw": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "srp": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "serial": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "tengige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "twentyfivegige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "twohundredgige": {
                                                    "type": "list",
                                                    "elements": "str",
                                                },
                                                "nve": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "tunnel_ip": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "tunnel_ipsec": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "tunnel_mte": {
                                                    "type": "list",
                                                    "elements": "int",
                                                },
                                                "tunnel_mpls": {"type": "int"},
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "flood_reduction": {"type": "bool"},
                        "graceful_restart": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "helper_disable": {"type": "bool"},
                                "min_interval": {"type": "int"},
                                "max_interval": {"type": "int"},
                            },
                        },
                        "hello_interval": {"type": "int"},
                        "ignore_mospf_type6_lsa": {"type": "bool"},
                        "instance_id": {"type": "int"},
                        "log_adjacency_changes": {
                            "type": "dict",
                            "options": {
                                "set": {"type": "bool"},
                                "disable": {"type": "bool"},
                                "detail": {"type": "bool"},
                            },
                        },
                        "maximum": {
                            "type": "dict",
                            "options": {
                                "interfaces": {"type": "int"},
                                "paths": {"type": "int"},
                                "redistributed_prefixes": {"type": "int"},
                            },
                        },
                        "mpls_ldp_sync": {"type": "bool"},
                        "mtu_ignore": {"type": "bool"},
                        "network": {
                            "type": "str",
                            "choices": [
                                "broadcast",
                                "non-broadcast",
                                "point-to-multipoint",
                                "point-to-point",
                            ],
                        },
                        "nsr": {"type": "bool"},
                        "packet_size": {"type": "int"},
                        "passive": {"type": "bool"},
                        "prefix_suppression": {"type": "bool"},
                        "priority": {"type": "int"},
                        "protocol_shutdown": {"type": "bool"},
                        "redistribute": {
                            "type": "dict",
                            "options": {
                                "application": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "id": {
                                            "type": "str",
                                            "required": True,
                                        },
                                        "set": {"type": "bool"},
                                        "metric": {"type": "int"},
                                        "metric_type": {"type": "int"},
                                        "route_policy": {"type": "str"},
                                        "tag": {"type": "int"},
                                    },
                                },
                                "bgp": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "id": {
                                            "type": "int",
                                            "required": True,
                                        },
                                        "set": {"type": "bool"},
                                        "metric": {"type": "int"},
                                        "metric_type": {"type": "int"},
                                        "preserved_med": {"type": "str"},
                                        "route_policy": {"type": "str"},
                                        "tag": {"type": "int"},
                                    },
                                },
                                "connected": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "metric": {"type": "int"},
                                        "metric_type": {"type": "int"},
                                        "route_policy": {"type": "str"},
                                        "tag": {"type": "int"},
                                    },
                                },
                                "eigrp": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "id": {
                                            "type": "int",
                                            "required": True,
                                        },
                                        "set": {"type": "bool"},
                                        "match": {
                                            "type": "str",
                                            "choices": [
                                                "external",
                                                "internal",
                                            ],
                                        },
                                        "metric": {"type": "int"},
                                        "metric_type": {"type": "int"},
                                        "route_policy": {"type": "str"},
                                        "tag": {"type": "int"},
                                    },
                                },
                                "isis": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "id": {
                                            "type": "str",
                                            "required": True,
                                        },
                                        "set": {"type": "bool"},
                                        "level": {
                                            "type": "str",
                                            "choices": [
                                                "level-1",
                                                "level-1-2",
                                                "level-2",
                                            ],
                                        },
                                        "metric": {"type": "int"},
                                        "metric_type": {"type": "int"},
                                        "route_policy": {"type": "str"},
                                        "tag": {"type": "int"},
                                    },
                                },
                                "mobile": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "metric": {"type": "int"},
                                        "metric_type": {"type": "int"},
                                        "route_policy": {"type": "str"},
                                        "tag": {"type": "int"},
                                    },
                                },
                                "ospfv3": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "id": {
                                            "type": "str",
                                            "required": True,
                                        },
                                        "set": {"type": "bool"},
                                        "match": {
                                            "type": "dict",
                                            "options": {
                                                "external": {
                                                    "type": "int",
                                                    "choices": ["1", "2"],
                                                },
                                                "nssa_external": {
                                                    "type": "int",
                                                    "choices": ["1", "2"],
                                                },
                                                "internal": {"type": "bool"},
                                            },
                                        },
                                        "metric": {"type": "int"},
                                        "metric_type": {"type": "int"},
                                        "route_policy": {"type": "str"},
                                        "tag": {"type": "int"},
                                    },
                                },
                                "static": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "metric": {"type": "int"},
                                        "metric_type": {"type": "int"},
                                        "route_policy": {"type": "str"},
                                        "tag": {"type": "int"},
                                    },
                                },
                                "subscriber": {
                                    "type": "dict",
                                    "options": {
                                        "set": {"type": "bool"},
                                        "metric": {"type": "int"},
                                        "metric_type": {"type": "int"},
                                        "route_policy": {"type": "str"},
                                        "tag": {"type": "int"},
                                    },
                                },
                            },
                        },
                        "retransmit_interval": {"type": "int"},
                        "router_id": {"type": "str"},
                        "spf_prefix_priority": {
                            "type": "dict",
                            "options": {
                                "disable": {"type": "bool"},
                                "route_policy": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "name": {"type": "str"},
                                        "value": {"type": "str"},
                                    },
                                },
                            },
                        },
                        "stub_router": {
                            "type": "dict",
                            "options": {
                                "router_lsa": {
                                    "type": "dict",
                                    "options": {
                                        "advertise_with": {
                                            "type": "str",
                                            "choices": [
                                                "max-metric",
                                                "r-bit",
                                                "v6-bit",
                                            ],
                                        },
                                        "always": {"type": "bool"},
                                        "external_lsa": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "metric": {"type": "int"},
                                            },
                                        },
                                        "include_stub": {"type": "bool"},
                                        "on_proc_migration": {"type": "int"},
                                        "on_proc_restart": {"type": "int"},
                                        "on_startup": {
                                            "type": "dict",
                                            "options": {
                                                "time": {"type": "int"},
                                                "wait_for_bgp": {
                                                    "type": "bool"
                                                },
                                            },
                                        },
                                        "on_switchover": {"type": "int"},
                                        "summary_lsa": {
                                            "type": "dict",
                                            "options": {
                                                "set": {"type": "bool"},
                                                "metric": {"type": "int"},
                                            },
                                        },
                                    },
                                }
                            },
                        },
                        "summary_prefix": {
                            "type": "list",
                            "elements": "dict",
                            "options": {
                                "prefix": {"type": "str", "required": True},
                                "not_advertise": {"type": "bool"},
                                "tag": {"type": "int"},
                            },
                        },
                        "timers": {
                            "type": "dict",
                            "options": {
                                "lsa_arrival": {"type": "int"},
                                "pacing": {
                                    "type": "dict",
                                    "options": {
                                        "flood": {"type": "int"},
                                        "lsa_group": {"type": "int"},
                                        "retransmission": {"type": "int"},
                                    },
                                },
                                "throttle": {
                                    "type": "dict",
                                    "options": {
                                        "lsa": {
                                            "type": "dict",
                                            "options": {
                                                "all_lsa_initial": {
                                                    "type": "int"
                                                },
                                                "all_lsa_minimum": {
                                                    "type": "int"
                                                },
                                            },
                                        },
                                        "spf": {
                                            "type": "dict",
                                            "options": {
                                                "spf_initial": {"type": "int"},
                                                "spf_minimum": {"type": "int"},
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        "trace": {
                            "type": "dict",
                            "options": {
                                "size": {"type": "str"},
                                "value": {"type": "int"},
                            },
                        },
                        "transmit_delay": {"type": "int"},
                    },
                }
            },
        },
        "state": {
            "type": "str",
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "rendered",
                "parsed",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
