/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.units;

import java.io.Serializable;

public abstract class AUnit
implements Serializable {
    protected int m_decimals = 2;
    protected double m_factor;
    protected AUnit m_nexLowerUnit;
    protected AUnit m_nextHigherUnit;
    protected String m_unitName;

    protected AUnit() {
    }

    public int getDecimals() {
        return this.m_decimals;
    }

    public double getFactor() {
        return this.m_factor;
    }

    public String getLabel(double value) {
        return new StringBuffer().append(this.round(value / this.m_factor)).append(" ").append(this.m_unitName).toString();
    }

    public AUnit getNexLowerUnit() {
        return this.m_nexLowerUnit;
    }

    public AUnit getNextHigherUnit() {
        return this.m_nextHigherUnit;
    }

    public String getUnitName() {
        return this.m_unitName;
    }

    public double getValue(double value) {
        return this.round(value / this.m_factor);
    }

    private final double round(double value) {
        double tmp = Math.pow(10.0, this.m_decimals);
        return Math.floor(value * tmp + 0.5) / tmp;
    }

    public void setDecimals(int aftercomma) {
        if (aftercomma >= 0) {
            this.m_decimals = aftercomma;
        }
    }

    public String toString() {
        return this.getUnitName();
    }
}

