/// <reference types="node" />
import crypto, { KeyLike } from 'crypto';
import { CacheProvider as InMemoryCacheProvider } from './inmemory-cache-provider';
import type { Request } from 'express';
interface SAMLOptions {
    acceptedClockSkewMs: number;
    protocol: string;
    host: string;
    callbackUrl: string;
    signatureAlgorithm: string;
    path: string;
    privateCert: string;
    logoutUrl: string;
    entryPoint: string;
    skipRequestCompression: boolean;
    idpIssuer: string;
    additionalParams: Record<string, string>;
    additionalAuthorizeParams: Record<string, string>;
    additionalLogoutParams: Record<string, string>;
    cacheProvider: InMemoryCacheProvider;
    issuer: string;
    identifierFormat: string;
    cert: string | string[];
    passive: boolean;
    decryptionPvk: string;
    logoutCallbackUrl: string;
    validateInResponseTo: boolean;
    requestIdExpirationPeriodMs: number;
    audience: string;
}
declare class SAML {
    options: SAMLOptions;
    cacheProvider: InMemoryCacheProvider;
    constructor(options: any);
    initialize(options: any): any;
    getProtocol(req: any): any;
    getCallbackUrl(req: any): string;
    generateUniqueID(): string;
    generateInstant(): string;
    signRequest(samlMessage: any): void;
    generateAuthorizeRequest: (req: any, isPassive: any, isHttpPostBinding: any, callback: any) => void;
    generateLogoutRequest(req: any): any;
    generateLogoutResponse: (req: any, logoutRequest: any) => string;
    requestToUrl(request: any, response: any, operation: any, additionalParameters: any, callback: any): void;
    getAdditionalParams(req: Request, operation: any, overrideParams?: any): Record<string, any>;
    getAuthorizeUrl(req: any, options: any, callback: any): void;
    getAuthorizeForm(req: any, callback: any): void;
    getLogoutUrl(req: any, options: any, callback: any): any;
    getLogoutResponseUrl(req: any, options: any, callback: any): void;
    certToPEM(cert: any): any;
    certsToCheck(): any;
    validateSignature: (fullXml: any, currentNode: any, certs: any) => any;
    validateSignatureForCert(signature: any, cert: any, fullXml: any, currentNode: any): boolean;
    validatePostResponse(container: any, callback: any): void;
    validateInResponseTo(inResponseTo: any): any;
    validateRedirect(container: any, originalQuery: any, callback: any): void;
    hasValidSignatureForRedirect(container: any, originalQuery: any): any;
    validateSignatureForRedirect(urlString: any, signature: any, alg: any, cert: any): boolean;
    verifyLogoutRequest(doc: any): void;
    verifyLogoutResponse(doc: any): Promise<any>;
    verifyIssuer(samlMessage: any): void;
    processValidlySignedAssertion(xml: any, samlResponseXml: any, inResponseTo: any, callback: any): void;
    checkTimestampsValidityError(nowMs: any, notBefore: any, notOnOrAfter: any): Error;
    checkAudienceValidityError(expectedAudience: any, audienceRestrictions: any): any;
    validatePostRequest(container: any, callback: any): void;
    getNameID(self: any, doc: any, callback: any): any;
    generateServiceProviderMetadata(decryptionCert: any, signingCert: any): string;
    keyToPEM(key: KeyLike): crypto.KeyLike;
}
export { SAML };
