/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.api.Interface;
import javajs.util.BS;
import javajs.util.CifDataParser;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.V3;
import org.jmol.adapter.readers.cif.MSCifParser;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.Logger;
import org.jmol.util.Vibration;

public class CifReader
extends AtomSetCollectionReader {
    protected static final String CELL_TYPE_MAGNETIC_PARENT = "parent";
    protected static final String CELL_TYPE_MAGNETIC_STANDARD = "standard";
    Parser subParser;
    private static final String titleRecords = "__citation_title__publ_section_title__active_magnetic_irreps_details__";
    private MSCifParser modr;
    GenericCifDataParser cifParser;
    private boolean isAFLOW;
    private boolean filterAssembly;
    private boolean allowRotations = true;
    private boolean readIdeal = true;
    private int configurationPtr = Integer.MIN_VALUE;
    protected boolean useAuthorChainID = true;
    protected String thisDataSetName = "";
    protected String lastDataSetName;
    private String chemicalName = "";
    private String thisStructuralFormula = "";
    private String thisFormula = "";
    protected boolean iHaveDesiredModel;
    protected boolean isMMCIF;
    protected boolean isLigand;
    protected boolean isMagCIF;
    boolean haveHAtoms;
    private String molecularType = "GEOM_BOND default";
    private char lastAltLoc = '\u0000';
    private boolean haveAromatic;
    private int conformationIndex;
    private int nMolecular = 0;
    private String appendedData;
    protected boolean skipping;
    protected int nAtoms;
    protected int ac;
    private String auditBlockCode;
    private String lastSpaceGroupName;
    private boolean modulated;
    protected boolean isCourseGrained;
    boolean haveCellWaveVector;
    protected Map<String, String> htGroup1;
    protected int nAtoms0;
    private int titleAtomSet = 1;
    private Map<String, String> htCellTypes;
    public Map<String, Integer> modelMap;
    private boolean haveGlobalDummy;
    private Hashtable<String, Object> htAudit;
    public Lst<String> symops;
    protected String pdbID;
    private static final String[] TransformFields = new String[]{"x[1][1]", "x[1][2]", "x[1][3]", "r[1]", "x[2][1]", "x[2][2]", "x[2][3]", "r[2]", "x[3][1]", "x[3][2]", "x[3][3]", "r[3]"};
    String key;
    String key0;
    String data;
    private boolean isLoop;
    int[] col2key = new int[100];
    int[] key2col = new int[100];
    String field;
    protected char firstChar = '\u0000';
    private Map<String, float[]> htOxStates;
    private Lst<Object[]> bondTypes = new Lst();
    private String disorderAssembly = ".";
    private String lastDisorderAssembly;
    private Lst<float[]> lattvecs;
    private Lst<String> magCenterings;
    protected int maxSerial;
    private static final byte ATOM_TYPE_SYMBOL = 0;
    private static final byte ATOM_TYPE_OXIDATION_NUMBER = 1;
    private static final byte ATOM_TYPE_RADIUS_BOND = 2;
    private static final String[] atomTypeFields = new String[]{"_atom_type_symbol", "_atom_type_oxidation_number", "_atom_type_radius_bond"};
    protected static final byte NONE = -1;
    private static final byte TYPE_SYMBOL = 0;
    private static final byte LABEL = 1;
    private static final byte AUTH_ATOM_ID = 2;
    private static final byte FRACT_X = 3;
    private static final byte FRACT_Y = 4;
    private static final byte FRACT_Z = 5;
    private static final byte CARTN_X = 6;
    private static final byte CARTN_Y = 7;
    private static final byte CARTN_Z = 8;
    private static final byte OCCUPANCY = 9;
    private static final byte B_ISO = 10;
    private static final byte AUTH_COMP_ID = 11;
    private static final byte AUTH_ASYM_ID = 12;
    private static final byte AUTH_SEQ_ID = 13;
    private static final byte INS_CODE = 14;
    private static final byte ALT_ID = 15;
    private static final byte GROUP_PDB = 16;
    private static final byte MODEL_NO = 17;
    private static final byte DUMMY_ATOM = 18;
    private static final byte DISORDER_GROUP = 19;
    private static final byte ANISO_LABEL = 20;
    private static final byte ANISO_MMCIF_ID = 21;
    private static final byte ANISO_U11 = 22;
    private static final byte ANISO_U22 = 23;
    private static final byte ANISO_U33 = 24;
    private static final byte ANISO_U12 = 25;
    private static final byte ANISO_U13 = 26;
    private static final byte ANISO_U23 = 27;
    private static final byte ANISO_MMCIF_U11 = 28;
    private static final byte ANISO_MMCIF_U22 = 29;
    private static final byte ANISO_MMCIF_U33 = 30;
    private static final byte ANISO_MMCIF_U12 = 31;
    private static final byte ANISO_MMCIF_U13 = 32;
    private static final byte ANISO_MMCIF_U23 = 33;
    private static final byte U_ISO_OR_EQUIV = 34;
    private static final byte ANISO_B11 = 35;
    private static final byte ANISO_B22 = 36;
    private static final byte ANISO_B33 = 37;
    private static final byte ANISO_B12 = 38;
    private static final byte ANISO_B13 = 39;
    private static final byte ANISO_B23 = 40;
    private static final byte ANISO_BETA_11 = 41;
    private static final byte ANISO_BETA_22 = 42;
    private static final byte ANISO_BETA_33 = 43;
    private static final byte ANISO_BETA_12 = 44;
    private static final byte ANISO_BETA_13 = 45;
    private static final byte ANISO_BETA_23 = 46;
    private static final byte ADP_TYPE = 47;
    private static final byte CC_COMP_ID = 48;
    private static final byte CC_ATOM_ID = 49;
    private static final byte CC_ATOM_SYM = 50;
    private static final byte CC_ATOM_CHARGE = 51;
    private static final byte CC_ATOM_X = 52;
    private static final byte CC_ATOM_Y = 53;
    private static final byte CC_ATOM_Z = 54;
    private static final byte CC_ATOM_X_IDEAL = 55;
    private static final byte CC_ATOM_Y_IDEAL = 56;
    private static final byte CC_ATOM_Z_IDEAL = 57;
    private static final byte DISORDER_ASSEMBLY = 58;
    private static final byte LABEL_ASYM_ID = 59;
    private static final byte SUBSYS_ID = 60;
    private static final byte SITE_MULT = 61;
    private static final byte THERMAL_TYPE = 62;
    private static final byte MOMENT_LABEL = 63;
    private static final byte MOMENT_PRELIM_X = 64;
    private static final byte MOMENT_PRELIM_Y = 65;
    private static final byte MOMENT_PRELIM_Z = 66;
    private static final byte MOMENT_X = 67;
    private static final byte MOMENT_Y = 68;
    private static final byte MOMENT_Z = 69;
    private static final byte ATOM_ID = 70;
    private static final byte LABEL_SEQ_ID = 71;
    private static final byte LABEL_COMP_ID = 72;
    private static final byte LABEL_ATOM_ID = 73;
    protected static final String FAMILY_ATOM = "_atom_site";
    private static final String[] atomFields = new String[]{"*_type_symbol", "*_label", "*_auth_atom_id", "*_fract_x", "*_fract_y", "*_fract_z", "*_cartn_x", "*_cartn_y", "*_cartn_z", "*_occupancy", "*_b_iso_or_equiv", "*_auth_comp_id", "*_auth_asym_id", "*_auth_seq_id", "*_pdbx_pdb_ins_code", "*_label_alt_id", "*_group_pdb", "*_pdbx_pdb_model_num", "*_calc_flag", "*_disorder_group", "*_aniso_label", "*_anisotrop_id", "*_aniso_u_11", "*_aniso_u_22", "*_aniso_u_33", "*_aniso_u_12", "*_aniso_u_13", "*_aniso_u_23", "*_anisotrop_u[1][1]", "*_anisotrop_u[2][2]", "*_anisotrop_u[3][3]", "*_anisotrop_u[1][2]", "*_anisotrop_u[1][3]", "*_anisotrop_u[2][3]", "*_u_iso_or_equiv", "*_aniso_b_11", "*_aniso_b_22", "*_aniso_b_33", "*_aniso_b_12", "*_aniso_b_13", "*_aniso_b_23", "*_aniso_beta_11", "*_aniso_beta_22", "*_aniso_beta_33", "*_aniso_beta_12", "*_aniso_beta_13", "*_aniso_beta_23", "*_adp_type", "_chem_comp_atom_comp_id", "_chem_comp_atom_atom_id", "_chem_comp_atom_type_symbol", "_chem_comp_atom_charge", "_chem_comp_atom_model_cartn_x", "_chem_comp_atom_model_cartn_y", "_chem_comp_atom_model_cartn_z", "_chem_comp_atom_pdbx_model_cartn_x_ideal", "_chem_comp_atom_pdbx_model_cartn_y_ideal", "_chem_comp_atom_pdbx_model_cartn_z_ideal", "*_disorder_assembly", "*_label_asym_id", "*_subsystem_code", "*_symmetry_multiplicity", "*_thermal_displace_type", "*_moment_label", "*_moment_crystalaxis_mx", "*_moment_crystalaxis_my", "*_moment_crystalaxis_mz", "*_moment_crystalaxis_x", "*_moment_crystalaxis_y", "*_moment_crystalaxis_z", "*_id", "*_label_seq_id", "*_label_comp_id", "*_label_atom_id"};
    private static final byte CITATION_TITLE = 0;
    private static final String[] citationFields = new String[]{"_citation_title"};
    private static final byte SYM_XYZ = 0;
    private static final byte SYM_MAGN_XYZ = 1;
    private static final byte SYM_SSG_ALG = 2;
    private static final byte SYM_MAGN_SSG_ALG = 3;
    private static final byte SYM_EQ_XYZ = 4;
    private static final byte SYM_SSG_EQ_XYZ = 5;
    private static final byte SYM_MAGN_REV = 7;
    private static final byte SYM_MAGN_SSG_REV = 8;
    private static final byte SYM_MAGN_REV_PRELIM = 6;
    private static final byte SYM_MAGN_CENTERING = 9;
    private static final byte SYM_MAGN_SSG_CENTERING = 10;
    private static final byte SYM_MAGN_SSG_CENT_XYZ = 11;
    private static final String FAMILY_SGOP = "_space_group_symop";
    private static final String[] symmetryOperationsFields = new String[]{"*_operation_xyz", "*_magn_operation_xyz", "*_ssg_operation_algebraic", "*_magn_ssg_operation_algebraic", "_symmetry_equiv_pos_as_xyz", "_symmetry_ssg_equiv_pos_as_xyz", "*_magn_operation_timereversal", "*_magn_ssg_operation_timereversal", "*_operation_timereversal", "*_magn_centering_xyz", "*_magn_ssg_centering_algebraic", "*_magn_ssg_centering_xyz"};
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 0;
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 1;
    private static final byte GEOM_BOND_DISTANCE = 2;
    private static final byte CCDC_GEOM_BOND_TYPE = 3;
    private static final String[] geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2", "_geom_bond_distance", "_ccdc_geom_bond_type"};
    private float[] atomRadius;
    private BS[] bsConnected;
    private BS[] bsSets;
    private final P3 ptOffset = new P3();
    private BS bsMolecule;
    private BS bsExclude;
    private int firstAtom;
    private Atom[] atoms;
    private BS bsBondDuplicates;

    @Override
    public void initializeReader() throws Exception {
        this.initSubclass();
        this.allowPDBFilter = true;
        this.appendedData = (String)this.htParams.get("appendedData");
        String conf = this.getFilter("CONF ");
        if (conf != null) {
            this.configurationPtr = this.parseIntStr(conf);
        }
        this.isMolecular = this.checkFilterKey("MOLECUL") && !this.checkFilterKey("BIOMOLECULE");
        this.isPrimitive = this.checkFilterKey("PRIMITIVE");
        this.readIdeal = !this.checkFilterKey("NOIDEAL");
        this.filterAssembly = this.checkFilterKey("$");
        boolean bl = this.useAuthorChainID = !this.checkFilterKey("NOAUTHORCHAINS");
        if (this.isMolecular) {
            this.forceSymmetry(false);
            this.molecularType = "filter \"MOLECULAR\"";
        }
        this.asc.checkSpecial = !this.checkFilterKey("NOSPECIAL");
        boolean bl2 = this.allowRotations = !this.checkFilterKey("NOSYM");
        if (this.strSupercell != null && this.strSupercell.indexOf(",") >= 0) {
            this.addCellType("conventional", this.strSupercell, true);
        }
        if (this.binaryDoc != null) {
            return;
        }
        this.readCifData();
        this.continuing = false;
    }

    protected void initSubclass() {
    }

    private void readCifData() throws Exception {
        block2: {
            this.cifParser = this.getCifDataParser();
            this.line = "";
            while (this.continueWith(this.key = (String)this.cifParser.peekToken()) && this.readAllData()) {
            }
            if (this.appendedData == null) break block2;
            this.cifParser = ((GenericCifDataParser)this.getInterface("javajs.util.CifDataParser")).set(null, Rdr.getBR(this.appendedData), this.debugging);
            while ((this.key = (String)this.cifParser.peekToken()) != null && this.readAllData()) {
            }
        }
    }

    private boolean continueWith(String key) {
        boolean ret = key != null && (this.ac == 0 || !key.equals("_shelx_hkl_file"));
        return ret;
    }

    protected GenericCifDataParser getCifDataParser() {
        return new CifDataParser().set(this, null, this.debugging);
    }

    private boolean readAllData() throws Exception {
        if (this.key.startsWith("data_")) {
            this.isLigand = false;
            if (this.asc.atomSetCount == 0) {
                this.iHaveDesiredModel = false;
            }
            if (this.iHaveDesiredModel) {
                return false;
            }
            if (this.desiredModelNumber != Integer.MIN_VALUE) {
                this.appendLoadNote(null);
            }
            this.newModel(-1);
            this.haveCellWaveVector = false;
            if (this.auditBlockCode == null) {
                this.modulated = false;
            }
            if (!this.skipping) {
                this.nAtoms0 = this.asc.ac;
                this.processDataParameter();
                this.nAtoms = this.asc.ac;
            }
            return true;
        }
        if (this.skipping && this.key.equals("_audit_block_code")) {
            this.iHaveDesiredModel = false;
            this.skipping = false;
        }
        this.isLoop = this.key.startsWith("loop_");
        if (this.isLoop) {
            if (this.skipping && !this.isMMCIF) {
                this.cifParser.getTokenPeeked();
                this.cifParser.skipLoop(false);
            } else {
                this.processLoopBlock();
            }
            return true;
        }
        if (this.key.indexOf("_") != 0) {
            Logger.warn(this.key.startsWith("save_") ? "CIF reader ignoring save_" : "CIF ERROR ? should be an underscore: " + this.key);
            this.cifParser.getTokenPeeked();
        } else if (!this.getData()) {
            return true;
        }
        if (!this.skipping) {
            this.key0 = this.key;
            this.key = this.cifParser.fixKey(this.key0);
            if (this.key.startsWith("_chemical_name") || this.key.equals("_chem_comp_name")) {
                this.processChemicalInfo("name");
            } else if (this.key.startsWith("_chemical_formula_structural")) {
                this.processChemicalInfo("structuralFormula");
            } else if (this.key.startsWith("_chemical_formula_sum") || this.key.equals("_chem_comp_formula")) {
                this.processChemicalInfo("formula");
            } else if (this.key.equals("_cell_modulation_dimension")) {
                this.modDim = this.parseIntStr(this.data);
                if (this.modr != null) {
                    this.modr.setModDim(this.modDim);
                }
            } else if (!this.skipKey(this.key)) {
                if (this.key.startsWith("_cell_") && this.key.indexOf("_commen_") < 0) {
                    this.processCellParameter();
                } else if (this.key.startsWith("_atom_sites_fract_tran")) {
                    this.processUnitCellTransformMatrix();
                } else if (this.key.startsWith("_audit")) {
                    if (this.key.equals("_audit_block_code")) {
                        this.auditBlockCode = this.cifParser.fullTrim(this.data).toUpperCase();
                        this.appendLoadNote(this.auditBlockCode);
                        if (this.htAudit != null && this.auditBlockCode.contains("_MOD_")) {
                            String key = PT.rep(this.auditBlockCode, "_MOD_", "_REFRNCE_");
                            if (this.asc.setSymmetry((SymmetryInterface)this.htAudit.get(key)) != null) {
                                this.unitCellParams = this.asc.getSymmetry().getUnitCellParams();
                                this.iHaveUnitCell = true;
                            }
                        } else if (this.htAudit != null && this.symops != null) {
                            for (int i = 0; i < this.symops.size(); ++i) {
                                this.setSymmetryOperator((String)this.symops.get(i));
                            }
                        }
                        if (this.lastSpaceGroupName != null) {
                            this.setSpaceGroupName(this.lastSpaceGroupName);
                        }
                    } else if (this.key.equals("_audit_creation_date")) {
                        this.symmetry = null;
                    }
                } else if (this.key.startsWith("_chem_comp_atom") || this.key.startsWith("_atom")) {
                    this.processLoopBlock();
                } else if (this.key.startsWith("_symmetry_space_group_name_h-m") || this.key.startsWith("_symmetry_space_group_name_hall") || this.key.startsWith("_space_group_name") || this.key.contains("_ssg_name") || this.key.contains("_magn_name") || this.key.contains("_bns_name")) {
                    this.processSymmetrySpaceGroupName();
                } else if (this.key.startsWith("_space_group_transform") || this.key.startsWith("_parent_space_group") || this.key.startsWith("_space_group_magn_transform")) {
                    this.processUnitCellTransform();
                } else if (this.key.contains("_database_code")) {
                    this.addModelTitle("ID");
                } else if (titleRecords.contains("_" + this.key + "__")) {
                    this.addModelTitle("TITLE");
                } else if (this.key.startsWith("_aflow_")) {
                    this.isAFLOW = true;
                } else if (this.key.equals("_symmetry_int_tables_number")) {
                    int intTableNo = this.parseIntStr(this.data);
                    this.rotateHexCell = this.isAFLOW && intTableNo >= 143 && intTableNo <= 194;
                } else if (this.key.equals("_entry_id")) {
                    this.pdbID = this.data;
                } else if (this.key.startsWith("_topol_")) {
                    this.getTopologyParser().ProcessRecord(this.key, this.data);
                } else {
                    this.processSubclassEntry();
                }
            }
        }
        return true;
    }

    private boolean skipKey(String key) {
        return key.startsWith("_shelx_") || key.startsWith("_reflns_") || key.startsWith("_diffrn_");
    }

    private void addModelTitle(String key) {
        if (this.asc.atomSetCount > this.titleAtomSet) {
            this.titleAtomSet = this.asc.atomSetCount;
            this.appendLoadNote("\nMODEL: " + this.titleAtomSet);
        }
        this.appendLoadNote(key + ": " + this.cifParser.fullTrim(this.data));
    }

    protected void processSubclassEntry() throws Exception {
        if (this.modDim > 0) {
            this.getModulationReader().processEntry();
        }
    }

    private void processUnitCellTransform() {
        this.data = PT.replaceAllCharacters(this.data, " ", "");
        if (this.key.contains("_from_parent") || this.key.contains("child_transform")) {
            this.addCellType(CELL_TYPE_MAGNETIC_PARENT, this.data, true);
        } else if (this.key.contains("_to_standard") || this.key.contains("transform_bns_pp_abc")) {
            this.addCellType(CELL_TYPE_MAGNETIC_STANDARD, this.data, false);
        }
        this.appendLoadNote(this.key + ": " + this.data);
    }

    private void addCellType(String type, String data, boolean isFrom) {
        if (this.htCellTypes == null) {
            this.htCellTypes = new Hashtable<String, String>();
        }
        if (data.startsWith("!")) {
            data = data.substring(1);
            isFrom = !isFrom;
        }
        String cell = (isFrom ? "!" : "") + data;
        this.htCellTypes.put(type, cell);
        if (type.equalsIgnoreCase(this.strSupercell)) {
            this.strSupercell = cell;
            this.htCellTypes.put("conventional", (isFrom ? "" : "!") + data);
        }
    }

    private MSCifParser getModulationReader() throws Exception {
        return this.modr == null ? this.initializeMSCIF() : this.modr;
    }

    private MSCifParser initializeMSCIF() throws Exception {
        if (this.modr == null) {
            this.modr = (MSCifParser)this.getInterface("org.jmol.adapter.readers.cif.MSCifParser");
            this.ms = this.modr;
        }
        this.modulated = this.modr.initialize(this, this.modDim) > 0;
        return this.modr;
    }

    protected void newModel(int modelNo) throws Exception {
        if (modelNo < 0) {
            if (this.modelNumber == 1 && this.asc.ac == 0 && this.nAtoms == 0 && !this.haveGlobalDummy) {
                this.modelNumber = 0;
                this.haveModel = false;
                this.haveGlobalDummy = true;
                this.asc.removeCurrentAtomSet();
            }
            modelNo = ++this.modelNumber;
        }
        boolean bl = this.skipping = !this.doGetModel(this.modelNumber = modelNo, null);
        if (this.skipping) {
            if (!this.isMMCIF) {
                this.cifParser.getTokenPeeked();
            }
            return;
        }
        this.chemicalName = "";
        this.thisStructuralFormula = "";
        this.thisFormula = "";
        this.iHaveDesiredModel = this.isLastModel(this.modelNumber);
        if (this.isCourseGrained) {
            this.asc.setCurrentModelInfo("courseGrained", Boolean.TRUE);
        }
        if (this.nAtoms0 > 0 && this.nAtoms0 == this.asc.ac) {
            --this.modelNumber;
            this.haveModel = false;
            this.asc.removeCurrentAtomSet();
        } else {
            this.applySymmetryAndSetTrajectory();
        }
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        if (this.htOxStates != null) {
            this.setOxidationStates();
        }
        if (this.asc.iSet > 0 && this.asc.getAtomSetAtomCount(this.asc.iSet) == 0) {
            --this.asc.atomSetCount;
        } else if (!this.finalizeSubclass()) {
            this.applySymmetryAndSetTrajectory();
        }
        int n = this.asc.atomSetCount;
        if (n > 1) {
            this.asc.setCollectionName("<collection of " + n + " models>");
        }
        if (this.pdbID != null) {
            this.asc.setCurrentModelInfo("pdbID", this.pdbID);
        }
        this.finalizeReaderASCR();
        this.addHeader();
        if (this.haveAromatic) {
            this.addJmolScript("calculate aromatic");
        }
    }

    private void setOxidationStates() {
        int i = this.asc.ac;
        while (--i >= 0) {
            float[] data;
            Atom a = this.asc.atoms[i];
            String sym = a.typeSymbol;
            if (sym == null || (data = this.htOxStates.get(sym)) == null) continue;
            float charge = data[0];
            float radius = data[1];
            if (!Float.isNaN(charge)) {
                a.formalCharge = Math.round(charge);
            }
            if (Float.isNaN(radius)) continue;
            a.bondingRadius = radius;
        }
    }

    protected void addHeader() {
        String header = this.cifParser.getFileHeader();
        if (header.length() > 0) {
            String s = this.setLoadNote();
            this.appendLoadNote(null);
            this.appendLoadNote(header);
            this.appendLoadNote(s);
            this.setLoadNote();
            this.asc.setInfo("fileHeader", header);
        }
    }

    protected boolean finalizeSubclass() throws Exception {
        return this.subParser == null ? false : this.subParser.finalizeReader();
    }

    @Override
    public void doPreSymmetry() throws Exception {
        if (this.magCenterings != null) {
            this.addLatticeVectors();
        }
        if (this.modDim > 0) {
            this.getModulationReader().setModulation(false, null);
        }
        if (this.isMagCIF) {
            this.asc.getXSymmetry().scaleFractionalVibs();
            this.vibsFractional = true;
        }
    }

    @Override
    public void applySymmetryAndSetTrajectory() throws Exception {
        boolean doCheckBonding;
        if (this.isMMCIF) {
            this.asc.checkSpecial = false;
        }
        boolean bl = doCheckBonding = this.doCheckUnitCell && !this.isMMCIF;
        if (this.isMMCIF && this.asc.iSet >= 0) {
            int modelIndex = this.asc.iSet;
            this.asc.setCurrentModelInfo("PDB_CONECT_firstAtom_count_max", new int[]{this.asc.getAtomSetAtomIndex(modelIndex), this.asc.getAtomSetAtomCount(modelIndex), this.maxSerial});
        }
        if (this.htCellTypes != null) {
            for (Map.Entry<String, String> e : this.htCellTypes.entrySet()) {
                this.asc.setCurrentModelInfo("unitcell_" + e.getKey(), e.getValue());
            }
            this.htCellTypes = null;
        }
        if (!this.haveCellWaveVector) {
            this.modDim = 0;
        }
        if (this.doApplySymmetry && !this.iHaveFractionalCoordinates) {
            this.fractionalizeCoordinates(true);
        }
        this.applySymTrajASCR();
        if (doCheckBonding && (this.bondTypes.size() > 0 || this.isMolecular)) {
            this.setBondingAndMolecules();
        }
        this.asc.setCurrentModelInfo("fileHasUnitCell", Boolean.TRUE);
        this.asc.xtalSymmetry = null;
    }

    @Override
    protected void finalizeSubclassSymmetry(boolean haveSymmetry) throws Exception {
        SymmetryInterface sym;
        SymmetryInterface symmetryInterface = sym = haveSymmetry ? this.asc.getXSymmetry().getBaseSymmetry() : null;
        if (sym != null && sym.getSpaceGroup() == null) {
            if (!this.isBinary) {
                this.appendLoadNote("Invalid or missing space group operations!");
            }
            sym = null;
        }
        if (this.modDim > 0 && sym != null) {
            this.addLatticeVectors();
            this.asc.setTensors();
            this.getModulationReader().setModulation(true, sym);
            this.modr.finalizeModulation();
        }
        if (this.isMagCIF) {
            this.asc.setNoAutoBond();
            if (sym != null) {
                this.addJmolScript("vectors on;vectors 0.15;");
                int n = this.asc.getXSymmetry().setSpinVectors();
                this.appendLoadNote(n + " magnetic moments - use VECTORS ON/OFF or VECTOR MAX x.x or SELECT VXYZ>0");
            }
        }
        if (sym != null && this.auditBlockCode != null && this.auditBlockCode.contains("REFRNCE")) {
            if (this.htAudit == null) {
                this.htAudit = new Hashtable();
            }
            this.htAudit.put(this.auditBlockCode, sym);
        }
        if (this.subParser != null) {
            this.subParser.finalizeSymmetry(haveSymmetry);
        }
    }

    private void processDataParameter() {
        this.bondTypes.clear();
        this.cifParser.getTokenPeeked();
        String string = this.thisDataSetName = this.key.length() < 6 ? "" : this.key.substring(5);
        if (this.thisDataSetName.length() > 0) {
            this.nextAtomSet();
        }
        if (this.debugging) {
            Logger.debug(this.key);
        }
    }

    protected void nextAtomSet() {
        this.asc.setCurrentModelInfo("isCIF", Boolean.TRUE);
        if (this.asc.iSet >= 0) {
            if (this.isMMCIF) {
                this.setModelPDB(true);
                if (this.pdbID != null) {
                    this.asc.setCurrentModelInfo("pdbID", this.pdbID);
                }
            }
            this.asc.newAtomSet();
            if (this.isMMCIF) {
                this.setModelPDB(true);
                if (this.pdbID != null) {
                    this.asc.setCurrentModelInfo("pdbID", this.pdbID);
                }
            }
        } else {
            this.asc.setCollectionName(this.thisDataSetName);
        }
    }

    private String processChemicalInfo(String type) throws Exception {
        if (type.equals("name")) {
            this.chemicalName = this.data = this.cifParser.fullTrim(this.data);
            this.appendLoadNote(this.chemicalName);
            if (!this.data.equals("?")) {
                this.asc.setInfo("modelLoadNote", this.data);
            }
        } else if (type.equals("structuralFormula")) {
            this.thisStructuralFormula = this.data = this.cifParser.fullTrim(this.data);
        } else if (type.equals("formula")) {
            this.thisFormula = this.data = this.cifParser.fullTrim(this.data);
            if (this.thisFormula.length() > 1) {
                this.appendLoadNote(this.thisFormula);
            }
        }
        if (this.debugging) {
            Logger.debug(type + " = " + this.data);
        }
        return this.data;
    }

    private void processSymmetrySpaceGroupName() throws Exception {
        if (this.key.indexOf("_ssg_name") >= 0) {
            this.modulated = true;
            this.latticeType = this.data.substring(0, 1);
        } else if (this.modulated) {
            return;
        }
        this.data = this.cifParser.toUnicode(this.data);
        this.lastSpaceGroupName = (this.key.indexOf("h-m") > 0 ? "HM:" : (this.modulated ? "SSG:" : (this.key.indexOf("bns") >= 0 ? "BNS:" : (this.key.indexOf("hall") >= 0 ? "Hall:" : "")))) + this.data;
        this.setSpaceGroupName(this.lastSpaceGroupName);
    }

    private void addLatticeVectors() {
        int i2;
        this.lattvecs = null;
        if (this.magCenterings != null) {
            this.latticeType = "Magnetic";
            this.lattvecs = new Lst();
            for (i2 = 0; i2 < this.magCenterings.size(); ++i2) {
                String s = (String)this.magCenterings.get(i2);
                float[] f = new float[this.modDim + 4];
                if (s.indexOf("x1") >= 0) {
                    for (int j = 1; j <= this.modDim + 3; ++j) {
                        s = PT.rep(s, "x" + j, "");
                    }
                }
                String[] tokens = PT.split(PT.replaceAllCharacters(s, "xyz+", ""), ",");
                int n = 0;
                for (int j = 0; j < tokens.length; ++j) {
                    s = tokens[j].trim();
                    if (s.length() == 0 || (f[j] = PT.parseFloatFraction(s)) == 0.0f) continue;
                    ++n;
                }
                if (n < 2) continue;
                this.lattvecs.addLast(f);
            }
            this.magCenterings = null;
        } else if (this.latticeType != null && "ABCFI".indexOf(this.latticeType) >= 0) {
            this.lattvecs = new Lst();
            try {
                this.ms.addLatticeVector(this.lattvecs, this.latticeType);
            }
            catch (Exception i2) {
                // empty catch block
            }
        }
        if (this.lattvecs != null && this.lattvecs.size() > 0 && this.asc.getSymmetry().addLatticeVectors(this.lattvecs)) {
            this.appendLoadNote("Note! " + this.lattvecs.size() + " symmetry operators added for lattice centering " + this.latticeType);
            for (i2 = 0; i2 < this.lattvecs.size(); ++i2) {
                this.appendLoadNote(PT.toJSON(null, this.lattvecs.get(i2)));
            }
        }
        this.latticeType = null;
    }

    private void processCellParameter() throws Exception {
        int i = 6;
        while (--i >= 0) {
            if (!this.key.equals(JmolAdapter.cellParamNames[i])) continue;
            float p = this.parseFloatStr(this.data);
            if (this.rotateHexCell && i == 5 && p == 120.0f) {
                p = -1.0f;
            }
            this.setUnitCellItem(i, p);
            return;
        }
    }

    private void processUnitCellTransformMatrix() throws Exception {
        float v = this.parseFloatStr(this.data);
        if (Float.isNaN(v)) {
            return;
        }
        for (int i = 0; i < TransformFields.length; ++i) {
            if (this.key.indexOf(TransformFields[i]) < 0) continue;
            this.setUnitCellItem(6 + i, v);
            return;
        }
    }

    private boolean getData() throws Exception {
        this.key = (String)this.cifParser.getTokenPeeked();
        if (!this.continueWith(this.key)) {
            return false;
        }
        this.data = this.skipKey(this.key) ? this.cifParser.skipNextToken() : this.cifParser.getNextToken();
        if (this.debugging && this.data != null && this.data.length() > 0 && this.data.charAt(0) != '\u0000') {
            Logger.debug(">> " + this.key + " " + this.data);
        }
        if (this.data == null) {
            Logger.warn("CIF ERROR ? end of file; data missing: " + this.key);
            return false;
        }
        return this.data.length() == 0 || this.data.charAt(0) != '\u0000';
    }

    protected void processLoopBlock() throws Exception {
        if (this.isLoop) {
            this.cifParser.getTokenPeeked();
            this.key = (String)this.cifParser.peekToken();
            if (this.key == null) {
                return;
            }
            this.key0 = this.key;
            this.key = this.cifParser.fixKey(this.key0);
        }
        if (this.modDim > 0) {
            switch (this.getModulationReader().processLoopBlock()) {
                case 0: {
                    break;
                }
                case -1: {
                    this.cifParser.skipLoop(false);
                }
                case 1: {
                    return;
                }
            }
        }
        boolean isLigand = false;
        if (this.key.startsWith(FAMILY_ATOM) || (isLigand = this.key.startsWith("_chem_comp_atom_"))) {
            if (!this.processAtomSiteLoopBlock(isLigand)) {
                return;
            }
            if (this.thisDataSetName.equals("global")) {
                this.thisDataSetName = this.chemicalName;
                this.asc.setCollectionName(this.thisDataSetName);
            }
            if (!this.thisDataSetName.equals(this.lastDataSetName)) {
                this.asc.setAtomSetName(this.thisDataSetName);
                this.lastDataSetName = this.thisDataSetName;
            }
            this.asc.setCurrentModelInfo("chemicalName", this.chemicalName);
            this.asc.setCurrentModelInfo("structuralFormula", this.thisStructuralFormula);
            this.asc.setCurrentModelInfo("formula", this.thisFormula);
            return;
        }
        if (this.key.startsWith(FAMILY_SGOP) || this.key.startsWith("_symmetry_equiv_pos") || this.key.startsWith("_symmetry_ssg_equiv")) {
            if (this.ignoreFileSymmetryOperators) {
                Logger.warn("ignoring file-based symmetry operators");
                this.cifParser.skipLoop(false);
            } else {
                this.processSymmetryOperationsLoopBlock();
            }
            return;
        }
        if (this.key.startsWith("_citation")) {
            this.processCitationListBlock();
            return;
        }
        if (this.key.startsWith("_atom_type")) {
            this.processAtomTypeLoopBlock();
            return;
        }
        if ((this.isMolecular || !this.doApplySymmetry) && this.key.startsWith("_geom_bond")) {
            this.processGeomBondLoopBlock();
            return;
        }
        if (this.processSubclassLoopBlock()) {
            return;
        }
        if (this.key.equals("_propagation_vector_seq_id")) {
            this.addMore();
            return;
        }
        this.cifParser.skipLoop(false);
    }

    protected boolean processSubclassLoopBlock() throws Exception {
        if (this.key.startsWith("_topol_")) {
            return this.getTopologyParser().processBlock(this.key);
        }
        return false;
    }

    private Parser getTopologyParser() {
        if (this.subParser == null) {
            this.subParser = (Parser)Interface.getInterface("org.jmol.adapter.readers.cif.TopoCifParser");
            this.subParser = this.subParser.setReader(this);
        }
        return this.subParser;
    }

    private void addMore() {
        int n = 0;
        try {
            String str;
            while ((str = (String)this.cifParser.peekToken()) != null && str.charAt(0) == '_') {
                this.cifParser.getTokenPeeked();
                ++n;
            }
            int m = 0;
            String s = "";
            while ((str = (String)this.cifParser.getNextDataToken()) != null) {
                s = s + str + (m % n == 0 ? "=" : " ");
                if (++m % n != 0) continue;
                this.appendUunitCellInfo(s.trim());
                s = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int fieldProperty(int i) {
        return i >= 0 && (this.field = (String)this.cifParser.getColumnData(i)).length() > 0 && (this.firstChar = this.field.charAt(0)) != '\u0000' ? this.col2key[i] : -1;
    }

    void parseLoopParameters(String[] fields) throws Exception {
        this.cifParser.parseDataBlockParameters(fields, this.isLoop ? null : this.key0, this.data, this.key2col, this.col2key);
    }

    void parseLoopParametersFor(String key, String[] fields) throws Exception {
        if (fields[0].charAt(0) == '*') {
            int i = fields.length;
            while (--i >= 0) {
                if (fields[i].charAt(0) != '*') continue;
                fields[i] = key + fields[i].substring(1);
            }
        }
        this.parseLoopParameters(fields);
    }

    private void disableField(int fieldIndex) {
        int i = this.key2col[fieldIndex];
        if (i != -1) {
            this.col2key[i] = -1;
        }
    }

    private void processAtomTypeLoopBlock() throws Exception {
        this.parseLoopParameters(atomTypeFields);
        while (this.cifParser.getData()) {
            String sym = this.getField((byte)0);
            if (sym == null) continue;
            float oxno = this.parseFloatStr(this.getField((byte)1));
            float radius = this.parseFloatStr(this.getField((byte)2));
            if (Float.isNaN(oxno) && Float.isNaN(radius)) continue;
            if (this.htOxStates == null) {
                this.htOxStates = new Hashtable<String, float[]>();
            }
            this.htOxStates.put(sym, new float[]{oxno, radius});
        }
    }

    boolean processAtomSiteLoopBlock(boolean isLigand) throws Exception {
        this.isLigand = isLigand;
        int pdbModelNo = -1;
        boolean haveCoord = true;
        this.parseLoopParametersFor(FAMILY_ATOM, atomFields);
        if (this.key2col[55] != -1) {
            this.setFractionalCoordinates(false);
        } else if (this.key2col[6] != -1 || this.key2col[52] != -1) {
            this.setFractionalCoordinates(false);
            this.disableField(3);
            this.disableField(4);
            this.disableField(5);
            if (this.key2col[16] != -1 && !this.isMMCIF) {
                this.setIsPDB();
                this.isMMCIF = true;
            }
        } else if (this.key2col[3] != -1) {
            this.setFractionalCoordinates(true);
            this.disableField(6);
            this.disableField(7);
            this.disableField(8);
        } else if (this.key2col[20] != -1 || this.key2col[21] != -1 || this.key2col[63] != -1) {
            haveCoord = false;
        } else {
            this.cifParser.skipLoop(false);
            return false;
        }
        int modelField = this.key2col[17];
        int siteMult = 0;
        while (this.cifParser.getData()) {
            if (modelField >= 0) {
                if ((pdbModelNo = this.checkPDBModelField(modelField, pdbModelNo)) < 0) break;
                if (this.skipping) continue;
            }
            Atom atom = null;
            if (this.isMMCIF) {
                if (haveCoord) {
                    atom = new Atom();
                } else if (this.fieldProperty(this.key2col[20]) == -1 && this.fieldProperty(this.key2col[21]) == -1 && this.fieldProperty(this.key2col[63]) == -1 || (atom = this.asc.getAtomFromName(this.field)) == null) {
                    continue;
                }
            } else {
                int f = -1;
                f = this.fieldProperty(this.key2col[1]);
                if (f != -1 || (f = this.fieldProperty(this.key2col[49])) != -1 || (f = this.fieldProperty(this.key2col[73])) != -1 || (f = this.fieldProperty(this.key2col[20])) != -1 || (f = this.fieldProperty(this.key2col[21])) != -1 || (f = this.fieldProperty(this.key2col[63])) != -1) {
                    atom = this.asc.getAtomFromName(this.field);
                }
                if (atom == null) {
                    atom = new Atom();
                    if (f != -1) {
                        if (this.asc.iSet < 0) {
                            this.nextAtomSet();
                            this.asc.newAtomSet();
                        }
                        this.asc.atomSymbolicMap.put(this.field, atom);
                    }
                }
            }
            String componentId = null;
            String id = null;
            String authAtom = null;
            String authComp = null;
            String authSeq = null;
            String authAsym = null;
            boolean haveAuth = false;
            int seqID = 0;
            int n = this.cifParser.getColumnCount();
            block40: for (int i = 0; i < n; ++i) {
                int tok = this.fieldProperty(i);
                block0 : switch (tok) {
                    case -1: {
                        continue block40;
                    }
                    case 70: {
                        id = this.field;
                        continue block40;
                    }
                    case 0: 
                    case 50: {
                        String elementSymbol;
                        if (this.field.length() < 2) {
                            elementSymbol = this.field;
                        } else {
                            char ch1 = Character.toLowerCase(this.field.charAt(1));
                            if (Atom.isValidSym2(this.firstChar, ch1)) {
                                elementSymbol = "" + this.firstChar + ch1;
                            } else {
                                elementSymbol = "" + this.firstChar;
                                if (!this.haveHAtoms && this.firstChar == 'H') {
                                    this.haveHAtoms = true;
                                }
                            }
                        }
                        atom.elementSymbol = elementSymbol;
                        atom.typeSymbol = this.field;
                        continue block40;
                    }
                    case 1: 
                    case 49: 
                    case 73: {
                        atom.atomName = this.field;
                        continue block40;
                    }
                    case 2: {
                        haveAuth = true;
                        authAtom = this.field;
                        continue block40;
                    }
                    case 48: 
                    case 72: {
                        atom.group3 = this.field;
                        continue block40;
                    }
                    case 11: {
                        authComp = this.field;
                        haveAuth = true;
                        continue block40;
                    }
                    case 59: {
                        componentId = this.field;
                        continue block40;
                    }
                    case 12: {
                        authAsym = this.field;
                        haveAuth = true;
                        continue block40;
                    }
                    case 71: {
                        atom.sequenceNumber = seqID = this.parseIntStr(this.field);
                        continue block40;
                    }
                    case 13: {
                        haveAuth = true;
                        authSeq = this.field;
                        continue block40;
                    }
                    case 55: {
                        float x = this.parseFloatStr(this.field);
                        if (!this.readIdeal || Float.isNaN(x)) continue block40;
                        atom.x = x;
                        continue block40;
                    }
                    case 56: {
                        float y = this.parseFloatStr(this.field);
                        if (!this.readIdeal || Float.isNaN(y)) continue block40;
                        atom.y = y;
                        continue block40;
                    }
                    case 57: {
                        float z = this.parseFloatStr(this.field);
                        if (!this.readIdeal || Float.isNaN(z)) continue block40;
                        atom.z = z;
                        continue block40;
                    }
                    case 3: 
                    case 6: 
                    case 52: {
                        atom.x = this.parseFloatStr(this.field);
                        continue block40;
                    }
                    case 4: 
                    case 7: 
                    case 53: {
                        atom.y = this.parseFloatStr(this.field);
                        continue block40;
                    }
                    case 5: 
                    case 8: 
                    case 54: {
                        atom.z = this.parseFloatStr(this.field);
                        continue block40;
                    }
                    case 51: {
                        atom.formalCharge = this.parseIntStr(this.field);
                        continue block40;
                    }
                    case 9: {
                        float floatOccupancy = this.parseFloatStr(this.field);
                        if (Float.isNaN(floatOccupancy)) continue block40;
                        atom.foccupancy = floatOccupancy;
                        continue block40;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloatStr(this.field) * (this.isMMCIF ? 1.0f : 100.0f);
                        continue block40;
                    }
                    case 14: {
                        atom.insertionCode = this.firstChar;
                        continue block40;
                    }
                    case 15: 
                    case 60: {
                        atom.altLoc = this.firstChar;
                        continue block40;
                    }
                    case 58: {
                        this.disorderAssembly = this.field;
                        continue block40;
                    }
                    case 19: {
                        if (this.firstChar == '-' && this.field.length() > 1) {
                            atom.altLoc = this.field.charAt(1);
                            atom.ignoreSymmetry = true;
                            continue block40;
                        }
                        atom.altLoc = this.firstChar;
                        continue block40;
                    }
                    case 16: {
                        if (!"HETATM".equals(this.field)) continue block40;
                        atom.isHetero = true;
                        continue block40;
                    }
                    case 18: {
                        if (!"dum".equals(this.field)) continue block40;
                        atom.x = Float.NaN;
                        continue block40;
                    }
                    case 61: {
                        if (!this.modulated) continue block40;
                        siteMult = this.parseIntStr(this.field);
                        continue block40;
                    }
                    case 47: 
                    case 62: {
                        int j;
                        if (!this.field.equalsIgnoreCase("Uiso") || (j = this.key2col[34]) == -1) continue block40;
                        this.asc.setU(atom, 7, this.parseFloatStr((String)this.cifParser.getColumnData(j)));
                        continue block40;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        this.asc.setU(atom, (this.col2key[i] - 22) % 6, this.parseFloatStr(this.field));
                        continue block40;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        this.asc.setU(atom, 6, 4.0f);
                        this.asc.setU(atom, (this.col2key[i] - 35) % 6, this.parseFloatStr(this.field));
                        continue block40;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        this.asc.setU(atom, 6, 0.0f);
                        this.asc.setU(atom, (this.col2key[i] - 41) % 6, this.parseFloatStr(this.field));
                        continue block40;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: {
                        this.isMagCIF = true;
                        V3 pt = atom.vib;
                        if (pt == null) {
                            atom.vib = pt = new Vibration().setType(-2);
                        }
                        float v = this.parseFloatStr(this.field);
                        switch (tok) {
                            case 64: 
                            case 67: {
                                pt.x = v;
                                this.appendLoadNote("magnetic moment: " + this.line);
                                break block0;
                            }
                            case 65: 
                            case 68: {
                                pt.y = v;
                                break block0;
                            }
                            case 66: 
                            case 69: {
                                pt.z = v;
                            }
                        }
                    }
                }
            }
            if (!haveCoord) continue;
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            String strChain = componentId;
            if (haveAuth) {
                if (authAtom != null) {
                    atom.atomName = authAtom;
                }
                if (authComp != null) {
                    atom.group3 = authComp;
                }
                if (authSeq != null) {
                    atom.sequenceNumber = this.parseIntStr(authSeq);
                }
                if (authAsym != null && this.useAuthorChainID) {
                    strChain = authAsym;
                }
            }
            if (strChain != null) {
                this.setChainID(atom, strChain);
            }
            if (this.maxSerial != Integer.MIN_VALUE) {
                this.maxSerial = Math.max(this.maxSerial, atom.sequenceNumber);
            }
            if (!this.addCifAtom(atom, id, componentId, strChain)) continue;
            if (id != null && seqID > 0) {
                V3 pt = atom.vib;
                if (pt == null) {
                    pt = this.asc.addVibrationVector(atom.index, 0.0f, Float.NaN, 1.0947133E9f);
                }
                pt.x = seqID;
            }
            if (this.modDim <= 0 || siteMult == 0) continue;
            atom.vib = V3.new3(siteMult, 0.0f, Float.NaN);
        }
        this.asc.setCurrentModelInfo("isCIF", Boolean.TRUE);
        if (this.isMMCIF) {
            this.setModelPDB(true);
        }
        if (this.isMMCIF && this.skipping) {
            this.skipping = false;
        }
        return true;
    }

    protected boolean addCifAtom(Atom atom, String id, String componentId, String strChain) {
        if (atom.elementSymbol == null && atom.atomName != null) {
            atom.getElementSymbol();
        }
        if (!this.filterCIFAtom(atom, componentId)) {
            return false;
        }
        this.setAtomCoord(atom);
        if (this.isMMCIF && !this.processSubclassAtom(atom, componentId, strChain)) {
            return false;
        }
        if (this.asc.iSet < 0) {
            this.nextAtomSet();
        }
        this.asc.addAtomWithMappedName(atom);
        if (id != null) {
            this.asc.atomSymbolicMap.put(id, atom);
        }
        ++this.ac;
        return true;
    }

    protected int checkPDBModelField(int modelField, int currentModelNo) throws Exception {
        return 0;
    }

    protected boolean processSubclassAtom(Atom atom, String assemblyId, String strChain) {
        return true;
    }

    protected boolean filterCIFAtom(Atom atom, String componentId) {
        if (!this.filterAtom(atom, -1)) {
            return false;
        }
        if (this.filterAssembly && this.filterReject(this.filter, "$", componentId)) {
            return false;
        }
        if (this.configurationPtr > 0) {
            if (!this.disorderAssembly.equals(this.lastDisorderAssembly)) {
                this.lastDisorderAssembly = this.disorderAssembly;
                this.lastAltLoc = '\u0000';
                this.conformationIndex = this.configurationPtr;
            }
            if (atom.altLoc != '\u0000') {
                if (this.conformationIndex >= 0 && atom.altLoc != this.lastAltLoc) {
                    this.lastAltLoc = atom.altLoc;
                    --this.conformationIndex;
                }
                if (this.conformationIndex != 0) {
                    Logger.info("ignoring " + atom.atomName);
                    return false;
                }
            }
        }
        return true;
    }

    private void processCitationListBlock() throws Exception {
        this.parseLoopParameters(citationFields);
        while (this.cifParser.getData()) {
            String title = this.getField((byte)0);
            if (this.isNull(title)) continue;
            this.appendLoadNote("TITLE: " + this.cifParser.toUnicode(title));
        }
    }

    private void processSymmetryOperationsLoopBlock() throws Exception {
        this.parseLoopParametersFor(FAMILY_SGOP, symmetryOperationsFields);
        this.symops = new Lst();
        int n = symmetryOperationsFields.length;
        while (--n >= 0 && this.key2col[n] == -1) {
        }
        if (n < 0) {
            Logger.warn("required _space_group_symop key not found");
            this.cifParser.skipLoop(false);
            return;
        }
        n = 0;
        boolean isMag = false;
        while (this.cifParser.getData()) {
            boolean ssgop = false;
            int nn = this.cifParser.getColumnCount();
            int timeRev = this.fieldProperty(this.key2col[7]) == -1 && this.fieldProperty(this.key2col[8]) == -1 && this.fieldProperty(this.key2col[6]) == -1 ? 0 : (this.field.equals("-1") ? -1 : 1);
            block8: for (int i = 0; i < nn; ++i) {
                int tok = this.fieldProperty(i);
                switch (tok) {
                    case 5: {
                        if (this.field.indexOf(126) >= 0) {
                            this.field = PT.rep(this.field, "~", "");
                        }
                    }
                    case 2: 
                    case 3: {
                        this.modulated = true;
                        ssgop = true;
                    }
                    case 0: 
                    case 1: 
                    case 4: {
                        if (!this.allowRotations && timeRev == 0 && ++n != 1 || this.modulated && !ssgop) continue block8;
                        if (tok == 1 || tok == 3) {
                            isMag = true;
                            int n2 = this.field.endsWith(",+1") || this.field.endsWith(",1") ? 1 : (timeRev = this.field.endsWith(",-1") ? -1 : 0);
                            if (timeRev != 0) {
                                this.field = this.field.substring(0, this.field.lastIndexOf(44));
                            }
                        }
                        if (timeRev != 0) {
                            this.field = this.field + "," + (timeRev == 1 ? "m" : "-m");
                        }
                        this.field = this.field.replace(';', ' ');
                        this.symops.addLast(this.field);
                        this.setSymmetryOperator(this.field);
                        if (!this.modulated || this.modDim != 0) continue block8;
                        this.modDim = this.getModulationReader().modDim;
                        continue block8;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        isMag = true;
                        if (this.magCenterings == null) {
                            this.magCenterings = new Lst();
                        }
                        this.magCenterings.addLast(this.field);
                    }
                }
            }
        }
        if (this.ms != null && !isMag) {
            this.addLatticeVectors();
        }
    }

    public int getBondOrder(String field) {
        switch (field.toUpperCase().charAt(0)) {
            default: {
                Logger.warn("unknown CIF bond order: " + field);
            }
            case '\u0000': 
            case 'S': {
                return 1;
            }
            case 'D': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'Q': {
                return 4;
            }
            case 'A': 
        }
        this.haveAromatic = true;
        return 515;
    }

    private void processGeomBondLoopBlock() throws Exception {
        boolean bondLoopBug = this.stateScriptVersionInt >= 130304 && this.stateScriptVersionInt < 140403;
        this.parseLoopParameters(geomBondFields);
        if (bondLoopBug || !this.checkAllFieldsPresent(geomBondFields, 2, true)) {
            this.cifParser.skipLoop(false);
            return;
        }
        int bondCount = 0;
        while (this.cifParser.getData()) {
            String name1 = this.getField((byte)0);
            String name2 = this.getField((byte)1);
            int order = this.getBondOrder(this.getField((byte)3));
            String sdist = this.getField((byte)2);
            float distance = this.parseFloatStr(sdist);
            if (distance == 0.0f || Float.isNaN(distance)) {
                if (this.iHaveFractionalCoordinates) continue;
                Atom a = this.getAtomFromNameCheckCase(name1);
                Atom b = this.getAtomFromNameCheckCase(name2);
                if (a == null || b == null) {
                    System.err.println("ATOM_SITE atom for name " + (a != null ? name2 : (b != null ? name1 : name1 + " and " + name2)) + " not found");
                    continue;
                }
                this.asc.addNewBondWithOrder(a.index, b.index, order);
                continue;
            }
            float dx = 0.0f;
            int pt = sdist.indexOf(40);
            if (pt >= 0) {
                char[] data = sdist.toCharArray();
                String sdx = sdist.substring(pt + 1, sdist.length() - 1);
                int n = sdx.length();
                int j = pt;
                while (--j >= 0 && (data[j] != '.' || --j >= 0)) {
                    data[j] = --n < 0 ? 48 : (int)sdx.charAt(n);
                }
                dx = this.parseFloatStr(String.valueOf(data));
                if (Float.isNaN(dx)) {
                    Logger.info("error reading uncertainty for " + this.line);
                    dx = 0.015f;
                }
            } else {
                dx = 0.015f;
            }
            ++bondCount;
            this.bondTypes.addLast(new Object[]{name1, name2, Float.valueOf(distance), Float.valueOf(dx), order});
        }
        if (bondCount > 0) {
            Logger.info(bondCount + " bonds read");
            if (!this.doApplySymmetry) {
                this.isMolecular = true;
                this.forceSymmetry(false);
            }
        }
    }

    private Atom getAtomFromNameCheckCase(String name) {
        Atom a = this.asc.getAtomFromName(name);
        if (a == null) {
            if (!this.asc.atomMapAnyCase) {
                this.asc.setAtomMapAnyCase();
            }
            a = this.asc.getAtomFromName(name.toUpperCase());
        }
        return a;
    }

    private void setBondingAndMolecules() {
        int i;
        this.atoms = this.asc.atoms;
        this.firstAtom = this.asc.getLastAtomSetAtomIndex();
        int nat = this.asc.getLastAtomSetAtomCount();
        this.ac = this.firstAtom + nat;
        Logger.info("CIF creating molecule for " + nat + " atoms " + (this.bondTypes.size() > 0 ? " using GEOM_BOND records" : ""));
        this.bsSets = new BS[nat];
        this.symmetry = this.asc.getSymmetry();
        for (i = this.firstAtom; i < this.ac; ++i) {
            int ipt = this.asc.getAtomFromName((String)this.atoms[i].atomName).index - this.firstAtom;
            if (ipt < 0) continue;
            if (this.bsSets[ipt] == null) {
                this.bsSets[ipt] = new BS();
            }
            this.bsSets[ipt].set(i - this.firstAtom);
        }
        if (this.isMolecular) {
            this.atomRadius = new float[this.ac];
            for (i = this.firstAtom; i < this.ac; ++i) {
                int charge;
                int elemnoWithIsotope = JmolAdapter.getElementNumber(this.atoms[i].getElementSymbol());
                this.atoms[i].elementNumber = (short)elemnoWithIsotope;
                int n = charge = this.atoms[i].formalCharge == Integer.MIN_VALUE ? 0 : this.atoms[i].formalCharge;
                if (elemnoWithIsotope <= 0) continue;
                this.atomRadius[i] = JmolAdapter.getBondingRadius(elemnoWithIsotope, charge);
            }
            this.bsConnected = new BS[this.ac];
            for (i = this.firstAtom; i < this.ac; ++i) {
                this.bsConnected[i] = new BS();
            }
            this.bsMolecule = new BS();
            this.bsExclude = new BS();
        }
        boolean isFirst = true;
        this.bsBondDuplicates = new BS();
        while (this.createBonds(isFirst)) {
            isFirst = false;
        }
        if (this.isMolecular && this.iHaveFractionalCoordinates && !this.bsMolecule.isEmpty()) {
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = new BS();
            }
            this.asc.bsAtoms.clearBits(this.firstAtom, this.ac);
            this.asc.bsAtoms.or(this.bsMolecule);
            this.asc.bsAtoms.andNot(this.bsExclude);
            for (int i2 = this.firstAtom; i2 < this.ac; ++i2) {
                if (this.asc.bsAtoms.get(i2)) {
                    this.symmetry.toCartesian(this.atoms[i2], true);
                    continue;
                }
                if (!this.debugging) continue;
                Logger.debug(this.molecularType + " removing " + i2 + " " + this.atoms[i2].atomName + " " + this.atoms[i2]);
            }
            this.asc.setCurrentModelInfo("unitCellParams", null);
            if (this.nMolecular++ == this.asc.iSet) {
                this.asc.clearGlobalBoolean(0);
                this.asc.clearGlobalBoolean(1);
                this.asc.clearGlobalBoolean(2);
            }
        }
        if (this.bondTypes.size() > 0) {
            this.asc.setCurrentModelInfo("hasBonds", Boolean.TRUE);
        }
        this.bondTypes.clear();
        this.atomRadius = null;
        this.bsSets = null;
        this.bsConnected = null;
        this.bsMolecule = null;
        this.bsExclude = null;
    }

    private void fixAtomForBonding(P3 pt, int i) {
        pt.setT(this.atoms[i]);
        if (this.iHaveFractionalCoordinates) {
            this.symmetry.toCartesian(pt, true);
        }
    }

    private boolean createBonds(boolean doInit) {
        String list = "";
        boolean haveH = false;
        int i = this.bondTypes.size();
        while (--i >= 0) {
            if (this.bsBondDuplicates.get(i)) continue;
            Object[] o = (Object[])this.bondTypes.get(i);
            float distance = ((Float)o[2]).floatValue();
            float dx = ((Float)o[3]).floatValue();
            int order = (Integer)o[4];
            Atom a1 = this.getAtomFromNameCheckCase((String)o[0]);
            Atom a2 = this.getAtomFromNameCheckCase((String)o[1]);
            if (a1 == null || a2 == null) {
                a2 = this.getAtomFromNameCheckCase((String)o[1]);
                continue;
            }
            int iatom1 = a1.index;
            int iatom2 = a2.index;
            if (doInit) {
                String key = ";" + iatom1 + ";" + iatom2 + ";" + distance;
                if (list.indexOf(key) >= 0) {
                    this.bsBondDuplicates.set(i);
                    continue;
                }
                list = list + key;
            }
            BS bs1 = this.bsSets[iatom1 - this.firstAtom];
            BS bs2 = this.bsSets[iatom2 - this.firstAtom];
            if (bs1 == null || bs2 == null) continue;
            if (this.atoms[iatom1].elementNumber == 1 || this.atoms[iatom2].elementNumber == 1) {
                haveH = true;
            }
            int j = bs1.nextSetBit(0);
            while (j >= 0) {
                int k = bs2.nextSetBit(0);
                while (k >= 0) {
                    if (!(this.isMolecular && this.bsConnected[j + this.firstAtom].get(k) || !this.checkBondDistance(this.atoms[j + this.firstAtom], this.atoms[k + this.firstAtom], distance, dx))) {
                        this.addNewBond(j + this.firstAtom, k + this.firstAtom, order);
                    }
                    k = bs2.nextSetBit(k + 1);
                }
                j = bs1.nextSetBit(j + 1);
            }
        }
        if (!this.iHaveFractionalCoordinates) {
            return false;
        }
        if (this.bondTypes.size() > 0 && !haveH) {
            for (i = this.firstAtom; i < this.ac; ++i) {
                if (this.atoms[i].elementNumber != 1) continue;
                boolean checkAltLoc = this.atoms[i].altLoc != '\u0000';
                for (int k = this.firstAtom; k < this.ac; ++k) {
                    if (k == i || this.atoms[k].elementNumber == 1 || checkAltLoc && this.atoms[k].altLoc != '\u0000' && this.atoms[k].altLoc != this.atoms[i].altLoc || this.bsConnected[i].get(k) || !this.checkBondDistance(this.atoms[i], this.atoms[k], 1.1f, 0.0f)) continue;
                    this.addNewBond(i, k, 1);
                }
            }
        }
        if (!this.isMolecular) {
            return false;
        }
        if (doInit) {
            for (i = this.firstAtom; i < this.ac; ++i) {
                if (this.atoms[i].atomSite + this.firstAtom != i || this.bsMolecule.get(i)) continue;
                this.setBs(this.atoms, i, this.bsConnected, this.bsMolecule);
            }
        }
        float bondTolerance = this.vwr.getFloat(0x22000004);
        BS bsBranch = new BS();
        P3 cart1 = new P3();
        P3 cart2 = new P3();
        int nFactor = 2;
        for (int i2 = this.firstAtom; i2 < this.ac; ++i2) {
            if (this.bsMolecule.get(i2) || this.bsExclude.get(i2)) continue;
            int j = this.bsMolecule.nextSetBit(0);
            while (j >= 0) {
                if (this.symmetry.checkDistance(this.atoms[j], this.atoms[i2], this.atomRadius[i2] + this.atomRadius[j] + bondTolerance, 0.0f, nFactor, nFactor, nFactor, this.ptOffset)) {
                    this.setBs(this.atoms, i2, this.bsConnected, bsBranch);
                    int k = bsBranch.nextSetBit(0);
                    while (k >= 0) {
                        this.atoms[k].add(this.ptOffset);
                        this.fixAtomForBonding(cart1, k);
                        BS bs = this.bsSets[this.asc.getAtomIndex(this.atoms[k].atomName) - this.firstAtom];
                        if (bs != null) {
                            int ii = bs.nextSetBit(0);
                            while (ii >= 0) {
                                if (ii + this.firstAtom != k) {
                                    this.fixAtomForBonding(cart2, ii + this.firstAtom);
                                    if (cart2.distance(cart1) < 0.1f) {
                                        this.bsExclude.set(k);
                                        break;
                                    }
                                }
                                ii = bs.nextSetBit(ii + 1);
                            }
                        }
                        this.bsMolecule.set(k);
                        k = bsBranch.nextSetBit(k + 1);
                    }
                    return true;
                }
                j = this.bsMolecule.nextSetBit(j + 1);
            }
        }
        return false;
    }

    private boolean checkBondDistance(Atom a, Atom b, float distance, float dx) {
        if (this.iHaveFractionalCoordinates) {
            return this.symmetry.checkDistance(a, b, distance, dx, 0, 0, 0, this.ptOffset);
        }
        float d = a.distance(b);
        return dx > 0.0f ? Math.abs(d - distance) <= dx : d <= distance && d > 0.1f;
    }

    private void addNewBond(int i, int j, int order) {
        this.asc.addNewBondWithOrder(i, j, order);
        if (!this.isMolecular) {
            return;
        }
        this.bsConnected[i].set(j);
        this.bsConnected[j].set(i);
    }

    private void setBs(Atom[] atoms, int iatom, BS[] bsBonds, BS bs) {
        BS bsBond = bsBonds[iatom];
        bs.set(iatom);
        int i = bsBond.nextSetBit(0);
        while (i >= 0) {
            if (!bs.get(i)) {
                this.setBs(atoms, i, bsBonds, bs);
            }
            i = bsBond.nextSetBit(i + 1);
        }
    }

    protected boolean checkSubclassSymmetry() {
        return this.doCheckUnitCell;
    }

    protected boolean checkAllFieldsPresent(String[] keys, int lastKey, boolean critical) {
        int i;
        int n = i = lastKey < 0 ? keys.length : lastKey;
        while (--i >= 0) {
            if (this.key2col[i] != -1) continue;
            if (critical) {
                Logger.warn("CIF reader missing property: " + keys[i]);
            }
            return false;
        }
        return true;
    }

    protected String getField(byte type) {
        int i = this.key2col[type];
        return i == -1 ? "\u0000" : (String)this.cifParser.getColumnData(i);
    }

    protected boolean isNull(String key) {
        return key.equals("\u0000");
    }

    static interface Parser {
        public Parser setReader(CifReader var1);

        public boolean processBlock(String var1) throws Exception;

        public boolean finalizeReader() throws Exception;

        public void finalizeSymmetry(boolean var1) throws Exception;

        public void ProcessRecord(String var1, String var2) throws Exception;
    }
}

