/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine;

import org.apache.commons.jcs3.engine.CacheEventQueue;
import org.apache.commons.jcs3.engine.PooledCacheEventQueue;
import org.apache.commons.jcs3.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs3.engine.behavior.ICacheListener;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class CacheEventQueueFactory<K, V> {
    private static final Log log = LogManager.getLog(CacheEventQueueFactory.class);

    public ICacheEventQueue<K, V> createCacheEventQueue(ICacheListener<K, V> listener, long listenerId, String cacheName, String threadPoolName, ICacheEventQueue.QueueType poolType) {
        return this.createCacheEventQueue(listener, listenerId, cacheName, 10, 500, threadPoolName, poolType);
    }

    public ICacheEventQueue<K, V> createCacheEventQueue(ICacheListener<K, V> listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry, String threadPoolName, ICacheEventQueue.QueueType poolType) {
        log.debug("threadPoolName = [{0}] poolType = {1}", new Object[]{threadPoolName, poolType});
        PooledCacheEventQueue eventQueue = null;
        if (poolType == null || ICacheEventQueue.QueueType.SINGLE == poolType) {
            eventQueue = new CacheEventQueue<K, V>(listener, listenerId, cacheName, maxFailure, waitBeforeRetry);
        } else if (ICacheEventQueue.QueueType.POOLED == poolType) {
            eventQueue = new PooledCacheEventQueue<K, V>(listener, listenerId, cacheName, maxFailure, waitBeforeRetry, threadPoolName);
        }
        return eventQueue;
    }
}

