/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.spi.preferences.ListListSetting;
import org.openstreetmap.josm.spi.preferences.ListSetting;
import org.openstreetmap.josm.spi.preferences.MapListSetting;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.spi.preferences.StringSetting;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class PreferencesUtils {
    private static volatile StringBuilder summary = new StringBuilder();

    private PreferencesUtils() {
    }

    public static void log(String fmt, Object ... vars) {
        summary.append(String.format(fmt, vars));
    }

    public static void log(String s) {
        summary.append(s).append('\n');
    }

    public static void log(Exception e, String s) {
        summary.append(s).append(' ').append(Logging.getErrorMessage(e)).append('\n');
    }

    public static String getLog() {
        return summary.toString();
    }

    public static void resetLog() {
        summary = new StringBuilder();
    }

    public static void replacePreferences(Preferences fragment, Preferences mainpref) {
        for (Map.Entry<String, Setting<?>> entry : fragment.settingsMap.entrySet()) {
            mainpref.putSetting(entry.getKey(), entry.getValue());
        }
    }

    public static void appendPreferences(Preferences fragment, Preferences mainpref) {
        for (Map.Entry<String, Setting<?>> entry : fragment.settingsMap.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() instanceof StringSetting) {
                mainpref.putSetting(key, entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof ListSetting) {
                ListSetting lSetting = (ListSetting)entry.getValue();
                List<String> newItems = PreferencesUtils.getList(mainpref, key, true);
                if (newItems == null) continue;
                for (String item : (List)lSetting.getValue()) {
                    if (newItems.contains(item)) continue;
                    newItems.add(item);
                }
                mainpref.putList(key, newItems);
                continue;
            }
            if (entry.getValue() instanceof ListListSetting) {
                ListListSetting llSetting = (ListListSetting)entry.getValue();
                List<List<String>> newLists = PreferencesUtils.getListOfLists(mainpref, key, true);
                if (newLists == null) continue;
                for (List list : (List)llSetting.getValue()) {
                    if (newLists.contains(list)) continue;
                    newLists.add(list);
                }
                mainpref.putListOfLists(key, newLists);
                continue;
            }
            if (!(entry.getValue() instanceof MapListSetting)) continue;
            MapListSetting mlSetting = (MapListSetting)entry.getValue();
            List<Map<String, String>> newMaps = PreferencesUtils.getListOfStructs(mainpref, key, true);
            if (newMaps == null) continue;
            for (Map map : (List)mlSetting.getValue()) {
                if (newMaps.contains(map)) continue;
                newMaps.add(map);
            }
            mainpref.putListOfMaps(entry.getKey(), newMaps);
        }
    }

    public static void deletePreferenceValues(Preferences fragment, Preferences mainpref) {
        for (Map.Entry<String, Setting<?>> entry : fragment.settingsMap.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() instanceof StringSetting) {
                StringSetting sSetting = (StringSetting)entry.getValue();
                if (!sSetting.equals(mainpref.settingsMap.get(key))) continue;
                mainpref.put(key, null);
                continue;
            }
            if (entry.getValue() instanceof ListSetting) {
                ListSetting lSetting = (ListSetting)entry.getValue();
                List<String> newItems = PreferencesUtils.getList(mainpref, key, true);
                if (newItems == null) continue;
                for (String item : (List)lSetting.getValue()) {
                    PreferencesUtils.log("Deleting preferences: from list %s: %s\n", key, item);
                    newItems.remove(item);
                }
                mainpref.putList(entry.getKey(), newItems);
                continue;
            }
            if (entry.getValue() instanceof ListListSetting) {
                ListListSetting llSetting = (ListListSetting)entry.getValue();
                List<List<String>> newLists = PreferencesUtils.getListOfLists(mainpref, key, true);
                if (newLists == null) continue;
                Iterator<List<String>> listIterator = newLists.iterator();
                while (listIterator.hasNext()) {
                    Collection list = listIterator.next();
                    for (Collection removeList : (List)llSetting.getValue()) {
                        if (!list.containsAll(removeList)) continue;
                        PreferencesUtils.log("Deleting preferences: list from lists %s: %s\n", key, list);
                        listIterator.remove();
                    }
                }
                mainpref.putListOfLists(key, newLists);
                continue;
            }
            if (!(entry.getValue() instanceof MapListSetting)) continue;
            MapListSetting mlSetting = (MapListSetting)entry.getValue();
            List<Map<String, String>> newMaps = PreferencesUtils.getListOfStructs(mainpref, key, true);
            if (newMaps == null) continue;
            Iterator<Map<String, String>> mapIterator = newMaps.iterator();
            while (mapIterator.hasNext()) {
                Map<String, String> map = mapIterator.next();
                for (Map removeMap : (List)mlSetting.getValue()) {
                    if (!map.entrySet().containsAll(removeMap.entrySet())) continue;
                    PreferencesUtils.log("Deleting preferences: deleting map from maps %s: %s\n", key, map);
                    mapIterator.remove();
                }
            }
            mainpref.putListOfMaps(entry.getKey(), newMaps);
        }
    }

    public static void deletePreferenceKeyByPattern(String pattern, Preferences pref) {
        Map<String, Setting<?>> allSettings = pref.getAllSettings();
        for (Map.Entry<String, Setting<?>> entry : allSettings.entrySet()) {
            String key = entry.getKey();
            if (!key.matches(pattern)) continue;
            PreferencesUtils.log("Deleting preferences: deleting key from preferences: " + key);
            pref.putSetting(key, null);
        }
    }

    public static void deletePreferenceKey(String key, Preferences pref) {
        Map<String, Setting<?>> allSettings = pref.getAllSettings();
        if (allSettings.containsKey(key)) {
            PreferencesUtils.log("Deleting preferences: deleting key from preferences: " + key);
            pref.putSetting(key, null);
        }
    }

    private static List<String> getList(Preferences mainpref, String key, boolean warnUnknownDefault) {
        ListSetting existing = Utils.cast(mainpref.settingsMap.get(key), ListSetting.class);
        ListSetting defaults = Utils.cast(mainpref.defaultsMap.get(key), ListSetting.class);
        if (existing == null && defaults == null) {
            if (warnUnknownDefault) {
                PreferencesUtils.defaultUnknownWarning(key);
            }
            return null;
        }
        if (existing != null) {
            return new ArrayList<String>((Collection)existing.getValue());
        }
        return defaults.getValue() == null ? null : new ArrayList((Collection)defaults.getValue());
    }

    private static List<List<String>> getListOfLists(Preferences mainpref, String key, boolean warnUnknownDefault) {
        ListListSetting existing = Utils.cast(mainpref.settingsMap.get(key), ListListSetting.class);
        ListListSetting defaults = Utils.cast(mainpref.defaultsMap.get(key), ListListSetting.class);
        if (existing == null && defaults == null) {
            if (warnUnknownDefault) {
                PreferencesUtils.defaultUnknownWarning(key);
            }
            return null;
        }
        if (existing != null) {
            return new ArrayList<List<String>>((Collection)existing.getValue());
        }
        return defaults.getValue() == null ? null : new ArrayList((Collection)defaults.getValue());
    }

    private static List<Map<String, String>> getListOfStructs(Preferences mainpref, String key, boolean warnUnknownDefault) {
        MapListSetting existing = Utils.cast(mainpref.settingsMap.get(key), MapListSetting.class);
        MapListSetting defaults = Utils.cast(mainpref.settingsMap.get(key), MapListSetting.class);
        if (existing == null && defaults == null) {
            if (warnUnknownDefault) {
                PreferencesUtils.defaultUnknownWarning(key);
            }
            return null;
        }
        if (existing != null) {
            return new ArrayList<Map<String, String>>((Collection)existing.getValue());
        }
        return defaults.getValue() == null ? null : new ArrayList((Collection)defaults.getValue());
    }

    private static void defaultUnknownWarning(String key) {
        PreferencesUtils.log("Warning: Unknown default value of %s , skipped\n", key);
        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("<html>Settings file asks to append preferences to <b>{0}</b>,<br/> but its default value is unknown at this moment.<br/> Please activate corresponding function manually and retry importing.", key), I18n.tr("Warning", new Object[0]), 2);
    }

    public static void showPrefs(Preferences tmpPref) {
        Logging.info("properties: " + tmpPref.settingsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBoolean(IPreferences prefs, String key, String specName, boolean def) {
        IPreferences iPreferences = prefs;
        synchronized (iPreferences) {
            boolean generic = prefs.getBoolean(key, def);
            String skey = key + '.' + specName;
            String svalue = prefs.get(skey, null);
            if (svalue != null) {
                return Boolean.parseBoolean(svalue);
            }
            return generic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInteger(IPreferences prefs, String key, String specName, int def) {
        IPreferences iPreferences = prefs;
        synchronized (iPreferences) {
            String v = prefs.get(key + '.' + specName);
            if (v.isEmpty()) {
                v = prefs.get(key, Integer.toString(def));
            }
            if (v.isEmpty()) {
                return def;
            }
            try {
                return Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                Logging.trace(e);
                return def;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromList(IPreferences prefs, String key, String value) {
        IPreferences iPreferences = prefs;
        synchronized (iPreferences) {
            ArrayList<String> a = new ArrayList<String>(prefs.getList(key, Collections.emptyList()));
            a.remove(value);
            prefs.putList(key, a);
        }
    }

    public static boolean putListBounded(IPreferences prefs, String key, int maxsize, List<String> val) {
        ArrayList<String> newCollection = new ArrayList<String>(Math.min(maxsize, val.size()));
        for (String i : val) {
            if (newCollection.size() >= maxsize) break;
            newCollection.add(i);
        }
        return prefs.putList(key, newCollection);
    }
}

