/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

abstract class UploadTextComponentValidator
extends AbstractTextComponentValidator {
    private final JLabel feedback;
    protected boolean uploadRejected;

    UploadTextComponentValidator(JTextComponent tc, JLabel feedback) {
        super(tc);
        this.feedback = feedback;
        this.feedback.setOpaque(true);
        this.validate();
    }

    @Override
    protected void feedbackValid(String msg) {
        msg = msg != null ? "<html>\u2714 " + msg : null;
        super.feedbackValid(msg);
        if (!Objects.equals(msg, this.feedback.getText())) {
            this.feedback.setText(msg);
            this.feedback.setForeground(VALID_COLOR);
            this.feedback.setBackground(null);
            this.feedback.setBorder(null);
        }
    }

    @Override
    protected void feedbackWarning(String msg) {
        msg = msg != null ? "<html>" + msg : null;
        super.feedbackWarning(msg);
        if (!Objects.equals(msg, this.feedback.getText())) {
            this.feedback.setText(msg);
            this.feedback.setForeground(null);
            this.feedback.setBackground(WARNING_BACKGROUND);
            this.feedback.setBorder(WARNING_BORDER);
        }
    }

    @Override
    public boolean isValid() {
        throw new UnsupportedOperationException();
    }

    public final boolean isUploadRejected() {
        return this.uploadRejected;
    }

    static class UploadAreaValidator
    extends UploadTextComponentValidator {
        private double area = Double.NaN;

        UploadAreaValidator(JTextComponent tc, JLabel feedback) {
            super(tc, feedback);
        }

        void computeArea(Collection<? extends IPrimitive> primitives) {
            this.area = primitives.stream().map(IPrimitive::getBBox).reduce(new BBox(), (b1, b2) -> {
                b1.add((BBox)b2);
                return b1;
            }).area();
            this.validate();
        }

        @Override
        public void validate() {
            if (Double.isFinite(this.area) && this.area <= Config.getPref().getDouble("upload.max-area", 3.0)) {
                this.feedbackValid(null);
            } else {
                this.feedbackWarning(I18n.tr("The bounding box of this changeset is very large \u2013 please consider splitting your changes!", new Object[0]));
            }
        }
    }

    static class UploadSourceValidator
    extends UploadTextComponentValidator {
        UploadSourceValidator(JTextComponent tc, JLabel feedback) {
            super(tc, feedback);
        }

        @Override
        public void validate() {
            if (!Config.getPref().getBoolean("message.upload_source_is_empty", true)) {
                this.feedbackDisabled();
                return;
            }
            String uploadSource = this.getComponent().getText();
            if (Utils.isStripEmpty(uploadSource)) {
                this.feedbackWarning(I18n.tr("You did not specify a source for your changes.<br />It is technically allowed, but this information helps<br />other users to understand the origins of the data.<br /><br />If you spend a minute now to explain your change, you will make life<br />easier for many other mappers.", new Object[0]).replace("<br />", " "));
            } else {
                String rejection = UploadDialog.UploadAction.validateUploadTag(uploadSource, "upload.source", Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
                boolean bl = this.uploadRejected = rejection != null;
                if (this.uploadRejected) {
                    this.feedbackWarning(I18n.tr("Your changeset source is <i>rejected</i>.", new Object[0]) + "<br />" + rejection);
                } else {
                    this.feedbackValid(I18n.tr("Thank you for providing the data source!", new Object[0]));
                }
            }
        }
    }

    static class UploadCommentValidator
    extends UploadTextComponentValidator {
        UploadCommentValidator(JTextComponent tc, JLabel feedback) {
            super(tc, feedback);
        }

        @Override
        public void validate() {
            if (!Config.getPref().getBoolean("message.upload_comment_is_empty_or_very_short", true)) {
                this.feedbackDisabled();
                return;
            }
            String uploadComment = this.getComponent().getText();
            if (UploadDialog.UploadAction.isUploadCommentTooShort(uploadComment)) {
                this.feedbackWarning(I18n.tr("Your upload comment is <i>empty</i>, or <i>very short</i>.<br /><br />This is technically allowed, but please consider that many users who are<br />watching changes in their area depend on meaningful changeset comments<br />to understand what is going on!<br /><br />If you spend a minute now to explain your change, you will make life<br />easier for many other mappers.", new Object[0]).replace("<br />", " "));
            } else {
                String rejection = UploadDialog.UploadAction.validateUploadTag(uploadComment, "upload.comment", Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
                boolean bl = this.uploadRejected = rejection != null;
                if (this.uploadRejected) {
                    this.feedbackWarning(I18n.tr("Your upload comment is <i>rejected</i>.", new Object[0]) + "<br />" + rejection);
                } else {
                    this.feedbackValid(I18n.tr("Thank you for providing a changeset comment! This gives other mappers a better understanding of your intent.", new Object[0]));
                }
            }
        }
    }
}

