/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ResourceHandle;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ZipHandlerBase
extends ArchiveHandler {
    @ApiStatus.Internal
    public static final boolean USE_CRC_INSTEAD_OF_TIMESTAMP = SystemProperties.is("zip.handler.uses.crc.instead.of.timestamp");

    public ZipHandlerBase(@NotNull String path2) {
        if (path2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(0);
        }
        super(path2);
    }

    @Override
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        ResourceHandle<ZipFile> existingZipRef = this.acquireZipHandle();
        Map<String, ArchiveHandler.EntryInfo> map = this.buildEntryMapForZipFile(existingZipRef.get());
        Map<String, ArchiveHandler.EntryInfo> map2 = map;
        if (map2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(1);
        }
        return map2;
        finally {
            if (existingZipRef != null) {
                existingZipRef.close();
            }
        }
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> buildEntryMapForZipFile(@NotNull ZipFile zip2) {
        if (zip2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(2);
        }
        ZipEntryMap map = new ZipEntryMap(zip2.size());
        map.put("", this.createRootEntry());
        Enumeration<? extends ZipEntry> entries = zip2.entries();
        while (entries.hasMoreElements()) {
            this.getOrCreate(entries.nextElement(), (Map<String, ArchiveHandler.EntryInfo>)map, zip2);
        }
        ZipEntryMap zipEntryMap = map;
        if (zipEntryMap == null) {
            ZipHandlerBase.$$$reportNull$$$0(3);
        }
        return zipEntryMap;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull ZipEntry entry, @NotNull Map<String, ArchiveHandler.EntryInfo> map, @NotNull ZipFile zip2) {
        ArchiveHandler.EntryInfo info;
        if (entry == null) {
            ZipHandlerBase.$$$reportNull$$$0(4);
        }
        if (map == null) {
            ZipHandlerBase.$$$reportNull$$$0(5);
        }
        if (zip2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(6);
        }
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar(entryName, '/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if (StringUtil.startsWithChar(entryName, '/') || StringUtil.startsWithChar(entryName, '\\')) {
            entryName = entryName.substring(1);
        }
        if ((info = map.get(entryName)) != null) {
            if (!isDirectory) {
                Logger.getInstance(ZipHandlerBase.class).info("Duplicated entry: " + this.getFile() + "!/" + entryName + ' ' + info.length + '/' + entry.getSize());
            }
            ArchiveHandler.EntryInfo entryInfo = info;
            if (entryInfo == null) {
                ZipHandlerBase.$$$reportNull$$$0(7);
            }
            return entryInfo;
        }
        Trinity<String, String, String> path2 = this.splitPathAndFix(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path2.first, map, zip2);
        if (".".equals(path2.second)) {
            ArchiveHandler.EntryInfo entryInfo = parentInfo;
            if (entryInfo == null) {
                ZipHandlerBase.$$$reportNull$$$0(8);
            }
            return entryInfo;
        }
        long fileStamp = USE_CRC_INSTEAD_OF_TIMESTAMP ? entry.getCrc() : this.getEntryFileStamp();
        ArchiveHandler.EntryInfo entryInfo = info = ZipHandlerBase.store(map, parentInfo, (CharSequence)path2.second, isDirectory, entry.getSize(), fileStamp, (String)path2.third);
        if (entryInfo == null) {
            ZipHandlerBase.$$$reportNull$$$0(9);
        }
        return entryInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ArchiveHandler.EntryInfo store(@NotNull Map<String, ArchiveHandler.EntryInfo> map, @Nullable ArchiveHandler.EntryInfo parentInfo, @NotNull CharSequence shortName, boolean isDirectory, long size, long time, @NotNull String string2) {
        void entryName;
        if (map == null) {
            ZipHandlerBase.$$$reportNull$$$0(10);
        }
        if (shortName == null) {
            ZipHandlerBase.$$$reportNull$$$0(11);
        }
        if (string2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(12);
        }
        CharSequence sequence2 = ByteArrayCharSequence.convertToBytesIfPossible(shortName);
        ArchiveHandler.EntryInfo info = new ArchiveHandler.EntryInfo(sequence2, isDirectory, size, time, parentInfo);
        map.put((String)entryName, info);
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            ZipHandlerBase.$$$reportNull$$$0(13);
        }
        return entryInfo;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull String entryName, @NotNull Map<String, ArchiveHandler.EntryInfo> map, @NotNull ZipFile zip2) {
        ArchiveHandler.EntryInfo info;
        if (entryName == null) {
            ZipHandlerBase.$$$reportNull$$$0(14);
        }
        if (map == null) {
            ZipHandlerBase.$$$reportNull$$$0(15);
        }
        if (zip2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(16);
        }
        if ((info = map.get(entryName)) == null) {
            ZipEntry entry = zip2.getEntry(entryName + "/");
            if (entry != null) {
                return this.getOrCreate(entry, map, zip2);
            }
            Trinity<String, String, String> path2 = this.splitPathAndFix(entryName);
            if (entryName.equals(path2.first)) {
                throw new IllegalArgumentException("invalid entry name: '" + entryName + "' in " + zip2.getName() + "; after split: " + path2);
            }
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path2.first, map, zip2);
            entryName = (String)path2.third;
            info = ZipHandlerBase.store(map, parentInfo, (CharSequence)path2.second, true, 0L, -1L, entryName);
        }
        if (!info.isDirectory) {
            Logger.getInstance(this.getClass()).info(zip2.getName() + ": " + entryName + " should be a directory");
            info = ZipHandlerBase.store(map, info.parent, info.shortName, true, info.length, info.timestamp, entryName);
        }
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            ZipHandlerBase.$$$reportNull$$$0(17);
        }
        return entryInfo;
    }

    public byte @NotNull [] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block15: {
            byte[] byArray;
            InputStream stream;
            ResourceHandle<ZipFile> zipRef;
            block16: {
                if (relativePath == null) {
                    ZipHandlerBase.$$$reportNull$$$0(19);
                }
                zipRef = this.acquireZipHandle();
                ZipFile zip2 = zipRef.get();
                ZipEntry entry = zip2.getEntry(relativePath);
                if (entry == null) break block15;
                long length = entry.getSize();
                if (FileUtilRt.isTooLarge(length)) {
                    throw new FileTooBigException(this.getFile() + "!/" + relativePath);
                }
                stream = zip2.getInputStream(entry);
                if (stream == null) break block15;
                byArray = FileUtil.loadBytes(stream, (int)length);
                if (byArray != null) break block16;
                ZipHandlerBase.$$$reportNull$$$0(20);
            }
            return byArray;
            {
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            finally {
                if (zipRef != null) {
                    zipRef.close();
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    protected abstract long getEntryFileStamp();

    @NotNull
    protected abstract ResourceHandle<ZipFile> acquireZipHandle() throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 22: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 2: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 5: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEntryMapForZipFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "store";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildEntryMapForZipFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getEntryCrc";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

