/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.annotations;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.deserialization.PlatformDependentDeclarationFilterKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.util.DeclarationUtilKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0018\u001a\f\u0010\u0019\u001a\u0004\u0018\u00010\u0017*\u00020\u0018\u001a\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0017*\u00020\u001bH\u0002\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u0017*\u00020\u0018\u001a\f\u0010\u001d\u001a\u0004\u0018\u00010\u0017*\u00020\u0018\u001a\n\u0010\u001e\u001a\u00020\u0012*\u00020\u0013\u001a\n\u0010\u001f\u001a\u00020\u0012*\u00020\u0018\u001a\n\u0010 \u001a\u00020\u0012*\u00020\u0018\u001a\n\u0010!\u001a\u00020\u0012*\u00020\u0018\u001a\n\u0010\"\u001a\u00020\u0012*\u00020\u0018\u001a\n\u0010#\u001a\u00020\u0012*\u00020\u0013\u001a\u0012\u0010$\u001a\u00020\u0012*\u00020\u00182\u0006\u0010%\u001a\u00020\u0015\u001a\u0012\u0010&\u001a\u00020\u0012*\u00020\u00132\u0006\u0010%\u001a\u00020\u0015\u001a\n\u0010'\u001a\u00020\u0012*\u00020(\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0003\"\u0010\u0010\f\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\r\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u000e\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u000f\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0010\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"JVM_DEFAULT_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_DEFAULT_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME", "getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME", "JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME", "getJVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME", "JVM_OVERLOADS_FQ_NAME", "getJVM_OVERLOADS_FQ_NAME", "JVM_RECORD_ANNOTATION_FQ_NAME", "getJVM_RECORD_ANNOTATION_FQ_NAME", "JVM_SYNTHETIC_ANNOTATION_FQ_NAME", "STRICTFP_ANNOTATION_FQ_NAME", "SYNCHRONIZED_ANNOTATION_FQ_NAME", "TRANSIENT_ANNOTATION_FQ_NAME", "VOLATILE_ANNOTATION_FQ_NAME", "checkIsImplementationCompiledToJvmDefault", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "findJvmFieldAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findJvmOverloadsAnnotation", "findJvmSyntheticAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "findStrictfpAnnotation", "findSynchronizedAnnotation", "hasJvmDefaultAnnotation", "hasJvmDefaultNoCompatibilityAnnotation", "hasJvmDefaultWithCompatibilityAnnotation", "hasJvmFieldAnnotation", "hasJvmSyntheticAnnotation", "hasPlatformDependentAnnotation", "isCallableMemberCompiledToJvmDefault", "jvmDefault", "isCompiledToJvmDefault", "isJvmRecord", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "frontend.java"})
public final class JvmAnnotationUtilKt {
    @NotNull
    private static final FqName JVM_DEFAULT_FQ_NAME = new FqName("kotlin.jvm.JvmDefault");
    @NotNull
    private static final FqName JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME = new FqName("kotlin.jvm.JvmDefaultWithoutCompatibility");
    @NotNull
    private static final FqName JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME = new FqName("kotlin.jvm.JvmDefaultWithCompatibility");
    @NotNull
    private static final FqName JVM_OVERLOADS_FQ_NAME = new FqName("kotlin.jvm.JvmOverloads");
    @JvmField
    @NotNull
    public static final FqName JVM_SYNTHETIC_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmSynthetic");
    @NotNull
    private static final FqName JVM_RECORD_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmRecord");
    @JvmField
    @NotNull
    public static final FqName SYNCHRONIZED_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Synchronized");
    @JvmField
    @NotNull
    public static final FqName STRICTFP_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Strictfp");
    @JvmField
    @NotNull
    public static final FqName VOLATILE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Volatile");
    @JvmField
    @NotNull
    public static final FqName TRANSIENT_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Transient");

    @NotNull
    public static final FqName getJVM_DEFAULT_FQ_NAME() {
        return JVM_DEFAULT_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME() {
        return JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME() {
        return JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_OVERLOADS_FQ_NAME() {
        return JVM_OVERLOADS_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_RECORD_ANNOTATION_FQ_NAME() {
        return JVM_RECORD_ANNOTATION_FQ_NAME;
    }

    @Nullable
    public static final AnnotationDescriptor findJvmOverloadsAnnotation(@NotNull DeclarationDescriptor $this$findJvmOverloadsAnnotation) {
        Intrinsics.checkNotNullParameter($this$findJvmOverloadsAnnotation, "<this>");
        return $this$findJvmOverloadsAnnotation.getAnnotations().findAnnotation(JVM_OVERLOADS_FQ_NAME);
    }

    @Nullable
    public static final AnnotationDescriptor findJvmFieldAnnotation(@NotNull DeclarationDescriptor $this$findJvmFieldAnnotation) {
        Intrinsics.checkNotNullParameter($this$findJvmFieldAnnotation, "<this>");
        Object object = $this$findJvmFieldAnnotation instanceof PropertyDescriptor ? (PropertyDescriptor)$this$findJvmFieldAnnotation : null;
        return object != null && (object = object.getBackingField()) != null && (object = object.getAnnotations()) != null ? object.findAnnotation(JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME) : null;
    }

    public static final boolean hasJvmFieldAnnotation(@NotNull DeclarationDescriptor $this$hasJvmFieldAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasJvmFieldAnnotation, "<this>");
        return JvmAnnotationUtilKt.findJvmFieldAnnotation($this$hasJvmFieldAnnotation) != null;
    }

    public static final boolean isCallableMemberCompiledToJvmDefault(@NotNull DeclarationDescriptor $this$isCallableMemberCompiledToJvmDefault, @NotNull JvmDefaultMode jvmDefault) {
        Intrinsics.checkNotNullParameter($this$isCallableMemberCompiledToJvmDefault, "<this>");
        Intrinsics.checkNotNullParameter((Object)jvmDefault, "jvmDefault");
        return $this$isCallableMemberCompiledToJvmDefault instanceof CallableMemberDescriptor && JvmAnnotationUtilKt.isCompiledToJvmDefault((CallableMemberDescriptor)$this$isCallableMemberCompiledToJvmDefault, jvmDefault);
    }

    public static final boolean isCompiledToJvmDefault(@NotNull CallableMemberDescriptor $this$isCompiledToJvmDefault, @NotNull JvmDefaultMode jvmDefault) {
        Intrinsics.checkNotNullParameter($this$isCompiledToJvmDefault, "<this>");
        Intrinsics.checkNotNullParameter((Object)jvmDefault, "jvmDefault");
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember($this$isCompiledToJvmDefault);
        Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor, "getDirectMember(this)");
        CallableMemberDescriptor directMember = callableMemberDescriptor;
        DeclarationDescriptor declarationDescriptor = directMember.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "directMember.containingDeclaration");
        DeclarationDescriptor clazz = declarationDescriptor;
        if (directMember.getAnnotations().hasAnnotation(JVM_DEFAULT_FQ_NAME)) {
            return true;
        }
        if (!(clazz instanceof DeserializedClassDescriptor)) {
            return jvmDefault.getForAllMethodsWithBody();
        }
        return JvmProtoBufUtil.isNewPlaceForBodyGeneration(((DeserializedClassDescriptor)clazz).getClassProto());
    }

    public static final boolean checkIsImplementationCompiledToJvmDefault(@NotNull CallableMemberDescriptor $this$checkIsImplementationCompiledToJvmDefault, @NotNull JvmDefaultMode jvmDefaultMode2) {
        Intrinsics.checkNotNullParameter($this$checkIsImplementationCompiledToJvmDefault, "<this>");
        Intrinsics.checkNotNullParameter((Object)jvmDefaultMode2, "jvmDefaultMode");
        CallableMemberDescriptor callableMemberDescriptor = $this$checkIsImplementationCompiledToJvmDefault.getKind().isReal() ? $this$checkIsImplementationCompiledToJvmDefault : DeclarationUtilKt.findImplementationFromInterface($this$checkIsImplementationCompiledToJvmDefault);
        if (callableMemberDescriptor == null) {
            throw new IllegalStateException(("Can't find actual implementation for " + $this$checkIsImplementationCompiledToJvmDefault).toString());
        }
        CallableMemberDescriptor actualImplementation = callableMemberDescriptor;
        return JvmAnnotationUtilKt.isCallableMemberCompiledToJvmDefault(actualImplementation, jvmDefaultMode2);
    }

    public static final boolean hasJvmDefaultAnnotation(@NotNull CallableMemberDescriptor $this$hasJvmDefaultAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasJvmDefaultAnnotation, "<this>");
        return DescriptorUtils.getDirectMember($this$hasJvmDefaultAnnotation).getAnnotations().hasAnnotation(JVM_DEFAULT_FQ_NAME);
    }

    public static final boolean hasJvmDefaultNoCompatibilityAnnotation(@NotNull DeclarationDescriptor $this$hasJvmDefaultNoCompatibilityAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasJvmDefaultNoCompatibilityAnnotation, "<this>");
        return $this$hasJvmDefaultNoCompatibilityAnnotation.getAnnotations().hasAnnotation(JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME);
    }

    public static final boolean hasJvmDefaultWithCompatibilityAnnotation(@NotNull DeclarationDescriptor $this$hasJvmDefaultWithCompatibilityAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasJvmDefaultWithCompatibilityAnnotation, "<this>");
        return $this$hasJvmDefaultWithCompatibilityAnnotation.getAnnotations().hasAnnotation(JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME);
    }

    public static final boolean hasPlatformDependentAnnotation(@NotNull CallableMemberDescriptor $this$hasPlatformDependentAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasPlatformDependentAnnotation, "<this>");
        return DescriptorUtils.getDirectMember($this$hasPlatformDependentAnnotation).getAnnotations().hasAnnotation(PlatformDependentDeclarationFilterKt.getPLATFORM_DEPENDENT_ANNOTATION_FQ_NAME());
    }

    private static final AnnotationDescriptor findJvmSyntheticAnnotation(Annotated $this$findJvmSyntheticAnnotation) {
        AnnotationDescriptor annotationDescriptor = $this$findJvmSyntheticAnnotation.getAnnotations().findAnnotation(JVM_SYNTHETIC_ANNOTATION_FQ_NAME);
        if (annotationDescriptor == null) {
            Object object = $this$findJvmSyntheticAnnotation instanceof PropertyDescriptor ? (PropertyDescriptor)$this$findJvmSyntheticAnnotation : null;
            annotationDescriptor = object != null && (object = object.getBackingField()) != null && (object = object.getAnnotations()) != null ? object.findAnnotation(JVM_SYNTHETIC_ANNOTATION_FQ_NAME) : null;
        }
        return annotationDescriptor;
    }

    public static final boolean hasJvmSyntheticAnnotation(@NotNull DeclarationDescriptor $this$hasJvmSyntheticAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasJvmSyntheticAnnotation, "<this>");
        return JvmAnnotationUtilKt.findJvmSyntheticAnnotation($this$hasJvmSyntheticAnnotation) != null;
    }

    @Nullable
    public static final AnnotationDescriptor findStrictfpAnnotation(@NotNull DeclarationDescriptor $this$findStrictfpAnnotation) {
        Intrinsics.checkNotNullParameter($this$findStrictfpAnnotation, "<this>");
        return $this$findStrictfpAnnotation.getAnnotations().findAnnotation(STRICTFP_ANNOTATION_FQ_NAME);
    }

    @Nullable
    public static final AnnotationDescriptor findSynchronizedAnnotation(@NotNull DeclarationDescriptor $this$findSynchronizedAnnotation) {
        Intrinsics.checkNotNullParameter($this$findSynchronizedAnnotation, "<this>");
        return $this$findSynchronizedAnnotation.getAnnotations().findAnnotation(SYNCHRONIZED_ANNOTATION_FQ_NAME);
    }

    public static final boolean isJvmRecord(@NotNull ClassDescriptor $this$isJvmRecord) {
        Intrinsics.checkNotNullParameter($this$isJvmRecord, "<this>");
        return $this$isJvmRecord.getAnnotations().hasAnnotation(JVM_RECORD_ANNOTATION_FQ_NAME);
    }
}

