/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputBinaryFile;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.output.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.extensions.ClassFileFactoryFinalizerExtension;
import org.jetbrains.kotlin.jvm.abi.AbiClassInfo;
import org.jetbrains.kotlin.jvm.abi.AbiMethodInfo;
import org.jetbrains.kotlin.jvm.abi.JvmAbiMetadataProcessorKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension;", "Lorg/jetbrains/kotlin/codegen/extensions/ClassFileFactoryFinalizerExtension;", "outputPath", "Ljava/io/File;", "abiClassInfos", "", "", "Lorg/jetbrains/kotlin/jvm/abi/AbiClassInfo;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Ljava/io/File;Ljava/util/Map;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "finalizeClassFactory", "", "factory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "AbiOutputFiles", "jvm-abi-gen"})
public final class JvmAbiOutputExtension
implements ClassFileFactoryFinalizerExtension {
    @NotNull
    private final File outputPath;
    @NotNull
    private final Map<String, AbiClassInfo> abiClassInfos;
    @NotNull
    private final MessageCollector messageCollector;

    public JvmAbiOutputExtension(@NotNull File outputPath, @NotNull Map<String, ? extends AbiClassInfo> abiClassInfos, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter(abiClassInfos, (String)"abiClassInfos");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        this.outputPath = outputPath;
        this.abiClassInfos = abiClassInfos;
        this.messageCollector = messageCollector;
    }

    public void finalizeClassFactory(@NotNull ClassFileFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        AbiOutputFiles outputFiles = new AbiOutputFiles(this.abiClassInfos, (OutputFileCollection)factory);
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)this.outputPath), (Object)"jar")) {
            CompileEnvironmentUtil.writeToJar((File)this.outputPath, (boolean)false, (boolean)true, (boolean)true, null, (OutputFileCollection)outputFiles, (MessageCollector)this.messageCollector);
        } else {
            OutputUtilsKt.writeAllTo((OutputFileCollection)outputFiles, (File)this.outputPath);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension$AbiOutputFiles;", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "abiClassInfos", "", "", "Lorg/jetbrains/kotlin/jvm/abi/AbiClassInfo;", "outputFiles", "(Ljava/util/Map;Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;)V", "getAbiClassInfos", "()Ljava/util/Map;", "getOutputFiles", "()Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "asList", "", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "get", "relativePath", "jvm-abi-gen"})
    private static final class AbiOutputFiles
    implements OutputFileCollection {
        @NotNull
        private final Map<String, AbiClassInfo> abiClassInfos;
        @NotNull
        private final OutputFileCollection outputFiles;

        public AbiOutputFiles(@NotNull Map<String, ? extends AbiClassInfo> abiClassInfos, @NotNull OutputFileCollection outputFiles) {
            Intrinsics.checkNotNullParameter(abiClassInfos, (String)"abiClassInfos");
            Intrinsics.checkNotNullParameter((Object)outputFiles, (String)"outputFiles");
            this.abiClassInfos = abiClassInfos;
            this.outputFiles = outputFiles;
        }

        @NotNull
        public final Map<String, AbiClassInfo> getAbiClassInfos() {
            return this.abiClassInfos;
        }

        @NotNull
        public final OutputFileCollection getOutputFiles() {
            return this.outputFiles;
        }

        @Nullable
        public OutputFile get(@NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            throw new IllegalStateException("AbiOutputFiles does not implement `get`.".toString());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<OutputFile> asList() {
            void $this$mapNotNullTo$iv$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.outputFiles.asList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                OutputFile it = (OutputFile)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.endsWith$default((String)it.getRelativePath(), (String)".class", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List metadata = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    OutputFile it = (OutputFile)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getRelativePath());
                    it = (OutputFile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getRelativePath())));
                }
            });
            Iterable $this$mapNotNull$iv = CollectionsKt.sorted((Iterable)this.abiClassInfos.keySet());
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                OutputFile outputFile;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String internalName = (String)element$iv$iv;
                boolean bl2 = false;
                OutputFile outputFile2 = this.outputFiles.get(internalName + ".class");
                AbiClassInfo abiInfo = (AbiClassInfo)MapsKt.getValue(this.abiClassInfos, (Object)internalName);
                if (outputFile2 == null) {
                    outputFile = null;
                } else if (abiInfo instanceof AbiClassInfo.Public) {
                    outputFile = outputFile2;
                } else {
                    Intrinsics.checkNotNull((Object)abiInfo, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.jvm.abi.AbiClassInfo.Stripped");
                    Map<Method, AbiMethodInfo> methodInfo = ((AbiClassInfo.Stripped)abiInfo).getMethodInfo();
                    ClassWriter writer = new ClassWriter(0);
                    new ClassReader(outputFile2.asByteArray()).accept(new ClassVisitor(writer, methodInfo, this){
                        final /* synthetic */ Map<Method, AbiMethodInfo> $methodInfo;
                        final /* synthetic */ AbiOutputFiles this$0;
                        {
                            this.$methodInfo = $methodInfo;
                            this.this$0 = $receiver;
                            super(589824, (ClassVisitor)$writer);
                        }

                        @Nullable
                        public FieldVisitor visitField(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable Object value) {
                            if ((access & 2) != 0) {
                                return null;
                            }
                            return super.visitField(access, name, descriptor, signature, value);
                        }

                        @Nullable
                        public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
                            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                            AbiMethodInfo abiMethodInfo = this.$methodInfo.get(new Method(name, descriptor));
                            if (abiMethodInfo == null) {
                                return null;
                            }
                            AbiMethodInfo info = abiMethodInfo;
                            MethodVisitor visitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                            if (info == AbiMethodInfo.KEEP || (access & 0x500) != 0) {
                                return visitor;
                            }
                            return new MethodVisitor(visitor){

                                public void visitCode() {
                                    MethodVisitor $this$visitCode_u24lambda_u2d0 = this.mv;
                                    boolean bl = false;
                                    $this$visitCode_u24lambda_u2d0.visitCode();
                                    $this$visitCode_u24lambda_u2d0.visitInsn(1);
                                    $this$visitCode_u24lambda_u2d0.visitInsn(191);
                                    $this$visitCode_u24lambda_u2d0.visitMaxs(0, 0);
                                    $this$visitCode_u24lambda_u2d0.visitEnd();
                                    this.mv = null;
                                }
                            };
                        }

                        public void visitSource(@Nullable String source, @Nullable String debug) {
                            boolean bl;
                            block5: {
                                Iterable $this$any$iv = this.$methodInfo.values();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        AbiMethodInfo it = (AbiMethodInfo)((Object)element$iv);
                                        boolean bl2 = false;
                                        if (!(it == AbiMethodInfo.KEEP)) continue;
                                        bl = true;
                                        break block5;
                                    }
                                    bl = false;
                                }
                            }
                            if (bl) {
                                super.visitSource(source, debug);
                            } else {
                                super.visitSource(source, null);
                            }
                        }

                        public void visitInnerClass(@Nullable String name, @Nullable String outerName, @Nullable String innerName, int access) {
                            if (CollectionsKt.contains((Iterable)this.this$0.getAbiClassInfos().keySet(), (Object)name)) {
                                super.visitInnerClass(name, outerName, innerName, access);
                            }
                        }

                        @NotNull
                        public AnnotationVisitor visitAnnotation(@Nullable String descriptor, boolean visible) {
                            AnnotationVisitor delegate = super.visitAnnotation(descriptor, visible);
                            if (!Intrinsics.areEqual((Object)descriptor, (Object)JvmAnnotationNames.METADATA_DESC)) {
                                Intrinsics.checkNotNullExpressionValue((Object)delegate, (String)"delegate");
                                return delegate;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)delegate, (String)"delegate");
                            return JvmAbiMetadataProcessorKt.abiMetadataProcessor(delegate);
                        }
                    }, 0);
                    List list = outputFile2.getSourceFiles();
                    String string = outputFile2.getRelativePath();
                    byte[] byArray = writer.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writer.toByteArray()");
                    outputFile = (OutputFile)new SimpleOutputBinaryFile(list, string, byArray);
                }
                if (outputFile == null) continue;
                OutputFile it$iv$iv = outputFile;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List classFiles2 = (List)destination$iv$iv2;
            return CollectionsKt.plus((Collection)metadata, (Iterable)classFiles2);
        }
    }
}

