"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maybeHas = maybeHas;
exports.validatePassword = validatePassword;
exports.FETCH_STATUS_SUCCESS = exports.shouldIncludeInOutstandingSum = exports.shouldIncludeInBalance = exports.MIN_WEBOOB_VERSION = exports.UNKNOWN_ACCOUNT_TYPE = exports.UNKNOWN_OPERATION_TYPE = exports.formatDate = void 0;

var _moment = _interopRequireDefault(require("moment"));

var _accountTypes = _interopRequireDefault(require("./account-types.json"));

var _operationTypes = _interopRequireDefault(require("./operation-types.json"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint no-console: 0 */
function maybeHas(obj, prop) {
  return obj && obj.hasOwnProperty(prop);
} // Example: 02/25/2019


const toShortString = date => (0, _moment.default)(date).format('L'); // Example: February 25, 2019


const toDayString = date => (0, _moment.default)(date).format('LL'); // Example: Monday, February 25, 2019 10:04 PM


const toLongString = date => (0, _moment.default)(date).format('LLLL'); // Example: 5 minutes ago


const fromNow = date => (0, _moment.default)(date).calendar();

const formatDate = {
  toShortString,
  toDayString,
  toLongString,
  fromNow
};
exports.formatDate = formatDate;
const UNKNOWN_OPERATION_TYPE = 'type.unknown';
exports.UNKNOWN_OPERATION_TYPE = UNKNOWN_OPERATION_TYPE;
const UNKNOWN_ACCOUNT_TYPE = 'account-type.unknown';
exports.UNKNOWN_ACCOUNT_TYPE = UNKNOWN_ACCOUNT_TYPE;
const MIN_WEBOOB_VERSION = '1.5'; // At least 8 chars, including one lowercase, one uppercase and one digit.

exports.MIN_WEBOOB_VERSION = MIN_WEBOOB_VERSION;
const PASSPHRASE_VALIDATION_REGEXP = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}$/;

function validatePassword(password) {
  return PASSPHRASE_VALIDATION_REGEXP.test(password);
}

const DEFERRED_CARD_TYPE = _operationTypes.default.find(type => type.name === 'type.deferred_card');

const SUMMARY_CARD_TYPE = _operationTypes.default.find(type => type.name === 'type.card_summary');

const ACCOUNT_TYPE_CARD = _accountTypes.default.find(type => type.name === 'account-type.card');

const shouldIncludeInBalance = (op, balanceDate, accountType) => {
  let opDebitMoment = (0, _moment.default)(op.debitDate || op.date);
  return opDebitMoment.isSameOrBefore(balanceDate, 'day') && (op.type !== DEFERRED_CARD_TYPE.name || accountType === ACCOUNT_TYPE_CARD.name);
};

exports.shouldIncludeInBalance = shouldIncludeInBalance;

const shouldIncludeInOutstandingSum = op => {
  let opDebitMoment = (0, _moment.default)(op.debitDate || op.date);
  let today = (0, _moment.default)();
  return opDebitMoment.isAfter(today, 'day') && op.type !== SUMMARY_CARD_TYPE.name;
};

exports.shouldIncludeInOutstandingSum = shouldIncludeInOutstandingSum;
const FETCH_STATUS_SUCCESS = 'OK';
exports.FETCH_STATUS_SUCCESS = FETCH_STATUS_SUCCESS;