/// <reference types="node" />
import { ParsedUrlQuery } from "querystring";
import { ServerResponse } from "http";
import { IrcServer } from "./irc/IrcServer";
import { ClientPool } from "./irc/ClientPool";
import { IrcBridge } from "./bridge/IrcBridge";
export declare class DebugApi {
    private ircBridge;
    private port;
    private servers;
    private pool;
    private token;
    constructor(ircBridge: IrcBridge, port: number, servers: IrcServer[], pool: ClientPool, token: string);
    run(): void;
    private onRequest;
    private onKillUser;
    onReapUsers(query: ParsedUrlQuery, response: ServerResponse): void;
    private getClient;
    private getClientState;
    private killUser;
    private sendIRCCommand;
    private killRoom;
    private inspectUsers;
    private wrapJsonReq;
    private wrapJsonResponse;
}
