/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.io.InputStream;

public class ThrottlingInputStream
extends InputStream {
    private final InputStream target;
    private final RateLimiter maxBytesPerSecond;

    public ThrottlingInputStream(InputStream target, RateLimiter maxBytesPerSecond) {
        this.target = target;
        this.maxBytesPerSecond = maxBytesPerSecond;
    }

    @Override
    public int read() throws IOException {
        this.maxBytesPerSecond.acquire(1);
        return this.target.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.maxBytesPerSecond.acquire(b.length);
        return this.target.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.maxBytesPerSecond.acquire(len);
        return this.target.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.target.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.target.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.target.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.target.reset();
    }

    @Override
    public boolean markSupported() {
        return this.target.markSupported();
    }

    @Override
    public void close() throws IOException {
        this.target.close();
    }
}

