/*
 * Decompiled with CFR 0.152.
 */
package mediathek.update;

import java.io.Closeable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import mediathek.tool.TimerPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutomaticFilmlistUpdate
implements Closeable {
    private static final Logger logger = LogManager.getLogger(AutomaticFilmlistUpdate.class);
    private final IUpdateAction action;
    private ScheduledFuture<?> actionFuture;

    public AutomaticFilmlistUpdate(IUpdateAction action) {
        this.action = action;
    }

    private void reloadFilmList() {
        logger.debug("Automatic FilmList load started.");
        this.action.performUpdate();
        logger.debug("Automatic FilmList load finished.");
    }

    public void start() {
        logger.debug("AutomaticFilmlistUpdate Started.");
        this.actionFuture = TimerPool.getTimerPool().scheduleWithFixedDelay(() -> SwingUtilities.invokeLater(this::reloadFilmList), 12L, 12L, TimeUnit.HOURS);
    }

    @Override
    public void close() {
        if (this.actionFuture != null && !this.actionFuture.isDone()) {
            this.actionFuture.cancel(false);
        }
        logger.debug("AutomaticFilmlistUpdate closed.");
    }

    @FunctionalInterface
    public static interface IUpdateAction {
        public void performUpdate();
    }
}

