/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.Locale;
import java.util.Map;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.draw.TimeHeader;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public abstract class TimeHeaderCalendar
extends TimeHeader {
    protected final LoadPlanable defaultPlan;
    protected final Map<Day, HColor> colorDays;
    protected final Map<DayOfWeek, HColor> colorDaysOfWeek;
    protected final Locale locale;

    public TimeHeaderCalendar(Locale locale, Style timelineStyle, Style closedStyle, Day calendar, Day min, Day max, LoadPlanable defaultPlan, Map<Day, HColor> colorDays, Map<DayOfWeek, HColor> colorDaysOfWeek, TimeScale timeScale, HColorSet colorSet, ThemeStyle themeStyle) {
        super(timelineStyle, closedStyle, min, max, timeScale, colorSet, themeStyle);
        this.locale = locale;
        this.defaultPlan = defaultPlan;
        this.colorDays = colorDays;
        this.colorDaysOfWeek = colorDaysOfWeek;
    }

    protected final void drawTextsBackground(UGraphic ug, double totalHeightWithoutFooter) {
        double height = totalHeightWithoutFooter - this.getFullHeaderHeight();
        Pending pending = null;
        Day wink = this.min;
        while (wink.compareTo(this.max) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            double x2 = this.getTimeScale().getEndingPosition(wink);
            HColor back = this.colorDays.get(wink);
            HColor backDoW = this.colorDaysOfWeek.get((Object)wink.getDayOfWeek());
            if (backDoW != null) {
                back = backDoW;
            }
            if (back == null && this.defaultPlan.getLoadAt(wink) == 0) {
                back = this.closedBackgroundColor();
            }
            if (back == null) {
                if (pending != null) {
                    pending.draw(ug, height);
                }
                pending = null;
            } else {
                if (pending != null && !pending.color.equals(back)) {
                    pending.draw(ug, height);
                    pending = null;
                }
                if (pending == null) {
                    pending = new Pending(back, x1, x2);
                } else {
                    pending.x2 = x2;
                }
            }
            wink = wink.increment();
        }
    }

    class Pending {
        final double x1;
        double x2;
        final HColor color;

        Pending(HColor color, double x1, double x2) {
            this.x1 = x1;
            this.x2 = x2;
            this.color = color;
        }

        public void draw(UGraphic ug, double height) {
            TimeHeaderCalendar.this.drawRectangle(ug.apply(this.color.bg()), height, this.x1, this.x2);
        }
    }
}

