/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Point2D;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class PlayerAnalog
extends Player {
    private final SortedMap<TimeTick, Double> values = new TreeMap<TimeTick, Double>();
    private final double ymargin = 8.0;
    private Double initialState;
    private Double start;
    private Double end;
    private Integer ticksEvery;

    public PlayerAnalog(String code, ISkinParam skinParam, TimingRuler ruler, boolean compact) {
        super(code, skinParam, ruler, compact, null);
        this.suggestedHeight = 100;
    }

    private double getMin() {
        if (this.start != null) {
            return this.start;
        }
        return 0.0;
    }

    private double getMax() {
        if (this.end != null) {
            return this.end;
        }
        double max = 0.0;
        for (Double val : this.values.values()) {
            max = Math.max(max, val);
        }
        if (max == 0.0) {
            return 10.0;
        }
        return max;
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        return this.suggestedHeight;
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        double x = this.ruler.getPosInPixel(tick);
        double value = this.getValueAt(tick);
        return new IntricatedPoint(new Point2D.Double(x, this.getYpos(value)), new Point2D.Double(x, this.getYpos(value)));
    }

    private double getValueAt(TimeTick tick) {
        Double result = (Double)this.values.get(tick);
        if (result != null) {
            return result;
        }
        Map.Entry<TimeTick, Double> last = null;
        for (Map.Entry<TimeTick, Double> ent : this.values.entrySet()) {
            if (ent.getKey().compareTo(tick) > 0) {
                double v2 = ent.getValue();
                if (last == null) {
                    return v2;
                }
                double t2 = ent.getKey().getTime().doubleValue();
                double v1 = last.getValue();
                double t1 = last.getKey().getTime().doubleValue();
                double p = (tick.getTime().doubleValue() - t1) / (t2 - t1);
                return v1 + (v2 - v1) * p;
            }
            last = ent;
        }
        return (Double)last.getValue();
    }

    @Override
    public void addNote(TimeTick now, Display note, Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void defineState(String stateCode, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setState(TimeTick now, String comment, Colors color, String ... valueString) {
        double value = this.getState(valueString[0]);
        if (now == null) {
            this.initialState = value;
        } else {
            this.values.put(now, value);
        }
        if (this.initialState == null) {
            this.initialState = value;
        }
    }

    private double getState(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    @Override
    public void createConstraint(TimeTick tick1, TimeTick tick2, String message) {
        throw new UnsupportedOperationException();
    }

    private double getYpos(double value) {
        double fullHeight = this.getFullHeight(null);
        double y = (value - this.getMin()) * (fullHeight - 16.0) / (this.getMax() - this.getMin());
        return fullHeight - 8.0 - y;
    }

    @Override
    public TextBlock getPart1(final double fullAvailableWidth, final double specialVSpace) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                PlayerAnalog.this.drawPart1(ug, fullAvailableWidth, specialVSpace);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dim = PlayerAnalog.this.getTitle().calculateDimension(stringBounder);
                return Dimension2DDouble.delta(dim, 5.0 + PlayerAnalog.this.getMaxWidthForTicks(stringBounder), 0.0);
            }
        };
    }

    private double getMaxWidthForTicks(StringBounder stringBounder) {
        if (this.ticksEvery == null) {
            return Math.max(this.getWidthLabel(stringBounder, this.getMin()), this.getWidthLabel(stringBounder, this.getMax()));
        }
        double result = 0.0;
        int first = (int)Math.ceil(this.getMin());
        int last = (int)Math.floor(this.getMax());
        for (int i = first; i <= last; ++i) {
            if (i % this.ticksEvery != 0) continue;
            result = Math.max(result, this.getWidthLabel(stringBounder, i));
        }
        return result;
    }

    private void drawPart1(UGraphic ug, double fullAvailableWidth, double specialVSpace) {
        StringBounder stringBounder = ug.getStringBounder();
        TextBlock title = this.getTitle();
        Dimension2D dim = title.calculateDimension(stringBounder);
        double y = (this.getFullHeight(stringBounder) - dim.getHeight()) / 2.0;
        title.drawU(ug.apply(UTranslate.dy(y)));
        if (this.ticksEvery == null) {
            this.drawScaleLabel(ug.apply(UTranslate.dy(specialVSpace)), this.getMin(), fullAvailableWidth);
            this.drawScaleLabel(ug.apply(UTranslate.dy(specialVSpace)), this.getMax(), fullAvailableWidth);
        } else {
            int first = (int)Math.ceil(this.getMin());
            int last = (int)Math.floor(this.getMax());
            for (int i = first; i <= last; ++i) {
                if (i % this.ticksEvery != 0) continue;
                this.drawScaleLabel(ug.apply(UTranslate.dy(specialVSpace)), i, fullAvailableWidth);
            }
        }
    }

    private double getWidthLabel(StringBounder stringBounder, double value) {
        TextBlock label = this.getTextBlock(value);
        Dimension2D dim = label.calculateDimension(stringBounder);
        return dim.getWidth();
    }

    private void drawScaleLabel(UGraphic ug, double value, double fullAvailableWidth) {
        TextBlock label = this.getTextBlock(value);
        Dimension2D dim = label.calculateDimension(ug.getStringBounder());
        ug = ug.apply(UTranslate.dx(fullAvailableWidth - dim.getWidth() - 2.0));
        label.drawU(ug.apply(UTranslate.dy(this.getYpos(value) - dim.getHeight() / 2.0)));
    }

    private TextBlock getTextBlock(double value) {
        Display display = Display.getWithNewlines("" + value);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    private void drawTickHlines(UGraphic ug) {
        ug = TimingRuler.applyForVLines(ug, this.getStyle(), this.skinParam);
        int first = (int)Math.ceil(this.getMin());
        int last = (int)Math.floor(this.getMax());
        ULine hline = ULine.hline(this.ruler.getWidth());
        for (int i = first; i <= last; ++i) {
            if (i % this.ticksEvery != 0) continue;
            ug.apply(UTranslate.dy(this.getYpos(i))).draw(hline);
        }
    }

    @Override
    public UDrawable getPart2() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                if (PlayerAnalog.this.ticksEvery != null) {
                    PlayerAnalog.this.drawTickHlines(ug);
                }
                ug = PlayerAnalog.this.getContext().apply(ug);
                double lastx = 0.0;
                double lastValue = PlayerAnalog.this.initialState == null ? 0.0 : PlayerAnalog.this.initialState;
                for (Map.Entry ent : PlayerAnalog.this.values.entrySet()) {
                    double y1 = PlayerAnalog.this.getYpos(lastValue);
                    double y2 = PlayerAnalog.this.getYpos((Double)ent.getValue());
                    double x = PlayerAnalog.this.ruler.getPosInPixel((TimeTick)ent.getKey());
                    ug.apply(new UTranslate(lastx, y1)).draw(new ULine(x - lastx, y2 - y1));
                    lastx = x;
                    lastValue = (Double)ent.getValue();
                }
                ug.apply(new UTranslate(lastx, PlayerAnalog.this.getYpos(lastValue))).draw(ULine.hline(PlayerAnalog.this.ruler.getWidth() - lastx));
            }
        };
    }

    public void setStartEnd(double start, double end) {
        this.start = start;
        this.end = end;
    }

    public void setTicks(int ticksEvery) {
        this.ticksEvery = ticksEvery;
    }

    @Override
    protected StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram);
    }
}

