/* scanner.c generated by valac 0.56.0, the Vala compiler
 * generated from scanner.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* TODO: Could indicate the start of the next page immediately after the last page is received (i.e. before the sane_cancel()) */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <sane/sane.h>
#include <glib/gi18n-lib.h>
#include <sane/saneopts.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
enum  {
	SCAN_DEVICE_0_PROPERTY,
	SCAN_DEVICE_NUM_PROPERTIES
};
static GParamSpec* scan_device_properties[SCAN_DEVICE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
enum  {
	SCAN_PAGE_INFO_0_PROPERTY,
	SCAN_PAGE_INFO_NUM_PROPERTIES
};
static GParamSpec* scan_page_info_properties[SCAN_PAGE_INFO_NUM_PROPERTIES];

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
enum  {
	SCAN_LINE_0_PROPERTY,
	SCAN_LINE_NUM_PROPERTIES
};
static GParamSpec* scan_line_properties[SCAN_LINE_NUM_PROPERTIES];
typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF,
	SCAN_TYPE_BATCH
} ScanType;

#define TYPE_SCAN_TYPE (scan_type_get_type ())
typedef enum  {
	SCAN_SIDE_FRONT,
	SCAN_SIDE_BACK,
	SCAN_SIDE_BOTH
} ScanSide;

#define TYPE_SCAN_SIDE (scan_side_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
enum  {
	SCAN_OPTIONS_0_PROPERTY,
	SCAN_OPTIONS_NUM_PROPERTIES
};
static GParamSpec* scan_options_properties[SCAN_OPTIONS_NUM_PROPERTIES];

#define TYPE_SCAN_JOB (scan_job_get_type ())
#define SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_JOB, ScanJob))
#define SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_JOB, ScanJobClass))
#define IS_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_JOB))
#define IS_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_JOB))
#define SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_JOB, ScanJobClass))

typedef struct _ScanJob ScanJob;
typedef struct _ScanJobClass ScanJobClass;
typedef struct _ScanJobPrivate ScanJobPrivate;
enum  {
	SCAN_JOB_0_PROPERTY,
	SCAN_JOB_NUM_PROPERTIES
};
static GParamSpec* scan_job_properties[SCAN_JOB_NUM_PROPERTIES];

#define TYPE_REQUEST (request_get_type ())
#define REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST, Request))
#define REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST, RequestClass))
#define IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST))
#define IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST))
#define REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST, RequestClass))

typedef struct _Request Request;
typedef struct _RequestClass RequestClass;
typedef struct _RequestPrivate RequestPrivate;
typedef struct _ParamSpecRequest ParamSpecRequest;

#define TYPE_REQUEST_REDETECT (request_redetect_get_type ())
#define REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_REDETECT, RequestRedetect))
#define REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_REDETECT, RequestRedetectClass))
#define IS_REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_REDETECT))
#define IS_REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_REDETECT))
#define REQUEST_REDETECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_REDETECT, RequestRedetectClass))

typedef struct _RequestRedetect RequestRedetect;
typedef struct _RequestRedetectClass RequestRedetectClass;
typedef struct _RequestRedetectPrivate RequestRedetectPrivate;

#define TYPE_REQUEST_CANCEL (request_cancel_get_type ())
#define REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_CANCEL, RequestCancel))
#define REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_CANCEL, RequestCancelClass))
#define IS_REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_CANCEL))
#define IS_REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_CANCEL))
#define REQUEST_CANCEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_CANCEL, RequestCancelClass))

typedef struct _RequestCancel RequestCancel;
typedef struct _RequestCancelClass RequestCancelClass;
typedef struct _RequestCancelPrivate RequestCancelPrivate;

#define TYPE_REQUEST_START_SCAN (request_start_scan_get_type ())
#define REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_START_SCAN, RequestStartScan))
#define REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_START_SCAN, RequestStartScanClass))
#define IS_REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_START_SCAN))
#define IS_REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_START_SCAN))
#define REQUEST_START_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_START_SCAN, RequestStartScanClass))

typedef struct _RequestStartScan RequestStartScan;
typedef struct _RequestStartScanClass RequestStartScanClass;
typedef struct _RequestStartScanPrivate RequestStartScanPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_REQUEST_QUIT (request_quit_get_type ())
#define REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_QUIT, RequestQuit))
#define REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_QUIT, RequestQuitClass))
#define IS_REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_QUIT))
#define IS_REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_QUIT))
#define REQUEST_QUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_QUIT, RequestQuitClass))

typedef struct _RequestQuit RequestQuit;
typedef struct _RequestQuitClass RequestQuitClass;
typedef struct _RequestQuitPrivate RequestQuitPrivate;

#define TYPE_CREDENTIALS (credentials_get_type ())
#define CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CREDENTIALS, Credentials))
#define CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CREDENTIALS, CredentialsClass))
#define IS_CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CREDENTIALS))
#define IS_CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CREDENTIALS))
#define CREDENTIALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CREDENTIALS, CredentialsClass))

typedef struct _Credentials Credentials;
typedef struct _CredentialsClass CredentialsClass;
typedef struct _CredentialsPrivate CredentialsPrivate;
typedef struct _ParamSpecCredentials ParamSpecCredentials;
typedef enum  {
	SCAN_STATE_IDLE = 0,
	SCAN_STATE_REDETECT,
	SCAN_STATE_OPEN,
	SCAN_STATE_GET_OPTION,
	SCAN_STATE_START,
	SCAN_STATE_GET_PARAMETERS,
	SCAN_STATE_READ
} ScanState;

#define TYPE_SCAN_STATE (scan_state_get_type ())

#define TYPE_NOTIFY (notify_get_type ())
#define NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY, Notify))
#define NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY, NotifyClass))
#define IS_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY))
#define IS_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY))
#define NOTIFY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY, NotifyClass))

typedef struct _Notify Notify;
typedef struct _NotifyClass NotifyClass;
typedef struct _NotifyPrivate NotifyPrivate;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;
typedef struct _ParamSpecNotify ParamSpecNotify;

#define TYPE_NOTIFY_SCANNING_CHANGED (notify_scanning_changed_get_type ())
#define NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChanged))
#define NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))
#define IS_NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCANNING_CHANGED))
#define IS_NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCANNING_CHANGED))
#define NOTIFY_SCANNING_CHANGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))

typedef struct _NotifyScanningChanged NotifyScanningChanged;
typedef struct _NotifyScanningChangedClass NotifyScanningChangedClass;
typedef struct _NotifyScanningChangedPrivate NotifyScanningChangedPrivate;

#define TYPE_NOTIFY_UPDATE_DEVICES (notify_update_devices_get_type ())
#define NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices))
#define NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))
#define IS_NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_UPDATE_DEVICES))
#define IS_NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_UPDATE_DEVICES))
#define NOTIFY_UPDATE_DEVICES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))

typedef struct _NotifyUpdateDevices NotifyUpdateDevices;
typedef struct _NotifyUpdateDevicesClass NotifyUpdateDevicesClass;
typedef struct _NotifyUpdateDevicesPrivate NotifyUpdateDevicesPrivate;

#define TYPE_NOTIFY_REQUEST_AUTHORIZATION (notify_request_authorization_get_type ())
#define NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization))
#define NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))
#define IS_NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define IS_NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define NOTIFY_REQUEST_AUTHORIZATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))

typedef struct _NotifyRequestAuthorization NotifyRequestAuthorization;
typedef struct _NotifyRequestAuthorizationClass NotifyRequestAuthorizationClass;
typedef struct _NotifyRequestAuthorizationPrivate NotifyRequestAuthorizationPrivate;

#define TYPE_NOTIFY_SCAN_FAILED (notify_scan_failed_get_type ())
#define NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed))
#define NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))
#define IS_NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCAN_FAILED))
#define IS_NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCAN_FAILED))
#define NOTIFY_SCAN_FAILED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))

typedef struct _NotifyScanFailed NotifyScanFailed;
typedef struct _NotifyScanFailedClass NotifyScanFailedClass;
typedef struct _NotifyScanFailedPrivate NotifyScanFailedPrivate;

#define TYPE_NOTIFY_DOCUMENT_DONE (notify_document_done_get_type ())
#define NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDone))
#define NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))
#define IS_NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_DOCUMENT_DONE))
#define IS_NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_DOCUMENT_DONE))
#define NOTIFY_DOCUMENT_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))

typedef struct _NotifyDocumentDone NotifyDocumentDone;
typedef struct _NotifyDocumentDoneClass NotifyDocumentDoneClass;
typedef struct _NotifyDocumentDonePrivate NotifyDocumentDonePrivate;

#define TYPE_NOTIFY_EXPECT_PAGE (notify_expect_page_get_type ())
#define NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPage))
#define NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))
#define IS_NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_EXPECT_PAGE))
#define IS_NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_EXPECT_PAGE))
#define NOTIFY_EXPECT_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))

typedef struct _NotifyExpectPage NotifyExpectPage;
typedef struct _NotifyExpectPageClass NotifyExpectPageClass;
typedef struct _NotifyExpectPagePrivate NotifyExpectPagePrivate;

#define TYPE_NOTIFY_GOT_PAGE_INFO (notify_got_page_info_get_type ())
#define NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo))
#define NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))
#define IS_NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_PAGE_INFO))
#define IS_NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_PAGE_INFO))
#define NOTIFY_GOT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))

typedef struct _NotifyGotPageInfo NotifyGotPageInfo;
typedef struct _NotifyGotPageInfoClass NotifyGotPageInfoClass;
typedef struct _NotifyGotPageInfoPrivate NotifyGotPageInfoPrivate;
typedef struct _ScannerPrivate ScannerPrivate;

#define TYPE_NOTIFY_PAGE_DONE (notify_page_done_get_type ())
#define NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDone))
#define NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))
#define IS_NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_PAGE_DONE))
#define IS_NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_PAGE_DONE))
#define NOTIFY_PAGE_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))

typedef struct _NotifyPageDone NotifyPageDone;
typedef struct _NotifyPageDoneClass NotifyPageDoneClass;
typedef struct _NotifyPageDonePrivate NotifyPageDonePrivate;

#define TYPE_NOTIFY_GOT_LINE (notify_got_line_get_type ())
#define NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLine))
#define NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))
#define IS_NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_LINE))
#define IS_NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_LINE))
#define NOTIFY_GOT_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))

typedef struct _NotifyGotLine NotifyGotLine;
typedef struct _NotifyGotLineClass NotifyGotLineClass;
typedef struct _NotifyGotLinePrivate NotifyGotLinePrivate;
enum  {
	SCANNER_0_PROPERTY,
	SCANNER_NUM_PROPERTIES
};
static GParamSpec* scanner_properties[SCANNER_NUM_PROPERTIES];
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _notify_unref0(var) ((var == NULL) ? NULL : (var = (notify_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _credentials_unref0(var) ((var == NULL) ? NULL : (var = (credentials_unref (var), NULL)))
#define _request_unref0(var) ((var == NULL) ? NULL : (var = (request_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SCANNER_UPDATE_DEVICES_SIGNAL,
	SCANNER_REQUEST_AUTHORIZATION_SIGNAL,
	SCANNER_EXPECT_PAGE_SIGNAL,
	SCANNER_GOT_PAGE_INFO_SIGNAL,
	SCANNER_GOT_LINE_SIGNAL,
	SCANNER_SCAN_FAILED_SIGNAL,
	SCANNER_PAGE_DONE_SIGNAL,
	SCANNER_DOCUMENT_DONE_SIGNAL,
	SCANNER_SCANNING_CHANGED_SIGNAL,
	SCANNER_NUM_SIGNALS
};
static guint scanner_signals[SCANNER_NUM_SIGNALS] = {0};

struct _ScanDevice {
	GObject parent_instance;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GObjectClass parent_class;
};

struct _ScanPageInfo {
	GObject parent_instance;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GObjectClass parent_class;
};

struct _ScanLine {
	GObject parent_instance;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GObjectClass parent_class;
};

struct _ScanOptions {
	GObject parent_instance;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	ScanSide side;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
	gint page_delay;
};

struct _ScanOptionsClass {
	GObjectClass parent_class;
};

struct _ScanJob {
	GObject parent_instance;
	ScanJobPrivate * priv;
	gint id;
	gchar* device;
	gdouble dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	ScanSide side;
	gint page_width;
	gint page_height;
	gint brightness;
	gint contrast;
	gint page_delay;
};

struct _ScanJobClass {
	GObjectClass parent_class;
};

struct _Request {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RequestPrivate * priv;
};

struct _RequestClass {
	GTypeClass parent_class;
	void (*finalize) (Request *self);
};

struct _ParamSpecRequest {
	GParamSpec parent_instance;
};

struct _RequestRedetect {
	Request parent_instance;
	RequestRedetectPrivate * priv;
};

struct _RequestRedetectClass {
	RequestClass parent_class;
};

struct _RequestCancel {
	Request parent_instance;
	RequestCancelPrivate * priv;
};

struct _RequestCancelClass {
	RequestClass parent_class;
};

struct _RequestStartScan {
	Request parent_instance;
	RequestStartScanPrivate * priv;
	ScanJob* job;
};

struct _RequestStartScanClass {
	RequestClass parent_class;
};

struct _RequestQuit {
	Request parent_instance;
	RequestQuitPrivate * priv;
};

struct _RequestQuitClass {
	RequestClass parent_class;
};

struct _Credentials {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CredentialsPrivate * priv;
	gchar* username;
	gchar* password;
};

struct _CredentialsClass {
	GTypeClass parent_class;
	void (*finalize) (Credentials *self);
};

struct _ParamSpecCredentials {
	GParamSpec parent_instance;
};

struct _Notify {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NotifyPrivate * priv;
};

struct _NotifyClass {
	GTypeClass parent_class;
	void (*finalize) (Notify *self);
	void (*run) (Notify* self, Scanner* scanner);
};

struct _ParamSpecNotify {
	GParamSpec parent_instance;
};

struct _NotifyScanningChanged {
	Notify parent_instance;
	NotifyScanningChangedPrivate * priv;
};

struct _NotifyScanningChangedClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevices {
	Notify parent_instance;
	NotifyUpdateDevicesPrivate * priv;
};

struct _NotifyUpdateDevicesClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevicesPrivate {
	GList* devices;
};

struct _NotifyRequestAuthorization {
	Notify parent_instance;
	NotifyRequestAuthorizationPrivate * priv;
};

struct _NotifyRequestAuthorizationClass {
	NotifyClass parent_class;
};

struct _NotifyRequestAuthorizationPrivate {
	gchar* resource;
};

struct _NotifyScanFailed {
	Notify parent_instance;
	NotifyScanFailedPrivate * priv;
};

struct _NotifyScanFailedClass {
	NotifyClass parent_class;
};

struct _NotifyScanFailedPrivate {
	gint error_code;
	gchar* error_string;
};

struct _NotifyDocumentDone {
	Notify parent_instance;
	NotifyDocumentDonePrivate * priv;
};

struct _NotifyDocumentDoneClass {
	NotifyClass parent_class;
};

struct _NotifyExpectPage {
	Notify parent_instance;
	NotifyExpectPagePrivate * priv;
};

struct _NotifyExpectPageClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfo {
	Notify parent_instance;
	NotifyGotPageInfoPrivate * priv;
};

struct _NotifyGotPageInfoClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfoPrivate {
	gint job_id;
	ScanPageInfo* info;
};

struct _Scanner {
	GObject parent_instance;
	ScannerPrivate * priv;
	gint first_job_id;
	gint job_id;
};

struct _ScannerClass {
	GObjectClass parent_class;
};

struct _NotifyPageDone {
	Notify parent_instance;
	NotifyPageDonePrivate * priv;
};

struct _NotifyPageDoneClass {
	NotifyClass parent_class;
};

struct _NotifyPageDonePrivate {
	gint job_id;
};

struct _NotifyGotLine {
	Notify parent_instance;
	NotifyGotLinePrivate * priv;
};

struct _NotifyGotLineClass {
	NotifyClass parent_class;
};

struct _NotifyGotLinePrivate {
	gint job_id;
	ScanLine* line;
};

struct _ScannerPrivate {
	GThread* thread;
	GAsyncQueue* request_queue;
	GAsyncQueue* notify_queue;
	GAsyncQueue* authorize_queue;
	gchar* default_device;
	ScanState state;
	gboolean need_redetect;
	GList* job_queue;
	SANE_Handle handle;
	gboolean have_handle;
	gchar* current_device;
	SANE_Parameters parameters;
	SANE_Int option_index;
	GHashTable* options;
	guchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gint n_used;
	gint line_count;
	gint pass_number;
	gint page_number;
	gint notified_page;
	gboolean scanning;
};

static gpointer scan_device_parent_class = NULL;
static gpointer scan_page_info_parent_class = NULL;
static gpointer scan_line_parent_class = NULL;
static gpointer scan_options_parent_class = NULL;
static gpointer scan_job_parent_class = NULL;
static gpointer request_parent_class = NULL;
static gpointer request_redetect_parent_class = NULL;
static gpointer request_cancel_parent_class = NULL;
static gpointer request_start_scan_parent_class = NULL;
static gpointer request_quit_parent_class = NULL;
static gpointer credentials_parent_class = NULL;
static gpointer notify_parent_class = NULL;
static gpointer notify_scanning_changed_parent_class = NULL;
static gint NotifyUpdateDevices_private_offset;
static gpointer notify_update_devices_parent_class = NULL;
static gint NotifyRequestAuthorization_private_offset;
static gpointer notify_request_authorization_parent_class = NULL;
static gint NotifyScanFailed_private_offset;
static gpointer notify_scan_failed_parent_class = NULL;
static gpointer notify_document_done_parent_class = NULL;
static gpointer notify_expect_page_parent_class = NULL;
static gint NotifyGotPageInfo_private_offset;
static gpointer notify_got_page_info_parent_class = NULL;
static gint NotifyPageDone_private_offset;
static gpointer notify_page_done_parent_class = NULL;
static gint NotifyGotLine_private_offset;
static gpointer notify_got_line_parent_class = NULL;
static gint Scanner_private_offset;
static gpointer scanner_parent_class = NULL;
static Scanner* scanner_scanner_object;
static Scanner* scanner_scanner_object = NULL;

VALA_EXTERN GType scan_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanDevice, g_object_unref)
VALA_EXTERN ScanDevice* scan_device_new (void);
VALA_EXTERN ScanDevice* scan_device_construct (GType object_type);
static void scan_device_finalize (GObject * obj);
static GType scan_device_get_type_once (void);
VALA_EXTERN GType scan_page_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanPageInfo, g_object_unref)
VALA_EXTERN ScanPageInfo* scan_page_info_new (void);
VALA_EXTERN ScanPageInfo* scan_page_info_construct (GType object_type);
static void scan_page_info_finalize (GObject * obj);
static GType scan_page_info_get_type_once (void);
VALA_EXTERN GType scan_line_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanLine, g_object_unref)
VALA_EXTERN ScanLine* scan_line_new (void);
VALA_EXTERN ScanLine* scan_line_construct (GType object_type);
static void scan_line_finalize (GObject * obj);
static GType scan_line_get_type_once (void);
VALA_EXTERN GType scan_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scan_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scan_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scan_options_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanOptions, g_object_unref)
VALA_EXTERN ScanOptions* scan_options_new (void);
VALA_EXTERN ScanOptions* scan_options_construct (GType object_type);
static void scan_options_finalize (GObject * obj);
static GType scan_options_get_type_once (void);
VALA_EXTERN GType scan_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanJob, g_object_unref)
VALA_EXTERN ScanJob* scan_job_new (void);
VALA_EXTERN ScanJob* scan_job_construct (GType object_type);
static void scan_job_finalize (GObject * obj);
static GType scan_job_get_type_once (void);
VALA_EXTERN gpointer request_ref (gpointer instance);
VALA_EXTERN void request_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_request (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_request (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_request (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_request (const GValue* value);
VALA_EXTERN GType request_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Request, request_unref)
VALA_EXTERN Request* request_new (void);
VALA_EXTERN Request* request_construct (GType object_type);
static void request_finalize (Request * obj);
static GType request_get_type_once (void);
VALA_EXTERN GType request_redetect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RequestRedetect, request_unref)
VALA_EXTERN RequestRedetect* request_redetect_new (void);
VALA_EXTERN RequestRedetect* request_redetect_construct (GType object_type);
static GType request_redetect_get_type_once (void);
VALA_EXTERN GType request_cancel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RequestCancel, request_unref)
VALA_EXTERN RequestCancel* request_cancel_new (void);
VALA_EXTERN RequestCancel* request_cancel_construct (GType object_type);
static GType request_cancel_get_type_once (void);
VALA_EXTERN GType request_start_scan_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RequestStartScan, request_unref)
VALA_EXTERN RequestStartScan* request_start_scan_new (void);
VALA_EXTERN RequestStartScan* request_start_scan_construct (GType object_type);
static void request_start_scan_finalize (Request * obj);
static GType request_start_scan_get_type_once (void);
VALA_EXTERN GType request_quit_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RequestQuit, request_unref)
VALA_EXTERN RequestQuit* request_quit_new (void);
VALA_EXTERN RequestQuit* request_quit_construct (GType object_type);
static GType request_quit_get_type_once (void);
VALA_EXTERN gpointer credentials_ref (gpointer instance);
VALA_EXTERN void credentials_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_credentials (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_credentials (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_credentials (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_credentials (const GValue* value);
VALA_EXTERN GType credentials_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Credentials, credentials_unref)
VALA_EXTERN Credentials* credentials_new (void);
VALA_EXTERN Credentials* credentials_construct (GType object_type);
static void credentials_finalize (Credentials * obj);
static GType credentials_get_type_once (void);
VALA_EXTERN GType scan_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer notify_ref (gpointer instance);
VALA_EXTERN void notify_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_notify (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_notify (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_notify (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_notify (const GValue* value);
VALA_EXTERN GType notify_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Notify, notify_unref)
VALA_EXTERN GType scanner_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Scanner, g_object_unref)
VALA_EXTERN void notify_run (Notify* self,
                 Scanner* scanner);
static void notify_real_run (Notify* self,
                      Scanner* scanner);
VALA_EXTERN Notify* notify_new (void);
VALA_EXTERN Notify* notify_construct (GType object_type);
static void notify_finalize (Notify * obj);
static GType notify_get_type_once (void);
VALA_EXTERN GType notify_scanning_changed_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotifyScanningChanged, notify_unref)
static void notify_scanning_changed_real_run (Notify* base,
                                       Scanner* scanner);
VALA_EXTERN NotifyScanningChanged* notify_scanning_changed_new (void);
VALA_EXTERN NotifyScanningChanged* notify_scanning_changed_construct (GType object_type);
static GType notify_scanning_changed_get_type_once (void);
VALA_EXTERN GType notify_update_devices_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotifyUpdateDevices, notify_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN NotifyUpdateDevices* notify_update_devices_new (GList* devices);
VALA_EXTERN NotifyUpdateDevices* notify_update_devices_construct (GType object_type,
                                                      GList* devices);
static void notify_update_devices_real_run (Notify* base,
                                     Scanner* scanner);
static void notify_update_devices_finalize (Notify * obj);
static GType notify_update_devices_get_type_once (void);
VALA_EXTERN GType notify_request_authorization_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotifyRequestAuthorization, notify_unref)
VALA_EXTERN NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource);
VALA_EXTERN NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type,
                                                                    const gchar* resource);
static void notify_request_authorization_real_run (Notify* base,
                                            Scanner* scanner);
static void notify_request_authorization_finalize (Notify * obj);
static GType notify_request_authorization_get_type_once (void);
VALA_EXTERN GType notify_scan_failed_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotifyScanFailed, notify_unref)
VALA_EXTERN NotifyScanFailed* notify_scan_failed_new (gint error_code,
                                          const gchar* error_string);
VALA_EXTERN NotifyScanFailed* notify_scan_failed_construct (GType object_type,
                                                gint error_code,
                                                const gchar* error_string);
static void notify_scan_failed_real_run (Notify* base,
                                  Scanner* scanner);
static void notify_scan_failed_finalize (Notify * obj);
static GType notify_scan_failed_get_type_once (void);
VALA_EXTERN GType notify_document_done_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotifyDocumentDone, notify_unref)
static void notify_document_done_real_run (Notify* base,
                                    Scanner* scanner);
VALA_EXTERN NotifyDocumentDone* notify_document_done_new (void);
VALA_EXTERN NotifyDocumentDone* notify_document_done_construct (GType object_type);
static GType notify_document_done_get_type_once (void);
VALA_EXTERN GType notify_expect_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotifyExpectPage, notify_unref)
static void notify_expect_page_real_run (Notify* base,
                                  Scanner* scanner);
VALA_EXTERN NotifyExpectPage* notify_expect_page_new (void);
VALA_EXTERN NotifyExpectPage* notify_expect_page_construct (GType object_type);
static GType notify_expect_page_get_type_once (void);
VALA_EXTERN GType notify_got_page_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotifyGotPageInfo, notify_unref)
VALA_EXTERN NotifyGotPageInfo* notify_got_page_info_new (gint job_id,
                                             ScanPageInfo* info);
VALA_EXTERN NotifyGotPageInfo* notify_got_page_info_construct (GType object_type,
                                                   gint job_id,
                                                   ScanPageInfo* info);
static void notify_got_page_info_real_run (Notify* base,
                                    Scanner* scanner);
static void notify_got_page_info_finalize (Notify * obj);
static GType notify_got_page_info_get_type_once (void);
VALA_EXTERN GType notify_page_done_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotifyPageDone, notify_unref)
VALA_EXTERN NotifyPageDone* notify_page_done_new (gint job_id);
VALA_EXTERN NotifyPageDone* notify_page_done_construct (GType object_type,
                                            gint job_id);
static void notify_page_done_real_run (Notify* base,
                                Scanner* scanner);
static void notify_page_done_finalize (Notify * obj);
static GType notify_page_done_get_type_once (void);
VALA_EXTERN GType notify_got_line_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotifyGotLine, notify_unref)
VALA_EXTERN NotifyGotLine* notify_got_line_new (gint job_id,
                                    ScanLine* line);
VALA_EXTERN NotifyGotLine* notify_got_line_construct (GType object_type,
                                          gint job_id,
                                          ScanLine* line);
static void notify_got_line_real_run (Notify* base,
                               Scanner* scanner);
static void notify_got_line_finalize (Notify * obj);
static GType notify_got_line_get_type_once (void);
static Scanner* scanner_new (void);
static Scanner* scanner_construct (GType object_type);
static void _request_unref0_ (gpointer var);
static void _notify_unref0_ (gpointer var);
static void _credentials_unref0_ (gpointer var);
VALA_EXTERN Scanner* scanner_get_instance (void);
static gboolean scanner_notify_idle_cb (Scanner* self);
static void scanner_notify_event (Scanner* self,
                           Notify* notification);
static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self);
static void scanner_set_scanning (Scanner* self,
                           gboolean is_scanning);
static gint scanner_get_device_weight (const gchar* device);
static gint scanner_compare_devices (ScanDevice* device1,
                              ScanDevice* device2);
static void scanner_do_redetect (Scanner* self);
static void _g_free0_ (gpointer var);
static gint _scanner_compare_devices_gcompare_func (gconstpointer a,
                                             gconstpointer b);
static gdouble scanner_scale_fixed (Scanner* self,
                             gint source_min,
                             gint source_max,
                             SANE_Option_Descriptor* option,
                             gint value);
static gint scanner_scale_int (Scanner* self,
                        gint source_min,
                        gint source_max,
                        SANE_Option_Descriptor* option,
                        gint value);
static gboolean scanner_set_default_option (Scanner* self,
                                     SANE_Handle handle,
                                     SANE_Option_Descriptor* option,
                                     SANE_Int option_index);
static void scanner_set_bool_option (Scanner* self,
                              SANE_Handle handle,
                              SANE_Option_Descriptor* option,
                              SANE_Int option_index,
                              gboolean value,
                              gboolean* _result_);
static void scanner_set_int_option (Scanner* self,
                             SANE_Handle handle,
                             SANE_Option_Descriptor* option,
                             SANE_Int option_index,
                             gint value,
                             gint* _result_);
static void scanner_set_fixed_option (Scanner* self,
                               SANE_Handle handle,
                               SANE_Option_Descriptor* option,
                               SANE_Int option_index,
                               gdouble value,
                               gdouble* _result_);
static void scanner_set_fixed_or_int_option (Scanner* self,
                                      SANE_Handle handle,
                                      SANE_Option_Descriptor* option,
                                      SANE_Int option_index,
                                      gdouble value,
                                      gdouble* _result_);
static void scanner_set_option_to_max (Scanner* self,
                                SANE_Handle handle,
                                SANE_Option_Descriptor* option,
                                SANE_Int option_index);
static gboolean scanner_set_string_option (Scanner* self,
                                    SANE_Handle handle,
                                    SANE_Option_Descriptor* option,
                                    SANE_Int option_index,
                                    const gchar* value,
                                    gchar** _result_);
static gboolean scanner_set_constrained_string_option (Scanner* self,
                                                SANE_Handle handle,
                                                SANE_Option_Descriptor* option,
                                                SANE_Int option_index,
                                                gchar** values,
                                                gint values_length1,
                                                gchar** _result_);
static void scanner_log_option (Scanner* self,
                         SANE_Int index,
                         SANE_Option_Descriptor* option);
static void scanner_authorization_cb (const gchar* resource,
                               gchar* username,
                               gint username_length1,
                               gchar* password,
                               gint password_length1);
VALA_EXTERN void scanner_authorize (Scanner* self,
                        const gchar* username,
                        const gchar* password);
static void scanner_close_device (Scanner* self);
static void scanner_fail_scan (Scanner* self,
                        gint error_code,
                        const gchar* error_string);
static gboolean scanner_handle_requests (Scanner* self);
static void scanner_do_open (Scanner* self);
static void scanner_set_adf (Scanner* self,
                      ScanJob* job,
                      SANE_Option_Descriptor* option,
                      SANE_Int index);
static void scanner_do_get_option (Scanner* self);
static SANE_Option_Descriptor* scanner_get_option_by_name (Scanner* self,
                                                    SANE_Handle handle,
                                                    const gchar* name,
                                                    gint* index);
static gdouble scanner_convert_page_size (Scanner* self,
                                   SANE_Option_Descriptor* option,
                                   gdouble size,
                                   gdouble dpi);
static void scanner_do_complete_document (Scanner* self);
static void scanner_do_start (Scanner* self);
static void scanner_do_get_parameters (Scanner* self);
static void scanner_do_complete_page (Scanner* self);
static void scanner_do_read (Scanner* self);
static void* scanner_scan_thread (Scanner* self);
static void _scanner_authorization_cb_sane_authcallback (const gchar* resource,
                                                  gchar* username,
                                                  gchar* password);
VALA_EXTERN void scanner_redetect (Scanner* self);
VALA_EXTERN void scanner_start (Scanner* self);
static gpointer _scanner_scan_thread_gthread_func (gpointer self);
VALA_EXTERN gboolean scanner_is_scanning (Scanner* self);
static gchar* scanner_get_scan_mode_string (Scanner* self,
                                     ScanMode mode);
VALA_EXTERN gchar* scanner_type_to_string (ScanType type);
VALA_EXTERN ScanType scanner_type_from_string (const gchar* type);
VALA_EXTERN gchar* scanner_side_to_string (ScanSide side);
VALA_EXTERN ScanSide scanner_side_from_string (const gchar* side);
VALA_EXTERN void scanner_scan (Scanner* self,
                   const gchar* device,
                   ScanOptions* options);
VALA_EXTERN void scanner_cancel (Scanner* self);
VALA_EXTERN void scanner_free (Scanner* self);
static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void scanner_finalize (GObject * obj);
static GType scanner_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ScanDevice*
scan_device_construct (GType object_type)
{
	ScanDevice * self = NULL;
	self = (ScanDevice*) g_object_new (object_type, NULL);
	return self;
}

ScanDevice*
scan_device_new (void)
{
	return scan_device_construct (TYPE_SCAN_DEVICE);
}

static void
scan_device_class_init (ScanDeviceClass * klass,
                        gpointer klass_data)
{
	scan_device_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = scan_device_finalize;
}

static void
scan_device_instance_init (ScanDevice * self,
                           gpointer klass)
{
}

static void
scan_device_finalize (GObject * obj)
{
	ScanDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_DEVICE, ScanDevice);
	_g_free0 (self->name);
	_g_free0 (self->label);
	G_OBJECT_CLASS (scan_device_parent_class)->finalize (obj);
}

static GType
scan_device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScanDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanDevice), 0, (GInstanceInitFunc) scan_device_instance_init, NULL };
	GType scan_device_type_id;
	scan_device_type_id = g_type_register_static (G_TYPE_OBJECT, "ScanDevice", &g_define_type_info, 0);
	return scan_device_type_id;
}

GType
scan_device_get_type (void)
{
	static volatile gsize scan_device_type_id__once = 0;
	if (g_once_init_enter (&scan_device_type_id__once)) {
		GType scan_device_type_id;
		scan_device_type_id = scan_device_get_type_once ();
		g_once_init_leave (&scan_device_type_id__once, scan_device_type_id);
	}
	return scan_device_type_id__once;
}

ScanPageInfo*
scan_page_info_construct (GType object_type)
{
	ScanPageInfo * self = NULL;
	self = (ScanPageInfo*) g_object_new (object_type, NULL);
	return self;
}

ScanPageInfo*
scan_page_info_new (void)
{
	return scan_page_info_construct (TYPE_SCAN_PAGE_INFO);
}

static void
scan_page_info_class_init (ScanPageInfoClass * klass,
                           gpointer klass_data)
{
	scan_page_info_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = scan_page_info_finalize;
}

static void
scan_page_info_instance_init (ScanPageInfo * self,
                              gpointer klass)
{
}

static void
scan_page_info_finalize (GObject * obj)
{
	ScanPageInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_PAGE_INFO, ScanPageInfo);
	_g_free0 (self->device);
	G_OBJECT_CLASS (scan_page_info_parent_class)->finalize (obj);
}

static GType
scan_page_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScanPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanPageInfo), 0, (GInstanceInitFunc) scan_page_info_instance_init, NULL };
	GType scan_page_info_type_id;
	scan_page_info_type_id = g_type_register_static (G_TYPE_OBJECT, "ScanPageInfo", &g_define_type_info, 0);
	return scan_page_info_type_id;
}

GType
scan_page_info_get_type (void)
{
	static volatile gsize scan_page_info_type_id__once = 0;
	if (g_once_init_enter (&scan_page_info_type_id__once)) {
		GType scan_page_info_type_id;
		scan_page_info_type_id = scan_page_info_get_type_once ();
		g_once_init_leave (&scan_page_info_type_id__once, scan_page_info_type_id);
	}
	return scan_page_info_type_id__once;
}

ScanLine*
scan_line_construct (GType object_type)
{
	ScanLine * self = NULL;
	self = (ScanLine*) g_object_new (object_type, NULL);
	return self;
}

ScanLine*
scan_line_new (void)
{
	return scan_line_construct (TYPE_SCAN_LINE);
}

static void
scan_line_class_init (ScanLineClass * klass,
                      gpointer klass_data)
{
	scan_line_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = scan_line_finalize;
}

static void
scan_line_instance_init (ScanLine * self,
                         gpointer klass)
{
}

static void
scan_line_finalize (GObject * obj)
{
	ScanLine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_LINE, ScanLine);
	self->data = (g_free (self->data), NULL);
	G_OBJECT_CLASS (scan_line_parent_class)->finalize (obj);
}

static GType
scan_line_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScanLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanLine), 0, (GInstanceInitFunc) scan_line_instance_init, NULL };
	GType scan_line_type_id;
	scan_line_type_id = g_type_register_static (G_TYPE_OBJECT, "ScanLine", &g_define_type_info, 0);
	return scan_line_type_id;
}

GType
scan_line_get_type (void)
{
	static volatile gsize scan_line_type_id__once = 0;
	if (g_once_init_enter (&scan_line_type_id__once)) {
		GType scan_line_type_id;
		scan_line_type_id = scan_line_get_type_once ();
		g_once_init_leave (&scan_line_type_id__once, scan_line_type_id);
	}
	return scan_line_type_id__once;
}

static GType
scan_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{SCAN_MODE_DEFAULT, "SCAN_MODE_DEFAULT", "default"}, {SCAN_MODE_COLOR, "SCAN_MODE_COLOR", "color"}, {SCAN_MODE_GRAY, "SCAN_MODE_GRAY", "gray"}, {SCAN_MODE_LINEART, "SCAN_MODE_LINEART", "lineart"}, {0, NULL, NULL}};
	GType scan_mode_type_id;
	scan_mode_type_id = g_enum_register_static ("ScanMode", values);
	return scan_mode_type_id;
}

GType
scan_mode_get_type (void)
{
	static volatile gsize scan_mode_type_id__once = 0;
	if (g_once_init_enter (&scan_mode_type_id__once)) {
		GType scan_mode_type_id;
		scan_mode_type_id = scan_mode_get_type_once ();
		g_once_init_leave (&scan_mode_type_id__once, scan_mode_type_id);
	}
	return scan_mode_type_id__once;
}

static GType
scan_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SCAN_TYPE_SINGLE, "SCAN_TYPE_SINGLE", "single"}, {SCAN_TYPE_ADF, "SCAN_TYPE_ADF", "adf"}, {SCAN_TYPE_BATCH, "SCAN_TYPE_BATCH", "batch"}, {0, NULL, NULL}};
	GType scan_type_type_id;
	scan_type_type_id = g_enum_register_static ("ScanType", values);
	return scan_type_type_id;
}

GType
scan_type_get_type (void)
{
	static volatile gsize scan_type_type_id__once = 0;
	if (g_once_init_enter (&scan_type_type_id__once)) {
		GType scan_type_type_id;
		scan_type_type_id = scan_type_get_type_once ();
		g_once_init_leave (&scan_type_type_id__once, scan_type_type_id);
	}
	return scan_type_type_id__once;
}

static GType
scan_side_get_type_once (void)
{
	static const GEnumValue values[] = {{SCAN_SIDE_FRONT, "SCAN_SIDE_FRONT", "front"}, {SCAN_SIDE_BACK, "SCAN_SIDE_BACK", "back"}, {SCAN_SIDE_BOTH, "SCAN_SIDE_BOTH", "both"}, {0, NULL, NULL}};
	GType scan_side_type_id;
	scan_side_type_id = g_enum_register_static ("ScanSide", values);
	return scan_side_type_id;
}

GType
scan_side_get_type (void)
{
	static volatile gsize scan_side_type_id__once = 0;
	if (g_once_init_enter (&scan_side_type_id__once)) {
		GType scan_side_type_id;
		scan_side_type_id = scan_side_get_type_once ();
		g_once_init_leave (&scan_side_type_id__once, scan_side_type_id);
	}
	return scan_side_type_id__once;
}

ScanOptions*
scan_options_construct (GType object_type)
{
	ScanOptions * self = NULL;
	self = (ScanOptions*) g_object_new (object_type, NULL);
	return self;
}

ScanOptions*
scan_options_new (void)
{
	return scan_options_construct (TYPE_SCAN_OPTIONS);
}

static void
scan_options_class_init (ScanOptionsClass * klass,
                         gpointer klass_data)
{
	scan_options_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = scan_options_finalize;
}

static void
scan_options_instance_init (ScanOptions * self,
                            gpointer klass)
{
}

static void
scan_options_finalize (GObject * obj)
{
	ScanOptions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_OPTIONS, ScanOptions);
	G_OBJECT_CLASS (scan_options_parent_class)->finalize (obj);
}

static GType
scan_options_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScanOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanOptions), 0, (GInstanceInitFunc) scan_options_instance_init, NULL };
	GType scan_options_type_id;
	scan_options_type_id = g_type_register_static (G_TYPE_OBJECT, "ScanOptions", &g_define_type_info, 0);
	return scan_options_type_id;
}

GType
scan_options_get_type (void)
{
	static volatile gsize scan_options_type_id__once = 0;
	if (g_once_init_enter (&scan_options_type_id__once)) {
		GType scan_options_type_id;
		scan_options_type_id = scan_options_get_type_once ();
		g_once_init_leave (&scan_options_type_id__once, scan_options_type_id);
	}
	return scan_options_type_id__once;
}

ScanJob*
scan_job_construct (GType object_type)
{
	ScanJob * self = NULL;
	self = (ScanJob*) g_object_new (object_type, NULL);
	return self;
}

ScanJob*
scan_job_new (void)
{
	return scan_job_construct (TYPE_SCAN_JOB);
}

static void
scan_job_class_init (ScanJobClass * klass,
                     gpointer klass_data)
{
	scan_job_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = scan_job_finalize;
}

static void
scan_job_instance_init (ScanJob * self,
                        gpointer klass)
{
}

static void
scan_job_finalize (GObject * obj)
{
	ScanJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_JOB, ScanJob);
	_g_free0 (self->device);
	G_OBJECT_CLASS (scan_job_parent_class)->finalize (obj);
}

static GType
scan_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScanJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanJob), 0, (GInstanceInitFunc) scan_job_instance_init, NULL };
	GType scan_job_type_id;
	scan_job_type_id = g_type_register_static (G_TYPE_OBJECT, "ScanJob", &g_define_type_info, 0);
	return scan_job_type_id;
}

GType
scan_job_get_type (void)
{
	static volatile gsize scan_job_type_id__once = 0;
	if (g_once_init_enter (&scan_job_type_id__once)) {
		GType scan_job_type_id;
		scan_job_type_id = scan_job_get_type_once ();
		g_once_init_leave (&scan_job_type_id__once, scan_job_type_id);
	}
	return scan_job_type_id__once;
}

Request*
request_construct (GType object_type)
{
	Request* self = NULL;
	self = (Request*) g_type_create_instance (object_type);
	return self;
}

Request*
request_new (void)
{
	return request_construct (TYPE_REQUEST);
}

static void
value_request_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_request_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		request_unref (value->data[0].v_pointer);
	}
}

static void
value_request_copy_value (const GValue* src_value,
                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = request_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_request_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_request_collect_value (GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Request * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = request_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_request_lcopy_value (const GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	Request ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = request_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_request (const gchar* name,
                    const gchar* nick,
                    const gchar* blurb,
                    GType object_type,
                    GParamFlags flags)
{
	ParamSpecRequest* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_REQUEST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_request (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST), NULL);
	return value->data[0].v_pointer;
}

void
value_set_request (GValue* value,
                   gpointer v_object)
{
	Request * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		request_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		request_unref (old);
	}
}

void
value_take_request (GValue* value,
                    gpointer v_object)
{
	Request * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		request_unref (old);
	}
}

static void
request_class_init (RequestClass * klass,
                    gpointer klass_data)
{
	request_parent_class = g_type_class_peek_parent (klass);
	((RequestClass *) klass)->finalize = request_finalize;
}

static void
request_instance_init (Request * self,
                       gpointer klass)
{
	self->ref_count = 1;
}

static void
request_finalize (Request * obj)
{
	Request * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REQUEST, Request);
	g_signal_handlers_destroy (self);
}

static GType
request_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_request_init, value_request_free_value, value_request_copy_value, value_request_peek_pointer, "p", value_request_collect_value, "p", value_request_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (RequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Request), 0, (GInstanceInitFunc) request_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType request_type_id;
	request_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Request", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return request_type_id;
}

GType
request_get_type (void)
{
	static volatile gsize request_type_id__once = 0;
	if (g_once_init_enter (&request_type_id__once)) {
		GType request_type_id;
		request_type_id = request_get_type_once ();
		g_once_init_leave (&request_type_id__once, request_type_id);
	}
	return request_type_id__once;
}

gpointer
request_ref (gpointer instance)
{
	Request * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
request_unref (gpointer instance)
{
	Request * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		REQUEST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

RequestRedetect*
request_redetect_construct (GType object_type)
{
	RequestRedetect* self = NULL;
	self = (RequestRedetect*) request_construct (object_type);
	return self;
}

RequestRedetect*
request_redetect_new (void)
{
	return request_redetect_construct (TYPE_REQUEST_REDETECT);
}

static void
request_redetect_class_init (RequestRedetectClass * klass,
                             gpointer klass_data)
{
	request_redetect_parent_class = g_type_class_peek_parent (klass);
}

static void
request_redetect_instance_init (RequestRedetect * self,
                                gpointer klass)
{
}

static GType
request_redetect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RequestRedetectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_redetect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestRedetect), 0, (GInstanceInitFunc) request_redetect_instance_init, NULL };
	GType request_redetect_type_id;
	request_redetect_type_id = g_type_register_static (TYPE_REQUEST, "RequestRedetect", &g_define_type_info, 0);
	return request_redetect_type_id;
}

GType
request_redetect_get_type (void)
{
	static volatile gsize request_redetect_type_id__once = 0;
	if (g_once_init_enter (&request_redetect_type_id__once)) {
		GType request_redetect_type_id;
		request_redetect_type_id = request_redetect_get_type_once ();
		g_once_init_leave (&request_redetect_type_id__once, request_redetect_type_id);
	}
	return request_redetect_type_id__once;
}

RequestCancel*
request_cancel_construct (GType object_type)
{
	RequestCancel* self = NULL;
	self = (RequestCancel*) request_construct (object_type);
	return self;
}

RequestCancel*
request_cancel_new (void)
{
	return request_cancel_construct (TYPE_REQUEST_CANCEL);
}

static void
request_cancel_class_init (RequestCancelClass * klass,
                           gpointer klass_data)
{
	request_cancel_parent_class = g_type_class_peek_parent (klass);
}

static void
request_cancel_instance_init (RequestCancel * self,
                              gpointer klass)
{
}

static GType
request_cancel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RequestCancelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_cancel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestCancel), 0, (GInstanceInitFunc) request_cancel_instance_init, NULL };
	GType request_cancel_type_id;
	request_cancel_type_id = g_type_register_static (TYPE_REQUEST, "RequestCancel", &g_define_type_info, 0);
	return request_cancel_type_id;
}

GType
request_cancel_get_type (void)
{
	static volatile gsize request_cancel_type_id__once = 0;
	if (g_once_init_enter (&request_cancel_type_id__once)) {
		GType request_cancel_type_id;
		request_cancel_type_id = request_cancel_get_type_once ();
		g_once_init_leave (&request_cancel_type_id__once, request_cancel_type_id);
	}
	return request_cancel_type_id__once;
}

RequestStartScan*
request_start_scan_construct (GType object_type)
{
	RequestStartScan* self = NULL;
	self = (RequestStartScan*) request_construct (object_type);
	return self;
}

RequestStartScan*
request_start_scan_new (void)
{
	return request_start_scan_construct (TYPE_REQUEST_START_SCAN);
}

static void
request_start_scan_class_init (RequestStartScanClass * klass,
                               gpointer klass_data)
{
	request_start_scan_parent_class = g_type_class_peek_parent (klass);
	((RequestClass *) klass)->finalize = request_start_scan_finalize;
}

static void
request_start_scan_instance_init (RequestStartScan * self,
                                  gpointer klass)
{
}

static void
request_start_scan_finalize (Request * obj)
{
	RequestStartScan * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REQUEST_START_SCAN, RequestStartScan);
	_g_object_unref0 (self->job);
	REQUEST_CLASS (request_start_scan_parent_class)->finalize (obj);
}

static GType
request_start_scan_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RequestStartScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_start_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestStartScan), 0, (GInstanceInitFunc) request_start_scan_instance_init, NULL };
	GType request_start_scan_type_id;
	request_start_scan_type_id = g_type_register_static (TYPE_REQUEST, "RequestStartScan", &g_define_type_info, 0);
	return request_start_scan_type_id;
}

GType
request_start_scan_get_type (void)
{
	static volatile gsize request_start_scan_type_id__once = 0;
	if (g_once_init_enter (&request_start_scan_type_id__once)) {
		GType request_start_scan_type_id;
		request_start_scan_type_id = request_start_scan_get_type_once ();
		g_once_init_leave (&request_start_scan_type_id__once, request_start_scan_type_id);
	}
	return request_start_scan_type_id__once;
}

RequestQuit*
request_quit_construct (GType object_type)
{
	RequestQuit* self = NULL;
	self = (RequestQuit*) request_construct (object_type);
	return self;
}

RequestQuit*
request_quit_new (void)
{
	return request_quit_construct (TYPE_REQUEST_QUIT);
}

static void
request_quit_class_init (RequestQuitClass * klass,
                         gpointer klass_data)
{
	request_quit_parent_class = g_type_class_peek_parent (klass);
}

static void
request_quit_instance_init (RequestQuit * self,
                            gpointer klass)
{
}

static GType
request_quit_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RequestQuitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_quit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestQuit), 0, (GInstanceInitFunc) request_quit_instance_init, NULL };
	GType request_quit_type_id;
	request_quit_type_id = g_type_register_static (TYPE_REQUEST, "RequestQuit", &g_define_type_info, 0);
	return request_quit_type_id;
}

GType
request_quit_get_type (void)
{
	static volatile gsize request_quit_type_id__once = 0;
	if (g_once_init_enter (&request_quit_type_id__once)) {
		GType request_quit_type_id;
		request_quit_type_id = request_quit_get_type_once ();
		g_once_init_leave (&request_quit_type_id__once, request_quit_type_id);
	}
	return request_quit_type_id__once;
}

Credentials*
credentials_construct (GType object_type)
{
	Credentials* self = NULL;
	self = (Credentials*) g_type_create_instance (object_type);
	return self;
}

Credentials*
credentials_new (void)
{
	return credentials_construct (TYPE_CREDENTIALS);
}

static void
value_credentials_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_credentials_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		credentials_unref (value->data[0].v_pointer);
	}
}

static void
value_credentials_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = credentials_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_credentials_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_credentials_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Credentials * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = credentials_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_credentials_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	Credentials ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = credentials_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_credentials (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecCredentials* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CREDENTIALS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_credentials (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_credentials (GValue* value,
                       gpointer v_object)
{
	Credentials * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		credentials_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		credentials_unref (old);
	}
}

void
value_take_credentials (GValue* value,
                        gpointer v_object)
{
	Credentials * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		credentials_unref (old);
	}
}

static void
credentials_class_init (CredentialsClass * klass,
                        gpointer klass_data)
{
	credentials_parent_class = g_type_class_peek_parent (klass);
	((CredentialsClass *) klass)->finalize = credentials_finalize;
}

static void
credentials_instance_init (Credentials * self,
                           gpointer klass)
{
	self->ref_count = 1;
}

static void
credentials_finalize (Credentials * obj)
{
	Credentials * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CREDENTIALS, Credentials);
	g_signal_handlers_destroy (self);
	_g_free0 (self->username);
	_g_free0 (self->password);
}

static GType
credentials_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_credentials_init, value_credentials_free_value, value_credentials_copy_value, value_credentials_peek_pointer, "p", value_credentials_collect_value, "p", value_credentials_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CredentialsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) credentials_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Credentials), 0, (GInstanceInitFunc) credentials_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType credentials_type_id;
	credentials_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Credentials", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return credentials_type_id;
}

GType
credentials_get_type (void)
{
	static volatile gsize credentials_type_id__once = 0;
	if (g_once_init_enter (&credentials_type_id__once)) {
		GType credentials_type_id;
		credentials_type_id = credentials_get_type_once ();
		g_once_init_leave (&credentials_type_id__once, credentials_type_id);
	}
	return credentials_type_id__once;
}

gpointer
credentials_ref (gpointer instance)
{
	Credentials * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
credentials_unref (gpointer instance)
{
	Credentials * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CREDENTIALS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GType
scan_state_get_type_once (void)
{
	static const GEnumValue values[] = {{SCAN_STATE_IDLE, "SCAN_STATE_IDLE", "idle"}, {SCAN_STATE_REDETECT, "SCAN_STATE_REDETECT", "redetect"}, {SCAN_STATE_OPEN, "SCAN_STATE_OPEN", "open"}, {SCAN_STATE_GET_OPTION, "SCAN_STATE_GET_OPTION", "get-option"}, {SCAN_STATE_START, "SCAN_STATE_START", "start"}, {SCAN_STATE_GET_PARAMETERS, "SCAN_STATE_GET_PARAMETERS", "get-parameters"}, {SCAN_STATE_READ, "SCAN_STATE_READ", "read"}, {0, NULL, NULL}};
	GType scan_state_type_id;
	scan_state_type_id = g_enum_register_static ("ScanState", values);
	return scan_state_type_id;
}

GType
scan_state_get_type (void)
{
	static volatile gsize scan_state_type_id__once = 0;
	if (g_once_init_enter (&scan_state_type_id__once)) {
		GType scan_state_type_id;
		scan_state_type_id = scan_state_get_type_once ();
		g_once_init_leave (&scan_state_type_id__once, scan_state_type_id);
	}
	return scan_state_type_id__once;
}

static void
notify_real_run (Notify* self,
                 Scanner* scanner)
{
	g_return_if_fail (scanner != NULL);
}

void
notify_run (Notify* self,
            Scanner* scanner)
{
	NotifyClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NOTIFY_GET_CLASS (self);
	if (_klass_->run) {
		_klass_->run (self, scanner);
	}
}

Notify*
notify_construct (GType object_type)
{
	Notify* self = NULL;
	self = (Notify*) g_type_create_instance (object_type);
	return self;
}

Notify*
notify_new (void)
{
	return notify_construct (TYPE_NOTIFY);
}

static void
value_notify_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_notify_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		notify_unref (value->data[0].v_pointer);
	}
}

static void
value_notify_copy_value (const GValue* src_value,
                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = notify_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_notify_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_notify_collect_value (GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Notify * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = notify_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_notify_lcopy_value (const GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	Notify ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = notify_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_notify (const gchar* name,
                   const gchar* nick,
                   const gchar* blurb,
                   GType object_type,
                   GParamFlags flags)
{
	ParamSpecNotify* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NOTIFY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_notify (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY), NULL);
	return value->data[0].v_pointer;
}

void
value_set_notify (GValue* value,
                  gpointer v_object)
{
	Notify * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		notify_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		notify_unref (old);
	}
}

void
value_take_notify (GValue* value,
                   gpointer v_object)
{
	Notify * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		notify_unref (old);
	}
}

static void
notify_class_init (NotifyClass * klass,
                   gpointer klass_data)
{
	notify_parent_class = g_type_class_peek_parent (klass);
	((NotifyClass *) klass)->finalize = notify_finalize;
	((NotifyClass *) klass)->run = (void (*) (Notify*, Scanner*)) notify_real_run;
}

static void
notify_instance_init (Notify * self,
                      gpointer klass)
{
	self->ref_count = 1;
}

static void
notify_finalize (Notify * obj)
{
	Notify * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY, Notify);
	g_signal_handlers_destroy (self);
}

static GType
notify_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_notify_init, value_notify_free_value, value_notify_copy_value, value_notify_peek_pointer, "p", value_notify_collect_value, "p", value_notify_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NotifyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Notify), 0, (GInstanceInitFunc) notify_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType notify_type_id;
	notify_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Notify", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return notify_type_id;
}

GType
notify_get_type (void)
{
	static volatile gsize notify_type_id__once = 0;
	if (g_once_init_enter (&notify_type_id__once)) {
		GType notify_type_id;
		notify_type_id = notify_get_type_once ();
		g_once_init_leave (&notify_type_id__once, notify_type_id);
	}
	return notify_type_id__once;
}

gpointer
notify_ref (gpointer instance)
{
	Notify * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
notify_unref (gpointer instance)
{
	Notify * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NOTIFY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
notify_scanning_changed_real_run (Notify* base,
                                  Scanner* scanner)
{
	NotifyScanningChanged * self;
	self = (NotifyScanningChanged*) base;
	g_return_if_fail (scanner != NULL);
	g_signal_emit (scanner, scanner_signals[SCANNER_SCANNING_CHANGED_SIGNAL], 0);
}

NotifyScanningChanged*
notify_scanning_changed_construct (GType object_type)
{
	NotifyScanningChanged* self = NULL;
	self = (NotifyScanningChanged*) notify_construct (object_type);
	return self;
}

NotifyScanningChanged*
notify_scanning_changed_new (void)
{
	return notify_scanning_changed_construct (TYPE_NOTIFY_SCANNING_CHANGED);
}

static void
notify_scanning_changed_class_init (NotifyScanningChangedClass * klass,
                                    gpointer klass_data)
{
	notify_scanning_changed_parent_class = g_type_class_peek_parent (klass);
	((NotifyClass *) klass)->run = (void (*) (Notify*, Scanner*)) notify_scanning_changed_real_run;
}

static void
notify_scanning_changed_instance_init (NotifyScanningChanged * self,
                                       gpointer klass)
{
}

static GType
notify_scanning_changed_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotifyScanningChangedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scanning_changed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanningChanged), 0, (GInstanceInitFunc) notify_scanning_changed_instance_init, NULL };
	GType notify_scanning_changed_type_id;
	notify_scanning_changed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanningChanged", &g_define_type_info, 0);
	return notify_scanning_changed_type_id;
}

GType
notify_scanning_changed_get_type (void)
{
	static volatile gsize notify_scanning_changed_type_id__once = 0;
	if (g_once_init_enter (&notify_scanning_changed_type_id__once)) {
		GType notify_scanning_changed_type_id;
		notify_scanning_changed_type_id = notify_scanning_changed_get_type_once ();
		g_once_init_leave (&notify_scanning_changed_type_id__once, notify_scanning_changed_type_id);
	}
	return notify_scanning_changed_type_id__once;
}

static inline gpointer
notify_update_devices_get_instance_private (NotifyUpdateDevices* self)
{
	return G_STRUCT_MEMBER_P (self, NotifyUpdateDevices_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

NotifyUpdateDevices*
notify_update_devices_construct (GType object_type,
                                 GList* devices)
{
	NotifyUpdateDevices* self = NULL;
	GList* _tmp0_;
	self = (NotifyUpdateDevices*) notify_construct (object_type);
	_tmp0_ = devices;
	devices = NULL;
	(self->priv->devices == NULL) ? NULL : (self->priv->devices = (_g_list_free__g_object_unref0_ (self->priv->devices), NULL));
	self->priv->devices = _tmp0_;
	(devices == NULL) ? NULL : (devices = (_g_list_free__g_object_unref0_ (devices), NULL));
	return self;
}

NotifyUpdateDevices*
notify_update_devices_new (GList* devices)
{
	return notify_update_devices_construct (TYPE_NOTIFY_UPDATE_DEVICES, devices);
}

static void
notify_update_devices_real_run (Notify* base,
                                Scanner* scanner)
{
	NotifyUpdateDevices * self;
	GList* _tmp0_;
	self = (NotifyUpdateDevices*) base;
	g_return_if_fail (scanner != NULL);
	_tmp0_ = self->priv->devices;
	g_signal_emit (scanner, scanner_signals[SCANNER_UPDATE_DEVICES_SIGNAL], 0, _tmp0_);
}

static void
notify_update_devices_class_init (NotifyUpdateDevicesClass * klass,
                                  gpointer klass_data)
{
	notify_update_devices_parent_class = g_type_class_peek_parent (klass);
	((NotifyClass *) klass)->finalize = notify_update_devices_finalize;
	g_type_class_adjust_private_offset (klass, &NotifyUpdateDevices_private_offset);
	((NotifyClass *) klass)->run = (void (*) (Notify*, Scanner*)) notify_update_devices_real_run;
}

static void
notify_update_devices_instance_init (NotifyUpdateDevices * self,
                                     gpointer klass)
{
	self->priv = notify_update_devices_get_instance_private (self);
}

static void
notify_update_devices_finalize (Notify * obj)
{
	NotifyUpdateDevices * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices);
	(self->priv->devices == NULL) ? NULL : (self->priv->devices = (_g_list_free__g_object_unref0_ (self->priv->devices), NULL));
	NOTIFY_CLASS (notify_update_devices_parent_class)->finalize (obj);
}

static GType
notify_update_devices_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotifyUpdateDevicesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_update_devices_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyUpdateDevices), 0, (GInstanceInitFunc) notify_update_devices_instance_init, NULL };
	GType notify_update_devices_type_id;
	notify_update_devices_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyUpdateDevices", &g_define_type_info, 0);
	NotifyUpdateDevices_private_offset = g_type_add_instance_private (notify_update_devices_type_id, sizeof (NotifyUpdateDevicesPrivate));
	return notify_update_devices_type_id;
}

GType
notify_update_devices_get_type (void)
{
	static volatile gsize notify_update_devices_type_id__once = 0;
	if (g_once_init_enter (&notify_update_devices_type_id__once)) {
		GType notify_update_devices_type_id;
		notify_update_devices_type_id = notify_update_devices_get_type_once ();
		g_once_init_leave (&notify_update_devices_type_id__once, notify_update_devices_type_id);
	}
	return notify_update_devices_type_id__once;
}

static inline gpointer
notify_request_authorization_get_instance_private (NotifyRequestAuthorization* self)
{
	return G_STRUCT_MEMBER_P (self, NotifyRequestAuthorization_private_offset);
}

NotifyRequestAuthorization*
notify_request_authorization_construct (GType object_type,
                                        const gchar* resource)
{
	NotifyRequestAuthorization* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (resource != NULL, NULL);
	self = (NotifyRequestAuthorization*) notify_construct (object_type);
	_tmp0_ = g_strdup (resource);
	_g_free0 (self->priv->resource);
	self->priv->resource = _tmp0_;
	return self;
}

NotifyRequestAuthorization*
notify_request_authorization_new (const gchar* resource)
{
	return notify_request_authorization_construct (TYPE_NOTIFY_REQUEST_AUTHORIZATION, resource);
}

static void
notify_request_authorization_real_run (Notify* base,
                                       Scanner* scanner)
{
	NotifyRequestAuthorization * self;
	const gchar* _tmp0_;
	self = (NotifyRequestAuthorization*) base;
	g_return_if_fail (scanner != NULL);
	_tmp0_ = self->priv->resource;
	g_signal_emit (scanner, scanner_signals[SCANNER_REQUEST_AUTHORIZATION_SIGNAL], 0, _tmp0_);
}

static void
notify_request_authorization_class_init (NotifyRequestAuthorizationClass * klass,
                                         gpointer klass_data)
{
	notify_request_authorization_parent_class = g_type_class_peek_parent (klass);
	((NotifyClass *) klass)->finalize = notify_request_authorization_finalize;
	g_type_class_adjust_private_offset (klass, &NotifyRequestAuthorization_private_offset);
	((NotifyClass *) klass)->run = (void (*) (Notify*, Scanner*)) notify_request_authorization_real_run;
}

static void
notify_request_authorization_instance_init (NotifyRequestAuthorization * self,
                                            gpointer klass)
{
	self->priv = notify_request_authorization_get_instance_private (self);
}

static void
notify_request_authorization_finalize (Notify * obj)
{
	NotifyRequestAuthorization * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization);
	_g_free0 (self->priv->resource);
	NOTIFY_CLASS (notify_request_authorization_parent_class)->finalize (obj);
}

static GType
notify_request_authorization_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotifyRequestAuthorizationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_request_authorization_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyRequestAuthorization), 0, (GInstanceInitFunc) notify_request_authorization_instance_init, NULL };
	GType notify_request_authorization_type_id;
	notify_request_authorization_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyRequestAuthorization", &g_define_type_info, 0);
	NotifyRequestAuthorization_private_offset = g_type_add_instance_private (notify_request_authorization_type_id, sizeof (NotifyRequestAuthorizationPrivate));
	return notify_request_authorization_type_id;
}

GType
notify_request_authorization_get_type (void)
{
	static volatile gsize notify_request_authorization_type_id__once = 0;
	if (g_once_init_enter (&notify_request_authorization_type_id__once)) {
		GType notify_request_authorization_type_id;
		notify_request_authorization_type_id = notify_request_authorization_get_type_once ();
		g_once_init_leave (&notify_request_authorization_type_id__once, notify_request_authorization_type_id);
	}
	return notify_request_authorization_type_id__once;
}

static inline gpointer
notify_scan_failed_get_instance_private (NotifyScanFailed* self)
{
	return G_STRUCT_MEMBER_P (self, NotifyScanFailed_private_offset);
}

NotifyScanFailed*
notify_scan_failed_construct (GType object_type,
                              gint error_code,
                              const gchar* error_string)
{
	NotifyScanFailed* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (error_string != NULL, NULL);
	self = (NotifyScanFailed*) notify_construct (object_type);
	self->priv->error_code = error_code;
	_tmp0_ = g_strdup (error_string);
	_g_free0 (self->priv->error_string);
	self->priv->error_string = _tmp0_;
	return self;
}

NotifyScanFailed*
notify_scan_failed_new (gint error_code,
                        const gchar* error_string)
{
	return notify_scan_failed_construct (TYPE_NOTIFY_SCAN_FAILED, error_code, error_string);
}

static void
notify_scan_failed_real_run (Notify* base,
                             Scanner* scanner)
{
	NotifyScanFailed * self;
	const gchar* _tmp0_;
	self = (NotifyScanFailed*) base;
	g_return_if_fail (scanner != NULL);
	_tmp0_ = self->priv->error_string;
	g_signal_emit (scanner, scanner_signals[SCANNER_SCAN_FAILED_SIGNAL], 0, self->priv->error_code, _tmp0_);
}

static void
notify_scan_failed_class_init (NotifyScanFailedClass * klass,
                               gpointer klass_data)
{
	notify_scan_failed_parent_class = g_type_class_peek_parent (klass);
	((NotifyClass *) klass)->finalize = notify_scan_failed_finalize;
	g_type_class_adjust_private_offset (klass, &NotifyScanFailed_private_offset);
	((NotifyClass *) klass)->run = (void (*) (Notify*, Scanner*)) notify_scan_failed_real_run;
}

static void
notify_scan_failed_instance_init (NotifyScanFailed * self,
                                  gpointer klass)
{
	self->priv = notify_scan_failed_get_instance_private (self);
}

static void
notify_scan_failed_finalize (Notify * obj)
{
	NotifyScanFailed * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed);
	_g_free0 (self->priv->error_string);
	NOTIFY_CLASS (notify_scan_failed_parent_class)->finalize (obj);
}

static GType
notify_scan_failed_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotifyScanFailedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scan_failed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanFailed), 0, (GInstanceInitFunc) notify_scan_failed_instance_init, NULL };
	GType notify_scan_failed_type_id;
	notify_scan_failed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanFailed", &g_define_type_info, 0);
	NotifyScanFailed_private_offset = g_type_add_instance_private (notify_scan_failed_type_id, sizeof (NotifyScanFailedPrivate));
	return notify_scan_failed_type_id;
}

GType
notify_scan_failed_get_type (void)
{
	static volatile gsize notify_scan_failed_type_id__once = 0;
	if (g_once_init_enter (&notify_scan_failed_type_id__once)) {
		GType notify_scan_failed_type_id;
		notify_scan_failed_type_id = notify_scan_failed_get_type_once ();
		g_once_init_leave (&notify_scan_failed_type_id__once, notify_scan_failed_type_id);
	}
	return notify_scan_failed_type_id__once;
}

static void
notify_document_done_real_run (Notify* base,
                               Scanner* scanner)
{
	NotifyDocumentDone * self;
	self = (NotifyDocumentDone*) base;
	g_return_if_fail (scanner != NULL);
	g_signal_emit (scanner, scanner_signals[SCANNER_DOCUMENT_DONE_SIGNAL], 0);
}

NotifyDocumentDone*
notify_document_done_construct (GType object_type)
{
	NotifyDocumentDone* self = NULL;
	self = (NotifyDocumentDone*) notify_construct (object_type);
	return self;
}

NotifyDocumentDone*
notify_document_done_new (void)
{
	return notify_document_done_construct (TYPE_NOTIFY_DOCUMENT_DONE);
}

static void
notify_document_done_class_init (NotifyDocumentDoneClass * klass,
                                 gpointer klass_data)
{
	notify_document_done_parent_class = g_type_class_peek_parent (klass);
	((NotifyClass *) klass)->run = (void (*) (Notify*, Scanner*)) notify_document_done_real_run;
}

static void
notify_document_done_instance_init (NotifyDocumentDone * self,
                                    gpointer klass)
{
}

static GType
notify_document_done_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotifyDocumentDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_document_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyDocumentDone), 0, (GInstanceInitFunc) notify_document_done_instance_init, NULL };
	GType notify_document_done_type_id;
	notify_document_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyDocumentDone", &g_define_type_info, 0);
	return notify_document_done_type_id;
}

GType
notify_document_done_get_type (void)
{
	static volatile gsize notify_document_done_type_id__once = 0;
	if (g_once_init_enter (&notify_document_done_type_id__once)) {
		GType notify_document_done_type_id;
		notify_document_done_type_id = notify_document_done_get_type_once ();
		g_once_init_leave (&notify_document_done_type_id__once, notify_document_done_type_id);
	}
	return notify_document_done_type_id__once;
}

static void
notify_expect_page_real_run (Notify* base,
                             Scanner* scanner)
{
	NotifyExpectPage * self;
	self = (NotifyExpectPage*) base;
	g_return_if_fail (scanner != NULL);
	g_signal_emit (scanner, scanner_signals[SCANNER_EXPECT_PAGE_SIGNAL], 0);
}

NotifyExpectPage*
notify_expect_page_construct (GType object_type)
{
	NotifyExpectPage* self = NULL;
	self = (NotifyExpectPage*) notify_construct (object_type);
	return self;
}

NotifyExpectPage*
notify_expect_page_new (void)
{
	return notify_expect_page_construct (TYPE_NOTIFY_EXPECT_PAGE);
}

static void
notify_expect_page_class_init (NotifyExpectPageClass * klass,
                               gpointer klass_data)
{
	notify_expect_page_parent_class = g_type_class_peek_parent (klass);
	((NotifyClass *) klass)->run = (void (*) (Notify*, Scanner*)) notify_expect_page_real_run;
}

static void
notify_expect_page_instance_init (NotifyExpectPage * self,
                                  gpointer klass)
{
}

static GType
notify_expect_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotifyExpectPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_expect_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyExpectPage), 0, (GInstanceInitFunc) notify_expect_page_instance_init, NULL };
	GType notify_expect_page_type_id;
	notify_expect_page_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyExpectPage", &g_define_type_info, 0);
	return notify_expect_page_type_id;
}

GType
notify_expect_page_get_type (void)
{
	static volatile gsize notify_expect_page_type_id__once = 0;
	if (g_once_init_enter (&notify_expect_page_type_id__once)) {
		GType notify_expect_page_type_id;
		notify_expect_page_type_id = notify_expect_page_get_type_once ();
		g_once_init_leave (&notify_expect_page_type_id__once, notify_expect_page_type_id);
	}
	return notify_expect_page_type_id__once;
}

static inline gpointer
notify_got_page_info_get_instance_private (NotifyGotPageInfo* self)
{
	return G_STRUCT_MEMBER_P (self, NotifyGotPageInfo_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

NotifyGotPageInfo*
notify_got_page_info_construct (GType object_type,
                                gint job_id,
                                ScanPageInfo* info)
{
	NotifyGotPageInfo* self = NULL;
	ScanPageInfo* _tmp0_;
	g_return_val_if_fail (info != NULL, NULL);
	self = (NotifyGotPageInfo*) notify_construct (object_type);
	self->priv->job_id = job_id;
	_tmp0_ = _g_object_ref0 (info);
	_g_object_unref0 (self->priv->info);
	self->priv->info = _tmp0_;
	return self;
}

NotifyGotPageInfo*
notify_got_page_info_new (gint job_id,
                          ScanPageInfo* info)
{
	return notify_got_page_info_construct (TYPE_NOTIFY_GOT_PAGE_INFO, job_id, info);
}

static void
notify_got_page_info_real_run (Notify* base,
                               Scanner* scanner)
{
	NotifyGotPageInfo * self;
	gboolean _tmp0_ = FALSE;
	self = (NotifyGotPageInfo*) base;
	g_return_if_fail (scanner != NULL);
	if (self->priv->job_id >= scanner->first_job_id) {
		_tmp0_ = self->priv->job_id < scanner->job_id;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ScanPageInfo* _tmp1_;
		_tmp1_ = self->priv->info;
		g_signal_emit (scanner, scanner_signals[SCANNER_GOT_PAGE_INFO_SIGNAL], 0, _tmp1_);
	}
}

static void
notify_got_page_info_class_init (NotifyGotPageInfoClass * klass,
                                 gpointer klass_data)
{
	notify_got_page_info_parent_class = g_type_class_peek_parent (klass);
	((NotifyClass *) klass)->finalize = notify_got_page_info_finalize;
	g_type_class_adjust_private_offset (klass, &NotifyGotPageInfo_private_offset);
	((NotifyClass *) klass)->run = (void (*) (Notify*, Scanner*)) notify_got_page_info_real_run;
}

static void
notify_got_page_info_instance_init (NotifyGotPageInfo * self,
                                    gpointer klass)
{
	self->priv = notify_got_page_info_get_instance_private (self);
}

static void
notify_got_page_info_finalize (Notify * obj)
{
	NotifyGotPageInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo);
	_g_object_unref0 (self->priv->info);
	NOTIFY_CLASS (notify_got_page_info_parent_class)->finalize (obj);
}

static GType
notify_got_page_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotifyGotPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotPageInfo), 0, (GInstanceInitFunc) notify_got_page_info_instance_init, NULL };
	GType notify_got_page_info_type_id;
	notify_got_page_info_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotPageInfo", &g_define_type_info, 0);
	NotifyGotPageInfo_private_offset = g_type_add_instance_private (notify_got_page_info_type_id, sizeof (NotifyGotPageInfoPrivate));
	return notify_got_page_info_type_id;
}

GType
notify_got_page_info_get_type (void)
{
	static volatile gsize notify_got_page_info_type_id__once = 0;
	if (g_once_init_enter (&notify_got_page_info_type_id__once)) {
		GType notify_got_page_info_type_id;
		notify_got_page_info_type_id = notify_got_page_info_get_type_once ();
		g_once_init_leave (&notify_got_page_info_type_id__once, notify_got_page_info_type_id);
	}
	return notify_got_page_info_type_id__once;
}

static inline gpointer
notify_page_done_get_instance_private (NotifyPageDone* self)
{
	return G_STRUCT_MEMBER_P (self, NotifyPageDone_private_offset);
}

NotifyPageDone*
notify_page_done_construct (GType object_type,
                            gint job_id)
{
	NotifyPageDone* self = NULL;
	self = (NotifyPageDone*) notify_construct (object_type);
	self->priv->job_id = job_id;
	return self;
}

NotifyPageDone*
notify_page_done_new (gint job_id)
{
	return notify_page_done_construct (TYPE_NOTIFY_PAGE_DONE, job_id);
}

static void
notify_page_done_real_run (Notify* base,
                           Scanner* scanner)
{
	NotifyPageDone * self;
	gboolean _tmp0_ = FALSE;
	self = (NotifyPageDone*) base;
	g_return_if_fail (scanner != NULL);
	if (self->priv->job_id >= scanner->first_job_id) {
		_tmp0_ = self->priv->job_id < scanner->job_id;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit (scanner, scanner_signals[SCANNER_PAGE_DONE_SIGNAL], 0);
	}
}

static void
notify_page_done_class_init (NotifyPageDoneClass * klass,
                             gpointer klass_data)
{
	notify_page_done_parent_class = g_type_class_peek_parent (klass);
	((NotifyClass *) klass)->finalize = notify_page_done_finalize;
	g_type_class_adjust_private_offset (klass, &NotifyPageDone_private_offset);
	((NotifyClass *) klass)->run = (void (*) (Notify*, Scanner*)) notify_page_done_real_run;
}

static void
notify_page_done_instance_init (NotifyPageDone * self,
                                gpointer klass)
{
	self->priv = notify_page_done_get_instance_private (self);
}

static void
notify_page_done_finalize (Notify * obj)
{
	NotifyPageDone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_PAGE_DONE, NotifyPageDone);
	NOTIFY_CLASS (notify_page_done_parent_class)->finalize (obj);
}

static GType
notify_page_done_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotifyPageDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_page_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyPageDone), 0, (GInstanceInitFunc) notify_page_done_instance_init, NULL };
	GType notify_page_done_type_id;
	notify_page_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyPageDone", &g_define_type_info, 0);
	NotifyPageDone_private_offset = g_type_add_instance_private (notify_page_done_type_id, sizeof (NotifyPageDonePrivate));
	return notify_page_done_type_id;
}

GType
notify_page_done_get_type (void)
{
	static volatile gsize notify_page_done_type_id__once = 0;
	if (g_once_init_enter (&notify_page_done_type_id__once)) {
		GType notify_page_done_type_id;
		notify_page_done_type_id = notify_page_done_get_type_once ();
		g_once_init_leave (&notify_page_done_type_id__once, notify_page_done_type_id);
	}
	return notify_page_done_type_id__once;
}

static inline gpointer
notify_got_line_get_instance_private (NotifyGotLine* self)
{
	return G_STRUCT_MEMBER_P (self, NotifyGotLine_private_offset);
}

NotifyGotLine*
notify_got_line_construct (GType object_type,
                           gint job_id,
                           ScanLine* line)
{
	NotifyGotLine* self = NULL;
	ScanLine* _tmp0_;
	g_return_val_if_fail (line != NULL, NULL);
	self = (NotifyGotLine*) notify_construct (object_type);
	self->priv->job_id = job_id;
	_tmp0_ = _g_object_ref0 (line);
	_g_object_unref0 (self->priv->line);
	self->priv->line = _tmp0_;
	return self;
}

NotifyGotLine*
notify_got_line_new (gint job_id,
                     ScanLine* line)
{
	return notify_got_line_construct (TYPE_NOTIFY_GOT_LINE, job_id, line);
}

static void
notify_got_line_real_run (Notify* base,
                          Scanner* scanner)
{
	NotifyGotLine * self;
	gboolean _tmp0_ = FALSE;
	self = (NotifyGotLine*) base;
	g_return_if_fail (scanner != NULL);
	if (self->priv->job_id >= scanner->first_job_id) {
		_tmp0_ = self->priv->job_id < scanner->job_id;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ScanLine* _tmp1_;
		_tmp1_ = self->priv->line;
		g_signal_emit (scanner, scanner_signals[SCANNER_GOT_LINE_SIGNAL], 0, _tmp1_);
	}
}

static void
notify_got_line_class_init (NotifyGotLineClass * klass,
                            gpointer klass_data)
{
	notify_got_line_parent_class = g_type_class_peek_parent (klass);
	((NotifyClass *) klass)->finalize = notify_got_line_finalize;
	g_type_class_adjust_private_offset (klass, &NotifyGotLine_private_offset);
	((NotifyClass *) klass)->run = (void (*) (Notify*, Scanner*)) notify_got_line_real_run;
}

static void
notify_got_line_instance_init (NotifyGotLine * self,
                               gpointer klass)
{
	self->priv = notify_got_line_get_instance_private (self);
}

static void
notify_got_line_finalize (Notify * obj)
{
	NotifyGotLine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_GOT_LINE, NotifyGotLine);
	_g_object_unref0 (self->priv->line);
	NOTIFY_CLASS (notify_got_line_parent_class)->finalize (obj);
}

static GType
notify_got_line_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotifyGotLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotLine), 0, (GInstanceInitFunc) notify_got_line_instance_init, NULL };
	GType notify_got_line_type_id;
	notify_got_line_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotLine", &g_define_type_info, 0);
	NotifyGotLine_private_offset = g_type_add_instance_private (notify_got_line_type_id, sizeof (NotifyGotLinePrivate));
	return notify_got_line_type_id;
}

GType
notify_got_line_get_type (void)
{
	static volatile gsize notify_got_line_type_id__once = 0;
	if (g_once_init_enter (&notify_got_line_type_id__once)) {
		GType notify_got_line_type_id;
		notify_got_line_type_id = notify_got_line_get_type_once ();
		g_once_init_leave (&notify_got_line_type_id__once, notify_got_line_type_id);
	}
	return notify_got_line_type_id__once;
}

static inline gpointer
scanner_get_instance_private (Scanner* self)
{
	return G_STRUCT_MEMBER_P (self, Scanner_private_offset);
}

static void
_request_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (request_unref (var), NULL));
}

static void
_notify_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (notify_unref (var), NULL));
}

static void
_credentials_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (credentials_unref (var), NULL));
}

static Scanner*
scanner_construct (GType object_type)
{
	Scanner * self = NULL;
	GAsyncQueue* _tmp0_;
	GAsyncQueue* _tmp1_;
	GAsyncQueue* _tmp2_;
	self = (Scanner*) g_object_new (object_type, NULL);
	_tmp0_ = g_async_queue_new_full (_request_unref0_);
	_g_async_queue_unref0 (self->priv->request_queue);
	self->priv->request_queue = _tmp0_;
	_tmp1_ = g_async_queue_new_full (_notify_unref0_);
	_g_async_queue_unref0 (self->priv->notify_queue);
	self->priv->notify_queue = _tmp1_;
	_tmp2_ = g_async_queue_new_full (_credentials_unref0_);
	_g_async_queue_unref0 (self->priv->authorize_queue);
	self->priv->authorize_queue = _tmp2_;
	return self;
}

static Scanner*
scanner_new (void)
{
	return scanner_construct (TYPE_SCANNER);
}

Scanner*
scanner_get_instance (void)
{
	Scanner* _tmp0_;
	Scanner* _tmp2_;
	Scanner* _tmp3_;
	Scanner* result;
	_tmp0_ = scanner_scanner_object;
	if (_tmp0_ == NULL) {
		Scanner* _tmp1_;
		_tmp1_ = scanner_new ();
		_g_object_unref0 (scanner_scanner_object);
		scanner_scanner_object = _tmp1_;
	}
	_tmp2_ = scanner_scanner_object;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gboolean
scanner_notify_idle_cb (Scanner* self)
{
	Notify* notification = NULL;
	GAsyncQueue* _tmp0_;
	gpointer _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->notify_queue;
	_tmp1_ = g_async_queue_pop (_tmp0_);
	notification = (Notify*) _tmp1_;
	notify_run (notification, self);
	result = FALSE;
	_notify_unref0 (notification);
	return result;
}

static gpointer
_notify_ref0 (gpointer self)
{
	return self ? notify_ref (self) : NULL;
}

static gboolean
_scanner_notify_idle_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = scanner_notify_idle_cb ((Scanner*) self);
	return result;
}

static void
scanner_notify_event (Scanner* self,
                      Notify* notification)
{
	GAsyncQueue* _tmp0_;
	Notify* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_tmp0_ = self->priv->notify_queue;
	_tmp1_ = _notify_ref0 (notification);
	g_async_queue_push (_tmp0_, _tmp1_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _scanner_notify_idle_cb_gsource_func, g_object_ref (self), g_object_unref);
}

static void
scanner_set_scanning (Scanner* self,
                      gboolean is_scanning)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->scanning) {
		_tmp1_ = !is_scanning;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (!self->priv->scanning) {
			_tmp2_ = is_scanning;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		NotifyScanningChanged* _tmp3_;
		NotifyScanningChanged* _tmp4_;
		self->priv->scanning = is_scanning;
		_tmp3_ = notify_scanning_changed_new ();
		_tmp4_ = _tmp3_;
		scanner_notify_event (self, (Notify*) _tmp4_);
		_notify_unref0 (_tmp4_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
scanner_get_device_weight (const gchar* device)
{
	gint result;
	g_return_val_if_fail (device != NULL, 0);
	if (g_str_has_prefix (device, "vfl:")) {
		result = 2;
		return result;
	}
	if (string_contains (device, "usb")) {
		result = 0;
		return result;
	}
	result = 1;
	return result;
}

static gint
scanner_compare_devices (ScanDevice* device1,
                         ScanDevice* device2)
{
	gint weight1 = 0;
	const gchar* _tmp0_;
	gint weight2 = 0;
	const gchar* _tmp1_;
	GCompareFunc _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (device1 != NULL, 0);
	g_return_val_if_fail (device2 != NULL, 0);
	_tmp0_ = device1->name;
	weight1 = scanner_get_device_weight (_tmp0_);
	_tmp1_ = device2->name;
	weight2 = scanner_get_device_weight (_tmp1_);
	if (weight1 != weight2) {
		result = weight1 - weight2;
		return result;
	}
	_tmp2_ = ((GCompareFunc) g_strcmp0);
	_tmp3_ = device1->label;
	_tmp4_ = device2->label;
	result = _tmp2_ (_tmp3_, _tmp4_);
	return result;
}

static gchar*
sane_status_to_string (SANE_Status status)
{
	gchar* result;
	switch (status) {
		case SANE_STATUS_GOOD:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("SANE_STATUS_GOOD");
			result = _tmp0_;
			return result;
		}
		case SANE_STATUS_UNSUPPORTED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("SANE_STATUS_UNSUPPORTED");
			result = _tmp1_;
			return result;
		}
		case SANE_STATUS_CANCELLED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("SANE_STATUS_CANCELLED");
			result = _tmp2_;
			return result;
		}
		case SANE_STATUS_DEVICE_BUSY:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("SANE_STATUS_DEVICE_BUSY");
			result = _tmp3_;
			return result;
		}
		case SANE_STATUS_INVAL:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("SANE_STATUS_INVAL");
			result = _tmp4_;
			return result;
		}
		case SANE_STATUS_EOF:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("SANE_STATUS_EOF");
			result = _tmp5_;
			return result;
		}
		case SANE_STATUS_JAMMED:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("SANE_STATUS_JAMMED");
			result = _tmp6_;
			return result;
		}
		case SANE_STATUS_NO_DOCS:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("SANE_STATUS_NO_DOCS");
			result = _tmp7_;
			return result;
		}
		case SANE_STATUS_COVER_OPEN:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("SANE_STATUS_COVER_OPEN");
			result = _tmp8_;
			return result;
		}
		case SANE_STATUS_IO_ERROR:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("SANE_STATUS_IO_ERROR");
			result = _tmp9_;
			return result;
		}
		case SANE_STATUS_NO_MEM:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("SANE_STATUS_NO_MEM");
			result = _tmp10_;
			return result;
		}
		case SANE_STATUS_ACCESS_DENIED:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("SANE_STATUS_ACCESS_DENIED");
			result = _tmp11_;
			return result;
		}
		default:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup_printf ("SANE_STATUS(%d)", (gint) status);
			result = _tmp12_;
			return result;
		}
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
_scanner_compare_devices_gcompare_func (gconstpointer a,
                                        gconstpointer b)
{
	gint result;
	result = scanner_compare_devices ((ScanDevice*) a, (ScanDevice*) b);
	return result;
}

static void
scanner_do_redetect (Scanner* self)
{
	SANE_Device** device_list = NULL;
	gint device_list_length1;
	gint _device_list_size_;
	SANE_Status status = 0;
	SANE_Device** _tmp0_ = NULL;
	SANE_Status _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GHashTable* seen = NULL;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	GList* devices = NULL;
	GList* _tmp100_;
	GList* _tmp107_;
	NotifyUpdateDevices* _tmp108_;
	NotifyUpdateDevices* _tmp109_;
	g_return_if_fail (self != NULL);
	device_list = NULL;
	device_list_length1 = 0;
	_device_list_size_ = device_list_length1;
	_tmp1_ = sane_get_devices (&_tmp0_, FALSE);
	device_list = _tmp0_;
	device_list_length1 = -1;
	_device_list_size_ = device_list_length1;
	status = _tmp1_;
	_tmp2_ = sane_status_to_string (status);
	_tmp3_ = _tmp2_;
	g_debug ("scanner.vala:348: sane_get_devices () -> %s", _tmp3_);
	_g_free0 (_tmp3_);
	if (status != SANE_STATUS_GOOD) {
		const gchar* _tmp4_;
		_tmp4_ = sane_strstatus (status);
		g_warning ("scanner.vala:351: Unable to get SANE devices: %s", _tmp4_);
		self->priv->need_redetect = FALSE;
		self->priv->state = SCAN_STATE_IDLE;
		return;
	}
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, NULL);
	seen = _tmp7_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				SANE_Device** _tmp10_;
				gint _tmp10__length1;
				SANE_Device* _tmp11_;
				GHashTable* _tmp12_;
				SANE_Device** _tmp13_;
				gint _tmp13__length1;
				SANE_Device* _tmp14_;
				const gchar* _tmp15_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = device_list;
				_tmp10__length1 = device_list_length1;
				_tmp11_ = _tmp10_[i];
				if (!(_tmp11_ != NULL)) {
					break;
				}
				_tmp12_ = seen;
				_tmp13_ = device_list;
				_tmp13__length1 = device_list_length1;
				_tmp14_ = _tmp13_[i];
				_tmp15_ = _tmp14_->model;
				if (g_hash_table_contains (_tmp12_, _tmp15_)) {
					GHashTable* _tmp16_;
					SANE_Device** _tmp17_;
					gint _tmp17__length1;
					SANE_Device* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					GHashTable* _tmp21_;
					SANE_Device** _tmp22_;
					gint _tmp22__length1;
					SANE_Device* _tmp23_;
					const gchar* _tmp24_;
					gconstpointer _tmp25_;
					_tmp16_ = seen;
					_tmp17_ = device_list;
					_tmp17__length1 = device_list_length1;
					_tmp18_ = _tmp17_[i];
					_tmp19_ = _tmp18_->model;
					_tmp20_ = g_strdup (_tmp19_);
					_tmp21_ = seen;
					_tmp22_ = device_list;
					_tmp22__length1 = device_list_length1;
					_tmp23_ = _tmp22_[i];
					_tmp24_ = _tmp23_->model;
					_tmp25_ = g_hash_table_lookup (_tmp21_, _tmp24_);
					g_hash_table_insert (_tmp16_, _tmp20_, (gpointer) ((gintptr) (((gint) ((gintptr) _tmp25_)) + 1)));
				} else {
					GHashTable* _tmp26_;
					SANE_Device** _tmp27_;
					gint _tmp27__length1;
					SANE_Device* _tmp28_;
					const gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp26_ = seen;
					_tmp27_ = device_list;
					_tmp27__length1 = device_list_length1;
					_tmp28_ = _tmp27_[i];
					_tmp29_ = _tmp28_->model;
					_tmp30_ = g_strdup (_tmp29_);
					g_hash_table_insert (_tmp26_, _tmp30_, (gpointer) ((gintptr) 1));
				}
			}
		}
	}
	devices = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = TRUE;
			while (TRUE) {
				SANE_Device** _tmp33_;
				gint _tmp33__length1;
				SANE_Device* _tmp34_;
				SANE_Device** _tmp35_;
				gint _tmp35__length1;
				SANE_Device* _tmp36_;
				const gchar* _tmp37_;
				SANE_Device** _tmp38_;
				gint _tmp38__length1;
				SANE_Device* _tmp39_;
				const gchar* _tmp40_;
				SANE_Device** _tmp41_;
				gint _tmp41__length1;
				SANE_Device* _tmp42_;
				const gchar* _tmp43_;
				SANE_Device** _tmp44_;
				gint _tmp44__length1;
				SANE_Device* _tmp45_;
				const gchar* _tmp46_;
				SANE_Device** _tmp47_;
				gint _tmp47__length1;
				SANE_Device* _tmp48_;
				const gchar* _tmp49_;
				ScanDevice* scan_device = NULL;
				ScanDevice* _tmp50_;
				ScanDevice* _tmp51_;
				SANE_Device** _tmp52_;
				gint _tmp52__length1;
				SANE_Device* _tmp53_;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* vendor = NULL;
				SANE_Device** _tmp56_;
				gint _tmp56__length1;
				SANE_Device* _tmp57_;
				const gchar* _tmp58_;
				gchar* _tmp59_;
				const gchar* _tmp60_;
				SANE_Device** _tmp62_;
				gint _tmp62__length1;
				SANE_Device* _tmp63_;
				const gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				const gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gboolean _tmp70_;
				ScanDevice* _tmp82_;
				ScanDevice* _tmp83_;
				const gchar* _tmp84_;
				gchar* _tmp85_;
				GHashTable* _tmp86_;
				SANE_Device** _tmp87_;
				gint _tmp87__length1;
				SANE_Device* _tmp88_;
				const gchar* _tmp89_;
				gconstpointer _tmp90_;
				ScanDevice* _tmp98_;
				ScanDevice* _tmp99_;
				if (!_tmp31_) {
					gint _tmp32_;
					_tmp32_ = i;
					i = _tmp32_ + 1;
				}
				_tmp31_ = FALSE;
				_tmp33_ = device_list;
				_tmp33__length1 = device_list_length1;
				_tmp34_ = _tmp33_[i];
				if (!(_tmp34_ != NULL)) {
					break;
				}
				_tmp35_ = device_list;
				_tmp35__length1 = device_list_length1;
				_tmp36_ = _tmp35_[i];
				_tmp37_ = _tmp36_->type;
				if (g_strcmp0 (_tmp37_, "virtual device") == 0) {
					continue;
				}
				_tmp38_ = device_list;
				_tmp38__length1 = device_list_length1;
				_tmp39_ = _tmp38_[i];
				_tmp40_ = _tmp39_->name;
				_tmp41_ = device_list;
				_tmp41__length1 = device_list_length1;
				_tmp42_ = _tmp41_[i];
				_tmp43_ = _tmp42_->vendor;
				_tmp44_ = device_list;
				_tmp44__length1 = device_list_length1;
				_tmp45_ = _tmp44_[i];
				_tmp46_ = _tmp45_->model;
				_tmp47_ = device_list;
				_tmp47__length1 = device_list_length1;
				_tmp48_ = _tmp47_[i];
				_tmp49_ = _tmp48_->type;
				g_debug ("scanner.vala:374: Device: name=\"%s\" vendor=\"%s\" model=\"%s\" type=" \
"\"%s\"", _tmp40_, _tmp43_, _tmp46_, _tmp49_);
				_tmp50_ = scan_device_new ();
				scan_device = _tmp50_;
				_tmp51_ = scan_device;
				_tmp52_ = device_list;
				_tmp52__length1 = device_list_length1;
				_tmp53_ = _tmp52_[i];
				_tmp54_ = _tmp53_->name;
				_tmp55_ = g_strdup (_tmp54_);
				_g_free0 (_tmp51_->name);
				_tmp51_->name = _tmp55_;
				_tmp56_ = device_list;
				_tmp56__length1 = device_list_length1;
				_tmp57_ = _tmp56_[i];
				_tmp58_ = _tmp57_->vendor;
				_tmp59_ = g_strdup (_tmp58_);
				vendor = _tmp59_;
				_tmp60_ = vendor;
				if (g_strcmp0 (_tmp60_, "Hewlett-Packard") == 0) {
					gchar* _tmp61_;
					_tmp61_ = g_strdup ("HP");
					_g_free0 (vendor);
					vendor = _tmp61_;
				}
				_tmp62_ = device_list;
				_tmp62__length1 = device_list_length1;
				_tmp63_ = _tmp62_[i];
				_tmp64_ = _tmp63_->model;
				_tmp65_ = g_utf8_strdown (_tmp64_, (gssize) -1);
				_tmp66_ = _tmp65_;
				_tmp67_ = vendor;
				_tmp68_ = g_utf8_strdown (_tmp67_, (gssize) -1);
				_tmp69_ = _tmp68_;
				_tmp70_ = g_str_has_prefix (_tmp66_, _tmp69_);
				_g_free0 (_tmp69_);
				_g_free0 (_tmp66_);
				if (_tmp70_) {
					ScanDevice* _tmp71_;
					SANE_Device** _tmp72_;
					gint _tmp72__length1;
					SANE_Device* _tmp73_;
					const gchar* _tmp74_;
					gchar* _tmp75_;
					_tmp71_ = scan_device;
					_tmp72_ = device_list;
					_tmp72__length1 = device_list_length1;
					_tmp73_ = _tmp72_[i];
					_tmp74_ = _tmp73_->model;
					_tmp75_ = g_strdup (_tmp74_);
					_g_free0 (_tmp71_->label);
					_tmp71_->label = _tmp75_;
				} else {
					ScanDevice* _tmp76_;
					const gchar* _tmp77_;
					SANE_Device** _tmp78_;
					gint _tmp78__length1;
					SANE_Device* _tmp79_;
					const gchar* _tmp80_;
					gchar* _tmp81_;
					_tmp76_ = scan_device;
					_tmp77_ = vendor;
					_tmp78_ = device_list;
					_tmp78__length1 = device_list_length1;
					_tmp79_ = _tmp78_[i];
					_tmp80_ = _tmp79_->model;
					_tmp81_ = g_strdup_printf ("%s %s", _tmp77_, _tmp80_);
					_g_free0 (_tmp76_->label);
					_tmp76_->label = _tmp81_;
				}
				_tmp82_ = scan_device;
				_tmp83_ = scan_device;
				_tmp84_ = _tmp83_->label;
				_tmp85_ = string_replace (_tmp84_, "_", " ");
				_g_free0 (_tmp82_->label);
				_tmp82_->label = _tmp85_;
				_tmp86_ = seen;
				_tmp87_ = device_list;
				_tmp87__length1 = device_list_length1;
				_tmp88_ = _tmp87_[i];
				_tmp89_ = _tmp88_->model;
				_tmp90_ = g_hash_table_lookup (_tmp86_, _tmp89_);
				if (((gint) ((gintptr) _tmp90_)) > 1) {
					ScanDevice* _tmp91_;
					ScanDevice* _tmp92_;
					const gchar* _tmp93_;
					SANE_Device** _tmp94_;
					gint _tmp94__length1;
					SANE_Device* _tmp95_;
					const gchar* _tmp96_;
					gchar* _tmp97_;
					_tmp91_ = scan_device;
					_tmp92_ = scan_device;
					_tmp93_ = _tmp92_->label;
					_tmp94_ = device_list;
					_tmp94__length1 = device_list_length1;
					_tmp95_ = _tmp94_[i];
					_tmp96_ = _tmp95_->name;
					_tmp97_ = g_strdup_printf ("%s on %s", _tmp93_, _tmp96_);
					_g_free0 (_tmp91_->label);
					_tmp91_->label = _tmp97_;
				}
				_tmp98_ = scan_device;
				_tmp99_ = _g_object_ref0 (_tmp98_);
				devices = g_list_append (devices, _tmp99_);
				_g_free0 (vendor);
				_g_object_unref0 (scan_device);
			}
		}
	}
	devices = g_list_sort (devices, _scanner_compare_devices_gcompare_func);
	self->priv->need_redetect = FALSE;
	self->priv->state = SCAN_STATE_IDLE;
	_tmp100_ = devices;
	if (_tmp100_ != NULL) {
		ScanDevice* device = NULL;
		GList* _tmp101_;
		gconstpointer _tmp102_;
		ScanDevice* _tmp103_;
		ScanDevice* _tmp104_;
		const gchar* _tmp105_;
		gchar* _tmp106_;
		_tmp101_ = devices;
		_tmp102_ = g_list_nth_data (_tmp101_, (guint) 0);
		_tmp103_ = _g_object_ref0 ((ScanDevice*) _tmp102_);
		device = _tmp103_;
		_tmp104_ = device;
		_tmp105_ = _tmp104_->name;
		_tmp106_ = g_strdup (_tmp105_);
		_g_free0 (self->priv->default_device);
		self->priv->default_device = _tmp106_;
		_g_object_unref0 (device);
	} else {
		_g_free0 (self->priv->default_device);
		self->priv->default_device = NULL;
	}
	_tmp107_ = devices;
	devices = NULL;
	_tmp108_ = notify_update_devices_new (_tmp107_);
	_tmp109_ = _tmp108_;
	scanner_notify_event (self, (Notify*) _tmp109_);
	_notify_unref0 (_tmp109_);
	(devices == NULL) ? NULL : (devices = (_g_list_free__g_object_unref0_ (devices), NULL));
	_g_hash_table_unref0 (seen);
}

static gdouble
scanner_scale_fixed (Scanner* self,
                     gint source_min,
                     gint source_max,
                     SANE_Option_Descriptor* option,
                     gint value)
{
	gdouble v = 0.0;
	gboolean _tmp0_ = FALSE;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (option != NULL, 0.0);
	v = (gdouble) value;
	g_return_val_if_fail (option->type == SANE_TYPE_FIXED, value);
	if (option->constraint_type == SANE_CONSTRAINT_RANGE) {
		SANE_Range* _tmp1_;
		SANE_Range* _tmp2_;
		_tmp1_ = option->constraint.range;
		_tmp2_ = option->constraint.range;
		_tmp0_ = _tmp1_->max != _tmp2_->min;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SANE_Range* _tmp3_;
		SANE_Range* _tmp4_;
		SANE_Range* _tmp5_;
		SANE_Range* _tmp6_;
		SANE_Range* _tmp7_;
		v -= (gdouble) source_min;
		_tmp3_ = option->constraint.range;
		_tmp4_ = option->constraint.range;
		v *= SANE_UNFIX ((SANE_Fixed) _tmp3_->max) - SANE_UNFIX ((SANE_Fixed) _tmp4_->min);
		v /= (gdouble) (source_max - source_min);
		_tmp5_ = option->constraint.range;
		v += SANE_UNFIX ((SANE_Fixed) _tmp5_->min);
		_tmp6_ = option->constraint.range;
		_tmp7_ = option->constraint.range;
		g_debug ("scanner.vala:430: scale_fixed: scaling %d [min: %d, max: %d] to %f [mi" \
"n: %f, max: %f]", value, source_min, source_max, v, SANE_UNFIX ((SANE_Fixed) _tmp6_->min), SANE_UNFIX ((SANE_Fixed) _tmp7_->max));
	}
	result = v;
	return result;
}

static gint
scanner_scale_int (Scanner* self,
                   gint source_min,
                   gint source_max,
                   SANE_Option_Descriptor* option,
                   gint value)
{
	gint v = 0;
	gboolean _tmp0_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (option != NULL, 0);
	v = value;
	g_return_val_if_fail (option->type == SANE_TYPE_INT, value);
	if (option->constraint_type == SANE_CONSTRAINT_RANGE) {
		SANE_Range* _tmp1_;
		SANE_Range* _tmp2_;
		_tmp1_ = option->constraint.range;
		_tmp2_ = option->constraint.range;
		_tmp0_ = _tmp1_->max != _tmp2_->min;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SANE_Range* _tmp3_;
		SANE_Range* _tmp4_;
		SANE_Range* _tmp5_;
		SANE_Range* _tmp6_;
		SANE_Range* _tmp7_;
		v -= source_min;
		_tmp3_ = option->constraint.range;
		_tmp4_ = option->constraint.range;
		v *= (gint) (_tmp3_->max - _tmp4_->min);
		v /= source_max - source_min;
		_tmp5_ = option->constraint.range;
		v += (gint) _tmp5_->min;
		_tmp6_ = option->constraint.range;
		_tmp7_ = option->constraint.range;
		g_debug ("scanner.vala:449: scale_int: scaling %d [min: %d, max: %d] to %d [min:" \
" %d, max: %d]", value, source_min, source_max, v, (gint) _tmp6_->min, (gint) _tmp7_->max);
	}
	result = v;
	return result;
}

static gboolean
scanner_set_default_option (Scanner* self,
                            SANE_Handle handle,
                            SANE_Option_Descriptor* option,
                            SANE_Int option_index)
{
	SANE_Status status = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (option != NULL, FALSE);
	if ((option->cap & SANE_CAP_AUTOMATIC) == ((SANE_Int) 0)) {
		result = FALSE;
		return result;
	}
	status = sane_control_option (handle, option_index, SANE_ACTION_SET_AUTO, NULL, NULL);
	_tmp0_ = option->name;
	_tmp1_ = sane_status_to_string (status);
	_tmp2_ = _tmp1_;
	g_debug ("scanner.vala:463: sane_control_option (%d, SANE_ACTION_SET_AUTO, %s=au" \
"to) -> %s", (gint) option_index, _tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	if (status != SANE_STATUS_GOOD) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = option->name;
		_tmp4_ = sane_strstatus (status);
		g_warning ("scanner.vala:465: Error setting default option %s: %s", _tmp3_, _tmp4_);
	}
	result = status == SANE_STATUS_GOOD;
	return result;
}

static void
scanner_set_bool_option (Scanner* self,
                         SANE_Handle handle,
                         SANE_Option_Descriptor* option,
                         SANE_Int option_index,
                         gboolean value,
                         gboolean* _result_)
{
	gboolean _vala__result_ = FALSE;
	SANE_Bool v = {0};
	SANE_Status status = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	g_return_if_fail (option->type == SANE_TYPE_BOOL);
	v = (SANE_Bool) value;
	status = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, &v, NULL);
	_vala__result_ = (gboolean) v;
	if (value) {
		_tmp0_ = "SANE_TRUE";
	} else {
		_tmp0_ = "SANE_FALSE";
	}
	if (_vala__result_) {
		_tmp1_ = "SANE_TRUE";
	} else {
		_tmp1_ = "SANE_FALSE";
	}
	_tmp2_ = option->name;
	_tmp3_ = sane_status_to_string (status);
	_tmp4_ = _tmp3_;
	g_debug ("scanner.vala:477: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s=%" \
"s) -> (%s, %s)", (gint) option_index, _tmp2_, _tmp0_, _tmp4_, _tmp1_);
	_g_free0 (_tmp4_);
	if (_result_) {
		*_result_ = _vala__result_;
	}
}

static void
scanner_set_int_option (Scanner* self,
                        SANE_Handle handle,
                        SANE_Option_Descriptor* option,
                        SANE_Int option_index,
                        gint value,
                        gint* _result_)
{
	gint _vala__result_ = 0;
	SANE_Int v = {0};
	SANE_Status status = 0;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	g_return_if_fail (option->type == SANE_TYPE_INT);
	v = (SANE_Int) value;
	if (option->constraint_type == SANE_CONSTRAINT_RANGE) {
		SANE_Range* _tmp0_;
		SANE_Range* _tmp2_;
		SANE_Range* _tmp4_;
		_tmp0_ = option->constraint.range;
		if (_tmp0_->quant != ((SANE_Word) 0)) {
			SANE_Range* _tmp1_;
			_tmp1_ = option->constraint.range;
			v *= (SANE_Int) _tmp1_->quant;
		}
		_tmp2_ = option->constraint.range;
		if (v < ((SANE_Int) _tmp2_->min)) {
			SANE_Range* _tmp3_;
			_tmp3_ = option->constraint.range;
			v = (SANE_Int) _tmp3_->min;
		}
		_tmp4_ = option->constraint.range;
		if (v > ((SANE_Int) _tmp4_->max)) {
			SANE_Range* _tmp5_;
			_tmp5_ = option->constraint.range;
			v = (SANE_Int) _tmp5_->max;
		}
	} else {
		if (option->constraint_type == SANE_CONSTRAINT_WORD_LIST) {
			gint distance = 0;
			gint nearest = 0;
			distance = G_MAXINT;
			nearest = 0;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp6_ = FALSE;
					_tmp6_ = TRUE;
					while (TRUE) {
						SANE_Word* _tmp8_;
						gint _tmp8__length1;
						SANE_Word _tmp9_;
						gint x = 0;
						SANE_Word* _tmp10_;
						gint _tmp10__length1;
						SANE_Word _tmp11_;
						gint d = 0;
						if (!_tmp6_) {
							gint _tmp7_;
							_tmp7_ = i;
							i = _tmp7_ + 1;
						}
						_tmp6_ = FALSE;
						_tmp8_ = option->constraint.word_list;
						_tmp8__length1 = -1;
						_tmp9_ = _tmp8_[0];
						if (!(((SANE_Word) i) < _tmp9_)) {
							break;
						}
						_tmp10_ = option->constraint.word_list;
						_tmp10__length1 = -1;
						_tmp11_ = _tmp10_[i + 1];
						x = (gint) _tmp11_;
						d = (gint) (x - v);
						d = abs (d);
						if (d < distance) {
							distance = d;
							nearest = x;
						}
					}
				}
			}
			v = (SANE_Int) nearest;
		}
	}
	status = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, &v, NULL);
	_tmp12_ = option->name;
	_tmp13_ = sane_status_to_string (status);
	_tmp14_ = _tmp13_;
	g_debug ("scanner.vala:514: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s=%" \
"d) -> (%s, %d)", (gint) option_index, _tmp12_, value, _tmp14_, (gint) v);
	_g_free0 (_tmp14_);
	_vala__result_ = (gint) v;
	if (_result_) {
		*_result_ = _vala__result_;
	}
}

static void
scanner_set_fixed_option (Scanner* self,
                          SANE_Handle handle,
                          SANE_Option_Descriptor* option,
                          SANE_Int option_index,
                          gdouble value,
                          gdouble* _result_)
{
	gdouble _vala__result_ = 0.0;
	gdouble v = 0.0;
	SANE_Fixed v_fixed = {0};
	SANE_Status status = 0;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	v = value;
	g_return_if_fail (option->type == SANE_TYPE_FIXED);
	if (option->constraint_type == SANE_CONSTRAINT_RANGE) {
		gdouble min = 0.0;
		SANE_Range* _tmp0_;
		gdouble max = 0.0;
		SANE_Range* _tmp1_;
		_tmp0_ = option->constraint.range;
		min = SANE_UNFIX ((SANE_Fixed) _tmp0_->min);
		_tmp1_ = option->constraint.range;
		max = SANE_UNFIX ((SANE_Fixed) _tmp1_->max);
		if (v < min) {
			v = min;
		}
		if (v > max) {
			v = max;
		}
	} else {
		if (option->constraint_type == SANE_CONSTRAINT_WORD_LIST) {
			gdouble distance = 0.0;
			gdouble nearest = 0.0;
			distance = DBL_MAX;
			nearest = 0.0;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp2_ = FALSE;
					_tmp2_ = TRUE;
					while (TRUE) {
						SANE_Word* _tmp4_;
						gint _tmp4__length1;
						SANE_Word _tmp5_;
						gdouble x = 0.0;
						SANE_Word* _tmp6_;
						gint _tmp6__length1;
						SANE_Word _tmp7_;
						if (!_tmp2_) {
							gint _tmp3_;
							_tmp3_ = i;
							i = _tmp3_ + 1;
						}
						_tmp2_ = FALSE;
						_tmp4_ = option->constraint.word_list;
						_tmp4__length1 = -1;
						_tmp5_ = _tmp4_[0];
						if (!(((SANE_Word) i) < _tmp5_)) {
							break;
						}
						_tmp6_ = option->constraint.word_list;
						_tmp6__length1 = -1;
						_tmp7_ = _tmp6_[i + 1];
						x = SANE_UNFIX ((SANE_Fixed) _tmp7_);
						if (fabs (x - v) < distance) {
							distance = fabs (x - v);
							nearest = x;
						}
					}
				}
			}
			v = nearest;
		}
	}
	v_fixed = SANE_FIX (v);
	status = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, &v_fixed, NULL);
	_tmp8_ = option->name;
	_tmp9_ = sane_status_to_string (status);
	_tmp10_ = _tmp9_;
	g_debug ("scanner.vala:554: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s=%" \
"f) -> (%s, %f)", (gint) option_index, _tmp8_, value, _tmp10_, SANE_UNFIX (v_fixed));
	_g_free0 (_tmp10_);
	_vala__result_ = SANE_UNFIX (v_fixed);
	if (_result_) {
		*_result_ = _vala__result_;
	}
}

static void
scanner_set_fixed_or_int_option (Scanner* self,
                                 SANE_Handle handle,
                                 SANE_Option_Descriptor* option,
                                 SANE_Int option_index,
                                 gdouble value,
                                 gdouble* _result_)
{
	gdouble _vala__result_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	if (option->type == SANE_TYPE_FIXED) {
		gdouble _tmp0_ = 0.0;
		scanner_set_fixed_option (self, handle, option, option_index, value, &_tmp0_);
		_vala__result_ = _tmp0_;
	} else {
		if (option->type == SANE_TYPE_INT) {
			gint r = 0;
			gint _tmp1_ = 0;
			scanner_set_int_option (self, handle, option, option_index, (gint) round (value), &_tmp1_);
			r = _tmp1_;
			_vala__result_ = (gdouble) r;
		} else {
			_vala__result_ = 0.0;
			g_warning ("scanner.vala:572: Unable to set unsupported option type");
		}
	}
	if (_result_) {
		*_result_ = _vala__result_;
	}
}

static void
scanner_set_option_to_max (Scanner* self,
                           SANE_Handle handle,
                           SANE_Option_Descriptor* option,
                           SANE_Int option_index)
{
	SANE_Status status = 0;
	SANE_Range* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	if (option->constraint_type != SANE_CONSTRAINT_RANGE) {
		return;
	}
	_tmp0_ = option->constraint.range;
	status = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, &_tmp0_->max, NULL);
	if (option->type == SANE_TYPE_FIXED) {
		const gchar* _tmp1_;
		SANE_Range* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = option->name;
		_tmp2_ = option->constraint.range;
		_tmp3_ = sane_status_to_string (status);
		_tmp4_ = _tmp3_;
		g_debug ("scanner.vala:584: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s=o" \
"ption.range.max=%f) -> (%s)", (gint) option_index, _tmp1_, SANE_UNFIX ((SANE_Fixed) _tmp2_->max), _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		const gchar* _tmp5_;
		SANE_Range* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = option->name;
		_tmp6_ = option->constraint.range;
		_tmp7_ = sane_status_to_string (status);
		_tmp8_ = _tmp7_;
		g_debug ("scanner.vala:586: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s=o" \
"ption.range.max=%d) -> (%s)", (gint) option_index, _tmp5_, (gint) _tmp6_->max, _tmp8_);
		_g_free0 (_tmp8_);
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
scanner_set_string_option (Scanner* self,
                           SANE_Handle handle,
                           SANE_Option_Descriptor* option,
                           SANE_Int option_index,
                           const gchar* value,
                           gchar** _result_)
{
	gchar* _vala__result_ = NULL;
	gchar* _tmp0_;
	gchar* s = NULL;
	gchar* _tmp1_;
	gint s_length1;
	gint _s_size_;
	gint i = 0;
	gchar* _tmp6_;
	gint _tmp6__length1;
	SANE_Status status = 0;
	gchar* _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (option != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala__result_);
	_vala__result_ = _tmp0_;
	g_return_val_if_fail (option->type == SANE_TYPE_STRING, FALSE);
	_tmp1_ = g_new0 (gchar, option->size);
	s = _tmp1_;
	s_length1 = option->size;
	_s_size_ = s_length1;
	i = 0;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			gchar* _tmp5_;
			gint _tmp5__length1;
			if (!_tmp2_) {
				gint _tmp3_;
				_tmp3_ = i;
				i = _tmp3_ + 1;
			}
			_tmp2_ = FALSE;
			if (((SANE_Int) i) < (option->size - 1)) {
				_tmp4_ = string_get (value, (glong) i) != '\0';
			} else {
				_tmp4_ = FALSE;
			}
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = s;
			_tmp5__length1 = s_length1;
			_tmp5_[i] = string_get (value, (glong) i);
		}
	}
	_tmp6_ = s;
	_tmp6__length1 = s_length1;
	_tmp6_[i] = '\0';
	_tmp7_ = s;
	_tmp7__length1 = s_length1;
	status = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, _tmp7_, NULL);
	_tmp8_ = s;
	_tmp8__length1 = s_length1;
	_tmp9_ = g_strdup ((const gchar*) _tmp8_);
	_g_free0 (_vala__result_);
	_vala__result_ = _tmp9_;
	_tmp10_ = option->name;
	_tmp11_ = sane_status_to_string (status);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala__result_;
	g_debug ("scanner.vala:602: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s=\"" \
"%s\") -> (%s, \"%s\")", (gint) option_index, _tmp10_, value, _tmp12_, _tmp13_);
	_g_free0 (_tmp12_);
	result = status == SANE_STATUS_GOOD;
	s = (g_free (s), NULL);
	if (_result_) {
		*_result_ = _vala__result_;
	} else {
		_g_free0 (_vala__result_);
	}
	return result;
}

static gboolean
scanner_set_constrained_string_option (Scanner* self,
                                       SANE_Handle handle,
                                       SANE_Option_Descriptor* option,
                                       SANE_Int option_index,
                                       gchar** values,
                                       gint values_length1,
                                       gchar** _result_)
{
	gchar* _vala__result_ = NULL;
	gchar* _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (option != NULL, FALSE);
	g_return_val_if_fail (option->type == SANE_TYPE_STRING, FALSE);
	g_return_val_if_fail (option->constraint_type == SANE_CONSTRAINT_STRING_LIST, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				gint j = 0;
				gchar** _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = values[i];
				if (!(_tmp2_ != NULL)) {
					break;
				}
				j = 0;
				{
					gboolean _tmp3_ = FALSE;
					_tmp3_ = TRUE;
					while (TRUE) {
						gchar** _tmp5_;
						gint _tmp5__length1;
						const gchar* _tmp6_;
						const gchar* _tmp7_;
						gchar** _tmp8_;
						gint _tmp8__length1;
						const gchar* _tmp9_;
						if (!_tmp3_) {
							gint _tmp4_;
							_tmp4_ = j;
							j = _tmp4_ + 1;
						}
						_tmp3_ = FALSE;
						_tmp5_ = option->constraint.string_list;
						_tmp5__length1 = _vala_array_length (option->constraint.string_list);
						_tmp6_ = _tmp5_[j];
						if (!(_tmp6_ != NULL)) {
							break;
						}
						_tmp7_ = values[i];
						_tmp8_ = option->constraint.string_list;
						_tmp8__length1 = _vala_array_length (option->constraint.string_list);
						_tmp9_ = _tmp8_[j];
						if (g_strcmp0 (_tmp7_, _tmp9_) == 0) {
							break;
						}
					}
				}
				_tmp10_ = option->constraint.string_list;
				_tmp10__length1 = _vala_array_length (option->constraint.string_list);
				_tmp11_ = _tmp10_[j];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gchar* _tmp13_ = NULL;
					gboolean _tmp14_;
					_tmp12_ = values[i];
					_tmp14_ = scanner_set_string_option (self, handle, option, option_index, _tmp12_, &_tmp13_);
					_g_free0 (_vala__result_);
					_vala__result_ = _tmp13_;
					result = _tmp14_;
					if (_result_) {
						*_result_ = _vala__result_;
					} else {
						_g_free0 (_vala__result_);
					}
					return result;
				}
			}
		}
	}
	_tmp15_ = g_strdup ("");
	_g_free0 (_vala__result_);
	_vala__result_ = _tmp15_;
	result = FALSE;
	if (_result_) {
		*_result_ = _vala__result_;
	} else {
		_g_free0 (_vala__result_);
	}
	return result;
}

static void
scanner_log_option (Scanner* self,
                    SANE_Int index,
                    SANE_Option_Descriptor* option)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	SANE_Int cap = {0};
	const gchar* _tmp151_;
	const gchar* _tmp152_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0_ = g_strdup_printf ("Option %d:", (gint) index);
	s = _tmp0_;
	_tmp1_ = option->name;
	if (g_strcmp0 (_tmp1_, "") != 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = s;
		_tmp3_ = option->name;
		_tmp4_ = g_strdup_printf (" name='%s'", _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp2_, _tmp5_, NULL);
		_g_free0 (s);
		s = _tmp6_;
		_g_free0 (_tmp5_);
	}
	_tmp7_ = option->title;
	if (g_strcmp0 (_tmp7_, "") != 0) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = s;
		_tmp9_ = option->title;
		_tmp10_ = g_strdup_printf (" title='%s'", _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp8_, _tmp11_, NULL);
		_g_free0 (s);
		s = _tmp12_;
		_g_free0 (_tmp11_);
	}
	switch (option->type) {
		case SANE_TYPE_BOOL:
		{
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp13_ = s;
			_tmp14_ = g_strconcat (_tmp13_, " type=bool", NULL);
			_g_free0 (s);
			s = _tmp14_;
			break;
		}
		case SANE_TYPE_INT:
		{
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp15_ = s;
			_tmp16_ = g_strconcat (_tmp15_, " type=int", NULL);
			_g_free0 (s);
			s = _tmp16_;
			break;
		}
		case SANE_TYPE_FIXED:
		{
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = s;
			_tmp18_ = g_strconcat (_tmp17_, " type=fixed", NULL);
			_g_free0 (s);
			s = _tmp18_;
			break;
		}
		case SANE_TYPE_STRING:
		{
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp19_ = s;
			_tmp20_ = g_strconcat (_tmp19_, " type=string", NULL);
			_g_free0 (s);
			s = _tmp20_;
			break;
		}
		case SANE_TYPE_BUTTON:
		{
			const gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp21_ = s;
			_tmp22_ = g_strconcat (_tmp21_, " type=button", NULL);
			_g_free0 (s);
			s = _tmp22_;
			break;
		}
		case SANE_TYPE_GROUP:
		{
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp23_ = s;
			_tmp24_ = g_strconcat (_tmp23_, " type=group", NULL);
			_g_free0 (s);
			s = _tmp24_;
			break;
		}
		default:
		{
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp25_ = s;
			_tmp26_ = g_strdup_printf (" type=%d", (gint) option->type);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strconcat (_tmp25_, _tmp27_, NULL);
			_g_free0 (s);
			s = _tmp28_;
			_g_free0 (_tmp27_);
			break;
		}
	}
	_tmp29_ = s;
	_tmp30_ = g_strdup_printf (" size=%d", (gint) option->size);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp29_, _tmp31_, NULL);
	_g_free0 (s);
	s = _tmp32_;
	_g_free0 (_tmp31_);
	switch (option->unit) {
		case SANE_UNIT_NONE:
		{
			break;
		}
		case SANE_UNIT_PIXEL:
		{
			const gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp33_ = s;
			_tmp34_ = g_strconcat (_tmp33_, " unit=pixels", NULL);
			_g_free0 (s);
			s = _tmp34_;
			break;
		}
		case SANE_UNIT_BIT:
		{
			const gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp35_ = s;
			_tmp36_ = g_strconcat (_tmp35_, " unit=bits", NULL);
			_g_free0 (s);
			s = _tmp36_;
			break;
		}
		case SANE_UNIT_MM:
		{
			const gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp37_ = s;
			_tmp38_ = g_strconcat (_tmp37_, " unit=mm", NULL);
			_g_free0 (s);
			s = _tmp38_;
			break;
		}
		case SANE_UNIT_DPI:
		{
			const gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp39_ = s;
			_tmp40_ = g_strconcat (_tmp39_, " unit=dpi", NULL);
			_g_free0 (s);
			s = _tmp40_;
			break;
		}
		case SANE_UNIT_PERCENT:
		{
			const gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp41_ = s;
			_tmp42_ = g_strconcat (_tmp41_, " unit=percent", NULL);
			_g_free0 (s);
			s = _tmp42_;
			break;
		}
		case SANE_UNIT_MICROSECOND:
		{
			const gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp43_ = s;
			_tmp44_ = g_strconcat (_tmp43_, " unit=microseconds", NULL);
			_g_free0 (s);
			s = _tmp44_;
			break;
		}
		default:
		{
			const gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			_tmp45_ = s;
			_tmp46_ = g_strdup_printf (" unit=%d", (gint) option->unit);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_strconcat (_tmp45_, _tmp47_, NULL);
			_g_free0 (s);
			s = _tmp48_;
			_g_free0 (_tmp47_);
			break;
		}
	}
	switch (option->constraint_type) {
		case SANE_CONSTRAINT_RANGE:
		{
			SANE_Range* _tmp49_;
			_tmp49_ = option->constraint.range;
			if (_tmp49_ != NULL) {
				if (option->type == SANE_TYPE_FIXED) {
					const gchar* _tmp50_;
					SANE_Range* _tmp51_;
					SANE_Range* _tmp52_;
					SANE_Range* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					_tmp50_ = s;
					_tmp51_ = option->constraint.range;
					_tmp52_ = option->constraint.range;
					_tmp53_ = option->constraint.range;
					_tmp54_ = g_strdup_printf (" min=%f, max=%f, quant=%d", SANE_UNFIX ((SANE_Fixed) _tmp51_->min), SANE_UNFIX ((SANE_Fixed) _tmp52_->max), (gint) _tmp53_->quant);
					_tmp55_ = _tmp54_;
					_tmp56_ = g_strconcat (_tmp50_, _tmp55_, NULL);
					_g_free0 (s);
					s = _tmp56_;
					_g_free0 (_tmp55_);
				} else {
					const gchar* _tmp57_;
					SANE_Range* _tmp58_;
					SANE_Range* _tmp59_;
					SANE_Range* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					_tmp57_ = s;
					_tmp58_ = option->constraint.range;
					_tmp59_ = option->constraint.range;
					_tmp60_ = option->constraint.range;
					_tmp61_ = g_strdup_printf (" min=%d, max=%d, quant=%d", (gint) _tmp58_->min, (gint) _tmp59_->max, (gint) _tmp60_->quant);
					_tmp62_ = _tmp61_;
					_tmp63_ = g_strconcat (_tmp57_, _tmp62_, NULL);
					_g_free0 (s);
					s = _tmp63_;
					_g_free0 (_tmp62_);
				}
			}
			break;
		}
		case SANE_CONSTRAINT_WORD_LIST:
		{
			const gchar* _tmp64_;
			gchar* _tmp65_;
			const gchar* _tmp84_;
			gchar* _tmp85_;
			_tmp64_ = s;
			_tmp65_ = g_strconcat (_tmp64_, " values=[", NULL);
			_g_free0 (s);
			s = _tmp65_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp66_ = FALSE;
					_tmp66_ = TRUE;
					while (TRUE) {
						SANE_Word* _tmp68_;
						gint _tmp68__length1;
						SANE_Word _tmp69_;
						if (!_tmp66_) {
							gint _tmp67_;
							_tmp67_ = i;
							i = _tmp67_ + 1;
						}
						_tmp66_ = FALSE;
						_tmp68_ = option->constraint.word_list;
						_tmp68__length1 = -1;
						_tmp69_ = _tmp68_[0];
						if (!(((SANE_Word) i) < _tmp69_)) {
							break;
						}
						if (i != 0) {
							const gchar* _tmp70_;
							gchar* _tmp71_;
							_tmp70_ = s;
							_tmp71_ = g_strconcat (_tmp70_, ", ", NULL);
							_g_free0 (s);
							s = _tmp71_;
						}
						if (option->type == SANE_TYPE_INT) {
							const gchar* _tmp72_;
							SANE_Word* _tmp73_;
							gint _tmp73__length1;
							SANE_Word _tmp74_;
							gchar* _tmp75_;
							gchar* _tmp76_;
							gchar* _tmp77_;
							_tmp72_ = s;
							_tmp73_ = option->constraint.word_list;
							_tmp73__length1 = -1;
							_tmp74_ = _tmp73_[i + 1];
							_tmp75_ = g_strdup_printf ("%d", (gint) _tmp74_);
							_tmp76_ = _tmp75_;
							_tmp77_ = g_strconcat (_tmp72_, _tmp76_, NULL);
							_g_free0 (s);
							s = _tmp77_;
							_g_free0 (_tmp76_);
						} else {
							const gchar* _tmp78_;
							SANE_Word* _tmp79_;
							gint _tmp79__length1;
							SANE_Word _tmp80_;
							gchar* _tmp81_;
							gchar* _tmp82_;
							gchar* _tmp83_;
							_tmp78_ = s;
							_tmp79_ = option->constraint.word_list;
							_tmp79__length1 = -1;
							_tmp80_ = _tmp79_[i + 1];
							_tmp81_ = g_strdup_printf ("%f", SANE_UNFIX ((SANE_Fixed) _tmp80_));
							_tmp82_ = _tmp81_;
							_tmp83_ = g_strconcat (_tmp78_, _tmp82_, NULL);
							_g_free0 (s);
							s = _tmp83_;
							_g_free0 (_tmp82_);
						}
					}
				}
			}
			_tmp84_ = s;
			_tmp85_ = g_strconcat (_tmp84_, "]", NULL);
			_g_free0 (s);
			s = _tmp85_;
			break;
		}
		case SANE_CONSTRAINT_STRING_LIST:
		{
			const gchar* _tmp86_;
			gchar* _tmp87_;
			gchar** _tmp88_;
			gint _tmp88__length1;
			const gchar* _tmp101_;
			gchar* _tmp102_;
			_tmp86_ = s;
			_tmp87_ = g_strconcat (_tmp86_, " values=[", NULL);
			_g_free0 (s);
			s = _tmp87_;
			_tmp88_ = option->constraint.string_list;
			_tmp88__length1 = _vala_array_length (option->constraint.string_list);
			if (_tmp88_ != NULL) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp89_ = FALSE;
						_tmp89_ = TRUE;
						while (TRUE) {
							gchar** _tmp91_;
							gint _tmp91__length1;
							const gchar* _tmp92_;
							const gchar* _tmp95_;
							gchar** _tmp96_;
							gint _tmp96__length1;
							const gchar* _tmp97_;
							gchar* _tmp98_;
							gchar* _tmp99_;
							gchar* _tmp100_;
							if (!_tmp89_) {
								gint _tmp90_;
								_tmp90_ = i;
								i = _tmp90_ + 1;
							}
							_tmp89_ = FALSE;
							_tmp91_ = option->constraint.string_list;
							_tmp91__length1 = _vala_array_length (option->constraint.string_list);
							_tmp92_ = _tmp91_[i];
							if (!(_tmp92_ != NULL)) {
								break;
							}
							if (i != 0) {
								const gchar* _tmp93_;
								gchar* _tmp94_;
								_tmp93_ = s;
								_tmp94_ = g_strconcat (_tmp93_, ", ", NULL);
								_g_free0 (s);
								s = _tmp94_;
							}
							_tmp95_ = s;
							_tmp96_ = option->constraint.string_list;
							_tmp96__length1 = _vala_array_length (option->constraint.string_list);
							_tmp97_ = _tmp96_[i];
							_tmp98_ = g_strdup_printf ("\"%s\"", _tmp97_);
							_tmp99_ = _tmp98_;
							_tmp100_ = g_strconcat (_tmp95_, _tmp99_, NULL);
							_g_free0 (s);
							s = _tmp100_;
							_g_free0 (_tmp99_);
						}
					}
				}
			}
			_tmp101_ = s;
			_tmp102_ = g_strconcat (_tmp101_, "]", NULL);
			_g_free0 (s);
			s = _tmp102_;
			break;
		}
		default:
		{
			break;
		}
	}
	cap = option->cap;
	if (cap != ((SANE_Int) 0)) {
		gchar* caps = NULL;
		gchar* _tmp103_;
		const gchar* _tmp146_;
		const gchar* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		gchar* _tmp150_;
		_tmp103_ = g_strdup ("");
		caps = _tmp103_;
		if ((cap & SANE_CAP_SOFT_SELECT) != ((SANE_Int) 0)) {
			const gchar* _tmp104_;
			const gchar* _tmp107_;
			gchar* _tmp108_;
			_tmp104_ = caps;
			if (g_strcmp0 (_tmp104_, "") != 0) {
				const gchar* _tmp105_;
				gchar* _tmp106_;
				_tmp105_ = caps;
				_tmp106_ = g_strconcat (_tmp105_, ",", NULL);
				_g_free0 (caps);
				caps = _tmp106_;
			}
			_tmp107_ = caps;
			_tmp108_ = g_strconcat (_tmp107_, "soft-select", NULL);
			_g_free0 (caps);
			caps = _tmp108_;
			cap &= (SANE_Int) (~SANE_CAP_SOFT_SELECT);
		}
		if ((cap & SANE_CAP_HARD_SELECT) != ((SANE_Int) 0)) {
			const gchar* _tmp109_;
			const gchar* _tmp112_;
			gchar* _tmp113_;
			_tmp109_ = caps;
			if (g_strcmp0 (_tmp109_, "") != 0) {
				const gchar* _tmp110_;
				gchar* _tmp111_;
				_tmp110_ = caps;
				_tmp111_ = g_strconcat (_tmp110_, ",", NULL);
				_g_free0 (caps);
				caps = _tmp111_;
			}
			_tmp112_ = caps;
			_tmp113_ = g_strconcat (_tmp112_, "hard-select", NULL);
			_g_free0 (caps);
			caps = _tmp113_;
			cap &= (SANE_Int) (~SANE_CAP_HARD_SELECT);
		}
		if ((cap & SANE_CAP_SOFT_DETECT) != ((SANE_Int) 0)) {
			const gchar* _tmp114_;
			const gchar* _tmp117_;
			gchar* _tmp118_;
			_tmp114_ = caps;
			if (g_strcmp0 (_tmp114_, "") != 0) {
				const gchar* _tmp115_;
				gchar* _tmp116_;
				_tmp115_ = caps;
				_tmp116_ = g_strconcat (_tmp115_, ",", NULL);
				_g_free0 (caps);
				caps = _tmp116_;
			}
			_tmp117_ = caps;
			_tmp118_ = g_strconcat (_tmp117_, "soft-detect", NULL);
			_g_free0 (caps);
			caps = _tmp118_;
			cap &= (SANE_Int) (~SANE_CAP_SOFT_DETECT);
		}
		if ((cap & SANE_CAP_EMULATED) != ((SANE_Int) 0)) {
			const gchar* _tmp119_;
			const gchar* _tmp122_;
			gchar* _tmp123_;
			_tmp119_ = caps;
			if (g_strcmp0 (_tmp119_, "") != 0) {
				const gchar* _tmp120_;
				gchar* _tmp121_;
				_tmp120_ = caps;
				_tmp121_ = g_strconcat (_tmp120_, ",", NULL);
				_g_free0 (caps);
				caps = _tmp121_;
			}
			_tmp122_ = caps;
			_tmp123_ = g_strconcat (_tmp122_, "emulated", NULL);
			_g_free0 (caps);
			caps = _tmp123_;
			cap &= (SANE_Int) (~SANE_CAP_EMULATED);
		}
		if ((cap & SANE_CAP_AUTOMATIC) != ((SANE_Int) 0)) {
			const gchar* _tmp124_;
			const gchar* _tmp127_;
			gchar* _tmp128_;
			_tmp124_ = caps;
			if (g_strcmp0 (_tmp124_, "") != 0) {
				const gchar* _tmp125_;
				gchar* _tmp126_;
				_tmp125_ = caps;
				_tmp126_ = g_strconcat (_tmp125_, ",", NULL);
				_g_free0 (caps);
				caps = _tmp126_;
			}
			_tmp127_ = caps;
			_tmp128_ = g_strconcat (_tmp127_, "automatic", NULL);
			_g_free0 (caps);
			caps = _tmp128_;
			cap &= (SANE_Int) (~SANE_CAP_AUTOMATIC);
		}
		if ((cap & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
			const gchar* _tmp129_;
			const gchar* _tmp132_;
			gchar* _tmp133_;
			_tmp129_ = caps;
			if (g_strcmp0 (_tmp129_, "") != 0) {
				const gchar* _tmp130_;
				gchar* _tmp131_;
				_tmp130_ = caps;
				_tmp131_ = g_strconcat (_tmp130_, ",", NULL);
				_g_free0 (caps);
				caps = _tmp131_;
			}
			_tmp132_ = caps;
			_tmp133_ = g_strconcat (_tmp132_, "inactive", NULL);
			_g_free0 (caps);
			caps = _tmp133_;
			cap &= (SANE_Int) (~SANE_CAP_INACTIVE);
		}
		if ((cap & SANE_CAP_ADVANCED) != ((SANE_Int) 0)) {
			const gchar* _tmp134_;
			const gchar* _tmp137_;
			gchar* _tmp138_;
			_tmp134_ = caps;
			if (g_strcmp0 (_tmp134_, "") != 0) {
				const gchar* _tmp135_;
				gchar* _tmp136_;
				_tmp135_ = caps;
				_tmp136_ = g_strconcat (_tmp135_, ",", NULL);
				_g_free0 (caps);
				caps = _tmp136_;
			}
			_tmp137_ = caps;
			_tmp138_ = g_strconcat (_tmp137_, "advanced", NULL);
			_g_free0 (caps);
			caps = _tmp138_;
			cap &= (SANE_Int) (~SANE_CAP_ADVANCED);
		}
		if (cap != ((SANE_Int) 0)) {
			const gchar* _tmp139_;
			const gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			_tmp139_ = caps;
			if (g_strcmp0 (_tmp139_, "") != 0) {
				const gchar* _tmp140_;
				gchar* _tmp141_;
				_tmp140_ = caps;
				_tmp141_ = g_strconcat (_tmp140_, ",", NULL);
				_g_free0 (caps);
				caps = _tmp141_;
			}
			_tmp142_ = caps;
			_tmp143_ = g_strdup_printf ("%x", (guint) ((gint) cap));
			_tmp144_ = _tmp143_;
			_tmp145_ = g_strconcat (_tmp142_, _tmp144_, NULL);
			_g_free0 (caps);
			caps = _tmp145_;
			_g_free0 (_tmp144_);
		}
		_tmp146_ = s;
		_tmp147_ = caps;
		_tmp148_ = g_strconcat (" cap=", _tmp147_, NULL);
		_tmp149_ = _tmp148_;
		_tmp150_ = g_strconcat (_tmp146_, _tmp149_, NULL);
		_g_free0 (s);
		s = _tmp150_;
		_g_free0 (_tmp149_);
		_g_free0 (caps);
	}
	_tmp151_ = s;
	g_debug ("scanner.vala:795: %s", _tmp151_);
	_tmp152_ = option->desc;
	if (_tmp152_ != NULL) {
		const gchar* _tmp153_;
		_tmp153_ = option->desc;
		g_debug ("scanner.vala:798:   Description: %s", _tmp153_);
	}
	_g_free0 (s);
}

static void
scanner_authorization_cb (const gchar* resource,
                          gchar* username,
                          gint username_length1,
                          gchar* password,
                          gint password_length1)
{
	Scanner* _tmp0_;
	NotifyRequestAuthorization* _tmp1_;
	NotifyRequestAuthorization* _tmp2_;
	Credentials* credentials = NULL;
	Scanner* _tmp3_;
	GAsyncQueue* _tmp4_;
	gpointer _tmp5_;
	g_return_if_fail (resource != NULL);
	_tmp0_ = scanner_scanner_object;
	_tmp1_ = notify_request_authorization_new (resource);
	_tmp2_ = _tmp1_;
	scanner_notify_event (_tmp0_, (Notify*) _tmp2_);
	_notify_unref0 (_tmp2_);
	_tmp3_ = scanner_scanner_object;
	_tmp4_ = _tmp3_->priv->authorize_queue;
	_tmp5_ = g_async_queue_pop (_tmp4_);
	credentials = (Credentials*) _tmp5_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_ = FALSE;
				Credentials* _tmp9_;
				const gchar* _tmp10_;
				Credentials* _tmp11_;
				const gchar* _tmp12_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = credentials;
				_tmp10_ = _tmp9_->username;
				if (string_get (_tmp10_, (glong) i) != '\0') {
					_tmp8_ = i < SANE_MAX_USERNAME_LEN;
				} else {
					_tmp8_ = FALSE;
				}
				if (!_tmp8_) {
					break;
				}
				_tmp11_ = credentials;
				_tmp12_ = _tmp11_->username;
				username[i] = string_get (_tmp12_, (glong) i);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp15_ = FALSE;
				Credentials* _tmp16_;
				const gchar* _tmp17_;
				Credentials* _tmp18_;
				const gchar* _tmp19_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = credentials;
				_tmp17_ = _tmp16_->password;
				if (string_get (_tmp17_, (glong) i) != '\0') {
					_tmp15_ = i < SANE_MAX_USERNAME_LEN;
				} else {
					_tmp15_ = FALSE;
				}
				if (!_tmp15_) {
					break;
				}
				_tmp18_ = credentials;
				_tmp19_ = _tmp18_->password;
				password[i] = string_get (_tmp19_, (glong) i);
			}
		}
	}
	_credentials_unref0 (credentials);
}

static gpointer
_credentials_ref0 (gpointer self)
{
	return self ? credentials_ref (self) : NULL;
}

void
scanner_authorize (Scanner* self,
                   const gchar* username,
                   const gchar* password)
{
	Credentials* credentials = NULL;
	Credentials* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GAsyncQueue* _tmp3_;
	Credentials* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	g_return_if_fail (password != NULL);
	_tmp0_ = credentials_new ();
	credentials = _tmp0_;
	_tmp1_ = g_strdup (username);
	_g_free0 (credentials->username);
	credentials->username = _tmp1_;
	_tmp2_ = g_strdup (password);
	_g_free0 (credentials->password);
	credentials->password = _tmp2_;
	_tmp3_ = self->priv->authorize_queue;
	_tmp4_ = _credentials_ref0 (credentials);
	g_async_queue_push (_tmp3_, _tmp4_);
	_credentials_unref0 (credentials);
}

static void
scanner_close_device (Scanner* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->have_handle) {
		sane_cancel (self->priv->handle);
		g_debug ("scanner.vala:825: sane_cancel ()");
		sane_close (self->priv->handle);
		g_debug ("scanner.vala:828: sane_close ()");
		self->priv->have_handle = FALSE;
		_g_hash_table_unref0 (self->priv->options);
		self->priv->options = NULL;
	}
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer = NULL;
	self->priv->buffer_length1 = 0;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	(self->priv->job_queue == NULL) ? NULL : (self->priv->job_queue = (_g_list_free__g_object_unref0_ (self->priv->job_queue), NULL));
	self->priv->job_queue = NULL;
	scanner_set_scanning (self, FALSE);
}

static void
scanner_fail_scan (Scanner* self,
                   gint error_code,
                   const gchar* error_string)
{
	NotifyScanFailed* _tmp0_;
	NotifyScanFailed* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_string != NULL);
	scanner_close_device (self);
	self->priv->state = SCAN_STATE_IDLE;
	_tmp0_ = notify_scan_failed_new (error_code, error_string);
	_tmp1_ = _tmp0_;
	scanner_notify_event (self, (Notify*) _tmp1_);
	_notify_unref0 (_tmp1_);
}

static gpointer
_request_ref0 (gpointer self)
{
	return self ? request_ref (self) : NULL;
}

static gboolean
scanner_handle_requests (Scanner* self)
{
	gboolean _tmp0_ = FALSE;
	gint request_count = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->state == SCAN_STATE_IDLE) {
		_tmp0_ = self->priv->need_redetect;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->state = SCAN_STATE_REDETECT;
	}
	request_count = 0;
	while (TRUE) {
		Request* request = NULL;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gint _tmp6_;
		Request* _tmp7_;
		if (self->priv->state == SCAN_STATE_IDLE) {
			_tmp2_ = request_count == 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			GAsyncQueue* _tmp3_;
			_tmp3_ = self->priv->request_queue;
			_tmp1_ = g_async_queue_length (_tmp3_) > 0;
		}
		if (_tmp1_) {
			GAsyncQueue* _tmp4_;
			gpointer _tmp5_;
			_tmp4_ = self->priv->request_queue;
			_tmp5_ = g_async_queue_pop (_tmp4_);
			_request_unref0 (request);
			request = (Request*) _tmp5_;
		} else {
			result = TRUE;
			_request_unref0 (request);
			return result;
		}
		g_debug ("scanner.vala:863: Processing request");
		_tmp6_ = request_count;
		request_count = _tmp6_ + 1;
		_tmp7_ = request;
		if (IS_REQUEST_START_SCAN (_tmp7_)) {
			RequestStartScan* r = NULL;
			Request* _tmp8_;
			RequestStartScan* _tmp9_;
			RequestStartScan* _tmp10_;
			ScanJob* _tmp11_;
			ScanJob* _tmp12_;
			_tmp8_ = request;
			_tmp9_ = _request_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_REQUEST_START_SCAN, RequestStartScan));
			r = _tmp9_;
			_tmp10_ = r;
			_tmp11_ = _tmp10_->job;
			_tmp12_ = _g_object_ref0 (_tmp11_);
			self->priv->job_queue = g_list_append (self->priv->job_queue, _tmp12_);
			_request_unref0 (r);
		} else {
			Request* _tmp13_;
			_tmp13_ = request;
			if (IS_REQUEST_CANCEL (_tmp13_)) {
				scanner_fail_scan (self, (gint) SANE_STATUS_CANCELLED, "Scan cancelled - do not report this error");
			} else {
				Request* _tmp14_;
				_tmp14_ = request;
				if (IS_REQUEST_QUIT (_tmp14_)) {
					scanner_close_device (self);
					result = FALSE;
					_request_unref0 (request);
					return result;
				}
			}
		}
		_request_unref0 (request);
	}
}

static void
scanner_do_open (Scanner* self)
{
	ScanJob* job = NULL;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ScanJob* _tmp4_;
	const gchar* _tmp5_;
	ScanJob* _tmp10_;
	const gchar* _tmp11_;
	GHashFunc _tmp15_;
	GEqualFunc _tmp16_;
	GHashTable* _tmp17_;
	SANE_Status status = 0;
	ScanJob* _tmp18_;
	const gchar* _tmp19_;
	SANE_Handle _tmp20_ = {0};
	SANE_Status _tmp21_;
	ScanJob* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	ScanJob* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->job_queue;
	_tmp1_ = _tmp0_->data;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
	job = _tmp2_;
	self->priv->line_count = 0;
	self->priv->pass_number = 0;
	self->priv->page_number = 0;
	self->priv->notified_page = -1;
	self->priv->option_index = (SANE_Int) 0;
	_tmp4_ = job;
	_tmp5_ = _tmp4_->device;
	if (_tmp5_ == NULL) {
		const gchar* _tmp6_;
		_tmp6_ = self->priv->default_device;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ScanJob* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = job;
		_tmp8_ = self->priv->default_device;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (_tmp7_->device);
		_tmp7_->device = _tmp9_;
	}
	_tmp10_ = job;
	_tmp11_ = _tmp10_->device;
	if (_tmp11_ == NULL) {
		g_warning ("scanner.vala:898: No scan device available");
		scanner_fail_scan (self, 0, _ ("No scanners available.  Please connect a scanner."));
		_g_object_unref0 (job);
		return;
	}
	if (self->priv->have_handle) {
		const gchar* _tmp12_;
		ScanJob* _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = self->priv->current_device;
		_tmp13_ = job;
		_tmp14_ = _tmp13_->device;
		if (g_strcmp0 (_tmp12_, _tmp14_) == 0) {
			self->priv->state = SCAN_STATE_GET_OPTION;
			_g_object_unref0 (job);
			return;
		}
		sane_close (self->priv->handle);
		g_debug ("scanner.vala:915: sane_close ()");
		self->priv->have_handle = FALSE;
	}
	_g_free0 (self->priv->current_device);
	self->priv->current_device = NULL;
	self->priv->have_handle = FALSE;
	_tmp15_ = g_str_hash;
	_tmp16_ = g_str_equal;
	_tmp17_ = g_hash_table_new_full (_tmp15_, _tmp16_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->options);
	self->priv->options = _tmp17_;
	_tmp18_ = job;
	_tmp19_ = _tmp18_->device;
	_tmp21_ = sane_open (_tmp19_, &_tmp20_);
	self->priv->handle = _tmp20_;
	status = _tmp21_;
	_tmp22_ = job;
	_tmp23_ = _tmp22_->device;
	_tmp24_ = sane_status_to_string (status);
	_tmp25_ = _tmp24_;
	g_debug ("scanner.vala:924: sane_open (\"%s\") -> %s", _tmp23_, _tmp25_);
	_g_free0 (_tmp25_);
	if (status != SANE_STATUS_GOOD) {
		const gchar* _tmp26_;
		_tmp26_ = sane_strstatus (status);
		g_warning ("scanner.vala:928: Unable to open device: %s", _tmp26_);
		scanner_fail_scan (self, (gint) status, _ ("Unable to connect to scanner"));
		_g_object_unref0 (job);
		return;
	}
	self->priv->have_handle = TRUE;
	_tmp27_ = job;
	_tmp28_ = _tmp27_->device;
	_tmp29_ = g_strdup (_tmp28_);
	_g_free0 (self->priv->current_device);
	self->priv->current_device = _tmp29_;
	self->priv->state = SCAN_STATE_GET_OPTION;
	_g_object_unref0 (job);
}

static void
scanner_set_adf (Scanner* self,
                 ScanJob* job,
                 SANE_Option_Descriptor* option,
                 SANE_Int index)
{
	gchar** adf_sources = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint adf_sources_length1;
	gint _adf_sources_size_;
	gchar** adf_front_sources = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint adf_front_sources_length1;
	gint _adf_front_sources_size_;
	gchar** adf_back_sources = NULL;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint adf_back_sources_length1;
	gint _adf_back_sources_size_;
	gchar** adf_duplex_sources = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gint adf_duplex_sources_length1;
	gint _adf_duplex_sources_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	g_return_if_fail (option != NULL);
	_tmp0_ = g_strdup ("Automatic Document Feeder");
	_tmp1_ = SANE_I18N ("Automatic Document Feeder");
	_tmp2_ = g_strdup (_tmp1_);
	_tmp3_ = g_strdup ("ADF");
	_tmp4_ = g_strdup ("Automatic Document Feeder(centrally aligned)");
	_tmp5_ = g_strdup ("Automatic Document Feeder(center aligned)");
	_tmp6_ = g_strdup ("Automatic Document Feeder(left aligned)");
	_tmp7_ = g_strdup ("ADF Simplex");
	_tmp8_ = g_new0 (gchar*, 7 + 1);
	_tmp8_[0] = _tmp0_;
	_tmp8_[1] = _tmp2_;
	_tmp8_[2] = _tmp3_;
	_tmp8_[3] = _tmp4_;
	_tmp8_[4] = _tmp5_;
	_tmp8_[5] = _tmp6_;
	_tmp8_[6] = _tmp7_;
	adf_sources = _tmp8_;
	adf_sources_length1 = 7;
	_adf_sources_size_ = adf_sources_length1;
	_tmp9_ = g_strdup ("ADF Front");
	_tmp10_ = SANE_I18N ("ADF Front");
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = g_new0 (gchar*, 2 + 1);
	_tmp12_[0] = _tmp9_;
	_tmp12_[1] = _tmp11_;
	adf_front_sources = _tmp12_;
	adf_front_sources_length1 = 2;
	_adf_front_sources_size_ = adf_front_sources_length1;
	_tmp13_ = g_strdup ("ADF Back");
	_tmp14_ = SANE_I18N ("ADF Back");
	_tmp15_ = g_strdup (_tmp14_);
	_tmp16_ = g_new0 (gchar*, 2 + 1);
	_tmp16_[0] = _tmp13_;
	_tmp16_[1] = _tmp15_;
	adf_back_sources = _tmp16_;
	adf_back_sources_length1 = 2;
	_adf_back_sources_size_ = adf_back_sources_length1;
	_tmp17_ = g_strdup ("ADF Duplex");
	_tmp18_ = g_strdup ("Duplex ADF");
	_tmp19_ = SANE_I18N ("ADF Duplex");
	_tmp20_ = g_strdup (_tmp19_);
	_tmp21_ = g_strdup ("ADF Duplex - Long-Edge Binding");
	_tmp22_ = g_strdup ("ADF Duplex - Short-Edge Binding");
	_tmp23_ = g_strdup ("Duplex");
	_tmp24_ = g_strdup ("Automatic Document Feeder(centrally aligned,Duplex)");
	_tmp25_ = g_strdup ("Automatic Document Feeder(left aligned,Duplex)");
	_tmp26_ = g_new0 (gchar*, 8 + 1);
	_tmp26_[0] = _tmp17_;
	_tmp26_[1] = _tmp18_;
	_tmp26_[2] = _tmp20_;
	_tmp26_[3] = _tmp21_;
	_tmp26_[4] = _tmp22_;
	_tmp26_[5] = _tmp23_;
	_tmp26_[6] = _tmp24_;
	_tmp26_[7] = _tmp25_;
	adf_duplex_sources = _tmp26_;
	adf_duplex_sources_length1 = 8;
	_adf_duplex_sources_size_ = adf_duplex_sources_length1;
	if (job->side == SCAN_SIDE_FRONT) {
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp27_ = adf_front_sources;
		_tmp27__length1 = adf_front_sources_length1;
		if (!scanner_set_constrained_string_option (self, self->priv->handle, option, index, _tmp27_, (gint) _tmp27__length1, NULL)) {
			gchar** _tmp28_;
			gint _tmp28__length1;
			_tmp28_ = adf_sources;
			_tmp28__length1 = adf_sources_length1;
			if (!scanner_set_constrained_string_option (self, self->priv->handle, option, index, _tmp28_, (gint) _tmp28__length1, NULL)) {
				g_warning ("scanner.vala:981: Unable to set front ADF source, please file a bug");
			}
		}
	} else {
		if (job->side == SCAN_SIDE_BACK) {
			gchar** _tmp29_;
			gint _tmp29__length1;
			_tmp29_ = adf_back_sources;
			_tmp29__length1 = adf_back_sources_length1;
			if (!scanner_set_constrained_string_option (self, self->priv->handle, option, index, _tmp29_, (gint) _tmp29__length1, NULL)) {
				gchar** _tmp30_;
				gint _tmp30__length1;
				_tmp30_ = adf_sources;
				_tmp30__length1 = adf_sources_length1;
				if (!scanner_set_constrained_string_option (self, self->priv->handle, option, index, _tmp30_, (gint) _tmp30__length1, NULL)) {
					g_warning ("scanner.vala:987: Unable to set back ADF source, please file a bug");
				}
			}
		} else {
			if (job->side == SCAN_SIDE_BOTH) {
				gchar** _tmp31_;
				gint _tmp31__length1;
				_tmp31_ = adf_duplex_sources;
				_tmp31__length1 = adf_duplex_sources_length1;
				if (!scanner_set_constrained_string_option (self, self->priv->handle, option, index, _tmp31_, (gint) _tmp31__length1, NULL)) {
					gchar** _tmp32_;
					gint _tmp32__length1;
					_tmp32_ = adf_sources;
					_tmp32__length1 = adf_sources_length1;
					if (!scanner_set_constrained_string_option (self, self->priv->handle, option, index, _tmp32_, (gint) _tmp32__length1, NULL)) {
						g_warning ("scanner.vala:993: Unable to set duplex ADF source, please file a bug");
					}
				}
			}
		}
	}
	adf_duplex_sources = (_vala_array_free (adf_duplex_sources, adf_duplex_sources_length1, (GDestroyNotify) g_free), NULL);
	adf_back_sources = (_vala_array_free (adf_back_sources, adf_back_sources_length1, (GDestroyNotify) g_free), NULL);
	adf_front_sources = (_vala_array_free (adf_front_sources, adf_front_sources_length1, (GDestroyNotify) g_free), NULL);
	adf_sources = (_vala_array_free (adf_sources, adf_sources_length1, (GDestroyNotify) g_free), NULL);
}

static void
scanner_do_get_option (Scanner* self)
{
	ScanJob* job = NULL;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	SANE_Option_Descriptor* option = NULL;
	SANE_Option_Descriptor* _tmp3_;
	SANE_Int index = {0};
	SANE_Int _tmp4_;
	SANE_Option_Descriptor* _tmp5_;
	SANE_Option_Descriptor* _tmp250_;
	SANE_Option_Descriptor* _tmp251_;
	SANE_Option_Descriptor* _tmp252_;
	const gchar* _tmp253_;
	GHashTable* _tmp254_;
	SANE_Option_Descriptor* _tmp255_;
	const gchar* _tmp256_;
	gchar* _tmp257_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->job_queue;
	_tmp1_ = _tmp0_->data;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
	job = _tmp2_;
	_tmp3_ = sane_get_option_descriptor (self->priv->handle, self->priv->option_index);
	option = _tmp3_;
	g_debug ("scanner.vala:1002: sane_get_option_descriptor (%d)", (gint) self->priv->option_index);
	index = self->priv->option_index;
	_tmp4_ = self->priv->option_index;
	self->priv->option_index = _tmp4_ + 1;
	_tmp5_ = option;
	if (_tmp5_ == NULL) {
		const gchar* _tmp6_;
		gint _tmp7_ = 0;
		SANE_Option_Descriptor* _tmp8_;
		SANE_Option_Descriptor* _tmp9_;
		SANE_Option_Descriptor* _tmp12_;
		const gchar* _tmp33_;
		gint _tmp34_ = 0;
		SANE_Option_Descriptor* _tmp35_;
		SANE_Option_Descriptor* _tmp36_;
		gint _tmp88_ = 0;
		SANE_Option_Descriptor* _tmp89_;
		SANE_Option_Descriptor* _tmp90_;
		SANE_Option_Descriptor* _tmp93_;
		gint _tmp97_ = 0;
		SANE_Option_Descriptor* _tmp98_;
		SANE_Option_Descriptor* _tmp99_;
		SANE_Option_Descriptor* _tmp102_;
		gint _tmp112_ = 0;
		SANE_Option_Descriptor* _tmp113_;
		SANE_Option_Descriptor* _tmp114_;
		gint _tmp117_ = 0;
		SANE_Option_Descriptor* _tmp118_;
		SANE_Option_Descriptor* _tmp119_;
		const gchar* _tmp125_;
		gint _tmp126_ = 0;
		SANE_Option_Descriptor* _tmp127_;
		gboolean _tmp128_ = FALSE;
		SANE_Option_Descriptor* _tmp129_;
		SANE_Option_Descriptor* _tmp141_;
		SANE_Option_Descriptor* _tmp144_;
		const gchar* _tmp156_;
		gint _tmp157_ = 0;
		SANE_Option_Descriptor* _tmp158_;
		SANE_Option_Descriptor* _tmp159_;
		const gchar* _tmp166_;
		gint _tmp167_ = 0;
		SANE_Option_Descriptor* _tmp168_;
		SANE_Option_Descriptor* _tmp169_;
		ScanJob* _tmp176_;
		const gchar* _tmp185_;
		gint _tmp186_ = 0;
		SANE_Option_Descriptor* _tmp187_;
		gboolean _tmp188_ = FALSE;
		SANE_Option_Descriptor* _tmp189_;
		const gchar* _tmp195_;
		gint _tmp196_ = 0;
		SANE_Option_Descriptor* _tmp197_;
		gboolean _tmp198_ = FALSE;
		SANE_Option_Descriptor* _tmp199_;
		const gchar* _tmp205_;
		gint _tmp206_ = 0;
		SANE_Option_Descriptor* _tmp207_;
		SANE_Option_Descriptor* _tmp208_;
		const gchar* _tmp217_;
		gint _tmp218_ = 0;
		SANE_Option_Descriptor* _tmp219_;
		SANE_Option_Descriptor* _tmp220_;
		const gchar* _tmp229_;
		_tmp6_ = SANE_NAME_SCAN_SOURCE;
		_tmp8_ = scanner_get_option_by_name (self, self->priv->handle, _tmp6_, &_tmp7_);
		index = (SANE_Int) _tmp7_;
		option = _tmp8_;
		_tmp9_ = option;
		if (_tmp9_ == NULL) {
			gint _tmp10_ = 0;
			SANE_Option_Descriptor* _tmp11_;
			_tmp11_ = scanner_get_option_by_name (self, self->priv->handle, "doc-source", &_tmp10_);
			index = (SANE_Int) _tmp10_;
			option = _tmp11_;
		}
		_tmp12_ = option;
		if (_tmp12_ != NULL) {
			gchar** flatbed_sources = NULL;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar** _tmp24_;
			gint flatbed_sources_length1;
			gint _flatbed_sources_size_;
			ScanJob* _tmp25_;
			_tmp13_ = g_strdup ("Auto");
			_tmp14_ = SANE_I18N ("Auto");
			_tmp15_ = g_strdup (_tmp14_);
			_tmp16_ = g_strdup ("Flatbed");
			_tmp17_ = SANE_I18N ("Flatbed");
			_tmp18_ = g_strdup (_tmp17_);
			_tmp19_ = g_strdup ("FlatBed");
			_tmp20_ = g_strdup ("Normal");
			_tmp21_ = SANE_I18N ("Normal");
			_tmp22_ = g_strdup (_tmp21_);
			_tmp23_ = g_strdup ("Document Table");
			_tmp24_ = g_new0 (gchar*, 8 + 1);
			_tmp24_[0] = _tmp13_;
			_tmp24_[1] = _tmp15_;
			_tmp24_[2] = _tmp16_;
			_tmp24_[3] = _tmp18_;
			_tmp24_[4] = _tmp19_;
			_tmp24_[5] = _tmp20_;
			_tmp24_[6] = _tmp22_;
			_tmp24_[7] = _tmp23_;
			flatbed_sources = _tmp24_;
			flatbed_sources_length1 = 8;
			_flatbed_sources_size_ = flatbed_sources_length1;
			_tmp25_ = job;
			switch (_tmp25_->type) {
				case SCAN_TYPE_SINGLE:
				case SCAN_TYPE_BATCH:
				{
					SANE_Option_Descriptor* _tmp26_;
					_tmp26_ = option;
					if (!scanner_set_default_option (self, self->priv->handle, _tmp26_, index)) {
						SANE_Option_Descriptor* _tmp27_;
						gchar** _tmp28_;
						gint _tmp28__length1;
						_tmp27_ = option;
						_tmp28_ = flatbed_sources;
						_tmp28__length1 = flatbed_sources_length1;
						if (!scanner_set_constrained_string_option (self, self->priv->handle, _tmp27_, index, _tmp28_, (gint) _tmp28__length1, NULL)) {
							ScanJob* _tmp29_;
							SANE_Option_Descriptor* _tmp30_;
							g_warning ("scanner.vala:1036: Unable to set single page source, trying to set ADF" \
" instead");
							g_warning ("scanner.vala:1037: If Flatbed is existing and it is not set, please fi" \
"le a bug");
							_tmp29_ = job;
							_tmp30_ = option;
							scanner_set_adf (self, _tmp29_, _tmp30_, index);
						}
					}
					break;
				}
				case SCAN_TYPE_ADF:
				{
					ScanJob* _tmp31_;
					SANE_Option_Descriptor* _tmp32_;
					_tmp31_ = job;
					_tmp32_ = option;
					scanner_set_adf (self, _tmp31_, _tmp32_, index);
					break;
				}
				default:
				break;
			}
			flatbed_sources = (_vala_array_free (flatbed_sources, flatbed_sources_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp33_ = SANE_NAME_SCAN_MODE;
		_tmp35_ = scanner_get_option_by_name (self, self->priv->handle, _tmp33_, &_tmp34_);
		index = (SANE_Int) _tmp34_;
		option = _tmp35_;
		_tmp36_ = option;
		if (_tmp36_ != NULL) {
			gchar** color_scan_modes = NULL;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar** _tmp45_;
			gint color_scan_modes_length1;
			gint _color_scan_modes_size_;
			gchar** gray_scan_modes = NULL;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar** _tmp55_;
			gint gray_scan_modes_length1;
			gint _gray_scan_modes_size_;
			gchar** lineart_scan_modes = NULL;
			const gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			const gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			const gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			const gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			const gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar** _tmp80_;
			gint lineart_scan_modes_length1;
			gint _lineart_scan_modes_size_;
			ScanJob* _tmp81_;
			_tmp37_ = SANE_VALUE_SCAN_MODE_COLOR;
			_tmp38_ = g_strdup (_tmp37_);
			_tmp39_ = g_strdup ("Color");
			_tmp40_ = g_strdup ("24bit Color[Fast]");
			_tmp41_ = g_strdup ("24bit Color");
			_tmp42_ = g_strdup ("24-bit Color");
			_tmp43_ = g_strdup ("24 bit Color");
			_tmp44_ = g_strdup ("Color - 16 Million Colors");
			_tmp45_ = g_new0 (gchar*, 7 + 1);
			_tmp45_[0] = _tmp38_;
			_tmp45_[1] = _tmp39_;
			_tmp45_[2] = _tmp40_;
			_tmp45_[3] = _tmp41_;
			_tmp45_[4] = _tmp42_;
			_tmp45_[5] = _tmp43_;
			_tmp45_[6] = _tmp44_;
			color_scan_modes = _tmp45_;
			color_scan_modes_length1 = 7;
			_color_scan_modes_size_ = color_scan_modes_length1;
			_tmp46_ = SANE_VALUE_SCAN_MODE_GRAY;
			_tmp47_ = g_strdup (_tmp46_);
			_tmp48_ = g_strdup ("Gray");
			_tmp49_ = g_strdup ("Grayscale");
			_tmp50_ = SANE_I18N ("Grayscale");
			_tmp51_ = g_strdup (_tmp50_);
			_tmp52_ = g_strdup ("8-bit Grayscale");
			_tmp53_ = g_strdup ("True Gray");
			_tmp54_ = g_strdup ("Grayscale - 256 Levels");
			_tmp55_ = g_new0 (gchar*, 7 + 1);
			_tmp55_[0] = _tmp47_;
			_tmp55_[1] = _tmp48_;
			_tmp55_[2] = _tmp49_;
			_tmp55_[3] = _tmp51_;
			_tmp55_[4] = _tmp52_;
			_tmp55_[5] = _tmp53_;
			_tmp55_[6] = _tmp54_;
			gray_scan_modes = _tmp55_;
			gray_scan_modes_length1 = 7;
			_gray_scan_modes_size_ = gray_scan_modes_length1;
			_tmp56_ = SANE_VALUE_SCAN_MODE_LINEART;
			_tmp57_ = g_strdup (_tmp56_);
			_tmp58_ = g_strdup ("Lineart");
			_tmp59_ = g_strdup ("LineArt");
			_tmp60_ = SANE_I18N ("LineArt");
			_tmp61_ = g_strdup (_tmp60_);
			_tmp62_ = g_strdup ("Black & White");
			_tmp63_ = SANE_I18N ("Black & White");
			_tmp64_ = g_strdup (_tmp63_);
			_tmp65_ = g_strdup ("Binary");
			_tmp66_ = SANE_I18N ("Binary");
			_tmp67_ = g_strdup (_tmp66_);
			_tmp68_ = g_strdup ("Thresholded");
			_tmp69_ = SANE_VALUE_SCAN_MODE_GRAY;
			_tmp70_ = g_strdup (_tmp69_);
			_tmp71_ = g_strdup ("Gray");
			_tmp72_ = g_strdup ("Grayscale");
			_tmp73_ = SANE_I18N ("Grayscale");
			_tmp74_ = g_strdup (_tmp73_);
			_tmp75_ = g_strdup ("True Gray");
			_tmp76_ = g_strdup ("1-bit Black & White");
			_tmp77_ = g_strdup ("Black and White - Line Art");
			_tmp78_ = g_strdup ("Black and White - Halftone");
			_tmp79_ = g_strdup ("Monochrome");
			_tmp80_ = g_new0 (gchar*, 18 + 1);
			_tmp80_[0] = _tmp57_;
			_tmp80_[1] = _tmp58_;
			_tmp80_[2] = _tmp59_;
			_tmp80_[3] = _tmp61_;
			_tmp80_[4] = _tmp62_;
			_tmp80_[5] = _tmp64_;
			_tmp80_[6] = _tmp65_;
			_tmp80_[7] = _tmp67_;
			_tmp80_[8] = _tmp68_;
			_tmp80_[9] = _tmp70_;
			_tmp80_[10] = _tmp71_;
			_tmp80_[11] = _tmp72_;
			_tmp80_[12] = _tmp74_;
			_tmp80_[13] = _tmp75_;
			_tmp80_[14] = _tmp76_;
			_tmp80_[15] = _tmp77_;
			_tmp80_[16] = _tmp78_;
			_tmp80_[17] = _tmp79_;
			lineart_scan_modes = _tmp80_;
			lineart_scan_modes_length1 = 18;
			_lineart_scan_modes_size_ = lineart_scan_modes_length1;
			_tmp81_ = job;
			switch (_tmp81_->scan_mode) {
				case SCAN_MODE_COLOR:
				{
					SANE_Option_Descriptor* _tmp82_;
					gchar** _tmp83_;
					gint _tmp83__length1;
					_tmp82_ = option;
					_tmp83_ = color_scan_modes;
					_tmp83__length1 = color_scan_modes_length1;
					if (!scanner_set_constrained_string_option (self, self->priv->handle, _tmp82_, index, _tmp83_, (gint) _tmp83__length1, NULL)) {
						g_warning ("scanner.vala:1098: Unable to set Color mode, please file a bug");
					}
					break;
				}
				case SCAN_MODE_GRAY:
				{
					SANE_Option_Descriptor* _tmp84_;
					gchar** _tmp85_;
					gint _tmp85__length1;
					_tmp84_ = option;
					_tmp85_ = gray_scan_modes;
					_tmp85__length1 = gray_scan_modes_length1;
					if (!scanner_set_constrained_string_option (self, self->priv->handle, _tmp84_, index, _tmp85_, (gint) _tmp85__length1, NULL)) {
						g_warning ("scanner.vala:1102: Unable to set Gray mode, please file a bug");
					}
					break;
				}
				case SCAN_MODE_LINEART:
				{
					SANE_Option_Descriptor* _tmp86_;
					gchar** _tmp87_;
					gint _tmp87__length1;
					_tmp86_ = option;
					_tmp87_ = lineart_scan_modes;
					_tmp87__length1 = lineart_scan_modes_length1;
					if (!scanner_set_constrained_string_option (self, self->priv->handle, _tmp86_, index, _tmp87_, (gint) _tmp87__length1, NULL)) {
						g_warning ("scanner.vala:1106: Unable to set Lineart mode, please file a bug");
					}
					break;
				}
				default:
				{
					break;
				}
			}
			lineart_scan_modes = (_vala_array_free (lineart_scan_modes, lineart_scan_modes_length1, (GDestroyNotify) g_free), NULL);
			gray_scan_modes = (_vala_array_free (gray_scan_modes, gray_scan_modes_length1, (GDestroyNotify) g_free), NULL);
			color_scan_modes = (_vala_array_free (color_scan_modes, color_scan_modes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp89_ = scanner_get_option_by_name (self, self->priv->handle, "duplex", &_tmp88_);
		index = (SANE_Int) _tmp88_;
		option = _tmp89_;
		_tmp90_ = option;
		if (_tmp90_ == NULL) {
			gint _tmp91_ = 0;
			SANE_Option_Descriptor* _tmp92_;
			_tmp92_ = scanner_get_option_by_name (self, self->priv->handle, "scan-both-sides", &_tmp91_);
			index = (SANE_Int) _tmp91_;
			option = _tmp92_;
		}
		_tmp93_ = option;
		if (_tmp93_ != NULL) {
			SANE_Option_Descriptor* _tmp94_;
			_tmp94_ = option;
			if (_tmp94_->type == SANE_TYPE_BOOL) {
				SANE_Option_Descriptor* _tmp95_;
				ScanJob* _tmp96_;
				_tmp95_ = option;
				_tmp96_ = job;
				scanner_set_bool_option (self, self->priv->handle, _tmp95_, index, _tmp96_->side == SCAN_SIDE_BOTH, NULL);
			}
		}
		_tmp98_ = scanner_get_option_by_name (self, self->priv->handle, "adf-mode", &_tmp97_);
		index = (SANE_Int) _tmp97_;
		option = _tmp98_;
		_tmp99_ = option;
		if (_tmp99_ == NULL) {
			gint _tmp100_ = 0;
			SANE_Option_Descriptor* _tmp101_;
			_tmp101_ = scanner_get_option_by_name (self, self->priv->handle, "ScanMode", &_tmp100_);
			index = (SANE_Int) _tmp100_;
			option = _tmp101_;
		}
		_tmp102_ = option;
		if (_tmp102_ != NULL) {
			gchar** adf_simplex_modes = NULL;
			gchar* _tmp103_;
			gchar** _tmp104_;
			gint adf_simplex_modes_length1;
			gint _adf_simplex_modes_size_;
			gchar** adf_duplex_modes = NULL;
			gchar* _tmp105_;
			gchar** _tmp106_;
			gint adf_duplex_modes_length1;
			gint _adf_duplex_modes_size_;
			ScanJob* _tmp107_;
			_tmp103_ = g_strdup ("Simplex");
			_tmp104_ = g_new0 (gchar*, 1 + 1);
			_tmp104_[0] = _tmp103_;
			adf_simplex_modes = _tmp104_;
			adf_simplex_modes_length1 = 1;
			_adf_simplex_modes_size_ = adf_simplex_modes_length1;
			_tmp105_ = g_strdup ("Duplex");
			_tmp106_ = g_new0 (gchar*, 1 + 1);
			_tmp106_[0] = _tmp105_;
			adf_duplex_modes = _tmp106_;
			adf_duplex_modes_length1 = 1;
			_adf_duplex_modes_size_ = adf_duplex_modes_length1;
			_tmp107_ = job;
			if (_tmp107_->side == SCAN_SIDE_BOTH) {
				SANE_Option_Descriptor* _tmp108_;
				gchar** _tmp109_;
				gint _tmp109__length1;
				_tmp108_ = option;
				_tmp109_ = adf_duplex_modes;
				_tmp109__length1 = adf_duplex_modes_length1;
				scanner_set_constrained_string_option (self, self->priv->handle, _tmp108_, index, _tmp109_, (gint) _tmp109__length1, NULL);
			} else {
				SANE_Option_Descriptor* _tmp110_;
				gchar** _tmp111_;
				gint _tmp111__length1;
				_tmp110_ = option;
				_tmp111_ = adf_simplex_modes;
				_tmp111__length1 = adf_simplex_modes_length1;
				scanner_set_constrained_string_option (self, self->priv->handle, _tmp110_, index, _tmp111_, (gint) _tmp111__length1, NULL);
			}
			adf_duplex_modes = (_vala_array_free (adf_duplex_modes, adf_duplex_modes_length1, (GDestroyNotify) g_free), NULL);
			adf_simplex_modes = (_vala_array_free (adf_simplex_modes, adf_simplex_modes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp113_ = scanner_get_option_by_name (self, self->priv->handle, "adf-auto-scan", &_tmp112_);
		index = (SANE_Int) _tmp112_;
		option = _tmp113_;
		_tmp114_ = option;
		if (_tmp114_ != NULL) {
			SANE_Option_Descriptor* _tmp115_;
			_tmp115_ = option;
			if (_tmp115_->type == SANE_TYPE_BOOL) {
				SANE_Option_Descriptor* _tmp116_;
				_tmp116_ = option;
				scanner_set_bool_option (self, self->priv->handle, _tmp116_, index, TRUE, NULL);
			}
		}
		_tmp118_ = scanner_get_option_by_name (self, self->priv->handle, "batch-scan", &_tmp117_);
		index = (SANE_Int) _tmp117_;
		option = _tmp118_;
		_tmp119_ = option;
		if (_tmp119_ != NULL) {
			SANE_Option_Descriptor* _tmp120_;
			_tmp120_ = option;
			if (_tmp120_->type == SANE_TYPE_BOOL) {
				gboolean _tmp121_ = FALSE;
				ScanJob* _tmp122_;
				SANE_Option_Descriptor* _tmp124_;
				_tmp122_ = job;
				if (_tmp122_->type != SCAN_TYPE_SINGLE) {
					ScanJob* _tmp123_;
					_tmp123_ = job;
					_tmp121_ = _tmp123_->type != SCAN_TYPE_BATCH;
				} else {
					_tmp121_ = FALSE;
				}
				_tmp124_ = option;
				scanner_set_bool_option (self, self->priv->handle, _tmp124_, index, _tmp121_, NULL);
			}
		}
		_tmp125_ = SANE_NAME_SCAN_X_RESOLUTION;
		_tmp127_ = scanner_get_option_by_name (self, self->priv->handle, _tmp125_, &_tmp126_);
		index = (SANE_Int) _tmp126_;
		option = _tmp127_;
		_tmp129_ = option;
		if (_tmp129_ != NULL) {
			SANE_Option_Descriptor* _tmp130_;
			_tmp130_ = option;
			_tmp128_ = ((SANE_Int) 0) != (_tmp130_->cap & SANE_CAP_SOFT_SELECT);
		} else {
			_tmp128_ = FALSE;
		}
		if (_tmp128_) {
			SANE_Option_Descriptor* _tmp131_;
			ScanJob* _tmp132_;
			ScanJob* _tmp133_;
			gdouble _tmp134_ = 0.0;
			const gchar* _tmp135_;
			gint _tmp136_ = 0;
			SANE_Option_Descriptor* _tmp137_;
			_tmp131_ = option;
			_tmp132_ = job;
			_tmp133_ = job;
			scanner_set_fixed_or_int_option (self, self->priv->handle, _tmp131_, index, _tmp132_->dpi, &_tmp134_);
			_tmp133_->dpi = _tmp134_;
			_tmp135_ = SANE_NAME_SCAN_Y_RESOLUTION;
			_tmp137_ = scanner_get_option_by_name (self, self->priv->handle, _tmp135_, &_tmp136_);
			index = (SANE_Int) _tmp136_;
			option = _tmp137_;
		} else {
			const gchar* _tmp138_;
			gint _tmp139_ = 0;
			SANE_Option_Descriptor* _tmp140_;
			_tmp138_ = SANE_NAME_SCAN_RESOLUTION;
			_tmp140_ = scanner_get_option_by_name (self, self->priv->handle, _tmp138_, &_tmp139_);
			index = (SANE_Int) _tmp139_;
			option = _tmp140_;
		}
		_tmp141_ = option;
		if (_tmp141_ == NULL) {
			gint _tmp142_ = 0;
			SANE_Option_Descriptor* _tmp143_;
			_tmp143_ = scanner_get_option_by_name (self, self->priv->handle, "scan-resolution", &_tmp142_);
			index = (SANE_Int) _tmp142_;
			option = _tmp143_;
		}
		_tmp144_ = option;
		if (_tmp144_ != NULL) {
			SANE_Option_Descriptor* _tmp145_;
			ScanJob* _tmp146_;
			ScanJob* _tmp147_;
			gdouble _tmp148_ = 0.0;
			const gchar* _tmp149_;
			gint _tmp150_ = 0;
			SANE_Option_Descriptor* _tmp151_;
			SANE_Option_Descriptor* _tmp152_;
			_tmp145_ = option;
			_tmp146_ = job;
			_tmp147_ = job;
			scanner_set_fixed_or_int_option (self, self->priv->handle, _tmp145_, index, _tmp146_->dpi, &_tmp148_);
			_tmp147_->dpi = _tmp148_;
			_tmp149_ = SANE_NAME_BIT_DEPTH;
			_tmp151_ = scanner_get_option_by_name (self, self->priv->handle, _tmp149_, &_tmp150_);
			index = (SANE_Int) _tmp150_;
			option = _tmp151_;
			_tmp152_ = option;
			if (_tmp152_ != NULL) {
				ScanJob* _tmp153_;
				_tmp153_ = job;
				if (_tmp153_->depth > 0) {
					SANE_Option_Descriptor* _tmp154_;
					ScanJob* _tmp155_;
					_tmp154_ = option;
					_tmp155_ = job;
					scanner_set_int_option (self, self->priv->handle, _tmp154_, index, _tmp155_->depth, NULL);
				}
			}
		}
		_tmp156_ = SANE_NAME_SCAN_BR_X;
		_tmp158_ = scanner_get_option_by_name (self, self->priv->handle, _tmp156_, &_tmp157_);
		index = (SANE_Int) _tmp157_;
		option = _tmp158_;
		_tmp159_ = option;
		if (_tmp159_ != NULL) {
			ScanJob* _tmp160_;
			_tmp160_ = job;
			if (_tmp160_->page_width > 0) {
				SANE_Option_Descriptor* _tmp161_;
				SANE_Option_Descriptor* _tmp162_;
				ScanJob* _tmp163_;
				ScanJob* _tmp164_;
				_tmp161_ = option;
				_tmp162_ = option;
				_tmp163_ = job;
				_tmp164_ = job;
				scanner_set_fixed_or_int_option (self, self->priv->handle, _tmp161_, index, scanner_convert_page_size (self, _tmp162_, (gdouble) _tmp163_->page_width, _tmp164_->dpi), NULL);
			} else {
				SANE_Option_Descriptor* _tmp165_;
				_tmp165_ = option;
				scanner_set_option_to_max (self, self->priv->handle, _tmp165_, index);
			}
		}
		_tmp166_ = SANE_NAME_SCAN_BR_Y;
		_tmp168_ = scanner_get_option_by_name (self, self->priv->handle, _tmp166_, &_tmp167_);
		index = (SANE_Int) _tmp167_;
		option = _tmp168_;
		_tmp169_ = option;
		if (_tmp169_ != NULL) {
			ScanJob* _tmp170_;
			_tmp170_ = job;
			if (_tmp170_->page_height > 0) {
				SANE_Option_Descriptor* _tmp171_;
				SANE_Option_Descriptor* _tmp172_;
				ScanJob* _tmp173_;
				ScanJob* _tmp174_;
				_tmp171_ = option;
				_tmp172_ = option;
				_tmp173_ = job;
				_tmp174_ = job;
				scanner_set_fixed_or_int_option (self, self->priv->handle, _tmp171_, index, scanner_convert_page_size (self, _tmp172_, (gdouble) _tmp173_->page_height, _tmp174_->dpi), NULL);
			} else {
				SANE_Option_Descriptor* _tmp175_;
				_tmp175_ = option;
				scanner_set_option_to_max (self, self->priv->handle, _tmp175_, index);
			}
		}
		_tmp176_ = job;
		if (_tmp176_->page_width == 0) {
			gint _tmp177_ = 0;
			SANE_Option_Descriptor* _tmp178_;
			SANE_Option_Descriptor* _tmp179_;
			gint _tmp181_ = 0;
			SANE_Option_Descriptor* _tmp182_;
			SANE_Option_Descriptor* _tmp183_;
			_tmp178_ = scanner_get_option_by_name (self, self->priv->handle, "scan-area", &_tmp177_);
			index = (SANE_Int) _tmp177_;
			option = _tmp178_;
			_tmp179_ = option;
			if (_tmp179_ != NULL) {
				SANE_Option_Descriptor* _tmp180_;
				_tmp180_ = option;
				scanner_set_string_option (self, self->priv->handle, _tmp180_, index, "Maximum", NULL);
			}
			_tmp182_ = scanner_get_option_by_name (self, self->priv->handle, "AutoDocumentSize", &_tmp181_);
			index = (SANE_Int) _tmp181_;
			option = _tmp182_;
			_tmp183_ = option;
			if (_tmp183_ != NULL) {
				SANE_Option_Descriptor* _tmp184_;
				_tmp184_ = option;
				scanner_set_bool_option (self, self->priv->handle, _tmp184_, index, TRUE, NULL);
			}
		}
		_tmp185_ = SANE_NAME_PAGE_WIDTH;
		_tmp187_ = scanner_get_option_by_name (self, self->priv->handle, _tmp185_, &_tmp186_);
		index = (SANE_Int) _tmp186_;
		option = _tmp187_;
		_tmp189_ = option;
		if (_tmp189_ != NULL) {
			ScanJob* _tmp190_;
			_tmp190_ = job;
			_tmp188_ = ((gdouble) _tmp190_->page_width) > 0.0;
		} else {
			_tmp188_ = FALSE;
		}
		if (_tmp188_) {
			SANE_Option_Descriptor* _tmp191_;
			SANE_Option_Descriptor* _tmp192_;
			ScanJob* _tmp193_;
			ScanJob* _tmp194_;
			_tmp191_ = option;
			_tmp192_ = option;
			_tmp193_ = job;
			_tmp194_ = job;
			scanner_set_fixed_or_int_option (self, self->priv->handle, _tmp191_, index, scanner_convert_page_size (self, _tmp192_, (gdouble) _tmp193_->page_width, _tmp194_->dpi), NULL);
		}
		_tmp195_ = SANE_NAME_PAGE_HEIGHT;
		_tmp197_ = scanner_get_option_by_name (self, self->priv->handle, _tmp195_, &_tmp196_);
		index = (SANE_Int) _tmp196_;
		option = _tmp197_;
		_tmp199_ = option;
		if (_tmp199_ != NULL) {
			ScanJob* _tmp200_;
			_tmp200_ = job;
			_tmp198_ = ((gdouble) _tmp200_->page_height) > 0.0;
		} else {
			_tmp198_ = FALSE;
		}
		if (_tmp198_) {
			SANE_Option_Descriptor* _tmp201_;
			SANE_Option_Descriptor* _tmp202_;
			ScanJob* _tmp203_;
			ScanJob* _tmp204_;
			_tmp201_ = option;
			_tmp202_ = option;
			_tmp203_ = job;
			_tmp204_ = job;
			scanner_set_fixed_or_int_option (self, self->priv->handle, _tmp201_, index, scanner_convert_page_size (self, _tmp202_, (gdouble) _tmp203_->page_height, _tmp204_->dpi), NULL);
		}
		_tmp205_ = SANE_NAME_BRIGHTNESS;
		_tmp207_ = scanner_get_option_by_name (self, self->priv->handle, _tmp205_, &_tmp206_);
		index = (SANE_Int) _tmp206_;
		option = _tmp207_;
		_tmp208_ = option;
		if (_tmp208_ != NULL) {
			SANE_Option_Descriptor* _tmp209_;
			_tmp209_ = option;
			if (_tmp209_->type == SANE_TYPE_FIXED) {
				gdouble brightness = 0.0;
				SANE_Option_Descriptor* _tmp210_;
				ScanJob* _tmp211_;
				SANE_Option_Descriptor* _tmp212_;
				_tmp210_ = option;
				_tmp211_ = job;
				brightness = scanner_scale_fixed (self, -100, 100, _tmp210_, _tmp211_->brightness);
				_tmp212_ = option;
				scanner_set_fixed_option (self, self->priv->handle, _tmp212_, index, brightness, NULL);
			} else {
				SANE_Option_Descriptor* _tmp213_;
				_tmp213_ = option;
				if (_tmp213_->type == SANE_TYPE_INT) {
					gint brightness = 0;
					SANE_Option_Descriptor* _tmp214_;
					ScanJob* _tmp215_;
					SANE_Option_Descriptor* _tmp216_;
					_tmp214_ = option;
					_tmp215_ = job;
					brightness = scanner_scale_int (self, -100, 100, _tmp214_, _tmp215_->brightness);
					_tmp216_ = option;
					scanner_set_int_option (self, self->priv->handle, _tmp216_, index, brightness, NULL);
				} else {
					g_warning ("scanner.vala:1233: Unable to set brightness, please file a bug");
				}
			}
		}
		_tmp217_ = SANE_NAME_CONTRAST;
		_tmp219_ = scanner_get_option_by_name (self, self->priv->handle, _tmp217_, &_tmp218_);
		index = (SANE_Int) _tmp218_;
		option = _tmp219_;
		_tmp220_ = option;
		if (_tmp220_ != NULL) {
			SANE_Option_Descriptor* _tmp221_;
			_tmp221_ = option;
			if (_tmp221_->type == SANE_TYPE_FIXED) {
				gdouble contrast = 0.0;
				SANE_Option_Descriptor* _tmp222_;
				ScanJob* _tmp223_;
				SANE_Option_Descriptor* _tmp224_;
				_tmp222_ = option;
				_tmp223_ = job;
				contrast = scanner_scale_fixed (self, -100, 100, _tmp222_, _tmp223_->contrast);
				_tmp224_ = option;
				scanner_set_fixed_option (self, self->priv->handle, _tmp224_, index, contrast, NULL);
			} else {
				SANE_Option_Descriptor* _tmp225_;
				_tmp225_ = option;
				if (_tmp225_->type == SANE_TYPE_INT) {
					gint contrast = 0;
					SANE_Option_Descriptor* _tmp226_;
					ScanJob* _tmp227_;
					SANE_Option_Descriptor* _tmp228_;
					_tmp226_ = option;
					_tmp227_ = job;
					contrast = scanner_scale_int (self, -100, 100, _tmp226_, _tmp227_->contrast);
					_tmp228_ = option;
					scanner_set_int_option (self, self->priv->handle, _tmp228_, index, contrast, NULL);
				} else {
					g_warning ("scanner.vala:1249: Unable to set contrast, please file a bug");
				}
			}
		}
		_tmp229_ = self->priv->current_device;
		if (g_strcmp0 (_tmp229_, "test") == 0) {
			gint _tmp230_ = 0;
			SANE_Option_Descriptor* _tmp231_;
			SANE_Option_Descriptor* _tmp232_;
			gint _tmp234_ = 0;
			SANE_Option_Descriptor* _tmp235_;
			SANE_Option_Descriptor* _tmp236_;
			gint _tmp238_ = 0;
			SANE_Option_Descriptor* _tmp239_;
			SANE_Option_Descriptor* _tmp240_;
			gint _tmp242_ = 0;
			SANE_Option_Descriptor* _tmp243_;
			SANE_Option_Descriptor* _tmp244_;
			gint _tmp246_ = 0;
			SANE_Option_Descriptor* _tmp247_;
			SANE_Option_Descriptor* _tmp248_;
			_tmp231_ = scanner_get_option_by_name (self, self->priv->handle, "hand-scanner", &_tmp230_);
			index = (SANE_Int) _tmp230_;
			option = _tmp231_;
			_tmp232_ = option;
			if (_tmp232_ != NULL) {
				SANE_Option_Descriptor* _tmp233_;
				_tmp233_ = option;
				scanner_set_bool_option (self, self->priv->handle, _tmp233_, index, FALSE, NULL);
			}
			_tmp235_ = scanner_get_option_by_name (self, self->priv->handle, "three-pass", &_tmp234_);
			index = (SANE_Int) _tmp234_;
			option = _tmp235_;
			_tmp236_ = option;
			if (_tmp236_ != NULL) {
				SANE_Option_Descriptor* _tmp237_;
				_tmp237_ = option;
				scanner_set_bool_option (self, self->priv->handle, _tmp237_, index, FALSE, NULL);
			}
			_tmp239_ = scanner_get_option_by_name (self, self->priv->handle, "test-picture", &_tmp238_);
			index = (SANE_Int) _tmp238_;
			option = _tmp239_;
			_tmp240_ = option;
			if (_tmp240_ != NULL) {
				SANE_Option_Descriptor* _tmp241_;
				_tmp241_ = option;
				scanner_set_string_option (self, self->priv->handle, _tmp241_, index, "Color pattern", NULL);
			}
			_tmp243_ = scanner_get_option_by_name (self, self->priv->handle, "read-delay", &_tmp242_);
			index = (SANE_Int) _tmp242_;
			option = _tmp243_;
			_tmp244_ = option;
			if (_tmp244_ != NULL) {
				SANE_Option_Descriptor* _tmp245_;
				_tmp245_ = option;
				scanner_set_bool_option (self, self->priv->handle, _tmp245_, index, TRUE, NULL);
			}
			_tmp247_ = scanner_get_option_by_name (self, self->priv->handle, "read-delay-duration", &_tmp246_);
			index = (SANE_Int) _tmp246_;
			option = _tmp247_;
			_tmp248_ = option;
			if (_tmp248_ != NULL) {
				SANE_Option_Descriptor* _tmp249_;
				_tmp249_ = option;
				scanner_set_int_option (self, self->priv->handle, _tmp249_, index, 200000, NULL);
			}
		}
		self->priv->state = SCAN_STATE_START;
		_g_object_unref0 (job);
		return;
	}
	_tmp250_ = option;
	scanner_log_option (self, index, _tmp250_);
	_tmp251_ = option;
	if (_tmp251_->type == SANE_TYPE_GROUP) {
		_g_object_unref0 (job);
		return;
	}
	_tmp252_ = option;
	_tmp253_ = _tmp252_->name;
	if (_tmp253_ == NULL) {
		_g_object_unref0 (job);
		return;
	}
	_tmp254_ = self->priv->options;
	_tmp255_ = option;
	_tmp256_ = _tmp255_->name;
	_tmp257_ = g_strdup (_tmp256_);
	g_hash_table_insert (_tmp254_, _tmp257_, (gpointer) ((gintptr) index));
	_g_object_unref0 (job);
}

static gdouble
scanner_convert_page_size (Scanner* self,
                           SANE_Option_Descriptor* option,
                           gdouble size,
                           gdouble dpi)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (option != NULL, 0.0);
	if (option->unit == SANE_UNIT_PIXEL) {
		result = (dpi * size) / 254.0;
		return result;
	} else {
		if (option->unit == SANE_UNIT_MM) {
			result = size / 10.0;
			return result;
		} else {
			g_warning ("scanner.vala:1297: Unable to set unsupported unit type");
			result = (gdouble) 0.0f;
			return result;
		}
	}
}

static SANE_Option_Descriptor*
scanner_get_option_by_name (Scanner* self,
                            SANE_Handle handle,
                            const gchar* name,
                            gint* index)
{
	gint _vala_index = 0;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	SANE_Option_Descriptor* option_descriptor = NULL;
	SANE_Option_Descriptor* _tmp2_;
	SANE_Option_Descriptor* _tmp3_;
	SANE_Option_Descriptor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->options;
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	_vala_index = (gint) ((gintptr) _tmp1_);
	if (_vala_index == 0) {
		result = NULL;
		if (index) {
			*index = _vala_index;
		}
		return result;
	}
	_tmp2_ = sane_get_option_descriptor (handle, (SANE_Int) _vala_index);
	option_descriptor = _tmp2_;
	_tmp3_ = option_descriptor;
	if ((_tmp3_->cap & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
		g_warning ("scanner.vala:1316: The option %s (%d) is inactive and can't be set, pl" \
"ease file a bug", name, _vala_index);
		result = NULL;
		if (index) {
			*index = _vala_index;
		}
		return result;
	}
	result = option_descriptor;
	if (index) {
		*index = _vala_index;
	}
	return result;
}

static void
scanner_do_complete_document (Scanner* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	NotifyDocumentDone* _tmp2_;
	NotifyDocumentDone* _tmp3_;
	g_return_if_fail (self != NULL);
	sane_cancel (self->priv->handle);
	g_debug ("scanner.vala:1325: sane_cancel ()");
	_tmp0_ = self->priv->job_queue;
	self->priv->job_queue = g_list_remove_link (self->priv->job_queue, _tmp0_);
	self->priv->state = SCAN_STATE_IDLE;
	_tmp1_ = self->priv->job_queue;
	if (_tmp1_ != NULL) {
		self->priv->state = SCAN_STATE_OPEN;
		return;
	}
	_tmp2_ = notify_document_done_new ();
	_tmp3_ = _tmp2_;
	scanner_notify_event (self, (Notify*) _tmp3_);
	_notify_unref0 (_tmp3_);
	scanner_set_scanning (self, FALSE);
}

static void
scanner_do_start (Scanner* self)
{
	SANE_Status status = 0;
	NotifyExpectPage* _tmp0_;
	NotifyExpectPage* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = notify_expect_page_new ();
	_tmp1_ = _tmp0_;
	scanner_notify_event (self, (Notify*) _tmp1_);
	_notify_unref0 (_tmp1_);
	status = sane_start (self->priv->handle);
	_tmp2_ = sane_status_to_string (status);
	_tmp3_ = _tmp2_;
	g_debug ("scanner.vala:1352: sane_start (page=%d, pass=%d) -> %s", self->priv->page_number, self->priv->pass_number, _tmp3_);
	_g_free0 (_tmp3_);
	if (status == SANE_STATUS_GOOD) {
		self->priv->state = SCAN_STATE_GET_PARAMETERS;
	} else {
		if (status == SANE_STATUS_NO_DOCS) {
			scanner_do_complete_document (self);
			if (self->priv->page_number == 0) {
				scanner_fail_scan (self, (gint) status, _ ("Document feeder empty"));
			}
		} else {
			if (status == SANE_STATUS_NO_MEM) {
				scanner_fail_scan (self, (gint) status, _ ("Insufficient memory to perform scan.\n" "Try to decrease <tt>Resolution</tt> or <tt>Page Size</tt> in <tt>Prefe" \
"rences</tt> menu. " "For some scanners when scanning in high resolution, the scan size is r" \
"estricted."));
			} else {
				if (status == SANE_STATUS_DEVICE_BUSY) {
				} else {
					const gchar* _tmp4_;
					_tmp4_ = sane_strstatus (status);
					g_warning ("scanner.vala:1379: Unable to start device: %s", _tmp4_);
					scanner_fail_scan (self, (gint) status, _ ("Unable to start scan"));
				}
			}
		}
	}
}

static gchar*
sane_frame_to_string (SANE_Frame frame)
{
	gchar* result;
	switch (frame) {
		case SANE_FRAME_GRAY:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("SANE_FRAME_GRAY");
			result = _tmp0_;
			return result;
		}
		case SANE_FRAME_RGB:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("SANE_FRAME_RGB");
			result = _tmp1_;
			return result;
		}
		case SANE_FRAME_RED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("SANE_FRAME_RED");
			result = _tmp2_;
			return result;
		}
		case SANE_FRAME_GREEN:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("SANE_FRAME_GREEN");
			result = _tmp3_;
			return result;
		}
		case SANE_FRAME_BLUE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("SANE_FRAME_BLUE");
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup_printf ("SANE_FRAME(%d)", (gint) frame);
			result = _tmp5_;
			return result;
		}
	}
}

static void
scanner_do_get_parameters (Scanner* self)
{
	SANE_Status status = 0;
	SANE_Parameters _tmp0_ = {0};
	SANE_Status _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ScanJob* job = NULL;
	GList* _tmp5_;
	gconstpointer _tmp6_;
	ScanJob* _tmp7_;
	const gchar* _tmp8_ = NULL;
	SANE_Parameters _tmp9_;
	SANE_Parameters _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	SANE_Parameters _tmp13_;
	SANE_Parameters _tmp14_;
	SANE_Parameters _tmp15_;
	SANE_Parameters _tmp16_;
	ScanPageInfo* info = NULL;
	ScanPageInfo* _tmp17_;
	ScanPageInfo* _tmp18_;
	SANE_Parameters _tmp19_;
	ScanPageInfo* _tmp20_;
	SANE_Parameters _tmp21_;
	ScanPageInfo* _tmp22_;
	SANE_Parameters _tmp23_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	SANE_Parameters _tmp27_;
	gint _tmp33_ = 0;
	SANE_Parameters _tmp34_;
	ScanPageInfo* _tmp35_;
	ScanPageInfo* _tmp36_;
	ScanJob* _tmp37_;
	ScanPageInfo* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gint buffer_size = 0;
	SANE_Parameters _tmp45_;
	guchar* _tmp46_;
	g_return_if_fail (self != NULL);
	_tmp1_ = sane_get_parameters (self->priv->handle, &_tmp0_);
	self->priv->parameters = _tmp0_;
	status = _tmp1_;
	_tmp2_ = sane_status_to_string (status);
	_tmp3_ = _tmp2_;
	g_debug ("scanner.vala:1389: sane_get_parameters () -> %s", _tmp3_);
	_g_free0 (_tmp3_);
	if (status != SANE_STATUS_GOOD) {
		const gchar* _tmp4_;
		_tmp4_ = sane_strstatus (status);
		g_warning ("scanner.vala:1392: Unable to get device parameters: %s", _tmp4_);
		scanner_fail_scan (self, (gint) status, _ ("Error communicating with scanner"));
		return;
	}
	_tmp5_ = self->priv->job_queue;
	_tmp6_ = _tmp5_->data;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp6_, TYPE_SCAN_JOB, ScanJob));
	job = _tmp7_;
	_tmp9_ = self->priv->parameters;
	if (_tmp9_.last_frame) {
		_tmp8_ = "SANE_TRUE";
	} else {
		_tmp8_ = "SANE_FALSE";
	}
	_tmp10_ = self->priv->parameters;
	_tmp11_ = sane_frame_to_string (_tmp10_.format);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->parameters;
	_tmp14_ = self->priv->parameters;
	_tmp15_ = self->priv->parameters;
	_tmp16_ = self->priv->parameters;
	g_debug ("scanner.vala:1401: Parameters: format=%s last_frame=%s bytes_per_line=" \
"%d pixels_per_line=%d lines=%d depth=%d", _tmp12_, _tmp8_, _tmp13_.bytes_per_line, _tmp14_.pixels_per_line, _tmp15_.lines, _tmp16_.depth);
	_g_free0 (_tmp12_);
	_tmp17_ = scan_page_info_new ();
	info = _tmp17_;
	_tmp18_ = info;
	_tmp19_ = self->priv->parameters;
	_tmp18_->width = _tmp19_.pixels_per_line;
	_tmp20_ = info;
	_tmp21_ = self->priv->parameters;
	_tmp20_->height = _tmp21_.lines;
	_tmp22_ = info;
	_tmp23_ = self->priv->parameters;
	_tmp22_->depth = _tmp23_.depth;
	_tmp27_ = self->priv->parameters;
	if (_tmp27_.depth == 8) {
		SANE_Parameters _tmp28_;
		_tmp28_ = self->priv->parameters;
		_tmp26_ = _tmp28_.format == SANE_FRAME_GRAY;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		ScanJob* _tmp29_;
		_tmp29_ = job;
		_tmp25_ = _tmp29_->depth == 2;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ScanJob* _tmp30_;
		_tmp30_ = job;
		_tmp24_ = _tmp30_->scan_mode == SCAN_MODE_GRAY;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		ScanPageInfo* _tmp31_;
		ScanJob* _tmp32_;
		_tmp31_ = info;
		_tmp32_ = job;
		_tmp31_->depth = _tmp32_->depth;
	}
	_tmp34_ = self->priv->parameters;
	if (_tmp34_.format == SANE_FRAME_GRAY) {
		_tmp33_ = 1;
	} else {
		_tmp33_ = 3;
	}
	_tmp35_ = info;
	_tmp35_->n_channels = _tmp33_;
	_tmp36_ = info;
	_tmp37_ = job;
	_tmp36_->dpi = _tmp37_->dpi;
	_tmp38_ = info;
	_tmp39_ = self->priv->current_device;
	_tmp40_ = g_strdup (_tmp39_);
	_g_free0 (_tmp38_->device);
	_tmp38_->device = _tmp40_;
	if (self->priv->page_number != self->priv->notified_page) {
		ScanJob* _tmp41_;
		ScanPageInfo* _tmp42_;
		NotifyGotPageInfo* _tmp43_;
		NotifyGotPageInfo* _tmp44_;
		_tmp41_ = job;
		_tmp42_ = info;
		_tmp43_ = notify_got_page_info_new (_tmp41_->id, _tmp42_);
		_tmp44_ = _tmp43_;
		scanner_notify_event (self, (Notify*) _tmp44_);
		_notify_unref0 (_tmp44_);
		self->priv->notified_page = self->priv->page_number;
	}
	_tmp45_ = self->priv->parameters;
	buffer_size = _tmp45_.bytes_per_line + 1;
	_tmp46_ = g_new0 (guchar, buffer_size);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer = _tmp46_;
	self->priv->buffer_length1 = buffer_size;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	self->priv->n_used = 0;
	self->priv->line_count = 0;
	self->priv->pass_number = 0;
	self->priv->state = SCAN_STATE_READ;
	_g_object_unref0 (info);
	_g_object_unref0 (job);
}

static void
scanner_do_complete_page (Scanner* self)
{
	ScanJob* job = NULL;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	ScanJob* _tmp3_;
	NotifyPageDone* _tmp4_;
	NotifyPageDone* _tmp5_;
	SANE_Parameters _tmp6_;
	ScanJob* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->job_queue;
	_tmp1_ = _tmp0_->data;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
	job = _tmp2_;
	_tmp3_ = job;
	_tmp4_ = notify_page_done_new (_tmp3_->id);
	_tmp5_ = _tmp4_;
	scanner_notify_event (self, (Notify*) _tmp5_);
	_notify_unref0 (_tmp5_);
	_tmp6_ = self->priv->parameters;
	if (!_tmp6_.last_frame) {
		gint _tmp7_;
		_tmp7_ = self->priv->pass_number;
		self->priv->pass_number = _tmp7_ + 1;
		self->priv->state = SCAN_STATE_START;
		_g_object_unref0 (job);
		return;
	}
	_tmp8_ = job;
	if (_tmp8_->type != SCAN_TYPE_SINGLE) {
		ScanJob* _tmp9_;
		gint _tmp11_;
		ScanJob* _tmp12_;
		NotifyPageDone* _tmp13_;
		NotifyPageDone* _tmp14_;
		_tmp9_ = job;
		if (_tmp9_->type == SCAN_TYPE_BATCH) {
			ScanJob* _tmp10_;
			_tmp10_ = job;
			g_usleep ((gulong) (_tmp10_->page_delay * 1000));
		}
		_tmp11_ = self->priv->page_number;
		self->priv->page_number = _tmp11_ + 1;
		self->priv->pass_number = 0;
		_tmp12_ = job;
		_tmp13_ = notify_page_done_new (_tmp12_->id);
		_tmp14_ = _tmp13_;
		scanner_notify_event (self, (Notify*) _tmp14_);
		_notify_unref0 (_tmp14_);
		self->priv->state = SCAN_STATE_START;
		_g_object_unref0 (job);
		return;
	}
	scanner_do_complete_document (self);
	_g_object_unref0 (job);
}

static void
scanner_do_read (Scanner* self)
{
	ScanJob* job = NULL;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	gint n_to_read = 0;
	guchar* _tmp3_;
	gint _tmp3__length1;
	SANE_Int n_read = {0};
	guchar* b = NULL;
	guchar* _tmp4_;
	gint _tmp4__length1;
	SANE_Status status = 0;
	guchar* _tmp5_;
	SANE_Int _tmp6_ = {0};
	SANE_Status _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean full_read = FALSE;
	gboolean _tmp15_ = FALSE;
	SANE_Parameters _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->job_queue;
	_tmp1_ = _tmp0_->data;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
	job = _tmp2_;
	_tmp3_ = self->priv->buffer;
	_tmp3__length1 = self->priv->buffer_length1;
	n_to_read = _tmp3__length1 - self->priv->n_used;
	_tmp4_ = self->priv->buffer;
	_tmp4__length1 = self->priv->buffer_length1;
	b = (guchar*) _tmp4_;
	_tmp5_ = b;
	_tmp7_ = sane_read (self->priv->handle, (guint8*) (_tmp5_ + self->priv->n_used), (SANE_Int) n_to_read, &_tmp6_);
	n_read = _tmp6_;
	status = _tmp7_;
	_tmp8_ = sane_status_to_string (status);
	_tmp9_ = _tmp8_;
	g_debug ("scanner.vala:1476: sane_read (%d) -> (%s, %d)", n_to_read, _tmp9_, (gint) n_read);
	_g_free0 (_tmp9_);
	if (status == SANE_STATUS_EOF) {
		gboolean _tmp10_ = FALSE;
		SANE_Parameters _tmp11_;
		_tmp11_ = self->priv->parameters;
		if (_tmp11_.lines > 0) {
			SANE_Parameters _tmp12_;
			_tmp12_ = self->priv->parameters;
			_tmp10_ = self->priv->line_count != _tmp12_.lines;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			SANE_Parameters _tmp13_;
			_tmp13_ = self->priv->parameters;
			g_warning ("scanner.vala:1482: Scan completed with %d lines, expected %d lines", self->priv->line_count, _tmp13_.lines);
		}
		if (self->priv->n_used > 0) {
			g_warning ("scanner.vala:1484: Scan complete with %d bytes of unused data", self->priv->n_used);
		}
		scanner_do_complete_page (self);
		_g_object_unref0 (job);
		return;
	}
	if (status == SANE_STATUS_NO_DOCS) {
		scanner_do_complete_document (self);
		if (self->priv->page_number == 0) {
			scanner_fail_scan (self, (gint) status, _ ("Document feeder empty"));
		}
		_g_object_unref0 (job);
		return;
	}
	if (status != SANE_STATUS_GOOD) {
		const gchar* _tmp14_;
		_tmp14_ = sane_strstatus (status);
		g_warning ("scanner.vala:1503: Unable to read frame from device: %s", _tmp14_);
		scanner_fail_scan (self, (gint) status, _ ("Error communicating with scanner"));
		_g_object_unref0 (job);
		return;
	}
	full_read = FALSE;
	if (self->priv->n_used == 0) {
		guchar* _tmp16_;
		gint _tmp16__length1;
		_tmp16_ = self->priv->buffer;
		_tmp16__length1 = self->priv->buffer_length1;
		_tmp15_ = n_read == ((SANE_Int) _tmp16__length1);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		full_read = TRUE;
	}
	self->priv->n_used = self->priv->n_used + ((gint) n_read);
	_tmp17_ = self->priv->parameters;
	if (self->priv->n_used >= _tmp17_.bytes_per_line) {
		ScanLine* line = NULL;
		ScanLine* _tmp18_;
		SANE_Parameters _tmp19_;
		ScanLine* _tmp25_;
		SANE_Parameters _tmp26_;
		ScanLine* _tmp27_;
		SANE_Parameters _tmp28_;
		ScanLine* _tmp29_;
		guchar* _tmp30_;
		gint _tmp30__length1;
		ScanLine* _tmp31_;
		SANE_Parameters _tmp32_;
		ScanLine* _tmp33_;
		ScanLine* _tmp34_;
		ScanLine* _tmp35_;
		ScanLine* _tmp36_;
		gint buffer_size = 0;
		ScanLine* _tmp37_;
		guchar* _tmp38_;
		gint _tmp38__length1;
		guchar* _tmp40_;
		gint n_remaining = 0;
		ScanLine* _tmp41_;
		ScanLine* _tmp42_;
		gboolean _tmp52_ = FALSE;
		gboolean _tmp53_ = FALSE;
		gboolean _tmp54_ = FALSE;
		SANE_Parameters _tmp55_;
		ScanJob* _tmp77_;
		ScanLine* _tmp78_;
		NotifyGotLine* _tmp79_;
		NotifyGotLine* _tmp80_;
		_tmp18_ = scan_line_new ();
		line = _tmp18_;
		_tmp19_ = self->priv->parameters;
		switch (_tmp19_.format) {
			case SANE_FRAME_GRAY:
			{
				ScanLine* _tmp20_;
				_tmp20_ = line;
				_tmp20_->channel = 0;
				break;
			}
			case SANE_FRAME_RGB:
			{
				ScanLine* _tmp21_;
				_tmp21_ = line;
				_tmp21_->channel = -1;
				break;
			}
			case SANE_FRAME_RED:
			{
				ScanLine* _tmp22_;
				_tmp22_ = line;
				_tmp22_->channel = 0;
				break;
			}
			case SANE_FRAME_GREEN:
			{
				ScanLine* _tmp23_;
				_tmp23_ = line;
				_tmp23_->channel = 1;
				break;
			}
			case SANE_FRAME_BLUE:
			{
				ScanLine* _tmp24_;
				_tmp24_ = line;
				_tmp24_->channel = 2;
				break;
			}
			default:
			break;
		}
		_tmp25_ = line;
		_tmp26_ = self->priv->parameters;
		_tmp25_->width = _tmp26_.pixels_per_line;
		_tmp27_ = line;
		_tmp28_ = self->priv->parameters;
		_tmp27_->depth = _tmp28_.depth;
		_tmp29_ = line;
		_tmp30_ = self->priv->buffer;
		_tmp30__length1 = self->priv->buffer_length1;
		self->priv->buffer = NULL;
		self->priv->buffer_length1 = 0;
		_tmp29_->data = (g_free (_tmp29_->data), NULL);
		_tmp29_->data = _tmp30_;
		_tmp29_->data_length1 = _tmp30__length1;
		_tmp31_ = line;
		_tmp32_ = self->priv->parameters;
		_tmp31_->data_length = _tmp32_.bytes_per_line;
		_tmp33_ = line;
		_tmp33_->number = self->priv->line_count;
		_tmp34_ = line;
		_tmp35_ = line;
		_tmp34_->n_lines = self->priv->n_used / _tmp35_->data_length;
		_tmp36_ = line;
		self->priv->line_count = self->priv->line_count + _tmp36_->n_lines;
		_tmp37_ = line;
		_tmp38_ = _tmp37_->data;
		_tmp38__length1 = _tmp37_->data_length1;
		buffer_size = _tmp38__length1;
		if (full_read) {
			SANE_Parameters _tmp39_;
			_tmp39_ = self->priv->parameters;
			buffer_size += _tmp39_.bytes_per_line;
		}
		_tmp40_ = g_new0 (guchar, buffer_size);
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
		self->priv->buffer = _tmp40_;
		self->priv->buffer_length1 = buffer_size;
		self->priv->_buffer_size_ = self->priv->buffer_length1;
		_tmp41_ = line;
		_tmp42_ = line;
		n_remaining = self->priv->n_used - (_tmp41_->n_lines * _tmp42_->data_length);
		self->priv->n_used = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp43_ = FALSE;
				_tmp43_ = TRUE;
				while (TRUE) {
					guchar* _tmp45_;
					gint _tmp45__length1;
					ScanLine* _tmp46_;
					guchar* _tmp47_;
					gint _tmp47__length1;
					ScanLine* _tmp48_;
					ScanLine* _tmp49_;
					guchar _tmp50_;
					gint _tmp51_;
					if (!_tmp43_) {
						gint _tmp44_;
						_tmp44_ = i;
						i = _tmp44_ + 1;
					}
					_tmp43_ = FALSE;
					if (!(i < n_remaining)) {
						break;
					}
					_tmp45_ = self->priv->buffer;
					_tmp45__length1 = self->priv->buffer_length1;
					_tmp46_ = line;
					_tmp47_ = _tmp46_->data;
					_tmp47__length1 = _tmp46_->data_length1;
					_tmp48_ = line;
					_tmp49_ = line;
					_tmp50_ = _tmp47_[i + (_tmp48_->n_lines * _tmp49_->data_length)];
					_tmp45_[i] = _tmp50_;
					_tmp51_ = self->priv->n_used;
					self->priv->n_used = _tmp51_ + 1;
				}
			}
		}
		_tmp55_ = self->priv->parameters;
		if (_tmp55_.depth == 8) {
			SANE_Parameters _tmp56_;
			_tmp56_ = self->priv->parameters;
			_tmp54_ = _tmp56_.format == SANE_FRAME_GRAY;
		} else {
			_tmp54_ = FALSE;
		}
		if (_tmp54_) {
			ScanJob* _tmp57_;
			_tmp57_ = job;
			_tmp53_ = _tmp57_->depth == 2;
		} else {
			_tmp53_ = FALSE;
		}
		if (_tmp53_) {
			ScanJob* _tmp58_;
			_tmp58_ = job;
			_tmp52_ = _tmp58_->scan_mode == SCAN_MODE_GRAY;
		} else {
			_tmp52_ = FALSE;
		}
		if (_tmp52_) {
			guchar block = '\0';
			gint write_offset = 0;
			gint block_shift = 0;
			ScanLine* _tmp75_;
			ScanLine* _tmp76_;
			block = (guchar) 0;
			write_offset = 0;
			block_shift = 6;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp59_ = FALSE;
					_tmp59_ = TRUE;
					while (TRUE) {
						ScanLine* _tmp61_;
						gint offset = 0;
						ScanLine* _tmp62_;
						if (!_tmp59_) {
							gint _tmp60_;
							_tmp60_ = i;
							i = _tmp60_ + 1;
						}
						_tmp59_ = FALSE;
						_tmp61_ = line;
						if (!(i < _tmp61_->n_lines)) {
							break;
						}
						_tmp62_ = line;
						offset = i * _tmp62_->data_length;
						{
							gint x = 0;
							x = 0;
							{
								gboolean _tmp63_ = FALSE;
								_tmp63_ = TRUE;
								while (TRUE) {
									ScanLine* _tmp65_;
									guchar p = '\0';
									ScanLine* _tmp66_;
									guchar* _tmp67_;
									gint _tmp67__length1;
									guchar _tmp68_;
									guchar sample = '\0';
									if (!_tmp63_) {
										gint _tmp64_;
										_tmp64_ = x;
										x = _tmp64_ + 1;
									}
									_tmp63_ = FALSE;
									_tmp65_ = line;
									if (!(x < _tmp65_->width)) {
										break;
									}
									_tmp66_ = line;
									_tmp67_ = _tmp66_->data;
									_tmp67__length1 = _tmp66_->data_length1;
									_tmp68_ = _tmp67_[offset + x];
									p = _tmp68_;
									if (((gint) p) >= 192) {
										sample = (guchar) 3;
									} else {
										if (((gint) p) >= 128) {
											sample = (guchar) 2;
										} else {
											if (((gint) p) >= 64) {
												sample = (guchar) 1;
											} else {
												sample = (guchar) 0;
											}
										}
									}
									block |= (guchar) (sample << block_shift);
									if (block_shift == 0) {
										ScanLine* _tmp69_;
										guchar* _tmp70_;
										gint _tmp70__length1;
										gint _tmp71_;
										_tmp69_ = line;
										_tmp70_ = _tmp69_->data;
										_tmp70__length1 = _tmp69_->data_length1;
										_tmp70_[write_offset] = block;
										_tmp71_ = write_offset;
										write_offset = _tmp71_ + 1;
										block = (guchar) 0;
										block_shift = 6;
									} else {
										block_shift -= 2;
									}
								}
							}
						}
						if (block_shift != 6) {
							ScanLine* _tmp72_;
							guchar* _tmp73_;
							gint _tmp73__length1;
							gint _tmp74_;
							_tmp72_ = line;
							_tmp73_ = _tmp72_->data;
							_tmp73__length1 = _tmp72_->data_length1;
							_tmp73_[write_offset] = block;
							_tmp74_ = write_offset;
							write_offset = _tmp74_ + 1;
							block = (guchar) 0;
							block_shift = 6;
						}
					}
				}
			}
			_tmp75_ = line;
			_tmp76_ = line;
			_tmp75_->data_length = ((_tmp76_->width * 2) + 7) / 8;
		}
		_tmp77_ = job;
		_tmp78_ = line;
		_tmp79_ = notify_got_line_new (_tmp77_->id, _tmp78_);
		_tmp80_ = _tmp79_;
		scanner_notify_event (self, (Notify*) _tmp80_);
		_notify_unref0 (_tmp80_);
		_g_object_unref0 (line);
	}
	_g_object_unref0 (job);
}

static void
_scanner_authorization_cb_sane_authcallback (const gchar* resource,
                                             gchar* username,
                                             gchar* password)
{
	scanner_authorization_cb (resource, username, -1, password, -1);
}

static void*
scanner_scan_thread (Scanner* self)
{
	SANE_Int version_code = {0};
	SANE_Status status = 0;
	SANE_Int _tmp0_ = {0};
	SANE_Status _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->state = SCAN_STATE_IDLE;
	_tmp1_ = sane_init (&_tmp0_, _scanner_authorization_cb_sane_authcallback);
	version_code = _tmp0_;
	status = _tmp1_;
	_tmp2_ = sane_status_to_string (status);
	_tmp3_ = _tmp2_;
	g_debug ("scanner.vala:1620: sane_init () -> %s", _tmp3_);
	_g_free0 (_tmp3_);
	if (status != SANE_STATUS_GOOD) {
		const gchar* _tmp4_;
		_tmp4_ = sane_strstatus (status);
		g_warning ("scanner.vala:1623: Unable to initialize SANE backend: %s", _tmp4_);
		result = NULL;
		return result;
	}
	g_debug ("scanner.vala:1626: SANE version %d.%d.%d", SANE_VERSION_MAJOR (version_code), SANE_VERSION_MINOR (version_code), SANE_VERSION_BUILD (version_code));
	scanner_redetect (self);
	while (TRUE) {
		if (!scanner_handle_requests (self)) {
			break;
		}
		switch (self->priv->state) {
			case SCAN_STATE_IDLE:
			{
				GList* _tmp5_;
				_tmp5_ = self->priv->job_queue;
				if (_tmp5_ != NULL) {
					scanner_set_scanning (self, TRUE);
					self->priv->state = SCAN_STATE_OPEN;
				}
				break;
			}
			case SCAN_STATE_REDETECT:
			{
				scanner_do_redetect (self);
				break;
			}
			case SCAN_STATE_OPEN:
			{
				scanner_do_open (self);
				break;
			}
			case SCAN_STATE_GET_OPTION:
			{
				scanner_do_get_option (self);
				break;
			}
			case SCAN_STATE_START:
			{
				scanner_do_start (self);
				break;
			}
			case SCAN_STATE_GET_PARAMETERS:
			{
				scanner_do_get_parameters (self);
				break;
			}
			case SCAN_STATE_READ:
			{
				scanner_do_read (self);
				break;
			}
			default:
			break;
		}
	}
	result = NULL;
	return result;
}

static gpointer
_scanner_scan_thread_gthread_func (gpointer self)
{
	gpointer result;
	result = scanner_scan_thread ((Scanner*) self);
	g_object_unref (self);
	return result;
}

void
scanner_start (Scanner* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GThread* _tmp0_ = NULL;
		GThread* _tmp1_;
		GThread* _tmp2_;
		_tmp1_ = g_thread_try_new ("scan-thread", _scanner_scan_thread_gthread_func, g_object_ref (self), &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = _tmp2_;
		_g_thread_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("scanner.vala:1677: Unable to create thread: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
scanner_redetect (Scanner* self)
{
	GAsyncQueue* _tmp0_;
	RequestRedetect* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->need_redetect) {
		return;
	}
	self->priv->need_redetect = TRUE;
	g_debug ("scanner.vala:1687: Requesting redetection of scan devices");
	_tmp0_ = self->priv->request_queue;
	_tmp1_ = request_redetect_new ();
	g_async_queue_push (_tmp0_, (Request*) _tmp1_);
}

gboolean
scanner_is_scanning (Scanner* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->scanning;
	return result;
}

static gchar*
scanner_get_scan_mode_string (Scanner* self,
                              ScanMode mode)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (mode) {
		case SCAN_MODE_DEFAULT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("ScanMode.DEFAULT");
			result = _tmp0_;
			return result;
		}
		case SCAN_MODE_COLOR:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ScanMode.COLOR");
			result = _tmp1_;
			return result;
		}
		case SCAN_MODE_GRAY:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("ScanMode.GRAY");
			result = _tmp2_;
			return result;
		}
		case SCAN_MODE_LINEART:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("ScanMode.LINEART");
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup_printf ("%d", (gint) mode);
			result = _tmp4_;
			return result;
		}
	}
}

gchar*
scanner_type_to_string (ScanType type)
{
	gchar* result;
	switch (type) {
		case SCAN_TYPE_SINGLE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("single");
			result = _tmp0_;
			return result;
		}
		case SCAN_TYPE_BATCH:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("batch");
			result = _tmp1_;
			return result;
		}
		case SCAN_TYPE_ADF:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("adf");
			result = _tmp2_;
			return result;
		}
		default:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup_printf ("%d", (gint) type);
			result = _tmp3_;
			return result;
		}
	}
}

ScanType
scanner_type_from_string (const gchar* type)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	ScanType result;
	g_return_val_if_fail (type != NULL, 0);
	_tmp0_ = type;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("single")))) {
		switch (0) {
			default:
			{
				result = SCAN_TYPE_SINGLE;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("batch")))) {
		switch (0) {
			default:
			{
				result = SCAN_TYPE_BATCH;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("adf")))) {
		switch (0) {
			default:
			{
				result = SCAN_TYPE_ADF;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warning ("scanner.vala:1740: Unknown ScanType: %s. Please report this error.", type);
				result = SCAN_TYPE_SINGLE;
				return result;
			}
		}
	}
}

gchar*
scanner_side_to_string (ScanSide side)
{
	gchar* result;
	switch (side) {
		case SCAN_SIDE_FRONT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("front");
			result = _tmp0_;
			return result;
		}
		case SCAN_SIDE_BACK:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("back");
			result = _tmp1_;
			return result;
		}
		case SCAN_SIDE_BOTH:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("both");
			result = _tmp2_;
			return result;
		}
		default:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup_printf ("%d", (gint) side);
			result = _tmp3_;
			return result;
		}
	}
}

ScanSide
scanner_side_from_string (const gchar* side)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	ScanSide result;
	g_return_val_if_fail (side != NULL, 0);
	_tmp0_ = side;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("front")))) {
		switch (0) {
			default:
			{
				result = SCAN_SIDE_FRONT;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("back")))) {
		switch (0) {
			default:
			{
				result = SCAN_SIDE_BACK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("both")))) {
		switch (0) {
			default:
			{
				result = SCAN_SIDE_BOTH;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warning ("scanner.vala:1771: Unknown ScanSide: %s. Please report this error.", side);
				result = SCAN_SIDE_FRONT;
				return result;
			}
		}
	}
}

void
scanner_scan (Scanner* self,
              const gchar* device,
              ScanOptions* options)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	RequestStartScan* request = NULL;
	RequestStartScan* _tmp7_;
	ScanJob* _tmp8_;
	ScanJob* _tmp9_;
	gint _tmp10_;
	ScanJob* _tmp11_;
	gchar* _tmp12_;
	ScanJob* _tmp13_;
	ScanJob* _tmp14_;
	ScanJob* _tmp15_;
	ScanJob* _tmp16_;
	ScanJob* _tmp17_;
	ScanJob* _tmp18_;
	ScanJob* _tmp19_;
	ScanJob* _tmp20_;
	ScanJob* _tmp21_;
	ScanJob* _tmp22_;
	GAsyncQueue* _tmp23_;
	Request* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (options != NULL);
	if (device != NULL) {
		_tmp0_ = device;
	} else {
		_tmp0_ = "(null)";
	}
	_tmp1_ = scanner_get_scan_mode_string (self, options->scan_mode);
	_tmp2_ = _tmp1_;
	_tmp3_ = scanner_type_to_string (options->type);
	_tmp4_ = _tmp3_;
	_tmp5_ = scanner_side_to_string (options->side);
	_tmp6_ = _tmp5_;
	g_debug ("scanner.vala:1778: Scanner.scan (\"%s\", dpi=%d, scan_mode=%s, depth=%" \
"d, type=%s, side=%s, paper_width=%d, paper_height=%d, brightness=%d, c" \
"ontrast=%d, delay=%dms)", _tmp0_, options->dpi, _tmp2_, options->depth, _tmp4_, _tmp6_, options->paper_width, options->paper_height, options->brightness, options->contrast, options->page_delay);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = request_start_scan_new ();
	request = _tmp7_;
	_tmp8_ = scan_job_new ();
	_g_object_unref0 (request->job);
	request->job = _tmp8_;
	_tmp9_ = request->job;
	_tmp10_ = self->job_id;
	self->job_id = _tmp10_ + 1;
	_tmp9_->id = _tmp10_;
	_tmp11_ = request->job;
	_tmp12_ = g_strdup (device);
	_g_free0 (_tmp11_->device);
	_tmp11_->device = _tmp12_;
	_tmp13_ = request->job;
	_tmp13_->dpi = (gdouble) options->dpi;
	_tmp14_ = request->job;
	_tmp14_->scan_mode = options->scan_mode;
	_tmp15_ = request->job;
	_tmp15_->depth = options->depth;
	_tmp16_ = request->job;
	_tmp16_->type = options->type;
	_tmp17_ = request->job;
	_tmp17_->side = options->side;
	_tmp18_ = request->job;
	_tmp18_->page_width = options->paper_width;
	_tmp19_ = request->job;
	_tmp19_->page_height = options->paper_height;
	_tmp20_ = request->job;
	_tmp20_->brightness = options->brightness;
	_tmp21_ = request->job;
	_tmp21_->contrast = options->contrast;
	_tmp22_ = request->job;
	_tmp22_->page_delay = options->page_delay;
	_tmp23_ = self->priv->request_queue;
	_tmp24_ = _request_ref0 ((Request*) request);
	g_async_queue_push (_tmp23_, _tmp24_);
	_request_unref0 (request);
}

void
scanner_cancel (Scanner* self)
{
	GAsyncQueue* _tmp0_;
	RequestCancel* _tmp1_;
	g_return_if_fail (self != NULL);
	self->first_job_id = self->job_id;
	_tmp0_ = self->priv->request_queue;
	_tmp1_ = request_cancel_new ();
	g_async_queue_push (_tmp0_, (Request*) _tmp1_);
}

void
scanner_free (Scanner* self)
{
	GAsyncQueue* _tmp0_;
	RequestQuit* _tmp1_;
	GThread* _tmp2_;
	g_return_if_fail (self != NULL);
	g_debug ("scanner.vala:1808: Stopping scan thread");
	_tmp0_ = self->priv->request_queue;
	_tmp1_ = request_quit_new ();
	g_async_queue_push (_tmp0_, (Request*) _tmp1_);
	_tmp2_ = self->priv->thread;
	if (_tmp2_ != NULL) {
		GThread* _tmp3_;
		_tmp3_ = self->priv->thread;
		self->priv->thread = NULL;
		g_thread_join (_tmp3_);
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = NULL;
	}
	sane_exit ();
	g_debug ("scanner.vala:1819: sane_exit ()");
}

static void
g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
scanner_class_init (ScannerClass * klass,
                    gpointer klass_data)
{
	scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Scanner_private_offset);
	G_OBJECT_CLASS (klass)->finalize = scanner_finalize;
	scanner_signals[SCANNER_UPDATE_DEVICES_SIGNAL] = g_signal_new ("update-devices", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	scanner_signals[SCANNER_REQUEST_AUTHORIZATION_SIGNAL] = g_signal_new ("request-authorization", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	scanner_signals[SCANNER_EXPECT_PAGE_SIGNAL] = g_signal_new ("expect-page", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	scanner_signals[SCANNER_GOT_PAGE_INFO_SIGNAL] = g_signal_new ("got-page-info", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SCAN_PAGE_INFO);
	scanner_signals[SCANNER_GOT_LINE_SIGNAL] = g_signal_new ("got-line", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SCAN_LINE);
	scanner_signals[SCANNER_SCAN_FAILED_SIGNAL] = g_signal_new ("scan-failed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_STRING, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_STRING);
	scanner_signals[SCANNER_PAGE_DONE_SIGNAL] = g_signal_new ("page-done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	scanner_signals[SCANNER_DOCUMENT_DONE_SIGNAL] = g_signal_new ("document-done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	scanner_signals[SCANNER_SCANNING_CHANGED_SIGNAL] = g_signal_new ("scanning-changed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
scanner_instance_init (Scanner * self,
                       gpointer klass)
{
	self->priv = scanner_get_instance_private (self);
}

static void
scanner_finalize (GObject * obj)
{
	Scanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCANNER, Scanner);
	_g_thread_unref0 (self->priv->thread);
	_g_async_queue_unref0 (self->priv->request_queue);
	_g_async_queue_unref0 (self->priv->notify_queue);
	_g_async_queue_unref0 (self->priv->authorize_queue);
	_g_free0 (self->priv->default_device);
	(self->priv->job_queue == NULL) ? NULL : (self->priv->job_queue = (_g_list_free__g_object_unref0_ (self->priv->job_queue), NULL));
	_g_free0 (self->priv->current_device);
	_g_hash_table_unref0 (self->priv->options);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	G_OBJECT_CLASS (scanner_parent_class)->finalize (obj);
}

static GType
scanner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scanner), 0, (GInstanceInitFunc) scanner_instance_init, NULL };
	GType scanner_type_id;
	scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "Scanner", &g_define_type_info, 0);
	Scanner_private_offset = g_type_add_instance_private (scanner_type_id, sizeof (ScannerPrivate));
	return scanner_type_id;
}

GType
scanner_get_type (void)
{
	static volatile gsize scanner_type_id__once = 0;
	if (g_once_init_enter (&scanner_type_id__once)) {
		GType scanner_type_id;
		scanner_type_id = scanner_get_type_once ();
		g_once_init_leave (&scanner_type_id__once, scanner_type_id);
	}
	return scanner_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

