/* app-window.c generated by valac 0.56.0, the Vala compiler
 * generated from app-window.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>,
 *         Eduard Gotwig <g@ox.io>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <handy.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define DEFAULT_TEXT_DPI 150
#define DEFAULT_PHOTO_DPI 300
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
typedef struct _AppWindowPrivate AppWindowPrivate;
typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF,
	SCAN_TYPE_BATCH
} ScanType;

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;
enum  {
	APP_WINDOW_0_PROPERTY,
	APP_WINDOW_BOOK_PROPERTY,
	APP_WINDOW_SELECTED_PAGE_PROPERTY,
	APP_WINDOW_SCANNING_PROPERTY,
	APP_WINDOW_BRIGHTNESS_PROPERTY,
	APP_WINDOW_CONTRAST_PROPERTY,
	APP_WINDOW_PAGE_DELAY_PROPERTY,
	APP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* app_window_properties[APP_WINDOW_NUM_PROPERTIES];

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _autosave_manager_unref0(var) ((var == NULL) ? NULL : (var = (autosave_manager_unref (var), NULL)))

#define TYPE_AUTHORIZE_DIALOG (authorize_dialog_get_type ())
#define AUTHORIZE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTHORIZE_DIALOG, AuthorizeDialog))
#define AUTHORIZE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTHORIZE_DIALOG, AuthorizeDialogClass))
#define IS_AUTHORIZE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTHORIZE_DIALOG))
#define IS_AUTHORIZE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTHORIZE_DIALOG))
#define AUTHORIZE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTHORIZE_DIALOG, AuthorizeDialogClass))

typedef struct _AuthorizeDialog AuthorizeDialog;
typedef struct _AuthorizeDialogClass AuthorizeDialogClass;

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
typedef struct _Block1Data Block1Data;

#define TYPE_CANCELLABLE_PROGRESS_BAR (cancellable_progress_bar_get_type ())
#define CANCELLABLE_PROGRESS_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANCELLABLE_PROGRESS_BAR, CancellableProgressBar))
#define CANCELLABLE_PROGRESS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANCELLABLE_PROGRESS_BAR, CancellableProgressBarClass))
#define IS_CANCELLABLE_PROGRESS_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANCELLABLE_PROGRESS_BAR))
#define IS_CANCELLABLE_PROGRESS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANCELLABLE_PROGRESS_BAR))
#define CANCELLABLE_PROGRESS_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANCELLABLE_PROGRESS_BAR, CancellableProgressBarClass))

typedef struct _CancellableProgressBar CancellableProgressBar;
typedef struct _CancellableProgressBarClass CancellableProgressBarClass;
typedef struct _Block2Data Block2Data;
typedef void (*ProgressionCallback) (gdouble fraction, gpointer user_data);
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AppWindowSaveDocumentAsyncData AppWindowSaveDocumentAsyncData;
typedef struct _AppWindowPromptToSaveAsyncData AppWindowPromptToSaveAsyncData;

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef enum  {
	SCAN_SIDE_FRONT,
	SCAN_SIDE_BACK,
	SCAN_SIDE_BOTH
} ScanSide;

#define TYPE_SCAN_SIDE (scan_side_get_type ())
typedef struct _Block3Data Block3Data;

#define TYPE_PAGE_ICON (page_icon_get_type ())
#define PAGE_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_ICON, PageIcon))
#define PAGE_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_ICON, PageIconClass))
#define IS_PAGE_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_ICON))
#define IS_PAGE_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_ICON))
#define PAGE_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_ICON, PageIconClass))

typedef struct _PageIcon PageIcon;
typedef struct _PageIconClass PageIconClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _AppWindowEmailDocumentAsyncData AppWindowEmailDocumentAsyncData;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
enum  {
	APP_WINDOW_START_SCAN_SIGNAL,
	APP_WINDOW_STOP_SCAN_SIGNAL,
	APP_WINDOW_REDETECT_SIGNAL,
	APP_WINDOW_NUM_SIGNALS
};
static guint app_window_signals[APP_WINDOW_NUM_SIGNALS] = {0};
typedef struct _CancellableProgressBarPrivate CancellableProgressBarPrivate;
enum  {
	CANCELLABLE_PROGRESS_BAR_0_PROPERTY,
	CANCELLABLE_PROGRESS_BAR_NUM_PROPERTIES
};
static GParamSpec* cancellable_progress_bar_properties[CANCELLABLE_PROGRESS_BAR_NUM_PROPERTIES];
typedef struct _Block4Data Block4Data;

struct _AppWindow {
	HdyApplicationWindow parent_instance;
	AppWindowPrivate * priv;
};

struct _AppWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _AppWindowPrivate {
	GSettings* settings;
	ScanType scan_type;
	PreferencesDialog* preferences_dialog;
	gboolean setting_devices;
	gboolean user_selected_device;
	HdyHeaderBar* header_bar;
	GtkMenu* page_menu;
	GtkStack* stack;
	HdyStatusPage* status_page;
	GtkLabel* status_secondary_label;
	GtkListStore* device_model;
	GtkBox* device_buttons_box;
	GtkComboBox* device_combo;
	GtkBox* main_vbox;
	GtkRadioMenuItem* custom_crop_menuitem;
	GtkRadioMenuItem* a3_menuitem;
	GtkRadioMenuItem* a4_menuitem;
	GtkRadioMenuItem* a5_menuitem;
	GtkRadioMenuItem* a6_menuitem;
	GtkRadioMenuItem* letter_menuitem;
	GtkRadioMenuItem* legal_menuitem;
	GtkRadioMenuItem* four_by_six_menuitem;
	GtkRadioMenuItem* no_crop_menuitem;
	GtkMenuItem* page_move_left_menuitem;
	GtkMenuItem* page_move_right_menuitem;
	GtkMenuItem* page_delete_menuitem;
	GtkMenuItem* crop_rotate_menuitem;
	GtkMenuItem* copy_to_clipboard_menuitem;
	GtkButton* save_button;
	GtkButton* stop_button;
	GtkButton* scan_button;
	GtkActionBar* action_bar;
	GtkToggleButton* crop_button;
	GtkButton* delete_button;
	GtkImage* scan_options_image;
	GtkImage* scan_hint_image;
	GtkRadioButton* scan_single_radio;
	GtkRadioButton* scan_adf_radio;
	GtkRadioButton* scan_batch_radio;
	GtkRadioButton* text_radio;
	GtkRadioButton* photo_radio;
	GtkMenuButton* menu_button;
	gboolean have_devices;
	gchar* missing_driver;
	Book* _book;
	gboolean book_needs_saving;
	gchar* book_uri;
	AutosaveManager* autosave_manager;
	BookView* book_view;
	gboolean updating_page_menu;
	gchar* document_hint;
	gboolean scanning_;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	gboolean window_is_fullscreen;
	guint save_state_timeout;
};

struct _ScanDevice {
	GObject parent_instance;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	AppWindow* self;
	GtkFileChooserNative* save_dialog;
	GtkListStore* file_type_store;
	GtkComboBox* file_type_combo;
	GtkLabel* quality_label;
	GtkAdjustment* quality_adjustment;
	GtkScale* quality_scale;
};

struct _Block2Data {
	int _ref_count_;
	AppWindow* self;
	CancellableProgressBar* progress_bar;
	gpointer _async_data_;
};

struct _AppWindowSaveDocumentAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AppWindow* self;
	gboolean result;
	Block2Data* _data2_;
	gchar* uri;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* file;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	const gchar* _tmp4_;
	gchar* mime_type;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GCancellable* cancellable;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	CancellableProgressBar* _tmp9_;
	GtkActionBar* _tmp10_;
	CancellableProgressBar* _tmp11_;
	CancellableProgressBar* _tmp12_;
	GtkButton* _tmp13_;
	Book* _tmp14_;
	const gchar* _tmp15_;
	GSettings* _tmp16_;
	GFile* _tmp17_;
	GSettings* _tmp18_;
	GSettings* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GSettings* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GSettings* _tmp25_;
	GCancellable* _tmp26_;
	GError* e;
	GtkButton* _tmp27_;
	CancellableProgressBar* _tmp28_;
	GError* _tmp29_;
	const gchar* _tmp30_;
	GError* _tmp31_;
	const gchar* _tmp32_;
	GtkButton* _tmp33_;
	CancellableProgressBar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	GError* _inner_error0_;
};

struct _AppWindowPromptToSaveAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AppWindow* self;
	gchar* title;
	gchar* discard_label;
	gboolean result;
	gboolean _tmp0_;
	Book* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GtkMessageDialog* dialog;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* _tmp5_;
	GtkMessageDialog* _tmp6_;
	GtkMessageDialog* _tmp7_;
	GtkMessageDialog* _tmp8_;
	gint response;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* _tmp10_;
};

struct _ScanOptions {
	GObject parent_instance;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	ScanSide side;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
	gint page_delay;
};

struct _ScanOptionsClass {
	GObjectClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	AppWindow* self;
	GtkWindow* dialog;
};

struct _AppWindowEmailDocumentAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AppWindow* self;
	gchar* dir;
	gchar* _tmp0_;
	gchar* mime_type;
	gchar* filename;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* file;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	Book* _tmp12_;
	const gchar* _tmp13_;
	GSettings* _tmp14_;
	GFile* _tmp15_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GSettings* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GSettings* _tmp23_;
	gchar* command_line;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GFile* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gint i;
	gboolean _tmp33_;
	gint _tmp34_;
	Book* _tmp35_;
	guint _tmp36_;
	guint _tmp37_;
	GFile* indexed_file;
	GFile* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	Book* _tmp41_;
	guint _tmp42_;
	guint _tmp43_;
	GFile* _tmp44_;
	GFile* _tmp45_;
	const gchar* _tmp46_;
	GFile* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	const gchar* _tmp53_;
	GError* e;
	GError* _tmp54_;
	const gchar* _tmp55_;
	GError* _inner_error0_;
};

struct _CancellableProgressBar {
	GtkHBox parent_instance;
	CancellableProgressBarPrivate * priv;
};

struct _CancellableProgressBarClass {
	GtkHBoxClass parent_class;
};

struct _CancellableProgressBarPrivate {
	GtkProgressBar* bar;
	GtkButton* button;
};

struct _Block4Data {
	int _ref_count_;
	CancellableProgressBar* self;
	GCancellable* cancellable;
};

static gint AppWindow_private_offset;
static gpointer app_window_parent_class = NULL;
static gchar* app_window_STATE_DIR;
static gchar* app_window_STATE_DIR = NULL;
static gint CancellableProgressBar_private_offset;
static gpointer cancellable_progress_bar_parent_class = NULL;

VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN GType scan_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PreferencesDialog, g_object_unref)
VALA_EXTERN GType book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Book, g_object_unref)
VALA_EXTERN gpointer autosave_manager_ref (gpointer instance);
VALA_EXTERN void autosave_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_autosave_manager (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_autosave_manager (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_autosave_manager (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_autosave_manager (const GValue* value);
VALA_EXTERN GType autosave_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AutosaveManager, autosave_manager_unref)
VALA_EXTERN GType book_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookView, g_object_unref)
VALA_EXTERN Book* app_window_get_book (AppWindow* self);
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
static void app_window_page_added_cb (AppWindow* self,
                               Book* book,
                               Page* page);
static void _app_window_page_added_cb_book_page_added (Book* _sender,
                                                Page* page,
                                                gpointer self);
static void app_window_reordered_cb (AppWindow* self,
                              Book* book);
static void _app_window_reordered_cb_book_reordered (Book* _sender,
                                              gpointer self);
static void app_window_page_removed_cb (AppWindow* self,
                                 Book* book,
                                 Page* page);
static void _app_window_page_removed_cb_book_page_removed (Book* _sender,
                                                    Page* page,
                                                    gpointer self);
static void app_window_new_document_cb (AppWindow* self);
static void _app_window_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void app_window_scan_single_cb (AppWindow* self);
static void _app_window_scan_single_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void app_window_scan_adf_cb (AppWindow* self);
static void _app_window_scan_adf_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void app_window_scan_batch_cb (AppWindow* self);
static void _app_window_scan_batch_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void app_window_scan_stop_cb (AppWindow* self);
static void _app_window_scan_stop_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void app_window_rotate_left_cb (AppWindow* self);
static void _app_window_rotate_left_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void app_window_rotate_right_cb (AppWindow* self);
static void _app_window_rotate_right_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void app_window_move_left_cb (AppWindow* self);
static void _app_window_move_left_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void app_window_move_right_cb (AppWindow* self);
static void _app_window_move_right_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void app_window_copy_page_cb (AppWindow* self);
static void _app_window_copy_page_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void app_window_delete_page_cb (AppWindow* self);
static void _app_window_delete_page_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void app_window_reorder_document_cb (AppWindow* self);
static void _app_window_reorder_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
VALA_EXTERN void app_window_save_document_activate_cb (AppWindow* self);
static void _app_window_save_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void app_window_email_document_cb (AppWindow* self);
static void _app_window_email_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void app_window_print_document_cb (AppWindow* self);
static void _app_window_print_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void app_window_preferences_cb (AppWindow* self);
static void _app_window_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void app_window_help_cb (AppWindow* self);
static void _app_window_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void app_window_about_cb (AppWindow* self);
static void _app_window_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void app_window_quit_cb (AppWindow* self);
static void _app_window_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN AppWindow* app_window_new (void);
VALA_EXTERN AppWindow* app_window_construct (GType object_type);
VALA_EXTERN Book* book_new (void);
VALA_EXTERN Book* book_construct (GType object_type);
static void app_window_set_book (AppWindow* self,
                          Book* value);
static void app_window_book_changed_cb (AppWindow* self,
                                 Book* book);
static void _app_window_book_changed_cb_book_changed (Book* _sender,
                                               gpointer self);
static void app_window_load (AppWindow* self);
static void app_window_clear_document (AppWindow* self);
VALA_EXTERN void app_window_show_error_dialog (AppWindow* self,
                                   const gchar* error_title,
                                   const gchar* error_text);
VALA_EXTERN void app_window_authorize (AppWindow* self,
                           const gchar* resource,
                           gchar** username,
                           gchar** password);
VALA_EXTERN GType authorize_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AuthorizeDialog, g_object_unref)
VALA_EXTERN AuthorizeDialog* authorize_dialog_new (const gchar* title);
VALA_EXTERN AuthorizeDialog* authorize_dialog_construct (GType object_type,
                                             const gchar* title);
VALA_EXTERN gchar* authorize_dialog_get_username (AuthorizeDialog* self);
VALA_EXTERN gchar* authorize_dialog_get_password (AuthorizeDialog* self);
static void app_window_update_scan_status (AppWindow* self);
static gchar* app_window_get_selected_device (AppWindow* self);
static gchar* app_window_get_selected_device_label (AppWindow* self);
VALA_EXTERN GType scan_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanDevice, g_object_unref)
VALA_EXTERN void app_window_set_scan_devices (AppWindow* self,
                                  GList* devices,
                                  const gchar* missing_driver);
static gboolean app_window_find_scan_device (AppWindow* self,
                                      const gchar* device,
                                      GtkTreeIter* iter);
static gboolean app_window_prompt_to_load_autosaved_book (AppWindow* self);
VALA_EXTERN void app_window_set_selected_device (AppWindow* self,
                                     const gchar* device);
static gchar* app_window_choose_file_location (AppWindow* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gchar* app_window_mime_type_to_extension (AppWindow* self,
                                          const gchar* mime_type);
static void __lambda26_ (Block1Data* _data1_);
static void ___lambda26__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                gpointer self);
static void __lambda27_ (Block1Data* _data1_);
static void ___lambda27__gtk_combo_box_changed (GtkComboBox* _sender,
                                         gpointer self);
VALA_EXTERN guint book_get_n_pages (Book* self);
VALA_EXTERN GFile* make_indexed_file (const gchar* uri,
                          guint i,
                          guint n_pages);
static gboolean app_window_check_overwrite (AppWindow* self,
                                     GtkWindow* parent,
                                     GList* files);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gchar* app_window_extension_to_mime_type (AppWindow* self,
                                          const gchar* extension);
static gchar* app_window_uri_to_mime_type (AppWindow* self,
                                    const gchar* uri);
static void app_window_save_document_async_data_free (gpointer _data);
static void app_window_save_document_async (AppWindow* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static gboolean app_window_save_document_finish (AppWindow* self,
                                          GAsyncResult* _res_);
static gboolean app_window_save_document_async_co (AppWindowSaveDocumentAsyncData* _data_);
VALA_EXTERN GType cancellable_progress_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CancellableProgressBar, g_object_unref)
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN CancellableProgressBar* cancellable_progress_bar_new (const gchar* text,
                                                      GCancellable* cancellable);
VALA_EXTERN CancellableProgressBar* cancellable_progress_bar_construct (GType object_type,
                                                            const gchar* text,
                                                            GCancellable* cancellable);
VALA_EXTERN void book_save_async (Book* self,
                      const gchar* mime_type,
                      gint quality,
                      GFile* file,
                      gboolean postproc_enabled,
                      const gchar* postproc_script,
                      const gchar* postproc_arguments,
                      gboolean postproc_keep_original,
                      ProgressionCallback progress_cb,
                      gpointer progress_cb_target,
                      GCancellable* cancellable,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_);
VALA_EXTERN void book_save_finish (Book* self,
                       GAsyncResult* _res_,
                       GError** error);
static void ___lambda30_ (Block2Data* _data2_,
                   gdouble fraction);
VALA_EXTERN void cancellable_progress_bar_set_fraction (CancellableProgressBar* self,
                                            gdouble fraction);
static void ____lambda30__progression_callback (gdouble fraction,
                                         gpointer self);
static void app_window_save_document_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
VALA_EXTERN void cancellable_progress_bar_destroy_with_delay (CancellableProgressBar* self,
                                                  guint delay);
static void app_window_prompt_to_save_async_data_free (gpointer _data);
static void app_window_prompt_to_save_async (AppWindow* self,
                                      const gchar* title,
                                      const gchar* discard_label,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean app_window_prompt_to_save_finish (AppWindow* self,
                                           GAsyncResult* _res_);
static gboolean app_window_prompt_to_save_async_co (AppWindowPromptToSaveAsyncData* _data_);
static void app_window_prompt_to_save_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
VALA_EXTERN void book_clear (Book* self);
static void app_window_new_document (AppWindow* self);
static void __lambda31_ (AppWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN gboolean app_window_get_scanning (AppWindow* self);
VALA_EXTERN void autosave_manager_cleanup (AutosaveManager* self);
static void ___lambda31__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean app_window_status_label_activate_link_cb (AppWindow* self,
                                                   GtkLabel* label,
                                                   const gchar* uri);
static void app_window_install_drivers (AppWindow* self);
static gboolean _app_window_status_label_activate_link_cb_gtk_label_activate_link (GtkLabel* _sender,
                                                                            const gchar* uri,
                                                                            gpointer self);
static void app_window_redetect_button_clicked_cb (AppWindow* self,
                                            GtkButton* button);
static void _app_window_redetect_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
VALA_EXTERN GType scan_options_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanOptions, g_object_unref)
static void app_window_scan (AppWindow* self,
                      ScanOptions* options);
static ScanOptions* app_window_make_scan_options (AppWindow* self);
VALA_EXTERN GType scan_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scan_side_get_type (void) G_GNUC_CONST ;
static void app_window_rotate_left_button_clicked_cb (AppWindow* self);
static void app_window_rotate_right_button_clicked_cb (AppWindow* self);
static void app_window_page_move_left_menuitem_activate_cb (AppWindow* self);
static void app_window_page_move_right_menuitem_activate_cb (AppWindow* self);
static void app_window_copy_to_clipboard_button_clicked_cb (AppWindow* self);
static void app_window_page_delete_menuitem_activate_cb (AppWindow* self);
static void app_window_set_scan_type (AppWindow* self,
                               ScanType scan_type);
static void app_window_scan_single_radio_toggled_cb (AppWindow* self,
                                              GtkToggleButton* button);
static void _app_window_scan_single_radio_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                         gpointer self);
static void app_window_scan_adf_radio_toggled_cb (AppWindow* self,
                                           GtkToggleButton* button);
static void _app_window_scan_adf_radio_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                      gpointer self);
static void app_window_scan_batch_radio_toggled_cb (AppWindow* self,
                                             GtkToggleButton* button);
static void _app_window_scan_batch_radio_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                        gpointer self);
static void app_window_set_document_hint (AppWindow* self,
                                   const gchar* document_hint,
                                   gboolean save);
static void app_window_text_radio_toggled_cb (AppWindow* self,
                                       GtkToggleButton* button);
static void _app_window_text_radio_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self);
static void app_window_photo_radio_toggled_cb (AppWindow* self,
                                        GtkToggleButton* button);
static void _app_window_photo_radio_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                   gpointer self);
static void app_window_preferences_button_clicked_cb (AppWindow* self,
                                               GtkButton* button);
static void _app_window_preferences_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
VALA_EXTERN ScanOptions* scan_options_new (void);
VALA_EXTERN ScanOptions* scan_options_construct (GType object_type);
VALA_EXTERN gint preferences_dialog_get_text_dpi (PreferencesDialog* self);
VALA_EXTERN gint preferences_dialog_get_photo_dpi (PreferencesDialog* self);
VALA_EXTERN gboolean preferences_dialog_get_paper_size (PreferencesDialog* self,
                                            gint* width,
                                            gint* height);
VALA_EXTERN gint app_window_get_brightness (AppWindow* self);
VALA_EXTERN gint app_window_get_contrast (AppWindow* self);
VALA_EXTERN gint app_window_get_page_delay (AppWindow* self);
VALA_EXTERN ScanSide preferences_dialog_get_page_side (PreferencesDialog* self);
static void app_window_device_combo_changed_cb (AppWindow* self,
                                         GtkWidget* widget);
static void _app_window_device_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                gpointer self);
static void app_window_scan_button_clicked_cb (AppWindow* self,
                                        GtkWidget* widget);
static void _app_window_scan_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self);
static void app_window_stop_scan_button_clicked_cb (AppWindow* self,
                                             GtkWidget* widget);
static void _app_window_stop_scan_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void app_window_update_page_menu (AppWindow* self);
VALA_EXTERN Page* book_view_get_selected_page (BookView* self);
VALA_EXTERN guint book_get_page_index (Book* self,
                           Page* page);
static void app_window_page_selected_cb (AppWindow* self,
                                  BookView* view,
                                  Page* page);
VALA_EXTERN gboolean page_get_has_crop (Page* self);
VALA_EXTERN const gchar* page_get_crop_name (Page* self);
static void app_window_show_page_cb (AppWindow* self,
                              BookView* view,
                              Page* page);
VALA_EXTERN void page_save_png (Page* self,
                    GFile* file,
                    GError** error);
static void app_window_show_page_menu_cb (AppWindow* self,
                                   BookView* view,
                                   GdkEvent* event);
VALA_EXTERN void page_rotate_left (Page* self);
static void _app_window_rotate_left_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                       gpointer self);
VALA_EXTERN void page_rotate_right (Page* self);
static void _app_window_rotate_right_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                        gpointer self);
static void app_window_set_crop (AppWindow* self,
                          const gchar* crop_name);
VALA_EXTERN void page_set_no_crop (Page* self);
VALA_EXTERN gint page_get_width (Page* self);
VALA_EXTERN gint page_get_height (Page* self);
VALA_EXTERN void page_set_custom_crop (Page* self,
                           gint width,
                           gint height);
VALA_EXTERN void page_move_crop (Page* self,
                     gint x,
                     gint y);
VALA_EXTERN void page_set_named_crop (Page* self,
                          const gchar* name);
static void app_window_no_crop_menuitem_toggled_cb (AppWindow* self,
                                             GtkCheckMenuItem* widget);
static void _app_window_no_crop_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                          gpointer self);
static void app_window_custom_crop_menuitem_toggled_cb (AppWindow* self,
                                                 GtkCheckMenuItem* widget);
static void _app_window_custom_crop_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                              gpointer self);
static void app_window_four_by_six_menuitem_toggled_cb (AppWindow* self,
                                                 GtkCheckMenuItem* widget);
static void _app_window_four_by_six_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                              gpointer self);
static void app_window_legal_menuitem_toggled_cb (AppWindow* self,
                                           GtkCheckMenuItem* widget);
static void _app_window_legal_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                        gpointer self);
static void app_window_letter_menuitem_toggled_cb (AppWindow* self,
                                            GtkCheckMenuItem* widget);
static void _app_window_letter_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                         gpointer self);
static void app_window_a6_menuitem_toggled_cb (AppWindow* self,
                                        GtkCheckMenuItem* widget);
static void _app_window_a6_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                     gpointer self);
static void app_window_a5_menuitem_toggled_cb (AppWindow* self,
                                        GtkCheckMenuItem* widget);
static void _app_window_a5_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                     gpointer self);
static void app_window_a4_menuitem_toggled_cb (AppWindow* self,
                                        GtkCheckMenuItem* widget);
static void _app_window_a4_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                     gpointer self);
static void app_window_a3_menuitem_toggled_cb (AppWindow* self,
                                        GtkCheckMenuItem* widget);
static void _app_window_a3_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                     gpointer self);
static void app_window_crop_rotate_menuitem_activate_cb (AppWindow* self);
VALA_EXTERN void page_rotate_crop (Page* self);
static void _app_window_crop_rotate_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                          gpointer self);
VALA_EXTERN void book_move_page (Book* self,
                     Page* page,
                     guint location);
static void _app_window_page_move_left_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                             gpointer self);
static void _app_window_page_move_right_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                              gpointer self);
VALA_EXTERN Book* book_view_get_book (BookView* self);
VALA_EXTERN void book_delete_page (Book* self,
                       Page* page);
static void _app_window_page_delete_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                          gpointer self);
static void app_window_reorder_document (AppWindow* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda32_ (Block3Data* _data3_,
                      GdkEventKey* e);
static gboolean ___lambda32__gtk_widget_key_press_event (GtkWidget* _sender,
                                                  GdkEventKey* event,
                                                  gpointer self);
static GtkButton* app_window_make_reorder_button (AppWindow* self,
                                           const gchar* text,
                                           const gchar* items);
static void __lambda33_ (Block3Data* _data3_);
VALA_EXTERN void book_combine_sides (Book* self);
static void ___lambda33__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda34_ (Block3Data* _data3_);
VALA_EXTERN void book_combine_sides_reverse (Book* self);
static void ___lambda34__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda35_ (Block3Data* _data3_);
VALA_EXTERN void book_reverse (Book* self);
static void ___lambda35__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda36_ (Block3Data* _data3_);
static void ___lambda36__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static GtkBox* app_window_make_reorder_box (AppWindow* self,
                                     const gchar* items);
VALA_EXTERN GType page_icon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageIcon, g_object_unref)
VALA_EXTERN PageIcon* page_icon_new (gchar side,
                         gint position);
VALA_EXTERN PageIcon* page_icon_construct (GType object_type,
                               gchar side,
                               gint position);
static void app_window_save_file_button_clicked_cb (AppWindow* self,
                                             GtkWidget* widget);
static void _app_window_save_file_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
VALA_EXTERN void page_copy_to_clipboard (Page* self,
                             GtkWindow* window);
static void _app_window_copy_to_clipboard_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                             gpointer self);
static void app_window_draw_page (AppWindow* self,
                           GtkPrintOperation* operation,
                           GtkPrintContext* print_context,
                           gint page_number);
VALA_EXTERN Page* book_get_page (Book* self,
                     gint page_number);
VALA_EXTERN gboolean page_get_is_landscape (Page* self);
VALA_EXTERN gint page_get_dpi (Page* self);
VALA_EXTERN GdkPixbuf* page_get_image (Page* self,
                           gboolean apply_crop);
static void app_window_email_document_async (AppWindow* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void app_window_email_document_finish (AppWindow* self,
                                       GAsyncResult* _res_);
static void app_window_email_document_async_data_free (gpointer _data);
static gboolean app_window_email_document_async_co (AppWindowEmailDocumentAsyncData* _data_);
static void app_window_email_document_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void app_window_print_document (AppWindow* self);
static void _app_window_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender,
                                                          GtkPrintContext* context,
                                                          gint page_nr,
                                                          gpointer self);
static void app_window_launch_help (AppWindow* self);
static void app_window_show_about (AppWindow* self);
static void app_window_on_quit (AppWindow* self);
static void __lambda37_ (AppWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void app_window_save_state (AppWindow* self,
                            gboolean force);
static void ___lambda37__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void app_window_real_size_allocate (GtkWidget* base,
                                    GtkAllocation* allocation);
static gboolean app_window_real_window_state_event (GtkWidget* base,
                                             GdkEventWindowState* event);
static gboolean app_window_window_delete_event_cb (AppWindow* self,
                                            GtkWidget* widget,
                                            GdkEventAny* event);
static gboolean _app_window_window_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender,
                                                                     GdkEventAny* event,
                                                                     gpointer self);
VALA_EXTERN PreferencesDialog* preferences_dialog_new (GSettings* settings);
VALA_EXTERN PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 GSettings* settings);
static gboolean __lambda39_ (AppWindow* self);
static gboolean ___lambda39__gtk_widget_delete_event (GtkWidget* _sender,
                                               GdkEventAny* event,
                                               gpointer self);
static void _app_window_new_document_cb_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _app_window_rotate_left_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void _app_window_rotate_right_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
static void __lambda40_ (AppWindow* self,
                  GtkToggleButton* widget);
static void ___lambda40__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda41_ (AppWindow* self);
static void ___lambda41__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
VALA_EXTERN BookView* book_view_new (Book* book);
VALA_EXTERN BookView* book_view_construct (GType object_type,
                               Book* book);
static void _app_window_page_selected_cb_book_view_page_selected (BookView* _sender,
                                                           Page* page,
                                                           gpointer self);
static void _app_window_show_page_cb_book_view_show_page (BookView* _sender,
                                                   Page* page,
                                                   gpointer self);
static void _app_window_show_page_menu_cb_book_view_show_menu (BookView* _sender,
                                                        GdkEvent* event,
                                                        gpointer self);
static void app_window_load_state (AppWindow* self);
static gchar* app_window_get_state_filename (AppWindow* self);
static gint app_window_state_get_integer (AppWindow* self,
                                   GKeyFile* f,
                                   const gchar* group_name,
                                   const gchar* key,
                                   gint _default_);
static gboolean app_window_state_get_boolean (AppWindow* self,
                                       GKeyFile* f,
                                       const gchar* group_name,
                                       const gchar* key,
                                       gboolean _default_);
VALA_EXTERN ScanType scanner_type_from_string (const gchar* type);
static gchar* app_window_state_get_string (AppWindow* self,
                                    GKeyFile* f,
                                    const gchar* group_name,
                                    const gchar* key,
                                    const gchar* _default_);
static gboolean ___lambda38_ (AppWindow* self);
static gboolean ____lambda38__gsource_func (gpointer self);
VALA_EXTERN gchar* scanner_type_to_string (ScanType type);
VALA_EXTERN void app_window_start (AppWindow* self);
VALA_EXTERN AutosaveManager* autosave_manager_new (void);
VALA_EXTERN AutosaveManager* autosave_manager_construct (GType object_type);
VALA_EXTERN void autosave_manager_set_book (AutosaveManager* self,
                                Book* value);
VALA_EXTERN gboolean autosave_manager_exists (AutosaveManager* self);
VALA_EXTERN void autosave_manager_load (AutosaveManager* self);
VALA_EXTERN void book_view_set_selected_page (BookView* self,
                                  Page* value);
VALA_EXTERN Page* app_window_get_selected_page (AppWindow* self);
VALA_EXTERN void app_window_set_selected_page (AppWindow* self,
                                   Page* value);
VALA_EXTERN void app_window_set_scanning (AppWindow* self,
                              gboolean value);
VALA_EXTERN gint preferences_dialog_get_brightness (PreferencesDialog* self);
VALA_EXTERN void app_window_set_brightness (AppWindow* self,
                                gint value);
VALA_EXTERN void preferences_dialog_set_brightness (PreferencesDialog* self,
                                        gint brightness);
VALA_EXTERN gint preferences_dialog_get_contrast (PreferencesDialog* self);
VALA_EXTERN void app_window_set_contrast (AppWindow* self,
                              gint value);
VALA_EXTERN void preferences_dialog_set_contrast (PreferencesDialog* self,
                                      gint contrast);
VALA_EXTERN gint preferences_dialog_get_page_delay (PreferencesDialog* self);
VALA_EXTERN void app_window_set_page_delay (AppWindow* self,
                                gint value);
VALA_EXTERN void preferences_dialog_set_page_delay (PreferencesDialog* self,
                                        gint page_delay);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void app_window_finalize (GObject * obj);
static GType app_window_get_type_once (void);
static void _vala_app_window_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_app_window_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda28_ (Block4Data* _data4_);
static void ____lambda28__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static gboolean __lambda29_ (CancellableProgressBar* self);
static gboolean ___lambda29__gsource_func (gpointer self);
static void cancellable_progress_bar_finalize (GObject * obj);
static GType cancellable_progress_bar_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry APP_WINDOW_action_entries[19] = {{"new_document", _app_window_new_document_cb_gsimple_action_activate_callback}, {"scan_single", _app_window_scan_single_cb_gsimple_action_activate_callback}, {"scan_adf", _app_window_scan_adf_cb_gsimple_action_activate_callback}, {"scan_batch", _app_window_scan_batch_cb_gsimple_action_activate_callback}, {"scan_stop", _app_window_scan_stop_cb_gsimple_action_activate_callback}, {"rotate_left", _app_window_rotate_left_cb_gsimple_action_activate_callback}, {"rotate_right", _app_window_rotate_right_cb_gsimple_action_activate_callback}, {"move_left", _app_window_move_left_cb_gsimple_action_activate_callback}, {"move_right", _app_window_move_right_cb_gsimple_action_activate_callback}, {"copy_page", _app_window_copy_page_cb_gsimple_action_activate_callback}, {"delete_page", _app_window_delete_page_cb_gsimple_action_activate_callback}, {"reorder", _app_window_reorder_document_cb_gsimple_action_activate_callback}, {"save", _app_window_save_document_activate_cb_gsimple_action_activate_callback}, {"email", _app_window_email_document_cb_gsimple_action_activate_callback}, {"print", _app_window_print_document_cb_gsimple_action_activate_callback}, {"preferences", _app_window_preferences_cb_gsimple_action_activate_callback}, {"help", _app_window_help_cb_gsimple_action_activate_callback}, {"about", _app_window_about_cb_gsimple_action_activate_callback}, {"quit", _app_window_quit_cb_gsimple_action_activate_callback}};

static inline gpointer
app_window_get_instance_private (AppWindow* self)
{
	return G_STRUCT_MEMBER_P (self, AppWindow_private_offset);
}

static void
_app_window_page_added_cb_book_page_added (Book* _sender,
                                           Page* page,
                                           gpointer self)
{
	app_window_page_added_cb ((AppWindow*) self, _sender, page);
}

static void
_app_window_reordered_cb_book_reordered (Book* _sender,
                                         gpointer self)
{
	app_window_reordered_cb ((AppWindow*) self, _sender);
}

static void
_app_window_page_removed_cb_book_page_removed (Book* _sender,
                                               Page* page,
                                               gpointer self)
{
	app_window_page_removed_cb ((AppWindow*) self, _sender, page);
}

static void
_app_window_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	app_window_new_document_cb ((AppWindow*) self);
}

static void
_app_window_scan_single_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	app_window_scan_single_cb ((AppWindow*) self);
}

static void
_app_window_scan_adf_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	app_window_scan_adf_cb ((AppWindow*) self);
}

static void
_app_window_scan_batch_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	app_window_scan_batch_cb ((AppWindow*) self);
}

static void
_app_window_scan_stop_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	app_window_scan_stop_cb ((AppWindow*) self);
}

static void
_app_window_rotate_left_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	app_window_rotate_left_cb ((AppWindow*) self);
}

static void
_app_window_rotate_right_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	app_window_rotate_right_cb ((AppWindow*) self);
}

static void
_app_window_move_left_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	app_window_move_left_cb ((AppWindow*) self);
}

static void
_app_window_move_right_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	app_window_move_right_cb ((AppWindow*) self);
}

static void
_app_window_copy_page_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	app_window_copy_page_cb ((AppWindow*) self);
}

static void
_app_window_delete_page_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	app_window_delete_page_cb ((AppWindow*) self);
}

static void
_app_window_reorder_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	app_window_reorder_document_cb ((AppWindow*) self);
}

static void
_app_window_save_document_activate_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	app_window_save_document_activate_cb ((AppWindow*) self);
}

static void
_app_window_email_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	app_window_email_document_cb ((AppWindow*) self);
}

static void
_app_window_print_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	app_window_print_document_cb ((AppWindow*) self);
}

static void
_app_window_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	app_window_preferences_cb ((AppWindow*) self);
}

static void
_app_window_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	app_window_help_cb ((AppWindow*) self);
}

static void
_app_window_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	app_window_about_cb ((AppWindow*) self);
}

static void
_app_window_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	app_window_quit_cb ((AppWindow*) self);
}

static void
_app_window_book_changed_cb_book_changed (Book* _sender,
                                          gpointer self)
{
	app_window_book_changed_cb ((AppWindow*) self, _sender);
}

AppWindow*
app_window_construct (GType object_type)
{
	AppWindow * self = NULL;
	GSettings* _tmp0_;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp1_;
	GValue _tmp2_ = {0};
	GtkComboBox* _tmp3_;
	GtkComboBox* _tmp4_;
	Book* _tmp5_;
	Book* _tmp6_;
	Book* _tmp7_;
	Book* _tmp8_;
	Book* _tmp9_;
	Book* _tmp10_;
	self = (AppWindow*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("org.gnome.SimpleScan");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp1_);
	renderer = _tmp1_;
	g_value_init (&_tmp2_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp2_, 0.5);
	g_object_set_property ((GObject*) renderer, "xalign", &_tmp2_);
	G_IS_VALUE (&_tmp2_) ? (g_value_unset (&_tmp2_), NULL) : NULL;
	_tmp3_ = self->priv->device_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) renderer, TRUE);
	_tmp4_ = self->priv->device_combo;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp4_, (GtkCellRenderer*) renderer, "text", 1);
	_tmp5_ = book_new ();
	_tmp6_ = _tmp5_;
	app_window_set_book (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->_book;
	g_signal_connect_object (_tmp7_, "page-added", (GCallback) _app_window_page_added_cb_book_page_added, self, 0);
	_tmp8_ = self->priv->_book;
	g_signal_connect_object (_tmp8_, "reordered", (GCallback) _app_window_reordered_cb_book_reordered, self, 0);
	_tmp9_ = self->priv->_book;
	g_signal_connect_object (_tmp9_, "page-removed", (GCallback) _app_window_page_removed_cb_book_page_removed, self, 0);
	_tmp10_ = self->priv->_book;
	g_signal_connect_object (_tmp10_, "changed", (GCallback) _app_window_book_changed_cb_book_changed, self, 0);
	app_window_load (self);
	app_window_clear_document (self);
	_g_object_unref0 (renderer);
	return self;
}

AppWindow*
app_window_new (void)
{
	return app_window_construct (TYPE_APP_WINDOW);
}

void
app_window_show_error_dialog (AppWindow* self,
                              const gchar* error_title,
                              const gchar* error_text)
{
	GtkMessageDialog* dialog = NULL;
	GtkMessageDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_title != NULL);
	g_return_if_fail (error_text != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", error_title);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_dialog_add_button ((GtkDialog*) dialog, _ ("_Close"), 0);
	gtk_message_dialog_format_secondary_markup (dialog, "%s", error_text);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

void
app_window_authorize (AppWindow* self,
                      const gchar* resource,
                      gchar** username,
                      gchar** password)
{
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	gchar* description = NULL;
	gchar* _tmp0_;
	AuthorizeDialog* authorize_dialog = NULL;
	AuthorizeDialog* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (resource != NULL);
	_tmp0_ = g_strdup_printf (_ ("Username and password required to access “%s”"), resource);
	description = _tmp0_;
	_tmp1_ = authorize_dialog_new (description);
	g_object_ref_sink (_tmp1_);
	authorize_dialog = _tmp1_;
	gtk_widget_set_visible ((GtkWidget*) authorize_dialog, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) authorize_dialog, (GtkWindow*) self);
	gtk_dialog_run ((GtkDialog*) authorize_dialog);
	gtk_widget_destroy ((GtkWidget*) authorize_dialog);
	_tmp2_ = authorize_dialog_get_username (authorize_dialog);
	_g_free0 (_vala_username);
	_vala_username = _tmp2_;
	_tmp3_ = authorize_dialog_get_password (authorize_dialog);
	_g_free0 (_vala_password);
	_vala_password = _tmp3_;
	_g_object_unref0 (authorize_dialog);
	_g_free0 (description);
	if (username) {
		*username = _vala_username;
	} else {
		_g_free0 (_vala_username);
	}
	if (password) {
		*password = _vala_password;
	} else {
		_g_free0 (_vala_password);
	}
}

static void
app_window_update_scan_status (AppWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scan_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	if (!self->priv->have_devices) {
		HdyStatusPage* _tmp1_;
		GtkLabel* _tmp2_;
		GtkBox* _tmp3_;
		_tmp1_ = self->priv->status_page;
		hdy_status_page_set_title (_tmp1_, _ ("Searching for Scanners…"));
		_tmp2_ = self->priv->status_secondary_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
		_tmp3_ = self->priv->device_buttons_box;
		gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = app_window_get_selected_device (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_ != NULL;
		_g_free0 (_tmp5_);
		if (_tmp6_) {
			GtkButton* _tmp7_;
			HdyStatusPage* _tmp8_;
			GtkLabel* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GtkLabel* _tmp12_;
			GtkBox* _tmp13_;
			GtkBox* _tmp14_;
			GtkComboBox* _tmp15_;
			_tmp7_ = self->priv->scan_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, TRUE);
			_tmp8_ = self->priv->status_page;
			hdy_status_page_set_title (_tmp8_, _ ("Ready to Scan"));
			_tmp9_ = self->priv->status_secondary_label;
			_tmp10_ = app_window_get_selected_device_label (self);
			_tmp11_ = _tmp10_;
			gtk_label_set_text (_tmp9_, _tmp11_);
			_g_free0 (_tmp11_);
			_tmp12_ = self->priv->status_secondary_label;
			gtk_widget_set_visible ((GtkWidget*) _tmp12_, FALSE);
			_tmp13_ = self->priv->device_buttons_box;
			gtk_widget_set_visible ((GtkWidget*) _tmp13_, TRUE);
			_tmp14_ = self->priv->device_buttons_box;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, TRUE);
			_tmp15_ = self->priv->device_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, TRUE);
		} else {
			const gchar* _tmp16_;
			_tmp16_ = self->priv->missing_driver;
			if (_tmp16_ != NULL) {
				HdyStatusPage* _tmp17_;
				GtkLabel* _tmp18_;
				GtkLabel* _tmp19_;
				GtkBox* _tmp20_;
				_tmp17_ = self->priv->status_page;
				hdy_status_page_set_title (_tmp17_, _ ("Additional Software Needed"));
				_tmp18_ = self->priv->status_secondary_label;
				gtk_label_set_markup (_tmp18_, _ ("You need to <a href=\"install-firmware\">install driver software</a> f" \
"or your scanner."));
				_tmp19_ = self->priv->status_secondary_label;
				gtk_widget_set_visible ((GtkWidget*) _tmp19_, TRUE);
				_tmp20_ = self->priv->device_buttons_box;
				gtk_widget_set_visible ((GtkWidget*) _tmp20_, FALSE);
			} else {
				HdyStatusPage* _tmp21_;
				GtkLabel* _tmp22_;
				GtkLabel* _tmp23_;
				GtkBox* _tmp24_;
				GtkBox* _tmp25_;
				GtkComboBox* _tmp26_;
				_tmp21_ = self->priv->status_page;
				hdy_status_page_set_title (_tmp21_, _ ("No Scanners Detected"));
				_tmp22_ = self->priv->status_secondary_label;
				gtk_label_set_text (_tmp22_, _ ("Please check your scanner is connected and powered on."));
				_tmp23_ = self->priv->status_secondary_label;
				gtk_widget_set_visible ((GtkWidget*) _tmp23_, TRUE);
				_tmp24_ = self->priv->device_buttons_box;
				gtk_widget_set_visible ((GtkWidget*) _tmp24_, TRUE);
				_tmp25_ = self->priv->device_buttons_box;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, TRUE);
				_tmp26_ = self->priv->device_combo;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp26_, FALSE);
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
app_window_set_scan_devices (AppWindow* self,
                             GList* devices,
                             const gchar* missing_driver)
{
	gchar* _tmp0_;
	gboolean have_selection = FALSE;
	gint index = 0;
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	self->priv->have_devices = TRUE;
	_tmp0_ = g_strdup (missing_driver);
	_g_free0 (self->priv->missing_driver);
	self->priv->missing_driver = _tmp0_;
	self->priv->setting_devices = TRUE;
	have_selection = FALSE;
	if (self->priv->user_selected_device) {
		GtkComboBox* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->device_combo;
		_tmp2_ = gtk_combo_box_get_active (_tmp1_);
		_tmp3_ = _tmp2_;
		have_selection = _tmp3_ >= 0;
	}
	index = 0;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = devices;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			ScanDevice* _tmp4_;
			ScanDevice* device = NULL;
			_tmp4_ = _g_object_ref0 ((ScanDevice*) device_it->data);
			device = _tmp4_;
			{
				gint n_delete = 0;
				GtkListStore* _tmp5_;
				GtkTreeIter _tmp6_ = {0};
				gboolean _tmp7_;
				gint _tmp35_;
				n_delete = -1;
				_tmp5_ = self->priv->device_model;
				_tmp7_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp5_, &_tmp6_, NULL, index);
				iter = _tmp6_;
				if (_tmp7_) {
					gint i = 0;
					i = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gchar* name = NULL;
							gboolean matched = FALSE;
							GtkListStore* _tmp11_;
							GtkTreeIter _tmp12_;
							gchar* _tmp13_ = NULL;
							const gchar* _tmp14_;
							ScanDevice* _tmp15_;
							const gchar* _tmp16_;
							gint _tmp17_;
							if (!_tmp8_) {
								GtkListStore* _tmp9_;
								gboolean _tmp10_;
								_tmp9_ = self->priv->device_model;
								_tmp10_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp9_, &iter);
								if (!_tmp10_) {
									break;
								}
							}
							_tmp8_ = FALSE;
							_tmp11_ = self->priv->device_model;
							_tmp12_ = iter;
							gtk_tree_model_get ((GtkTreeModel*) _tmp11_, &_tmp12_, 0, &_tmp13_, -1, -1);
							_g_free0 (name);
							name = _tmp13_;
							_tmp14_ = name;
							_tmp15_ = device;
							_tmp16_ = _tmp15_->name;
							matched = g_strcmp0 (_tmp14_, _tmp16_) == 0;
							if (matched) {
								n_delete = i;
								_g_free0 (name);
								break;
							}
							_tmp17_ = i;
							i = _tmp17_ + 1;
							_g_free0 (name);
						}
					}
				}
				if (n_delete >= 0) {
					gint i = 0;
					GtkListStore* _tmp18_;
					GtkTreeIter _tmp19_;
					ScanDevice* _tmp20_;
					const gchar* _tmp21_;
					_tmp18_ = self->priv->device_model;
					_tmp19_ = iter;
					_tmp20_ = device;
					_tmp21_ = _tmp20_->label;
					gtk_list_store_set (_tmp18_, &_tmp19_, 1, _tmp21_, -1, -1);
					{
						gboolean _tmp22_ = FALSE;
						i = 0;
						_tmp22_ = TRUE;
						while (TRUE) {
							GtkListStore* _tmp24_;
							GtkTreeIter _tmp25_ = {0};
							GtkListStore* _tmp26_;
							if (!_tmp22_) {
								gint _tmp23_;
								_tmp23_ = i;
								i = _tmp23_ + 1;
							}
							_tmp22_ = FALSE;
							if (!(i < n_delete)) {
								break;
							}
							_tmp24_ = self->priv->device_model;
							gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp24_, &_tmp25_, NULL, index);
							iter = _tmp25_;
							_tmp26_ = self->priv->device_model;
							gtk_list_store_remove (_tmp26_, &iter);
						}
					}
				} else {
					GtkListStore* _tmp27_;
					GtkTreeIter _tmp28_ = {0};
					GtkListStore* _tmp29_;
					GtkTreeIter _tmp30_;
					ScanDevice* _tmp31_;
					const gchar* _tmp32_;
					ScanDevice* _tmp33_;
					const gchar* _tmp34_;
					_tmp27_ = self->priv->device_model;
					gtk_list_store_insert (_tmp27_, &_tmp28_, index);
					iter = _tmp28_;
					_tmp29_ = self->priv->device_model;
					_tmp30_ = iter;
					_tmp31_ = device;
					_tmp32_ = _tmp31_->name;
					_tmp33_ = device;
					_tmp34_ = _tmp33_->label;
					gtk_list_store_set (_tmp29_, &_tmp30_, 0, _tmp32_, 1, _tmp34_, -1, -1);
				}
				_tmp35_ = index;
				index = _tmp35_ + 1;
				_g_object_unref0 (device);
			}
		}
	}
	while (TRUE) {
		GtkListStore* _tmp36_;
		GtkTreeIter _tmp37_ = {0};
		gboolean _tmp38_;
		GtkListStore* _tmp39_;
		_tmp36_ = self->priv->device_model;
		_tmp38_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp36_, &_tmp37_, NULL, index);
		iter = _tmp37_;
		if (!_tmp38_) {
			break;
		}
		_tmp39_ = self->priv->device_model;
		gtk_list_store_remove (_tmp39_, &iter);
	}
	if (!have_selection) {
		gchar* device = NULL;
		GSettings* _tmp40_;
		gchar* _tmp41_;
		gboolean _tmp42_ = FALSE;
		const gchar* _tmp43_;
		_tmp40_ = self->priv->settings;
		_tmp41_ = g_settings_get_string (_tmp40_, "selected-device");
		device = _tmp41_;
		_tmp43_ = device;
		if (_tmp43_ != NULL) {
			const gchar* _tmp44_;
			GtkTreeIter _tmp45_ = {0};
			gboolean _tmp46_;
			_tmp44_ = device;
			_tmp46_ = app_window_find_scan_device (self, _tmp44_, &_tmp45_);
			iter = _tmp45_;
			_tmp42_ = _tmp46_;
		} else {
			_tmp42_ = FALSE;
		}
		if (_tmp42_) {
			GtkComboBox* _tmp47_;
			GtkTreeIter _tmp48_;
			_tmp47_ = self->priv->device_combo;
			_tmp48_ = iter;
			gtk_combo_box_set_active_iter (_tmp47_, &_tmp48_);
		} else {
			GtkComboBox* _tmp49_;
			_tmp49_ = self->priv->device_combo;
			gtk_combo_box_set_active (_tmp49_, 0);
		}
		_g_free0 (device);
	}
	self->priv->setting_devices = FALSE;
	app_window_update_scan_status (self);
}

static gboolean
app_window_prompt_to_load_autosaved_book (AppWindow* self)
{
	GtkMessageDialog* dialog = NULL;
	GtkMessageDialog* _tmp0_;
	gint response = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "%s", _ ("An autosaved book exists. Do you want to open it?"));
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_dialog_set_default_response ((GtkDialog*) dialog, (gint) GTK_RESPONSE_YES);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = response == ((gint) GTK_RESPONSE_YES);
	_g_object_unref0 (dialog);
	return result;
}

static gchar*
app_window_get_selected_device (AppWindow* self)
{
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->device_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gchar* device = NULL;
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp3_ = self->priv->device_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &_tmp5_, -1, -1);
		_g_free0 (device);
		device = _tmp5_;
		result = device;
		return result;
	}
	result = NULL;
	return result;
}

static gchar*
app_window_get_selected_device_label (AppWindow* self)
{
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->device_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gchar* label = NULL;
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp3_ = self->priv->device_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 1, &_tmp5_, -1, -1);
		_g_free0 (label);
		label = _tmp5_;
		result = label;
		return result;
	}
	result = NULL;
	return result;
}

void
app_window_set_selected_device (AppWindow* self,
                                const gchar* device)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkComboBox* _tmp2_;
	GtkTreeIter _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	self->priv->user_selected_device = TRUE;
	_tmp1_ = app_window_find_scan_device (self, device, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->device_combo;
	_tmp3_ = iter;
	gtk_combo_box_set_active_iter (_tmp2_, &_tmp3_);
}

static gboolean
app_window_find_scan_device (AppWindow* self,
                             const gchar* device,
                             GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	gboolean have_iter = FALSE;
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	have_iter = FALSE;
	_tmp0_ = self->priv->device_model;
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
	_vala_iter = _tmp1_;
	if (_tmp2_) {
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar* d = NULL;
				GtkListStore* _tmp7_;
				GtkTreeIter _tmp8_;
				gchar* _tmp9_ = NULL;
				const gchar* _tmp10_;
				if (!_tmp3_) {
					gboolean _tmp4_ = FALSE;
					if (!have_iter) {
						GtkListStore* _tmp5_;
						gboolean _tmp6_;
						_tmp5_ = self->priv->device_model;
						_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &_vala_iter);
						_tmp4_ = _tmp6_;
					} else {
						_tmp4_ = FALSE;
					}
					if (!_tmp4_) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp7_ = self->priv->device_model;
				_tmp8_ = _vala_iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 0, &_tmp9_, -1, -1);
				_g_free0 (d);
				d = _tmp9_;
				_tmp10_ = d;
				if (g_strcmp0 (_tmp10_, device) == 0) {
					have_iter = TRUE;
				}
				_g_free0 (d);
			}
		}
	}
	result = have_iter;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		AppWindow* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->quality_scale);
		_g_object_unref0 (_data1_->quality_adjustment);
		_g_object_unref0 (_data1_->quality_label);
		_g_object_unref0 (_data1_->file_type_combo);
		_g_object_unref0 (_data1_->file_type_store);
		_g_object_unref0 (_data1_->save_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda26_ (Block1Data* _data1_)
{
	AppWindow* self;
	GSettings* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	self = _data1_->self;
	_tmp0_ = self->priv->settings;
	_tmp1_ = _data1_->quality_adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_int (_tmp0_, "jpeg-quality", (gint) _tmp3_);
}

static void
___lambda26__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                           gpointer self)
{
	__lambda26_ (self);
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
__lambda27_ (Block1Data* _data1_)
{
	AppWindow* self;
	gchar* mime_type = NULL;
	gchar* _tmp0_;
	GtkTreeIter i = {0};
	GtkComboBox* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	gchar* filename = NULL;
	GtkFileChooserNative* _tmp9_;
	gchar* _tmp10_;
	gint extension_index = 0;
	const gchar* _tmp11_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GtkFileChooserNative* _tmp21_;
	const gchar* _tmp22_;
	GtkScale* _tmp23_;
	GtkLabel* _tmp24_;
	const gchar* _tmp25_;
	self = _data1_->self;
	_tmp0_ = g_strdup ("");
	mime_type = _tmp0_;
	_tmp1_ = _data1_->file_type_combo;
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
	i = _tmp2_;
	if (_tmp3_) {
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		gchar* _tmp6_ = NULL;
		GSettings* _tmp7_;
		const gchar* _tmp8_;
		_tmp4_ = _data1_->file_type_store;
		_tmp5_ = i;
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 1, &_tmp6_, -1, -1);
		_g_free0 (mime_type);
		mime_type = _tmp6_;
		_tmp7_ = self->priv->settings;
		_tmp8_ = mime_type;
		g_settings_set_string (_tmp7_, "save-format", _tmp8_);
	}
	_tmp9_ = _data1_->save_dialog;
	_tmp10_ = gtk_file_chooser_get_current_name ((GtkFileChooser*) _tmp9_);
	filename = _tmp10_;
	_tmp11_ = filename;
	extension_index = string_last_index_of_char (_tmp11_, (gunichar) '.', 0);
	if (extension_index >= 0) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = filename;
		_tmp13_ = string_slice (_tmp12_, (glong) 0, (glong) extension_index);
		_g_free0 (filename);
		filename = _tmp13_;
	}
	_tmp14_ = filename;
	_tmp15_ = g_strconcat (_tmp14_, ".", NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = mime_type;
	_tmp18_ = app_window_mime_type_to_extension (self, _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp16_, _tmp19_, NULL);
	_g_free0 (filename);
	filename = _tmp20_;
	_g_free0 (_tmp19_);
	_g_free0 (_tmp16_);
	_tmp21_ = _data1_->save_dialog;
	_tmp22_ = filename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp21_, _tmp22_);
	_tmp23_ = _data1_->quality_scale;
	_tmp24_ = _data1_->quality_label;
	_tmp25_ = mime_type;
	gtk_widget_set_visible ((GtkWidget*) _tmp24_, g_strcmp0 (_tmp25_, "image/png") != 0);
	gtk_widget_set_visible ((GtkWidget*) _tmp23_, g_strcmp0 (_tmp25_, "image/png") != 0);
	_g_free0 (filename);
	_g_free0 (mime_type);
}

static void
___lambda27__gtk_combo_box_changed (GtkComboBox* _sender,
                                    gpointer self)
{
	__lambda27_ (self);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gchar*
app_window_choose_file_location (AppWindow* self)
{
	Block1Data* _data1_;
	gchar* directory = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GtkFileChooserNative* _tmp9_;
	GtkFileChooserNative* _tmp10_;
	gchar* save_format = NULL;
	GSettings* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp26_;
	GtkFileFilter* _tmp27_;
	GtkFileFilter* _tmp28_;
	GtkFileFilter* _tmp29_;
	GtkFileFilter* _tmp30_;
	GtkFileFilter* _tmp31_;
	GtkFileChooserNative* _tmp32_;
	GtkFileFilter* _tmp33_;
	GtkFileFilter* _tmp34_;
	GtkFileFilter* _tmp35_;
	GtkFileFilter* _tmp36_;
	GtkFileFilter* _tmp37_;
	GtkFileChooserNative* _tmp38_;
	GtkFileFilter* _tmp39_;
	GtkFileFilter* _tmp40_;
	GtkListStore* _tmp41_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp42_;
	GtkTreeIter _tmp43_ = {0};
	GtkListStore* _tmp44_;
	GtkTreeIter _tmp45_;
	GtkListStore* _tmp46_;
	GtkTreeIter _tmp47_ = {0};
	GtkListStore* _tmp48_;
	GtkTreeIter _tmp49_;
	GtkListStore* _tmp50_;
	GtkTreeIter _tmp51_ = {0};
	GtkListStore* _tmp52_;
	GtkTreeIter _tmp53_;
	GtkListStore* _tmp54_;
	GtkTreeIter _tmp55_ = {0};
	GtkListStore* _tmp56_;
	GtkTreeIter _tmp57_;
	GtkBox* box = NULL;
	GtkBox* _tmp58_;
	GtkBox* _tmp59_;
	GtkBox* _tmp60_;
	GtkFileChooserNative* _tmp61_;
	GtkBox* _tmp62_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp63_;
	GtkLabel* _tmp64_;
	GtkBox* _tmp65_;
	GtkLabel* _tmp66_;
	GtkListStore* _tmp67_;
	GtkComboBox* _tmp68_;
	GtkComboBox* _tmp69_;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp70_;
	GtkComboBox* _tmp71_;
	GtkCellRendererText* _tmp72_;
	GtkComboBox* _tmp73_;
	GtkCellRendererText* _tmp74_;
	GtkBox* _tmp75_;
	GtkComboBox* _tmp76_;
	GtkListStore* _tmp77_;
	GtkTreeIter _tmp78_ = {0};
	gboolean _tmp79_;
	GtkLabel* _tmp90_;
	GtkBox* _tmp91_;
	GtkLabel* _tmp92_;
	GtkAdjustment* _tmp93_;
	GtkAdjustment* _tmp94_;
	GtkScale* _tmp95_;
	GtkScale* _tmp96_;
	GtkScale* _tmp97_;
	gchar* minimum_size_label = NULL;
	gchar* _tmp98_;
	GtkScale* _tmp99_;
	GtkAdjustment* _tmp100_;
	gdouble _tmp101_;
	gdouble _tmp102_;
	const gchar* _tmp103_;
	GtkScale* _tmp104_;
	GtkScale* _tmp105_;
	gchar* full_detail_label = NULL;
	gchar* _tmp106_;
	GtkScale* _tmp107_;
	GtkAdjustment* _tmp108_;
	gdouble _tmp109_;
	gdouble _tmp110_;
	const gchar* _tmp111_;
	GtkAdjustment* _tmp112_;
	GSettings* _tmp113_;
	GtkAdjustment* _tmp114_;
	GtkBox* _tmp115_;
	GtkScale* _tmp116_;
	GtkScale* _tmp117_;
	GtkLabel* _tmp118_;
	const gchar* _tmp119_;
	GtkComboBox* _tmp120_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	directory = NULL;
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "save-directory");
	_g_free0 (directory);
	directory = _tmp1_;
	_tmp3_ = directory;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = directory;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
		_tmp7_ = g_filename_to_uri (_tmp6_, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (directory);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_free0 (directory);
		directory = _tmp8_;
		_g_free0 (_tmp5_);
	}
	_tmp9_ = gtk_file_chooser_native_new (_ ("Save As…"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Save"), _ ("_Cancel"));
	_data1_->save_dialog = _tmp9_;
	_tmp10_ = _data1_->save_dialog;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp10_, FALSE);
	_tmp11_ = self->priv->settings;
	_tmp12_ = g_settings_get_string (_tmp11_, "save-format");
	save_format = _tmp12_;
	_tmp13_ = self->priv->book_uri;
	if (_tmp13_ != NULL) {
		GtkFileChooserNative* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = _data1_->save_dialog;
		_tmp15_ = self->priv->book_uri;
		gtk_file_chooser_set_uri ((GtkFileChooser*) _tmp14_, _tmp15_);
	} else {
		GtkFileChooserNative* _tmp16_;
		const gchar* _tmp17_;
		GtkFileChooserNative* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp16_ = _data1_->save_dialog;
		_tmp17_ = directory;
		gtk_file_chooser_set_current_folder_uri ((GtkFileChooser*) _tmp16_, _tmp17_);
		_tmp18_ = _data1_->save_dialog;
		_tmp19_ = g_strconcat (_ ("Scanned Document"), ".", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = save_format;
		_tmp22_ = app_window_mime_type_to_extension (self, _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp20_, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp18_, _tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp20_);
	}
	_tmp26_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp26_);
	filter = _tmp26_;
	_tmp27_ = filter;
	gtk_file_filter_set_name (_tmp27_, _ ("Image Files"));
	_tmp28_ = filter;
	gtk_file_filter_add_mime_type (_tmp28_, "image/jpeg");
	_tmp29_ = filter;
	gtk_file_filter_add_mime_type (_tmp29_, "image/png");
	_tmp30_ = filter;
	gtk_file_filter_add_mime_type (_tmp30_, "image/webp");
	_tmp31_ = filter;
	gtk_file_filter_add_mime_type (_tmp31_, "application/pdf");
	_tmp32_ = _data1_->save_dialog;
	_tmp33_ = filter;
	_tmp34_ = _g_object_ref0 (_tmp33_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp32_, _tmp34_);
	_tmp35_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (filter);
	filter = _tmp35_;
	_tmp36_ = filter;
	gtk_file_filter_set_name (_tmp36_, _ ("All Files"));
	_tmp37_ = filter;
	gtk_file_filter_add_pattern (_tmp37_, "*");
	_tmp38_ = _data1_->save_dialog;
	_tmp39_ = filter;
	_tmp40_ = _g_object_ref0 (_tmp39_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp38_, _tmp40_);
	_tmp41_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	_data1_->file_type_store = _tmp41_;
	_tmp42_ = _data1_->file_type_store;
	gtk_list_store_append (_tmp42_, &_tmp43_);
	iter = _tmp43_;
	_tmp44_ = _data1_->file_type_store;
	_tmp45_ = iter;
	gtk_list_store_set (_tmp44_, &_tmp45_, 0, _ ("PDF (multi-page document)"), 1, "application/pdf", -1, -1);
	_tmp46_ = _data1_->file_type_store;
	gtk_list_store_append (_tmp46_, &_tmp47_);
	iter = _tmp47_;
	_tmp48_ = _data1_->file_type_store;
	_tmp49_ = iter;
	gtk_list_store_set (_tmp48_, &_tmp49_, 0, _ ("JPEG (compressed)"), 1, "image/jpeg", -1, -1);
	_tmp50_ = _data1_->file_type_store;
	gtk_list_store_append (_tmp50_, &_tmp51_);
	iter = _tmp51_;
	_tmp52_ = _data1_->file_type_store;
	_tmp53_ = iter;
	gtk_list_store_set (_tmp52_, &_tmp53_, 0, _ ("PNG (lossless)"), 1, "image/png", -1, -1);
	_tmp54_ = _data1_->file_type_store;
	gtk_list_store_append (_tmp54_, &_tmp55_);
	iter = _tmp55_;
	_tmp56_ = _data1_->file_type_store;
	_tmp57_ = iter;
	gtk_list_store_set (_tmp56_, &_tmp57_, 0, _ ("WebP (compressed)"), 1, "image/webp", -1, -1);
	_tmp58_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp58_);
	box = _tmp58_;
	_tmp59_ = box;
	gtk_widget_set_visible ((GtkWidget*) _tmp59_, TRUE);
	_tmp60_ = box;
	gtk_box_set_spacing (_tmp60_, 10);
	_tmp61_ = _data1_->save_dialog;
	_tmp62_ = box;
	gtk_file_chooser_set_extra_widget ((GtkFileChooser*) _tmp61_, (GtkWidget*) _tmp62_);
	_tmp63_ = (GtkLabel*) gtk_label_new (_ ("File format:"));
	g_object_ref_sink (_tmp63_);
	label = _tmp63_;
	_tmp64_ = label;
	gtk_widget_set_visible ((GtkWidget*) _tmp64_, TRUE);
	_tmp65_ = box;
	_tmp66_ = label;
	gtk_container_add ((GtkContainer*) _tmp65_, (GtkWidget*) _tmp66_);
	_tmp67_ = _data1_->file_type_store;
	_tmp68_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp67_);
	g_object_ref_sink (_tmp68_);
	_data1_->file_type_combo = _tmp68_;
	_tmp69_ = _data1_->file_type_combo;
	gtk_widget_set_visible ((GtkWidget*) _tmp69_, TRUE);
	_tmp70_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp70_);
	renderer = _tmp70_;
	_tmp71_ = _data1_->file_type_combo;
	_tmp72_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp71_, (GtkCellRenderer*) _tmp72_, TRUE);
	_tmp73_ = _data1_->file_type_combo;
	_tmp74_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp73_, (GtkCellRenderer*) _tmp74_, "text", 0);
	_tmp75_ = box;
	_tmp76_ = _data1_->file_type_combo;
	gtk_container_add ((GtkContainer*) _tmp75_, (GtkWidget*) _tmp76_);
	_tmp77_ = _data1_->file_type_store;
	_tmp79_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp77_, &_tmp78_);
	iter = _tmp78_;
	if (_tmp79_) {
		{
			gboolean _tmp80_ = FALSE;
			_tmp80_ = TRUE;
			while (TRUE) {
				gchar* mime_type = NULL;
				GtkListStore* _tmp83_;
				GtkTreeIter _tmp84_;
				gchar* _tmp85_ = NULL;
				const gchar* _tmp86_;
				const gchar* _tmp87_;
				if (!_tmp80_) {
					GtkListStore* _tmp81_;
					gboolean _tmp82_;
					_tmp81_ = _data1_->file_type_store;
					_tmp82_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp81_, &iter);
					if (!_tmp82_) {
						break;
					}
				}
				_tmp80_ = FALSE;
				_tmp83_ = _data1_->file_type_store;
				_tmp84_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp83_, &_tmp84_, 1, &_tmp85_, -1, -1);
				_g_free0 (mime_type);
				mime_type = _tmp85_;
				_tmp86_ = mime_type;
				_tmp87_ = save_format;
				if (g_strcmp0 (_tmp86_, _tmp87_) == 0) {
					GtkComboBox* _tmp88_;
					GtkTreeIter _tmp89_;
					_tmp88_ = _data1_->file_type_combo;
					_tmp89_ = iter;
					gtk_combo_box_set_active_iter (_tmp88_, &_tmp89_);
				}
				_g_free0 (mime_type);
			}
		}
	}
	_tmp90_ = (GtkLabel*) gtk_label_new (_ ("Compression:"));
	g_object_ref_sink (_tmp90_);
	_data1_->quality_label = _tmp90_;
	_tmp91_ = box;
	_tmp92_ = _data1_->quality_label;
	gtk_container_add ((GtkContainer*) _tmp91_, (GtkWidget*) _tmp92_);
	_tmp93_ = gtk_adjustment_new ((gdouble) 75, (gdouble) 0, (gdouble) 100, (gdouble) 1, (gdouble) 10, (gdouble) 0);
	g_object_ref_sink (_tmp93_);
	_data1_->quality_adjustment = _tmp93_;
	_tmp94_ = _data1_->quality_adjustment;
	_tmp95_ = (GtkScale*) gtk_scale_new (GTK_ORIENTATION_HORIZONTAL, _tmp94_);
	g_object_ref_sink (_tmp95_);
	_data1_->quality_scale = _tmp95_;
	_tmp96_ = _data1_->quality_scale;
	g_object_set ((GtkWidget*) _tmp96_, "width-request", 250, NULL);
	_tmp97_ = _data1_->quality_scale;
	gtk_scale_set_draw_value (_tmp97_, FALSE);
	_tmp98_ = g_strdup_printf ("<small>%s</small>", _ ("Minimum size"));
	minimum_size_label = _tmp98_;
	_tmp99_ = _data1_->quality_scale;
	_tmp100_ = _data1_->quality_adjustment;
	_tmp101_ = gtk_adjustment_get_lower (_tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = minimum_size_label;
	gtk_scale_add_mark (_tmp99_, _tmp102_, GTK_POS_BOTTOM, _tmp103_);
	_tmp104_ = _data1_->quality_scale;
	gtk_scale_add_mark (_tmp104_, (gdouble) 75, GTK_POS_BOTTOM, NULL);
	_tmp105_ = _data1_->quality_scale;
	gtk_scale_add_mark (_tmp105_, (gdouble) 90, GTK_POS_BOTTOM, NULL);
	_tmp106_ = g_strdup_printf ("<small>%s</small>", _ ("Full detail"));
	full_detail_label = _tmp106_;
	_tmp107_ = _data1_->quality_scale;
	_tmp108_ = _data1_->quality_adjustment;
	_tmp109_ = gtk_adjustment_get_upper (_tmp108_);
	_tmp110_ = _tmp109_;
	_tmp111_ = full_detail_label;
	gtk_scale_add_mark (_tmp107_, _tmp110_, GTK_POS_BOTTOM, _tmp111_);
	_tmp112_ = _data1_->quality_adjustment;
	_tmp113_ = self->priv->settings;
	gtk_adjustment_set_value (_tmp112_, (gdouble) g_settings_get_int (_tmp113_, "jpeg-quality"));
	_tmp114_ = _data1_->quality_adjustment;
	g_signal_connect_data (_tmp114_, "value-changed", (GCallback) ___lambda26__gtk_adjustment_value_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp115_ = box;
	_tmp116_ = _data1_->quality_scale;
	gtk_container_add ((GtkContainer*) _tmp115_, (GtkWidget*) _tmp116_);
	_tmp117_ = _data1_->quality_scale;
	_tmp118_ = _data1_->quality_label;
	_tmp119_ = save_format;
	gtk_widget_set_visible ((GtkWidget*) _tmp118_, g_strcmp0 (_tmp119_, "image/png") != 0);
	gtk_widget_set_visible ((GtkWidget*) _tmp117_, g_strcmp0 (_tmp119_, "image/png") != 0);
	_tmp120_ = _data1_->file_type_combo;
	g_signal_connect_data (_tmp120_, "changed", (GCallback) ___lambda27__gtk_combo_box_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	while (TRUE) {
		gint response = 0;
		GtkFileChooserNative* _tmp121_;
		gchar* mime_type = NULL;
		gchar* _tmp123_;
		GtkTreeIter i = {0};
		GtkComboBox* _tmp124_;
		GtkTreeIter _tmp125_ = {0};
		gboolean _tmp126_;
		gchar* uri = NULL;
		GtkFileChooserNative* _tmp130_;
		gchar* _tmp131_;
		gint extension_index = 0;
		const gchar* _tmp132_;
		GList* files = NULL;
		gboolean _tmp140_ = FALSE;
		gboolean _tmp141_ = FALSE;
		const gchar* _tmp142_;
		GtkFileChooserNative* _tmp157_;
		GtkWindow* _tmp158_;
		GtkWindow* _tmp159_;
		GList* _tmp160_;
		_tmp121_ = _data1_->save_dialog;
		response = gtk_native_dialog_run ((GtkNativeDialog*) _tmp121_);
		if (response != ((gint) GTK_RESPONSE_ACCEPT)) {
			GtkFileChooserNative* _tmp122_;
			_tmp122_ = _data1_->save_dialog;
			gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp122_);
			result = NULL;
			_g_free0 (full_detail_label);
			_g_free0 (minimum_size_label);
			_g_object_unref0 (renderer);
			_g_object_unref0 (label);
			_g_object_unref0 (box);
			_g_object_unref0 (filter);
			_g_free0 (save_format);
			_g_free0 (directory);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return result;
		}
		_tmp123_ = g_strdup ("");
		mime_type = _tmp123_;
		_tmp124_ = _data1_->file_type_combo;
		_tmp126_ = gtk_combo_box_get_active_iter (_tmp124_, &_tmp125_);
		i = _tmp125_;
		if (_tmp126_) {
			GtkListStore* _tmp127_;
			GtkTreeIter _tmp128_;
			gchar* _tmp129_ = NULL;
			_tmp127_ = _data1_->file_type_store;
			_tmp128_ = i;
			gtk_tree_model_get ((GtkTreeModel*) _tmp127_, &_tmp128_, 1, &_tmp129_, -1, -1);
			_g_free0 (mime_type);
			mime_type = _tmp129_;
		}
		_tmp130_ = _data1_->save_dialog;
		_tmp131_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp130_);
		uri = _tmp131_;
		_tmp132_ = uri;
		extension_index = string_last_index_of_char (_tmp132_, (gunichar) '.', 0);
		if (extension_index < 0) {
			const gchar* _tmp133_;
			const gchar* _tmp134_;
			gchar* _tmp135_;
			gchar* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			gchar* _tmp139_;
			_tmp133_ = uri;
			_tmp134_ = mime_type;
			_tmp135_ = app_window_mime_type_to_extension (self, _tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = g_strconcat (".", _tmp136_, NULL);
			_tmp138_ = _tmp137_;
			_tmp139_ = g_strconcat (_tmp133_, _tmp138_, NULL);
			_g_free0 (uri);
			uri = _tmp139_;
			_g_free0 (_tmp138_);
			_g_free0 (_tmp136_);
		}
		files = NULL;
		_tmp142_ = mime_type;
		if (g_strcmp0 (_tmp142_, "image/jpeg") == 0) {
			_tmp141_ = TRUE;
		} else {
			const gchar* _tmp143_;
			_tmp143_ = mime_type;
			_tmp141_ = g_strcmp0 (_tmp143_, "image/png") == 0;
		}
		if (_tmp141_) {
			_tmp140_ = TRUE;
		} else {
			const gchar* _tmp144_;
			_tmp144_ = mime_type;
			_tmp140_ = g_strcmp0 (_tmp144_, "image/webp") == 0;
		}
		if (_tmp140_) {
			{
				gint j = 0;
				j = 0;
				{
					gboolean _tmp145_ = FALSE;
					_tmp145_ = TRUE;
					while (TRUE) {
						Book* _tmp147_;
						guint _tmp148_;
						guint _tmp149_;
						const gchar* _tmp150_;
						Book* _tmp151_;
						guint _tmp152_;
						guint _tmp153_;
						GFile* _tmp154_;
						if (!_tmp145_) {
							gint _tmp146_;
							_tmp146_ = j;
							j = _tmp146_ + 1;
						}
						_tmp145_ = FALSE;
						_tmp147_ = self->priv->_book;
						_tmp148_ = book_get_n_pages (_tmp147_);
						_tmp149_ = _tmp148_;
						if (!(((guint) j) < _tmp149_)) {
							break;
						}
						_tmp150_ = uri;
						_tmp151_ = self->priv->_book;
						_tmp152_ = book_get_n_pages (_tmp151_);
						_tmp153_ = _tmp152_;
						_tmp154_ = make_indexed_file (_tmp150_, (guint) j, _tmp153_);
						files = g_list_append (files, _tmp154_);
					}
				}
			}
		} else {
			const gchar* _tmp155_;
			GFile* _tmp156_;
			_tmp155_ = uri;
			_tmp156_ = g_file_new_for_uri (_tmp155_);
			files = g_list_append (files, _tmp156_);
		}
		_tmp157_ = _data1_->save_dialog;
		_tmp158_ = gtk_native_dialog_get_transient_for ((GtkNativeDialog*) _tmp157_);
		_tmp159_ = _tmp158_;
		_tmp160_ = files;
		if (app_window_check_overwrite (self, _tmp159_, _tmp160_)) {
			gchar* directory_uri = NULL;
			const gchar* _tmp161_;
			const gchar* _tmp162_;
			gchar* _tmp163_;
			GSettings* _tmp164_;
			const gchar* _tmp165_;
			GtkFileChooserNative* _tmp166_;
			_tmp161_ = uri;
			_tmp162_ = uri;
			_tmp163_ = string_substring (_tmp161_, (glong) 0, (glong) (string_last_index_of (_tmp162_, "/", 0) + 1));
			directory_uri = _tmp163_;
			_tmp164_ = self->priv->settings;
			_tmp165_ = directory_uri;
			g_settings_set_string (_tmp164_, "save-directory", _tmp165_);
			_tmp166_ = _data1_->save_dialog;
			gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp166_);
			result = uri;
			_g_free0 (directory_uri);
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
			_g_free0 (mime_type);
			_g_free0 (full_detail_label);
			_g_free0 (minimum_size_label);
			_g_object_unref0 (renderer);
			_g_object_unref0 (label);
			_g_object_unref0 (box);
			_g_object_unref0 (filter);
			_g_free0 (save_format);
			_g_free0 (directory);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return result;
		}
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_free0 (uri);
		_g_free0 (mime_type);
	}
}

static gboolean
app_window_check_overwrite (AppWindow* self,
                            GtkWindow* parent,
                            GList* files)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent != NULL, FALSE);
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = files;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GFile* _tmp0_;
			GFile* file = NULL;
			_tmp0_ = _g_object_ref0 ((GFile*) file_it->data);
			file = _tmp0_;
			{
				GFile* _tmp1_;
				GtkMessageDialog* dialog = NULL;
				GFile* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				GtkMessageDialog* _tmp5_;
				GtkMessageDialog* _tmp6_;
				GtkMessageDialog* _tmp7_;
				GtkMessageDialog* _tmp8_;
				gint response = 0;
				GtkMessageDialog* _tmp9_;
				GtkMessageDialog* _tmp10_;
				_tmp1_ = file;
				if (!g_file_query_exists (_tmp1_, NULL)) {
					_g_object_unref0 (file);
					continue;
				}
				_tmp2_ = file;
				_tmp3_ = g_file_get_basename (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("A file named “%s” already exists.  Do you want to replace it?"), _tmp4_);
				g_object_ref_sink (_tmp5_);
				_tmp6_ = _tmp5_;
				_g_free0 (_tmp4_);
				dialog = _tmp6_;
				_tmp7_ = dialog;
				gtk_dialog_add_button ((GtkDialog*) _tmp7_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
				_tmp8_ = dialog;
				gtk_dialog_add_button ((GtkDialog*) _tmp8_, _ ("_Replace"), (gint) GTK_RESPONSE_ACCEPT);
				_tmp9_ = dialog;
				response = gtk_dialog_run ((GtkDialog*) _tmp9_);
				_tmp10_ = dialog;
				gtk_widget_destroy ((GtkWidget*) _tmp10_);
				if (response != ((gint) GTK_RESPONSE_ACCEPT)) {
					result = FALSE;
					_g_object_unref0 (dialog);
					_g_object_unref0 (file);
					return result;
				}
				_g_object_unref0 (dialog);
				_g_object_unref0 (file);
			}
		}
	}
	result = TRUE;
	return result;
}

static gchar*
app_window_mime_type_to_extension (AppWindow* self,
                                   const gchar* mime_type)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	if (g_strcmp0 (mime_type, "application/pdf") == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("pdf");
		result = _tmp0_;
		return result;
	} else {
		if (g_strcmp0 (mime_type, "image/jpeg") == 0) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("jpg");
			result = _tmp1_;
			return result;
		} else {
			if (g_strcmp0 (mime_type, "image/png") == 0) {
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("png");
				result = _tmp2_;
				return result;
			} else {
				if (g_strcmp0 (mime_type, "image/webp") == 0) {
					gchar* _tmp3_;
					_tmp3_ = g_strdup ("webp");
					result = _tmp3_;
					return result;
				} else {
					result = NULL;
					return result;
				}
			}
		}
	}
}

static gchar*
app_window_extension_to_mime_type (AppWindow* self,
                                   const gchar* extension)
{
	gchar* extension_lower = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = g_utf8_strdown (extension, (gssize) -1);
	extension_lower = _tmp0_;
	_tmp1_ = extension_lower;
	if (g_strcmp0 (_tmp1_, "pdf") == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("application/pdf");
		result = _tmp2_;
		_g_free0 (extension_lower);
		return result;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = extension_lower;
		if (g_strcmp0 (_tmp3_, "jpg") == 0) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("image/jpeg");
			result = _tmp4_;
			_g_free0 (extension_lower);
			return result;
		} else {
			const gchar* _tmp5_;
			_tmp5_ = extension_lower;
			if (g_strcmp0 (_tmp5_, "png") == 0) {
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("image/png");
				result = _tmp6_;
				_g_free0 (extension_lower);
				return result;
			} else {
				const gchar* _tmp7_;
				_tmp7_ = extension_lower;
				if (g_strcmp0 (_tmp7_, "webp") == 0) {
					gchar* _tmp8_;
					_tmp8_ = g_strdup ("image/webp");
					result = _tmp8_;
					_g_free0 (extension_lower);
					return result;
				} else {
					result = NULL;
					_g_free0 (extension_lower);
					return result;
				}
			}
		}
	}
}

static gchar*
app_window_uri_to_mime_type (AppWindow* self,
                             const gchar* uri)
{
	gint extension_index = 0;
	gchar* extension = NULL;
	gchar* _tmp1_;
	gchar* mime_type = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	extension_index = string_last_index_of_char (uri, (gunichar) '.', 0);
	if (extension_index < 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("image/jpeg");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = string_substring (uri, (glong) (extension_index + 1), (glong) -1);
	extension = _tmp1_;
	_tmp2_ = extension;
	_tmp3_ = app_window_extension_to_mime_type (self, _tmp2_);
	mime_type = _tmp3_;
	_tmp4_ = mime_type;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("image/jpeg");
		result = _tmp5_;
		_g_free0 (mime_type);
		_g_free0 (extension);
		return result;
	}
	result = mime_type;
	_g_free0 (extension);
	return result;
}

static void
app_window_save_document_async_data_free (gpointer _data)
{
	AppWindowSaveDocumentAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AppWindowSaveDocumentAsyncData, _data_);
}

static void
app_window_save_document_async (AppWindow* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	AppWindowSaveDocumentAsyncData* _data_;
	AppWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AppWindowSaveDocumentAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, app_window_save_document_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	app_window_save_document_async_co (_data_);
}

static gboolean
app_window_save_document_finish (AppWindow* self,
                                 GAsyncResult* _res_)
{
	gboolean result;
	AppWindowSaveDocumentAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		AppWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->progress_bar);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
___lambda30_ (Block2Data* _data2_,
              gdouble fraction)
{
	AppWindow* self;
	CancellableProgressBar* _tmp0_;
	self = _data2_->self;
	_tmp0_ = _data2_->progress_bar;
	cancellable_progress_bar_set_fraction (_tmp0_, fraction);
}

static void
____lambda30__progression_callback (gdouble fraction,
                                    gpointer self)
{
	___lambda30_ (self, fraction);
}

static void
app_window_save_document_async_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	AppWindowSaveDocumentAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	app_window_save_document_async_co (_data_);
}

static gboolean
app_window_save_document_async_co (AppWindowSaveDocumentAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = app_window_choose_file_location (_data_->self);
	_data_->uri = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->uri;
	if (_data_->_tmp1_ == NULL) {
		_data_->result = FALSE;
		_g_free0 (_data_->uri);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->uri;
	_data_->_tmp3_ = g_file_new_for_uri (_data_->_tmp2_);
	_data_->file = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->uri;
	g_debug ("app-window.vala:712: Saving to '%s'", _data_->_tmp4_);
	_data_->_tmp5_ = _data_->uri;
	_data_->_tmp6_ = app_window_uri_to_mime_type (_data_->self, _data_->_tmp5_);
	_data_->mime_type = _data_->_tmp6_;
	_data_->_tmp7_ = g_cancellable_new ();
	_data_->cancellable = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->cancellable;
	_data_->_tmp9_ = cancellable_progress_bar_new (_ ("Saving"), _data_->_tmp8_);
	g_object_ref_sink (_data_->_tmp9_);
	_data_->_data2_->progress_bar = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->self->priv->action_bar;
	_data_->_tmp11_ = _data_->_data2_->progress_bar;
	gtk_action_bar_pack_end (_data_->_tmp10_, (GtkWidget*) _data_->_tmp11_);
	_data_->_tmp12_ = _data_->_data2_->progress_bar;
	gtk_widget_set_visible ((GtkWidget*) _data_->_tmp12_, TRUE);
	_data_->_tmp13_ = _data_->self->priv->save_button;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp13_, FALSE);
	{
		_data_->_tmp14_ = _data_->self->priv->_book;
		_data_->_tmp15_ = _data_->mime_type;
		_data_->_tmp16_ = _data_->self->priv->settings;
		_data_->_tmp17_ = _data_->file;
		_data_->_tmp18_ = _data_->self->priv->settings;
		_data_->_tmp19_ = _data_->self->priv->settings;
		_data_->_tmp20_ = g_settings_get_string (_data_->_tmp19_, "postproc-script");
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = _data_->self->priv->settings;
		_data_->_tmp23_ = g_settings_get_string (_data_->_tmp22_, "postproc-arguments");
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = _data_->self->priv->settings;
		_data_->_tmp26_ = _data_->cancellable;
		_data_->_state_ = 1;
		book_save_async (_data_->_tmp14_, _data_->_tmp15_, g_settings_get_int (_data_->_tmp16_, "jpeg-quality"), _data_->_tmp17_, g_settings_get_boolean (_data_->_tmp18_, "postproc-enabled"), _data_->_tmp21_, _data_->_tmp24_, g_settings_get_boolean (_data_->_tmp25_, "postproc-keep-original"), ____lambda30__progression_callback, _data_->_data2_, _data_->_tmp26_, app_window_save_document_async_ready, _data_);
		return FALSE;
		_state_1:
		book_save_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp24_);
		_g_free0 (_data_->_tmp21_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp27_ = _data_->self->priv->save_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp27_, TRUE);
		_data_->_tmp28_ = _data_->_data2_->progress_bar;
		gtk_widget_destroy ((GtkWidget*) _data_->_tmp28_);
		_data_->_tmp29_ = _data_->e;
		_data_->_tmp30_ = _data_->_tmp29_->message;
		g_warning ("app-window.vala:735: Error saving file: %s", _data_->_tmp30_);
		_data_->_tmp31_ = _data_->e;
		_data_->_tmp32_ = _data_->_tmp31_->message;
		app_window_show_error_dialog (_data_->self, _ ("Failed to save file"), _data_->_tmp32_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->cancellable);
		_g_free0 (_data_->mime_type);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->uri);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->cancellable);
		_g_free0 (_data_->mime_type);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->uri);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp33_ = _data_->self->priv->save_button;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp33_, TRUE);
	_data_->_tmp34_ = _data_->_data2_->progress_bar;
	cancellable_progress_bar_destroy_with_delay (_data_->_tmp34_, (guint) 500);
	_data_->self->priv->book_needs_saving = FALSE;
	_data_->_tmp35_ = _data_->uri;
	_data_->_tmp36_ = g_strdup (_data_->_tmp35_);
	_g_free0 (_data_->self->priv->book_uri);
	_data_->self->priv->book_uri = _data_->_tmp36_;
	_data_->result = TRUE;
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->mime_type);
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->uri);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
app_window_prompt_to_save_async_data_free (gpointer _data)
{
	AppWindowPromptToSaveAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->title);
	_g_free0 (_data_->discard_label);
	_g_object_unref0 (_data_->self);
	g_slice_free (AppWindowPromptToSaveAsyncData, _data_);
}

static void
app_window_prompt_to_save_async (AppWindow* self,
                                 const gchar* title,
                                 const gchar* discard_label,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AppWindowPromptToSaveAsyncData* _data_;
	AppWindow* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (discard_label != NULL);
	_data_ = g_slice_new0 (AppWindowPromptToSaveAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, app_window_prompt_to_save_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (title);
	_g_free0 (_data_->title);
	_data_->title = _tmp1_;
	_tmp2_ = g_strdup (discard_label);
	_g_free0 (_data_->discard_label);
	_data_->discard_label = _tmp2_;
	app_window_prompt_to_save_async_co (_data_);
}

static gboolean
app_window_prompt_to_save_finish (AppWindow* self,
                                  GAsyncResult* _res_)
{
	gboolean result;
	AppWindowPromptToSaveAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
app_window_prompt_to_save_async_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	AppWindowPromptToSaveAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	app_window_prompt_to_save_async_co (_data_);
}

static gboolean
app_window_prompt_to_save_async_co (AppWindowPromptToSaveAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!_data_->self->priv->book_needs_saving) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp1_ = _data_->self->priv->_book;
		_data_->_tmp2_ = book_get_n_pages (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp0_ = _data_->_tmp3_ == ((guint) 0);
	}
	if (_data_->_tmp0_) {
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data_->self, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _data_->title);
	g_object_ref_sink (_data_->_tmp4_);
	_data_->dialog = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->dialog;
	gtk_message_dialog_format_secondary_text (_data_->_tmp5_, "%s", _ ("If you don’t save, changes will be permanently lost."));
	_data_->_tmp6_ = _data_->dialog;
	gtk_dialog_add_button ((GtkDialog*) _data_->_tmp6_, _data_->discard_label, (gint) GTK_RESPONSE_NO);
	_data_->_tmp7_ = _data_->dialog;
	gtk_dialog_add_button ((GtkDialog*) _data_->_tmp7_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_data_->_tmp8_ = _data_->dialog;
	gtk_dialog_add_button ((GtkDialog*) _data_->_tmp8_, _ ("_Save"), (gint) GTK_RESPONSE_YES);
	_data_->_tmp9_ = _data_->dialog;
	_data_->response = gtk_dialog_run ((GtkDialog*) _data_->_tmp9_);
	_data_->_tmp10_ = _data_->dialog;
	gtk_widget_destroy ((GtkWidget*) _data_->_tmp10_);
	switch (_data_->response) {
		case GTK_RESPONSE_YES:
		{
			_data_->_state_ = 1;
			app_window_save_document_async (_data_->self, app_window_prompt_to_save_async_ready, _data_);
			return FALSE;
			_state_1:
			if (app_window_save_document_finish (_data_->self, _data_->_res_)) {
				_data_->result = TRUE;
				_g_object_unref0 (_data_->dialog);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->result = FALSE;
				_g_object_unref0 (_data_->dialog);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		case GTK_RESPONSE_NO:
		{
			_data_->result = TRUE;
			_g_object_unref0 (_data_->dialog);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		default:
		{
			_data_->result = FALSE;
			_g_object_unref0 (_data_->dialog);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
}

static void
app_window_clear_document (AppWindow* self)
{
	Book* _tmp0_;
	GtkButton* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkStack* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_book;
	book_clear (_tmp0_);
	self->priv->book_needs_saving = FALSE;
	_g_free0 (self->priv->book_uri);
	self->priv->book_uri = NULL;
	_tmp1_ = self->priv->save_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->copy_to_clipboard_menuitem;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
	app_window_update_scan_status (self);
	_tmp3_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp3_, "startup");
}

static void
__lambda31_ (AppWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	AutosaveManager* _tmp2_;
	g_return_if_fail (res != NULL);
	if (!app_window_prompt_to_save_finish (self, res)) {
		return;
	}
	_tmp0_ = app_window_get_scanning (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_signal_emit (self, app_window_signals[APP_WINDOW_STOP_SCAN_SIGNAL], 0);
	}
	app_window_clear_document (self);
	_tmp2_ = self->priv->autosave_manager;
	autosave_manager_cleanup (_tmp2_);
}

static void
___lambda31__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda31_ ((AppWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
app_window_new_document (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_prompt_to_save_async (self, _ ("Save current document?"), _ ("_Discard Changes"), ___lambda31__gasync_ready_callback, g_object_ref (self));
}

static gboolean
app_window_status_label_activate_link_cb (AppWindow* self,
                                          GtkLabel* label,
                                          const gchar* uri)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (label != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	if (g_strcmp0 (uri, "install-firmware") == 0) {
		app_window_install_drivers (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
_app_window_status_label_activate_link_cb_gtk_label_activate_link (GtkLabel* _sender,
                                                                   const gchar* uri,
                                                                   gpointer self)
{
	gboolean result;
	result = app_window_status_label_activate_link_cb ((AppWindow*) self, _sender, uri);
	return result;
}

static void
app_window_new_document_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_new_document (self);
}

static void
app_window_redetect_button_clicked_cb (AppWindow* self,
                                       GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	self->priv->have_devices = FALSE;
	app_window_update_scan_status (self);
	g_signal_emit (self, app_window_signals[APP_WINDOW_REDETECT_SIGNAL], 0);
}

static void
_app_window_redetect_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	app_window_redetect_button_clicked_cb ((AppWindow*) self, _sender);
}

static void
app_window_scan (AppWindow* self,
                 ScanOptions* options)
{
	HdyStatusPage* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (options != NULL);
	_tmp0_ = self->priv->status_page;
	hdy_status_page_set_title (_tmp0_, _ ("Contacting Scanner…"));
	_tmp1_ = self->priv->device_buttons_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->device_buttons_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
	_tmp3_ = app_window_get_selected_device (self);
	_tmp4_ = _tmp3_;
	g_signal_emit (self, app_window_signals[APP_WINDOW_START_SCAN_SIGNAL], 0, _tmp4_, options);
	_g_free0 (_tmp4_);
}

static void
app_window_scan_single_cb (AppWindow* self)
{
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_make_scan_options (self);
	options = _tmp0_;
	options->type = SCAN_TYPE_SINGLE;
	app_window_scan (self, options);
	_g_object_unref0 (options);
}

static void
app_window_scan_adf_cb (AppWindow* self)
{
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_make_scan_options (self);
	options = _tmp0_;
	options->type = SCAN_TYPE_ADF;
	app_window_scan (self, options);
	_g_object_unref0 (options);
}

static void
app_window_scan_batch_cb (AppWindow* self)
{
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_make_scan_options (self);
	options = _tmp0_;
	options->type = SCAN_TYPE_BATCH;
	app_window_scan (self, options);
	_g_object_unref0 (options);
}

static void
app_window_scan_stop_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, app_window_signals[APP_WINDOW_STOP_SCAN_SIGNAL], 0);
}

static void
app_window_rotate_left_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_rotate_left_button_clicked_cb (self);
}

static void
app_window_rotate_right_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_rotate_right_button_clicked_cb (self);
}

static void
app_window_move_left_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_page_move_left_menuitem_activate_cb (self);
}

static void
app_window_move_right_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_page_move_right_menuitem_activate_cb (self);
}

static void
app_window_copy_page_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_copy_to_clipboard_button_clicked_cb (self);
}

static void
app_window_delete_page_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_page_delete_menuitem_activate_cb (self);
}

static void
app_window_set_scan_type (AppWindow* self,
                          ScanType scan_type)
{
	g_return_if_fail (self != NULL);
	self->priv->scan_type = scan_type;
	switch (scan_type) {
		case SCAN_TYPE_SINGLE:
		{
			GtkRadioButton* _tmp0_;
			GtkImage* _tmp1_;
			GtkButton* _tmp2_;
			_tmp0_ = self->priv->scan_single_radio;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, TRUE);
			_tmp1_ = self->priv->scan_options_image;
			g_object_set (_tmp1_, "icon-name", "scanner-symbolic", NULL);
			_tmp2_ = self->priv->scan_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _ ("Scan a single page from the scanner"));
			break;
		}
		case SCAN_TYPE_ADF:
		{
			GtkRadioButton* _tmp3_;
			GtkImage* _tmp4_;
			GtkButton* _tmp5_;
			_tmp3_ = self->priv->scan_adf_radio;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, TRUE);
			_tmp4_ = self->priv->scan_options_image;
			g_object_set (_tmp4_, "icon-name", "scan-type-adf-symbolic", NULL);
			_tmp5_ = self->priv->scan_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _ ("Scan multiple pages from the scanner"));
			break;
		}
		case SCAN_TYPE_BATCH:
		{
			GtkRadioButton* _tmp6_;
			GtkImage* _tmp7_;
			GtkButton* _tmp8_;
			_tmp6_ = self->priv->scan_batch_radio;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp6_, TRUE);
			_tmp7_ = self->priv->scan_options_image;
			g_object_set (_tmp7_, "icon-name", "scan-type-batch-symbolic", NULL);
			_tmp8_ = self->priv->scan_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _ ("Scan multiple pages from the scanner"));
			break;
		}
		default:
		break;
	}
}

static void
app_window_scan_single_radio_toggled_cb (AppWindow* self,
                                         GtkToggleButton* button)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_scan_type (self, SCAN_TYPE_SINGLE);
	}
}

static void
_app_window_scan_single_radio_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                    gpointer self)
{
	app_window_scan_single_radio_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_scan_adf_radio_toggled_cb (AppWindow* self,
                                      GtkToggleButton* button)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_scan_type (self, SCAN_TYPE_ADF);
	}
}

static void
_app_window_scan_adf_radio_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                 gpointer self)
{
	app_window_scan_adf_radio_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_scan_batch_radio_toggled_cb (AppWindow* self,
                                        GtkToggleButton* button)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_scan_type (self, SCAN_TYPE_BATCH);
	}
}

static void
_app_window_scan_batch_radio_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                   gpointer self)
{
	app_window_scan_batch_radio_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_set_document_hint (AppWindow* self,
                              const gchar* document_hint,
                              gboolean save)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (document_hint != NULL);
	_tmp0_ = g_strdup (document_hint);
	_g_free0 (self->priv->document_hint);
	self->priv->document_hint = _tmp0_;
	if (g_strcmp0 (document_hint, "text") == 0) {
		GtkRadioButton* _tmp1_;
		GtkImage* _tmp2_;
		_tmp1_ = self->priv->text_radio;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp1_, TRUE);
		_tmp2_ = self->priv->scan_hint_image;
		g_object_set (_tmp2_, "icon-name", "x-office-document-symbolic", NULL);
	} else {
		if (g_strcmp0 (document_hint, "photo") == 0) {
			GtkRadioButton* _tmp3_;
			GtkImage* _tmp4_;
			_tmp3_ = self->priv->photo_radio;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, TRUE);
			_tmp4_ = self->priv->scan_hint_image;
			g_object_set (_tmp4_, "icon-name", "image-x-generic-symbolic", NULL);
		}
	}
	if (save) {
		GSettings* _tmp5_;
		_tmp5_ = self->priv->settings;
		g_settings_set_string (_tmp5_, "document-type", document_hint);
	}
}

static void
app_window_text_radio_toggled_cb (AppWindow* self,
                                  GtkToggleButton* button)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_document_hint (self, "text", TRUE);
	}
}

static void
_app_window_text_radio_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                             gpointer self)
{
	app_window_text_radio_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_photo_radio_toggled_cb (AppWindow* self,
                                   GtkToggleButton* button)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_document_hint (self, "photo", TRUE);
	}
}

static void
_app_window_photo_radio_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                              gpointer self)
{
	app_window_photo_radio_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_preferences_button_clicked_cb (AppWindow* self,
                                          GtkButton* button)
{
	PreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp0_);
}

static void
_app_window_preferences_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	app_window_preferences_button_clicked_cb ((AppWindow*) self, _sender);
}

static ScanOptions*
app_window_make_scan_options (AppWindow* self)
{
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_;
	const gchar* _tmp1_;
	PreferencesDialog* _tmp10_;
	ScanOptions* _tmp11_;
	ScanOptions* _tmp12_;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	ScanOptions* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	ScanOptions* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	ScanOptions* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	ScanOptions* _tmp24_;
	PreferencesDialog* _tmp25_;
	ScanOptions* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = scan_options_new ();
	options = _tmp0_;
	_tmp1_ = self->priv->document_hint;
	if (g_strcmp0 (_tmp1_, "text") == 0) {
		ScanOptions* _tmp2_;
		ScanOptions* _tmp3_;
		PreferencesDialog* _tmp4_;
		ScanOptions* _tmp5_;
		_tmp2_ = options;
		_tmp2_->scan_mode = SCAN_MODE_GRAY;
		_tmp3_ = options;
		_tmp4_ = self->priv->preferences_dialog;
		_tmp3_->dpi = preferences_dialog_get_text_dpi (_tmp4_);
		_tmp5_ = options;
		_tmp5_->depth = 2;
	} else {
		ScanOptions* _tmp6_;
		ScanOptions* _tmp7_;
		PreferencesDialog* _tmp8_;
		ScanOptions* _tmp9_;
		_tmp6_ = options;
		_tmp6_->scan_mode = SCAN_MODE_COLOR;
		_tmp7_ = options;
		_tmp8_ = self->priv->preferences_dialog;
		_tmp7_->dpi = preferences_dialog_get_photo_dpi (_tmp8_);
		_tmp9_ = options;
		_tmp9_->depth = 8;
	}
	_tmp10_ = self->priv->preferences_dialog;
	_tmp11_ = options;
	_tmp12_ = options;
	preferences_dialog_get_paper_size (_tmp10_, &_tmp13_, &_tmp14_);
	_tmp11_->paper_width = _tmp13_;
	_tmp12_->paper_height = _tmp14_;
	_tmp15_ = options;
	_tmp16_ = app_window_get_brightness (self);
	_tmp17_ = _tmp16_;
	_tmp15_->brightness = _tmp17_;
	_tmp18_ = options;
	_tmp19_ = app_window_get_contrast (self);
	_tmp20_ = _tmp19_;
	_tmp18_->contrast = _tmp20_;
	_tmp21_ = options;
	_tmp22_ = app_window_get_page_delay (self);
	_tmp23_ = _tmp22_;
	_tmp21_->page_delay = _tmp23_;
	_tmp24_ = options;
	_tmp25_ = self->priv->preferences_dialog;
	_tmp24_->side = preferences_dialog_get_page_side (_tmp25_);
	result = options;
	return result;
}

static void
app_window_device_combo_changed_cb (AppWindow* self,
                                    GtkWidget* widget)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (self->priv->setting_devices) {
		return;
	}
	self->priv->user_selected_device = TRUE;
	_tmp0_ = app_window_get_selected_device (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		GSettings* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->priv->settings;
		_tmp4_ = app_window_get_selected_device (self);
		_tmp5_ = _tmp4_;
		g_settings_set_string (_tmp3_, "selected-device", _tmp5_);
		_g_free0 (_tmp5_);
	}
}

static void
_app_window_device_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                           gpointer self)
{
	app_window_device_combo_changed_cb ((AppWindow*) self, _sender);
}

static void
app_window_scan_button_clicked_cb (AppWindow* self,
                                   GtkWidget* widget)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	ScanOptions* options = NULL;
	ScanOptions* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scan_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = self->priv->stop_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = app_window_make_scan_options (self);
	options = _tmp2_;
	options->type = self->priv->scan_type;
	app_window_scan (self, options);
	_g_object_unref0 (options);
}

static void
_app_window_scan_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self)
{
	app_window_scan_button_clicked_cb ((AppWindow*) self, _sender);
}

static void
app_window_stop_scan_button_clicked_cb (AppWindow* self,
                                        GtkWidget* widget)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scan_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->stop_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
	g_signal_emit (self, app_window_signals[APP_WINDOW_STOP_SCAN_SIGNAL], 0);
}

static void
_app_window_stop_scan_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	app_window_stop_scan_button_clicked_cb ((AppWindow*) self, _sender);
}

static void
app_window_preferences_cb (AppWindow* self)
{
	PreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp0_);
}

static void
app_window_update_page_menu (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		GtkMenuItem* _tmp5_;
		GtkMenuItem* _tmp6_;
		_tmp5_ = self->priv->page_move_left_menuitem;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
		_tmp6_ = self->priv->page_move_right_menuitem;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
	} else {
		guint index = 0U;
		Book* _tmp7_;
		Page* _tmp8_;
		GtkMenuItem* _tmp9_;
		GtkMenuItem* _tmp10_;
		Book* _tmp11_;
		guint _tmp12_;
		guint _tmp13_;
		_tmp7_ = self->priv->_book;
		_tmp8_ = page;
		index = book_get_page_index (_tmp7_, _tmp8_);
		_tmp9_ = self->priv->page_move_left_menuitem;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, index > ((guint) 0));
		_tmp10_ = self->priv->page_move_right_menuitem;
		_tmp11_ = self->priv->_book;
		_tmp12_ = book_get_n_pages (_tmp11_);
		_tmp13_ = _tmp12_;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, index < (_tmp13_ - 1));
	}
	_g_object_unref0 (page);
}

static void
app_window_page_selected_cb (AppWindow* self,
                             BookView* view,
                             Page* page)
{
	GtkRadioMenuItem* menuitem = NULL;
	GtkRadioMenuItem* _tmp0_;
	GtkRadioMenuItem* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkRadioMenuItem* _tmp31_;
	GtkToggleButton* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	if (page == NULL) {
		return;
	}
	self->priv->updating_page_menu = TRUE;
	app_window_update_page_menu (self);
	_tmp0_ = self->priv->no_crop_menuitem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	menuitem = _tmp1_;
	_tmp2_ = page_get_has_crop (page);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gchar* crop_name = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = page_get_crop_name (page);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		crop_name = _tmp6_;
		_tmp7_ = crop_name;
		if (_tmp7_ != NULL) {
			const gchar* _tmp8_;
			_tmp8_ = crop_name;
			if (g_strcmp0 (_tmp8_, "A3") == 0) {
				GtkRadioMenuItem* _tmp9_;
				GtkRadioMenuItem* _tmp10_;
				_tmp9_ = self->priv->a3_menuitem;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				_g_object_unref0 (menuitem);
				menuitem = _tmp10_;
			} else {
				const gchar* _tmp11_;
				_tmp11_ = crop_name;
				if (g_strcmp0 (_tmp11_, "A4") == 0) {
					GtkRadioMenuItem* _tmp12_;
					GtkRadioMenuItem* _tmp13_;
					_tmp12_ = self->priv->a4_menuitem;
					_tmp13_ = _g_object_ref0 (_tmp12_);
					_g_object_unref0 (menuitem);
					menuitem = _tmp13_;
				} else {
					const gchar* _tmp14_;
					_tmp14_ = crop_name;
					if (g_strcmp0 (_tmp14_, "A5") == 0) {
						GtkRadioMenuItem* _tmp15_;
						GtkRadioMenuItem* _tmp16_;
						_tmp15_ = self->priv->a5_menuitem;
						_tmp16_ = _g_object_ref0 (_tmp15_);
						_g_object_unref0 (menuitem);
						menuitem = _tmp16_;
					} else {
						const gchar* _tmp17_;
						_tmp17_ = crop_name;
						if (g_strcmp0 (_tmp17_, "A6") == 0) {
							GtkRadioMenuItem* _tmp18_;
							GtkRadioMenuItem* _tmp19_;
							_tmp18_ = self->priv->a6_menuitem;
							_tmp19_ = _g_object_ref0 (_tmp18_);
							_g_object_unref0 (menuitem);
							menuitem = _tmp19_;
						} else {
							const gchar* _tmp20_;
							_tmp20_ = crop_name;
							if (g_strcmp0 (_tmp20_, "letter") == 0) {
								GtkRadioMenuItem* _tmp21_;
								GtkRadioMenuItem* _tmp22_;
								_tmp21_ = self->priv->letter_menuitem;
								_tmp22_ = _g_object_ref0 (_tmp21_);
								_g_object_unref0 (menuitem);
								menuitem = _tmp22_;
							} else {
								const gchar* _tmp23_;
								_tmp23_ = crop_name;
								if (g_strcmp0 (_tmp23_, "legal") == 0) {
									GtkRadioMenuItem* _tmp24_;
									GtkRadioMenuItem* _tmp25_;
									_tmp24_ = self->priv->legal_menuitem;
									_tmp25_ = _g_object_ref0 (_tmp24_);
									_g_object_unref0 (menuitem);
									menuitem = _tmp25_;
								} else {
									const gchar* _tmp26_;
									_tmp26_ = crop_name;
									if (g_strcmp0 (_tmp26_, "4x6") == 0) {
										GtkRadioMenuItem* _tmp27_;
										GtkRadioMenuItem* _tmp28_;
										_tmp27_ = self->priv->four_by_six_menuitem;
										_tmp28_ = _g_object_ref0 (_tmp27_);
										_g_object_unref0 (menuitem);
										menuitem = _tmp28_;
									}
								}
							}
						}
					}
				}
			}
		} else {
			GtkRadioMenuItem* _tmp29_;
			GtkRadioMenuItem* _tmp30_;
			_tmp29_ = self->priv->custom_crop_menuitem;
			_tmp30_ = _g_object_ref0 (_tmp29_);
			_g_object_unref0 (menuitem);
			menuitem = _tmp30_;
		}
		_g_free0 (crop_name);
	}
	_tmp31_ = menuitem;
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp31_, TRUE);
	_tmp32_ = self->priv->crop_button;
	_tmp33_ = page_get_has_crop (page);
	_tmp34_ = _tmp33_;
	gtk_toggle_button_set_active (_tmp32_, _tmp34_);
	self->priv->updating_page_menu = FALSE;
	_g_object_unref0 (menuitem);
}

static void
app_window_show_page_cb (AppWindow* self,
                         BookView* view,
                         Page* page)
{
	GFile* file = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (page != NULL);
	{
		gchar* dir = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp0_ = g_dir_make_tmp ("simple-scan-XXXXXX", &_inner_error0_);
		dir = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = dir;
		_tmp2_ = g_build_filename (_tmp1_, "scan.png", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_g_object_unref0 (file);
		file = _tmp4_;
		_g_free0 (_tmp3_);
		_tmp5_ = file;
		page_save_png (page, _tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (dir);
			goto __catch0_g_error;
		}
		_g_free0 (dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		app_window_show_error_dialog (self, _ ("Unable to save image for preview"), _tmp7_);
		_g_error_free0 (e);
		_g_object_unref0 (file);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GdkScreen* _tmp8_;
		GdkScreen* _tmp9_;
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = file;
		_tmp11_ = g_file_get_uri (_tmp10_);
		_tmp12_ = _tmp11_;
		gtk_show_uri (_tmp9_, _tmp12_, gtk_get_current_event_time (), &_inner_error0_);
		_g_free0 (_tmp12_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		app_window_show_error_dialog (self, _ ("Unable to open image preview application"), _tmp14_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

static void
app_window_show_page_menu_cb (AppWindow* self,
                              BookView* view,
                              GdkEvent* event)
{
	GtkMenu* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->page_menu;
	gtk_menu_popup_at_pointer (_tmp0_, event);
}

static void
app_window_rotate_left_button_clicked_cb (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	if (self->priv->updating_page_menu) {
		return;
	}
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ != NULL) {
		Page* _tmp5_;
		_tmp5_ = page;
		page_rotate_left (_tmp5_);
	}
	_g_object_unref0 (page);
}

static void
_app_window_rotate_left_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                  gpointer self)
{
	app_window_rotate_left_button_clicked_cb ((AppWindow*) self);
}

static void
app_window_rotate_right_button_clicked_cb (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	if (self->priv->updating_page_menu) {
		return;
	}
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ != NULL) {
		Page* _tmp5_;
		_tmp5_ = page;
		page_rotate_right (_tmp5_);
	}
	_g_object_unref0 (page);
}

static void
_app_window_rotate_right_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                   gpointer self)
{
	app_window_rotate_right_button_clicked_cb ((AppWindow*) self);
}

static void
app_window_set_crop (AppWindow* self,
                     const gchar* crop_name)
{
	GtkMenuItem* _tmp0_;
	Page* page = NULL;
	BookView* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->crop_rotate_menuitem;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, crop_name != NULL);
	if (self->priv->updating_page_menu) {
		return;
	}
	_tmp1_ = self->priv->book_view;
	_tmp2_ = book_view_get_selected_page (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	page = _tmp4_;
	_tmp5_ = page;
	if (_tmp5_ == NULL) {
		g_warning ("app-window.vala:1163: Trying to set crop but no selected page");
		_g_object_unref0 (page);
		return;
	}
	if (crop_name == NULL) {
		Page* _tmp6_;
		_tmp6_ = page;
		page_set_no_crop (_tmp6_);
	} else {
		if (g_strcmp0 (crop_name, "custom") == 0) {
			gint width = 0;
			Page* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint height = 0;
			Page* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint crop_width = 0;
			gint crop_height = 0;
			Page* _tmp13_;
			Page* _tmp14_;
			_tmp7_ = page;
			_tmp8_ = page_get_width (_tmp7_);
			_tmp9_ = _tmp8_;
			width = _tmp9_;
			_tmp10_ = page;
			_tmp11_ = page_get_height (_tmp10_);
			_tmp12_ = _tmp11_;
			height = _tmp12_;
			crop_width = (gint) ((width * 0.8) + 0.5);
			crop_height = (gint) ((height * 0.8) + 0.5);
			_tmp13_ = page;
			page_set_custom_crop (_tmp13_, crop_width, crop_height);
			_tmp14_ = page;
			page_move_crop (_tmp14_, (width - crop_width) / 2, (height - crop_height) / 2);
		} else {
			Page* _tmp15_;
			_tmp15_ = page;
			page_set_named_crop (_tmp15_, crop_name);
		}
	}
	_g_object_unref0 (page);
}

static void
app_window_no_crop_menuitem_toggled_cb (AppWindow* self,
                                        GtkCheckMenuItem* widget)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_crop (self, NULL);
	}
}

static void
_app_window_no_crop_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                     gpointer self)
{
	app_window_no_crop_menuitem_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_custom_crop_menuitem_toggled_cb (AppWindow* self,
                                            GtkCheckMenuItem* widget)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_crop (self, "custom");
	}
}

static void
_app_window_custom_crop_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                         gpointer self)
{
	app_window_custom_crop_menuitem_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_four_by_six_menuitem_toggled_cb (AppWindow* self,
                                            GtkCheckMenuItem* widget)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_crop (self, "4x6");
	}
}

static void
_app_window_four_by_six_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                         gpointer self)
{
	app_window_four_by_six_menuitem_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_legal_menuitem_toggled_cb (AppWindow* self,
                                      GtkCheckMenuItem* widget)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_crop (self, "legal");
	}
}

static void
_app_window_legal_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                   gpointer self)
{
	app_window_legal_menuitem_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_letter_menuitem_toggled_cb (AppWindow* self,
                                       GtkCheckMenuItem* widget)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_crop (self, "letter");
	}
}

static void
_app_window_letter_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                    gpointer self)
{
	app_window_letter_menuitem_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_a6_menuitem_toggled_cb (AppWindow* self,
                                   GtkCheckMenuItem* widget)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_crop (self, "A6");
	}
}

static void
_app_window_a6_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                gpointer self)
{
	app_window_a6_menuitem_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_a5_menuitem_toggled_cb (AppWindow* self,
                                   GtkCheckMenuItem* widget)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_crop (self, "A5");
	}
}

static void
_app_window_a5_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                gpointer self)
{
	app_window_a5_menuitem_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_a4_menuitem_toggled_cb (AppWindow* self,
                                   GtkCheckMenuItem* widget)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_crop (self, "A4");
	}
}

static void
_app_window_a4_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                gpointer self)
{
	app_window_a4_menuitem_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_a3_menuitem_toggled_cb (AppWindow* self,
                                   GtkCheckMenuItem* widget)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (widget);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		app_window_set_crop (self, "A3");
	}
}

static void
_app_window_a3_menuitem_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                gpointer self)
{
	app_window_a3_menuitem_toggled_cb ((AppWindow*) self, _sender);
}

static void
app_window_crop_rotate_menuitem_activate_cb (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (page);
		return;
	}
	_tmp5_ = page;
	page_rotate_crop (_tmp5_);
	_g_object_unref0 (page);
}

static void
_app_window_crop_rotate_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                     gpointer self)
{
	app_window_crop_rotate_menuitem_activate_cb ((AppWindow*) self);
}

static void
app_window_page_move_left_menuitem_activate_cb (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	guint index = 0U;
	Book* _tmp4_;
	Page* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = self->priv->_book;
	_tmp5_ = page;
	index = book_get_page_index (_tmp4_, _tmp5_);
	if (index > ((guint) 0)) {
		Book* _tmp6_;
		Page* _tmp7_;
		_tmp6_ = self->priv->_book;
		_tmp7_ = page;
		book_move_page (_tmp6_, _tmp7_, index - 1);
	}
	_g_object_unref0 (page);
}

static void
_app_window_page_move_left_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                        gpointer self)
{
	app_window_page_move_left_menuitem_activate_cb ((AppWindow*) self);
}

static void
app_window_page_move_right_menuitem_activate_cb (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	guint index = 0U;
	Book* _tmp4_;
	Page* _tmp5_;
	Book* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = self->priv->_book;
	_tmp5_ = page;
	index = book_get_page_index (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->_book;
	_tmp7_ = book_get_n_pages (_tmp6_);
	_tmp8_ = _tmp7_;
	if (index < (_tmp8_ - 1)) {
		Book* _tmp9_;
		Page* _tmp10_;
		Book* _tmp11_;
		Page* _tmp12_;
		_tmp9_ = self->priv->_book;
		_tmp10_ = page;
		_tmp11_ = self->priv->_book;
		_tmp12_ = page;
		book_move_page (_tmp9_, _tmp10_, book_get_page_index (_tmp11_, _tmp12_) + 1);
	}
	_g_object_unref0 (page);
}

static void
_app_window_page_move_right_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                         gpointer self)
{
	app_window_page_move_right_menuitem_activate_cb ((AppWindow*) self);
}

static void
app_window_page_delete_menuitem_activate_cb (AppWindow* self)
{
	BookView* _tmp0_;
	Book* _tmp1_;
	Book* _tmp2_;
	BookView* _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_book (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->book_view;
	_tmp4_ = book_view_get_selected_page (_tmp3_);
	_tmp5_ = _tmp4_;
	book_delete_page (_tmp2_, _tmp5_);
}

static void
_app_window_page_delete_menuitem_activate_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                     gpointer self)
{
	app_window_page_delete_menuitem_activate_cb ((AppWindow*) self);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		AppWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda32_ (Block3Data* _data3_,
             GdkEventKey* e)
{
	AppWindow* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data3_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->state == 0) {
		_tmp0_ = e->keyval == GDK_KEY_Escape;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda32__gtk_widget_key_press_event (GtkWidget* _sender,
                                         GdkEventKey* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda32_ (self, event);
	return result;
}

static void
__lambda33_ (Block3Data* _data3_)
{
	AppWindow* self;
	Book* _tmp0_;
	self = _data3_->self;
	_tmp0_ = self->priv->_book;
	book_combine_sides (_tmp0_);
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
}

static void
___lambda33__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda33_ (self);
}

static void
__lambda34_ (Block3Data* _data3_)
{
	AppWindow* self;
	Book* _tmp0_;
	self = _data3_->self;
	_tmp0_ = self->priv->_book;
	book_combine_sides_reverse (_tmp0_);
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
}

static void
___lambda34__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda34_ (self);
}

static void
__lambda35_ (Block3Data* _data3_)
{
	AppWindow* self;
	Book* _tmp0_;
	self = _data3_->self;
	_tmp0_ = self->priv->_book;
	book_reverse (_tmp0_);
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
}

static void
___lambda35__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda35_ (self);
}

static void
__lambda36_ (Block3Data* _data3_)
{
	AppWindow* self;
	self = _data3_->self;
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
}

static void
___lambda36__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda36_ (self);
}

static void
app_window_reorder_document (AppWindow* self)
{
	Block3Data* _data3_;
	GtkWindow* _tmp0_;
	GtkGrid* g = NULL;
	GtkGrid* _tmp1_;
	GtkButton* b = NULL;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_object_ref_sink (_tmp0_);
	_data3_->dialog = _tmp0_;
	gtk_window_set_type_hint (_data3_->dialog, GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_modal (_data3_->dialog, TRUE);
	gtk_container_set_border_width ((GtkContainer*) _data3_->dialog, (guint) 12);
	gtk_window_set_title (_data3_->dialog, C_ ("dialog title", "Reorder Pages"));
	gtk_window_set_transient_for (_data3_->dialog, (GtkWindow*) self);
	g_signal_connect_data ((GtkWidget*) _data3_->dialog, "key-press-event", (GCallback) ___lambda32__gtk_widget_key_press_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	gtk_widget_set_visible ((GtkWidget*) _data3_->dialog, TRUE);
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp1_);
	g = _tmp1_;
	gtk_grid_set_row_homogeneous (g, TRUE);
	gtk_grid_set_row_spacing (g, 6);
	gtk_grid_set_column_homogeneous (g, TRUE);
	gtk_grid_set_column_spacing (g, 6);
	gtk_widget_set_visible ((GtkWidget*) g, TRUE);
	gtk_container_add ((GtkContainer*) _data3_->dialog, (GtkWidget*) g);
	_tmp2_ = app_window_make_reorder_button (self, _ ("Combine sides"), "F1F2F3B1B2B3-F1B1F2B2F3B3");
	b = _tmp2_;
	_tmp3_ = b;
	g_signal_connect_data (_tmp3_, "clicked", (GCallback) ___lambda33__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp4_ = b;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = b;
	gtk_grid_attach (g, (GtkWidget*) _tmp5_, 0, 0, 1, 1);
	_tmp6_ = app_window_make_reorder_button (self, _ ("Combine sides (reverse)"), "F1F2F3B3B2B1-F1B1F2B2F3B3");
	_g_object_unref0 (b);
	b = _tmp6_;
	_tmp7_ = b;
	g_signal_connect_data (_tmp7_, "clicked", (GCallback) ___lambda34__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp8_ = b;
	gtk_widget_set_visible ((GtkWidget*) _tmp8_, TRUE);
	_tmp9_ = b;
	gtk_grid_attach (g, (GtkWidget*) _tmp9_, 1, 0, 1, 1);
	_tmp10_ = app_window_make_reorder_button (self, _ ("Reverse"), "C1C2C3C4C5C6-C6C5C4C3C2C1");
	_g_object_unref0 (b);
	b = _tmp10_;
	_tmp11_ = b;
	g_signal_connect_data (_tmp11_, "clicked", (GCallback) ___lambda35__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp12_ = b;
	gtk_widget_set_visible ((GtkWidget*) _tmp12_, TRUE);
	_tmp13_ = b;
	gtk_grid_attach (g, (GtkWidget*) _tmp13_, 0, 2, 1, 1);
	_tmp14_ = app_window_make_reorder_button (self, _ ("Keep unchanged"), "C1C2C3C4C5C6-C1C2C3C4C5C6");
	_g_object_unref0 (b);
	b = _tmp14_;
	_tmp15_ = b;
	g_signal_connect_data (_tmp15_, "clicked", (GCallback) ___lambda36__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp16_ = b;
	gtk_widget_set_visible ((GtkWidget*) _tmp16_, TRUE);
	_tmp17_ = b;
	gtk_grid_attach (g, (GtkWidget*) _tmp17_, 1, 2, 1, 1);
	gtk_window_present (_data3_->dialog);
	_g_object_unref0 (b);
	_g_object_unref0 (g);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
app_window_reorder_document_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_reorder_document (self);
}

static GtkButton*
app_window_make_reorder_button (AppWindow* self,
                                const gchar* text,
                                const gchar* items)
{
	GtkButton* b = NULL;
	GtkButton* _tmp0_;
	GtkBox* vbox = NULL;
	GtkBox* _tmp1_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp2_;
	GtkBox* rb = NULL;
	GtkBox* _tmp3_;
	GtkButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (items != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp0_);
	b = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp1_);
	vbox = _tmp1_;
	gtk_widget_set_visible ((GtkWidget*) vbox, TRUE);
	gtk_container_add ((GtkContainer*) b, (GtkWidget*) vbox);
	_tmp2_ = (GtkLabel*) gtk_label_new (text);
	g_object_ref_sink (_tmp2_);
	label = _tmp2_;
	gtk_widget_set_visible ((GtkWidget*) label, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) label, TRUE);
	gtk_container_add ((GtkContainer*) vbox, (GtkWidget*) label);
	_tmp3_ = app_window_make_reorder_box (self, items);
	rb = _tmp3_;
	gtk_widget_set_visible ((GtkWidget*) rb, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) rb, TRUE);
	gtk_container_add ((GtkContainer*) vbox, (GtkWidget*) rb);
	result = b;
	_g_object_unref0 (rb);
	_g_object_unref0 (label);
	_g_object_unref0 (vbox);
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static GtkBox*
app_window_make_reorder_box (AppWindow* self,
                             const gchar* items)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* page_box = NULL;
	GtkBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (items != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = box;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	page_box = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar side = '\0';
				gint _tmp8_;
				GtkBox* _tmp9_;
				PageIcon* icon = NULL;
				PageIcon* _tmp14_;
				PageIcon* _tmp15_;
				GtkBox* _tmp16_;
				PageIcon* _tmp17_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(string_get (items, (glong) i) != '\0')) {
					break;
				}
				if (string_get (items, (glong) i) == '-') {
					GtkLabel* a = NULL;
					GtkLabel* _tmp4_;
					GtkLabel* _tmp5_;
					GtkBox* _tmp6_;
					GtkLabel* _tmp7_;
					_tmp4_ = (GtkLabel*) gtk_label_new ("➤");
					g_object_ref_sink (_tmp4_);
					a = _tmp4_;
					_tmp5_ = a;
					gtk_widget_set_visible ((GtkWidget*) _tmp5_, TRUE);
					_tmp6_ = box;
					_tmp7_ = a;
					gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
					_g_object_unref0 (page_box);
					page_box = NULL;
					_g_object_unref0 (a);
					continue;
				}
				side = string_get (items, (glong) i);
				_tmp8_ = i;
				i = _tmp8_ + 1;
				if (string_get (items, (glong) i) == '\0') {
					break;
				}
				_tmp9_ = page_box;
				if (_tmp9_ == NULL) {
					GtkBox* _tmp10_;
					GtkBox* _tmp11_;
					GtkBox* _tmp12_;
					GtkBox* _tmp13_;
					_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
					g_object_ref_sink (_tmp10_);
					_g_object_unref0 (page_box);
					page_box = _tmp10_;
					_tmp11_ = page_box;
					gtk_widget_set_visible ((GtkWidget*) _tmp11_, TRUE);
					_tmp12_ = box;
					_tmp13_ = page_box;
					gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
				}
				_tmp14_ = page_icon_new (side, (gint) (string_get (items, (glong) i) - '1'));
				g_object_ref_sink (_tmp14_);
				icon = _tmp14_;
				_tmp15_ = icon;
				gtk_widget_set_visible ((GtkWidget*) _tmp15_, TRUE);
				_tmp16_ = page_box;
				_tmp17_ = icon;
				gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
				_g_object_unref0 (icon);
			}
		}
	}
	result = box;
	_g_object_unref0 (page_box);
	return result;
}

static void
app_window_save_file_button_clicked_cb (AppWindow* self,
                                        GtkWidget* widget)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	app_window_save_document_async (self, NULL, NULL);
}

static void
_app_window_save_file_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	app_window_save_file_button_clicked_cb ((AppWindow*) self, _sender);
}

void
app_window_save_document_activate_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_save_document_async (self, NULL, NULL);
}

static void
app_window_copy_to_clipboard_button_clicked_cb (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ != NULL) {
		Page* _tmp5_;
		_tmp5_ = page;
		page_copy_to_clipboard (_tmp5_, (GtkWindow*) self);
	}
	_g_object_unref0 (page);
}

static void
_app_window_copy_to_clipboard_button_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                        gpointer self)
{
	app_window_copy_to_clipboard_button_clicked_cb ((AppWindow*) self);
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static void
app_window_draw_page (AppWindow* self,
                      GtkPrintOperation* operation,
                      GtkPrintContext* print_context,
                      gint page_number)
{
	cairo_t* context = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	Page* page = NULL;
	Book* _tmp2_;
	Page* _tmp3_;
	gboolean is_landscape = FALSE;
	Page* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	cairo_t* _tmp9_;
	Page* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	Page* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GdkPixbuf* image = NULL;
	Page* _tmp16_;
	GdkPixbuf* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_return_if_fail (print_context != NULL);
	_tmp0_ = gtk_print_context_get_cairo_context (print_context);
	_tmp1_ = _cairo_reference0 (_tmp0_);
	context = _tmp1_;
	_tmp2_ = self->priv->_book;
	_tmp3_ = book_get_page (_tmp2_, page_number);
	page = _tmp3_;
	is_landscape = FALSE;
	if (gtk_print_context_get_width (print_context) > gtk_print_context_get_height (print_context)) {
		is_landscape = TRUE;
	}
	_tmp4_ = page;
	_tmp5_ = page_get_is_landscape (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != is_landscape) {
		cairo_t* _tmp7_;
		cairo_t* _tmp8_;
		_tmp7_ = context;
		cairo_translate (_tmp7_, gtk_print_context_get_width (print_context), (gdouble) 0);
		_tmp8_ = context;
		cairo_rotate (_tmp8_, G_PI_2);
	}
	_tmp9_ = context;
	_tmp10_ = page;
	_tmp11_ = page_get_dpi (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = page;
	_tmp14_ = page_get_dpi (_tmp13_);
	_tmp15_ = _tmp14_;
	cairo_scale (_tmp9_, gtk_print_context_get_dpi_x (print_context) / _tmp12_, gtk_print_context_get_dpi_y (print_context) / _tmp15_);
	_tmp16_ = page;
	_tmp17_ = page_get_image (_tmp16_, TRUE);
	image = _tmp17_;
	_tmp18_ = context;
	gdk_cairo_set_source_pixbuf (_tmp18_, image, (gdouble) 0, (gdouble) 0);
	_tmp19_ = context;
	cairo_paint (_tmp19_);
	_g_object_unref0 (image);
	_g_object_unref0 (page);
	_cairo_destroy0 (context);
}

static void
app_window_email_document_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_email_document_async (self, NULL, NULL);
}

static void
app_window_email_document_async_data_free (gpointer _data)
{
	AppWindowEmailDocumentAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AppWindowEmailDocumentAsyncData, _data_);
}

static void
app_window_email_document_async (AppWindow* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AppWindowEmailDocumentAsyncData* _data_;
	AppWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AppWindowEmailDocumentAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, app_window_email_document_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	app_window_email_document_async_co (_data_);
}

static void
app_window_email_document_finish (AppWindow* self,
                                  GAsyncResult* _res_)
{
	AppWindowEmailDocumentAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
app_window_email_document_async_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	AppWindowEmailDocumentAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	app_window_email_document_async_co (_data_);
}

static gboolean
app_window_email_document_async_co (AppWindowEmailDocumentAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = g_dir_make_tmp ("simple-scan-XXXXXX", &_data_->_inner_error0_);
		_data_->dir = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = _data_->self->priv->document_hint;
		if (g_strcmp0 (_data_->_tmp1_, "text") == 0) {
			_data_->_tmp2_ = g_strdup ("application/pdf");
			_g_free0 (_data_->mime_type);
			_data_->mime_type = _data_->_tmp2_;
			_data_->_tmp3_ = g_strdup ("scan.pdf");
			_g_free0 (_data_->filename);
			_data_->filename = _data_->_tmp3_;
		} else {
			_data_->_tmp4_ = g_strdup ("image/jpeg");
			_g_free0 (_data_->mime_type);
			_data_->mime_type = _data_->_tmp4_;
			_data_->_tmp5_ = g_strdup ("scan.jpg");
			_g_free0 (_data_->filename);
			_data_->filename = _data_->_tmp5_;
		}
		_data_->_tmp6_ = _data_->dir;
		_data_->_tmp7_ = _data_->filename;
		_data_->_tmp8_ = g_build_filename (_data_->_tmp6_, _data_->_tmp7_, NULL);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = g_file_new_for_path (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_g_free0 (_data_->_tmp9_);
		_data_->file = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->self->priv->_book;
		_data_->_tmp13_ = _data_->mime_type;
		_data_->_tmp14_ = _data_->self->priv->settings;
		_data_->_tmp15_ = _data_->file;
		_data_->_tmp16_ = _data_->self->priv->settings;
		_data_->_tmp17_ = _data_->self->priv->settings;
		_data_->_tmp18_ = g_settings_get_string (_data_->_tmp17_, "postproc-script");
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = _data_->self->priv->settings;
		_data_->_tmp21_ = g_settings_get_string (_data_->_tmp20_, "postproc-arguments");
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = _data_->self->priv->settings;
		_data_->_state_ = 1;
		book_save_async (_data_->_tmp12_, _data_->_tmp13_, g_settings_get_int (_data_->_tmp14_, "jpeg-quality"), _data_->_tmp15_, g_settings_get_boolean (_data_->_tmp16_, "postproc-enabled"), _data_->_tmp19_, _data_->_tmp22_, g_settings_get_boolean (_data_->_tmp23_, "postproc-keep-original"), NULL, NULL, NULL, app_window_email_document_async_ready, _data_);
		return FALSE;
		_state_1:
		book_save_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp22_);
		_g_free0 (_data_->_tmp19_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			_g_free0 (_data_->mime_type);
			_g_free0 (_data_->dir);
			goto __catch0_g_error;
		}
		_data_->_tmp24_ = g_strdup ("xdg-email");
		_data_->command_line = _data_->_tmp24_;
		_data_->_tmp25_ = _data_->mime_type;
		if (g_strcmp0 (_data_->_tmp25_, "application/pdf") == 0) {
			_data_->_tmp26_ = _data_->command_line;
			_data_->_tmp27_ = _data_->file;
			_data_->_tmp28_ = g_file_get_path (_data_->_tmp27_);
			_data_->_tmp29_ = _data_->_tmp28_;
			_data_->_tmp30_ = g_strdup_printf (" --attach %s", _data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_data_->_tmp32_ = g_strconcat (_data_->_tmp26_, _data_->_tmp31_, NULL);
			_g_free0 (_data_->command_line);
			_data_->command_line = _data_->_tmp32_;
			_g_free0 (_data_->_tmp31_);
			_g_free0 (_data_->_tmp29_);
		} else {
			{
				_data_->i = 0;
				{
					_data_->_tmp33_ = TRUE;
					while (TRUE) {
						if (!_data_->_tmp33_) {
							_data_->_tmp34_ = _data_->i;
							_data_->i = _data_->_tmp34_ + 1;
						}
						_data_->_tmp33_ = FALSE;
						_data_->_tmp35_ = _data_->self->priv->_book;
						_data_->_tmp36_ = book_get_n_pages (_data_->_tmp35_);
						_data_->_tmp37_ = _data_->_tmp36_;
						if (!(((guint) _data_->i) < _data_->_tmp37_)) {
							break;
						}
						_data_->_tmp38_ = _data_->file;
						_data_->_tmp39_ = g_file_get_uri (_data_->_tmp38_);
						_data_->_tmp40_ = _data_->_tmp39_;
						_data_->_tmp41_ = _data_->self->priv->_book;
						_data_->_tmp42_ = book_get_n_pages (_data_->_tmp41_);
						_data_->_tmp43_ = _data_->_tmp42_;
						_data_->_tmp44_ = make_indexed_file (_data_->_tmp40_, (guint) _data_->i, _data_->_tmp43_);
						_data_->_tmp45_ = _data_->_tmp44_;
						_g_free0 (_data_->_tmp40_);
						_data_->indexed_file = _data_->_tmp45_;
						_data_->_tmp46_ = _data_->command_line;
						_data_->_tmp47_ = _data_->indexed_file;
						_data_->_tmp48_ = g_file_get_path (_data_->_tmp47_);
						_data_->_tmp49_ = _data_->_tmp48_;
						_data_->_tmp50_ = g_strdup_printf (" --attach %s", _data_->_tmp49_);
						_data_->_tmp51_ = _data_->_tmp50_;
						_data_->_tmp52_ = g_strconcat (_data_->_tmp46_, _data_->_tmp51_, NULL);
						_g_free0 (_data_->command_line);
						_data_->command_line = _data_->_tmp52_;
						_g_free0 (_data_->_tmp51_);
						_g_free0 (_data_->_tmp49_);
						_g_object_unref0 (_data_->indexed_file);
					}
				}
			}
		}
		_data_->_tmp53_ = _data_->command_line;
		g_spawn_command_line_async (_data_->_tmp53_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->command_line);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			_g_free0 (_data_->mime_type);
			_g_free0 (_data_->dir);
			goto __catch0_g_error;
		}
		_g_free0 (_data_->command_line);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->filename);
		_g_free0 (_data_->mime_type);
		_g_free0 (_data_->dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp54_ = _data_->e;
		_data_->_tmp55_ = _data_->_tmp54_->message;
		g_warning ("app-window.vala:1497: Unable to email document: %s", _data_->_tmp55_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_app_window_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender,
                                                     GtkPrintContext* context,
                                                     gint page_nr,
                                                     gpointer self)
{
	app_window_draw_page ((AppWindow*) self, _sender, context, page_nr);
}

static void
app_window_print_document (AppWindow* self)
{
	GtkPrintOperation* print = NULL;
	GtkPrintOperation* _tmp0_;
	Book* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_print_operation_new ();
	print = _tmp0_;
	_tmp1_ = self->priv->_book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	_tmp3_ = _tmp2_;
	g_object_set (print, "n-pages", (gint) _tmp3_, NULL);
	g_signal_connect_object (print, "draw-page", (GCallback) _app_window_draw_page_gtk_print_operation_draw_page, self, 0);
	{
		gtk_print_operation_run (print, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, (GtkWindow*) self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("app-window.vala:1513: Error printing: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (print);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_signal_parse_name ("draw-page", gtk_print_operation_get_type (), &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (print, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _app_window_draw_page_gtk_print_operation_draw_page, self);
	_g_object_unref0 (print);
}

static void
app_window_print_document_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_print_document (self);
}

static void
app_window_launch_help (AppWindow* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GdkScreen* _tmp0_;
		GdkScreen* _tmp1_;
		_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp1_ = _tmp0_;
		gtk_show_uri (_tmp1_, "help:simple-scan", gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		app_window_show_error_dialog (self, _ ("Unable to open help file"), _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
app_window_help_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_launch_help (self);
}

static void
app_window_show_about (AppWindow* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint authors_length1;
	gint _authors_size_;
	gchar* title = NULL;
	gchar* _tmp2_;
	gchar* description = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Robert Ancell <robert.ancell@canonical.com>");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	authors = _tmp1_;
	authors_length1 = 1;
	_authors_size_ = authors_length1;
	_tmp2_ = g_strdup (_ ("About Document Scanner"));
	title = _tmp2_;
	_tmp3_ = g_strdup (_ ("Simple document scanning tool"));
	description = _tmp3_;
	gtk_show_about_dialog ((GtkWindow*) self, "title", title, "authors", authors, "translator-credits", _ ("translator-credits"), "comments", description, "copyright", "Copyright © 2009-2018 Canonical Ltd.", "license-type", GTK_LICENSE_GPL_3_0, "program-name", _ ("Document Scanner"), "logo-icon-name", "org.gnome.SimpleScan", "version", VERSION, "website", "https://gitlab.gnome.org/GNOME/simple-scan", "wrap-license", TRUE, NULL);
	_g_free0 (description);
	_g_free0 (title);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static void
app_window_about_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_show_about (self);
}

static void
__lambda37_ (AppWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	AutosaveManager* _tmp0_;
	g_return_if_fail (res != NULL);
	if (!app_window_prompt_to_save_finish (self, res)) {
		return;
	}
	gtk_widget_destroy ((GtkWidget*) self);
	if (self->priv->save_state_timeout != ((guint) 0)) {
		app_window_save_state (self, TRUE);
	}
	_tmp0_ = self->priv->autosave_manager;
	autosave_manager_cleanup (_tmp0_);
}

static void
___lambda37__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda37_ ((AppWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
app_window_on_quit (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_prompt_to_save_async (self, _ ("Save document before quitting?"), _ ("_Quit without Saving"), ___lambda37__gasync_ready_callback, g_object_ref (self));
}

static void
app_window_quit_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_on_quit (self);
}

static void
app_window_real_size_allocate (GtkWidget* base,
                               GtkAllocation* allocation)
{
	AppWindow * self;
	GtkAllocation _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (AppWindow*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (app_window_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), &_tmp0_);
	if (!self->priv->window_is_maximized) {
		_tmp1_ = !self->priv->window_is_fullscreen;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
		self->priv->window_width = _tmp2_;
		self->priv->window_height = _tmp3_;
		app_window_save_state (self, FALSE);
	}
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
app_window_install_drivers (AppWindow* self)
{
	gchar* message = NULL;
	gchar* _tmp0_;
	gchar* instructions = NULL;
	gchar* _tmp1_;
	gchar** packages_to_install = NULL;
	gchar** _tmp2_;
	gint packages_to_install_length1;
	gint _packages_to_install_size_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	static GQuark _tmp5_label3 = 0;
	static GQuark _tmp5_label4 = 0;
	static GQuark _tmp5_label5 = 0;
	static GQuark _tmp5_label6 = 0;
	static GQuark _tmp5_label7 = 0;
	static GQuark _tmp5_label8 = 0;
	static GQuark _tmp5_label9 = 0;
	GtkDialog* dialog = NULL;
	GtkDialog* _tmp22_;
	GtkDialog* _tmp23_;
	GtkBox* _tmp24_;
	GtkDialog* _tmp25_;
	GtkBox* _tmp26_;
	GtkLabel* label = NULL;
	const gchar* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	GtkDialog* _tmp33_;
	GtkBox* _tmp34_;
	GtkLabel* _tmp35_;
	GtkBox* instructions_box = NULL;
	GtkBox* _tmp36_;
	GtkBox* _tmp37_;
	GtkBox* _tmp38_;
	GtkDialog* _tmp39_;
	GtkBox* _tmp40_;
	GtkBox* _tmp41_;
	GtkStack* stack = NULL;
	GtkStack* _tmp42_;
	GtkBox* _tmp43_;
	GtkStack* _tmp44_;
	GtkSpinner* spinner = NULL;
	GtkSpinner* _tmp45_;
	GtkSpinner* _tmp46_;
	GtkStack* _tmp47_;
	GtkSpinner* _tmp48_;
	GtkLabel* status_label = NULL;
	GtkLabel* _tmp49_;
	GtkLabel* _tmp50_;
	GtkStack* _tmp51_;
	GtkLabel* _tmp52_;
	GtkLabel* instructions_label = NULL;
	const gchar* _tmp53_;
	GtkLabel* _tmp54_;
	GtkLabel* _tmp55_;
	GtkLabel* _tmp56_;
	GtkLabel* _tmp57_;
	GtkBox* _tmp58_;
	GtkLabel* _tmp59_;
	GtkLabel* _tmp60_;
	GtkLabel* _tmp61_;
	GtkLabel* _tmp62_;
	GtkLabel* _tmp63_;
	GtkDialog* _tmp64_;
	GtkBox* _tmp65_;
	GtkDialog* _tmp66_;
	GtkBox* _tmp67_;
	GtkLabel* _tmp68_;
	gchar** _tmp69_;
	gint _tmp69__length1;
	GtkDialog* _tmp77_;
	GtkDialog* _tmp78_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	message = _tmp0_;
	_tmp1_ = g_strdup ("");
	instructions = _tmp1_;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	packages_to_install = _tmp2_;
	packages_to_install_length1 = 0;
	_packages_to_install_size_ = packages_to_install_length1;
	_tmp3_ = self->priv->missing_driver;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if ((((_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("brscan")))) || (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("brscan2"))))) || (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("brscan3"))))) || (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("brscan4"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_strdup (_ ("You appear to have a Brother scanner."));
				_g_free0 (message);
				message = _tmp7_;
				_tmp8_ = g_strdup (_ ("Drivers for this are available on the <a href=\"http://support.brother" \
".com\">Brother website</a>."));
				_g_free0 (instructions);
				instructions = _tmp8_;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("pixma")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = g_strdup (_ ("You appear to have a Canon scanner, which is supported by the <a href=" \
"\"http://www.sane-project.org/man/sane-pixma.5.html\">Pixma SANE backe" \
"nd</a>."));
				_g_free0 (message);
				message = _tmp9_;
				_tmp10_ = g_strdup (_ ("Please check if your <a href=\"http://www.sane-project.org/sane-suppor" \
"ted-devices.html\">scanner is supported by SANE</a>, otherwise report " \
"the issue to the <a href=\"https://alioth-lists.debian.net/cgi-bin/mai" \
"lman/listinfo/sane-devel\">SANE mailing list</a>."));
				_g_free0 (instructions);
				instructions = _tmp10_;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("samsung")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = g_strdup (_ ("You appear to have a Samsung scanner."));
				_g_free0 (message);
				message = _tmp11_;
				_tmp12_ = g_strdup (_ ("Drivers for this are available on the <a href=\"https://support.hp.com" \
"\">HP website</a> (HP acquired Samsung's printing business)."));
				_g_free0 (instructions);
				instructions = _tmp12_;
				break;
			}
		}
	} else if ((_tmp6_ == ((0 != _tmp5_label6) ? _tmp5_label6 : (_tmp5_label6 = g_quark_from_static_string ("hpaio")))) || (_tmp6_ == ((0 != _tmp5_label7) ? _tmp5_label7 : (_tmp5_label7 = g_quark_from_static_string ("smfp"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = g_strdup (_ ("You appear to have an HP scanner."));
				_g_free0 (message);
				message = _tmp13_;
				_tmp14_ = self->priv->missing_driver;
				if (g_strcmp0 (_tmp14_, "hpaio") == 0) {
					gchar* _tmp15_;
					gchar** _tmp16_;
					_tmp15_ = g_strdup ("libsane-hpaio");
					_tmp16_ = g_new0 (gchar*, 1 + 1);
					_tmp16_[0] = _tmp15_;
					packages_to_install = (_vala_array_free (packages_to_install, packages_to_install_length1, (GDestroyNotify) g_free), NULL);
					packages_to_install = _tmp16_;
					packages_to_install_length1 = 1;
					_packages_to_install_size_ = packages_to_install_length1;
				} else {
					gchar* _tmp17_;
					_tmp17_ = g_strdup (_ ("Drivers for this are available on the <a href=\"https://support.hp.com" \
"\">HP website</a>."));
					_g_free0 (instructions);
					instructions = _tmp17_;
				}
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label8) ? _tmp5_label8 : (_tmp5_label8 = g_quark_from_static_string ("epkowa")))) {
		switch (0) {
			default:
			{
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp18_ = g_strdup (_ ("You appear to have an Epson scanner."));
				_g_free0 (message);
				message = _tmp18_;
				_tmp19_ = g_strdup (_ ("Drivers for this are available on the <a href=\"http://support.epson.c" \
"om\">Epson website</a>."));
				_g_free0 (instructions);
				instructions = _tmp19_;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label9) ? _tmp5_label9 : (_tmp5_label9 = g_quark_from_static_string ("lexmark_nscan")))) {
		switch (0) {
			default:
			{
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp20_ = g_strdup (_ ("You appear to have an Lexmark scanner."));
				_g_free0 (message);
				message = _tmp20_;
				_tmp21_ = g_strdup (_ ("Drivers for this are available on the <a href=\"http://support.lexmark" \
".com\">Lexmark website</a>."));
				_g_free0 (instructions);
				instructions = _tmp21_;
				break;
			}
		}
	}
	_tmp22_ = (GtkDialog*) gtk_dialog_new_with_buttons (_ ("Install drivers"), (GtkWindow*) self, GTK_DIALOG_MODAL, _ ("_Close"), GTK_RESPONSE_CLOSE, NULL);
	g_object_ref_sink (_tmp22_);
	dialog = _tmp22_;
	_tmp23_ = dialog;
	_tmp24_ = gtk_dialog_get_content_area (_tmp23_);
	gtk_container_set_border_width ((GtkContainer*) _tmp24_, (guint) 12);
	_tmp25_ = dialog;
	_tmp26_ = gtk_dialog_get_content_area (_tmp25_);
	gtk_box_set_spacing (_tmp26_, 6);
	_tmp27_ = message;
	_tmp28_ = (GtkLabel*) gtk_label_new (_tmp27_);
	g_object_ref_sink (_tmp28_);
	label = _tmp28_;
	_tmp29_ = label;
	gtk_widget_set_visible ((GtkWidget*) _tmp29_, TRUE);
	_tmp30_ = label;
	gtk_label_set_xalign (_tmp30_, 0.f);
	_tmp31_ = label;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp31_, TRUE);
	_tmp32_ = label;
	gtk_label_set_use_markup (_tmp32_, TRUE);
	_tmp33_ = dialog;
	_tmp34_ = gtk_dialog_get_content_area (_tmp33_);
	_tmp35_ = label;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp36_);
	instructions_box = _tmp36_;
	_tmp37_ = instructions_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp37_, TRUE);
	_tmp38_ = instructions_box;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp38_, TRUE);
	_tmp39_ = dialog;
	_tmp40_ = gtk_dialog_get_content_area (_tmp39_);
	_tmp41_ = instructions_box;
	gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp42_);
	stack = _tmp42_;
	_tmp43_ = instructions_box;
	_tmp44_ = stack;
	gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp45_);
	spinner = _tmp45_;
	_tmp46_ = spinner;
	gtk_widget_set_visible ((GtkWidget*) _tmp46_, TRUE);
	_tmp47_ = stack;
	_tmp48_ = spinner;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp49_);
	status_label = _tmp49_;
	_tmp50_ = status_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp50_, TRUE);
	_tmp51_ = stack;
	_tmp52_ = status_label;
	gtk_container_add ((GtkContainer*) _tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = instructions;
	_tmp54_ = (GtkLabel*) gtk_label_new (_tmp53_);
	g_object_ref_sink (_tmp54_);
	instructions_label = _tmp54_;
	_tmp55_ = instructions_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp55_, TRUE);
	_tmp56_ = instructions_label;
	gtk_label_set_xalign (_tmp56_, 0.f);
	_tmp57_ = instructions_label;
	gtk_label_set_use_markup (_tmp57_, TRUE);
	_tmp58_ = instructions_box;
	_tmp59_ = instructions_label;
	gtk_container_add ((GtkContainer*) _tmp58_, (GtkWidget*) _tmp59_);
	_tmp60_ = (GtkLabel*) gtk_label_new (_ ("Once installed you will need to restart this app."));
	g_object_ref_sink (_tmp60_);
	_g_object_unref0 (label);
	label = _tmp60_;
	_tmp61_ = label;
	gtk_widget_set_visible ((GtkWidget*) _tmp61_, TRUE);
	_tmp62_ = label;
	gtk_label_set_xalign (_tmp62_, 0.f);
	_tmp63_ = label;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp63_, TRUE);
	_tmp64_ = dialog;
	_tmp65_ = gtk_dialog_get_content_area (_tmp64_);
	gtk_container_set_border_width ((GtkContainer*) _tmp65_, (guint) 12);
	_tmp66_ = dialog;
	_tmp67_ = gtk_dialog_get_content_area (_tmp66_);
	_tmp68_ = label;
	gtk_container_add ((GtkContainer*) _tmp67_, (GtkWidget*) _tmp68_);
	_tmp69_ = packages_to_install;
	_tmp69__length1 = packages_to_install_length1;
	if (_tmp69__length1 > 0) {
		GtkLabel* _tmp70_;
		gchar** _tmp71_;
		gint _tmp71__length1;
		gchar** _tmp72_;
		gint _tmp72__length1;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		_tmp70_ = instructions_label;
		_tmp71_ = packages_to_install;
		_tmp71__length1 = packages_to_install_length1;
		_tmp72_ = packages_to_install;
		_tmp72__length1 = packages_to_install_length1;
		_tmp73_ = _vala_g_strjoinv (", ", _tmp72_, (gint) _tmp72__length1);
		_tmp74_ = _tmp73_;
		_tmp75_ = g_strdup_printf (ngettext ("You need to install the %s package.", "You need to install the %s packages.", (gulong) _tmp71__length1), _tmp74_);
		_tmp76_ = _tmp75_;
		gtk_label_set_text (_tmp70_, _tmp76_);
		_g_free0 (_tmp76_);
		_g_free0 (_tmp74_);
	}
	_tmp77_ = dialog;
	gtk_dialog_run (_tmp77_);
	_tmp78_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp78_);
	_g_object_unref0 (instructions_label);
	_g_object_unref0 (status_label);
	_g_object_unref0 (spinner);
	_g_object_unref0 (stack);
	_g_object_unref0 (instructions_box);
	_g_object_unref0 (label);
	_g_object_unref0 (dialog);
	packages_to_install = (_vala_array_free (packages_to_install, packages_to_install_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (instructions);
	_g_free0 (message);
}

static gboolean
app_window_real_window_state_event (GtkWidget* base,
                                    GdkEventWindowState* event)
{
	AppWindow * self;
	gboolean _result_ = FALSE;
	gboolean result;
	self = (AppWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_result_ = GDK_EVENT_PROPAGATE;
	if (GTK_WIDGET_CLASS (app_window_parent_class)->window_state_event != NULL) {
		_result_ = GTK_WIDGET_CLASS (app_window_parent_class)->window_state_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), event);
	}
	if ((event->changed_mask & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		self->priv->window_is_maximized = (event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED) != 0;
		app_window_save_state (self, FALSE);
	}
	if ((event->changed_mask & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		self->priv->window_is_fullscreen = (event->new_window_state & GDK_WINDOW_STATE_FULLSCREEN) != 0;
		app_window_save_state (self, FALSE);
	}
	result = _result_;
	return result;
}

static gboolean
app_window_window_delete_event_cb (AppWindow* self,
                                   GtkWidget* widget,
                                   GdkEventAny* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	app_window_on_quit (self);
	result = TRUE;
	return result;
}

static gboolean
_app_window_window_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender,
                                                            GdkEventAny* event,
                                                            gpointer self)
{
	gboolean result;
	result = app_window_window_delete_event_cb ((AppWindow*) self, _sender, event);
	return result;
}

static void
app_window_page_added_cb (AppWindow* self,
                          Book* book,
                          Page* page)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	app_window_update_page_menu (self);
}

static void
app_window_reordered_cb (AppWindow* self,
                         Book* book)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	app_window_update_page_menu (self);
}

static void
app_window_page_removed_cb (AppWindow* self,
                            Book* book,
                            Page* page)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	app_window_update_page_menu (self);
}

static void
app_window_book_changed_cb (AppWindow* self,
                            Book* book)
{
	GtkButton* _tmp0_;
	GtkMenuItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	_tmp0_ = self->priv->save_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	self->priv->book_needs_saving = TRUE;
	_tmp1_ = self->priv->copy_to_clipboard_menuitem;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
}

static gboolean
__lambda39_ (AppWindow* self)
{
	PreferencesDialog* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->preferences_dialog;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
	result = TRUE;
	return result;
}

static gboolean
___lambda39__gtk_widget_delete_event (GtkWidget* _sender,
                                      GdkEventAny* event,
                                      gpointer self)
{
	gboolean result;
	result = __lambda39_ ((AppWindow*) self);
	return result;
}

static void
_app_window_new_document_cb_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	app_window_new_document_cb ((AppWindow*) self);
}

static void
_app_window_rotate_left_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	app_window_rotate_left_button_clicked_cb ((AppWindow*) self);
}

static void
_app_window_rotate_right_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	app_window_rotate_right_button_clicked_cb ((AppWindow*) self);
}

static void
__lambda40_ (AppWindow* self,
             GtkToggleButton* widget)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (widget != NULL);
	if (self->priv->updating_page_menu) {
		return;
	}
	_tmp0_ = gtk_toggle_button_get_active (widget);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkRadioMenuItem* _tmp2_;
		_tmp2_ = self->priv->custom_crop_menuitem;
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp2_, TRUE);
	} else {
		GtkRadioMenuItem* _tmp3_;
		_tmp3_ = self->priv->no_crop_menuitem;
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp3_, TRUE);
	}
}

static void
___lambda40__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda40_ ((AppWindow*) self, _sender);
}

static void
__lambda41_ (AppWindow* self)
{
	BookView* _tmp0_;
	Book* _tmp1_;
	Book* _tmp2_;
	BookView* _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_book (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->book_view;
	_tmp4_ = book_view_get_selected_page (_tmp3_);
	_tmp5_ = _tmp4_;
	book_delete_page (_tmp2_, _tmp5_);
}

static void
___lambda41__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda41_ ((AppWindow*) self);
}

static void
_app_window_page_selected_cb_book_view_page_selected (BookView* _sender,
                                                      Page* page,
                                                      gpointer self)
{
	app_window_page_selected_cb ((AppWindow*) self, _sender, page);
}

static void
_app_window_show_page_cb_book_view_show_page (BookView* _sender,
                                              Page* page,
                                              gpointer self)
{
	app_window_show_page_cb ((AppWindow*) self, _sender, page);
}

static void
_app_window_show_page_menu_cb_book_view_show_menu (BookView* _sender,
                                                   GdkEvent* event,
                                                   gpointer self)
{
	app_window_show_page_menu_cb ((AppWindow*) self, _sender, event);
}

static void
app_window_load (AppWindow* self)
{
	GSettings* _tmp0_;
	PreferencesDialog* _tmp1_;
	PreferencesDialog* _tmp2_;
	PreferencesDialog* _tmp3_;
	PreferencesDialog* _tmp4_;
	GtkApplication* app = NULL;
	GApplication* _tmp5_;
	GtkApplication* _tmp6_;
	HdyHeaderBar* _tmp7_;
	GtkApplication* _tmp8_;
	GtkApplication* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GtkApplication* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GtkApplication* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	GtkApplication* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	GtkApplication* _tmp25_;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	GtkApplication* _tmp29_;
	gchar* _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	GtkApplication* _tmp33_;
	gchar* _tmp34_;
	gchar** _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	GtkApplication* _tmp37_;
	gchar* _tmp38_;
	gchar** _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	GtkApplication* _tmp41_;
	gchar* _tmp42_;
	gchar** _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	GtkApplication* _tmp45_;
	gchar* _tmp46_;
	gchar** _tmp47_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	GtkApplication* _tmp49_;
	gchar* _tmp50_;
	gchar** _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	GtkApplication* _tmp53_;
	gchar* _tmp54_;
	gchar** _tmp55_;
	gchar** _tmp56_;
	gint _tmp56__length1;
	GtkApplication* _tmp57_;
	gchar* _tmp58_;
	gchar** _tmp59_;
	gchar** _tmp60_;
	gint _tmp60__length1;
	GtkApplication* _tmp61_;
	gchar* _tmp62_;
	gchar** _tmp63_;
	gchar** _tmp64_;
	gint _tmp64__length1;
	GtkApplication* _tmp65_;
	gchar* _tmp66_;
	gchar** _tmp67_;
	gchar** _tmp68_;
	gint _tmp68__length1;
	GtkApplication* _tmp69_;
	gchar* _tmp70_;
	gchar** _tmp71_;
	gchar** _tmp72_;
	gint _tmp72__length1;
	GtkApplication* _tmp73_;
	gchar* _tmp74_;
	gchar** _tmp75_;
	gchar** _tmp76_;
	gint _tmp76__length1;
	GMenu* gear_menu = NULL;
	GMenu* _tmp77_;
	GMenu* section = NULL;
	GMenu* _tmp78_;
	GMenu* _tmp79_;
	GMenu* _tmp80_;
	GMenu* _tmp81_;
	GMenu* _tmp82_;
	GMenu* _tmp83_;
	GMenu* _tmp84_;
	GMenu* _tmp85_;
	GMenu* _tmp86_;
	GMenu* _tmp87_;
	GMenu* _tmp88_;
	GMenu* _tmp89_;
	GMenu* _tmp90_;
	GtkMenuButton* _tmp91_;
	GMenu* _tmp92_;
	GtkApplication* _tmp93_;
	GtkButton* button = NULL;
	GtkButton* _tmp94_;
	GtkButton* _tmp95_;
	GtkButton* _tmp96_;
	GtkActionBar* _tmp97_;
	GtkButton* _tmp98_;
	GtkBox* box = NULL;
	GtkBox* _tmp99_;
	GtkBox* _tmp100_;
	GtkActionBar* _tmp101_;
	GtkBox* _tmp102_;
	GtkBox* rotate_box = NULL;
	GtkBox* _tmp103_;
	GtkBox* _tmp104_;
	GtkStyleContext* _tmp105_;
	GtkBox* _tmp106_;
	GtkBox* _tmp107_;
	GtkBox* _tmp108_;
	GtkButton* _tmp109_;
	GtkButton* _tmp110_;
	GtkButton* _tmp111_;
	GtkWidget* _tmp112_;
	GtkWidget* _tmp113_;
	GtkButton* _tmp114_;
	GtkWidget* _tmp115_;
	GtkWidget* _tmp116_;
	GtkButton* _tmp117_;
	GtkButton* _tmp118_;
	GtkBox* _tmp119_;
	GtkButton* _tmp120_;
	GtkButton* _tmp121_;
	GtkButton* _tmp122_;
	GtkButton* _tmp123_;
	GtkWidget* _tmp124_;
	GtkWidget* _tmp125_;
	GtkButton* _tmp126_;
	GtkWidget* _tmp127_;
	GtkWidget* _tmp128_;
	GtkButton* _tmp129_;
	GtkButton* _tmp130_;
	GtkBox* _tmp131_;
	GtkButton* _tmp132_;
	GtkToggleButton* _tmp133_;
	GtkToggleButton* _tmp134_;
	GtkImage* image = NULL;
	GtkImage* _tmp135_;
	GtkImage* _tmp136_;
	GtkImage* _tmp137_;
	GtkImage* _tmp138_;
	GtkToggleButton* _tmp139_;
	GtkImage* _tmp140_;
	GtkToggleButton* _tmp141_;
	GtkToggleButton* _tmp142_;
	GtkBox* _tmp143_;
	GtkToggleButton* _tmp144_;
	GtkButton* _tmp145_;
	GtkButton* _tmp146_;
	GtkButton* _tmp147_;
	GtkWidget* _tmp148_;
	GtkWidget* _tmp149_;
	GtkButton* _tmp150_;
	GtkWidget* _tmp151_;
	GtkWidget* _tmp152_;
	GtkButton* _tmp153_;
	GtkButton* _tmp154_;
	GtkBox* _tmp155_;
	GtkButton* _tmp156_;
	gchar* document_type = NULL;
	GSettings* _tmp157_;
	gchar* _tmp158_;
	const gchar* _tmp159_;
	Book* _tmp161_;
	BookView* _tmp162_;
	BookView* _tmp163_;
	BookView* _tmp164_;
	GtkBox* _tmp165_;
	BookView* _tmp166_;
	BookView* _tmp167_;
	BookView* _tmp168_;
	BookView* _tmp169_;
	BookView* _tmp170_;
	PreferencesDialog* _tmp171_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = preferences_dialog_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp1_;
	_tmp2_ = self->priv->preferences_dialog;
	g_signal_connect_object ((GtkWidget*) _tmp2_, "delete-event", (GCallback) ___lambda39__gtk_widget_delete_event, self, 0);
	_tmp3_ = self->priv->preferences_dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, (GtkWindow*) self);
	_tmp4_ = self->priv->preferences_dialog;
	gtk_window_set_modal ((GtkWindow*) _tmp4_, TRUE);
	gtk_window_set_default_icon_name ("org.gnome.SimpleScan");
	_tmp5_ = g_application_get_default ();
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_application_get_type ()) ? ((GtkApplication*) _tmp5_) : NULL);
	app = _tmp6_;
	_tmp7_ = self->priv->header_bar;
	hdy_header_bar_set_title (_tmp7_, _ ("Document Scanner"));
	_tmp8_ = app;
	g_action_map_add_action_entries ((GActionMap*) _tmp8_, APP_WINDOW_action_entries, (gint) G_N_ELEMENTS (APP_WINDOW_action_entries), self);
	_tmp9_ = app;
	_tmp10_ = g_strdup ("<Ctrl>N");
	_tmp11_ = g_new0 (gchar*, 1 + 1);
	_tmp11_[0] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	gtk_application_set_accels_for_action (_tmp9_, "app.new_document", _tmp12_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = app;
	_tmp14_ = g_strdup ("<Ctrl>1");
	_tmp15_ = g_new0 (gchar*, 1 + 1);
	_tmp15_[0] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 1;
	gtk_application_set_accels_for_action (_tmp13_, "app.scan_single", _tmp16_);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	_tmp17_ = app;
	_tmp18_ = g_strdup ("<Ctrl>F");
	_tmp19_ = g_new0 (gchar*, 1 + 1);
	_tmp19_[0] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 1;
	gtk_application_set_accels_for_action (_tmp17_, "app.scan_adf", _tmp20_);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	_tmp21_ = app;
	_tmp22_ = g_strdup ("<Ctrl>M");
	_tmp23_ = g_new0 (gchar*, 1 + 1);
	_tmp23_[0] = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 1;
	gtk_application_set_accels_for_action (_tmp21_, "app.scan_batch", _tmp24_);
	_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
	_tmp25_ = app;
	_tmp26_ = g_strdup ("Escape");
	_tmp27_ = g_new0 (gchar*, 1 + 1);
	_tmp27_[0] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	gtk_application_set_accels_for_action (_tmp25_, "app.scan_stop", _tmp28_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = app;
	_tmp30_ = g_strdup ("bracketleft");
	_tmp31_ = g_new0 (gchar*, 1 + 1);
	_tmp31_[0] = _tmp30_;
	_tmp32_ = _tmp31_;
	_tmp32__length1 = 1;
	gtk_application_set_accels_for_action (_tmp29_, "app.rotate_left", _tmp32_);
	_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
	_tmp33_ = app;
	_tmp34_ = g_strdup ("bracketright");
	_tmp35_ = g_new0 (gchar*, 1 + 1);
	_tmp35_[0] = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp36__length1 = 1;
	gtk_application_set_accels_for_action (_tmp33_, "app.rotate_right", _tmp36_);
	_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
	_tmp37_ = app;
	_tmp38_ = g_strdup ("less");
	_tmp39_ = g_new0 (gchar*, 1 + 1);
	_tmp39_[0] = _tmp38_;
	_tmp40_ = _tmp39_;
	_tmp40__length1 = 1;
	gtk_application_set_accels_for_action (_tmp37_, "app.move_left", _tmp40_);
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
	_tmp41_ = app;
	_tmp42_ = g_strdup ("greater");
	_tmp43_ = g_new0 (gchar*, 1 + 1);
	_tmp43_[0] = _tmp42_;
	_tmp44_ = _tmp43_;
	_tmp44__length1 = 1;
	gtk_application_set_accels_for_action (_tmp41_, "app.move_right", _tmp44_);
	_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
	_tmp45_ = app;
	_tmp46_ = g_strdup ("<Ctrl>C");
	_tmp47_ = g_new0 (gchar*, 1 + 1);
	_tmp47_[0] = _tmp46_;
	_tmp48_ = _tmp47_;
	_tmp48__length1 = 1;
	gtk_application_set_accels_for_action (_tmp45_, "app.copy_page", _tmp48_);
	_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
	_tmp49_ = app;
	_tmp50_ = g_strdup ("Delete");
	_tmp51_ = g_new0 (gchar*, 1 + 1);
	_tmp51_[0] = _tmp50_;
	_tmp52_ = _tmp51_;
	_tmp52__length1 = 1;
	gtk_application_set_accels_for_action (_tmp49_, "app.delete_page", _tmp52_);
	_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
	_tmp53_ = app;
	_tmp54_ = g_strdup ("<Ctrl>S");
	_tmp55_ = g_new0 (gchar*, 1 + 1);
	_tmp55_[0] = _tmp54_;
	_tmp56_ = _tmp55_;
	_tmp56__length1 = 1;
	gtk_application_set_accels_for_action (_tmp53_, "app.save", _tmp56_);
	_tmp56_ = (_vala_array_free (_tmp56_, _tmp56__length1, (GDestroyNotify) g_free), NULL);
	_tmp57_ = app;
	_tmp58_ = g_strdup ("<Ctrl>E");
	_tmp59_ = g_new0 (gchar*, 1 + 1);
	_tmp59_[0] = _tmp58_;
	_tmp60_ = _tmp59_;
	_tmp60__length1 = 1;
	gtk_application_set_accels_for_action (_tmp57_, "app.email", _tmp60_);
	_tmp60_ = (_vala_array_free (_tmp60_, _tmp60__length1, (GDestroyNotify) g_free), NULL);
	_tmp61_ = app;
	_tmp62_ = g_strdup ("<Ctrl>P");
	_tmp63_ = g_new0 (gchar*, 1 + 1);
	_tmp63_[0] = _tmp62_;
	_tmp64_ = _tmp63_;
	_tmp64__length1 = 1;
	gtk_application_set_accels_for_action (_tmp61_, "app.print", _tmp64_);
	_tmp64_ = (_vala_array_free (_tmp64_, _tmp64__length1, (GDestroyNotify) g_free), NULL);
	_tmp65_ = app;
	_tmp66_ = g_strdup ("F1");
	_tmp67_ = g_new0 (gchar*, 1 + 1);
	_tmp67_[0] = _tmp66_;
	_tmp68_ = _tmp67_;
	_tmp68__length1 = 1;
	gtk_application_set_accels_for_action (_tmp65_, "app.help", _tmp68_);
	_tmp68_ = (_vala_array_free (_tmp68_, _tmp68__length1, (GDestroyNotify) g_free), NULL);
	_tmp69_ = app;
	_tmp70_ = g_strdup ("<Ctrl>Q");
	_tmp71_ = g_new0 (gchar*, 1 + 1);
	_tmp71_[0] = _tmp70_;
	_tmp72_ = _tmp71_;
	_tmp72__length1 = 1;
	gtk_application_set_accels_for_action (_tmp69_, "app.quit", _tmp72_);
	_tmp72_ = (_vala_array_free (_tmp72_, _tmp72__length1, (GDestroyNotify) g_free), NULL);
	_tmp73_ = app;
	_tmp74_ = g_strdup ("<Ctrl>question");
	_tmp75_ = g_new0 (gchar*, 1 + 1);
	_tmp75_[0] = _tmp74_;
	_tmp76_ = _tmp75_;
	_tmp76__length1 = 1;
	gtk_application_set_accels_for_action (_tmp73_, "win.show-help-overlay", _tmp76_);
	_tmp76_ = (_vala_array_free (_tmp76_, _tmp76__length1, (GDestroyNotify) g_free), NULL);
	_tmp77_ = g_menu_new ();
	gear_menu = _tmp77_;
	_tmp78_ = g_menu_new ();
	section = _tmp78_;
	_tmp79_ = gear_menu;
	_tmp80_ = section;
	g_menu_append_section (_tmp79_, NULL, (GMenuModel*) _tmp80_);
	_tmp81_ = section;
	g_menu_append (_tmp81_, _ ("_Email"), "app.email");
	_tmp82_ = section;
	g_menu_append (_tmp82_, _ ("Pri_nt"), "app.print");
	_tmp83_ = section;
	g_menu_append (_tmp83_, C_ ("menu", "_Reorder Pages"), "app.reorder");
	_tmp84_ = g_menu_new ();
	_g_object_unref0 (section);
	section = _tmp84_;
	_tmp85_ = gear_menu;
	_tmp86_ = section;
	g_menu_append_section (_tmp85_, NULL, (GMenuModel*) _tmp86_);
	_tmp87_ = section;
	g_menu_append (_tmp87_, _ ("_Preferences"), "app.preferences");
	_tmp88_ = section;
	g_menu_append (_tmp88_, _ ("_Keyboard Shortcuts"), "win.show-help-overlay");
	_tmp89_ = section;
	g_menu_append (_tmp89_, _ ("_Help"), "app.help");
	_tmp90_ = section;
	g_menu_append (_tmp90_, _ ("_About Document Scanner"), "app.about");
	_tmp91_ = self->priv->menu_button;
	_tmp92_ = gear_menu;
	gtk_menu_button_set_menu_model (_tmp91_, (GMenuModel*) _tmp92_);
	_tmp93_ = app;
	gtk_application_add_window (_tmp93_, (GtkWindow*) self);
	_tmp94_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_New Document"));
	g_object_ref_sink (_tmp94_);
	button = _tmp94_;
	_tmp95_ = button;
	gtk_widget_set_visible ((GtkWidget*) _tmp95_, TRUE);
	_tmp96_ = button;
	g_signal_connect_object (_tmp96_, "clicked", (GCallback) _app_window_new_document_cb_gtk_button_clicked, self, 0);
	_tmp97_ = self->priv->action_bar;
	_tmp98_ = button;
	gtk_action_bar_pack_start (_tmp97_, (GtkWidget*) _tmp98_);
	_tmp99_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	g_object_ref_sink (_tmp99_);
	box = _tmp99_;
	_tmp100_ = box;
	gtk_widget_set_visible ((GtkWidget*) _tmp100_, TRUE);
	_tmp101_ = self->priv->action_bar;
	_tmp102_ = box;
	gtk_action_bar_set_center_widget (_tmp101_, (GtkWidget*) _tmp102_);
	_tmp103_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp103_);
	rotate_box = _tmp103_;
	_tmp104_ = rotate_box;
	_tmp105_ = gtk_widget_get_style_context ((GtkWidget*) _tmp104_);
	gtk_style_context_add_class (_tmp105_, GTK_STYLE_CLASS_LINKED);
	_tmp106_ = rotate_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp106_, TRUE);
	_tmp107_ = box;
	_tmp108_ = rotate_box;
	gtk_container_add ((GtkContainer*) _tmp107_, (GtkWidget*) _tmp108_);
	_tmp109_ = (GtkButton*) gtk_button_new_from_icon_name ("object-rotate-left-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp109_);
	_g_object_unref0 (button);
	button = _tmp109_;
	_tmp110_ = button;
	gtk_widget_set_visible ((GtkWidget*) _tmp110_, TRUE);
	_tmp111_ = button;
	_tmp112_ = gtk_button_get_image (_tmp111_);
	_tmp113_ = _tmp112_;
	gtk_widget_set_margin_start (_tmp113_, 18);
	_tmp114_ = button;
	_tmp115_ = gtk_button_get_image (_tmp114_);
	_tmp116_ = _tmp115_;
	gtk_widget_set_margin_end (_tmp116_, 18);
	_tmp117_ = button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp117_, _ ("Rotate the page to the left (counter-clockwise)"));
	_tmp118_ = button;
	g_signal_connect_object (_tmp118_, "clicked", (GCallback) _app_window_rotate_left_button_clicked_cb_gtk_button_clicked, self, 0);
	_tmp119_ = rotate_box;
	_tmp120_ = button;
	gtk_container_add ((GtkContainer*) _tmp119_, (GtkWidget*) _tmp120_);
	_tmp121_ = (GtkButton*) gtk_button_new_from_icon_name ("object-rotate-right-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp121_);
	_g_object_unref0 (button);
	button = _tmp121_;
	_tmp122_ = button;
	gtk_widget_set_visible ((GtkWidget*) _tmp122_, TRUE);
	_tmp123_ = button;
	_tmp124_ = gtk_button_get_image (_tmp123_);
	_tmp125_ = _tmp124_;
	gtk_widget_set_margin_start (_tmp125_, 18);
	_tmp126_ = button;
	_tmp127_ = gtk_button_get_image (_tmp126_);
	_tmp128_ = _tmp127_;
	gtk_widget_set_margin_end (_tmp128_, 18);
	_tmp129_ = button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp129_, _ ("Rotate the page to the right (clockwise)"));
	_tmp130_ = button;
	g_signal_connect_object (_tmp130_, "clicked", (GCallback) _app_window_rotate_right_button_clicked_cb_gtk_button_clicked, self, 0);
	_tmp131_ = rotate_box;
	_tmp132_ = button;
	gtk_container_add ((GtkContainer*) _tmp131_, (GtkWidget*) _tmp132_);
	_tmp133_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp133_);
	_g_object_unref0 (self->priv->crop_button);
	self->priv->crop_button = _tmp133_;
	_tmp134_ = self->priv->crop_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp134_, TRUE);
	_tmp135_ = (GtkImage*) gtk_image_new_from_icon_name ("crop-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp135_);
	image = _tmp135_;
	_tmp136_ = image;
	gtk_widget_set_visible ((GtkWidget*) _tmp136_, TRUE);
	_tmp137_ = image;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp137_, 18);
	_tmp138_ = image;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp138_, 18);
	_tmp139_ = self->priv->crop_button;
	_tmp140_ = image;
	gtk_container_add ((GtkContainer*) _tmp139_, (GtkWidget*) _tmp140_);
	_tmp141_ = self->priv->crop_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp141_, _ ("Crop the selected page"));
	_tmp142_ = self->priv->crop_button;
	g_signal_connect_object (_tmp142_, "toggled", (GCallback) ___lambda40__gtk_toggle_button_toggled, self, 0);
	_tmp143_ = box;
	_tmp144_ = self->priv->crop_button;
	gtk_container_add ((GtkContainer*) _tmp143_, (GtkWidget*) _tmp144_);
	_tmp145_ = (GtkButton*) gtk_button_new_from_icon_name ("user-trash-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp145_);
	_g_object_unref0 (self->priv->delete_button);
	self->priv->delete_button = _tmp145_;
	_tmp146_ = self->priv->delete_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp146_, TRUE);
	_tmp147_ = self->priv->delete_button;
	_tmp148_ = gtk_button_get_image (_tmp147_);
	_tmp149_ = _tmp148_;
	gtk_widget_set_margin_start (_tmp149_, 18);
	_tmp150_ = self->priv->delete_button;
	_tmp151_ = gtk_button_get_image (_tmp150_);
	_tmp152_ = _tmp151_;
	gtk_widget_set_margin_end (_tmp152_, 18);
	_tmp153_ = self->priv->delete_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp153_, _ ("Delete the selected page"));
	_tmp154_ = self->priv->delete_button;
	g_signal_connect_object (_tmp154_, "clicked", (GCallback) ___lambda41__gtk_button_clicked, self, 0);
	_tmp155_ = box;
	_tmp156_ = self->priv->delete_button;
	gtk_container_add ((GtkContainer*) _tmp155_, (GtkWidget*) _tmp156_);
	_tmp157_ = self->priv->settings;
	_tmp158_ = g_settings_get_string (_tmp157_, "document-type");
	document_type = _tmp158_;
	_tmp159_ = document_type;
	if (_tmp159_ != NULL) {
		const gchar* _tmp160_;
		_tmp160_ = document_type;
		app_window_set_document_hint (self, _tmp160_, FALSE);
	}
	_tmp161_ = self->priv->_book;
	_tmp162_ = book_view_new (_tmp161_);
	g_object_ref_sink (_tmp162_);
	_g_object_unref0 (self->priv->book_view);
	self->priv->book_view = _tmp162_;
	_tmp163_ = self->priv->book_view;
	gtk_container_set_border_width ((GtkContainer*) _tmp163_, (guint) 18);
	_tmp164_ = self->priv->book_view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp164_, TRUE);
	_tmp165_ = self->priv->main_vbox;
	_tmp166_ = self->priv->book_view;
	gtk_container_add ((GtkContainer*) _tmp165_, (GtkWidget*) _tmp166_);
	_tmp167_ = self->priv->book_view;
	g_signal_connect_object (_tmp167_, "page-selected", (GCallback) _app_window_page_selected_cb_book_view_page_selected, self, 0);
	_tmp168_ = self->priv->book_view;
	g_signal_connect_object (_tmp168_, "show-page", (GCallback) _app_window_show_page_cb_book_view_show_page, self, 0);
	_tmp169_ = self->priv->book_view;
	g_signal_connect_object (_tmp169_, "show-menu", (GCallback) _app_window_show_page_menu_cb_book_view_show_menu, self, 0);
	_tmp170_ = self->priv->book_view;
	gtk_widget_set_visible ((GtkWidget*) _tmp170_, TRUE);
	_tmp171_ = self->priv->preferences_dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp171_, (GtkWindow*) self);
	app_window_load_state (self);
	g_debug ("app-window.vala:1954: Restoring window to %dx%d pixels", self->priv->window_width, self->priv->window_height);
	gtk_window_set_default_size ((GtkWindow*) self, self->priv->window_width, self->priv->window_height);
	if (self->priv->window_is_maximized) {
		g_debug ("app-window.vala:1958: Restoring window to maximized");
		gtk_window_maximize ((GtkWindow*) self);
	}
	if (self->priv->window_is_fullscreen) {
		g_debug ("app-window.vala:1963: Restoring window to fullscreen");
		gtk_window_fullscreen ((GtkWindow*) self);
	}
	_g_free0 (document_type);
	_g_object_unref0 (image);
	_g_object_unref0 (rotate_box);
	_g_object_unref0 (box);
	_g_object_unref0 (button);
	_g_object_unref0 (section);
	_g_object_unref0 (gear_menu);
	_g_object_unref0 (app);
}

static void
app_window_load_state (AppWindow* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GKeyFile* f = NULL;
	GKeyFile* _tmp3_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_get_state_filename (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_debug ("app-window.vala:1975: Loading state from %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = g_key_file_new ();
	f = _tmp3_;
	{
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = app_window_get_state_filename (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		g_key_file_load_from_file (f, _tmp6_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		if (!g_error_matches (_tmp7_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			GError* _tmp8_;
			const gchar* _tmp9_;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("app-window.vala:1985: Failed to load state: %s", _tmp9_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	self->priv->window_width = app_window_state_get_integer (self, f, "window", "width", 600);
	if (self->priv->window_width <= 0) {
		self->priv->window_width = 600;
	}
	self->priv->window_height = app_window_state_get_integer (self, f, "window", "height", 400);
	if (self->priv->window_height <= 0) {
		self->priv->window_height = 400;
	}
	self->priv->window_is_maximized = app_window_state_get_boolean (self, f, "window", "is-maximized", FALSE);
	self->priv->window_is_fullscreen = app_window_state_get_boolean (self, f, "window", "is-fullscreen", FALSE);
	_tmp10_ = app_window_state_get_string (self, f, "scanner", "scan-type", "");
	_tmp11_ = _tmp10_;
	self->priv->scan_type = scanner_type_from_string (_tmp11_);
	_g_free0 (_tmp11_);
	app_window_set_scan_type (self, self->priv->scan_type);
	_g_key_file_unref0 (f);
}

static gchar*
app_window_state_get_string (AppWindow* self,
                             GKeyFile* f,
                             const gchar* group_name,
                             const gchar* key,
                             const gchar* _default_)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (_default_ != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_key_file_get_string (f, group_name, key, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp3_;
		g_clear_error (&_inner_error0_);
		_tmp3_ = g_strdup (_default_);
		result = _tmp3_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
app_window_state_get_integer (AppWindow* self,
                              GKeyFile* f,
                              const gchar* group_name,
                              const gchar* key,
                              gint _default_)
{
	gint _tmp1_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (f != NULL, 0);
	g_return_val_if_fail (group_name != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	{
		gint _tmp0_ = 0;
		_tmp0_ = g_key_file_get_integer (f, group_name, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = _default_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp1_;
}

static gboolean
app_window_state_get_boolean (AppWindow* self,
                              GKeyFile* f,
                              const gchar* group_name,
                              const gchar* key,
                              gboolean _default_)
{
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (f != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = g_key_file_get_boolean (f, group_name, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = _default_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp1_;
}

static gboolean
___lambda38_ (AppWindow* self)
{
	gboolean result;
	app_window_save_state (self, TRUE);
	self->priv->save_state_timeout = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
____lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda38_ ((AppWindow*) self);
	return result;
}

static void
app_window_save_state (AppWindow* self,
                       gboolean force)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GKeyFile* f = NULL;
	GKeyFile* _tmp3_;
	GKeyFile* _tmp4_;
	GKeyFile* _tmp5_;
	GKeyFile* _tmp6_;
	GKeyFile* _tmp7_;
	GKeyFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!force) {
		if (self->priv->save_state_timeout != ((guint) 0)) {
			g_source_remove (self->priv->save_state_timeout);
		}
		self->priv->save_state_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda38__gsource_func, g_object_ref (self), g_object_unref);
		return;
	}
	_tmp0_ = app_window_get_state_filename (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_debug ("app-window.vala:2051: Saving state to %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = g_key_file_new ();
	f = _tmp3_;
	_tmp4_ = f;
	g_key_file_set_integer (_tmp4_, "window", "width", self->priv->window_width);
	_tmp5_ = f;
	g_key_file_set_integer (_tmp5_, "window", "height", self->priv->window_height);
	_tmp6_ = f;
	g_key_file_set_boolean (_tmp6_, "window", "is-maximized", self->priv->window_is_maximized);
	_tmp7_ = f;
	g_key_file_set_boolean (_tmp7_, "window", "is-fullscreen", self->priv->window_is_fullscreen);
	_tmp8_ = f;
	_tmp9_ = scanner_type_to_string (self->priv->scan_type);
	_tmp10_ = _tmp9_;
	g_key_file_set_string (_tmp8_, "scanner", "scan-type", _tmp10_);
	_g_free0 (_tmp10_);
	{
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GKeyFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp11_ = app_window_STATE_DIR;
		g_mkdir_with_parents (_tmp11_, 0700);
		_tmp12_ = app_window_get_state_filename (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = f;
		_tmp16_ = g_key_file_to_data (_tmp15_, NULL, NULL);
		_tmp17_ = _tmp16_;
		g_file_set_contents (_tmp14_, _tmp17_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("app-window.vala:2066: Failed to write state: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_key_file_unref0 (f);
}

void
app_window_start (AppWindow* self)
{
	AutosaveManager* _tmp0_;
	AutosaveManager* _tmp1_;
	Book* _tmp2_;
	gboolean _tmp3_ = FALSE;
	AutosaveManager* _tmp4_;
	Book* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	gtk_widget_set_visible ((GtkWidget*) self, TRUE);
	_tmp0_ = autosave_manager_new ();
	_autosave_manager_unref0 (self->priv->autosave_manager);
	self->priv->autosave_manager = _tmp0_;
	_tmp1_ = self->priv->autosave_manager;
	_tmp2_ = self->priv->_book;
	autosave_manager_set_book (_tmp1_, _tmp2_);
	_tmp4_ = self->priv->autosave_manager;
	if (autosave_manager_exists (_tmp4_)) {
		_tmp3_ = app_window_prompt_to_load_autosaved_book (self);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		AutosaveManager* _tmp5_;
		_tmp5_ = self->priv->autosave_manager;
		autosave_manager_load (_tmp5_);
	}
	_tmp6_ = self->priv->_book;
	_tmp7_ = book_get_n_pages (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == ((guint) 0)) {
		self->priv->book_needs_saving = FALSE;
	} else {
		GtkStack* _tmp9_;
		BookView* _tmp10_;
		Book* _tmp11_;
		Page* _tmp12_;
		Page* _tmp13_;
		Book* _tmp14_;
		_tmp9_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp9_, "document");
		_tmp10_ = self->priv->book_view;
		_tmp11_ = self->priv->_book;
		_tmp12_ = book_get_page (_tmp11_, 0);
		_tmp13_ = _tmp12_;
		book_view_set_selected_page (_tmp10_, _tmp13_);
		_g_object_unref0 (_tmp13_);
		self->priv->book_needs_saving = TRUE;
		_tmp14_ = self->priv->_book;
		app_window_book_changed_cb (self, _tmp14_);
	}
}

Book*
app_window_get_book (AppWindow* self)
{
	Book* result;
	Book* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_book;
	result = _tmp0_;
	return result;
}

static void
app_window_set_book (AppWindow* self,
                     Book* value)
{
	Book* old_value;
	g_return_if_fail (self != NULL);
	old_value = app_window_get_book (self);
	if (old_value != value) {
		Book* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_book);
		self->priv->_book = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, app_window_properties[APP_WINDOW_BOOK_PROPERTY]);
	}
}

Page*
app_window_get_selected_page (AppWindow* self)
{
	Page* result;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
app_window_set_selected_page (AppWindow* self,
                              Page* value)
{
	BookView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	book_view_set_selected_page (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, app_window_properties[APP_WINDOW_SELECTED_PAGE_PROPERTY]);
}

gboolean
app_window_get_scanning (AppWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->scanning_;
	return result;
}

void
app_window_set_scanning (AppWindow* self,
                         gboolean value)
{
	GtkStack* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	g_return_if_fail (self != NULL);
	self->priv->scanning_ = value;
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "document");
	_tmp1_ = self->priv->page_delete_menuitem;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, !value);
	_tmp2_ = self->priv->delete_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, !value);
	_tmp3_ = self->priv->scan_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, !value);
	_tmp4_ = self->priv->stop_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, value);
	g_object_notify_by_pspec ((GObject *) self, app_window_properties[APP_WINDOW_SCANNING_PROPERTY]);
}

gint
app_window_get_brightness (AppWindow* self)
{
	gint result;
	PreferencesDialog* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->preferences_dialog;
	result = preferences_dialog_get_brightness (_tmp0_);
	return result;
}

void
app_window_set_brightness (AppWindow* self,
                           gint value)
{
	PreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	preferences_dialog_set_brightness (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, app_window_properties[APP_WINDOW_BRIGHTNESS_PROPERTY]);
}

gint
app_window_get_contrast (AppWindow* self)
{
	gint result;
	PreferencesDialog* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->preferences_dialog;
	result = preferences_dialog_get_contrast (_tmp0_);
	return result;
}

void
app_window_set_contrast (AppWindow* self,
                         gint value)
{
	PreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	preferences_dialog_set_contrast (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, app_window_properties[APP_WINDOW_CONTRAST_PROPERTY]);
}

gint
app_window_get_page_delay (AppWindow* self)
{
	gint result;
	PreferencesDialog* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->preferences_dialog;
	result = preferences_dialog_get_page_delay (_tmp0_);
	return result;
}

void
app_window_set_page_delay (AppWindow* self,
                           gint value)
{
	PreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	preferences_dialog_set_page_delay (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, app_window_properties[APP_WINDOW_PAGE_DELAY_PROPERTY]);
}

static gchar*
app_window_get_state_filename (AppWindow* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", "state", NULL);
	result = _tmp1_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
app_window_class_init (AppWindowClass * klass,
                       gpointer klass_data)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	app_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AppWindow_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) app_window_real_size_allocate;
	((GtkWidgetClass *) klass)->window_state_event = (gboolean (*) (GtkWidget*, GdkEventWindowState*)) app_window_real_window_state_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_app_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_app_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = app_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_WINDOW_BOOK_PROPERTY, app_window_properties[APP_WINDOW_BOOK_PROPERTY] = g_param_spec_object ("book", "book", "book", TYPE_BOOK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_WINDOW_SELECTED_PAGE_PROPERTY, app_window_properties[APP_WINDOW_SELECTED_PAGE_PROPERTY] = g_param_spec_object ("selected-page", "selected-page", "selected-page", TYPE_PAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_WINDOW_SCANNING_PROPERTY, app_window_properties[APP_WINDOW_SCANNING_PROPERTY] = g_param_spec_boolean ("scanning", "scanning", "scanning", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_WINDOW_BRIGHTNESS_PROPERTY, app_window_properties[APP_WINDOW_BRIGHTNESS_PROPERTY] = g_param_spec_int ("brightness", "brightness", "brightness", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_WINDOW_CONTRAST_PROPERTY, app_window_properties[APP_WINDOW_CONTRAST_PROPERTY] = g_param_spec_int ("contrast", "contrast", "contrast", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_WINDOW_PAGE_DELAY_PROPERTY, app_window_properties[APP_WINDOW_PAGE_DELAY_PROPERTY] = g_param_spec_int ("page-delay", "page-delay", "page-delay", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/SimpleScan/ui/app-window.ui");
	app_window_signals[APP_WINDOW_START_SCAN_SIGNAL] = g_signal_new ("start-scan", TYPE_APP_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_SCAN_OPTIONS);
	app_window_signals[APP_WINDOW_STOP_SCAN_SIGNAL] = g_signal_new ("stop-scan", TYPE_APP_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	app_window_signals[APP_WINDOW_REDETECT_SIGNAL] = g_signal_new ("redetect", TYPE_APP_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_bar", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_menu", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, page_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "status_page", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, status_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "status_secondary_label", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, status_secondary_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "device_model", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, device_model));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "device_buttons_box", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, device_buttons_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "device_combo", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, device_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_vbox", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, main_vbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_crop_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, custom_crop_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "a3_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, a3_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "a4_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, a4_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "a5_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, a5_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "a6_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, a6_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "letter_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, letter_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "legal_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, legal_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "four_by_six_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, four_by_six_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "no_crop_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, no_crop_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_move_left_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, page_move_left_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_move_right_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, page_move_right_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_delete_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, page_delete_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "crop_rotate_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, crop_rotate_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "copy_to_clipboard_menuitem", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, copy_to_clipboard_menuitem));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_button", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, save_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stop_button", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, stop_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scan_button", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, scan_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_bar", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, action_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scan_options_image", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, scan_options_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scan_hint_image", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, scan_hint_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scan_single_radio", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, scan_single_radio));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scan_adf_radio", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, scan_adf_radio));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scan_batch_radio", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, scan_batch_radio));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_radio", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, text_radio));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "photo_radio", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, photo_radio));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, menu_button));
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", NULL, NULL);
	app_window_STATE_DIR = _tmp1_;
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "status_label_activate_link_cb", G_CALLBACK(_app_window_status_label_activate_link_cb_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "redetect_button_clicked_cb", G_CALLBACK(_app_window_redetect_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scan_single_radio_toggled_cb", G_CALLBACK(_app_window_scan_single_radio_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scan_adf_radio_toggled_cb", G_CALLBACK(_app_window_scan_adf_radio_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scan_batch_radio_toggled_cb", G_CALLBACK(_app_window_scan_batch_radio_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "text_radio_toggled_cb", G_CALLBACK(_app_window_text_radio_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "photo_radio_toggled_cb", G_CALLBACK(_app_window_photo_radio_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "preferences_button_clicked_cb", G_CALLBACK(_app_window_preferences_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "device_combo_changed_cb", G_CALLBACK(_app_window_device_combo_changed_cb_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scan_button_clicked_cb", G_CALLBACK(_app_window_scan_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "stop_scan_button_clicked_cb", G_CALLBACK(_app_window_stop_scan_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "rotate_left_button_clicked_cb", G_CALLBACK(_app_window_rotate_left_button_clicked_cb_gtk_menu_item_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "rotate_right_button_clicked_cb", G_CALLBACK(_app_window_rotate_right_button_clicked_cb_gtk_menu_item_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "no_crop_menuitem_toggled_cb", G_CALLBACK(_app_window_no_crop_menuitem_toggled_cb_gtk_check_menu_item_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "custom_crop_menuitem_toggled_cb", G_CALLBACK(_app_window_custom_crop_menuitem_toggled_cb_gtk_check_menu_item_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "four_by_six_menuitem_toggled_cb", G_CALLBACK(_app_window_four_by_six_menuitem_toggled_cb_gtk_check_menu_item_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "legal_menuitem_toggled_cb", G_CALLBACK(_app_window_legal_menuitem_toggled_cb_gtk_check_menu_item_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "letter_menuitem_toggled_cb", G_CALLBACK(_app_window_letter_menuitem_toggled_cb_gtk_check_menu_item_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "a6_menuitem_toggled_cb", G_CALLBACK(_app_window_a6_menuitem_toggled_cb_gtk_check_menu_item_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "a5_menuitem_toggled_cb", G_CALLBACK(_app_window_a5_menuitem_toggled_cb_gtk_check_menu_item_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "a4_menuitem_toggled_cb", G_CALLBACK(_app_window_a4_menuitem_toggled_cb_gtk_check_menu_item_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "a3_menuitem_toggled_cb", G_CALLBACK(_app_window_a3_menuitem_toggled_cb_gtk_check_menu_item_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "crop_rotate_menuitem_activate_cb", G_CALLBACK(_app_window_crop_rotate_menuitem_activate_cb_gtk_menu_item_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "page_move_left_menuitem_activate_cb", G_CALLBACK(_app_window_page_move_left_menuitem_activate_cb_gtk_menu_item_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "page_move_right_menuitem_activate_cb", G_CALLBACK(_app_window_page_move_right_menuitem_activate_cb_gtk_menu_item_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "page_delete_menuitem_activate_cb", G_CALLBACK(_app_window_page_delete_menuitem_activate_cb_gtk_menu_item_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "save_file_button_clicked_cb", G_CALLBACK(_app_window_save_file_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "copy_to_clipboard_button_clicked_cb", G_CALLBACK(_app_window_copy_to_clipboard_button_clicked_cb_gtk_menu_item_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "window_delete_event_cb", G_CALLBACK(_app_window_window_delete_event_cb_gtk_widget_delete_event));
}

static void
app_window_instance_init (AppWindow * self,
                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = app_window_get_instance_private (self);
	self->priv->scan_type = SCAN_TYPE_SINGLE;
	self->priv->have_devices = FALSE;
	self->priv->missing_driver = NULL;
	self->priv->book_uri = NULL;
	_tmp0_ = g_strdup ("photo");
	self->priv->document_hint = _tmp0_;
	self->priv->scanning_ = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
app_window_finalize (GObject * obj)
{
	AppWindow * self;
	Book* _tmp0_;
	guint _tmp1_;
	Book* _tmp2_;
	guint _tmp3_;
	Book* _tmp4_;
	guint _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_WINDOW, AppWindow);
	_tmp0_ = self->priv->_book;
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _app_window_page_added_cb_book_page_added, self);
	_tmp2_ = self->priv->_book;
	g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _app_window_reordered_cb_book_reordered, self);
	_tmp4_ = self->priv->_book;
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _app_window_page_removed_cb_book_page_removed, self);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->crop_button);
	_g_object_unref0 (self->priv->delete_button);
	_g_free0 (self->priv->missing_driver);
	_g_object_unref0 (self->priv->_book);
	_g_free0 (self->priv->book_uri);
	_autosave_manager_unref0 (self->priv->autosave_manager);
	_g_object_unref0 (self->priv->book_view);
	_g_free0 (self->priv->document_hint);
	G_OBJECT_CLASS (app_window_parent_class)->finalize (obj);
}

static GType
app_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AppWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppWindow), 0, (GInstanceInitFunc) app_window_instance_init, NULL };
	GType app_window_type_id;
	app_window_type_id = g_type_register_static (hdy_application_window_get_type (), "AppWindow", &g_define_type_info, 0);
	AppWindow_private_offset = g_type_add_instance_private (app_window_type_id, sizeof (AppWindowPrivate));
	return app_window_type_id;
}

GType
app_window_get_type (void)
{
	static volatile gsize app_window_type_id__once = 0;
	if (g_once_init_enter (&app_window_type_id__once)) {
		GType app_window_type_id;
		app_window_type_id = app_window_get_type_once ();
		g_once_init_leave (&app_window_type_id__once, app_window_type_id);
	}
	return app_window_type_id__once;
}

static void
_vala_app_window_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	AppWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APP_WINDOW, AppWindow);
	switch (property_id) {
		case APP_WINDOW_BOOK_PROPERTY:
		g_value_set_object (value, app_window_get_book (self));
		break;
		case APP_WINDOW_SELECTED_PAGE_PROPERTY:
		g_value_set_object (value, app_window_get_selected_page (self));
		break;
		case APP_WINDOW_SCANNING_PROPERTY:
		g_value_set_boolean (value, app_window_get_scanning (self));
		break;
		case APP_WINDOW_BRIGHTNESS_PROPERTY:
		g_value_set_int (value, app_window_get_brightness (self));
		break;
		case APP_WINDOW_CONTRAST_PROPERTY:
		g_value_set_int (value, app_window_get_contrast (self));
		break;
		case APP_WINDOW_PAGE_DELAY_PROPERTY:
		g_value_set_int (value, app_window_get_page_delay (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_app_window_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	AppWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APP_WINDOW, AppWindow);
	switch (property_id) {
		case APP_WINDOW_BOOK_PROPERTY:
		app_window_set_book (self, g_value_get_object (value));
		break;
		case APP_WINDOW_SELECTED_PAGE_PROPERTY:
		app_window_set_selected_page (self, g_value_get_object (value));
		break;
		case APP_WINDOW_SCANNING_PROPERTY:
		app_window_set_scanning (self, g_value_get_boolean (value));
		break;
		case APP_WINDOW_BRIGHTNESS_PROPERTY:
		app_window_set_brightness (self, g_value_get_int (value));
		break;
		case APP_WINDOW_CONTRAST_PROPERTY:
		app_window_set_contrast (self, g_value_get_int (value));
		break;
		case APP_WINDOW_PAGE_DELAY_PROPERTY:
		app_window_set_page_delay (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
cancellable_progress_bar_get_instance_private (CancellableProgressBar* self)
{
	return G_STRUCT_MEMBER_P (self, CancellableProgressBar_private_offset);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		CancellableProgressBar* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
___lambda28_ (Block4Data* _data4_)
{
	CancellableProgressBar* self;
	self = _data4_->self;
	gtk_widget_set_visible ((GtkWidget*) self, FALSE);
	g_cancellable_cancel (_data4_->cancellable);
}

static void
____lambda28__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda28_ (self);
}

CancellableProgressBar*
cancellable_progress_bar_construct (GType object_type,
                                    const gchar* text,
                                    GCancellable* cancellable)
{
	CancellableProgressBar * self = NULL;
	Block4Data* _data4_;
	GCancellable* _tmp0_;
	GtkProgressBar* _tmp1_;
	GtkProgressBar* _tmp2_;
	GtkProgressBar* _tmp3_;
	GtkProgressBar* _tmp4_;
	GtkProgressBar* _tmp5_;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data4_->cancellable);
	_data4_->cancellable = _tmp0_;
	self = (CancellableProgressBar*) g_object_new (object_type, NULL);
	_data4_->self = g_object_ref (self);
	_tmp1_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->bar);
	self->priv->bar = _tmp1_;
	_tmp2_ = self->priv->bar;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->bar;
	gtk_progress_bar_set_text (_tmp3_, text);
	_tmp4_ = self->priv->bar;
	gtk_progress_bar_set_show_text (_tmp4_, TRUE);
	_tmp5_ = self->priv->bar;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp5_, TRUE, TRUE, (guint) 0);
	if (_data4_->cancellable != NULL) {
		GtkButton* _tmp6_;
		GtkButton* _tmp7_;
		GtkButton* _tmp8_;
		GtkButton* _tmp9_;
		_tmp6_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->button);
		self->priv->button = _tmp6_;
		_tmp7_ = self->priv->button;
		gtk_widget_set_visible ((GtkWidget*) _tmp7_, TRUE);
		_tmp8_ = self->priv->button;
		g_signal_connect_data (_tmp8_, "clicked", (GCallback) ____lambda28__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		_tmp9_ = self->priv->button;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp9_, TRUE, TRUE, (guint) 0);
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return self;
}

CancellableProgressBar*
cancellable_progress_bar_new (const gchar* text,
                              GCancellable* cancellable)
{
	return cancellable_progress_bar_construct (TYPE_CANCELLABLE_PROGRESS_BAR, text, cancellable);
}

void
cancellable_progress_bar_set_fraction (CancellableProgressBar* self,
                                       gdouble fraction)
{
	GtkProgressBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bar;
	gtk_progress_bar_set_fraction (_tmp0_, fraction);
}

static gboolean
__lambda29_ (CancellableProgressBar* self)
{
	gboolean result;
	gtk_widget_destroy ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda29__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda29_ ((CancellableProgressBar*) self);
	return result;
}

void
cancellable_progress_bar_destroy_with_delay (CancellableProgressBar* self,
                                             guint delay)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	g_timeout_add_full (G_PRIORITY_DEFAULT, delay, ___lambda29__gsource_func, g_object_ref (self), g_object_unref);
}

static void
cancellable_progress_bar_class_init (CancellableProgressBarClass * klass,
                                     gpointer klass_data)
{
	cancellable_progress_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CancellableProgressBar_private_offset);
	G_OBJECT_CLASS (klass)->finalize = cancellable_progress_bar_finalize;
}

static void
cancellable_progress_bar_instance_init (CancellableProgressBar * self,
                                        gpointer klass)
{
	self->priv = cancellable_progress_bar_get_instance_private (self);
}

static void
cancellable_progress_bar_finalize (GObject * obj)
{
	CancellableProgressBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CANCELLABLE_PROGRESS_BAR, CancellableProgressBar);
	_g_object_unref0 (self->priv->bar);
	_g_object_unref0 (self->priv->button);
	G_OBJECT_CLASS (cancellable_progress_bar_parent_class)->finalize (obj);
}

static GType
cancellable_progress_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CancellableProgressBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cancellable_progress_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CancellableProgressBar), 0, (GInstanceInitFunc) cancellable_progress_bar_instance_init, NULL };
	GType cancellable_progress_bar_type_id;
	cancellable_progress_bar_type_id = g_type_register_static (gtk_hbox_get_type (), "CancellableProgressBar", &g_define_type_info, 0);
	CancellableProgressBar_private_offset = g_type_add_instance_private (cancellable_progress_bar_type_id, sizeof (CancellableProgressBarPrivate));
	return cancellable_progress_bar_type_id;
}

GType
cancellable_progress_bar_get_type (void)
{
	static volatile gsize cancellable_progress_bar_type_id__once = 0;
	if (g_once_init_enter (&cancellable_progress_bar_type_id__once)) {
		GType cancellable_progress_bar_type_id;
		cancellable_progress_bar_type_id = cancellable_progress_bar_get_type_once ();
		g_once_init_leave (&cancellable_progress_bar_type_id__once, cancellable_progress_bar_type_id);
	}
	return cancellable_progress_bar_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

