/* postprocessor.c generated by valac 0.56.0, the Vala compiler
 * generated from postprocessor.vala, do not modify */

/* SPDX-License-Identifier: GPL-3.0-or-later*/
/*
 * Copyright (C) 2022 Alexander Vogt
 * Author: Alexander Vogt <a.vogt@fulguritus.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_POSTPROCESSOR (postprocessor_get_type ())
#define POSTPROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POSTPROCESSOR, Postprocessor))
#define POSTPROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POSTPROCESSOR, PostprocessorClass))
#define IS_POSTPROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POSTPROCESSOR))
#define IS_POSTPROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POSTPROCESSOR))
#define POSTPROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POSTPROCESSOR, PostprocessorClass))

typedef struct _Postprocessor Postprocessor;
typedef struct _PostprocessorClass PostprocessorClass;
typedef struct _PostprocessorPrivate PostprocessorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPostprocessor ParamSpecPostprocessor;

struct _Postprocessor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PostprocessorPrivate * priv;
};

struct _PostprocessorClass {
	GTypeClass parent_class;
	void (*finalize) (Postprocessor *self);
};

struct _ParamSpecPostprocessor {
	GParamSpec parent_instance;
};

static gpointer postprocessor_parent_class = NULL;

VALA_EXTERN gpointer postprocessor_ref (gpointer instance);
VALA_EXTERN void postprocessor_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_postprocessor (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_postprocessor (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_postprocessor (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_postprocessor (const GValue* value);
VALA_EXTERN GType postprocessor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Postprocessor, postprocessor_unref)
VALA_EXTERN Postprocessor* postprocessor_new (void);
VALA_EXTERN Postprocessor* postprocessor_construct (GType object_type);
VALA_EXTERN gint postprocessor_process (Postprocessor* self,
                            const gchar* script,
                            const gchar* mime_type,
                            gboolean keep_original,
                            const gchar* source_file,
                            const gchar* arguments,
                            GError** error);
static void postprocessor_finalize (Postprocessor * obj);
static GType postprocessor_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

Postprocessor*
postprocessor_construct (GType object_type)
{
	Postprocessor* self = NULL;
	self = (Postprocessor*) g_type_create_instance (object_type);
	return self;
}

Postprocessor*
postprocessor_new (void)
{
	return postprocessor_construct (TYPE_POSTPROCESSOR);
}

gint
postprocessor_process (Postprocessor* self,
                       const gchar* script,
                       const gchar* mime_type,
                       gboolean keep_original,
                       const gchar* source_file,
                       const gchar* arguments,
                       GError** error)
{
	const gchar* _tmp0_ = NULL;
	gchar** spawn_args = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint spawn_args_length1;
	gint _spawn_args_size_;
	gchar** spawn_env = NULL;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint spawn_env_length1;
	gint _spawn_env_size_;
	gchar* process_stdout = NULL;
	gchar* process_stderr = NULL;
	gint process_status = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (script != NULL, 0);
	g_return_val_if_fail (mime_type != NULL, 0);
	g_return_val_if_fail (source_file != NULL, 0);
	g_return_val_if_fail (arguments != NULL, 0);
	if (keep_original) {
		_tmp0_ = "true";
	} else {
		_tmp0_ = "false";
	}
	_tmp1_ = g_strdup (script);
	_tmp2_ = g_strdup (mime_type);
	_tmp3_ = g_strdup (_tmp0_);
	_tmp4_ = g_strdup (source_file);
	_tmp5_ = g_strdup (arguments);
	_tmp6_ = g_new0 (gchar*, 5 + 1);
	_tmp6_[0] = _tmp1_;
	_tmp6_[1] = _tmp2_;
	_tmp6_[2] = _tmp3_;
	_tmp6_[3] = _tmp4_;
	_tmp6_[4] = _tmp5_;
	spawn_args = _tmp6_;
	spawn_args_length1 = 5;
	_spawn_args_size_ = spawn_args_length1;
	_tmp8_ = _tmp7_ = g_get_environ ();
	spawn_env = _tmp8_;
	spawn_env_length1 = _vala_array_length (_tmp7_);
	_spawn_env_size_ = spawn_env_length1;
	g_print ("Executing script%s\n", script);
	g_spawn_sync (NULL, spawn_args, spawn_env, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp9_, &_tmp10_, &_tmp11_, &_inner_error0_);
	_g_free0 (process_stdout);
	process_stdout = _tmp9_;
	_g_free0 (process_stderr);
	process_stderr = _tmp10_;
	process_status = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp12_ = -1;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (process_stderr);
		_g_free0 (process_stdout);
		spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
		return _tmp12_;
	}
	g_debug ("postprocessor.vala:36: status: %d\n", process_status);
	g_debug ("postprocessor.vala:37: STDOUT: \n");
	g_debug ("postprocessor.vala:38: process_stdout");
	g_debug ("postprocessor.vala:39: STDERR: \n");
	g_debug ("postprocessor.vala:40: process_stderr");
	result = process_status;
	_g_free0 (process_stderr);
	_g_free0 (process_stdout);
	spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
	spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
value_postprocessor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_postprocessor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		postprocessor_unref (value->data[0].v_pointer);
	}
}

static void
value_postprocessor_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = postprocessor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_postprocessor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_postprocessor_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Postprocessor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = postprocessor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_postprocessor_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	Postprocessor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = postprocessor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_postprocessor (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecPostprocessor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_POSTPROCESSOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_postprocessor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_POSTPROCESSOR), NULL);
	return value->data[0].v_pointer;
}

void
value_set_postprocessor (GValue* value,
                         gpointer v_object)
{
	Postprocessor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_POSTPROCESSOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_POSTPROCESSOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		postprocessor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		postprocessor_unref (old);
	}
}

void
value_take_postprocessor (GValue* value,
                          gpointer v_object)
{
	Postprocessor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_POSTPROCESSOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_POSTPROCESSOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		postprocessor_unref (old);
	}
}

static void
postprocessor_class_init (PostprocessorClass * klass,
                          gpointer klass_data)
{
	postprocessor_parent_class = g_type_class_peek_parent (klass);
	((PostprocessorClass *) klass)->finalize = postprocessor_finalize;
}

static void
postprocessor_instance_init (Postprocessor * self,
                             gpointer klass)
{
	self->ref_count = 1;
}

static void
postprocessor_finalize (Postprocessor * obj)
{
	Postprocessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_POSTPROCESSOR, Postprocessor);
	g_signal_handlers_destroy (self);
}

static GType
postprocessor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_postprocessor_init, value_postprocessor_free_value, value_postprocessor_copy_value, value_postprocessor_peek_pointer, "p", value_postprocessor_collect_value, "p", value_postprocessor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PostprocessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) postprocessor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Postprocessor), 0, (GInstanceInitFunc) postprocessor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType postprocessor_type_id;
	postprocessor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Postprocessor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return postprocessor_type_id;
}

GType
postprocessor_get_type (void)
{
	static volatile gsize postprocessor_type_id__once = 0;
	if (g_once_init_enter (&postprocessor_type_id__once)) {
		GType postprocessor_type_id;
		postprocessor_type_id = postprocessor_get_type_once ();
		g_once_init_leave (&postprocessor_type_id__once, postprocessor_type_id);
	}
	return postprocessor_type_id__once;
}

gpointer
postprocessor_ref (gpointer instance)
{
	Postprocessor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
postprocessor_unref (gpointer instance)
{
	Postprocessor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		POSTPROCESSOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

