/* This file is automatically generated by Lemon from input grammar
** source file "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon". */
/* ascend_parser.lemon
 *
 * Wiretap Library
 * Copyright (c) 1998 by Gilbert Ramirez <gram@alumni.rice.edu>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

/*
    Example 'pridisp' output data - one paragraph/frame:

PRI-XMIT-27: (task "l1Task" at 0x10216fe0, time: 560194.01) 4 octets @ 0x1027c5b0
  [0000]: 00 01 01 a9                                         ....
PRI-RCV-27: (task "idle task" at 0x10123570, time: 560194.01) 4 octets @ 0x1027fb00
  [0000]: 00 01 01 dd

    Example 'pridisp' output data - two paragraphs/frame for XMIT case only:

PRI-XMIT-19/1:  (task "l1Task" at 0x10216840, time: 274759.98) 4 octets @ 0x1027f230
  [0000]: 00 01 30 d8                                         ..0.
PRI-XMIT-19/2 (task "l1Task" at 0x10216840, time: 274759.98) 11 octets @ 0x1027f234
  [0000]: 08 02 8c bf 02 18 04 e9  82 83 8f                   ........ ...

    Example 'ether-disp' output data:

ETHER3ND RECV: (task "_sarTask" at 0x802c6eb0, time: 259848.03) 775 octets @ 0xa8fb2020
  [0000]: 00 d0 52 04 e7 1e 08 00  20 ae 51 b5 08 00 45 00    ..R..... .Q...E.
  [0010]: 02 f9 05 e6 40 00 3f 11  6e 39 87 fe c4 95 3c 3c    ....@.?.  n9....<<
  [0020]: 3c 05 13 c4 13 c4 02 e5  ef ed 49 4e 56 49 54 45    <.......  ..INVITE
  [0030]: 20 73 69 70 3a 35 32 30  37 33 40 36 30 2e 36 30     sip:520 73@60.60
  [0040]: 2e 36 30 2e 35 20 53 49  50 2f 32 2e 30 0d 0a 56    .60.5 SI P/2.0..V
  [0050]: 69 61 3a 20 53 49 50 2f  32 2e 30 2f 55 44 50 20    ia: SIP/ 2.0/UDP
  [0060]: 31 33 35 2e                                         135.

    Example 'wandsess' output data:

RECV-iguana:241:(task: B02614C0, time: 1975432.85) 49 octets @ 8003BD94
  [0000]: FF 03 00 3D C0 06 CA 22 2F 45 00 00 28 6A 3B 40
  [0010]: 00 3F 03 D7 37 CE 41 62 12 CF 00 FB 08 20 27 00
  [0020]: 50 E4 08 DD D7 7C 4C 71 92 50 10 7D 78 67 C8 00
  [0030]: 00
XMIT-iguana:241:(task: B04E12C0, time: 1975432.85) 53 octets @ 8009EB16
  [0000]: FF 03 00 3D C0 09 1E 31 21 45 00 00 2C 2D BD 40
  [0010]: 00 7A 06 D8 B1 CF 00 FB 08 CE 41 62 12 00 50 20
  [0020]: 29 7C 4C 71 9C 9A 6A 93 A4 60 12 22 38 3F 10 00
  [0030]: 00 02 04 05 B4

    Example 'wdd' output data:

Date: 01/12/1990.  Time: 12:22:33
Cause an attempt to place call to 14082750382
WD_DIALOUT_DISP: chunk 2515EE type IP.
(task: 251790, time: 994953.28) 44 octets @ 2782B8
  [0000]: 00 C0 7B 71 45 6C 00 60 08 16 AA 51 08 00 45 00
  [0010]: 00 2C 66 1C 40 00 80 06 53 F6 AC 14 00 18 CC 47
  [0020]: C8 45 0A 31 00 50 3B D9 5B 75 00 00

    The following output comes from a MAX with Software 7.2.3:

RECV-187:(task: B050B480, time: 18042248.03) 100 octets @ 800012C0
  [0000]: FF 03 00 21 45 00 00 60 E3 49 00 00 7F 11 FD 7B
  [0010]: C0 A8 F7 05 8A C8 18 51 00 89 00 89 00 4C C7 C1
  [0020]: CC 8E 40 00 00 01 00 00 00 00 00 01 20 45 4A 45
  [0030]: 42 45 43 45 48 43 4E 46 43 46 41 43 41 43 41 43
  [0040]: 41 43 41 43 41 43 41 43 41 43 41 42 4E 00 00 20
  [0050]: 00 01 C0 0C 00 20 00 01 00 04 93 E0 00 06 60 00
  [0060]: C0 A8 F7 05
XMIT-187:(task: B0292CA0, time: 18042248.04) 60 octets @ 800AD576
  [0000]: FF 03 00 21 45 00 00 38 D7 EE 00 00 0F 01 11 2B
  [0010]: 0A FF FF FE C0 A8 F7 05 03 0D 33 D3 00 00 00 00
  [0020]: 45 00 00 60 E3 49 00 00 7E 11 FE 7B C0 A8 F7 05
  [0030]: 8A C8 18 51 00 89 00 89 00 4C C7 C1
RECV-187:(task: B0292CA0, time: 18042251.92) 16 octets @ 800018E8
  [0000]: FF 03 C0 21 09 01 00 0C DE 61 96 4B 00 30 94 92

  In TAOS 8.0, Lucent slightly changed the format as follows:

    Example 'wandisp' output data (TAOS 8.0.3): (same format is used
    for 'wanopen' and 'wannext' command)

RECV-14: (task "idle task" at 0xb05e6e00, time: 1279.01) 29 octets @ 0x8000e0fc
  [0000]: ff 03 c0 21 01 01 00 19  01 04 05 f4 11 04 05 f4    ...!.... ........
  [0010]: 13 09 03 00 c0 7b 9a 9f  2d 17 04 10 00             .....{.. -....
XMIT-14: (task "idle task" at 0xb05e6e00, time: 1279.02) 38 octets @ 0x8007fd56
  [0000]: ff 03 c0 21 01 01 00 22  00 04 00 00 01 04 05 f4    ...!..." ........
  [0010]: 03 05 c2 23 05 11 04 05  f4 13 09 03 00 c0 7b 80    ...#.... ......{.
  [0020]: 7c ef 17 04 0e 00                                   |.....
XMIT-14: (task "idle task" at 0xb05e6e00, time: 1279.02) 29 octets @ 0x8007fa36
  [0000]: ff 03 c0 21 02 01 00 19  01 04 05 f4 11 04 05 f4    ...!.... ........
  [0010]: 13 09 03 00 c0 7b 9a 9f  2d 17 04 10 00             .....{.. -....

    Example 'wandsess' output data (TAOS 8.0.3):

RECV-Max7:20: (task "_brouterControlTask" at 0xb094ac20, time: 1481.50) 20 octets @ 0x8000d198
  [0000]: ff 03 00 3d c0 00 00 04  80 fd 02 01 00 0a 11 06    ...=.... ........
  [0010]: 00 01 01 03                                         ....
XMIT-Max7:20: (task "_brouterControlTask" at 0xb094ac20, time: 1481.51) 26 octets @ 0x800806b6
  [0000]: ff 03 00 3d c0 00 00 00  80 21 01 01 00 10 02 06    ...=.... .!......
  [0010]: 00 2d 0f 01 03 06 89 64  03 08                      .-.....d ..
XMIT-Max7:20: (task "_brouterControlTask" at 0xb094ac20, time: 1481.51) 20 octets @ 0x8007f716
  [0000]: ff 03 00 3d c0 00 00 01  80 fd 01 01 00 0a 11 06    ...=.... ........
  [0010]: 00 01 01 03                                         ....

  The changes since TAOS 7.X are:

    1) White space is added before "(task".
    2) Task has a name, indicated by a subsequent string surrounded by a
       double-quote.
    3) Address expressed in hex number has a preceding "0x".
    4) Hex numbers are in lower case.
    5) There is a character display corresponding to hex data in each line.

 */

#include "config.h"
#include <assert.h>
#include <stdlib.h>
#include <string.h>

#include "wtap-int.h"
#include "ascendtext.h"
#include "ascend-int.h"
#include "ascend_parser.h"
#include "ascend_scanner_lex.h"
#include "file_wrappers.h"
#include <wsutil/wslog.h>

#define NO_USER "<none>"

static void *AscendParserAlloc(void *(*mallocProc)(size_t));
static void AscendParser(void *yyp, int yymajor, ascend_token_t yyminor, ascend_state_t *state);
static void AscendParserFree(void *p, void (*freeProc)(void*));

#if 0
#define ASCEND_PARSER_DEBUG 1
#undef NDEBUG
#define ascend_debug(...) ws_warning(__VA_ARGS__)
#else
#define ascend_debug(...)
#endif

#line 170 "./ascend_parser.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols.
***************** Begin token definitions *************************************/
#ifndef STRING
#define STRING                          1
#define KEYWORD                         2
#define WDD_DATE                        3
#define WDD_DECNUM                      4
#define WDD_TIME                        5
#define WDD_CAUSE                       6
#define WDD_CALLNUM                     7
#define WDD_CHUNK                       8
#define COUNTER                         9
#define SLASH_SUFFIX                   10
#define WDS_PREFIX                     11
#define ISDN_PREFIX                    12
#define ETHER_PREFIX                   13
#define DECNUM                         14
#define YEAR                           15
#define MONTH                          16
#define MDAY                           17
#define HEXNUM                         18
#define HEXBYTE                        19
#endif
/**************** End token definitions ***************************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    AscendParserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is AscendParserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    AscendParserARG_SDECL     A static variable declaration for the %extra_argument
**    AscendParserARG_PDECL     A parameter declaration for the %extra_argument
**    AscendParserARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    AscendParserARG_STORE     Code to store %extra_argument into yypParser
**    AscendParserARG_FETCH     Code to extract %extra_argument from yypParser
**    AscendParserCTX_*         As AscendParserARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 41
#define YYACTIONTYPE unsigned short int
#define AscendParserTOKENTYPE  ascend_token_t 
typedef union {
  int yyinit;
  AscendParserTOKENTYPE yy0;
  guint16 yy23;
  guint32 yy43;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define AscendParserARG_SDECL  ascend_state_t *parser_state ;
#define AscendParserARG_PDECL , ascend_state_t *parser_state 
#define AscendParserARG_PARAM ,parser_state 
#define AscendParserARG_FETCH  ascend_state_t *parser_state =yypParser->parser_state ;
#define AscendParserARG_STORE yypParser->parser_state =parser_state ;
#define AscendParserCTX_SDECL
#define AscendParserCTX_PDECL
#define AscendParserCTX_PARAM
#define AscendParserCTX_FETCH
#define AscendParserCTX_STORE
#define YYNSTATE             132
#define YYNRULE              51
#define YYNRULE_WITH_ACTION  16
#define YYNTOKEN             20
#define YY_MAX_SHIFT         131
#define YY_MIN_SHIFTREDUCE   152
#define YY_MAX_SHIFTREDUCE   202
#define YY_ERROR_ACTION      203
#define YY_ACCEPT_ACTION     204
#define YY_NO_ACTION         205
#define YY_MIN_REDUCE        206
#define YY_MAX_REDUCE        256
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (180)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   204,   15,   85,   13,   10,    9,    8,    7,    6,   54,
 /*    10 */     4,   48,   42,    3,   21,  177,   90,  177,   93,   53,
 /*    20 */    36,   94,  154,  152,  153,   98,  112,  101,  118,  119,
 /*    30 */   155,  120,  156,   11,  121,  122,   14,  123,  152,  130,
 /*    40 */    12,   60,   47,  167,   67,  131,   67,   67,  157,   67,
 /*    50 */   128,  155,   67,   67,  156,   67,   16,   67,   67,   82,
 /*    60 */   248,  177,   17,   67,  205,   86,   19,   20,   88,   22,
 /*    70 */    23,  249,   61,  230,   89,   97,   92,   26,   27,   53,
 /*    80 */    96,   29,   30,  100,   33,   34,  102,  104,   37,   38,
 /*    90 */   106,  105,  107,  110,  109,  165,   43,   44,  111,  115,
 /*   100 */   205,   83,  114,   49,   50,    5,  117,   87,   24,   25,
 /*   110 */   232,  125,   55,   56,  127,  126,  129,   84,   18,   91,
 /*   120 */    28,    1,   62,   63,   64,   65,   66,   68,   69,   70,
 /*   130 */    71,   72,   73,   74,  164,   75,   76,   77,   78,  162,
 /*   140 */    79,   80,   81,  163,   95,   31,   32,  161,   99,   35,
 /*   150 */     2,  160,  103,   39,   40,   41,  159,  108,   45,   46,
 /*   160 */   113,   51,   52,  166,  116,  229,  228,  227,  226,  225,
 /*   170 */   224,  128,  158,  124,  205,   57,   58,  223,   59,  222,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    20,   21,   37,   23,   24,   25,   26,   27,   28,   29,
 /*    10 */    30,   31,   32,   33,    3,    1,   34,    1,   36,    8,
 /*    20 */    34,   35,   11,   12,   13,   34,   22,   36,   22,   22,
 /*    30 */    14,   22,   18,   23,   22,   22,    9,   22,   12,   22,
 /*    40 */    22,   31,    2,   19,   40,   22,   40,   40,    4,   40,
 /*    50 */    10,   14,   40,   40,   18,   40,   37,   40,   40,   38,
 /*    60 */    39,    1,   37,   40,   41,   37,   37,   37,   35,   35,
 /*    70 */    35,   40,   40,    0,   36,   36,   35,   35,   35,    8,
 /*    80 */    35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
 /*    90 */    34,   36,   34,   36,   35,    7,   35,   35,   34,   36,
 /*   100 */    41,   35,   35,   35,   35,   30,   36,    2,    2,    2,
 /*   110 */    38,   35,   35,   35,   34,   36,   35,    6,    5,    2,
 /*   120 */     2,    2,   40,   40,   40,   40,   40,   38,   38,   38,
 /*   130 */    38,   38,   38,   38,   18,   38,   38,   38,   38,   18,
 /*   140 */    38,   38,   38,   18,    2,    2,    2,   18,    2,    2,
 /*   150 */     2,   18,    2,    2,    2,    2,   18,    2,    2,    2,
 /*   160 */     2,    2,    2,   18,    2,    0,    0,    0,    0,    0,
 /*   170 */     0,   10,   18,    2,   41,    2,    2,    0,    2,    0,
 /*   180 */    41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
 /*   190 */    41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
};
#define YY_SHIFT_COUNT    (131)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (179)
static const unsigned char yy_shift_ofst[] = {
 /*     0 */    11,   14,   14,   16,   27,   27,   27,   27,   27,   27,
 /*    10 */    27,   27,   26,   27,   24,   27,   44,   44,   44,   44,
 /*    20 */    44,   44,   37,   37,   37,   36,   37,   37,   37,   37,
 /*    30 */    37,   37,   36,   37,   37,   37,   37,   37,   37,   37,
 /*    40 */    36,   60,   60,   37,   37,   37,   36,   60,   37,   37,
 /*    50 */    37,   37,   36,   36,   71,   37,   37,   37,   36,   60,
 /*    60 */    37,   27,   27,   27,   27,   27,   27,   27,   24,   24,
 /*    70 */    24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
 /*    80 */    24,   24,   24,   40,   88,  111,  113,  116,  105,  106,
 /*    90 */   107,  125,  117,  118,  119,  121,  142,  143,  144,  129,
 /*   100 */   146,  147,  148,  133,  150,  151,  152,  153,  138,  155,
 /*   110 */   156,  157,   73,  145,  158,  159,  160,  162,  165,  166,
 /*   120 */   167,  168,  169,  170,  154,  171,  173,  174,  176,  161,
 /*   130 */   177,  179,
};
#define YY_REDUCE_COUNT (82)
#define YY_REDUCE_MIN   (-35)
#define YY_REDUCE_MAX   (104)
static const signed char yy_reduce_ofst[] = {
 /*     0 */   -20,  -18,   -9,  -14,    4,    6,    7,    9,   12,   13,
 /*    10 */    15,   17,   10,   18,   21,   23,  -35,   19,   25,   28,
 /*    20 */    29,   30,   33,   34,   35,   38,   41,   42,   43,   45,
 /*    30 */    46,   47,   39,   48,   49,   50,   51,   52,   53,   54,
 /*    40 */    55,   56,   58,   59,   61,   62,   57,   64,   66,   67,
 /*    50 */    68,   69,   63,   70,   75,   76,   77,   78,   79,   80,
 /*    60 */    81,   31,   32,   82,   83,   84,   85,   86,   72,   89,
 /*    70 */    90,   91,   92,   93,   94,   95,   97,   98,   99,  100,
 /*    80 */   102,  103,  104,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
 /*    10 */   203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
 /*    20 */   203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
 /*    30 */   203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
 /*    40 */   203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
 /*    50 */   203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
 /*    60 */   203,  250,  251,  252,  253,  254,  255,  256,  233,  234,
 /*    70 */   235,  236,  237,  238,  239,  240,  241,  242,  243,  244,
 /*    80 */   245,  246,  247,  203,  203,  203,  203,  203,  203,  203,
 /*    90 */   203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
 /*   100 */   203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
 /*   110 */   203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
 /*   120 */   203,  203,  203,  203,  203,  203,  203,  203,  203,  203,
 /*   130 */   203,  203,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.
** If a construct like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  AscendParserARG_SDECL                /* A place to hold %extra_argument */
  AscendParserCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
#include <assert.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void AscendParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  /*    0 */ "$",
  /*    1 */ "STRING",
  /*    2 */ "KEYWORD",
  /*    3 */ "WDD_DATE",
  /*    4 */ "WDD_DECNUM",
  /*    5 */ "WDD_TIME",
  /*    6 */ "WDD_CAUSE",
  /*    7 */ "WDD_CALLNUM",
  /*    8 */ "WDD_CHUNK",
  /*    9 */ "COUNTER",
  /*   10 */ "SLASH_SUFFIX",
  /*   11 */ "WDS_PREFIX",
  /*   12 */ "ISDN_PREFIX",
  /*   13 */ "ETHER_PREFIX",
  /*   14 */ "DECNUM",
  /*   15 */ "YEAR",
  /*   16 */ "MONTH",
  /*   17 */ "MDAY",
  /*   18 */ "HEXNUM",
  /*   19 */ "HEXBYTE",
  /*   20 */ "data_packet",
  /*   21 */ "ether_hdr",
  /*   22 */ "datagroup",
  /*   23 */ "deferred_isdn_hdr",
  /*   24 */ "isdn_hdr",
  /*   25 */ "wds_hdr",
  /*   26 */ "wds8_hdr",
  /*   27 */ "wdp7_hdr",
  /*   28 */ "wdp8_hdr",
  /*   29 */ "wdd_date",
  /*   30 */ "wdd_hdr",
  /*   31 */ "isdn_prefix",
  /*   32 */ "ether_prefix",
  /*   33 */ "wds_prefix",
  /*   34 */ "string",
  /*   35 */ "decnum",
  /*   36 */ "hexnum",
  /*   37 */ "wdd_decnum",
  /*   38 */ "byte",
  /*   39 */ "bytegroup",
  /*   40 */ "dataln",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "isdn_prefix ::= ISDN_PREFIX",
 /*   1 */ "ether_prefix ::= ETHER_PREFIX",
 /*   2 */ "wds_prefix ::= WDS_PREFIX",
 /*   3 */ "decnum ::= DECNUM",
 /*   4 */ "hexnum ::= HEXNUM",
 /*   5 */ "wdd_decnum ::= WDD_DECNUM",
 /*   6 */ "deferred_isdn_hdr ::= isdn_prefix decnum SLASH_SUFFIX KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM",
 /*   7 */ "isdn_hdr ::= isdn_prefix decnum KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM",
 /*   8 */ "ether_hdr ::= ether_prefix string KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM",
 /*   9 */ "wds_hdr ::= wds_prefix string decnum KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM",
 /*  10 */ "wds8_hdr ::= wds_prefix string decnum KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM",
 /*  11 */ "wdp7_hdr ::= wds_prefix decnum KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM",
 /*  12 */ "wdp8_hdr ::= wds_prefix decnum KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM",
 /*  13 */ "wdd_date ::= WDD_DATE wdd_decnum wdd_decnum wdd_decnum WDD_TIME wdd_decnum wdd_decnum wdd_decnum WDD_CAUSE WDD_CALLNUM",
 /*  14 */ "wdd_hdr ::= WDD_CHUNK hexnum KEYWORD KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM",
 /*  15 */ "byte ::= HEXBYTE",
 /*  16 */ "data_packet ::= ether_hdr datagroup",
 /*  17 */ "data_packet ::= deferred_isdn_hdr datagroup deferred_isdn_hdr datagroup",
 /*  18 */ "data_packet ::= isdn_hdr datagroup",
 /*  19 */ "data_packet ::= wds_hdr datagroup",
 /*  20 */ "data_packet ::= wds8_hdr datagroup",
 /*  21 */ "data_packet ::= wdp7_hdr datagroup",
 /*  22 */ "data_packet ::= wdp8_hdr datagroup",
 /*  23 */ "data_packet ::= wdd_date wdd_hdr datagroup",
 /*  24 */ "data_packet ::= wdd_hdr datagroup",
 /*  25 */ "string ::= STRING",
 /*  26 */ "bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte byte byte byte",
 /*  27 */ "bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte byte byte",
 /*  28 */ "bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte byte",
 /*  29 */ "bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte",
 /*  30 */ "bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte",
 /*  31 */ "bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte",
 /*  32 */ "bytegroup ::= byte byte byte byte byte byte byte byte byte byte",
 /*  33 */ "bytegroup ::= byte byte byte byte byte byte byte byte byte",
 /*  34 */ "bytegroup ::= byte byte byte byte byte byte byte byte",
 /*  35 */ "bytegroup ::= byte byte byte byte byte byte byte",
 /*  36 */ "bytegroup ::= byte byte byte byte byte byte",
 /*  37 */ "bytegroup ::= byte byte byte byte byte",
 /*  38 */ "bytegroup ::= byte byte byte byte",
 /*  39 */ "bytegroup ::= byte byte byte",
 /*  40 */ "bytegroup ::= byte byte",
 /*  41 */ "bytegroup ::= byte",
 /*  42 */ "dataln ::= COUNTER bytegroup",
 /*  43 */ "datagroup ::= dataln dataln dataln dataln dataln dataln dataln dataln",
 /*  44 */ "datagroup ::= dataln dataln dataln dataln dataln dataln dataln",
 /*  45 */ "datagroup ::= dataln dataln dataln dataln dataln dataln",
 /*  46 */ "datagroup ::= dataln dataln dataln dataln dataln",
 /*  47 */ "datagroup ::= dataln dataln dataln dataln",
 /*  48 */ "datagroup ::= dataln dataln dataln",
 /*  49 */ "datagroup ::= dataln dataln",
 /*  50 */ "datagroup ::= dataln",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0;
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to AscendParserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
static void AscendParserInit(void *yypRawParser AscendParserCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  AscendParserCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef AscendParser_ENGINEALWAYSONSTACK
/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to AscendParser and AscendParserFree.
*/
void *AscendParserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) AscendParserCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    AscendParserCTX_STORE
    AscendParserInit(yypParser AscendParserCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* AscendParser_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  AscendParserARG_FETCH
  AscendParserCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* TERMINAL Destructor */
    case 1: /* STRING */
    case 2: /* KEYWORD */
    case 3: /* WDD_DATE */
    case 4: /* WDD_DECNUM */
    case 5: /* WDD_TIME */
    case 6: /* WDD_CAUSE */
    case 7: /* WDD_CALLNUM */
    case 8: /* WDD_CHUNK */
    case 9: /* COUNTER */
    case 10: /* SLASH_SUFFIX */
    case 11: /* WDS_PREFIX */
    case 12: /* ISDN_PREFIX */
    case 13: /* ETHER_PREFIX */
    case 14: /* DECNUM */
    case 15: /* YEAR */
    case 16: /* MONTH */
    case 17: /* MDAY */
    case 18: /* HEXNUM */
    case 19: /* HEXBYTE */
{
#line 151 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"

    (void) parser_state;
    (void) yypminor;

#line 800 "./ascend_parser.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
static void AscendParserFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef AscendParser_ENGINEALWAYSONSTACK
/*
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void AscendParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  AscendParserFinalize(p);
  (*freeProc)(p);
}
#endif /* AscendParser_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int AscendParserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int AscendParserCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<(int)(sizeof(yy_action)/sizeof(yy_action[0])) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   AscendParserARG_FETCH
   AscendParserCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   AscendParserARG_STORE /* Suppress warning about unused %extra_argument var */
   AscendParserCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  AscendParserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
    31,  /* (0) isdn_prefix ::= ISDN_PREFIX */
    32,  /* (1) ether_prefix ::= ETHER_PREFIX */
    33,  /* (2) wds_prefix ::= WDS_PREFIX */
    35,  /* (3) decnum ::= DECNUM */
    36,  /* (4) hexnum ::= HEXNUM */
    37,  /* (5) wdd_decnum ::= WDD_DECNUM */
    23,  /* (6) deferred_isdn_hdr ::= isdn_prefix decnum SLASH_SUFFIX KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
    24,  /* (7) isdn_hdr ::= isdn_prefix decnum KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
    21,  /* (8) ether_hdr ::= ether_prefix string KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
    25,  /* (9) wds_hdr ::= wds_prefix string decnum KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
    26,  /* (10) wds8_hdr ::= wds_prefix string decnum KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
    27,  /* (11) wdp7_hdr ::= wds_prefix decnum KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
    28,  /* (12) wdp8_hdr ::= wds_prefix decnum KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
    29,  /* (13) wdd_date ::= WDD_DATE wdd_decnum wdd_decnum wdd_decnum WDD_TIME wdd_decnum wdd_decnum wdd_decnum WDD_CAUSE WDD_CALLNUM */
    30,  /* (14) wdd_hdr ::= WDD_CHUNK hexnum KEYWORD KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
    38,  /* (15) byte ::= HEXBYTE */
    20,  /* (16) data_packet ::= ether_hdr datagroup */
    20,  /* (17) data_packet ::= deferred_isdn_hdr datagroup deferred_isdn_hdr datagroup */
    20,  /* (18) data_packet ::= isdn_hdr datagroup */
    20,  /* (19) data_packet ::= wds_hdr datagroup */
    20,  /* (20) data_packet ::= wds8_hdr datagroup */
    20,  /* (21) data_packet ::= wdp7_hdr datagroup */
    20,  /* (22) data_packet ::= wdp8_hdr datagroup */
    20,  /* (23) data_packet ::= wdd_date wdd_hdr datagroup */
    20,  /* (24) data_packet ::= wdd_hdr datagroup */
    34,  /* (25) string ::= STRING */
    39,  /* (26) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte byte byte byte */
    39,  /* (27) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte byte byte */
    39,  /* (28) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte byte */
    39,  /* (29) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte */
    39,  /* (30) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte */
    39,  /* (31) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte */
    39,  /* (32) bytegroup ::= byte byte byte byte byte byte byte byte byte byte */
    39,  /* (33) bytegroup ::= byte byte byte byte byte byte byte byte byte */
    39,  /* (34) bytegroup ::= byte byte byte byte byte byte byte byte */
    39,  /* (35) bytegroup ::= byte byte byte byte byte byte byte */
    39,  /* (36) bytegroup ::= byte byte byte byte byte byte */
    39,  /* (37) bytegroup ::= byte byte byte byte byte */
    39,  /* (38) bytegroup ::= byte byte byte byte */
    39,  /* (39) bytegroup ::= byte byte byte */
    39,  /* (40) bytegroup ::= byte byte */
    39,  /* (41) bytegroup ::= byte */
    40,  /* (42) dataln ::= COUNTER bytegroup */
    22,  /* (43) datagroup ::= dataln dataln dataln dataln dataln dataln dataln dataln */
    22,  /* (44) datagroup ::= dataln dataln dataln dataln dataln dataln dataln */
    22,  /* (45) datagroup ::= dataln dataln dataln dataln dataln dataln */
    22,  /* (46) datagroup ::= dataln dataln dataln dataln dataln */
    22,  /* (47) datagroup ::= dataln dataln dataln dataln */
    22,  /* (48) datagroup ::= dataln dataln dataln */
    22,  /* (49) datagroup ::= dataln dataln */
    22,  /* (50) datagroup ::= dataln */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -1,  /* (0) isdn_prefix ::= ISDN_PREFIX */
   -1,  /* (1) ether_prefix ::= ETHER_PREFIX */
   -1,  /* (2) wds_prefix ::= WDS_PREFIX */
   -1,  /* (3) decnum ::= DECNUM */
   -1,  /* (4) hexnum ::= HEXNUM */
   -1,  /* (5) wdd_decnum ::= WDD_DECNUM */
  -13,  /* (6) deferred_isdn_hdr ::= isdn_prefix decnum SLASH_SUFFIX KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
  -12,  /* (7) isdn_hdr ::= isdn_prefix decnum KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
  -12,  /* (8) ether_hdr ::= ether_prefix string KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
  -11,  /* (9) wds_hdr ::= wds_prefix string decnum KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
  -13,  /* (10) wds8_hdr ::= wds_prefix string decnum KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
  -10,  /* (11) wdp7_hdr ::= wds_prefix decnum KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
  -12,  /* (12) wdp8_hdr ::= wds_prefix decnum KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
  -10,  /* (13) wdd_date ::= WDD_DATE wdd_decnum wdd_decnum wdd_decnum WDD_TIME wdd_decnum wdd_decnum wdd_decnum WDD_CAUSE WDD_CALLNUM */
  -11,  /* (14) wdd_hdr ::= WDD_CHUNK hexnum KEYWORD KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
   -1,  /* (15) byte ::= HEXBYTE */
   -2,  /* (16) data_packet ::= ether_hdr datagroup */
   -4,  /* (17) data_packet ::= deferred_isdn_hdr datagroup deferred_isdn_hdr datagroup */
   -2,  /* (18) data_packet ::= isdn_hdr datagroup */
   -2,  /* (19) data_packet ::= wds_hdr datagroup */
   -2,  /* (20) data_packet ::= wds8_hdr datagroup */
   -2,  /* (21) data_packet ::= wdp7_hdr datagroup */
   -2,  /* (22) data_packet ::= wdp8_hdr datagroup */
   -3,  /* (23) data_packet ::= wdd_date wdd_hdr datagroup */
   -2,  /* (24) data_packet ::= wdd_hdr datagroup */
   -1,  /* (25) string ::= STRING */
  -16,  /* (26) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte byte byte byte */
  -15,  /* (27) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte byte byte */
  -14,  /* (28) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte byte */
  -13,  /* (29) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte */
  -12,  /* (30) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte */
  -11,  /* (31) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte */
  -10,  /* (32) bytegroup ::= byte byte byte byte byte byte byte byte byte byte */
   -9,  /* (33) bytegroup ::= byte byte byte byte byte byte byte byte byte */
   -8,  /* (34) bytegroup ::= byte byte byte byte byte byte byte byte */
   -7,  /* (35) bytegroup ::= byte byte byte byte byte byte byte */
   -6,  /* (36) bytegroup ::= byte byte byte byte byte byte */
   -5,  /* (37) bytegroup ::= byte byte byte byte byte */
   -4,  /* (38) bytegroup ::= byte byte byte byte */
   -3,  /* (39) bytegroup ::= byte byte byte */
   -2,  /* (40) bytegroup ::= byte byte */
   -1,  /* (41) bytegroup ::= byte */
   -2,  /* (42) dataln ::= COUNTER bytegroup */
   -8,  /* (43) datagroup ::= dataln dataln dataln dataln dataln dataln dataln dataln */
   -7,  /* (44) datagroup ::= dataln dataln dataln dataln dataln dataln dataln */
   -6,  /* (45) datagroup ::= dataln dataln dataln dataln dataln dataln */
   -5,  /* (46) datagroup ::= dataln dataln dataln dataln dataln */
   -4,  /* (47) datagroup ::= dataln dataln dataln dataln */
   -3,  /* (48) datagroup ::= dataln dataln dataln */
   -2,  /* (49) datagroup ::= dataln dataln */
   -1,  /* (50) datagroup ::= dataln */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  AscendParserTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  AscendParserCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  AscendParserARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
  assert( yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* isdn_prefix ::= ISDN_PREFIX */
      case 1: /* ether_prefix ::= ETHER_PREFIX */ yytestcase(yyruleno==1);
      case 2: /* wds_prefix ::= WDS_PREFIX */ yytestcase(yyruleno==2);
#line 189 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{ yylhsminor.yy23 = yymsp[0].minor.yy0.u16_val; }
#line 1291 "./ascend_parser.c"
  yymsp[0].minor.yy23 = yylhsminor.yy23;
        break;
      case 3: /* decnum ::= DECNUM */
      case 4: /* hexnum ::= HEXNUM */ yytestcase(yyruleno==4);
      case 5: /* wdd_decnum ::= WDD_DECNUM */ yytestcase(yyruleno==5);
#line 200 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{ yylhsminor.yy43 = yymsp[0].minor.yy0.u32_val; }
#line 1299 "./ascend_parser.c"
  yymsp[0].minor.yy43 = yylhsminor.yy43;
        break;
      case 6: /* deferred_isdn_hdr ::= isdn_prefix decnum SLASH_SUFFIX KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
#line 220 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{
    parser_state->wirelen += yymsp[-2].minor.yy43;
    parser_state->secs = yymsp[-4].minor.yy43;
    parser_state->usecs = yymsp[-3].minor.yy43;
    if (parser_state->pseudo_header != NULL) {
        parser_state->pseudo_header->type = yymsp[-12].minor.yy23;
        parser_state->pseudo_header->sess = yymsp[-11].minor.yy43;
        parser_state->pseudo_header->call_num[0] = '\0';
        parser_state->pseudo_header->chunk = 0;
        parser_state->pseudo_header->task = yymsp[-6].minor.yy43;
    }
    /* because we have two data groups */
    parser_state->first_hexbyte = 0;
}
#line 1318 "./ascend_parser.c"
  yy_destructor(yypParser,10,&yymsp[-10].minor);
  yy_destructor(yypParser,2,&yymsp[-9].minor);
  yy_destructor(yypParser,2,&yymsp[-7].minor);
  yy_destructor(yypParser,2,&yymsp[-5].minor);
  yy_destructor(yypParser,2,&yymsp[-1].minor);
  yy_destructor(yypParser,18,&yymsp[0].minor);
        break;
      case 7: /* isdn_hdr ::= isdn_prefix decnum KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
#line 240 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{
    parser_state->wirelen += yymsp[-2].minor.yy43;
    parser_state->secs = yymsp[-4].minor.yy43;
    parser_state->usecs = yymsp[-3].minor.yy43;
    if (parser_state->pseudo_header != NULL) {
        parser_state->pseudo_header->type = yymsp[-11].minor.yy23;
        parser_state->pseudo_header->sess = yymsp[-10].minor.yy43;
        parser_state->pseudo_header->call_num[0] = '\0';
        parser_state->pseudo_header->chunk = 0;
        parser_state->pseudo_header->task = yymsp[-6].minor.yy43;
    }
    parser_state->first_hexbyte = 0;
}
#line 1341 "./ascend_parser.c"
  yy_destructor(yypParser,2,&yymsp[-9].minor);
  yy_destructor(yypParser,2,&yymsp[-7].minor);
  yy_destructor(yypParser,2,&yymsp[-5].minor);
  yy_destructor(yypParser,2,&yymsp[-1].minor);
  yy_destructor(yypParser,18,&yymsp[0].minor);
        break;
      case 8: /* ether_hdr ::= ether_prefix string KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
#line 258 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{
    parser_state->wirelen += yymsp[-2].minor.yy43;
    parser_state->secs = yymsp[-4].minor.yy43;
    parser_state->usecs = yymsp[-3].minor.yy43;
    if (parser_state->pseudo_header != NULL) {
        parser_state->pseudo_header->type = yymsp[-11].minor.yy23;
        parser_state->pseudo_header->call_num[0] = '\0';
        parser_state->pseudo_header->chunk = 0;
        parser_state->pseudo_header->task = yymsp[-6].minor.yy43;
    }
}
#line 1361 "./ascend_parser.c"
  yy_destructor(yypParser,2,&yymsp[-9].minor);
  yy_destructor(yypParser,2,&yymsp[-7].minor);
  yy_destructor(yypParser,2,&yymsp[-5].minor);
  yy_destructor(yypParser,2,&yymsp[-1].minor);
  yy_destructor(yypParser,18,&yymsp[0].minor);
        break;
      case 9: /* wds_hdr ::= wds_prefix string decnum KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
#line 272 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{
    parser_state->wirelen += yymsp[-2].minor.yy43;
    parser_state->secs = yymsp[-4].minor.yy43;
    parser_state->usecs = yymsp[-3].minor.yy43;
    if (parser_state->pseudo_header != NULL) {
        /* parser_state->pseudo_header->user is set in ascend_scanner.l */
        parser_state->pseudo_header->type = yymsp[-10].minor.yy23;
        parser_state->pseudo_header->sess = yymsp[-8].minor.yy43;
        parser_state->pseudo_header->call_num[0] = '\0';
        parser_state->pseudo_header->chunk = 0;
        parser_state->pseudo_header->task = yymsp[-6].minor.yy43;
    }
}
#line 1383 "./ascend_parser.c"
  yy_destructor(yypParser,2,&yymsp[-7].minor);
  yy_destructor(yypParser,2,&yymsp[-5].minor);
  yy_destructor(yypParser,2,&yymsp[-1].minor);
  yy_destructor(yypParser,18,&yymsp[0].minor);
        break;
      case 10: /* wds8_hdr ::= wds_prefix string decnum KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
#line 288 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{
    parser_state->wirelen += yymsp[-2].minor.yy43;
    parser_state->secs = yymsp[-4].minor.yy43;
    parser_state->usecs = yymsp[-3].minor.yy43;
    if (parser_state->pseudo_header != NULL) {
        /* parser_state->pseudo_header->user is set in ascend_scanner.l */
        parser_state->pseudo_header->type = yymsp[-12].minor.yy23;
        parser_state->pseudo_header->sess = yymsp[-10].minor.yy43;
        parser_state->pseudo_header->call_num[0] = '\0';
        parser_state->pseudo_header->chunk = 0;
        parser_state->pseudo_header->task = yymsp[-6].minor.yy43;
    }
}
#line 1404 "./ascend_parser.c"
  yy_destructor(yypParser,2,&yymsp[-9].minor);
  yy_destructor(yypParser,2,&yymsp[-7].minor);
  yy_destructor(yypParser,2,&yymsp[-5].minor);
  yy_destructor(yypParser,2,&yymsp[-1].minor);
  yy_destructor(yypParser,18,&yymsp[0].minor);
        break;
      case 11: /* wdp7_hdr ::= wds_prefix decnum KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
#line 304 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{
    parser_state->wirelen += yymsp[-2].minor.yy43;
    parser_state->secs = yymsp[-4].minor.yy43;
    parser_state->usecs = yymsp[-3].minor.yy43;
    if (parser_state->pseudo_header != NULL) {
        /* parser_state->pseudo_header->user is set in ascend_scanner.l */
        parser_state->pseudo_header->type = yymsp[-9].minor.yy23;
        parser_state->pseudo_header->sess = yymsp[-8].minor.yy43;
        parser_state->pseudo_header->call_num[0] = '\0';
        parser_state->pseudo_header->chunk = 0;
        parser_state->pseudo_header->task = yymsp[-6].minor.yy43;
    }
}
#line 1426 "./ascend_parser.c"
  yy_destructor(yypParser,2,&yymsp[-7].minor);
  yy_destructor(yypParser,2,&yymsp[-5].minor);
  yy_destructor(yypParser,2,&yymsp[-1].minor);
  yy_destructor(yypParser,18,&yymsp[0].minor);
        break;
      case 12: /* wdp8_hdr ::= wds_prefix decnum KEYWORD string KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
#line 320 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{
    parser_state->wirelen += yymsp[-2].minor.yy43;
    parser_state->secs = yymsp[-4].minor.yy43;
    parser_state->usecs = yymsp[-3].minor.yy43;
    if (parser_state->pseudo_header != NULL) {
        /* parser_state->pseudo_header->user is set in ascend_scanner.l */
        parser_state->pseudo_header->type = yymsp[-11].minor.yy23;
        parser_state->pseudo_header->sess = yymsp[-10].minor.yy43;
        parser_state->pseudo_header->call_num[0] = '\0';
        parser_state->pseudo_header->chunk = 0;
        parser_state->pseudo_header->task = yymsp[-6].minor.yy43;
    }
}
#line 1447 "./ascend_parser.c"
  yy_destructor(yypParser,2,&yymsp[-9].minor);
  yy_destructor(yypParser,2,&yymsp[-7].minor);
  yy_destructor(yypParser,2,&yymsp[-5].minor);
  yy_destructor(yypParser,2,&yymsp[-1].minor);
  yy_destructor(yypParser,18,&yymsp[0].minor);
        break;
      case 13: /* wdd_date ::= WDD_DATE wdd_decnum wdd_decnum wdd_decnum WDD_TIME wdd_decnum wdd_decnum wdd_decnum WDD_CAUSE WDD_CALLNUM */
{  yy_destructor(yypParser,3,&yymsp[-9].minor);
#line 339 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{
    /*
    * Supply the date/time value to the code above us; it will use the
    * first date/time value supplied as the capture start date/time.
    */
    struct tm wddt;

    wddt.tm_sec  = yymsp[-2].minor.yy43;
    wddt.tm_min  = yymsp[-3].minor.yy43;
    wddt.tm_hour = yymsp[-4].minor.yy43;
    wddt.tm_mday = yymsp[-7].minor.yy43;
    wddt.tm_mon  = yymsp[-8].minor.yy43 - 1;
    wddt.tm_year = (yymsp[-6].minor.yy43 > 1970) ? yymsp[-6].minor.yy43 - 1900 : 70;
    wddt.tm_isdst = -1;

    parser_state->timestamp = (guint32) mktime(&wddt);
    parser_state->saw_timestamp = TRUE;

    (void) g_strlcpy(parser_state->pseudo_header->call_num, yymsp[0].minor.yy0.str_val, ASCEND_MAX_STR_LEN);
}
#line 1477 "./ascend_parser.c"
  yy_destructor(yypParser,5,&yymsp[-5].minor);
  yy_destructor(yypParser,6,&yymsp[-1].minor);
}
        break;
      case 14: /* wdd_hdr ::= WDD_CHUNK hexnum KEYWORD KEYWORD hexnum KEYWORD decnum decnum decnum KEYWORD HEXNUM */
{  yy_destructor(yypParser,8,&yymsp[-10].minor);
#line 365 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{
    parser_state->wirelen = yymsp[-2].minor.yy43;
    parser_state->secs = yymsp[-4].minor.yy43;
    parser_state->usecs = yymsp[-3].minor.yy43;
    if (parser_state->pseudo_header != NULL) {
        parser_state->pseudo_header->type = ASCEND_PFX_WDD;
        parser_state->pseudo_header->user[0] = '\0';
        parser_state->pseudo_header->sess = 0;
        parser_state->pseudo_header->chunk = yymsp[-9].minor.yy43;
        parser_state->pseudo_header->task = yymsp[-6].minor.yy43;
    }
}
#line 1497 "./ascend_parser.c"
  yy_destructor(yypParser,2,&yymsp[-8].minor);
  yy_destructor(yypParser,2,&yymsp[-7].minor);
  yy_destructor(yypParser,2,&yymsp[-5].minor);
  yy_destructor(yypParser,2,&yymsp[-1].minor);
  yy_destructor(yypParser,18,&yymsp[0].minor);
}
        break;
      case 15: /* byte ::= HEXBYTE */
#line 378 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{
    /* remember the position of the data group in the trace, to tip off
        ascend_find_next_packet() as to where to look for the next header. */
    if (parser_state->first_hexbyte == 0) {
        parser_state->first_hexbyte = file_tell(parser_state->fh) - yymsp[0].minor.yy0.length;
    }

    /* XXX - if this test fails, it means that we parsed more bytes than
        the header claimed there were. */
    if (parser_state->caplen < parser_state->wirelen) {
        parser_state->pkt_data[parser_state->caplen] = yymsp[0].minor.yy0.u8_val;
        parser_state->caplen++;
    }
}
#line 1521 "./ascend_parser.c"
        break;
      case 25: /* string ::= STRING */
{  yy_destructor(yypParser,1,&yymsp[0].minor);
#line 197 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{
}
#line 1528 "./ascend_parser.c"
}
        break;
      case 42: /* dataln ::= COUNTER bytegroup */
{  yy_destructor(yypParser,9,&yymsp[-1].minor);
#line 411 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"
{
}
#line 1536 "./ascend_parser.c"
}
        break;
      default:
      /* (16) data_packet ::= ether_hdr datagroup */ yytestcase(yyruleno==16);
      /* (17) data_packet ::= deferred_isdn_hdr datagroup deferred_isdn_hdr datagroup */ yytestcase(yyruleno==17);
      /* (18) data_packet ::= isdn_hdr datagroup */ yytestcase(yyruleno==18);
      /* (19) data_packet ::= wds_hdr datagroup */ yytestcase(yyruleno==19);
      /* (20) data_packet ::= wds8_hdr datagroup */ yytestcase(yyruleno==20);
      /* (21) data_packet ::= wdp7_hdr datagroup */ yytestcase(yyruleno==21);
      /* (22) data_packet ::= wdp8_hdr datagroup */ yytestcase(yyruleno==22);
      /* (23) data_packet ::= wdd_date wdd_hdr datagroup */ yytestcase(yyruleno==23);
      /* (24) data_packet ::= wdd_hdr datagroup */ yytestcase(yyruleno==24);
      /* (26) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte byte byte byte */ yytestcase(yyruleno==26);
      /* (27) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte byte byte */ yytestcase(yyruleno==27);
      /* (28) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte byte */ yytestcase(yyruleno==28);
      /* (29) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte byte */ yytestcase(yyruleno==29);
      /* (30) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte byte */ yytestcase(yyruleno==30);
      /* (31) bytegroup ::= byte byte byte byte byte byte byte byte byte byte byte */ yytestcase(yyruleno==31);
      /* (32) bytegroup ::= byte byte byte byte byte byte byte byte byte byte */ yytestcase(yyruleno==32);
      /* (33) bytegroup ::= byte byte byte byte byte byte byte byte byte */ yytestcase(yyruleno==33);
      /* (34) bytegroup ::= byte byte byte byte byte byte byte byte */ yytestcase(yyruleno==34);
      /* (35) bytegroup ::= byte byte byte byte byte byte byte */ yytestcase(yyruleno==35);
      /* (36) bytegroup ::= byte byte byte byte byte byte */ yytestcase(yyruleno==36);
      /* (37) bytegroup ::= byte byte byte byte byte */ yytestcase(yyruleno==37);
      /* (38) bytegroup ::= byte byte byte byte */ yytestcase(yyruleno==38);
      /* (39) bytegroup ::= byte byte byte */ yytestcase(yyruleno==39);
      /* (40) bytegroup ::= byte byte */ yytestcase(yyruleno==40);
      /* (41) bytegroup ::= byte */ yytestcase(yyruleno==41);
      /* (43) datagroup ::= dataln dataln dataln dataln dataln dataln dataln dataln */ yytestcase(yyruleno==43);
      /* (44) datagroup ::= dataln dataln dataln dataln dataln dataln dataln */ yytestcase(yyruleno==44);
      /* (45) datagroup ::= dataln dataln dataln dataln dataln dataln */ yytestcase(yyruleno==45);
      /* (46) datagroup ::= dataln dataln dataln dataln dataln */ yytestcase(yyruleno==46);
      /* (47) datagroup ::= dataln dataln dataln dataln */ yytestcase(yyruleno==47);
      /* (48) datagroup ::= dataln dataln dataln */ yytestcase(yyruleno==48);
      /* (49) datagroup ::= dataln dataln */ yytestcase(yyruleno==49);
      /* (50) datagroup ::= dataln */ yytestcase(yyruleno==50);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  AscendParserARG_FETCH
  AscendParserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  AscendParserARG_STORE /* Suppress warning about unused %extra_argument variable */
  AscendParserCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor _U_,               /* The major type of the error token */
  AscendParserTOKENTYPE yyminor         /* The minor type of the error token */
){
  AscendParserARG_FETCH
  AscendParserCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 423 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"

    /*
    * We might be parsing output that includes console session output along
    * with packet dumps.
    */
    (void)yypParser;
    (void)yyminor;
    static char *err = "non-packet data";

    parser_state->ascend_parse_error = err;
#line 1643 "./ascend_parser.c"
/************ End %syntax_error code ******************************************/
  AscendParserARG_STORE /* Suppress warning about unused %extra_argument variable */
  AscendParserCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  AscendParserARG_FETCH
  AscendParserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  AscendParserARG_STORE /* Suppress warning about unused %extra_argument variable */
  AscendParserCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "AscendParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void AscendParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  AscendParserTOKENTYPE yyminor       /* The value for the token */
  AscendParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  AscendParserCTX_FETCH
  AscendParserARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor AscendParserCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

#if 0
/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int AscendParserFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
#endif
#line 435 "/build/wireshark/src/wireshark-3.6.7/wiretap/ascend_parser.lemon"


/* Run the parser. */
bool
run_ascend_parser(guint8 *pd, ascend_state_t *parser_state, int *err, gchar **err_info)
{
    yyscan_t scanner = NULL;
    void *parser;

    if (ascend_lex_init(&scanner) != 0) {
        /* errno is set if this fails */
        *err = errno;
        *err_info = NULL;
        return false;
    }
    /* Associate the parser state with the lexical analyzer state */
    ascend_set_extra(parser_state, scanner);
    parser_state->ascend_parse_error = NULL;
    parser_state->err = 0;
    parser_state->err_info = NULL;
    parser_state->pkt_data = pd;

    /*
    * We haven't seen a time stamp yet.
    */
    parser_state->saw_timestamp = FALSE;
    parser_state->timestamp = 0;

    parser_state->first_hexbyte = 0;
    parser_state->caplen = 0;
    parser_state->wirelen = 0;

    parser_state->secs = 0;
    parser_state->usecs = 0;

    /*
    * Not all packets in a "wdd" dump necessarily have a "Cause an
    * attempt to place call to" header (I presume this can happen if
    * there was a call in progress when the packet was sent or
    * received), so we won't necessarily have the phone number for
    * the packet.
    *
    * XXX - we could assume, in the sequential pass, that it's the
    * phone number from the last call, and remember that for use
    * when doing random access.
    */
    parser_state->pseudo_header->call_num[0] = '\0';

    parser = AscendParserAlloc(g_malloc);

#ifdef ASCEND_PARSER_DEBUG
    AscendParserTrace(stderr, "=AP ");
#endif

    int token_id;
    do {
        token_id = ascend_lex(scanner);

        ascend_debug("Got token %d at %" G_GINT64_MODIFIER "d", token_id, file_tell(parser_state->fh));

        AscendParser(parser, token_id, parser_state->token, parser_state);
    } while (token_id && !parser_state->err && !parser_state->ascend_parse_error && parser_state->caplen < ASCEND_MAX_PKT_LEN);

    AscendParserFree(parser, g_free);
    ascend_lex_destroy(scanner);

    if (parser_state->err) {
        *err = parser_state->err;
        *err_info = parser_state->err_info;
        return false;
    }

    return true;
}

#line 1954 "./ascend_parser.c"
