/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.imageio;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.apache.tools.ant.types.optional.imageio.DrawOperation;
import org.apache.tools.ant.types.optional.imageio.ImageOperation;
import org.apache.tools.ant.types.optional.imageio.TransformOperation;

public class Rotate
extends TransformOperation
implements DrawOperation {
    private static final float HALF_CIRCLE = 180.0f;
    private float angle = 0.0f;

    public void setAngle(String ang) {
        this.angle = Float.parseFloat(ang) % 360.0f;
    }

    public BufferedImage performRotate(BufferedImage image) {
        if (Float.compare(Math.abs(this.angle), 0.0f) == 0) {
            return image;
        }
        if (this.angle < 0.0f) {
            this.angle += 360.0f;
        }
        if (Float.compare(this.angle, 180.0f) == 0) {
            this.log("Flipping an image", 4);
            AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
            tx.translate(-image.getWidth(null), -image.getHeight(null));
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            return op.filter(image, null);
        }
        AffineTransform tx = AffineTransform.getRotateInstance((float)((double)this.angle * (Math.PI / 180)));
        Rectangle2D box = this.getBoundingBox(image, tx);
        AffineTransform translation = AffineTransform.getTranslateInstance(-box.getMinX(), -box.getMinY());
        tx.preConcatenate(translation);
        BufferedImage rotatedImage = new BufferedImage((int)Math.round(box.getWidth()), (int)Math.round(box.getHeight()), image.getType());
        Graphics2D graphics = rotatedImage.createGraphics();
        graphics.setPaint(new Color(image.getRGB(0, 0)));
        graphics.fillRect(0, 0, rotatedImage.getWidth(), rotatedImage.getHeight());
        graphics.dispose();
        AffineTransformOp rotateOp = new AffineTransformOp(tx, 2);
        rotateOp.filter(image, rotatedImage);
        return rotatedImage;
    }

    private Rectangle2D getBoundingBox(BufferedImage image, AffineTransform tx) {
        int xmax = image.getWidth() - 1;
        int ymax = image.getHeight() - 1;
        Point2D[] corners = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(xmax, 0.0), new Point2D.Double(xmax, ymax), new Point2D.Double(0.0, ymax)};
        tx.transform(corners, 0, corners, 0, 4);
        Rectangle2D.Double boundingBox = new Rectangle2D.Double();
        Arrays.stream(corners, 0, 4).forEach(boundingBox::add);
        return boundingBox;
    }

    @Override
    public BufferedImage executeTransformOperation(BufferedImage image) {
        for (ImageOperation instr : this.instructions) {
            if (instr instanceof DrawOperation) {
                BufferedImage op = ((DrawOperation)((Object)instr)).executeDrawOperation();
                return this.performRotate(op);
            }
            if (!(instr instanceof TransformOperation)) continue;
            image = ((TransformOperation)instr).executeTransformOperation(image);
        }
        image = this.performRotate(image);
        return image;
    }

    @Override
    public BufferedImage executeDrawOperation() {
        for (ImageOperation instr : this.instructions) {
            if (!(instr instanceof DrawOperation)) continue;
            BufferedImage op = ((DrawOperation)((Object)instr)).executeDrawOperation();
            return this.performRotate(op);
        }
        return null;
    }
}

