/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         aalogparse_parse
#define yylex           aalogparse_lex
#define yyerror         aalogparse_error
#define yydebug         aalogparse_debug
#define yynerrs         aalogparse_nerrs

/* First part of user prologue.  */
#line 19 "grammar.y"


/* set the following to non-zero to get bison to emit debugging
 * information about tokens given and rules matched.
 * Also:
 *   Uncomment the %defines
 *   parse.error
 *   parse.trace
 */
#define YYDEBUG 0
#include <string.h>
#include <aalogparse.h>
#include "parser.h"
#include "grammar.h"
#include "scanner.h"

#ifndef unused_
#define unused_ __attribute__ ((unused))
#endif
#if (YYDEBUG != 0)
#define debug_unused_ /* nothing */
#else
#define debug_unused_ unused_
#endif

aa_log_record *ret_record;

/* Since we're a library, on any errors we don't want to print out any
 * error messages. We should probably add a debug interface that does
 * emit messages when asked for. */
void aalogparse_error(unused_ void *scanner, debug_unused_ char const *s)
{
#if (YYDEBUG != 0)
	printf("ERROR: %s\n", s);
#endif
	ret_record->event = AA_RECORD_INVALID;
}

struct aa_type_table {
	unsigned int audit_type;
	aa_record_event_type event;
};

static struct aa_type_table aa_type_table[] = {
	{AUDIT_APPARMOR_AUDIT,   AA_RECORD_AUDIT},
	{AUDIT_APPARMOR_ALLOWED, AA_RECORD_ALLOWED},
	{AUDIT_APPARMOR_DENIED,  AA_RECORD_DENIED},
	{AUDIT_APPARMOR_HINT,    AA_RECORD_HINT},
	{AUDIT_APPARMOR_STATUS,  AA_RECORD_STATUS},
	{AUDIT_APPARMOR_ERROR,   AA_RECORD_ERROR},
	{0,                      AA_RECORD_INVALID},
};

aa_record_event_type lookup_aa_event(unsigned int type)
{
	int i;

	for (i = 0; aa_type_table[i].audit_type != 0; i++)
		if (type == aa_type_table[i].audit_type)
			break;

	return aa_type_table[i].event;
}



#line 143 "grammar.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_AALOGPARSE_GRAMMAR_H_INCLUDED
# define YY_AALOGPARSE_GRAMMAR_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int aalogparse_debug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    TOK_DIGITS = 258,              /* TOK_DIGITS  */
    TOK_TYPE_UNKNOWN = 259,        /* TOK_TYPE_UNKNOWN  */
    TOK_QUOTED_STRING = 260,       /* TOK_QUOTED_STRING  */
    TOK_ID = 261,                  /* TOK_ID  */
    TOK_MODE = 262,                /* TOK_MODE  */
    TOK_DMESG_STAMP = 263,         /* TOK_DMESG_STAMP  */
    TOK_AUDIT_DIGITS = 264,        /* TOK_AUDIT_DIGITS  */
    TOK_DATE_MONTH = 265,          /* TOK_DATE_MONTH  */
    TOK_DATE = 266,                /* TOK_DATE  */
    TOK_TIME = 267,                /* TOK_TIME  */
    TOK_HEXSTRING = 268,           /* TOK_HEXSTRING  */
    TOK_TYPE_OTHER = 269,          /* TOK_TYPE_OTHER  */
    TOK_MSG_REST = 270,            /* TOK_MSG_REST  */
    TOK_IP_ADDR = 271,             /* TOK_IP_ADDR  */
    TOK_EQUALS = 272,              /* TOK_EQUALS  */
    TOK_COLON = 273,               /* TOK_COLON  */
    TOK_MINUS = 274,               /* TOK_MINUS  */
    TOK_OPEN_PAREN = 275,          /* TOK_OPEN_PAREN  */
    TOK_CLOSE_PAREN = 276,         /* TOK_CLOSE_PAREN  */
    TOK_PERIOD = 277,              /* TOK_PERIOD  */
    TOK_QUESTION_MARK = 278,       /* TOK_QUESTION_MARK  */
    TOK_SINGLE_QUOTE = 279,        /* TOK_SINGLE_QUOTE  */
    TOK_TYPE_REJECT = 280,         /* TOK_TYPE_REJECT  */
    TOK_TYPE_AUDIT = 281,          /* TOK_TYPE_AUDIT  */
    TOK_TYPE_COMPLAIN = 282,       /* TOK_TYPE_COMPLAIN  */
    TOK_TYPE_HINT = 283,           /* TOK_TYPE_HINT  */
    TOK_TYPE_STATUS = 284,         /* TOK_TYPE_STATUS  */
    TOK_TYPE_ERROR = 285,          /* TOK_TYPE_ERROR  */
    TOK_TYPE_AA_REJECT = 286,      /* TOK_TYPE_AA_REJECT  */
    TOK_TYPE_AA_AUDIT = 287,       /* TOK_TYPE_AA_AUDIT  */
    TOK_TYPE_AA_COMPLAIN = 288,    /* TOK_TYPE_AA_COMPLAIN  */
    TOK_TYPE_AA_HINT = 289,        /* TOK_TYPE_AA_HINT  */
    TOK_TYPE_AA_STATUS = 290,      /* TOK_TYPE_AA_STATUS  */
    TOK_TYPE_AA_ERROR = 291,       /* TOK_TYPE_AA_ERROR  */
    TOK_TYPE_LSM_AVC = 292,        /* TOK_TYPE_LSM_AVC  */
    TOK_TYPE_USER_AVC = 293,       /* TOK_TYPE_USER_AVC  */
    TOK_KEY_APPARMOR = 294,        /* TOK_KEY_APPARMOR  */
    TOK_KEY_TYPE = 295,            /* TOK_KEY_TYPE  */
    TOK_KEY_MSG = 296,             /* TOK_KEY_MSG  */
    TOK_KEY_OPERATION = 297,       /* TOK_KEY_OPERATION  */
    TOK_KEY_NAME = 298,            /* TOK_KEY_NAME  */
    TOK_KEY_NAME2 = 299,           /* TOK_KEY_NAME2  */
    TOK_KEY_MASK = 300,            /* TOK_KEY_MASK  */
    TOK_KEY_DENIED_MASK = 301,     /* TOK_KEY_DENIED_MASK  */
    TOK_KEY_REQUESTED_MASK = 302,  /* TOK_KEY_REQUESTED_MASK  */
    TOK_KEY_ATTRIBUTE = 303,       /* TOK_KEY_ATTRIBUTE  */
    TOK_KEY_TASK = 304,            /* TOK_KEY_TASK  */
    TOK_KEY_PARENT = 305,          /* TOK_KEY_PARENT  */
    TOK_KEY_MAGIC_TOKEN = 306,     /* TOK_KEY_MAGIC_TOKEN  */
    TOK_KEY_INFO = 307,            /* TOK_KEY_INFO  */
    TOK_KEY_PEER_INFO = 308,       /* TOK_KEY_PEER_INFO  */
    TOK_KEY_PID = 309,             /* TOK_KEY_PID  */
    TOK_KEY_PEER_PID = 310,        /* TOK_KEY_PEER_PID  */
    TOK_KEY_PROFILE = 311,         /* TOK_KEY_PROFILE  */
    TOK_KEY_PEER_PROFILE = 312,    /* TOK_KEY_PEER_PROFILE  */
    TOK_KEY_LABEL = 313,           /* TOK_KEY_LABEL  */
    TOK_KEY_PEER_LABEL = 314,      /* TOK_KEY_PEER_LABEL  */
    TOK_KEY_PEER = 315,            /* TOK_KEY_PEER  */
    TOK_AUDIT = 316,               /* TOK_AUDIT  */
    TOK_KEY_FAMILY = 317,          /* TOK_KEY_FAMILY  */
    TOK_KEY_SOCK_TYPE = 318,       /* TOK_KEY_SOCK_TYPE  */
    TOK_KEY_PROTOCOL = 319,        /* TOK_KEY_PROTOCOL  */
    TOK_KEY_NAMESPACE = 320,       /* TOK_KEY_NAMESPACE  */
    TOK_KEY_ERROR = 321,           /* TOK_KEY_ERROR  */
    TOK_KEY_FSUID = 322,           /* TOK_KEY_FSUID  */
    TOK_KEY_OUID = 323,            /* TOK_KEY_OUID  */
    TOK_KEY_UID = 324,             /* TOK_KEY_UID  */
    TOK_KEY_AUID = 325,            /* TOK_KEY_AUID  */
    TOK_KEY_SAUID = 326,           /* TOK_KEY_SAUID  */
    TOK_KEY_SES = 327,             /* TOK_KEY_SES  */
    TOK_KEY_HOSTNAME = 328,        /* TOK_KEY_HOSTNAME  */
    TOK_KEY_ADDR = 329,            /* TOK_KEY_ADDR  */
    TOK_KEY_TERMINAL = 330,        /* TOK_KEY_TERMINAL  */
    TOK_KEY_EXE = 331,             /* TOK_KEY_EXE  */
    TOK_KEY_COMM = 332,            /* TOK_KEY_COMM  */
    TOK_KEY_CAPABILITY = 333,      /* TOK_KEY_CAPABILITY  */
    TOK_KEY_CAPNAME = 334,         /* TOK_KEY_CAPNAME  */
    TOK_KEY_OFFSET = 335,          /* TOK_KEY_OFFSET  */
    TOK_KEY_TARGET = 336,          /* TOK_KEY_TARGET  */
    TOK_KEY_LADDR = 337,           /* TOK_KEY_LADDR  */
    TOK_KEY_FADDR = 338,           /* TOK_KEY_FADDR  */
    TOK_KEY_LPORT = 339,           /* TOK_KEY_LPORT  */
    TOK_KEY_FPORT = 340,           /* TOK_KEY_FPORT  */
    TOK_KEY_BUS = 341,             /* TOK_KEY_BUS  */
    TOK_KEY_PATH = 342,            /* TOK_KEY_PATH  */
    TOK_KEY_INTERFACE = 343,       /* TOK_KEY_INTERFACE  */
    TOK_KEY_MEMBER = 344,          /* TOK_KEY_MEMBER  */
    TOK_KEY_SIGNAL = 345,          /* TOK_KEY_SIGNAL  */
    TOK_KEY_FSTYPE = 346,          /* TOK_KEY_FSTYPE  */
    TOK_KEY_FLAGS = 347,           /* TOK_KEY_FLAGS  */
    TOK_KEY_SRCNAME = 348,         /* TOK_KEY_SRCNAME  */
    TOK_SOCKLOGD_KERNEL = 349,     /* TOK_SOCKLOGD_KERNEL  */
    TOK_SYSLOG_KERNEL = 350,       /* TOK_SYSLOG_KERNEL  */
    TOK_SYSLOG_USER = 351          /* TOK_SYSLOG_USER  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define TOK_DIGITS 258
#define TOK_TYPE_UNKNOWN 259
#define TOK_QUOTED_STRING 260
#define TOK_ID 261
#define TOK_MODE 262
#define TOK_DMESG_STAMP 263
#define TOK_AUDIT_DIGITS 264
#define TOK_DATE_MONTH 265
#define TOK_DATE 266
#define TOK_TIME 267
#define TOK_HEXSTRING 268
#define TOK_TYPE_OTHER 269
#define TOK_MSG_REST 270
#define TOK_IP_ADDR 271
#define TOK_EQUALS 272
#define TOK_COLON 273
#define TOK_MINUS 274
#define TOK_OPEN_PAREN 275
#define TOK_CLOSE_PAREN 276
#define TOK_PERIOD 277
#define TOK_QUESTION_MARK 278
#define TOK_SINGLE_QUOTE 279
#define TOK_TYPE_REJECT 280
#define TOK_TYPE_AUDIT 281
#define TOK_TYPE_COMPLAIN 282
#define TOK_TYPE_HINT 283
#define TOK_TYPE_STATUS 284
#define TOK_TYPE_ERROR 285
#define TOK_TYPE_AA_REJECT 286
#define TOK_TYPE_AA_AUDIT 287
#define TOK_TYPE_AA_COMPLAIN 288
#define TOK_TYPE_AA_HINT 289
#define TOK_TYPE_AA_STATUS 290
#define TOK_TYPE_AA_ERROR 291
#define TOK_TYPE_LSM_AVC 292
#define TOK_TYPE_USER_AVC 293
#define TOK_KEY_APPARMOR 294
#define TOK_KEY_TYPE 295
#define TOK_KEY_MSG 296
#define TOK_KEY_OPERATION 297
#define TOK_KEY_NAME 298
#define TOK_KEY_NAME2 299
#define TOK_KEY_MASK 300
#define TOK_KEY_DENIED_MASK 301
#define TOK_KEY_REQUESTED_MASK 302
#define TOK_KEY_ATTRIBUTE 303
#define TOK_KEY_TASK 304
#define TOK_KEY_PARENT 305
#define TOK_KEY_MAGIC_TOKEN 306
#define TOK_KEY_INFO 307
#define TOK_KEY_PEER_INFO 308
#define TOK_KEY_PID 309
#define TOK_KEY_PEER_PID 310
#define TOK_KEY_PROFILE 311
#define TOK_KEY_PEER_PROFILE 312
#define TOK_KEY_LABEL 313
#define TOK_KEY_PEER_LABEL 314
#define TOK_KEY_PEER 315
#define TOK_AUDIT 316
#define TOK_KEY_FAMILY 317
#define TOK_KEY_SOCK_TYPE 318
#define TOK_KEY_PROTOCOL 319
#define TOK_KEY_NAMESPACE 320
#define TOK_KEY_ERROR 321
#define TOK_KEY_FSUID 322
#define TOK_KEY_OUID 323
#define TOK_KEY_UID 324
#define TOK_KEY_AUID 325
#define TOK_KEY_SAUID 326
#define TOK_KEY_SES 327
#define TOK_KEY_HOSTNAME 328
#define TOK_KEY_ADDR 329
#define TOK_KEY_TERMINAL 330
#define TOK_KEY_EXE 331
#define TOK_KEY_COMM 332
#define TOK_KEY_CAPABILITY 333
#define TOK_KEY_CAPNAME 334
#define TOK_KEY_OFFSET 335
#define TOK_KEY_TARGET 336
#define TOK_KEY_LADDR 337
#define TOK_KEY_FADDR 338
#define TOK_KEY_LPORT 339
#define TOK_KEY_FPORT 340
#define TOK_KEY_BUS 341
#define TOK_KEY_PATH 342
#define TOK_KEY_INTERFACE 343
#define TOK_KEY_MEMBER 344
#define TOK_KEY_SIGNAL 345
#define TOK_KEY_FSTYPE 346
#define TOK_KEY_FLAGS 347
#define TOK_KEY_SRCNAME 348
#define TOK_SOCKLOGD_KERNEL 349
#define TOK_SYSLOG_KERNEL 350
#define TOK_SYSLOG_USER 351

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 97 "grammar.y"

	char	*t_str;
	long	t_long;

#line 393 "grammar.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif




int aalogparse_parse (void *scanner);


#endif /* !YY_AALOGPARSE_GRAMMAR_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TOK_DIGITS = 3,                 /* TOK_DIGITS  */
  YYSYMBOL_TOK_TYPE_UNKNOWN = 4,           /* TOK_TYPE_UNKNOWN  */
  YYSYMBOL_TOK_QUOTED_STRING = 5,          /* TOK_QUOTED_STRING  */
  YYSYMBOL_TOK_ID = 6,                     /* TOK_ID  */
  YYSYMBOL_TOK_MODE = 7,                   /* TOK_MODE  */
  YYSYMBOL_TOK_DMESG_STAMP = 8,            /* TOK_DMESG_STAMP  */
  YYSYMBOL_TOK_AUDIT_DIGITS = 9,           /* TOK_AUDIT_DIGITS  */
  YYSYMBOL_TOK_DATE_MONTH = 10,            /* TOK_DATE_MONTH  */
  YYSYMBOL_TOK_DATE = 11,                  /* TOK_DATE  */
  YYSYMBOL_TOK_TIME = 12,                  /* TOK_TIME  */
  YYSYMBOL_TOK_HEXSTRING = 13,             /* TOK_HEXSTRING  */
  YYSYMBOL_TOK_TYPE_OTHER = 14,            /* TOK_TYPE_OTHER  */
  YYSYMBOL_TOK_MSG_REST = 15,              /* TOK_MSG_REST  */
  YYSYMBOL_TOK_IP_ADDR = 16,               /* TOK_IP_ADDR  */
  YYSYMBOL_TOK_EQUALS = 17,                /* TOK_EQUALS  */
  YYSYMBOL_TOK_COLON = 18,                 /* TOK_COLON  */
  YYSYMBOL_TOK_MINUS = 19,                 /* TOK_MINUS  */
  YYSYMBOL_TOK_OPEN_PAREN = 20,            /* TOK_OPEN_PAREN  */
  YYSYMBOL_TOK_CLOSE_PAREN = 21,           /* TOK_CLOSE_PAREN  */
  YYSYMBOL_TOK_PERIOD = 22,                /* TOK_PERIOD  */
  YYSYMBOL_TOK_QUESTION_MARK = 23,         /* TOK_QUESTION_MARK  */
  YYSYMBOL_TOK_SINGLE_QUOTE = 24,          /* TOK_SINGLE_QUOTE  */
  YYSYMBOL_TOK_TYPE_REJECT = 25,           /* TOK_TYPE_REJECT  */
  YYSYMBOL_TOK_TYPE_AUDIT = 26,            /* TOK_TYPE_AUDIT  */
  YYSYMBOL_TOK_TYPE_COMPLAIN = 27,         /* TOK_TYPE_COMPLAIN  */
  YYSYMBOL_TOK_TYPE_HINT = 28,             /* TOK_TYPE_HINT  */
  YYSYMBOL_TOK_TYPE_STATUS = 29,           /* TOK_TYPE_STATUS  */
  YYSYMBOL_TOK_TYPE_ERROR = 30,            /* TOK_TYPE_ERROR  */
  YYSYMBOL_TOK_TYPE_AA_REJECT = 31,        /* TOK_TYPE_AA_REJECT  */
  YYSYMBOL_TOK_TYPE_AA_AUDIT = 32,         /* TOK_TYPE_AA_AUDIT  */
  YYSYMBOL_TOK_TYPE_AA_COMPLAIN = 33,      /* TOK_TYPE_AA_COMPLAIN  */
  YYSYMBOL_TOK_TYPE_AA_HINT = 34,          /* TOK_TYPE_AA_HINT  */
  YYSYMBOL_TOK_TYPE_AA_STATUS = 35,        /* TOK_TYPE_AA_STATUS  */
  YYSYMBOL_TOK_TYPE_AA_ERROR = 36,         /* TOK_TYPE_AA_ERROR  */
  YYSYMBOL_TOK_TYPE_LSM_AVC = 37,          /* TOK_TYPE_LSM_AVC  */
  YYSYMBOL_TOK_TYPE_USER_AVC = 38,         /* TOK_TYPE_USER_AVC  */
  YYSYMBOL_TOK_KEY_APPARMOR = 39,          /* TOK_KEY_APPARMOR  */
  YYSYMBOL_TOK_KEY_TYPE = 40,              /* TOK_KEY_TYPE  */
  YYSYMBOL_TOK_KEY_MSG = 41,               /* TOK_KEY_MSG  */
  YYSYMBOL_TOK_KEY_OPERATION = 42,         /* TOK_KEY_OPERATION  */
  YYSYMBOL_TOK_KEY_NAME = 43,              /* TOK_KEY_NAME  */
  YYSYMBOL_TOK_KEY_NAME2 = 44,             /* TOK_KEY_NAME2  */
  YYSYMBOL_TOK_KEY_MASK = 45,              /* TOK_KEY_MASK  */
  YYSYMBOL_TOK_KEY_DENIED_MASK = 46,       /* TOK_KEY_DENIED_MASK  */
  YYSYMBOL_TOK_KEY_REQUESTED_MASK = 47,    /* TOK_KEY_REQUESTED_MASK  */
  YYSYMBOL_TOK_KEY_ATTRIBUTE = 48,         /* TOK_KEY_ATTRIBUTE  */
  YYSYMBOL_TOK_KEY_TASK = 49,              /* TOK_KEY_TASK  */
  YYSYMBOL_TOK_KEY_PARENT = 50,            /* TOK_KEY_PARENT  */
  YYSYMBOL_TOK_KEY_MAGIC_TOKEN = 51,       /* TOK_KEY_MAGIC_TOKEN  */
  YYSYMBOL_TOK_KEY_INFO = 52,              /* TOK_KEY_INFO  */
  YYSYMBOL_TOK_KEY_PEER_INFO = 53,         /* TOK_KEY_PEER_INFO  */
  YYSYMBOL_TOK_KEY_PID = 54,               /* TOK_KEY_PID  */
  YYSYMBOL_TOK_KEY_PEER_PID = 55,          /* TOK_KEY_PEER_PID  */
  YYSYMBOL_TOK_KEY_PROFILE = 56,           /* TOK_KEY_PROFILE  */
  YYSYMBOL_TOK_KEY_PEER_PROFILE = 57,      /* TOK_KEY_PEER_PROFILE  */
  YYSYMBOL_TOK_KEY_LABEL = 58,             /* TOK_KEY_LABEL  */
  YYSYMBOL_TOK_KEY_PEER_LABEL = 59,        /* TOK_KEY_PEER_LABEL  */
  YYSYMBOL_TOK_KEY_PEER = 60,              /* TOK_KEY_PEER  */
  YYSYMBOL_TOK_AUDIT = 61,                 /* TOK_AUDIT  */
  YYSYMBOL_TOK_KEY_FAMILY = 62,            /* TOK_KEY_FAMILY  */
  YYSYMBOL_TOK_KEY_SOCK_TYPE = 63,         /* TOK_KEY_SOCK_TYPE  */
  YYSYMBOL_TOK_KEY_PROTOCOL = 64,          /* TOK_KEY_PROTOCOL  */
  YYSYMBOL_TOK_KEY_NAMESPACE = 65,         /* TOK_KEY_NAMESPACE  */
  YYSYMBOL_TOK_KEY_ERROR = 66,             /* TOK_KEY_ERROR  */
  YYSYMBOL_TOK_KEY_FSUID = 67,             /* TOK_KEY_FSUID  */
  YYSYMBOL_TOK_KEY_OUID = 68,              /* TOK_KEY_OUID  */
  YYSYMBOL_TOK_KEY_UID = 69,               /* TOK_KEY_UID  */
  YYSYMBOL_TOK_KEY_AUID = 70,              /* TOK_KEY_AUID  */
  YYSYMBOL_TOK_KEY_SAUID = 71,             /* TOK_KEY_SAUID  */
  YYSYMBOL_TOK_KEY_SES = 72,               /* TOK_KEY_SES  */
  YYSYMBOL_TOK_KEY_HOSTNAME = 73,          /* TOK_KEY_HOSTNAME  */
  YYSYMBOL_TOK_KEY_ADDR = 74,              /* TOK_KEY_ADDR  */
  YYSYMBOL_TOK_KEY_TERMINAL = 75,          /* TOK_KEY_TERMINAL  */
  YYSYMBOL_TOK_KEY_EXE = 76,               /* TOK_KEY_EXE  */
  YYSYMBOL_TOK_KEY_COMM = 77,              /* TOK_KEY_COMM  */
  YYSYMBOL_TOK_KEY_CAPABILITY = 78,        /* TOK_KEY_CAPABILITY  */
  YYSYMBOL_TOK_KEY_CAPNAME = 79,           /* TOK_KEY_CAPNAME  */
  YYSYMBOL_TOK_KEY_OFFSET = 80,            /* TOK_KEY_OFFSET  */
  YYSYMBOL_TOK_KEY_TARGET = 81,            /* TOK_KEY_TARGET  */
  YYSYMBOL_TOK_KEY_LADDR = 82,             /* TOK_KEY_LADDR  */
  YYSYMBOL_TOK_KEY_FADDR = 83,             /* TOK_KEY_FADDR  */
  YYSYMBOL_TOK_KEY_LPORT = 84,             /* TOK_KEY_LPORT  */
  YYSYMBOL_TOK_KEY_FPORT = 85,             /* TOK_KEY_FPORT  */
  YYSYMBOL_TOK_KEY_BUS = 86,               /* TOK_KEY_BUS  */
  YYSYMBOL_TOK_KEY_PATH = 87,              /* TOK_KEY_PATH  */
  YYSYMBOL_TOK_KEY_INTERFACE = 88,         /* TOK_KEY_INTERFACE  */
  YYSYMBOL_TOK_KEY_MEMBER = 89,            /* TOK_KEY_MEMBER  */
  YYSYMBOL_TOK_KEY_SIGNAL = 90,            /* TOK_KEY_SIGNAL  */
  YYSYMBOL_TOK_KEY_FSTYPE = 91,            /* TOK_KEY_FSTYPE  */
  YYSYMBOL_TOK_KEY_FLAGS = 92,             /* TOK_KEY_FLAGS  */
  YYSYMBOL_TOK_KEY_SRCNAME = 93,           /* TOK_KEY_SRCNAME  */
  YYSYMBOL_TOK_SOCKLOGD_KERNEL = 94,       /* TOK_SOCKLOGD_KERNEL  */
  YYSYMBOL_TOK_SYSLOG_KERNEL = 95,         /* TOK_SYSLOG_KERNEL  */
  YYSYMBOL_TOK_SYSLOG_USER = 96,           /* TOK_SYSLOG_USER  */
  YYSYMBOL_YYACCEPT = 97,                  /* $accept  */
  YYSYMBOL_log_message = 98,               /* log_message  */
  YYSYMBOL_audit_type = 99,                /* audit_type  */
  YYSYMBOL_type_syntax = 100,              /* type_syntax  */
  YYSYMBOL_new_syntax = 101,               /* new_syntax  */
  YYSYMBOL_other_audit = 102,              /* other_audit  */
  YYSYMBOL_dmesg_type = 103,               /* dmesg_type  */
  YYSYMBOL_syslog_id = 104,                /* syslog_id  */
  YYSYMBOL_syslog_type = 105,              /* syslog_type  */
  YYSYMBOL_audit_dispatch = 106,           /* audit_dispatch  */
  YYSYMBOL_audit_msg = 107,                /* audit_msg  */
  YYSYMBOL_audit_user_msg_partial_tail = 108, /* audit_user_msg_partial_tail  */
  YYSYMBOL_audit_user_msg_tail = 109,      /* audit_user_msg_tail  */
  YYSYMBOL_audit_user_msg = 110,           /* audit_user_msg  */
  YYSYMBOL_audit_id = 111,                 /* audit_id  */
  YYSYMBOL_syslog_date = 112,              /* syslog_date  */
  YYSYMBOL_key_list = 113,                 /* key_list  */
  YYSYMBOL_key = 114,                      /* key  */
  YYSYMBOL_apparmor_event = 115,           /* apparmor_event  */
  YYSYMBOL_key_pid = 116,                  /* key_pid  */
  YYSYMBOL_key_peer_pid = 117,             /* key_peer_pid  */
  YYSYMBOL_ignored_pid = 118,              /* ignored_pid  */
  YYSYMBOL_ignored_uid = 119,              /* ignored_uid  */
  YYSYMBOL_ignored_auid = 120,             /* ignored_auid  */
  YYSYMBOL_ignored_ses = 121,              /* ignored_ses  */
  YYSYMBOL_key_type = 122,                 /* key_type  */
  YYSYMBOL_safe_string = 123,              /* safe_string  */
  YYSYMBOL_protocol = 124                  /* protocol  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  18
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   348

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  97
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  28
/* YYNRULES -- Number of rules.  */
#define YYNRULES  112
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  298

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   351


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   200,   200,   201,   202,   203,   206,   208,   209,   213,
     214,   215,   216,   217,   218,   219,   220,   221,   224,   232,
     236,   237,   241,   243,   245,   247,   250,   252,   254,   256,
     258,   264,   267,   270,   273,   276,   279,   290,   292,   296,
     297,   300,   302,   304,   306,   308,   310,   312,   314,   316,
     318,   320,   322,   324,   326,   328,   329,   330,   332,   334,
     336,   338,   340,   342,   344,   346,   348,   350,   352,   354,
     356,   358,   359,   360,   361,   363,   365,   371,   377,   378,
     384,   388,   393,   397,   399,   401,   403,   405,   407,   409,
     411,   413,   416,   418,   420,   423,   431,   432,   433,   434,
     435,   436,   439,   442,   445,   446,   447,   448,   450,   453,
     454,   457,   458
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "TOK_DIGITS",
  "TOK_TYPE_UNKNOWN", "TOK_QUOTED_STRING", "TOK_ID", "TOK_MODE",
  "TOK_DMESG_STAMP", "TOK_AUDIT_DIGITS", "TOK_DATE_MONTH", "TOK_DATE",
  "TOK_TIME", "TOK_HEXSTRING", "TOK_TYPE_OTHER", "TOK_MSG_REST",
  "TOK_IP_ADDR", "TOK_EQUALS", "TOK_COLON", "TOK_MINUS", "TOK_OPEN_PAREN",
  "TOK_CLOSE_PAREN", "TOK_PERIOD", "TOK_QUESTION_MARK", "TOK_SINGLE_QUOTE",
  "TOK_TYPE_REJECT", "TOK_TYPE_AUDIT", "TOK_TYPE_COMPLAIN",
  "TOK_TYPE_HINT", "TOK_TYPE_STATUS", "TOK_TYPE_ERROR",
  "TOK_TYPE_AA_REJECT", "TOK_TYPE_AA_AUDIT", "TOK_TYPE_AA_COMPLAIN",
  "TOK_TYPE_AA_HINT", "TOK_TYPE_AA_STATUS", "TOK_TYPE_AA_ERROR",
  "TOK_TYPE_LSM_AVC", "TOK_TYPE_USER_AVC", "TOK_KEY_APPARMOR",
  "TOK_KEY_TYPE", "TOK_KEY_MSG", "TOK_KEY_OPERATION", "TOK_KEY_NAME",
  "TOK_KEY_NAME2", "TOK_KEY_MASK", "TOK_KEY_DENIED_MASK",
  "TOK_KEY_REQUESTED_MASK", "TOK_KEY_ATTRIBUTE", "TOK_KEY_TASK",
  "TOK_KEY_PARENT", "TOK_KEY_MAGIC_TOKEN", "TOK_KEY_INFO",
  "TOK_KEY_PEER_INFO", "TOK_KEY_PID", "TOK_KEY_PEER_PID",
  "TOK_KEY_PROFILE", "TOK_KEY_PEER_PROFILE", "TOK_KEY_LABEL",
  "TOK_KEY_PEER_LABEL", "TOK_KEY_PEER", "TOK_AUDIT", "TOK_KEY_FAMILY",
  "TOK_KEY_SOCK_TYPE", "TOK_KEY_PROTOCOL", "TOK_KEY_NAMESPACE",
  "TOK_KEY_ERROR", "TOK_KEY_FSUID", "TOK_KEY_OUID", "TOK_KEY_UID",
  "TOK_KEY_AUID", "TOK_KEY_SAUID", "TOK_KEY_SES", "TOK_KEY_HOSTNAME",
  "TOK_KEY_ADDR", "TOK_KEY_TERMINAL", "TOK_KEY_EXE", "TOK_KEY_COMM",
  "TOK_KEY_CAPABILITY", "TOK_KEY_CAPNAME", "TOK_KEY_OFFSET",
  "TOK_KEY_TARGET", "TOK_KEY_LADDR", "TOK_KEY_FADDR", "TOK_KEY_LPORT",
  "TOK_KEY_FPORT", "TOK_KEY_BUS", "TOK_KEY_PATH", "TOK_KEY_INTERFACE",
  "TOK_KEY_MEMBER", "TOK_KEY_SIGNAL", "TOK_KEY_FSTYPE", "TOK_KEY_FLAGS",
  "TOK_KEY_SRCNAME", "TOK_SOCKLOGD_KERNEL", "TOK_SYSLOG_KERNEL",
  "TOK_SYSLOG_USER", "$accept", "log_message", "audit_type", "type_syntax",
  "new_syntax", "other_audit", "dmesg_type", "syslog_id", "syslog_type",
  "audit_dispatch", "audit_msg", "audit_user_msg_partial_tail",
  "audit_user_msg_tail", "audit_user_msg", "audit_id", "syslog_date",
  "key_list", "key", "apparmor_event", "key_pid", "key_peer_pid",
  "ignored_pid", "ignored_uid", "ignored_auid", "ignored_ses", "key_type",
  "safe_string", "protocol", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-144)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-105)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      13,   -53,    27,    21,    18,    33,    64,  -144,  -144,  -144,
    -144,   186,    -5,    51,    60,  -144,     5,    12,  -144,  -144,
      59,    61,    62,    66,    67,    68,    73,    74,    75,    87,
      88,    89,    90,    91,    99,   100,   102,   103,   104,   105,
     106,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   137,
     186,  -144,  -144,  -144,   -28,  -144,    -6,    35,  -144,    36,
      36,    36,    36,    36,    36,    36,    36,    36,   138,  -144,
    -144,  -144,   136,  -144,    85,   152,   153,    15,    15,   155,
     157,   158,   159,   154,   163,   166,   173,   175,   180,   181,
      15,    15,    15,    15,   182,   183,   187,    22,    15,     3,
     188,   190,   192,    43,    57,    58,    15,    15,   193,   194,
     197,    15,   189,   195,   199,   200,   201,   203,   204,   205,
     191,   207,   208,   209,  -144,  -144,   186,   -35,   198,    11,
     186,    12,    12,   186,   202,   186,   186,   186,   186,   186,
     186,   186,   206,  -144,   210,  -144,  -144,  -144,  -144,  -144,
    -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,
    -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,
    -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,
    -144,   213,  -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,
    -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,
    -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,   186,
      31,   186,    12,   215,    35,   186,   186,   186,   186,  -144,
     186,   186,   186,   186,   186,   186,   186,    12,   225,  -144,
      35,   186,   186,  -144,    12,   186,   186,   150,   211,    12,
     186,   186,   238,   234,  -144,   233,   264,   241,   186,   218,
    -144,   293,   243,   302,   318,   234,  -144,   186,  -144,   219,
     319,   265,   317,   221,  -144,   336,   323,   300,   324,   274,
    -144,   341,   328,  -144,  -144,   322,   186,   186
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       0,     0,     0,     0,     0,     0,     0,     2,     3,     4,
       5,     0,     0,     0,     0,    38,     0,     0,     1,    95,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      31,    39,    55,    56,     0,    21,     0,     0,    37,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     8,     0,    32,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    40,    20,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    17,     0,    96,    97,    98,    99,   100,
     101,    78,    64,    41,   109,   110,    42,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,   102,   103,    57,
      58,    59,    60,    54,    61,    62,   112,   111,    63,    43,
      65,     0,    67,    68,    69,    71,    70,    72,    74,    73,
      75,    76,    77,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    30,
       0,     0,     0,     0,     0,    22,     0,     0,    15,    18,
       9,    10,    11,    12,    13,    14,    16,     0,     0,    66,
       0,    24,     0,   108,     0,    23,    19,     0,     0,     0,
      25,     0,     0,     0,    35,     0,     0,     0,    29,     0,
      34,     0,     0,     0,     0,    26,    27,    28,   104,     0,
       0,     0,     0,     0,   105,     0,     0,     0,     0,   102,
     106,     0,     0,    36,   107,     0,     0,    33
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,  -144,
      16,    80,    81,  -144,   -65,  -144,  -143,   -70,  -144,  -144,
    -144,  -144,  -144,  -144,  -144,   -73,   -66,  -144
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     6,     7,    89,    90,    91,     8,    76,     9,    10,
      11,   263,   264,   163,    93,    12,    70,    71,   171,    72,
      73,   265,   272,   281,   287,   151,   176,   198
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     144,    74,   147,   229,   152,   148,   200,   235,    13,    79,
     238,   150,   240,   241,   242,   243,   244,   245,   246,    80,
     174,     1,   201,     2,     3,   196,   230,   197,   175,   234,
      14,   164,   177,    15,   148,    16,    81,    82,    83,    84,
      85,    86,    87,    88,   189,   190,   191,   192,   174,   250,
      17,   164,   199,     4,     5,   149,   175,   206,   208,   210,
     211,   212,   174,   174,    18,   216,   205,   145,   146,    77,
     175,   175,    78,    92,   232,   148,    94,     5,    95,    96,
     207,   209,   231,    97,    98,    99,   236,   237,   251,    75,
     100,   101,   102,   255,   256,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   103,   104,   105,   106,   107,   260,
     165,   166,   167,   168,   169,   170,   108,   109,   268,   110,
     111,   112,   113,   114,   277,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   297,   143,   172,   164,   182,   173,   144,
     178,   254,   179,   180,   181,   144,   183,   252,   144,   184,
     144,   144,   144,   144,   144,   144,   144,   259,   185,   162,
     186,   144,   257,   187,   188,   144,   144,   193,   194,   261,
     144,   202,   195,   203,   267,   204,   213,   225,   144,   214,
     215,    19,   219,   220,   262,   217,   221,   144,   222,   223,
     224,   218,   226,   227,   228,   233,   249,   239,   253,   248,
     266,   278,   284,   247,   289,    20,    21,   144,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,   258,    41,    42,
      43,    44,    45,    46,    47,   269,    19,    48,   270,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      20,    21,   273,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,   274,    35,    36,    37,    38,
      39,    40,   271,    41,    42,    43,    44,    45,    46,    47,
     279,   282,    48,   280,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,   283,   285,   286,   288,   290,
     291,   292,   293,  -104,   294,   295,   296,   275,   276
};

static const yytype_int16 yycheck[] =
{
      70,     6,     8,   146,    77,    40,     3,   150,    61,     4,
     153,    76,   155,   156,   157,   158,   159,   160,   161,    14,
       5,     8,    19,    10,    11,     3,    61,     5,    13,    18,
       3,    20,    98,    12,    40,    17,    31,    32,    33,    34,
      35,    36,    37,    38,   110,   111,   112,   113,     5,    18,
      17,    20,   118,    40,    41,    61,    13,   123,   124,   125,
     126,   127,     5,     5,     0,   131,    23,    95,    96,    18,
      13,    13,    12,    61,   147,    40,    17,    41,    17,    17,
      23,    23,   147,    17,    17,    17,   151,   152,   231,    94,
      17,    17,    17,   236,   237,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    17,    17,    17,    17,    17,   252,
      25,    26,    27,    28,    29,    30,    17,    17,   261,    17,
      17,    17,    17,    17,   267,    17,    17,    17,    17,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,   296,    17,     3,    20,     3,     5,   229,
       5,   234,     5,     5,     5,   235,     3,   232,   238,     3,
     240,   241,   242,   243,   244,   245,   246,   250,     5,    41,
       5,   251,   247,     3,     3,   255,   256,     5,     5,   254,
     260,     3,     5,     3,   259,     3,     3,     6,   268,     5,
       3,    15,     3,     3,    54,    16,     5,   277,     5,     5,
       5,    16,     5,     5,     5,    17,     3,    15,     3,     9,
       9,     3,     3,    17,     3,    39,    40,   297,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    22,    62,    63,
      64,    65,    66,    67,    68,    17,    15,    71,    24,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
      39,    40,    18,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    69,    62,    63,    64,    65,    66,    67,    68,
      17,     9,    71,    70,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    17,    17,    72,    21,     3,
      17,    41,    18,    69,     3,    17,    24,   267,   267
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     8,    10,    11,    40,    41,    98,    99,   103,   105,
     106,   107,   112,    61,     3,    12,    17,    17,     0,    15,
      39,    40,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    62,    63,    64,    65,    66,    67,    68,    71,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    91,    92,    93,
     113,   114,   116,   117,     6,    94,   104,    18,    12,     4,
      14,    31,    32,    33,    34,    35,    36,    37,    38,   100,
     101,   102,    61,   111,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
      17,    17,    17,    17,   114,    95,    96,     8,    40,    61,
     111,   122,   122,   107,   107,   107,   107,   107,   107,   107,
     107,   107,    41,   110,    20,    25,    26,    27,    28,    29,
      30,   115,     3,     5,     5,    13,   123,   123,     5,     5,
       5,     5,     3,     3,     3,     5,     5,     3,     3,   123,
     123,   123,   123,     5,     5,     5,     3,     5,   124,   123,
       3,    19,     3,     3,     3,    23,   123,    23,   123,    23,
     123,   123,   123,     3,     5,     3,   123,    16,    16,     3,
       3,     5,     5,     5,     5,     6,     5,     5,     5,   113,
      61,   111,   122,    17,    18,   113,   111,   111,   113,    15,
     113,   113,   113,   113,   113,   113,   113,    17,     9,     3,
      18,   113,   111,     3,   122,   113,   113,   111,    22,   122,
     113,   111,    54,   108,   109,   118,     9,   111,   113,    17,
      24,    69,   119,    18,    54,   108,   109,   113,     3,    17,
      70,   120,     9,    17,     3,    17,    72,   121,    21,     3,
       3,    17,    41,    18,     3,    17,    24,   113
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    97,    98,    98,    98,    98,    99,   100,   100,   101,
     101,   101,   101,   101,   101,   101,   101,   101,   102,   103,
     104,   104,   105,   105,   105,   105,   105,   105,   105,   105,
     105,   106,   107,   108,   109,   110,   111,   112,   112,   113,
     113,   114,   114,   114,   114,   114,   114,   114,   114,   114,
     114,   114,   114,   114,   114,   114,   114,   114,   114,   114,
     114,   114,   114,   114,   114,   114,   114,   114,   114,   114,
     114,   114,   114,   114,   114,   114,   114,   114,   114,   114,
     114,   114,   114,   114,   114,   114,   114,   114,   114,   114,
     114,   114,   114,   114,   114,   114,   115,   115,   115,   115,
     115,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     123,   124,   124
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     3,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     3,     6,
       2,     1,     4,     5,     5,     6,     8,     8,     8,     7,
       4,     2,     3,     8,     2,     4,     9,     3,     2,     1,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     1,     1,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     4,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     3,     3,     3,     3,     1,
       1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (scanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, scanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, void *scanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (scanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, void *scanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, scanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, void *scanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, scanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, void *scanner)
{
  YY_USE (yyvaluep);
  YY_USE (scanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_TOK_QUOTED_STRING: /* TOK_QUOTED_STRING  */
#line 193 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1457 "grammar.c"
        break;

    case YYSYMBOL_TOK_ID: /* TOK_ID  */
#line 193 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1463 "grammar.c"
        break;

    case YYSYMBOL_TOK_MODE: /* TOK_MODE  */
#line 193 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1469 "grammar.c"
        break;

    case YYSYMBOL_TOK_DMESG_STAMP: /* TOK_DMESG_STAMP  */
#line 193 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1475 "grammar.c"
        break;

    case YYSYMBOL_TOK_AUDIT_DIGITS: /* TOK_AUDIT_DIGITS  */
#line 194 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1481 "grammar.c"
        break;

    case YYSYMBOL_TOK_DATE_MONTH: /* TOK_DATE_MONTH  */
#line 194 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1487 "grammar.c"
        break;

    case YYSYMBOL_TOK_DATE: /* TOK_DATE  */
#line 194 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1493 "grammar.c"
        break;

    case YYSYMBOL_TOK_TIME: /* TOK_TIME  */
#line 194 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1499 "grammar.c"
        break;

    case YYSYMBOL_TOK_HEXSTRING: /* TOK_HEXSTRING  */
#line 195 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1505 "grammar.c"
        break;

    case YYSYMBOL_TOK_TYPE_OTHER: /* TOK_TYPE_OTHER  */
#line 195 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1511 "grammar.c"
        break;

    case YYSYMBOL_TOK_MSG_REST: /* TOK_MSG_REST  */
#line 195 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1517 "grammar.c"
        break;

    case YYSYMBOL_TOK_IP_ADDR: /* TOK_IP_ADDR  */
#line 196 "grammar.y"
            { free(((*yyvaluep).t_str)); }
#line 1523 "grammar.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (void *scanner)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, scanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 7: /* type_syntax: new_syntax  */
#line 208 "grammar.y"
                        { ret_record->version = AA_RECORD_SYNTAX_V2; }
#line 1799 "grammar.c"
    break;

  case 9: /* new_syntax: TOK_TYPE_AA_REJECT audit_msg key_list  */
#line 213 "grammar.y"
                                                { ret_record->event = AA_RECORD_DENIED; }
#line 1805 "grammar.c"
    break;

  case 10: /* new_syntax: TOK_TYPE_AA_AUDIT audit_msg key_list  */
#line 214 "grammar.y"
                                               { ret_record->event = AA_RECORD_AUDIT; }
#line 1811 "grammar.c"
    break;

  case 11: /* new_syntax: TOK_TYPE_AA_COMPLAIN audit_msg key_list  */
#line 215 "grammar.y"
                                                  { ret_record->event = AA_RECORD_ALLOWED; }
#line 1817 "grammar.c"
    break;

  case 12: /* new_syntax: TOK_TYPE_AA_HINT audit_msg key_list  */
#line 216 "grammar.y"
                                              { ret_record->event = AA_RECORD_HINT; }
#line 1823 "grammar.c"
    break;

  case 13: /* new_syntax: TOK_TYPE_AA_STATUS audit_msg key_list  */
#line 217 "grammar.y"
                                                { ret_record->event = AA_RECORD_STATUS; }
#line 1829 "grammar.c"
    break;

  case 14: /* new_syntax: TOK_TYPE_AA_ERROR audit_msg key_list  */
#line 218 "grammar.y"
                                               { ret_record->event = AA_RECORD_ERROR; }
#line 1835 "grammar.c"
    break;

  case 15: /* new_syntax: TOK_TYPE_UNKNOWN audit_msg key_list  */
#line 219 "grammar.y"
                                              { ret_record->event = lookup_aa_event((yyvsp[-2].t_long)); }
#line 1841 "grammar.c"
    break;

  case 18: /* other_audit: TOK_TYPE_OTHER audit_msg TOK_MSG_REST  */
#line 225 "grammar.y"
        {
		ret_record->operation = (yyvsp[-2].t_str);
		ret_record->event = AA_RECORD_INVALID;
		ret_record->info = (yyvsp[0].t_str);
	}
#line 1851 "grammar.c"
    break;

  case 19: /* dmesg_type: TOK_DMESG_STAMP TOK_AUDIT TOK_COLON key_type audit_id key_list  */
#line 233 "grammar.y"
        { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-5].t_str)); }
#line 1857 "grammar.c"
    break;

  case 20: /* syslog_id: TOK_ID TOK_SYSLOG_KERNEL  */
#line 236 "grammar.y"
                                    { free((yyvsp[-1].t_str)); }
#line 1863 "grammar.c"
    break;

  case 21: /* syslog_id: TOK_SOCKLOGD_KERNEL  */
#line 237 "grammar.y"
                              { }
#line 1869 "grammar.c"
    break;

  case 22: /* syslog_type: syslog_date syslog_id audit_id key_list  */
#line 242 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; }
#line 1875 "grammar.c"
    break;

  case 23: /* syslog_type: syslog_date syslog_id key_type audit_id key_list  */
#line 244 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; }
#line 1881 "grammar.c"
    break;

  case 24: /* syslog_type: syslog_date syslog_id TOK_DMESG_STAMP audit_id key_list  */
#line 246 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-2].t_str)); }
#line 1887 "grammar.c"
    break;

  case 25: /* syslog_type: syslog_date syslog_id TOK_DMESG_STAMP key_type audit_id key_list  */
#line 248 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-3].t_str)); }
#line 1893 "grammar.c"
    break;

  case 26: /* syslog_type: syslog_date syslog_id TOK_DMESG_STAMP TOK_AUDIT TOK_COLON key_type audit_id audit_user_msg_partial_tail  */
#line 251 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-5].t_str)); }
#line 1899 "grammar.c"
    break;

  case 27: /* syslog_type: syslog_date syslog_id TOK_DMESG_STAMP TOK_AUDIT TOK_COLON key_type audit_id audit_user_msg_tail  */
#line 253 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-5].t_str)); }
#line 1905 "grammar.c"
    break;

  case 28: /* syslog_type: syslog_date syslog_id TOK_DMESG_STAMP TOK_AUDIT TOK_COLON key_type audit_id key_list  */
#line 255 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-5].t_str)); }
#line 1911 "grammar.c"
    break;

  case 29: /* syslog_type: syslog_date syslog_id TOK_AUDIT TOK_COLON key_type audit_id key_list  */
#line 257 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; }
#line 1917 "grammar.c"
    break;

  case 30: /* syslog_type: syslog_date TOK_ID TOK_SYSLOG_USER key_list  */
#line 259 "grammar.y"
          { ret_record->version = AA_RECORD_SYNTAX_V2; free((yyvsp[-2].t_str)); }
#line 1923 "grammar.c"
    break;

  case 31: /* audit_dispatch: audit_msg key_list  */
#line 264 "grammar.y"
                           { ret_record->version = AA_RECORD_SYNTAX_V2; }
#line 1929 "grammar.c"
    break;

  case 36: /* audit_id: TOK_AUDIT TOK_OPEN_PAREN TOK_AUDIT_DIGITS TOK_PERIOD TOK_AUDIT_DIGITS TOK_COLON TOK_AUDIT_DIGITS TOK_CLOSE_PAREN TOK_COLON  */
#line 280 "grammar.y"
        {
		if (!asprintf(&ret_record->audit_id, "%s.%s:%s", (yyvsp[-6].t_str), (yyvsp[-4].t_str), (yyvsp[-2].t_str)))
			yyerror(scanner, YY_("Out of memory"));
		ret_record->epoch = atol((yyvsp[-6].t_str));
		ret_record->audit_sub_id = atoi((yyvsp[-2].t_str));
		free((yyvsp[-6].t_str));
		free((yyvsp[-4].t_str));
		free((yyvsp[-2].t_str));
	}
#line 1943 "grammar.c"
    break;

  case 37: /* syslog_date: TOK_DATE_MONTH TOK_DIGITS TOK_TIME  */
#line 291 "grammar.y"
                { free((yyvsp[-2].t_str)); free((yyvsp[0].t_str)); /* do nothing */ }
#line 1949 "grammar.c"
    break;

  case 38: /* syslog_date: TOK_DATE TOK_TIME  */
#line 293 "grammar.y"
                { free((yyvsp[-1].t_str)); free((yyvsp[0].t_str)); /* do nothing */ }
#line 1955 "grammar.c"
    break;

  case 41: /* key: TOK_KEY_OPERATION TOK_EQUALS TOK_QUOTED_STRING  */
#line 301 "grammar.y"
        { ret_record->operation = (yyvsp[0].t_str);}
#line 1961 "grammar.c"
    break;

  case 42: /* key: TOK_KEY_NAME TOK_EQUALS safe_string  */
#line 303 "grammar.y"
        { ret_record->name = (yyvsp[0].t_str);}
#line 1967 "grammar.c"
    break;

  case 43: /* key: TOK_KEY_NAMESPACE TOK_EQUALS safe_string  */
#line 305 "grammar.y"
        { ret_record->namespace = (yyvsp[0].t_str);}
#line 1973 "grammar.c"
    break;

  case 44: /* key: TOK_KEY_NAME2 TOK_EQUALS safe_string  */
#line 307 "grammar.y"
        { ret_record->name2 = (yyvsp[0].t_str);}
#line 1979 "grammar.c"
    break;

  case 45: /* key: TOK_KEY_MASK TOK_EQUALS TOK_QUOTED_STRING  */
#line 309 "grammar.y"
        { ret_record->denied_mask = (yyvsp[0].t_str);}
#line 1985 "grammar.c"
    break;

  case 46: /* key: TOK_KEY_DENIED_MASK TOK_EQUALS TOK_QUOTED_STRING  */
#line 311 "grammar.y"
        { ret_record->denied_mask = (yyvsp[0].t_str);}
#line 1991 "grammar.c"
    break;

  case 47: /* key: TOK_KEY_REQUESTED_MASK TOK_EQUALS TOK_QUOTED_STRING  */
#line 313 "grammar.y"
        { ret_record->requested_mask = (yyvsp[0].t_str);}
#line 1997 "grammar.c"
    break;

  case 48: /* key: TOK_KEY_ATTRIBUTE TOK_EQUALS TOK_QUOTED_STRING  */
#line 315 "grammar.y"
        { ret_record->attribute = (yyvsp[0].t_str);}
#line 2003 "grammar.c"
    break;

  case 49: /* key: TOK_KEY_TASK TOK_EQUALS TOK_DIGITS  */
#line 317 "grammar.y"
        { ret_record->task = (yyvsp[0].t_long);}
#line 2009 "grammar.c"
    break;

  case 50: /* key: TOK_KEY_PARENT TOK_EQUALS TOK_DIGITS  */
#line 319 "grammar.y"
        { ret_record->parent = (yyvsp[0].t_long);}
#line 2015 "grammar.c"
    break;

  case 51: /* key: TOK_KEY_MAGIC_TOKEN TOK_EQUALS TOK_DIGITS  */
#line 321 "grammar.y"
        { ret_record->magic_token = (yyvsp[0].t_long);}
#line 2021 "grammar.c"
    break;

  case 52: /* key: TOK_KEY_INFO TOK_EQUALS TOK_QUOTED_STRING  */
#line 323 "grammar.y"
        { ret_record->info = (yyvsp[0].t_str);}
#line 2027 "grammar.c"
    break;

  case 53: /* key: TOK_KEY_PEER_INFO TOK_EQUALS TOK_QUOTED_STRING  */
#line 325 "grammar.y"
        { ret_record->peer_info = (yyvsp[0].t_str);}
#line 2033 "grammar.c"
    break;

  case 54: /* key: TOK_KEY_PEER TOK_EQUALS TOK_QUOTED_STRING  */
#line 327 "grammar.y"
        { ret_record->peer = (yyvsp[0].t_str);}
#line 2039 "grammar.c"
    break;

  case 57: /* key: TOK_KEY_PROFILE TOK_EQUALS safe_string  */
#line 331 "grammar.y"
        { ret_record->profile = (yyvsp[0].t_str);}
#line 2045 "grammar.c"
    break;

  case 58: /* key: TOK_KEY_PEER_PROFILE TOK_EQUALS safe_string  */
#line 333 "grammar.y"
        { ret_record->peer_profile = (yyvsp[0].t_str);}
#line 2051 "grammar.c"
    break;

  case 59: /* key: TOK_KEY_LABEL TOK_EQUALS safe_string  */
#line 335 "grammar.y"
        { ret_record->profile = (yyvsp[0].t_str);}
#line 2057 "grammar.c"
    break;

  case 60: /* key: TOK_KEY_PEER_LABEL TOK_EQUALS safe_string  */
#line 337 "grammar.y"
        { ret_record->peer_profile = (yyvsp[0].t_str);}
#line 2063 "grammar.c"
    break;

  case 61: /* key: TOK_KEY_FAMILY TOK_EQUALS TOK_QUOTED_STRING  */
#line 339 "grammar.y"
        { ret_record->net_family = (yyvsp[0].t_str);}
#line 2069 "grammar.c"
    break;

  case 62: /* key: TOK_KEY_SOCK_TYPE TOK_EQUALS TOK_QUOTED_STRING  */
#line 341 "grammar.y"
        { ret_record->net_sock_type = (yyvsp[0].t_str);}
#line 2075 "grammar.c"
    break;

  case 63: /* key: TOK_KEY_PROTOCOL TOK_EQUALS protocol  */
#line 343 "grammar.y"
        { ret_record->net_protocol = (yyvsp[0].t_str);}
#line 2081 "grammar.c"
    break;

  case 64: /* key: TOK_KEY_TYPE TOK_EQUALS TOK_DIGITS  */
#line 345 "grammar.y"
        { ret_record->event = lookup_aa_event((yyvsp[0].t_long));}
#line 2087 "grammar.c"
    break;

  case 65: /* key: TOK_KEY_ERROR TOK_EQUALS TOK_DIGITS  */
#line 347 "grammar.y"
        { ret_record->error_code = (yyvsp[0].t_long);}
#line 2093 "grammar.c"
    break;

  case 66: /* key: TOK_KEY_ERROR TOK_EQUALS TOK_MINUS TOK_DIGITS  */
#line 349 "grammar.y"
        { ret_record->error_code = (yyvsp[0].t_long);}
#line 2099 "grammar.c"
    break;

  case 67: /* key: TOK_KEY_FSUID TOK_EQUALS TOK_DIGITS  */
#line 351 "grammar.y"
        { ret_record->fsuid = (yyvsp[0].t_long);}
#line 2105 "grammar.c"
    break;

  case 68: /* key: TOK_KEY_OUID TOK_EQUALS TOK_DIGITS  */
#line 353 "grammar.y"
        { ret_record->ouid = (yyvsp[0].t_long);}
#line 2111 "grammar.c"
    break;

  case 69: /* key: TOK_KEY_SAUID TOK_EQUALS TOK_DIGITS  */
#line 355 "grammar.y"
        { /* Ignore - Source audit ID from user AVC messages */ }
#line 2117 "grammar.c"
    break;

  case 70: /* key: TOK_KEY_HOSTNAME TOK_EQUALS safe_string  */
#line 357 "grammar.y"
        { free((yyvsp[0].t_str)); /* Ignore - hostname from user AVC messages */ }
#line 2123 "grammar.c"
    break;

  case 74: /* key: TOK_KEY_ADDR TOK_EQUALS safe_string  */
#line 362 "grammar.y"
        { free((yyvsp[0].t_str)); /* Ignore - IP address from user AVC messages */ }
#line 2129 "grammar.c"
    break;

  case 75: /* key: TOK_KEY_TERMINAL TOK_EQUALS safe_string  */
#line 364 "grammar.y"
        { free((yyvsp[0].t_str)); /* Ignore - TTY from user AVC messages */ }
#line 2135 "grammar.c"
    break;

  case 76: /* key: TOK_KEY_EXE TOK_EQUALS safe_string  */
#line 366 "grammar.y"
        { /* Free existing arrays because exe= and comm= maps to the same
	     aa_log_record member */
	  free(ret_record->comm);
	  ret_record->comm = (yyvsp[0].t_str);
	}
#line 2145 "grammar.c"
    break;

  case 77: /* key: TOK_KEY_COMM TOK_EQUALS safe_string  */
#line 372 "grammar.y"
        { /* Free existing arrays because exe= and comm= maps to the same
	     aa_log_record member */
	  free(ret_record->comm);
	  ret_record->comm = (yyvsp[0].t_str);
	}
#line 2155 "grammar.c"
    break;

  case 79: /* key: TOK_KEY_CAPABILITY TOK_EQUALS TOK_DIGITS  */
#line 379 "grammar.y"
        { /* need to reverse map number to string, need to figure out
	   * how to get auto generation of reverse mapping table into
	   * autotools Makefile.  For now just drop assumming capname is
	   * present which it should be with current kernels */
	}
#line 2165 "grammar.c"
    break;

  case 80: /* key: TOK_KEY_CAPNAME TOK_EQUALS TOK_QUOTED_STRING  */
#line 385 "grammar.y"
        { /* capname used to be reported in name */
	  ret_record->name = (yyvsp[0].t_str);
	}
#line 2173 "grammar.c"
    break;

  case 81: /* key: TOK_KEY_OFFSET TOK_EQUALS TOK_DIGITS  */
#line 389 "grammar.y"
        { /* offset is used for reporting where an error occured unpacking
	   * loaded policy.  We can just drop this currently
	   */
	}
#line 2182 "grammar.c"
    break;

  case 82: /* key: TOK_KEY_TARGET TOK_EQUALS safe_string  */
#line 394 "grammar.y"
        { /* target was always name2 in the past */
	  ret_record->name2 = (yyvsp[0].t_str);
	}
#line 2190 "grammar.c"
    break;

  case 83: /* key: TOK_KEY_LADDR TOK_EQUALS TOK_IP_ADDR  */
#line 398 "grammar.y"
        { ret_record->net_local_addr = (yyvsp[0].t_str);}
#line 2196 "grammar.c"
    break;

  case 84: /* key: TOK_KEY_FADDR TOK_EQUALS TOK_IP_ADDR  */
#line 400 "grammar.y"
        { ret_record->net_foreign_addr = (yyvsp[0].t_str);}
#line 2202 "grammar.c"
    break;

  case 85: /* key: TOK_KEY_LPORT TOK_EQUALS TOK_DIGITS  */
#line 402 "grammar.y"
        { ret_record->net_local_port = (yyvsp[0].t_long);}
#line 2208 "grammar.c"
    break;

  case 86: /* key: TOK_KEY_FPORT TOK_EQUALS TOK_DIGITS  */
#line 404 "grammar.y"
        { ret_record->net_foreign_port = (yyvsp[0].t_long);}
#line 2214 "grammar.c"
    break;

  case 87: /* key: TOK_KEY_BUS TOK_EQUALS TOK_QUOTED_STRING  */
#line 406 "grammar.y"
        { ret_record->dbus_bus = (yyvsp[0].t_str); }
#line 2220 "grammar.c"
    break;

  case 88: /* key: TOK_KEY_PATH TOK_EQUALS TOK_QUOTED_STRING  */
#line 408 "grammar.y"
        { ret_record->dbus_path = (yyvsp[0].t_str); }
#line 2226 "grammar.c"
    break;

  case 89: /* key: TOK_KEY_INTERFACE TOK_EQUALS TOK_QUOTED_STRING  */
#line 410 "grammar.y"
        { ret_record->dbus_interface = (yyvsp[0].t_str); }
#line 2232 "grammar.c"
    break;

  case 90: /* key: TOK_KEY_MEMBER TOK_EQUALS TOK_QUOTED_STRING  */
#line 412 "grammar.y"
        { ret_record->dbus_member = (yyvsp[0].t_str); }
#line 2238 "grammar.c"
    break;

  case 91: /* key: TOK_KEY_SIGNAL TOK_EQUALS TOK_ID  */
#line 414 "grammar.y"
        { ret_record->signal = (yyvsp[0].t_str); }
#line 2244 "grammar.c"
    break;

  case 92: /* key: TOK_KEY_FSTYPE TOK_EQUALS TOK_QUOTED_STRING  */
#line 417 "grammar.y"
        { ret_record->fs_type = (yyvsp[0].t_str); }
#line 2250 "grammar.c"
    break;

  case 93: /* key: TOK_KEY_FLAGS TOK_EQUALS TOK_QUOTED_STRING  */
#line 419 "grammar.y"
        { ret_record->flags = (yyvsp[0].t_str); }
#line 2256 "grammar.c"
    break;

  case 94: /* key: TOK_KEY_SRCNAME TOK_EQUALS TOK_QUOTED_STRING  */
#line 421 "grammar.y"
        { ret_record->src_name = (yyvsp[0].t_str); }
#line 2262 "grammar.c"
    break;

  case 95: /* key: TOK_MSG_REST  */
#line 424 "grammar.y"
        {
		ret_record->event = AA_RECORD_INVALID;
		ret_record->info = (yyvsp[0].t_str);
	}
#line 2271 "grammar.c"
    break;

  case 96: /* apparmor_event: TOK_TYPE_REJECT  */
#line 431 "grammar.y"
                                { ret_record->event = AA_RECORD_DENIED; }
#line 2277 "grammar.c"
    break;

  case 97: /* apparmor_event: TOK_TYPE_AUDIT  */
#line 432 "grammar.y"
                                { ret_record->event = AA_RECORD_AUDIT; }
#line 2283 "grammar.c"
    break;

  case 98: /* apparmor_event: TOK_TYPE_COMPLAIN  */
#line 433 "grammar.y"
                                { ret_record->event = AA_RECORD_ALLOWED; }
#line 2289 "grammar.c"
    break;

  case 99: /* apparmor_event: TOK_TYPE_HINT  */
#line 434 "grammar.y"
                                { ret_record->event = AA_RECORD_HINT; }
#line 2295 "grammar.c"
    break;

  case 100: /* apparmor_event: TOK_TYPE_STATUS  */
#line 435 "grammar.y"
                                { ret_record->event = AA_RECORD_STATUS; }
#line 2301 "grammar.c"
    break;

  case 101: /* apparmor_event: TOK_TYPE_ERROR  */
#line 436 "grammar.y"
                                { ret_record->event = AA_RECORD_ERROR; }
#line 2307 "grammar.c"
    break;

  case 102: /* key_pid: TOK_KEY_PID TOK_EQUALS TOK_DIGITS  */
#line 439 "grammar.y"
                                           { ret_record->pid = (yyvsp[0].t_long); }
#line 2313 "grammar.c"
    break;

  case 103: /* key_peer_pid: TOK_KEY_PEER_PID TOK_EQUALS TOK_DIGITS  */
#line 442 "grammar.y"
                                                     { ret_record->peer_pid = (yyvsp[0].t_long); }
#line 2319 "grammar.c"
    break;

  case 104: /* ignored_pid: TOK_KEY_PID TOK_EQUALS TOK_DIGITS  */
#line 445 "grammar.y"
                                                 { /* DROP */ }
#line 2325 "grammar.c"
    break;

  case 105: /* ignored_uid: TOK_KEY_UID TOK_EQUALS TOK_DIGITS  */
#line 446 "grammar.y"
                                                 { /* DROP */ }
#line 2331 "grammar.c"
    break;

  case 106: /* ignored_auid: TOK_KEY_AUID TOK_EQUALS TOK_DIGITS  */
#line 447 "grammar.y"
                                                 { /* DROP */ }
#line 2337 "grammar.c"
    break;

  case 107: /* ignored_ses: TOK_KEY_SES TOK_EQUALS TOK_DIGITS  */
#line 448 "grammar.y"
                                                 { /* DROP */ }
#line 2343 "grammar.c"
    break;

  case 108: /* key_type: TOK_KEY_TYPE TOK_EQUALS TOK_DIGITS  */
#line 450 "grammar.y"
                                             { ret_record->event = lookup_aa_event((yyvsp[0].t_long)); }
#line 2349 "grammar.c"
    break;

  case 112: /* protocol: TOK_DIGITS  */
#line 459 "grammar.y"
        { /* FIXME: this should probably convert back to a string proto name */
	  (yyval.t_str) = ipproto_to_string((yyvsp[0].t_long));
	}
#line 2357 "grammar.c"
    break;


#line 2361 "grammar.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (scanner, YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, scanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (scanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, scanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 463 "grammar.y"


aa_log_record *
_parse_yacc(char *str)
{
	/* yydebug = 1;  */
	YY_BUFFER_STATE lex_buf;
	yyscan_t scanner;

	ret_record = NULL;
	ret_record = malloc(sizeof(aa_log_record));

	_init_log_record(ret_record);

	if (ret_record == NULL)
		return NULL;

#if (YYDEBUG != 0)
	yydebug = 1;
#endif

	aalogparse_lex_init(&scanner);
	lex_buf = aalogparse__scan_string(str, scanner);
	/* Ignore return value to return an AA_RECORD_INVALID event */
	(void)aalogparse_parse(scanner);
	aalogparse__delete_buffer(lex_buf, scanner);
	aalogparse_lex_destroy(scanner);
	return ret_record;
}
