#ifdef ASTSTART
__ASTSTART = DIAG_START_AST,
#undef ASTSTART
#endif

DIAG(err_asm_empty_symbolic_operand_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "empty symbolic operand name in inline assembly string", 0, SFINAE_SubstitutionFailure, false, true, true, false, 12)
DIAG(err_asm_invalid_escape, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid %% escape in inline assembly string", 0, SFINAE_SubstitutionFailure, false, true, true, false, 12)
DIAG(err_asm_invalid_operand_number, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid operand number in inline asm string", 0, SFINAE_SubstitutionFailure, false, true, true, false, 12)
DIAG(err_asm_unknown_symbolic_operand_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "unknown symbolic operand name in inline assembly string", 0, SFINAE_SubstitutionFailure, false, true, true, false, 12)
DIAG(err_asm_unterminated_symbolic_operand_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "unterminated symbolic operand name in inline assembly string", 0, SFINAE_SubstitutionFailure, false, true, true, false, 12)
DIAG(err_experimental_clang_interp_failed, CLASS_ERROR, (unsigned)diag::Severity::Error, "the experimental clang interpreter failed to evaluate an expression", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_different_num_template_parameters, CLASS_ERROR, (unsigned)diag::Severity::Error, "template parameter lists have a different number of parameters (%0 vs %1)", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_different_template_parameter_kind, CLASS_ERROR, (unsigned)diag::Severity::Error, "template parameter has different kinds in different translation units", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_field_type_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "field %0 declared with incompatible types in different translation units (%1 vs. %2)", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_function_type_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "external function %0 declared with incompatible types in different translation units (%1 vs. %2)", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_ivar_type_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "instance variable %0 declared with incompatible types in different translation units (%1 vs. %2)", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_non_type_parameter_type_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "non-type template parameter declared with incompatible types in different translation units (%0 vs. %1)", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_objc_method_num_params_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{class|instance}0 method %1 has a different number of parameters in different translation units (%2 vs. %3)", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_objc_method_param_type_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{class|instance}0 method %1 has a parameter with a different types in different translation units (%2 vs. %3)", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_objc_method_result_type_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{class|instance}0 method %1 has incompatible result types in different translation units (%2 vs. %3)", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_objc_method_variadic_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{class|instance}0 method %1 is variadic in one translation unit and not variadic in another", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_objc_property_impl_kind_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 is implemented with %select{@synthesize|@dynamic}1 in one translation but %select{@dynamic|@synthesize}1 in another translation unit", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_objc_property_type_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 declared with incompatible types in different translation units (%1 vs. %2)", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_objc_superclass_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "class %0 has incompatible superclasses", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_objc_synthesize_ivar_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "property %0 is synthesized to different ivars in different translation units (%1 vs. %2)", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_parameter_pack_non_pack, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter kind mismatch; parameter is %select{not a|a}0 parameter pack", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_tag_type_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "type %0 has incompatible definitions in different translation units", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_variable_multiple_def, CLASS_ERROR, (unsigned)diag::Severity::Error, "external variable %0 defined in multiple translation units", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_odr_variable_type_inconsistent, CLASS_ERROR, (unsigned)diag::Severity::Error, "external variable %0 declared with incompatible types in different translation units (%1 vs. %2)", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_unsupported_ast_node, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot import unsupported AST node %0", 0, SFINAE_SubstitutionFailure, false, true, true, false, 0)
DIAG(err_vftable_ambiguous_component, CLASS_ERROR, (unsigned)diag::Severity::Error, "ambiguous vftable component for %0 introduced via covariant thunks; this is an inherent limitation of the ABI", 0, SFINAE_SubstitutionFailure, false, true, true, false, 26)
DIAG(note_consteval_address_accessible, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{pointer|reference}0 to a consteval declaration is not a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_access_deleted_object, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{read of|read of|assignment to|increment of|decrement of|member call on|dynamic_cast of|typeid applied to|construction of|destruction of}0 heap allocated object that has been deleted", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_access_inactive_union_member, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{read of|read of|assignment to|increment of|decrement of|member call on|dynamic_cast of|typeid applied to|construction of subobject of|destruction of}0 member %1 of union with %select{active member %3|no active member}2 is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_access_mutable, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{read of|read of|assignment to|increment of|decrement of|member call on|dynamic_cast of|typeid applied to|construction of|destruction of}0 mutable member %1 is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_access_null, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{read of|read of|assignment to|increment of|decrement of|member call on|dynamic_cast of|typeid applied to|construction of|destruction of}0 dereferenced null pointer is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_access_past_end, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{read of|read of|assignment to|increment of|decrement of|member call on|dynamic_cast of|typeid applied to|construction of|destruction of}0 dereferenced one-past-the-end pointer is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_access_static_temporary, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{read of|read of|assignment to|increment of|decrement of|member call on|dynamic_cast of|typeid applied to|reconstruction of|destruction of}0 temporary is not allowed in a constant expression outside the expression that created the temporary", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_access_uninit, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{read of|read of|assignment to|increment of|decrement of|member call on|dynamic_cast of|typeid applied to|construction of subobject of|destruction of}0 %select{object outside its lifetime|uninitialized object}1 is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_access_unreadable_object, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{read of|read of|assignment to|increment of|decrement of|member call on|dynamic_cast of|typeid applied to|construction of|destruction of}0 object '%1' whose value is not known", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_access_unsized_array, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{read of|read of|assignment to|increment of|decrement of|member call on|dynamic_cast of|typeid applied to|construction of|destruction of}0 element of array without known bound is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_access_volatile_obj, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{read of|read of|assignment to|increment of|decrement of|<ERROR>|<ERROR>|<ERROR>|<ERROR>}0 volatile %select{temporary|object %2|member %2}1 is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_access_volatile_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{read of|read of|assignment to|increment of|decrement of|<ERROR>|<ERROR>|<ERROR>|<ERROR>}0 volatile-qualified type %1 is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_alignment_adjust, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot constant evaluate the result of adjusting alignment to %0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_alignment_compute, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot constant evaluate whether run-time alignment is at least %0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_alignment_too_big, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "requested alignment must be %0 or less for type %1; %2 is invalid", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_array_index, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot refer to element %0 of %select{array of %2 element%plural{1:|:s}2|non-array object}1 in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_baa_insufficient_alignment, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{alignment of|offset of the aligned pointer from}0 the base pointee object (%1 %plural{1:byte|:bytes}1) is %select{less than|not a multiple of}0 the asserted %2 %plural{1:byte|:bytes}2", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_baa_value_insufficient_alignment, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "value of the aligned pointer (%0) is not a multiple of the asserted %1 %plural{1:byte|:bytes}1", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_bit_cast_indet_dest, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "indeterminate value can only initialize an object of type 'unsigned char'%select{, 'char',|}1 or 'std::byte'; %0 is invalid", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_bit_cast_invalid_subtype, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "invalid type %0 is a %select{member|base}1 of %2", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_bit_cast_invalid_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "bit_cast %select{from|to}0 a %select{|type with a }1%select{union|pointer|member pointer|volatile|reference}2 %select{type|member}1 is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_bit_cast_unrepresentable_value, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "value %1 cannot be represented in type %0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_bit_cast_unsupported_bitfield, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constexpr bit_cast involving bit-field is not yet supported", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_bit_cast_unsupported_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constexpr bit_cast involving type %0 is not yet supported", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_call_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in call to '%0'", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_call_limit_exceeded, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constexpr evaluation hit maximum call limit", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_calls_suppressed, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "(skipping %0 call%s0 in backtrace; use -fconstexpr-backtrace-limit=0 to see all)", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_compare_virtual_mem_ptr, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "comparison of pointer to virtual member function %0 has unspecified value", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_conditional_never_const, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "both arms of conditional operator are unable to produce a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_construct_complex_elem, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "construction of individual component of complex number is not yet supported in constant expressions", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_deallocate_null, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'std::allocator<...>::deallocate' used to delete a null pointer", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_delete_base_nonvirt_dtor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "delete of object with dynamic type %1 through pointer to base class type %0 with non-virtual destructor", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_delete_not_heap_alloc, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "delete of pointer '%0' that does not point to a heap-allocated object", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_delete_subobject, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "delete of pointer%select{ to subobject|}1 '%0' %select{|that does not point to complete object}1", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_depth_limit_exceeded, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constexpr evaluation exceeded maximum depth of %0 calls", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_destroy_complex_elem, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "destruction of individual component of complex number is not yet supported in constant expressions", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_destroy_out_of_lifetime, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "destroying object '%0' whose lifetime has already ended", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_double_delete, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "delete of pointer that has already been deleted", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_double_destroy, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "destruction of object that is already being destroyed", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_dynamic_alloc, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{pointer|reference}0 to %select{|subobject of }1heap-allocated object is not a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_dynamic_alloc_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "heap allocation performed here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_dynamic_cast_to_reference_failed, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "reference dynamic_cast failed: %select{static type %1 of operand is a non-public base class of dynamic type %2|dynamic type %2 of operand does not have a base class of type %3|%3 is an ambiguous base class of dynamic type %2 of operand|%3 is a non-public base class of dynamic type %2 of operand}0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_dynamic_rounding, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot evaluate this expression if rounding mode is dynamic", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_float_arithmetic, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "floating point arithmetic produces %select{an infinity|a NaN}0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_float_arithmetic_strict, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "compile time floating point arithmetic suppressed in strict evaluation modes", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_function_param_value_unknown, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "function parameter %0 with unknown value cannot be used in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_heap_alloc_limit_exceeded, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constexpr evaluation hit maximum heap allocation limit", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_inherited_ctor_call_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "in implicit initialization for inherited constructor of %0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_invalid_alignment, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "requested alignment %0 is not a positive power of two", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_invalid_cast, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{reinterpret_cast|dynamic_cast|cast that performs the conversions of a reinterpret_cast|cast from %1}0 is not allowed in a constant expression%select{| in C++ standards before C++20||}0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_invalid_downcast, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot cast object of dynamic type %0 to type %1", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_invalid_function, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{non-constexpr|undefined}0 %select{function|constructor}1 %2 cannot be used in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_invalid_inhctor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constructor inherited from base class %0 cannot be used in a constant expression; derived class cannot be implicitly initialized", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_large_shift, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "shift count %0 >= width of type %1 (%2 bit%s2)", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_lifetime_ended, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{read of|read of|assignment to|increment of|decrement of|member call on|dynamic_cast of|typeid applied to|construction of|destruction of}0 %select{temporary|variable}1 whose %plural{8:storage duration|:lifetime}0 has ended", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_lshift_discards, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "signed left shift discards bits", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_lshift_of_negative, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "left shift of negative value %0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_ltor_incomplete_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "read of incomplete type %0 is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_ltor_non_const_int, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "read of non-const variable %0 is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_ltor_non_constexpr, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "read of non-constexpr variable %0 is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_ltor_non_integral, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "read of variable %0 of non-integral, non-enumeration type %1 is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_memchr_unsupported, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constant evaluation of %0 on array of type %1 is not supported; only arrays of narrow character types can be searched", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_memcmp_unsupported, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constant evaluation of %0 between arrays of types %1 and %2 is not supported; only arrays of narrow character types can be compared", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_memcpy_incomplete_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot constant evaluate '%select{memcpy|memmove}0' between objects of incomplete type %1", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_memcpy_nontrivial, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot constant evaluate '%select{memcpy|memmove}0' between objects of non-trivially-copyable type %1", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_memcpy_null, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{source|destination}2 of '%select{%select{memcpy|wmemcpy}1|%select{memmove|wmemmove}1}0' is %3", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_memcpy_overlap, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'%select{memcpy|wmemcpy}0' between overlapping memory regions", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_memcpy_type_pun, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot constant evaluate '%select{memcpy|memmove}0' from object of type %1 to object of type %2", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_memcpy_unsupported, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "'%select{%select{memcpy|wmemcpy}1|%select{memmove|wmemmove}1}0' not supported: %select{size to copy (%4) is not a multiple of size of element type %3 (%5)|source is not a contiguous array of at least %4 elements of type %3|destination is not a contiguous array of at least %4 elements of type %3}2", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_memory_leak, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "allocation performed here was not deallocated%plural{0:|: (along with %0 other memory leak%s0)}0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_modify_const_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "modification of object of const-qualified type %0 is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_modify_global, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "a constant expression cannot modify an object that is visible outside that expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_negative_shift, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "negative shift count %0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_new, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "dynamic memory allocation is not permitted in constant expressions until C++20", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_new_delete_mismatch, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%plural{2:'delete' used to delete pointer to object allocated with 'std::allocator<...>::allocate'|:%select{non-array delete|array delete|'std::allocator<...>::deallocate'}0 used to delete pointer to %select{array object of type %2|non-array object of type %2|object allocated with 'new'}0}1", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_new_negative, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot allocate array; evaluated array bound %0 is negative", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_new_non_replaceable, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "call to %select{placement|class-specific}0 %1", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_new_not_complete_object_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot allocate memory of %select{incomplete|function}0 type %1", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_new_placement, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "this placement new expression is not yet supported in constant expressions", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_new_too_large, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot allocate array; evaluated array bound %0 is too large", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_new_too_small, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot allocate array; evaluated array bound %0 is too small to hold %1 explicitly initialized elements", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_new_untyped, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot allocate untyped memory in a constant expression; use 'std::allocator<T>::allocate' to allocate memory of type 'T'", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_no_return, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "control reached end of constexpr function", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_non_global, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{pointer|reference}0 to %select{|subobject of }1%select{temporary|%3}2 is not a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_nonliteral, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "non-literal type %0 cannot be used in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_not_static, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "address of non-static constexpr variable %0 may differ on each invocation of the enclosing function; add 'static' to give it a constant address", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_null_subobject, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot %select{access base class of|access derived class of|access field of|access array element of|perform pointer arithmetic on|access real component of|access imaginary component of}0 null pointer", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_operator_new_bad_size, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "allocated size %0 is not a multiple of size %1 of element type %2", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_overflow, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "value %0 is outside the range of representable values of type %1", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_past_end, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "dereferenced pointer past the end of %select{|subobject of }0%select{temporary|%2}1 is not a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_past_end_subobject, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot %select{access base class of|access derived class of|access field of|access array element of|ERROR|access real component of|access imaginary component of}0 pointer past the end of object", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_placement_new_wrong_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "placement new would change type of storage from %0 to %1", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_pointer_comparison_base_classes, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "comparison of addresses of subobjects of different base classes has unspecified value", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_pointer_comparison_base_field, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "comparison of address of base class subobject %0 of class %1 to field %2 has unspecified value", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_pointer_comparison_differing_access, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "comparison of address of fields %0 and %2 of %4 with differing access specifiers (%1 vs %3) has unspecified value", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_pointer_comparison_unspecified, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "comparison has unspecified value", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_pointer_subtraction_not_same_array, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "subtracted pointers are not elements of the same array", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_pointer_subtraction_zero_size, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "subtraction of pointers to type %0 of zero size", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_polymorphic_unknown_dynamic_type, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{|||||virtual function called on|dynamic_cast applied to|typeid applied to|construction of|destruction of}0 object '%1' whose dynamic type is not constant", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_pseudo_destructor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "pseudo-destructor call is not permitted in constant expressions until C++20", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_pure_virtual_call, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "pure virtual function %q0 called", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_step_limit_exceeded, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "constexpr evaluation hit maximum step limit; possible infinite loop?", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_stmt_expr_unsupported, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "this use of statement expressions is not supported in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_subobject_declared_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "subobject declared here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_temporary_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "temporary created here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_this, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{|implicit }0use of 'this' pointer is only allowed within the evaluation of a call to a 'constexpr' member function", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_typeid_polymorphic, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "typeid applied to expression of polymorphic type %0 is not allowed in a constant expression in C++ standards before C++20", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_uninitialized, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{|sub}0object of type %1 is not initialized", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_union_member_change_during_init, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "assignment would change active union member during the initialization of a different member of the same union", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_unsized_array_indexed, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "indexing of array without known bound is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_unsupported_destruction, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "non-trivial destruction of type %0 in a constant expression is not supported", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_unsupported_layout, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "type %0 has unexpected layout", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_unsupported_temporary_nontrivial_dtor, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "non-trivial destruction of lifetime-extended temporary with type %0 used in the result of a constant expression is not yet supported", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_unsupported_unsized_array, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "array-to-pointer decay of array member without known bound is not supported", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_use_uninit_reference, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use of reference outside its lifetime is not allowed in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_var_init_non_constant, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "initializer of %0 is not a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_var_init_unknown, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "initializer of %0 is unknown", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_var_init_weak, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "initializer of weak variable %0 is not considered constant because it may be different at runtime", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_virtual_base, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot construct object of type %0 with virtual base class in a constant expression", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_virtual_call, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "cannot evaluate call to virtual function in a constant expression in C++ standards before C++20", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_void_comparison, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "comparison between unequal pointers to void has unspecified result", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_constexpr_volatile_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "volatile %select{temporary created|object declared|member declared}0 here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_covariant_thunk, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "covariant thunk required by %0", 0, SFINAE_Suppress, false, false, true, false, 26)
DIAG(note_expr_divide_by_zero, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "division by zero", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_non_null_attribute_failed, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "null passed to a callee that requires a non-null argument", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_base, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "class has base type %0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_bit_field, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "bit-field %0 with type %1 and length %2 here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_enumerator, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "enumerator %0 with value %1 here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_field, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "field %0 has type %1 here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_field_name, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "field has name %0 here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_friend, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "friend declared here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_missing_base, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "no corresponding base class here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_missing_enumerator, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "no corresponding enumerator here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_missing_field, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "no corresponding field here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_missing_friend, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "no corresponding friend here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_not_bit_field, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "field %0 is not a bit-field", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_number_of_bases, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "class has %0 base %plural{1:class|:classes}0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_objc_method_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{class|instance}0 method %1 also declared here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_objc_missing_superclass, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "no corresponding superclass here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_objc_property_impl_kind, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "property %0 is implemented with %select{@synthesize|@dynamic}1 here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_objc_superclass, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "inherits from superclass %0 here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_objc_synthesize_ivar_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "property is synthesized to ivar %0 here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_parameter_pack_non_pack, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{parameter|parameter pack}0 declared here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_tag_kind_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%0 is a %select{struct|interface|union|class|enum}1 here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_template_parameter_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "template parameter declared here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_template_parameter_list, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "template parameter list also declared here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_value_here, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "declared here with type %0", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_odr_virtual_base, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{non-virtual|virtual}0 derivation here", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(note_unimplemented_constexpr_lambda_feature_ast, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "unimplemented constexpr lambda feature: %0 (coming soon!)", 0, SFINAE_Suppress, false, false, true, false, 0)
DIAG(remark_sanitize_address_insert_extra_padding_accepted, CLASS_REMARK, (unsigned)diag::Severity::Ignored, "-fsanitize-address-field-padding applied to %0", 713, SFINAE_Suppress, false, true, true, false, 0)
DIAG(remark_sanitize_address_insert_extra_padding_rejected, CLASS_REMARK, (unsigned)diag::Severity::Ignored, "-fsanitize-address-field-padding ignored for %0 because it %select{is not C++|is packed|is a union|is trivially copyable|has trivial destructor|is standard layout|is in a ignorelisted file|is ignorelisted}1", 713, SFINAE_Suppress, false, true, true, false, 0)
DIAG(warn_fixedpoint_constant_overflow, CLASS_WARNING, (unsigned)diag::Severity::Warning, "overflow in expression; result is %0 with type %1", 291, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_integer_constant_overflow, CLASS_WARNING, (unsigned)diag::Severity::Warning, "overflow in expression; result is %0 with type %1", 418, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_is_constant_evaluated_always_true_constexpr, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' will always evaluate to 'true' in a manifestly constant-evaluated expression", 166, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_npot_ms_struct, CLASS_WARNING, (unsigned)diag::Severity::Error, "ms_struct may not produce Microsoft-compatible layouts with fundamental data types with sizes that aren't a power of two", 390, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_different_num_template_parameters, CLASS_WARNING, (unsigned)diag::Severity::Warning, "template parameter lists have a different number of parameters (%0 vs %1)", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_different_template_parameter_kind, CLASS_WARNING, (unsigned)diag::Severity::Warning, "template parameter has different kinds in different translation units", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_field_type_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "field %0 declared with incompatible types in different translation units (%1 vs. %2)", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_function_type_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "external function %0 declared with incompatible types in different translation units (%1 vs. %2)", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_ivar_type_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "instance variable %0 declared with incompatible types in different translation units (%1 vs. %2)", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_non_type_parameter_type_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "non-type template parameter declared with incompatible types in different translation units (%0 vs. %1)", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_objc_method_num_params_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{class|instance}0 method %1 has a different number of parameters in different translation units (%2 vs. %3)", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_objc_method_param_type_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{class|instance}0 method %1 has a parameter with a different types in different translation units (%2 vs. %3)", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_objc_method_result_type_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{class|instance}0 method %1 has incompatible result types in different translation units (%2 vs. %3)", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_objc_method_variadic_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%select{class|instance}0 method %1 is variadic in one translation unit and not variadic in another", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_objc_property_impl_kind_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property %0 is implemented with %select{@synthesize|@dynamic}1 in one translation but %select{@dynamic|@synthesize}1 in another translation unit", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_objc_property_type_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property %0 declared with incompatible types in different translation units (%1 vs. %2)", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_objc_superclass_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "class %0 has incompatible superclasses", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_objc_synthesize_ivar_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "property %0 is synthesized to different ivars in different translation units (%1 vs. %2)", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_parameter_pack_non_pack, CLASS_WARNING, (unsigned)diag::Severity::Warning, "parameter kind mismatch; parameter is %select{not a|a}0 parameter pack", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_tag_type_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "type %0 has incompatible definitions in different translation units", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_variable_multiple_def, CLASS_WARNING, (unsigned)diag::Severity::Warning, "external variable %0 defined in multiple translation units", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_odr_variable_type_inconsistent, CLASS_WARNING, (unsigned)diag::Severity::Warning, "external variable %0 declared with incompatible types in different translation units (%1 vs. %2)", 603, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_padded_struct_anon_field, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "padding %select{struct|interface|class}0 %1 with %2 %select{byte|bit}3%s2 to align anonymous bit-field", 627, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_padded_struct_field, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "padding %select{struct|interface|class}0 %1 with %2 %select{byte|bit}3%s2 to align %4", 627, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_padded_struct_size, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "padding size of %0 with %1 %select{byte|bit}2%s1 to alignment boundary", 627, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_unaligned_access, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "field %1 within %0 is less aligned than %2 and is usually due to %0 being packed, which can lead to unaligned accesses", 829, SFINAE_Suppress, false, false, true, false, 0)
DIAG(warn_unnecessary_packed, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "packed attribute is unnecessary for %0", 626, SFINAE_Suppress, false, false, true, false, 0)
