/* base-window.c generated by valac 0.56.2, the Vala compiler
 * generated from base-window.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BASE_APPLICATION (base_application_get_type ())
#define BASE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_APPLICATION, BaseApplication))
#define IS_BASE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_APPLICATION))
#define BASE_APPLICATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_BASE_APPLICATION, BaseApplicationIface))

typedef struct _BaseApplication BaseApplication;
typedef struct _BaseApplicationIface BaseApplicationIface;

#define TYPE_ADAPTATIVE_WINDOW (adaptative_window_get_type ())
#define ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow))
#define ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))
#define IS_ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WINDOW))
#define IS_ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADAPTATIVE_WINDOW))
#define ADAPTATIVE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))

typedef struct _AdaptativeWindow AdaptativeWindow;
typedef struct _AdaptativeWindowClass AdaptativeWindowClass;
typedef struct _AdaptativeWindowPrivate AdaptativeWindowPrivate;

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_WINDOW (base_window_get_type ())
#define BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_WINDOW, BaseWindow))
#define BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_WINDOW, BaseWindowClass))
#define IS_BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_WINDOW))
#define IS_BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_WINDOW))
#define BASE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_WINDOW, BaseWindowClass))

typedef struct _BaseWindow BaseWindow;
typedef struct _BaseWindowClass BaseWindowClass;
typedef struct _BaseWindowPrivate BaseWindowPrivate;

#define TYPE_BASE_VIEW (base_view_get_type ())
#define BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_VIEW, BaseView))
#define BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_VIEW, BaseViewClass))
#define IS_BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_VIEW))
#define IS_BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_VIEW))
#define BASE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_VIEW, BaseViewClass))

typedef struct _BaseView BaseView;
typedef struct _BaseViewClass BaseViewClass;

#define TYPE_NIGHT_TIME_AWARE_HEADER_BAR (night_time_aware_header_bar_get_type ())
#define NIGHT_TIME_AWARE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBar))
#define NIGHT_TIME_AWARE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBarClass))
#define IS_NIGHT_TIME_AWARE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR))
#define IS_NIGHT_TIME_AWARE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIGHT_TIME_AWARE_HEADER_BAR))
#define NIGHT_TIME_AWARE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBarClass))

typedef struct _NightTimeAwareHeaderBar NightTimeAwareHeaderBar;
typedef struct _NightTimeAwareHeaderBarClass NightTimeAwareHeaderBarClass;

#define TYPE_BASE_HEADER_BAR (base_header_bar_get_type ())
#define BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBar))
#define BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))
#define IS_BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_HEADER_BAR))
#define IS_BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_HEADER_BAR))
#define BASE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))

typedef struct _BaseHeaderBar BaseHeaderBar;
typedef struct _BaseHeaderBarClass BaseHeaderBarClass;
enum  {
	BASE_WINDOW_0_PROPERTY,
	BASE_WINDOW_BASE_VIEW_PROPERTY,
	BASE_WINDOW_HELP_STRING_OR_EMPTY_PROPERTY,
	BASE_WINDOW_IN_WINDOW_ABOUT_PROPERTY,
	BASE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* base_window_properties[BASE_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BaseApplicationIface {
	GTypeInterface parent_iface;
	void (*copy) (BaseApplication* self, const gchar* text);
	void (*get_about_dialog_infos) (BaseApplication* self, gchar*** artists, gint* artists_length1, gchar*** authors, gint* authors_length1, gchar** comments, gchar** copyright, gchar*** documenters, gint* documenters_length1, gchar** logo_icon_name, gchar** program_name, gchar** translator_credits, gchar** version, gchar** website, gchar** website_label);
};

struct _AdaptativeWindow {
	GtkApplicationWindow parent_instance;
	AdaptativeWindowPrivate * priv;
};

struct _AdaptativeWindowClass {
	GtkApplicationWindowClass parent_class;
	void (*before_destroy) (AdaptativeWindow* self);
};

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseWindow {
	AdaptativeWindow parent_instance;
	BaseWindowPrivate * priv;
};

struct _BaseWindowClass {
	AdaptativeWindowClass parent_class;
	gboolean (*handle_copy_text) (BaseWindow* self, gchar** copy_text);
	gboolean (*get_alt_copy_text) (BaseWindow* self, gchar** copy_text);
	void (*paste_text) (BaseWindow* self, const gchar* text);
	void (*menu_pressed) (BaseWindow* self);
	gboolean (*on_key_press_event) (BaseWindow* self, GtkWidget* widget, GdkEventKey* event);
	void (*set_window_size) (BaseWindow* self, AdaptativeWidgetWindowSize new_size);
	void (*close_in_window_panels) (BaseWindow* self);
	gboolean (*escape_pressed) (BaseWindow* self);
	void (*show_default_view) (BaseWindow* self);
};

struct _BaseWindowPrivate {
	BaseView* main_view;
	BaseHeaderBar* headerbar;
	GtkGrid* main_grid;
	gchar* _help_string_or_empty;
	gboolean disable_popovers;
	GtkAboutDialog* about_dialog;
	gboolean should_init_about_dialog;
	gboolean _in_window_about;
	gboolean should_init_in_window_about;
};

static gint BaseWindow_private_offset;
static gpointer base_window_parent_class = NULL;
static AdaptativeWidgetIface * base_window_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType base_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseApplication, g_object_unref)
VALA_EXTERN void base_application_copy (BaseApplication* self,
                            const gchar* text);
VALA_EXTERN void base_application_get_about_dialog_infos (BaseApplication* self,
                                              gchar*** artists,
                                              gint* artists_length1,
                                              gchar*** authors,
                                              gint* authors_length1,
                                              gchar** comments,
                                              gchar** copyright,
                                              gchar*** documenters,
                                              gint* documenters_length1,
                                              gchar** logo_icon_name,
                                              gchar** program_name,
                                              gchar** translator_credits,
                                              gchar** version,
                                              gchar** website,
                                              gchar** website_label);
static GType base_application_get_type_once (void);
VALA_EXTERN GType adaptative_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWindow, g_object_unref)
VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseWindow, g_object_unref)
VALA_EXTERN GType base_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseView, g_object_unref)
VALA_EXTERN GType night_time_aware_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NightTimeAwareHeaderBar, g_object_unref)
VALA_EXTERN GType base_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseHeaderBar, g_object_unref)
VALA_EXTERN gboolean base_window_handle_copy_text (BaseWindow* self,
                                       gchar** copy_text);
VALA_EXTERN gboolean base_window_get_alt_copy_text (BaseWindow* self,
                                        gchar** copy_text);
VALA_EXTERN void base_window_paste_text (BaseWindow* self,
                             const gchar* text);
VALA_EXTERN void base_window_menu_pressed (BaseWindow* self);
VALA_EXTERN gboolean base_window_on_key_press_event (BaseWindow* self,
                                         GtkWidget* widget,
                                         GdkEventKey* event);
VALA_EXTERN void base_window_set_window_size (BaseWindow* self,
                                  AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void base_window_close_in_window_panels (BaseWindow* self);
VALA_EXTERN gboolean base_window_escape_pressed (BaseWindow* self);
VALA_EXTERN void base_window_show_default_view (BaseWindow* self);
static void base_window_copy (BaseWindow* self);
static void _base_window_copy_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void base_window_copy_alt (BaseWindow* self);
static void _base_window_copy_alt_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void base_window_paste (BaseWindow* self);
static void _base_window_paste_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void base_window_paste_alt (BaseWindow* self);
static void _base_window_paste_alt_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void _base_window_escape_pressed (BaseWindow* self);
static void __base_window_escape_pressed_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void base_window_toggle_hamburger (BaseWindow* self);
static void _base_window_toggle_hamburger_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void _base_window_menu_pressed_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void _base_window_show_default_view_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void base_window_help (BaseWindow* self);
static void _base_window_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void base_window_about (BaseWindow* self);
static void _base_window_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
VALA_EXTERN void base_window_add_to_main_grid (BaseWindow* self,
                                   GtkWidget* widget);
static void base_window_install_action_entries (BaseWindow* self);
static gboolean base_window_real_handle_copy_text (BaseWindow* self,
                                            gchar** copy_text);
VALA_EXTERN gboolean base_view_handle_copy_text (BaseView* self,
                                     gchar** copy_text);
static gboolean base_window_real_get_alt_copy_text (BaseWindow* self,
                                             gchar** copy_text);
VALA_EXTERN gboolean base_window_no_copy_text (gchar** copy_text);
VALA_EXTERN gboolean base_window_copy_clipboard_text (gchar** copy_text);
VALA_EXTERN gboolean base_window_is_empty_text (const gchar* text);
VALA_EXTERN void base_view_close_popovers (BaseView* self);
static inline void base_window_copy_text (BaseWindow* self,
                            const gchar* text);
VALA_EXTERN gboolean base_view_is_in_in_window_mode (BaseView* self);
static void base_window_real_paste_text (BaseWindow* self,
                                  const gchar* text);
static void base_window_paste_clipboard_content (BaseWindow* self);
static inline gboolean base_window_get_clipboard_content (gchar** clipboard_content);
VALA_EXTERN void base_header_bar_toggle_hamburger_menu (BaseHeaderBar* self);
static void base_window_real_menu_pressed (BaseWindow* self);
static gboolean base_window_real_on_key_press_event (BaseWindow* self,
                                              GtkWidget* widget,
                                              GdkEventKey* event);
static gboolean _base_window_on_key_press_event (GtkWidget* widget,
                                          GdkEventKey* event,
                                          const gchar* help_string_or_empty);
static const gchar* base_window_get_help_string_or_empty (BaseWindow* self);
static gboolean _base_window_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                     GdkEventKey* event,
                                                                     gpointer self);
VALA_EXTERN void base_header_bar_close_popovers (BaseHeaderBar* self);
static inline gboolean base_window_show_application_help (BaseWindow* _this,
                                            const gchar* help_string_or_empty);
static void base_window_real_set_window_size (BaseWindow* self,
                                       AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_phone_size (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_thin (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN gboolean base_window_get_in_window_about (BaseWindow* self);
static void base_window_real_close_in_window_panels (BaseWindow* self);
VALA_EXTERN void base_window_hide_notification (BaseWindow* self);
static gboolean base_window_real_escape_pressed (BaseWindow* self);
static void base_window_real_show_default_view (BaseWindow* self);
static void base_window_set_in_window_about (BaseWindow* self,
                                      gboolean value);
VALA_EXTERN void base_header_bar_show_default_view (BaseHeaderBar* self);
VALA_EXTERN void base_view_show_default_view (BaseView* self);
static void base_window_show_about_dialog (BaseWindow* self);
static void base_window_create_about_dialog (BaseWindow* self);
static void ___lambda10_ (BaseWindow* self,
                   GtkDialog* _about_dialog,
                   gint response);
static void ____lambda10__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static gboolean base_window_about_dialog_key_press_event (GtkWidget* _about_dialog_widget,
                                                   GdkEventKey* event);
static gboolean _base_window_about_dialog_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                               GdkEventKey* event,
                                                                               gpointer self);
VALA_EXTERN const gchar* base_header_bar_get_about_action_label (BaseHeaderBar* self);
static void base_window_toggle_in_window_about (BaseWindow* self);
static void base_window_init_in_window_about (BaseWindow* self);
static inline void base_window_show_about_view (BaseWindow* self);
VALA_EXTERN void base_view_create_about_list (BaseView* self,
                                  gchar*** artists,
                                  gint* artists_length1,
                                  gchar*** authors,
                                  gint* authors_length1,
                                  gchar** comments,
                                  gchar** copyright,
                                  gchar*** documenters,
                                  gint* documenters_length1,
                                  gchar** logo_icon_name,
                                  gchar** program_name,
                                  gchar** translator_credits,
                                  gchar** version,
                                  gchar** website,
                                  gchar** website_label);
VALA_EXTERN void base_header_bar_show_about_view (BaseHeaderBar* self);
VALA_EXTERN void base_view_show_about_view (BaseView* self);
VALA_EXTERN void base_window_show_notification (BaseWindow* self,
                                    const gchar* notification);
VALA_EXTERN void base_view_show_notification (BaseView* self,
                                  const gchar* notification);
VALA_EXTERN void base_view_hide_notification (BaseView* self);
VALA_EXTERN BaseWindow* base_window_new (void);
VALA_EXTERN BaseWindow* base_window_construct (GType object_type);
VALA_EXTERN AdaptativeWindow* adaptative_window_construct (GType object_type);
VALA_EXTERN BaseView* base_window_get_base_view (BaseWindow* self);
static void base_window_set_base_view (BaseWindow* self,
                                BaseView* value);
static void base_window_set_help_string_or_empty (BaseWindow* self,
                                           const gchar* value);
static GObject * base_window_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
VALA_EXTERN NightTimeAwareHeaderBar* adaptative_window_get_nta_headerbar (AdaptativeWindow* self);
VALA_EXTERN void adaptative_window_add_adaptative_child (AdaptativeWindow* self,
                                             AdaptativeWidget* child);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void base_window_finalize (GObject * obj);
static GType base_window_get_type_once (void);
static void _vala_base_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_base_window_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry BASE_WINDOW_action_entries[10] = {{"copy", _base_window_copy_gsimple_action_activate_callback}, {"copy-alt", _base_window_copy_alt_gsimple_action_activate_callback}, {"paste", _base_window_paste_gsimple_action_activate_callback}, {"paste-alt", _base_window_paste_alt_gsimple_action_activate_callback}, {"escape", __base_window_escape_pressed_gsimple_action_activate_callback}, {"toggle-hamburger", _base_window_toggle_hamburger_gsimple_action_activate_callback}, {"menu", _base_window_menu_pressed_gsimple_action_activate_callback}, {"show-default-view", _base_window_show_default_view_gsimple_action_activate_callback}, {"help", _base_window_help_gsimple_action_activate_callback}, {"about", _base_window_about_gsimple_action_activate_callback}};

void
base_application_copy (BaseApplication* self,
                       const gchar* text)
{
	BaseApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BASE_APPLICATION_GET_INTERFACE (self);
	if (_iface_->copy) {
		_iface_->copy (self, text);
	}
}

void
base_application_get_about_dialog_infos (BaseApplication* self,
                                         gchar*** artists,
                                         gint* artists_length1,
                                         gchar*** authors,
                                         gint* authors_length1,
                                         gchar** comments,
                                         gchar** copyright,
                                         gchar*** documenters,
                                         gint* documenters_length1,
                                         gchar** logo_icon_name,
                                         gchar** program_name,
                                         gchar** translator_credits,
                                         gchar** version,
                                         gchar** website,
                                         gchar** website_label)
{
	BaseApplicationIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BASE_APPLICATION_GET_INTERFACE (self);
	if (_iface_->get_about_dialog_infos) {
		_iface_->get_about_dialog_infos (self, artists, artists_length1, authors, authors_length1, comments, copyright, documenters, documenters_length1, logo_icon_name, program_name, translator_credits, version, website, website_label);
	}
}

static void
base_application_default_init (BaseApplicationIface * iface,
                               gpointer iface_data)
{
}

static GType
base_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaseApplicationIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) base_application_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType base_application_type_id;
	base_application_type_id = g_type_register_static (G_TYPE_INTERFACE, "BaseApplication", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (base_application_type_id, gtk_application_get_type ());
	return base_application_type_id;
}

GType
base_application_get_type (void)
{
	static volatile gsize base_application_type_id__once = 0;
	if (g_once_init_enter (&base_application_type_id__once)) {
		GType base_application_type_id;
		base_application_type_id = base_application_get_type_once ();
		g_once_init_leave (&base_application_type_id__once, base_application_type_id);
	}
	return base_application_type_id__once;
}

static inline gpointer
base_window_get_instance_private (BaseWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BaseWindow_private_offset);
}

static void
_base_window_copy_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	base_window_copy ((BaseWindow*) self);
}

static void
_base_window_copy_alt_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	base_window_copy_alt ((BaseWindow*) self);
}

static void
_base_window_paste_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	base_window_paste ((BaseWindow*) self);
}

static void
_base_window_paste_alt_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	base_window_paste_alt ((BaseWindow*) self);
}

static void
__base_window_escape_pressed_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	_base_window_escape_pressed ((BaseWindow*) self);
}

static void
_base_window_toggle_hamburger_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	base_window_toggle_hamburger ((BaseWindow*) self);
}

static void
_base_window_menu_pressed_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	base_window_menu_pressed ((BaseWindow*) self);
}

static void
_base_window_show_default_view_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	base_window_show_default_view ((BaseWindow*) self);
}

static void
_base_window_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	base_window_help ((BaseWindow*) self);
}

static void
_base_window_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	base_window_about ((BaseWindow*) self);
}

void
base_window_add_to_main_grid (BaseWindow* self,
                              GtkWidget* widget)
{
	GtkGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->main_grid;
	gtk_container_add ((GtkContainer*) _tmp0_, widget);
}

static void
base_window_install_action_entries (BaseWindow* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, BASE_WINDOW_action_entries, (gint) G_N_ELEMENTS (BASE_WINDOW_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "base", (GActionGroup*) action_group);
	_g_object_unref0 (action_group);
}

static gboolean
base_window_real_handle_copy_text (BaseWindow* self,
                                   gchar** copy_text)
{
	gchar* _vala_copy_text = NULL;
	BaseView* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean result;
	_tmp0_ = self->priv->main_view;
	_tmp2_ = base_view_handle_copy_text (_tmp0_, &_tmp1_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp1_;
	result = _tmp2_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

gboolean
base_window_handle_copy_text (BaseWindow* self,
                              gchar** copy_text)
{
	BaseWindowClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BASE_WINDOW_GET_CLASS (self);
	if (_klass_->handle_copy_text) {
		return _klass_->handle_copy_text (self, copy_text);
	}
	return FALSE;
}

static gboolean
base_window_real_get_alt_copy_text (BaseWindow* self,
                                    gchar** copy_text)
{
	gchar* _vala_copy_text = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean result;
	_tmp1_ = base_window_no_copy_text (&_tmp0_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp0_;
	result = _tmp1_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

gboolean
base_window_get_alt_copy_text (BaseWindow* self,
                               gchar** copy_text)
{
	BaseWindowClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BASE_WINDOW_GET_CLASS (self);
	if (_klass_->get_alt_copy_text) {
		return _klass_->get_alt_copy_text (self, copy_text);
	}
	return FALSE;
}

gboolean
base_window_no_copy_text (gchar** copy_text)
{
	gchar* _vala_copy_text = NULL;
	gchar* _tmp0_;
	gboolean result;
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp0_;
	result = FALSE;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

gboolean
base_window_copy_clipboard_text (gchar** copy_text)
{
	gchar* _vala_copy_text = NULL;
	gchar* nullable_selection = NULL;
	GtkClipboard* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp8_ = NULL;
	gboolean _tmp9_;
	gboolean result;
	_tmp0_ = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
	_tmp1_ = gtk_clipboard_wait_for_text (_tmp0_);
	nullable_selection = _tmp1_;
	_tmp2_ = nullable_selection;
	if (_tmp2_ != NULL) {
		gchar* selection = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = nullable_selection;
		_tmp4_ = g_strdup ((const gchar*) _tmp3_);
		selection = _tmp4_;
		_tmp5_ = selection;
		if (g_strcmp0 (_tmp5_, "") != 0) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = selection;
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (_vala_copy_text);
			_vala_copy_text = _tmp7_;
			result = TRUE;
			_g_free0 (selection);
			_g_free0 (nullable_selection);
			if (copy_text) {
				*copy_text = _vala_copy_text;
			} else {
				_g_free0 (_vala_copy_text);
			}
			return result;
		}
		_g_free0 (selection);
	}
	_tmp9_ = base_window_no_copy_text (&_tmp8_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp8_;
	result = _tmp9_;
	_g_free0 (nullable_selection);
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

inline gboolean
base_window_is_empty_text (const gchar* text)
{
	gboolean result;
	g_return_val_if_fail (text != NULL, FALSE);
	result = g_strcmp0 (text, "") == 0;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
base_window_copy (BaseWindow* self)
{
	GtkWidget* focus = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	BaseView* _tmp19_;
	gchar* text = NULL;
	gchar* _tmp20_ = NULL;
	gboolean _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_focus ((GtkWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	focus = _tmp1_;
	_tmp2_ = focus;
	if (_tmp2_ != NULL) {
		GtkWidget* _tmp3_;
		_tmp3_ = focus;
		if (G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), gtk_editable_get_type ())) {
			gint garbage1 = 0;
			gint garbage2 = 0;
			GtkWidget* _tmp4_;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gboolean _tmp7_;
			_tmp4_ = focus;
			_tmp7_ = gtk_editable_get_selection_bounds (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), gtk_editable_get_type (), GtkEditable), &_tmp5_, &_tmp6_);
			garbage1 = _tmp5_;
			garbage2 = _tmp6_;
			if (_tmp7_) {
				GtkWidget* _tmp8_;
				_tmp8_ = focus;
				gtk_editable_copy_clipboard (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), gtk_editable_get_type (), GtkEditable));
				_g_object_unref0 (focus);
				return;
			}
		} else {
			GtkWidget* _tmp9_;
			_tmp9_ = focus;
			if (G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), gtk_text_view_get_type ())) {
				GtkWidget* _tmp10_;
				GtkTextBuffer* _tmp11_;
				_tmp10_ = focus;
				_tmp11_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), gtk_text_view_get_type (), GtkTextView));
				if (gtk_text_buffer_get_has_selection (_tmp11_)) {
					GtkWidget* _tmp12_;
					_tmp12_ = focus;
					g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), gtk_text_view_get_type (), GtkTextView), "copy-clipboard");
					_g_object_unref0 (focus);
					return;
				}
			} else {
				GtkWidget* _tmp13_;
				_tmp13_ = focus;
				if (G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), gtk_label_get_type ())) {
					gint garbage1 = 0;
					gint garbage2 = 0;
					GtkWidget* _tmp14_;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					gboolean _tmp17_;
					_tmp14_ = focus;
					_tmp17_ = gtk_label_get_selection_bounds (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), gtk_label_get_type (), GtkLabel), &_tmp15_, &_tmp16_);
					garbage1 = _tmp15_;
					garbage2 = _tmp16_;
					if (_tmp17_) {
						GtkWidget* _tmp18_;
						_tmp18_ = focus;
						g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), gtk_label_get_type (), GtkLabel), "copy-clipboard");
						_g_object_unref0 (focus);
						return;
					}
				}
			}
		}
	}
	_tmp19_ = self->priv->main_view;
	base_view_close_popovers (_tmp19_);
	_tmp21_ = base_window_handle_copy_text (self, &_tmp20_);
	_g_free0 (text);
	text = _tmp20_;
	if (_tmp21_) {
		const gchar* _tmp22_;
		_tmp22_ = text;
		base_window_copy_text (self, _tmp22_);
	}
	_g_free0 (text);
	_g_object_unref0 (focus);
}

static void
base_window_copy_alt (BaseWindow* self)
{
	BaseView* _tmp0_;
	BaseView* _tmp1_;
	gchar* text = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	if (base_view_is_in_in_window_mode (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->main_view;
	base_view_close_popovers (_tmp1_);
	_tmp3_ = base_window_get_alt_copy_text (self, &_tmp2_);
	_g_free0 (text);
	text = _tmp2_;
	if (_tmp3_) {
		const gchar* _tmp4_;
		_tmp4_ = text;
		base_window_copy_text (self, _tmp4_);
	}
	_g_free0 (text);
}

static inline void
base_window_copy_text (BaseWindow* self,
                       const gchar* text)
{
	GtkApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_vala_return_if_fail (!base_window_is_empty_text (text), "!is_empty_text (text)");
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	base_application_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_BASE_APPLICATION, BaseApplication), (const gchar*) text);
}

static void
base_window_real_paste_text (BaseWindow* self,
                             const gchar* text)
{
}

void
base_window_paste_text (BaseWindow* self,
                        const gchar* text)
{
	BaseWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BASE_WINDOW_GET_CLASS (self);
	if (_klass_->paste_text) {
		_klass_->paste_text (self, text);
	}
}

static void
base_window_paste (BaseWindow* self)
{
	BaseView* _tmp0_;
	GtkWidget* focus = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	if (base_view_is_in_in_window_mode (_tmp0_)) {
		return;
	}
	_tmp1_ = gtk_window_get_focus ((GtkWindow*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	focus = _tmp2_;
	_tmp3_ = focus;
	if (_tmp3_ != NULL) {
		GtkWidget* _tmp4_;
		GtkWidget* _tmp6_;
		_tmp4_ = focus;
		if (G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), gtk_entry_get_type ())) {
			GtkWidget* _tmp5_;
			_tmp5_ = focus;
			g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), gtk_entry_get_type (), GtkEntry), "paste-clipboard");
			_g_object_unref0 (focus);
			return;
		}
		_tmp6_ = focus;
		if (G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), gtk_text_view_get_type ())) {
			GtkWidget* _tmp7_;
			_tmp7_ = focus;
			g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), gtk_text_view_get_type (), GtkTextView), "paste-clipboard");
			_g_object_unref0 (focus);
			return;
		}
	}
	base_window_paste_clipboard_content (self);
	_g_object_unref0 (focus);
}

static void
base_window_paste_alt (BaseWindow* self)
{
	g_return_if_fail (self != NULL);
	base_window_close_in_window_panels (self);
	base_window_paste_clipboard_content (self);
}

static void
base_window_paste_clipboard_content (BaseWindow* self)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	gchar* clipboard_content = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (display);
		return;
	}
	_tmp4_ = base_window_get_clipboard_content (&_tmp3_);
	_g_free0 (clipboard_content);
	clipboard_content = _tmp3_;
	if (_tmp4_) {
		const gchar* _tmp5_;
		_tmp5_ = clipboard_content;
		base_window_paste_text (self, _tmp5_);
	}
	_g_free0 (clipboard_content);
	_g_object_unref0 (display);
}

static inline gboolean
base_window_get_clipboard_content (gchar** clipboard_content)
{
	gchar* _vala_clipboard_content = NULL;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkDisplay* _tmp3_;
	GtkClipboard* _tmp4_;
	gchar* _tmp5_;
	gboolean result;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (_tmp2_ == NULL) {
		_g_free0 (_vala_clipboard_content);
		_vala_clipboard_content = NULL;
		result = FALSE;
		_g_object_unref0 (display);
		if (clipboard_content) {
			*clipboard_content = _vala_clipboard_content;
		} else {
			_g_free0 (_vala_clipboard_content);
		}
		return result;
	}
	_tmp3_ = display;
	_tmp4_ = gtk_clipboard_get_default (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gdk_display_get_type (), GdkDisplay));
	_tmp5_ = gtk_clipboard_wait_for_text (_tmp4_);
	_g_free0 (_vala_clipboard_content);
	_vala_clipboard_content = _tmp5_;
	result = TRUE;
	_g_object_unref0 (display);
	if (clipboard_content) {
		*clipboard_content = _vala_clipboard_content;
	} else {
		_g_free0 (_vala_clipboard_content);
	}
	return result;
}

static void
base_window_toggle_hamburger (BaseWindow* self)
{
	BaseHeaderBar* _tmp0_;
	BaseView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	base_header_bar_toggle_hamburger_menu (_tmp0_);
	_tmp1_ = self->priv->main_view;
	base_view_close_popovers (_tmp1_);
}

static void
base_window_real_menu_pressed (BaseWindow* self)
{
	BaseHeaderBar* _tmp0_;
	BaseView* _tmp1_;
	_tmp0_ = self->priv->headerbar;
	base_header_bar_toggle_hamburger_menu (_tmp0_);
	_tmp1_ = self->priv->main_view;
	base_view_close_popovers (_tmp1_);
}

void
base_window_menu_pressed (BaseWindow* self)
{
	BaseWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BASE_WINDOW_GET_CLASS (self);
	if (_klass_->menu_pressed) {
		_klass_->menu_pressed (self);
	}
}

static gboolean
base_window_real_on_key_press_event (BaseWindow* self,
                                     GtkWidget* widget,
                                     GdkEventKey* event)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_help_string_or_empty;
	result = _base_window_on_key_press_event (widget, event, _tmp0_);
	return result;
}

gboolean
base_window_on_key_press_event (BaseWindow* self,
                                GtkWidget* widget,
                                GdkEventKey* event)
{
	BaseWindowClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BASE_WINDOW_GET_CLASS (self);
	if (_klass_->on_key_press_event) {
		return _klass_->on_key_press_event (self, widget, event);
	}
	return FALSE;
}

static gboolean
_base_window_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                            GdkEventKey* event,
                                                            gpointer self)
{
	gboolean result;
	result = base_window_on_key_press_event ((BaseWindow*) self, _sender, event);
	return result;
}

static gboolean
_base_window_on_key_press_event (GtkWidget* widget,
                                 GdkEventKey* event,
                                 const gchar* help_string_or_empty)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (help_string_or_empty != NULL, FALSE);
	_tmp1_ = gdk_keyval_name (event->keyval);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup ((const gchar*) _tmp0_);
	name = _tmp2_;
	_tmp3_ = name;
	if (g_strcmp0 (_tmp3_, "F1") == 0) {
		BaseWindow* _this = NULL;
		BaseWindow* _tmp4_;
		BaseWindow* _tmp5_;
		BaseHeaderBar* _tmp6_;
		BaseWindow* _tmp7_;
		BaseView* _tmp8_;
		BaseWindow* _tmp10_;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (widget, TYPE_BASE_WINDOW, BaseWindow));
		_this = _tmp4_;
		_tmp5_ = _this;
		_tmp6_ = _tmp5_->priv->headerbar;
		base_header_bar_close_popovers (_tmp6_);
		_tmp7_ = _this;
		_tmp8_ = _tmp7_->priv->main_view;
		base_view_close_popovers (_tmp8_);
		if ((event->state & GDK_CONTROL_MASK) != 0) {
			result = FALSE;
			_g_object_unref0 (_this);
			_g_free0 (name);
			return result;
		}
		if ((event->state & GDK_SHIFT_MASK) == 0) {
			BaseWindow* _tmp9_;
			_tmp9_ = _this;
			result = base_window_show_application_help (_tmp9_, help_string_or_empty);
			_g_object_unref0 (_this);
			_g_free0 (name);
			return result;
		}
		_tmp10_ = _this;
		base_window_about (_tmp10_);
		result = TRUE;
		_g_object_unref0 (_this);
		_g_free0 (name);
		return result;
	}
	result = FALSE;
	_g_free0 (name);
	return result;
}

static void
base_window_help (BaseWindow* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_help_string_or_empty;
	base_window_show_application_help (self, _tmp0_);
}

static inline gboolean
base_window_show_application_help (BaseWindow* _this,
                                   const gchar* help_string_or_empty)
{
	gboolean success = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (_this != NULL, FALSE);
	g_return_val_if_fail (help_string_or_empty != NULL, FALSE);
	if (g_strcmp0 (help_string_or_empty, "") == 0) {
		result = FALSE;
		return result;
	}
	{
		gtk_show_uri_on_window ((GtkWindow*) _this, help_string_or_empty, gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		success = TRUE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("base-window.vala:331: Failed to show help: %s", _tmp1_);
		success = FALSE;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = success;
	return result;
}

static void
base_window_real_set_window_size (BaseWindow* self,
                                  AdaptativeWidgetWindowSize new_size)
{
	gboolean _tmp0_ = FALSE;
	gboolean _disable_popovers = FALSE;
	if (adaptative_widget_window_size_is_phone_size (new_size)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = adaptative_widget_window_size_is_extra_thin (new_size);
	}
	_disable_popovers = _tmp0_;
	if (self->priv->disable_popovers != _disable_popovers) {
		gboolean _tmp1_;
		self->priv->disable_popovers = _disable_popovers;
		_tmp1_ = self->priv->_in_window_about;
		if (_tmp1_) {
			base_window_show_default_view (self);
		}
	}
}

void
base_window_set_window_size (BaseWindow* self,
                             AdaptativeWidgetWindowSize new_size)
{
	BaseWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BASE_WINDOW_GET_CLASS (self);
	if (_klass_->set_window_size) {
		_klass_->set_window_size (self, new_size);
	}
}

static void
base_window_real_close_in_window_panels (BaseWindow* self)
{
	BaseHeaderBar* _tmp0_;
	gboolean _tmp1_;
	base_window_hide_notification (self);
	_tmp0_ = self->priv->headerbar;
	base_header_bar_close_popovers (_tmp0_);
	_tmp1_ = self->priv->_in_window_about;
	if (_tmp1_) {
		base_window_show_default_view (self);
	}
}

void
base_window_close_in_window_panels (BaseWindow* self)
{
	BaseWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BASE_WINDOW_GET_CLASS (self);
	if (_klass_->close_in_window_panels) {
		_klass_->close_in_window_panels (self);
	}
}

static void
_base_window_escape_pressed (BaseWindow* self)
{
	g_return_if_fail (self != NULL);
	base_window_escape_pressed (self);
}

static gboolean
base_window_real_escape_pressed (BaseWindow* self)
{
	gboolean _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->_in_window_about;
	if (_tmp0_) {
		base_window_show_default_view (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
base_window_escape_pressed (BaseWindow* self)
{
	BaseWindowClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BASE_WINDOW_GET_CLASS (self);
	if (_klass_->escape_pressed) {
		return _klass_->escape_pressed (self);
	}
	return FALSE;
}

static void
base_window_real_show_default_view (BaseWindow* self)
{
	gboolean _tmp0_;
	_tmp0_ = self->priv->_in_window_about;
	if (_tmp0_) {
		BaseHeaderBar* _tmp1_;
		BaseView* _tmp2_;
		base_window_set_in_window_about (self, FALSE);
		_tmp1_ = self->priv->headerbar;
		base_header_bar_show_default_view (_tmp1_);
		_tmp2_ = self->priv->main_view;
		base_view_show_default_view (_tmp2_);
	} else {
		g_assert_not_reached ();
	}
}

void
base_window_show_default_view (BaseWindow* self)
{
	BaseWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BASE_WINDOW_GET_CLASS (self);
	if (_klass_->show_default_view) {
		_klass_->show_default_view (self);
	}
}

static void
___lambda10_ (BaseWindow* self,
              GtkDialog* _about_dialog,
              gint response)
{
	g_return_if_fail (_about_dialog != NULL);
	gtk_widget_hide ((GtkWidget*) _about_dialog);
}

static void
____lambda10__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda10_ ((BaseWindow*) self, _sender, response_id);
}

static gboolean
_base_window_about_dialog_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                      GdkEventKey* event,
                                                                      gpointer self)
{
	gboolean result;
	result = base_window_about_dialog_key_press_event (_sender, event);
	return result;
}

static void
base_window_show_about_dialog (BaseWindow* self)
{
	GtkAboutDialog* _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->should_init_about_dialog) {
		GtkAboutDialog* _tmp0_;
		GtkAboutDialog* _tmp1_;
		GtkAboutDialog* _tmp2_;
		base_window_create_about_dialog (self);
		_tmp0_ = self->priv->about_dialog;
		g_signal_connect_object ((GtkDialog*) _tmp0_, "response", (GCallback) ____lambda10__gtk_dialog_response, self, 0);
		_tmp1_ = self->priv->about_dialog;
		g_signal_connect ((GtkWidget*) _tmp1_, "key-press-event", (GCallback) _base_window_about_dialog_key_press_event_gtk_widget_key_press_event, NULL);
		_tmp2_ = self->priv->about_dialog;
		gtk_window_set_transient_for ((GtkWindow*) _tmp2_, (GtkWindow*) self);
		self->priv->should_init_about_dialog = FALSE;
	}
	_tmp3_ = self->priv->about_dialog;
	gtk_dialog_run ((GtkDialog*) _tmp3_);
}

static gboolean
base_window_about_dialog_key_press_event (GtkWidget* _about_dialog_widget,
                                          GdkEventKey* event)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (_about_dialog_widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = gdk_keyval_name (event->keyval);
	_tmp1_ = _tmp2_;
	if (_tmp1_ == NULL) {
		_tmp1_ = "";
	}
	if (g_strcmp0 ((const gchar*) _tmp1_, "F1") == 0) {
		_tmp0_ = (event->state & GDK_SHIFT_MASK) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_dialog_response (G_TYPE_CHECK_INSTANCE_CAST (_about_dialog_widget, gtk_dialog_get_type (), GtkDialog), (gint) GTK_RESPONSE_CANCEL);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
base_window_create_about_dialog (BaseWindow* self)
{
	gchar** artists = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** authors = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	gchar* comments = NULL;
	gchar* copyright = NULL;
	gchar* logo_icon_name = NULL;
	gchar* program_name = NULL;
	gchar* translator_credits = NULL;
	gchar* version = NULL;
	gchar* website = NULL;
	gchar* website_label = NULL;
	GtkApplication* _tmp0_;
	gchar** _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GtkAboutDialog* _tmp15_;
	GtkAboutDialog* _tmp16_;
	BaseHeaderBar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GtkAboutDialog* _tmp20_;
	GtkAboutDialog* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** _tmp25_;
	gint _tmp25__length1;
	const gchar* _tmp28_;
	const gchar* _tmp31_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	const gchar* _tmp37_;
	const gchar* _tmp40_;
	const gchar* _tmp43_;
	const gchar* _tmp46_;
	const gchar* _tmp49_;
	const gchar* _tmp52_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	base_application_get_about_dialog_infos (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_BASE_APPLICATION, BaseApplication), &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	artists = _tmp1_;
	artists_length1 = _tmp2_;
	_artists_size_ = artists_length1;
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	authors = _tmp3_;
	authors_length1 = _tmp4_;
	_authors_size_ = authors_length1;
	_g_free0 (comments);
	comments = _tmp5_;
	_g_free0 (copyright);
	copyright = _tmp6_;
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	documenters = _tmp7_;
	documenters_length1 = _tmp8_;
	_documenters_size_ = documenters_length1;
	_g_free0 (logo_icon_name);
	logo_icon_name = _tmp9_;
	_g_free0 (program_name);
	program_name = _tmp10_;
	_g_free0 (translator_credits);
	translator_credits = _tmp11_;
	_g_free0 (version);
	version = _tmp12_;
	_g_free0 (website);
	website = _tmp13_;
	_g_free0 (website_label);
	website_label = _tmp14_;
	_tmp15_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = _tmp15_;
	_tmp16_ = self->priv->about_dialog;
	_tmp17_ = self->priv->headerbar;
	_tmp18_ = base_header_bar_get_about_action_label (_tmp17_);
	_tmp19_ = _tmp18_;
	gtk_window_set_title ((GtkWindow*) _tmp16_, _tmp19_);
	_tmp20_ = self->priv->about_dialog;
	gtk_about_dialog_set_wrap_license (_tmp20_, TRUE);
	_tmp21_ = self->priv->about_dialog;
	gtk_about_dialog_set_license_type (_tmp21_, GTK_LICENSE_GPL_3_0);
	_tmp22_ = artists;
	_tmp22__length1 = artists_length1;
	if (_tmp22__length1 > 0) {
		GtkAboutDialog* _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		_tmp23_ = self->priv->about_dialog;
		_tmp24_ = artists;
		_tmp24__length1 = artists_length1;
		gtk_about_dialog_set_artists (_tmp23_, _tmp24_);
	}
	_tmp25_ = authors;
	_tmp25__length1 = authors_length1;
	if (_tmp25__length1 > 0) {
		GtkAboutDialog* _tmp26_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp26_ = self->priv->about_dialog;
		_tmp27_ = authors;
		_tmp27__length1 = authors_length1;
		gtk_about_dialog_set_authors (_tmp26_, _tmp27_);
	}
	_tmp28_ = comments;
	if (g_strcmp0 (_tmp28_, "") != 0) {
		GtkAboutDialog* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = self->priv->about_dialog;
		_tmp30_ = comments;
		gtk_about_dialog_set_comments (_tmp29_, _tmp30_);
	}
	_tmp31_ = copyright;
	if (g_strcmp0 (_tmp31_, "") != 0) {
		GtkAboutDialog* _tmp32_;
		const gchar* _tmp33_;
		_tmp32_ = self->priv->about_dialog;
		_tmp33_ = copyright;
		gtk_about_dialog_set_copyright (_tmp32_, _tmp33_);
	}
	_tmp34_ = documenters;
	_tmp34__length1 = documenters_length1;
	if (_tmp34__length1 > 0) {
		GtkAboutDialog* _tmp35_;
		gchar** _tmp36_;
		gint _tmp36__length1;
		_tmp35_ = self->priv->about_dialog;
		_tmp36_ = documenters;
		_tmp36__length1 = documenters_length1;
		gtk_about_dialog_set_documenters (_tmp35_, _tmp36_);
	}
	_tmp37_ = logo_icon_name;
	if (g_strcmp0 (_tmp37_, "") != 0) {
		GtkAboutDialog* _tmp38_;
		const gchar* _tmp39_;
		_tmp38_ = self->priv->about_dialog;
		_tmp39_ = logo_icon_name;
		gtk_about_dialog_set_logo_icon_name (_tmp38_, _tmp39_);
	}
	_tmp40_ = program_name;
	if (g_strcmp0 (_tmp40_, "") != 0) {
		GtkAboutDialog* _tmp41_;
		const gchar* _tmp42_;
		_tmp41_ = self->priv->about_dialog;
		_tmp42_ = program_name;
		gtk_about_dialog_set_program_name (_tmp41_, _tmp42_);
	} else {
		g_assert_not_reached ();
	}
	_tmp43_ = translator_credits;
	if (g_strcmp0 (_tmp43_, "") != 0) {
		GtkAboutDialog* _tmp44_;
		const gchar* _tmp45_;
		_tmp44_ = self->priv->about_dialog;
		_tmp45_ = translator_credits;
		gtk_about_dialog_set_translator_credits (_tmp44_, _tmp45_);
	}
	_tmp46_ = version;
	if (g_strcmp0 (_tmp46_, "") != 0) {
		GtkAboutDialog* _tmp47_;
		const gchar* _tmp48_;
		_tmp47_ = self->priv->about_dialog;
		_tmp48_ = version;
		gtk_about_dialog_set_version (_tmp47_, _tmp48_);
	}
	_tmp49_ = website;
	if (g_strcmp0 (_tmp49_, "") != 0) {
		GtkAboutDialog* _tmp50_;
		const gchar* _tmp51_;
		_tmp50_ = self->priv->about_dialog;
		_tmp51_ = website;
		gtk_about_dialog_set_website (_tmp50_, _tmp51_);
	}
	_tmp52_ = website_label;
	if (g_strcmp0 (_tmp52_, "") != 0) {
		GtkAboutDialog* _tmp53_;
		const gchar* _tmp54_;
		_tmp53_ = self->priv->about_dialog;
		_tmp54_ = website_label;
		gtk_about_dialog_set_website_label (_tmp53_, _tmp54_);
	}
	_g_free0 (website_label);
	_g_free0 (website);
	_g_free0 (version);
	_g_free0 (translator_credits);
	_g_free0 (program_name);
	_g_free0 (logo_icon_name);
	_g_free0 (copyright);
	_g_free0 (comments);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
}

static void
base_window_about (BaseWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->disable_popovers) {
		base_window_toggle_in_window_about (self);
	} else {
		base_window_show_about_dialog (self);
	}
}

static void
base_window_toggle_in_window_about (BaseWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->should_init_in_window_about) {
		base_window_init_in_window_about (self);
		self->priv->should_init_in_window_about = FALSE;
		base_window_show_about_view (self);
	} else {
		gboolean _tmp0_;
		_tmp0_ = self->priv->_in_window_about;
		if (_tmp0_) {
			base_window_show_default_view (self);
		} else {
			base_window_show_about_view (self);
		}
	}
}

static void
base_window_init_in_window_about (BaseWindow* self)
{
	gchar** artists = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** authors = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	gchar* comments = NULL;
	gchar* copyright = NULL;
	gchar* logo_icon_name = NULL;
	gchar* program_name = NULL;
	gchar* translator_credits = NULL;
	gchar* version = NULL;
	gchar* website = NULL;
	gchar* website_label = NULL;
	GtkApplication* _tmp0_;
	gchar** _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	BaseView* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	base_application_get_about_dialog_infos (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_BASE_APPLICATION, BaseApplication), &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	artists = _tmp1_;
	artists_length1 = _tmp2_;
	_artists_size_ = artists_length1;
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	authors = _tmp3_;
	authors_length1 = _tmp4_;
	_authors_size_ = authors_length1;
	_g_free0 (comments);
	comments = _tmp5_;
	_g_free0 (copyright);
	copyright = _tmp6_;
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	documenters = _tmp7_;
	documenters_length1 = _tmp8_;
	_documenters_size_ = documenters_length1;
	_g_free0 (logo_icon_name);
	logo_icon_name = _tmp9_;
	_g_free0 (program_name);
	program_name = _tmp10_;
	_g_free0 (translator_credits);
	translator_credits = _tmp11_;
	_g_free0 (version);
	version = _tmp12_;
	_g_free0 (website);
	website = _tmp13_;
	_g_free0 (website_label);
	website_label = _tmp14_;
	_tmp15_ = self->priv->main_view;
	base_view_create_about_list (_tmp15_, &artists, (gint*) (&artists_length1), &authors, (gint*) (&authors_length1), &comments, &copyright, &documenters, (gint*) (&documenters_length1), &logo_icon_name, &program_name, &translator_credits, &version, &website, &website_label);
	_artists_size_ = artists_length1;
	_authors_size_ = authors_length1;
	_documenters_size_ = documenters_length1;
	_g_free0 (website_label);
	_g_free0 (website);
	_g_free0 (version);
	_g_free0 (translator_credits);
	_g_free0 (program_name);
	_g_free0 (logo_icon_name);
	_g_free0 (copyright);
	_g_free0 (comments);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
}

static inline void
base_window_show_about_view (BaseWindow* self)
{
	gboolean _tmp0_;
	BaseHeaderBar* _tmp1_;
	BaseView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_in_window_about;
	_vala_return_if_fail (_tmp0_ == FALSE, "in_window_about == false");
	base_window_close_in_window_panels (self);
	base_window_set_in_window_about (self, TRUE);
	_tmp1_ = self->priv->headerbar;
	base_header_bar_show_about_view (_tmp1_);
	_tmp2_ = self->priv->main_view;
	base_view_show_about_view (_tmp2_);
	gtk_window_set_focus_visible ((GtkWindow*) self, FALSE);
}

void
base_window_show_notification (BaseWindow* self,
                               const gchar* notification)
{
	BaseView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_tmp0_ = self->priv->main_view;
	base_view_show_notification (_tmp0_, notification);
}

void
base_window_hide_notification (BaseWindow* self)
{
	BaseView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	base_view_hide_notification (_tmp0_);
}

BaseWindow*
base_window_construct (GType object_type)
{
	BaseWindow * self = NULL;
	self = (BaseWindow*) adaptative_window_construct (object_type);
	return self;
}

BaseWindow*
base_window_new (void)
{
	return base_window_construct (TYPE_BASE_WINDOW);
}

BaseView*
base_window_get_base_view (BaseWindow* self)
{
	BaseView* result;
	BaseView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->main_view;
	result = _tmp0_;
	return result;
}

static void
base_window_set_base_view (BaseWindow* self,
                           BaseView* value)
{
	BaseView* _value = NULL;
	BaseView* _tmp0_;
	BaseView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_value = _tmp0_;
	if (_value == NULL) {
		g_assert_not_reached ();
	}
	_tmp1_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->main_view);
	self->priv->main_view = _tmp1_;
	gtk_widget_set_vexpand ((GtkWidget*) value, TRUE);
	gtk_widget_set_visible ((GtkWidget*) value, TRUE);
	base_window_add_to_main_grid (self, (GtkWidget*) value);
	_g_object_unref0 (_value);
}

static const gchar*
base_window_get_help_string_or_empty (BaseWindow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_help_string_or_empty;
	result = _tmp0_;
	return result;
}

static void
base_window_set_help_string_or_empty (BaseWindow* self,
                                      const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_help_string_or_empty);
	self->priv->_help_string_or_empty = _tmp0_;
}

gboolean
base_window_get_in_window_about (BaseWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_in_window_about;
	return result;
}

static void
base_window_set_in_window_about (BaseWindow* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_in_window_about = value;
}

static GObject *
base_window_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BaseWindow * self;
	NightTimeAwareHeaderBar* _tmp0_;
	NightTimeAwareHeaderBar* _tmp1_;
	BaseHeaderBar* _tmp2_;
	BaseHeaderBar* _tmp3_;
	BaseView* _tmp4_;
	parent_class = G_OBJECT_CLASS (base_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BASE_WINDOW, BaseWindow);
	_tmp0_ = adaptative_window_get_nta_headerbar ((AdaptativeWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_BASE_HEADER_BAR, BaseHeaderBar));
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp2_;
	base_window_install_action_entries (self);
	_tmp3_ = self->priv->headerbar;
	adaptative_window_add_adaptative_child ((AdaptativeWindow*) self, (AdaptativeWidget*) _tmp3_);
	_tmp4_ = self->priv->main_view;
	adaptative_window_add_adaptative_child ((AdaptativeWindow*) self, (AdaptativeWidget*) _tmp4_);
	adaptative_window_add_adaptative_child ((AdaptativeWindow*) self, (AdaptativeWidget*) self);
	return obj;
}

static void
base_window_class_init (BaseWindowClass * klass,
                        gpointer klass_data)
{
	base_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaseWindow_private_offset);
	((BaseWindowClass *) klass)->handle_copy_text = (gboolean (*) (BaseWindow*, gchar**)) base_window_real_handle_copy_text;
	((BaseWindowClass *) klass)->get_alt_copy_text = (gboolean (*) (BaseWindow*, gchar**)) base_window_real_get_alt_copy_text;
	((BaseWindowClass *) klass)->paste_text = (void (*) (BaseWindow*, const gchar*)) base_window_real_paste_text;
	((BaseWindowClass *) klass)->menu_pressed = (void (*) (BaseWindow*)) base_window_real_menu_pressed;
	((BaseWindowClass *) klass)->on_key_press_event = (gboolean (*) (BaseWindow*, GtkWidget*, GdkEventKey*)) base_window_real_on_key_press_event;
	((BaseWindowClass *) klass)->set_window_size = (void (*) (BaseWindow*, AdaptativeWidgetWindowSize)) base_window_real_set_window_size;
	((BaseWindowClass *) klass)->close_in_window_panels = (void (*) (BaseWindow*)) base_window_real_close_in_window_panels;
	((BaseWindowClass *) klass)->escape_pressed = (gboolean (*) (BaseWindow*)) base_window_real_escape_pressed;
	((BaseWindowClass *) klass)->show_default_view = (void (*) (BaseWindow*)) base_window_real_show_default_view;
	G_OBJECT_CLASS (klass)->get_property = _vala_base_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_base_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = base_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = base_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BASE_WINDOW_BASE_VIEW_PROPERTY, base_window_properties[BASE_WINDOW_BASE_VIEW_PROPERTY] = g_param_spec_object ("base-view", "base-view", "base-view", TYPE_BASE_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BASE_WINDOW_HELP_STRING_OR_EMPTY_PROPERTY, base_window_properties[BASE_WINDOW_HELP_STRING_OR_EMPTY_PROPERTY] = g_param_spec_string ("help-string-or-empty", "help-string-or-empty", "help-string-or-empty", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BASE_WINDOW_IN_WINDOW_ABOUT_PROPERTY, base_window_properties[BASE_WINDOW_IN_WINDOW_ABOUT_PROPERTY] = g_param_spec_boolean ("in-window-about", "in-window-about", "in-window-about", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/base-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_grid", FALSE, BaseWindow_private_offset + G_STRUCT_OFFSET (BaseWindowPrivate, main_grid));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_key_press_event", G_CALLBACK(_base_window_on_key_press_event_gtk_widget_key_press_event));
}

static void
base_window_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                              gpointer iface_data)
{
	base_window_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) base_window_set_window_size;
}

static void
base_window_instance_init (BaseWindow * self,
                           gpointer klass)
{
	gchar* _tmp0_;
	self->priv = base_window_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_help_string_or_empty = _tmp0_;
	self->priv->disable_popovers = FALSE;
	self->priv->should_init_about_dialog = TRUE;
	self->priv->_in_window_about = FALSE;
	self->priv->should_init_in_window_about = TRUE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
base_window_finalize (GObject * obj)
{
	BaseWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BASE_WINDOW, BaseWindow);
	_g_object_unref0 (self->priv->main_view);
	_g_object_unref0 (self->priv->headerbar);
	_g_free0 (self->priv->_help_string_or_empty);
	_g_object_unref0 (self->priv->about_dialog);
	G_OBJECT_CLASS (base_window_parent_class)->finalize (obj);
}

static GType
base_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaseWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) base_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaseWindow), 0, (GInstanceInitFunc) base_window_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) base_window_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType base_window_type_id;
	base_window_type_id = g_type_register_static (TYPE_ADAPTATIVE_WINDOW, "BaseWindow", &g_define_type_info, 0);
	g_type_add_interface_static (base_window_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	BaseWindow_private_offset = g_type_add_instance_private (base_window_type_id, sizeof (BaseWindowPrivate));
	return base_window_type_id;
}

GType
base_window_get_type (void)
{
	static volatile gsize base_window_type_id__once = 0;
	if (g_once_init_enter (&base_window_type_id__once)) {
		GType base_window_type_id;
		base_window_type_id = base_window_get_type_once ();
		g_once_init_leave (&base_window_type_id__once, base_window_type_id);
	}
	return base_window_type_id__once;
}

static void
_vala_base_window_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	BaseWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BASE_WINDOW, BaseWindow);
	switch (property_id) {
		case BASE_WINDOW_BASE_VIEW_PROPERTY:
		g_value_set_object (value, base_window_get_base_view (self));
		break;
		case BASE_WINDOW_HELP_STRING_OR_EMPTY_PROPERTY:
		g_value_set_string (value, base_window_get_help_string_or_empty (self));
		break;
		case BASE_WINDOW_IN_WINDOW_ABOUT_PROPERTY:
		g_value_set_boolean (value, base_window_get_in_window_about (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_base_window_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	BaseWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BASE_WINDOW, BaseWindow);
	switch (property_id) {
		case BASE_WINDOW_BASE_VIEW_PROPERTY:
		base_window_set_base_view (self, g_value_get_object (value));
		break;
		case BASE_WINDOW_HELP_STRING_OR_EMPTY_PROPERTY:
		base_window_set_help_string_or_empty (self, g_value_get_string (value));
		break;
		case BASE_WINDOW_IN_WINDOW_ABOUT_PROPERTY:
		base_window_set_in_window_about (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

