/* dconf-view.c generated by valac 0.56.2, the Vala compiler
 * generated from dconf-view.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#define MODEL_UTILS_dconf_context_id ((guint16) 2)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_VIEW (base_view_get_type ())
#define BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_VIEW, BaseView))
#define BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_VIEW, BaseViewClass))
#define IS_BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_VIEW))
#define IS_BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_VIEW))
#define BASE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_VIEW, BaseViewClass))

typedef struct _BaseView BaseView;
typedef struct _BaseViewClass BaseViewClass;
typedef struct _BaseViewPrivate BaseViewPrivate;

#define TYPE_BROWSER_VIEW (browser_view_get_type ())
#define BROWSER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_VIEW, BrowserView))
#define BROWSER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_VIEW, BrowserViewClass))
#define IS_BROWSER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_VIEW))
#define IS_BROWSER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_VIEW))
#define BROWSER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_VIEW, BrowserViewClass))

typedef struct _BrowserView BrowserView;
typedef struct _BrowserViewClass BrowserViewClass;
typedef struct _BrowserViewPrivate BrowserViewPrivate;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_BROWSER_INFO_BAR (browser_info_bar_get_type ())
#define BROWSER_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_INFO_BAR, BrowserInfoBar))
#define BROWSER_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_INFO_BAR, BrowserInfoBarClass))
#define IS_BROWSER_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_INFO_BAR))
#define IS_BROWSER_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_INFO_BAR))
#define BROWSER_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_INFO_BAR, BrowserInfoBarClass))

typedef struct _BrowserInfoBar BrowserInfoBar;
typedef struct _BrowserInfoBarClass BrowserInfoBarClass;

#define TYPE_SORTING_OPTIONS (sorting_options_get_type ())
#define SORTING_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTING_OPTIONS, SortingOptions))
#define SORTING_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTING_OPTIONS, SortingOptionsClass))
#define IS_SORTING_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTING_OPTIONS))
#define IS_SORTING_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTING_OPTIONS))
#define SORTING_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTING_OPTIONS, SortingOptionsClass))

typedef struct _SortingOptions SortingOptions;
typedef struct _SortingOptionsClass SortingOptionsClass;

#define TYPE_BOOKMARKS_VIEW (bookmarks_view_get_type ())
#define BOOKMARKS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_VIEW, BookmarksView))
#define BOOKMARKS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_VIEW, BookmarksViewClass))
#define IS_BOOKMARKS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_VIEW))
#define IS_BOOKMARKS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_VIEW))
#define BOOKMARKS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_VIEW, BookmarksViewClass))

typedef struct _BookmarksView BookmarksView;
typedef struct _BookmarksViewClass BookmarksViewClass;
typedef struct _BookmarksViewPrivate BookmarksViewPrivate;

#define TYPE_DCONF_VIEW (dconf_view_get_type ())
#define DCONF_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_VIEW, DConfView))
#define DCONF_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_VIEW, DConfViewClass))
#define IS_DCONF_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_VIEW))
#define IS_DCONF_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_VIEW))
#define DCONF_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_VIEW, DConfViewClass))

typedef struct _DConfView DConfView;
typedef struct _DConfViewClass DConfViewClass;
typedef struct _DConfViewPrivate DConfViewPrivate;

#define TYPE_BROWSER_STACK (browser_stack_get_type ())
#define BROWSER_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_STACK, BrowserStack))
#define BROWSER_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_STACK, BrowserStackClass))
#define IS_BROWSER_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_STACK))
#define IS_BROWSER_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_STACK))
#define BROWSER_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_STACK, BrowserStackClass))

typedef struct _BrowserStack BrowserStack;
typedef struct _BrowserStackClass BrowserStackClass;

#define TYPE_MODIFICATIONS_HANDLER (modifications_handler_get_type ())
#define MODIFICATIONS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFICATIONS_HANDLER, ModificationsHandler))
#define MODIFICATIONS_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFICATIONS_HANDLER, ModificationsHandlerClass))
#define IS_MODIFICATIONS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFICATIONS_HANDLER))
#define IS_MODIFICATIONS_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFICATIONS_HANDLER))
#define MODIFICATIONS_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFICATIONS_HANDLER, ModificationsHandlerClass))

typedef struct _ModificationsHandler ModificationsHandler;
typedef struct _ModificationsHandlerClass ModificationsHandlerClass;

#define TYPE_OVERLAYED_LIST (overlayed_list_get_type ())
#define OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAYED_LIST, OverlayedList))
#define OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAYED_LIST, OverlayedListClass))
#define IS_OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAYED_LIST))
#define IS_OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAYED_LIST))
#define OVERLAYED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAYED_LIST, OverlayedListClass))

typedef struct _OverlayedList OverlayedList;
typedef struct _OverlayedListClass OverlayedListClass;

#define TYPE_MODIFICATIONS_LIST (modifications_list_get_type ())
#define MODIFICATIONS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFICATIONS_LIST, ModificationsList))
#define MODIFICATIONS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFICATIONS_LIST, ModificationsListClass))
#define IS_MODIFICATIONS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFICATIONS_LIST))
#define IS_MODIFICATIONS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFICATIONS_LIST))
#define MODIFICATIONS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFICATIONS_LIST, ModificationsListClass))

typedef struct _ModificationsList ModificationsList;
typedef struct _ModificationsListClass ModificationsListClass;
enum  {
	DCONF_VIEW_0_PROPERTY,
	DCONF_VIEW_MODIFICATIONS_HANDLER_PROPERTY,
	DCONF_VIEW_IN_WINDOW_MODIFICATIONS_PROPERTY,
	DCONF_VIEW_NUM_PROPERTIES
};
static GParamSpec* dconf_view_properties[DCONF_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BROWSER_CONTENT (browser_content_get_type ())
#define BROWSER_CONTENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_CONTENT, BrowserContent))
#define IS_BROWSER_CONTENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_CONTENT))
#define BROWSER_CONTENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_BROWSER_CONTENT, BrowserContentIface))

typedef struct _BrowserContent BrowserContent;
typedef struct _BrowserContentIface BrowserContentIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef enum  {
	MODIFICATIONS_MODE_NONE,
	MODIFICATIONS_MODE_TEMPORARY,
	MODIFICATIONS_MODE_DELAYED
} ModificationsMode;

#define TYPE_MODIFICATIONS_MODE (modifications_mode_get_type ())

#define TYPE_SIMPLE_SETTING_OBJECT (simple_setting_object_get_type ())
#define SIMPLE_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject))
#define SIMPLE_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObjectClass))
#define IS_SIMPLE_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SETTING_OBJECT))
#define IS_SIMPLE_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SETTING_OBJECT))
#define SIMPLE_SETTING_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObjectClass))

typedef struct _SimpleSettingObject SimpleSettingObject;
typedef struct _SimpleSettingObjectClass SimpleSettingObjectClass;

#define TYPE_SETTINGS_MODEL_CORE (settings_model_core_get_type ())
#define SETTINGS_MODEL_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL_CORE, SettingsModelCore))
#define SETTINGS_MODEL_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL_CORE, SettingsModelCoreClass))
#define IS_SETTINGS_MODEL_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL_CORE))
#define IS_SETTINGS_MODEL_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL_CORE))
#define SETTINGS_MODEL_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL_CORE, SettingsModelCoreClass))

typedef struct _SettingsModelCore SettingsModelCore;
typedef struct _SettingsModelCoreClass SettingsModelCoreClass;

#define TYPE_SETTINGS_MODEL (settings_model_get_type ())
#define SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL, SettingsModel))
#define SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL, SettingsModelClass))
#define IS_SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL))
#define IS_SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL))
#define SETTINGS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL, SettingsModelClass))

typedef struct _SettingsModel SettingsModel;
typedef struct _SettingsModelClass SettingsModelClass;

#define TYPE_REGISTRY_VARIANT_DICT (registry_variant_dict_get_type ())
#define REGISTRY_VARIANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDict))
#define REGISTRY_VARIANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDictClass))
#define IS_REGISTRY_VARIANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VARIANT_DICT))
#define IS_REGISTRY_VARIANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VARIANT_DICT))
#define REGISTRY_VARIANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDictClass))

typedef struct _RegistryVariantDict RegistryVariantDict;
typedef struct _RegistryVariantDictClass RegistryVariantDictClass;
typedef enum  {
	PROPERTY_QUERY_HASH = 1 << 0,
	PROPERTY_QUERY_HAS_SCHEMA = 1 << 1,
	PROPERTY_QUERY_KEY_NAME = 1 << 2,
	PROPERTY_QUERY_TYPE_CODE = 1 << 3,
	PROPERTY_QUERY_KEY_VALUE = 1 << 4,
	PROPERTY_QUERY_FIXED_SCHEMA = 1 << 5,
	PROPERTY_QUERY_SCHEMA_ID = 1 << 6,
	PROPERTY_QUERY_SUMMARY = 1 << 7,
	PROPERTY_QUERY_DESCRIPTION = 1 << 8,
	PROPERTY_QUERY_DEFAULT_VALUE = 1 << 9,
	PROPERTY_QUERY_RANGE_TYPE = 1 << 10,
	PROPERTY_QUERY_RANGE_CONTENT = 1 << 11,
	PROPERTY_QUERY_MAXIMUM = 1 << 12,
	PROPERTY_QUERY_MINIMUM = 1 << 13,
	PROPERTY_QUERY_KEY_CONFLICT = 1 << 14,
	PROPERTY_QUERY_IS_DEFAULT = 1 << 15
} PropertyQuery;

#define TYPE_PROPERTY_QUERY (property_query_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseView {
	GtkStack parent_instance;
	BaseViewPrivate * priv;
	GtkGrid* main_grid;
};

struct _BaseViewClass {
	GtkStackClass parent_class;
	gboolean (*handle_copy_text) (BaseView* self, gchar** copy_text);
	void (*close_popovers) (BaseView* self);
	void (*set_window_size) (BaseView* self, AdaptativeWidgetWindowSize new_size);
	void (*show_default_view) (BaseView* self);
	gboolean (*is_in_in_window_mode) (BaseView* self);
};

struct _BrowserView {
	BaseView parent_instance;
	BrowserViewPrivate * priv;
	BrowserInfoBar* info_bar;
	SortingOptions* sorting_options;
};

struct _BrowserViewClass {
	BaseViewClass parent_class;
	void (*set_path) (BrowserView* self, ViewType type, const gchar* path);
	gboolean (*next_match) (BrowserView* self);
	gboolean (*previous_match) (BrowserView* self);
	gboolean (*toggle_row_popover) (BrowserView* self);
};

struct _BookmarksView {
	BrowserView parent_instance;
	BookmarksViewPrivate * priv;
};

struct _BookmarksViewClass {
	BrowserViewClass parent_class;
};

struct _DConfView {
	BookmarksView parent_instance;
	DConfViewPrivate * priv;
};

struct _DConfViewClass {
	BookmarksViewClass parent_class;
};

struct _DConfViewPrivate {
	BrowserStack* dconf_content;
	ModificationsHandler* _modifications_handler;
	gboolean _in_window_modifications;
	gboolean modifications_list_created;
	ModificationsList* modifications_list;
};

struct _BrowserContentIface {
	GTypeInterface parent_iface;
	void (*prepare_folder_view) (BrowserContent* self, GListStore* key_model, gboolean is_ancestor);
	void (*prepare_object_view) (BrowserContent* self, const gchar* full_name, guint16 context_id, GVariant* properties, gboolean is_parent);
	void (*set_path) (BrowserContent* self, ViewType type, const gchar* path);
	gchar* (*get_selected_row_name) (BrowserContent* self);
	void (*select_row_named) (BrowserContent* self, const gchar* selected, guint16 last_context_id, gboolean grab_focus_if_needed);
	void (*select_first_row) (BrowserContent* self);
	void (*row_grab_focus) (BrowserContent* self);
	gboolean (*toggle_row_popover) (BrowserContent* self);
	void (*discard_row_popover) (BrowserContent* self);
	void (*invalidate_popovers) (BrowserContent* self);
	gboolean (*check_reload_folder) (BrowserContent* self, GVariant* fresh_key_model);
	gboolean (*check_reload_object) (BrowserContent* self, guint properties_hash);
	gboolean (*handle_copy_text) (BrowserContent* self, gchar** copy_text);
	gboolean (*handle_alt_copy_text) (BrowserContent* self, gchar** copy_text);
	gboolean (*next_match) (BrowserContent* self);
	gboolean (*previous_match) (BrowserContent* self);
	gboolean (*return_pressed) (BrowserContent* self);
	ViewType (*get_current_view) (BrowserContent* self);
	void (*set_current_view) (BrowserContent* self, ViewType value);
};

static gint DConfView_private_offset;
static gpointer dconf_view_parent_class = NULL;
static AdaptativeWidgetIface * dconf_view_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseView, g_object_unref)
VALA_EXTERN GType browser_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserView, g_object_unref)
VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType browser_info_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserInfoBar, g_object_unref)
VALA_EXTERN GType sorting_options_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortingOptions, g_object_unref)
VALA_EXTERN GType bookmarks_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksView, g_object_unref)
VALA_EXTERN GType dconf_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DConfView, g_object_unref)
VALA_EXTERN GType browser_stack_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserStack, g_object_unref)
VALA_EXTERN GType modifications_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ModificationsHandler, g_object_unref)
VALA_EXTERN GType overlayed_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayedList, g_object_unref)
VALA_EXTERN GType modifications_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ModificationsList, g_object_unref)
VALA_EXTERN void base_view_set_window_size (BaseView* self,
                                AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean base_view_is_in_in_window_mode (BaseView* self);
VALA_EXTERN void base_view_show_default_view (BaseView* self);
VALA_EXTERN void browser_view_set_path (BrowserView* self,
                            ViewType type,
                            const gchar* path);
VALA_EXTERN gboolean browser_view_next_match (BrowserView* self);
VALA_EXTERN gboolean browser_view_previous_match (BrowserView* self);
VALA_EXTERN gboolean base_view_handle_copy_text (BaseView* self,
                                     gchar** copy_text);
static void dconf_view_set_key_value (DConfView* self,
                               GSimpleAction* action,
                               GVariant* value_variant);
static void _dconf_view_set_key_value_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void dconf_view_set_to_default (DConfView* self,
                                GSimpleAction* action,
                                GVariant* path_variant);
static void _dconf_view_set_to_default_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void dconf_view_delay_erase (DConfView* self,
                             GSimpleAction* action,
                             GVariant* path_variant);
static void _dconf_view_delay_erase_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void dconf_view_toggle_dconf_key_switch (DConfView* self,
                                         GSimpleAction* action,
                                         GVariant* value_variant);
static void _dconf_view_toggle_dconf_key_switch_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void dconf_view_toggle_gsettings_key_switch (DConfView* self,
                                             GSimpleAction* action,
                                             GVariant* value_variant);
static void _dconf_view_toggle_gsettings_key_switch_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
VALA_EXTERN DConfView* dconf_view_new (ModificationsHandler* modifications_handler);
VALA_EXTERN DConfView* dconf_view_construct (GType object_type,
                                 ModificationsHandler* modifications_handler);
VALA_EXTERN BrowserStack* browser_stack_new (ModificationsHandler* modifications_handler);
VALA_EXTERN BrowserStack* browser_stack_construct (GType object_type,
                                       ModificationsHandler* modifications_handler);
VALA_EXTERN GType browser_content_get_type (void) G_GNUC_CONST ;
static void dconf_view_real_set_window_size (AdaptativeWidget* base,
                                      AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static gboolean dconf_view_real_is_in_in_window_mode (BaseView* base);
VALA_EXTERN gboolean dconf_view_get_in_window_modifications (DConfView* self);
static void dconf_view_real_show_default_view (BaseView* base);
static void dconf_view_set_in_window_modifications (DConfView* self,
                                             gboolean value);
static void dconf_view_install_action_entries (DConfView* self);
static ModificationsHandler* dconf_view_get_modifications_handler (DConfView* self);
VALA_EXTERN gboolean modifications_handler_get_current_delay_mode (ModificationsHandler* self);
VALA_EXTERN void modifications_handler_add_delayed_setting (ModificationsHandler* self,
                                                const gchar* key_path,
                                                GVariant* new_value,
                                                guint16 context_id);
VALA_EXTERN gboolean model_utils_is_dconf_context_id (guint16 context_id);
VALA_EXTERN void modifications_handler_set_gsettings_key_value (ModificationsHandler* self,
                                                    const gchar* full_name,
                                                    guint16 context_id,
                                                    GVariant* key_value);
VALA_EXTERN void modifications_handler_set_dconf_key_value (ModificationsHandler* self,
                                                const gchar* full_name,
                                                GVariant* key_value);
VALA_EXTERN void modifications_handler_enter_delay_mode (ModificationsHandler* self);
VALA_EXTERN void modifications_handler_set_to_default (ModificationsHandler* self,
                                           const gchar* full_name,
                                           guint16 context_id);
VALA_EXTERN void browser_view_invalidate_popovers (BrowserView* self);
static GVariant* _variant_new9 (gboolean value);
static void dconf_view_create_modifications_list (DConfView* self);
VALA_EXTERN ModificationsList* modifications_list_new (gboolean needs_shadows,
                                           gboolean big_placeholder);
VALA_EXTERN ModificationsList* modifications_list_construct (GType object_type,
                                                 gboolean needs_shadows,
                                                 gboolean big_placeholder);
VALA_EXTERN AdaptativeWidgetWindowSize base_view_get_saved_window_size (BaseView* self);
VALA_EXTERN void dconf_view_show_modifications_view (DConfView* self);
VALA_EXTERN gboolean bookmarks_view_get_in_window_bookmarks (BookmarksView* self);
VALA_EXTERN gboolean base_view_get_in_window_about (BaseView* self);
VALA_EXTERN void overlayed_list_reset (OverlayedList* self);
static void dconf_view_update_in_window_modifications (DConfView* self);
VALA_EXTERN GListStore* modifications_handler_get_delayed_settings (ModificationsHandler* self);
VALA_EXTERN void modifications_list_bind_model (ModificationsList* self,
                                    GListStore* modifications,
                                    GtkListBoxCreateWidgetFunc delayed_setting_row_create,
                                    gpointer delayed_setting_row_create_target);
static GtkWidget* dconf_view_delayed_setting_row_create (DConfView* self,
                                                  GObject* object);
static GtkWidget* _dconf_view_delayed_setting_row_create_gtk_list_box_create_widget_func (GObject* item,
                                                                                   gpointer self);
VALA_EXTERN GType modifications_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ModificationsMode modifications_handler_get_mode (ModificationsHandler* self);
VALA_EXTERN GType simple_setting_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SimpleSettingObject, g_object_unref)
VALA_EXTERN GtkWidget* modifications_revealer_create_delayed_setting_row (ModificationsHandler* modifications_handler,
                                                              const gchar* name,
                                                              const gchar* full_name,
                                                              guint16 context_id);
VALA_EXTERN const gchar* simple_setting_object_get_name (SimpleSettingObject* self);
VALA_EXTERN const gchar* simple_setting_object_get_full_name (SimpleSettingObject* self);
VALA_EXTERN guint16 simple_setting_object_get_context_id (SimpleSettingObject* self);
static void dconf_view_real_set_path (BrowserView* base,
                               ViewType type,
                               const gchar* path);
VALA_EXTERN void browser_content_set_path (BrowserContent* self,
                               ViewType type,
                               const gchar* path);
VALA_EXTERN void modifications_handler_path_changed (ModificationsHandler* self);
VALA_EXTERN void dconf_view_set_search_parameters (DConfView* self,
                                       gboolean local_search,
                                       const gchar* current_path,
                                       gchar** bookmarks,
                                       gint bookmarks_length1);
VALA_EXTERN void browser_view_hide_reload_warning (BrowserView* self);
VALA_EXTERN void browser_stack_set_search_parameters (BrowserStack* self,
                                          gboolean local_search,
                                          const gchar* current_path,
                                          guint16 current_context_id,
                                          gchar** bookmarks,
                                          gint bookmarks_length1,
                                          SortingOptions* sorting_options);
VALA_EXTERN guint16 browser_view_get_last_context_id (BrowserView* self);
VALA_EXTERN gboolean dconf_view_check_reload (DConfView* self,
                                  ViewType type,
                                  const gchar* path,
                                  gboolean show_infobar);
VALA_EXTERN GType settings_model_core_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsModelCore, g_object_unref)
VALA_EXTERN GType settings_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsModel, g_object_unref)
VALA_EXTERN SettingsModel* modifications_handler_get_model (ModificationsHandler* self);
VALA_EXTERN gboolean model_utils_is_folder_path (const gchar* path);
VALA_EXTERN gboolean browser_content_check_reload_folder (BrowserContent* self,
                                              GVariant* fresh_key_model);
VALA_EXTERN GVariant* settings_model_get_children (SettingsModel* self,
                                       const gchar* folder_path,
                                       gboolean watch,
                                       gboolean clean_watched);
VALA_EXTERN void browser_info_bar_show_warning (BrowserInfoBar* self,
                                    const gchar* name);
VALA_EXTERN gboolean settings_model_key_exists (SettingsModel* self,
                                    const gchar* key_path,
                                    guint16 key_context_id);
VALA_EXTERN GType registry_variant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistryVariantDict, g_object_unref)
VALA_EXTERN GVariant* settings_model_get_key_properties (SettingsModel* self,
                                             const gchar* key_path,
                                             guint16 key_context_id,
                                             guint16 query);
VALA_EXTERN GType property_query_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RegistryVariantDict* registry_variant_dict_new_from_aqv (GVariant* variant);
VALA_EXTERN RegistryVariantDict* registry_variant_dict_construct_from_aqv (GType object_type,
                                                               GVariant* variant);
VALA_EXTERN gboolean registry_variant_dict_lookup (RegistryVariantDict* self,
                                       guint16 key,
                                       const gchar* format_string,
                                       ...);
VALA_EXTERN gboolean browser_content_check_reload_object (BrowserContent* self,
                                              guint properties_hash);
VALA_EXTERN void dconf_view_hide_or_show_toggles (DConfView* self,
                                      gboolean show);
VALA_EXTERN void browser_stack_hide_or_show_toggles (BrowserStack* self,
                                         gboolean show);
static gboolean dconf_view_real_next_match (BrowserView* base);
VALA_EXTERN gboolean overlayed_list_next_match (OverlayedList* self);
static gboolean dconf_view_real_previous_match (BrowserView* base);
VALA_EXTERN gboolean overlayed_list_previous_match (OverlayedList* self);
VALA_EXTERN void dconf_view_toggle_boolean_key (DConfView* self);
VALA_EXTERN void browser_stack_toggle_boolean_key (BrowserStack* self);
VALA_EXTERN void dconf_view_set_selected_to_default (DConfView* self);
VALA_EXTERN void browser_stack_set_selected_to_default (BrowserStack* self);
static gboolean dconf_view_real_handle_copy_text (BaseView* base,
                                           gchar** copy_text);
VALA_EXTERN gboolean overlayed_list_handle_copy_text (OverlayedList* self,
                                          gchar** copy_text);
VALA_EXTERN void dconf_view_gkey_value_push (DConfView* self,
                                 const gchar* full_name,
                                 guint16 context_id,
                                 GVariant* key_value,
                                 gboolean is_key_default);
VALA_EXTERN void browser_stack_gkey_value_push (BrowserStack* self,
                                    const gchar* full_name,
                                    guint16 context_id,
                                    GVariant* key_value,
                                    gboolean is_key_default);
VALA_EXTERN void dconf_view_dkey_value_push (DConfView* self,
                                 const gchar* full_name,
                                 GVariant* key_value_or_null);
VALA_EXTERN void browser_stack_dkey_value_push (BrowserStack* self,
                                    const gchar* full_name,
                                    GVariant* key_value_or_null);
static void dconf_view_set_modifications_handler (DConfView* self,
                                           ModificationsHandler* value);
VALA_EXTERN SortingOptions* sorting_options_new (SettingsModel* _model);
VALA_EXTERN SortingOptions* sorting_options_construct (GType object_type,
                                           SettingsModel* _model);
VALA_EXTERN void browser_view_on_case_sensitive_changed (BrowserView* self);
static void _browser_view_on_case_sensitive_changed_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void _dconf_view_update_in_window_modifications_modifications_handler_delayed_changes_changed (ModificationsHandler* _sender,
                                                                                               gpointer self);
static GObject * dconf_view_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static void dconf_view_finalize (GObject * obj);
static GType dconf_view_get_type_once (void);
static void _vala_dconf_view_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_dconf_view_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GActionEntry DCONF_VIEW_action_entries[5] = {{"set-key-value", _dconf_view_set_key_value_gsimple_action_activate_callback, "(sqv)"}, {"set-to-default", _dconf_view_set_to_default_gsimple_action_activate_callback, "(sq)"}, {"delay-erase", _dconf_view_delay_erase_gsimple_action_activate_callback, "s"}, {"toggle-dconf-key-switch", _dconf_view_toggle_dconf_key_switch_gsimple_action_activate_callback, "(sb)"}, {"toggle-gsettings-key-switch", _dconf_view_toggle_gsettings_key_switch_gsimple_action_activate_callback, "(sqbb)"}};

static inline gpointer
dconf_view_get_instance_private (DConfView* self)
{
	return G_STRUCT_MEMBER_P (self, DConfView_private_offset);
}

static void
_dconf_view_set_key_value_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	dconf_view_set_key_value ((DConfView*) self, action, parameter);
}

static void
_dconf_view_set_to_default_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	dconf_view_set_to_default ((DConfView*) self, action, parameter);
}

static void
_dconf_view_delay_erase_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	dconf_view_delay_erase ((DConfView*) self, action, parameter);
}

static void
_dconf_view_toggle_dconf_key_switch_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	dconf_view_toggle_dconf_key_switch ((DConfView*) self, action, parameter);
}

static void
_dconf_view_toggle_gsettings_key_switch_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	dconf_view_toggle_gsettings_key_switch ((DConfView*) self, action, parameter);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DConfView*
dconf_view_construct (GType object_type,
                      ModificationsHandler* modifications_handler)
{
	DConfView * self = NULL;
	BrowserStack* _dconf_content = NULL;
	BrowserStack* _tmp0_;
	BrowserStack* _tmp1_;
	g_return_val_if_fail (modifications_handler != NULL, NULL);
	_tmp0_ = browser_stack_new (modifications_handler);
	g_object_ref_sink (_tmp0_);
	_dconf_content = _tmp0_;
	gtk_widget_show ((GtkWidget*) _dconf_content);
	self = (DConfView*) g_object_new (object_type, "browser-content", G_TYPE_CHECK_INSTANCE_CAST (_dconf_content, TYPE_BROWSER_CONTENT, BrowserContent), "modifications-handler", modifications_handler, NULL);
	_tmp1_ = _g_object_ref0 (_dconf_content);
	_g_object_unref0 (self->priv->dconf_content);
	self->priv->dconf_content = _tmp1_;
	_g_object_unref0 (_dconf_content);
	return self;
}

DConfView*
dconf_view_new (ModificationsHandler* modifications_handler)
{
	return dconf_view_construct (TYPE_DCONF_VIEW, modifications_handler);
}

static void
dconf_view_real_set_window_size (AdaptativeWidget* base,
                                 AdaptativeWidgetWindowSize new_size)
{
	DConfView * self;
	self = (DConfView*) base;
	BASE_VIEW_CLASS (dconf_view_parent_class)->set_window_size ((BaseView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BOOKMARKS_VIEW, BookmarksView), new_size);
	if (self->priv->modifications_list_created) {
		ModificationsList* _tmp0_;
		_tmp0_ = self->priv->modifications_list;
		adaptative_widget_set_window_size ((AdaptativeWidget*) _tmp0_, new_size);
	}
}

static gboolean
dconf_view_real_is_in_in_window_mode (BaseView* base)
{
	DConfView * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean result;
	self = (DConfView*) base;
	_tmp1_ = self->priv->_in_window_modifications;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = BASE_VIEW_CLASS (dconf_view_parent_class)->is_in_in_window_mode ((BaseView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BOOKMARKS_VIEW, BookmarksView));
	}
	result = _tmp0_;
	return result;
}

static void
dconf_view_real_show_default_view (BaseView* base)
{
	DConfView * self;
	gboolean _tmp0_;
	self = (DConfView*) base;
	_tmp0_ = self->priv->_in_window_modifications;
	if (_tmp0_) {
		dconf_view_set_in_window_modifications (self, FALSE);
		gtk_stack_set_visible_child_name ((GtkStack*) self, "main-view");
	} else {
		BASE_VIEW_CLASS (dconf_view_parent_class)->show_default_view ((BaseView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BOOKMARKS_VIEW, BookmarksView));
	}
}

static void
dconf_view_install_action_entries (DConfView* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, DCONF_VIEW_action_entries, (gint) G_N_ELEMENTS (DCONF_VIEW_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "view", (GActionGroup*) action_group);
	_g_object_unref0 (action_group);
}

static void
dconf_view_set_key_value (DConfView* self,
                          GSimpleAction* action,
                          GVariant* value_variant)
{
	gchar* full_name = NULL;
	guint16 context_id = 0U;
	GVariant* key_value_request = NULL;
	gchar* _tmp0_ = NULL;
	guint16 _tmp1_ = 0U;
	GVariant* _tmp2_ = NULL;
	ModificationsHandler* _tmp3_;
	ModificationsHandler* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (value_variant != NULL, "value_variant != null");
	g_variant_get ((GVariant*) value_variant, "(sqv)", &_tmp0_, &_tmp1_, &_tmp2_, NULL);
	_g_free0 (full_name);
	full_name = _tmp0_;
	context_id = _tmp1_;
	_g_variant_unref0 (key_value_request);
	key_value_request = _tmp2_;
	_tmp3_ = dconf_view_get_modifications_handler (self);
	_tmp4_ = _tmp3_;
	if (modifications_handler_get_current_delay_mode (_tmp4_)) {
		ModificationsHandler* _tmp5_;
		ModificationsHandler* _tmp6_;
		const gchar* _tmp7_;
		GVariant* _tmp8_;
		_tmp5_ = dconf_view_get_modifications_handler (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = full_name;
		_tmp8_ = key_value_request;
		modifications_handler_add_delayed_setting (_tmp6_, _tmp7_, _tmp8_, context_id);
	} else {
		if (!model_utils_is_dconf_context_id (context_id)) {
			ModificationsHandler* _tmp9_;
			ModificationsHandler* _tmp10_;
			const gchar* _tmp11_;
			GVariant* _tmp12_;
			_tmp9_ = dconf_view_get_modifications_handler (self);
			_tmp10_ = _tmp9_;
			_tmp11_ = full_name;
			_tmp12_ = key_value_request;
			modifications_handler_set_gsettings_key_value (_tmp10_, _tmp11_, context_id, _tmp12_);
		} else {
			ModificationsHandler* _tmp13_;
			ModificationsHandler* _tmp14_;
			const gchar* _tmp15_;
			GVariant* _tmp16_;
			_tmp13_ = dconf_view_get_modifications_handler (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = full_name;
			_tmp16_ = key_value_request;
			modifications_handler_set_dconf_key_value (_tmp14_, _tmp15_, _tmp16_);
		}
	}
	_g_variant_unref0 (key_value_request);
	_g_free0 (full_name);
}

static void
dconf_view_delay_erase (DConfView* self,
                        GSimpleAction* action,
                        GVariant* path_variant)
{
	gchar* full_name_or_empty = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ModificationsHandler* _tmp3_;
	ModificationsHandler* _tmp4_;
	ModificationsHandler* _tmp5_;
	ModificationsHandler* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (path_variant != NULL, "path_variant != null");
	_tmp0_ = g_variant_get_string ((GVariant*) path_variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	full_name_or_empty = _tmp1_;
	_tmp2_ = full_name_or_empty;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		_g_free0 (full_name_or_empty);
		return;
	}
	_tmp3_ = dconf_view_get_modifications_handler (self);
	_tmp4_ = _tmp3_;
	modifications_handler_enter_delay_mode (_tmp4_);
	_tmp5_ = dconf_view_get_modifications_handler (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = full_name_or_empty;
	modifications_handler_add_delayed_setting (_tmp6_, _tmp7_, NULL, MODEL_UTILS_dconf_context_id);
	_g_free0 (full_name_or_empty);
}

static void
dconf_view_set_to_default (DConfView* self,
                           GSimpleAction* action,
                           GVariant* path_variant)
{
	gchar* full_name = NULL;
	guint16 context_id = 0U;
	gchar* _tmp0_ = NULL;
	guint16 _tmp1_ = 0U;
	ModificationsHandler* _tmp2_;
	ModificationsHandler* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (path_variant != NULL, "path_variant != null");
	g_variant_get ((GVariant*) path_variant, "(sq)", &_tmp0_, &_tmp1_, NULL);
	_g_free0 (full_name);
	full_name = _tmp0_;
	context_id = _tmp1_;
	_tmp2_ = dconf_view_get_modifications_handler (self);
	_tmp3_ = _tmp2_;
	modifications_handler_set_to_default (_tmp3_, full_name, context_id);
	browser_view_invalidate_popovers ((BrowserView*) self);
	_g_free0 (full_name);
}

static GVariant*
_variant_new9 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
dconf_view_toggle_dconf_key_switch (DConfView* self,
                                    GSimpleAction* action,
                                    GVariant* value_variant)
{
	ModificationsHandler* _tmp0_;
	ModificationsHandler* _tmp1_;
	gchar* full_name = NULL;
	gboolean key_value_request = FALSE;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	ModificationsHandler* _tmp4_;
	ModificationsHandler* _tmp5_;
	GVariant* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (value_variant != NULL, "value_variant != null");
	_tmp0_ = dconf_view_get_modifications_handler (self);
	_tmp1_ = _tmp0_;
	if (modifications_handler_get_current_delay_mode (_tmp1_)) {
		g_assert_not_reached ();
	}
	g_variant_get ((GVariant*) value_variant, "(sb)", &_tmp2_, &_tmp3_, NULL);
	_g_free0 (full_name);
	full_name = _tmp2_;
	key_value_request = _tmp3_;
	_tmp4_ = dconf_view_get_modifications_handler (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _variant_new9 (key_value_request);
	modifications_handler_set_dconf_key_value (_tmp5_, full_name, _tmp6_);
	_g_variant_unref0 (_tmp6_);
	_g_free0 (full_name);
}

static void
dconf_view_toggle_gsettings_key_switch (DConfView* self,
                                        GSimpleAction* action,
                                        GVariant* value_variant)
{
	ModificationsHandler* _tmp0_;
	ModificationsHandler* _tmp1_;
	gchar* full_name = NULL;
	guint16 context_id = 0U;
	gboolean key_value_request = FALSE;
	gboolean key_default_value = FALSE;
	gchar* _tmp2_ = NULL;
	guint16 _tmp3_ = 0U;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (value_variant != NULL, "value_variant != null");
	_tmp0_ = dconf_view_get_modifications_handler (self);
	_tmp1_ = _tmp0_;
	if (modifications_handler_get_current_delay_mode (_tmp1_)) {
		g_assert_not_reached ();
	}
	g_variant_get ((GVariant*) value_variant, "(sqbb)", &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, NULL);
	_g_free0 (full_name);
	full_name = _tmp2_;
	context_id = _tmp3_;
	key_value_request = _tmp4_;
	key_default_value = _tmp5_;
	if (key_value_request == key_default_value) {
		ModificationsHandler* _tmp6_;
		ModificationsHandler* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = dconf_view_get_modifications_handler (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = full_name;
		modifications_handler_set_to_default (_tmp7_, _tmp8_, context_id);
	} else {
		ModificationsHandler* _tmp9_;
		ModificationsHandler* _tmp10_;
		const gchar* _tmp11_;
		GVariant* _tmp12_;
		GVariant* _tmp13_;
		_tmp9_ = dconf_view_get_modifications_handler (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = full_name;
		_tmp12_ = g_variant_new_boolean (key_value_request);
		g_variant_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		modifications_handler_set_gsettings_key_value (_tmp10_, _tmp11_, context_id, _tmp13_);
		_g_variant_unref0 (_tmp13_);
	}
	_g_free0 (full_name);
}

static void
dconf_view_create_modifications_list (DConfView* self)
{
	ModificationsList* _tmp0_;
	ModificationsList* _tmp1_;
	AdaptativeWidgetWindowSize _tmp2_;
	AdaptativeWidgetWindowSize _tmp3_;
	ModificationsList* _tmp4_;
	ModificationsList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = modifications_list_new (FALSE, TRUE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->modifications_list);
	self->priv->modifications_list = _tmp0_;
	_tmp1_ = self->priv->modifications_list;
	_tmp2_ = base_view_get_saved_window_size ((BaseView*) self);
	_tmp3_ = _tmp2_;
	adaptative_widget_set_window_size ((AdaptativeWidget*) _tmp1_, _tmp3_);
	_tmp4_ = self->priv->modifications_list;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->modifications_list;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	self->priv->modifications_list_created = TRUE;
}

void
dconf_view_show_modifications_view (DConfView* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ModificationsList* _tmp5_;
	ModificationsList* _tmp6_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->modifications_list_created == TRUE, "modifications_list_created == true");
	_tmp1_ = bookmarks_view_get_in_window_bookmarks ((BookmarksView*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = base_view_get_in_window_about ((BaseView*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		base_view_show_default_view ((BaseView*) self);
	}
	_tmp5_ = self->priv->modifications_list;
	overlayed_list_reset ((OverlayedList*) _tmp5_);
	_tmp6_ = self->priv->modifications_list;
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp6_);
	dconf_view_set_in_window_modifications (self, TRUE);
}

static GtkWidget*
_dconf_view_delayed_setting_row_create_gtk_list_box_create_widget_func (GObject* item,
                                                                        gpointer self)
{
	GtkWidget* result;
	result = dconf_view_delayed_setting_row_create ((DConfView*) self, item);
	return result;
}

static void
dconf_view_update_in_window_modifications (DConfView* self)
{
	GListStore* modifications_liststore = NULL;
	ModificationsHandler* _tmp0_;
	ModificationsHandler* _tmp1_;
	GListStore* _tmp2_;
	ModificationsList* _tmp3_;
	GListStore* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	if (!self->priv->modifications_list_created) {
		dconf_view_create_modifications_list (self);
	}
	_tmp0_ = dconf_view_get_modifications_handler (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = modifications_handler_get_delayed_settings (_tmp1_);
	modifications_liststore = _tmp2_;
	_tmp3_ = self->priv->modifications_list;
	_tmp4_ = modifications_liststore;
	modifications_list_bind_model (_tmp3_, _tmp4_, _dconf_view_delayed_setting_row_create_gtk_list_box_create_widget_func, self);
	_tmp6_ = self->priv->_in_window_modifications;
	if (_tmp6_) {
		ModificationsHandler* _tmp7_;
		ModificationsHandler* _tmp8_;
		ModificationsMode _tmp9_;
		ModificationsMode _tmp10_;
		_tmp7_ = dconf_view_get_modifications_handler (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = modifications_handler_get_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp5_ = _tmp10_ == MODIFICATIONS_MODE_NONE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		base_view_show_default_view ((BaseView*) self);
	}
	_g_object_unref0 (modifications_liststore);
}

static GtkWidget*
dconf_view_delayed_setting_row_create (DConfView* self,
                                       GObject* object)
{
	SimpleSettingObject* sso = NULL;
	SimpleSettingObject* _tmp0_;
	ModificationsHandler* _tmp1_;
	ModificationsHandler* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	guint16 _tmp7_;
	guint16 _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object != NULL, NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject));
	sso = _tmp0_;
	_tmp1_ = dconf_view_get_modifications_handler (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = simple_setting_object_get_name (sso);
	_tmp4_ = _tmp3_;
	_tmp5_ = simple_setting_object_get_full_name (sso);
	_tmp6_ = _tmp5_;
	_tmp7_ = simple_setting_object_get_context_id (sso);
	_tmp8_ = _tmp7_;
	_tmp9_ = modifications_revealer_create_delayed_setting_row (_tmp2_, _tmp4_, _tmp6_, _tmp8_);
	result = _tmp9_;
	_g_object_unref0 (sso);
	return result;
}

static void
dconf_view_real_set_path (BrowserView* base,
                          ViewType type,
                          const gchar* path)
{
	DConfView * self;
	BrowserStack* _tmp0_;
	ModificationsHandler* _tmp1_;
	ModificationsHandler* _tmp2_;
	self = (DConfView*) base;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->dconf_content;
	browser_content_set_path ((BrowserContent*) _tmp0_, type, path);
	_tmp1_ = dconf_view_get_modifications_handler (self);
	_tmp2_ = _tmp1_;
	modifications_handler_path_changed (_tmp2_);
	browser_view_invalidate_popovers ((BrowserView*) self);
}

void
dconf_view_set_search_parameters (DConfView* self,
                                  gboolean local_search,
                                  const gchar* current_path,
                                  gchar** bookmarks,
                                  gint bookmarks_length1)
{
	BrowserStack* _tmp0_;
	guint16 _tmp1_;
	guint16 _tmp2_;
	SortingOptions* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current_path != NULL);
	browser_view_hide_reload_warning ((BrowserView*) self);
	_tmp0_ = self->priv->dconf_content;
	_tmp1_ = browser_view_get_last_context_id ((BrowserView*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = ((BrowserView*) self)->sorting_options;
	browser_stack_set_search_parameters (_tmp0_, local_search, current_path, _tmp2_, bookmarks, (gint) bookmarks_length1, _tmp3_);
}

gboolean
dconf_view_check_reload (DConfView* self,
                         ViewType type,
                         const gchar* path,
                         gboolean show_infobar)
{
	SettingsModel* model = NULL;
	ModificationsHandler* _tmp0_;
	ModificationsHandler* _tmp1_;
	SettingsModel* _tmp2_;
	SettingsModel* _tmp3_;
	SettingsModel* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = dconf_view_get_modifications_handler (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = modifications_handler_get_model (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	model = _tmp4_;
	if (type == VIEW_TYPE_FOLDER) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		if (type == VIEW_TYPE_CONFIG) {
			_tmp6_ = model_utils_is_folder_path (path);
		} else {
			_tmp6_ = FALSE;
		}
		_tmp5_ = _tmp6_;
	}
	if (_tmp5_) {
		BrowserStack* _tmp7_;
		SettingsModel* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		gboolean _tmp11_;
		_tmp7_ = self->priv->dconf_content;
		_tmp8_ = model;
		_tmp9_ = settings_model_get_children (_tmp8_, path, FALSE, FALSE);
		_tmp10_ = _tmp9_;
		_tmp11_ = !browser_content_check_reload_folder ((BrowserContent*) _tmp7_, _tmp10_);
		_g_variant_unref0 (_tmp10_);
		if (_tmp11_) {
			result = FALSE;
			_g_object_unref0 (model);
			return result;
		}
		if (show_infobar) {
			BrowserInfoBar* _tmp12_;
			_tmp12_ = ((BrowserView*) self)->info_bar;
			browser_info_bar_show_warning (_tmp12_, "hard-reload-folder");
			result = FALSE;
			_g_object_unref0 (model);
			return result;
		}
	} else {
		gboolean _tmp13_ = FALSE;
		if (type == VIEW_TYPE_OBJECT) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = type == VIEW_TYPE_CONFIG;
		}
		if (_tmp13_) {
			SettingsModel* _tmp14_;
			guint16 _tmp15_;
			guint16 _tmp16_;
			_tmp14_ = model;
			_tmp15_ = browser_view_get_last_context_id ((BrowserView*) self);
			_tmp16_ = _tmp15_;
			if (settings_model_key_exists (_tmp14_, path, _tmp16_)) {
				RegistryVariantDict* properties = NULL;
				SettingsModel* _tmp17_;
				guint16 _tmp18_;
				guint16 _tmp19_;
				GVariant* _tmp20_;
				GVariant* _tmp21_;
				RegistryVariantDict* _tmp22_;
				RegistryVariantDict* _tmp23_;
				guint properties_hash = 0U;
				RegistryVariantDict* _tmp24_;
				guint _tmp25_ = 0U;
				gboolean _tmp26_;
				BrowserStack* _tmp27_;
				_tmp17_ = model;
				_tmp18_ = browser_view_get_last_context_id ((BrowserView*) self);
				_tmp19_ = _tmp18_;
				_tmp20_ = settings_model_get_key_properties (_tmp17_, path, _tmp19_, (guint16) PROPERTY_QUERY_HASH);
				_tmp21_ = _tmp20_;
				_tmp22_ = registry_variant_dict_new_from_aqv (_tmp21_);
				_tmp23_ = _tmp22_;
				_g_variant_unref0 (_tmp21_);
				properties = _tmp23_;
				_tmp24_ = properties;
				_tmp26_ = registry_variant_dict_lookup (_tmp24_, (guint16) PROPERTY_QUERY_HASH, "u", &_tmp25_, NULL);
				properties_hash = _tmp25_;
				if (!_tmp26_) {
					g_assert_not_reached ();
				}
				_tmp27_ = self->priv->dconf_content;
				if (!browser_content_check_reload_object ((BrowserContent*) _tmp27_, properties_hash)) {
					result = FALSE;
					_g_object_unref0 (properties);
					_g_object_unref0 (model);
					return result;
				}
				_g_object_unref0 (properties);
			}
			if (show_infobar) {
				BrowserInfoBar* _tmp28_;
				_tmp28_ = ((BrowserView*) self)->info_bar;
				browser_info_bar_show_warning (_tmp28_, "hard-reload-object");
				result = FALSE;
				_g_object_unref0 (model);
				return result;
			}
		} else {
			if (type == VIEW_TYPE_SEARCH) {
				g_assert_not_reached ();
			} else {
				g_assert_not_reached ();
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (model);
	return result;
}

void
dconf_view_hide_or_show_toggles (DConfView* self,
                                 gboolean show)
{
	BrowserStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dconf_content;
	browser_stack_hide_or_show_toggles (_tmp0_, show);
}

static gboolean
dconf_view_real_next_match (BrowserView* base)
{
	DConfView * self;
	gboolean _tmp0_;
	gboolean result;
	self = (DConfView*) base;
	_tmp0_ = self->priv->_in_window_modifications;
	if (_tmp0_) {
		ModificationsList* _tmp1_;
		_tmp1_ = self->priv->modifications_list;
		result = overlayed_list_next_match ((OverlayedList*) _tmp1_);
		return result;
	}
	result = BROWSER_VIEW_CLASS (dconf_view_parent_class)->next_match ((BrowserView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BOOKMARKS_VIEW, BookmarksView));
	return result;
}

static gboolean
dconf_view_real_previous_match (BrowserView* base)
{
	DConfView * self;
	gboolean _tmp0_;
	gboolean result;
	self = (DConfView*) base;
	_tmp0_ = self->priv->_in_window_modifications;
	if (_tmp0_) {
		ModificationsList* _tmp1_;
		_tmp1_ = self->priv->modifications_list;
		result = overlayed_list_previous_match ((OverlayedList*) _tmp1_);
		return result;
	}
	result = BROWSER_VIEW_CLASS (dconf_view_parent_class)->previous_match ((BrowserView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BOOKMARKS_VIEW, BookmarksView));
	return result;
}

void
dconf_view_toggle_boolean_key (DConfView* self)
{
	BrowserStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dconf_content;
	browser_stack_toggle_boolean_key (_tmp0_);
}

void
dconf_view_set_selected_to_default (DConfView* self)
{
	BrowserStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dconf_content;
	browser_stack_set_selected_to_default (_tmp0_);
}

static gboolean
dconf_view_real_handle_copy_text (BaseView* base,
                                  gchar** copy_text)
{
	DConfView * self;
	gchar* _vala_copy_text = NULL;
	gboolean _tmp0_;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_;
	gboolean result;
	self = (DConfView*) base;
	_tmp0_ = self->priv->_in_window_modifications;
	if (_tmp0_) {
		ModificationsList* _tmp1_;
		gchar* _tmp2_ = NULL;
		gboolean _tmp3_;
		_tmp1_ = self->priv->modifications_list;
		_tmp3_ = overlayed_list_handle_copy_text ((OverlayedList*) _tmp1_, &_tmp2_);
		_g_free0 (_vala_copy_text);
		_vala_copy_text = _tmp2_;
		result = _tmp3_;
		if (copy_text) {
			*copy_text = _vala_copy_text;
		} else {
			_g_free0 (_vala_copy_text);
		}
		return result;
	}
	_tmp5_ = BASE_VIEW_CLASS (dconf_view_parent_class)->handle_copy_text ((BaseView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BOOKMARKS_VIEW, BookmarksView), &_tmp4_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp4_;
	result = _tmp5_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

void
dconf_view_gkey_value_push (DConfView* self,
                            const gchar* full_name,
                            guint16 context_id,
                            GVariant* key_value,
                            gboolean is_key_default)
{
	BrowserStack* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	g_return_if_fail (key_value != NULL);
	_tmp0_ = self->priv->dconf_content;
	browser_stack_gkey_value_push (_tmp0_, full_name, context_id, key_value, is_key_default);
}

void
dconf_view_dkey_value_push (DConfView* self,
                            const gchar* full_name,
                            GVariant* key_value_or_null)
{
	BrowserStack* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	_tmp0_ = self->priv->dconf_content;
	browser_stack_dkey_value_push (_tmp0_, full_name, key_value_or_null);
}

static ModificationsHandler*
dconf_view_get_modifications_handler (DConfView* self)
{
	ModificationsHandler* result;
	ModificationsHandler* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_modifications_handler;
	result = _tmp0_;
	return result;
}

static void
_browser_view_on_case_sensitive_changed_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	browser_view_on_case_sensitive_changed ((BrowserView*) self);
}

static void
_dconf_view_update_in_window_modifications_modifications_handler_delayed_changes_changed (ModificationsHandler* _sender,
                                                                                          gpointer self)
{
	dconf_view_update_in_window_modifications ((DConfView*) self);
}

static void
dconf_view_set_modifications_handler (DConfView* self,
                                      ModificationsHandler* value)
{
	ModificationsHandler* _tmp0_;
	SettingsModel* _tmp1_;
	SettingsModel* _tmp2_;
	SortingOptions* _tmp3_;
	SortingOptions* _tmp4_;
	ModificationsHandler* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_modifications_handler);
	self->priv->_modifications_handler = _tmp0_;
	_tmp1_ = modifications_handler_get_model (value);
	_tmp2_ = _tmp1_;
	_tmp3_ = sorting_options_new (_tmp2_);
	_g_object_unref0 (((BrowserView*) self)->sorting_options);
	((BrowserView*) self)->sorting_options = _tmp3_;
	_tmp4_ = ((BrowserView*) self)->sorting_options;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::case-sensitive", (GCallback) _browser_view_on_case_sensitive_changed_g_object_notify, (BrowserView*) self, 0);
	_tmp5_ = self->priv->_modifications_handler;
	g_signal_connect_object (_tmp5_, "delayed-changes-changed", (GCallback) _dconf_view_update_in_window_modifications_modifications_handler_delayed_changes_changed, self, 0);
}

gboolean
dconf_view_get_in_window_modifications (DConfView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_in_window_modifications;
	return result;
}

static void
dconf_view_set_in_window_modifications (DConfView* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_in_window_modifications = value;
}

static GObject *
dconf_view_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DConfView * self;
	parent_class = G_OBJECT_CLASS (dconf_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DCONF_VIEW, DConfView);
	dconf_view_install_action_entries (self);
	return obj;
}

static void
dconf_view_class_init (DConfViewClass * klass,
                       gpointer klass_data)
{
	dconf_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DConfView_private_offset);
	((BaseViewClass *) klass)->set_window_size = (void (*) (BaseView*, AdaptativeWidgetWindowSize)) dconf_view_real_set_window_size;
	((BaseViewClass *) klass)->is_in_in_window_mode = (gboolean (*) (BaseView*)) dconf_view_real_is_in_in_window_mode;
	((BaseViewClass *) klass)->show_default_view = (void (*) (BaseView*)) dconf_view_real_show_default_view;
	((BrowserViewClass *) klass)->set_path = (void (*) (BrowserView*, ViewType, const gchar*)) dconf_view_real_set_path;
	((BrowserViewClass *) klass)->next_match = (gboolean (*) (BrowserView*)) dconf_view_real_next_match;
	((BrowserViewClass *) klass)->previous_match = (gboolean (*) (BrowserView*)) dconf_view_real_previous_match;
	((BaseViewClass *) klass)->handle_copy_text = (gboolean (*) (BaseView*, gchar**)) dconf_view_real_handle_copy_text;
	G_OBJECT_CLASS (klass)->get_property = _vala_dconf_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dconf_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = dconf_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = dconf_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DCONF_VIEW_MODIFICATIONS_HANDLER_PROPERTY, dconf_view_properties[DCONF_VIEW_MODIFICATIONS_HANDLER_PROPERTY] = g_param_spec_object ("modifications-handler", "modifications-handler", "modifications-handler", TYPE_MODIFICATIONS_HANDLER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DCONF_VIEW_IN_WINDOW_MODIFICATIONS_PROPERTY, dconf_view_properties[DCONF_VIEW_IN_WINDOW_MODIFICATIONS_PROPERTY] = g_param_spec_boolean ("in-window-modifications", "in-window-modifications", "in-window-modifications", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
dconf_view_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                             gpointer iface_data)
{
	dconf_view_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) dconf_view_real_set_window_size;
}

static void
dconf_view_instance_init (DConfView * self,
                          gpointer klass)
{
	self->priv = dconf_view_get_instance_private (self);
	self->priv->_in_window_modifications = FALSE;
	self->priv->modifications_list_created = FALSE;
}

static void
dconf_view_finalize (GObject * obj)
{
	DConfView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DCONF_VIEW, DConfView);
	_g_object_unref0 (self->priv->dconf_content);
	_g_object_unref0 (self->priv->_modifications_handler);
	_g_object_unref0 (self->priv->modifications_list);
	G_OBJECT_CLASS (dconf_view_parent_class)->finalize (obj);
}

static GType
dconf_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DConfViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dconf_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DConfView), 0, (GInstanceInitFunc) dconf_view_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) dconf_view_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType dconf_view_type_id;
	dconf_view_type_id = g_type_register_static (TYPE_BOOKMARKS_VIEW, "DConfView", &g_define_type_info, 0);
	g_type_add_interface_static (dconf_view_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	DConfView_private_offset = g_type_add_instance_private (dconf_view_type_id, sizeof (DConfViewPrivate));
	return dconf_view_type_id;
}

GType
dconf_view_get_type (void)
{
	static volatile gsize dconf_view_type_id__once = 0;
	if (g_once_init_enter (&dconf_view_type_id__once)) {
		GType dconf_view_type_id;
		dconf_view_type_id = dconf_view_get_type_once ();
		g_once_init_leave (&dconf_view_type_id__once, dconf_view_type_id);
	}
	return dconf_view_type_id__once;
}

static void
_vala_dconf_view_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	DConfView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DCONF_VIEW, DConfView);
	switch (property_id) {
		case DCONF_VIEW_MODIFICATIONS_HANDLER_PROPERTY:
		g_value_set_object (value, dconf_view_get_modifications_handler (self));
		break;
		case DCONF_VIEW_IN_WINDOW_MODIFICATIONS_PROPERTY:
		g_value_set_boolean (value, dconf_view_get_in_window_modifications (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_dconf_view_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	DConfView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DCONF_VIEW, DConfView);
	switch (property_id) {
		case DCONF_VIEW_MODIFICATIONS_HANDLER_PROPERTY:
		dconf_view_set_modifications_handler (self, g_value_get_object (value));
		break;
		case DCONF_VIEW_IN_WINDOW_MODIFICATIONS_PROPERTY:
		dconf_view_set_in_window_modifications (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

