/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.BranchStatement;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class BreakStatement
extends BranchStatement {
    public boolean isSynthetic;

    public BreakStatement(char[] cArray, int n, int n2) {
        super(cArray, n, n2);
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowContext flowContext2;
        FlowContext flowContext3 = flowContext2 = this.label == null ? flowContext.getTargetContextForDefaultBreak() : flowContext.getTargetContextForBreakLabel(this.label);
        if (flowContext2 instanceof SwitchFlowContext && flowContext2.associatedNode instanceof SwitchExpression) {
            blockScope.problemReporter().switchExpressionBreakNotAllowed(this);
        }
        if (flowContext2 == null) {
            if (this.label == null) {
                blockScope.problemReporter().invalidBreak(this);
            } else {
                blockScope.problemReporter().undefinedLabel(this);
            }
            return flowInfo;
        }
        flowContext2.recordAbruptExit();
        flowContext2.expireNullCheckedFieldInfo();
        this.initStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
        this.targetLabel = flowContext2.breakLabel();
        FlowContext flowContext4 = flowContext;
        int n = 0;
        this.subroutines = new SubRoutineStatement[5];
        do {
            SubRoutineStatement subRoutineStatement;
            if ((subRoutineStatement = flowContext4.subroutine()) != null) {
                if (n == this.subroutines.length) {
                    this.subroutines = new SubRoutineStatement[n * 2];
                    System.arraycopy(this.subroutines, 0, this.subroutines, 0, n);
                }
                this.subroutines[n++] = subRoutineStatement;
                if (subRoutineStatement.isSubRoutineEscaping()) break;
            }
            flowContext4.recordReturnFrom(flowInfo.unconditionalInits());
            flowContext4.recordBreakTo(flowContext2);
            if (flowContext4 instanceof InsideSubRoutineFlowContext) {
                ASTNode aSTNode = flowContext4.associatedNode;
                if (!(aSTNode instanceof TryStatement)) continue;
                TryStatement tryStatement = (TryStatement)aSTNode;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
                continue;
            }
            if (flowContext4 != flowContext2) continue;
            flowContext2.recordBreakFrom(flowInfo);
            break;
        } while ((flowContext4 = flowContext4.getLocalParent()) != null);
        if (n != this.subroutines.length) {
            this.subroutines = new SubRoutineStatement[n];
            System.arraycopy(this.subroutines, 0, this.subroutines, 0, n);
        }
        return FlowInfo.DEAD_END;
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        BreakStatement.printIndent(n, stringBuffer).append("break");
        if (this.label != null) {
            stringBuffer.append(' ').append(this.label);
        }
        return stringBuffer.append(';');
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public boolean doesNotCompleteNormally() {
        return true;
    }

    @Override
    public boolean canCompleteNormally() {
        return false;
    }

    @Override
    protected boolean doNotReportUnreachable() {
        return this.isSynthetic;
    }
}

