/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class TypePattern
extends Pattern {
    public LocalDeclaration local;

    public TypePattern(LocalDeclaration localDeclaration) {
        this.local = localDeclaration;
    }

    @Override
    public void collectPatternVariablesToScope(LocalVariableBinding[] localVariableBindingArray, BlockScope blockScope) {
        if (this.resolvedType == null) {
            this.resolveType(blockScope);
        }
        if (this.local != null && this.local.binding != null) {
            if (this.patternVarsWhenTrue == null) {
                this.patternVarsWhenTrue = new LocalVariableBinding[1];
                this.patternVarsWhenTrue[0] = this.local.binding;
            } else {
                this.addPatternVariablesWhenTrue(new LocalVariableBinding[]{this.local.binding});
            }
        }
    }

    @Override
    public boolean checkUnsafeCast(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3, boolean bl) {
        if (!typeBinding.isReifiable()) {
            return CastExpression.checkUnsafeCast(this, scope, typeBinding, typeBinding2, typeBinding3, bl);
        }
        return super.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding3, bl);
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo.markAsDefinitelyAssigned(this.local.binding);
        if (!this.isTotalTypeNode) {
            flowInfo.markAsDefinitelyNonNull(this.local.binding);
        } else if (flowContext.associatedNode instanceof SwitchStatement) {
            SwitchStatement switchStatement = (SwitchStatement)flowContext.associatedNode;
            int n = switchStatement.containsNull ? 4 : switchStatement.expression.nullStatus(flowInfo, flowContext);
            flowInfo.markNullStatus(this.local.binding, n);
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if (this.local != null) {
            LocalVariableBinding localVariableBinding = this.local.binding;
            if (!this.isTotalTypeNode) {
                codeStream.checkcast(localVariableBinding.type);
            }
            this.local.generateCode(blockScope, codeStream);
            codeStream.store(localVariableBinding, false);
            localVariableBinding.recordInitializationStartPC(codeStream.position);
        }
    }

    @Override
    public LocalDeclaration getPatternVariableIntroduced() {
        return this.local;
    }

    @Override
    public void resolve(BlockScope blockScope) {
        this.resolveType(blockScope);
    }

    @Override
    public boolean isTotalForType(TypeBinding typeBinding) {
        if (typeBinding == null || this.resolvedType == null) {
            return false;
        }
        return typeBinding.erasure().isSubtypeOf(this.resolvedType.erasure(), false);
    }

    @Override
    public boolean dominates(Pattern pattern) {
        return this.isTotalForType(pattern.resolvedType);
    }

    @Override
    public TypeBinding resolveAtType(BlockScope blockScope, TypeBinding typeBinding) {
        if (this.resolvedType == null) {
            this.resolvedType = this.local.binding.type;
        }
        return this.resolvedType;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        if (this.resolvedType != null || this.local == null) {
            return this.resolvedType;
        }
        this.local.modifiers |= 0x10000000;
        this.local.resolve(blockScope, true);
        if (this.local.binding != null) {
            this.local.binding.modifiers |= 0x10000000;
            this.local.binding.useFlag = 1;
            this.resolvedType = this.local.binding.type;
        }
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.local != null) {
            this.local.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return this.local != null ? this.local.printAsExpression(n, stringBuffer) : stringBuffer;
    }
}

